/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIMMINGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIMMINGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIMMINGFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_DIMMING_FI message types

fi_tclMessageBase* midw_dimmingfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULTMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULTMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGMODEMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGMODEMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETEMULATIONMODEMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETEMULATIONMODEMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGSTATEMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGSTATEMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGSTATEMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGSTATEMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGBRIGHTNESSMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGBRIGHTNESSMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGBRIGHTNESSMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGBRIGHTNESSMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGPWMMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGPWMMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETDRIVERINITALIZEDMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETDRIVERINITALIZEDMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETSCREENCONTENTAVAILABLEMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETSCREENCONTENTAVAILABLEMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETDIMMINGMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETDIMMINGMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SWITCHBACKLIGHTMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SWITCHBACKLIGHTMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELEXTENDEDMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELEXTENDEDMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETVIDEOBRIGHTNESSLEVELMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETVIDEOBRIGHTNESSLEVELMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_SETBRIGHTNESSINPUTTYPEMETHODSTART:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_SETBRIGHTNESSINPUTTYPEMETHODRESULT:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DAY_SLIDERGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DAY_SLIDERSET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DAY_SLIDERUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DAY_SLIDERRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DAY_SLIDERSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_NIGHT_SLIDERGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_NIGHT_SLIDERSET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_NIGHT_SLIDERUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_NIGHT_SLIDERRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_NIGHT_SLIDERSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_MODEGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_MODESET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_MODEUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_MODERELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_MODERelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_MODESTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DIAG_EMULATION_MODEGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DIAG_EMULATION_MODESET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DIAG_EMULATION_MODEUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DIAG_EMULATION_MODERELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODERelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DIAG_EMULATION_MODESTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_STATEGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_STATEUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_STATERELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_STATERelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_STATESTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_FEEDBACK_LEDGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_FEEDBACK_LEDSET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_FEEDBACK_LEDUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_FEEDBACK_LEDRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_FEEDBACK_LEDSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_SDC_LEDGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_SDC_LEDSET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_SDC_LEDUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_SDC_LEDRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_SDC_LEDSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_PWMGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_PWMUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_PWMRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_PWMSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_INTERNAL_TROUBLEGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_INTERNAL_TROUBLESET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_INTERNAL_TROUBLEUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_INTERNAL_TROUBLERELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLERelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_INTERNAL_TROUBLESTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_LIGHT_SENSORGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_LIGHT_SENSORUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_LIGHT_SENSORRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_LIGHT_SENSORSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_DISP_NAVGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_DISP_NAVUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_DISP_NAVRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_DISP_NAVSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_BEZ_NAVGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_BEZ_NAVUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_BEZ_NAVRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_BEZ_NAVSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_USER_BRIGHTNESSGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_USER_BRIGHTNESSSET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_USER_BRIGHTNESSUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_USER_BRIGHTNESSRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_USER_BRIGHTNESSSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULT_STATUSUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULT_STATUSRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULT_STATUSGET:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet;

      case midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULT_STATUSSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATAUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATARELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATAGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATASTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODEUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_DimmingModeUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODERELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_DimmingModeRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODEGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_DimmingModeGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODESTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODEUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_EmulationModeUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODERELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_EmulationModeRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODEGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_EmulationModeGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODESTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_ITCUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_ITCUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_ITCRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_ITCRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_ITCGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_ITCGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_ITCSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_ITCStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_BrightnessUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_BrightnessRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_BrightnessGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_HalfclassUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_HalfclassRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_HalfclassGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLEUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLERELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLEGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLESTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BacklightUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BacklightRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BacklightGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFORELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SIZEUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SizeUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SIZERELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SizeRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SIZEGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SizeGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SIZESTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_SizeStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATUREUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATURERELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATUREGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATURESTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_VARIANTUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DIAG_VariantUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_VARIANTRELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DIAG_VariantRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_VARIANTGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DIAG_VariantGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_VARIANTSTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPEUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPERELUPREG:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPEGET:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeGet;

      case midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPESTATUS:
         return OSAL_NEW midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_dimmingfifi messages

// common functions

tU16 midw_dimmingfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_DIMMINGFI_C_U16_SERVICE_ID;
}

tU16 midw_dimmingfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_dimmingfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_dimmingfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_dimmingfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_dimmingfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_dimmingfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_dimmingfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsMode = coRef.DefaultSettingsMode;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsMode = coRef.DefaultSettingsMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart()
:DefaultSettingsGroup(0)
,DefaultSettingsMode(0)
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULTMETHODSTART;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefaultSettingsGroup);
   (tVoid) (oIn >> DefaultSettingsMode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefaultSettingsGroup);
   (tVoid) (oOut << DefaultSettingsMode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefaultSettingsGroup == roRef.DefaultSettingsGroup);
   bResult = bResult && (DefaultSettingsMode == roRef.DefaultSettingsMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsStatus = coRef.DefaultSettingsStatus;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsStatus = coRef.DefaultSettingsStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult()
:DefaultSettingsGroup(0)
,DefaultSettingsStatus(0)
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULTMETHODRESULT;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefaultSettingsGroup);
   (tVoid) (oIn >> DefaultSettingsStatus);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefaultSettingsGroup);
   (tVoid) (oOut << DefaultSettingsStatus);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefaultSettingsGroup == roRef.DefaultSettingsGroup);
   bResult = bResult && (DefaultSettingsStatus == roRef.DefaultSettingsStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DimmingMode = coRef.DimmingMode;
}
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DimmingMode = coRef.DimmingMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart()
:DimmingMode()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGMODEMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingMode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingMode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingMode == roRef.DimmingMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DimmingMode = coRef.DimmingMode;
}
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DimmingMode = coRef.DimmingMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult()
:DimmingMode()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGMODEMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingMode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingMode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingMode == roRef.DimmingMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   EmulationMode = coRef.EmulationMode;
}
midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   EmulationMode = coRef.EmulationMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart()
:EmulationMode()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETEMULATIONMODEMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::~midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EmulationMode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EmulationMode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EmulationMode == roRef.EmulationMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   EmulationMode = coRef.EmulationMode;
}
midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   EmulationMode = coRef.EmulationMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult()
:EmulationMode()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETEMULATIONMODEMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::~midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EmulationMode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EmulationMode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EmulationMode == roRef.EmulationMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   DimmingStatus = coRef.DimmingStatus;
}
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   DimmingStatus = coRef.DimmingStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart()
:LUN(0)
,DimmingStatus()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGSTATEMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> DimmingStatus);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << DimmingStatus);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (DimmingStatus == roRef.DimmingStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   DimmingStatus = coRef.DimmingStatus;
}
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   DimmingStatus = coRef.DimmingStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult()
:LUN(0)
,DimmingStatus()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGSTATEMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> DimmingStatus);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << DimmingStatus);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (DimmingStatus == roRef.DimmingStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
}
midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart()
:LUN(0)
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGSTATEMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::~midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   DimmingState = coRef.DimmingState;
}
midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   DimmingState = coRef.DimmingState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult()
:LUN(0)
,DimmingState()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGSTATEMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::~midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> DimmingState);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << DimmingState);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (DimmingState == roRef.DimmingState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
}
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart()
:LUN()
,Brightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGBRIGHTNESSMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
}
midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult()
:LUN()
,Brightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGBRIGHTNESSMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
}
midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart()
:LUN()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGBRIGHTNESSMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::~midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
}
midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult()
:LUN()
,Brightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGBRIGHTNESSMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::~midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart::midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart::midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart()
:Brightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart::~midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult::midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult::midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult()
:Brightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult::~midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart()
:Brightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGPWMMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::~midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult()
:Brightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGPWMMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::~midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   SetDriverInitialized = coRef.SetDriverInitialized;
}
midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SetDriverInitialized = coRef.SetDriverInitialized;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart()
:SetDriverInitialized()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETDRIVERINITALIZEDMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::~midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetDriverInitialized);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetDriverInitialized);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetDriverInitialized == roRef.SetDriverInitialized);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   SetDriverInitialized = coRef.SetDriverInitialized;
}
midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SetDriverInitialized = coRef.SetDriverInitialized;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult()
:SetDriverInitialized()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETDRIVERINITALIZEDMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::~midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetDriverInitialized);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetDriverInitialized);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetDriverInitialized == roRef.SetDriverInitialized);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   SetScreenContentAvailable = coRef.SetScreenContentAvailable;
}
midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SetScreenContentAvailable = coRef.SetScreenContentAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart()
:SetScreenContentAvailable()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETSCREENCONTENTAVAILABLEMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::~midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetScreenContentAvailable);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetScreenContentAvailable);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetScreenContentAvailable == roRef.SetScreenContentAvailable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   SetScreenContentAvailable = coRef.SetScreenContentAvailable;
}
midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SetScreenContentAvailable = coRef.SetScreenContentAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult()
:SetScreenContentAvailable()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETSCREENCONTENTAVAILABLEMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::~midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetScreenContentAvailable);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetScreenContentAvailable);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetScreenContentAvailable == roRef.SetScreenContentAvailable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart& midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart()
:Brightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETDIMMINGMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart::~midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult& midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult()
:Brightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETDIMMINGMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult::~midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   SwitchBacklight = coRef.SwitchBacklight;
}
midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SwitchBacklight = coRef.SwitchBacklight;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart()
:SwitchBacklight()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SWITCHBACKLIGHTMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::~midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SwitchBacklight);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SwitchBacklight);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SwitchBacklight == roRef.SwitchBacklight);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   SwitchBacklight = coRef.SwitchBacklight;
}
midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SwitchBacklight = coRef.SwitchBacklight;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult()
:SwitchBacklight()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SWITCHBACKLIGHTMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::~midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SwitchBacklight);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SwitchBacklight);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SwitchBacklight == roRef.SwitchBacklight);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevel = coRef.BrightnessLevel;
}
midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevel = coRef.BrightnessLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart()
:BrightnessLevel()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::~midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevel);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevel);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevel == roRef.BrightnessLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevel = coRef.BrightnessLevel;
}
midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevel = coRef.BrightnessLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult()
:BrightnessLevel()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::~midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevel);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevel);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevel == roRef.BrightnessLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
}
midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart()
:BrightnessLevelExtended(0)
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELEXTENDEDMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::~midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevelExtended);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevelExtended);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevelExtended == roRef.BrightnessLevelExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
}
midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult()
:BrightnessLevelExtended(0)
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELEXTENDEDMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::~midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevelExtended);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevelExtended);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevelExtended == roRef.BrightnessLevelExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   VideoBrightnessLevelDay = coRef.VideoBrightnessLevelDay;
   VideoBrightnessLevelNight = coRef.VideoBrightnessLevelNight;
}
midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VideoBrightnessLevelDay = coRef.VideoBrightnessLevelDay;
   VideoBrightnessLevelNight = coRef.VideoBrightnessLevelNight;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart()
:VideoBrightnessLevelDay(0)
,VideoBrightnessLevelNight(0)
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETVIDEOBRIGHTNESSLEVELMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::~midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VideoBrightnessLevelDay);
   (tVoid) (oIn >> VideoBrightnessLevelNight);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VideoBrightnessLevelDay);
   (tVoid) (oOut << VideoBrightnessLevelNight);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VideoBrightnessLevelDay == roRef.VideoBrightnessLevelDay);
   bResult = bResult && (VideoBrightnessLevelNight == roRef.VideoBrightnessLevelNight);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   VideoBrightnessLevelDay = coRef.VideoBrightnessLevelDay;
   VideoBrightnessLevelNight = coRef.VideoBrightnessLevelNight;
}
midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   VideoBrightnessLevelDay = coRef.VideoBrightnessLevelDay;
   VideoBrightnessLevelNight = coRef.VideoBrightnessLevelNight;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult()
:VideoBrightnessLevelDay(0)
,VideoBrightnessLevelNight(0)
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SETVIDEOBRIGHTNESSLEVELMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::~midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VideoBrightnessLevelDay);
   (tVoid) (oIn >> VideoBrightnessLevelNight);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VideoBrightnessLevelDay);
   (tVoid) (oOut << VideoBrightnessLevelNight);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VideoBrightnessLevelDay == roRef.VideoBrightnessLevelDay);
   bResult = bResult && (VideoBrightnessLevelNight == roRef.VideoBrightnessLevelNight);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   SetBrightnessInputType = coRef.SetBrightnessInputType;
}
midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::operator=(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SetBrightnessInputType = coRef.SetBrightnessInputType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart()
:SetBrightnessInputType()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_SETBRIGHTNESSINPUTTYPEMETHODSTART;
}


midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::~midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart()
{}

tU32 midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetBrightnessInputType);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetBrightnessInputType);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::operator==(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetBrightnessInputType == roRef.SetBrightnessInputType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   SetBrightnessInputType = coRef.SetBrightnessInputType;
}
midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::operator=(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SetBrightnessInputType = coRef.SetBrightnessInputType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult()
:SetBrightnessInputType()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_SETBRIGHTNESSINPUTTYPEMETHODRESULT;
}


midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::~midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult()
{}

tU32 midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetBrightnessInputType);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetBrightnessInputType);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::operator==(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetBrightnessInputType == roRef.SetBrightnessInputType);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DAY_SLIDERGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet::midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DayIllumination = coRef.DayIllumination;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet& midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet& coRef)
{
   if (this == &coRef) return *this;
   DayIllumination = coRef.DayIllumination;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet::midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet()
:DayIllumination()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DAY_SLIDERSET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DayIllumination);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DayIllumination);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DayIllumination == roRef.DayIllumination);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DAY_SLIDERUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERRelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DAY_SLIDERRELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERRelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DayIllumination = coRef.DayIllumination;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus& coRef)
{
   if (this == &coRef) return *this;
   DayIllumination = coRef.DayIllumination;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus()
:DayIllumination()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DAY_SLIDERSTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DayIllumination);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DayIllumination);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DayIllumination == roRef.DayIllumination);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_NIGHT_SLIDERGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet::midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   NightIllumination = coRef.NightIllumination;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet& midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet& coRef)
{
   if (this == &coRef) return *this;
   NightIllumination = coRef.NightIllumination;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet::midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet()
:NightIllumination()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_NIGHT_SLIDERSET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NightIllumination);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NightIllumination);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NightIllumination == roRef.NightIllumination);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_NIGHT_SLIDERUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERRelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_NIGHT_SLIDERRELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERRelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   NightIllumination = coRef.NightIllumination;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus& coRef)
{
   if (this == &coRef) return *this;
   NightIllumination = coRef.NightIllumination;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus()
:NightIllumination()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_NIGHT_SLIDERSTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NightIllumination);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NightIllumination);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NightIllumination == roRef.NightIllumination);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_MODEGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet::midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DimmingMode = coRef.DimmingMode;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet& midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet& coRef)
{
   if (this == &coRef) return *this;
   DimmingMode = coRef.DimmingMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet::midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet()
:DimmingMode()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_MODESET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingMode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingMode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingMode == roRef.DimmingMode);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_MODEUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_MODERelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_MODERelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_MODERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_MODERELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_MODERelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_MODERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DimmingMode = coRef.DimmingMode;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus& coRef)
{
   if (this == &coRef) return *this;
   DimmingMode = coRef.DimmingMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus()
:DimmingMode()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_MODESTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingMode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingMode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingMode == roRef.DimmingMode);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DIAG_EMULATION_MODEGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet::midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DimmingMode = coRef.DimmingMode;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet& midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet& coRef)
{
   if (this == &coRef) return *this;
   DimmingMode = coRef.DimmingMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet::midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet()
:DimmingMode()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DIAG_EMULATION_MODESET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingMode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingMode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingMode == roRef.DimmingMode);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DIAG_EMULATION_MODEUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODERelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODERelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DIAG_EMULATION_MODERELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODERelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DimmingMode = coRef.DimmingMode;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus& coRef)
{
   if (this == &coRef) return *this;
   DimmingMode = coRef.DimmingMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus()
:DimmingMode()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DIAG_EMULATION_MODESTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingMode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingMode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingMode == roRef.DimmingMode);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_STATEGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEGet()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_STATEUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_STATERelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_STATERelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_STATERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_STATERELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_STATERelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_STATERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DimmingState = coRef.DimmingState;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus& coRef)
{
   if (this == &coRef) return *this;
   DimmingState = coRef.DimmingState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus()
:DimmingState()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_STATESTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingState);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingState);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingState == roRef.DimmingState);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_FEEDBACK_LEDGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet::midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DimmingFeedback = coRef.DimmingFeedback;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet& midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet& coRef)
{
   if (this == &coRef) return *this;
   DimmingFeedback = coRef.DimmingFeedback;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet::midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet()
:DimmingFeedback()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_FEEDBACK_LEDSET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingFeedback);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingFeedback);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingFeedback == roRef.DimmingFeedback);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_FEEDBACK_LEDUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDRelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_FEEDBACK_LEDRELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDRelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DimmingFeedback = coRef.DimmingFeedback;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus& coRef)
{
   if (this == &coRef) return *this;
   DimmingFeedback = coRef.DimmingFeedback;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus()
:DimmingFeedback()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_FEEDBACK_LEDSTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingFeedback);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingFeedback);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingFeedback == roRef.DimmingFeedback);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_SDC_LEDGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet::midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   SDC_LED_State = coRef.SDC_LED_State;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet& midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet& coRef)
{
   if (this == &coRef) return *this;
   SDC_LED_State = coRef.SDC_LED_State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet::midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet()
:SDC_LED_State()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_SDC_LEDSET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SDC_LED_State);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SDC_LED_State);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SDC_LED_State == roRef.SDC_LED_State);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_SDC_LEDUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDRelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_SDC_LEDRELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDRelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   SDC_LED_State = coRef.SDC_LED_State;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus& coRef)
{
   if (this == &coRef) return *this;
   SDC_LED_State = coRef.SDC_LED_State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus()
:SDC_LED_State()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_SDC_LEDSTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SDC_LED_State);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SDC_LED_State);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SDC_LED_State == roRef.SDC_LED_State);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_PWMGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMGet()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_PWMUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMRelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_PWMRELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMRelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DimmingPWM = coRef.DimmingPWM;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus& coRef)
{
   if (this == &coRef) return *this;
   DimmingPWM = coRef.DimmingPWM;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus()
:DimmingPWM()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_PWMSTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingPWM);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingPWM);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingPWM == roRef.DimmingPWM);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_INTERNAL_TROUBLEGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet::midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   TroubleCode = coRef.TroubleCode;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet& midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet::midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet()
:TroubleCode(0)
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_INTERNAL_TROUBLESET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_INTERNAL_TROUBLEUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLERelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLERelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_INTERNAL_TROUBLERELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLERelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   TroubleCode = coRef.TroubleCode;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus()
:TroubleCode(0)
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_INTERNAL_TROUBLESTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_LIGHT_SENSORGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORGet()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_LIGHT_SENSORUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORRelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_LIGHT_SENSORRELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORRelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   LightSensor = coRef.LightSensor;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus& coRef)
{
   if (this == &coRef) return *this;
   LightSensor = coRef.LightSensor;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus()
:LightSensor(0)
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_LIGHT_SENSORSTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LightSensor);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LightSensor);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LightSensor == roRef.LightSensor);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_DISP_NAVGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVGet()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_DISP_NAVUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVRelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_DISP_NAVRELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVRelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   III_Disp_NAV = coRef.III_Disp_NAV;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus& coRef)
{
   if (this == &coRef) return *this;
   III_Disp_NAV = coRef.III_Disp_NAV;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus()
:III_Disp_NAV(0)
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_DISP_NAVSTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> III_Disp_NAV);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << III_Disp_NAV);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (III_Disp_NAV == roRef.III_Disp_NAV);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_BEZ_NAVGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVGet()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_BEZ_NAVUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVRelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_BEZ_NAVRELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVRelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   III_BEZ_NAV = coRef.III_BEZ_NAV;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus& coRef)
{
   if (this == &coRef) return *this;
   III_BEZ_NAV = coRef.III_BEZ_NAV;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus()
:III_BEZ_NAV(0)
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_III_BEZ_NAVSTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> III_BEZ_NAV);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << III_BEZ_NAV);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (III_BEZ_NAV == roRef.III_BEZ_NAV);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSGet()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_USER_BRIGHTNESSGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet::midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   UserBrightness = coRef.UserBrightness;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet& midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet& coRef)
{
   if (this == &coRef) return *this;
   UserBrightness = coRef.UserBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet::midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet()
:UserBrightness()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_USER_BRIGHTNESSSET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UserBrightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UserBrightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UserBrightness == roRef.UserBrightness);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_USER_BRIGHTNESSUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSRelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_USER_BRIGHTNESSRELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSRelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   UserBrightness = coRef.UserBrightness;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus& coRef)
{
   if (this == &coRef) return *this;
   UserBrightness = coRef.UserBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus()
:UserBrightness()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_USER_BRIGHTNESSSTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UserBrightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UserBrightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UserBrightness == roRef.UserBrightness);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULT_STATUSUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSRelUpReg::midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULT_STATUSRELUPREG;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSRelUpReg::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccesful = coRef.DefSetStateSuccesful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccesful = coRef.DefSetStateSuccesful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet::midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet()
:DefSetStateGroup(0)
,DefSetStateMode(0)
,DefSetStateSuccesful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULT_STATUSGET;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccesful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccesful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccesful == roRef.DefSetStateSuccesful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccesful = coRef.DefSetStateSuccesful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus::operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccesful = coRef.DefSetStateSuccesful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus::midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus()
:DefSetStateGroup(0)
,DefSetStateMode(0)
,DefSetStateSuccesful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULT_STATUSSTATUS;
}


midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus::~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus()
{}

tU32 midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccesful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccesful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus::operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccesful == roRef.DefSetStateSuccesful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataUpReg::midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATAUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataUpReg::~midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg::midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATARELUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg::~midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataGet::midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATAGET;
}


midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataGet::~midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus::midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus(const midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   IlluminationSwitch = coRef.IlluminationSwitch;
   IlluminationBrightness = coRef.IlluminationBrightness;
}
midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus& midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus::operator=(const midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus& coRef)
{
   if (this == &coRef) return *this;
   IlluminationSwitch = coRef.IlluminationSwitch;
   IlluminationBrightness = coRef.IlluminationBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus::midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus()
:IlluminationSwitch()
,IlluminationBrightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATASTATUS;
}


midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus::~midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IlluminationSwitch);
   (tVoid) (oIn >> IlluminationBrightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IlluminationSwitch);
   (tVoid) (oOut << IlluminationBrightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus::operator==(const midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IlluminationSwitch == roRef.IlluminationSwitch);
   bResult = bResult && (IlluminationBrightness == roRef.IlluminationBrightness);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg::midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg::~midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg::midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSRELUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg::~midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessGet::midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSGET;
}


midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessGet::~midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus(const midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   SensorAvail = coRef.SensorAvail;
   SensorBrightness = coRef.SensorBrightness;
}
midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::operator=(const midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& coRef)
{
   if (this == &coRef) return *this;
   SensorAvail = coRef.SensorAvail;
   SensorBrightness = coRef.SensorBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus()
:SensorAvail()
,SensorBrightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSSTATUS;
}


midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::~midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SensorAvail);
   (tVoid) (oIn >> SensorBrightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SensorAvail);
   (tVoid) (oOut << SensorBrightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::operator==(const midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SensorAvail == roRef.SensorAvail);
   bResult = bResult && (SensorBrightness == roRef.SensorBrightness);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_DimmingModeUpReg::midw_dimmingfi_tclMsgDIM_INFO_DimmingModeUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_DimmingModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODEUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_DimmingModeUpReg::~midw_dimmingfi_tclMsgDIM_INFO_DimmingModeUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_DimmingModeRelUpReg::midw_dimmingfi_tclMsgDIM_INFO_DimmingModeRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_DimmingModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODERELUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_DimmingModeRelUpReg::~midw_dimmingfi_tclMsgDIM_INFO_DimmingModeRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_DimmingModeGet::midw_dimmingfi_tclMsgDIM_INFO_DimmingModeGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_DimmingModeGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODEGET;
}


midw_dimmingfi_tclMsgDIM_INFO_DimmingModeGet::~midw_dimmingfi_tclMsgDIM_INFO_DimmingModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus::midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus(const midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Config = coRef.Config;
   Car = coRef.Car;
   Status = coRef.Status;
}
midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus& midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus::operator=(const midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus& coRef)
{
   if (this == &coRef) return *this;
   Config = coRef.Config;
   Car = coRef.Car;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus::midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus()
:Config()
,Car()
,Status()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODESTATUS;
}


midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus::~midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Config);
   (tVoid) (oIn >> Car);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Config);
   (tVoid) (oOut << Car);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus::operator==(const midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Config == roRef.Config);
   bResult = bResult && (Car == roRef.Car);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_EmulationModeUpReg::midw_dimmingfi_tclMsgDIM_INFO_EmulationModeUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_EmulationModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODEUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_EmulationModeUpReg::~midw_dimmingfi_tclMsgDIM_INFO_EmulationModeUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_EmulationModeRelUpReg::midw_dimmingfi_tclMsgDIM_INFO_EmulationModeRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_EmulationModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODERELUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_EmulationModeRelUpReg::~midw_dimmingfi_tclMsgDIM_INFO_EmulationModeRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_EmulationModeGet::midw_dimmingfi_tclMsgDIM_INFO_EmulationModeGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_EmulationModeGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODEGET;
}


midw_dimmingfi_tclMsgDIM_INFO_EmulationModeGet::~midw_dimmingfi_tclMsgDIM_INFO_EmulationModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus::midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus(const midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   EmulationMode = coRef.EmulationMode;
}
midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus& midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus::operator=(const midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus& coRef)
{
   if (this == &coRef) return *this;
   EmulationMode = coRef.EmulationMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus::midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus()
:EmulationMode()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODESTATUS;
}


midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus::~midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EmulationMode);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EmulationMode);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus::operator==(const midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EmulationMode == roRef.EmulationMode);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_ITCUpReg::midw_dimmingfi_tclMsgDIM_INFO_ITCUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_ITCUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_ITCUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_ITCUpReg::~midw_dimmingfi_tclMsgDIM_INFO_ITCUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_ITCRelUpReg::midw_dimmingfi_tclMsgDIM_INFO_ITCRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_ITCRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_ITCRELUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_ITCRelUpReg::~midw_dimmingfi_tclMsgDIM_INFO_ITCRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_ITCGet::midw_dimmingfi_tclMsgDIM_INFO_ITCGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_ITCGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_ITCGET;
}


midw_dimmingfi_tclMsgDIM_INFO_ITCGet::~midw_dimmingfi_tclMsgDIM_INFO_ITCGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_ITCStatus::midw_dimmingfi_tclMsgDIM_INFO_ITCStatus(const midw_dimmingfi_tclMsgDIM_INFO_ITCStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   ITC = coRef.ITC;
}
midw_dimmingfi_tclMsgDIM_INFO_ITCStatus& midw_dimmingfi_tclMsgDIM_INFO_ITCStatus::operator=(const midw_dimmingfi_tclMsgDIM_INFO_ITCStatus& coRef)
{
   if (this == &coRef) return *this;
   ITC = coRef.ITC;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_ITCStatus::midw_dimmingfi_tclMsgDIM_INFO_ITCStatus()
:ITC(0)
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_ITCStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_ITCSTATUS;
}


midw_dimmingfi_tclMsgDIM_INFO_ITCStatus::~midw_dimmingfi_tclMsgDIM_INFO_ITCStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_ITCStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_ITCStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ITC);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_ITCStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ITC);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_ITCStatus::operator==(const midw_dimmingfi_tclMsgDIM_INFO_ITCStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ITC == roRef.ITC);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessUpReg::midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessUpReg::~midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg::midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSRELUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg::~midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessGet::midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSGET;
}


midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessGet::~midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus::midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus(const midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   PWMBrightness = coRef.PWMBrightness;
}
midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus& midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus::operator=(const midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus& coRef)
{
   if (this == &coRef) return *this;
   PWMBrightness = coRef.PWMBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus::midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus()
:PWMBrightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSSTATUS;
}


midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus::~midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PWMBrightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PWMBrightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus::operator==(const midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PWMBrightness == roRef.PWMBrightness);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessUpReg::midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessUpReg::~midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessRelUpReg::midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSRELUPREG;
}


midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessRelUpReg::~midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessGet::midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSGET;
}


midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessGet::~midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus::midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus(const midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   CANBrightness = coRef.CANBrightness;
}
midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus& midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus::operator=(const midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus& coRef)
{
   if (this == &coRef) return *this;
   CANBrightness = coRef.CANBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus::midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus()
:CANBrightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSSTATUS;
}


midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus::~midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CANBrightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CANBrightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus::operator==(const midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CANBrightness == roRef.CANBrightness);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_KEYB_BrightnessUpReg::midw_dimmingfi_tclMsgDIM_KEYB_BrightnessUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_BrightnessUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSUPREG;
}


midw_dimmingfi_tclMsgDIM_KEYB_BrightnessUpReg::~midw_dimmingfi_tclMsgDIM_KEYB_BrightnessUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_KEYB_BrightnessRelUpReg::midw_dimmingfi_tclMsgDIM_KEYB_BrightnessRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_BrightnessRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSRELUPREG;
}


midw_dimmingfi_tclMsgDIM_KEYB_BrightnessRelUpReg::~midw_dimmingfi_tclMsgDIM_KEYB_BrightnessRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_KEYB_BrightnessGet::midw_dimmingfi_tclMsgDIM_KEYB_BrightnessGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_BrightnessGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSGET;
}


midw_dimmingfi_tclMsgDIM_KEYB_BrightnessGet::~midw_dimmingfi_tclMsgDIM_KEYB_BrightnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus::midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus(const midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus& midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus::operator=(const midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus::midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus()
:Brightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSSTATUS;
}


midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus::~midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus::operator==(const midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_KEYB_HalfclassUpReg::midw_dimmingfi_tclMsgDIM_KEYB_HalfclassUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_HalfclassUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSUPREG;
}


midw_dimmingfi_tclMsgDIM_KEYB_HalfclassUpReg::~midw_dimmingfi_tclMsgDIM_KEYB_HalfclassUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_KEYB_HalfclassRelUpReg::midw_dimmingfi_tclMsgDIM_KEYB_HalfclassRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_HalfclassRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSRELUPREG;
}


midw_dimmingfi_tclMsgDIM_KEYB_HalfclassRelUpReg::~midw_dimmingfi_tclMsgDIM_KEYB_HalfclassRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_KEYB_HalfclassGet::midw_dimmingfi_tclMsgDIM_KEYB_HalfclassGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_HalfclassGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSGET;
}


midw_dimmingfi_tclMsgDIM_KEYB_HalfclassGet::~midw_dimmingfi_tclMsgDIM_KEYB_HalfclassGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus::midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus(const midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Halfclass_A = coRef.Halfclass_A;
   Halfclass_B = coRef.Halfclass_B;
   ADC_CFG_A = coRef.ADC_CFG_A;
   ADC_CFG_B = coRef.ADC_CFG_B;
   ADC_A = coRef.ADC_A;
   ADC_B = coRef.ADC_B;
   PWM_HC_A = coRef.PWM_HC_A;
   PWM_HC_B = coRef.PWM_HC_B;
}
midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus& midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus::operator=(const midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus& coRef)
{
   if (this == &coRef) return *this;
   Halfclass_A = coRef.Halfclass_A;
   Halfclass_B = coRef.Halfclass_B;
   ADC_CFG_A = coRef.ADC_CFG_A;
   ADC_CFG_B = coRef.ADC_CFG_B;
   ADC_A = coRef.ADC_A;
   ADC_B = coRef.ADC_B;
   PWM_HC_A = coRef.PWM_HC_A;
   PWM_HC_B = coRef.PWM_HC_B;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus::midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus()
:Halfclass_A()
,Halfclass_B()
,ADC_CFG_A(0)
,ADC_CFG_B(0)
,ADC_A(0)
,ADC_B(0)
,PWM_HC_A(0)
,PWM_HC_B(0)
 {}

tS32 midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSSTATUS;
}


midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus::~midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Halfclass_A);
   (tVoid) (oIn >> Halfclass_B);
   (tVoid) (oIn >> ADC_CFG_A);
   (tVoid) (oIn >> ADC_CFG_B);
   (tVoid) (oIn >> ADC_A);
   (tVoid) (oIn >> ADC_B);
   (tVoid) (oIn >> PWM_HC_A);
   (tVoid) (oIn >> PWM_HC_B);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Halfclass_A);
   (tVoid) (oOut << Halfclass_B);
   (tVoid) (oOut << ADC_CFG_A);
   (tVoid) (oOut << ADC_CFG_B);
   (tVoid) (oOut << ADC_A);
   (tVoid) (oOut << ADC_B);
   (tVoid) (oOut << PWM_HC_A);
   (tVoid) (oOut << PWM_HC_B);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus::operator==(const midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Halfclass_A == roRef.Halfclass_A);
   bResult = bResult && (Halfclass_B == roRef.Halfclass_B);
   bResult = bResult && (ADC_CFG_A == roRef.ADC_CFG_A);
   bResult = bResult && (ADC_CFG_B == roRef.ADC_CFG_B);
   bResult = bResult && (ADC_A == roRef.ADC_A);
   bResult = bResult && (ADC_B == roRef.ADC_B);
   bResult = bResult && (PWM_HC_A == roRef.PWM_HC_A);
   bResult = bResult && (PWM_HC_B == roRef.PWM_HC_B);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedUpReg::midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedUpReg::~midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg::midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDRELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedGet::midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDGET;
}


midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedGet::~midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus::midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus(const midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   DriverInitialized = coRef.DriverInitialized;
}
midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus& midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus::operator=(const midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus& coRef)
{
   if (this == &coRef) return *this;
   DriverInitialized = coRef.DriverInitialized;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus::midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus()
:DriverInitialized()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDSTATUS;
}


midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus::~midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriverInitialized);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriverInitialized);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus::operator==(const midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriverInitialized == roRef.DriverInitialized);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg::midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLEUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg::~midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg::midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLERELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableGet::midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLEGET;
}


midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableGet::~midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus(const midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   ContentAvailable = coRef.ContentAvailable;
}
midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::operator=(const midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   ContentAvailable = coRef.ContentAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus()
:ContentAvailable()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLESTATUS;
}


midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::~midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContentAvailable);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContentAvailable);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::operator==(const midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContentAvailable == roRef.ContentAvailable);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BrightnessUpReg::midw_dimmingfi_tclMsgDIM_DISP_BrightnessUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessUpReg::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BrightnessRelUpReg::midw_dimmingfi_tclMsgDIM_DISP_BrightnessRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSRELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessRelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BrightnessGet::midw_dimmingfi_tclMsgDIM_DISP_BrightnessGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSGET;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessGet::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus::midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus& midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus::operator=(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus::midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus()
:Brightness()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSSTATUS;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus::operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BacklightUpReg::midw_dimmingfi_tclMsgDIM_DISP_BacklightUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BacklightUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_BacklightUpReg::~midw_dimmingfi_tclMsgDIM_DISP_BacklightUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BacklightRelUpReg::midw_dimmingfi_tclMsgDIM_DISP_BacklightRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BacklightRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTRELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_BacklightRelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_BacklightRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BacklightGet::midw_dimmingfi_tclMsgDIM_DISP_BacklightGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BacklightGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTGET;
}


midw_dimmingfi_tclMsgDIM_DISP_BacklightGet::~midw_dimmingfi_tclMsgDIM_DISP_BacklightGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus::midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus(const midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   BacklightStatus = coRef.BacklightStatus;
}
midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus& midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus::operator=(const midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus& coRef)
{
   if (this == &coRef) return *this;
   BacklightStatus = coRef.BacklightStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus::midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus()
:BacklightStatus()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTSTATUS;
}


midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus::~midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BacklightStatus);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BacklightStatus);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus::operator==(const midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BacklightStatus == roRef.BacklightStatus);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoUpReg::midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoUpReg::~midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg::midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFORELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoGet::midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOGET;
}


midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoGet::~midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus::midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus(const midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   PanelTemp = coRef.PanelTemp;
   AmbientTemp = coRef.AmbientTemp;
   WarningLevel = coRef.WarningLevel;
   CriticalLevelTimeout = coRef.CriticalLevelTimeout;
   CriticalLevelElapsed = coRef.CriticalLevelElapsed;
}
midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus& midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus::operator=(const midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   PanelTemp = coRef.PanelTemp;
   AmbientTemp = coRef.AmbientTemp;
   WarningLevel = coRef.WarningLevel;
   CriticalLevelTimeout = coRef.CriticalLevelTimeout;
   CriticalLevelElapsed = coRef.CriticalLevelElapsed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus::midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus()
:PanelTemp()
,AmbientTemp()
,WarningLevel()
,CriticalLevelTimeout(0)
,CriticalLevelElapsed(0)
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOSTATUS;
}


midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus::~midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PanelTemp);
   (tVoid) (oIn >> AmbientTemp);
   (tVoid) (oIn >> WarningLevel);
   (tVoid) (oIn >> CriticalLevelTimeout);
   (tVoid) (oIn >> CriticalLevelElapsed);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PanelTemp);
   (tVoid) (oOut << AmbientTemp);
   (tVoid) (oOut << WarningLevel);
   (tVoid) (oOut << CriticalLevelTimeout);
   (tVoid) (oOut << CriticalLevelElapsed);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus::operator==(const midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PanelTemp == roRef.PanelTemp);
   bResult = bResult && (AmbientTemp == roRef.AmbientTemp);
   bResult = bResult && (WarningLevel == roRef.WarningLevel);
   bResult = bResult && (CriticalLevelTimeout == roRef.CriticalLevelTimeout);
   bResult = bResult && (CriticalLevelElapsed == roRef.CriticalLevelElapsed);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_SizeUpReg::midw_dimmingfi_tclMsgDIM_DISP_SizeUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SizeUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SIZEUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_SizeUpReg::~midw_dimmingfi_tclMsgDIM_DISP_SizeUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_SizeRelUpReg::midw_dimmingfi_tclMsgDIM_DISP_SizeRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SizeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SIZERELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_SizeRelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_SizeRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_SizeGet::midw_dimmingfi_tclMsgDIM_DISP_SizeGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SizeGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SIZEGET;
}


midw_dimmingfi_tclMsgDIM_DISP_SizeGet::~midw_dimmingfi_tclMsgDIM_DISP_SizeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_SizeStatus::midw_dimmingfi_tclMsgDIM_DISP_SizeStatus(const midw_dimmingfi_tclMsgDIM_DISP_SizeStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Size = coRef.Size;
}
midw_dimmingfi_tclMsgDIM_DISP_SizeStatus& midw_dimmingfi_tclMsgDIM_DISP_SizeStatus::operator=(const midw_dimmingfi_tclMsgDIM_DISP_SizeStatus& coRef)
{
   if (this == &coRef) return *this;
   Size = coRef.Size;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_SizeStatus::midw_dimmingfi_tclMsgDIM_DISP_SizeStatus()
:Size()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_SizeStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_SIZESTATUS;
}


midw_dimmingfi_tclMsgDIM_DISP_SizeStatus::~midw_dimmingfi_tclMsgDIM_DISP_SizeStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_SizeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_SizeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Size);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_SizeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Size);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_SizeStatus::operator==(const midw_dimmingfi_tclMsgDIM_DISP_SizeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Size == roRef.Size);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelUpReg::midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg::midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELRELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelGet::midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELGET;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelGet::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus::midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevel = coRef.BrightnessLevel;
}
midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus& midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus::operator=(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevel = coRef.BrightnessLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus::midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus()
:BrightnessLevel()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELSTATUS;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevel);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevel);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus::operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevel == roRef.BrightnessLevel);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureUpReg::midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATUREUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureUpReg::~midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg::midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATURERELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureGet::midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATUREGET;
}


midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureGet::~midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus::midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus(const midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Temperature = coRef.Temperature;
}
midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus& midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus::operator=(const midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus& coRef)
{
   if (this == &coRef) return *this;
   Temperature = coRef.Temperature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus::midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus()
:Temperature()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATURESTATUS;
}


midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus::~midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Temperature);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Temperature);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus::operator==(const midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Temperature == roRef.Temperature);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg::midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg::midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDRELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet::midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDGET;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
}
midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::operator=(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus()
:BrightnessLevelExtended(0)
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDSTATUS;
}


midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevelExtended);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevelExtended);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevelExtended == roRef.BrightnessLevelExtended);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg::midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg::midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELRELUPREG;
}


midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg::~midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelGet::midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELGET;
}


midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelGet::~midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus(const midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   VideoBrightnessLevel = coRef.VideoBrightnessLevel;
}
midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::operator=(const midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   VideoBrightnessLevel = coRef.VideoBrightnessLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus()
:VideoBrightnessLevel(0)
 {}

tS32 midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELSTATUS;
}


midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::~midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VideoBrightnessLevel);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VideoBrightnessLevel);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::operator==(const midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VideoBrightnessLevel == roRef.VideoBrightnessLevel);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DIAG_VariantUpReg::midw_dimmingfi_tclMsgDIM_DIAG_VariantUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DIAG_VariantUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_VARIANTUPREG;
}


midw_dimmingfi_tclMsgDIM_DIAG_VariantUpReg::~midw_dimmingfi_tclMsgDIM_DIAG_VariantUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DIAG_VariantRelUpReg::midw_dimmingfi_tclMsgDIM_DIAG_VariantRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DIAG_VariantRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_VARIANTRELUPREG;
}


midw_dimmingfi_tclMsgDIM_DIAG_VariantRelUpReg::~midw_dimmingfi_tclMsgDIM_DIAG_VariantRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DIAG_VariantGet::midw_dimmingfi_tclMsgDIM_DIAG_VariantGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DIAG_VariantGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_VARIANTGET;
}


midw_dimmingfi_tclMsgDIM_DIAG_VariantGet::~midw_dimmingfi_tclMsgDIM_DIAG_VariantGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus::midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus(const midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   Variant = coRef.Variant;
}
midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus& midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus::operator=(const midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus& coRef)
{
   if (this == &coRef) return *this;
   Variant = coRef.Variant;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus::midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus()
:Variant(0)
 {}

tS32 midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_VARIANTSTATUS;
}


midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus::~midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Variant);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Variant);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus::operator==(const midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Variant == roRef.Variant);
   return bResult;
}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg::midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPEUPREG;
}


midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg::~midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg::midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPERELUPREG;
}


midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg::~midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg()
{}

//=============================================================================

midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeGet::midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeGet()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeGet::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPEGET;
}


midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeGet::~midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus(const midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& coRef)
   : midw_dimmingfi_tclMsgBaseMessage(coRef)
{
   InputConfiguration = coRef.InputConfiguration;
}
midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::operator=(const midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& coRef)
{
   if (this == &coRef) return *this;
   InputConfiguration = coRef.InputConfiguration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus()
:InputConfiguration()
 {}

tS32 midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::s32GetTypeId() const
{
   return (tS32) midw_dimmingfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPESTATUS;
}


midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::~midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus()
{}

tU32 midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> InputConfiguration);
   return oIn;
}

fi_tclOutContext& midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << InputConfiguration);
   return oOut;
}

tBool midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::operator==(const midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (InputConfiguration == roRef.InputConfiguration);
   return bResult;
}

