/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_DIAGNOSTICSFITYPES_HEADER
#define MIDW_DIAGNOSTICSFITYPES_HEADER


class midw_diagnosticsfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for Midw_Diagnostics_FI message types

fi_tclMessageBase* midw_diagnosticsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_diagnosticsfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_diagnosticsfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_diagnosticsfi_tclMsgTestMessageMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgTestMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgTestMessageMethodStart& operator=(const midw_diagnosticsfi_tclMsgTestMessageMethodStart& coRef);
   midw_diagnosticsfi_tclMsgTestMessageMethodStart(const midw_diagnosticsfi_tclMsgTestMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ProtocolId;
   midw_fi_tcl_MessageBuffer MessageBuffer;
   virtual ~midw_diagnosticsfi_tclMsgTestMessageMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgTestMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgTestMessageMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgTestMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgTestMessageMethodResult& operator=(const midw_diagnosticsfi_tclMsgTestMessageMethodResult& coRef);
   midw_diagnosticsfi_tclMsgTestMessageMethodResult(const midw_diagnosticsfi_tclMsgTestMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ProtocolId;
   midw_fi_tcl_MessageBuffer MessageBuffer;
   virtual ~midw_diagnosticsfi_tclMsgTestMessageMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgTestMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgDiagRequestMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgDiagRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgDiagRequestMethodStart& operator=(const midw_diagnosticsfi_tclMsgDiagRequestMethodStart& coRef);
   midw_diagnosticsfi_tclMsgDiagRequestMethodStart(const midw_diagnosticsfi_tclMsgDiagRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_DiagProtocol protID;
   midw_fi_tcl_DiagData diagData;
   tU32 cookie;
   virtual ~midw_diagnosticsfi_tclMsgDiagRequestMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgDiagRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgDiagRequestMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgDiagRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgDiagRequestMethodResult& operator=(const midw_diagnosticsfi_tclMsgDiagRequestMethodResult& coRef);
   midw_diagnosticsfi_tclMsgDiagRequestMethodResult(const midw_diagnosticsfi_tclMsgDiagRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_DiagProtocol protID;
   midw_fi_tcl_DiagData diagData;
   tU32 cookie;
   virtual ~midw_diagnosticsfi_tclMsgDiagRequestMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgDiagRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgReadDiagLogMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgReadDiagLogMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgReadDiagLogMethodStart& operator=(const midw_diagnosticsfi_tclMsgReadDiagLogMethodStart& coRef);
   midw_diagnosticsfi_tclMsgReadDiagLogMethodStart(const midw_diagnosticsfi_tclMsgReadDiagLogMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TroubleCodeType TroubleCodes;
   virtual ~midw_diagnosticsfi_tclMsgReadDiagLogMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgReadDiagLogMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgReadDiagLogMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgReadDiagLogMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgReadDiagLogMethodResult& operator=(const midw_diagnosticsfi_tclMsgReadDiagLogMethodResult& coRef);
   midw_diagnosticsfi_tclMsgReadDiagLogMethodResult(const midw_diagnosticsfi_tclMsgReadDiagLogMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TroubleCodeType TroubleCodes;
   midw_fi_tcl_TroubleCodeList TroubleCodeList;
   virtual ~midw_diagnosticsfi_tclMsgReadDiagLogMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgReadDiagLogMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgClearDiagLogMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgClearDiagLogMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgClearDiagLogMethodStart& operator=(const midw_diagnosticsfi_tclMsgClearDiagLogMethodStart& coRef);
   midw_diagnosticsfi_tclMsgClearDiagLogMethodStart(const midw_diagnosticsfi_tclMsgClearDiagLogMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TroubleCodeType TroubleCodes;
   virtual ~midw_diagnosticsfi_tclMsgClearDiagLogMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgClearDiagLogMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgClearDiagLogMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgClearDiagLogMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgClearDiagLogMethodResult& operator=(const midw_diagnosticsfi_tclMsgClearDiagLogMethodResult& coRef);
   midw_diagnosticsfi_tclMsgClearDiagLogMethodResult(const midw_diagnosticsfi_tclMsgClearDiagLogMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TroubleCodeType TroubleCodes;
   virtual ~midw_diagnosticsfi_tclMsgClearDiagLogMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgClearDiagLogMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart& operator=(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart& coRef);
   midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TestRoutines TestRoutine;
   virtual ~midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult& operator=(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult& coRef);
   midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TestRoutines TestRoutine;
   tBool Success;
   virtual ~midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart& operator=(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart& coRef);
   midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DefaultSettingsCategories SettingsCategory;
   virtual ~midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult& operator=(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult& coRef);
   midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SettingsSuccessful;
   midw_fi_tcl_e8_DefaultSettingsCategories SettingsCategory;
   virtual ~midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart& operator=(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart& coRef);
   midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DiagMausSetup MausSetup;
   virtual ~midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult& operator=(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult& coRef);
   midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool EnableSuccessful;
   virtual ~midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart& operator=(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart& coRef);
   midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TestRoutines TestRoutine;
   virtual ~midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult& operator=(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult& coRef);
   midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TestRoutines TestRoutine;
   tBool Success;
   virtual ~midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart& operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart& coRef);
   midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   midw_fi_tcl_e8_DefSetMode DefSetStateMode;
   virtual ~midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult& operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult& coRef);
   midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   midw_fi_tcl_e8_DefSetServiceStatus DefSetServiceStatus;
   virtual ~midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart& operator=(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart& coRef);
   midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ResetSupplierConfig;
   virtual ~midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult& operator=(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult& coRef);
   midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DefResetServiceStatus;
   virtual ~midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart& operator=(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart& coRef);
   midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 RunTimeSourceAppID;
   tU32 RunTimeSourceAppData;
   virtual ~midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult& operator=(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult& coRef);
   midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RunTimeSourceDiagResp;
   virtual ~midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart& operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart& coRef);
   midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   midw_fi_tcl_e8_DefSetMode DefSetStateMode;
   virtual ~midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult& operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult& coRef);
   midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   midw_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool DefSetStateSuccessful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart& operator=(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart& coRef);
   midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_CalibrationTable Table;
   virtual ~midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult& operator=(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult& coRef);
   midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_CalibrationTable Table;
   tU32 SessionHandle;
   virtual ~midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart& operator=(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart& coRef);
   midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SessionHandle;
   midw_fi_tcl_CalibrationTimeStamp TimeStamp;
   virtual ~midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult& operator=(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult& coRef);
   midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_CalibrationTable Table;
   virtual ~midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStartRouteCalculationSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStartRouteCalculationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgStartRouteCalculationSet& operator=(const midw_diagnosticsfi_tclMsgStartRouteCalculationSet& coRef);
   midw_diagnosticsfi_tclMsgStartRouteCalculationSet(const midw_diagnosticsfi_tclMsgStartRouteCalculationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool CalculationStarted;
   virtual ~midw_diagnosticsfi_tclMsgStartRouteCalculationSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgStartRouteCalculationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStartRouteCalculationUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStartRouteCalculationUpReg();

   virtual ~midw_diagnosticsfi_tclMsgStartRouteCalculationUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgStartRouteCalculationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStartRouteCalculationRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStartRouteCalculationRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgStartRouteCalculationRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgStartRouteCalculationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgStartRouteCalculationStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgStartRouteCalculationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgStartRouteCalculationStatus& operator=(const midw_diagnosticsfi_tclMsgStartRouteCalculationStatus& coRef);
   midw_diagnosticsfi_tclMsgStartRouteCalculationStatus(const midw_diagnosticsfi_tclMsgStartRouteCalculationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_RouteCalculationStartParameter RouteDetails;
   virtual ~midw_diagnosticsfi_tclMsgStartRouteCalculationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgStartRouteCalculationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRouteCalculationResultSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRouteCalculationResultSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgRouteCalculationResultSet& operator=(const midw_diagnosticsfi_tclMsgRouteCalculationResultSet& coRef);
   midw_diagnosticsfi_tclMsgRouteCalculationResultSet(const midw_diagnosticsfi_tclMsgRouteCalculationResultSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_RouteCalculationResultParameter CalculationResult;
   virtual ~midw_diagnosticsfi_tclMsgRouteCalculationResultSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgRouteCalculationResultSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRouteCalculationResultUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRouteCalculationResultUpReg();

   virtual ~midw_diagnosticsfi_tclMsgRouteCalculationResultUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgRouteCalculationResultUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRouteCalculationResultRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRouteCalculationResultRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgRouteCalculationResultRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgRouteCalculationResultRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRouteCalculationResultStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRouteCalculationResultStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgRouteCalculationResultStatus& operator=(const midw_diagnosticsfi_tclMsgRouteCalculationResultStatus& coRef);
   midw_diagnosticsfi_tclMsgRouteCalculationResultStatus(const midw_diagnosticsfi_tclMsgRouteCalculationResultStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool CalculationResultRequested;
   virtual ~midw_diagnosticsfi_tclMsgRouteCalculationResultStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgRouteCalculationResultStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetLocaleStartSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetLocaleStartSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetLocaleStartSet& operator=(const midw_diagnosticsfi_tclMsgSetLocaleStartSet& coRef);
   midw_diagnosticsfi_tclMsgSetLocaleStartSet(const midw_diagnosticsfi_tclMsgSetLocaleStartSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool LocaleSwitched;
   virtual ~midw_diagnosticsfi_tclMsgSetLocaleStartSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetLocaleStartSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetLocaleStartUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetLocaleStartUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSetLocaleStartUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSetLocaleStartUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetLocaleStartRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetLocaleStartRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSetLocaleStartRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSetLocaleStartRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetLocaleStartStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetLocaleStartStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetLocaleStartStatus& operator=(const midw_diagnosticsfi_tclMsgSetLocaleStartStatus& coRef);
   midw_diagnosticsfi_tclMsgSetLocaleStartStatus(const midw_diagnosticsfi_tclMsgSetLocaleStartStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_CountryLanguage CountryLanguage;
   midw_fi_tcl_e8_Store Store;
   virtual ~midw_diagnosticsfi_tclMsgSetLocaleStartStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetLocaleStartStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetLocaleResultSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetLocaleResultSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetLocaleResultSet& operator=(const midw_diagnosticsfi_tclMsgSetLocaleResultSet& coRef);
   midw_diagnosticsfi_tclMsgSetLocaleResultSet(const midw_diagnosticsfi_tclMsgSetLocaleResultSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_CountryLanguageResult CountryLanguageResult;
   virtual ~midw_diagnosticsfi_tclMsgSetLocaleResultSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetLocaleResultSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetLocaleResultUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetLocaleResultUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSetLocaleResultUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSetLocaleResultUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetLocaleResultRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetLocaleResultRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSetLocaleResultRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSetLocaleResultRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetLocaleResultStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetLocaleResultStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetLocaleResultStatus& operator=(const midw_diagnosticsfi_tclMsgSetLocaleResultStatus& coRef);
   midw_diagnosticsfi_tclMsgSetLocaleResultStatus(const midw_diagnosticsfi_tclMsgSetLocaleResultStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SetLocaleResultRequested;
   virtual ~midw_diagnosticsfi_tclMsgSetLocaleResultStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetLocaleResultStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgGetLocaleSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgGetLocaleSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgGetLocaleSet& operator=(const midw_diagnosticsfi_tclMsgGetLocaleSet& coRef);
   midw_diagnosticsfi_tclMsgGetLocaleSet(const midw_diagnosticsfi_tclMsgGetLocaleSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_CountryLanguage CountryLanguage;
   virtual ~midw_diagnosticsfi_tclMsgGetLocaleSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgGetLocaleSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgGetLocaleUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgGetLocaleUpReg();

   virtual ~midw_diagnosticsfi_tclMsgGetLocaleUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgGetLocaleUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgGetLocaleRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgGetLocaleRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgGetLocaleRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgGetLocaleRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgGetLocaleStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgGetLocaleStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgGetLocaleStatus& operator=(const midw_diagnosticsfi_tclMsgGetLocaleStatus& coRef);
   midw_diagnosticsfi_tclMsgGetLocaleStatus(const midw_diagnosticsfi_tclMsgGetLocaleStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool GetLocaleRequested;
   virtual ~midw_diagnosticsfi_tclMsgGetLocaleStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgGetLocaleStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetDisplaySet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetDisplaySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetDisplaySet& operator=(const midw_diagnosticsfi_tclMsgSetDisplaySet& coRef);
   midw_diagnosticsfi_tclMsgSetDisplaySet(const midw_diagnosticsfi_tclMsgSetDisplaySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DisplayTestSuccess;
   virtual ~midw_diagnosticsfi_tclMsgSetDisplaySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetDisplaySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetDisplayUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetDisplayUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSetDisplayUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSetDisplayUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetDisplayRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetDisplayRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSetDisplayRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSetDisplayRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetDisplayStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetDisplayStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetDisplayStatus& operator=(const midw_diagnosticsfi_tclMsgSetDisplayStatus& coRef);
   midw_diagnosticsfi_tclMsgSetDisplayStatus(const midw_diagnosticsfi_tclMsgSetDisplayStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_DisplayData DisplayData;
   virtual ~midw_diagnosticsfi_tclMsgSetDisplayStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetDisplayStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus& operator=(const midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus& coRef);
   midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus(const midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_KdsViaUsbUpdateStatus ConfigUpdateStatus;
   virtual ~midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftStatusSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgAntiTheftStatusSet& operator=(const midw_diagnosticsfi_tclMsgAntiTheftStatusSet& coRef);
   midw_diagnosticsfi_tclMsgAntiTheftStatusSet(const midw_diagnosticsfi_tclMsgAntiTheftStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_AntiTheftStatus AntiTheftStatus;
   virtual ~midw_diagnosticsfi_tclMsgAntiTheftStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftStatusUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftStatusUpReg();

   virtual ~midw_diagnosticsfi_tclMsgAntiTheftStatusUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftStatusRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftStatusRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgAntiTheftStatusRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftStatusStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftStatusStatus();

   virtual ~midw_diagnosticsfi_tclMsgAntiTheftStatusStatus();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftStatusStatus& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftUnlockHMISet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftUnlockHMISet();

   virtual ~midw_diagnosticsfi_tclMsgAntiTheftUnlockHMISet();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHMISet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIUpReg();

   virtual ~midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus& operator=(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus& coRef);
   midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool VIDWriteStatus;
   virtual ~midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftUnlockHUSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftUnlockHUSet();

   virtual ~midw_diagnosticsfi_tclMsgAntiTheftUnlockHUSet();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHUSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftUnlockHUUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftUnlockHUUpReg();

   virtual ~midw_diagnosticsfi_tclMsgAntiTheftUnlockHUUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHUUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftUnlockHURelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftUnlockHURelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgAntiTheftUnlockHURelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHURelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus& operator=(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus& coRef);
   midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool PINValidationStatus;
   virtual ~midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgClearDestinationMemorySet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgClearDestinationMemorySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgClearDestinationMemorySet& operator=(const midw_diagnosticsfi_tclMsgClearDestinationMemorySet& coRef);
   midw_diagnosticsfi_tclMsgClearDestinationMemorySet(const midw_diagnosticsfi_tclMsgClearDestinationMemorySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ClearMemorySuccess;
   virtual ~midw_diagnosticsfi_tclMsgClearDestinationMemorySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgClearDestinationMemorySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgClearDestinationMemoryUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgClearDestinationMemoryUpReg();

   virtual ~midw_diagnosticsfi_tclMsgClearDestinationMemoryUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgClearDestinationMemoryUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgClearDestinationMemoryRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgClearDestinationMemoryRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgClearDestinationMemoryRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgClearDestinationMemoryRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus& operator=(const midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus& coRef);
   midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus(const midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ClearMemory;
   virtual ~midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet& operator=(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet& coRef);
   midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 RecordCount;
   virtual ~midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgGetDestinationMemorySizeUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgGetDestinationMemorySizeUpReg();

   virtual ~midw_diagnosticsfi_tclMsgGetDestinationMemorySizeUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgGetDestinationMemorySizeRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgGetDestinationMemorySizeRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgGetDestinationMemorySizeRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus& operator=(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus& coRef);
   midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool GetMemorySize;
   virtual ~midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSimulateKeyPressSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSimulateKeyPressSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSimulateKeyPressSet& operator=(const midw_diagnosticsfi_tclMsgSimulateKeyPressSet& coRef);
   midw_diagnosticsfi_tclMsgSimulateKeyPressSet(const midw_diagnosticsfi_tclMsgSimulateKeyPressSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool KeyPressSuccess;
   virtual ~midw_diagnosticsfi_tclMsgSimulateKeyPressSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSimulateKeyPressSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSimulateKeyPressUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSimulateKeyPressUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSimulateKeyPressUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSimulateKeyPressUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSimulateKeyPressRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSimulateKeyPressRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSimulateKeyPressRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSimulateKeyPressRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSimulateKeyPressStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSimulateKeyPressStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSimulateKeyPressStatus& operator=(const midw_diagnosticsfi_tclMsgSimulateKeyPressStatus& coRef);
   midw_diagnosticsfi_tclMsgSimulateKeyPressStatus(const midw_diagnosticsfi_tclMsgSimulateKeyPressStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_SimulatedKeys KeyCommand;
   tS8 EncoderSteps;
   virtual ~midw_diagnosticsfi_tclMsgSimulateKeyPressStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSimulateKeyPressStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgResetSecuritySet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgResetSecuritySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgResetSecuritySet& operator=(const midw_diagnosticsfi_tclMsgResetSecuritySet& coRef);
   midw_diagnosticsfi_tclMsgResetSecuritySet(const midw_diagnosticsfi_tclMsgResetSecuritySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ResetSuccess;
   virtual ~midw_diagnosticsfi_tclMsgResetSecuritySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgResetSecuritySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgResetSecurityUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgResetSecurityUpReg();

   virtual ~midw_diagnosticsfi_tclMsgResetSecurityUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgResetSecurityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgResetSecurityRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgResetSecurityRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgResetSecurityRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgResetSecurityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgResetSecurityStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgResetSecurityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgResetSecurityStatus& operator=(const midw_diagnosticsfi_tclMsgResetSecurityStatus& coRef);
   midw_diagnosticsfi_tclMsgResetSecurityStatus(const midw_diagnosticsfi_tclMsgResetSecurityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Reset;
   virtual ~midw_diagnosticsfi_tclMsgResetSecurityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgResetSecurityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgLanguageGet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgLanguageGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgLanguageGet& operator=(const midw_diagnosticsfi_tclMsgLanguageGet& coRef);
   midw_diagnosticsfi_tclMsgLanguageGet(const midw_diagnosticsfi_tclMsgLanguageGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_Language Language;
   virtual ~midw_diagnosticsfi_tclMsgLanguageGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgLanguageGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgLanguageStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgLanguageStatus();

   virtual ~midw_diagnosticsfi_tclMsgLanguageStatus();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgLanguageStatus& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSpeedLockGet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSpeedLockGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSpeedLockGet& operator=(const midw_diagnosticsfi_tclMsgSpeedLockGet& coRef);
   midw_diagnosticsfi_tclMsgSpeedLockGet(const midw_diagnosticsfi_tclMsgSpeedLockGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_SpeedLock SpeedLock;
   virtual ~midw_diagnosticsfi_tclMsgSpeedLockGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSpeedLockGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSpeedLockStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSpeedLockStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSpeedLockStatus& operator=(const midw_diagnosticsfi_tclMsgSpeedLockStatus& coRef);
   midw_diagnosticsfi_tclMsgSpeedLockStatus(const midw_diagnosticsfi_tclMsgSpeedLockStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_SpeedLock SpeedLockStatus;
   tU8 SpeedLockThreshold;
   virtual ~midw_diagnosticsfi_tclMsgSpeedLockStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSpeedLockStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSpdLockSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSpdLockSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSpdLockSet& operator=(const midw_diagnosticsfi_tclMsgSpdLockSet& coRef);
   midw_diagnosticsfi_tclMsgSpdLockSet(const midw_diagnosticsfi_tclMsgSpdLockSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_SpeedLock SpeedLock;
   virtual ~midw_diagnosticsfi_tclMsgSpdLockSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSpdLockSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSpdLockStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSpdLockStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSpdLockStatus& operator=(const midw_diagnosticsfi_tclMsgSpdLockStatus& coRef);
   midw_diagnosticsfi_tclMsgSpdLockStatus(const midw_diagnosticsfi_tclMsgSpdLockStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SpeedLockStatus;
   virtual ~midw_diagnosticsfi_tclMsgSpdLockStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSpdLockStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetRVCSignalGet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetRVCSignalGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetRVCSignalGet& operator=(const midw_diagnosticsfi_tclMsgSetRVCSignalGet& coRef);
   midw_diagnosticsfi_tclMsgSetRVCSignalGet(const midw_diagnosticsfi_tclMsgSetRVCSignalGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DiagRVCSignal SignalStatus;
   virtual ~midw_diagnosticsfi_tclMsgSetRVCSignalGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetRVCSignalGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetRVCSignalSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetRVCSignalSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetRVCSignalSet& operator=(const midw_diagnosticsfi_tclMsgSetRVCSignalSet& coRef);
   midw_diagnosticsfi_tclMsgSetRVCSignalSet(const midw_diagnosticsfi_tclMsgSetRVCSignalSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool StatusChanged;
   virtual ~midw_diagnosticsfi_tclMsgSetRVCSignalSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetRVCSignalSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetRVCSignalUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetRVCSignalUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSetRVCSignalUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSetRVCSignalUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetRVCSignalRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetRVCSignalRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSetRVCSignalRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSetRVCSignalRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetRVCSignalStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetRVCSignalStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetRVCSignalStatus& operator=(const midw_diagnosticsfi_tclMsgSetRVCSignalStatus& coRef);
   midw_diagnosticsfi_tclMsgSetRVCSignalStatus(const midw_diagnosticsfi_tclMsgSetRVCSignalStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DiagRVCSignal SignalStatus;
   virtual ~midw_diagnosticsfi_tclMsgSetRVCSignalStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetRVCSignalStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRVCSignalStatusSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRVCSignalStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgRVCSignalStatusSet& operator=(const midw_diagnosticsfi_tclMsgRVCSignalStatusSet& coRef);
   midw_diagnosticsfi_tclMsgRVCSignalStatusSet(const midw_diagnosticsfi_tclMsgRVCSignalStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DiagRVCSignal SignalStatus;
   virtual ~midw_diagnosticsfi_tclMsgRVCSignalStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgRVCSignalStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRVCSignalStatusUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRVCSignalStatusUpReg();

   virtual ~midw_diagnosticsfi_tclMsgRVCSignalStatusUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgRVCSignalStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRVCSignalStatusRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRVCSignalStatusRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgRVCSignalStatusRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgRVCSignalStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRVCSignalStatusStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRVCSignalStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgRVCSignalStatusStatus& operator=(const midw_diagnosticsfi_tclMsgRVCSignalStatusStatus& coRef);
   midw_diagnosticsfi_tclMsgRVCSignalStatusStatus(const midw_diagnosticsfi_tclMsgRVCSignalStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RequestStatus;
   virtual ~midw_diagnosticsfi_tclMsgRVCSignalStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgRVCSignalStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgKdsEntryGet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgKdsEntryGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgKdsEntryGet& operator=(const midw_diagnosticsfi_tclMsgKdsEntryGet& coRef);
   midw_diagnosticsfi_tclMsgKdsEntryGet(const midw_diagnosticsfi_tclMsgKdsEntryGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 KdsEntry;
   virtual ~midw_diagnosticsfi_tclMsgKdsEntryGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgKdsEntryGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgKdsEntrySet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgKdsEntrySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgKdsEntrySet& operator=(const midw_diagnosticsfi_tclMsgKdsEntrySet& coRef);
   midw_diagnosticsfi_tclMsgKdsEntrySet(const midw_diagnosticsfi_tclMsgKdsEntrySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 KdsEntry;
   midw_fi_tcl_KDSItemList KdsDataList;
   virtual ~midw_diagnosticsfi_tclMsgKdsEntrySet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgKdsEntrySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgKdsEntryStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgKdsEntryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgKdsEntryStatus& operator=(const midw_diagnosticsfi_tclMsgKdsEntryStatus& coRef);
   midw_diagnosticsfi_tclMsgKdsEntryStatus(const midw_diagnosticsfi_tclMsgKdsEntryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 KdsEntry;
   midw_fi_tcl_KDSItemList KdsDataList;
   virtual ~midw_diagnosticsfi_tclMsgKdsEntryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgKdsEntryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgKdsEntryUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgKdsEntryUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgKdsEntryUpReg& operator=(const midw_diagnosticsfi_tclMsgKdsEntryUpReg& coRef);
   midw_diagnosticsfi_tclMsgKdsEntryUpReg(const midw_diagnosticsfi_tclMsgKdsEntryUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 KdsEntry;
   virtual ~midw_diagnosticsfi_tclMsgKdsEntryUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgKdsEntryUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgKdsEntryRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgKdsEntryRelUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgKdsEntryRelUpReg& operator=(const midw_diagnosticsfi_tclMsgKdsEntryRelUpReg& coRef);
   midw_diagnosticsfi_tclMsgKdsEntryRelUpReg(const midw_diagnosticsfi_tclMsgKdsEntryRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 KdsEntry;
   virtual ~midw_diagnosticsfi_tclMsgKdsEntryRelUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgKdsEntryRelUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgDiagConfigItemGet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgDiagConfigItemGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgDiagConfigItemGet& operator=(const midw_diagnosticsfi_tclMsgDiagConfigItemGet& coRef);
   midw_diagnosticsfi_tclMsgDiagConfigItemGet(const midw_diagnosticsfi_tclMsgDiagConfigItemGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ConfigItem;
   virtual ~midw_diagnosticsfi_tclMsgDiagConfigItemGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgDiagConfigItemGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgDiagConfigItemSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgDiagConfigItemSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgDiagConfigItemSet& operator=(const midw_diagnosticsfi_tclMsgDiagConfigItemSet& coRef);
   midw_diagnosticsfi_tclMsgDiagConfigItemSet(const midw_diagnosticsfi_tclMsgDiagConfigItemSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ConfigItem;
   midw_fi_tcl_ConfigItemList ConfigItemContent;
   virtual ~midw_diagnosticsfi_tclMsgDiagConfigItemSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgDiagConfigItemSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgDiagConfigItemStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgDiagConfigItemStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgDiagConfigItemStatus& operator=(const midw_diagnosticsfi_tclMsgDiagConfigItemStatus& coRef);
   midw_diagnosticsfi_tclMsgDiagConfigItemStatus(const midw_diagnosticsfi_tclMsgDiagConfigItemStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ConfigItem;
   tBool ConfigItemValid;
   midw_fi_tcl_ConfigItemList ConfigItemContent;
   virtual ~midw_diagnosticsfi_tclMsgDiagConfigItemStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgDiagConfigItemStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgDiagConfigItemUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgDiagConfigItemUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgDiagConfigItemUpReg& operator=(const midw_diagnosticsfi_tclMsgDiagConfigItemUpReg& coRef);
   midw_diagnosticsfi_tclMsgDiagConfigItemUpReg(const midw_diagnosticsfi_tclMsgDiagConfigItemUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ConfigItem;
   virtual ~midw_diagnosticsfi_tclMsgDiagConfigItemUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgDiagConfigItemUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg& operator=(const midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg& coRef);
   midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg(const midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ConfigItem;
   virtual ~midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetFactorySettingsStatusUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetFactorySettingsStatusUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSetFactorySettingsStatusUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetFactorySettingsStatusRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetFactorySettingsStatusRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgSetFactorySettingsStatusRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet& operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet& coRef);
   midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   midw_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool DefSetStateSuccessful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet& operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet& coRef);
   midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   midw_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool DefSetStateSuccessful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus& operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus& coRef);
   midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   midw_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool DefSetStateSuccessful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRemoteControlUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRemoteControlUpReg();

   virtual ~midw_diagnosticsfi_tclMsgRemoteControlUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgRemoteControlUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRemoteControlRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRemoteControlRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgRemoteControlRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgRemoteControlRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRemoteControlGet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRemoteControlGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgRemoteControlGet& operator=(const midw_diagnosticsfi_tclMsgRemoteControlGet& coRef);
   midw_diagnosticsfi_tclMsgRemoteControlGet(const midw_diagnosticsfi_tclMsgRemoteControlGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_RCtrlSource src;
   midw_fi_tcl_e8_RCtrlCommand cmd;
   midw_fi_tcl_e8_RCtrlSignal signal;
   virtual ~midw_diagnosticsfi_tclMsgRemoteControlGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgRemoteControlGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRemoteControlSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRemoteControlSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgRemoteControlSet& operator=(const midw_diagnosticsfi_tclMsgRemoteControlSet& coRef);
   midw_diagnosticsfi_tclMsgRemoteControlSet(const midw_diagnosticsfi_tclMsgRemoteControlSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_RCtrlSource src;
   midw_fi_tcl_e8_RCtrlCommand cmd;
   midw_fi_tcl_e8_RCtrlSignal signal;
   tBool status;
   virtual ~midw_diagnosticsfi_tclMsgRemoteControlSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgRemoteControlSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgRemoteControlStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgRemoteControlStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgRemoteControlStatus& operator=(const midw_diagnosticsfi_tclMsgRemoteControlStatus& coRef);
   midw_diagnosticsfi_tclMsgRemoteControlStatus(const midw_diagnosticsfi_tclMsgRemoteControlStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_RCtrlSource src;
   midw_fi_tcl_e8_RCtrlCommand cmd;
   midw_fi_tcl_e8_RCtrlSignal signal;
   tBool status;
   virtual ~midw_diagnosticsfi_tclMsgRemoteControlStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgRemoteControlStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgCISswUpdateProcessUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgCISswUpdateProcessUpReg();

   virtual ~midw_diagnosticsfi_tclMsgCISswUpdateProcessUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgCISswUpdateProcessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgCISswUpdateProcessRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgCISswUpdateProcessRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgCISswUpdateProcessRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgCISswUpdateProcessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgCISswUpdateProcessSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgCISswUpdateProcessSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgCISswUpdateProcessSet& operator=(const midw_diagnosticsfi_tclMsgCISswUpdateProcessSet& coRef);
   midw_diagnosticsfi_tclMsgCISswUpdateProcessSet(const midw_diagnosticsfi_tclMsgCISswUpdateProcessSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool status;
   virtual ~midw_diagnosticsfi_tclMsgCISswUpdateProcessSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgCISswUpdateProcessSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus& operator=(const midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus& coRef);
   midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus(const midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool status;
   virtual ~midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessUpReg();

   virtual ~midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessRelUpReg : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessRelUpReg();

   virtual ~midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessRelUpReg();

   inline tBool operator==(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet& operator=(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet& coRef);
   midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool status;
   virtual ~midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus& operator=(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus& coRef);
   midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool status;
   virtual ~midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgCalibrationParameterGet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgCalibrationParameterGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgCalibrationParameterGet& operator=(const midw_diagnosticsfi_tclMsgCalibrationParameterGet& coRef);
   midw_diagnosticsfi_tclMsgCalibrationParameterGet(const midw_diagnosticsfi_tclMsgCalibrationParameterGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SessionHandle;
   midw_fi_tclString Name;
   virtual ~midw_diagnosticsfi_tclMsgCalibrationParameterGet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgCalibrationParameterGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgCalibrationParameterSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgCalibrationParameterSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgCalibrationParameterSet& operator=(const midw_diagnosticsfi_tclMsgCalibrationParameterSet& coRef);
   midw_diagnosticsfi_tclMsgCalibrationParameterSet(const midw_diagnosticsfi_tclMsgCalibrationParameterSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SessionHandle;
   midw_fi_tclString Name;
   midw_fi_tcl_CalibrationValue Value;
   virtual ~midw_diagnosticsfi_tclMsgCalibrationParameterSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgCalibrationParameterSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgCalibrationParameterStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgCalibrationParameterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgCalibrationParameterStatus& operator=(const midw_diagnosticsfi_tclMsgCalibrationParameterStatus& coRef);
   midw_diagnosticsfi_tclMsgCalibrationParameterStatus(const midw_diagnosticsfi_tclMsgCalibrationParameterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_CalibrationTable Table;
   midw_fi_tclString Name;
   midw_fi_tcl_CalibrationValue Value;
   midw_fi_tcl_e8_CalibrationParameterSize ElementSize;
   virtual ~midw_diagnosticsfi_tclMsgCalibrationParameterStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgCalibrationParameterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgPartNumberGet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgPartNumberGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgPartNumberGet& operator=(const midw_diagnosticsfi_tclMsgPartNumberGet& coRef);
   midw_diagnosticsfi_tclMsgPartNumberGet(const midw_diagnosticsfi_tclMsgPartNumberGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DataIdentifier;
   virtual ~midw_diagnosticsfi_tclMsgPartNumberGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgPartNumberGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgPartNumberSet : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgPartNumberSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgPartNumberSet& operator=(const midw_diagnosticsfi_tclMsgPartNumberSet& coRef);
   midw_diagnosticsfi_tclMsgPartNumberSet(const midw_diagnosticsfi_tclMsgPartNumberSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DataIdentifier;
   tU32 PartNumber;
   midw_fi_tcl_AlphaCode AlphaCode;
   virtual ~midw_diagnosticsfi_tclMsgPartNumberSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgPartNumberSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diagnosticsfi_tclMsgPartNumberStatus : public midw_diagnosticsfi_tclMsgBaseMessage
{
public:

   midw_diagnosticsfi_tclMsgPartNumberStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diagnosticsfi_tclMsgPartNumberStatus& operator=(const midw_diagnosticsfi_tclMsgPartNumberStatus& coRef);
   midw_diagnosticsfi_tclMsgPartNumberStatus(const midw_diagnosticsfi_tclMsgPartNumberStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DataIdentifier;
   tU32 PartNumber;
   midw_fi_tcl_AlphaCode AlphaCode;
   virtual ~midw_diagnosticsfi_tclMsgPartNumberStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diagnosticsfi_tclMsgPartNumberStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
