#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_STDVISITORS
#include "midw_fi_gen_if.h"

tBool midw_diagnosticsfi_tclDescription::bInitMessage(midw_diagnosticsfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_diagnosticsfi_tclToken::EN_LAST_TOKEN:
   case midw_diagnosticsfi_tclToken::EN_LIST:
   case midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT:
   case midw_diagnosticsfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_diagnosticsfi_tclToken::EN_MSG_TESTMESSAGEMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_MESSAGEBUFFER,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_MESSAGEBUFFER)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_PROTOCOLID)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_TESTMESSAGEMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_MESSAGEBUFFER,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_MESSAGEBUFFER)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_PROTOCOLID)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_DIAGREQUESTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_COOKIE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_DIAGDATA,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DIAGDATA)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_DIAGPROTOCOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_PROTID)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_DIAGREQUESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_COOKIE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_DIAGDATA,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DIAGDATA)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_DIAGPROTOCOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_PROTID)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_READDIAGLOGMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_TROUBLECODETYPE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TROUBLECODES)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_READDIAGLOGMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_TROUBLECODELIST,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TROUBLECODELIST)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_TROUBLECODETYPE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TROUBLECODES)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDIAGLOGMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_TROUBLECODETYPE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TROUBLECODES)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDIAGLOGMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_TROUBLECODETYPE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TROUBLECODES)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_STARTDIAGNOSTICTESTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_TESTROUTINES,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TESTROUTINE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_STARTDIAGNOSTICTESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SUCCESS)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_TESTROUTINES,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TESTROUTINE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETDEFAULTSETTINGSMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DEFAULTSETTINGSCATEGORIES,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SETTINGSCATEGORY)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETDEFAULTSETTINGSMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DEFAULTSETTINGSCATEGORIES,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SETTINGSCATEGORY)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SETTINGSSUCCESSFUL)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_ENABLETIMESLOTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DIAGMAUSSETUP,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_MAUSSETUP)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_ENABLETIMESLOTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_ENABLESUCCESSFUL)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_STOPDIAGNOSTICTESTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_TESTROUTINES,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TESTROUTINE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_STOPDIAGNOSTICTESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SUCCESS)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_TESTROUTINES,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TESTROUTINE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DEFSETMODE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DEFSETSERVICESTATUS,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSERVICESTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETRESETTOSUPPLIERDEFAULTCONFIGMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_RESETSUPPLIERCONFIG)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETRESETTOSUPPLIERDEFAULTCONFIGMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFRESETSERVICESTATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETRUNTIMESOURCEDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_RUNTIMESOURCEAPPDATA)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U16,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_RUNTIMESOURCEAPPID)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETRUNTIMESOURCEDATAMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_RUNTIMESOURCEDIAGRESP)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DEFSETMODE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U16,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEFIRSTDIFFERENTPARAMETERID)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATESUCCESSFUL)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DEFSETMODE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_STARTCALIBRATIONSESSIONMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_CALIBRATIONTABLE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TABLE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_STARTCALIBRATIONSESSIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SESSIONHANDLE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_CALIBRATIONTABLE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TABLE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_STOPCALIBRATIONSESSIONMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_CALIBRATIONTIMESTAMP,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SESSIONHANDLE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_STOPCALIBRATIONSESSIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_CALIBRATIONTABLE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TABLE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CALCULATIONSTARTED)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_ROUTECALCULATIONSTARTPARAMETER,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_ROUTEDETAILS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_ROUTECALCULATIONRESULTPARAMETER,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CALCULATIONRESULT)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CALCULATIONRESULTREQUESTED)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_LOCALESWITCHED)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_STORE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_STORE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_COUNTRYLANGUAGE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_COUNTRYLANGUAGE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_COUNTRYLANGUAGERESULT,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_COUNTRYLANGUAGERESULT)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SETLOCALERESULTREQUESTED)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALESET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_COUNTRYLANGUAGE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_COUNTRYLANGUAGE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALESTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_GETLOCALEREQUESTED)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DISPLAYTESTSUCCESS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_DISPLAYDATA,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DISPLAYDATA)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CONFIGUPDATEVIAUSBSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_KDSVIAUSBUPDATESTATUS,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CONFIGUPDATESTATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_ANTITHEFTSTATUS,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_ANTITHEFTSTATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMISTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_VIDWRITESTATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_PINVALIDATIONSTATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CLEARMEMORYSUCCESS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CLEARMEMORY)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZESET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U16,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_RECORDCOUNT)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZESTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_GETMEMORYSIZE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_KEYPRESSSUCCESS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_S8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_ENCODERSTEPS)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_SIMULATEDKEYS,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_KEYCOMMAND)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_RESETSUCCESS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_RESET)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_LANGUAGEGET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E16_LANGUAGE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_LANGUAGE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SPEEDLOCKGET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E16_SPEEDLOCK,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SPEEDLOCK)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SPEEDLOCKSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SPEEDLOCKTHRESHOLD)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E16_SPEEDLOCK,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SPEEDLOCKSTATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SPDLOCKSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E16_SPEEDLOCK,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SPEEDLOCK)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SPDLOCKSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SPEEDLOCKSTATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALGET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DIAGRVCSIGNAL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SIGNALSTATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_STATUSCHANGED)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DIAGRVCSIGNAL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SIGNALSTATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DIAGRVCSIGNAL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SIGNALSTATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_REQUESTSTATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYGET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_KDSENTRY)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_KDSITEMLIST,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_KDSDATALIST)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_KDSENTRY)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_KDSITEMLIST,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_KDSDATALIST)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_KDSENTRY)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYUPREG:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_KDSENTRY)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYRELUPREG:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_KDSENTRY)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMGET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CONFIGITEM)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_CONFIGITEMLIST,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CONFIGITEMCONTENT)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CONFIGITEM)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_CONFIGITEMLIST,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CONFIGITEMCONTENT)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CONFIGITEMVALID)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CONFIGITEM)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMUPREG:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CONFIGITEM)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMRELUPREG:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CONFIGITEM)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSGET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U16,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEFIRSTDIFFERENTPARAMETERID)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATESUCCESSFUL)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DEFSETMODE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U16,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEFIRSTDIFFERENTPARAMETERID)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATESUCCESSFUL)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DEFSETMODE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U16,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEFIRSTDIFFERENTPARAMETERID)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATESUCCESSFUL)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_DEFSETMODE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLGET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_RCTRLSIGNAL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SIGNAL)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_RCTRLCOMMAND,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CMD)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_RCTRLSOURCE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SRC)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_RCTRLSIGNAL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SIGNAL)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_RCTRLCOMMAND,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CMD)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_RCTRLSOURCE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SRC)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_RCTRLSIGNAL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SIGNAL)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_RCTRLCOMMAND,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_CMD)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_RCTRLSOURCE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SRC)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERGET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_STRING,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_NAME)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SESSIONHANDLE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_CALIBRATIONVALUE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_VALUE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_STRING,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_NAME)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_SESSIONHANDLE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_CALIBRATIONPARAMETERSIZE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_ELEMENTSIZE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_CALIBRATIONVALUE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_VALUE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_STRING,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_NAME)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_CALIBRATIONTABLE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_TABLE)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERGET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DATAIDENTIFIER)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERSET:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_ALPHACODE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_ALPHACODE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_PARTNUMBER)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DATAIDENTIFIER)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERSTATUS:
   {
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_ALPHACODE,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_ALPHACODE)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_PARTNUMBER)) && bResult;
      bResult = oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MSG_DATAIDENTIFIER)) && bResult;
   } break;
   case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALEUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALERELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSSTATUS:
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMISET:
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMIUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMIRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUSET:
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHURELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZEUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZERELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_LANGUAGESTATUS:
   case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSUPREG:
   case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSRELUPREG:
   case midw_diagnosticsfi_tclToken::EN_BINCONTAINER:
   case midw_diagnosticsfi_tclToken::EN_DIAGPROTOCOL:
   case midw_diagnosticsfi_tclToken::EN_E8_STORE:
   case midw_diagnosticsfi_tclToken::EN_E8_ROUTECALCULATIONCOMMAND:
   case midw_diagnosticsfi_tclToken::EN_E8_ROUTECALCULATIONSTATUS:
   case midw_diagnosticsfi_tclToken::EN_E8_LANGUAGE:
   case midw_diagnosticsfi_tclToken::EN_E8_COUNTRY:
   case midw_diagnosticsfi_tclToken::EN_E8_LANGUAGESUBSYSTEM:
   case midw_diagnosticsfi_tclToken::EN_E8_TESTSCREENS:
   case midw_diagnosticsfi_tclToken::EN_DISPLAYSTRINGSLIST:
   case midw_diagnosticsfi_tclToken::EN_DISPLAYDATA:
   case midw_diagnosticsfi_tclToken::EN_E8_TROUBLECODETYPE:
   case midw_diagnosticsfi_tclToken::EN_E8_TESTROUTINES:
   case midw_diagnosticsfi_tclToken::EN_E8_DEFAULTSETTINGSCATEGORIES:
   case midw_diagnosticsfi_tclToken::EN_COUNTRYLANGUAGE:
   case midw_diagnosticsfi_tclToken::EN_COUNTRYLANGUAGERESULT:
   case midw_diagnosticsfi_tclToken::EN_E8_TROUBLECODESTATUS:
   case midw_diagnosticsfi_tclToken::EN_TROUBLECODE:
   case midw_diagnosticsfi_tclToken::EN_TROUBLECODELIST:
   case midw_diagnosticsfi_tclToken::EN_ROUTECALCULATIONSTARTPARAMETER:
   case midw_diagnosticsfi_tclToken::EN_ROUTECALCULATIONRESULTPARAMETER:
   case midw_diagnosticsfi_tclToken::EN_E16_LANGUAGE:
   case midw_diagnosticsfi_tclToken::EN_E16_SPEEDLOCK:
   case midw_diagnosticsfi_tclToken::EN_MESSAGEBUFFER:
   case midw_diagnosticsfi_tclToken::EN_E8_DEFSETMODE:
   case midw_diagnosticsfi_tclToken::EN_E8_DEFSETSERVICESTATUS:
   case midw_diagnosticsfi_tclToken::EN_E8_DIAGMAUSSETUP:
   case midw_diagnosticsfi_tclToken::EN_E8_SIMULATEDKEYS:
   case midw_diagnosticsfi_tclToken::EN_KDSITEMLIST:
   case midw_diagnosticsfi_tclToken::EN_CONFIGITEMLIST:
   case midw_diagnosticsfi_tclToken::EN_DIAGDATA:
   case midw_diagnosticsfi_tclToken::EN_E8_RCTRLSOURCE:
   case midw_diagnosticsfi_tclToken::EN_E8_RCTRLCOMMAND:
   case midw_diagnosticsfi_tclToken::EN_E8_RCTRLSIGNAL:
   case midw_diagnosticsfi_tclToken::EN_E8_DIAGRVCSIGNAL:
   case midw_diagnosticsfi_tclToken::EN_E8_CALIBRATIONTABLE:
   case midw_diagnosticsfi_tclToken::EN_CALIBRATIONVALUE:
   case midw_diagnosticsfi_tclToken::EN_CALIBRATIONTIMESTAMP:
   case midw_diagnosticsfi_tclToken::EN_ALPHACODE:
   case midw_diagnosticsfi_tclToken::EN_E8_CALIBRATIONPARAMETERSIZE:
   case midw_diagnosticsfi_tclToken::EN_E8_KDSVIAUSBUPDATESTATUS:
   case midw_diagnosticsfi_tclToken::EN_ANTITHEFTSTATUS:
   case midw_diagnosticsfi_tclToken::EN_U8:   
   case midw_diagnosticsfi_tclToken::EN_S8:   
   case midw_diagnosticsfi_tclToken::EN_U16:   
   case midw_diagnosticsfi_tclToken::EN_S16:   
   case midw_diagnosticsfi_tclToken::EN_U24:   
   case midw_diagnosticsfi_tclToken::EN_S24:   
   case midw_diagnosticsfi_tclToken::EN_U32:   
   case midw_diagnosticsfi_tclToken::EN_S32:   
   case midw_diagnosticsfi_tclToken::EN_U64:   
   case midw_diagnosticsfi_tclToken::EN_S64:   
   case midw_diagnosticsfi_tclToken::EN_F32:   
   case midw_diagnosticsfi_tclToken::EN_F64:   
   case midw_diagnosticsfi_tclToken::EN_BOOL:   
   case midw_diagnosticsfi_tclToken::EN_STRING:   
   case midw_diagnosticsfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(enMsgToken,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_diagnosticsfi_tclDescription::bDoIt(midw_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_diagnosticsfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_diagnosticsfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_diagnosticsfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_diagnosticsfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_diagnosticsfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_diagnosticsfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_diagnosticsfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_LIST: 
      {
         midw_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_diagnosticsfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_diagnosticsfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_diagnosticsfi_tclToken::EN_U8: 
      {
         midw_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_diagnosticsfi_tclToken::EN_U16: 
      {
         midw_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_U24: 
      {
         midw_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_U32: 
      {
         midw_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_U64: 
      {
         midw_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_S8: 
      {
         midw_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_S16: 
      {
         midw_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_S24: 
      {
         midw_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_S32: 
      {
         midw_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_S64: 
      {
         midw_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_F32: 
      {
         midw_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_F64: 
      {
         midw_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_BOOL: 
      {
         midw_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_STRING: 
      {
         midw_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_diagnosticsfi_tclToken::EN_MSG_TESTMESSAGEMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_TESTMESSAGEMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGREQUESTMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGREQUESTMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_READDIAGLOGMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_READDIAGLOGMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDIAGLOGMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDIAGLOGMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_STARTDIAGNOSTICTESTMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_STARTDIAGNOSTICTESTMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETDEFAULTSETTINGSMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETDEFAULTSETTINGSMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_ENABLETIMESLOTMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_ENABLETIMESLOTMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_STOPDIAGNOSTICTESTMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_STOPDIAGNOSTICTESTMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETRESETTOSUPPLIERDEFAULTCONFIGMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETRESETTOSUPPLIERDEFAULTCONFIGMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETRUNTIMESOURCEDATAMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETRUNTIMESOURCEDATAMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_STARTCALIBRATIONSESSIONMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_STARTCALIBRATIONSESSIONMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_STOPCALIBRATIONSESSIONMETHODSTART:
      case midw_diagnosticsfi_tclToken::EN_MSG_STOPCALIBRATIONSESSIONMETHODRESULT:
      case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALESET:
      case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALEUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALERELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALESTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_CONFIGUPDATEVIAUSBSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMISET:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMIUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMIRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMISTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHURELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZESET:
      case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZEUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZERELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZESTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_LANGUAGEGET:
      case midw_diagnosticsfi_tclToken::EN_MSG_LANGUAGESTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_SPEEDLOCKGET:
      case midw_diagnosticsfi_tclToken::EN_MSG_SPEEDLOCKSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_SPDLOCKSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_SPDLOCKSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALGET:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYGET:
      case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMGET:
      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSGET:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLGET:
      case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSRELUPREG:
      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERGET:
      case midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERSTATUS:
      case midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERGET:
      case midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERSET:
      case midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_diagnosticsfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_LIST,midw_diagnosticsfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_DIAGPROTOCOL:
      {
         midw_fi_tcl_DiagProtocol o_DiagProtocol;
         if (!bDoIt(o_DiagProtocol))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_STORE:
      {
         midw_fi_tcl_e8_Store o_e8_Store;
         if (!bDoIt(o_e8_Store))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_ROUTECALCULATIONCOMMAND:
      {
         midw_fi_tcl_e8_RouteCalculationCommand o_e8_RouteCalculationCommand;
         if (!bDoIt(o_e8_RouteCalculationCommand))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_ROUTECALCULATIONSTATUS:
      {
         midw_fi_tcl_e8_RouteCalculationStatus o_e8_RouteCalculationStatus;
         if (!bDoIt(o_e8_RouteCalculationStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_LANGUAGE:
      {
         midw_fi_tcl_e8_Language o_e8_Language;
         if (!bDoIt(o_e8_Language))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_COUNTRY:
      {
         midw_fi_tcl_e8_Country o_e8_Country;
         if (!bDoIt(o_e8_Country))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_LANGUAGESUBSYSTEM:
      {
         midw_fi_tcl_e8_LanguageSubsystem o_e8_LanguageSubsystem;
         if (!bDoIt(o_e8_LanguageSubsystem))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_TESTSCREENS:
      {
         midw_fi_tcl_e8_TestScreens o_e8_TestScreens;
         if (!bDoIt(o_e8_TestScreens))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_DISPLAYSTRINGSLIST:
      {
      if (poVisitor->bDoExpand_DisplayStringsList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_STRING,midw_diagnosticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_LIST,midw_diagnosticsfi_tclSemanticDomain::EN_STRINGLIST));
      }
      else
      {
         midw_fi_tcl_DisplayStringsList o_DisplayStringsList;
         if (!bDoIt(o_DisplayStringsList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DisplayStringsList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DisplayStringsList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_DISPLAYDATA:
      {
      if (poVisitor->bDoExpand_DisplayData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_DISPLAYSTRINGSLIST,midw_diagnosticsfi_tclSemanticDomain::EN_DISPLAYSTRINGS));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_TESTSCREENS,midw_diagnosticsfi_tclSemanticDomain::EN_TESTSCREEN));
      }
      else
      {
         midw_fi_tcl_DisplayData o_DisplayData;
         if (!bDoIt(o_DisplayData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DisplayData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DisplayData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_TROUBLECODETYPE:
      {
         midw_fi_tcl_e8_TroubleCodeType o_e8_TroubleCodeType;
         if (!bDoIt(o_e8_TroubleCodeType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_TESTROUTINES:
      {
         midw_fi_tcl_e8_TestRoutines o_e8_TestRoutines;
         if (!bDoIt(o_e8_TestRoutines))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_DEFAULTSETTINGSCATEGORIES:
      {
         midw_fi_tcl_e8_DefaultSettingsCategories o_e8_DefaultSettingsCategories;
         if (!bDoIt(o_e8_DefaultSettingsCategories))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_COUNTRYLANGUAGE:
      {
      if (poVisitor->bDoExpand_CountryLanguage(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_LANGUAGESUBSYSTEM,midw_diagnosticsfi_tclSemanticDomain::EN_SUBSYSTEM));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_LANGUAGE,midw_diagnosticsfi_tclSemanticDomain::EN_LANGUAGE));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_COUNTRY,midw_diagnosticsfi_tclSemanticDomain::EN_COUNTRY));
      }
      else
      {
         midw_fi_tcl_CountryLanguage o_CountryLanguage;
         if (!bDoIt(o_CountryLanguage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryLanguage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryLanguage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_COUNTRYLANGUAGERESULT:
      {
      if (poVisitor->bDoExpand_CountryLanguageResult(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_COUNTRYLANGUAGE,midw_diagnosticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_LIST,midw_diagnosticsfi_tclSemanticDomain::EN_COUNTRYLANGUAGELIST));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_BOOL,midw_diagnosticsfi_tclSemanticDomain::EN_SUCCESS));
      }
      else
      {
         midw_fi_tcl_CountryLanguageResult o_CountryLanguageResult;
         if (!bDoIt(o_CountryLanguageResult))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryLanguageResult.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryLanguageResult.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_TROUBLECODESTATUS:
      {
         midw_fi_tcl_e8_TroubleCodeStatus o_e8_TroubleCodeStatus;
         if (!bDoIt(o_e8_TroubleCodeStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_TROUBLECODE:
      {
      if (poVisitor->bDoExpand_TroubleCode(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_TROUBLECODESTATUS,midw_diagnosticsfi_tclSemanticDomain::EN_STATUS));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_TROUBLECODE));
      }
      else
      {
         midw_fi_tcl_TroubleCode o_TroubleCode;
         if (!bDoIt(o_TroubleCode))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TroubleCode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TroubleCode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_TROUBLECODELIST:
      {
      if (poVisitor->bDoExpand_TroubleCodeList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_TROUBLECODE,midw_diagnosticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_LIST,midw_diagnosticsfi_tclSemanticDomain::EN_TROUBLECODELIST));
      }
      else
      {
         midw_fi_tcl_TroubleCodeList o_TroubleCodeList;
         if (!bDoIt(o_TroubleCodeList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TroubleCodeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TroubleCodeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_ROUTECALCULATIONSTARTPARAMETER:
      {
      if (poVisitor->bDoExpand_RouteCalculationStartParameter(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_ROUTECALCULATIONCOMMAND,midw_diagnosticsfi_tclSemanticDomain::EN_COMMAND));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_ROUTEOPTIMISATION));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_ROUTEINDEX));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_S32,midw_diagnosticsfi_tclSemanticDomain::EN_DESTINATIONLATITUDE));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_S32,midw_diagnosticsfi_tclSemanticDomain::EN_DESTINATIONLONGITUDE));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_S32,midw_diagnosticsfi_tclSemanticDomain::EN_CURRENTPOSITIONLATITUDE));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_S32,midw_diagnosticsfi_tclSemanticDomain::EN_CURRENTPOSITIONLONGITUDE));
      }
      else
      {
         midw_fi_tcl_RouteCalculationStartParameter o_RouteCalculationStartParameter;
         if (!bDoIt(o_RouteCalculationStartParameter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteCalculationStartParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteCalculationStartParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_ROUTECALCULATIONRESULTPARAMETER:
      {
      if (poVisitor->bDoExpand_RouteCalculationResultParameter(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_ROUTEDURATION));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U32,midw_diagnosticsfi_tclSemanticDomain::EN_ROUTELENGTH));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_ROUTECALCULATIONSTATUS,midw_diagnosticsfi_tclSemanticDomain::EN_ROUTECALCULATIONSTATUS));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_E8_ROUTECALCULATIONCOMMAND,midw_diagnosticsfi_tclSemanticDomain::EN_COMMAND));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_ROUTEOPTIMISATION));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_ROUTEINDEX));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_S32,midw_diagnosticsfi_tclSemanticDomain::EN_DESTINATIONLATITUDE));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_S32,midw_diagnosticsfi_tclSemanticDomain::EN_DESTINATIONLONGITUDE));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_S32,midw_diagnosticsfi_tclSemanticDomain::EN_CURRENTPOSITIONLATITUDE));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_S32,midw_diagnosticsfi_tclSemanticDomain::EN_CURRENTPOSITIONLONGITUDE));
      }
      else
      {
         midw_fi_tcl_RouteCalculationResultParameter o_RouteCalculationResultParameter;
         if (!bDoIt(o_RouteCalculationResultParameter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteCalculationResultParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteCalculationResultParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_E16_LANGUAGE:
      {
         midw_fi_tcl_e16_Language o_e16_Language;
         if (!bDoIt(o_e16_Language))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E16_SPEEDLOCK:
      {
         midw_fi_tcl_e16_SpeedLock o_e16_SpeedLock;
         if (!bDoIt(o_e16_SpeedLock))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_MESSAGEBUFFER:
      {
      if (poVisitor->bDoExpand_MessageBuffer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_LIST,midw_diagnosticsfi_tclSemanticDomain::EN_MESSAGEBUFFER));
      }
      else
      {
         midw_fi_tcl_MessageBuffer o_MessageBuffer;
         if (!bDoIt(o_MessageBuffer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MessageBuffer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MessageBuffer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_DEFSETMODE:
      {
         midw_fi_tcl_e8_DefSetMode o_e8_DefSetMode;
         if (!bDoIt(o_e8_DefSetMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_DEFSETSERVICESTATUS:
      {
         midw_fi_tcl_e8_DefSetServiceStatus o_e8_DefSetServiceStatus;
         if (!bDoIt(o_e8_DefSetServiceStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_DIAGMAUSSETUP:
      {
         midw_fi_tcl_e8_DiagMausSetup o_e8_DiagMausSetup;
         if (!bDoIt(o_e8_DiagMausSetup))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_SIMULATEDKEYS:
      {
         midw_fi_tcl_e8_SimulatedKeys o_e8_SimulatedKeys;
         if (!bDoIt(o_e8_SimulatedKeys))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_KDSITEMLIST:
      {
      if (poVisitor->bDoExpand_KDSItemList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_LIST,midw_diagnosticsfi_tclSemanticDomain::EN_ITEMLIST));
      }
      else
      {
         midw_fi_tcl_KDSItemList o_KDSItemList;
         if (!bDoIt(o_KDSItemList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_KDSItemList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_KDSItemList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_CONFIGITEMLIST:
      {
      if (poVisitor->bDoExpand_ConfigItemList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_LIST,midw_diagnosticsfi_tclSemanticDomain::EN_ITEMLIST));
      }
      else
      {
         midw_fi_tcl_ConfigItemList o_ConfigItemList;
         if (!bDoIt(o_ConfigItemList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ConfigItemList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ConfigItemList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_DIAGDATA:
      {
      if (poVisitor->bDoExpand_DiagData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_LIST,midw_diagnosticsfi_tclSemanticDomain::EN_ITEMLIST));
      }
      else
      {
         midw_fi_tcl_DiagData o_DiagData;
         if (!bDoIt(o_DiagData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_RCTRLSOURCE:
      {
         midw_fi_tcl_e8_RCtrlSource o_e8_RCtrlSource;
         if (!bDoIt(o_e8_RCtrlSource))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_RCTRLCOMMAND:
      {
         midw_fi_tcl_e8_RCtrlCommand o_e8_RCtrlCommand;
         if (!bDoIt(o_e8_RCtrlCommand))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_RCTRLSIGNAL:
      {
         midw_fi_tcl_e8_RCtrlSignal o_e8_RCtrlSignal;
         if (!bDoIt(o_e8_RCtrlSignal))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_DIAGRVCSIGNAL:
      {
         midw_fi_tcl_e8_DiagRVCSignal o_e8_DiagRVCSignal;
         if (!bDoIt(o_e8_DiagRVCSignal))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_CALIBRATIONTABLE:
      {
         midw_fi_tcl_e8_CalibrationTable o_e8_CalibrationTable;
         if (!bDoIt(o_e8_CalibrationTable))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_CALIBRATIONVALUE:
      {
      if (poVisitor->bDoExpand_CalibrationValue(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_LIST,midw_diagnosticsfi_tclSemanticDomain::EN_BYTEVALUE));
      }
      else
      {
         midw_fi_tcl_CalibrationValue o_CalibrationValue;
         if (!bDoIt(o_CalibrationValue))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CalibrationValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CalibrationValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_CALIBRATIONTIMESTAMP:
      {
      if (poVisitor->bDoExpand_CalibrationTimeStamp(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_YEAR));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MONTH));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_DAY));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_SECONDS));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_MINUTES));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_HOURS));
      }
      else
      {
         midw_fi_tcl_CalibrationTimeStamp o_CalibrationTimeStamp;
         if (!bDoIt(o_CalibrationTimeStamp))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CalibrationTimeStamp.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CalibrationTimeStamp.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_ALPHACODE:
      {
      if (poVisitor->bDoExpand_AlphaCode(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_END_OF_STRUCT,midw_diagnosticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_U8,midw_diagnosticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diagnosticsfi_tclKnot(midw_diagnosticsfi_tclToken::EN_LIST,midw_diagnosticsfi_tclSemanticDomain::EN_LETTER));
      }
      else
      {
         midw_fi_tcl_AlphaCode o_AlphaCode;
         if (!bDoIt(o_AlphaCode))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AlphaCode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AlphaCode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_CALIBRATIONPARAMETERSIZE:
      {
         midw_fi_tcl_e8_CalibrationParameterSize o_e8_CalibrationParameterSize;
         if (!bDoIt(o_e8_CalibrationParameterSize))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_E8_KDSVIAUSBUPDATESTATUS:
      {
         midw_fi_tcl_e8_KdsViaUsbUpdateStatus o_e8_KdsViaUsbUpdateStatus;
         if (!bDoIt(o_e8_KdsViaUsbUpdateStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_ANTITHEFTSTATUS:
      {
         midw_fi_tcl_AntiTheftStatus o_AntiTheftStatus;
         if (!bDoIt(o_AntiTheftStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diagnosticsfi_tclToken::EN_UNKNOWN:
      case midw_diagnosticsfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

