/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_DIAGLOGFITYPES_HEADER
#define MIDW_DIAGLOGFITYPES_HEADER


class midw_diaglogfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for Midw_DiagLog_FI message types

fi_tclMessageBase* midw_diaglogfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_diaglogfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_diaglogfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_diaglogfi_tclMsgSaveTestResultMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSaveTestResultMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgSaveTestResultMethodStart& operator=(const midw_diaglogfi_tclMsgSaveTestResultMethodStart& coRef);
   midw_diaglogfi_tclMsgSaveTestResultMethodStart(const midw_diaglogfi_tclMsgSaveTestResultMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TestResultList TestResultList;
   virtual ~midw_diaglogfi_tclMsgSaveTestResultMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgSaveTestResultMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgSaveTestResultMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSaveTestResultMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgSaveTestResultMethodResult& operator=(const midw_diaglogfi_tclMsgSaveTestResultMethodResult& coRef);
   midw_diaglogfi_tclMsgSaveTestResultMethodResult(const midw_diaglogfi_tclMsgSaveTestResultMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgSaveTestResultMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgSaveTestResultMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart& operator=(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart& coRef);
   midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TestResultList TestResultList;
   virtual ~midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult& operator=(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult& coRef);
   midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgProductionReadRequestMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgProductionReadRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgProductionReadRequestMethodStart& operator=(const midw_diaglogfi_tclMsgProductionReadRequestMethodStart& coRef);
   midw_diaglogfi_tclMsgProductionReadRequestMethodStart(const midw_diaglogfi_tclMsgProductionReadRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Protocol Protocol;
   tU8 StatusMask;
   tU32 ITCMask;
   tU32 Option;
   virtual ~midw_diaglogfi_tclMsgProductionReadRequestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgProductionReadRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgProductionReadRequestMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgProductionReadRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgProductionReadRequestMethodResult& operator=(const midw_diaglogfi_tclMsgProductionReadRequestMethodResult& coRef);
   midw_diaglogfi_tclMsgProductionReadRequestMethodResult(const midw_diaglogfi_tclMsgProductionReadRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_ProductionReadResultList ProductionReadResultList;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgProductionReadRequestMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgProductionReadRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgCustomerReadRequestMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgCustomerReadRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgCustomerReadRequestMethodStart& operator=(const midw_diaglogfi_tclMsgCustomerReadRequestMethodStart& coRef);
   midw_diaglogfi_tclMsgCustomerReadRequestMethodStart(const midw_diaglogfi_tclMsgCustomerReadRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Protocol Protocol;
   tU8 StatusMask;
   tU32 DTCMask;
   tU32 Option;
   virtual ~midw_diaglogfi_tclMsgCustomerReadRequestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgCustomerReadRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgCustomerReadRequestMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgCustomerReadRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgCustomerReadRequestMethodResult& operator=(const midw_diaglogfi_tclMsgCustomerReadRequestMethodResult& coRef);
   midw_diaglogfi_tclMsgCustomerReadRequestMethodResult(const midw_diaglogfi_tclMsgCustomerReadRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_CustomerReadResultList CustomerReadResultList;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgCustomerReadRequestMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgCustomerReadRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetItcInformationMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetItcInformationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetItcInformationMethodStart& operator=(const midw_diaglogfi_tclMsggetItcInformationMethodStart& coRef);
   midw_diaglogfi_tclMsggetItcInformationMethodStart(const midw_diaglogfi_tclMsggetItcInformationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   std::vector<tU16, std::allocator<tU16> > ITCList;
   virtual ~midw_diaglogfi_tclMsggetItcInformationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetItcInformationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetItcInformationMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetItcInformationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetItcInformationMethodResult& operator=(const midw_diaglogfi_tclMsggetItcInformationMethodResult& coRef);
   midw_diaglogfi_tclMsggetItcInformationMethodResult(const midw_diaglogfi_tclMsggetItcInformationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_ITC_Information, std::allocator<midw_fi_tcl_ITC_Information> > ItcInformationList;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsggetItcInformationMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetItcInformationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgProductionClearRequestMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgProductionClearRequestMethodStart();

   virtual ~midw_diaglogfi_tclMsgProductionClearRequestMethodStart();

   inline tBool operator==(const midw_diaglogfi_tclMsgProductionClearRequestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgProductionClearRequestMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgProductionClearRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgProductionClearRequestMethodResult& operator=(const midw_diaglogfi_tclMsgProductionClearRequestMethodResult& coRef);
   midw_diaglogfi_tclMsgProductionClearRequestMethodResult(const midw_diaglogfi_tclMsgProductionClearRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgProductionClearRequestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgProductionClearRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgCustomerClearRequestMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgCustomerClearRequestMethodStart();

   virtual ~midw_diaglogfi_tclMsgCustomerClearRequestMethodStart();

   inline tBool operator==(const midw_diaglogfi_tclMsgCustomerClearRequestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgCustomerClearRequestMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgCustomerClearRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgCustomerClearRequestMethodResult& operator=(const midw_diaglogfi_tclMsgCustomerClearRequestMethodResult& coRef);
   midw_diaglogfi_tclMsgCustomerClearRequestMethodResult(const midw_diaglogfi_tclMsgCustomerClearRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgCustomerClearRequestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgCustomerClearRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgWriteToMediaMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgWriteToMediaMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgWriteToMediaMethodStart& operator=(const midw_diaglogfi_tclMsgWriteToMediaMethodStart& coRef);
   midw_diaglogfi_tclMsgWriteToMediaMethodStart(const midw_diaglogfi_tclMsgWriteToMediaMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_VDLMediaType Media;
   virtual ~midw_diaglogfi_tclMsgWriteToMediaMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgWriteToMediaMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgWriteToMediaMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgWriteToMediaMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgWriteToMediaMethodResult& operator=(const midw_diaglogfi_tclMsgWriteToMediaMethodResult& coRef);
   midw_diaglogfi_tclMsgWriteToMediaMethodResult(const midw_diaglogfi_tclMsgWriteToMediaMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgWriteToMediaMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgWriteToMediaMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart& operator=(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart& coRef);
   midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU8 StatusMask;
   tU32 DTCMask;
   virtual ~midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult& operator=(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult& coRef);
   midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 StatusAvailabilityMask;
   midw_fi_tcl_ReadResultList ReadResultList;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart& operator=(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart& coRef);
   midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   virtual ~midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult& operator=(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult& coRef);
   midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 StatusAvailabilityMask;
   midw_fi_tcl_ReadResultList ReadResultList;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetSupportedDTCMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetSupportedDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetSupportedDTCMethodStart& operator=(const midw_diaglogfi_tclMsggetSupportedDTCMethodStart& coRef);
   midw_diaglogfi_tclMsggetSupportedDTCMethodStart(const midw_diaglogfi_tclMsggetSupportedDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   virtual ~midw_diaglogfi_tclMsggetSupportedDTCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetSupportedDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetSupportedDTCMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetSupportedDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetSupportedDTCMethodResult& operator=(const midw_diaglogfi_tclMsggetSupportedDTCMethodResult& coRef);
   midw_diaglogfi_tclMsggetSupportedDTCMethodResult(const midw_diaglogfi_tclMsggetSupportedDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 StatusAvailabilityMask;
   midw_fi_tcl_ReadResultList ReadResultList;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsggetSupportedDTCMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetSupportedDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& operator=(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& coRef);
   midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU8 StatusMask;
   tU32 DTCMask;
   virtual ~midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& operator=(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& coRef);
   midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 StatusAvailabilityMask;
   tU32 NumberOfDTC;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetStatusByDTCMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetStatusByDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetStatusByDTCMethodStart& operator=(const midw_diaglogfi_tclMsggetStatusByDTCMethodStart& coRef);
   midw_diaglogfi_tclMsggetStatusByDTCMethodStart(const midw_diaglogfi_tclMsggetStatusByDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTCMask;
   virtual ~midw_diaglogfi_tclMsggetStatusByDTCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetStatusByDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetStatusByDTCMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetStatusByDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetStatusByDTCMethodResult& operator=(const midw_diaglogfi_tclMsggetStatusByDTCMethodResult& coRef);
   midw_diaglogfi_tclMsggetStatusByDTCMethodResult(const midw_diaglogfi_tclMsggetStatusByDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 StatusAvailabilityMask;
   midw_fi_tcl_ReadResultList ReadResultList;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsggetStatusByDTCMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetStatusByDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart& operator=(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart& coRef);
   midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTC;
   tU8 DTCExtDataRecordNumber;
   virtual ~midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult& operator=(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult& coRef);
   midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DTC;
   tU8 StatusOfDtc;
   midw_fi_tcl_FreezeFrameList FreezeFrameList;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetStatusByITCMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetStatusByITCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetStatusByITCMethodStart& operator=(const midw_diaglogfi_tclMsggetStatusByITCMethodStart& coRef);
   midw_diaglogfi_tclMsggetStatusByITCMethodStart(const midw_diaglogfi_tclMsggetStatusByITCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 ITCMask;
   virtual ~midw_diaglogfi_tclMsggetStatusByITCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetStatusByITCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsggetStatusByITCMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsggetStatusByITCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsggetStatusByITCMethodResult& operator=(const midw_diaglogfi_tclMsggetStatusByITCMethodResult& coRef);
   midw_diaglogfi_tclMsggetStatusByITCMethodResult(const midw_diaglogfi_tclMsggetStatusByITCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_ReadResultList ReadResultList;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsggetStatusByITCMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsggetStatusByITCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart& operator=(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart& coRef);
   midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   virtual ~midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult& operator=(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult& coRef);
   midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_SnapshotIdentificationList SnapshotIdentificationList;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& operator=(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& coRef);
   midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTC;
   tU8 DTCSnapshotRecordNumber;
   virtual ~midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& operator=(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& coRef);
   midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DTC;
   tU8 StatusOfDtc;
   midw_fi_tcl_SnapshotDataList SnapshotDataList;
   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgclearDTCMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgclearDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgclearDTCMethodStart& operator=(const midw_diaglogfi_tclMsgclearDTCMethodStart& coRef);
   midw_diaglogfi_tclMsgclearDTCMethodStart(const midw_diaglogfi_tclMsgclearDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTCMask;
   virtual ~midw_diaglogfi_tclMsgclearDTCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgclearDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgclearDTCMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgclearDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgclearDTCMethodResult& operator=(const midw_diaglogfi_tclMsgclearDTCMethodResult& coRef);
   midw_diaglogfi_tclMsgclearDTCMethodResult(const midw_diaglogfi_tclMsgclearDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgclearDTCMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgclearDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgControlMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgControlMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgControlMethodStart& operator=(const midw_diaglogfi_tclMsgControlMethodStart& coRef);
   midw_diaglogfi_tclMsgControlMethodStart(const midw_diaglogfi_tclMsgControlMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ControlParameter ControlParameter;
   virtual ~midw_diaglogfi_tclMsgControlMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgControlMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgControlMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgControlMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgControlMethodResult& operator=(const midw_diaglogfi_tclMsgControlMethodResult& coRef);
   midw_diaglogfi_tclMsgControlMethodResult(const midw_diaglogfi_tclMsgControlMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgControlMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgControlMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgControlDtcSettingMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgControlDtcSettingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgControlDtcSettingMethodStart& operator=(const midw_diaglogfi_tclMsgControlDtcSettingMethodStart& coRef);
   midw_diaglogfi_tclMsgControlDtcSettingMethodStart(const midw_diaglogfi_tclMsgControlDtcSettingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ControlParameter ControlParameter;
   midw_fi_tcl_ControlList DTC_List;
   virtual ~midw_diaglogfi_tclMsgControlDtcSettingMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgControlDtcSettingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgControlDtcSettingMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgControlDtcSettingMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgControlDtcSettingMethodResult& operator=(const midw_diaglogfi_tclMsgControlDtcSettingMethodResult& coRef);
   midw_diaglogfi_tclMsgControlDtcSettingMethodResult(const midw_diaglogfi_tclMsgControlDtcSettingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MethodResultReply Status;
   virtual ~midw_diaglogfi_tclMsgControlDtcSettingMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgControlDtcSettingMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart& operator=(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart& coRef);
   midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DiaglogDefsetType DefSetStateGroup;
   midw_fi_tcl_e8_DefSetMode DefSetStateMode;
   virtual ~midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult& operator=(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult& coRef);
   midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DiaglogDefsetType DefSetStateGroup;
   midw_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool DefSetStateSuccessful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgDTCActiveGet : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgDTCActiveGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgDTCActiveGet& operator=(const midw_diaglogfi_tclMsgDTCActiveGet& coRef);
   midw_diaglogfi_tclMsgDTCActiveGet(const midw_diaglogfi_tclMsgDTCActiveGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool IsDTCActive;
   virtual ~midw_diaglogfi_tclMsgDTCActiveGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgDTCActiveGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgDTCActiveUpReg : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgDTCActiveUpReg();

   virtual ~midw_diaglogfi_tclMsgDTCActiveUpReg();

   inline tBool operator==(const midw_diaglogfi_tclMsgDTCActiveUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgDTCActiveRelUpReg : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgDTCActiveRelUpReg();

   virtual ~midw_diaglogfi_tclMsgDTCActiveRelUpReg();

   inline tBool operator==(const midw_diaglogfi_tclMsgDTCActiveRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgDTCActiveStatus : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgDTCActiveStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgDTCActiveStatus& operator=(const midw_diaglogfi_tclMsgDTCActiveStatus& coRef);
   midw_diaglogfi_tclMsgDTCActiveStatus(const midw_diaglogfi_tclMsgDTCActiveStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool IsDTCActive;
   tU32 DTC;
   tU8 DTCStatus;
   tU8 DTCFailureType;
   virtual ~midw_diaglogfi_tclMsgDTCActiveStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgDTCActiveStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgSendNextTestResultUpReg : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSendNextTestResultUpReg();

   virtual ~midw_diaglogfi_tclMsgSendNextTestResultUpReg();

   inline tBool operator==(const midw_diaglogfi_tclMsgSendNextTestResultUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgSendNextTestResultRelUpReg : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSendNextTestResultRelUpReg();

   virtual ~midw_diaglogfi_tclMsgSendNextTestResultRelUpReg();

   inline tBool operator==(const midw_diaglogfi_tclMsgSendNextTestResultRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgSendNextTestResultStatus : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSendNextTestResultStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgSendNextTestResultStatus& operator=(const midw_diaglogfi_tclMsgSendNextTestResultStatus& coRef);
   midw_diaglogfi_tclMsgSendNextTestResultStatus(const midw_diaglogfi_tclMsgSendNextTestResultStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct;
   tBool Status;
   virtual ~midw_diaglogfi_tclMsgSendNextTestResultStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgSendNextTestResultStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgDTCTriggeredUpReg : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgDTCTriggeredUpReg();

   virtual ~midw_diaglogfi_tclMsgDTCTriggeredUpReg();

   inline tBool operator==(const midw_diaglogfi_tclMsgDTCTriggeredUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgDTCTriggeredRelUpReg : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgDTCTriggeredRelUpReg();

   virtual ~midw_diaglogfi_tclMsgDTCTriggeredRelUpReg();

   inline tBool operator==(const midw_diaglogfi_tclMsgDTCTriggeredRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgDTCTriggeredGet : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgDTCTriggeredGet();

   virtual ~midw_diaglogfi_tclMsgDTCTriggeredGet();

   inline tBool operator==(const midw_diaglogfi_tclMsgDTCTriggeredGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgDTCTriggeredStatus : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgDTCTriggeredStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgDTCTriggeredStatus& operator=(const midw_diaglogfi_tclMsgDTCTriggeredStatus& coRef);
   midw_diaglogfi_tclMsgDTCTriggeredStatus(const midw_diaglogfi_tclMsgDTCTriggeredStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDTCTriggeredFlag;
   tU8 u8DTCSource;
   tU16 u16DTCNumber;
   tU8 u8DTCFailureType;
   tBool bDTCWarningIndicatorRequestedStatus;
   tBool bDTCTestFailedSincePowerUpStatus;
   tBool bDTCTestNotPassedSincePowerUpStatus;
   tBool bDTCHistoryStatus;
   tBool bDTCTestFailedSinceCodeClearedStatus;
   tBool bDTCTestNotPassedSinceCodeClearedStatus;
   tBool bDTCCurrentStatus;
   tBool bDTCCodeSupported;
   midw_fi_tcl_e8_GMLnGWDTCFaultType e8DTCFaultType;
   virtual ~midw_diaglogfi_tclMsgDTCTriggeredStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgDTCTriggeredStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgSendActiveDTCListUpReg : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSendActiveDTCListUpReg();

   virtual ~midw_diaglogfi_tclMsgSendActiveDTCListUpReg();

   inline tBool operator==(const midw_diaglogfi_tclMsgSendActiveDTCListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgSendActiveDTCListRelUpReg : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSendActiveDTCListRelUpReg();

   virtual ~midw_diaglogfi_tclMsgSendActiveDTCListRelUpReg();

   inline tBool operator==(const midw_diaglogfi_tclMsgSendActiveDTCListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgSendActiveDTCListStatus : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgSendActiveDTCListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgSendActiveDTCListStatus& operator=(const midw_diaglogfi_tclMsgSendActiveDTCListStatus& coRef);
   midw_diaglogfi_tclMsgSendActiveDTCListStatus(const midw_diaglogfi_tclMsgSendActiveDTCListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_ActiveDTCList ActiveDTCList;
   virtual ~midw_diaglogfi_tclMsgSendActiveDTCListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgSendActiveDTCListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgDtcStatusChangedUpReg : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgDtcStatusChangedUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgDtcStatusChangedUpReg& operator=(const midw_diaglogfi_tclMsgDtcStatusChangedUpReg& coRef);
   midw_diaglogfi_tclMsgDtcStatusChangedUpReg(const midw_diaglogfi_tclMsgDtcStatusChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTCNumber;
   tU8 DTCStatusBitMask;
   virtual ~midw_diaglogfi_tclMsgDtcStatusChangedUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgDtcStatusChangedUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg& operator=(const midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg& coRef);
   midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg(const midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTCNumber;
   tU8 DTCStatusBitMask;
   virtual ~midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglogfi_tclMsgDtcStatusChangedStatus : public midw_diaglogfi_tclMsgBaseMessage
{
public:

   midw_diaglogfi_tclMsgDtcStatusChangedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglogfi_tclMsgDtcStatusChangedStatus& operator=(const midw_diaglogfi_tclMsgDtcStatusChangedStatus& coRef);
   midw_diaglogfi_tclMsgDtcStatusChangedStatus(const midw_diaglogfi_tclMsgDtcStatusChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_ReadResultStructure DTCResponse;
   virtual ~midw_diaglogfi_tclMsgDtcStatusChangedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglogfi_tclMsgDtcStatusChangedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
