#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_STDVISITORS
#include "midw_fi_gen_if.h"

tBool midw_diaglogfi_tclDescription::bInitMessage(midw_diaglogfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_diaglogfi_tclToken::EN_LAST_TOKEN:
   case midw_diaglogfi_tclToken::EN_LIST:
   case midw_diaglogfi_tclToken::EN_END_OF_STRUCT:
   case midw_diaglogfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_TESTRESULTLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_TESTRESULTLIST)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_TESTRESULTLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_TESTRESULTLIST)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_OPTION)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_ITCMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUSMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_PROTOCOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_PROTOCOL)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_PRODUCTIONREADRESULTLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_PRODUCTIONREADRESULTLIST)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_OPTION)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUSMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_PROTOCOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_PROTOCOL)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_CUSTOMERREADRESULTLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_CUSTOMERREADRESULTLIST)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U16,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_ITCLIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_ITC_INFORMATION,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_ITCINFORMATIONLIST)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_WRITETOMEDIAMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_VDLMEDIATYPE,midw_diaglogfi_tclSemanticDomain::EN_MSG_MEDIA)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_WRITETOMEDIAMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUSMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_READRESULTLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_READRESULTLIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUSAVAILABILITYMASK)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_READRESULTLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_READRESULTLIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUSAVAILABILITYMASK)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_READRESULTLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_READRESULTLIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUSAVAILABILITYMASK)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUSMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_NUMBEROFDTC)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUSAVAILABILITYMASK)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_READRESULTLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_READRESULTLIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUSAVAILABILITYMASK)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCEXTDATARECORDNUMBER)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTC)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_FREEZEFRAMELIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_FREEZEFRAMELIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUSOFDTC)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTC)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_ITCMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_READRESULTLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_READRESULTLIST)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_SNAPSHOTIDENTIFICATIONLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_SNAPSHOTIDENTIFICATIONLIST)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCSNAPSHOTRECORDNUMBER)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTC)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_SNAPSHOTDATALIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_SNAPSHOTDATALIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUSOFDTC)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTC)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_CLEARDTCMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_CLEARDTCMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_CONTROLMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_CONTROLPARAMETER,midw_diaglogfi_tclSemanticDomain::EN_MSG_CONTROLPARAMETER)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_CONTROLMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_CONTROLLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTC_LIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_CONTROLPARAMETER,midw_diaglogfi_tclSemanticDomain::EN_MSG_CONTROLPARAMETER)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_DEFSETMODE,midw_diaglogfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_DIAGLOGDEFSETTYPE,midw_diaglogfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U16,midw_diaglogfi_tclSemanticDomain::EN_MSG_DEFSETSTATEFIRSTDIFFERENTPARAMETERID)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_DEFSETSTATESUCCESSFUL)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_DEFSETMODE,midw_diaglogfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_DIAGLOGDEFSETTYPE,midw_diaglogfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVEGET:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_ISDTCACTIVE)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVESTATUS:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCFAILURETYPE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCSTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTC)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_ISDTCACTIVE)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTSTATUS:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_SENDNEXTTESTRESULTSTRUCTURE,midw_diaglogfi_tclSemanticDomain::EN_MSG_NEXTTESTRESULTSTRUCT)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDSTATUS:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_GMLNGWDTCFAULTTYPE,midw_diaglogfi_tclSemanticDomain::EN_MSG_E8DTCFAULTTYPE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_BDTCCODESUPPORTED)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_BDTCCURRENTSTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_BDTCTESTNOTPASSEDSINCECODECLEAREDSTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_BDTCTESTFAILEDSINCECODECLEAREDSTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_BDTCHISTORYSTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_BDTCTESTNOTPASSEDSINCEPOWERUPSTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_BDTCTESTFAILEDSINCEPOWERUPSTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_BDTCWARNINGINDICATORREQUESTEDSTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_U8DTCFAILURETYPE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U16,midw_diaglogfi_tclSemanticDomain::EN_MSG_U16DTCNUMBER)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_U8DTCSOURCE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_MSG_BDTCTRIGGEREDFLAG)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTSTATUS:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_ACTIVEDTCLIST,midw_diaglogfi_tclSemanticDomain::EN_MSG_ACTIVEDTCLIST)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDUPREG:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCSTATUSBITMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCNUMBER)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDRELUPREG:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCSTATUSBITMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCNUMBER)) && bResult;
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_MSG_GROUP)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDSTATUS:
   {
      bResult = oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_READRESULTSTRUCTURE,midw_diaglogfi_tclSemanticDomain::EN_MSG_DTCRESPONSE)) && bResult;
   } break;
   case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODSTART:
   case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODSTART:
   case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVEUPREG:
   case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVERELUPREG:
   case midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTUPREG:
   case midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTRELUPREG:
   case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDUPREG:
   case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDRELUPREG:
   case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDGET:
   case midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTUPREG:
   case midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTRELUPREG:
   case midw_diaglogfi_tclToken::EN_BINCONTAINER:
   case midw_diaglogfi_tclToken::EN_E8_DEFSETMODE:
   case midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY:
   case midw_diaglogfi_tclToken::EN_E8_TESTRESULT:
   case midw_diaglogfi_tclToken::EN_FREEZEFRAMEDATA:
   case midw_diaglogfi_tclToken::EN_FREEZEFRAMELIST:
   case midw_diaglogfi_tclToken::EN_READRESULTSTRUCTURE:
   case midw_diaglogfi_tclToken::EN_READRESULTLIST:
   case midw_diaglogfi_tclToken::EN_ITC_INFORMATION:
   case midw_diaglogfi_tclToken::EN_PRODUCTIONREADRESULTSTRUCTURE:
   case midw_diaglogfi_tclToken::EN_PRODUCTIONREADRESULTLIST:
   case midw_diaglogfi_tclToken::EN_CUSTOMERREADRESULTSTRUCTURE:
   case midw_diaglogfi_tclToken::EN_CUSTOMERREADRESULTLIST:
   case midw_diaglogfi_tclToken::EN_E8_PROTOCOL:
   case midw_diaglogfi_tclToken::EN_TESTRESULT:
   case midw_diaglogfi_tclToken::EN_TESTRESULTLIST:
   case midw_diaglogfi_tclToken::EN_SNAPSHOTDATA:
   case midw_diaglogfi_tclToken::EN_SNAPSHOTDATALIST:
   case midw_diaglogfi_tclToken::EN_SNAPSHOTIDENTIFICATION:
   case midw_diaglogfi_tclToken::EN_SNAPSHOTIDENTIFICATIONLIST:
   case midw_diaglogfi_tclToken::EN_E8_CONTROLPARAMETER:
   case midw_diaglogfi_tclToken::EN_CONTROLLIST:
   case midw_diaglogfi_tclToken::EN_E8_VDLMEDIATYPE:
   case midw_diaglogfi_tclToken::EN_E8_DIAGLOGDEFSETTYPE:
   case midw_diaglogfi_tclToken::EN_E8_SENDNEXTTESTRESREASON:
   case midw_diaglogfi_tclToken::EN_SENDNEXTTESTRESULTSTRUCTURE:
   case midw_diaglogfi_tclToken::EN_E8_GMLNGWDTCFAULTTYPE:
   case midw_diaglogfi_tclToken::EN_ACTIVEDTCLIST:
   case midw_diaglogfi_tclToken::EN_U8:   
   case midw_diaglogfi_tclToken::EN_S8:   
   case midw_diaglogfi_tclToken::EN_U16:   
   case midw_diaglogfi_tclToken::EN_S16:   
   case midw_diaglogfi_tclToken::EN_U24:   
   case midw_diaglogfi_tclToken::EN_S24:   
   case midw_diaglogfi_tclToken::EN_U32:   
   case midw_diaglogfi_tclToken::EN_S32:   
   case midw_diaglogfi_tclToken::EN_U64:   
   case midw_diaglogfi_tclToken::EN_S64:   
   case midw_diaglogfi_tclToken::EN_F32:   
   case midw_diaglogfi_tclToken::EN_F64:   
   case midw_diaglogfi_tclToken::EN_BOOL:   
   case midw_diaglogfi_tclToken::EN_STRING:   
   case midw_diaglogfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(enMsgToken,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_diaglogfi_tclDescription::bDoIt(midw_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_diaglogfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_diaglogfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_diaglogfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_diaglogfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_diaglogfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_diaglogfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_diaglogfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_LIST: 
      {
         midw_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_diaglogfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_diaglogfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_diaglogfi_tclToken::EN_U8: 
      {
         midw_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_diaglogfi_tclToken::EN_U16: 
      {
         midw_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_U24: 
      {
         midw_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_U32: 
      {
         midw_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_U64: 
      {
         midw_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_S8: 
      {
         midw_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_S16: 
      {
         midw_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_S24: 
      {
         midw_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_S32: 
      {
         midw_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_S64: 
      {
         midw_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_F32: 
      {
         midw_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_F64: 
      {
         midw_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_BOOL: 
      {
         midw_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_STRING: 
      {
         midw_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_WRITETOMEDIAMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_WRITETOMEDIAMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_CLEARDTCMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_CLEARDTCMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_CONTROLMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_CONTROLMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART:
      case midw_diaglogfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT:
      case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVEGET:
      case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVEUPREG:
      case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVERELUPREG:
      case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVESTATUS:
      case midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTUPREG:
      case midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTRELUPREG:
      case midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTSTATUS:
      case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDUPREG:
      case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDRELUPREG:
      case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDGET:
      case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDSTATUS:
      case midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTUPREG:
      case midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTRELUPREG:
      case midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTSTATUS:
      case midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDUPREG:
      case midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDRELUPREG:
      case midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_diaglogfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_E8_DEFSETMODE:
      {
         midw_fi_tcl_e8_DefSetMode o_e8_DefSetMode;
         if (!bDoIt(o_e8_DefSetMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_E8_METHODRESULTREPLY:
      {
         midw_fi_tcl_e8_MethodResultReply o_e8_MethodResultReply;
         if (!bDoIt(o_e8_MethodResultReply))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_E8_TESTRESULT:
      {
         midw_fi_tcl_e8_TestResult o_e8_TestResult;
         if (!bDoIt(o_e8_TestResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_FREEZEFRAMEDATA:
      {
      if (poVisitor->bDoExpand_FreezeFrameData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_DATA));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         midw_fi_tcl_FreezeFrameData o_FreezeFrameData;
         if (!bDoIt(o_FreezeFrameData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FreezeFrameData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FreezeFrameData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_FREEZEFRAMELIST:
      {
      if (poVisitor->bDoExpand_FreezeFrameList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_FREEZEFRAMEDATA,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_FREEZEFRAMEDATALIST));
      }
      else
      {
         midw_fi_tcl_FreezeFrameList o_FreezeFrameList;
         if (!bDoIt(o_FreezeFrameList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FreezeFrameList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FreezeFrameList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_READRESULTSTRUCTURE:
      {
      if (poVisitor->bDoExpand_ReadResultStructure(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_STATUSOFDTC));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_DTC));
      }
      else
      {
         midw_fi_tcl_ReadResultStructure o_ReadResultStructure;
         if (!bDoIt(o_ReadResultStructure))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReadResultStructure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReadResultStructure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_READRESULTLIST:
      {
      if (poVisitor->bDoExpand_ReadResultList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_READRESULTSTRUCTURE,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_DTCLIST));
      }
      else
      {
         midw_fi_tcl_ReadResultList o_ReadResultList;
         if (!bDoIt(o_ReadResultList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReadResultList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReadResultList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_ITC_INFORMATION:
      {
      if (poVisitor->bDoExpand_ITC_Information(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_OCCURENCECOUNTER));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_AGEINGCOUNTER));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_STATUSOFITC));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_DTC));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U16,midw_diaglogfi_tclSemanticDomain::EN_ITC));
      }
      else
      {
         midw_fi_tcl_ITC_Information o_ITC_Information;
         if (!bDoIt(o_ITC_Information))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ITC_Information.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ITC_Information.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_PRODUCTIONREADRESULTSTRUCTURE:
      {
      if (poVisitor->bDoExpand_ProductionReadResultStructure(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_STATUS));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U16,midw_diaglogfi_tclSemanticDomain::EN_ITC));
      }
      else
      {
         midw_fi_tcl_ProductionReadResultStructure o_ProductionReadResultStructure;
         if (!bDoIt(o_ProductionReadResultStructure))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ProductionReadResultStructure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ProductionReadResultStructure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_PRODUCTIONREADRESULTLIST:
      {
      if (poVisitor->bDoExpand_ProductionReadResultList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_PRODUCTIONREADRESULTSTRUCTURE,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_ITCLIST));
      }
      else
      {
         midw_fi_tcl_ProductionReadResultList o_ProductionReadResultList;
         if (!bDoIt(o_ProductionReadResultList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ProductionReadResultList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ProductionReadResultList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_CUSTOMERREADRESULTSTRUCTURE:
      {
      if (poVisitor->bDoExpand_CustomerReadResultStructure(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_STATUS));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_DTC));
      }
      else
      {
         midw_fi_tcl_CustomerReadResultStructure o_CustomerReadResultStructure;
         if (!bDoIt(o_CustomerReadResultStructure))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CustomerReadResultStructure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CustomerReadResultStructure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_CUSTOMERREADRESULTLIST:
      {
      if (poVisitor->bDoExpand_CustomerReadResultList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_CUSTOMERREADRESULTSTRUCTURE,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_DTCLIST));
      }
      else
      {
         midw_fi_tcl_CustomerReadResultList o_CustomerReadResultList;
         if (!bDoIt(o_CustomerReadResultList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CustomerReadResultList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CustomerReadResultList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_E8_PROTOCOL:
      {
         midw_fi_tcl_e8_Protocol o_e8_Protocol;
         if (!bDoIt(o_e8_Protocol))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_TESTRESULT:
      {
      if (poVisitor->bDoExpand_TestResult(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_FREEZEFRAMELIST,midw_diaglogfi_tclSemanticDomain::EN_FREEZEFRAMELIST));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_TESTRESULT,midw_diaglogfi_tclSemanticDomain::EN_RESULT));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_TROUBLECODE));
      }
      else
      {
         midw_fi_tcl_TestResult o_TestResult;
         if (!bDoIt(o_TestResult))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TestResult.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TestResult.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_TESTRESULTLIST:
      {
      if (poVisitor->bDoExpand_TestResultList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_TESTRESULT,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_TESTRESULTLIST));
      }
      else
      {
         midw_fi_tcl_TestResultList o_TestResultList;
         if (!bDoIt(o_TestResultList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TestResultList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TestResultList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_SNAPSHOTDATA:
      {
      if (poVisitor->bDoExpand_SnapshotData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_DATA));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_NUMBEROFDATA));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_RECORDNUMBER));
      }
      else
      {
         midw_fi_tcl_SnapshotData o_SnapshotData;
         if (!bDoIt(o_SnapshotData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SnapshotData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SnapshotData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_SNAPSHOTDATALIST:
      {
      if (poVisitor->bDoExpand_SnapshotDataList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_SNAPSHOTDATA,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_SNAPSHOTDATA));
      }
      else
      {
         midw_fi_tcl_SnapshotDataList o_SnapshotDataList;
         if (!bDoIt(o_SnapshotDataList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SnapshotDataList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SnapshotDataList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_SNAPSHOTIDENTIFICATION:
      {
      if (poVisitor->bDoExpand_SnapshotIdentification(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U8,midw_diaglogfi_tclSemanticDomain::EN_RECORDNUMBER));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_DTC));
      }
      else
      {
         midw_fi_tcl_SnapshotIdentification o_SnapshotIdentification;
         if (!bDoIt(o_SnapshotIdentification))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SnapshotIdentification.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SnapshotIdentification.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_SNAPSHOTIDENTIFICATIONLIST:
      {
      if (poVisitor->bDoExpand_SnapshotIdentificationList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_SNAPSHOTIDENTIFICATION,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_SNAPSHOTIDENTIFICATION));
      }
      else
      {
         midw_fi_tcl_SnapshotIdentificationList o_SnapshotIdentificationList;
         if (!bDoIt(o_SnapshotIdentificationList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SnapshotIdentificationList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SnapshotIdentificationList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_E8_CONTROLPARAMETER:
      {
         midw_fi_tcl_e8_ControlParameter o_e8_ControlParameter;
         if (!bDoIt(o_e8_ControlParameter))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_CONTROLLIST:
      {
      if (poVisitor->bDoExpand_ControlList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_DTCLIST));
      }
      else
      {
         midw_fi_tcl_ControlList o_ControlList;
         if (!bDoIt(o_ControlList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ControlList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ControlList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_E8_VDLMEDIATYPE:
      {
         midw_fi_tcl_e8_VDLMediaType o_e8_VDLMediaType;
         if (!bDoIt(o_e8_VDLMediaType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_E8_DIAGLOGDEFSETTYPE:
      {
         midw_fi_tcl_e8_DiaglogDefsetType o_e8_DiaglogDefsetType;
         if (!bDoIt(o_e8_DiaglogDefsetType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_E8_SENDNEXTTESTRESREASON:
      {
         midw_fi_tcl_e8_SendNextTestResReason o_e8_SendNextTestResReason;
         if (!bDoIt(o_e8_SendNextTestResReason))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_SENDNEXTTESTRESULTSTRUCTURE:
      {
      if (poVisitor->bDoExpand_SendNextTestResultStructure(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U16,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_ITCLIST));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_E8_SENDNEXTTESTRESREASON,midw_diaglogfi_tclSemanticDomain::EN_SENDNEXTTESTRESREASON));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_BOOL,midw_diaglogfi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         midw_fi_tcl_SendNextTestResultStructure o_SendNextTestResultStructure;
         if (!bDoIt(o_SendNextTestResultStructure))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SendNextTestResultStructure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SendNextTestResultStructure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_E8_GMLNGWDTCFAULTTYPE:
      {
         midw_fi_tcl_e8_GMLnGWDTCFaultType o_e8_GMLnGWDTCFaultType;
         if (!bDoIt(o_e8_GMLnGWDTCFaultType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglogfi_tclToken::EN_ACTIVEDTCLIST:
      {
      if (poVisitor->bDoExpand_ActiveDTCList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_END_OF_STRUCT,midw_diaglogfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_U32,midw_diaglogfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglogfi_tclKnot(midw_diaglogfi_tclToken::EN_LIST,midw_diaglogfi_tclSemanticDomain::EN_DTCLIST));
      }
      else
      {
         midw_fi_tcl_ActiveDTCList o_ActiveDTCList;
         if (!bDoIt(o_ActiveDTCList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ActiveDTCList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ActiveDTCList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglogfi_tclToken::EN_UNKNOWN:
      case midw_diaglogfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

