/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_DIAGLIBFITYPES_HEADER
#define MIDW_DIAGLIBFITYPES_HEADER


class midw_diaglibfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_diaglib_fi message types

fi_tclMessageBase* midw_diaglibfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_diaglibfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_diaglibfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_diaglibfi_tclMsgRoutineControlMethodStart : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgRoutineControlMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgRoutineControlMethodStart& operator=(const midw_diaglibfi_tclMsgRoutineControlMethodStart& coRef);
   midw_diaglibfi_tclMsgRoutineControlMethodStart(const midw_diaglibfi_tclMsgRoutineControlMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 RoutineId;
   midw_fi_tcl_b32_RoutineBitMask RoutineBitMask;
   midw_fi_tcl_ValueList RoutineParameterList;
   virtual ~midw_diaglibfi_tclMsgRoutineControlMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgRoutineControlMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgRoutineControlMethodResult : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgRoutineControlMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgRoutineControlMethodResult& operator=(const midw_diaglibfi_tclMsgRoutineControlMethodResult& coRef);
   midw_diaglibfi_tclMsgRoutineControlMethodResult(const midw_diaglibfi_tclMsgRoutineControlMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 RoutineId;
   midw_fi_tcl_e8_RoutineStatus RoutineStatus;
   midw_fi_tcl_ValueList RoutineResult;
   virtual ~midw_diaglibfi_tclMsgRoutineControlMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgRoutineControlMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgRoutineControlMethodAbort : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgRoutineControlMethodAbort();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgRoutineControlMethodAbort& operator=(const midw_diaglibfi_tclMsgRoutineControlMethodAbort& coRef);
   midw_diaglibfi_tclMsgRoutineControlMethodAbort(const midw_diaglibfi_tclMsgRoutineControlMethodAbort& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 RoutineId;
   virtual ~midw_diaglibfi_tclMsgRoutineControlMethodAbort();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgRoutineControlMethodAbort& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgGetRoutineResultMethodStart : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgGetRoutineResultMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgGetRoutineResultMethodStart& operator=(const midw_diaglibfi_tclMsgGetRoutineResultMethodStart& coRef);
   midw_diaglibfi_tclMsgGetRoutineResultMethodStart(const midw_diaglibfi_tclMsgGetRoutineResultMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 RoutineId;
   virtual ~midw_diaglibfi_tclMsgGetRoutineResultMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgGetRoutineResultMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgGetRoutineResultMethodResult : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgGetRoutineResultMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgGetRoutineResultMethodResult& operator=(const midw_diaglibfi_tclMsgGetRoutineResultMethodResult& coRef);
   midw_diaglibfi_tclMsgGetRoutineResultMethodResult(const midw_diaglibfi_tclMsgGetRoutineResultMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 RoutineId;
   midw_fi_tcl_e8_RoutineStatus RoutineStatus;
   midw_fi_tcl_ValueList RoutineResult;
   virtual ~midw_diaglibfi_tclMsgGetRoutineResultMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgGetRoutineResultMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgIOControlMethodStart : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgIOControlMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgIOControlMethodStart& operator=(const midw_diaglibfi_tclMsgIOControlMethodStart& coRef);
   midw_diaglibfi_tclMsgIOControlMethodStart(const midw_diaglibfi_tclMsgIOControlMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ControlId;
   midw_fi_tcl_e8_IOControlActionId ActionId;
   midw_fi_tcl_ValueList IOParameterList;
   virtual ~midw_diaglibfi_tclMsgIOControlMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgIOControlMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgIOControlMethodResult : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgIOControlMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgIOControlMethodResult& operator=(const midw_diaglibfi_tclMsgIOControlMethodResult& coRef);
   midw_diaglibfi_tclMsgIOControlMethodResult(const midw_diaglibfi_tclMsgIOControlMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ControlId;
   midw_fi_tcl_e8_IOControlActionId ActionId;
   midw_fi_tcl_e8_IOResult IOResult;
   midw_fi_tcl_ValueList IOResultList;
   virtual ~midw_diaglibfi_tclMsgIOControlMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgIOControlMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgSystemSetPrepareMethodStart : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgSystemSetPrepareMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgSystemSetPrepareMethodStart& operator=(const midw_diaglibfi_tclMsgSystemSetPrepareMethodStart& coRef);
   midw_diaglibfi_tclMsgSystemSetPrepareMethodStart(const midw_diaglibfi_tclMsgSystemSetPrepareMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SystemSetId;
   midw_fi_tcl_e8_SystemSetType SystemSetMode;
   virtual ~midw_diaglibfi_tclMsgSystemSetPrepareMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgSystemSetPrepareMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgSystemSetPrepareMethodResult : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgSystemSetPrepareMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgSystemSetPrepareMethodResult& operator=(const midw_diaglibfi_tclMsgSystemSetPrepareMethodResult& coRef);
   midw_diaglibfi_tclMsgSystemSetPrepareMethodResult(const midw_diaglibfi_tclMsgSystemSetPrepareMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SystemSetId;
   midw_fi_tcl_e8_SystemSetType SystemSetMode;
   midw_fi_tcl_e8_SystemSetResult SystemSetResult;
   midw_fi_tcl_ValueList ErrorList;
   virtual ~midw_diaglibfi_tclMsgSystemSetPrepareMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgSystemSetPrepareMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgSystemSetFinishedMethodStart : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgSystemSetFinishedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgSystemSetFinishedMethodStart& operator=(const midw_diaglibfi_tclMsgSystemSetFinishedMethodStart& coRef);
   midw_diaglibfi_tclMsgSystemSetFinishedMethodStart(const midw_diaglibfi_tclMsgSystemSetFinishedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SystemSetId;
   midw_fi_tcl_e8_SystemSetType SystemSetMode;
   virtual ~midw_diaglibfi_tclMsgSystemSetFinishedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgSystemSetFinishedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgSystemSetFinishedMethodResult : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgSystemSetFinishedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgSystemSetFinishedMethodResult& operator=(const midw_diaglibfi_tclMsgSystemSetFinishedMethodResult& coRef);
   midw_diaglibfi_tclMsgSystemSetFinishedMethodResult(const midw_diaglibfi_tclMsgSystemSetFinishedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SystemSetId;
   midw_fi_tcl_e8_SystemSetResult SystemSetResult;
   virtual ~midw_diaglibfi_tclMsgSystemSetFinishedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgSystemSetFinishedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgSystemSetMethodStart : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgSystemSetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgSystemSetMethodStart& operator=(const midw_diaglibfi_tclMsgSystemSetMethodStart& coRef);
   midw_diaglibfi_tclMsgSystemSetMethodStart(const midw_diaglibfi_tclMsgSystemSetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SystemSetId;
   midw_fi_tcl_e8_SystemSetType SystemSetMode;
   virtual ~midw_diaglibfi_tclMsgSystemSetMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgSystemSetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgSystemSetMethodResult : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgSystemSetMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgSystemSetMethodResult& operator=(const midw_diaglibfi_tclMsgSystemSetMethodResult& coRef);
   midw_diaglibfi_tclMsgSystemSetMethodResult(const midw_diaglibfi_tclMsgSystemSetMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SystemSetId;
   midw_fi_tcl_e8_SystemSetType SystemSetMode;
   midw_fi_tcl_e8_SystemSetResult SystemSetResult;
   midw_fi_tcl_ValueList ErrorList;
   virtual ~midw_diaglibfi_tclMsgSystemSetMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgSystemSetMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgSystemSetVerifyMethodStart : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgSystemSetVerifyMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgSystemSetVerifyMethodStart& operator=(const midw_diaglibfi_tclMsgSystemSetVerifyMethodStart& coRef);
   midw_diaglibfi_tclMsgSystemSetVerifyMethodStart(const midw_diaglibfi_tclMsgSystemSetVerifyMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SystemSetId;
   midw_fi_tcl_e8_SystemSetType SystemSetMode;
   virtual ~midw_diaglibfi_tclMsgSystemSetVerifyMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgSystemSetVerifyMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgSystemSetVerifyMethodResult : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgSystemSetVerifyMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgSystemSetVerifyMethodResult& operator=(const midw_diaglibfi_tclMsgSystemSetVerifyMethodResult& coRef);
   midw_diaglibfi_tclMsgSystemSetVerifyMethodResult(const midw_diaglibfi_tclMsgSystemSetVerifyMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SystemSetId;
   midw_fi_tcl_e8_SystemSetType SystemSetMode;
   midw_fi_tcl_e8_SystemSetResult SystemSetResult;
   midw_fi_tcl_ValueList ValueList;
   virtual ~midw_diaglibfi_tclMsgSystemSetVerifyMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgSystemSetVerifyMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgDiagnosisReadMethodStart : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgDiagnosisReadMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgDiagnosisReadMethodStart& operator=(const midw_diaglibfi_tclMsgDiagnosisReadMethodStart& coRef);
   midw_diaglibfi_tclMsgDiagnosisReadMethodStart(const midw_diaglibfi_tclMsgDiagnosisReadMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DiagnosisDataId;
   virtual ~midw_diaglibfi_tclMsgDiagnosisReadMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgDiagnosisReadMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgDiagnosisReadMethodResult : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgDiagnosisReadMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgDiagnosisReadMethodResult& operator=(const midw_diaglibfi_tclMsgDiagnosisReadMethodResult& coRef);
   midw_diaglibfi_tclMsgDiagnosisReadMethodResult(const midw_diaglibfi_tclMsgDiagnosisReadMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DiagnosisDataId;
   midw_fi_tcl_e8_DiagDataResult DiagnosisReadResult;
   midw_fi_tcl_ValueList DiagnosisReadValues;
   virtual ~midw_diaglibfi_tclMsgDiagnosisReadMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgDiagnosisReadMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgDiagnosisWriteMethodStart : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgDiagnosisWriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgDiagnosisWriteMethodStart& operator=(const midw_diaglibfi_tclMsgDiagnosisWriteMethodStart& coRef);
   midw_diaglibfi_tclMsgDiagnosisWriteMethodStart(const midw_diaglibfi_tclMsgDiagnosisWriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DiagnosisDataId;
   midw_fi_tcl_ValueList DiagnosisWriteValues;
   virtual ~midw_diaglibfi_tclMsgDiagnosisWriteMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgDiagnosisWriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgDiagnosisWriteMethodResult : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgDiagnosisWriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgDiagnosisWriteMethodResult& operator=(const midw_diaglibfi_tclMsgDiagnosisWriteMethodResult& coRef);
   midw_diaglibfi_tclMsgDiagnosisWriteMethodResult(const midw_diaglibfi_tclMsgDiagnosisWriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DiagnosisDataId;
   midw_fi_tcl_e8_DiagDataResult DiagnosisWriteResult;
   midw_fi_tcl_ValueList ErrorList;
   virtual ~midw_diaglibfi_tclMsgDiagnosisWriteMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgDiagnosisWriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgDiagnosisDataGet : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgDiagnosisDataGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgDiagnosisDataGet& operator=(const midw_diaglibfi_tclMsgDiagnosisDataGet& coRef);
   midw_diaglibfi_tclMsgDiagnosisDataGet(const midw_diaglibfi_tclMsgDiagnosisDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DiagnosisDataId;
   virtual ~midw_diaglibfi_tclMsgDiagnosisDataGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgDiagnosisDataGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgDiagnosisDataSet : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgDiagnosisDataSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgDiagnosisDataSet& operator=(const midw_diaglibfi_tclMsgDiagnosisDataSet& coRef);
   midw_diaglibfi_tclMsgDiagnosisDataSet(const midw_diaglibfi_tclMsgDiagnosisDataSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DiagnosisDataId;
   midw_fi_tcl_ValueList DiagnosisWriteValues;
   virtual ~midw_diaglibfi_tclMsgDiagnosisDataSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgDiagnosisDataSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_diaglibfi_tclMsgDiagnosisDataStatus : public midw_diaglibfi_tclMsgBaseMessage
{
public:

   midw_diaglibfi_tclMsgDiagnosisDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_diaglibfi_tclMsgDiagnosisDataStatus& operator=(const midw_diaglibfi_tclMsgDiagnosisDataStatus& coRef);
   midw_diaglibfi_tclMsgDiagnosisDataStatus(const midw_diaglibfi_tclMsgDiagnosisDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DiagnosisDataId;
   midw_fi_tcl_e8_DiagDataResult DiagnosisDataResult;
   midw_fi_tcl_ValueList DiagnosisDataValues;
   virtual ~midw_diaglibfi_tclMsgDiagnosisDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_diaglibfi_tclMsgDiagnosisDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
