#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_STDVISITORS
#include "midw_fi_gen_if.h"

tBool midw_diaglibfi_tclDescription::bInitMessage(midw_diaglibfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_diaglibfi_tclToken::EN_LAST_TOKEN:
   case midw_diaglibfi_tclToken::EN_LIST:
   case midw_diaglibfi_tclToken::EN_END_OF_STRUCT:
   case midw_diaglibfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_ROUTINEPARAMETERLIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_B32_ROUTINEBITMASK,midw_diaglibfi_tclSemanticDomain::EN_MSG_ROUTINEBITMASK)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_ROUTINEID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_ROUTINERESULT)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_ROUTINESTATUS,midw_diaglibfi_tclSemanticDomain::EN_MSG_ROUTINESTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_ROUTINEID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODABORT:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_ROUTINEID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_GETROUTINERESULTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_ROUTINEID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_GETROUTINERESULTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_ROUTINERESULT)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_ROUTINESTATUS,midw_diaglibfi_tclSemanticDomain::EN_MSG_ROUTINESTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_ROUTINEID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_IOCONTROLMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_IOPARAMETERLIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_IOCONTROLACTIONID,midw_diaglibfi_tclSemanticDomain::EN_MSG_ACTIONID)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_CONTROLID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_IOCONTROLMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_IORESULTLIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_IORESULT,midw_diaglibfi_tclSemanticDomain::EN_MSG_IORESULT)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_IOCONTROLACTIONID,midw_diaglibfi_tclSemanticDomain::EN_MSG_ACTIONID)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_CONTROLID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETPREPAREMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_SYSTEMSETTYPE,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETPREPAREMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_ERRORLIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_SYSTEMSETRESULT,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETRESULT)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_SYSTEMSETTYPE,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETFINISHEDMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_SYSTEMSETTYPE,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETFINISHEDMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_SYSTEMSETRESULT,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETRESULT)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_SYSTEMSETTYPE,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_ERRORLIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_SYSTEMSETRESULT,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETRESULT)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_SYSTEMSETTYPE,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETVERIFYMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_SYSTEMSETTYPE,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETVERIFYMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_VALUELIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_SYSTEMSETRESULT,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETRESULT)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_SYSTEMSETTYPE,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETMODE)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_SYSTEMSETID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISREADMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISDATAID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISREADMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISREADVALUES)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_DIAGDATARESULT,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISREADRESULT)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISDATAID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISWRITEMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISWRITEVALUES)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISDATAID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISWRITEMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_ERRORLIST)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_DIAGDATARESULT,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISWRITERESULT)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISDATAID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATAGET:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISDATAID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATASET:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISWRITEVALUES)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISDATAID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATASTATUS:
   {
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUELIST,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISDATAVALUES)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_DIAGDATARESULT,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISDATARESULT)) && bResult;
      bResult = oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_MSG_DIAGNOSISDATAID)) && bResult;
   } break;
   case midw_diaglibfi_tclToken::EN_BINCONTAINER:
   case midw_diaglibfi_tclToken::EN_U8ARRAY:
   case midw_diaglibfi_tclToken::EN_E8_INTERNALERROR:
   case midw_diaglibfi_tclToken::EN_B32_ROUTINEBITMASK:
   case midw_diaglibfi_tclToken::EN_E8_ROUTINESTATUS:
   case midw_diaglibfi_tclToken::EN_E8_IORESULT:
   case midw_diaglibfi_tclToken::EN_E8_SYSTEMSETRESULT:
   case midw_diaglibfi_tclToken::EN_E8_DIAGDATARESULT:
   case midw_diaglibfi_tclToken::EN_E8_IOCONTROLACTIONID:
   case midw_diaglibfi_tclToken::EN_E8_SYSTEMSETTYPE:
   case midw_diaglibfi_tclToken::EN_E8_VALUETYPE:
   case midw_diaglibfi_tclToken::EN_VALUEUNION:
   case midw_diaglibfi_tclToken::EN_VALUEUNIONUNION0:
   case midw_diaglibfi_tclToken::EN_VALUELIST:
   case midw_diaglibfi_tclToken::EN_U8:   
   case midw_diaglibfi_tclToken::EN_S8:   
   case midw_diaglibfi_tclToken::EN_U16:   
   case midw_diaglibfi_tclToken::EN_S16:   
   case midw_diaglibfi_tclToken::EN_U24:   
   case midw_diaglibfi_tclToken::EN_S24:   
   case midw_diaglibfi_tclToken::EN_U32:   
   case midw_diaglibfi_tclToken::EN_S32:   
   case midw_diaglibfi_tclToken::EN_U64:   
   case midw_diaglibfi_tclToken::EN_S64:   
   case midw_diaglibfi_tclToken::EN_F32:   
   case midw_diaglibfi_tclToken::EN_F64:   
   case midw_diaglibfi_tclToken::EN_BOOL:   
   case midw_diaglibfi_tclToken::EN_STRING:   
   case midw_diaglibfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(enMsgToken,midw_diaglibfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_diaglibfi_tclDescription::bDoIt(midw_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_diaglibfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_diaglibfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_diaglibfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_diaglibfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_diaglibfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_diaglibfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_diaglibfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_diaglibfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_LIST: 
      {
         midw_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_diaglibfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_diaglibfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_diaglibfi_tclToken::EN_U8: 
      {
         midw_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_diaglibfi_tclToken::EN_U16: 
      {
         midw_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_U24: 
      {
         midw_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_U32: 
      {
         midw_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_U64: 
      {
         midw_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_S8: 
      {
         midw_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_S16: 
      {
         midw_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_S24: 
      {
         midw_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_S32: 
      {
         midw_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_S64: 
      {
         midw_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_F32: 
      {
         midw_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_F64: 
      {
         midw_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_BOOL: 
      {
         midw_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_STRING: 
      {
         midw_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODSTART:
      case midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODRESULT:
      case midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODABORT:
      case midw_diaglibfi_tclToken::EN_MSG_GETROUTINERESULTMETHODSTART:
      case midw_diaglibfi_tclToken::EN_MSG_GETROUTINERESULTMETHODRESULT:
      case midw_diaglibfi_tclToken::EN_MSG_IOCONTROLMETHODSTART:
      case midw_diaglibfi_tclToken::EN_MSG_IOCONTROLMETHODRESULT:
      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETPREPAREMETHODSTART:
      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETPREPAREMETHODRESULT:
      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETFINISHEDMETHODSTART:
      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETFINISHEDMETHODRESULT:
      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETMETHODSTART:
      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETMETHODRESULT:
      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETVERIFYMETHODSTART:
      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETVERIFYMETHODRESULT:
      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISREADMETHODSTART:
      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISREADMETHODRESULT:
      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISWRITEMETHODSTART:
      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISWRITEMETHODRESULT:
      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATAGET:
      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATASET:
      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATASTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_diaglibfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_END_OF_STRUCT,midw_diaglibfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U8,midw_diaglibfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_LIST,midw_diaglibfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglibfi_tclToken::EN_U8ARRAY:
      {
      if (poVisitor->bDoExpand_u8Array(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_END_OF_STRUCT,midw_diaglibfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U8,midw_diaglibfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_LIST,midw_diaglibfi_tclSemanticDomain::EN_TU8ARRAY));
      }
      else
      {
         midw_fi_tcl_u8Array o_u8Array;
         if (!bDoIt(o_u8Array))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_u8Array.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_u8Array.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglibfi_tclToken::EN_E8_INTERNALERROR:
      {
         midw_fi_tcl_e8_InternalError o_e8_InternalError;
         if (!bDoIt(o_e8_InternalError))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_B32_ROUTINEBITMASK:
      {
         midw_fi_tcl_b32_RoutineBitMask o_b32_RoutineBitMask;
         if (!bDoIt(o_b32_RoutineBitMask))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_E8_ROUTINESTATUS:
      {
         midw_fi_tcl_e8_RoutineStatus o_e8_RoutineStatus;
         if (!bDoIt(o_e8_RoutineStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_E8_IORESULT:
      {
         midw_fi_tcl_e8_IOResult o_e8_IOResult;
         if (!bDoIt(o_e8_IOResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_E8_SYSTEMSETRESULT:
      {
         midw_fi_tcl_e8_SystemSetResult o_e8_SystemSetResult;
         if (!bDoIt(o_e8_SystemSetResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_E8_DIAGDATARESULT:
      {
         midw_fi_tcl_e8_DiagDataResult o_e8_DiagDataResult;
         if (!bDoIt(o_e8_DiagDataResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_E8_IOCONTROLACTIONID:
      {
         midw_fi_tcl_e8_IOControlActionId o_e8_IOControlActionId;
         if (!bDoIt(o_e8_IOControlActionId))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_E8_SYSTEMSETTYPE:
      {
         midw_fi_tcl_e8_SystemSetType o_e8_SystemSetType;
         if (!bDoIt(o_e8_SystemSetType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_diaglibfi_tclToken::EN_E8_VALUETYPE:
      {
         midw_fi_tcl_e8_ValueType o_e8_ValueType;
         if (!bDoIt(o_e8_ValueType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
   case midw_diaglibfi_tclToken::EN_VALUEUNIONUNION0:
   {
      (tVoid) oPath.bGoUp();
      (tVoid) oCallStack.bGoUp();
      midw_fi_tcl_e8_ValueType oDataType;
      oCallStack.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_VALUETYPE,midw_diaglibfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      (tVoid) bDoIt(oDataType);
      (tVoid) oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case midw_fi_tcl_e8_ValueType::FI_EN_TBOOL:
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_BOOL,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU8:
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U8,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU16:
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U16,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU32:
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U32,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS8:
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_S8,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS16:
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_S16,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS32:
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_S32,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TF32:
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_F32,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TF64:
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_F64,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_T_E8_INTERNALERROR:
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_E8_INTERNALERROR,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_T_U8ARRAY:
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_U8ARRAY,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
         break;
      }
   } break;
      case midw_diaglibfi_tclToken::EN_VALUEUNION:
      {
      if (poVisitor->bDoExpand_ValueUnion(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_END_OF_STRUCT,midw_diaglibfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUEUNIONUNION0,midw_diaglibfi_tclSemanticDomain::EN_VALUEUNION));
      }
      else
      {
         midw_fi_tcl_ValueUnion o_ValueUnion;
         if (!bDoIt(o_ValueUnion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ValueUnion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ValueUnion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglibfi_tclToken::EN_VALUELIST:
      {
      if (poVisitor->bDoExpand_ValueList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_END_OF_STRUCT,midw_diaglibfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_VALUEUNION,midw_diaglibfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_diaglibfi_tclKnot(midw_diaglibfi_tclToken::EN_LIST,midw_diaglibfi_tclSemanticDomain::EN_VALUELIST));
      }
      else
      {
         midw_fi_tcl_ValueList o_ValueList;
         if (!bDoIt(o_ValueList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ValueList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ValueList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_diaglibfi_tclToken::EN_UNKNOWN:
      case midw_diaglibfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

