/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DEVICEMANAGERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DEVICEMANAGERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DEVICEMANAGERFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_devicemanager_fi message types

fi_tclMessageBase* midw_devicemanagerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODSTART:
         return OSAL_NEW midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart;

      case midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODRESULT:
         return OSAL_NEW midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult;

      case midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODSTART:
         return OSAL_NEW midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart;

      case midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODRESULT:
         return OSAL_NEW midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult;

      case midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONUPREG:
         return OSAL_NEW midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg;

      case midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONRELUPREG:
         return OSAL_NEW midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg;

      case midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONGET:
         return OSAL_NEW midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet;

      case midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONSTATUS:
         return OSAL_NEW midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_devicemanagerfifi messages

// common functions

tU16 midw_devicemanagerfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_DEVICEMANAGERFI_C_U16_SERVICE_ID;
}

tU16 midw_devicemanagerfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_devicemanagerfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_devicemanagerfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_devicemanagerfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_devicemanagerfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_devicemanagerfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_devicemanagerfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& coRef)
   : midw_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   DeviceSerialNo = coRef.DeviceSerialNo;
}
midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::operator=(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceSerialNo = coRef.DeviceSerialNo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::vDestroy()
{
   DeviceSerialNo.vDestroy();
}

midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart()
:DeviceSerialNo()
 {}

tS32 midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODSTART;
}


midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::~midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DeviceSerialNo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceSerialNo);
   return oIn;
}

fi_tclOutContext& midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceSerialNo);
   return oOut;
}

tBool midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::operator==(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceSerialNo == roRef.DeviceSerialNo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& coRef)
   : midw_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   DeviceProperty = coRef.DeviceProperty;
}
midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::operator=(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceProperty = coRef.DeviceProperty;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::vDestroy()
{
   DeviceProperty.vDestroy(); 
}

midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult()
:DeviceProperty()
 {}

tS32 midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODRESULT;
}


midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::~midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DeviceProperty.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceProperty);
   return oIn;
}

fi_tclOutContext& midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceProperty);
   return oOut;
}

tBool midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::operator==(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceProperty == roRef.DeviceProperty);
   return bResult;
}

//=============================================================================

midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart::midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart()
 {}

tS32 midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODSTART;
}


midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart::~midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult(const midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& coRef)
   : midw_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   DevInfoArr = coRef.DevInfoArr;
}
midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::operator=(const midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DevInfoArr = coRef.DevInfoArr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::vDestroy()
{
   DevInfoArr.vDestroy(); 
}

midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult()
:DevInfoArr()
 {}

tS32 midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODRESULT;
}


midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::~midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DevInfoArr.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DevInfoArr);
   return oIn;
}

fi_tclOutContext& midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DevInfoArr);
   return oOut;
}

tBool midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::operator==(const midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DevInfoArr == roRef.DevInfoArr);
   return bResult;
}

//=============================================================================

midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg::midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg()
 {}

tS32 midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg::s32GetTypeId() const
{
   return (tS32) midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONUPREG;
}


midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg::~midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg()
{}

//=============================================================================

midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg::midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg()
 {}

tS32 midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONRELUPREG;
}


midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg::~midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg()
{}

//=============================================================================

midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet()
 {}

tS32 midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::s32GetTypeId() const
{
   return (tS32) midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONGET;
}


midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::~midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus(const midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& coRef)
   : midw_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   Devicetype = coRef.Devicetype;
}
midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::operator=(const midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   Devicetype = coRef.Devicetype;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Devicetype.size(); ++u32Idx)
         Devicetype[u32Idx].vDestroy();
   Devicetype.clear();
   }
}

midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus()

 {}

tS32 midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONSTATUS;
}


midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::~midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Devicetype.size(); ++u32ListIdx)
      u32DynamicSize += Devicetype[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Devicetype.size(); ++u32Idx)
      {
         Devicetype[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Devicetype.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Devicetype[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Devicetype.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Devicetype.size(); ++u32Idx)
         (tVoid) (oOut << Devicetype[u32Idx]);
   }
   return oOut;
}

tBool midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::operator==(const midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Devicetype.size() == roRef.Devicetype.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Devicetype.size()); ++u32Idx)
            bResult = bResult && (Devicetype[u32Idx] == roRef.Devicetype[u32Idx]);
      }
   return bResult;
}

