/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_AUDIO_ROUTE_MGRFITYPES_HEADER
#define MIDW_AUDIO_ROUTE_MGRFITYPES_HEADER


class midw_audio_route_mgrfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_audio_route_mgr_fi message types

fi_tclMessageBase* midw_audio_route_mgrfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_audio_route_mgrfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_audio_route_mgrfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart& operator=(const midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart& coRef);
   midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart(const midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_SourceRouteActivity SourceRouteActivity;
   virtual ~midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityUpReg : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityUpReg();

   virtual ~midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityUpReg();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityRelUpReg : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityRelUpReg();

   virtual ~midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityRelUpReg();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityGet : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityGet();

   virtual ~midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityGet();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet& operator=(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet& coRef);
   midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_SourceRouteActivity SourceRouteActivity;
   virtual ~midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus& operator=(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus& coRef);
   midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_SourceRouteActivity SourceRouteActivity;
   tU16 ErrorCode;
   virtual ~midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgRequestAudioRouteUpReg : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgRequestAudioRouteUpReg();

   virtual ~midw_audio_route_mgrfi_tclMsgRequestAudioRouteUpReg();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgRequestAudioRouteRelUpReg : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgRequestAudioRouteRelUpReg();

   virtual ~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRelUpReg();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgRequestAudioRouteGet : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgRequestAudioRouteGet();

   virtual ~midw_audio_route_mgrfi_tclMsgRequestAudioRouteGet();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus& operator=(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus& coRef);
   midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_RequestAudioRouteItem, std::allocator<midw_fi_tcl_RequestAudioRouteItem> > RequestAudioRouteList;
   virtual ~midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgSourceAvailabilityUpReg : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgSourceAvailabilityUpReg();

   virtual ~midw_audio_route_mgrfi_tclMsgSourceAvailabilityUpReg();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgSourceAvailabilityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgSourceAvailabilityRelUpReg : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgSourceAvailabilityRelUpReg();

   virtual ~midw_audio_route_mgrfi_tclMsgSourceAvailabilityRelUpReg();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgSourceAvailabilityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgSourceAvailabilityGet : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgSourceAvailabilityGet();

   virtual ~midw_audio_route_mgrfi_tclMsgSourceAvailabilityGet();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgSourceAvailabilityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus& operator=(const midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus& coRef);
   midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus(const midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_SourceAvailablityItem, std::allocator<midw_fi_tcl_SourceAvailablityItem> > SourceAvailabilityList;
   virtual ~midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectUpReg : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectUpReg();

   virtual ~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectUpReg();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectRelUpReg : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectRelUpReg();

   virtual ~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectRelUpReg();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectGet : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectGet();

   virtual ~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectGet();

   inline tBool operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet& operator=(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet& coRef);
   midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource Source;
   tU16 SubSource;
   tU16 Reason;
   virtual ~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus : public midw_audio_route_mgrfi_tclMsgBaseMessage
{
public:

   midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus& operator=(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus& coRef);
   midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource Source;
   tU16 SubSource;
   tU16 Reason;
   virtual ~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
