/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_AUD_SRC_ROUTEFITYPES_HEADER
#define MIDW_AUD_SRC_ROUTEFITYPES_HEADER


class midw_aud_src_routefi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_aud_src_route_fi message types

fi_tclMessageBase* midw_aud_src_routefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_aud_src_routefi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_aud_src_routefi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_aud_src_routefi_tclMsgAllocateMethodStart : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgAllocateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgAllocateMethodStart& operator=(const midw_aud_src_routefi_tclMsgAllocateMethodStart& coRef);
   midw_aud_src_routefi_tclMsgAllocateMethodStart(const midw_aud_src_routefi_tclMsgAllocateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   tU16 u16Sink;
   virtual ~midw_aud_src_routefi_tclMsgAllocateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgAllocateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgAllocateMethodResult : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgAllocateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgAllocateMethodResult& operator=(const midw_aud_src_routefi_tclMsgAllocateMethodResult& coRef);
   midw_aud_src_routefi_tclMsgAllocateMethodResult(const midw_aud_src_routefi_tclMsgAllocateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   tU16 u16Sink;
   tU16 u16BlockWidth;
   tU16 u16ConnectionLabel;
   tU16 u16Error;
   virtual ~midw_aud_src_routefi_tclMsgAllocateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgAllocateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgDeAllocateMethodStart : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgDeAllocateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgDeAllocateMethodStart& operator=(const midw_aud_src_routefi_tclMsgDeAllocateMethodStart& coRef);
   midw_aud_src_routefi_tclMsgDeAllocateMethodStart(const midw_aud_src_routefi_tclMsgDeAllocateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   virtual ~midw_aud_src_routefi_tclMsgDeAllocateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgDeAllocateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgDeAllocateMethodResult : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgDeAllocateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgDeAllocateMethodResult& operator=(const midw_aud_src_routefi_tclMsgDeAllocateMethodResult& coRef);
   midw_aud_src_routefi_tclMsgDeAllocateMethodResult(const midw_aud_src_routefi_tclMsgDeAllocateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   tU16 u16Error;
   virtual ~midw_aud_src_routefi_tclMsgDeAllocateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgDeAllocateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSourceActivityMethodStart : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSourceActivityMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgSourceActivityMethodStart& operator=(const midw_aud_src_routefi_tclMsgSourceActivityMethodStart& coRef);
   midw_aud_src_routefi_tclMsgSourceActivityMethodStart(const midw_aud_src_routefi_tclMsgSourceActivityMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   midw_fi_tcl_e8_SrcActivity e8Activity;
   midw_fi_tcl_e8_AudSource u8PosNextSrc;
   virtual ~midw_aud_src_routefi_tclMsgSourceActivityMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgSourceActivityMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSourceActivityMethodResult : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSourceActivityMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgSourceActivityMethodResult& operator=(const midw_aud_src_routefi_tclMsgSourceActivityMethodResult& coRef);
   midw_aud_src_routefi_tclMsgSourceActivityMethodResult(const midw_aud_src_routefi_tclMsgSourceActivityMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   midw_fi_tcl_e8_SrcActivity e8Activity;
   tU16 u16Error;
   virtual ~midw_aud_src_routefi_tclMsgSourceActivityMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgSourceActivityMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart& operator=(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart& coRef);
   midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   virtual ~midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult& operator=(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult& coRef);
   midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   virtual ~midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgMuteRequestUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgMuteRequestUpReg();

   virtual ~midw_aud_src_routefi_tclMsgMuteRequestUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgMuteRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgMuteRequestRelUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgMuteRequestRelUpReg();

   virtual ~midw_aud_src_routefi_tclMsgMuteRequestRelUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgMuteRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgMuteRequestStatus : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgMuteRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgMuteRequestStatus& operator=(const midw_aud_src_routefi_tclMsgMuteRequestStatus& coRef);
   midw_aud_src_routefi_tclMsgMuteRequestStatus(const midw_aud_src_routefi_tclMsgMuteRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_MuteRequestItem, std::allocator<midw_fi_tcl_MuteRequestItem> > MuteRequestList;
   virtual ~midw_aud_src_routefi_tclMsgMuteRequestStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgMuteRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgMuteStateUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgMuteStateUpReg();

   virtual ~midw_aud_src_routefi_tclMsgMuteStateUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgMuteStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgMuteStateRelUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgMuteStateRelUpReg();

   virtual ~midw_aud_src_routefi_tclMsgMuteStateRelUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgMuteStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgMuteStateSet : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgMuteStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgMuteStateSet& operator=(const midw_aud_src_routefi_tclMsgMuteStateSet& coRef);
   midw_aud_src_routefi_tclMsgMuteStateSet(const midw_aud_src_routefi_tclMsgMuteStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   midw_fi_tcl_e8_MuteState u8MuteState;
   virtual ~midw_aud_src_routefi_tclMsgMuteStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgMuteStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgMuteStateStatus : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgMuteStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgMuteStateStatus& operator=(const midw_aud_src_routefi_tclMsgMuteStateStatus& coRef);
   midw_aud_src_routefi_tclMsgMuteStateStatus(const midw_aud_src_routefi_tclMsgMuteStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   midw_fi_tcl_e8_MuteState u8MuteState;
   virtual ~midw_aud_src_routefi_tclMsgMuteStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgMuteStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgRequestAudioRouteUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgRequestAudioRouteUpReg();

   virtual ~midw_aud_src_routefi_tclMsgRequestAudioRouteUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgRequestAudioRouteRelUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgRequestAudioRouteRelUpReg();

   virtual ~midw_aud_src_routefi_tclMsgRequestAudioRouteRelUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgRequestAudioRouteGet : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgRequestAudioRouteGet();

   virtual ~midw_aud_src_routefi_tclMsgRequestAudioRouteGet();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgRequestAudioRouteStatus : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgRequestAudioRouteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgRequestAudioRouteStatus& operator=(const midw_aud_src_routefi_tclMsgRequestAudioRouteStatus& coRef);
   midw_aud_src_routefi_tclMsgRequestAudioRouteStatus(const midw_aud_src_routefi_tclMsgRequestAudioRouteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_RequestAudioRouteItem, std::allocator<midw_fi_tcl_RequestAudioRouteItem> > RequestAudioRouteList;
   virtual ~midw_aud_src_routefi_tclMsgRequestAudioRouteStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSourceAvailabilityUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSourceAvailabilityUpReg();

   virtual ~midw_aud_src_routefi_tclMsgSourceAvailabilityUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgSourceAvailabilityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSourceAvailabilityRelUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSourceAvailabilityRelUpReg();

   virtual ~midw_aud_src_routefi_tclMsgSourceAvailabilityRelUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgSourceAvailabilityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSourceAvailabilityGet : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSourceAvailabilityGet();

   virtual ~midw_aud_src_routefi_tclMsgSourceAvailabilityGet();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgSourceAvailabilityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSourceAvailabilityStatus : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSourceAvailabilityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgSourceAvailabilityStatus& operator=(const midw_aud_src_routefi_tclMsgSourceAvailabilityStatus& coRef);
   midw_aud_src_routefi_tclMsgSourceAvailabilityStatus(const midw_aud_src_routefi_tclMsgSourceAvailabilityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_SourceAvailablityItem, std::allocator<midw_fi_tcl_SourceAvailablityItem> > SourceAvailabilityList;
   virtual ~midw_aud_src_routefi_tclMsgSourceAvailabilityStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgSourceAvailabilityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSetAudioPropertyUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSetAudioPropertyUpReg();

   virtual ~midw_aud_src_routefi_tclMsgSetAudioPropertyUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgSetAudioPropertyUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSetAudioPropertyRelUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSetAudioPropertyRelUpReg();

   virtual ~midw_aud_src_routefi_tclMsgSetAudioPropertyRelUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgSetAudioPropertyRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSetAudioPropertyGet : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSetAudioPropertyGet();

   virtual ~midw_aud_src_routefi_tclMsgSetAudioPropertyGet();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgSetAudioPropertyGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgSetAudioPropertyStatus : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgSetAudioPropertyStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgSetAudioPropertyStatus& operator=(const midw_aud_src_routefi_tclMsgSetAudioPropertyStatus& coRef);
   midw_aud_src_routefi_tclMsgSetAudioPropertyStatus(const midw_aud_src_routefi_tclMsgSetAudioPropertyStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_SetAudioPropertyItem, std::allocator<midw_fi_tcl_SetAudioPropertyItem> > SetAudioPropertyList;
   virtual ~midw_aud_src_routefi_tclMsgSetAudioPropertyStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgSetAudioPropertyStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgRequestAudioRouteRejectUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgRequestAudioRouteRejectUpReg();

   virtual ~midw_aud_src_routefi_tclMsgRequestAudioRouteRejectUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgRequestAudioRouteRejectRelUpReg : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgRequestAudioRouteRejectRelUpReg();

   virtual ~midw_aud_src_routefi_tclMsgRequestAudioRouteRejectRelUpReg();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgRequestAudioRouteRejectGet : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgRequestAudioRouteRejectGet();

   virtual ~midw_aud_src_routefi_tclMsgRequestAudioRouteRejectGet();

   inline tBool operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet& operator=(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet& coRef);
   midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   tU16 u16Reason;
   virtual ~midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus : public midw_aud_src_routefi_tclMsgBaseMessage
{
public:

   midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus& operator=(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus& coRef);
   midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   tU16 u16Reason;
   virtual ~midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
