#ifndef MIDW_APPCONTROLFILANGUAGE_HEADER
#define MIDW_APPCONTROLFILANGUAGE_HEADER

class midw_appcontrolfi_tclInContext;
class midw_appcontrolfi_tclOutContext;
class midw_appcontrolfi_tclVisitorBase;

class MY_DECL midw_appcontrolfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  midw_appcontrolfi_tclDescription(fi_tclInContext* poIn, midw_appcontrolfi_tclVisitorBase* poVisit);
  midw_appcontrolfi_tclDescription(fi_tclOutContext* poOut, midw_appcontrolfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(midw_appcontrolfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(midw_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ midw_appcontrolfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  midw_appcontrolfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<midw_appcontrolfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<midw_appcontrolfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline midw_appcontrolfi_tclDescription::midw_appcontrolfi_tclDescription(fi_tclInContext* poIn, midw_appcontrolfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline midw_appcontrolfi_tclDescription::midw_appcontrolfi_tclDescription(fi_tclOutContext* poOut, midw_appcontrolfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

