/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_APPLICATIONMGRFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_APPLICATIONMGRFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_APPLICATIONMGRFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_ApplicationMgr_fi message types

fi_tclMessageBase* midw_applicationmgrfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_applicationmgrfi_tclToken::EN_MSG_APPLICATION_STATE_REQMETHODSTART:
         return OSAL_NEW midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart;

      case midw_applicationmgrfi_tclToken::EN_MSG_APPLICATION_STATE_REQMETHODRESULT:
         return OSAL_NEW midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult;

      case midw_applicationmgrfi_tclToken::EN_MSG_APPLICATIONSTATELISTUPREG:
         return OSAL_NEW midw_applicationmgrfi_tclMsgApplicationStateListUpReg;

      case midw_applicationmgrfi_tclToken::EN_MSG_APPLICATIONSTATELISTGET:
         return OSAL_NEW midw_applicationmgrfi_tclMsgApplicationStateListGet;

      case midw_applicationmgrfi_tclToken::EN_MSG_APPLICATIONSTATELISTSET:
         return OSAL_NEW midw_applicationmgrfi_tclMsgApplicationStateListSet;

      case midw_applicationmgrfi_tclToken::EN_MSG_APPLICATIONSTATELISTSTATUS:
         return OSAL_NEW midw_applicationmgrfi_tclMsgApplicationStateListStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_applicationmgrfifi messages

// common functions

tU16 midw_applicationmgrfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_APPLICATIONMGRFI_C_U16_SERVICE_ID;
}

tU16 midw_applicationmgrfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_applicationmgrfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_applicationmgrfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_applicationmgrfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_applicationmgrfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_applicationmgrfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_applicationmgrfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart::midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart& coRef)
   : midw_applicationmgrfi_tclMsgBaseMessage(coRef)
{
   ApplicationData = coRef.ApplicationData;
}
midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart& midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart::operator=(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ApplicationData = coRef.ApplicationData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart::midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart()
:ApplicationData()
 {}

tS32 midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart::s32GetTypeId() const
{
   return (tS32) midw_applicationmgrfi_tclToken::EN_MSG_APPLICATION_STATE_REQMETHODSTART;
}


midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart::~midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart()
{}

tU32 midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ApplicationData);
   return oIn;
}

fi_tclOutContext& midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ApplicationData);
   return oOut;
}

tBool midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart::operator==(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ApplicationData == roRef.ApplicationData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult::midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult& coRef)
   : midw_applicationmgrfi_tclMsgBaseMessage(coRef)
{
   ResultCode = coRef.ResultCode;
}
midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult& midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult::operator=(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResultCode = coRef.ResultCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult::midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult()
:ResultCode()
 {}

tS32 midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult::s32GetTypeId() const
{
   return (tS32) midw_applicationmgrfi_tclToken::EN_MSG_APPLICATION_STATE_REQMETHODRESULT;
}


midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult::~midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult()
{}

tU32 midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResultCode);
   return oIn;
}

fi_tclOutContext& midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResultCode);
   return oOut;
}

tBool midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult::operator==(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResultCode == roRef.ResultCode);
   return bResult;
}

//=============================================================================

midw_applicationmgrfi_tclMsgApplicationStateListUpReg::midw_applicationmgrfi_tclMsgApplicationStateListUpReg()
 {}

tS32 midw_applicationmgrfi_tclMsgApplicationStateListUpReg::s32GetTypeId() const
{
   return (tS32) midw_applicationmgrfi_tclToken::EN_MSG_APPLICATIONSTATELISTUPREG;
}


midw_applicationmgrfi_tclMsgApplicationStateListUpReg::~midw_applicationmgrfi_tclMsgApplicationStateListUpReg()
{}

//=============================================================================

midw_applicationmgrfi_tclMsgApplicationStateListGet::midw_applicationmgrfi_tclMsgApplicationStateListGet()
 {}

tS32 midw_applicationmgrfi_tclMsgApplicationStateListGet::s32GetTypeId() const
{
   return (tS32) midw_applicationmgrfi_tclToken::EN_MSG_APPLICATIONSTATELISTGET;
}


midw_applicationmgrfi_tclMsgApplicationStateListGet::~midw_applicationmgrfi_tclMsgApplicationStateListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_applicationmgrfi_tclMsgApplicationStateListSet::midw_applicationmgrfi_tclMsgApplicationStateListSet(const midw_applicationmgrfi_tclMsgApplicationStateListSet& coRef)
   : midw_applicationmgrfi_tclMsgBaseMessage(coRef)
{
   ApplicationData = coRef.ApplicationData;
}
midw_applicationmgrfi_tclMsgApplicationStateListSet& midw_applicationmgrfi_tclMsgApplicationStateListSet::operator=(const midw_applicationmgrfi_tclMsgApplicationStateListSet& coRef)
{
   if (this == &coRef) return *this;
   ApplicationData = coRef.ApplicationData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_applicationmgrfi_tclMsgApplicationStateListSet::midw_applicationmgrfi_tclMsgApplicationStateListSet()
:ApplicationData()
 {}

tS32 midw_applicationmgrfi_tclMsgApplicationStateListSet::s32GetTypeId() const
{
   return (tS32) midw_applicationmgrfi_tclToken::EN_MSG_APPLICATIONSTATELISTSET;
}


midw_applicationmgrfi_tclMsgApplicationStateListSet::~midw_applicationmgrfi_tclMsgApplicationStateListSet()
{}

tU32 midw_applicationmgrfi_tclMsgApplicationStateListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_applicationmgrfi_tclMsgApplicationStateListSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ApplicationData);
   return oIn;
}

fi_tclOutContext& midw_applicationmgrfi_tclMsgApplicationStateListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ApplicationData);
   return oOut;
}

tBool midw_applicationmgrfi_tclMsgApplicationStateListSet::operator==(const midw_applicationmgrfi_tclMsgApplicationStateListSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ApplicationData == roRef.ApplicationData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_applicationmgrfi_tclMsgApplicationStateListStatus::midw_applicationmgrfi_tclMsgApplicationStateListStatus(const midw_applicationmgrfi_tclMsgApplicationStateListStatus& coRef)
   : midw_applicationmgrfi_tclMsgBaseMessage(coRef)
{
   ApplicationList = coRef.ApplicationList;
}
midw_applicationmgrfi_tclMsgApplicationStateListStatus& midw_applicationmgrfi_tclMsgApplicationStateListStatus::operator=(const midw_applicationmgrfi_tclMsgApplicationStateListStatus& coRef)
{
   if (this == &coRef) return *this;
   ApplicationList = coRef.ApplicationList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_applicationmgrfi_tclMsgApplicationStateListStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ApplicationList.size(); ++u32Idx)
         ApplicationList[u32Idx].vDestroy();
   ApplicationList.clear();
   }
}

midw_applicationmgrfi_tclMsgApplicationStateListStatus::midw_applicationmgrfi_tclMsgApplicationStateListStatus()

 {}

tS32 midw_applicationmgrfi_tclMsgApplicationStateListStatus::s32GetTypeId() const
{
   return (tS32) midw_applicationmgrfi_tclToken::EN_MSG_APPLICATIONSTATELISTSTATUS;
}


midw_applicationmgrfi_tclMsgApplicationStateListStatus::~midw_applicationmgrfi_tclMsgApplicationStateListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_applicationmgrfi_tclMsgApplicationStateListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ApplicationList.size()*3);
}

fi_tclInContext& midw_applicationmgrfi_tclMsgApplicationStateListStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ApplicationList.size(); ++u32Idx)
      {
         ApplicationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ApplicationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ApplicationList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_applicationmgrfi_tclMsgApplicationStateListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ApplicationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ApplicationList.size(); ++u32Idx)
         (tVoid) (oOut << ApplicationList[u32Idx]);
   }
   return oOut;
}

tBool midw_applicationmgrfi_tclMsgApplicationStateListStatus::operator==(const midw_applicationmgrfi_tclMsgApplicationStateListStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ApplicationList.size() == roRef.ApplicationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ApplicationList.size()); ++u32Idx)
            bResult = bResult && (ApplicationList[u32Idx] == roRef.ApplicationList[u32Idx]);
      }
   return bResult;
}

