/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "midw_ext_fi_gen_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 midw_ext_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 midw_ext_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 midw_ext_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 midw_ext_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 midw_ext_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 midw_ext_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 midw_ext_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 midw_ext_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 midw_ext_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 midw_ext_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 midw_ext_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 midw_ext_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& midw_ext_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 midw_ext_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid midw_ext_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tclString::~midw_ext_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

midw_ext_fi_tclString& midw_ext_fi_tclString::operator=(const midw_ext_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

midw_ext_fi_tclString::midw_ext_fi_tclString(const midw_ext_fi_tclString& coRef):midw_ext_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& midw_ext_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool midw_ext_fi_tclString::operator==(const midw_ext_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 midw_ext_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
midw_ext_fi_tclString& midw_ext_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
midw_ext_fi_tclString::midw_ext_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool midw_ext_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

midw_ext_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

midw_ext_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool midw_ext_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar midw_ext_FI_C_U8_NULLCHAR = '\0';

tChar* midw_ext_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* midw_ext_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* midw_ext_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& midw_ext_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return midw_ext_FI_C_U8_NULLCHAR;
}

tChar& midw_ext_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return midw_ext_FI_C_U8_NULLCHAR;
}

tChar& midw_ext_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return midw_ext_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool midw_ext_fi_tclString::bSet(const midw_ext_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool midw_ext_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString midw_ext_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& midw_ext_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool midw_ext_fi_tclList::operator==(const midw_ext_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 midw_ext_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_ext_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid midw_ext_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tclMultiLanguageString::~midw_ext_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

midw_ext_fi_tclMultiLanguageString& midw_ext_fi_tclMultiLanguageString::operator=(const midw_ext_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

midw_ext_fi_tclMultiLanguageString::midw_ext_fi_tclMultiLanguageString(const midw_ext_fi_tclMultiLanguageString& coRef):midw_ext_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& midw_ext_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool midw_ext_fi_tclMultiLanguageString::operator==(const midw_ext_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 midw_ext_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
midw_ext_fi_tclMultiLanguageString& midw_ext_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
midw_ext_fi_tclMultiLanguageString::midw_ext_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool midw_ext_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

midw_ext_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

midw_ext_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool midw_ext_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* midw_ext_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* midw_ext_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* midw_ext_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& midw_ext_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return midw_ext_FI_C_U8_NULLCHAR;
}

tChar& midw_ext_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return midw_ext_FI_C_U8_NULLCHAR;
}

tChar& midw_ext_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return midw_ext_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool midw_ext_fi_tclMultiLanguageString::bSet(const midw_ext_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool midw_ext_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString midw_ext_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_BinContainer::midw_ext_fi_tcl_BinContainer(const midw_ext_fi_tcl_BinContainer& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
midw_ext_fi_tcl_BinContainer& midw_ext_fi_tcl_BinContainer::operator=(const midw_ext_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

midw_ext_fi_tcl_BinContainer::midw_ext_fi_tcl_BinContainer()

 {}

tS32 midw_ext_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_BINCONTAINER;
}


midw_ext_fi_tcl_BinContainer::~midw_ext_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& midw_ext_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_BinContainer::operator==(const midw_ext_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_fi_tcl_Reserved::midw_ext_fi_tcl_Reserved()
 {}

tS32 midw_ext_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_RESERVED;
}


midw_ext_fi_tcl_Reserved::~midw_ext_fi_tcl_Reserved()
{}

tU32 midw_ext_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& midw_ext_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_u8_Percent::midw_ext_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 midw_ext_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_U8_PERCENT;
}


midw_ext_fi_tcl_u8_Percent::~midw_ext_fi_tcl_u8_Percent()
{}

tU32 midw_ext_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s16_PerThousand::midw_ext_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_ext_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


midw_ext_fi_tcl_s16_PerThousand::~midw_ext_fi_tcl_s16_PerThousand()
{}

tU32 midw_ext_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_u16_IndexInReferenceList::midw_ext_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 midw_ext_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


midw_ext_fi_tcl_u16_IndexInReferenceList::~midw_ext_fi_tcl_u16_IndexInReferenceList()
{}

tU32 midw_ext_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_u16_ErrorCode::midw_ext_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 midw_ext_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_U16_ERRORCODE;
}


midw_ext_fi_tcl_u16_ErrorCode::~midw_ext_fi_tcl_u16_ErrorCode()
{}

tU32 midw_ext_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_u16_RPM::midw_ext_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 midw_ext_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_U16_RPM;
}


midw_ext_fi_tcl_u16_RPM::~midw_ext_fi_tcl_u16_RPM()
{}

tU32 midw_ext_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Kilogram::midw_ext_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_KILOGRAM;
}


midw_ext_fi_tcl_s32_Kilogram::~midw_ext_fi_tcl_s32_Kilogram()
{}

tU32 midw_ext_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Pound::midw_ext_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_POUND;
}


midw_ext_fi_tcl_s32_Pound::~midw_ext_fi_tcl_s32_Pound()
{}

tU32 midw_ext_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s16_Meter::midw_ext_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_ext_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S16_METER;
}


midw_ext_fi_tcl_s16_Meter::~midw_ext_fi_tcl_s16_Meter()
{}

tU32 midw_ext_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Meter::midw_ext_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_METER;
}


midw_ext_fi_tcl_s32_Meter::~midw_ext_fi_tcl_s32_Meter()
{}

tU32 midw_ext_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Yards::midw_ext_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_YARDS;
}


midw_ext_fi_tcl_s32_Yards::~midw_ext_fi_tcl_s32_Yards()
{}

tU32 midw_ext_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Foot::midw_ext_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_FOOT;
}


midw_ext_fi_tcl_s32_Foot::~midw_ext_fi_tcl_s32_Foot()
{}

tU32 midw_ext_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Centimeter::midw_ext_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_CENTIMETER;
}


midw_ext_fi_tcl_s32_Centimeter::~midw_ext_fi_tcl_s32_Centimeter()
{}

tU32 midw_ext_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Inch::midw_ext_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_INCH;
}


midw_ext_fi_tcl_s32_Inch::~midw_ext_fi_tcl_s32_Inch()
{}

tU32 midw_ext_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Millimeter::midw_ext_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_MILLIMETER;
}


midw_ext_fi_tcl_s32_Millimeter::~midw_ext_fi_tcl_s32_Millimeter()
{}

tU32 midw_ext_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Microliter::midw_ext_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_MICROLITER;
}


midw_ext_fi_tcl_s32_Microliter::~midw_ext_fi_tcl_s32_Microliter()
{}

tU32 midw_ext_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Second::midw_ext_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_SECOND;
}


midw_ext_fi_tcl_s32_Second::~midw_ext_fi_tcl_s32_Second()
{}

tU32 midw_ext_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_u16_MilliSecond::midw_ext_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 midw_ext_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_U16_MILLISECOND;
}


midw_ext_fi_tcl_u16_MilliSecond::~midw_ext_fi_tcl_u16_MilliSecond()
{}

tU32 midw_ext_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_MilliSecond::midw_ext_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_MILLISECOND;
}


midw_ext_fi_tcl_s32_MilliSecond::~midw_ext_fi_tcl_s32_MilliSecond()
{}

tU32 midw_ext_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_POSIXTime::midw_ext_fi_tcl_POSIXTime(const midw_ext_fi_tcl_POSIXTime& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
midw_ext_fi_tcl_POSIXTime& midw_ext_fi_tcl_POSIXTime::operator=(const midw_ext_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_POSIXTime::midw_ext_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 midw_ext_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_POSIXTIME;
}


midw_ext_fi_tcl_POSIXTime::~midw_ext_fi_tcl_POSIXTime()
{}

tU32 midw_ext_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool midw_ext_fi_tcl_POSIXTime::operator==(const midw_ext_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DST_State::midw_ext_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 midw_ext_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DST_STATE;
}


midw_ext_fi_tcl_e8_DST_State::~midw_ext_fi_tcl_e8_DST_State()
{}

tU32 midw_ext_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TimeZoneElement::midw_ext_fi_tcl_TimeZoneElement(const midw_ext_fi_tcl_TimeZoneElement& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
midw_ext_fi_tcl_TimeZoneElement& midw_ext_fi_tcl_TimeZoneElement::operator=(const midw_ext_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

midw_ext_fi_tcl_TimeZoneElement::midw_ext_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 midw_ext_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


midw_ext_fi_tcl_TimeZoneElement::~midw_ext_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+ static_cast<tU32>(DST_TimeDomain.size()*1);
}

fi_tclInContext& midw_ext_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_TimeZoneElement::operator==(const midw_ext_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s16_KmPerHour::midw_ext_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_ext_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S16_KMPERHOUR;
}


midw_ext_fi_tcl_s16_KmPerHour::~midw_ext_fi_tcl_s16_KmPerHour()
{}

tU32 midw_ext_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s16_MilesPerHour::midw_ext_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_ext_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


midw_ext_fi_tcl_s16_MilesPerHour::~midw_ext_fi_tcl_s16_MilesPerHour()
{}

tU32 midw_ext_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s16_Knot::midw_ext_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_ext_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S16_KNOT;
}


midw_ext_fi_tcl_s16_Knot::~midw_ext_fi_tcl_s16_Knot()
{}

tU32 midw_ext_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s16_CentimeterSecond::midw_ext_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_ext_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


midw_ext_fi_tcl_s16_CentimeterSecond::~midw_ext_fi_tcl_s16_CentimeterSecond()
{}

tU32 midw_ext_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s16_Kelvin::midw_ext_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_ext_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S16_KELVIN;
}


midw_ext_fi_tcl_s16_Kelvin::~midw_ext_fi_tcl_s16_Kelvin()
{}

tU32 midw_ext_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s16_Fahrenheit::midw_ext_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_ext_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


midw_ext_fi_tcl_s16_Fahrenheit::~midw_ext_fi_tcl_s16_Fahrenheit()
{}

tU32 midw_ext_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Pascal::midw_ext_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_PASCAL;
}


midw_ext_fi_tcl_s32_Pascal::~midw_ext_fi_tcl_s32_Pascal()
{}

tU32 midw_ext_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Watt::midw_ext_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_WATT;
}


midw_ext_fi_tcl_s32_Watt::~midw_ext_fi_tcl_s32_Watt()
{}

tU32 midw_ext_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_FIVersion::midw_ext_fi_tcl_FIVersion(const midw_ext_fi_tcl_FIVersion& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
midw_ext_fi_tcl_FIVersion& midw_ext_fi_tcl_FIVersion::operator=(const midw_ext_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_FIVersion::midw_ext_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 midw_ext_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_FIVERSION;
}


midw_ext_fi_tcl_FIVersion::~midw_ext_fi_tcl_FIVersion()
{}

tU32 midw_ext_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool midw_ext_fi_tcl_FIVersion::operator==(const midw_ext_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Longitude::midw_ext_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_LONGITUDE;
}


midw_ext_fi_tcl_s32_Longitude::~midw_ext_fi_tcl_s32_Longitude()
{}

tU32 midw_ext_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s32_Latitude::midw_ext_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_ext_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S32_LATITUDE;
}


midw_ext_fi_tcl_s32_Latitude::~midw_ext_fi_tcl_s32_Latitude()
{}

tU32 midw_ext_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PositionWGS84::midw_ext_fi_tcl_PositionWGS84(const midw_ext_fi_tcl_PositionWGS84& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
midw_ext_fi_tcl_PositionWGS84& midw_ext_fi_tcl_PositionWGS84::operator=(const midw_ext_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PositionWGS84::midw_ext_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 midw_ext_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_POSITIONWGS84;
}


midw_ext_fi_tcl_PositionWGS84::~midw_ext_fi_tcl_PositionWGS84()
{}

tU32 midw_ext_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool midw_ext_fi_tcl_PositionWGS84::operator==(const midw_ext_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_RectangleWGS84::midw_ext_fi_tcl_RectangleWGS84(const midw_ext_fi_tcl_RectangleWGS84& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
midw_ext_fi_tcl_RectangleWGS84& midw_ext_fi_tcl_RectangleWGS84::operator=(const midw_ext_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_RectangleWGS84::midw_ext_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 midw_ext_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_RECTANGLEWGS84;
}


midw_ext_fi_tcl_RectangleWGS84::~midw_ext_fi_tcl_RectangleWGS84()
{}

tU32 midw_ext_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& midw_ext_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool midw_ext_fi_tcl_RectangleWGS84::operator==(const midw_ext_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e16_ISOCountryCode::midw_ext_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 midw_ext_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


midw_ext_fi_tcl_e16_ISOCountryCode::~midw_ext_fi_tcl_e16_ISOCountryCode()
{}

tU32 midw_ext_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e16_ISOLanguageCode::midw_ext_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 midw_ext_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


midw_ext_fi_tcl_e16_ISOLanguageCode::~midw_ext_fi_tcl_e16_ISOLanguageCode()
{}

tU32 midw_ext_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_LanguageID::midw_ext_fi_tcl_LanguageID(const midw_ext_fi_tcl_LanguageID& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
midw_ext_fi_tcl_LanguageID& midw_ext_fi_tcl_LanguageID::operator=(const midw_ext_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_LanguageID::midw_ext_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 midw_ext_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_LANGUAGEID;
}


midw_ext_fi_tcl_LanguageID::~midw_ext_fi_tcl_LanguageID()
{}

tU32 midw_ext_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool midw_ext_fi_tcl_LanguageID::operator==(const midw_ext_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_u8_DirectionAbsolute::midw_ext_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 midw_ext_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


midw_ext_fi_tcl_u8_DirectionAbsolute::~midw_ext_fi_tcl_u8_DirectionAbsolute()
{}

tU32 midw_ext_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_u8_DirectionRelative::midw_ext_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 midw_ext_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


midw_ext_fi_tcl_u8_DirectionRelative::~midw_ext_fi_tcl_u8_DirectionRelative()
{}

tU32 midw_ext_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s16_CentiDegree::midw_ext_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_ext_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


midw_ext_fi_tcl_s16_CentiDegree::~midw_ext_fi_tcl_s16_CentiDegree()
{}

tU32 midw_ext_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s16_Degree::midw_ext_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_ext_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S16_DEGREE;
}


midw_ext_fi_tcl_s16_Degree::~midw_ext_fi_tcl_s16_Degree()
{}

tU32 midw_ext_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree::midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree::~midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree::midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree::~midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_FuelType::midw_ext_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 midw_ext_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_FUELTYPE;
}


midw_ext_fi_tcl_e8_FuelType::~midw_ext_fi_tcl_e8_FuelType()
{}

tU32 midw_ext_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DistTimeFuel::midw_ext_fi_tcl_DistTimeFuel(const midw_ext_fi_tcl_DistTimeFuel& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
midw_ext_fi_tcl_DistTimeFuel& midw_ext_fi_tcl_DistTimeFuel::operator=(const midw_ext_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DistTimeFuel::midw_ext_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 midw_ext_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DISTTIMEFUEL;
}


midw_ext_fi_tcl_DistTimeFuel::~midw_ext_fi_tcl_DistTimeFuel()
{}

tU32 midw_ext_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_ext_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool midw_ext_fi_tcl_DistTimeFuel::operator==(const midw_ext_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_Response::midw_ext_fi_tcl_e8_DAB_Response():enType(FI_EN_DAB_RES_OK) {}

tS32 midw_ext_fi_tcl_e8_DAB_Response::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_RESPONSE;
}


midw_ext_fi_tcl_e8_DAB_Response::~midw_ext_fi_tcl_e8_DAB_Response()
{}

tU32 midw_ext_fi_tcl_e8_DAB_Response::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_Response::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_Response::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_UserProfileAction::midw_ext_fi_tcl_e8_DAB_UserProfileAction():enType(FI_EN_DAB_PROFILE_CHANGE) {}

tS32 midw_ext_fi_tcl_e8_DAB_UserProfileAction::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_USERPROFILEACTION;
}


midw_ext_fi_tcl_e8_DAB_UserProfileAction::~midw_ext_fi_tcl_e8_DAB_UserProfileAction()
{}

tU32 midw_ext_fi_tcl_e8_DAB_UserProfileAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_UserProfileAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_UserProfileAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_SourceState::midw_ext_fi_tcl_e8_DAB_SourceState():enType(FI_EN_DAB_BACKGROUND) {}

tS32 midw_ext_fi_tcl_e8_DAB_SourceState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_SOURCESTATE;
}


midw_ext_fi_tcl_e8_DAB_SourceState::~midw_ext_fi_tcl_e8_DAB_SourceState()
{}

tU32 midw_ext_fi_tcl_e8_DAB_SourceState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_SourceState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_SourceState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_Label::midw_ext_fi_tcl_DAB_Label(const midw_ext_fi_tcl_DAB_Label& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sLabel = coRef.sLabel;
   sLabelShort = coRef.sLabelShort;
   u16LabelMask = coRef.u16LabelMask;
}
midw_ext_fi_tcl_DAB_Label& midw_ext_fi_tcl_DAB_Label::operator=(const midw_ext_fi_tcl_DAB_Label& coRef)
{
   if (this == &coRef) return *this;
   sLabel = coRef.sLabel;
   sLabelShort = coRef.sLabelShort;
   u16LabelMask = coRef.u16LabelMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_Label::vDestroy()
{
   sLabel.vDestroy();
   sLabelShort.vDestroy();
}

midw_ext_fi_tcl_DAB_Label::midw_ext_fi_tcl_DAB_Label()
:sLabel()
,sLabelShort()
,u16LabelMask(0)
 {}

tS32 midw_ext_fi_tcl_DAB_Label::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_LABEL;
}


midw_ext_fi_tcl_DAB_Label::~midw_ext_fi_tcl_DAB_Label()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_Label::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sLabel.u32GetSize(u16MajorVersion)+sLabelShort.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_Label::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sLabel);
   (tVoid) (oIn >> sLabelShort);
   (tVoid) (oIn >> u16LabelMask);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_Label::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sLabel);
   (tVoid) (oOut << sLabelShort);
   (tVoid) (oOut << u16LabelMask);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_Label::operator==(const midw_ext_fi_tcl_DAB_Label& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sLabel == roRef.sLabel);
   bResult = bResult && (sLabelShort == roRef.sLabelShort);
   bResult = bResult && (u16LabelMask == roRef.u16LabelMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_ServiceType::midw_ext_fi_tcl_e8_DAB_ServiceType():enType(FI_EN_DAB_SERVICETYPE_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_DAB_ServiceType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_SERVICETYPE;
}


midw_ext_fi_tcl_e8_DAB_ServiceType::~midw_ext_fi_tcl_e8_DAB_ServiceType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_ServiceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_ServiceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_ServiceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_ServiceListSortingType::midw_ext_fi_tcl_e8_DAB_ServiceListSortingType():enType(FI_EN_DAB_SERVICELIST_SORTINGTYPE_LABEL) {}

tS32 midw_ext_fi_tcl_e8_DAB_ServiceListSortingType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_SERVICELISTSORTINGTYPE;
}


midw_ext_fi_tcl_e8_DAB_ServiceListSortingType::~midw_ext_fi_tcl_e8_DAB_ServiceListSortingType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_ServiceListSortingType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_ServiceListSortingType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_ServiceListSortingType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType::midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType():enType(FI_EN_DAB_ENSEMBLELIST_SORTINGTYPE_LABEL) {}

tS32 midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_ENSEMBLELISTSORTINGTYPE;
}


midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType::~midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_AST_Type::midw_ext_fi_tcl_e8_DAB_AST_Type():enType(FI_EN_DAB_AST_NORMAL) {}

tS32 midw_ext_fi_tcl_e8_DAB_AST_Type::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_AST_TYPE;
}


midw_ext_fi_tcl_e8_DAB_AST_Type::~midw_ext_fi_tcl_e8_DAB_AST_Type()
{}

tU32 midw_ext_fi_tcl_e8_DAB_AST_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_AST_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_AST_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode::midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode():enType(FI_EN_DAB_SERVICELINKING_OFF) {}

tS32 midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_SERVICELINKINGMODE;
}


midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode::~midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode()
{}

tU32 midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b8_DAB_MTC_SetMode::midw_ext_fi_tcl_b8_DAB_MTC_SetMode():u8Value(0)
{}

tS32 midw_ext_fi_tcl_b8_DAB_MTC_SetMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B8_DAB_MTC_SETMODE;
}


midw_ext_fi_tcl_b8_DAB_MTC_SetMode::~midw_ext_fi_tcl_b8_DAB_MTC_SetMode()
{}

tU32 midw_ext_fi_tcl_b8_DAB_MTC_SetMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_b8_DAB_MTC_SetMode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b8_DAB_MTC_SetMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_MTC_Request::midw_ext_fi_tcl_e8_MTC_Request():enType(FI_EN_DAB_SERVICELINKING_FM) {}

tS32 midw_ext_fi_tcl_e8_MTC_Request::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_MTC_REQUEST;
}


midw_ext_fi_tcl_e8_MTC_Request::~midw_ext_fi_tcl_e8_MTC_Request()
{}

tU32 midw_ext_fi_tcl_e8_MTC_Request::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_MTC_Request::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_MTC_Request::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_MTC_Tuner_Status::midw_ext_fi_tcl_e8_MTC_Tuner_Status():enType(FI_EN_MAIN_DAB_TUNER) {}

tS32 midw_ext_fi_tcl_e8_MTC_Tuner_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_MTC_TUNER_STATUS;
}


midw_ext_fi_tcl_e8_MTC_Tuner_Status::~midw_ext_fi_tcl_e8_MTC_Tuner_Status()
{}

tU32 midw_ext_fi_tcl_e8_MTC_Tuner_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_MTC_Tuner_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_MTC_Tuner_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState::midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState():enType(FI_EN_STOPPED) {}

tS32 midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_MTC_TUNER_ACTIVITYSTATE;
}


midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState::~midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState()
{}

tU32 midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_StationType::midw_ext_fi_tcl_e8_StationType():enType(FI_EN_DAB) {}

tS32 midw_ext_fi_tcl_e8_StationType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_STATIONTYPE;
}


midw_ext_fi_tcl_e8_StationType::~midw_ext_fi_tcl_e8_StationType()
{}

tU32 midw_ext_fi_tcl_e8_StationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_StationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_StationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TPState::midw_ext_fi_tcl_e8_TPState():enType(FI_EN_NO_TP) {}

tS32 midw_ext_fi_tcl_e8_TPState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TPSTATE;
}


midw_ext_fi_tcl_e8_TPState::~midw_ext_fi_tcl_e8_TPState()
{}

tU32 midw_ext_fi_tcl_e8_TPState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TPState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TPState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_SampleRate::midw_ext_fi_tcl_e8_DAB_SampleRate():enType(FI_EN_DAB_SAMPLERATE_48KHZ) {}

tS32 midw_ext_fi_tcl_e8_DAB_SampleRate::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_SAMPLERATE;
}


midw_ext_fi_tcl_e8_DAB_SampleRate::~midw_ext_fi_tcl_e8_DAB_SampleRate()
{}

tU32 midw_ext_fi_tcl_e8_DAB_SampleRate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_SampleRate::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_SampleRate::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_AudioMode::midw_ext_fi_tcl_e8_DAB_AudioMode():enType(FI_EN_DAB_AUDIOMODE_STEREO) {}

tS32 midw_ext_fi_tcl_e8_DAB_AudioMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_AUDIOMODE;
}


midw_ext_fi_tcl_e8_DAB_AudioMode::~midw_ext_fi_tcl_e8_DAB_AudioMode()
{}

tU32 midw_ext_fi_tcl_e8_DAB_AudioMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_AudioMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_AudioMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_AudioCodec::midw_ext_fi_tcl_e8_DAB_AudioCodec():enType(FI_EN_DAB_AUDIOCODEC_NOT_RECOGNIZED) {}

tS32 midw_ext_fi_tcl_e8_DAB_AudioCodec::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_AUDIOCODEC;
}


midw_ext_fi_tcl_e8_DAB_AudioCodec::~midw_ext_fi_tcl_e8_DAB_AudioCodec()
{}

tU32 midw_ext_fi_tcl_e8_DAB_AudioCodec::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_AudioCodec::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_AudioCodec::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_Encoding::midw_ext_fi_tcl_e8_DAB_Encoding():enType(FI_EN_DAB_ENCODING_MPEG1) {}

tS32 midw_ext_fi_tcl_e8_DAB_Encoding::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_ENCODING;
}


midw_ext_fi_tcl_e8_DAB_Encoding::~midw_ext_fi_tcl_e8_DAB_Encoding()
{}

tU32 midw_ext_fi_tcl_e8_DAB_Encoding::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_Encoding::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_Encoding::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_ComponentType::midw_ext_fi_tcl_e8_DAB_ComponentType():enType(FI_EN_DAB_COMPONENTTYPE_PRIMARY) {}

tS32 midw_ext_fi_tcl_e8_DAB_ComponentType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_COMPONENTTYPE;
}


midw_ext_fi_tcl_e8_DAB_ComponentType::~midw_ext_fi_tcl_e8_DAB_ComponentType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_ComponentType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_ComponentType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_ComponentType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_TMIdType::midw_ext_fi_tcl_e8_DAB_TMIdType():enType(FI_EN_DAB_TMIDTYPE_MSC_AUDIO_STREAM) {}

tS32 midw_ext_fi_tcl_e8_DAB_TMIdType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_TMIDTYPE;
}


midw_ext_fi_tcl_e8_DAB_TMIdType::~midw_ext_fi_tcl_e8_DAB_TMIdType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_TMIdType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_TMIdType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_TMIdType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType::midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType():enType(FI_EN_DAB_ASCTY_FG_SOUND) {}

tS32 midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_AUDIOSERVICECOMPONENTTYPE;
}


midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType::~midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_DataServiceComponentType::midw_ext_fi_tcl_e8_DAB_DataServiceComponentType():enType(FI_EN_DAB_DSCTY_NOT_SPECIFIED) {}

tS32 midw_ext_fi_tcl_e8_DAB_DataServiceComponentType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_DATASERVICECOMPONENTTYPE;
}


midw_ext_fi_tcl_e8_DAB_DataServiceComponentType::~midw_ext_fi_tcl_e8_DAB_DataServiceComponentType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_DataServiceComponentType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_DataServiceComponentType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_DataServiceComponentType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b16_DAB_AnnouncementType::midw_ext_fi_tcl_b16_DAB_AnnouncementType():u16Value(0)
{}

tS32 midw_ext_fi_tcl_b16_DAB_AnnouncementType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B16_DAB_ANNOUNCEMENTTYPE;
}


midw_ext_fi_tcl_b16_DAB_AnnouncementType::~midw_ext_fi_tcl_b16_DAB_AnnouncementType()
{}

tU32 midw_ext_fi_tcl_b16_DAB_AnnouncementType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_b16_DAB_AnnouncementType::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b16_DAB_AnnouncementType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState::midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState():enType(FI_EN_IDLE) {}

tS32 midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_ANNOUNCEMENTSELECTSTATE;
}


midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState::~midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState()
{}

tU32 midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::midw_ext_fi_tcl_e8_DAB_AnnouncementStatus():enType(FI_EN_START) {}

tS32 midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_ANNOUNCEMENTSTATUS;
}


midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::~midw_ext_fi_tcl_e8_DAB_AnnouncementStatus()
{}

tU32 midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_AnnouncementSource::midw_ext_fi_tcl_e8_DAB_AnnouncementSource():enType(FI_EN_DAB_ANNOSOURCE_NONE) {}

tS32 midw_ext_fi_tcl_e8_DAB_AnnouncementSource::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_ANNOUNCEMENTSOURCE;
}


midw_ext_fi_tcl_e8_DAB_AnnouncementSource::~midw_ext_fi_tcl_e8_DAB_AnnouncementSource()
{}

tU32 midw_ext_fi_tcl_e8_DAB_AnnouncementSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_AnnouncementSource::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_AnnouncementSource::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_ChnSelectMode::midw_ext_fi_tcl_e8_DAB_ChnSelectMode():enType(FI_EN_DAB_CHNSELECTMODE_PSDI) {}

tS32 midw_ext_fi_tcl_e8_DAB_ChnSelectMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_CHNSELECTMODE;
}


midw_ext_fi_tcl_e8_DAB_ChnSelectMode::~midw_ext_fi_tcl_e8_DAB_ChnSelectMode()
{}

tU32 midw_ext_fi_tcl_e8_DAB_ChnSelectMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_ChnSelectMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_ChnSelectMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_EnsSelectMode::midw_ext_fi_tcl_e8_DAB_EnsSelectMode():enType(FI_EN_DAB_ENSSELECTMODE_ENSID) {}

tS32 midw_ext_fi_tcl_e8_DAB_EnsSelectMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_ENSSELECTMODE;
}


midw_ext_fi_tcl_e8_DAB_EnsSelectMode::~midw_ext_fi_tcl_e8_DAB_EnsSelectMode()
{}

tU32 midw_ext_fi_tcl_e8_DAB_EnsSelectMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_EnsSelectMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_EnsSelectMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_CompSelectMode::midw_ext_fi_tcl_e8_DAB_CompSelectMode():enType(FI_EN_DAB_CHNSELECTMODE_SCID) {}

tS32 midw_ext_fi_tcl_e8_DAB_CompSelectMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_COMPSELECTMODE;
}


midw_ext_fi_tcl_e8_DAB_CompSelectMode::~midw_ext_fi_tcl_e8_DAB_CompSelectMode()
{}

tU32 midw_ext_fi_tcl_e8_DAB_CompSelectMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_CompSelectMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_CompSelectMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_UriSelectState::midw_ext_fi_tcl_e8_DAB_UriSelectState():enType(FI_EN_DAB_URI_SELECT_STATE_OK) {}

tS32 midw_ext_fi_tcl_e8_DAB_UriSelectState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_URISELECTSTATE;
}


midw_ext_fi_tcl_e8_DAB_UriSelectState::~midw_ext_fi_tcl_e8_DAB_UriSelectState()
{}

tU32 midw_ext_fi_tcl_e8_DAB_UriSelectState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_UriSelectState::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_UriSelectState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_TunerActivityType::midw_ext_fi_tcl_e8_DAB_TunerActivityType():enType(FI_EN_DAB_ACTIVITYTYPE_NORMAL) {}

tS32 midw_ext_fi_tcl_e8_DAB_TunerActivityType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_TUNERACTIVITYTYPE;
}


midw_ext_fi_tcl_e8_DAB_TunerActivityType::~midw_ext_fi_tcl_e8_DAB_TunerActivityType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_TunerActivityType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_TunerActivityType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_TunerActivityType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_Frequency::midw_ext_fi_tcl_DAB_Frequency(const midw_ext_fi_tcl_DAB_Frequency& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32Frequency = coRef.u32Frequency;
   sFreqLabel = coRef.sFreqLabel;
}
midw_ext_fi_tcl_DAB_Frequency& midw_ext_fi_tcl_DAB_Frequency::operator=(const midw_ext_fi_tcl_DAB_Frequency& coRef)
{
   if (this == &coRef) return *this;
   u32Frequency = coRef.u32Frequency;
   sFreqLabel = coRef.sFreqLabel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_Frequency::vDestroy()
{
   sFreqLabel.vDestroy();
}

midw_ext_fi_tcl_DAB_Frequency::midw_ext_fi_tcl_DAB_Frequency()
:u32Frequency(0)
,sFreqLabel()
 {}

tS32 midw_ext_fi_tcl_DAB_Frequency::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_FREQUENCY;
}


midw_ext_fi_tcl_DAB_Frequency::~midw_ext_fi_tcl_DAB_Frequency()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_Frequency::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+sFreqLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_Frequency::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> sFreqLabel);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_Frequency::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << sFreqLabel);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_Frequency::operator==(const midw_ext_fi_tcl_DAB_Frequency& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (sFreqLabel == roRef.sFreqLabel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_FrequencyTable::midw_ext_fi_tcl_e8_DAB_FrequencyTable():enType(FI_EN_DAB_FREQTABLE_AUTO) {}

tS32 midw_ext_fi_tcl_e8_DAB_FrequencyTable::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_FREQUENCYTABLE;
}


midw_ext_fi_tcl_e8_DAB_FrequencyTable::~midw_ext_fi_tcl_e8_DAB_FrequencyTable()
{}

tU32 midw_ext_fi_tcl_e8_DAB_FrequencyTable::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_FrequencyTable::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_FrequencyTable::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b16_DAB_TunerStatusFlags::midw_ext_fi_tcl_b16_DAB_TunerStatusFlags():u16Value(0)
{}

tS32 midw_ext_fi_tcl_b16_DAB_TunerStatusFlags::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B16_DAB_TUNERSTATUSFLAGS;
}


midw_ext_fi_tcl_b16_DAB_TunerStatusFlags::~midw_ext_fi_tcl_b16_DAB_TunerStatusFlags()
{}

tU32 midw_ext_fi_tcl_b16_DAB_TunerStatusFlags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_b16_DAB_TunerStatusFlags::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b16_DAB_TunerStatusFlags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_TunerStatus::midw_ext_fi_tcl_DAB_TunerStatus(const midw_ext_fi_tcl_DAB_TunerStatus& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8TunerActivityType = coRef.e8TunerActivityType;
   FreqTuned = coRef.FreqTuned;
   sFrequencyTable = coRef.sFrequencyTable;
   b16Flags = coRef.b16Flags;
   u8SignalQuality = coRef.u8SignalQuality;
   u8AudioQuality = coRef.u8AudioQuality;
   u32CurrentEnsembleId = coRef.u32CurrentEnsembleId;
   u32CurrentServiceId = coRef.u32CurrentServiceId;
   u16CurrentSCIDI = coRef.u16CurrentSCIDI;
}
midw_ext_fi_tcl_DAB_TunerStatus& midw_ext_fi_tcl_DAB_TunerStatus::operator=(const midw_ext_fi_tcl_DAB_TunerStatus& coRef)
{
   if (this == &coRef) return *this;
   e8TunerActivityType = coRef.e8TunerActivityType;
   FreqTuned = coRef.FreqTuned;
   sFrequencyTable = coRef.sFrequencyTable;
   b16Flags = coRef.b16Flags;
   u8SignalQuality = coRef.u8SignalQuality;
   u8AudioQuality = coRef.u8AudioQuality;
   u32CurrentEnsembleId = coRef.u32CurrentEnsembleId;
   u32CurrentServiceId = coRef.u32CurrentServiceId;
   u16CurrentSCIDI = coRef.u16CurrentSCIDI;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_TunerStatus::vDestroy()
{
   FreqTuned.vDestroy(); 
   sFrequencyTable.vDestroy();
}

midw_ext_fi_tcl_DAB_TunerStatus::midw_ext_fi_tcl_DAB_TunerStatus()
:e8TunerActivityType()
,FreqTuned()
,sFrequencyTable()
,b16Flags()
,u8SignalQuality(0)
,u8AudioQuality(0)
,u32CurrentEnsembleId(0)
,u32CurrentServiceId(0)
,u16CurrentSCIDI(0)
 {}

tS32 midw_ext_fi_tcl_DAB_TunerStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_TUNERSTATUS;
}


midw_ext_fi_tcl_DAB_TunerStatus::~midw_ext_fi_tcl_DAB_TunerStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_TunerStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 15+FreqTuned.u32GetSize(u16MajorVersion)+sFrequencyTable.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_TunerStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8TunerActivityType);
   (tVoid) (oIn >> FreqTuned);
   (tVoid) (oIn >> sFrequencyTable);
   (tVoid) (oIn >> b16Flags);
   (tVoid) (oIn >> u8SignalQuality);
   (tVoid) (oIn >> u8AudioQuality);
   (tVoid) (oIn >> u32CurrentEnsembleId);
   (tVoid) (oIn >> u32CurrentServiceId);
   (tVoid) (oIn >> u16CurrentSCIDI);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_TunerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8TunerActivityType);
   (tVoid) (oOut << FreqTuned);
   (tVoid) (oOut << sFrequencyTable);
   (tVoid) (oOut << b16Flags);
   (tVoid) (oOut << u8SignalQuality);
   (tVoid) (oOut << u8AudioQuality);
   (tVoid) (oOut << u32CurrentEnsembleId);
   (tVoid) (oOut << u32CurrentServiceId);
   (tVoid) (oOut << u16CurrentSCIDI);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_TunerStatus::operator==(const midw_ext_fi_tcl_DAB_TunerStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8TunerActivityType == roRef.e8TunerActivityType);
   bResult = bResult && (FreqTuned == roRef.FreqTuned);
   bResult = bResult && (sFrequencyTable == roRef.sFrequencyTable);
   bResult = bResult && (b16Flags == roRef.b16Flags);
   bResult = bResult && (u8SignalQuality == roRef.u8SignalQuality);
   bResult = bResult && (u8AudioQuality == roRef.u8AudioQuality);
   bResult = bResult && (u32CurrentEnsembleId == roRef.u32CurrentEnsembleId);
   bResult = bResult && (u32CurrentServiceId == roRef.u32CurrentServiceId);
   bResult = bResult && (u16CurrentSCIDI == roRef.u16CurrentSCIDI);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_RadioText::midw_ext_fi_tcl_DAB_RadioText(const midw_ext_fi_tcl_DAB_RadioText& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sRadioTextData = coRef.sRadioTextData;
   bValid = coRef.bValid;
   u8CharSet = coRef.u8CharSet;
}
midw_ext_fi_tcl_DAB_RadioText& midw_ext_fi_tcl_DAB_RadioText::operator=(const midw_ext_fi_tcl_DAB_RadioText& coRef)
{
   if (this == &coRef) return *this;
   sRadioTextData = coRef.sRadioTextData;
   bValid = coRef.bValid;
   u8CharSet = coRef.u8CharSet;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_RadioText::vDestroy()
{
   sRadioTextData.vDestroy();
}

midw_ext_fi_tcl_DAB_RadioText::midw_ext_fi_tcl_DAB_RadioText()
:sRadioTextData()
,bValid(0)
,u8CharSet(0)
 {}

tS32 midw_ext_fi_tcl_DAB_RadioText::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_RADIOTEXT;
}


midw_ext_fi_tcl_DAB_RadioText::~midw_ext_fi_tcl_DAB_RadioText()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_RadioText::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sRadioTextData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_RadioText::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sRadioTextData);
   (tVoid) (oIn >> bValid);
   (tVoid) (oIn >> u8CharSet);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_RadioText::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sRadioTextData);
   (tVoid) (oOut << bValid);
   (tVoid) (oOut << u8CharSet);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_RadioText::operator==(const midw_ext_fi_tcl_DAB_RadioText& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sRadioTextData == roRef.sRadioTextData);
   bResult = bResult && (bValid == roRef.bValid);
   bResult = bResult && (u8CharSet == roRef.u8CharSet);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_RadioTextPlus::midw_ext_fi_tcl_DAB_RadioTextPlus(const midw_ext_fi_tcl_DAB_RadioTextPlus& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8ContentType = coRef.u8ContentType;
   Content = coRef.Content;
}
midw_ext_fi_tcl_DAB_RadioTextPlus& midw_ext_fi_tcl_DAB_RadioTextPlus::operator=(const midw_ext_fi_tcl_DAB_RadioTextPlus& coRef)
{
   if (this == &coRef) return *this;
   u8ContentType = coRef.u8ContentType;
   Content = coRef.Content;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_RadioTextPlus::vDestroy()
{
   Content.vDestroy(); 
}

midw_ext_fi_tcl_DAB_RadioTextPlus::midw_ext_fi_tcl_DAB_RadioTextPlus()
:u8ContentType(0)
,Content()
 {}

tS32 midw_ext_fi_tcl_DAB_RadioTextPlus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_RADIOTEXTPLUS;
}


midw_ext_fi_tcl_DAB_RadioTextPlus::~midw_ext_fi_tcl_DAB_RadioTextPlus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_RadioTextPlus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Content.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_RadioTextPlus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8ContentType);
   (tVoid) (oIn >> Content);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_RadioTextPlus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8ContentType);
   (tVoid) (oOut << Content);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_RadioTextPlus::operator==(const midw_ext_fi_tcl_DAB_RadioTextPlus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8ContentType == roRef.u8ContentType);
   bResult = bResult && (Content == roRef.Content);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_EnsembleInfo::midw_ext_fi_tcl_DAB_EnsembleInfo(const midw_ext_fi_tcl_DAB_EnsembleInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32EnsembleId = coRef.u32EnsembleId;
   EnsembleLabel = coRef.EnsembleLabel;
   u32Frequency = coRef.u32Frequency;
   u8NumberOfAudioServices = coRef.u8NumberOfAudioServices;
   u8NumberOfDataServices = coRef.u8NumberOfDataServices;
   u8NumberOfAudioServiceComponents = coRef.u8NumberOfAudioServiceComponents;
   u8NumberOfDataServiceComponents = coRef.u8NumberOfDataServiceComponents;
   u8ReceptionQuality = coRef.u8ReceptionQuality;
   u8NumberOfEnsembles = coRef.u8NumberOfEnsembles;
   u8ListElementId = coRef.u8ListElementId;
   bReception = coRef.bReception;
}
midw_ext_fi_tcl_DAB_EnsembleInfo& midw_ext_fi_tcl_DAB_EnsembleInfo::operator=(const midw_ext_fi_tcl_DAB_EnsembleInfo& coRef)
{
   if (this == &coRef) return *this;
   u32EnsembleId = coRef.u32EnsembleId;
   EnsembleLabel = coRef.EnsembleLabel;
   u32Frequency = coRef.u32Frequency;
   u8NumberOfAudioServices = coRef.u8NumberOfAudioServices;
   u8NumberOfDataServices = coRef.u8NumberOfDataServices;
   u8NumberOfAudioServiceComponents = coRef.u8NumberOfAudioServiceComponents;
   u8NumberOfDataServiceComponents = coRef.u8NumberOfDataServiceComponents;
   u8ReceptionQuality = coRef.u8ReceptionQuality;
   u8NumberOfEnsembles = coRef.u8NumberOfEnsembles;
   u8ListElementId = coRef.u8ListElementId;
   bReception = coRef.bReception;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_EnsembleInfo::vDestroy()
{
   EnsembleLabel.vDestroy(); 
}

midw_ext_fi_tcl_DAB_EnsembleInfo::midw_ext_fi_tcl_DAB_EnsembleInfo()
:u32EnsembleId(0)
,EnsembleLabel()
,u32Frequency(0)
,u8NumberOfAudioServices(0)
,u8NumberOfDataServices(0)
,u8NumberOfAudioServiceComponents(0)
,u8NumberOfDataServiceComponents(0)
,u8ReceptionQuality(0)
,u8NumberOfEnsembles(0)
,u8ListElementId(0)
,bReception(0)
 {}

tS32 midw_ext_fi_tcl_DAB_EnsembleInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_ENSEMBLEINFO;
}


midw_ext_fi_tcl_DAB_EnsembleInfo::~midw_ext_fi_tcl_DAB_EnsembleInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_EnsembleInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 16+EnsembleLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_EnsembleInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32EnsembleId);
   (tVoid) (oIn >> EnsembleLabel);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u8NumberOfAudioServices);
   (tVoid) (oIn >> u8NumberOfDataServices);
   (tVoid) (oIn >> u8NumberOfAudioServiceComponents);
   (tVoid) (oIn >> u8NumberOfDataServiceComponents);
   (tVoid) (oIn >> u8ReceptionQuality);
   (tVoid) (oIn >> u8NumberOfEnsembles);
   (tVoid) (oIn >> u8ListElementId);
   (tVoid) (oIn >> bReception);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_EnsembleInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32EnsembleId);
   (tVoid) (oOut << EnsembleLabel);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u8NumberOfAudioServices);
   (tVoid) (oOut << u8NumberOfDataServices);
   (tVoid) (oOut << u8NumberOfAudioServiceComponents);
   (tVoid) (oOut << u8NumberOfDataServiceComponents);
   (tVoid) (oOut << u8ReceptionQuality);
   (tVoid) (oOut << u8NumberOfEnsembles);
   (tVoid) (oOut << u8ListElementId);
   (tVoid) (oOut << bReception);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_EnsembleInfo::operator==(const midw_ext_fi_tcl_DAB_EnsembleInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32EnsembleId == roRef.u32EnsembleId);
   bResult = bResult && (EnsembleLabel == roRef.EnsembleLabel);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u8NumberOfAudioServices == roRef.u8NumberOfAudioServices);
   bResult = bResult && (u8NumberOfDataServices == roRef.u8NumberOfDataServices);
   bResult = bResult && (u8NumberOfAudioServiceComponents == roRef.u8NumberOfAudioServiceComponents);
   bResult = bResult && (u8NumberOfDataServiceComponents == roRef.u8NumberOfDataServiceComponents);
   bResult = bResult && (u8ReceptionQuality == roRef.u8ReceptionQuality);
   bResult = bResult && (u8NumberOfEnsembles == roRef.u8NumberOfEnsembles);
   bResult = bResult && (u8ListElementId == roRef.u8ListElementId);
   bResult = bResult && (bReception == roRef.bReception);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags::midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags():u8Value(0)
{}

tS32 midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B8_DAB_SERVICEINFOFLAGS;
}


midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags::~midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags()
{}

tU32 midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_ServiceInfo::midw_ext_fi_tcl_DAB_ServiceInfo(const midw_ext_fi_tcl_DAB_ServiceInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32ServId = coRef.u32ServId;
   ServiceLabel = coRef.ServiceLabel;
   e8ServiceType = coRef.e8ServiceType;
   u8NumberOfAudioComponents = coRef.u8NumberOfAudioComponents;
   u8NumberOfDataComponents = coRef.u8NumberOfDataComponents;
   b16AvailableAnnoTypesMask = coRef.b16AvailableAnnoTypesMask;
   u8SampleRate = coRef.u8SampleRate;
   u16BitRate = coRef.u16BitRate;
   sAudioMode = coRef.sAudioMode;
   sAdvancedAudioCodec = coRef.sAdvancedAudioCodec;
   sAudioCodec = coRef.sAudioCodec;
   b8Flags = coRef.b8Flags;
   u8PresetListElementID = coRef.u8PresetListElementID;
   u16ServiceIndex = coRef.u16ServiceIndex;
   u8PTYCode = coRef.u8PTYCode;
   e8EncodingType = coRef.e8EncodingType;
}
midw_ext_fi_tcl_DAB_ServiceInfo& midw_ext_fi_tcl_DAB_ServiceInfo::operator=(const midw_ext_fi_tcl_DAB_ServiceInfo& coRef)
{
   if (this == &coRef) return *this;
   u32ServId = coRef.u32ServId;
   ServiceLabel = coRef.ServiceLabel;
   e8ServiceType = coRef.e8ServiceType;
   u8NumberOfAudioComponents = coRef.u8NumberOfAudioComponents;
   u8NumberOfDataComponents = coRef.u8NumberOfDataComponents;
   b16AvailableAnnoTypesMask = coRef.b16AvailableAnnoTypesMask;
   u8SampleRate = coRef.u8SampleRate;
   u16BitRate = coRef.u16BitRate;
   sAudioMode = coRef.sAudioMode;
   sAdvancedAudioCodec = coRef.sAdvancedAudioCodec;
   sAudioCodec = coRef.sAudioCodec;
   b8Flags = coRef.b8Flags;
   u8PresetListElementID = coRef.u8PresetListElementID;
   u16ServiceIndex = coRef.u16ServiceIndex;
   u8PTYCode = coRef.u8PTYCode;
   e8EncodingType = coRef.e8EncodingType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_ServiceInfo::vDestroy()
{
   ServiceLabel.vDestroy(); 
   sAudioMode.vDestroy();
   sAdvancedAudioCodec.vDestroy();
   sAudioCodec.vDestroy();
}

midw_ext_fi_tcl_DAB_ServiceInfo::midw_ext_fi_tcl_DAB_ServiceInfo()
:u32ServId(0)
,ServiceLabel()
,e8ServiceType()
,u8NumberOfAudioComponents(0)
,u8NumberOfDataComponents(0)
,b16AvailableAnnoTypesMask()
,u8SampleRate(0)
,u16BitRate(0)
,sAudioMode()
,sAdvancedAudioCodec()
,sAudioCodec()
,b8Flags()
,u8PresetListElementID(0)
,u16ServiceIndex(0)
,u8PTYCode(0)
,e8EncodingType()
 {}

tS32 midw_ext_fi_tcl_DAB_ServiceInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_SERVICEINFO;
}


midw_ext_fi_tcl_DAB_ServiceInfo::~midw_ext_fi_tcl_DAB_ServiceInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_ServiceInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 18+ServiceLabel.u32GetSize(u16MajorVersion)+sAudioMode.u32GetSize(u16MajorVersion)+sAdvancedAudioCodec.u32GetSize(u16MajorVersion)+sAudioCodec.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_ServiceInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ServId);
   (tVoid) (oIn >> ServiceLabel);
   (tVoid) (oIn >> e8ServiceType);
   (tVoid) (oIn >> u8NumberOfAudioComponents);
   (tVoid) (oIn >> u8NumberOfDataComponents);
   (tVoid) (oIn >> b16AvailableAnnoTypesMask);
   (tVoid) (oIn >> u8SampleRate);
   (tVoid) (oIn >> u16BitRate);
   (tVoid) (oIn >> sAudioMode);
   (tVoid) (oIn >> sAdvancedAudioCodec);
   (tVoid) (oIn >> sAudioCodec);
   (tVoid) (oIn >> b8Flags);
   (tVoid) (oIn >> u8PresetListElementID);
   (tVoid) (oIn >> u16ServiceIndex);
   (tVoid) (oIn >> u8PTYCode);
   (tVoid) (oIn >> e8EncodingType);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_ServiceInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ServId);
   (tVoid) (oOut << ServiceLabel);
   (tVoid) (oOut << e8ServiceType);
   (tVoid) (oOut << u8NumberOfAudioComponents);
   (tVoid) (oOut << u8NumberOfDataComponents);
   (tVoid) (oOut << b16AvailableAnnoTypesMask);
   (tVoid) (oOut << u8SampleRate);
   (tVoid) (oOut << u16BitRate);
   (tVoid) (oOut << sAudioMode);
   (tVoid) (oOut << sAdvancedAudioCodec);
   (tVoid) (oOut << sAudioCodec);
   (tVoid) (oOut << b8Flags);
   (tVoid) (oOut << u8PresetListElementID);
   (tVoid) (oOut << u16ServiceIndex);
   (tVoid) (oOut << u8PTYCode);
   (tVoid) (oOut << e8EncodingType);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_ServiceInfo::operator==(const midw_ext_fi_tcl_DAB_ServiceInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ServId == roRef.u32ServId);
   bResult = bResult && (ServiceLabel == roRef.ServiceLabel);
   bResult = bResult && (e8ServiceType == roRef.e8ServiceType);
   bResult = bResult && (u8NumberOfAudioComponents == roRef.u8NumberOfAudioComponents);
   bResult = bResult && (u8NumberOfDataComponents == roRef.u8NumberOfDataComponents);
   bResult = bResult && (b16AvailableAnnoTypesMask == roRef.b16AvailableAnnoTypesMask);
   bResult = bResult && (u8SampleRate == roRef.u8SampleRate);
   bResult = bResult && (u16BitRate == roRef.u16BitRate);
   bResult = bResult && (sAudioMode == roRef.sAudioMode);
   bResult = bResult && (sAdvancedAudioCodec == roRef.sAdvancedAudioCodec);
   bResult = bResult && (sAudioCodec == roRef.sAudioCodec);
   bResult = bResult && (b8Flags == roRef.b8Flags);
   bResult = bResult && (u8PresetListElementID == roRef.u8PresetListElementID);
   bResult = bResult && (u16ServiceIndex == roRef.u16ServiceIndex);
   bResult = bResult && (u8PTYCode == roRef.u8PTYCode);
   bResult = bResult && (e8EncodingType == roRef.e8EncodingType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_ChannelInfoState::midw_ext_fi_tcl_e8_DAB_ChannelInfoState():enType(FI_EN_DAB_STABLE) {}

tS32 midw_ext_fi_tcl_e8_DAB_ChannelInfoState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_CHANNELINFOSTATE;
}


midw_ext_fi_tcl_e8_DAB_ChannelInfoState::~midw_ext_fi_tcl_e8_DAB_ChannelInfoState()
{}

tU32 midw_ext_fi_tcl_e8_DAB_ChannelInfoState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_ChannelInfoState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_ChannelInfoState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_ChannelInfo::midw_ext_fi_tcl_DAB_ChannelInfo(const midw_ext_fi_tcl_DAB_ChannelInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32ServId = coRef.u32ServId;
   enState = coRef.enState;
   ServiceLabel = coRef.ServiceLabel;
   u8NumberOfAudioComponents = coRef.u8NumberOfAudioComponents;
   b16AvailableAnnoTypesMask = coRef.b16AvailableAnnoTypesMask;
   u8PresetListElementID = coRef.u8PresetListElementID;
   bComponentMode = coRef.bComponentMode;
   bFmServiceFollowActive = coRef.bFmServiceFollowActive;
   u16FrozenListElementID = coRef.u16FrozenListElementID;
   rRadioText = coRef.rRadioText;
   u8NumberOfDLPElements = coRef.u8NumberOfDLPElements;
   DLPlusList = coRef.DLPlusList;
   bMuted = coRef.bMuted;
   bAFAvailable = coRef.bAFAvailable;
   sLogoLink = coRef.sLogoLink;
   u8ScidsValue = coRef.u8ScidsValue;
}
midw_ext_fi_tcl_DAB_ChannelInfo& midw_ext_fi_tcl_DAB_ChannelInfo::operator=(const midw_ext_fi_tcl_DAB_ChannelInfo& coRef)
{
   if (this == &coRef) return *this;
   u32ServId = coRef.u32ServId;
   enState = coRef.enState;
   ServiceLabel = coRef.ServiceLabel;
   u8NumberOfAudioComponents = coRef.u8NumberOfAudioComponents;
   b16AvailableAnnoTypesMask = coRef.b16AvailableAnnoTypesMask;
   u8PresetListElementID = coRef.u8PresetListElementID;
   bComponentMode = coRef.bComponentMode;
   bFmServiceFollowActive = coRef.bFmServiceFollowActive;
   u16FrozenListElementID = coRef.u16FrozenListElementID;
   rRadioText = coRef.rRadioText;
   u8NumberOfDLPElements = coRef.u8NumberOfDLPElements;
   DLPlusList = coRef.DLPlusList;
   bMuted = coRef.bMuted;
   bAFAvailable = coRef.bAFAvailable;
   sLogoLink = coRef.sLogoLink;
   u8ScidsValue = coRef.u8ScidsValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_ChannelInfo::vDestroy()
{
   ServiceLabel.vDestroy(); 
   rRadioText.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < DLPlusList.size(); ++u32Idx)
         DLPlusList[u32Idx].vDestroy();
   DLPlusList.clear();
   }
   sLogoLink.vDestroy();
}

midw_ext_fi_tcl_DAB_ChannelInfo::midw_ext_fi_tcl_DAB_ChannelInfo()
:u32ServId(0)
,enState()
,ServiceLabel()
,u8NumberOfAudioComponents(0)
,b16AvailableAnnoTypesMask()
,u8PresetListElementID(0)
,bComponentMode(0)
,bFmServiceFollowActive(0)
,u16FrozenListElementID(0)
,rRadioText()
,u8NumberOfDLPElements(0)

,bMuted(0)
,bAFAvailable(0)
,sLogoLink()
,u8ScidsValue(0)
 {}

tS32 midw_ext_fi_tcl_DAB_ChannelInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_CHANNELINFO;
}


midw_ext_fi_tcl_DAB_ChannelInfo::~midw_ext_fi_tcl_DAB_ChannelInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_ChannelInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DLPlusList.size(); ++u32ListIdx)
      u32DynamicSize += DLPlusList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+21+ServiceLabel.u32GetSize(u16MajorVersion)+rRadioText.u32GetSize(u16MajorVersion)+sLogoLink.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_ChannelInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ServId);
   (tVoid) (oIn >> enState);
   (tVoid) (oIn >> ServiceLabel);
   (tVoid) (oIn >> u8NumberOfAudioComponents);
   (tVoid) (oIn >> b16AvailableAnnoTypesMask);
   (tVoid) (oIn >> u8PresetListElementID);
   (tVoid) (oIn >> bComponentMode);
   (tVoid) (oIn >> bFmServiceFollowActive);
   (tVoid) (oIn >> u16FrozenListElementID);
   (tVoid) (oIn >> rRadioText);
   (tVoid) (oIn >> u8NumberOfDLPElements);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DLPlusList.size(); ++u32Idx)
      {
         DLPlusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DLPlusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DLPlusList[u32Idx]);
      }
   }
   (tVoid) (oIn >> bMuted);
   (tVoid) (oIn >> bAFAvailable);
   (tVoid) (oIn >> sLogoLink);
   (tVoid) (oIn >> u8ScidsValue);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_ChannelInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ServId);
   (tVoid) (oOut << enState);
   (tVoid) (oOut << ServiceLabel);
   (tVoid) (oOut << u8NumberOfAudioComponents);
   (tVoid) (oOut << b16AvailableAnnoTypesMask);
   (tVoid) (oOut << u8PresetListElementID);
   (tVoid) (oOut << bComponentMode);
   (tVoid) (oOut << bFmServiceFollowActive);
   (tVoid) (oOut << u16FrozenListElementID);
   (tVoid) (oOut << rRadioText);
   (tVoid) (oOut << u8NumberOfDLPElements);
   (tVoid) (oOut << (tU32)DLPlusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DLPlusList.size(); ++u32Idx)
         (tVoid) (oOut << DLPlusList[u32Idx]);
   }
   (tVoid) (oOut << bMuted);
   (tVoid) (oOut << bAFAvailable);
   (tVoid) (oOut << sLogoLink);
   (tVoid) (oOut << u8ScidsValue);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_ChannelInfo::operator==(const midw_ext_fi_tcl_DAB_ChannelInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ServId == roRef.u32ServId);
   bResult = bResult && (enState == roRef.enState);
   bResult = bResult && (ServiceLabel == roRef.ServiceLabel);
   bResult = bResult && (u8NumberOfAudioComponents == roRef.u8NumberOfAudioComponents);
   bResult = bResult && (b16AvailableAnnoTypesMask == roRef.b16AvailableAnnoTypesMask);
   bResult = bResult && (u8PresetListElementID == roRef.u8PresetListElementID);
   bResult = bResult && (bComponentMode == roRef.bComponentMode);
   bResult = bResult && (bFmServiceFollowActive == roRef.bFmServiceFollowActive);
   bResult = bResult && (u16FrozenListElementID == roRef.u16FrozenListElementID);
   bResult = bResult && (rRadioText == roRef.rRadioText);
   bResult = bResult && (u8NumberOfDLPElements == roRef.u8NumberOfDLPElements);
      bResult = bResult && (DLPlusList.size() == roRef.DLPlusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DLPlusList.size()); ++u32Idx)
            bResult = bResult && (DLPlusList[u32Idx] == roRef.DLPlusList[u32Idx]);
      }
   bResult = bResult && (bMuted == roRef.bMuted);
   bResult = bResult && (bAFAvailable == roRef.bAFAvailable);
   bResult = bResult && (sLogoLink == roRef.sLogoLink);
   bResult = bResult && (u8ScidsValue == roRef.u8ScidsValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_ComponentInfo::midw_ext_fi_tcl_DAB_ComponentInfo(const midw_ext_fi_tcl_DAB_ComponentInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8ComponentId = coRef.u8ComponentId;
   ComponentLabel = coRef.ComponentLabel;
   u16SCIDI = coRef.u16SCIDI;
   u8Subchannel = coRef.u8Subchannel;
   u8SCIDS = coRef.u8SCIDS;
   e8ComponentType = coRef.e8ComponentType;
   e8ServiceType = coRef.e8ServiceType;
   e8TMIdType = coRef.e8TMIdType;
   u8AudioDataServiceComponentType = coRef.u8AudioDataServiceComponentType;
   u16ComponentIndex = coRef.u16ComponentIndex;
}
midw_ext_fi_tcl_DAB_ComponentInfo& midw_ext_fi_tcl_DAB_ComponentInfo::operator=(const midw_ext_fi_tcl_DAB_ComponentInfo& coRef)
{
   if (this == &coRef) return *this;
   u8ComponentId = coRef.u8ComponentId;
   ComponentLabel = coRef.ComponentLabel;
   u16SCIDI = coRef.u16SCIDI;
   u8Subchannel = coRef.u8Subchannel;
   u8SCIDS = coRef.u8SCIDS;
   e8ComponentType = coRef.e8ComponentType;
   e8ServiceType = coRef.e8ServiceType;
   e8TMIdType = coRef.e8TMIdType;
   u8AudioDataServiceComponentType = coRef.u8AudioDataServiceComponentType;
   u16ComponentIndex = coRef.u16ComponentIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_ComponentInfo::vDestroy()
{
   ComponentLabel.vDestroy(); 
}

midw_ext_fi_tcl_DAB_ComponentInfo::midw_ext_fi_tcl_DAB_ComponentInfo()
:u8ComponentId(0)
,ComponentLabel()
,u16SCIDI(0)
,u8Subchannel(0)
,u8SCIDS(0)
,e8ComponentType()
,e8ServiceType()
,e8TMIdType()
,u8AudioDataServiceComponentType(0)
,u16ComponentIndex(0)
 {}

tS32 midw_ext_fi_tcl_DAB_ComponentInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_COMPONENTINFO;
}


midw_ext_fi_tcl_DAB_ComponentInfo::~midw_ext_fi_tcl_DAB_ComponentInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_ComponentInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 11+ComponentLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_ComponentInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8ComponentId);
   (tVoid) (oIn >> ComponentLabel);
   (tVoid) (oIn >> u16SCIDI);
   (tVoid) (oIn >> u8Subchannel);
   (tVoid) (oIn >> u8SCIDS);
   (tVoid) (oIn >> e8ComponentType);
   (tVoid) (oIn >> e8ServiceType);
   (tVoid) (oIn >> e8TMIdType);
   (tVoid) (oIn >> u8AudioDataServiceComponentType);
   (tVoid) (oIn >> u16ComponentIndex);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_ComponentInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8ComponentId);
   (tVoid) (oOut << ComponentLabel);
   (tVoid) (oOut << u16SCIDI);
   (tVoid) (oOut << u8Subchannel);
   (tVoid) (oOut << u8SCIDS);
   (tVoid) (oOut << e8ComponentType);
   (tVoid) (oOut << e8ServiceType);
   (tVoid) (oOut << e8TMIdType);
   (tVoid) (oOut << u8AudioDataServiceComponentType);
   (tVoid) (oOut << u16ComponentIndex);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_ComponentInfo::operator==(const midw_ext_fi_tcl_DAB_ComponentInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8ComponentId == roRef.u8ComponentId);
   bResult = bResult && (ComponentLabel == roRef.ComponentLabel);
   bResult = bResult && (u16SCIDI == roRef.u16SCIDI);
   bResult = bResult && (u8Subchannel == roRef.u8Subchannel);
   bResult = bResult && (u8SCIDS == roRef.u8SCIDS);
   bResult = bResult && (e8ComponentType == roRef.e8ComponentType);
   bResult = bResult && (e8ServiceType == roRef.e8ServiceType);
   bResult = bResult && (e8TMIdType == roRef.e8TMIdType);
   bResult = bResult && (u8AudioDataServiceComponentType == roRef.u8AudioDataServiceComponentType);
   bResult = bResult && (u16ComponentIndex == roRef.u16ComponentIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_AnnoConfig::midw_ext_fi_tcl_DAB_AnnoConfig(const midw_ext_fi_tcl_DAB_AnnoConfig& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   AnnoConfigTypes = coRef.AnnoConfigTypes;
   bEnable = coRef.bEnable;
   AnnoConfigSource = coRef.AnnoConfigSource;
}
midw_ext_fi_tcl_DAB_AnnoConfig& midw_ext_fi_tcl_DAB_AnnoConfig::operator=(const midw_ext_fi_tcl_DAB_AnnoConfig& coRef)
{
   if (this == &coRef) return *this;
   AnnoConfigTypes = coRef.AnnoConfigTypes;
   bEnable = coRef.bEnable;
   AnnoConfigSource = coRef.AnnoConfigSource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_AnnoConfig::midw_ext_fi_tcl_DAB_AnnoConfig()
:AnnoConfigTypes()
,bEnable(0)
,AnnoConfigSource()
 {}

tS32 midw_ext_fi_tcl_DAB_AnnoConfig::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_ANNOCONFIG;
}


midw_ext_fi_tcl_DAB_AnnoConfig::~midw_ext_fi_tcl_DAB_AnnoConfig()
{}

tU32 midw_ext_fi_tcl_DAB_AnnoConfig::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_AnnoConfig::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AnnoConfigTypes);
   (tVoid) (oIn >> bEnable);
   (tVoid) (oIn >> AnnoConfigSource);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_AnnoConfig::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AnnoConfigTypes);
   (tVoid) (oOut << bEnable);
   (tVoid) (oOut << AnnoConfigSource);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_AnnoConfig::operator==(const midw_ext_fi_tcl_DAB_AnnoConfig& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AnnoConfigTypes == roRef.AnnoConfigTypes);
   bResult = bResult && (bEnable == roRef.bEnable);
   bResult = bResult && (AnnoConfigSource == roRef.AnnoConfigSource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_AnnoElement::midw_ext_fi_tcl_DAB_AnnoElement(const midw_ext_fi_tcl_DAB_AnnoElement& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u16AnnoType = coRef.u16AnnoType;
   AnnoState = coRef.AnnoState;
}
midw_ext_fi_tcl_DAB_AnnoElement& midw_ext_fi_tcl_DAB_AnnoElement::operator=(const midw_ext_fi_tcl_DAB_AnnoElement& coRef)
{
   if (this == &coRef) return *this;
   u16AnnoType = coRef.u16AnnoType;
   AnnoState = coRef.AnnoState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_AnnoElement::midw_ext_fi_tcl_DAB_AnnoElement()
:u16AnnoType(0)
,AnnoState()
 {}

tS32 midw_ext_fi_tcl_DAB_AnnoElement::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_ANNOELEMENT;
}


midw_ext_fi_tcl_DAB_AnnoElement::~midw_ext_fi_tcl_DAB_AnnoElement()
{}

tU32 midw_ext_fi_tcl_DAB_AnnoElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_AnnoElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16AnnoType);
   (tVoid) (oIn >> AnnoState);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_AnnoElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16AnnoType);
   (tVoid) (oOut << AnnoState);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_AnnoElement::operator==(const midw_ext_fi_tcl_DAB_AnnoElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16AnnoType == roRef.u16AnnoType);
   bResult = bResult && (AnnoState == roRef.AnnoState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_AnnoStatus::midw_ext_fi_tcl_DAB_AnnoStatus(const midw_ext_fi_tcl_DAB_AnnoStatus& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   AnnoConfigTypes = coRef.AnnoConfigTypes;
   AnnoConfigSource = coRef.AnnoConfigSource;
   AnnoSupportedTypes = coRef.AnnoSupportedTypes;
   AnnoActiveTypes = coRef.AnnoActiveTypes;
   AnnoActiveSource = coRef.AnnoActiveSource;
   AnnoActiveState = coRef.AnnoActiveState;
   AnnoSelectState = coRef.AnnoSelectState;
   AnnoSelectedTypes = coRef.AnnoSelectedTypes;
   AnnoServiceLabel = coRef.AnnoServiceLabel;
   AnnouncementList = coRef.AnnouncementList;
}
midw_ext_fi_tcl_DAB_AnnoStatus& midw_ext_fi_tcl_DAB_AnnoStatus::operator=(const midw_ext_fi_tcl_DAB_AnnoStatus& coRef)
{
   if (this == &coRef) return *this;
   AnnoConfigTypes = coRef.AnnoConfigTypes;
   AnnoConfigSource = coRef.AnnoConfigSource;
   AnnoSupportedTypes = coRef.AnnoSupportedTypes;
   AnnoActiveTypes = coRef.AnnoActiveTypes;
   AnnoActiveSource = coRef.AnnoActiveSource;
   AnnoActiveState = coRef.AnnoActiveState;
   AnnoSelectState = coRef.AnnoSelectState;
   AnnoSelectedTypes = coRef.AnnoSelectedTypes;
   AnnoServiceLabel = coRef.AnnoServiceLabel;
   AnnouncementList = coRef.AnnouncementList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_AnnoStatus::vDestroy()
{
   AnnoServiceLabel.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < AnnouncementList.size(); ++u32Idx)
         AnnouncementList[u32Idx].vDestroy();
   AnnouncementList.clear();
   }
}

midw_ext_fi_tcl_DAB_AnnoStatus::midw_ext_fi_tcl_DAB_AnnoStatus()
:AnnoConfigTypes()
,AnnoConfigSource()
,AnnoSupportedTypes()
,AnnoActiveTypes()
,AnnoActiveSource()
,AnnoActiveState()
,AnnoSelectState()
,AnnoSelectedTypes()
,AnnoServiceLabel()

 {}

tS32 midw_ext_fi_tcl_DAB_AnnoStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_ANNOSTATUS;
}


midw_ext_fi_tcl_DAB_AnnoStatus::~midw_ext_fi_tcl_DAB_AnnoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_AnnoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 16+AnnoServiceLabel.u32GetSize(u16MajorVersion)+ static_cast<tU32>(AnnouncementList.size()*3);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_AnnoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AnnoConfigTypes);
   (tVoid) (oIn >> AnnoConfigSource);
   (tVoid) (oIn >> AnnoSupportedTypes);
   (tVoid) (oIn >> AnnoActiveTypes);
   (tVoid) (oIn >> AnnoActiveSource);
   (tVoid) (oIn >> AnnoActiveState);
   (tVoid) (oIn >> AnnoSelectState);
   (tVoid) (oIn >> AnnoSelectedTypes);
   (tVoid) (oIn >> AnnoServiceLabel);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AnnouncementList.size(); ++u32Idx)
      {
         AnnouncementList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AnnouncementList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AnnouncementList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_AnnoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AnnoConfigTypes);
   (tVoid) (oOut << AnnoConfigSource);
   (tVoid) (oOut << AnnoSupportedTypes);
   (tVoid) (oOut << AnnoActiveTypes);
   (tVoid) (oOut << AnnoActiveSource);
   (tVoid) (oOut << AnnoActiveState);
   (tVoid) (oOut << AnnoSelectState);
   (tVoid) (oOut << AnnoSelectedTypes);
   (tVoid) (oOut << AnnoServiceLabel);
   (tVoid) (oOut << (tU32)AnnouncementList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AnnouncementList.size(); ++u32Idx)
         (tVoid) (oOut << AnnouncementList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_AnnoStatus::operator==(const midw_ext_fi_tcl_DAB_AnnoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AnnoConfigTypes == roRef.AnnoConfigTypes);
   bResult = bResult && (AnnoConfigSource == roRef.AnnoConfigSource);
   bResult = bResult && (AnnoSupportedTypes == roRef.AnnoSupportedTypes);
   bResult = bResult && (AnnoActiveTypes == roRef.AnnoActiveTypes);
   bResult = bResult && (AnnoActiveSource == roRef.AnnoActiveSource);
   bResult = bResult && (AnnoActiveState == roRef.AnnoActiveState);
   bResult = bResult && (AnnoSelectState == roRef.AnnoSelectState);
   bResult = bResult && (AnnoSelectedTypes == roRef.AnnoSelectedTypes);
   bResult = bResult && (AnnoServiceLabel == roRef.AnnoServiceLabel);
      bResult = bResult && (AnnouncementList.size() == roRef.AnnouncementList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AnnouncementList.size()); ++u32Idx)
            bResult = bResult && (AnnouncementList[u32Idx] == roRef.AnnouncementList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_ADRMsg::midw_ext_fi_tcl_DAB_ADRMsg(const midw_ext_fi_tcl_DAB_ADRMsg& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u16FktID = coRef.u16FktID;
   MsgData = coRef.MsgData;
}
midw_ext_fi_tcl_DAB_ADRMsg& midw_ext_fi_tcl_DAB_ADRMsg::operator=(const midw_ext_fi_tcl_DAB_ADRMsg& coRef)
{
   if (this == &coRef) return *this;
   u16FktID = coRef.u16FktID;
   MsgData = coRef.MsgData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_ADRMsg::vDestroy()
{
   {
   MsgData.clear();
   }
}

midw_ext_fi_tcl_DAB_ADRMsg::midw_ext_fi_tcl_DAB_ADRMsg()
:u16FktID(0)

 {}

tS32 midw_ext_fi_tcl_DAB_ADRMsg::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_ADRMSG;
}


midw_ext_fi_tcl_DAB_ADRMsg::~midw_ext_fi_tcl_DAB_ADRMsg()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_ADRMsg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(MsgData.size()*1);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_ADRMsg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FktID);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      MsgData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MsgData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_ADRMsg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FktID);
   (tVoid) (oOut << (tU32)MsgData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MsgData.size(); ++u32Idx)
         (tVoid) (oOut << MsgData[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_ADRMsg::operator==(const midw_ext_fi_tcl_DAB_ADRMsg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FktID == roRef.u16FktID);
      bResult = bResult && (MsgData.size() == roRef.MsgData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MsgData.size()); ++u32Idx)
            bResult = bResult && (MsgData[u32Idx] == roRef.MsgData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_LogoElement::midw_ext_fi_tcl_DAB_LogoElement(const midw_ext_fi_tcl_DAB_LogoElement& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32ServiceID = coRef.u32ServiceID;
   sLogoLink = coRef.sLogoLink;
}
midw_ext_fi_tcl_DAB_LogoElement& midw_ext_fi_tcl_DAB_LogoElement::operator=(const midw_ext_fi_tcl_DAB_LogoElement& coRef)
{
   if (this == &coRef) return *this;
   u32ServiceID = coRef.u32ServiceID;
   sLogoLink = coRef.sLogoLink;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_LogoElement::vDestroy()
{
   sLogoLink.vDestroy();
}

midw_ext_fi_tcl_DAB_LogoElement::midw_ext_fi_tcl_DAB_LogoElement()
:u32ServiceID(0)
,sLogoLink()
 {}

tS32 midw_ext_fi_tcl_DAB_LogoElement::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_LOGOELEMENT;
}


midw_ext_fi_tcl_DAB_LogoElement::~midw_ext_fi_tcl_DAB_LogoElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_LogoElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+sLogoLink.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_LogoElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ServiceID);
   (tVoid) (oIn >> sLogoLink);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_LogoElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ServiceID);
   (tVoid) (oOut << sLogoLink);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_LogoElement::operator==(const midw_ext_fi_tcl_DAB_LogoElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ServiceID == roRef.u32ServiceID);
   bResult = bResult && (sLogoLink == roRef.sLogoLink);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_ContentID::midw_ext_fi_tcl_DAB_ContentID(const midw_ext_fi_tcl_DAB_ContentID& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32ServiceID = coRef.u32ServiceID;
   u8Scid = coRef.u8Scid;
}
midw_ext_fi_tcl_DAB_ContentID& midw_ext_fi_tcl_DAB_ContentID::operator=(const midw_ext_fi_tcl_DAB_ContentID& coRef)
{
   if (this == &coRef) return *this;
   u32ServiceID = coRef.u32ServiceID;
   u8Scid = coRef.u8Scid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_ContentID::midw_ext_fi_tcl_DAB_ContentID()
:u32ServiceID(0)
,u8Scid(0)
 {}

tS32 midw_ext_fi_tcl_DAB_ContentID::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_CONTENTID;
}


midw_ext_fi_tcl_DAB_ContentID::~midw_ext_fi_tcl_DAB_ContentID()
{}

tU32 midw_ext_fi_tcl_DAB_ContentID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_ContentID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ServiceID);
   (tVoid) (oIn >> u8Scid);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_ContentID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ServiceID);
   (tVoid) (oOut << u8Scid);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_ContentID::operator==(const midw_ext_fi_tcl_DAB_ContentID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ServiceID == roRef.u32ServiceID);
   bResult = bResult && (u8Scid == roRef.u8Scid);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_TuneType::midw_ext_fi_tcl_e8_DAB_TuneType():enType(FI_EN_DAB_TUNETYPE_OFF) {}

tS32 midw_ext_fi_tcl_e8_DAB_TuneType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_TUNETYPE;
}


midw_ext_fi_tcl_e8_DAB_TuneType::~midw_ext_fi_tcl_e8_DAB_TuneType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_TuneType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_TuneType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_TuneType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_TuneParam::midw_ext_fi_tcl_DAB_TuneParam(const midw_ext_fi_tcl_DAB_TuneParam& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8TuneType = coRef.e8TuneType;
   u32Value = coRef.u32Value;
}
midw_ext_fi_tcl_DAB_TuneParam& midw_ext_fi_tcl_DAB_TuneParam::operator=(const midw_ext_fi_tcl_DAB_TuneParam& coRef)
{
   if (this == &coRef) return *this;
   e8TuneType = coRef.e8TuneType;
   u32Value = coRef.u32Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_TuneParam::midw_ext_fi_tcl_DAB_TuneParam()
:e8TuneType()
,u32Value(0)
 {}

tS32 midw_ext_fi_tcl_DAB_TuneParam::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_TUNEPARAM;
}


midw_ext_fi_tcl_DAB_TuneParam::~midw_ext_fi_tcl_DAB_TuneParam()
{}

tU32 midw_ext_fi_tcl_DAB_TuneParam::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_TuneParam::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8TuneType);
   (tVoid) (oIn >> u32Value);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_TuneParam::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8TuneType);
   (tVoid) (oOut << u32Value);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_TuneParam::operator==(const midw_ext_fi_tcl_DAB_TuneParam& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8TuneType == roRef.e8TuneType);
   bResult = bResult && (u32Value == roRef.u32Value);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_LearnType::midw_ext_fi_tcl_e8_DAB_LearnType():enType(FI_EN_DAB_LEARNTYPE_OFF) {}

tS32 midw_ext_fi_tcl_e8_DAB_LearnType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_LEARNTYPE;
}


midw_ext_fi_tcl_e8_DAB_LearnType::~midw_ext_fi_tcl_e8_DAB_LearnType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_LearnType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_LearnType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_LearnType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_LearnParam::midw_ext_fi_tcl_DAB_LearnParam(const midw_ext_fi_tcl_DAB_LearnParam& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8LearnType = coRef.e8LearnType;
   bRollback = coRef.bRollback;
}
midw_ext_fi_tcl_DAB_LearnParam& midw_ext_fi_tcl_DAB_LearnParam::operator=(const midw_ext_fi_tcl_DAB_LearnParam& coRef)
{
   if (this == &coRef) return *this;
   e8LearnType = coRef.e8LearnType;
   bRollback = coRef.bRollback;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_LearnParam::midw_ext_fi_tcl_DAB_LearnParam()
:e8LearnType()
,bRollback(0)
 {}

tS32 midw_ext_fi_tcl_DAB_LearnParam::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_LEARNPARAM;
}


midw_ext_fi_tcl_DAB_LearnParam::~midw_ext_fi_tcl_DAB_LearnParam()
{}

tU32 midw_ext_fi_tcl_DAB_LearnParam::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_LearnParam::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LearnType);
   (tVoid) (oIn >> bRollback);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_LearnParam::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LearnType);
   (tVoid) (oOut << bRollback);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_LearnParam::operator==(const midw_ext_fi_tcl_DAB_LearnParam& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LearnType == roRef.e8LearnType);
   bResult = bResult && (bRollback == roRef.bRollback);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b32_DAB_SetupMask::midw_ext_fi_tcl_b32_DAB_SetupMask():u32Value(0)
{}

tS32 midw_ext_fi_tcl_b32_DAB_SetupMask::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B32_DAB_SETUPMASK;
}


midw_ext_fi_tcl_b32_DAB_SetupMask::~midw_ext_fi_tcl_b32_DAB_SetupMask()
{}

tU32 midw_ext_fi_tcl_b32_DAB_SetupMask::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_b32_DAB_SetupMask::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b32_DAB_SetupMask::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b32_DAB_SetupFlags::midw_ext_fi_tcl_b32_DAB_SetupFlags():u32Value(0)
{}

tS32 midw_ext_fi_tcl_b32_DAB_SetupFlags::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B32_DAB_SETUPFLAGS;
}


midw_ext_fi_tcl_b32_DAB_SetupFlags::~midw_ext_fi_tcl_b32_DAB_SetupFlags()
{}

tU32 midw_ext_fi_tcl_b32_DAB_SetupFlags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_b32_DAB_SetupFlags::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b32_DAB_SetupFlags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b8_DAB_LinkingSetupMask::midw_ext_fi_tcl_b8_DAB_LinkingSetupMask():u8Value(0)
{}

tS32 midw_ext_fi_tcl_b8_DAB_LinkingSetupMask::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B8_DAB_LINKINGSETUPMASK;
}


midw_ext_fi_tcl_b8_DAB_LinkingSetupMask::~midw_ext_fi_tcl_b8_DAB_LinkingSetupMask()
{}

tU32 midw_ext_fi_tcl_b8_DAB_LinkingSetupMask::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_b8_DAB_LinkingSetupMask::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b8_DAB_LinkingSetupMask::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_SwitchTuner::midw_ext_fi_tcl_e8_DAB_SwitchTuner():enType(FI_EN_DAB_SWITCH_TO_DAB) {}

tS32 midw_ext_fi_tcl_e8_DAB_SwitchTuner::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_SWITCHTUNER;
}


midw_ext_fi_tcl_e8_DAB_SwitchTuner::~midw_ext_fi_tcl_e8_DAB_SwitchTuner()
{}

tU32 midw_ext_fi_tcl_e8_DAB_SwitchTuner::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_SwitchTuner::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_SwitchTuner::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner::midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner():enType(FI_EN_MAIN_DAB_TUNER) {}

tS32 midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_SERVICEFOLLOWINGTUNER;
}


midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner::~midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner()
{}

tU32 midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_MuteStatus::midw_ext_fi_tcl_e8_DAB_MuteStatus():enType(FI_EN_MUTE) {}

tS32 midw_ext_fi_tcl_e8_DAB_MuteStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_MUTESTATUS;
}


midw_ext_fi_tcl_e8_DAB_MuteStatus::~midw_ext_fi_tcl_e8_DAB_MuteStatus()
{}

tU32 midw_ext_fi_tcl_e8_DAB_MuteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_MuteStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_MuteStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_Source::midw_ext_fi_tcl_e8_DAB_Source():enType(FI_EN_DAB) {}

tS32 midw_ext_fi_tcl_e8_DAB_Source::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_SOURCE;
}


midw_ext_fi_tcl_e8_DAB_Source::~midw_ext_fi_tcl_e8_DAB_Source()
{}

tU32 midw_ext_fi_tcl_e8_DAB_Source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_Source::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_Source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags::midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags():u8Value(0)
{}

tS32 midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B8_DAB_EXTSERVFOLLOWINGFLAGS;
}


midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags::~midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags()
{}

tU32 midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_DeleteAction::midw_ext_fi_tcl_e8_DAB_DeleteAction():enType(FI_EN_PRESETLIST_DELACTION_ONE_ELEMENT) {}

tS32 midw_ext_fi_tcl_e8_DAB_DeleteAction::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_DELETEACTION;
}


midw_ext_fi_tcl_e8_DAB_DeleteAction::~midw_ext_fi_tcl_e8_DAB_DeleteAction()
{}

tU32 midw_ext_fi_tcl_e8_DAB_DeleteAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_DeleteAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_DeleteAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_PresetListElement::midw_ext_fi_tcl_DAB_PresetListElement(const midw_ext_fi_tcl_DAB_PresetListElement& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8PresetElementID = coRef.u8PresetElementID;
   u32ServiceID = coRef.u32ServiceID;
   ServiceLabel = coRef.ServiceLabel;
   u32Frequency = coRef.u32Frequency;
   u8Scid = coRef.u8Scid;
   ComponentLabel = coRef.ComponentLabel;
   u32EnsembleId = coRef.u32EnsembleId;
   EnsembleLabel = coRef.EnsembleLabel;
   sLogoLink = coRef.sLogoLink;
}
midw_ext_fi_tcl_DAB_PresetListElement& midw_ext_fi_tcl_DAB_PresetListElement::operator=(const midw_ext_fi_tcl_DAB_PresetListElement& coRef)
{
   if (this == &coRef) return *this;
   u8PresetElementID = coRef.u8PresetElementID;
   u32ServiceID = coRef.u32ServiceID;
   ServiceLabel = coRef.ServiceLabel;
   u32Frequency = coRef.u32Frequency;
   u8Scid = coRef.u8Scid;
   ComponentLabel = coRef.ComponentLabel;
   u32EnsembleId = coRef.u32EnsembleId;
   EnsembleLabel = coRef.EnsembleLabel;
   sLogoLink = coRef.sLogoLink;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_PresetListElement::vDestroy()
{
   ServiceLabel.vDestroy(); 
   ComponentLabel.vDestroy(); 
   EnsembleLabel.vDestroy(); 
   sLogoLink.vDestroy();
}

midw_ext_fi_tcl_DAB_PresetListElement::midw_ext_fi_tcl_DAB_PresetListElement()
:u8PresetElementID(0)
,u32ServiceID(0)
,ServiceLabel()
,u32Frequency(0)
,u8Scid(0)
,ComponentLabel()
,u32EnsembleId(0)
,EnsembleLabel()
,sLogoLink()
 {}

tS32 midw_ext_fi_tcl_DAB_PresetListElement::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_PRESETLISTELEMENT;
}


midw_ext_fi_tcl_DAB_PresetListElement::~midw_ext_fi_tcl_DAB_PresetListElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_PresetListElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+ServiceLabel.u32GetSize(u16MajorVersion)+ComponentLabel.u32GetSize(u16MajorVersion)+EnsembleLabel.u32GetSize(u16MajorVersion)+sLogoLink.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_PresetListElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8PresetElementID);
   (tVoid) (oIn >> u32ServiceID);
   (tVoid) (oIn >> ServiceLabel);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u8Scid);
   (tVoid) (oIn >> ComponentLabel);
   (tVoid) (oIn >> u32EnsembleId);
   (tVoid) (oIn >> EnsembleLabel);
   (tVoid) (oIn >> sLogoLink);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_PresetListElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8PresetElementID);
   (tVoid) (oOut << u32ServiceID);
   (tVoid) (oOut << ServiceLabel);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u8Scid);
   (tVoid) (oOut << ComponentLabel);
   (tVoid) (oOut << u32EnsembleId);
   (tVoid) (oOut << EnsembleLabel);
   (tVoid) (oOut << sLogoLink);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_PresetListElement::operator==(const midw_ext_fi_tcl_DAB_PresetListElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8PresetElementID == roRef.u8PresetElementID);
   bResult = bResult && (u32ServiceID == roRef.u32ServiceID);
   bResult = bResult && (ServiceLabel == roRef.ServiceLabel);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u8Scid == roRef.u8Scid);
   bResult = bResult && (ComponentLabel == roRef.ComponentLabel);
   bResult = bResult && (u32EnsembleId == roRef.u32EnsembleId);
   bResult = bResult && (EnsembleLabel == roRef.EnsembleLabel);
   bResult = bResult && (sLogoLink == roRef.sLogoLink);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_ListOperation::midw_ext_fi_tcl_e8_DAB_ListOperation():enType(FI_EN_OPEN) {}

tS32 midw_ext_fi_tcl_e8_DAB_ListOperation::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_LISTOPERATION;
}


midw_ext_fi_tcl_e8_DAB_ListOperation::~midw_ext_fi_tcl_e8_DAB_ListOperation()
{}

tU32 midw_ext_fi_tcl_e8_DAB_ListOperation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_ListOperation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_ListOperation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_ServiceListType::midw_ext_fi_tcl_e8_DAB_ServiceListType():enType(FI_EN_GLOBALLIST) {}

tS32 midw_ext_fi_tcl_e8_DAB_ServiceListType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_SERVICELISTTYPE;
}


midw_ext_fi_tcl_e8_DAB_ServiceListType::~midw_ext_fi_tcl_e8_DAB_ServiceListType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_ServiceListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_ServiceListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_ServiceListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_ChnListElement::midw_ext_fi_tcl_DAB_ChnListElement(const midw_ext_fi_tcl_DAB_ChnListElement& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u16ListElementID = coRef.u16ListElementID;
   u32DABId = coRef.u32DABId;
   u8CompScids = coRef.u8CompScids;
   Label = coRef.Label;
   EnsembleLabel = coRef.EnsembleLabel;
   sFreqLabel = coRef.sFreqLabel;
   u8PresetListElemId = coRef.u8PresetListElemId;
   u8PTY = coRef.u8PTY;
   u16ASU = coRef.u16ASU;
   bReception = coRef.bReception;
   u8NumberOfComponents = coRef.u8NumberOfComponents;
   u8ServiceLinkMode = coRef.u8ServiceLinkMode;
   sLogoLink = coRef.sLogoLink;
   bEPGSupport = coRef.bEPGSupport;
}
midw_ext_fi_tcl_DAB_ChnListElement& midw_ext_fi_tcl_DAB_ChnListElement::operator=(const midw_ext_fi_tcl_DAB_ChnListElement& coRef)
{
   if (this == &coRef) return *this;
   u16ListElementID = coRef.u16ListElementID;
   u32DABId = coRef.u32DABId;
   u8CompScids = coRef.u8CompScids;
   Label = coRef.Label;
   EnsembleLabel = coRef.EnsembleLabel;
   sFreqLabel = coRef.sFreqLabel;
   u8PresetListElemId = coRef.u8PresetListElemId;
   u8PTY = coRef.u8PTY;
   u16ASU = coRef.u16ASU;
   bReception = coRef.bReception;
   u8NumberOfComponents = coRef.u8NumberOfComponents;
   u8ServiceLinkMode = coRef.u8ServiceLinkMode;
   sLogoLink = coRef.sLogoLink;
   bEPGSupport = coRef.bEPGSupport;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_ChnListElement::vDestroy()
{
   Label.vDestroy(); 
   EnsembleLabel.vDestroy(); 
   sFreqLabel.vDestroy();
   sLogoLink.vDestroy();
}

midw_ext_fi_tcl_DAB_ChnListElement::midw_ext_fi_tcl_DAB_ChnListElement()
:u16ListElementID(0)
,u32DABId(0)
,u8CompScids(0)
,Label()
,EnsembleLabel()
,sFreqLabel()
,u8PresetListElemId(0)
,u8PTY(0)
,u16ASU(0)
,bReception(0)
,u8NumberOfComponents(0)
,u8ServiceLinkMode(0)
,sLogoLink()
,bEPGSupport(0)
 {}

tS32 midw_ext_fi_tcl_DAB_ChnListElement::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_CHNLISTELEMENT;
}


midw_ext_fi_tcl_DAB_ChnListElement::~midw_ext_fi_tcl_DAB_ChnListElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_ChnListElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 15+Label.u32GetSize(u16MajorVersion)+EnsembleLabel.u32GetSize(u16MajorVersion)+sFreqLabel.u32GetSize(u16MajorVersion)+sLogoLink.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_ChnListElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListElementID);
   (tVoid) (oIn >> u32DABId);
   (tVoid) (oIn >> u8CompScids);
   (tVoid) (oIn >> Label);
   (tVoid) (oIn >> EnsembleLabel);
   (tVoid) (oIn >> sFreqLabel);
   (tVoid) (oIn >> u8PresetListElemId);
   (tVoid) (oIn >> u8PTY);
   (tVoid) (oIn >> u16ASU);
   (tVoid) (oIn >> bReception);
   (tVoid) (oIn >> u8NumberOfComponents);
   (tVoid) (oIn >> u8ServiceLinkMode);
   (tVoid) (oIn >> sLogoLink);
   (tVoid) (oIn >> bEPGSupport);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_ChnListElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListElementID);
   (tVoid) (oOut << u32DABId);
   (tVoid) (oOut << u8CompScids);
   (tVoid) (oOut << Label);
   (tVoid) (oOut << EnsembleLabel);
   (tVoid) (oOut << sFreqLabel);
   (tVoid) (oOut << u8PresetListElemId);
   (tVoid) (oOut << u8PTY);
   (tVoid) (oOut << u16ASU);
   (tVoid) (oOut << bReception);
   (tVoid) (oOut << u8NumberOfComponents);
   (tVoid) (oOut << u8ServiceLinkMode);
   (tVoid) (oOut << sLogoLink);
   (tVoid) (oOut << bEPGSupport);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_ChnListElement::operator==(const midw_ext_fi_tcl_DAB_ChnListElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListElementID == roRef.u16ListElementID);
   bResult = bResult && (u32DABId == roRef.u32DABId);
   bResult = bResult && (u8CompScids == roRef.u8CompScids);
   bResult = bResult && (Label == roRef.Label);
   bResult = bResult && (EnsembleLabel == roRef.EnsembleLabel);
   bResult = bResult && (sFreqLabel == roRef.sFreqLabel);
   bResult = bResult && (u8PresetListElemId == roRef.u8PresetListElemId);
   bResult = bResult && (u8PTY == roRef.u8PTY);
   bResult = bResult && (u16ASU == roRef.u16ASU);
   bResult = bResult && (bReception == roRef.bReception);
   bResult = bResult && (u8NumberOfComponents == roRef.u8NumberOfComponents);
   bResult = bResult && (u8ServiceLinkMode == roRef.u8ServiceLinkMode);
   bResult = bResult && (sLogoLink == roRef.sLogoLink);
   bResult = bResult && (bEPGSupport == roRef.bEPGSupport);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_ListElementAvailInfo::midw_ext_fi_tcl_DAB_ListElementAvailInfo(const midw_ext_fi_tcl_DAB_ListElementAvailInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u16ListElementID = coRef.u16ListElementID;
   bAvailable = coRef.bAvailable;
}
midw_ext_fi_tcl_DAB_ListElementAvailInfo& midw_ext_fi_tcl_DAB_ListElementAvailInfo::operator=(const midw_ext_fi_tcl_DAB_ListElementAvailInfo& coRef)
{
   if (this == &coRef) return *this;
   u16ListElementID = coRef.u16ListElementID;
   bAvailable = coRef.bAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_ListElementAvailInfo::midw_ext_fi_tcl_DAB_ListElementAvailInfo()
:u16ListElementID(0)
,bAvailable(0)
 {}

tS32 midw_ext_fi_tcl_DAB_ListElementAvailInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_LISTELEMENTAVAILINFO;
}


midw_ext_fi_tcl_DAB_ListElementAvailInfo::~midw_ext_fi_tcl_DAB_ListElementAvailInfo()
{}

tU32 midw_ext_fi_tcl_DAB_ListElementAvailInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_ListElementAvailInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListElementID);
   (tVoid) (oIn >> bAvailable);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_ListElementAvailInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListElementID);
   (tVoid) (oOut << bAvailable);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_ListElementAvailInfo::operator==(const midw_ext_fi_tcl_DAB_ListElementAvailInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListElementID == roRef.u16ListElementID);
   bResult = bResult && (bAvailable == roRef.bAvailable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_TIIListElement::midw_ext_fi_tcl_DAB_TIIListElement(const midw_ext_fi_tcl_DAB_TIIListElement& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8MainId = coRef.u8MainId;
   u8SubId = coRef.u8SubId;
   u32Latitude = coRef.u32Latitude;
   u32Longitude = coRef.u32Longitude;
}
midw_ext_fi_tcl_DAB_TIIListElement& midw_ext_fi_tcl_DAB_TIIListElement::operator=(const midw_ext_fi_tcl_DAB_TIIListElement& coRef)
{
   if (this == &coRef) return *this;
   u8MainId = coRef.u8MainId;
   u8SubId = coRef.u8SubId;
   u32Latitude = coRef.u32Latitude;
   u32Longitude = coRef.u32Longitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_TIIListElement::midw_ext_fi_tcl_DAB_TIIListElement()
:u8MainId(0)
,u8SubId(0)
,u32Latitude(0)
,u32Longitude(0)
 {}

tS32 midw_ext_fi_tcl_DAB_TIIListElement::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_TIILISTELEMENT;
}


midw_ext_fi_tcl_DAB_TIIListElement::~midw_ext_fi_tcl_DAB_TIIListElement()
{}

tU32 midw_ext_fi_tcl_DAB_TIIListElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_TIIListElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8MainId);
   (tVoid) (oIn >> u8SubId);
   (tVoid) (oIn >> u32Latitude);
   (tVoid) (oIn >> u32Longitude);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_TIIListElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8MainId);
   (tVoid) (oOut << u8SubId);
   (tVoid) (oOut << u32Latitude);
   (tVoid) (oOut << u32Longitude);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_TIIListElement::operator==(const midw_ext_fi_tcl_DAB_TIIListElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8MainId == roRef.u8MainId);
   bResult = bResult && (u8SubId == roRef.u8SubId);
   bResult = bResult && (u32Latitude == roRef.u32Latitude);
   bResult = bResult && (u32Longitude == roRef.u32Longitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_BankList::midw_ext_fi_tcl_e8_DAB_BankList():enType(FI_EN_BANK_DAB1) {}

tS32 midw_ext_fi_tcl_e8_DAB_BankList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_BANKLIST;
}


midw_ext_fi_tcl_e8_DAB_BankList::~midw_ext_fi_tcl_e8_DAB_BankList()
{}

tU32 midw_ext_fi_tcl_e8_DAB_BankList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_BankList::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_BankList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_TestOperation::midw_ext_fi_tcl_e8_DAB_TestOperation():enType(FI_EN_TUNE_ENSEMBLE) {}

tS32 midw_ext_fi_tcl_e8_DAB_TestOperation::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_TESTOPERATION;
}


midw_ext_fi_tcl_e8_DAB_TestOperation::~midw_ext_fi_tcl_e8_DAB_TestOperation()
{}

tU32 midw_ext_fi_tcl_e8_DAB_TestOperation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_TestOperation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_TestOperation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation::midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation():enType(FI_EN_TUNE_ENSEMBLE) {}

tS32 midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_MANUALMODE_TUNEOPERATION;
}


midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation::~midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation()
{}

tU32 midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b8_DAB_TestMode_Flags::midw_ext_fi_tcl_b8_DAB_TestMode_Flags():u8Value(0)
{}

tS32 midw_ext_fi_tcl_b8_DAB_TestMode_Flags::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B8_DAB_TESTMODE_FLAGS;
}


midw_ext_fi_tcl_b8_DAB_TestMode_Flags::~midw_ext_fi_tcl_b8_DAB_TestMode_Flags()
{}

tU32 midw_ext_fi_tcl_b8_DAB_TestMode_Flags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_b8_DAB_TestMode_Flags::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b8_DAB_TestMode_Flags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags::midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags():u8Value(0)
{}

tS32 midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B8_DAB_ALT_FM_VALID_FLAGS;
}


midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags::~midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags()
{}

tU32 midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_LinkType::midw_ext_fi_tcl_e8_DAB_LinkType():enType(FI_EN_LINKTYPE_DAB_HARDLINK) {}

tS32 midw_ext_fi_tcl_e8_DAB_LinkType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_LINKTYPE;
}


midw_ext_fi_tcl_e8_DAB_LinkType::~midw_ext_fi_tcl_e8_DAB_LinkType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_LinkType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_LinkType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_LinkType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_BG_TestModeData::midw_ext_fi_tcl_DAB_BG_TestModeData(const midw_ext_fi_tcl_DAB_BG_TestModeData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32BgFrequency = coRef.u32BgFrequency;
   u32BgCurrentEnsID = coRef.u32BgCurrentEnsID;
   u32BgFICBER = coRef.u32BgFICBER;
   b16BgFlags = coRef.b16BgFlags;
   sBgDabMode = coRef.sBgDabMode;
}
midw_ext_fi_tcl_DAB_BG_TestModeData& midw_ext_fi_tcl_DAB_BG_TestModeData::operator=(const midw_ext_fi_tcl_DAB_BG_TestModeData& coRef)
{
   if (this == &coRef) return *this;
   u32BgFrequency = coRef.u32BgFrequency;
   u32BgCurrentEnsID = coRef.u32BgCurrentEnsID;
   u32BgFICBER = coRef.u32BgFICBER;
   b16BgFlags = coRef.b16BgFlags;
   sBgDabMode = coRef.sBgDabMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_BG_TestModeData::vDestroy()
{
   sBgDabMode.vDestroy();
}

midw_ext_fi_tcl_DAB_BG_TestModeData::midw_ext_fi_tcl_DAB_BG_TestModeData()
:u32BgFrequency(0)
,u32BgCurrentEnsID(0)
,u32BgFICBER(0)
,b16BgFlags()
,sBgDabMode()
 {}

tS32 midw_ext_fi_tcl_DAB_BG_TestModeData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_BG_TESTMODEDATA;
}


midw_ext_fi_tcl_DAB_BG_TestModeData::~midw_ext_fi_tcl_DAB_BG_TestModeData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_BG_TestModeData::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+sBgDabMode.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_BG_TestModeData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32BgFrequency);
   (tVoid) (oIn >> u32BgCurrentEnsID);
   (tVoid) (oIn >> u32BgFICBER);
   (tVoid) (oIn >> b16BgFlags);
   (tVoid) (oIn >> sBgDabMode);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_BG_TestModeData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32BgFrequency);
   (tVoid) (oOut << u32BgCurrentEnsID);
   (tVoid) (oOut << u32BgFICBER);
   (tVoid) (oOut << b16BgFlags);
   (tVoid) (oOut << sBgDabMode);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_BG_TestModeData::operator==(const midw_ext_fi_tcl_DAB_BG_TestModeData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32BgFrequency == roRef.u32BgFrequency);
   bResult = bResult && (u32BgCurrentEnsID == roRef.u32BgCurrentEnsID);
   bResult = bResult && (u32BgFICBER == roRef.u32BgFICBER);
   bResult = bResult && (b16BgFlags == roRef.b16BgFlags);
   bResult = bResult && (sBgDabMode == roRef.sBgDabMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_Time::midw_ext_fi_tcl_DAB_Time(const midw_ext_fi_tcl_DAB_Time& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32DabSec = coRef.u32DabSec;
   u32DabMin = coRef.u32DabMin;
   u32DabHour = coRef.u32DabHour;
   u32DabMday = coRef.u32DabMday;
   u32DabMon = coRef.u32DabMon;
   u32DabYear = coRef.u32DabYear;
   u32DabWday = coRef.u32DabWday;
   u32DabYday = coRef.u32DabYday;
   u32DabUtcOff = coRef.u32DabUtcOff;
}
midw_ext_fi_tcl_DAB_Time& midw_ext_fi_tcl_DAB_Time::operator=(const midw_ext_fi_tcl_DAB_Time& coRef)
{
   if (this == &coRef) return *this;
   u32DabSec = coRef.u32DabSec;
   u32DabMin = coRef.u32DabMin;
   u32DabHour = coRef.u32DabHour;
   u32DabMday = coRef.u32DabMday;
   u32DabMon = coRef.u32DabMon;
   u32DabYear = coRef.u32DabYear;
   u32DabWday = coRef.u32DabWday;
   u32DabYday = coRef.u32DabYday;
   u32DabUtcOff = coRef.u32DabUtcOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_Time::midw_ext_fi_tcl_DAB_Time()
:u32DabSec(0)
,u32DabMin(0)
,u32DabHour(0)
,u32DabMday(0)
,u32DabMon(0)
,u32DabYear(0)
,u32DabWday(0)
,u32DabYday(0)
,u32DabUtcOff(0)
 {}

tS32 midw_ext_fi_tcl_DAB_Time::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_TIME;
}


midw_ext_fi_tcl_DAB_Time::~midw_ext_fi_tcl_DAB_Time()
{}

tU32 midw_ext_fi_tcl_DAB_Time::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 36;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_Time::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DabSec);
   (tVoid) (oIn >> u32DabMin);
   (tVoid) (oIn >> u32DabHour);
   (tVoid) (oIn >> u32DabMday);
   (tVoid) (oIn >> u32DabMon);
   (tVoid) (oIn >> u32DabYear);
   (tVoid) (oIn >> u32DabWday);
   (tVoid) (oIn >> u32DabYday);
   (tVoid) (oIn >> u32DabUtcOff);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_Time::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DabSec);
   (tVoid) (oOut << u32DabMin);
   (tVoid) (oOut << u32DabHour);
   (tVoid) (oOut << u32DabMday);
   (tVoid) (oOut << u32DabMon);
   (tVoid) (oOut << u32DabYear);
   (tVoid) (oOut << u32DabWday);
   (tVoid) (oOut << u32DabYday);
   (tVoid) (oOut << u32DabUtcOff);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_Time::operator==(const midw_ext_fi_tcl_DAB_Time& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DabSec == roRef.u32DabSec);
   bResult = bResult && (u32DabMin == roRef.u32DabMin);
   bResult = bResult && (u32DabHour == roRef.u32DabHour);
   bResult = bResult && (u32DabMday == roRef.u32DabMday);
   bResult = bResult && (u32DabMon == roRef.u32DabMon);
   bResult = bResult && (u32DabYear == roRef.u32DabYear);
   bResult = bResult && (u32DabWday == roRef.u32DabWday);
   bResult = bResult && (u32DabYday == roRef.u32DabYday);
   bResult = bResult && (u32DabUtcOff == roRef.u32DabUtcOff);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData::midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData(const midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32NumTmcServices = coRef.u32NumTmcServices;
   u32NumTpegServices = coRef.u32NumTpegServices;
   u32RcvTmcMsgs = coRef.u32RcvTmcMsgs;
   u32RcvTpegMsgs = coRef.u32RcvTpegMsgs;
   DabTime = coRef.DabTime;
}
midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData& midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData::operator=(const midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData& coRef)
{
   if (this == &coRef) return *this;
   u32NumTmcServices = coRef.u32NumTmcServices;
   u32NumTpegServices = coRef.u32NumTpegServices;
   u32RcvTmcMsgs = coRef.u32RcvTmcMsgs;
   u32RcvTpegMsgs = coRef.u32RcvTpegMsgs;
   DabTime = coRef.DabTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData::midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData()
:u32NumTmcServices(0)
,u32NumTpegServices(0)
,u32RcvTmcMsgs(0)
,u32RcvTpegMsgs(0)
,DabTime()
 {}

tS32 midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_TMC_TPEG_TESTMODEDATA;
}


midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData::~midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData()
{}

tU32 midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 52;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32NumTmcServices);
   (tVoid) (oIn >> u32NumTpegServices);
   (tVoid) (oIn >> u32RcvTmcMsgs);
   (tVoid) (oIn >> u32RcvTpegMsgs);
   (tVoid) (oIn >> DabTime);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32NumTmcServices);
   (tVoid) (oOut << u32NumTpegServices);
   (tVoid) (oOut << u32RcvTmcMsgs);
   (tVoid) (oOut << u32RcvTpegMsgs);
   (tVoid) (oOut << DabTime);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData::operator==(const midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32NumTmcServices == roRef.u32NumTmcServices);
   bResult = bResult && (u32NumTpegServices == roRef.u32NumTpegServices);
   bResult = bResult && (u32RcvTmcMsgs == roRef.u32RcvTmcMsgs);
   bResult = bResult && (u32RcvTpegMsgs == roRef.u32RcvTpegMsgs);
   bResult = bResult && (DabTime == roRef.DabTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_LinkListElem::midw_ext_fi_tcl_DAB_LinkListElem(const midw_ext_fi_tcl_DAB_LinkListElem& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8LinkType = coRef.e8LinkType;
   sFreqLabel = coRef.sFreqLabel;
   u32ID = coRef.u32ID;
   u32EnsembleId = coRef.u32EnsembleId;
   u8Quality = coRef.u8Quality;
}
midw_ext_fi_tcl_DAB_LinkListElem& midw_ext_fi_tcl_DAB_LinkListElem::operator=(const midw_ext_fi_tcl_DAB_LinkListElem& coRef)
{
   if (this == &coRef) return *this;
   e8LinkType = coRef.e8LinkType;
   sFreqLabel = coRef.sFreqLabel;
   u32ID = coRef.u32ID;
   u32EnsembleId = coRef.u32EnsembleId;
   u8Quality = coRef.u8Quality;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_LinkListElem::vDestroy()
{
   sFreqLabel.vDestroy();
}

midw_ext_fi_tcl_DAB_LinkListElem::midw_ext_fi_tcl_DAB_LinkListElem()
:e8LinkType()
,sFreqLabel()
,u32ID(0)
,u32EnsembleId(0)
,u8Quality(0)
 {}

tS32 midw_ext_fi_tcl_DAB_LinkListElem::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_LINKLISTELEM;
}


midw_ext_fi_tcl_DAB_LinkListElem::~midw_ext_fi_tcl_DAB_LinkListElem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_LinkListElem::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+sFreqLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_LinkListElem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LinkType);
   (tVoid) (oIn >> sFreqLabel);
   (tVoid) (oIn >> u32ID);
   (tVoid) (oIn >> u32EnsembleId);
   (tVoid) (oIn >> u8Quality);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_LinkListElem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LinkType);
   (tVoid) (oOut << sFreqLabel);
   (tVoid) (oOut << u32ID);
   (tVoid) (oOut << u32EnsembleId);
   (tVoid) (oOut << u8Quality);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_LinkListElem::operator==(const midw_ext_fi_tcl_DAB_LinkListElem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LinkType == roRef.e8LinkType);
   bResult = bResult && (sFreqLabel == roRef.sFreqLabel);
   bResult = bResult && (u32ID == roRef.u32ID);
   bResult = bResult && (u32EnsembleId == roRef.u32EnsembleId);
   bResult = bResult && (u8Quality == roRef.u8Quality);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_AltFreqInfo::midw_ext_fi_tcl_DAB_AltFreqInfo(const midw_ext_fi_tcl_DAB_AltFreqInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32Frequency = coRef.u32Frequency;
   s8FieldStrength = coRef.s8FieldStrength;
   u8Quality = coRef.u8Quality;
}
midw_ext_fi_tcl_DAB_AltFreqInfo& midw_ext_fi_tcl_DAB_AltFreqInfo::operator=(const midw_ext_fi_tcl_DAB_AltFreqInfo& coRef)
{
   if (this == &coRef) return *this;
   u32Frequency = coRef.u32Frequency;
   s8FieldStrength = coRef.s8FieldStrength;
   u8Quality = coRef.u8Quality;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_AltFreqInfo::midw_ext_fi_tcl_DAB_AltFreqInfo()
:u32Frequency(0)
,s8FieldStrength(0)
,u8Quality(0)
 {}

tS32 midw_ext_fi_tcl_DAB_AltFreqInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_ALTFREQINFO;
}


midw_ext_fi_tcl_DAB_AltFreqInfo::~midw_ext_fi_tcl_DAB_AltFreqInfo()
{}

tU32 midw_ext_fi_tcl_DAB_AltFreqInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_AltFreqInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> s8FieldStrength);
   (tVoid) (oIn >> u8Quality);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_AltFreqInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << s8FieldStrength);
   (tVoid) (oOut << u8Quality);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_AltFreqInfo::operator==(const midw_ext_fi_tcl_DAB_AltFreqInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (s8FieldStrength == roRef.s8FieldStrength);
   bResult = bResult && (u8Quality == roRef.u8Quality);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_TestModeData::midw_ext_fi_tcl_DAB_TestModeData(const midw_ext_fi_tcl_DAB_TestModeData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32CurrentServID = coRef.u32CurrentServID;
   u32MSCBER = coRef.u32MSCBER;
   u32FICBER = coRef.u32FICBER;
   u32NETBER = coRef.u32NETBER;
   u8RSFEC = coRef.u8RSFEC;
   u8DABMode = coRef.u8DABMode;
   u8ProtectionLevel = coRef.u8ProtectionLevel;
   u8ConcealmentLevel = coRef.u8ConcealmentLevel;
   e8ServiceLinkingMode = coRef.e8ServiceLinkingMode;
   b8ValidFMValues = coRef.b8ValidFMValues;
   u16AltFMPI = coRef.u16AltFMPI;
   u32AltFMFrequency = coRef.u32AltFMFrequency;
   u8AltFMQuality = coRef.u8AltFMQuality;
   b8Flags = coRef.b8Flags;
   s8FieldStrength = coRef.s8FieldStrength;
   u16TotalNumberLinks = coRef.u16TotalNumberLinks;
   u8ECC = coRef.u8ECC;
   u16CountryLabel = coRef.u16CountryLabel;
   u16ActivatedLink = coRef.u16ActivatedLink;
   LinkList = coRef.LinkList;
   DAB_DMB_AltFreqInfo = coRef.DAB_DMB_AltFreqInfo;
   bSync = coRef.bSync;
}
midw_ext_fi_tcl_DAB_TestModeData& midw_ext_fi_tcl_DAB_TestModeData::operator=(const midw_ext_fi_tcl_DAB_TestModeData& coRef)
{
   if (this == &coRef) return *this;
   u32CurrentServID = coRef.u32CurrentServID;
   u32MSCBER = coRef.u32MSCBER;
   u32FICBER = coRef.u32FICBER;
   u32NETBER = coRef.u32NETBER;
   u8RSFEC = coRef.u8RSFEC;
   u8DABMode = coRef.u8DABMode;
   u8ProtectionLevel = coRef.u8ProtectionLevel;
   u8ConcealmentLevel = coRef.u8ConcealmentLevel;
   e8ServiceLinkingMode = coRef.e8ServiceLinkingMode;
   b8ValidFMValues = coRef.b8ValidFMValues;
   u16AltFMPI = coRef.u16AltFMPI;
   u32AltFMFrequency = coRef.u32AltFMFrequency;
   u8AltFMQuality = coRef.u8AltFMQuality;
   b8Flags = coRef.b8Flags;
   s8FieldStrength = coRef.s8FieldStrength;
   u16TotalNumberLinks = coRef.u16TotalNumberLinks;
   u8ECC = coRef.u8ECC;
   u16CountryLabel = coRef.u16CountryLabel;
   u16ActivatedLink = coRef.u16ActivatedLink;
   LinkList = coRef.LinkList;
   DAB_DMB_AltFreqInfo = coRef.DAB_DMB_AltFreqInfo;
   bSync = coRef.bSync;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_TestModeData::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LinkList.size(); ++u32Idx)
         LinkList[u32Idx].vDestroy();
   LinkList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < DAB_DMB_AltFreqInfo.size(); ++u32Idx)
         DAB_DMB_AltFreqInfo[u32Idx].vDestroy();
   DAB_DMB_AltFreqInfo.clear();
   }
}

midw_ext_fi_tcl_DAB_TestModeData::midw_ext_fi_tcl_DAB_TestModeData()
:u32CurrentServID(0)
,u32MSCBER(0)
,u32FICBER(0)
,u32NETBER(0)
,u8RSFEC(0)
,u8DABMode(0)
,u8ProtectionLevel(0)
,u8ConcealmentLevel(0)
,e8ServiceLinkingMode()
,b8ValidFMValues()
,u16AltFMPI(0)
,u32AltFMFrequency(0)
,u8AltFMQuality(0)
,b8Flags()
,s8FieldStrength(0)
,u16TotalNumberLinks(0)
,u8ECC(0)
,u16CountryLabel(0)
,u16ActivatedLink(0)


,bSync(0)
 {}

tS32 midw_ext_fi_tcl_DAB_TestModeData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_TESTMODEDATA;
}


midw_ext_fi_tcl_DAB_TestModeData::~midw_ext_fi_tcl_DAB_TestModeData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_TestModeData::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LinkList.size(); ++u32ListIdx)
      u32DynamicSize += LinkList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+47+ static_cast<tU32>(DAB_DMB_AltFreqInfo.size()*6);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_TestModeData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32CurrentServID);
   (tVoid) (oIn >> u32MSCBER);
   (tVoid) (oIn >> u32FICBER);
   (tVoid) (oIn >> u32NETBER);
   (tVoid) (oIn >> u8RSFEC);
   (tVoid) (oIn >> u8DABMode);
   (tVoid) (oIn >> u8ProtectionLevel);
   (tVoid) (oIn >> u8ConcealmentLevel);
   (tVoid) (oIn >> e8ServiceLinkingMode);
   (tVoid) (oIn >> b8ValidFMValues);
   (tVoid) (oIn >> u16AltFMPI);
   (tVoid) (oIn >> u32AltFMFrequency);
   (tVoid) (oIn >> u8AltFMQuality);
   (tVoid) (oIn >> b8Flags);
   (tVoid) (oIn >> s8FieldStrength);
   (tVoid) (oIn >> u16TotalNumberLinks);
   (tVoid) (oIn >> u8ECC);
   (tVoid) (oIn >> u16CountryLabel);
   (tVoid) (oIn >> u16ActivatedLink);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LinkList.size(); ++u32Idx)
      {
         LinkList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      LinkList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> LinkList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DAB_DMB_AltFreqInfo.size(); ++u32Idx)
      {
         DAB_DMB_AltFreqInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DAB_DMB_AltFreqInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DAB_DMB_AltFreqInfo[u32Idx]);
      }
   }
   (tVoid) (oIn >> bSync);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_TestModeData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32CurrentServID);
   (tVoid) (oOut << u32MSCBER);
   (tVoid) (oOut << u32FICBER);
   (tVoid) (oOut << u32NETBER);
   (tVoid) (oOut << u8RSFEC);
   (tVoid) (oOut << u8DABMode);
   (tVoid) (oOut << u8ProtectionLevel);
   (tVoid) (oOut << u8ConcealmentLevel);
   (tVoid) (oOut << e8ServiceLinkingMode);
   (tVoid) (oOut << b8ValidFMValues);
   (tVoid) (oOut << u16AltFMPI);
   (tVoid) (oOut << u32AltFMFrequency);
   (tVoid) (oOut << u8AltFMQuality);
   (tVoid) (oOut << b8Flags);
   (tVoid) (oOut << s8FieldStrength);
   (tVoid) (oOut << u16TotalNumberLinks);
   (tVoid) (oOut << u8ECC);
   (tVoid) (oOut << u16CountryLabel);
   (tVoid) (oOut << u16ActivatedLink);
   (tVoid) (oOut << (tU32)LinkList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < LinkList.size(); ++u32Idx)
         (tVoid) (oOut << LinkList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)DAB_DMB_AltFreqInfo.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DAB_DMB_AltFreqInfo.size(); ++u32Idx)
         (tVoid) (oOut << DAB_DMB_AltFreqInfo[u32Idx]);
   }
   (tVoid) (oOut << bSync);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_TestModeData::operator==(const midw_ext_fi_tcl_DAB_TestModeData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32CurrentServID == roRef.u32CurrentServID);
   bResult = bResult && (u32MSCBER == roRef.u32MSCBER);
   bResult = bResult && (u32FICBER == roRef.u32FICBER);
   bResult = bResult && (u32NETBER == roRef.u32NETBER);
   bResult = bResult && (u8RSFEC == roRef.u8RSFEC);
   bResult = bResult && (u8DABMode == roRef.u8DABMode);
   bResult = bResult && (u8ProtectionLevel == roRef.u8ProtectionLevel);
   bResult = bResult && (u8ConcealmentLevel == roRef.u8ConcealmentLevel);
   bResult = bResult && (e8ServiceLinkingMode == roRef.e8ServiceLinkingMode);
   bResult = bResult && (b8ValidFMValues == roRef.b8ValidFMValues);
   bResult = bResult && (u16AltFMPI == roRef.u16AltFMPI);
   bResult = bResult && (u32AltFMFrequency == roRef.u32AltFMFrequency);
   bResult = bResult && (u8AltFMQuality == roRef.u8AltFMQuality);
   bResult = bResult && (b8Flags == roRef.b8Flags);
   bResult = bResult && (s8FieldStrength == roRef.s8FieldStrength);
   bResult = bResult && (u16TotalNumberLinks == roRef.u16TotalNumberLinks);
   bResult = bResult && (u8ECC == roRef.u8ECC);
   bResult = bResult && (u16CountryLabel == roRef.u16CountryLabel);
   bResult = bResult && (u16ActivatedLink == roRef.u16ActivatedLink);
      bResult = bResult && (LinkList.size() == roRef.LinkList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LinkList.size()); ++u32Idx)
            bResult = bResult && (LinkList[u32Idx] == roRef.LinkList[u32Idx]);
      }
      bResult = bResult && (DAB_DMB_AltFreqInfo.size() == roRef.DAB_DMB_AltFreqInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DAB_DMB_AltFreqInfo.size()); ++u32Idx)
            bResult = bResult && (DAB_DMB_AltFreqInfo[u32Idx] == roRef.DAB_DMB_AltFreqInfo[u32Idx]);
      }
   bResult = bResult && (bSync == roRef.bSync);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_RdbId::midw_ext_fi_tcl_DAB_RdbId(const midw_ext_fi_tcl_DAB_RdbId& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Cc = coRef.u8Cc;
   u8Ltn = coRef.u8Ltn;
   u8Bsa = coRef.u8Bsa;
   u16Bsa = coRef.u16Bsa;
   u8Sid = coRef.u8Sid;
   bEncrypted = coRef.bEncrypted;
}
midw_ext_fi_tcl_DAB_RdbId& midw_ext_fi_tcl_DAB_RdbId::operator=(const midw_ext_fi_tcl_DAB_RdbId& coRef)
{
   if (this == &coRef) return *this;
   u8Cc = coRef.u8Cc;
   u8Ltn = coRef.u8Ltn;
   u8Bsa = coRef.u8Bsa;
   u16Bsa = coRef.u16Bsa;
   u8Sid = coRef.u8Sid;
   bEncrypted = coRef.bEncrypted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_RdbId::midw_ext_fi_tcl_DAB_RdbId()
:u8Cc(0)
,u8Ltn(0)
,u8Bsa(0)
,u16Bsa(0)
,u8Sid(0)
,bEncrypted(0)
 {}

tS32 midw_ext_fi_tcl_DAB_RdbId::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_RDBID;
}


midw_ext_fi_tcl_DAB_RdbId::~midw_ext_fi_tcl_DAB_RdbId()
{}

tU32 midw_ext_fi_tcl_DAB_RdbId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_RdbId::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Cc);
   (tVoid) (oIn >> u8Ltn);
   (tVoid) (oIn >> u8Bsa);
   (tVoid) (oIn >> u16Bsa);
   (tVoid) (oIn >> u8Sid);
   (tVoid) (oIn >> bEncrypted);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_RdbId::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Cc);
   (tVoid) (oOut << u8Ltn);
   (tVoid) (oOut << u8Bsa);
   (tVoid) (oOut << u16Bsa);
   (tVoid) (oOut << u8Sid);
   (tVoid) (oOut << bEncrypted);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_RdbId::operator==(const midw_ext_fi_tcl_DAB_RdbId& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Cc == roRef.u8Cc);
   bResult = bResult && (u8Ltn == roRef.u8Ltn);
   bResult = bResult && (u8Bsa == roRef.u8Bsa);
   bResult = bResult && (u16Bsa == roRef.u16Bsa);
   bResult = bResult && (u8Sid == roRef.u8Sid);
   bResult = bResult && (bEncrypted == roRef.bEncrypted);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_TmcData::midw_ext_fi_tcl_DAB_TmcData(const midw_ext_fi_tcl_DAB_TmcData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8TmcData1 = coRef.u8TmcData1;
   u8TmcData2 = coRef.u8TmcData2;
   u8TmcData3 = coRef.u8TmcData3;
   u8TmcData4 = coRef.u8TmcData4;
   u8TmcData5 = coRef.u8TmcData5;
}
midw_ext_fi_tcl_DAB_TmcData& midw_ext_fi_tcl_DAB_TmcData::operator=(const midw_ext_fi_tcl_DAB_TmcData& coRef)
{
   if (this == &coRef) return *this;
   u8TmcData1 = coRef.u8TmcData1;
   u8TmcData2 = coRef.u8TmcData2;
   u8TmcData3 = coRef.u8TmcData3;
   u8TmcData4 = coRef.u8TmcData4;
   u8TmcData5 = coRef.u8TmcData5;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_TmcData::midw_ext_fi_tcl_DAB_TmcData()
:u8TmcData1(0)
,u8TmcData2(0)
,u8TmcData3(0)
,u8TmcData4(0)
,u8TmcData5(0)
 {}

tS32 midw_ext_fi_tcl_DAB_TmcData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_TMCDATA;
}


midw_ext_fi_tcl_DAB_TmcData::~midw_ext_fi_tcl_DAB_TmcData()
{}

tU32 midw_ext_fi_tcl_DAB_TmcData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_TmcData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TmcData1);
   (tVoid) (oIn >> u8TmcData2);
   (tVoid) (oIn >> u8TmcData3);
   (tVoid) (oIn >> u8TmcData4);
   (tVoid) (oIn >> u8TmcData5);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_TmcData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TmcData1);
   (tVoid) (oOut << u8TmcData2);
   (tVoid) (oOut << u8TmcData3);
   (tVoid) (oOut << u8TmcData4);
   (tVoid) (oOut << u8TmcData5);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_TmcData::operator==(const midw_ext_fi_tcl_DAB_TmcData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TmcData1 == roRef.u8TmcData1);
   bResult = bResult && (u8TmcData2 == roRef.u8TmcData2);
   bResult = bResult && (u8TmcData3 == roRef.u8TmcData3);
   bResult = bResult && (u8TmcData4 == roRef.u8TmcData4);
   bResult = bResult && (u8TmcData5 == roRef.u8TmcData5);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_Encryption::midw_ext_fi_tcl_DAB_Encryption(const midw_ext_fi_tcl_DAB_Encryption& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   bEncrypted = coRef.bEncrypted;
   u8EncId = coRef.u8EncId;
   u8TestBits = coRef.u8TestBits;
}
midw_ext_fi_tcl_DAB_Encryption& midw_ext_fi_tcl_DAB_Encryption::operator=(const midw_ext_fi_tcl_DAB_Encryption& coRef)
{
   if (this == &coRef) return *this;
   bEncrypted = coRef.bEncrypted;
   u8EncId = coRef.u8EncId;
   u8TestBits = coRef.u8TestBits;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_Encryption::midw_ext_fi_tcl_DAB_Encryption()
:bEncrypted(0)
,u8EncId(0)
,u8TestBits(0)
 {}

tS32 midw_ext_fi_tcl_DAB_Encryption::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_ENCRYPTION;
}


midw_ext_fi_tcl_DAB_Encryption::~midw_ext_fi_tcl_DAB_Encryption()
{}

tU32 midw_ext_fi_tcl_DAB_Encryption::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_Encryption::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEncrypted);
   (tVoid) (oIn >> u8EncId);
   (tVoid) (oIn >> u8TestBits);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_Encryption::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEncrypted);
   (tVoid) (oOut << u8EncId);
   (tVoid) (oOut << u8TestBits);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_Encryption::operator==(const midw_ext_fi_tcl_DAB_Encryption& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEncrypted == roRef.bEncrypted);
   bResult = bResult && (u8EncId == roRef.u8EncId);
   bResult = bResult && (u8TestBits == roRef.u8TestBits);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_TmcMediumType::midw_ext_fi_tcl_e8_DAB_TmcMediumType():enType(FI_EN_DAB_MEDIUMTYPE_RESERVED) {}

tS32 midw_ext_fi_tcl_e8_DAB_TmcMediumType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_TMCMEDIUMTYPE;
}


midw_ext_fi_tcl_e8_DAB_TmcMediumType::~midw_ext_fi_tcl_e8_DAB_TmcMediumType()
{}

tU32 midw_ext_fi_tcl_e8_DAB_TmcMediumType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_TmcMediumType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_TmcMediumType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DAB_TuneCmd::midw_ext_fi_tcl_e8_DAB_TuneCmd():enType(FI_EN_DAB_TUNE_NEXT) {}

tS32 midw_ext_fi_tcl_e8_DAB_TuneCmd::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DAB_TUNECMD;
}


midw_ext_fi_tcl_e8_DAB_TuneCmd::~midw_ext_fi_tcl_e8_DAB_TuneCmd()
{}

tU32 midw_ext_fi_tcl_e8_DAB_TuneCmd::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DAB_TuneCmd::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DAB_TuneCmd::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_MsgSource::midw_ext_fi_tcl_DAB_MsgSource(const midw_ext_fi_tcl_DAB_MsgSource& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   DabMediumTypeId = coRef.DabMediumTypeId;
   u8Number = coRef.u8Number;
}
midw_ext_fi_tcl_DAB_MsgSource& midw_ext_fi_tcl_DAB_MsgSource::operator=(const midw_ext_fi_tcl_DAB_MsgSource& coRef)
{
   if (this == &coRef) return *this;
   DabMediumTypeId = coRef.DabMediumTypeId;
   u8Number = coRef.u8Number;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_DAB_MsgSource::midw_ext_fi_tcl_DAB_MsgSource()
:DabMediumTypeId()
,u8Number(0)
 {}

tS32 midw_ext_fi_tcl_DAB_MsgSource::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_MSGSOURCE;
}


midw_ext_fi_tcl_DAB_MsgSource::~midw_ext_fi_tcl_DAB_MsgSource()
{}

tU32 midw_ext_fi_tcl_DAB_MsgSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_DAB_MsgSource::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DabMediumTypeId);
   (tVoid) (oIn >> u8Number);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_MsgSource::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DabMediumTypeId);
   (tVoid) (oOut << u8Number);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_MsgSource::operator==(const midw_ext_fi_tcl_DAB_MsgSource& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DabMediumTypeId == roRef.DabMediumTypeId);
   bResult = bResult && (u8Number == roRef.u8Number);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_TmcInfo::midw_ext_fi_tcl_DAB_TmcInfo(const midw_ext_fi_tcl_DAB_TmcInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   RdbId = coRef.RdbId;
   s16Ecc = coRef.s16Ecc;
   u16Aid = coRef.u16Aid;
   TmcData = coRef.TmcData;
   u16ProgramId = coRef.u16ProgramId;
   DabEncryption = coRef.DabEncryption;
   DabMsgSource = coRef.DabMsgSource;
   sProgramServiceName = coRef.sProgramServiceName;
   sServiceProviderName = coRef.sServiceProviderName;
}
midw_ext_fi_tcl_DAB_TmcInfo& midw_ext_fi_tcl_DAB_TmcInfo::operator=(const midw_ext_fi_tcl_DAB_TmcInfo& coRef)
{
   if (this == &coRef) return *this;
   RdbId = coRef.RdbId;
   s16Ecc = coRef.s16Ecc;
   u16Aid = coRef.u16Aid;
   TmcData = coRef.TmcData;
   u16ProgramId = coRef.u16ProgramId;
   DabEncryption = coRef.DabEncryption;
   DabMsgSource = coRef.DabMsgSource;
   sProgramServiceName = coRef.sProgramServiceName;
   sServiceProviderName = coRef.sServiceProviderName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_TmcInfo::vDestroy()
{
   RdbId.vDestroy(); 
   {
   TmcData.clear();
   }
   DabEncryption.vDestroy(); 
   DabMsgSource.vDestroy(); 
   sProgramServiceName.vDestroy();
   sServiceProviderName.vDestroy();
}

midw_ext_fi_tcl_DAB_TmcInfo::midw_ext_fi_tcl_DAB_TmcInfo()
:RdbId()
,s16Ecc(0)
,u16Aid(0)

,u16ProgramId(0)
,DabEncryption()
,DabMsgSource()
,sProgramServiceName()
,sServiceProviderName()
 {}

tS32 midw_ext_fi_tcl_DAB_TmcInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_TMCINFO;
}


midw_ext_fi_tcl_DAB_TmcInfo::~midw_ext_fi_tcl_DAB_TmcInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_TmcInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 22+ static_cast<tU32>(TmcData.size()*1)+sProgramServiceName.u32GetSize(u16MajorVersion)+sServiceProviderName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_TmcInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RdbId);
   (tVoid) (oIn >> s16Ecc);
   (tVoid) (oIn >> u16Aid);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      TmcData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TmcData[u32Idx]);
      }
   }
   (tVoid) (oIn >> u16ProgramId);
   (tVoid) (oIn >> DabEncryption);
   (tVoid) (oIn >> DabMsgSource);
   (tVoid) (oIn >> sProgramServiceName);
   (tVoid) (oIn >> sServiceProviderName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_TmcInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RdbId);
   (tVoid) (oOut << s16Ecc);
   (tVoid) (oOut << u16Aid);
   (tVoid) (oOut << (tU32)TmcData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TmcData.size(); ++u32Idx)
         (tVoid) (oOut << TmcData[u32Idx]);
   }
   (tVoid) (oOut << u16ProgramId);
   (tVoid) (oOut << DabEncryption);
   (tVoid) (oOut << DabMsgSource);
   (tVoid) (oOut << sProgramServiceName);
   (tVoid) (oOut << sServiceProviderName);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_TmcInfo::operator==(const midw_ext_fi_tcl_DAB_TmcInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RdbId == roRef.RdbId);
   bResult = bResult && (s16Ecc == roRef.s16Ecc);
   bResult = bResult && (u16Aid == roRef.u16Aid);
      bResult = bResult && (TmcData.size() == roRef.TmcData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TmcData.size()); ++u32Idx)
            bResult = bResult && (TmcData[u32Idx] == roRef.TmcData[u32Idx]);
      }
   bResult = bResult && (u16ProgramId == roRef.u16ProgramId);
   bResult = bResult && (DabEncryption == roRef.DabEncryption);
   bResult = bResult && (DabMsgSource == roRef.DabMsgSource);
   bResult = bResult && (sProgramServiceName == roRef.sProgramServiceName);
   bResult = bResult && (sServiceProviderName == roRef.sServiceProviderName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_EnsembleTmcInfo::midw_ext_fi_tcl_DAB_EnsembleTmcInfo(const midw_ext_fi_tcl_DAB_EnsembleTmcInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32EnsembleId = coRef.u32EnsembleId;
   u8Quality = coRef.u8Quality;
   u8NumberOfRdbIds = coRef.u8NumberOfRdbIds;
   RdbIdList = coRef.RdbIdList;
}
midw_ext_fi_tcl_DAB_EnsembleTmcInfo& midw_ext_fi_tcl_DAB_EnsembleTmcInfo::operator=(const midw_ext_fi_tcl_DAB_EnsembleTmcInfo& coRef)
{
   if (this == &coRef) return *this;
   u32EnsembleId = coRef.u32EnsembleId;
   u8Quality = coRef.u8Quality;
   u8NumberOfRdbIds = coRef.u8NumberOfRdbIds;
   RdbIdList = coRef.RdbIdList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_EnsembleTmcInfo::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RdbIdList.size(); ++u32Idx)
         RdbIdList[u32Idx].vDestroy();
   RdbIdList.clear();
   }
}

midw_ext_fi_tcl_DAB_EnsembleTmcInfo::midw_ext_fi_tcl_DAB_EnsembleTmcInfo()
:u32EnsembleId(0)
,u8Quality(0)
,u8NumberOfRdbIds(0)

 {}

tS32 midw_ext_fi_tcl_DAB_EnsembleTmcInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_ENSEMBLETMCINFO;
}


midw_ext_fi_tcl_DAB_EnsembleTmcInfo::~midw_ext_fi_tcl_DAB_EnsembleTmcInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_EnsembleTmcInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10+ static_cast<tU32>(RdbIdList.size()*7);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_EnsembleTmcInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32EnsembleId);
   (tVoid) (oIn >> u8Quality);
   (tVoid) (oIn >> u8NumberOfRdbIds);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RdbIdList.size(); ++u32Idx)
      {
         RdbIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RdbIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RdbIdList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_EnsembleTmcInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32EnsembleId);
   (tVoid) (oOut << u8Quality);
   (tVoid) (oOut << u8NumberOfRdbIds);
   (tVoid) (oOut << (tU32)RdbIdList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RdbIdList.size(); ++u32Idx)
         (tVoid) (oOut << RdbIdList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_EnsembleTmcInfo::operator==(const midw_ext_fi_tcl_DAB_EnsembleTmcInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32EnsembleId == roRef.u32EnsembleId);
   bResult = bResult && (u8Quality == roRef.u8Quality);
   bResult = bResult && (u8NumberOfRdbIds == roRef.u8NumberOfRdbIds);
      bResult = bResult && (RdbIdList.size() == roRef.RdbIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RdbIdList.size()); ++u32Idx)
            bResult = bResult && (RdbIdList[u32Idx] == roRef.RdbIdList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_TpegInfo::midw_ext_fi_tcl_DAB_TpegInfo(const midw_ext_fi_tcl_DAB_TpegInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   TpegData = coRef.TpegData;
}
midw_ext_fi_tcl_DAB_TpegInfo& midw_ext_fi_tcl_DAB_TpegInfo::operator=(const midw_ext_fi_tcl_DAB_TpegInfo& coRef)
{
   if (this == &coRef) return *this;
   TpegData = coRef.TpegData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_TpegInfo::vDestroy()
{
   {
   TpegData.clear();
   }
}

midw_ext_fi_tcl_DAB_TpegInfo::midw_ext_fi_tcl_DAB_TpegInfo()

 {}

tS32 midw_ext_fi_tcl_DAB_TpegInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_TPEGINFO;
}


midw_ext_fi_tcl_DAB_TpegInfo::~midw_ext_fi_tcl_DAB_TpegInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_TpegInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TpegData.size()*1);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_TpegInfo::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      TpegData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TpegData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_TpegInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TpegData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TpegData.size(); ++u32Idx)
         (tVoid) (oOut << TpegData[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_TpegInfo::operator==(const midw_ext_fi_tcl_DAB_TpegInfo& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TpegData.size() == roRef.TpegData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TpegData.size()); ++u32Idx)
            bResult = bResult && (TpegData[u32Idx] == roRef.TpegData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_DAB_TpegUriChannel::midw_ext_fi_tcl_DAB_TpegUriChannel(const midw_ext_fi_tcl_DAB_TpegUriChannel& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sTpegUriChn = coRef.sTpegUriChn;
   DabUriSelectState = coRef.DabUriSelectState;
   bActive = coRef.bActive;
}
midw_ext_fi_tcl_DAB_TpegUriChannel& midw_ext_fi_tcl_DAB_TpegUriChannel::operator=(const midw_ext_fi_tcl_DAB_TpegUriChannel& coRef)
{
   if (this == &coRef) return *this;
   sTpegUriChn = coRef.sTpegUriChn;
   DabUriSelectState = coRef.DabUriSelectState;
   bActive = coRef.bActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_DAB_TpegUriChannel::vDestroy()
{
   sTpegUriChn.vDestroy();
}

midw_ext_fi_tcl_DAB_TpegUriChannel::midw_ext_fi_tcl_DAB_TpegUriChannel()
:sTpegUriChn()
,DabUriSelectState()
,bActive(0)
 {}

tS32 midw_ext_fi_tcl_DAB_TpegUriChannel::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_DAB_TPEGURICHANNEL;
}


midw_ext_fi_tcl_DAB_TpegUriChannel::~midw_ext_fi_tcl_DAB_TpegUriChannel()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_DAB_TpegUriChannel::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+sTpegUriChn.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_DAB_TpegUriChannel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sTpegUriChn);
   (tVoid) (oIn >> DabUriSelectState);
   (tVoid) (oIn >> bActive);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_DAB_TpegUriChannel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sTpegUriChn);
   (tVoid) (oOut << DabUriSelectState);
   (tVoid) (oOut << bActive);
   return oOut;
}

tBool midw_ext_fi_tcl_DAB_TpegUriChannel::operator==(const midw_ext_fi_tcl_DAB_TpegUriChannel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sTpegUriChn == roRef.sTpegUriChn);
   bResult = bResult && (DabUriSelectState == roRef.DabUriSelectState);
   bResult = bResult && (bActive == roRef.bActive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DefSetMode::midw_ext_fi_tcl_e8_DefSetMode():enType(FI_EN_DEFSET_SRC_NOT_DEF) {}

tS32 midw_ext_fi_tcl_e8_DefSetMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DEFSETMODE;
}


midw_ext_fi_tcl_e8_DefSetMode::~midw_ext_fi_tcl_e8_DefSetMode()
{}

tU32 midw_ext_fi_tcl_e8_DefSetMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DefSetMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DefSetMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DefSetServiceStatus::midw_ext_fi_tcl_e8_DefSetServiceStatus():enType(FI_EN_DEFSET_STATE_UNDEFINED) {}

tS32 midw_ext_fi_tcl_e8_DefSetServiceStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DEFSETSERVICESTATUS;
}


midw_ext_fi_tcl_e8_DefSetServiceStatus::~midw_ext_fi_tcl_e8_DefSetServiceStatus()
{}

tU32 midw_ext_fi_tcl_e8_DefSetServiceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DefSetServiceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DefSetServiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DefSetGroups::midw_ext_fi_tcl_e8_DefSetGroups():enType(FI_EN_DEFSET_GROUP_UNDEFIEND) {}

tS32 midw_ext_fi_tcl_e8_DefSetGroups::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DEFSETGROUPS;
}


midw_ext_fi_tcl_e8_DefSetGroups::~midw_ext_fi_tcl_e8_DefSetGroups()
{}

tU32 midw_ext_fi_tcl_e8_DefSetGroups::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DefSetGroups::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DefSetGroups::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_RCtrlSource::midw_ext_fi_tcl_e8_RCtrlSource():enType(FI_EN_RCTRL_SRC_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_RCtrlSource::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_RCTRLSOURCE;
}


midw_ext_fi_tcl_e8_RCtrlSource::~midw_ext_fi_tcl_e8_RCtrlSource()
{}

tU32 midw_ext_fi_tcl_e8_RCtrlSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_RCtrlSource::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_RCtrlSource::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_RCtrlCommand::midw_ext_fi_tcl_e8_RCtrlCommand():enType(FI_EN_RCTRL_CMD_DEACTIVATE) {}

tS32 midw_ext_fi_tcl_e8_RCtrlCommand::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_RCTRLCOMMAND;
}


midw_ext_fi_tcl_e8_RCtrlCommand::~midw_ext_fi_tcl_e8_RCtrlCommand()
{}

tU32 midw_ext_fi_tcl_e8_RCtrlCommand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_RCtrlCommand::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_RCtrlCommand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_RCtrlSignal::midw_ext_fi_tcl_e8_RCtrlSignal():enType(FI_EN_RCTRL_SIG_ALL) {}

tS32 midw_ext_fi_tcl_e8_RCtrlSignal::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_RCTRLSIGNAL;
}


midw_ext_fi_tcl_e8_RCtrlSignal::~midw_ext_fi_tcl_e8_RCtrlSignal()
{}

tU32 midw_ext_fi_tcl_e8_RCtrlSignal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_RCtrlSignal::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_RCtrlSignal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_CCAError::midw_ext_fi_tcl_e8_PHN_VAG_CCAError():enType(FI_EN_PHN_VAG_CCA_UNSPECIFIED) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_CCAError::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_CCAERROR;
}


midw_ext_fi_tcl_e8_PHN_VAG_CCAError::~midw_ext_fi_tcl_e8_PHN_VAG_CCAError()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_CCAError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_CCAError::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_CCAError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_PhoneError::midw_ext_fi_tcl_e8_PHN_VAG_PhoneError():enType(FI_EN_PHN_VAG_NO_ERROR) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_PhoneError::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_PHONEERROR;
}


midw_ext_fi_tcl_e8_PHN_VAG_PhoneError::~midw_ext_fi_tcl_e8_PHN_VAG_PhoneError()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_PhoneError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_PhoneError::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_PhoneError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus::midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus():enType(FI_EN_PHN_VAG_AUDIO_MUTE_ACK_NOK) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_AUDIOMUTEREQUESTACKSTATUS;
}


midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus::~midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState::midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState():enType(FI_EN_PHN_VAG_BT_INVISIBLE) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BTVISIBLESTATE;
}


midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState::~midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BTDeviceName::midw_ext_fi_tcl_PHN_VAG_BTDeviceName(const midw_ext_fi_tcl_PHN_VAG_BTDeviceName& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sBTDeviceName = coRef.sBTDeviceName;
}
midw_ext_fi_tcl_PHN_VAG_BTDeviceName& midw_ext_fi_tcl_PHN_VAG_BTDeviceName::operator=(const midw_ext_fi_tcl_PHN_VAG_BTDeviceName& coRef)
{
   if (this == &coRef) return *this;
   sBTDeviceName = coRef.sBTDeviceName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BTDeviceName::vDestroy()
{
   sBTDeviceName.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_BTDeviceName::midw_ext_fi_tcl_PHN_VAG_BTDeviceName()
:sBTDeviceName()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BTDeviceName::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BTDEVICENAME;
}


midw_ext_fi_tcl_PHN_VAG_BTDeviceName::~midw_ext_fi_tcl_PHN_VAG_BTDeviceName()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BTDeviceName::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sBTDeviceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BTDeviceName::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBTDeviceName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BTDeviceName::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBTDeviceName);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BTDeviceName::operator==(const midw_ext_fi_tcl_PHN_VAG_BTDeviceName& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBTDeviceName == roRef.sBTDeviceName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress::midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress(const midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sBTDeviceAddress = coRef.sBTDeviceAddress;
}
midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress& midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress::operator=(const midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress& coRef)
{
   if (this == &coRef) return *this;
   sBTDeviceAddress = coRef.sBTDeviceAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress::vDestroy()
{
   sBTDeviceAddress.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress::midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress()
:sBTDeviceAddress()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BTDEVICEADDRESS;
}


midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress::~midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sBTDeviceAddress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBTDeviceAddress);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBTDeviceAddress);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress::operator==(const midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBTDeviceAddress == roRef.sBTDeviceAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_PairedBTDevice::midw_ext_fi_tcl_PHN_VAG_PairedBTDevice(const midw_ext_fi_tcl_PHN_VAG_PairedBTDevice& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   bHfpSupported = coRef.bHfpSupported;
   bAvpSupported = coRef.bAvpSupported;
   bSmsSupported = coRef.bSmsSupported;
   bPimSupported = coRef.bPimSupported;
   bDunSupported = coRef.bDunSupported;
   bPanSupported = coRef.bPanSupported;
   bSppSupported = coRef.bSppSupported;
   BTDeviceName = coRef.BTDeviceName;
   BTDeviceAddess = coRef.BTDeviceAddess;
   u8DeviceId = coRef.u8DeviceId;
}
midw_ext_fi_tcl_PHN_VAG_PairedBTDevice& midw_ext_fi_tcl_PHN_VAG_PairedBTDevice::operator=(const midw_ext_fi_tcl_PHN_VAG_PairedBTDevice& coRef)
{
   if (this == &coRef) return *this;
   bHfpSupported = coRef.bHfpSupported;
   bAvpSupported = coRef.bAvpSupported;
   bSmsSupported = coRef.bSmsSupported;
   bPimSupported = coRef.bPimSupported;
   bDunSupported = coRef.bDunSupported;
   bPanSupported = coRef.bPanSupported;
   bSppSupported = coRef.bSppSupported;
   BTDeviceName = coRef.BTDeviceName;
   BTDeviceAddess = coRef.BTDeviceAddess;
   u8DeviceId = coRef.u8DeviceId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_PairedBTDevice::vDestroy()
{
   BTDeviceName.vDestroy(); 
   BTDeviceAddess.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_PairedBTDevice::midw_ext_fi_tcl_PHN_VAG_PairedBTDevice()
:bHfpSupported(0)
,bAvpSupported(0)
,bSmsSupported(0)
,bPimSupported(0)
,bDunSupported(0)
,bPanSupported(0)
,bSppSupported(0)
,BTDeviceName()
,BTDeviceAddess()
,u8DeviceId(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_PairedBTDevice::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_PAIREDBTDEVICE;
}


midw_ext_fi_tcl_PHN_VAG_PairedBTDevice::~midw_ext_fi_tcl_PHN_VAG_PairedBTDevice()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_PairedBTDevice::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+BTDeviceName.u32GetSize(u16MajorVersion)+BTDeviceAddess.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_PairedBTDevice::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bHfpSupported);
   (tVoid) (oIn >> bAvpSupported);
   (tVoid) (oIn >> bSmsSupported);
   (tVoid) (oIn >> bPimSupported);
   (tVoid) (oIn >> bDunSupported);
   (tVoid) (oIn >> bPanSupported);
   (tVoid) (oIn >> bSppSupported);
   (tVoid) (oIn >> BTDeviceName);
   (tVoid) (oIn >> BTDeviceAddess);
   (tVoid) (oIn >> u8DeviceId);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_PairedBTDevice::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bHfpSupported);
   (tVoid) (oOut << bAvpSupported);
   (tVoid) (oOut << bSmsSupported);
   (tVoid) (oOut << bPimSupported);
   (tVoid) (oOut << bDunSupported);
   (tVoid) (oOut << bPanSupported);
   (tVoid) (oOut << bSppSupported);
   (tVoid) (oOut << BTDeviceName);
   (tVoid) (oOut << BTDeviceAddess);
   (tVoid) (oOut << u8DeviceId);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_PairedBTDevice::operator==(const midw_ext_fi_tcl_PHN_VAG_PairedBTDevice& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bHfpSupported == roRef.bHfpSupported);
   bResult = bResult && (bAvpSupported == roRef.bAvpSupported);
   bResult = bResult && (bSmsSupported == roRef.bSmsSupported);
   bResult = bResult && (bPimSupported == roRef.bPimSupported);
   bResult = bResult && (bDunSupported == roRef.bDunSupported);
   bResult = bResult && (bPanSupported == roRef.bPanSupported);
   bResult = bResult && (bSppSupported == roRef.bSppSupported);
   bResult = bResult && (BTDeviceName == roRef.BTDeviceName);
   bResult = bResult && (BTDeviceAddess == roRef.BTDeviceAddess);
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_U8_Handle::midw_ext_fi_tcl_PHN_U8_Handle(const midw_ext_fi_tcl_PHN_U8_Handle& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   handle = coRef.handle;
}
midw_ext_fi_tcl_PHN_U8_Handle& midw_ext_fi_tcl_PHN_U8_Handle::operator=(const midw_ext_fi_tcl_PHN_U8_Handle& coRef)
{
   if (this == &coRef) return *this;
   handle = coRef.handle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_U8_Handle::vDestroy()
{
   {
   handle.clear();
   }
}

midw_ext_fi_tcl_PHN_U8_Handle::midw_ext_fi_tcl_PHN_U8_Handle()

 {}

tS32 midw_ext_fi_tcl_PHN_U8_Handle::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_U8_HANDLE;
}


midw_ext_fi_tcl_PHN_U8_Handle::~midw_ext_fi_tcl_PHN_U8_Handle()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_U8_Handle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(handle.size()*1);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_U8_Handle::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      handle.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> handle[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_U8_Handle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)handle.size());
   {
      for (tU32 u32Idx = 0; u32Idx < handle.size(); ++u32Idx)
         (tVoid) (oOut << handle[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_U8_Handle::operator==(const midw_ext_fi_tcl_PHN_U8_Handle& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (handle.size() == roRef.handle.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < handle.size()); ++u32Idx)
            bResult = bResult && (handle[u32Idx] == roRef.handle[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService::midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService():enType(FI_EN_PHN_BT_DEV_SERVICE_DUN) {}

tS32 midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_BTVIRTUALDEVICESERVICE;
}


midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService::~midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService()
{}

tU32 midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation::midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation(const midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8ServiceHandle = coRef.u8ServiceHandle;
   sServiceName = coRef.sServiceName;
   oUuidList = coRef.oUuidList;
}
midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation& midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation::operator=(const midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation& coRef)
{
   if (this == &coRef) return *this;
   u8ServiceHandle = coRef.u8ServiceHandle;
   sServiceName = coRef.sServiceName;
   oUuidList = coRef.oUuidList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation::vDestroy()
{
   sServiceName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < oUuidList.size(); ++u32Idx)
         oUuidList[u32Idx].vDestroy();
   oUuidList.clear();
   }
}

midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation::midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation()
:u8ServiceHandle(0)
,sServiceName()

 {}

tS32 midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_BT_SPP_SERVICEINFORMATION;
}


midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation::~midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oUuidList.size(); ++u32ListIdx)
      u32DynamicSize += oUuidList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5+sServiceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8ServiceHandle);
   (tVoid) (oIn >> sServiceName);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oUuidList.size(); ++u32Idx)
      {
         oUuidList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oUuidList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oUuidList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8ServiceHandle);
   (tVoid) (oOut << sServiceName);
   (tVoid) (oOut << (tU32)oUuidList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oUuidList.size(); ++u32Idx)
         (tVoid) (oOut << oUuidList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation::operator==(const midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8ServiceHandle == roRef.u8ServiceHandle);
   bResult = bResult && (sServiceName == roRef.sServiceName);
      bResult = bResult && (oUuidList.size() == roRef.oUuidList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oUuidList.size()); ++u32Idx)
            bResult = bResult && (oUuidList[u32Idx] == roRef.oUuidList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_BTVirtualDeviceData::midw_ext_fi_tcl_PHN_BTVirtualDeviceData(const midw_ext_fi_tcl_PHN_BTVirtualDeviceData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8VirtualDeviceService = coRef.e8VirtualDeviceService;
   sDeviceName = coRef.sDeviceName;
   oServiceInfo = coRef.oServiceInfo;
}
midw_ext_fi_tcl_PHN_BTVirtualDeviceData& midw_ext_fi_tcl_PHN_BTVirtualDeviceData::operator=(const midw_ext_fi_tcl_PHN_BTVirtualDeviceData& coRef)
{
   if (this == &coRef) return *this;
   e8VirtualDeviceService = coRef.e8VirtualDeviceService;
   sDeviceName = coRef.sDeviceName;
   oServiceInfo = coRef.oServiceInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_BTVirtualDeviceData::vDestroy()
{
   sDeviceName.vDestroy();
   oServiceInfo.vDestroy(); 
}

midw_ext_fi_tcl_PHN_BTVirtualDeviceData::midw_ext_fi_tcl_PHN_BTVirtualDeviceData()
:e8VirtualDeviceService()
,sDeviceName()
,oServiceInfo()
 {}

tS32 midw_ext_fi_tcl_PHN_BTVirtualDeviceData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_BTVIRTUALDEVICEDATA;
}


midw_ext_fi_tcl_PHN_BTVirtualDeviceData::~midw_ext_fi_tcl_PHN_BTVirtualDeviceData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_BTVirtualDeviceData::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sDeviceName.u32GetSize(u16MajorVersion)+oServiceInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_BTVirtualDeviceData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VirtualDeviceService);
   (tVoid) (oIn >> sDeviceName);
   (tVoid) (oIn >> oServiceInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_BTVirtualDeviceData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VirtualDeviceService);
   (tVoid) (oOut << sDeviceName);
   (tVoid) (oOut << oServiceInfo);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_BTVirtualDeviceData::operator==(const midw_ext_fi_tcl_PHN_BTVirtualDeviceData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VirtualDeviceService == roRef.e8VirtualDeviceService);
   bResult = bResult && (sDeviceName == roRef.sDeviceName);
   bResult = bResult && (oServiceInfo == roRef.oServiceInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BTDevice::midw_ext_fi_tcl_PHN_VAG_BTDevice(const midw_ext_fi_tcl_PHN_VAG_BTDevice& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   bHfpFeatureEnabled = coRef.bHfpFeatureEnabled;
   bHfpConnectionEstablished = coRef.bHfpConnectionEstablished;
   bAvpFeatureEnabled = coRef.bAvpFeatureEnabled;
   bAvpConnectionEstablished = coRef.bAvpConnectionEstablished;
   bSmsFeatureEnabled = coRef.bSmsFeatureEnabled;
   bSmsConnectionEstablished = coRef.bSmsConnectionEstablished;
   bPimFeatureEnabled = coRef.bPimFeatureEnabled;
   bPimConnectionEstablished = coRef.bPimConnectionEstablished;
   bDunFeatureEnabled = coRef.bDunFeatureEnabled;
   bDunConnectionEstablished = coRef.bDunConnectionEstablished;
   bPanFeatureEnabled = coRef.bPanFeatureEnabled;
   bPanConnectionEstablished = coRef.bPanConnectionEstablished;
   bSppFeatureEnabled = coRef.bSppFeatureEnabled;
   bSppConnectionEstablished = coRef.bSppConnectionEstablished;
   oVirtualDevices = coRef.oVirtualDevices;
   BTDeviceName = coRef.BTDeviceName;
   BTDeviceAddess = coRef.BTDeviceAddess;
}
midw_ext_fi_tcl_PHN_VAG_BTDevice& midw_ext_fi_tcl_PHN_VAG_BTDevice::operator=(const midw_ext_fi_tcl_PHN_VAG_BTDevice& coRef)
{
   if (this == &coRef) return *this;
   bHfpFeatureEnabled = coRef.bHfpFeatureEnabled;
   bHfpConnectionEstablished = coRef.bHfpConnectionEstablished;
   bAvpFeatureEnabled = coRef.bAvpFeatureEnabled;
   bAvpConnectionEstablished = coRef.bAvpConnectionEstablished;
   bSmsFeatureEnabled = coRef.bSmsFeatureEnabled;
   bSmsConnectionEstablished = coRef.bSmsConnectionEstablished;
   bPimFeatureEnabled = coRef.bPimFeatureEnabled;
   bPimConnectionEstablished = coRef.bPimConnectionEstablished;
   bDunFeatureEnabled = coRef.bDunFeatureEnabled;
   bDunConnectionEstablished = coRef.bDunConnectionEstablished;
   bPanFeatureEnabled = coRef.bPanFeatureEnabled;
   bPanConnectionEstablished = coRef.bPanConnectionEstablished;
   bSppFeatureEnabled = coRef.bSppFeatureEnabled;
   bSppConnectionEstablished = coRef.bSppConnectionEstablished;
   oVirtualDevices = coRef.oVirtualDevices;
   BTDeviceName = coRef.BTDeviceName;
   BTDeviceAddess = coRef.BTDeviceAddess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BTDevice::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oVirtualDevices.size(); ++u32Idx)
         oVirtualDevices[u32Idx].vDestroy();
   oVirtualDevices.clear();
   }
   BTDeviceName.vDestroy(); 
   BTDeviceAddess.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_BTDevice::midw_ext_fi_tcl_PHN_VAG_BTDevice()
:bHfpFeatureEnabled(0)
,bHfpConnectionEstablished(0)
,bAvpFeatureEnabled(0)
,bAvpConnectionEstablished(0)
,bSmsFeatureEnabled(0)
,bSmsConnectionEstablished(0)
,bPimFeatureEnabled(0)
,bPimConnectionEstablished(0)
,bDunFeatureEnabled(0)
,bDunConnectionEstablished(0)
,bPanFeatureEnabled(0)
,bPanConnectionEstablished(0)
,bSppFeatureEnabled(0)
,bSppConnectionEstablished(0)

,BTDeviceName()
,BTDeviceAddess()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BTDevice::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BTDEVICE;
}


midw_ext_fi_tcl_PHN_VAG_BTDevice::~midw_ext_fi_tcl_PHN_VAG_BTDevice()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BTDevice::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oVirtualDevices.size(); ++u32ListIdx)
      u32DynamicSize += oVirtualDevices[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+18+BTDeviceName.u32GetSize(u16MajorVersion)+BTDeviceAddess.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BTDevice::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bHfpFeatureEnabled);
   (tVoid) (oIn >> bHfpConnectionEstablished);
   (tVoid) (oIn >> bAvpFeatureEnabled);
   (tVoid) (oIn >> bAvpConnectionEstablished);
   (tVoid) (oIn >> bSmsFeatureEnabled);
   (tVoid) (oIn >> bSmsConnectionEstablished);
   (tVoid) (oIn >> bPimFeatureEnabled);
   (tVoid) (oIn >> bPimConnectionEstablished);
   (tVoid) (oIn >> bDunFeatureEnabled);
   (tVoid) (oIn >> bDunConnectionEstablished);
   (tVoid) (oIn >> bPanFeatureEnabled);
   (tVoid) (oIn >> bPanConnectionEstablished);
   (tVoid) (oIn >> bSppFeatureEnabled);
   (tVoid) (oIn >> bSppConnectionEstablished);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oVirtualDevices.size(); ++u32Idx)
      {
         oVirtualDevices[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oVirtualDevices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oVirtualDevices[u32Idx]);
      }
   }
   (tVoid) (oIn >> BTDeviceName);
   (tVoid) (oIn >> BTDeviceAddess);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BTDevice::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bHfpFeatureEnabled);
   (tVoid) (oOut << bHfpConnectionEstablished);
   (tVoid) (oOut << bAvpFeatureEnabled);
   (tVoid) (oOut << bAvpConnectionEstablished);
   (tVoid) (oOut << bSmsFeatureEnabled);
   (tVoid) (oOut << bSmsConnectionEstablished);
   (tVoid) (oOut << bPimFeatureEnabled);
   (tVoid) (oOut << bPimConnectionEstablished);
   (tVoid) (oOut << bDunFeatureEnabled);
   (tVoid) (oOut << bDunConnectionEstablished);
   (tVoid) (oOut << bPanFeatureEnabled);
   (tVoid) (oOut << bPanConnectionEstablished);
   (tVoid) (oOut << bSppFeatureEnabled);
   (tVoid) (oOut << bSppConnectionEstablished);
   (tVoid) (oOut << (tU32)oVirtualDevices.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oVirtualDevices.size(); ++u32Idx)
         (tVoid) (oOut << oVirtualDevices[u32Idx]);
   }
   (tVoid) (oOut << BTDeviceName);
   (tVoid) (oOut << BTDeviceAddess);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BTDevice::operator==(const midw_ext_fi_tcl_PHN_VAG_BTDevice& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bHfpFeatureEnabled == roRef.bHfpFeatureEnabled);
   bResult = bResult && (bHfpConnectionEstablished == roRef.bHfpConnectionEstablished);
   bResult = bResult && (bAvpFeatureEnabled == roRef.bAvpFeatureEnabled);
   bResult = bResult && (bAvpConnectionEstablished == roRef.bAvpConnectionEstablished);
   bResult = bResult && (bSmsFeatureEnabled == roRef.bSmsFeatureEnabled);
   bResult = bResult && (bSmsConnectionEstablished == roRef.bSmsConnectionEstablished);
   bResult = bResult && (bPimFeatureEnabled == roRef.bPimFeatureEnabled);
   bResult = bResult && (bPimConnectionEstablished == roRef.bPimConnectionEstablished);
   bResult = bResult && (bDunFeatureEnabled == roRef.bDunFeatureEnabled);
   bResult = bResult && (bDunConnectionEstablished == roRef.bDunConnectionEstablished);
   bResult = bResult && (bPanFeatureEnabled == roRef.bPanFeatureEnabled);
   bResult = bResult && (bPanConnectionEstablished == roRef.bPanConnectionEstablished);
   bResult = bResult && (bSppFeatureEnabled == roRef.bSppFeatureEnabled);
   bResult = bResult && (bSppConnectionEstablished == roRef.bSppConnectionEstablished);
      bResult = bResult && (oVirtualDevices.size() == roRef.oVirtualDevices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oVirtualDevices.size()); ++u32Idx)
            bResult = bResult && (oVirtualDevices[u32Idx] == roRef.oVirtualDevices[u32Idx]);
      }
   bResult = bResult && (BTDeviceName == roRef.BTDeviceName);
   bResult = bResult && (BTDeviceAddess == roRef.BTDeviceAddess);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_PINString::midw_ext_fi_tcl_PHN_VAG_PINString(const midw_ext_fi_tcl_PHN_VAG_PINString& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sPINString = coRef.sPINString;
}
midw_ext_fi_tcl_PHN_VAG_PINString& midw_ext_fi_tcl_PHN_VAG_PINString::operator=(const midw_ext_fi_tcl_PHN_VAG_PINString& coRef)
{
   if (this == &coRef) return *this;
   sPINString = coRef.sPINString;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_PINString::vDestroy()
{
   sPINString.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_PINString::midw_ext_fi_tcl_PHN_VAG_PINString()
:sPINString()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_PINString::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_PINSTRING;
}


midw_ext_fi_tcl_PHN_VAG_PINString::~midw_ext_fi_tcl_PHN_VAG_PINString()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_PINString::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sPINString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_PINString::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPINString);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_PINString::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPINString);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_PINString::operator==(const midw_ext_fi_tcl_PHN_VAG_PINString& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPINString == roRef.sPINString);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability::midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability():enType(FI_EN_PHN_VAG_NW_PROVIDER_NAME_NO_PRESENTATION) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_PROVIDERINFOAVAILABILITY;
}


midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability::~midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_ProviderName::midw_ext_fi_tcl_PHN_VAG_ProviderName(const midw_ext_fi_tcl_PHN_VAG_ProviderName& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sProviderName = coRef.sProviderName;
}
midw_ext_fi_tcl_PHN_VAG_ProviderName& midw_ext_fi_tcl_PHN_VAG_ProviderName::operator=(const midw_ext_fi_tcl_PHN_VAG_ProviderName& coRef)
{
   if (this == &coRef) return *this;
   sProviderName = coRef.sProviderName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_ProviderName::vDestroy()
{
   sProviderName.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_ProviderName::midw_ext_fi_tcl_PHN_VAG_ProviderName()
:sProviderName()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_ProviderName::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_PROVIDERNAME;
}


midw_ext_fi_tcl_PHN_VAG_ProviderName::~midw_ext_fi_tcl_PHN_VAG_ProviderName()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_ProviderName::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sProviderName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_ProviderName::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sProviderName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_ProviderName::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sProviderName);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_ProviderName::operator==(const midw_ext_fi_tcl_PHN_VAG_ProviderName& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sProviderName == roRef.sProviderName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off::midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off():enType(FI_EN_PHN_VAG_BTM_STATUS_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BTM_ON_OFF;
}


midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off::~midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_DeviceType::midw_ext_fi_tcl_e8_PHN_VAG_DeviceType():enType(FI_EN_PHN_VAG_UHV_NOT_AVAILABLE) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_DeviceType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_DEVICETYPE;
}


midw_ext_fi_tcl_e8_PHN_VAG_DeviceType::~midw_ext_fi_tcl_e8_PHN_VAG_DeviceType()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_DeviceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_DeviceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_DeviceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList::midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   bFunctionList = coRef.bFunctionList;
   bFSGSetup = coRef.bFSGSetup;
   bFSGOperationState = coRef.bFSGOperationState;
   bMobileServiceSupport = coRef.bMobileServiceSupport;
   bUserList = coRef.bUserList;
   bActiveUser = coRef.bActiveUser;
   bRegisterState = coRef.bRegisterState;
   bLockState = coRef.bLockState;
   bPhoneEnable = coRef.bPhoneEnable;
   bNetworkProvider = coRef.bNetworkProvider;
   bSignalQuality = coRef.bSignalQuality;
   bNetInfo = coRef.bNetInfo;
   bCallLineInfo = coRef.bCallLineInfo;
   bDialNumber = coRef.bDialNumber;
   bHangupCall = coRef.bHangupCall;
   bAcceptCall = coRef.bAcceptCall;
   bCallHold = coRef.bCallHold;
   bResumeCall = coRef.bResumeCall;
   bHandsFreeOnOff = coRef.bHandsFreeOnOff;
   bMicroMuteOnOff = coRef.bMicroMuteOnOff;
   bRingToneMuteOnOff = coRef.bRingToneMuteOnOff;
   bSendDTMF = coRef.bSendDTMF;
   bMPReleaseActiveCallAcceptHeldCall = coRef.bMPReleaseActiveCallAcceptHeldCall;
   bMPReleaseActiveCallAcceptWaitingCall = coRef.bMPReleaseActiveCallAcceptWaitingCall;
   bMPSwap = coRef.bMPSwap;
   bMPCallHoldAcceptWaitingCall = coRef.bMPCallHoldAcceptWaitingCall;
   bMPReleaseAllCallsAcceptWaitingCall = coRef.bMPReleaseAllCallsAcceptWaitingCall;
   bMPExplicitCallTransfer = coRef.bMPExplicitCallTransfer;
   bCCJoin = coRef.bCCJoin;
   bCCSplit = coRef.bCCSplit;
   bKeypad = coRef.bKeypad;
   bPhoneOnOff = coRef.bPhoneOnOff;
   bSupplementaryServices = coRef.bSupplementaryServices;
   bRestoreFactorySettings = coRef.bRestoreFactorySettings;
   bSetCurrentProfileName = coRef.bSetCurrentProfileName;
   bSetBTTestMode = coRef.bSetBTTestMode;
   bExStartConnection = coRef.bExStartConnection;
   bExBTMTestAction = coRef.bExBTMTestAction;
   bVoicerecognition = coRef.bVoicerecognition;
}
midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList& midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList& coRef)
{
   if (this == &coRef) return *this;
   bFunctionList = coRef.bFunctionList;
   bFSGSetup = coRef.bFSGSetup;
   bFSGOperationState = coRef.bFSGOperationState;
   bMobileServiceSupport = coRef.bMobileServiceSupport;
   bUserList = coRef.bUserList;
   bActiveUser = coRef.bActiveUser;
   bRegisterState = coRef.bRegisterState;
   bLockState = coRef.bLockState;
   bPhoneEnable = coRef.bPhoneEnable;
   bNetworkProvider = coRef.bNetworkProvider;
   bSignalQuality = coRef.bSignalQuality;
   bNetInfo = coRef.bNetInfo;
   bCallLineInfo = coRef.bCallLineInfo;
   bDialNumber = coRef.bDialNumber;
   bHangupCall = coRef.bHangupCall;
   bAcceptCall = coRef.bAcceptCall;
   bCallHold = coRef.bCallHold;
   bResumeCall = coRef.bResumeCall;
   bHandsFreeOnOff = coRef.bHandsFreeOnOff;
   bMicroMuteOnOff = coRef.bMicroMuteOnOff;
   bRingToneMuteOnOff = coRef.bRingToneMuteOnOff;
   bSendDTMF = coRef.bSendDTMF;
   bMPReleaseActiveCallAcceptHeldCall = coRef.bMPReleaseActiveCallAcceptHeldCall;
   bMPReleaseActiveCallAcceptWaitingCall = coRef.bMPReleaseActiveCallAcceptWaitingCall;
   bMPSwap = coRef.bMPSwap;
   bMPCallHoldAcceptWaitingCall = coRef.bMPCallHoldAcceptWaitingCall;
   bMPReleaseAllCallsAcceptWaitingCall = coRef.bMPReleaseAllCallsAcceptWaitingCall;
   bMPExplicitCallTransfer = coRef.bMPExplicitCallTransfer;
   bCCJoin = coRef.bCCJoin;
   bCCSplit = coRef.bCCSplit;
   bKeypad = coRef.bKeypad;
   bPhoneOnOff = coRef.bPhoneOnOff;
   bSupplementaryServices = coRef.bSupplementaryServices;
   bRestoreFactorySettings = coRef.bRestoreFactorySettings;
   bSetCurrentProfileName = coRef.bSetCurrentProfileName;
   bSetBTTestMode = coRef.bSetBTTestMode;
   bExStartConnection = coRef.bExStartConnection;
   bExBTMTestAction = coRef.bExBTMTestAction;
   bVoicerecognition = coRef.bVoicerecognition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList::midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList()
:bFunctionList(0)
,bFSGSetup(0)
,bFSGOperationState(0)
,bMobileServiceSupport(0)
,bUserList(0)
,bActiveUser(0)
,bRegisterState(0)
,bLockState(0)
,bPhoneEnable(0)
,bNetworkProvider(0)
,bSignalQuality(0)
,bNetInfo(0)
,bCallLineInfo(0)
,bDialNumber(0)
,bHangupCall(0)
,bAcceptCall(0)
,bCallHold(0)
,bResumeCall(0)
,bHandsFreeOnOff(0)
,bMicroMuteOnOff(0)
,bRingToneMuteOnOff(0)
,bSendDTMF(0)
,bMPReleaseActiveCallAcceptHeldCall(0)
,bMPReleaseActiveCallAcceptWaitingCall(0)
,bMPSwap(0)
,bMPCallHoldAcceptWaitingCall(0)
,bMPReleaseAllCallsAcceptWaitingCall(0)
,bMPExplicitCallTransfer(0)
,bCCJoin(0)
,bCCSplit(0)
,bKeypad(0)
,bPhoneOnOff(0)
,bSupplementaryServices(0)
,bRestoreFactorySettings(0)
,bSetCurrentProfileName(0)
,bSetBTTestMode(0)
,bExStartConnection(0)
,bExBTMTestAction(0)
,bVoicerecognition(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELFCTLIST;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList::~midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 39;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bFunctionList);
   (tVoid) (oIn >> bFSGSetup);
   (tVoid) (oIn >> bFSGOperationState);
   (tVoid) (oIn >> bMobileServiceSupport);
   (tVoid) (oIn >> bUserList);
   (tVoid) (oIn >> bActiveUser);
   (tVoid) (oIn >> bRegisterState);
   (tVoid) (oIn >> bLockState);
   (tVoid) (oIn >> bPhoneEnable);
   (tVoid) (oIn >> bNetworkProvider);
   (tVoid) (oIn >> bSignalQuality);
   (tVoid) (oIn >> bNetInfo);
   (tVoid) (oIn >> bCallLineInfo);
   (tVoid) (oIn >> bDialNumber);
   (tVoid) (oIn >> bHangupCall);
   (tVoid) (oIn >> bAcceptCall);
   (tVoid) (oIn >> bCallHold);
   (tVoid) (oIn >> bResumeCall);
   (tVoid) (oIn >> bHandsFreeOnOff);
   (tVoid) (oIn >> bMicroMuteOnOff);
   (tVoid) (oIn >> bRingToneMuteOnOff);
   (tVoid) (oIn >> bSendDTMF);
   (tVoid) (oIn >> bMPReleaseActiveCallAcceptHeldCall);
   (tVoid) (oIn >> bMPReleaseActiveCallAcceptWaitingCall);
   (tVoid) (oIn >> bMPSwap);
   (tVoid) (oIn >> bMPCallHoldAcceptWaitingCall);
   (tVoid) (oIn >> bMPReleaseAllCallsAcceptWaitingCall);
   (tVoid) (oIn >> bMPExplicitCallTransfer);
   (tVoid) (oIn >> bCCJoin);
   (tVoid) (oIn >> bCCSplit);
   (tVoid) (oIn >> bKeypad);
   (tVoid) (oIn >> bPhoneOnOff);
   (tVoid) (oIn >> bSupplementaryServices);
   (tVoid) (oIn >> bRestoreFactorySettings);
   (tVoid) (oIn >> bSetCurrentProfileName);
   (tVoid) (oIn >> bSetBTTestMode);
   (tVoid) (oIn >> bExStartConnection);
   (tVoid) (oIn >> bExBTMTestAction);
   (tVoid) (oIn >> bVoicerecognition);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bFunctionList);
   (tVoid) (oOut << bFSGSetup);
   (tVoid) (oOut << bFSGOperationState);
   (tVoid) (oOut << bMobileServiceSupport);
   (tVoid) (oOut << bUserList);
   (tVoid) (oOut << bActiveUser);
   (tVoid) (oOut << bRegisterState);
   (tVoid) (oOut << bLockState);
   (tVoid) (oOut << bPhoneEnable);
   (tVoid) (oOut << bNetworkProvider);
   (tVoid) (oOut << bSignalQuality);
   (tVoid) (oOut << bNetInfo);
   (tVoid) (oOut << bCallLineInfo);
   (tVoid) (oOut << bDialNumber);
   (tVoid) (oOut << bHangupCall);
   (tVoid) (oOut << bAcceptCall);
   (tVoid) (oOut << bCallHold);
   (tVoid) (oOut << bResumeCall);
   (tVoid) (oOut << bHandsFreeOnOff);
   (tVoid) (oOut << bMicroMuteOnOff);
   (tVoid) (oOut << bRingToneMuteOnOff);
   (tVoid) (oOut << bSendDTMF);
   (tVoid) (oOut << bMPReleaseActiveCallAcceptHeldCall);
   (tVoid) (oOut << bMPReleaseActiveCallAcceptWaitingCall);
   (tVoid) (oOut << bMPSwap);
   (tVoid) (oOut << bMPCallHoldAcceptWaitingCall);
   (tVoid) (oOut << bMPReleaseAllCallsAcceptWaitingCall);
   (tVoid) (oOut << bMPExplicitCallTransfer);
   (tVoid) (oOut << bCCJoin);
   (tVoid) (oOut << bCCSplit);
   (tVoid) (oOut << bKeypad);
   (tVoid) (oOut << bPhoneOnOff);
   (tVoid) (oOut << bSupplementaryServices);
   (tVoid) (oOut << bRestoreFactorySettings);
   (tVoid) (oOut << bSetCurrentProfileName);
   (tVoid) (oOut << bSetBTTestMode);
   (tVoid) (oOut << bExStartConnection);
   (tVoid) (oOut << bExBTMTestAction);
   (tVoid) (oOut << bVoicerecognition);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bFunctionList == roRef.bFunctionList);
   bResult = bResult && (bFSGSetup == roRef.bFSGSetup);
   bResult = bResult && (bFSGOperationState == roRef.bFSGOperationState);
   bResult = bResult && (bMobileServiceSupport == roRef.bMobileServiceSupport);
   bResult = bResult && (bUserList == roRef.bUserList);
   bResult = bResult && (bActiveUser == roRef.bActiveUser);
   bResult = bResult && (bRegisterState == roRef.bRegisterState);
   bResult = bResult && (bLockState == roRef.bLockState);
   bResult = bResult && (bPhoneEnable == roRef.bPhoneEnable);
   bResult = bResult && (bNetworkProvider == roRef.bNetworkProvider);
   bResult = bResult && (bSignalQuality == roRef.bSignalQuality);
   bResult = bResult && (bNetInfo == roRef.bNetInfo);
   bResult = bResult && (bCallLineInfo == roRef.bCallLineInfo);
   bResult = bResult && (bDialNumber == roRef.bDialNumber);
   bResult = bResult && (bHangupCall == roRef.bHangupCall);
   bResult = bResult && (bAcceptCall == roRef.bAcceptCall);
   bResult = bResult && (bCallHold == roRef.bCallHold);
   bResult = bResult && (bResumeCall == roRef.bResumeCall);
   bResult = bResult && (bHandsFreeOnOff == roRef.bHandsFreeOnOff);
   bResult = bResult && (bMicroMuteOnOff == roRef.bMicroMuteOnOff);
   bResult = bResult && (bRingToneMuteOnOff == roRef.bRingToneMuteOnOff);
   bResult = bResult && (bSendDTMF == roRef.bSendDTMF);
   bResult = bResult && (bMPReleaseActiveCallAcceptHeldCall == roRef.bMPReleaseActiveCallAcceptHeldCall);
   bResult = bResult && (bMPReleaseActiveCallAcceptWaitingCall == roRef.bMPReleaseActiveCallAcceptWaitingCall);
   bResult = bResult && (bMPSwap == roRef.bMPSwap);
   bResult = bResult && (bMPCallHoldAcceptWaitingCall == roRef.bMPCallHoldAcceptWaitingCall);
   bResult = bResult && (bMPReleaseAllCallsAcceptWaitingCall == roRef.bMPReleaseAllCallsAcceptWaitingCall);
   bResult = bResult && (bMPExplicitCallTransfer == roRef.bMPExplicitCallTransfer);
   bResult = bResult && (bCCJoin == roRef.bCCJoin);
   bResult = bResult && (bCCSplit == roRef.bCCSplit);
   bResult = bResult && (bKeypad == roRef.bKeypad);
   bResult = bResult && (bPhoneOnOff == roRef.bPhoneOnOff);
   bResult = bResult && (bSupplementaryServices == roRef.bSupplementaryServices);
   bResult = bResult && (bRestoreFactorySettings == roRef.bRestoreFactorySettings);
   bResult = bResult && (bSetCurrentProfileName == roRef.bSetCurrentProfileName);
   bResult = bResult && (bSetBTTestMode == roRef.bSetBTTestMode);
   bResult = bResult && (bExStartConnection == roRef.bExStartConnection);
   bResult = bResult && (bExBTMTestAction == roRef.bExBTMTestAction);
   bResult = bResult && (bVoicerecognition == roRef.bVoicerecognition);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics::midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics():u8Value(0)
{}

tS32 midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B8_PHN_VAG_BAP_TELFSGSETUP_PHONECHARACTERISTICS;
}


midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics::~midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics()
{}

tU32 midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType::midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType():enType(FI_EN_PHN_VAG_MOBILECONNECTIONTYPE_NOCONNECTION) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BAP_TELFSGSETUP_MOBILECONNECTIONTYPE;
}


midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType::~midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType::midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType():enType(FI_EN_PHN_VAG_PHONETYPE_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BAP_TELFSGSETUP_PHONETYPE;
}


midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType::~midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup::midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   oPhoneCharacteristics = coRef.oPhoneCharacteristics;
   eMobileConnectionType = coRef.eMobileConnectionType;
   u8NumberOfProfiles = coRef.u8NumberOfProfiles;
   ePhoneType = coRef.ePhoneType;
}
midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup& midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup& coRef)
{
   if (this == &coRef) return *this;
   oPhoneCharacteristics = coRef.oPhoneCharacteristics;
   eMobileConnectionType = coRef.eMobileConnectionType;
   u8NumberOfProfiles = coRef.u8NumberOfProfiles;
   ePhoneType = coRef.ePhoneType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup::midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup()
:oPhoneCharacteristics()
,eMobileConnectionType()
,u8NumberOfProfiles(0)
,ePhoneType()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELFSGSETUP;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup::~midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oPhoneCharacteristics);
   (tVoid) (oIn >> eMobileConnectionType);
   (tVoid) (oIn >> u8NumberOfProfiles);
   (tVoid) (oIn >> ePhoneType);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oPhoneCharacteristics);
   (tVoid) (oOut << eMobileConnectionType);
   (tVoid) (oOut << u8NumberOfProfiles);
   (tVoid) (oOut << ePhoneType);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oPhoneCharacteristics == roRef.oPhoneCharacteristics);
   bResult = bResult && (eMobileConnectionType == roRef.eMobileConnectionType);
   bResult = bResult && (u8NumberOfProfiles == roRef.u8NumberOfProfiles);
   bResult = bResult && (ePhoneType == roRef.ePhoneType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus::midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus():enType(FI_EN_PHN_VAG_OPSTATUS_PHONEINITILISATION) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BAP_TELFSGOPERATIONSTATE_OPSTATUS;
}


midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus::~midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState::midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   eOPStatus = coRef.eOPStatus;
}
midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState& midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState& coRef)
{
   if (this == &coRef) return *this;
   eOPStatus = coRef.eOPStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState::midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState()
:eOPStatus()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELFSGOPERATIONSTATE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState::~midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eOPStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eOPStatus);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eOPStatus == roRef.eOPStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item::midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sSIMSerial = coRef.sSIMSerial;
   sSerialNumber = coRef.sSerialNumber;
   sUserName = coRef.sUserName;
}
midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item& midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item& coRef)
{
   if (this == &coRef) return *this;
   sSIMSerial = coRef.sSIMSerial;
   sSerialNumber = coRef.sSerialNumber;
   sUserName = coRef.sUserName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item::vDestroy()
{
   sSIMSerial.vDestroy();
   sSerialNumber.vDestroy();
   sUserName.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item::midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item()
:sSIMSerial()
,sSerialNumber()
,sUserName()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELUSERLIST_ITEM;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item::~midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sSIMSerial.u32GetSize(u16MajorVersion)+sSerialNumber.u32GetSize(u16MajorVersion)+sUserName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sSIMSerial);
   (tVoid) (oIn >> sSerialNumber);
   (tVoid) (oIn >> sUserName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sSIMSerial);
   (tVoid) (oOut << sSerialNumber);
   (tVoid) (oOut << sUserName);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sSIMSerial == roRef.sSIMSerial);
   bResult = bResult && (sSerialNumber == roRef.sSerialNumber);
   bResult = bResult && (sUserName == roRef.sUserName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList::midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   isListValid = coRef.isListValid;
   u8NbrOfItems = coRef.u8NbrOfItems;
   oItemList = coRef.oItemList;
}
midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList& midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList& coRef)
{
   if (this == &coRef) return *this;
   isListValid = coRef.isListValid;
   u8NbrOfItems = coRef.u8NbrOfItems;
   oItemList = coRef.oItemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         oItemList[u32Idx].vDestroy();
   oItemList.clear();
   }
}

midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList::midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList()
:isListValid(0)
,u8NbrOfItems(0)

 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELUSERLIST;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList::~midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItemList.size(); ++u32ListIdx)
      u32DynamicSize += oItemList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> isListValid);
   (tVoid) (oIn >> u8NbrOfItems);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
      {
         oItemList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << isListValid);
   (tVoid) (oOut << u8NbrOfItems);
   (tVoid) (oOut << (tU32)oItemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         (tVoid) (oOut << oItemList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (isListValid == roRef.isListValid);
   bResult = bResult && (u8NbrOfItems == roRef.u8NbrOfItems);
      bResult = bResult && (oItemList.size() == roRef.oItemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItemList.size()); ++u32Idx)
            bResult = bResult && (oItemList[u32Idx] == roRef.oItemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser::midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser(const midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sSIMSerial = coRef.sSIMSerial;
   sSerialNumber = coRef.sSerialNumber;
   sUserName = coRef.sUserName;
   u8ProfileHandle = coRef.u8ProfileHandle;
   BTDeviceAddress = coRef.BTDeviceAddress;
}
midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser& midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser& coRef)
{
   if (this == &coRef) return *this;
   sSIMSerial = coRef.sSIMSerial;
   sSerialNumber = coRef.sSerialNumber;
   sUserName = coRef.sUserName;
   u8ProfileHandle = coRef.u8ProfileHandle;
   BTDeviceAddress = coRef.BTDeviceAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser::vDestroy()
{
   sSIMSerial.vDestroy();
   sSerialNumber.vDestroy();
   sUserName.vDestroy();
   BTDeviceAddress.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser::midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser()
:sSIMSerial()
,sSerialNumber()
,sUserName()
,u8ProfileHandle(0)
,BTDeviceAddress()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELACTIVEUSER;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser::~midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sSIMSerial.u32GetSize(u16MajorVersion)+sSerialNumber.u32GetSize(u16MajorVersion)+sUserName.u32GetSize(u16MajorVersion)+BTDeviceAddress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sSIMSerial);
   (tVoid) (oIn >> sSerialNumber);
   (tVoid) (oIn >> sUserName);
   (tVoid) (oIn >> u8ProfileHandle);
   (tVoid) (oIn >> BTDeviceAddress);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sSIMSerial);
   (tVoid) (oOut << sSerialNumber);
   (tVoid) (oOut << sUserName);
   (tVoid) (oOut << u8ProfileHandle);
   (tVoid) (oOut << BTDeviceAddress);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sSIMSerial == roRef.sSIMSerial);
   bResult = bResult && (sSerialNumber == roRef.sSerialNumber);
   bResult = bResult && (sUserName == roRef.sUserName);
   bResult = bResult && (u8ProfileHandle == roRef.u8ProfileHandle);
   bResult = bResult && (BTDeviceAddress == roRef.BTDeviceAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState::midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState():enType(FI_EN_PHN_VAG_BAP_REG_STATE_NOT_REGISTERED_AND_NOT_SEARCHING) {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELREGISTERSTATE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState::~midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState::midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState():enType(FI_EN_PHN_VAG_BAP_LOCK_STATE_NO_LOCK) {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELLOCKSTATE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState::~midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList::midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   bFunctionList = coRef.bFunctionList;
   bFSGSetup = coRef.bFSGSetup;
   bFSGOperationState = coRef.bFSGOperationState;
   bMobileServiceSupport = coRef.bMobileServiceSupport;
   bMissedCallIndication = coRef.bMissedCallIndication;
   bMissedCalls = coRef.bMissedCalls;
   bReceivedCalls = coRef.bReceivedCalls;
   bDialedNumbers = coRef.bDialedNumbers;
   bCallStackDeleteAll = coRef.bCallStackDeleteAll;
   bPbState = coRef.bPbState;
   bPhonebook = coRef.bPhonebook;
   bPbSpeller = coRef.bPbSpeller;
   bVoiceMailboxNumber = coRef.bVoiceMailboxNumber;
   bPbStartDownload = coRef.bPbStartDownload;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList& midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList& coRef)
{
   if (this == &coRef) return *this;
   bFunctionList = coRef.bFunctionList;
   bFSGSetup = coRef.bFSGSetup;
   bFSGOperationState = coRef.bFSGOperationState;
   bMobileServiceSupport = coRef.bMobileServiceSupport;
   bMissedCallIndication = coRef.bMissedCallIndication;
   bMissedCalls = coRef.bMissedCalls;
   bReceivedCalls = coRef.bReceivedCalls;
   bDialedNumbers = coRef.bDialedNumbers;
   bCallStackDeleteAll = coRef.bCallStackDeleteAll;
   bPbState = coRef.bPbState;
   bPhonebook = coRef.bPhonebook;
   bPbSpeller = coRef.bPbSpeller;
   bVoiceMailboxNumber = coRef.bVoiceMailboxNumber;
   bPbStartDownload = coRef.bPbStartDownload;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList::midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList()
:bFunctionList(0)
,bFSGSetup(0)
,bFSGOperationState(0)
,bMobileServiceSupport(0)
,bMissedCallIndication(0)
,bMissedCalls(0)
,bReceivedCalls(0)
,bDialedNumbers(0)
,bCallStackDeleteAll(0)
,bPbState(0)
,bPhonebook(0)
,bPbSpeller(0)
,bVoiceMailboxNumber(0)
,bPbStartDownload(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PBFCTLIST;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList::~midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bFunctionList);
   (tVoid) (oIn >> bFSGSetup);
   (tVoid) (oIn >> bFSGOperationState);
   (tVoid) (oIn >> bMobileServiceSupport);
   (tVoid) (oIn >> bMissedCallIndication);
   (tVoid) (oIn >> bMissedCalls);
   (tVoid) (oIn >> bReceivedCalls);
   (tVoid) (oIn >> bDialedNumbers);
   (tVoid) (oIn >> bCallStackDeleteAll);
   (tVoid) (oIn >> bPbState);
   (tVoid) (oIn >> bPhonebook);
   (tVoid) (oIn >> bPbSpeller);
   (tVoid) (oIn >> bVoiceMailboxNumber);
   (tVoid) (oIn >> bPbStartDownload);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bFunctionList);
   (tVoid) (oOut << bFSGSetup);
   (tVoid) (oOut << bFSGOperationState);
   (tVoid) (oOut << bMobileServiceSupport);
   (tVoid) (oOut << bMissedCallIndication);
   (tVoid) (oOut << bMissedCalls);
   (tVoid) (oOut << bReceivedCalls);
   (tVoid) (oOut << bDialedNumbers);
   (tVoid) (oOut << bCallStackDeleteAll);
   (tVoid) (oOut << bPbState);
   (tVoid) (oOut << bPhonebook);
   (tVoid) (oOut << bPbSpeller);
   (tVoid) (oOut << bVoiceMailboxNumber);
   (tVoid) (oOut << bPbStartDownload);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bFunctionList == roRef.bFunctionList);
   bResult = bResult && (bFSGSetup == roRef.bFSGSetup);
   bResult = bResult && (bFSGOperationState == roRef.bFSGOperationState);
   bResult = bResult && (bMobileServiceSupport == roRef.bMobileServiceSupport);
   bResult = bResult && (bMissedCallIndication == roRef.bMissedCallIndication);
   bResult = bResult && (bMissedCalls == roRef.bMissedCalls);
   bResult = bResult && (bReceivedCalls == roRef.bReceivedCalls);
   bResult = bResult && (bDialedNumbers == roRef.bDialedNumbers);
   bResult = bResult && (bCallStackDeleteAll == roRef.bCallStackDeleteAll);
   bResult = bResult && (bPbState == roRef.bPbState);
   bResult = bResult && (bPhonebook == roRef.bPhonebook);
   bResult = bResult && (bPbSpeller == roRef.bPbSpeller);
   bResult = bResult && (bVoiceMailboxNumber == roRef.bVoiceMailboxNumber);
   bResult = bResult && (bPbStartDownload == roRef.bPbStartDownload);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure::midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure():enType(FI_EN_PHN_VAG_PHONEBOOKSTRUCTURE_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BAP_PBFSGSETUP_PHONEBOOKSTRUCTURE;
}


midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure::~midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup::midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ePhoneBookStructure = coRef.ePhoneBookStructure;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup& midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup& coRef)
{
   if (this == &coRef) return *this;
   ePhoneBookStructure = coRef.ePhoneBookStructure;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup::midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup()
:ePhoneBookStructure()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PBFSGSETUP;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup::~midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ePhoneBookStructure);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ePhoneBookStructure);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ePhoneBookStructure == roRef.ePhoneBookStructure);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus::midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus():enType(FI_EN_PHN_VAG_OPSTATUS_PB_NORMALOPERATION) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BAP_PBFSGOPERATIONSTATE_OPSTATUS;
}


midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus::~midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState::midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   eOPStatus = coRef.eOPStatus;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState& midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState& coRef)
{
   if (this == &coRef) return *this;
   eOPStatus = coRef.eOPStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState::midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState()
:eOPStatus()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PBFSGOPERATIONSTATE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState::~midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eOPStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eOPStatus);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eOPStatus == roRef.eOPStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication::midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication(const midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u16MissedCalls = coRef.u16MissedCalls;
   u16MissedNumbers = coRef.u16MissedNumbers;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication& midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication& coRef)
{
   if (this == &coRef) return *this;
   u16MissedCalls = coRef.u16MissedCalls;
   u16MissedNumbers = coRef.u16MissedNumbers;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication::midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication()
:u16MissedCalls(0)
,u16MissedNumbers(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PBMISSEDCALLINDICATION;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication::~midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16MissedCalls);
   (tVoid) (oIn >> u16MissedNumbers);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16MissedCalls);
   (tVoid) (oOut << u16MissedNumbers);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16MissedCalls == roRef.u16MissedCalls);
   bResult = bResult && (u16MissedNumbers == roRef.u16MissedNumbers);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType::midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType():enType(FI_EN_PHN_VAG_PBCALLLIST_NUMBERTYPE_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BAP_PBCALLLIST_ITEM_NUMBERTYPE;
}


midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType::~midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item::midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sPbName = coRef.sPbName;
   eNumberType = coRef.eNumberType;
   sTelNumber = coRef.sTelNumber;
   u8Day = coRef.u8Day;
   u8Month = coRef.u8Month;
   u8Year = coRef.u8Year;
   u16Year = coRef.u16Year;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item& midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item& coRef)
{
   if (this == &coRef) return *this;
   sPbName = coRef.sPbName;
   eNumberType = coRef.eNumberType;
   sTelNumber = coRef.sTelNumber;
   u8Day = coRef.u8Day;
   u8Month = coRef.u8Month;
   u8Year = coRef.u8Year;
   u16Year = coRef.u16Year;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item::vDestroy()
{
   sPbName.vDestroy();
   sTelNumber.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item::midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item()
:sPbName()
,eNumberType()
,sTelNumber()
,u8Day(0)
,u8Month(0)
,u8Year(0)
,u16Year(0)
,u8Hour(0)
,u8Minute(0)
,u8Second(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PBCALLLIST_ITEM;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item::~midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+sPbName.u32GetSize(u16MajorVersion)+sTelNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPbName);
   (tVoid) (oIn >> eNumberType);
   (tVoid) (oIn >> sTelNumber);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Year);
   (tVoid) (oIn >> u16Year);
   (tVoid) (oIn >> u8Hour);
   (tVoid) (oIn >> u8Minute);
   (tVoid) (oIn >> u8Second);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPbName);
   (tVoid) (oOut << eNumberType);
   (tVoid) (oOut << sTelNumber);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Year);
   (tVoid) (oOut << u16Year);
   (tVoid) (oOut << u8Hour);
   (tVoid) (oOut << u8Minute);
   (tVoid) (oOut << u8Second);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPbName == roRef.sPbName);
   bResult = bResult && (eNumberType == roRef.eNumberType);
   bResult = bResult && (sTelNumber == roRef.sTelNumber);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Year == roRef.u8Year);
   bResult = bResult && (u16Year == roRef.u16Year);
   bResult = bResult && (u8Hour == roRef.u8Hour);
   bResult = bResult && (u8Minute == roRef.u8Minute);
   bResult = bResult && (u8Second == roRef.u8Second);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList::midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   isListValid = coRef.isListValid;
   u16NbrOfItems = coRef.u16NbrOfItems;
   oItemList = coRef.oItemList;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList& midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList& coRef)
{
   if (this == &coRef) return *this;
   isListValid = coRef.isListValid;
   u16NbrOfItems = coRef.u16NbrOfItems;
   oItemList = coRef.oItemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         oItemList[u32Idx].vDestroy();
   oItemList.clear();
   }
}

midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList::midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList()
:isListValid(0)
,u16NbrOfItems(0)

 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PBCALLLIST;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList::~midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItemList.size(); ++u32ListIdx)
      u32DynamicSize += oItemList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> isListValid);
   (tVoid) (oIn >> u16NbrOfItems);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
      {
         oItemList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << isListValid);
   (tVoid) (oOut << u16NbrOfItems);
   (tVoid) (oOut << (tU32)oItemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         (tVoid) (oOut << oItemList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (isListValid == roRef.isListValid);
   bResult = bResult && (u16NbrOfItems == roRef.u16NbrOfItems);
      bResult = bResult && (oItemList.size() == roRef.oItemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItemList.size()); ++u32Idx)
            bResult = bResult && (oItemList[u32Idx] == roRef.oItemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState::midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState():enType(FI_EN_PHN_VAG_PBDOWNLOADSTATE_NOPHONEBOOKAVAILABLE) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BAP_PBDOWNLOADSTATE;
}


midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState::~midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_HASH_Value::midw_ext_fi_tcl_PHN_HASH_Value(const midw_ext_fi_tcl_PHN_HASH_Value& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   handle = coRef.handle;
}
midw_ext_fi_tcl_PHN_HASH_Value& midw_ext_fi_tcl_PHN_HASH_Value::operator=(const midw_ext_fi_tcl_PHN_HASH_Value& coRef)
{
   if (this == &coRef) return *this;
   handle = coRef.handle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_HASH_Value::vDestroy()
{
   {
   handle.clear();
   }
}

midw_ext_fi_tcl_PHN_HASH_Value::midw_ext_fi_tcl_PHN_HASH_Value()

 {}

tS32 midw_ext_fi_tcl_PHN_HASH_Value::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_HASH_VALUE;
}


midw_ext_fi_tcl_PHN_HASH_Value::~midw_ext_fi_tcl_PHN_HASH_Value()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_HASH_Value::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(handle.size()*4);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_HASH_Value::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      handle.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> handle[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_HASH_Value::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)handle.size());
   {
      for (tU32 u32Idx = 0; u32Idx < handle.size(); ++u32Idx)
         (tVoid) (oOut << handle[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_HASH_Value::operator==(const midw_ext_fi_tcl_PHN_HASH_Value& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (handle.size() == roRef.handle.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < handle.size()); ++u32Idx)
            bResult = bResult && (handle[u32Idx] == roRef.handle[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PBState::midw_ext_fi_tcl_PHN_VAG_BAP_PBState(const midw_ext_fi_tcl_PHN_VAG_BAP_PBState& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   eDownloadState = coRef.eDownloadState;
   u16PbEntriesUHV = coRef.u16PbEntriesUHV;
   bIsNewPhonebook = coRef.bIsNewPhonebook;
   u8ProfileHandle = coRef.u8ProfileHandle;
   bIsInitialDownload = coRef.bIsInitialDownload;
   hHashValue = coRef.hHashValue;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PBState& midw_ext_fi_tcl_PHN_VAG_BAP_PBState::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBState& coRef)
{
   if (this == &coRef) return *this;
   eDownloadState = coRef.eDownloadState;
   u16PbEntriesUHV = coRef.u16PbEntriesUHV;
   bIsNewPhonebook = coRef.bIsNewPhonebook;
   u8ProfileHandle = coRef.u8ProfileHandle;
   bIsInitialDownload = coRef.bIsInitialDownload;
   hHashValue = coRef.hHashValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_PBState::vDestroy()
{
   hHashValue.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_BAP_PBState::midw_ext_fi_tcl_PHN_VAG_BAP_PBState()
:eDownloadState()
,u16PbEntriesUHV(0)
,bIsNewPhonebook(0)
,u8ProfileHandle(0)
,bIsInitialDownload(0)
,hHashValue()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PBState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PBSTATE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PBState::~midw_ext_fi_tcl_PHN_VAG_BAP_PBState()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PBState::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+hHashValue.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBState::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eDownloadState);
   (tVoid) (oIn >> u16PbEntriesUHV);
   (tVoid) (oIn >> bIsNewPhonebook);
   (tVoid) (oIn >> u8ProfileHandle);
   (tVoid) (oIn >> bIsInitialDownload);
   (tVoid) (oIn >> hHashValue);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBState::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eDownloadState);
   (tVoid) (oOut << u16PbEntriesUHV);
   (tVoid) (oOut << bIsNewPhonebook);
   (tVoid) (oOut << u8ProfileHandle);
   (tVoid) (oOut << bIsInitialDownload);
   (tVoid) (oOut << hHashValue);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PBState::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBState& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eDownloadState == roRef.eDownloadState);
   bResult = bResult && (u16PbEntriesUHV == roRef.u16PbEntriesUHV);
   bResult = bResult && (bIsNewPhonebook == roRef.bIsNewPhonebook);
   bResult = bResult && (u8ProfileHandle == roRef.u8ProfileHandle);
   bResult = bResult && (bIsInitialDownload == roRef.bIsInitialDownload);
   bResult = bResult && (hHashValue == roRef.hHashValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState::midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState():enType(FI_EN_PHN_VAG_CALLSTATE_IDLE) {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELCALLINFORMATION_CALLSTATE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState::~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType::midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType():enType(FI_EN_PHN_VAG_CALLTYPE_UNKNOWN) {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELCALLINFORMATION_CALLTYPE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType::~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState::midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState():enType(FI_EN_PHN_VAG_DIVERTSTATE_NOTDIVERTED) {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELCALLINFORMATION_DIVERTSTATE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState::~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine::midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   BAPTelCallState = coRef.BAPTelCallState;
   BAPTelCallType = coRef.BAPTelCallType;
   BAPTelCallDiverted = coRef.BAPTelCallDiverted;
   BAPTelPbName = coRef.BAPTelPbName;
   BAPTelTelNumber = coRef.BAPTelTelNumber;
}
midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine& coRef)
{
   if (this == &coRef) return *this;
   BAPTelCallState = coRef.BAPTelCallState;
   BAPTelCallType = coRef.BAPTelCallType;
   BAPTelCallDiverted = coRef.BAPTelCallDiverted;
   BAPTelPbName = coRef.BAPTelPbName;
   BAPTelTelNumber = coRef.BAPTelTelNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine::vDestroy()
{
   BAPTelPbName.vDestroy();
   BAPTelTelNumber.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine::midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine()
:BAPTelCallState()
,BAPTelCallType()
,BAPTelCallDiverted()
,BAPTelPbName()
,BAPTelTelNumber()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELCALLINFORMATION_CALLLINE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine::~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+BAPTelPbName.u32GetSize(u16MajorVersion)+BAPTelTelNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BAPTelCallState);
   (tVoid) (oIn >> BAPTelCallType);
   (tVoid) (oIn >> BAPTelCallDiverted);
   (tVoid) (oIn >> BAPTelPbName);
   (tVoid) (oIn >> BAPTelTelNumber);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BAPTelCallState);
   (tVoid) (oOut << BAPTelCallType);
   (tVoid) (oOut << BAPTelCallDiverted);
   (tVoid) (oOut << BAPTelPbName);
   (tVoid) (oOut << BAPTelTelNumber);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BAPTelCallState == roRef.BAPTelCallState);
   bResult = bResult && (BAPTelCallType == roRef.BAPTelCallType);
   bResult = bResult && (BAPTelCallDiverted == roRef.BAPTelCallDiverted);
   bResult = bResult && (BAPTelPbName == roRef.BAPTelPbName);
   bResult = bResult && (BAPTelTelNumber == roRef.BAPTelTelNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation::midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   BAPTelActiveCall = coRef.BAPTelActiveCall;
   BAPTelHeldCall = coRef.BAPTelHeldCall;
   BAPTelWaitingCall = coRef.BAPTelWaitingCall;
}
midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation& coRef)
{
   if (this == &coRef) return *this;
   BAPTelActiveCall = coRef.BAPTelActiveCall;
   BAPTelHeldCall = coRef.BAPTelHeldCall;
   BAPTelWaitingCall = coRef.BAPTelWaitingCall;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation::vDestroy()
{
   BAPTelActiveCall.vDestroy(); 
   BAPTelHeldCall.vDestroy(); 
   BAPTelWaitingCall.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation::midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation()
:BAPTelActiveCall()
,BAPTelHeldCall()
,BAPTelWaitingCall()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELCALLINFORMATION;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation::~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+BAPTelActiveCall.u32GetSize(u16MajorVersion)+BAPTelHeldCall.u32GetSize(u16MajorVersion)+BAPTelWaitingCall.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BAPTelActiveCall);
   (tVoid) (oIn >> BAPTelHeldCall);
   (tVoid) (oIn >> BAPTelWaitingCall);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BAPTelActiveCall);
   (tVoid) (oOut << BAPTelHeldCall);
   (tVoid) (oOut << BAPTelWaitingCall);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BAPTelActiveCall == roRef.BAPTelActiveCall);
   bResult = bResult && (BAPTelHeldCall == roRef.BAPTelHeldCall);
   bResult = bResult && (BAPTelWaitingCall == roRef.BAPTelWaitingCall);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration::midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   isListValid = coRef.isListValid;
   u32BAPTelDurationActiveCall = coRef.u32BAPTelDurationActiveCall;
   u32BAPTelDurationHeldCall = coRef.u32BAPTelDurationHeldCall;
}
midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration& coRef)
{
   if (this == &coRef) return *this;
   isListValid = coRef.isListValid;
   u32BAPTelDurationActiveCall = coRef.u32BAPTelDurationActiveCall;
   u32BAPTelDurationHeldCall = coRef.u32BAPTelDurationHeldCall;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration::midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration()
:isListValid(0)
,u32BAPTelDurationActiveCall(0)
,u32BAPTelDurationHeldCall(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELCALLDURATION;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration::~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> isListValid);
   (tVoid) (oIn >> u32BAPTelDurationActiveCall);
   (tVoid) (oIn >> u32BAPTelDurationHeldCall);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << isListValid);
   (tVoid) (oOut << u32BAPTelDurationActiveCall);
   (tVoid) (oOut << u32BAPTelDurationHeldCall);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (isListValid == roRef.isListValid);
   bResult = bResult && (u32BAPTelDurationActiveCall == roRef.u32BAPTelDurationActiveCall);
   bResult = bResult && (u32BAPTelDurationHeldCall == roRef.u32BAPTelDurationHeldCall);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BTM_PIN::midw_ext_fi_tcl_PHN_VAG_BTM_PIN(const midw_ext_fi_tcl_PHN_VAG_BTM_PIN& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sPIN = coRef.sPIN;
}
midw_ext_fi_tcl_PHN_VAG_BTM_PIN& midw_ext_fi_tcl_PHN_VAG_BTM_PIN::operator=(const midw_ext_fi_tcl_PHN_VAG_BTM_PIN& coRef)
{
   if (this == &coRef) return *this;
   sPIN = coRef.sPIN;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BTM_PIN::vDestroy()
{
   sPIN.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_BTM_PIN::midw_ext_fi_tcl_PHN_VAG_BTM_PIN()
:sPIN()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BTM_PIN::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BTM_PIN;
}


midw_ext_fi_tcl_PHN_VAG_BTM_PIN::~midw_ext_fi_tcl_PHN_VAG_BTM_PIN()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BTM_PIN::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sPIN.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BTM_PIN::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPIN);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BTM_PIN::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPIN);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BTM_PIN::operator==(const midw_ext_fi_tcl_PHN_VAG_BTM_PIN& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPIN == roRef.sPIN);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE():enType(FI_EN_PHN_BTTESTMODE_NORMAL_MODE) {}

tS32 midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_BTM_TEST_MODE;
}


midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::~midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE()
{}

tU32 midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_BTTestAction::midw_ext_fi_tcl_e8_PHN_BTTestAction():enType(FI_EN_PHN_BTTESTACTION_STOP_I2S_TESTTONE) {}

tS32 midw_ext_fi_tcl_e8_PHN_BTTestAction::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_BTTESTACTION;
}


midw_ext_fi_tcl_e8_PHN_BTTestAction::~midw_ext_fi_tcl_e8_PHN_BTTestAction()
{}

tU32 midw_ext_fi_tcl_e8_PHN_BTTestAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_BTTestAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_BTTestAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_SetGetShortcutNumber::midw_ext_fi_tcl_PHN_SetGetShortcutNumber(const midw_ext_fi_tcl_PHN_SetGetShortcutNumber& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8ShortcutNumberEntry = coRef.u8ShortcutNumberEntry;
   sShortcutNumber = coRef.sShortcutNumber;
   sShortcutName = coRef.sShortcutName;
}
midw_ext_fi_tcl_PHN_SetGetShortcutNumber& midw_ext_fi_tcl_PHN_SetGetShortcutNumber::operator=(const midw_ext_fi_tcl_PHN_SetGetShortcutNumber& coRef)
{
   if (this == &coRef) return *this;
   u8ShortcutNumberEntry = coRef.u8ShortcutNumberEntry;
   sShortcutNumber = coRef.sShortcutNumber;
   sShortcutName = coRef.sShortcutName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_SetGetShortcutNumber::vDestroy()
{
   sShortcutNumber.vDestroy();
   sShortcutName.vDestroy();
}

midw_ext_fi_tcl_PHN_SetGetShortcutNumber::midw_ext_fi_tcl_PHN_SetGetShortcutNumber()
:u8ShortcutNumberEntry(0)
,sShortcutNumber()
,sShortcutName()
 {}

tS32 midw_ext_fi_tcl_PHN_SetGetShortcutNumber::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_SETGETSHORTCUTNUMBER;
}


midw_ext_fi_tcl_PHN_SetGetShortcutNumber::~midw_ext_fi_tcl_PHN_SetGetShortcutNumber()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_SetGetShortcutNumber::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sShortcutNumber.u32GetSize(u16MajorVersion)+sShortcutName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_SetGetShortcutNumber::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8ShortcutNumberEntry);
   (tVoid) (oIn >> sShortcutNumber);
   (tVoid) (oIn >> sShortcutName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_SetGetShortcutNumber::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8ShortcutNumberEntry);
   (tVoid) (oOut << sShortcutNumber);
   (tVoid) (oOut << sShortcutName);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_SetGetShortcutNumber::operator==(const midw_ext_fi_tcl_PHN_SetGetShortcutNumber& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8ShortcutNumberEntry == roRef.u8ShortcutNumberEntry);
   bResult = bResult && (sShortcutNumber == roRef.sShortcutNumber);
   bResult = bResult && (sShortcutName == roRef.sShortcutName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest::midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest(const midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   oItemList = coRef.oItemList;
}
midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest& midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest::operator=(const midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest& coRef)
{
   if (this == &coRef) return *this;
   oItemList = coRef.oItemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         oItemList[u32Idx].vDestroy();
   oItemList.clear();
   }
}

midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest::midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest()

 {}

tS32 midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_SETGETSHORTCUTNUMBERREQUEST;
}


midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest::~midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItemList.size(); ++u32ListIdx)
      u32DynamicSize += oItemList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
      {
         oItemList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         (tVoid) (oOut << oItemList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest::operator==(const midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItemList.size() == roRef.oItemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItemList.size()); ++u32Idx)
            bResult = bResult && (oItemList[u32Idx] == roRef.oItemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL::midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL():u8Value(0)
{}

tS32 midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B8_PHN_DISPLAY_CONTROL;
}


midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL::~midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL()
{}

tU32 midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_SMS_Handle::midw_ext_fi_tcl_PHN_SMS_Handle(const midw_ext_fi_tcl_PHN_SMS_Handle& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   handle = coRef.handle;
}
midw_ext_fi_tcl_PHN_SMS_Handle& midw_ext_fi_tcl_PHN_SMS_Handle::operator=(const midw_ext_fi_tcl_PHN_SMS_Handle& coRef)
{
   if (this == &coRef) return *this;
   handle = coRef.handle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_SMS_Handle::vDestroy()
{
   {
   handle.clear();
   }
}

midw_ext_fi_tcl_PHN_SMS_Handle::midw_ext_fi_tcl_PHN_SMS_Handle()

 {}

tS32 midw_ext_fi_tcl_PHN_SMS_Handle::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_SMS_HANDLE;
}


midw_ext_fi_tcl_PHN_SMS_Handle::~midw_ext_fi_tcl_PHN_SMS_Handle()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_SMS_Handle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(handle.size()*1);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_SMS_Handle::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      handle.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> handle[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_SMS_Handle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)handle.size());
   {
      for (tU32 u32Idx = 0; u32Idx < handle.size(); ++u32Idx)
         (tVoid) (oOut << handle[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_SMS_Handle::operator==(const midw_ext_fi_tcl_PHN_SMS_Handle& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (handle.size() == roRef.handle.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < handle.size()); ++u32Idx)
            bResult = bResult && (handle[u32Idx] == roRef.handle[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_SMS_Message_Status::midw_ext_fi_tcl_e8_PHN_SMS_Message_Status():enType(FI_EN_PHN_SMS_UNREAD) {}

tS32 midw_ext_fi_tcl_e8_PHN_SMS_Message_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_SMS_MESSAGE_STATUS;
}


midw_ext_fi_tcl_e8_PHN_SMS_Message_Status::~midw_ext_fi_tcl_e8_PHN_SMS_Message_Status()
{}

tU32 midw_ext_fi_tcl_e8_PHN_SMS_Message_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_SMS_Message_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_SMS_Message_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status::midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status():enType(FI_EN_PHN_SMS_UPDATE_INITIAL) {}

tS32 midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_SMS_INBOX_UPDATE_STATUS;
}


midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status::~midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status()
{}

tU32 midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status::midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status():enType(FI_EN_PHN_SMS_SENDING_STATUS_NOT_SUPPORTED) {}

tS32 midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_SMS_SENDING_STATUS;
}


midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status::~midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status()
{}

tU32 midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_NumberType::midw_ext_fi_tcl_e8_PHN_VAG_NumberType():enType(FI_EN_PHN_VAG_NUMBER_TYPE_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_NumberType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_NUMBERTYPE;
}


midw_ext_fi_tcl_e8_PHN_VAG_NumberType::~midw_ext_fi_tcl_e8_PHN_VAG_NumberType()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_NumberType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_NumberType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_NumberType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE::midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE(const midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8SmsParagraphEntry = coRef.u8SmsParagraphEntry;
   sMessage = coRef.sMessage;
}
midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE& midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE::operator=(const midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE& coRef)
{
   if (this == &coRef) return *this;
   u8SmsParagraphEntry = coRef.u8SmsParagraphEntry;
   sMessage = coRef.sMessage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE::vDestroy()
{
   sMessage.vDestroy();
}

midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE::midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE()
:u8SmsParagraphEntry(0)
,sMessage()
 {}

tS32 midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_SMS_PREDEFINED_MESSAGE;
}


midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE::~midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sMessage.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SmsParagraphEntry);
   (tVoid) (oIn >> sMessage);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SmsParagraphEntry);
   (tVoid) (oOut << sMessage);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE::operator==(const midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SmsParagraphEntry == roRef.u8SmsParagraphEntry);
   bResult = bResult && (sMessage == roRef.sMessage);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_StartPairingRequest::midw_ext_fi_tcl_PHN_VAG_StartPairingRequest(const midw_ext_fi_tcl_PHN_VAG_StartPairingRequest& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   BTDeviceAddress = coRef.BTDeviceAddress;
   isPairingStartRequest = coRef.isPairingStartRequest;
}
midw_ext_fi_tcl_PHN_VAG_StartPairingRequest& midw_ext_fi_tcl_PHN_VAG_StartPairingRequest::operator=(const midw_ext_fi_tcl_PHN_VAG_StartPairingRequest& coRef)
{
   if (this == &coRef) return *this;
   BTDeviceAddress = coRef.BTDeviceAddress;
   isPairingStartRequest = coRef.isPairingStartRequest;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_StartPairingRequest::vDestroy()
{
   BTDeviceAddress.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_StartPairingRequest::midw_ext_fi_tcl_PHN_VAG_StartPairingRequest()
:BTDeviceAddress()
,isPairingStartRequest(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_StartPairingRequest::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_STARTPAIRINGREQUEST;
}


midw_ext_fi_tcl_PHN_VAG_StartPairingRequest::~midw_ext_fi_tcl_PHN_VAG_StartPairingRequest()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_StartPairingRequest::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+BTDeviceAddress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_StartPairingRequest::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTDeviceAddress);
   (tVoid) (oIn >> isPairingStartRequest);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_StartPairingRequest::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTDeviceAddress);
   (tVoid) (oOut << isPairingStartRequest);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_StartPairingRequest::operator==(const midw_ext_fi_tcl_PHN_VAG_StartPairingRequest& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTDeviceAddress == roRef.BTDeviceAddress);
   bResult = bResult && (isPairingStartRequest == roRef.isPairingStartRequest);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest::midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest(const midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   BTDeviceAddress = coRef.BTDeviceAddress;
}
midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest& midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest::operator=(const midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest& coRef)
{
   if (this == &coRef) return *this;
   BTDeviceAddress = coRef.BTDeviceAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest::vDestroy()
{
   BTDeviceAddress.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest::midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest()
:BTDeviceAddress()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_DELETEPAIREDDEVICEREQUEST;
}


midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest::~midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+BTDeviceAddress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTDeviceAddress);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTDeviceAddress);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest::operator==(const midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTDeviceAddress == roRef.BTDeviceAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest::midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   BTDeviceAddress = coRef.BTDeviceAddress;
}
midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest& midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest::operator=(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest& coRef)
{
   if (this == &coRef) return *this;
   BTDeviceAddress = coRef.BTDeviceAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest::vDestroy()
{
   BTDeviceAddress.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest::midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest()
:BTDeviceAddress()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_CONNECTBTDEVICEREQUEST;
}


midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest::~midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+BTDeviceAddress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTDeviceAddress);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTDeviceAddress);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest::operator==(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTDeviceAddress == roRef.BTDeviceAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest::midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest(const midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   BluetoothStatus = coRef.BluetoothStatus;
}
midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest& midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest::operator=(const midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest& coRef)
{
   if (this == &coRef) return *this;
   BluetoothStatus = coRef.BluetoothStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest::midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest()
:BluetoothStatus(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_SETBTMONOFFREQUEST;
}


midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest::~midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BluetoothStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BluetoothStatus);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest::operator==(const midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BluetoothStatus == roRef.BluetoothStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_BT_Profile::midw_ext_fi_tcl_e8_PHN_BT_Profile():enType(FI_EN_PHN_BT_HFP) {}

tS32 midw_ext_fi_tcl_e8_PHN_BT_Profile::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_BT_PROFILE;
}


midw_ext_fi_tcl_e8_PHN_BT_Profile::~midw_ext_fi_tcl_e8_PHN_BT_Profile()
{}

tU32 midw_ext_fi_tcl_e8_PHN_BT_Profile::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_BT_Profile::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_BT_Profile::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType::midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType():enType(FI_EN_PHN_VAG_BAP_CODE_TYPE_UNDEFINED) {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELSTARTPHONEENABLE_CODETYPE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType::~midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable::midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   eCodeType = coRef.eCodeType;
   sCode = coRef.sCode;
}
midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable& midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable& coRef)
{
   if (this == &coRef) return *this;
   eCodeType = coRef.eCodeType;
   sCode = coRef.sCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable::vDestroy()
{
   sCode.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable::midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable()
:eCodeType()
,sCode()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELSTARTPHONEENABLE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable::~midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sCode.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eCodeType);
   (tVoid) (oIn >> sCode);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eCodeType);
   (tVoid) (oOut << sCode);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eCodeType == roRef.eCodeType);
   bResult = bResult && (sCode == roRef.sCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType::midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType():enType(FI_EN_PHN_VAG_BAP_DIAL_NUMBER) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BAP_TELSTARTDIALNUMBER_NUMBERTYPE;
}


midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType::~midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber::midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   eNumberType = coRef.eNumberType;
   sTelNumber = coRef.sTelNumber;
   sName = coRef.sName;
   u32PhonebookEntryId = coRef.u32PhonebookEntryId;
}
midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber& midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber& coRef)
{
   if (this == &coRef) return *this;
   eNumberType = coRef.eNumberType;
   sTelNumber = coRef.sTelNumber;
   sName = coRef.sName;
   u32PhonebookEntryId = coRef.u32PhonebookEntryId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber::vDestroy()
{
   sTelNumber.vDestroy();
   sName.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber::midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber()
:eNumberType()
,sTelNumber()
,sName()
,u32PhonebookEntryId(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELSTARTDIALNUMBER;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber::~midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+sTelNumber.u32GetSize(u16MajorVersion)+sName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eNumberType);
   (tVoid) (oIn >> sTelNumber);
   (tVoid) (oIn >> sName);
   (tVoid) (oIn >> u32PhonebookEntryId);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eNumberType);
   (tVoid) (oOut << sTelNumber);
   (tVoid) (oOut << sName);
   (tVoid) (oOut << u32PhonebookEntryId);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eNumberType == roRef.eNumberType);
   bResult = bResult && (sTelNumber == roRef.sTelNumber);
   bResult = bResult && (sName == roRef.sName);
   bResult = bResult && (u32PhonebookEntryId == roRef.u32PhonebookEntryId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall::midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall():enType(FI_EN_PHN_VAG_BAP_HANG_UP_AIRBIQUITY_CALL) {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELSTARTHANGUPCALL;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall::~midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff::midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff():enType(FI_EN_PHN_VAG_BAP_SHUT_DOWN_PHONE) {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELPHONEONOFF;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff::~midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode::midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode():enType(FI_EN_PHN_VAG_BAP_RESTORE_FACTORY_SETTINGS_MODE_RESERVED) {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_TELRESTOREFACTORYSETTINGS_MODE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode::~midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage::midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage():u8Value(0)
{}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PBCALLSTACKDELETEALL_STORAGE;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage::~midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection::midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection():enType(FI_EN_T_E8_PHN_VAG_BAP_PB_SEARCHDIRECTION_UP) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BAP_PB_SEARCHDIRECTION;
}


midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection::~midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest::midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32StartingPosition = coRef.u32StartingPosition;
   eDirection = coRef.eDirection;
   s32Offset = coRef.s32Offset;
   u8NumberOfEntries = coRef.u8NumberOfEntries;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest& coRef)
{
   if (this == &coRef) return *this;
   u32StartingPosition = coRef.u32StartingPosition;
   eDirection = coRef.eDirection;
   s32Offset = coRef.s32Offset;
   u8NumberOfEntries = coRef.u8NumberOfEntries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest::midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest()
:u32StartingPosition(0)
,eDirection()
,s32Offset(0)
,u8NumberOfEntries(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PB_PHONEBOOKREQUEST;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest::~midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32StartingPosition);
   (tVoid) (oIn >> eDirection);
   (tVoid) (oIn >> s32Offset);
   (tVoid) (oIn >> u8NumberOfEntries);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32StartingPosition);
   (tVoid) (oOut << eDirection);
   (tVoid) (oOut << s32Offset);
   (tVoid) (oOut << u8NumberOfEntries);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32StartingPosition == roRef.u32StartingPosition);
   bResult = bResult && (eDirection == roRef.eDirection);
   bResult = bResult && (s32Offset == roRef.s32Offset);
   bResult = bResult && (u8NumberOfEntries == roRef.u8NumberOfEntries);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest::midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sSearchString = coRef.sSearchString;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest& midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest& coRef)
{
   if (this == &coRef) return *this;
   sSearchString = coRef.sSearchString;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest::vDestroy()
{
   sSearchString.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest::midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest()
:sSearchString()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PB_SPELLERREQUEST;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest::~midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sSearchString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sSearchString);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sSearchString);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sSearchString == roRef.sSearchString);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST::midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST(const midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   isVoiceRecognitionEnable = coRef.isVoiceRecognitionEnable;
}
midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST& midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST::operator=(const midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST& coRef)
{
   if (this == &coRef) return *this;
   isVoiceRecognitionEnable = coRef.isVoiceRecognitionEnable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST::midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST()
:isVoiceRecognitionEnable(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_VOICE_RECOGNITION_REQUEST;
}


midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST::~midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> isVoiceRecognitionEnable);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << isVoiceRecognitionEnable);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST::operator==(const midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (isVoiceRecognitionEnable == roRef.isVoiceRecognitionEnable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult::midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult():enType(FI_EN_PHN_VAG_SET_BT_VISIBILITY_RESULT_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_SETBTVISIBILITYRESULT;
}


midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult::~midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult::midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult():enType(FI_EN_PHN_VAG_START_PAIRING_RESULT_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_STARTPAIRINGRESULT;
}


midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult::~midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_StartPairingResult::midw_ext_fi_tcl_PHN_VAG_StartPairingResult(const midw_ext_fi_tcl_PHN_VAG_StartPairingResult& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8Result = coRef.e8Result;
   BTDeviceName = coRef.BTDeviceName;
}
midw_ext_fi_tcl_PHN_VAG_StartPairingResult& midw_ext_fi_tcl_PHN_VAG_StartPairingResult::operator=(const midw_ext_fi_tcl_PHN_VAG_StartPairingResult& coRef)
{
   if (this == &coRef) return *this;
   e8Result = coRef.e8Result;
   BTDeviceName = coRef.BTDeviceName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_StartPairingResult::vDestroy()
{
   BTDeviceName.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_StartPairingResult::midw_ext_fi_tcl_PHN_VAG_StartPairingResult()
:e8Result()
,BTDeviceName()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_StartPairingResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_STARTPAIRINGRESULT;
}


midw_ext_fi_tcl_PHN_VAG_StartPairingResult::~midw_ext_fi_tcl_PHN_VAG_StartPairingResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_StartPairingResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+BTDeviceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_StartPairingResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Result);
   (tVoid) (oIn >> BTDeviceName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_StartPairingResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Result);
   (tVoid) (oOut << BTDeviceName);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_StartPairingResult::operator==(const midw_ext_fi_tcl_PHN_VAG_StartPairingResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Result == roRef.e8Result);
   bResult = bResult && (BTDeviceName == roRef.BTDeviceName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList::midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList(const midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   isListValid = coRef.isListValid;
   u8NbrOfItems = coRef.u8NbrOfItems;
   oPairedItemList = coRef.oPairedItemList;
}
midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList& midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList::operator=(const midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList& coRef)
{
   if (this == &coRef) return *this;
   isListValid = coRef.isListValid;
   u8NbrOfItems = coRef.u8NbrOfItems;
   oPairedItemList = coRef.oPairedItemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oPairedItemList.size(); ++u32Idx)
         oPairedItemList[u32Idx].vDestroy();
   oPairedItemList.clear();
   }
}

midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList::midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList()
:isListValid(0)
,u8NbrOfItems(0)

 {}

tS32 midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_PAIREDBTDEVICELIST;
}


midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList::~midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oPairedItemList.size(); ++u32ListIdx)
      u32DynamicSize += oPairedItemList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> isListValid);
   (tVoid) (oIn >> u8NbrOfItems);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oPairedItemList.size(); ++u32Idx)
      {
         oPairedItemList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oPairedItemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oPairedItemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << isListValid);
   (tVoid) (oOut << u8NbrOfItems);
   (tVoid) (oOut << (tU32)oPairedItemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oPairedItemList.size(); ++u32Idx)
         (tVoid) (oOut << oPairedItemList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList::operator==(const midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (isListValid == roRef.isListValid);
   bResult = bResult && (u8NbrOfItems == roRef.u8NbrOfItems);
      bResult = bResult && (oPairedItemList.size() == roRef.oPairedItemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oPairedItemList.size()); ++u32Idx)
            bResult = bResult && (oPairedItemList[u32Idx] == roRef.oPairedItemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult::midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult():enType(FI_EN_PHN_VAG_DEL_PAIRED_BT_DEV_RESULT_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_DELETEPAIREDBTDEVRESULT;
}


midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult::~midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult::midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult(const midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8Result = coRef.e8Result;
}
midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult& midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult::operator=(const midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult& coRef)
{
   if (this == &coRef) return *this;
   e8Result = coRef.e8Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult::midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult()
:e8Result()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_DELETEPAIREDBTDEVRESULT;
}


midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult::~midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Result);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Result);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult::operator==(const midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Result == roRef.e8Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult::midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult():enType(FI_EN_PHN_REPLACE_PAIRED_BT_DEV_RESULT_OK) {}

tS32 midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_REPLACEPAIREDBTDEVRESULT;
}


midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult::~midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult()
{}

tU32 midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult::midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult():enType(FI_EN_PHN_VAG_CONNECT_BT_DEV_RESULT_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_CONNECTBTDEVRESULT;
}


midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult::~midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult::midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   BTDeviceAddess = coRef.BTDeviceAddess;
   e8Result = coRef.e8Result;
}
midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult& midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult::operator=(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult& coRef)
{
   if (this == &coRef) return *this;
   BTDeviceAddess = coRef.BTDeviceAddess;
   e8Result = coRef.e8Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult::vDestroy()
{
   BTDeviceAddess.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult::midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult()
:BTDeviceAddess()
,e8Result()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_CONNECTBTDEVRESULT;
}


midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult::~midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+BTDeviceAddess.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTDeviceAddess);
   (tVoid) (oIn >> e8Result);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTDeviceAddess);
   (tVoid) (oOut << e8Result);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult::operator==(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTDeviceAddess == roRef.BTDeviceAddess);
   bResult = bResult && (e8Result == roRef.e8Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result::midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result():enType(FI_EN_PHN_VAG_BAP_METHOD_OK) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BAP_RESULT;
}


midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result::~midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name::midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32Position = coRef.u32Position;
   sPbName = coRef.sPbName;
   u8TelNmbQuantity = coRef.u8TelNmbQuantity;
   eNumberType = coRef.eNumberType;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name& coRef)
{
   if (this == &coRef) return *this;
   u32Position = coRef.u32Position;
   sPbName = coRef.sPbName;
   u8TelNmbQuantity = coRef.u8TelNmbQuantity;
   eNumberType = coRef.eNumberType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name::vDestroy()
{
   sPbName.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name::midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name()
:u32Position(0)
,sPbName()
,u8TelNmbQuantity(0)
,eNumberType()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PB_PHONEBOOK_NAME;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name::~midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+sPbName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> sPbName);
   (tVoid) (oIn >> u8TelNmbQuantity);
   (tVoid) (oIn >> eNumberType);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << sPbName);
   (tVoid) (oOut << u8TelNmbQuantity);
   (tVoid) (oOut << eNumberType);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (sPbName == roRef.sPbName);
   bResult = bResult && (u8TelNmbQuantity == roRef.u8TelNmbQuantity);
   bResult = bResult && (eNumberType == roRef.eNumberType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window::midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   isListValid = coRef.isListValid;
   u16NbrOfItems = coRef.u16NbrOfItems;
   oItemList = coRef.oItemList;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window& coRef)
{
   if (this == &coRef) return *this;
   isListValid = coRef.isListValid;
   u16NbrOfItems = coRef.u16NbrOfItems;
   oItemList = coRef.oItemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         oItemList[u32Idx].vDestroy();
   oItemList.clear();
   }
}

midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window::midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window()
:isListValid(0)
,u16NbrOfItems(0)

 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PB_PHONEBOOK_WINDOW;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window::~midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItemList.size(); ++u32ListIdx)
      u32DynamicSize += oItemList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> isListValid);
   (tVoid) (oIn >> u16NbrOfItems);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
      {
         oItemList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << isListValid);
   (tVoid) (oOut << u16NbrOfItems);
   (tVoid) (oOut << (tU32)oItemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         (tVoid) (oOut << oItemList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (isListValid == roRef.isListValid);
   bResult = bResult && (u16NbrOfItems == roRef.u16NbrOfItems);
      bResult = bResult && (oItemList.size() == roRef.oItemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItemList.size()); ++u32Idx)
            bResult = bResult && (oItemList[u32Idx] == roRef.oItemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult::midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   eBAPMethodResult = coRef.eBAPMethodResult;
   ResultContent = coRef.ResultContent;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult& coRef)
{
   if (this == &coRef) return *this;
   eBAPMethodResult = coRef.eBAPMethodResult;
   ResultContent = coRef.ResultContent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult::vDestroy()
{
   ResultContent.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult::midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult()
:eBAPMethodResult()
,ResultContent()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PB_PHONEBOOKRESULT;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult::~midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+ResultContent.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eBAPMethodResult);
   (tVoid) (oIn >> ResultContent);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eBAPMethodResult);
   (tVoid) (oOut << ResultContent);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eBAPMethodResult == roRef.eBAPMethodResult);
   bResult = bResult && (ResultContent == roRef.ResultContent);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem::midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   eNumberType = coRef.eNumberType;
   sTelNumber = coRef.sTelNumber;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem& coRef)
{
   if (this == &coRef) return *this;
   eNumberType = coRef.eNumberType;
   sTelNumber = coRef.sTelNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem::vDestroy()
{
   sTelNumber.vDestroy();
}

midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem::midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem()
:eNumberType()
,sTelNumber()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PB_PHONEBOOK_NUMBERITEM;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem::~midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sTelNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eNumberType);
   (tVoid) (oIn >> sTelNumber);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eNumberType);
   (tVoid) (oOut << sTelNumber);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eNumberType == roRef.eNumberType);
   bResult = bResult && (sTelNumber == roRef.sTelNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item::midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   NameAndPosition = coRef.NameAndPosition;
   u8NbrOfItems = coRef.u8NbrOfItems;
   oItemList = coRef.oItemList;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item& coRef)
{
   if (this == &coRef) return *this;
   NameAndPosition = coRef.NameAndPosition;
   u8NbrOfItems = coRef.u8NbrOfItems;
   oItemList = coRef.oItemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item::vDestroy()
{
   NameAndPosition.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         oItemList[u32Idx].vDestroy();
   oItemList.clear();
   }
}

midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item::midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item()
:NameAndPosition()
,u8NbrOfItems(0)

 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PB_PHONEBOOK_ITEM;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item::~midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItemList.size(); ++u32ListIdx)
      u32DynamicSize += oItemList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5+NameAndPosition.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NameAndPosition);
   (tVoid) (oIn >> u8NbrOfItems);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
      {
         oItemList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NameAndPosition);
   (tVoid) (oOut << u8NbrOfItems);
   (tVoid) (oOut << (tU32)oItemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         (tVoid) (oOut << oItemList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NameAndPosition == roRef.NameAndPosition);
   bResult = bResult && (u8NbrOfItems == roRef.u8NbrOfItems);
      bResult = bResult && (oItemList.size() == roRef.oItemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItemList.size()); ++u32Idx)
            bResult = bResult && (oItemList[u32Idx] == roRef.oItemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult::midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   eBAPMethodResult = coRef.eBAPMethodResult;
   ResultContent = coRef.ResultContent;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult& coRef)
{
   if (this == &coRef) return *this;
   eBAPMethodResult = coRef.eBAPMethodResult;
   ResultContent = coRef.ResultContent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult::vDestroy()
{
   ResultContent.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult::midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult()
:eBAPMethodResult()
,ResultContent()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PB_PHONEBOOKDETAILSRESULT;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult::~midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+ResultContent.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eBAPMethodResult);
   (tVoid) (oIn >> ResultContent);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eBAPMethodResult);
   (tVoid) (oOut << ResultContent);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eBAPMethodResult == roRef.eBAPMethodResult);
   bResult = bResult && (ResultContent == roRef.ResultContent);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE::midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE(const midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   hSmsHandle = coRef.hSmsHandle;
   e8MessageStatus = coRef.e8MessageStatus;
   u16Year = coRef.u16Year;
   u8Year = coRef.u8Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
   sTelNumber = coRef.sTelNumber;
   sName = coRef.sName;
   sSubject = coRef.sSubject;
   eNumberType = coRef.eNumberType;
}
midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE& midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE::operator=(const midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE& coRef)
{
   if (this == &coRef) return *this;
   hSmsHandle = coRef.hSmsHandle;
   e8MessageStatus = coRef.e8MessageStatus;
   u16Year = coRef.u16Year;
   u8Year = coRef.u8Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
   sTelNumber = coRef.sTelNumber;
   sName = coRef.sName;
   sSubject = coRef.sSubject;
   eNumberType = coRef.eNumberType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE::vDestroy()
{
   hSmsHandle.vDestroy(); 
   sTelNumber.vDestroy();
   sName.vDestroy();
   sSubject.vDestroy();
}

midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE::midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE()
:hSmsHandle()
,e8MessageStatus()
,u16Year(0)
,u8Year(0)
,u8Month(0)
,u8Day(0)
,u8Hour(0)
,u8Minute(0)
,u8Second(0)
,sTelNumber()
,sName()
,sSubject()
,eNumberType()
 {}

tS32 midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_SMS_LIST_MESSAGE;
}


midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE::~midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+hSmsHandle.u32GetSize(u16MajorVersion)+sTelNumber.u32GetSize(u16MajorVersion)+sName.u32GetSize(u16MajorVersion)+sSubject.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> hSmsHandle);
   (tVoid) (oIn >> e8MessageStatus);
   (tVoid) (oIn >> u16Year);
   (tVoid) (oIn >> u8Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hour);
   (tVoid) (oIn >> u8Minute);
   (tVoid) (oIn >> u8Second);
   (tVoid) (oIn >> sTelNumber);
   (tVoid) (oIn >> sName);
   (tVoid) (oIn >> sSubject);
   (tVoid) (oIn >> eNumberType);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << hSmsHandle);
   (tVoid) (oOut << e8MessageStatus);
   (tVoid) (oOut << u16Year);
   (tVoid) (oOut << u8Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hour);
   (tVoid) (oOut << u8Minute);
   (tVoid) (oOut << u8Second);
   (tVoid) (oOut << sTelNumber);
   (tVoid) (oOut << sName);
   (tVoid) (oOut << sSubject);
   (tVoid) (oOut << eNumberType);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE::operator==(const midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (hSmsHandle == roRef.hSmsHandle);
   bResult = bResult && (e8MessageStatus == roRef.e8MessageStatus);
   bResult = bResult && (u16Year == roRef.u16Year);
   bResult = bResult && (u8Year == roRef.u8Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hour == roRef.u8Hour);
   bResult = bResult && (u8Minute == roRef.u8Minute);
   bResult = bResult && (u8Second == roRef.u8Second);
   bResult = bResult && (sTelNumber == roRef.sTelNumber);
   bResult = bResult && (sName == roRef.sName);
   bResult = bResult && (sSubject == roRef.sSubject);
   bResult = bResult && (eNumberType == roRef.eNumberType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name::midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name(const midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32Position = coRef.u32Position;
   sPbName = coRef.sPbName;
   sFliName = coRef.sFliName;
   u8TelNmbQuantity = coRef.u8TelNmbQuantity;
   eNumberType = coRef.eNumberType;
}
midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name& midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name::operator=(const midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name& coRef)
{
   if (this == &coRef) return *this;
   u32Position = coRef.u32Position;
   sPbName = coRef.sPbName;
   sFliName = coRef.sFliName;
   u8TelNmbQuantity = coRef.u8TelNmbQuantity;
   eNumberType = coRef.eNumberType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name::vDestroy()
{
   sPbName.vDestroy();
   sFliName.vDestroy();
}

midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name::midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name()
:u32Position(0)
,sPbName()
,sFliName()
,u8TelNmbQuantity(0)
,eNumberType()
 {}

tS32 midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_PB_FLI_PHONEBOOK_NAME;
}


midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name::~midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+sPbName.u32GetSize(u16MajorVersion)+sFliName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> sPbName);
   (tVoid) (oIn >> sFliName);
   (tVoid) (oIn >> u8TelNmbQuantity);
   (tVoid) (oIn >> eNumberType);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << sPbName);
   (tVoid) (oOut << sFliName);
   (tVoid) (oOut << u8TelNmbQuantity);
   (tVoid) (oOut << eNumberType);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name::operator==(const midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (sPbName == roRef.sPbName);
   bResult = bResult && (sFliName == roRef.sFliName);
   bResult = bResult && (u8TelNmbQuantity == roRef.u8TelNmbQuantity);
   bResult = bResult && (eNumberType == roRef.eNumberType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_PB_FLI_Result::midw_ext_fi_tcl_PHN_PB_FLI_Result(const midw_ext_fi_tcl_PHN_PB_FLI_Result& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   oItemList = coRef.oItemList;
}
midw_ext_fi_tcl_PHN_PB_FLI_Result& midw_ext_fi_tcl_PHN_PB_FLI_Result::operator=(const midw_ext_fi_tcl_PHN_PB_FLI_Result& coRef)
{
   if (this == &coRef) return *this;
   oItemList = coRef.oItemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_PB_FLI_Result::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         oItemList[u32Idx].vDestroy();
   oItemList.clear();
   }
}

midw_ext_fi_tcl_PHN_PB_FLI_Result::midw_ext_fi_tcl_PHN_PB_FLI_Result()

 {}

tS32 midw_ext_fi_tcl_PHN_PB_FLI_Result::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_PB_FLI_RESULT;
}


midw_ext_fi_tcl_PHN_PB_FLI_Result::~midw_ext_fi_tcl_PHN_PB_FLI_Result()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_PB_FLI_Result::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItemList.size(); ++u32ListIdx)
      u32DynamicSize += oItemList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_PB_FLI_Result::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
      {
         oItemList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_PB_FLI_Result::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         (tVoid) (oOut << oItemList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_PB_FLI_Result::operator==(const midw_ext_fi_tcl_PHN_PB_FLI_Result& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItemList.size() == roRef.oItemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItemList.size()); ++u32Idx)
            bResult = bResult && (oItemList[u32Idx] == roRef.oItemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_PB_FLI_Details_Result::midw_ext_fi_tcl_PHN_PB_FLI_Details_Result(const midw_ext_fi_tcl_PHN_PB_FLI_Details_Result& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32Position = coRef.u32Position;
   sPbName = coRef.sPbName;
   sFliName = coRef.sFliName;
   u8TelNmbQuantity = coRef.u8TelNmbQuantity;
   oItemList = coRef.oItemList;
}
midw_ext_fi_tcl_PHN_PB_FLI_Details_Result& midw_ext_fi_tcl_PHN_PB_FLI_Details_Result::operator=(const midw_ext_fi_tcl_PHN_PB_FLI_Details_Result& coRef)
{
   if (this == &coRef) return *this;
   u32Position = coRef.u32Position;
   sPbName = coRef.sPbName;
   sFliName = coRef.sFliName;
   u8TelNmbQuantity = coRef.u8TelNmbQuantity;
   oItemList = coRef.oItemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_PB_FLI_Details_Result::vDestroy()
{
   sPbName.vDestroy();
   sFliName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         oItemList[u32Idx].vDestroy();
   oItemList.clear();
   }
}

midw_ext_fi_tcl_PHN_PB_FLI_Details_Result::midw_ext_fi_tcl_PHN_PB_FLI_Details_Result()
:u32Position(0)
,sPbName()
,sFliName()
,u8TelNmbQuantity(0)

 {}

tS32 midw_ext_fi_tcl_PHN_PB_FLI_Details_Result::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_PB_FLI_DETAILS_RESULT;
}


midw_ext_fi_tcl_PHN_PB_FLI_Details_Result::~midw_ext_fi_tcl_PHN_PB_FLI_Details_Result()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_PB_FLI_Details_Result::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItemList.size(); ++u32ListIdx)
      u32DynamicSize += oItemList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9+sPbName.u32GetSize(u16MajorVersion)+sFliName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_PB_FLI_Details_Result::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> sPbName);
   (tVoid) (oIn >> sFliName);
   (tVoid) (oIn >> u8TelNmbQuantity);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
      {
         oItemList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_PB_FLI_Details_Result::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << sPbName);
   (tVoid) (oOut << sFliName);
   (tVoid) (oOut << u8TelNmbQuantity);
   (tVoid) (oOut << (tU32)oItemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItemList.size(); ++u32Idx)
         (tVoid) (oOut << oItemList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_PB_FLI_Details_Result::operator==(const midw_ext_fi_tcl_PHN_PB_FLI_Details_Result& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (sPbName == roRef.sPbName);
   bResult = bResult && (sFliName == roRef.sFliName);
   bResult = bResult && (u8TelNmbQuantity == roRef.u8TelNmbQuantity);
      bResult = bResult && (oItemList.size() == roRef.oItemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItemList.size()); ++u32Idx)
            bResult = bResult && (oItemList[u32Idx] == roRef.oItemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM::midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM(const midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sPbName = coRef.sPbName;
   sPbNumber = coRef.sPbNumber;
   bEntryExists = coRef.bEntryExists;
}
midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM& midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM::operator=(const midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM& coRef)
{
   if (this == &coRef) return *this;
   sPbName = coRef.sPbName;
   sPbNumber = coRef.sPbNumber;
   bEntryExists = coRef.bEntryExists;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM::vDestroy()
{
   sPbName.vDestroy();
   sPbNumber.vDestroy();
}

midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM::midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM()
:sPbName()
,sPbNumber()
,bEntryExists(0)
 {}

tS32 midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_PB_ENTRIES_CHECK_ITEM;
}


midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM::~midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sPbName.u32GetSize(u16MajorVersion)+sPbNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPbName);
   (tVoid) (oIn >> sPbNumber);
   (tVoid) (oIn >> bEntryExists);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPbName);
   (tVoid) (oOut << sPbNumber);
   (tVoid) (oOut << bEntryExists);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM::operator==(const midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPbName == roRef.sPbName);
   bResult = bResult && (sPbNumber == roRef.sPbNumber);
   bResult = bResult && (bEntryExists == roRef.bEntryExists);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM::midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM(const midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32PbNameId = coRef.u32PbNameId;
   sPbName = coRef.sPbName;
   u32PbNumberId = coRef.u32PbNumberId;
   sPbNumber = coRef.sPbNumber;
}
midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM& midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM::operator=(const midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM& coRef)
{
   if (this == &coRef) return *this;
   u32PbNameId = coRef.u32PbNameId;
   sPbName = coRef.sPbName;
   u32PbNumberId = coRef.u32PbNumberId;
   sPbNumber = coRef.sPbNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM::vDestroy()
{
   sPbName.vDestroy();
   sPbNumber.vDestroy();
}

midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM::midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM()
:u32PbNameId(0)
,sPbName()
,u32PbNumberId(0)
,sPbNumber()
 {}

tS32 midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_PB_TELEPHONE_NUMBER_ITEM;
}


midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM::~midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+sPbName.u32GetSize(u16MajorVersion)+sPbNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32PbNameId);
   (tVoid) (oIn >> sPbName);
   (tVoid) (oIn >> u32PbNumberId);
   (tVoid) (oIn >> sPbNumber);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32PbNameId);
   (tVoid) (oOut << sPbName);
   (tVoid) (oOut << u32PbNumberId);
   (tVoid) (oOut << sPbNumber);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM::operator==(const midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32PbNameId == roRef.u32PbNameId);
   bResult = bResult && (sPbName == roRef.sPbName);
   bResult = bResult && (u32PbNumberId == roRef.u32PbNumberId);
   bResult = bResult && (sPbNumber == roRef.sPbNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult::midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   eBAPMethodResult = coRef.eBAPMethodResult;
   bMatchFound = coRef.bMatchFound;
   SearchSpellerResult = coRef.SearchSpellerResult;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult& coRef)
{
   if (this == &coRef) return *this;
   eBAPMethodResult = coRef.eBAPMethodResult;
   bMatchFound = coRef.bMatchFound;
   SearchSpellerResult = coRef.SearchSpellerResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult::vDestroy()
{
   SearchSpellerResult.vDestroy(); 
}

midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult::midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult()
:eBAPMethodResult()
,bMatchFound(0)
,SearchSpellerResult()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PB_PBSPELLERRESULT;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult::~midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+SearchSpellerResult.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eBAPMethodResult);
   (tVoid) (oIn >> bMatchFound);
   (tVoid) (oIn >> SearchSpellerResult);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eBAPMethodResult);
   (tVoid) (oOut << bMatchFound);
   (tVoid) (oOut << SearchSpellerResult);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eBAPMethodResult == roRef.eBAPMethodResult);
   bResult = bResult && (bMatchFound == roRef.bMatchFound);
   bResult = bResult && (SearchSpellerResult == roRef.SearchSpellerResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_SearchDir::midw_ext_fi_tcl_e8_PHN_VAG_SearchDir():enType(FI_EN_ENUNDEFINED) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_SearchDir::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_SEARCHDIR;
}


midw_ext_fi_tcl_e8_PHN_VAG_SearchDir::~midw_ext_fi_tcl_e8_PHN_VAG_SearchDir()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_SearchDir::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_SearchDir::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_SearchDir::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult::midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult():enType(FI_EN_PHN_VAG_QUICKSEARCH_NOTHING_FOUND) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_QUICKSEARCHRESULT;
}


midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult::~midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult::midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   eBAPMethodResult = coRef.eBAPMethodResult;
   u32ListID = coRef.u32ListID;
   eSearchResult = coRef.eSearchResult;
   u32ListIndex = coRef.u32ListIndex;
}
midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult& midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult::operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult& coRef)
{
   if (this == &coRef) return *this;
   eBAPMethodResult = coRef.eBAPMethodResult;
   u32ListID = coRef.u32ListID;
   eSearchResult = coRef.eSearchResult;
   u32ListIndex = coRef.u32ListIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult::midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult()
:eBAPMethodResult()
,u32ListID(0)
,eSearchResult()
,u32ListIndex(0)
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_BAP_PB_QUICKSEARCHRESULT;
}


midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult::~midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eBAPMethodResult);
   (tVoid) (oIn >> u32ListID);
   (tVoid) (oIn >> eSearchResult);
   (tVoid) (oIn >> u32ListIndex);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eBAPMethodResult);
   (tVoid) (oOut << u32ListID);
   (tVoid) (oOut << eSearchResult);
   (tVoid) (oOut << u32ListIndex);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult::operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eBAPMethodResult == roRef.eBAPMethodResult);
   bResult = bResult && (u32ListID == roRef.u32ListID);
   bResult = bResult && (eSearchResult == roRef.eSearchResult);
   bResult = bResult && (u32ListIndex == roRef.u32ListIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State::midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State():enType(FI_EN_PHN_VAG_DIAG_MUTE_STATE_NOT_DETECTED) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_DIAG_MUTE_STATE;
}


midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State::~midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason::midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason():enType(FI_EN_PHN_VAG_DIAG_CAN_MUTE_REASON_PHONE_CALL) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_DIAG_CAN_MUTE_REASON;
}


midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason::~midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication::midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication(const midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8MutePinMuteState = coRef.e8MutePinMuteState;
   e8CANMuteState = coRef.e8CANMuteState;
   e8CANMuteReason = coRef.e8CANMuteReason;
}
midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication& midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication::operator=(const midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication& coRef)
{
   if (this == &coRef) return *this;
   e8MutePinMuteState = coRef.e8MutePinMuteState;
   e8CANMuteState = coRef.e8CANMuteState;
   e8CANMuteReason = coRef.e8CANMuteReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication::midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication()
:e8MutePinMuteState()
,e8CANMuteState()
,e8CANMuteReason()
 {}

tS32 midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PHN_VAG_AUDIOMUTEINDICATION;
}


midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication::~midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication()
{}

tU32 midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MutePinMuteState);
   (tVoid) (oIn >> e8CANMuteState);
   (tVoid) (oIn >> e8CANMuteReason);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MutePinMuteState);
   (tVoid) (oOut << e8CANMuteState);
   (tVoid) (oOut << e8CANMuteReason);
   return oOut;
}

tBool midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication::operator==(const midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MutePinMuteState == roRef.e8MutePinMuteState);
   bResult = bResult && (e8CANMuteState == roRef.e8CANMuteState);
   bResult = bResult && (e8CANMuteReason == roRef.e8CANMuteReason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS::midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS():enType(FI_EN_PHN_VAG_DIAG_MIC_CONN_OPEN) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_MIC_CONN_STATUS;
}


midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS::~midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS::midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS():enType(FI_EN_PHN_VAG_BT_SETUP_STATUS_ACTIVE) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_BT_SETUP_STATUS;
}


midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS::~midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason::midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason():enType(FI_EN_PHN_VAG_HMI_AUDIO_CAN_MUTE_REASON_PHONE_CALL) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_HMI_AUDIO_CAN_MUTE_REASON;
}


midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason::~midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action::midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action():enType(FI_EN_PHN_VAG_HMI_AUDIO_MUTE_STOP) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_HMI_AUDIO_MUTE_ACTION;
}


midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action::~midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource::midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource():enType(FI_EN_PHN_VAG_AUDIO_MUTE_TEL_SOURCE_AUX_UHV) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_AUDIOMUTE_TELEPHONESOURCE;
}


midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource::~midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_GAIN_SETTING::midw_ext_fi_tcl_e8_PHN_GAIN_SETTING():enType(FI_EN_PHN_GAIN_SETTING_LOW) {}

tS32 midw_ext_fi_tcl_e8_PHN_GAIN_SETTING::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_GAIN_SETTING;
}


midw_ext_fi_tcl_e8_PHN_GAIN_SETTING::~midw_ext_fi_tcl_e8_PHN_GAIN_SETTING()
{}

tU32 midw_ext_fi_tcl_e8_PHN_GAIN_SETTING::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_GAIN_SETTING::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_GAIN_SETTING::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER::midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER():enType(FI_EN_PHN_VAG_PB_SORTING_FIRST_NAME) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_PB_SORTING_ORDER;
}


midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER::~midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER::midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER():enType(FI_EN_PHN_VAG_PB_SOURCE_SIM_AND_ME) {}

tS32 midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_VAG_PB_SOURCE_FILTER;
}


midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER::~midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER()
{}

tU32 midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS::midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS():enType(FI_EN_PHN_BATTERY_RANGE_0) {}

tS32 midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_BATTERY_STATUS;
}


midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS::~midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS()
{}

tU32 midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_TX_MODE_SET::midw_ext_fi_tcl_e8_PHN_TX_MODE_SET():enType(FI_EN_PHN_TX_MODE_1) {}

tS32 midw_ext_fi_tcl_e8_PHN_TX_MODE_SET::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_TX_MODE_SET;
}


midw_ext_fi_tcl_e8_PHN_TX_MODE_SET::~midw_ext_fi_tcl_e8_PHN_TX_MODE_SET()
{}

tU32 midw_ext_fi_tcl_e8_PHN_TX_MODE_SET::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_TX_MODE_SET::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_TX_MODE_SET::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH::midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH():enType(FI_EN_PHN_TX_SLOT_LENGTH_DH5) {}

tS32 midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_TX_SLOT_LENGTH;
}


midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH::~midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH()
{}

tU32 midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE::midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE():enType(FI_EN_PHN_LOCAL_BT_DEVICE_UNKNOWN_MODE) {}

tS32 midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_PHN_LOCAL_BT_DEVICE_MODE;
}


midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE::~midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE()
{}

tU32 midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_UnitType::midw_ext_fi_tcl_e8_Meter_UnitType():enType(FI_EN_AUDIO) {}

tS32 midw_ext_fi_tcl_e8_Meter_UnitType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_UNITTYPE;
}


midw_ext_fi_tcl_e8_Meter_UnitType::~midw_ext_fi_tcl_e8_Meter_UnitType()
{}

tU32 midw_ext_fi_tcl_e8_Meter_UnitType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_UnitType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_UnitType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_ConfigurationStatus::midw_ext_fi_tcl_e8_Meter_ConfigurationStatus():enType(FI_EN_UNDEFINED) {}

tS32 midw_ext_fi_tcl_e8_Meter_ConfigurationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_CONFIGURATIONSTATUS;
}


midw_ext_fi_tcl_e8_Meter_ConfigurationStatus::~midw_ext_fi_tcl_e8_Meter_ConfigurationStatus()
{}

tU32 midw_ext_fi_tcl_e8_Meter_ConfigurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_ConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_ConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_VersionInfo::midw_ext_fi_tcl_Meter_VersionInfo(const midw_ext_fi_tcl_Meter_VersionInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Upper = coRef.u8Upper;
   u8Mid = coRef.u8Mid;
   u8Lower = coRef.u8Lower;
}
midw_ext_fi_tcl_Meter_VersionInfo& midw_ext_fi_tcl_Meter_VersionInfo::operator=(const midw_ext_fi_tcl_Meter_VersionInfo& coRef)
{
   if (this == &coRef) return *this;
   u8Upper = coRef.u8Upper;
   u8Mid = coRef.u8Mid;
   u8Lower = coRef.u8Lower;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_Meter_VersionInfo::midw_ext_fi_tcl_Meter_VersionInfo()
:u8Upper(0)
,u8Mid(0)
,u8Lower(0)
 {}

tS32 midw_ext_fi_tcl_Meter_VersionInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_VERSIONINFO;
}


midw_ext_fi_tcl_Meter_VersionInfo::~midw_ext_fi_tcl_Meter_VersionInfo()
{}

tU32 midw_ext_fi_tcl_Meter_VersionInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_Meter_VersionInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Upper);
   (tVoid) (oIn >> u8Mid);
   (tVoid) (oIn >> u8Lower);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_VersionInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Upper);
   (tVoid) (oOut << u8Mid);
   (tVoid) (oOut << u8Lower);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_VersionInfo::operator==(const midw_ext_fi_tcl_Meter_VersionInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Upper == roRef.u8Upper);
   bResult = bResult && (u8Mid == roRef.u8Mid);
   bResult = bResult && (u8Lower == roRef.u8Lower);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_UnitConnectionStatus::midw_ext_fi_tcl_Meter_UnitConnectionStatus(const midw_ext_fi_tcl_Meter_UnitConnectionStatus& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8UnitType = coRef.e8UnitType;
   bConnected = coRef.bConnected;
   u8AbsenceState = coRef.u8AbsenceState;
   u8MuteState = coRef.u8MuteState;
}
midw_ext_fi_tcl_Meter_UnitConnectionStatus& midw_ext_fi_tcl_Meter_UnitConnectionStatus::operator=(const midw_ext_fi_tcl_Meter_UnitConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   e8UnitType = coRef.e8UnitType;
   bConnected = coRef.bConnected;
   u8AbsenceState = coRef.u8AbsenceState;
   u8MuteState = coRef.u8MuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_Meter_UnitConnectionStatus::midw_ext_fi_tcl_Meter_UnitConnectionStatus()
:e8UnitType()
,bConnected(0)
,u8AbsenceState(0)
,u8MuteState(0)
 {}

tS32 midw_ext_fi_tcl_Meter_UnitConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_UNITCONNECTIONSTATUS;
}


midw_ext_fi_tcl_Meter_UnitConnectionStatus::~midw_ext_fi_tcl_Meter_UnitConnectionStatus()
{}

tU32 midw_ext_fi_tcl_Meter_UnitConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_Meter_UnitConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8UnitType);
   (tVoid) (oIn >> bConnected);
   (tVoid) (oIn >> u8AbsenceState);
   (tVoid) (oIn >> u8MuteState);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_UnitConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8UnitType);
   (tVoid) (oOut << bConnected);
   (tVoid) (oOut << u8AbsenceState);
   (tVoid) (oOut << u8MuteState);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_UnitConnectionStatus::operator==(const midw_ext_fi_tcl_Meter_UnitConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8UnitType == roRef.e8UnitType);
   bResult = bResult && (bConnected == roRef.bConnected);
   bResult = bResult && (u8AbsenceState == roRef.u8AbsenceState);
   bResult = bResult && (u8MuteState == roRef.u8MuteState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_UnitConfiguration::midw_ext_fi_tcl_Meter_UnitConfiguration(const midw_ext_fi_tcl_Meter_UnitConfiguration& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8UnitType = coRef.e8UnitType;
   e8ConfigurationStatus = coRef.e8ConfigurationStatus;
   u8UnitId = coRef.u8UnitId;
   rMessageVersion = coRef.rMessageVersion;
}
midw_ext_fi_tcl_Meter_UnitConfiguration& midw_ext_fi_tcl_Meter_UnitConfiguration::operator=(const midw_ext_fi_tcl_Meter_UnitConfiguration& coRef)
{
   if (this == &coRef) return *this;
   e8UnitType = coRef.e8UnitType;
   e8ConfigurationStatus = coRef.e8ConfigurationStatus;
   u8UnitId = coRef.u8UnitId;
   rMessageVersion = coRef.rMessageVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_Meter_UnitConfiguration::midw_ext_fi_tcl_Meter_UnitConfiguration()
:e8UnitType()
,e8ConfigurationStatus()
,u8UnitId(0)
,rMessageVersion()
 {}

tS32 midw_ext_fi_tcl_Meter_UnitConfiguration::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_UNITCONFIGURATION;
}


midw_ext_fi_tcl_Meter_UnitConfiguration::~midw_ext_fi_tcl_Meter_UnitConfiguration()
{}

tU32 midw_ext_fi_tcl_Meter_UnitConfiguration::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_fi_tcl_Meter_UnitConfiguration::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8UnitType);
   (tVoid) (oIn >> e8ConfigurationStatus);
   (tVoid) (oIn >> u8UnitId);
   (tVoid) (oIn >> rMessageVersion);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_UnitConfiguration::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8UnitType);
   (tVoid) (oOut << e8ConfigurationStatus);
   (tVoid) (oOut << u8UnitId);
   (tVoid) (oOut << rMessageVersion);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_UnitConfiguration::operator==(const midw_ext_fi_tcl_Meter_UnitConfiguration& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8UnitType == roRef.e8UnitType);
   bResult = bResult && (e8ConfigurationStatus == roRef.e8ConfigurationStatus);
   bResult = bResult && (u8UnitId == roRef.u8UnitId);
   bResult = bResult && (rMessageVersion == roRef.rMessageVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_UnitVersion::midw_ext_fi_tcl_Meter_UnitVersion(const midw_ext_fi_tcl_Meter_UnitVersion& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8UnitType = coRef.e8UnitType;
   rVersion = coRef.rVersion;
}
midw_ext_fi_tcl_Meter_UnitVersion& midw_ext_fi_tcl_Meter_UnitVersion::operator=(const midw_ext_fi_tcl_Meter_UnitVersion& coRef)
{
   if (this == &coRef) return *this;
   e8UnitType = coRef.e8UnitType;
   rVersion = coRef.rVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_Meter_UnitVersion::midw_ext_fi_tcl_Meter_UnitVersion()
:e8UnitType()
,rVersion()
 {}

tS32 midw_ext_fi_tcl_Meter_UnitVersion::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_UNITVERSION;
}


midw_ext_fi_tcl_Meter_UnitVersion::~midw_ext_fi_tcl_Meter_UnitVersion()
{}

tU32 midw_ext_fi_tcl_Meter_UnitVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_Meter_UnitVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8UnitType);
   (tVoid) (oIn >> rVersion);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_UnitVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8UnitType);
   (tVoid) (oOut << rVersion);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_UnitVersion::operator==(const midw_ext_fi_tcl_Meter_UnitVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8UnitType == roRef.e8UnitType);
   bResult = bResult && (rVersion == roRef.rVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus::midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus(const midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8UnitType = coRef.e8UnitType;
   u8MPDTMuteState = coRef.u8MPDTMuteState;
}
midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus& midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus::operator=(const midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus& coRef)
{
   if (this == &coRef) return *this;
   e8UnitType = coRef.e8UnitType;
   u8MPDTMuteState = coRef.u8MPDTMuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus::midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus()
:e8UnitType()
,u8MPDTMuteState(0)
 {}

tS32 midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_UNITDATATRANSMISSIONSTATUS;
}


midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus::~midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus()
{}

tU32 midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8UnitType);
   (tVoid) (oIn >> u8MPDTMuteState);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8UnitType);
   (tVoid) (oOut << u8MPDTMuteState);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus::operator==(const midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8UnitType == roRef.e8UnitType);
   bResult = bResult && (u8MPDTMuteState == roRef.u8MPDTMuteState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Language::midw_ext_fi_tcl_e8_Meter_Language():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_Language::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_LANGUAGE;
}


midw_ext_fi_tcl_e8_Meter_Language::~midw_ext_fi_tcl_e8_Meter_Language()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Language::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Language::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Language::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Language_Action::midw_ext_fi_tcl_e8_Meter_Language_Action():enType(FI_EN_INVALID_ACTION) {}

tS32 midw_ext_fi_tcl_e8_Meter_Language_Action::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_LANGUAGE_ACTION;
}


midw_ext_fi_tcl_e8_Meter_Language_Action::~midw_ext_fi_tcl_e8_Meter_Language_Action()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Language_Action::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Language_Action::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Language_Action::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type::midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type():enType(FI_EN_NOT_AVAILABLE) {}

tS32 midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_LANG_SYNC_MODE_TYPE;
}


midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type::~midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type()
{}

tU32 midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Language_Status::midw_ext_fi_tcl_e8_Meter_Language_Status():enType(FI_EN_UNAVAILABLE) {}

tS32 midw_ext_fi_tcl_e8_Meter_Language_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_LANGUAGE_STATUS;
}


midw_ext_fi_tcl_e8_Meter_Language_Status::~midw_ext_fi_tcl_e8_Meter_Language_Status()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Language_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Language_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Language_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult::midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult():enType(FI_EN_INVALID_PARAMETER) {}

tS32 midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_REQUESTEDLANGUAGERESULT;
}


midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult::~midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult()
{}

tU32 midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_DistanceUnit::midw_ext_fi_tcl_e8_Meter_DistanceUnit():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_DistanceUnit::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_DISTANCEUNIT;
}


midw_ext_fi_tcl_e8_Meter_DistanceUnit::~midw_ext_fi_tcl_e8_Meter_DistanceUnit()
{}

tU32 midw_ext_fi_tcl_e8_Meter_DistanceUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_DistanceUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_DistanceUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit::midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_FUELCONSUMPTIONUNIT;
}


midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit::~midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit()
{}

tU32 midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_TemperatureUnit::midw_ext_fi_tcl_e8_Meter_TemperatureUnit():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_TemperatureUnit::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_TEMPERATUREUNIT;
}


midw_ext_fi_tcl_e8_Meter_TemperatureUnit::~midw_ext_fi_tcl_e8_Meter_TemperatureUnit()
{}

tU32 midw_ext_fi_tcl_e8_Meter_TemperatureUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_TemperatureUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_TemperatureUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_PressureUnit::midw_ext_fi_tcl_e8_Meter_PressureUnit():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_PressureUnit::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_PRESSUREUNIT;
}


midw_ext_fi_tcl_e8_Meter_PressureUnit::~midw_ext_fi_tcl_e8_Meter_PressureUnit()
{}

tU32 midw_ext_fi_tcl_e8_Meter_PressureUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_PressureUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_PressureUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

midw_ext_fi_tcl_Meter_Audio_NoData::midw_ext_fi_tcl_Meter_Audio_NoData()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_NoData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_NODATA;
}


midw_ext_fi_tcl_Meter_Audio_NoData::~midw_ext_fi_tcl_Meter_Audio_NoData()
{}

tU32 midw_ext_fi_tcl_Meter_Audio_NoData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_NoData::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_NoData::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_RadioSource::midw_ext_fi_tcl_e8_Meter_Audio_RadioSource():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_RadioSource::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_RADIOSOURCE;
}


midw_ext_fi_tcl_e8_Meter_Audio_RadioSource::~midw_ext_fi_tcl_e8_Meter_Audio_RadioSource()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_RadioSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_RadioSource::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_RadioSource::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate::midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate():enType(FI_EN_NOT_UPDATED) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_HDRADIOSOURCEINFOUPDATE;
}


midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate::~midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName::midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName():enType(FI_EN_FM_HD) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_HDRADIOSOURCEINFONAME;
}


midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName::~midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource::midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource(const midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8Update = coRef.e8Update;
   e8Name = coRef.e8Name;
}
midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource& midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource::operator=(const midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource& coRef)
{
   if (this == &coRef) return *this;
   e8Update = coRef.e8Update;
   e8Name = coRef.e8Name;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource::midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource()
:e8Update()
,e8Name()
 {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_HDRADIOSOURCE;
}


midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource::~midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Update);
   (tVoid) (oIn >> e8Name);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Update);
   (tVoid) (oOut << e8Name);
   return oOut;
}

tBool midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource::operator==(const midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Update == roRef.e8Update);
   bResult = bResult && (e8Name == roRef.e8Name);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType::midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_RADIOLABELTYPE;
}


midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType::~midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_RadioLabel::midw_ext_fi_tcl_Meter_Audio_RadioLabel(const midw_ext_fi_tcl_Meter_Audio_RadioLabel& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8Type = coRef.e8Type;
   u8Id = coRef.u8Id;
}
midw_ext_fi_tcl_Meter_Audio_RadioLabel& midw_ext_fi_tcl_Meter_Audio_RadioLabel::operator=(const midw_ext_fi_tcl_Meter_Audio_RadioLabel& coRef)
{
   if (this == &coRef) return *this;
   e8Type = coRef.e8Type;
   u8Id = coRef.u8Id;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_Meter_Audio_RadioLabel::midw_ext_fi_tcl_Meter_Audio_RadioLabel()
:e8Type()
,u8Id(0)
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_RadioLabel::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_RADIOLABEL;
}


midw_ext_fi_tcl_Meter_Audio_RadioLabel::~midw_ext_fi_tcl_Meter_Audio_RadioLabel()
{}

tU32 midw_ext_fi_tcl_Meter_Audio_RadioLabel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_RadioLabel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Type);
   (tVoid) (oIn >> u8Id);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_RadioLabel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Type);
   (tVoid) (oOut << u8Id);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_RadioLabel::operator==(const midw_ext_fi_tcl_Meter_Audio_RadioLabel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Type == roRef.e8Type);
   bResult = bResult && (u8Id == roRef.u8Id);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit::midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_RADIOFREQUENCYUNIT;
}


midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit::~midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_RadioFrequency::midw_ext_fi_tcl_Meter_Audio_RadioFrequency(const midw_ext_fi_tcl_Meter_Audio_RadioFrequency& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Thousands = coRef.u8Thousands;
   u8Hundreds = coRef.u8Hundreds;
   u8Tens = coRef.u8Tens;
   u8Ones = coRef.u8Ones;
   bShowDecimalPoint = coRef.bShowDecimalPoint;
   u8Tenths = coRef.u8Tenths;
   u8Hundredths = coRef.u8Hundredths;
   e8Unit = coRef.e8Unit;
}
midw_ext_fi_tcl_Meter_Audio_RadioFrequency& midw_ext_fi_tcl_Meter_Audio_RadioFrequency::operator=(const midw_ext_fi_tcl_Meter_Audio_RadioFrequency& coRef)
{
   if (this == &coRef) return *this;
   u8Thousands = coRef.u8Thousands;
   u8Hundreds = coRef.u8Hundreds;
   u8Tens = coRef.u8Tens;
   u8Ones = coRef.u8Ones;
   bShowDecimalPoint = coRef.bShowDecimalPoint;
   u8Tenths = coRef.u8Tenths;
   u8Hundredths = coRef.u8Hundredths;
   e8Unit = coRef.e8Unit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_Meter_Audio_RadioFrequency::midw_ext_fi_tcl_Meter_Audio_RadioFrequency()
:u8Thousands(0)
,u8Hundreds(0)
,u8Tens(0)
,u8Ones(0)
,bShowDecimalPoint(0)
,u8Tenths(0)
,u8Hundredths(0)
,e8Unit()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_RadioFrequency::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_RADIOFREQUENCY;
}


midw_ext_fi_tcl_Meter_Audio_RadioFrequency::~midw_ext_fi_tcl_Meter_Audio_RadioFrequency()
{}

tU32 midw_ext_fi_tcl_Meter_Audio_RadioFrequency::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_RadioFrequency::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Thousands);
   (tVoid) (oIn >> u8Hundreds);
   (tVoid) (oIn >> u8Tens);
   (tVoid) (oIn >> u8Ones);
   (tVoid) (oIn >> bShowDecimalPoint);
   (tVoid) (oIn >> u8Tenths);
   (tVoid) (oIn >> u8Hundredths);
   (tVoid) (oIn >> e8Unit);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_RadioFrequency::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Thousands);
   (tVoid) (oOut << u8Hundreds);
   (tVoid) (oOut << u8Tens);
   (tVoid) (oOut << u8Ones);
   (tVoid) (oOut << bShowDecimalPoint);
   (tVoid) (oOut << u8Tenths);
   (tVoid) (oOut << u8Hundredths);
   (tVoid) (oOut << e8Unit);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_RadioFrequency::operator==(const midw_ext_fi_tcl_Meter_Audio_RadioFrequency& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Thousands == roRef.u8Thousands);
   bResult = bResult && (u8Hundreds == roRef.u8Hundreds);
   bResult = bResult && (u8Tens == roRef.u8Tens);
   bResult = bResult && (u8Ones == roRef.u8Ones);
   bResult = bResult && (bShowDecimalPoint == roRef.bShowDecimalPoint);
   bResult = bResult && (u8Tenths == roRef.u8Tenths);
   bResult = bResult && (u8Hundredths == roRef.u8Hundredths);
   bResult = bResult && (e8Unit == roRef.e8Unit);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType::midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_RADIOCATEGORYTYPE;
}


midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType::~midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_RadioCategory::midw_ext_fi_tcl_Meter_Audio_RadioCategory(const midw_ext_fi_tcl_Meter_Audio_RadioCategory& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8Type = coRef.e8Type;
   strCategoryName = coRef.strCategoryName;
}
midw_ext_fi_tcl_Meter_Audio_RadioCategory& midw_ext_fi_tcl_Meter_Audio_RadioCategory::operator=(const midw_ext_fi_tcl_Meter_Audio_RadioCategory& coRef)
{
   if (this == &coRef) return *this;
   e8Type = coRef.e8Type;
   strCategoryName = coRef.strCategoryName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_Meter_Audio_RadioCategory::vDestroy()
{
   strCategoryName.vDestroy();
}

midw_ext_fi_tcl_Meter_Audio_RadioCategory::midw_ext_fi_tcl_Meter_Audio_RadioCategory()
:e8Type()
,strCategoryName()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_RadioCategory::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_RADIOCATEGORY;
}


midw_ext_fi_tcl_Meter_Audio_RadioCategory::~midw_ext_fi_tcl_Meter_Audio_RadioCategory()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_Meter_Audio_RadioCategory::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+strCategoryName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_RadioCategory::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Type);
   (tVoid) (oIn >> strCategoryName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_RadioCategory::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Type);
   (tVoid) (oOut << strCategoryName);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_RadioCategory::operator==(const midw_ext_fi_tcl_Meter_Audio_RadioCategory& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Type == roRef.e8Type);
   bResult = bResult && (strCategoryName == roRef.strCategoryName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_RadioData::midw_ext_fi_tcl_Meter_Audio_RadioData(const midw_ext_fi_tcl_Meter_Audio_RadioData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8RadioSource = coRef.e8RadioSource;
   rLabel = coRef.rLabel;
   rFrequency = coRef.rFrequency;
   rCategory = coRef.rCategory;
   strStationName = coRef.strStationName;
}
midw_ext_fi_tcl_Meter_Audio_RadioData& midw_ext_fi_tcl_Meter_Audio_RadioData::operator=(const midw_ext_fi_tcl_Meter_Audio_RadioData& coRef)
{
   if (this == &coRef) return *this;
   e8RadioSource = coRef.e8RadioSource;
   rLabel = coRef.rLabel;
   rFrequency = coRef.rFrequency;
   rCategory = coRef.rCategory;
   strStationName = coRef.strStationName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_Meter_Audio_RadioData::vDestroy()
{
   rLabel.vDestroy(); 
   rFrequency.vDestroy(); 
   rCategory.vDestroy(); 
   strStationName.vDestroy();
}

midw_ext_fi_tcl_Meter_Audio_RadioData::midw_ext_fi_tcl_Meter_Audio_RadioData()
:e8RadioSource()
,rLabel()
,rFrequency()
,rCategory()
,strStationName()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_RadioData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_RADIODATA;
}


midw_ext_fi_tcl_Meter_Audio_RadioData::~midw_ext_fi_tcl_Meter_Audio_RadioData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_Meter_Audio_RadioData::u32GetSize(tU16 u16MajorVersion) const
{
   return 11+rCategory.u32GetSize(u16MajorVersion)+strStationName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_RadioData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RadioSource);
   (tVoid) (oIn >> rLabel);
   (tVoid) (oIn >> rFrequency);
   (tVoid) (oIn >> rCategory);
   (tVoid) (oIn >> strStationName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_RadioData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RadioSource);
   (tVoid) (oOut << rLabel);
   (tVoid) (oOut << rFrequency);
   (tVoid) (oOut << rCategory);
   (tVoid) (oOut << strStationName);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_RadioData::operator==(const midw_ext_fi_tcl_Meter_Audio_RadioData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RadioSource == roRef.e8RadioSource);
   bResult = bResult && (rLabel == roRef.rLabel);
   bResult = bResult && (rFrequency == roRef.rFrequency);
   bResult = bResult && (rCategory == roRef.rCategory);
   bResult = bResult && (strStationName == roRef.strStationName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_HDRadioData::midw_ext_fi_tcl_Meter_Audio_HDRadioData(const midw_ext_fi_tcl_Meter_Audio_HDRadioData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8RadioSource = coRef.e8RadioSource;
   rLabel = coRef.rLabel;
   rFrequency = coRef.rFrequency;
   rCategory = coRef.rCategory;
   strStationName = coRef.strStationName;
   u8MulticastChannel = coRef.u8MulticastChannel;
   strArtistName = coRef.strArtistName;
   strSongName = coRef.strSongName;
}
midw_ext_fi_tcl_Meter_Audio_HDRadioData& midw_ext_fi_tcl_Meter_Audio_HDRadioData::operator=(const midw_ext_fi_tcl_Meter_Audio_HDRadioData& coRef)
{
   if (this == &coRef) return *this;
   e8RadioSource = coRef.e8RadioSource;
   rLabel = coRef.rLabel;
   rFrequency = coRef.rFrequency;
   rCategory = coRef.rCategory;
   strStationName = coRef.strStationName;
   u8MulticastChannel = coRef.u8MulticastChannel;
   strArtistName = coRef.strArtistName;
   strSongName = coRef.strSongName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_Meter_Audio_HDRadioData::vDestroy()
{
   e8RadioSource.vDestroy(); 
   rLabel.vDestroy(); 
   rFrequency.vDestroy(); 
   rCategory.vDestroy(); 
   strStationName.vDestroy();
   strArtistName.vDestroy();
   strSongName.vDestroy();
}

midw_ext_fi_tcl_Meter_Audio_HDRadioData::midw_ext_fi_tcl_Meter_Audio_HDRadioData()
:e8RadioSource()
,rLabel()
,rFrequency()
,rCategory()
,strStationName()
,u8MulticastChannel(0)
,strArtistName()
,strSongName()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_HDRadioData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_HDRADIODATA;
}


midw_ext_fi_tcl_Meter_Audio_HDRadioData::~midw_ext_fi_tcl_Meter_Audio_HDRadioData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_Meter_Audio_HDRadioData::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+rCategory.u32GetSize(u16MajorVersion)+strStationName.u32GetSize(u16MajorVersion)+strArtistName.u32GetSize(u16MajorVersion)+strSongName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_HDRadioData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RadioSource);
   (tVoid) (oIn >> rLabel);
   (tVoid) (oIn >> rFrequency);
   (tVoid) (oIn >> rCategory);
   (tVoid) (oIn >> strStationName);
   (tVoid) (oIn >> u8MulticastChannel);
   (tVoid) (oIn >> strArtistName);
   (tVoid) (oIn >> strSongName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_HDRadioData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RadioSource);
   (tVoid) (oOut << rLabel);
   (tVoid) (oOut << rFrequency);
   (tVoid) (oOut << rCategory);
   (tVoid) (oOut << strStationName);
   (tVoid) (oOut << u8MulticastChannel);
   (tVoid) (oOut << strArtistName);
   (tVoid) (oOut << strSongName);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_HDRadioData::operator==(const midw_ext_fi_tcl_Meter_Audio_HDRadioData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RadioSource == roRef.e8RadioSource);
   bResult = bResult && (rLabel == roRef.rLabel);
   bResult = bResult && (rFrequency == roRef.rFrequency);
   bResult = bResult && (rCategory == roRef.rCategory);
   bResult = bResult && (strStationName == roRef.strStationName);
   bResult = bResult && (u8MulticastChannel == roRef.u8MulticastChannel);
   bResult = bResult && (strArtistName == roRef.strArtistName);
   bResult = bResult && (strSongName == roRef.strSongName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_MediaType::midw_ext_fi_tcl_e8_Meter_Audio_MediaType():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_MediaType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_MEDIATYPE;
}


midw_ext_fi_tcl_e8_Meter_Audio_MediaType::~midw_ext_fi_tcl_e8_Meter_Audio_MediaType()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_MediaType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_MediaType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_MediaType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType::midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_TRACKLABELTYPE;
}


midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType::~midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_TrackInfo::midw_ext_fi_tcl_Meter_Audio_TrackInfo(const midw_ext_fi_tcl_Meter_Audio_TrackInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8LabelType = coRef.e8LabelType;
   u32TrackNumber = coRef.u32TrackNumber;
   strTrackName = coRef.strTrackName;
}
midw_ext_fi_tcl_Meter_Audio_TrackInfo& midw_ext_fi_tcl_Meter_Audio_TrackInfo::operator=(const midw_ext_fi_tcl_Meter_Audio_TrackInfo& coRef)
{
   if (this == &coRef) return *this;
   e8LabelType = coRef.e8LabelType;
   u32TrackNumber = coRef.u32TrackNumber;
   strTrackName = coRef.strTrackName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_Meter_Audio_TrackInfo::vDestroy()
{
   strTrackName.vDestroy();
}

midw_ext_fi_tcl_Meter_Audio_TrackInfo::midw_ext_fi_tcl_Meter_Audio_TrackInfo()
:e8LabelType()
,u32TrackNumber(0)
,strTrackName()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_TrackInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_TRACKINFO;
}


midw_ext_fi_tcl_Meter_Audio_TrackInfo::~midw_ext_fi_tcl_Meter_Audio_TrackInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_Meter_Audio_TrackInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+strTrackName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_TrackInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LabelType);
   (tVoid) (oIn >> u32TrackNumber);
   (tVoid) (oIn >> strTrackName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_TrackInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LabelType);
   (tVoid) (oOut << u32TrackNumber);
   (tVoid) (oOut << strTrackName);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_TrackInfo::operator==(const midw_ext_fi_tcl_Meter_Audio_TrackInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LabelType == roRef.e8LabelType);
   bResult = bResult && (u32TrackNumber == roRef.u32TrackNumber);
   bResult = bResult && (strTrackName == roRef.strTrackName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType::midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_GROUPLABELTYPE;
}


midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType::~midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_GroupInfo::midw_ext_fi_tcl_Meter_Audio_GroupInfo(const midw_ext_fi_tcl_Meter_Audio_GroupInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8LabelType = coRef.e8LabelType;
   u16GroupNumber = coRef.u16GroupNumber;
   strGroupName = coRef.strGroupName;
}
midw_ext_fi_tcl_Meter_Audio_GroupInfo& midw_ext_fi_tcl_Meter_Audio_GroupInfo::operator=(const midw_ext_fi_tcl_Meter_Audio_GroupInfo& coRef)
{
   if (this == &coRef) return *this;
   e8LabelType = coRef.e8LabelType;
   u16GroupNumber = coRef.u16GroupNumber;
   strGroupName = coRef.strGroupName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_Meter_Audio_GroupInfo::vDestroy()
{
   strGroupName.vDestroy();
}

midw_ext_fi_tcl_Meter_Audio_GroupInfo::midw_ext_fi_tcl_Meter_Audio_GroupInfo()
:e8LabelType()
,u16GroupNumber(0)
,strGroupName()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_GroupInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_GROUPINFO;
}


midw_ext_fi_tcl_Meter_Audio_GroupInfo::~midw_ext_fi_tcl_Meter_Audio_GroupInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_Meter_Audio_GroupInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+strGroupName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_GroupInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LabelType);
   (tVoid) (oIn >> u16GroupNumber);
   (tVoid) (oIn >> strGroupName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_GroupInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LabelType);
   (tVoid) (oOut << u16GroupNumber);
   (tVoid) (oOut << strGroupName);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_GroupInfo::operator==(const midw_ext_fi_tcl_Meter_Audio_GroupInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LabelType == roRef.e8LabelType);
   bResult = bResult && (u16GroupNumber == roRef.u16GroupNumber);
   bResult = bResult && (strGroupName == roRef.strGroupName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType::midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_ARTISTLABELTYPE;
}


midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType::~midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_ArtistInfo::midw_ext_fi_tcl_Meter_Audio_ArtistInfo(const midw_ext_fi_tcl_Meter_Audio_ArtistInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8LabelType = coRef.e8LabelType;
   strArtistName = coRef.strArtistName;
}
midw_ext_fi_tcl_Meter_Audio_ArtistInfo& midw_ext_fi_tcl_Meter_Audio_ArtistInfo::operator=(const midw_ext_fi_tcl_Meter_Audio_ArtistInfo& coRef)
{
   if (this == &coRef) return *this;
   e8LabelType = coRef.e8LabelType;
   strArtistName = coRef.strArtistName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_Meter_Audio_ArtistInfo::vDestroy()
{
   strArtistName.vDestroy();
}

midw_ext_fi_tcl_Meter_Audio_ArtistInfo::midw_ext_fi_tcl_Meter_Audio_ArtistInfo()
:e8LabelType()
,strArtistName()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_ArtistInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_ARTISTINFO;
}


midw_ext_fi_tcl_Meter_Audio_ArtistInfo::~midw_ext_fi_tcl_Meter_Audio_ArtistInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_Meter_Audio_ArtistInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+strArtistName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_ArtistInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LabelType);
   (tVoid) (oIn >> strArtistName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_ArtistInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LabelType);
   (tVoid) (oOut << strArtistName);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_ArtistInfo::operator==(const midw_ext_fi_tcl_Meter_Audio_ArtistInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LabelType == roRef.e8LabelType);
   bResult = bResult && (strArtistName == roRef.strArtistName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_MediaData::midw_ext_fi_tcl_Meter_Audio_MediaData(const midw_ext_fi_tcl_Meter_Audio_MediaData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8MediaType = coRef.e8MediaType;
   rTrackInfo = coRef.rTrackInfo;
   rGroupInfo = coRef.rGroupInfo;
   rArtistInfo = coRef.rArtistInfo;
}
midw_ext_fi_tcl_Meter_Audio_MediaData& midw_ext_fi_tcl_Meter_Audio_MediaData::operator=(const midw_ext_fi_tcl_Meter_Audio_MediaData& coRef)
{
   if (this == &coRef) return *this;
   e8MediaType = coRef.e8MediaType;
   rTrackInfo = coRef.rTrackInfo;
   rGroupInfo = coRef.rGroupInfo;
   rArtistInfo = coRef.rArtistInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_Meter_Audio_MediaData::vDestroy()
{
   rTrackInfo.vDestroy(); 
   rGroupInfo.vDestroy(); 
   rArtistInfo.vDestroy(); 
}

midw_ext_fi_tcl_Meter_Audio_MediaData::midw_ext_fi_tcl_Meter_Audio_MediaData()
:e8MediaType()
,rTrackInfo()
,rGroupInfo()
,rArtistInfo()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_MediaData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_MEDIADATA;
}


midw_ext_fi_tcl_Meter_Audio_MediaData::~midw_ext_fi_tcl_Meter_Audio_MediaData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_Meter_Audio_MediaData::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+rTrackInfo.u32GetSize(u16MajorVersion)+rGroupInfo.u32GetSize(u16MajorVersion)+rArtistInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_MediaData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MediaType);
   (tVoid) (oIn >> rTrackInfo);
   (tVoid) (oIn >> rGroupInfo);
   (tVoid) (oIn >> rArtistInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_MediaData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MediaType);
   (tVoid) (oOut << rTrackInfo);
   (tVoid) (oOut << rGroupInfo);
   (tVoid) (oOut << rArtistInfo);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_MediaData::operator==(const midw_ext_fi_tcl_Meter_Audio_MediaData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MediaType == roRef.e8MediaType);
   bResult = bResult && (rTrackInfo == roRef.rTrackInfo);
   bResult = bResult && (rGroupInfo == roRef.rGroupInfo);
   bResult = bResult && (rArtistInfo == roRef.rArtistInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_AuxType::midw_ext_fi_tcl_e8_Meter_Audio_AuxType():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_AuxType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_AUXTYPE;
}


midw_ext_fi_tcl_e8_Meter_Audio_AuxType::~midw_ext_fi_tcl_e8_Meter_Audio_AuxType()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_AuxType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_AuxType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_AuxType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_AuxData::midw_ext_fi_tcl_Meter_Audio_AuxData(const midw_ext_fi_tcl_Meter_Audio_AuxData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8AuxType = coRef.e8AuxType;
}
midw_ext_fi_tcl_Meter_Audio_AuxData& midw_ext_fi_tcl_Meter_Audio_AuxData::operator=(const midw_ext_fi_tcl_Meter_Audio_AuxData& coRef)
{
   if (this == &coRef) return *this;
   e8AuxType = coRef.e8AuxType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_Meter_Audio_AuxData::midw_ext_fi_tcl_Meter_Audio_AuxData()
:e8AuxType()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_AuxData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_AUXDATA;
}


midw_ext_fi_tcl_Meter_Audio_AuxData::~midw_ext_fi_tcl_Meter_Audio_AuxData()
{}

tU32 midw_ext_fi_tcl_Meter_Audio_AuxData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_AuxData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8AuxType);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_AuxData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8AuxType);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_AuxData::operator==(const midw_ext_fi_tcl_Meter_Audio_AuxData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8AuxType == roRef.e8AuxType);
   return bResult;
}

//=============================================================================

midw_ext_fi_tcl_Meter_Audio_ExternalSoundData::midw_ext_fi_tcl_Meter_Audio_ExternalSoundData()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_ExternalSoundData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_EXTERNALSOUNDDATA;
}


midw_ext_fi_tcl_Meter_Audio_ExternalSoundData::~midw_ext_fi_tcl_Meter_Audio_ExternalSoundData()
{}

tU32 midw_ext_fi_tcl_Meter_Audio_ExternalSoundData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_ExternalSoundData::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_ExternalSoundData::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_InternetRadioData::midw_ext_fi_tcl_Meter_Audio_InternetRadioData(const midw_ext_fi_tcl_Meter_Audio_InternetRadioData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   strSourceName = coRef.strSourceName;
   rTrackInfo = coRef.rTrackInfo;
   rGroupInfo = coRef.rGroupInfo;
   rArtistInfo = coRef.rArtistInfo;
}
midw_ext_fi_tcl_Meter_Audio_InternetRadioData& midw_ext_fi_tcl_Meter_Audio_InternetRadioData::operator=(const midw_ext_fi_tcl_Meter_Audio_InternetRadioData& coRef)
{
   if (this == &coRef) return *this;
   strSourceName = coRef.strSourceName;
   rTrackInfo = coRef.rTrackInfo;
   rGroupInfo = coRef.rGroupInfo;
   rArtistInfo = coRef.rArtistInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_Meter_Audio_InternetRadioData::vDestroy()
{
   strSourceName.vDestroy();
   rTrackInfo.vDestroy(); 
   rGroupInfo.vDestroy(); 
   rArtistInfo.vDestroy(); 
}

midw_ext_fi_tcl_Meter_Audio_InternetRadioData::midw_ext_fi_tcl_Meter_Audio_InternetRadioData()
:strSourceName()
,rTrackInfo()
,rGroupInfo()
,rArtistInfo()
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_InternetRadioData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_INTERNETRADIODATA;
}


midw_ext_fi_tcl_Meter_Audio_InternetRadioData::~midw_ext_fi_tcl_Meter_Audio_InternetRadioData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_Meter_Audio_InternetRadioData::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strSourceName.u32GetSize(u16MajorVersion)+rTrackInfo.u32GetSize(u16MajorVersion)+rGroupInfo.u32GetSize(u16MajorVersion)+rArtistInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_InternetRadioData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strSourceName);
   (tVoid) (oIn >> rTrackInfo);
   (tVoid) (oIn >> rGroupInfo);
   (tVoid) (oIn >> rArtistInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_InternetRadioData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strSourceName);
   (tVoid) (oOut << rTrackInfo);
   (tVoid) (oOut << rGroupInfo);
   (tVoid) (oOut << rArtistInfo);
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_InternetRadioData::operator==(const midw_ext_fi_tcl_Meter_Audio_InternetRadioData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strSourceName == roRef.strSourceName);
   bResult = bResult && (rTrackInfo == roRef.rTrackInfo);
   bResult = bResult && (rGroupInfo == roRef.rGroupInfo);
   bResult = bResult && (rArtistInfo == roRef.rArtistInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType():enType(FI_EN_T_METER_AUDIO_NODATA) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_SOURCEINFOTYPE;
}


midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::~midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion::midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion(const midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   SourceInfoType = coRef.SourceInfoType;
   if  (coRef.poSourceInfoData)
   {
      switch(SourceInfoType.enType)
      {
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_NODATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_NoData((const midw_ext_fi_tcl_Meter_Audio_NoData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_RADIODATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_RadioData((const midw_ext_fi_tcl_Meter_Audio_RadioData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_MEDIADATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_MediaData((const midw_ext_fi_tcl_Meter_Audio_MediaData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_AUXDATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_AuxData((const midw_ext_fi_tcl_Meter_Audio_AuxData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_EXTERNALSOUNDDATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_ExternalSoundData((const midw_ext_fi_tcl_Meter_Audio_ExternalSoundData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_INTERNETRADIODATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_InternetRadioData((const midw_ext_fi_tcl_Meter_Audio_InternetRadioData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_HDRADIODATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_HDRadioData((const midw_ext_fi_tcl_Meter_Audio_HDRadioData&)*coRef.poSourceInfoData);
         break;
      default:
         poSourceInfoData = OSAL_NULL;
      }
   }
   else
   {
      poSourceInfoData = OSAL_NULL;
   }
}
midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion& midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion::operator=(const midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poSourceInfoData;
   SourceInfoType = coRef.SourceInfoType;
   if  (coRef.poSourceInfoData)
   {
      switch(SourceInfoType.enType)
      {
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_NODATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_NoData((const midw_ext_fi_tcl_Meter_Audio_NoData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_RADIODATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_RadioData((const midw_ext_fi_tcl_Meter_Audio_RadioData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_MEDIADATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_MediaData((const midw_ext_fi_tcl_Meter_Audio_MediaData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_AUXDATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_AuxData((const midw_ext_fi_tcl_Meter_Audio_AuxData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_EXTERNALSOUNDDATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_ExternalSoundData((const midw_ext_fi_tcl_Meter_Audio_ExternalSoundData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_INTERNETRADIODATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_InternetRadioData((const midw_ext_fi_tcl_Meter_Audio_InternetRadioData&)*coRef.poSourceInfoData);
         break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_HDRADIODATA:
         poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_HDRadioData((const midw_ext_fi_tcl_Meter_Audio_HDRadioData&)*coRef.poSourceInfoData);
         break;
      default:
         poSourceInfoData = OSAL_NULL;
      }
   }
   else
   {
      poSourceInfoData = OSAL_NULL;
   }
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion::vDestroy()
{
   if (poSourceInfoData)
   {
      poSourceInfoData->vDestroy();
      OSAL_DELETE poSourceInfoData;
      poSourceInfoData = OSAL_NULL;
   }
}

midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion::midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion()
:poSourceInfoData(0)
 {}

tS32 midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_METER_AUDIO_SOURCEINFOUNION;
}


midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion::~midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poSourceInfoData?poSourceInfoData->u32GetSize(u16MajorVersion):0);
}

fi_tclInContext& midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poSourceInfoData;
#else
   if (poSourceInfoData)
   {
      poSourceInfoData->vDestroy();
      OSAL_DELETE poSourceInfoData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> SourceInfoType);
   switch(SourceInfoType.enType)
   {
   case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_NODATA:
      poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_NoData;
      break;
   case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_RADIODATA:
      poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_RadioData;
      break;
   case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_MEDIADATA:
      poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_MediaData;
      break;
   case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_AUXDATA:
      poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_AuxData;
      break;
   case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_EXTERNALSOUNDDATA:
      poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_ExternalSoundData;
      break;
   case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_INTERNETRADIODATA:
      poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_InternetRadioData;
      break;
   case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_HDRADIODATA:
      poSourceInfoData = OSAL_NEW midw_ext_fi_tcl_Meter_Audio_HDRadioData;
      break;
   default:
      oIn.Invalidate();
      poSourceInfoData = OSAL_NULL;
   }
   if (poSourceInfoData && oIn.bIsValid())
      poSourceInfoData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SourceInfoType);
   if (poSourceInfoData)
   {
      (tVoid) poSourceInfoData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

tBool midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion::operator==(const midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SourceInfoType == roRef.SourceInfoType);
   if (bResult && poSourceInfoData && roRef.poSourceInfoData) 
   {
      switch (SourceInfoType.enType)
      {
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_NODATA:
         bResult = bResult && (*(const midw_ext_fi_tcl_Meter_Audio_NoData*)poSourceInfoData == *(const midw_ext_fi_tcl_Meter_Audio_NoData*)roRef.poSourceInfoData); //lint !e826
      break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_RADIODATA:
         bResult = bResult && (*(const midw_ext_fi_tcl_Meter_Audio_RadioData*)poSourceInfoData == *(const midw_ext_fi_tcl_Meter_Audio_RadioData*)roRef.poSourceInfoData); //lint !e826
      break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_MEDIADATA:
         bResult = bResult && (*(const midw_ext_fi_tcl_Meter_Audio_MediaData*)poSourceInfoData == *(const midw_ext_fi_tcl_Meter_Audio_MediaData*)roRef.poSourceInfoData); //lint !e826
      break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_AUXDATA:
         bResult = bResult && (*(const midw_ext_fi_tcl_Meter_Audio_AuxData*)poSourceInfoData == *(const midw_ext_fi_tcl_Meter_Audio_AuxData*)roRef.poSourceInfoData); //lint !e826
      break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_EXTERNALSOUNDDATA:
         bResult = bResult && (*(const midw_ext_fi_tcl_Meter_Audio_ExternalSoundData*)poSourceInfoData == *(const midw_ext_fi_tcl_Meter_Audio_ExternalSoundData*)roRef.poSourceInfoData); //lint !e826
      break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_INTERNETRADIODATA:
         bResult = bResult && (*(const midw_ext_fi_tcl_Meter_Audio_InternetRadioData*)poSourceInfoData == *(const midw_ext_fi_tcl_Meter_Audio_InternetRadioData*)roRef.poSourceInfoData); //lint !e826
      break;
      case midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::FI_EN_T_METER_AUDIO_HDRADIODATA:
         bResult = bResult && (*(const midw_ext_fi_tcl_Meter_Audio_HDRadioData*)poSourceInfoData == *(const midw_ext_fi_tcl_Meter_Audio_HDRadioData*)roRef.poSourceInfoData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poSourceInfoData == roRef.poSourceInfoData);
   }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_WarningSource::midw_ext_fi_tcl_e8_Meter_Audio_WarningSource():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_WarningSource::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_WARNINGSOURCE;
}


midw_ext_fi_tcl_e8_Meter_Audio_WarningSource::~midw_ext_fi_tcl_e8_Meter_Audio_WarningSource()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_WarningSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_WarningSource::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_WarningSource::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_WarningState::midw_ext_fi_tcl_e8_Meter_Audio_WarningState():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_WarningState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_WARNINGSTATE;
}


midw_ext_fi_tcl_e8_Meter_Audio_WarningState::~midw_ext_fi_tcl_e8_Meter_Audio_WarningState()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_WarningState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_WarningState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_WarningState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode::midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_AUDIO_SPECIALMODE;
}


midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode::~midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_NavStatus::midw_ext_fi_tcl_e8_NavStatus():enType(FI_EN_NAVSTATUS_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_NavStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_NAVSTATUS;
}


midw_ext_fi_tcl_e8_NavStatus::~midw_ext_fi_tcl_e8_NavStatus()
{}

tU32 midw_ext_fi_tcl_e8_NavStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_NavStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_NavStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_RoadClass::midw_ext_fi_tcl_e8_RoadClass():enType(FI_EN_ROAD_CLASS_NONE) {}

tS32 midw_ext_fi_tcl_e8_RoadClass::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_ROADCLASS;
}


midw_ext_fi_tcl_e8_RoadClass::~midw_ext_fi_tcl_e8_RoadClass()
{}

tU32 midw_ext_fi_tcl_e8_RoadClass::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_RoadClass::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_RoadClass::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Unit::midw_ext_fi_tcl_e8_Unit():enType(FI_EN_UNIT_METER) {}

tS32 midw_ext_fi_tcl_e8_Unit::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_UNIT;
}


midw_ext_fi_tcl_e8_Unit::~midw_ext_fi_tcl_e8_Unit()
{}

tU32 midw_ext_fi_tcl_e8_Unit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Unit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Unit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_ManeuverSymbol::midw_ext_fi_tcl_e8_ManeuverSymbol():enType(FI_EN_MANEUVER_SYMBOL_NO_SYMBOL) {}

tS32 midw_ext_fi_tcl_e8_ManeuverSymbol::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_MANEUVERSYMBOL;
}


midw_ext_fi_tcl_e8_ManeuverSymbol::~midw_ext_fi_tcl_e8_ManeuverSymbol()
{}

tU32 midw_ext_fi_tcl_e8_ManeuverSymbol::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_ManeuverSymbol::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_ManeuverSymbol::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SpeedUnit::midw_ext_fi_tcl_e8_SpeedUnit():enType(FI_EN_SPEEDUNIT_KM_PER_HOUR) {}

tS32 midw_ext_fi_tcl_e8_SpeedUnit::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SPEEDUNIT;
}


midw_ext_fi_tcl_e8_SpeedUnit::~midw_ext_fi_tcl_e8_SpeedUnit()
{}

tU32 midw_ext_fi_tcl_e8_SpeedUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SpeedUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SpeedUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_ManeuverRecommendationType::midw_ext_fi_tcl_e8_ManeuverRecommendationType():enType(FI_EN_PREVIEW) {}

tS32 midw_ext_fi_tcl_e8_ManeuverRecommendationType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_MANEUVERRECOMMENDATIONTYPE;
}


midw_ext_fi_tcl_e8_ManeuverRecommendationType::~midw_ext_fi_tcl_e8_ManeuverRecommendationType()
{}

tU32 midw_ext_fi_tcl_e8_ManeuverRecommendationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_ManeuverRecommendationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_ManeuverRecommendationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TimeType::midw_ext_fi_tcl_e8_TimeType():enType(FI_EN_REMAININGTIME) {}

tS32 midw_ext_fi_tcl_e8_TimeType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TIMETYPE;
}


midw_ext_fi_tcl_e8_TimeType::~midw_ext_fi_tcl_e8_TimeType()
{}

tU32 midw_ext_fi_tcl_e8_TimeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TimeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TimeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TimeFormat::midw_ext_fi_tcl_e8_TimeFormat():enType(FI_EN_TWELVEHOURS) {}

tS32 midw_ext_fi_tcl_e8_TimeFormat::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TIMEFORMAT;
}


midw_ext_fi_tcl_e8_TimeFormat::~midw_ext_fi_tcl_e8_TimeFormat()
{}

tU32 midw_ext_fi_tcl_e8_TimeFormat::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TimeFormat::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TimeFormat::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_ManeuverView::midw_ext_fi_tcl_e8_ManeuverView():enType(FI_EN_MANEUVER_VIEW_NONE) {}

tS32 midw_ext_fi_tcl_e8_ManeuverView::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_MANEUVERVIEW;
}


midw_ext_fi_tcl_e8_ManeuverView::~midw_ext_fi_tcl_e8_ManeuverView()
{}

tU32 midw_ext_fi_tcl_e8_ManeuverView::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_ManeuverView::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_ManeuverView::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DeformedImageRoad::midw_ext_fi_tcl_e8_DeformedImageRoad():enType(FI_EN_DEFORMED_IMAGE_ROAD_TYPE_NONE) {}

tS32 midw_ext_fi_tcl_e8_DeformedImageRoad::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DEFORMEDIMAGEROAD;
}


midw_ext_fi_tcl_e8_DeformedImageRoad::~midw_ext_fi_tcl_e8_DeformedImageRoad()
{}

tU32 midw_ext_fi_tcl_e8_DeformedImageRoad::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DeformedImageRoad::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DeformedImageRoad::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DeformedImageArrow::midw_ext_fi_tcl_e8_DeformedImageArrow():enType(FI_EN_DEFORMED_IMAGE_ARROW_TYPE_NONE) {}

tS32 midw_ext_fi_tcl_e8_DeformedImageArrow::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DEFORMEDIMAGEARROW;
}


midw_ext_fi_tcl_e8_DeformedImageArrow::~midw_ext_fi_tcl_e8_DeformedImageArrow()
{}

tU32 midw_ext_fi_tcl_e8_DeformedImageArrow::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DeformedImageArrow::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DeformedImageArrow::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_LaneStatus::midw_ext_fi_tcl_e8_LaneStatus():enType(FI_EN_LANE_STATUS_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_LaneStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_LANESTATUS;
}


midw_ext_fi_tcl_e8_LaneStatus::~midw_ext_fi_tcl_e8_LaneStatus()
{}

tU32 midw_ext_fi_tcl_e8_LaneStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_LaneStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_LaneStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_LaneRecommendation::midw_ext_fi_tcl_LaneRecommendation(const midw_ext_fi_tcl_LaneRecommendation& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8LaneRecommendationListLaneStatus = coRef.e8LaneRecommendationListLaneStatus;
   s32LaneRecommendationListCombinedFollowingLaneDirection = coRef.s32LaneRecommendationListCombinedFollowingLaneDirection;
   s32LaneRecommendationListGuidedFollowingLaneDirection = coRef.s32LaneRecommendationListGuidedFollowingLaneDirection;
}
midw_ext_fi_tcl_LaneRecommendation& midw_ext_fi_tcl_LaneRecommendation::operator=(const midw_ext_fi_tcl_LaneRecommendation& coRef)
{
   if (this == &coRef) return *this;
   e8LaneRecommendationListLaneStatus = coRef.e8LaneRecommendationListLaneStatus;
   s32LaneRecommendationListCombinedFollowingLaneDirection = coRef.s32LaneRecommendationListCombinedFollowingLaneDirection;
   s32LaneRecommendationListGuidedFollowingLaneDirection = coRef.s32LaneRecommendationListGuidedFollowingLaneDirection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_LaneRecommendation::midw_ext_fi_tcl_LaneRecommendation()
:e8LaneRecommendationListLaneStatus()
,s32LaneRecommendationListCombinedFollowingLaneDirection(0)
,s32LaneRecommendationListGuidedFollowingLaneDirection(0)
 {}

tS32 midw_ext_fi_tcl_LaneRecommendation::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_LANERECOMMENDATION;
}


midw_ext_fi_tcl_LaneRecommendation::~midw_ext_fi_tcl_LaneRecommendation()
{}

tU32 midw_ext_fi_tcl_LaneRecommendation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& midw_ext_fi_tcl_LaneRecommendation::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LaneRecommendationListLaneStatus);
   (tVoid) (oIn >> s32LaneRecommendationListCombinedFollowingLaneDirection);
   (tVoid) (oIn >> s32LaneRecommendationListGuidedFollowingLaneDirection);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_LaneRecommendation::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LaneRecommendationListLaneStatus);
   (tVoid) (oOut << s32LaneRecommendationListCombinedFollowingLaneDirection);
   (tVoid) (oOut << s32LaneRecommendationListGuidedFollowingLaneDirection);
   return oOut;
}

tBool midw_ext_fi_tcl_LaneRecommendation::operator==(const midw_ext_fi_tcl_LaneRecommendation& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LaneRecommendationListLaneStatus == roRef.e8LaneRecommendationListLaneStatus);
   bResult = bResult && (s32LaneRecommendationListCombinedFollowingLaneDirection == roRef.s32LaneRecommendationListCombinedFollowingLaneDirection);
   bResult = bResult && (s32LaneRecommendationListGuidedFollowingLaneDirection == roRef.s32LaneRecommendationListGuidedFollowingLaneDirection);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_ArrivalInformation::midw_ext_fi_tcl_ArrivalInformation(const midw_ext_fi_tcl_ArrivalInformation& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString = coRef.strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString;
   u32ArrivalInformationListDistanceToDestinationDistanceToDestination = coRef.u32ArrivalInformationListDistanceToDestinationDistanceToDestination;
   e8ArrivalInformationListDistanceToDestinationUnit = coRef.e8ArrivalInformationListDistanceToDestinationUnit;
   strArrivalInformationListDistanceToDestinationTimeToDestinationAsString = coRef.strArrivalInformationListDistanceToDestinationTimeToDestinationAsString;
   s32ArrivalInformationListTimeToDestination = coRef.s32ArrivalInformationListTimeToDestination;
   strArrivalInformationListEstimatedTimeOfArrivalAsString = coRef.strArrivalInformationListEstimatedTimeOfArrivalAsString;
   s32ArrivalInformationListEstimatedTimeOfArrivalHour = coRef.s32ArrivalInformationListEstimatedTimeOfArrivalHour;
   s32ArrivalInformationListEstimatedTimeOfArrivalMinute = coRef.s32ArrivalInformationListEstimatedTimeOfArrivalMinute;
   e8ArrivalInformationListDisplayTimeType = coRef.e8ArrivalInformationListDisplayTimeType;
   e8ArrivalInformationListDisplayTimeFormat = coRef.e8ArrivalInformationListDisplayTimeFormat;
   s32ArrivalInformationListDestinationIndex = coRef.s32ArrivalInformationListDestinationIndex;
}
midw_ext_fi_tcl_ArrivalInformation& midw_ext_fi_tcl_ArrivalInformation::operator=(const midw_ext_fi_tcl_ArrivalInformation& coRef)
{
   if (this == &coRef) return *this;
   strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString = coRef.strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString;
   u32ArrivalInformationListDistanceToDestinationDistanceToDestination = coRef.u32ArrivalInformationListDistanceToDestinationDistanceToDestination;
   e8ArrivalInformationListDistanceToDestinationUnit = coRef.e8ArrivalInformationListDistanceToDestinationUnit;
   strArrivalInformationListDistanceToDestinationTimeToDestinationAsString = coRef.strArrivalInformationListDistanceToDestinationTimeToDestinationAsString;
   s32ArrivalInformationListTimeToDestination = coRef.s32ArrivalInformationListTimeToDestination;
   strArrivalInformationListEstimatedTimeOfArrivalAsString = coRef.strArrivalInformationListEstimatedTimeOfArrivalAsString;
   s32ArrivalInformationListEstimatedTimeOfArrivalHour = coRef.s32ArrivalInformationListEstimatedTimeOfArrivalHour;
   s32ArrivalInformationListEstimatedTimeOfArrivalMinute = coRef.s32ArrivalInformationListEstimatedTimeOfArrivalMinute;
   e8ArrivalInformationListDisplayTimeType = coRef.e8ArrivalInformationListDisplayTimeType;
   e8ArrivalInformationListDisplayTimeFormat = coRef.e8ArrivalInformationListDisplayTimeFormat;
   s32ArrivalInformationListDestinationIndex = coRef.s32ArrivalInformationListDestinationIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_ArrivalInformation::vDestroy()
{
   strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString.vDestroy();
   strArrivalInformationListDistanceToDestinationTimeToDestinationAsString.vDestroy();
   strArrivalInformationListEstimatedTimeOfArrivalAsString.vDestroy();
}

midw_ext_fi_tcl_ArrivalInformation::midw_ext_fi_tcl_ArrivalInformation()
:strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString()
,u32ArrivalInformationListDistanceToDestinationDistanceToDestination(0)
,e8ArrivalInformationListDistanceToDestinationUnit()
,strArrivalInformationListDistanceToDestinationTimeToDestinationAsString()
,s32ArrivalInformationListTimeToDestination(0)
,strArrivalInformationListEstimatedTimeOfArrivalAsString()
,s32ArrivalInformationListEstimatedTimeOfArrivalHour(0)
,s32ArrivalInformationListEstimatedTimeOfArrivalMinute(0)
,e8ArrivalInformationListDisplayTimeType()
,e8ArrivalInformationListDisplayTimeFormat()
,s32ArrivalInformationListDestinationIndex(0)
 {}

tS32 midw_ext_fi_tcl_ArrivalInformation::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_ARRIVALINFORMATION;
}


midw_ext_fi_tcl_ArrivalInformation::~midw_ext_fi_tcl_ArrivalInformation()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_ArrivalInformation::u32GetSize(tU16 u16MajorVersion) const
{
   return 23+strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString.u32GetSize(u16MajorVersion)+strArrivalInformationListDistanceToDestinationTimeToDestinationAsString.u32GetSize(u16MajorVersion)+strArrivalInformationListEstimatedTimeOfArrivalAsString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_ArrivalInformation::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString);
   (tVoid) (oIn >> u32ArrivalInformationListDistanceToDestinationDistanceToDestination);
   (tVoid) (oIn >> e8ArrivalInformationListDistanceToDestinationUnit);
   (tVoid) (oIn >> strArrivalInformationListDistanceToDestinationTimeToDestinationAsString);
   (tVoid) (oIn >> s32ArrivalInformationListTimeToDestination);
   (tVoid) (oIn >> strArrivalInformationListEstimatedTimeOfArrivalAsString);
   (tVoid) (oIn >> s32ArrivalInformationListEstimatedTimeOfArrivalHour);
   (tVoid) (oIn >> s32ArrivalInformationListEstimatedTimeOfArrivalMinute);
   (tVoid) (oIn >> e8ArrivalInformationListDisplayTimeType);
   (tVoid) (oIn >> e8ArrivalInformationListDisplayTimeFormat);
   (tVoid) (oIn >> s32ArrivalInformationListDestinationIndex);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_ArrivalInformation::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString);
   (tVoid) (oOut << u32ArrivalInformationListDistanceToDestinationDistanceToDestination);
   (tVoid) (oOut << e8ArrivalInformationListDistanceToDestinationUnit);
   (tVoid) (oOut << strArrivalInformationListDistanceToDestinationTimeToDestinationAsString);
   (tVoid) (oOut << s32ArrivalInformationListTimeToDestination);
   (tVoid) (oOut << strArrivalInformationListEstimatedTimeOfArrivalAsString);
   (tVoid) (oOut << s32ArrivalInformationListEstimatedTimeOfArrivalHour);
   (tVoid) (oOut << s32ArrivalInformationListEstimatedTimeOfArrivalMinute);
   (tVoid) (oOut << e8ArrivalInformationListDisplayTimeType);
   (tVoid) (oOut << e8ArrivalInformationListDisplayTimeFormat);
   (tVoid) (oOut << s32ArrivalInformationListDestinationIndex);
   return oOut;
}

tBool midw_ext_fi_tcl_ArrivalInformation::operator==(const midw_ext_fi_tcl_ArrivalInformation& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString == roRef.strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString);
   bResult = bResult && (u32ArrivalInformationListDistanceToDestinationDistanceToDestination == roRef.u32ArrivalInformationListDistanceToDestinationDistanceToDestination);
   bResult = bResult && (e8ArrivalInformationListDistanceToDestinationUnit == roRef.e8ArrivalInformationListDistanceToDestinationUnit);
   bResult = bResult && (strArrivalInformationListDistanceToDestinationTimeToDestinationAsString == roRef.strArrivalInformationListDistanceToDestinationTimeToDestinationAsString);
   bResult = bResult && (s32ArrivalInformationListTimeToDestination == roRef.s32ArrivalInformationListTimeToDestination);
   bResult = bResult && (strArrivalInformationListEstimatedTimeOfArrivalAsString == roRef.strArrivalInformationListEstimatedTimeOfArrivalAsString);
   bResult = bResult && (s32ArrivalInformationListEstimatedTimeOfArrivalHour == roRef.s32ArrivalInformationListEstimatedTimeOfArrivalHour);
   bResult = bResult && (s32ArrivalInformationListEstimatedTimeOfArrivalMinute == roRef.s32ArrivalInformationListEstimatedTimeOfArrivalMinute);
   bResult = bResult && (e8ArrivalInformationListDisplayTimeType == roRef.e8ArrivalInformationListDisplayTimeType);
   bResult = bResult && (e8ArrivalInformationListDisplayTimeFormat == roRef.e8ArrivalInformationListDisplayTimeFormat);
   bResult = bResult && (s32ArrivalInformationListDestinationIndex == roRef.s32ArrivalInformationListDestinationIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_ScreenCoordinate::midw_ext_fi_tcl_ScreenCoordinate(const midw_ext_fi_tcl_ScreenCoordinate& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u32ScreenCoordinateXPos = coRef.u32ScreenCoordinateXPos;
   u32ScreenCoordinateYPos = coRef.u32ScreenCoordinateYPos;
}
midw_ext_fi_tcl_ScreenCoordinate& midw_ext_fi_tcl_ScreenCoordinate::operator=(const midw_ext_fi_tcl_ScreenCoordinate& coRef)
{
   if (this == &coRef) return *this;
   u32ScreenCoordinateXPos = coRef.u32ScreenCoordinateXPos;
   u32ScreenCoordinateYPos = coRef.u32ScreenCoordinateYPos;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_ScreenCoordinate::midw_ext_fi_tcl_ScreenCoordinate()
:u32ScreenCoordinateXPos(0)
,u32ScreenCoordinateYPos(0)
 {}

tS32 midw_ext_fi_tcl_ScreenCoordinate::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SCREENCOORDINATE;
}


midw_ext_fi_tcl_ScreenCoordinate::~midw_ext_fi_tcl_ScreenCoordinate()
{}

tU32 midw_ext_fi_tcl_ScreenCoordinate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_fi_tcl_ScreenCoordinate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ScreenCoordinateXPos);
   (tVoid) (oIn >> u32ScreenCoordinateYPos);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_ScreenCoordinate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ScreenCoordinateXPos);
   (tVoid) (oOut << u32ScreenCoordinateYPos);
   return oOut;
}

tBool midw_ext_fi_tcl_ScreenCoordinate::operator==(const midw_ext_fi_tcl_ScreenCoordinate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ScreenCoordinateXPos == roRef.u32ScreenCoordinateXPos);
   bResult = bResult && (u32ScreenCoordinateYPos == roRef.u32ScreenCoordinateYPos);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_AdminRoadClass::midw_ext_fi_tcl_e8_AdminRoadClass():enType(FI_EN_ADMIN_ROAD_CLASS_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_AdminRoadClass::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_ADMINROADCLASS;
}


midw_ext_fi_tcl_e8_AdminRoadClass::~midw_ext_fi_tcl_e8_AdminRoadClass()
{}

tU32 midw_ext_fi_tcl_e8_AdminRoadClass::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_AdminRoadClass::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_AdminRoadClass::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_IntersectionMapRoadLine::midw_ext_fi_tcl_IntersectionMapRoadLine(const midw_ext_fi_tcl_IntersectionMapRoadLine& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   tIntersectionMapRoadLineCoordinates = coRef.tIntersectionMapRoadLineCoordinates;
   e8IntersectionMapRoadLineRoadClass = coRef.e8IntersectionMapRoadLineRoadClass;
}
midw_ext_fi_tcl_IntersectionMapRoadLine& midw_ext_fi_tcl_IntersectionMapRoadLine::operator=(const midw_ext_fi_tcl_IntersectionMapRoadLine& coRef)
{
   if (this == &coRef) return *this;
   tIntersectionMapRoadLineCoordinates = coRef.tIntersectionMapRoadLineCoordinates;
   e8IntersectionMapRoadLineRoadClass = coRef.e8IntersectionMapRoadLineRoadClass;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_IntersectionMapRoadLine::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tIntersectionMapRoadLineCoordinates.size(); ++u32Idx)
         tIntersectionMapRoadLineCoordinates[u32Idx].vDestroy();
   tIntersectionMapRoadLineCoordinates.clear();
   }
}

midw_ext_fi_tcl_IntersectionMapRoadLine::midw_ext_fi_tcl_IntersectionMapRoadLine()

:e8IntersectionMapRoadLineRoadClass()
 {}

tS32 midw_ext_fi_tcl_IntersectionMapRoadLine::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_INTERSECTIONMAPROADLINE;
}


midw_ext_fi_tcl_IntersectionMapRoadLine::~midw_ext_fi_tcl_IntersectionMapRoadLine()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_IntersectionMapRoadLine::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(tIntersectionMapRoadLineCoordinates.size()*8);
}

fi_tclInContext& midw_ext_fi_tcl_IntersectionMapRoadLine::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tIntersectionMapRoadLineCoordinates.size(); ++u32Idx)
      {
         tIntersectionMapRoadLineCoordinates[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tIntersectionMapRoadLineCoordinates.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tIntersectionMapRoadLineCoordinates[u32Idx]);
      }
   }
   (tVoid) (oIn >> e8IntersectionMapRoadLineRoadClass);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_IntersectionMapRoadLine::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tIntersectionMapRoadLineCoordinates.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tIntersectionMapRoadLineCoordinates.size(); ++u32Idx)
         (tVoid) (oOut << tIntersectionMapRoadLineCoordinates[u32Idx]);
   }
   (tVoid) (oOut << e8IntersectionMapRoadLineRoadClass);
   return oOut;
}

tBool midw_ext_fi_tcl_IntersectionMapRoadLine::operator==(const midw_ext_fi_tcl_IntersectionMapRoadLine& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tIntersectionMapRoadLineCoordinates.size() == roRef.tIntersectionMapRoadLineCoordinates.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tIntersectionMapRoadLineCoordinates.size()); ++u32Idx)
            bResult = bResult && (tIntersectionMapRoadLineCoordinates[u32Idx] == roRef.tIntersectionMapRoadLineCoordinates[u32Idx]);
      }
   bResult = bResult && (e8IntersectionMapRoadLineRoadClass == roRef.e8IntersectionMapRoadLineRoadClass);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_IntersectionMapCarsorState::midw_ext_fi_tcl_e8_IntersectionMapCarsorState():enType(FI_EN_INTERSECTION_MAP_CARSOR_STATE_OFF) {}

tS32 midw_ext_fi_tcl_e8_IntersectionMapCarsorState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_INTERSECTIONMAPCARSORSTATE;
}


midw_ext_fi_tcl_e8_IntersectionMapCarsorState::~midw_ext_fi_tcl_e8_IntersectionMapCarsorState()
{}

tU32 midw_ext_fi_tcl_e8_IntersectionMapCarsorState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_IntersectionMapCarsorState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_IntersectionMapCarsorState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState::midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState():enType(FI_EN_SPI_APP_STATE_NAV_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SPINAVIGATION_NAVIGATIONAPPSTATE;
}


midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState::~midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState()
{}

tU32 midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SpiNavigation_TurnSide::midw_ext_fi_tcl_e8_SpiNavigation_TurnSide():enType(FI_EN_TURN_SIDE_LEFT) {}

tS32 midw_ext_fi_tcl_e8_SpiNavigation_TurnSide::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SPINAVIGATION_TURNSIDE;
}


midw_ext_fi_tcl_e8_SpiNavigation_TurnSide::~midw_ext_fi_tcl_e8_SpiNavigation_TurnSide()
{}

tU32 midw_ext_fi_tcl_e8_SpiNavigation_TurnSide::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SpiNavigation_TurnSide::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SpiNavigation_TurnSide::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent::midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent():enType(FI_EN_NEXT_TURN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SPINAVIGATION_NEXTTURNEVENT;
}


midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent::~midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent()
{}

tU32 midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode::midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_SWSC_KEYCODE;
}


midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode::~midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode()
{}

tU32 midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Phone_SMS_State::midw_ext_fi_tcl_e8_Meter_Phone_SMS_State():enType(FI_EN_NO_ACTION) {}

tS32 midw_ext_fi_tcl_e8_Meter_Phone_SMS_State::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_PHONE_SMS_STATE;
}


midw_ext_fi_tcl_e8_Meter_Phone_SMS_State::~midw_ext_fi_tcl_e8_Meter_Phone_SMS_State()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Phone_SMS_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Phone_SMS_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Phone_SMS_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu::midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu():enType(FI_EN_NO_ACTION) {}

tS32 midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_PHONE_SMS_SELECTED_MENU;
}


midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu::~midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType::midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_PHONE_SMS_POPUPTYPE;
}


midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType::~midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType()
{}

tU32 midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_VR_State::midw_ext_fi_tcl_e8_Meter_VR_State():enType(FI_EN_IDLE) {}

tS32 midw_ext_fi_tcl_e8_Meter_VR_State::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_VR_STATE;
}


midw_ext_fi_tcl_e8_Meter_VR_State::~midw_ext_fi_tcl_e8_Meter_VR_State()
{}

tU32 midw_ext_fi_tcl_e8_Meter_VR_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_VR_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_VR_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2::midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2():enType(FI_EN_0) {}

tS32 midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_VR_DIGIT_TYPE2;
}


midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2::~midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2()
{}

tU32 midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_PowerState::midw_ext_fi_tcl_e8_Meter_PowerState():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_PowerState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_POWERSTATE;
}


midw_ext_fi_tcl_e8_Meter_PowerState::~midw_ext_fi_tcl_e8_Meter_PowerState()
{}

tU32 midw_ext_fi_tcl_e8_Meter_PowerState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_PowerState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_PowerState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_TimeInfoType::midw_ext_fi_tcl_e8_Meter_TimeInfoType():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_TimeInfoType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_TIMEINFOTYPE;
}


midw_ext_fi_tcl_e8_Meter_TimeInfoType::~midw_ext_fi_tcl_e8_Meter_TimeInfoType()
{}

tU32 midw_ext_fi_tcl_e8_Meter_TimeInfoType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_TimeInfoType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_TimeInfoType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action::midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_PHONECALL_MENU_ACTION;
}


midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action::~midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action()
{}

tU32 midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Meter_PhoneCall_State::midw_ext_fi_tcl_e8_Meter_PhoneCall_State():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_Meter_PhoneCall_State::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METER_PHONECALL_STATE;
}


midw_ext_fi_tcl_e8_Meter_PhoneCall_State::~midw_ext_fi_tcl_e8_Meter_PhoneCall_State()
{}

tU32 midw_ext_fi_tcl_e8_Meter_PhoneCall_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Meter_PhoneCall_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Meter_PhoneCall_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Language_InvalidParameter::midw_ext_fi_tcl_e8_Language_InvalidParameter():enType(FI_EN_NORMAL) {}

tS32 midw_ext_fi_tcl_e8_Language_InvalidParameter::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_LANGUAGE_INVALIDPARAMETER;
}


midw_ext_fi_tcl_e8_Language_InvalidParameter::~midw_ext_fi_tcl_e8_Language_InvalidParameter()
{}

tU32 midw_ext_fi_tcl_e8_Language_InvalidParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Language_InvalidParameter::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Language_InvalidParameter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_ConfigurationStatus::midw_ext_fi_tcl_e8_TCU_ConfigurationStatus():enType(FI_EN_UNDEFINED) {}

tS32 midw_ext_fi_tcl_e8_TCU_ConfigurationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_CONFIGURATIONSTATUS;
}


midw_ext_fi_tcl_e8_TCU_ConfigurationStatus::~midw_ext_fi_tcl_e8_TCU_ConfigurationStatus()
{}

tU32 midw_ext_fi_tcl_e8_TCU_ConfigurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_ConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_ConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_VersionInfo::midw_ext_fi_tcl_TCU_VersionInfo(const midw_ext_fi_tcl_TCU_VersionInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Upper = coRef.u8Upper;
   u8Mid = coRef.u8Mid;
   u8Lower = coRef.u8Lower;
}
midw_ext_fi_tcl_TCU_VersionInfo& midw_ext_fi_tcl_TCU_VersionInfo::operator=(const midw_ext_fi_tcl_TCU_VersionInfo& coRef)
{
   if (this == &coRef) return *this;
   u8Upper = coRef.u8Upper;
   u8Mid = coRef.u8Mid;
   u8Lower = coRef.u8Lower;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_VersionInfo::midw_ext_fi_tcl_TCU_VersionInfo()
:u8Upper(0)
,u8Mid(0)
,u8Lower(0)
 {}

tS32 midw_ext_fi_tcl_TCU_VersionInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_VERSIONINFO;
}


midw_ext_fi_tcl_TCU_VersionInfo::~midw_ext_fi_tcl_TCU_VersionInfo()
{}

tU32 midw_ext_fi_tcl_TCU_VersionInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_VersionInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Upper);
   (tVoid) (oIn >> u8Mid);
   (tVoid) (oIn >> u8Lower);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_VersionInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Upper);
   (tVoid) (oOut << u8Mid);
   (tVoid) (oOut << u8Lower);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_VersionInfo::operator==(const midw_ext_fi_tcl_TCU_VersionInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Upper == roRef.u8Upper);
   bResult = bResult && (u8Mid == roRef.u8Mid);
   bResult = bResult && (u8Lower == roRef.u8Lower);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_CommunicationStatus::midw_ext_fi_tcl_e8_TCU_CommunicationStatus():enType(FI_EN_COMM_STATUS_OFF) {}

tS32 midw_ext_fi_tcl_e8_TCU_CommunicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_COMMUNICATIONSTATUS;
}


midw_ext_fi_tcl_e8_TCU_CommunicationStatus::~midw_ext_fi_tcl_e8_TCU_CommunicationStatus()
{}

tU32 midw_ext_fi_tcl_e8_TCU_CommunicationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_CommunicationStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_CommunicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_ServiceState::midw_ext_fi_tcl_e8_TCU_ServiceState():enType(FI_EN_IDLE) {}

tS32 midw_ext_fi_tcl_e8_TCU_ServiceState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_SERVICESTATE;
}


midw_ext_fi_tcl_e8_TCU_ServiceState::~midw_ext_fi_tcl_e8_TCU_ServiceState()
{}

tU32 midw_ext_fi_tcl_e8_TCU_ServiceState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_ServiceState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_ServiceState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_CurfewWarning::midw_ext_fi_tcl_e8_TCU_CurfewWarning():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_TCU_CurfewWarning::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_CURFEWWARNING;
}


midw_ext_fi_tcl_e8_TCU_CurfewWarning::~midw_ext_fi_tcl_e8_TCU_CurfewWarning()
{}

tU32 midw_ext_fi_tcl_e8_TCU_CurfewWarning::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_CurfewWarning::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_CurfewWarning::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_ModemStatus::midw_ext_fi_tcl_e8_TCU_ModemStatus():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_TCU_ModemStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_MODEMSTATUS;
}


midw_ext_fi_tcl_e8_TCU_ModemStatus::~midw_ext_fi_tcl_e8_TCU_ModemStatus()
{}

tU32 midw_ext_fi_tcl_e8_TCU_ModemStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_ModemStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_ModemStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_TCUStatus::midw_ext_fi_tcl_e8_TCU_TCUStatus():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_TCU_TCUStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_TCUSTATUS;
}


midw_ext_fi_tcl_e8_TCU_TCUStatus::~midw_ext_fi_tcl_e8_TCU_TCUStatus()
{}

tU32 midw_ext_fi_tcl_e8_TCU_TCUStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_TCUStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_TCUStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_GSMStatus::midw_ext_fi_tcl_e8_TCU_GSMStatus():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_TCU_GSMStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_GSMSTATUS;
}


midw_ext_fi_tcl_e8_TCU_GSMStatus::~midw_ext_fi_tcl_e8_TCU_GSMStatus()
{}

tU32 midw_ext_fi_tcl_e8_TCU_GSMStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_GSMStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_GSMStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_WifiStatus::midw_ext_fi_tcl_e8_TCU_WifiStatus():enType(FI_EN_OFF) {}

tS32 midw_ext_fi_tcl_e8_TCU_WifiStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_WIFISTATUS;
}


midw_ext_fi_tcl_e8_TCU_WifiStatus::~midw_ext_fi_tcl_e8_TCU_WifiStatus()
{}

tU32 midw_ext_fi_tcl_e8_TCU_WifiStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_WifiStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_WifiStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_WifiMode::midw_ext_fi_tcl_e8_TCU_WifiMode():enType(FI_EN_WIFIUNAVAILABLE) {}

tS32 midw_ext_fi_tcl_e8_TCU_WifiMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_WIFIMODE;
}


midw_ext_fi_tcl_e8_TCU_WifiMode::~midw_ext_fi_tcl_e8_TCU_WifiMode()
{}

tU32 midw_ext_fi_tcl_e8_TCU_WifiMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_WifiMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_WifiMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus::midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus():enType(FI_EN_WIFINOTACTIVATED) {}

tS32 midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_WIFIHOTSPOTSTATUS;
}


midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus::~midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus()
{}

tU32 midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_WifiClientStatus::midw_ext_fi_tcl_e8_TCU_WifiClientStatus():enType(FI_EN_NOTCONNECTED) {}

tS32 midw_ext_fi_tcl_e8_TCU_WifiClientStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_WIFICLIENTSTATUS;
}


midw_ext_fi_tcl_e8_TCU_WifiClientStatus::~midw_ext_fi_tcl_e8_TCU_WifiClientStatus()
{}

tU32 midw_ext_fi_tcl_e8_TCU_WifiClientStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_WifiClientStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_WifiClientStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_GSMDataMode::midw_ext_fi_tcl_e8_TCU_GSMDataMode():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_TCU_GSMDataMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_GSMDATAMODE;
}


midw_ext_fi_tcl_e8_TCU_GSMDataMode::~midw_ext_fi_tcl_e8_TCU_GSMDataMode()
{}

tU32 midw_ext_fi_tcl_e8_TCU_GSMDataMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_GSMDataMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_GSMDataMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Invalid_Parameter::midw_ext_fi_tcl_e8_TCU_Invalid_Parameter():enType(FI_EN_NORMAL) {}

tS32 midw_ext_fi_tcl_e8_TCU_Invalid_Parameter::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_INVALID_PARAMETER;
}


midw_ext_fi_tcl_e8_TCU_Invalid_Parameter::~midw_ext_fi_tcl_e8_TCU_Invalid_Parameter()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Invalid_Parameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Invalid_Parameter::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Invalid_Parameter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_RoamingStatus::midw_ext_fi_tcl_e8_TCU_RoamingStatus():enType(FI_EN_UNAVAILABLE) {}

tS32 midw_ext_fi_tcl_e8_TCU_RoamingStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_ROAMINGSTATUS;
}


midw_ext_fi_tcl_e8_TCU_RoamingStatus::~midw_ext_fi_tcl_e8_TCU_RoamingStatus()
{}

tU32 midw_ext_fi_tcl_e8_TCU_RoamingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_RoamingStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_RoamingStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus::midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus():enType(FI_EN_UNAVAILABLE) {}

tS32 midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_PPPCONNECTIONSTATUS;
}


midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus::~midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus()
{}

tU32 midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_InvalidParameter::midw_ext_fi_tcl_e8_TCU_InvalidParameter():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_TCU_InvalidParameter::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_INVALIDPARAMETER;
}


midw_ext_fi_tcl_e8_TCU_InvalidParameter::~midw_ext_fi_tcl_e8_TCU_InvalidParameter()
{}

tU32 midw_ext_fi_tcl_e8_TCU_InvalidParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_InvalidParameter::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_InvalidParameter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_PermitSetting::midw_ext_fi_tcl_e8_TCU_PermitSetting():enType(FI_EN_OFF) {}

tS32 midw_ext_fi_tcl_e8_TCU_PermitSetting::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_PERMITSETTING;
}


midw_ext_fi_tcl_e8_TCU_PermitSetting::~midw_ext_fi_tcl_e8_TCU_PermitSetting()
{}

tU32 midw_ext_fi_tcl_e8_TCU_PermitSetting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_PermitSetting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_PermitSetting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_APP_Context::midw_ext_fi_tcl_e8_TCU_APP_Context():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_TCU_APP_Context::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_APP_CONTEXT;
}


midw_ext_fi_tcl_e8_TCU_APP_Context::~midw_ext_fi_tcl_e8_TCU_APP_Context()
{}

tU32 midw_ext_fi_tcl_e8_TCU_APP_Context::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_APP_Context::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_APP_Context::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_ProbePermitSetting::midw_ext_fi_tcl_e8_TCU_ProbePermitSetting():enType(FI_EN_OFF) {}

tS32 midw_ext_fi_tcl_e8_TCU_ProbePermitSetting::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_PROBEPERMITSETTING;
}


midw_ext_fi_tcl_e8_TCU_ProbePermitSetting::~midw_ext_fi_tcl_e8_TCU_ProbePermitSetting()
{}

tU32 midw_ext_fi_tcl_e8_TCU_ProbePermitSetting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_ProbePermitSetting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_ProbePermitSetting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_PopUpFlag::midw_ext_fi_tcl_e8_TCU_PopUpFlag():enType(FI_EN_OFF) {}

tS32 midw_ext_fi_tcl_e8_TCU_PopUpFlag::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_POPUPFLAG;
}


midw_ext_fi_tcl_e8_TCU_PopUpFlag::~midw_ext_fi_tcl_e8_TCU_PopUpFlag()
{}

tU32 midw_ext_fi_tcl_e8_TCU_PopUpFlag::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_PopUpFlag::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_PopUpFlag::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_OperationRequest::midw_ext_fi_tcl_e8_TCU_OperationRequest():enType(FI_EN_CANCEL) {}

tS32 midw_ext_fi_tcl_e8_TCU_OperationRequest::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_OPERATIONREQUEST;
}


midw_ext_fi_tcl_e8_TCU_OperationRequest::~midw_ext_fi_tcl_e8_TCU_OperationRequest()
{}

tU32 midw_ext_fi_tcl_e8_TCU_OperationRequest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_OperationRequest::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_OperationRequest::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Date_Time::midw_ext_fi_tcl_TCU_Date_Time(const midw_ext_fi_tcl_TCU_Date_Time& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u16Year = coRef.u16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
   u8Reserve = coRef.u8Reserve;
}
midw_ext_fi_tcl_TCU_Date_Time& midw_ext_fi_tcl_TCU_Date_Time::operator=(const midw_ext_fi_tcl_TCU_Date_Time& coRef)
{
   if (this == &coRef) return *this;
   u16Year = coRef.u16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
   u8Reserve = coRef.u8Reserve;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Date_Time::midw_ext_fi_tcl_TCU_Date_Time()
:u16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hour(0)
,u8Minute(0)
,u8Second(0)
,u8Reserve(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Date_Time::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_DATE_TIME;
}


midw_ext_fi_tcl_TCU_Date_Time::~midw_ext_fi_tcl_TCU_Date_Time()
{}

tU32 midw_ext_fi_tcl_TCU_Date_Time::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Date_Time::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hour);
   (tVoid) (oIn >> u8Minute);
   (tVoid) (oIn >> u8Second);
   (tVoid) (oIn >> u8Reserve);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Date_Time::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hour);
   (tVoid) (oOut << u8Minute);
   (tVoid) (oOut << u8Second);
   (tVoid) (oOut << u8Reserve);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Date_Time::operator==(const midw_ext_fi_tcl_TCU_Date_Time& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16Year == roRef.u16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hour == roRef.u8Hour);
   bResult = bResult && (u8Minute == roRef.u8Minute);
   bResult = bResult && (u8Second == roRef.u8Second);
   bResult = bResult && (u8Reserve == roRef.u8Reserve);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_LocationType::midw_ext_fi_tcl_e8_TCU_LocationType():enType(FI_EN_TOKYO) {}

tS32 midw_ext_fi_tcl_e8_TCU_LocationType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_LOCATIONTYPE;
}


midw_ext_fi_tcl_e8_TCU_LocationType::~midw_ext_fi_tcl_e8_TCU_LocationType()
{}

tU32 midw_ext_fi_tcl_e8_TCU_LocationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_LocationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_LocationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Score_Info::midw_ext_fi_tcl_TCU_Score_Info(const midw_ext_fi_tcl_TCU_Score_Info& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8ECOScore = coRef.u8ECOScore;
   u8StartScore = coRef.u8StartScore;
   u8CruiseScore = coRef.u8CruiseScore;
   u8SlowdownScore = coRef.u8SlowdownScore;
}
midw_ext_fi_tcl_TCU_Score_Info& midw_ext_fi_tcl_TCU_Score_Info::operator=(const midw_ext_fi_tcl_TCU_Score_Info& coRef)
{
   if (this == &coRef) return *this;
   u8ECOScore = coRef.u8ECOScore;
   u8StartScore = coRef.u8StartScore;
   u8CruiseScore = coRef.u8CruiseScore;
   u8SlowdownScore = coRef.u8SlowdownScore;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Score_Info::midw_ext_fi_tcl_TCU_Score_Info()
:u8ECOScore(0)
,u8StartScore(0)
,u8CruiseScore(0)
,u8SlowdownScore(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Score_Info::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_SCORE_INFO;
}


midw_ext_fi_tcl_TCU_Score_Info::~midw_ext_fi_tcl_TCU_Score_Info()
{}

tU32 midw_ext_fi_tcl_TCU_Score_Info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Score_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8ECOScore);
   (tVoid) (oIn >> u8StartScore);
   (tVoid) (oIn >> u8CruiseScore);
   (tVoid) (oIn >> u8SlowdownScore);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Score_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8ECOScore);
   (tVoid) (oOut << u8StartScore);
   (tVoid) (oOut << u8CruiseScore);
   (tVoid) (oOut << u8SlowdownScore);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Score_Info::operator==(const midw_ext_fi_tcl_TCU_Score_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8ECOScore == roRef.u8ECOScore);
   bResult = bResult && (u8StartScore == roRef.u8StartScore);
   bResult = bResult && (u8CruiseScore == roRef.u8CruiseScore);
   bResult = bResult && (u8SlowdownScore == roRef.u8SlowdownScore);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Navi_Road_classification::midw_ext_fi_tcl_TCU_Navi_Road_classification(const midw_ext_fi_tcl_TCU_Navi_Road_classification& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8TableType = coRef.u8TableType;
   u8RoadType = coRef.u8RoadType;
}
midw_ext_fi_tcl_TCU_Navi_Road_classification& midw_ext_fi_tcl_TCU_Navi_Road_classification::operator=(const midw_ext_fi_tcl_TCU_Navi_Road_classification& coRef)
{
   if (this == &coRef) return *this;
   u8TableType = coRef.u8TableType;
   u8RoadType = coRef.u8RoadType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Navi_Road_classification::midw_ext_fi_tcl_TCU_Navi_Road_classification()
:u8TableType(0)
,u8RoadType(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Navi_Road_classification::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_NAVI_ROAD_CLASSIFICATION;
}


midw_ext_fi_tcl_TCU_Navi_Road_classification::~midw_ext_fi_tcl_TCU_Navi_Road_classification()
{}

tU32 midw_ext_fi_tcl_TCU_Navi_Road_classification::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Navi_Road_classification::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TableType);
   (tVoid) (oIn >> u8RoadType);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Navi_Road_classification::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TableType);
   (tVoid) (oOut << u8RoadType);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Navi_Road_classification::operator==(const midw_ext_fi_tcl_TCU_Navi_Road_classification& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TableType == roRef.u8TableType);
   bResult = bResult && (u8RoadType == roRef.u8RoadType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Distance_Value::midw_ext_fi_tcl_TCU_Distance_Value(const midw_ext_fi_tcl_TCU_Distance_Value& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u16OilFilter = coRef.u16OilFilter;
   u16Oil = coRef.u16Oil;
   u16Tire = coRef.u16Tire;
   u16User = coRef.u16User;
   u16Battery = coRef.u16Battery;
   u16ACFilter = coRef.u16ACFilter;
   u16Reserve = coRef.u16Reserve;
}
midw_ext_fi_tcl_TCU_Distance_Value& midw_ext_fi_tcl_TCU_Distance_Value::operator=(const midw_ext_fi_tcl_TCU_Distance_Value& coRef)
{
   if (this == &coRef) return *this;
   u16OilFilter = coRef.u16OilFilter;
   u16Oil = coRef.u16Oil;
   u16Tire = coRef.u16Tire;
   u16User = coRef.u16User;
   u16Battery = coRef.u16Battery;
   u16ACFilter = coRef.u16ACFilter;
   u16Reserve = coRef.u16Reserve;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Distance_Value::midw_ext_fi_tcl_TCU_Distance_Value()
:u16OilFilter(0)
,u16Oil(0)
,u16Tire(0)
,u16User(0)
,u16Battery(0)
,u16ACFilter(0)
,u16Reserve(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Distance_Value::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_DISTANCE_VALUE;
}


midw_ext_fi_tcl_TCU_Distance_Value::~midw_ext_fi_tcl_TCU_Distance_Value()
{}

tU32 midw_ext_fi_tcl_TCU_Distance_Value::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Distance_Value::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16OilFilter);
   (tVoid) (oIn >> u16Oil);
   (tVoid) (oIn >> u16Tire);
   (tVoid) (oIn >> u16User);
   (tVoid) (oIn >> u16Battery);
   (tVoid) (oIn >> u16ACFilter);
   (tVoid) (oIn >> u16Reserve);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Distance_Value::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16OilFilter);
   (tVoid) (oOut << u16Oil);
   (tVoid) (oOut << u16Tire);
   (tVoid) (oOut << u16User);
   (tVoid) (oOut << u16Battery);
   (tVoid) (oOut << u16ACFilter);
   (tVoid) (oOut << u16Reserve);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Distance_Value::operator==(const midw_ext_fi_tcl_TCU_Distance_Value& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16OilFilter == roRef.u16OilFilter);
   bResult = bResult && (u16Oil == roRef.u16Oil);
   bResult = bResult && (u16Tire == roRef.u16Tire);
   bResult = bResult && (u16User == roRef.u16User);
   bResult = bResult && (u16Battery == roRef.u16Battery);
   bResult = bResult && (u16ACFilter == roRef.u16ACFilter);
   bResult = bResult && (u16Reserve == roRef.u16Reserve);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Distance_Unit::midw_ext_fi_tcl_e8_TCU_Distance_Unit():enType(FI_EN_MILE) {}

tS32 midw_ext_fi_tcl_e8_TCU_Distance_Unit::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_DISTANCE_UNIT;
}


midw_ext_fi_tcl_e8_TCU_Distance_Unit::~midw_ext_fi_tcl_e8_TCU_Distance_Unit()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Distance_Unit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Distance_Unit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Distance_Unit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Provision_List::midw_ext_fi_tcl_TCU_Provision_List(const midw_ext_fi_tcl_TCU_Provision_List& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   bOperatorService = coRef.bOperatorService;
   bConnectedSearch = coRef.bConnectedSearch;
   bMobileInformation = coRef.bMobileInformation;
   u16ReserveNissan = coRef.u16ReserveNissan;
   bInternetWidget = coRef.bInternetWidget;
   bFuelPrice = coRef.bFuelPrice;
   bLocalSearch = coRef.bLocalSearch;
   bWebPreTrip = coRef.bWebPreTrip;
   bHDTraffic = coRef.bHDTraffic;
   bSpeedTrap = coRef.bSpeedTrap;
   bPreventNav = coRef.bPreventNav;
   bWeather = coRef.bWeather;
   bLiveServices = coRef.bLiveServices;
   bChargingSpotFinder = coRef.bChargingSpotFinder;
   bChargingSchedule = coRef.bChargingSchedule;
   u16ReserveRenault = coRef.u16ReserveRenault;
}
midw_ext_fi_tcl_TCU_Provision_List& midw_ext_fi_tcl_TCU_Provision_List::operator=(const midw_ext_fi_tcl_TCU_Provision_List& coRef)
{
   if (this == &coRef) return *this;
   bOperatorService = coRef.bOperatorService;
   bConnectedSearch = coRef.bConnectedSearch;
   bMobileInformation = coRef.bMobileInformation;
   u16ReserveNissan = coRef.u16ReserveNissan;
   bInternetWidget = coRef.bInternetWidget;
   bFuelPrice = coRef.bFuelPrice;
   bLocalSearch = coRef.bLocalSearch;
   bWebPreTrip = coRef.bWebPreTrip;
   bHDTraffic = coRef.bHDTraffic;
   bSpeedTrap = coRef.bSpeedTrap;
   bPreventNav = coRef.bPreventNav;
   bWeather = coRef.bWeather;
   bLiveServices = coRef.bLiveServices;
   bChargingSpotFinder = coRef.bChargingSpotFinder;
   bChargingSchedule = coRef.bChargingSchedule;
   u16ReserveRenault = coRef.u16ReserveRenault;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Provision_List::midw_ext_fi_tcl_TCU_Provision_List()
:bOperatorService(0)
,bConnectedSearch(0)
,bMobileInformation(0)
,u16ReserveNissan(0)
,bInternetWidget(0)
,bFuelPrice(0)
,bLocalSearch(0)
,bWebPreTrip(0)
,bHDTraffic(0)
,bSpeedTrap(0)
,bPreventNav(0)
,bWeather(0)
,bLiveServices(0)
,bChargingSpotFinder(0)
,bChargingSchedule(0)
,u16ReserveRenault(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Provision_List::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_PROVISION_LIST;
}


midw_ext_fi_tcl_TCU_Provision_List::~midw_ext_fi_tcl_TCU_Provision_List()
{}

tU32 midw_ext_fi_tcl_TCU_Provision_List::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Provision_List::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bOperatorService);
   (tVoid) (oIn >> bConnectedSearch);
   (tVoid) (oIn >> bMobileInformation);
   (tVoid) (oIn >> u16ReserveNissan);
   (tVoid) (oIn >> bInternetWidget);
   (tVoid) (oIn >> bFuelPrice);
   (tVoid) (oIn >> bLocalSearch);
   (tVoid) (oIn >> bWebPreTrip);
   (tVoid) (oIn >> bHDTraffic);
   (tVoid) (oIn >> bSpeedTrap);
   (tVoid) (oIn >> bPreventNav);
   (tVoid) (oIn >> bWeather);
   (tVoid) (oIn >> bLiveServices);
   (tVoid) (oIn >> bChargingSpotFinder);
   (tVoid) (oIn >> bChargingSchedule);
   (tVoid) (oIn >> u16ReserveRenault);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Provision_List::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bOperatorService);
   (tVoid) (oOut << bConnectedSearch);
   (tVoid) (oOut << bMobileInformation);
   (tVoid) (oOut << u16ReserveNissan);
   (tVoid) (oOut << bInternetWidget);
   (tVoid) (oOut << bFuelPrice);
   (tVoid) (oOut << bLocalSearch);
   (tVoid) (oOut << bWebPreTrip);
   (tVoid) (oOut << bHDTraffic);
   (tVoid) (oOut << bSpeedTrap);
   (tVoid) (oOut << bPreventNav);
   (tVoid) (oOut << bWeather);
   (tVoid) (oOut << bLiveServices);
   (tVoid) (oOut << bChargingSpotFinder);
   (tVoid) (oOut << bChargingSchedule);
   (tVoid) (oOut << u16ReserveRenault);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Provision_List::operator==(const midw_ext_fi_tcl_TCU_Provision_List& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bOperatorService == roRef.bOperatorService);
   bResult = bResult && (bConnectedSearch == roRef.bConnectedSearch);
   bResult = bResult && (bMobileInformation == roRef.bMobileInformation);
   bResult = bResult && (u16ReserveNissan == roRef.u16ReserveNissan);
   bResult = bResult && (bInternetWidget == roRef.bInternetWidget);
   bResult = bResult && (bFuelPrice == roRef.bFuelPrice);
   bResult = bResult && (bLocalSearch == roRef.bLocalSearch);
   bResult = bResult && (bWebPreTrip == roRef.bWebPreTrip);
   bResult = bResult && (bHDTraffic == roRef.bHDTraffic);
   bResult = bResult && (bSpeedTrap == roRef.bSpeedTrap);
   bResult = bResult && (bPreventNav == roRef.bPreventNav);
   bResult = bResult && (bWeather == roRef.bWeather);
   bResult = bResult && (bLiveServices == roRef.bLiveServices);
   bResult = bResult && (bChargingSpotFinder == roRef.bChargingSpotFinder);
   bResult = bResult && (bChargingSchedule == roRef.bChargingSchedule);
   bResult = bResult && (u16ReserveRenault == roRef.u16ReserveRenault);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_EcallStateDisplay::midw_ext_fi_tcl_e8_TCU_EcallStateDisplay():enType(FI_EN_NOTHINGTODISPLAY) {}

tS32 midw_ext_fi_tcl_e8_TCU_EcallStateDisplay::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_ECALLSTATEDISPLAY;
}


midw_ext_fi_tcl_e8_TCU_EcallStateDisplay::~midw_ext_fi_tcl_e8_TCU_EcallStateDisplay()
{}

tU32 midw_ext_fi_tcl_e8_TCU_EcallStateDisplay::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_EcallStateDisplay::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_EcallStateDisplay::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Maintenance_Info::midw_ext_fi_tcl_TCU_Maintenance_Info(const midw_ext_fi_tcl_TCU_Maintenance_Info& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8DistanceUnit = coRef.e8DistanceUnit;
   rDistanceValue = coRef.rDistanceValue;
}
midw_ext_fi_tcl_TCU_Maintenance_Info& midw_ext_fi_tcl_TCU_Maintenance_Info::operator=(const midw_ext_fi_tcl_TCU_Maintenance_Info& coRef)
{
   if (this == &coRef) return *this;
   e8DistanceUnit = coRef.e8DistanceUnit;
   rDistanceValue = coRef.rDistanceValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Maintenance_Info::midw_ext_fi_tcl_TCU_Maintenance_Info()
:e8DistanceUnit()
,rDistanceValue()
 {}

tS32 midw_ext_fi_tcl_TCU_Maintenance_Info::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_MAINTENANCE_INFO;
}


midw_ext_fi_tcl_TCU_Maintenance_Info::~midw_ext_fi_tcl_TCU_Maintenance_Info()
{}

tU32 midw_ext_fi_tcl_TCU_Maintenance_Info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Maintenance_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DistanceUnit);
   (tVoid) (oIn >> rDistanceValue);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Maintenance_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DistanceUnit);
   (tVoid) (oOut << rDistanceValue);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Maintenance_Info::operator==(const midw_ext_fi_tcl_TCU_Maintenance_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DistanceUnit == roRef.e8DistanceUnit);
   bResult = bResult && (rDistanceValue == roRef.rDistanceValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_LatitudeMode::midw_ext_fi_tcl_e8_TCU_LatitudeMode():enType(FI_EN_NORTH) {}

tS32 midw_ext_fi_tcl_e8_TCU_LatitudeMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_LATITUDEMODE;
}


midw_ext_fi_tcl_e8_TCU_LatitudeMode::~midw_ext_fi_tcl_e8_TCU_LatitudeMode()
{}

tU32 midw_ext_fi_tcl_e8_TCU_LatitudeMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_LatitudeMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_LatitudeMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_LongitudeMode::midw_ext_fi_tcl_e8_TCU_LongitudeMode():enType(FI_EN_EAST) {}

tS32 midw_ext_fi_tcl_e8_TCU_LongitudeMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_LONGITUDEMODE;
}


midw_ext_fi_tcl_e8_TCU_LongitudeMode::~midw_ext_fi_tcl_e8_TCU_LongitudeMode()
{}

tU32 midw_ext_fi_tcl_e8_TCU_LongitudeMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_LongitudeMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_LongitudeMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Sign::midw_ext_fi_tcl_e8_TCU_Sign():enType(FI_EN_MINUS) {}

tS32 midw_ext_fi_tcl_e8_TCU_Sign::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_SIGN;
}


midw_ext_fi_tcl_e8_TCU_Sign::~midw_ext_fi_tcl_e8_TCU_Sign()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Sign::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Sign::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Sign::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Home::midw_ext_fi_tcl_e8_TCU_Home():enType(FI_EN_INSIDE) {}

tS32 midw_ext_fi_tcl_e8_TCU_Home::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_HOME;
}


midw_ext_fi_tcl_e8_TCU_Home::~midw_ext_fi_tcl_e8_TCU_Home()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Home::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Home::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Home::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Altitude::midw_ext_fi_tcl_TCU_Altitude(const midw_ext_fi_tcl_TCU_Altitude& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8Sign = coRef.e8Sign;
   u16Value = coRef.u16Value;
}
midw_ext_fi_tcl_TCU_Altitude& midw_ext_fi_tcl_TCU_Altitude::operator=(const midw_ext_fi_tcl_TCU_Altitude& coRef)
{
   if (this == &coRef) return *this;
   e8Sign = coRef.e8Sign;
   u16Value = coRef.u16Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Altitude::midw_ext_fi_tcl_TCU_Altitude()
:e8Sign()
,u16Value(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Altitude::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_ALTITUDE;
}


midw_ext_fi_tcl_TCU_Altitude::~midw_ext_fi_tcl_TCU_Altitude()
{}

tU32 midw_ext_fi_tcl_TCU_Altitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Altitude::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Sign);
   (tVoid) (oIn >> u16Value);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Altitude::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Sign);
   (tVoid) (oOut << u16Value);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Altitude::operator==(const midw_ext_fi_tcl_TCU_Altitude& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Sign == roRef.e8Sign);
   bResult = bResult && (u16Value == roRef.u16Value);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_LocationInfo::midw_ext_fi_tcl_TCU_LocationInfo(const midw_ext_fi_tcl_TCU_LocationInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8LocationType = coRef.e8LocationType;
   e8Latitudemode = coRef.e8Latitudemode;
   e8LongitudeMode = coRef.e8LongitudeMode;
   u8LatitudeDEG = coRef.u8LatitudeDEG;
   u8LatitudeMIN = coRef.u8LatitudeMIN;
   u16LatitudeSEC = coRef.u16LatitudeSEC;
   u8LongitudeDEG = coRef.u8LongitudeDEG;
   u8LongitudeMIN = coRef.u8LongitudeMIN;
   u16LongitudeSEC = coRef.u16LongitudeSEC;
   Altitude = coRef.Altitude;
   u8SatelliteNumber = coRef.u8SatelliteNumber;
   e8Home = coRef.e8Home;
   u8Reserve = coRef.u8Reserve;
}
midw_ext_fi_tcl_TCU_LocationInfo& midw_ext_fi_tcl_TCU_LocationInfo::operator=(const midw_ext_fi_tcl_TCU_LocationInfo& coRef)
{
   if (this == &coRef) return *this;
   e8LocationType = coRef.e8LocationType;
   e8Latitudemode = coRef.e8Latitudemode;
   e8LongitudeMode = coRef.e8LongitudeMode;
   u8LatitudeDEG = coRef.u8LatitudeDEG;
   u8LatitudeMIN = coRef.u8LatitudeMIN;
   u16LatitudeSEC = coRef.u16LatitudeSEC;
   u8LongitudeDEG = coRef.u8LongitudeDEG;
   u8LongitudeMIN = coRef.u8LongitudeMIN;
   u16LongitudeSEC = coRef.u16LongitudeSEC;
   Altitude = coRef.Altitude;
   u8SatelliteNumber = coRef.u8SatelliteNumber;
   e8Home = coRef.e8Home;
   u8Reserve = coRef.u8Reserve;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_LocationInfo::midw_ext_fi_tcl_TCU_LocationInfo()
:e8LocationType()
,e8Latitudemode()
,e8LongitudeMode()
,u8LatitudeDEG(0)
,u8LatitudeMIN(0)
,u16LatitudeSEC(0)
,u8LongitudeDEG(0)
,u8LongitudeMIN(0)
,u16LongitudeSEC(0)
,Altitude()
,u8SatelliteNumber(0)
,e8Home()
,u8Reserve(0)
 {}

tS32 midw_ext_fi_tcl_TCU_LocationInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_LOCATIONINFO;
}


midw_ext_fi_tcl_TCU_LocationInfo::~midw_ext_fi_tcl_TCU_LocationInfo()
{}

tU32 midw_ext_fi_tcl_TCU_LocationInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_LocationInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LocationType);
   (tVoid) (oIn >> e8Latitudemode);
   (tVoid) (oIn >> e8LongitudeMode);
   (tVoid) (oIn >> u8LatitudeDEG);
   (tVoid) (oIn >> u8LatitudeMIN);
   (tVoid) (oIn >> u16LatitudeSEC);
   (tVoid) (oIn >> u8LongitudeDEG);
   (tVoid) (oIn >> u8LongitudeMIN);
   (tVoid) (oIn >> u16LongitudeSEC);
   (tVoid) (oIn >> Altitude);
   (tVoid) (oIn >> u8SatelliteNumber);
   (tVoid) (oIn >> e8Home);
   (tVoid) (oIn >> u8Reserve);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_LocationInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LocationType);
   (tVoid) (oOut << e8Latitudemode);
   (tVoid) (oOut << e8LongitudeMode);
   (tVoid) (oOut << u8LatitudeDEG);
   (tVoid) (oOut << u8LatitudeMIN);
   (tVoid) (oOut << u16LatitudeSEC);
   (tVoid) (oOut << u8LongitudeDEG);
   (tVoid) (oOut << u8LongitudeMIN);
   (tVoid) (oOut << u16LongitudeSEC);
   (tVoid) (oOut << Altitude);
   (tVoid) (oOut << u8SatelliteNumber);
   (tVoid) (oOut << e8Home);
   (tVoid) (oOut << u8Reserve);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_LocationInfo::operator==(const midw_ext_fi_tcl_TCU_LocationInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LocationType == roRef.e8LocationType);
   bResult = bResult && (e8Latitudemode == roRef.e8Latitudemode);
   bResult = bResult && (e8LongitudeMode == roRef.e8LongitudeMode);
   bResult = bResult && (u8LatitudeDEG == roRef.u8LatitudeDEG);
   bResult = bResult && (u8LatitudeMIN == roRef.u8LatitudeMIN);
   bResult = bResult && (u16LatitudeSEC == roRef.u16LatitudeSEC);
   bResult = bResult && (u8LongitudeDEG == roRef.u8LongitudeDEG);
   bResult = bResult && (u8LongitudeMIN == roRef.u8LongitudeMIN);
   bResult = bResult && (u16LongitudeSEC == roRef.u16LongitudeSEC);
   bResult = bResult && (Altitude == roRef.Altitude);
   bResult = bResult && (u8SatelliteNumber == roRef.u8SatelliteNumber);
   bResult = bResult && (e8Home == roRef.e8Home);
   bResult = bResult && (u8Reserve == roRef.u8Reserve);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Navi_Info::midw_ext_fi_tcl_TCU_Navi_Info(const midw_ext_fi_tcl_TCU_Navi_Info& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   LocationInfo = coRef.LocationInfo;
   rDateTime = coRef.rDateTime;
   u16VehicleHeading = coRef.u16VehicleHeading;
   u8TimeZone = coRef.u8TimeZone;
}
midw_ext_fi_tcl_TCU_Navi_Info& midw_ext_fi_tcl_TCU_Navi_Info::operator=(const midw_ext_fi_tcl_TCU_Navi_Info& coRef)
{
   if (this == &coRef) return *this;
   LocationInfo = coRef.LocationInfo;
   rDateTime = coRef.rDateTime;
   u16VehicleHeading = coRef.u16VehicleHeading;
   u8TimeZone = coRef.u8TimeZone;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Navi_Info::midw_ext_fi_tcl_TCU_Navi_Info()
:LocationInfo()
,rDateTime()
,u16VehicleHeading(0)
,u8TimeZone(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Navi_Info::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_NAVI_INFO;
}


midw_ext_fi_tcl_TCU_Navi_Info::~midw_ext_fi_tcl_TCU_Navi_Info()
{}

tU32 midw_ext_fi_tcl_TCU_Navi_Info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 28;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Navi_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LocationInfo);
   (tVoid) (oIn >> rDateTime);
   (tVoid) (oIn >> u16VehicleHeading);
   (tVoid) (oIn >> u8TimeZone);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Navi_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LocationInfo);
   (tVoid) (oOut << rDateTime);
   (tVoid) (oOut << u16VehicleHeading);
   (tVoid) (oOut << u8TimeZone);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Navi_Info::operator==(const midw_ext_fi_tcl_TCU_Navi_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LocationInfo == roRef.LocationInfo);
   bResult = bResult && (rDateTime == roRef.rDateTime);
   bResult = bResult && (u16VehicleHeading == roRef.u16VehicleHeading);
   bResult = bResult && (u8TimeZone == roRef.u8TimeZone);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Probe_Vehicle_Info::midw_ext_fi_tcl_TCU_Probe_Vehicle_Info(const midw_ext_fi_tcl_TCU_Probe_Vehicle_Info& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u16NaviVehicleSpeed = coRef.u16NaviVehicleSpeed;
   u32NaviDrivingDistance = coRef.u32NaviDrivingDistance;
   NaviRoadClassification = coRef.NaviRoadClassification;
}
midw_ext_fi_tcl_TCU_Probe_Vehicle_Info& midw_ext_fi_tcl_TCU_Probe_Vehicle_Info::operator=(const midw_ext_fi_tcl_TCU_Probe_Vehicle_Info& coRef)
{
   if (this == &coRef) return *this;
   u16NaviVehicleSpeed = coRef.u16NaviVehicleSpeed;
   u32NaviDrivingDistance = coRef.u32NaviDrivingDistance;
   NaviRoadClassification = coRef.NaviRoadClassification;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Probe_Vehicle_Info::midw_ext_fi_tcl_TCU_Probe_Vehicle_Info()
:u16NaviVehicleSpeed(0)
,u32NaviDrivingDistance(0)
,NaviRoadClassification()
 {}

tS32 midw_ext_fi_tcl_TCU_Probe_Vehicle_Info::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_PROBE_VEHICLE_INFO;
}


midw_ext_fi_tcl_TCU_Probe_Vehicle_Info::~midw_ext_fi_tcl_TCU_Probe_Vehicle_Info()
{}

tU32 midw_ext_fi_tcl_TCU_Probe_Vehicle_Info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Probe_Vehicle_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16NaviVehicleSpeed);
   (tVoid) (oIn >> u32NaviDrivingDistance);
   (tVoid) (oIn >> NaviRoadClassification);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Probe_Vehicle_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16NaviVehicleSpeed);
   (tVoid) (oOut << u32NaviDrivingDistance);
   (tVoid) (oOut << NaviRoadClassification);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Probe_Vehicle_Info::operator==(const midw_ext_fi_tcl_TCU_Probe_Vehicle_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16NaviVehicleSpeed == roRef.u16NaviVehicleSpeed);
   bResult = bResult && (u32NaviDrivingDistance == roRef.u32NaviDrivingDistance);
   bResult = bResult && (NaviRoadClassification == roRef.NaviRoadClassification);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Opcode::midw_ext_fi_tcl_e8_TCU_Opcode():enType(FI_EN_INDICATION) {}

tS32 midw_ext_fi_tcl_e8_TCU_Opcode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_OPCODE;
}


midw_ext_fi_tcl_e8_TCU_Opcode::~midw_ext_fi_tcl_e8_TCU_Opcode()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Opcode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Opcode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Opcode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Mode::midw_ext_fi_tcl_e8_TCU_Mode():enType(FI_EN_OFF) {}

tS32 midw_ext_fi_tcl_e8_TCU_Mode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_MODE;
}


midw_ext_fi_tcl_e8_TCU_Mode::~midw_ext_fi_tcl_e8_TCU_Mode()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Mode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_ReminderInfo::midw_ext_fi_tcl_TCU_ReminderInfo(const midw_ext_fi_tcl_TCU_ReminderInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8Plugin_Mode = coRef.e8Plugin_Mode;
   e8Stop_Mode = coRef.e8Stop_Mode;
   u16RemainTime = coRef.u16RemainTime;
}
midw_ext_fi_tcl_TCU_ReminderInfo& midw_ext_fi_tcl_TCU_ReminderInfo::operator=(const midw_ext_fi_tcl_TCU_ReminderInfo& coRef)
{
   if (this == &coRef) return *this;
   e8Plugin_Mode = coRef.e8Plugin_Mode;
   e8Stop_Mode = coRef.e8Stop_Mode;
   u16RemainTime = coRef.u16RemainTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_ReminderInfo::midw_ext_fi_tcl_TCU_ReminderInfo()
:e8Plugin_Mode()
,e8Stop_Mode()
,u16RemainTime(0)
 {}

tS32 midw_ext_fi_tcl_TCU_ReminderInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_REMINDERINFO;
}


midw_ext_fi_tcl_TCU_ReminderInfo::~midw_ext_fi_tcl_TCU_ReminderInfo()
{}

tU32 midw_ext_fi_tcl_TCU_ReminderInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_ReminderInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Plugin_Mode);
   (tVoid) (oIn >> e8Stop_Mode);
   (tVoid) (oIn >> u16RemainTime);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_ReminderInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Plugin_Mode);
   (tVoid) (oOut << e8Stop_Mode);
   (tVoid) (oOut << u16RemainTime);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_ReminderInfo::operator==(const midw_ext_fi_tcl_TCU_ReminderInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Plugin_Mode == roRef.e8Plugin_Mode);
   bResult = bResult && (e8Stop_Mode == roRef.e8Stop_Mode);
   bResult = bResult && (u16RemainTime == roRef.u16RemainTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Service_Type::midw_ext_fi_tcl_e8_TCU_Service_Type():enType(FI_EN_COMPATIBLESTATIONFINDER) {}

tS32 midw_ext_fi_tcl_e8_TCU_Service_Type::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_SERVICE_TYPE;
}


midw_ext_fi_tcl_e8_TCU_Service_Type::~midw_ext_fi_tcl_e8_TCU_Service_Type()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Service_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Service_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Service_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_ePOI_Type::midw_ext_fi_tcl_e8_TCU_ePOI_Type():enType(FI_EN_UNSPECIFIED) {}

tS32 midw_ext_fi_tcl_e8_TCU_ePOI_Type::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_EPOI_TYPE;
}


midw_ext_fi_tcl_e8_TCU_ePOI_Type::~midw_ext_fi_tcl_e8_TCU_ePOI_Type()
{}

tU32 midw_ext_fi_tcl_e8_TCU_ePOI_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_ePOI_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_ePOI_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Finder_Status::midw_ext_fi_tcl_e8_TCU_Finder_Status():enType(FI_EN_NO_SEARCH) {}

tS32 midw_ext_fi_tcl_e8_TCU_Finder_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_FINDER_STATUS;
}


midw_ext_fi_tcl_e8_TCU_Finder_Status::~midw_ext_fi_tcl_e8_TCU_Finder_Status()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Finder_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Finder_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Finder_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_GPS_Position::midw_ext_fi_tcl_TCU_GPS_Position(const midw_ext_fi_tcl_TCU_GPS_Position& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Reserved = coRef.u8Reserved;
   e8LocationType = coRef.e8LocationType;
   e8Latitudemode = coRef.e8Latitudemode;
   e8LongitudeMode = coRef.e8LongitudeMode;
   u8LatitudeDEG = coRef.u8LatitudeDEG;
   u8LatitudeMIN = coRef.u8LatitudeMIN;
   u16LatitudeSEC = coRef.u16LatitudeSEC;
   u8LongitudeDEG = coRef.u8LongitudeDEG;
   u8LongitudeMIN = coRef.u8LongitudeMIN;
   u16LongitudeSEC = coRef.u16LongitudeSEC;
}
midw_ext_fi_tcl_TCU_GPS_Position& midw_ext_fi_tcl_TCU_GPS_Position::operator=(const midw_ext_fi_tcl_TCU_GPS_Position& coRef)
{
   if (this == &coRef) return *this;
   u8Reserved = coRef.u8Reserved;
   e8LocationType = coRef.e8LocationType;
   e8Latitudemode = coRef.e8Latitudemode;
   e8LongitudeMode = coRef.e8LongitudeMode;
   u8LatitudeDEG = coRef.u8LatitudeDEG;
   u8LatitudeMIN = coRef.u8LatitudeMIN;
   u16LatitudeSEC = coRef.u16LatitudeSEC;
   u8LongitudeDEG = coRef.u8LongitudeDEG;
   u8LongitudeMIN = coRef.u8LongitudeMIN;
   u16LongitudeSEC = coRef.u16LongitudeSEC;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_GPS_Position::midw_ext_fi_tcl_TCU_GPS_Position()
:u8Reserved(0)
,e8LocationType()
,e8Latitudemode()
,e8LongitudeMode()
,u8LatitudeDEG(0)
,u8LatitudeMIN(0)
,u16LatitudeSEC(0)
,u8LongitudeDEG(0)
,u8LongitudeMIN(0)
,u16LongitudeSEC(0)
 {}

tS32 midw_ext_fi_tcl_TCU_GPS_Position::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_GPS_POSITION;
}


midw_ext_fi_tcl_TCU_GPS_Position::~midw_ext_fi_tcl_TCU_GPS_Position()
{}

tU32 midw_ext_fi_tcl_TCU_GPS_Position::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_GPS_Position::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Reserved);
   (tVoid) (oIn >> e8LocationType);
   (tVoid) (oIn >> e8Latitudemode);
   (tVoid) (oIn >> e8LongitudeMode);
   (tVoid) (oIn >> u8LatitudeDEG);
   (tVoid) (oIn >> u8LatitudeMIN);
   (tVoid) (oIn >> u16LatitudeSEC);
   (tVoid) (oIn >> u8LongitudeDEG);
   (tVoid) (oIn >> u8LongitudeMIN);
   (tVoid) (oIn >> u16LongitudeSEC);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_GPS_Position::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Reserved);
   (tVoid) (oOut << e8LocationType);
   (tVoid) (oOut << e8Latitudemode);
   (tVoid) (oOut << e8LongitudeMode);
   (tVoid) (oOut << u8LatitudeDEG);
   (tVoid) (oOut << u8LatitudeMIN);
   (tVoid) (oOut << u16LatitudeSEC);
   (tVoid) (oOut << u8LongitudeDEG);
   (tVoid) (oOut << u8LongitudeMIN);
   (tVoid) (oOut << u16LongitudeSEC);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_GPS_Position::operator==(const midw_ext_fi_tcl_TCU_GPS_Position& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Reserved == roRef.u8Reserved);
   bResult = bResult && (e8LocationType == roRef.e8LocationType);
   bResult = bResult && (e8Latitudemode == roRef.e8Latitudemode);
   bResult = bResult && (e8LongitudeMode == roRef.e8LongitudeMode);
   bResult = bResult && (u8LatitudeDEG == roRef.u8LatitudeDEG);
   bResult = bResult && (u8LatitudeMIN == roRef.u8LatitudeMIN);
   bResult = bResult && (u16LatitudeSEC == roRef.u16LatitudeSEC);
   bResult = bResult && (u8LongitudeDEG == roRef.u8LongitudeDEG);
   bResult = bResult && (u8LongitudeMIN == roRef.u8LongitudeMIN);
   bResult = bResult && (u16LongitudeSEC == roRef.u16LongitudeSEC);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Time_Stamp::midw_ext_fi_tcl_TCU_Time_Stamp(const midw_ext_fi_tcl_TCU_Time_Stamp& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Year = coRef.u8Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
}
midw_ext_fi_tcl_TCU_Time_Stamp& midw_ext_fi_tcl_TCU_Time_Stamp::operator=(const midw_ext_fi_tcl_TCU_Time_Stamp& coRef)
{
   if (this == &coRef) return *this;
   u8Year = coRef.u8Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Time_Stamp::midw_ext_fi_tcl_TCU_Time_Stamp()
:u8Year(0)
,u8Month(0)
,u8Day(0)
,u8Hour(0)
,u8Minute(0)
,u8Second(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Time_Stamp::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_TIME_STAMP;
}


midw_ext_fi_tcl_TCU_Time_Stamp::~midw_ext_fi_tcl_TCU_Time_Stamp()
{}

tU32 midw_ext_fi_tcl_TCU_Time_Stamp::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Time_Stamp::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hour);
   (tVoid) (oIn >> u8Minute);
   (tVoid) (oIn >> u8Second);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Time_Stamp::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hour);
   (tVoid) (oOut << u8Minute);
   (tVoid) (oOut << u8Second);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Time_Stamp::operator==(const midw_ext_fi_tcl_TCU_Time_Stamp& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Year == roRef.u8Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hour == roRef.u8Hour);
   bResult = bResult && (u8Minute == roRef.u8Minute);
   bResult = bResult && (u8Second == roRef.u8Second);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Opening_Hour_Day::midw_ext_fi_tcl_TCU_Opening_Hour_Day(const midw_ext_fi_tcl_TCU_Opening_Hour_Day& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8StartTime_1 = coRef.u8StartTime_1;
   u8StartTime_2 = coRef.u8StartTime_2;
   u8EndTime_1 = coRef.u8EndTime_1;
   u8EndTime_2 = coRef.u8EndTime_2;
}
midw_ext_fi_tcl_TCU_Opening_Hour_Day& midw_ext_fi_tcl_TCU_Opening_Hour_Day::operator=(const midw_ext_fi_tcl_TCU_Opening_Hour_Day& coRef)
{
   if (this == &coRef) return *this;
   u8StartTime_1 = coRef.u8StartTime_1;
   u8StartTime_2 = coRef.u8StartTime_2;
   u8EndTime_1 = coRef.u8EndTime_1;
   u8EndTime_2 = coRef.u8EndTime_2;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Opening_Hour_Day::midw_ext_fi_tcl_TCU_Opening_Hour_Day()
:u8StartTime_1(0)
,u8StartTime_2(0)
,u8EndTime_1(0)
,u8EndTime_2(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Opening_Hour_Day::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_OPENING_HOUR_DAY;
}


midw_ext_fi_tcl_TCU_Opening_Hour_Day::~midw_ext_fi_tcl_TCU_Opening_Hour_Day()
{}

tU32 midw_ext_fi_tcl_TCU_Opening_Hour_Day::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Opening_Hour_Day::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8StartTime_1);
   (tVoid) (oIn >> u8StartTime_2);
   (tVoid) (oIn >> u8EndTime_1);
   (tVoid) (oIn >> u8EndTime_2);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Opening_Hour_Day::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8StartTime_1);
   (tVoid) (oOut << u8StartTime_2);
   (tVoid) (oOut << u8EndTime_1);
   (tVoid) (oOut << u8EndTime_2);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Opening_Hour_Day::operator==(const midw_ext_fi_tcl_TCU_Opening_Hour_Day& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8StartTime_1 == roRef.u8StartTime_1);
   bResult = bResult && (u8StartTime_2 == roRef.u8StartTime_2);
   bResult = bResult && (u8EndTime_1 == roRef.u8EndTime_1);
   bResult = bResult && (u8EndTime_2 == roRef.u8EndTime_2);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Opening_Hour::midw_ext_fi_tcl_TCU_Opening_Hour(const midw_ext_fi_tcl_TCU_Opening_Hour& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   rSunday = coRef.rSunday;
   rMonday = coRef.rMonday;
   rTuesday = coRef.rTuesday;
   rWednesday = coRef.rWednesday;
   rThursday = coRef.rThursday;
   rFriday = coRef.rFriday;
   rSaturday = coRef.rSaturday;
}
midw_ext_fi_tcl_TCU_Opening_Hour& midw_ext_fi_tcl_TCU_Opening_Hour::operator=(const midw_ext_fi_tcl_TCU_Opening_Hour& coRef)
{
   if (this == &coRef) return *this;
   rSunday = coRef.rSunday;
   rMonday = coRef.rMonday;
   rTuesday = coRef.rTuesday;
   rWednesday = coRef.rWednesday;
   rThursday = coRef.rThursday;
   rFriday = coRef.rFriday;
   rSaturday = coRef.rSaturday;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Opening_Hour::midw_ext_fi_tcl_TCU_Opening_Hour()
:rSunday()
,rMonday()
,rTuesday()
,rWednesday()
,rThursday()
,rFriday()
,rSaturday()
 {}

tS32 midw_ext_fi_tcl_TCU_Opening_Hour::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_OPENING_HOUR;
}


midw_ext_fi_tcl_TCU_Opening_Hour::~midw_ext_fi_tcl_TCU_Opening_Hour()
{}

tU32 midw_ext_fi_tcl_TCU_Opening_Hour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 28;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Opening_Hour::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rSunday);
   (tVoid) (oIn >> rMonday);
   (tVoid) (oIn >> rTuesday);
   (tVoid) (oIn >> rWednesday);
   (tVoid) (oIn >> rThursday);
   (tVoid) (oIn >> rFriday);
   (tVoid) (oIn >> rSaturday);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Opening_Hour::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rSunday);
   (tVoid) (oOut << rMonday);
   (tVoid) (oOut << rTuesday);
   (tVoid) (oOut << rWednesday);
   (tVoid) (oOut << rThursday);
   (tVoid) (oOut << rFriday);
   (tVoid) (oOut << rSaturday);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Opening_Hour::operator==(const midw_ext_fi_tcl_TCU_Opening_Hour& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rSunday == roRef.rSunday);
   bResult = bResult && (rMonday == roRef.rMonday);
   bResult = bResult && (rTuesday == roRef.rTuesday);
   bResult = bResult && (rWednesday == roRef.rWednesday);
   bResult = bResult && (rThursday == roRef.rThursday);
   bResult = bResult && (rFriday == roRef.rFriday);
   bResult = bResult && (rSaturday == roRef.rSaturday);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Charge_Station_Accessibility::midw_ext_fi_tcl_TCU_Charge_Station_Accessibility():enType(FI_EN_UNSPECIFIED) {}

tS32 midw_ext_fi_tcl_TCU_Charge_Station_Accessibility::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_CHARGE_STATION_ACCESSIBILITY;
}


midw_ext_fi_tcl_TCU_Charge_Station_Accessibility::~midw_ext_fi_tcl_TCU_Charge_Station_Accessibility()
{}

tU32 midw_ext_fi_tcl_TCU_Charge_Station_Accessibility::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Charge_Station_Accessibility::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Charge_Station_Accessibility::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Payment_Method_Type::midw_ext_fi_tcl_TCU_Payment_Method_Type():enType(FI_EN_UNSPECIFIED) {}

tS32 midw_ext_fi_tcl_TCU_Payment_Method_Type::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_PAYMENT_METHOD_TYPE;
}


midw_ext_fi_tcl_TCU_Payment_Method_Type::~midw_ext_fi_tcl_TCU_Payment_Method_Type()
{}

tU32 midw_ext_fi_tcl_TCU_Payment_Method_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Payment_Method_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Payment_Method_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Full_Address::midw_ext_fi_tcl_TCU_Full_Address(const midw_ext_fi_tcl_TCU_Full_Address& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Length_of_Text = coRef.u8Length_of_Text;
   sText_Info = coRef.sText_Info;
}
midw_ext_fi_tcl_TCU_Full_Address& midw_ext_fi_tcl_TCU_Full_Address::operator=(const midw_ext_fi_tcl_TCU_Full_Address& coRef)
{
   if (this == &coRef) return *this;
   u8Length_of_Text = coRef.u8Length_of_Text;
   sText_Info = coRef.sText_Info;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TCU_Full_Address::vDestroy()
{
   sText_Info.vDestroy();
}

midw_ext_fi_tcl_TCU_Full_Address::midw_ext_fi_tcl_TCU_Full_Address()
:u8Length_of_Text(0)
,sText_Info()
 {}

tS32 midw_ext_fi_tcl_TCU_Full_Address::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_FULL_ADDRESS;
}


midw_ext_fi_tcl_TCU_Full_Address::~midw_ext_fi_tcl_TCU_Full_Address()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TCU_Full_Address::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sText_Info.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Full_Address::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Length_of_Text);
   (tVoid) (oIn >> sText_Info);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Full_Address::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Length_of_Text);
   (tVoid) (oOut << sText_Info);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Full_Address::operator==(const midw_ext_fi_tcl_TCU_Full_Address& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Length_of_Text == roRef.u8Length_of_Text);
   bResult = bResult && (sText_Info == roRef.sText_Info);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Bookable_Information::midw_ext_fi_tcl_e8_TCU_Bookable_Information():enType(FI_EN_UNSPECIFIED) {}

tS32 midw_ext_fi_tcl_e8_TCU_Bookable_Information::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_BOOKABLE_INFORMATION;
}


midw_ext_fi_tcl_e8_TCU_Bookable_Information::~midw_ext_fi_tcl_e8_TCU_Bookable_Information()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Bookable_Information::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Bookable_Information::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Bookable_Information::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Spot_Availability::midw_ext_fi_tcl_e8_TCU_Spot_Availability():enType(FI_EN_UNSPECIFIED) {}

tS32 midw_ext_fi_tcl_e8_TCU_Spot_Availability::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_SPOT_AVAILABILITY;
}


midw_ext_fi_tcl_e8_TCU_Spot_Availability::~midw_ext_fi_tcl_e8_TCU_Spot_Availability()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Spot_Availability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Spot_Availability::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Spot_Availability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Bookable_Free_Text::midw_ext_fi_tcl_TCU_Bookable_Free_Text(const midw_ext_fi_tcl_TCU_Bookable_Free_Text& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Length_of_Text = coRef.u8Length_of_Text;
   sText_Info = coRef.sText_Info;
}
midw_ext_fi_tcl_TCU_Bookable_Free_Text& midw_ext_fi_tcl_TCU_Bookable_Free_Text::operator=(const midw_ext_fi_tcl_TCU_Bookable_Free_Text& coRef)
{
   if (this == &coRef) return *this;
   u8Length_of_Text = coRef.u8Length_of_Text;
   sText_Info = coRef.sText_Info;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TCU_Bookable_Free_Text::vDestroy()
{
   sText_Info.vDestroy();
}

midw_ext_fi_tcl_TCU_Bookable_Free_Text::midw_ext_fi_tcl_TCU_Bookable_Free_Text()
:u8Length_of_Text(0)
,sText_Info()
 {}

tS32 midw_ext_fi_tcl_TCU_Bookable_Free_Text::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_BOOKABLE_FREE_TEXT;
}


midw_ext_fi_tcl_TCU_Bookable_Free_Text::~midw_ext_fi_tcl_TCU_Bookable_Free_Text()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TCU_Bookable_Free_Text::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sText_Info.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Bookable_Free_Text::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Length_of_Text);
   (tVoid) (oIn >> sText_Info);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Bookable_Free_Text::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Length_of_Text);
   (tVoid) (oOut << sText_Info);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Bookable_Free_Text::operator==(const midw_ext_fi_tcl_TCU_Bookable_Free_Text& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Length_of_Text == roRef.u8Length_of_Text);
   bResult = bResult && (sText_Info == roRef.sText_Info);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type::midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type():enType(FI_EN_SMALL_PADDLE) {}

tS32 midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_CHARGE_RECEPTACLE_TYPE;
}


midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type::~midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility::midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility():enType(FI_EN_200_240V_1_PHASE_10A) {}

tS32 midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_CHARGE_RECEPTACLE_FACILITY;
}


midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility::~midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Receptacle::midw_ext_fi_tcl_TCU_Receptacle(const midw_ext_fi_tcl_TCU_Receptacle& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8Charge_Receptacle_Type = coRef.e8Charge_Receptacle_Type;
   u16Available_Power = coRef.u16Available_Power;
   e8Charge_Receptacle_Facility = coRef.e8Charge_Receptacle_Facility;
}
midw_ext_fi_tcl_TCU_Receptacle& midw_ext_fi_tcl_TCU_Receptacle::operator=(const midw_ext_fi_tcl_TCU_Receptacle& coRef)
{
   if (this == &coRef) return *this;
   e8Charge_Receptacle_Type = coRef.e8Charge_Receptacle_Type;
   u16Available_Power = coRef.u16Available_Power;
   e8Charge_Receptacle_Facility = coRef.e8Charge_Receptacle_Facility;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Receptacle::midw_ext_fi_tcl_TCU_Receptacle()
:e8Charge_Receptacle_Type()
,u16Available_Power(0)
,e8Charge_Receptacle_Facility()
 {}

tS32 midw_ext_fi_tcl_TCU_Receptacle::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_RECEPTACLE;
}


midw_ext_fi_tcl_TCU_Receptacle::~midw_ext_fi_tcl_TCU_Receptacle()
{}

tU32 midw_ext_fi_tcl_TCU_Receptacle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Receptacle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Charge_Receptacle_Type);
   (tVoid) (oIn >> u16Available_Power);
   (tVoid) (oIn >> e8Charge_Receptacle_Facility);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Receptacle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Charge_Receptacle_Type);
   (tVoid) (oOut << u16Available_Power);
   (tVoid) (oOut << e8Charge_Receptacle_Facility);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Receptacle::operator==(const midw_ext_fi_tcl_TCU_Receptacle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Charge_Receptacle_Type == roRef.e8Charge_Receptacle_Type);
   bResult = bResult && (u16Available_Power == roRef.u16Available_Power);
   bResult = bResult && (e8Charge_Receptacle_Facility == roRef.e8Charge_Receptacle_Facility);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Spot_List::midw_ext_fi_tcl_TCU_Spot_List(const midw_ext_fi_tcl_TCU_Spot_List& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   sCharge_Spot_ID = coRef.sCharge_Spot_ID;
   e8Bookable_Information = coRef.e8Bookable_Information;
   e8Spot_Availability = coRef.e8Spot_Availability;
   rBookable_Free_Text = coRef.rBookable_Free_Text;
   u8Total_Number_Receptacles = coRef.u8Total_Number_Receptacles;
   rReceptacle1 = coRef.rReceptacle1;
   rReceptacle2 = coRef.rReceptacle2;
   rReceptacle3 = coRef.rReceptacle3;
   rReceptacle4 = coRef.rReceptacle4;
   rReceptacle5 = coRef.rReceptacle5;
   rReceptacle6 = coRef.rReceptacle6;
   rReceptacle7 = coRef.rReceptacle7;
   rReceptacle8 = coRef.rReceptacle8;
   rReceptacle9 = coRef.rReceptacle9;
   rReceptacle10 = coRef.rReceptacle10;
}
midw_ext_fi_tcl_TCU_Spot_List& midw_ext_fi_tcl_TCU_Spot_List::operator=(const midw_ext_fi_tcl_TCU_Spot_List& coRef)
{
   if (this == &coRef) return *this;
   sCharge_Spot_ID = coRef.sCharge_Spot_ID;
   e8Bookable_Information = coRef.e8Bookable_Information;
   e8Spot_Availability = coRef.e8Spot_Availability;
   rBookable_Free_Text = coRef.rBookable_Free_Text;
   u8Total_Number_Receptacles = coRef.u8Total_Number_Receptacles;
   rReceptacle1 = coRef.rReceptacle1;
   rReceptacle2 = coRef.rReceptacle2;
   rReceptacle3 = coRef.rReceptacle3;
   rReceptacle4 = coRef.rReceptacle4;
   rReceptacle5 = coRef.rReceptacle5;
   rReceptacle6 = coRef.rReceptacle6;
   rReceptacle7 = coRef.rReceptacle7;
   rReceptacle8 = coRef.rReceptacle8;
   rReceptacle9 = coRef.rReceptacle9;
   rReceptacle10 = coRef.rReceptacle10;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TCU_Spot_List::vDestroy()
{
   sCharge_Spot_ID.vDestroy();
   rBookable_Free_Text.vDestroy(); 
   rReceptacle1.vDestroy(); 
   rReceptacle2.vDestroy(); 
   rReceptacle3.vDestroy(); 
   rReceptacle4.vDestroy(); 
   rReceptacle5.vDestroy(); 
   rReceptacle6.vDestroy(); 
   rReceptacle7.vDestroy(); 
   rReceptacle8.vDestroy(); 
   rReceptacle9.vDestroy(); 
   rReceptacle10.vDestroy(); 
}

midw_ext_fi_tcl_TCU_Spot_List::midw_ext_fi_tcl_TCU_Spot_List()
:sCharge_Spot_ID()
,e8Bookable_Information()
,e8Spot_Availability()
,rBookable_Free_Text()
,u8Total_Number_Receptacles(0)
,rReceptacle1()
,rReceptacle2()
,rReceptacle3()
,rReceptacle4()
,rReceptacle5()
,rReceptacle6()
,rReceptacle7()
,rReceptacle8()
,rReceptacle9()
,rReceptacle10()
 {}

tS32 midw_ext_fi_tcl_TCU_Spot_List::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_SPOT_LIST;
}


midw_ext_fi_tcl_TCU_Spot_List::~midw_ext_fi_tcl_TCU_Spot_List()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TCU_Spot_List::u32GetSize(tU16 u16MajorVersion) const
{
   return 43+sCharge_Spot_ID.u32GetSize(u16MajorVersion)+rBookable_Free_Text.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Spot_List::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sCharge_Spot_ID);
   (tVoid) (oIn >> e8Bookable_Information);
   (tVoid) (oIn >> e8Spot_Availability);
   (tVoid) (oIn >> rBookable_Free_Text);
   (tVoid) (oIn >> u8Total_Number_Receptacles);
   (tVoid) (oIn >> rReceptacle1);
   (tVoid) (oIn >> rReceptacle2);
   (tVoid) (oIn >> rReceptacle3);
   (tVoid) (oIn >> rReceptacle4);
   (tVoid) (oIn >> rReceptacle5);
   (tVoid) (oIn >> rReceptacle6);
   (tVoid) (oIn >> rReceptacle7);
   (tVoid) (oIn >> rReceptacle8);
   (tVoid) (oIn >> rReceptacle9);
   (tVoid) (oIn >> rReceptacle10);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Spot_List::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sCharge_Spot_ID);
   (tVoid) (oOut << e8Bookable_Information);
   (tVoid) (oOut << e8Spot_Availability);
   (tVoid) (oOut << rBookable_Free_Text);
   (tVoid) (oOut << u8Total_Number_Receptacles);
   (tVoid) (oOut << rReceptacle1);
   (tVoid) (oOut << rReceptacle2);
   (tVoid) (oOut << rReceptacle3);
   (tVoid) (oOut << rReceptacle4);
   (tVoid) (oOut << rReceptacle5);
   (tVoid) (oOut << rReceptacle6);
   (tVoid) (oOut << rReceptacle7);
   (tVoid) (oOut << rReceptacle8);
   (tVoid) (oOut << rReceptacle9);
   (tVoid) (oOut << rReceptacle10);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Spot_List::operator==(const midw_ext_fi_tcl_TCU_Spot_List& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sCharge_Spot_ID == roRef.sCharge_Spot_ID);
   bResult = bResult && (e8Bookable_Information == roRef.e8Bookable_Information);
   bResult = bResult && (e8Spot_Availability == roRef.e8Spot_Availability);
   bResult = bResult && (rBookable_Free_Text == roRef.rBookable_Free_Text);
   bResult = bResult && (u8Total_Number_Receptacles == roRef.u8Total_Number_Receptacles);
   bResult = bResult && (rReceptacle1 == roRef.rReceptacle1);
   bResult = bResult && (rReceptacle2 == roRef.rReceptacle2);
   bResult = bResult && (rReceptacle3 == roRef.rReceptacle3);
   bResult = bResult && (rReceptacle4 == roRef.rReceptacle4);
   bResult = bResult && (rReceptacle5 == roRef.rReceptacle5);
   bResult = bResult && (rReceptacle6 == roRef.rReceptacle6);
   bResult = bResult && (rReceptacle7 == roRef.rReceptacle7);
   bResult = bResult && (rReceptacle8 == roRef.rReceptacle8);
   bResult = bResult && (rReceptacle9 == roRef.rReceptacle9);
   bResult = bResult && (rReceptacle10 == roRef.rReceptacle10);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Charge_Spot_List::midw_ext_fi_tcl_TCU_Charge_Spot_List(const midw_ext_fi_tcl_TCU_Charge_Spot_List& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Total_pages_of_lists = coRef.u8Total_pages_of_lists;
   u8Pages_of_list = coRef.u8Pages_of_list;
   u8Station_List_Number = coRef.u8Station_List_Number;
   rSpot_List1 = coRef.rSpot_List1;
   rSpot_List2 = coRef.rSpot_List2;
   rSpot_List3 = coRef.rSpot_List3;
   rSpot_List4 = coRef.rSpot_List4;
}
midw_ext_fi_tcl_TCU_Charge_Spot_List& midw_ext_fi_tcl_TCU_Charge_Spot_List::operator=(const midw_ext_fi_tcl_TCU_Charge_Spot_List& coRef)
{
   if (this == &coRef) return *this;
   u8Total_pages_of_lists = coRef.u8Total_pages_of_lists;
   u8Pages_of_list = coRef.u8Pages_of_list;
   u8Station_List_Number = coRef.u8Station_List_Number;
   rSpot_List1 = coRef.rSpot_List1;
   rSpot_List2 = coRef.rSpot_List2;
   rSpot_List3 = coRef.rSpot_List3;
   rSpot_List4 = coRef.rSpot_List4;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TCU_Charge_Spot_List::vDestroy()
{
   rSpot_List1.vDestroy(); 
   rSpot_List2.vDestroy(); 
   rSpot_List3.vDestroy(); 
   rSpot_List4.vDestroy(); 
}

midw_ext_fi_tcl_TCU_Charge_Spot_List::midw_ext_fi_tcl_TCU_Charge_Spot_List()
:u8Total_pages_of_lists(0)
,u8Pages_of_list(0)
,u8Station_List_Number(0)
,rSpot_List1()
,rSpot_List2()
,rSpot_List3()
,rSpot_List4()
 {}

tS32 midw_ext_fi_tcl_TCU_Charge_Spot_List::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_CHARGE_SPOT_LIST;
}


midw_ext_fi_tcl_TCU_Charge_Spot_List::~midw_ext_fi_tcl_TCU_Charge_Spot_List()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TCU_Charge_Spot_List::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+rSpot_List1.u32GetSize(u16MajorVersion)+rSpot_List2.u32GetSize(u16MajorVersion)+rSpot_List3.u32GetSize(u16MajorVersion)+rSpot_List4.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Charge_Spot_List::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Total_pages_of_lists);
   (tVoid) (oIn >> u8Pages_of_list);
   (tVoid) (oIn >> u8Station_List_Number);
   (tVoid) (oIn >> rSpot_List1);
   (tVoid) (oIn >> rSpot_List2);
   (tVoid) (oIn >> rSpot_List3);
   (tVoid) (oIn >> rSpot_List4);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Charge_Spot_List::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Total_pages_of_lists);
   (tVoid) (oOut << u8Pages_of_list);
   (tVoid) (oOut << u8Station_List_Number);
   (tVoid) (oOut << rSpot_List1);
   (tVoid) (oOut << rSpot_List2);
   (tVoid) (oOut << rSpot_List3);
   (tVoid) (oOut << rSpot_List4);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Charge_Spot_List::operator==(const midw_ext_fi_tcl_TCU_Charge_Spot_List& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Total_pages_of_lists == roRef.u8Total_pages_of_lists);
   bResult = bResult && (u8Pages_of_list == roRef.u8Pages_of_list);
   bResult = bResult && (u8Station_List_Number == roRef.u8Station_List_Number);
   bResult = bResult && (rSpot_List1 == roRef.rSpot_List1);
   bResult = bResult && (rSpot_List2 == roRef.rSpot_List2);
   bResult = bResult && (rSpot_List3 == roRef.rSpot_List3);
   bResult = bResult && (rSpot_List4 == roRef.rSpot_List4);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Time::midw_ext_fi_tcl_TCU_Time(const midw_ext_fi_tcl_TCU_Time& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Seconds = coRef.u8Seconds;
}
midw_ext_fi_tcl_TCU_Time& midw_ext_fi_tcl_TCU_Time::operator=(const midw_ext_fi_tcl_TCU_Time& coRef)
{
   if (this == &coRef) return *this;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Seconds = coRef.u8Seconds;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Time::midw_ext_fi_tcl_TCU_Time()
:u8Hour(0)
,u8Minute(0)
,u8Seconds(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Time::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_TIME;
}


midw_ext_fi_tcl_TCU_Time::~midw_ext_fi_tcl_TCU_Time()
{}

tU32 midw_ext_fi_tcl_TCU_Time::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Time::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Hour);
   (tVoid) (oIn >> u8Minute);
   (tVoid) (oIn >> u8Seconds);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Time::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Hour);
   (tVoid) (oOut << u8Minute);
   (tVoid) (oOut << u8Seconds);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Time::operator==(const midw_ext_fi_tcl_TCU_Time& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Hour == roRef.u8Hour);
   bResult = bResult && (u8Minute == roRef.u8Minute);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Language_Family_Type::midw_ext_fi_tcl_e8_Language_Family_Type():enType(FI_EN_FAMILY_TYPE_1) {}

tS32 midw_ext_fi_tcl_e8_Language_Family_Type::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_LANGUAGE_FAMILY_TYPE;
}


midw_ext_fi_tcl_e8_Language_Family_Type::~midw_ext_fi_tcl_e8_Language_Family_Type()
{}

tU32 midw_ext_fi_tcl_e8_Language_Family_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Language_Family_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Language_Family_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Language_Type::midw_ext_fi_tcl_e8_Language_Type():enType(FI_EN_DEFAULT) {}

tS32 midw_ext_fi_tcl_e8_Language_Type::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_LANGUAGE_TYPE;
}


midw_ext_fi_tcl_e8_Language_Type::~midw_ext_fi_tcl_e8_Language_Type()
{}

tU32 midw_ext_fi_tcl_e8_Language_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Language_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Language_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Navigation_Language::midw_ext_fi_tcl_TCU_Navigation_Language(const midw_ext_fi_tcl_TCU_Navigation_Language& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Reserved = coRef.u8Reserved;
   e8Language_Family_Type = coRef.e8Language_Family_Type;
   e8Language_Type = coRef.e8Language_Type;
}
midw_ext_fi_tcl_TCU_Navigation_Language& midw_ext_fi_tcl_TCU_Navigation_Language::operator=(const midw_ext_fi_tcl_TCU_Navigation_Language& coRef)
{
   if (this == &coRef) return *this;
   u8Reserved = coRef.u8Reserved;
   e8Language_Family_Type = coRef.e8Language_Family_Type;
   e8Language_Type = coRef.e8Language_Type;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Navigation_Language::midw_ext_fi_tcl_TCU_Navigation_Language()
:u8Reserved(0)
,e8Language_Family_Type()
,e8Language_Type()
 {}

tS32 midw_ext_fi_tcl_TCU_Navigation_Language::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_NAVIGATION_LANGUAGE;
}


midw_ext_fi_tcl_TCU_Navigation_Language::~midw_ext_fi_tcl_TCU_Navigation_Language()
{}

tU32 midw_ext_fi_tcl_TCU_Navigation_Language::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Navigation_Language::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Reserved);
   (tVoid) (oIn >> e8Language_Family_Type);
   (tVoid) (oIn >> e8Language_Type);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Navigation_Language::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Reserved);
   (tVoid) (oOut << e8Language_Family_Type);
   (tVoid) (oOut << e8Language_Type);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Navigation_Language::operator==(const midw_ext_fi_tcl_TCU_Navigation_Language& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Reserved == roRef.u8Reserved);
   bResult = bResult && (e8Language_Family_Type == roRef.e8Language_Family_Type);
   bResult = bResult && (e8Language_Type == roRef.e8Language_Type);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Booking_Status::midw_ext_fi_tcl_e8_TCU_Booking_Status():enType(FI_EN_BOOKING_FAILED_BECAUSE_OF_UNKNOWN_CUSTOMER_CONTRACT_IDENTIFIER) {}

tS32 midw_ext_fi_tcl_e8_TCU_Booking_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_BOOKING_STATUS;
}


midw_ext_fi_tcl_e8_TCU_Booking_Status::~midw_ext_fi_tcl_e8_TCU_Booking_Status()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Booking_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Booking_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Booking_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Unbooking_Status::midw_ext_fi_tcl_e8_TCU_Unbooking_Status():enType(FI_EN_UNBOOKING_FAILED_BECAUSE_OF_UNKNOWN_CUSTOMER_CONTRACT_IDENTIFIER) {}

tS32 midw_ext_fi_tcl_e8_TCU_Unbooking_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_UNBOOKING_STATUS;
}


midw_ext_fi_tcl_e8_TCU_Unbooking_Status::~midw_ext_fi_tcl_e8_TCU_Unbooking_Status()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Unbooking_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Unbooking_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Unbooking_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Update_Status::midw_ext_fi_tcl_e8_TCU_Update_Status():enType(FI_EN_UPDATE_FAILED) {}

tS32 midw_ext_fi_tcl_e8_TCU_Update_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_UPDATE_STATUS;
}


midw_ext_fi_tcl_e8_TCU_Update_Status::~midw_ext_fi_tcl_e8_TCU_Update_Status()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Update_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Update_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Update_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Sch_Activation_State::midw_ext_fi_tcl_e8_TCU_Sch_Activation_State():enType(FI_EN_SCHEDULER_ACTIVATED) {}

tS32 midw_ext_fi_tcl_e8_TCU_Sch_Activation_State::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_SCH_ACTIVATION_STATE;
}


midw_ext_fi_tcl_e8_TCU_Sch_Activation_State::~midw_ext_fi_tcl_e8_TCU_Sch_Activation_State()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Sch_Activation_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Sch_Activation_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Sch_Activation_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Charge_Days::midw_ext_fi_tcl_TCU_Charge_Days(const midw_ext_fi_tcl_TCU_Charge_Days& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Day1 = coRef.Day1;
   Day2 = coRef.Day2;
   Day3 = coRef.Day3;
   Day4 = coRef.Day4;
   Day5 = coRef.Day5;
   Day6 = coRef.Day6;
   Day7 = coRef.Day7;
}
midw_ext_fi_tcl_TCU_Charge_Days& midw_ext_fi_tcl_TCU_Charge_Days::operator=(const midw_ext_fi_tcl_TCU_Charge_Days& coRef)
{
   if (this == &coRef) return *this;
   Day1 = coRef.Day1;
   Day2 = coRef.Day2;
   Day3 = coRef.Day3;
   Day4 = coRef.Day4;
   Day5 = coRef.Day5;
   Day6 = coRef.Day6;
   Day7 = coRef.Day7;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Charge_Days::midw_ext_fi_tcl_TCU_Charge_Days()
:Day1(0)
,Day2(0)
,Day3(0)
,Day4(0)
,Day5(0)
,Day6(0)
,Day7(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Charge_Days::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_CHARGE_DAYS;
}


midw_ext_fi_tcl_TCU_Charge_Days::~midw_ext_fi_tcl_TCU_Charge_Days()
{}

tU32 midw_ext_fi_tcl_TCU_Charge_Days::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Charge_Days::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Day1);
   (tVoid) (oIn >> Day2);
   (tVoid) (oIn >> Day3);
   (tVoid) (oIn >> Day4);
   (tVoid) (oIn >> Day5);
   (tVoid) (oIn >> Day6);
   (tVoid) (oIn >> Day7);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Charge_Days::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Day1);
   (tVoid) (oOut << Day2);
   (tVoid) (oOut << Day3);
   (tVoid) (oOut << Day4);
   (tVoid) (oOut << Day5);
   (tVoid) (oOut << Day6);
   (tVoid) (oOut << Day7);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Charge_Days::operator==(const midw_ext_fi_tcl_TCU_Charge_Days& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Day1 == roRef.Day1);
   bResult = bResult && (Day2 == roRef.Day2);
   bResult = bResult && (Day3 == roRef.Day3);
   bResult = bResult && (Day4 == roRef.Day4);
   bResult = bResult && (Day5 == roRef.Day5);
   bResult = bResult && (Day6 == roRef.Day6);
   bResult = bResult && (Day7 == roRef.Day7);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status::midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status():enType(FI_EN_UNAVAILABLE) {}

tS32 midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_CHARGE_BLOCKED_STATUS;
}


midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status::~midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Spot_Receptacle_Type::midw_ext_fi_tcl_TCU_Spot_Receptacle_Type(const midw_ext_fi_tcl_TCU_Spot_Receptacle_Type& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   rDefault_receptacle_type = coRef.rDefault_receptacle_type;
   rUser_receptacle_type_1 = coRef.rUser_receptacle_type_1;
   rUser_receptacle_type_2 = coRef.rUser_receptacle_type_2;
   rUser_receptacle_type_3 = coRef.rUser_receptacle_type_3;
   u8Reserved1 = coRef.u8Reserved1;
   u8Reserved2 = coRef.u8Reserved2;
   u8Reserved3 = coRef.u8Reserved3;
   u8Reserved4 = coRef.u8Reserved4;
}
midw_ext_fi_tcl_TCU_Spot_Receptacle_Type& midw_ext_fi_tcl_TCU_Spot_Receptacle_Type::operator=(const midw_ext_fi_tcl_TCU_Spot_Receptacle_Type& coRef)
{
   if (this == &coRef) return *this;
   rDefault_receptacle_type = coRef.rDefault_receptacle_type;
   rUser_receptacle_type_1 = coRef.rUser_receptacle_type_1;
   rUser_receptacle_type_2 = coRef.rUser_receptacle_type_2;
   rUser_receptacle_type_3 = coRef.rUser_receptacle_type_3;
   u8Reserved1 = coRef.u8Reserved1;
   u8Reserved2 = coRef.u8Reserved2;
   u8Reserved3 = coRef.u8Reserved3;
   u8Reserved4 = coRef.u8Reserved4;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Spot_Receptacle_Type::midw_ext_fi_tcl_TCU_Spot_Receptacle_Type()
:rDefault_receptacle_type()
,rUser_receptacle_type_1()
,rUser_receptacle_type_2()
,rUser_receptacle_type_3()
,u8Reserved1(0)
,u8Reserved2(0)
,u8Reserved3(0)
,u8Reserved4(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Spot_Receptacle_Type::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_SPOT_RECEPTACLE_TYPE;
}


midw_ext_fi_tcl_TCU_Spot_Receptacle_Type::~midw_ext_fi_tcl_TCU_Spot_Receptacle_Type()
{}

tU32 midw_ext_fi_tcl_TCU_Spot_Receptacle_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Spot_Receptacle_Type::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rDefault_receptacle_type);
   (tVoid) (oIn >> rUser_receptacle_type_1);
   (tVoid) (oIn >> rUser_receptacle_type_2);
   (tVoid) (oIn >> rUser_receptacle_type_3);
   (tVoid) (oIn >> u8Reserved1);
   (tVoid) (oIn >> u8Reserved2);
   (tVoid) (oIn >> u8Reserved3);
   (tVoid) (oIn >> u8Reserved4);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Spot_Receptacle_Type::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rDefault_receptacle_type);
   (tVoid) (oOut << rUser_receptacle_type_1);
   (tVoid) (oOut << rUser_receptacle_type_2);
   (tVoid) (oOut << rUser_receptacle_type_3);
   (tVoid) (oOut << u8Reserved1);
   (tVoid) (oOut << u8Reserved2);
   (tVoid) (oOut << u8Reserved3);
   (tVoid) (oOut << u8Reserved4);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Spot_Receptacle_Type::operator==(const midw_ext_fi_tcl_TCU_Spot_Receptacle_Type& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rDefault_receptacle_type == roRef.rDefault_receptacle_type);
   bResult = bResult && (rUser_receptacle_type_1 == roRef.rUser_receptacle_type_1);
   bResult = bResult && (rUser_receptacle_type_2 == roRef.rUser_receptacle_type_2);
   bResult = bResult && (rUser_receptacle_type_3 == roRef.rUser_receptacle_type_3);
   bResult = bResult && (u8Reserved1 == roRef.u8Reserved1);
   bResult = bResult && (u8Reserved2 == roRef.u8Reserved2);
   bResult = bResult && (u8Reserved3 == roRef.u8Reserved3);
   bResult = bResult && (u8Reserved4 == roRef.u8Reserved4);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tclIN_Data::midw_ext_fi_tclIN_Data(const midw_ext_fi_tclIN_Data& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Length = coRef.u8Length;
   sText = coRef.sText;
}
midw_ext_fi_tclIN_Data& midw_ext_fi_tclIN_Data::operator=(const midw_ext_fi_tclIN_Data& coRef)
{
   if (this == &coRef) return *this;
   u8Length = coRef.u8Length;
   sText = coRef.sText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tclIN_Data::vDestroy()
{
   sText.vDestroy();
}

midw_ext_fi_tclIN_Data::midw_ext_fi_tclIN_Data()
:u8Length(0)
,sText()
 {}

tS32 midw_ext_fi_tclIN_Data::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_N_DATA;
}


midw_ext_fi_tclIN_Data::~midw_ext_fi_tclIN_Data()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tclIN_Data::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sText.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tclIN_Data::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Length);
   (tVoid) (oIn >> sText);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tclIN_Data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Length);
   (tVoid) (oOut << sText);
   return oOut;
}

tBool midw_ext_fi_tclIN_Data::operator==(const midw_ext_fi_tclIN_Data& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Length == roRef.u8Length);
   bResult = bResult && (sText == roRef.sText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_PIN::midw_ext_fi_tcl_TCU_PIN(const midw_ext_fi_tcl_TCU_PIN& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   rPIN_ID = coRef.rPIN_ID;
   rPIN_Password = coRef.rPIN_Password;
}
midw_ext_fi_tcl_TCU_PIN& midw_ext_fi_tcl_TCU_PIN::operator=(const midw_ext_fi_tcl_TCU_PIN& coRef)
{
   if (this == &coRef) return *this;
   rPIN_ID = coRef.rPIN_ID;
   rPIN_Password = coRef.rPIN_Password;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TCU_PIN::vDestroy()
{
   rPIN_ID.vDestroy(); 
   rPIN_Password.vDestroy(); 
}

midw_ext_fi_tcl_TCU_PIN::midw_ext_fi_tcl_TCU_PIN()
:rPIN_ID()
,rPIN_Password()
 {}

tS32 midw_ext_fi_tcl_TCU_PIN::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_PIN;
}


midw_ext_fi_tcl_TCU_PIN::~midw_ext_fi_tcl_TCU_PIN()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TCU_PIN::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+rPIN_ID.u32GetSize(u16MajorVersion)+rPIN_Password.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_TCU_PIN::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rPIN_ID);
   (tVoid) (oIn >> rPIN_Password);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_PIN::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rPIN_ID);
   (tVoid) (oOut << rPIN_Password);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_PIN::operator==(const midw_ext_fi_tcl_TCU_PIN& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rPIN_ID == roRef.rPIN_ID);
   bResult = bResult && (rPIN_Password == roRef.rPIN_Password);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Wifi_SSID_Name::midw_ext_fi_tcl_TCU_Wifi_SSID_Name(const midw_ext_fi_tcl_TCU_Wifi_SSID_Name& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8CharcterSet = coRef.u8CharcterSet;
   u8LentghOfText = coRef.u8LentghOfText;
   sText = coRef.sText;
}
midw_ext_fi_tcl_TCU_Wifi_SSID_Name& midw_ext_fi_tcl_TCU_Wifi_SSID_Name::operator=(const midw_ext_fi_tcl_TCU_Wifi_SSID_Name& coRef)
{
   if (this == &coRef) return *this;
   u8CharcterSet = coRef.u8CharcterSet;
   u8LentghOfText = coRef.u8LentghOfText;
   sText = coRef.sText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TCU_Wifi_SSID_Name::vDestroy()
{
   sText.vDestroy();
}

midw_ext_fi_tcl_TCU_Wifi_SSID_Name::midw_ext_fi_tcl_TCU_Wifi_SSID_Name()
:u8CharcterSet(0)
,u8LentghOfText(0)
,sText()
 {}

tS32 midw_ext_fi_tcl_TCU_Wifi_SSID_Name::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_WIFI_SSID_NAME;
}


midw_ext_fi_tcl_TCU_Wifi_SSID_Name::~midw_ext_fi_tcl_TCU_Wifi_SSID_Name()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TCU_Wifi_SSID_Name::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sText.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Wifi_SSID_Name::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8CharcterSet);
   (tVoid) (oIn >> u8LentghOfText);
   (tVoid) (oIn >> sText);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Wifi_SSID_Name::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8CharcterSet);
   (tVoid) (oOut << u8LentghOfText);
   (tVoid) (oOut << sText);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Wifi_SSID_Name::operator==(const midw_ext_fi_tcl_TCU_Wifi_SSID_Name& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8CharcterSet == roRef.u8CharcterSet);
   bResult = bResult && (u8LentghOfText == roRef.u8LentghOfText);
   bResult = bResult && (sText == roRef.sText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Wifi_PassKey::midw_ext_fi_tcl_TCU_Wifi_PassKey(const midw_ext_fi_tcl_TCU_Wifi_PassKey& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8CharcterSet = coRef.u8CharcterSet;
   u8LentghOfText = coRef.u8LentghOfText;
   sText = coRef.sText;
}
midw_ext_fi_tcl_TCU_Wifi_PassKey& midw_ext_fi_tcl_TCU_Wifi_PassKey::operator=(const midw_ext_fi_tcl_TCU_Wifi_PassKey& coRef)
{
   if (this == &coRef) return *this;
   u8CharcterSet = coRef.u8CharcterSet;
   u8LentghOfText = coRef.u8LentghOfText;
   sText = coRef.sText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TCU_Wifi_PassKey::vDestroy()
{
   sText.vDestroy();
}

midw_ext_fi_tcl_TCU_Wifi_PassKey::midw_ext_fi_tcl_TCU_Wifi_PassKey()
:u8CharcterSet(0)
,u8LentghOfText(0)
,sText()
 {}

tS32 midw_ext_fi_tcl_TCU_Wifi_PassKey::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_WIFI_PASSKEY;
}


midw_ext_fi_tcl_TCU_Wifi_PassKey::~midw_ext_fi_tcl_TCU_Wifi_PassKey()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TCU_Wifi_PassKey::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sText.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Wifi_PassKey::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8CharcterSet);
   (tVoid) (oIn >> u8LentghOfText);
   (tVoid) (oIn >> sText);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Wifi_PassKey::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8CharcterSet);
   (tVoid) (oOut << u8LentghOfText);
   (tVoid) (oOut << sText);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Wifi_PassKey::operator==(const midw_ext_fi_tcl_TCU_Wifi_PassKey& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8CharcterSet == roRef.u8CharcterSet);
   bResult = bResult && (u8LentghOfText == roRef.u8LentghOfText);
   bResult = bResult && (sText == roRef.sText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode::midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode():enType(FI_EN_WEP) {}

tS32 midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_WIFI_SECURITY_MODE;
}


midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode::~midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Wifi_Visibility::midw_ext_fi_tcl_e8_TCU_Wifi_Visibility():enType(FI_EN_WIFI_VISIBLE) {}

tS32 midw_ext_fi_tcl_e8_TCU_Wifi_Visibility::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_WIFI_VISIBILITY;
}


midw_ext_fi_tcl_e8_TCU_Wifi_Visibility::~midw_ext_fi_tcl_e8_TCU_Wifi_Visibility()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Wifi_Visibility::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Wifi_Visibility::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Wifi_Visibility::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Wifi_Status::midw_ext_fi_tcl_e8_TCU_Wifi_Status():enType(FI_EN_OFF) {}

tS32 midw_ext_fi_tcl_e8_TCU_Wifi_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_WIFI_STATUS;
}


midw_ext_fi_tcl_e8_TCU_Wifi_Status::~midw_ext_fi_tcl_e8_TCU_Wifi_Status()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Wifi_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Wifi_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Wifi_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Wifi_Mode::midw_ext_fi_tcl_e8_TCU_Wifi_Mode():enType(FI_EN_WIFI_UNAVAILABLE) {}

tS32 midw_ext_fi_tcl_e8_TCU_Wifi_Mode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_WIFI_MODE;
}


midw_ext_fi_tcl_e8_TCU_Wifi_Mode::~midw_ext_fi_tcl_e8_TCU_Wifi_Mode()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Wifi_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Wifi_Mode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Wifi_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status::midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_WIFI_CONNECTION_STATUS;
}


midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status::~midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security::midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security():enType(FI_EN_OPEN) {}

tS32 midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_WIFI_WIFI_SCAN_SECURITY;
}


midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security::~midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status::midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status():enType(FI_EN_NOT_CONNECTED) {}

tS32 midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_WIFI_WIFI_CLIENT_STATUS;
}


midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status::~midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity::midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity():enType(FI_EN_END) {}

tS32 midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_AUDIO_SOURCEACTIVITY;
}


midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity::~midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Cycle::midw_ext_fi_tcl_e8_TCU_Cycle():enType(FI_EN_EVERY_DAY) {}

tS32 midw_ext_fi_tcl_e8_TCU_Cycle::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_CYCLE;
}


midw_ext_fi_tcl_e8_TCU_Cycle::~midw_ext_fi_tcl_e8_TCU_Cycle()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Cycle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Cycle::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Cycle::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Time_Slot::midw_ext_fi_tcl_TCU_Time_Slot(const midw_ext_fi_tcl_TCU_Time_Slot& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   rStart_timeStamp = coRef.rStart_timeStamp;
   rStop_timeStamp = coRef.rStop_timeStamp;
   e8Cycle = coRef.e8Cycle;
}
midw_ext_fi_tcl_TCU_Time_Slot& midw_ext_fi_tcl_TCU_Time_Slot::operator=(const midw_ext_fi_tcl_TCU_Time_Slot& coRef)
{
   if (this == &coRef) return *this;
   rStart_timeStamp = coRef.rStart_timeStamp;
   rStop_timeStamp = coRef.rStop_timeStamp;
   e8Cycle = coRef.e8Cycle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Time_Slot::midw_ext_fi_tcl_TCU_Time_Slot()
:rStart_timeStamp()
,rStop_timeStamp()
,e8Cycle()
 {}

tS32 midw_ext_fi_tcl_TCU_Time_Slot::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_TIME_SLOT;
}


midw_ext_fi_tcl_TCU_Time_Slot::~midw_ext_fi_tcl_TCU_Time_Slot()
{}

tU32 midw_ext_fi_tcl_TCU_Time_Slot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Time_Slot::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rStart_timeStamp);
   (tVoid) (oIn >> rStop_timeStamp);
   (tVoid) (oIn >> e8Cycle);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Time_Slot::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rStart_timeStamp);
   (tVoid) (oOut << rStop_timeStamp);
   (tVoid) (oOut << e8Cycle);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Time_Slot::operator==(const midw_ext_fi_tcl_TCU_Time_Slot& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rStart_timeStamp == roRef.rStart_timeStamp);
   bResult = bResult && (rStop_timeStamp == roRef.rStop_timeStamp);
   bResult = bResult && (e8Cycle == roRef.e8Cycle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Coordinates::midw_ext_fi_tcl_TCU_Coordinates(const midw_ext_fi_tcl_TCU_Coordinates& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8Latitudemode = coRef.e8Latitudemode;
   e8LongitudeMode = coRef.e8LongitudeMode;
   u8LatitudeDEG = coRef.u8LatitudeDEG;
   u8LatitudeMIN = coRef.u8LatitudeMIN;
   u16LatitudeSEC = coRef.u16LatitudeSEC;
   u8LongitudeDEG = coRef.u8LongitudeDEG;
   u8LongitudeMIN = coRef.u8LongitudeMIN;
   u16LongitudeSEC = coRef.u16LongitudeSEC;
   u8Reserve = coRef.u8Reserve;
}
midw_ext_fi_tcl_TCU_Coordinates& midw_ext_fi_tcl_TCU_Coordinates::operator=(const midw_ext_fi_tcl_TCU_Coordinates& coRef)
{
   if (this == &coRef) return *this;
   e8Latitudemode = coRef.e8Latitudemode;
   e8LongitudeMode = coRef.e8LongitudeMode;
   u8LatitudeDEG = coRef.u8LatitudeDEG;
   u8LatitudeMIN = coRef.u8LatitudeMIN;
   u16LatitudeSEC = coRef.u16LatitudeSEC;
   u8LongitudeDEG = coRef.u8LongitudeDEG;
   u8LongitudeMIN = coRef.u8LongitudeMIN;
   u16LongitudeSEC = coRef.u16LongitudeSEC;
   u8Reserve = coRef.u8Reserve;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Coordinates::midw_ext_fi_tcl_TCU_Coordinates()
:e8Latitudemode()
,e8LongitudeMode()
,u8LatitudeDEG(0)
,u8LatitudeMIN(0)
,u16LatitudeSEC(0)
,u8LongitudeDEG(0)
,u8LongitudeMIN(0)
,u16LongitudeSEC(0)
,u8Reserve(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Coordinates::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_COORDINATES;
}


midw_ext_fi_tcl_TCU_Coordinates::~midw_ext_fi_tcl_TCU_Coordinates()
{}

tU32 midw_ext_fi_tcl_TCU_Coordinates::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Coordinates::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Latitudemode);
   (tVoid) (oIn >> e8LongitudeMode);
   (tVoid) (oIn >> u8LatitudeDEG);
   (tVoid) (oIn >> u8LatitudeMIN);
   (tVoid) (oIn >> u16LatitudeSEC);
   (tVoid) (oIn >> u8LongitudeDEG);
   (tVoid) (oIn >> u8LongitudeMIN);
   (tVoid) (oIn >> u16LongitudeSEC);
   (tVoid) (oIn >> u8Reserve);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Coordinates::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Latitudemode);
   (tVoid) (oOut << e8LongitudeMode);
   (tVoid) (oOut << u8LatitudeDEG);
   (tVoid) (oOut << u8LatitudeMIN);
   (tVoid) (oOut << u16LatitudeSEC);
   (tVoid) (oOut << u8LongitudeDEG);
   (tVoid) (oOut << u8LongitudeMIN);
   (tVoid) (oOut << u16LongitudeSEC);
   (tVoid) (oOut << u8Reserve);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Coordinates::operator==(const midw_ext_fi_tcl_TCU_Coordinates& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Latitudemode == roRef.e8Latitudemode);
   bResult = bResult && (e8LongitudeMode == roRef.e8LongitudeMode);
   bResult = bResult && (u8LatitudeDEG == roRef.u8LatitudeDEG);
   bResult = bResult && (u8LatitudeMIN == roRef.u8LatitudeMIN);
   bResult = bResult && (u16LatitudeSEC == roRef.u16LatitudeSEC);
   bResult = bResult && (u8LongitudeDEG == roRef.u8LongitudeDEG);
   bResult = bResult && (u8LongitudeMIN == roRef.u8LongitudeMIN);
   bResult = bResult && (u16LongitudeSEC == roRef.u16LongitudeSEC);
   bResult = bResult && (u8Reserve == roRef.u8Reserve);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type::midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type():enType(FI_EN_INCLUSION) {}

tS32 midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_RESTRICTION_AREA_TYPE;
}


midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type::~midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Area_Form::midw_ext_fi_tcl_e8_TCU_Area_Form():enType(FI_EN_SQUARE_AREA) {}

tS32 midw_ext_fi_tcl_e8_TCU_Area_Form::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_AREA_FORM;
}


midw_ext_fi_tcl_e8_TCU_Area_Form::~midw_ext_fi_tcl_e8_TCU_Area_Form()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Area_Form::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Area_Form::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Area_Form::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Area_Coordinate::midw_ext_fi_tcl_TCU_Area_Coordinate(const midw_ext_fi_tcl_TCU_Area_Coordinate& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   rCoordinates1 = coRef.rCoordinates1;
   rCoordinates2 = coRef.rCoordinates2;
}
midw_ext_fi_tcl_TCU_Area_Coordinate& midw_ext_fi_tcl_TCU_Area_Coordinate::operator=(const midw_ext_fi_tcl_TCU_Area_Coordinate& coRef)
{
   if (this == &coRef) return *this;
   rCoordinates1 = coRef.rCoordinates1;
   rCoordinates2 = coRef.rCoordinates2;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Area_Coordinate::midw_ext_fi_tcl_TCU_Area_Coordinate()
:rCoordinates1()
,rCoordinates2()
 {}

tS32 midw_ext_fi_tcl_TCU_Area_Coordinate::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_AREA_COORDINATE;
}


midw_ext_fi_tcl_TCU_Area_Coordinate::~midw_ext_fi_tcl_TCU_Area_Coordinate()
{}

tU32 midw_ext_fi_tcl_TCU_Area_Coordinate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 22;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Area_Coordinate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rCoordinates1);
   (tVoid) (oIn >> rCoordinates2);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Area_Coordinate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rCoordinates1);
   (tVoid) (oOut << rCoordinates2);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Area_Coordinate::operator==(const midw_ext_fi_tcl_TCU_Area_Coordinate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rCoordinates1 == roRef.rCoordinates1);
   bResult = bResult && (rCoordinates2 == roRef.rCoordinates2);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Area_Limit_Coordinates::midw_ext_fi_tcl_TCU_Area_Limit_Coordinates(const midw_ext_fi_tcl_TCU_Area_Limit_Coordinates& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   e8Restriction_Area_Type = coRef.e8Restriction_Area_Type;
   e8Area_Form = coRef.e8Area_Form;
   e8LocationType = coRef.e8LocationType;
   rArea_Coordinates = coRef.rArea_Coordinates;
   u16Radius = coRef.u16Radius;
}
midw_ext_fi_tcl_TCU_Area_Limit_Coordinates& midw_ext_fi_tcl_TCU_Area_Limit_Coordinates::operator=(const midw_ext_fi_tcl_TCU_Area_Limit_Coordinates& coRef)
{
   if (this == &coRef) return *this;
   e8Restriction_Area_Type = coRef.e8Restriction_Area_Type;
   e8Area_Form = coRef.e8Area_Form;
   e8LocationType = coRef.e8LocationType;
   rArea_Coordinates = coRef.rArea_Coordinates;
   u16Radius = coRef.u16Radius;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_TCU_Area_Limit_Coordinates::midw_ext_fi_tcl_TCU_Area_Limit_Coordinates()
:e8Restriction_Area_Type()
,e8Area_Form()
,e8LocationType()
,rArea_Coordinates()
,u16Radius(0)
 {}

tS32 midw_ext_fi_tcl_TCU_Area_Limit_Coordinates::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_AREA_LIMIT_COORDINATES;
}


midw_ext_fi_tcl_TCU_Area_Limit_Coordinates::~midw_ext_fi_tcl_TCU_Area_Limit_Coordinates()
{}

tU32 midw_ext_fi_tcl_TCU_Area_Limit_Coordinates::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 27;
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Area_Limit_Coordinates::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Restriction_Area_Type);
   (tVoid) (oIn >> e8Area_Form);
   (tVoid) (oIn >> e8LocationType);
   (tVoid) (oIn >> rArea_Coordinates);
   (tVoid) (oIn >> u16Radius);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Area_Limit_Coordinates::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Restriction_Area_Type);
   (tVoid) (oOut << e8Area_Form);
   (tVoid) (oOut << e8LocationType);
   (tVoid) (oOut << rArea_Coordinates);
   (tVoid) (oOut << u16Radius);
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Area_Limit_Coordinates::operator==(const midw_ext_fi_tcl_TCU_Area_Limit_Coordinates& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Restriction_Area_Type == roRef.e8Restriction_Area_Type);
   bResult = bResult && (e8Area_Form == roRef.e8Area_Form);
   bResult = bResult && (e8LocationType == roRef.e8LocationType);
   bResult = bResult && (rArea_Coordinates == roRef.rArea_Coordinates);
   bResult = bResult && (u16Radius == roRef.u16Radius);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Restrictions_State::midw_ext_fi_tcl_e8_TCU_Restrictions_State():enType(FI_EN_NO_RESTRICTION) {}

tS32 midw_ext_fi_tcl_e8_TCU_Restrictions_State::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_RESTRICTIONS_STATE;
}


midw_ext_fi_tcl_e8_TCU_Restrictions_State::~midw_ext_fi_tcl_e8_TCU_Restrictions_State()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Restrictions_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Restrictions_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Restrictions_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Time_Limit_Restriction::midw_ext_fi_tcl_TCU_Time_Limit_Restriction(const midw_ext_fi_tcl_TCU_Time_Limit_Restriction& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   rTime_Slot = coRef.rTime_Slot;
}
midw_ext_fi_tcl_TCU_Time_Limit_Restriction& midw_ext_fi_tcl_TCU_Time_Limit_Restriction::operator=(const midw_ext_fi_tcl_TCU_Time_Limit_Restriction& coRef)
{
   if (this == &coRef) return *this;
   rTime_Slot = coRef.rTime_Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TCU_Time_Limit_Restriction::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < rTime_Slot.size(); ++u32Idx)
         rTime_Slot[u32Idx].vDestroy();
   rTime_Slot.clear();
   }
}

midw_ext_fi_tcl_TCU_Time_Limit_Restriction::midw_ext_fi_tcl_TCU_Time_Limit_Restriction()

 {}

tS32 midw_ext_fi_tcl_TCU_Time_Limit_Restriction::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_TIME_LIMIT_RESTRICTION;
}


midw_ext_fi_tcl_TCU_Time_Limit_Restriction::~midw_ext_fi_tcl_TCU_Time_Limit_Restriction()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TCU_Time_Limit_Restriction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(rTime_Slot.size()*17);
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Time_Limit_Restriction::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < rTime_Slot.size(); ++u32Idx)
      {
         rTime_Slot[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      rTime_Slot.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> rTime_Slot[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Time_Limit_Restriction::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)rTime_Slot.size());
   {
      for (tU32 u32Idx = 0; u32Idx < rTime_Slot.size(); ++u32Idx)
         (tVoid) (oOut << rTime_Slot[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Time_Limit_Restriction::operator==(const midw_ext_fi_tcl_TCU_Time_Limit_Restriction& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (rTime_Slot.size() == roRef.rTime_Slot.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < rTime_Slot.size()); ++u32Idx)
            bResult = bResult && (rTime_Slot[u32Idx] == roRef.rTime_Slot[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Time_Slot_State::midw_ext_fi_tcl_e8_TCU_Time_Slot_State():enType(FI_EN_ALL_TIME) {}

tS32 midw_ext_fi_tcl_e8_TCU_Time_Slot_State::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_TIME_SLOT_STATE;
}


midw_ext_fi_tcl_e8_TCU_Time_Slot_State::~midw_ext_fi_tcl_e8_TCU_Time_Slot_State()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Time_Slot_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Time_Slot_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Time_Slot_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Speed_Limit_Restriction::midw_ext_fi_tcl_TCU_Speed_Limit_Restriction(const midw_ext_fi_tcl_TCU_Speed_Limit_Restriction& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   rLimited_Vehicle_Speed = coRef.rLimited_Vehicle_Speed;
   rTime_Slot = coRef.rTime_Slot;
}
midw_ext_fi_tcl_TCU_Speed_Limit_Restriction& midw_ext_fi_tcl_TCU_Speed_Limit_Restriction::operator=(const midw_ext_fi_tcl_TCU_Speed_Limit_Restriction& coRef)
{
   if (this == &coRef) return *this;
   rLimited_Vehicle_Speed = coRef.rLimited_Vehicle_Speed;
   rTime_Slot = coRef.rTime_Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TCU_Speed_Limit_Restriction::vDestroy()
{
   {
   rLimited_Vehicle_Speed.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < rTime_Slot.size(); ++u32Idx)
         rTime_Slot[u32Idx].vDestroy();
   rTime_Slot.clear();
   }
}

midw_ext_fi_tcl_TCU_Speed_Limit_Restriction::midw_ext_fi_tcl_TCU_Speed_Limit_Restriction()


 {}

tS32 midw_ext_fi_tcl_TCU_Speed_Limit_Restriction::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_SPEED_LIMIT_RESTRICTION;
}


midw_ext_fi_tcl_TCU_Speed_Limit_Restriction::~midw_ext_fi_tcl_TCU_Speed_Limit_Restriction()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TCU_Speed_Limit_Restriction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(rLimited_Vehicle_Speed.size()*2)+ static_cast<tU32>(rTime_Slot.size()*17);
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Speed_Limit_Restriction::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      rLimited_Vehicle_Speed.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> rLimited_Vehicle_Speed[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < rTime_Slot.size(); ++u32Idx)
      {
         rTime_Slot[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      rTime_Slot.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> rTime_Slot[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Speed_Limit_Restriction::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)rLimited_Vehicle_Speed.size());
   {
      for (tU32 u32Idx = 0; u32Idx < rLimited_Vehicle_Speed.size(); ++u32Idx)
         (tVoid) (oOut << rLimited_Vehicle_Speed[u32Idx]);
   }
   (tVoid) (oOut << (tU32)rTime_Slot.size());
   {
      for (tU32 u32Idx = 0; u32Idx < rTime_Slot.size(); ++u32Idx)
         (tVoid) (oOut << rTime_Slot[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Speed_Limit_Restriction::operator==(const midw_ext_fi_tcl_TCU_Speed_Limit_Restriction& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (rLimited_Vehicle_Speed.size() == roRef.rLimited_Vehicle_Speed.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < rLimited_Vehicle_Speed.size()); ++u32Idx)
            bResult = bResult && (rLimited_Vehicle_Speed[u32Idx] == roRef.rLimited_Vehicle_Speed[u32Idx]);
      }
      bResult = bResult && (rTime_Slot.size() == roRef.rTime_Slot.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < rTime_Slot.size()); ++u32Idx)
            bResult = bResult && (rTime_Slot[u32Idx] == roRef.rTime_Slot[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Area_Limit_Restriction::midw_ext_fi_tcl_TCU_Area_Limit_Restriction(const midw_ext_fi_tcl_TCU_Area_Limit_Restriction& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   rArea_Limit_Coordinates = coRef.rArea_Limit_Coordinates;
   rTime_Slot = coRef.rTime_Slot;
}
midw_ext_fi_tcl_TCU_Area_Limit_Restriction& midw_ext_fi_tcl_TCU_Area_Limit_Restriction::operator=(const midw_ext_fi_tcl_TCU_Area_Limit_Restriction& coRef)
{
   if (this == &coRef) return *this;
   rArea_Limit_Coordinates = coRef.rArea_Limit_Coordinates;
   rTime_Slot = coRef.rTime_Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TCU_Area_Limit_Restriction::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < rArea_Limit_Coordinates.size(); ++u32Idx)
         rArea_Limit_Coordinates[u32Idx].vDestroy();
   rArea_Limit_Coordinates.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < rTime_Slot.size(); ++u32Idx)
         rTime_Slot[u32Idx].vDestroy();
   rTime_Slot.clear();
   }
}

midw_ext_fi_tcl_TCU_Area_Limit_Restriction::midw_ext_fi_tcl_TCU_Area_Limit_Restriction()


 {}

tS32 midw_ext_fi_tcl_TCU_Area_Limit_Restriction::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_AREA_LIMIT_RESTRICTION;
}


midw_ext_fi_tcl_TCU_Area_Limit_Restriction::~midw_ext_fi_tcl_TCU_Area_Limit_Restriction()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TCU_Area_Limit_Restriction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(rArea_Limit_Coordinates.size()*27)+ static_cast<tU32>(rTime_Slot.size()*17);
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Area_Limit_Restriction::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < rArea_Limit_Coordinates.size(); ++u32Idx)
      {
         rArea_Limit_Coordinates[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      rArea_Limit_Coordinates.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> rArea_Limit_Coordinates[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < rTime_Slot.size(); ++u32Idx)
      {
         rTime_Slot[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      rTime_Slot.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> rTime_Slot[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Area_Limit_Restriction::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)rArea_Limit_Coordinates.size());
   {
      for (tU32 u32Idx = 0; u32Idx < rArea_Limit_Coordinates.size(); ++u32Idx)
         (tVoid) (oOut << rArea_Limit_Coordinates[u32Idx]);
   }
   (tVoid) (oOut << (tU32)rTime_Slot.size());
   {
      for (tU32 u32Idx = 0; u32Idx < rTime_Slot.size(); ++u32Idx)
         (tVoid) (oOut << rTime_Slot[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Area_Limit_Restriction::operator==(const midw_ext_fi_tcl_TCU_Area_Limit_Restriction& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (rArea_Limit_Coordinates.size() == roRef.rArea_Limit_Coordinates.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < rArea_Limit_Coordinates.size()); ++u32Idx)
            bResult = bResult && (rArea_Limit_Coordinates[u32Idx] == roRef.rArea_Limit_Coordinates[u32Idx]);
      }
      bResult = bResult && (rTime_Slot.size() == roRef.rTime_Slot.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < rTime_Slot.size()); ++u32Idx)
            bResult = bResult && (rTime_Slot[u32Idx] == roRef.rTime_Slot[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_ConnectionType::midw_ext_fi_tcl_e8_TCU_ConnectionType():enType(FI_EN_INVALID_CONNECTION) {}

tS32 midw_ext_fi_tcl_e8_TCU_ConnectionType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_CONNECTIONTYPE;
}


midw_ext_fi_tcl_e8_TCU_ConnectionType::~midw_ext_fi_tcl_e8_TCU_ConnectionType()
{}

tU32 midw_ext_fi_tcl_e8_TCU_ConnectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_ConnectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_ConnectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_XCALL_Type::midw_ext_fi_tcl_e8_TCU_XCALL_Type():enType(FI_EN_BREAKDOWN_CALL) {}

tS32 midw_ext_fi_tcl_e8_TCU_XCALL_Type::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_XCALL_TYPE;
}


midw_ext_fi_tcl_e8_TCU_XCALL_Type::~midw_ext_fi_tcl_e8_TCU_XCALL_Type()
{}

tU32 midw_ext_fi_tcl_e8_TCU_XCALL_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_XCALL_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_XCALL_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_XCALL_Language::midw_ext_fi_tcl_e8_TCU_XCALL_Language():enType(FI_EN_UNSUPPORTED) {}

tS32 midw_ext_fi_tcl_e8_TCU_XCALL_Language::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_XCALL_LANGUAGE;
}


midw_ext_fi_tcl_e8_TCU_XCALL_Language::~midw_ext_fi_tcl_e8_TCU_XCALL_Language()
{}

tU32 midw_ext_fi_tcl_e8_TCU_XCALL_Language::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_XCALL_Language::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_XCALL_Language::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Response_Time_Out::midw_ext_fi_tcl_e8_TCU_Response_Time_Out():enType(FI_EN_SOFTWARE_VERSION) {}

tS32 midw_ext_fi_tcl_e8_TCU_Response_Time_Out::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_RESPONSE_TIME_OUT;
}


midw_ext_fi_tcl_e8_TCU_Response_Time_Out::~midw_ext_fi_tcl_e8_TCU_Response_Time_Out()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Response_Time_Out::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Response_Time_Out::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Response_Time_Out::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TCU_Response_Time_Out::midw_ext_fi_tcl_TCU_Response_Time_Out(const midw_ext_fi_tcl_TCU_Response_Time_Out& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   eTime_Out_Type = coRef.eTime_Out_Type;
}
midw_ext_fi_tcl_TCU_Response_Time_Out& midw_ext_fi_tcl_TCU_Response_Time_Out::operator=(const midw_ext_fi_tcl_TCU_Response_Time_Out& coRef)
{
   if (this == &coRef) return *this;
   eTime_Out_Type = coRef.eTime_Out_Type;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TCU_Response_Time_Out::vDestroy()
{
   {
   eTime_Out_Type.clear();
   }
}

midw_ext_fi_tcl_TCU_Response_Time_Out::midw_ext_fi_tcl_TCU_Response_Time_Out()

 {}

tS32 midw_ext_fi_tcl_TCU_Response_Time_Out::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_TCU_RESPONSE_TIME_OUT;
}


midw_ext_fi_tcl_TCU_Response_Time_Out::~midw_ext_fi_tcl_TCU_Response_Time_Out()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TCU_Response_Time_Out::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(eTime_Out_Type.size()*1);
}

fi_tclInContext& midw_ext_fi_tcl_TCU_Response_Time_Out::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      eTime_Out_Type.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> eTime_Out_Type[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TCU_Response_Time_Out::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)eTime_Out_Type.size());
   {
      for (tU32 u32Idx = 0; u32Idx < eTime_Out_Type.size(); ++u32Idx)
         (tVoid) (oOut << eTime_Out_Type[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_TCU_Response_Time_Out::operator==(const midw_ext_fi_tcl_TCU_Response_Time_Out& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (eTime_Out_Type.size() == roRef.eTime_Out_Type.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < eTime_Out_Type.size()); ++u32Idx)
            bResult = bResult && (eTime_Out_Type[u32Idx] == roRef.eTime_Out_Type[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_Availability::midw_ext_fi_tcl_e8_TCU_Availability():enType(FI_EN_WITHOUT_TCU) {}

tS32 midw_ext_fi_tcl_e8_TCU_Availability::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_AVAILABILITY;
}


midw_ext_fi_tcl_e8_TCU_Availability::~midw_ext_fi_tcl_e8_TCU_Availability()
{}

tU32 midw_ext_fi_tcl_e8_TCU_Availability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_Availability::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_Availability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_CallType::midw_ext_fi_tcl_e8_TCU_CallType():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_TCU_CallType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_CALLTYPE;
}


midw_ext_fi_tcl_e8_TCU_CallType::~midw_ext_fi_tcl_e8_TCU_CallType()
{}

tU32 midw_ext_fi_tcl_e8_TCU_CallType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_CallType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_CallType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TCU_PrivacyModes::midw_ext_fi_tcl_e8_TCU_PrivacyModes():enType(FI_EN_PRIVACY_MANAGER_ACTIVATED) {}

tS32 midw_ext_fi_tcl_e8_TCU_PrivacyModes::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_PRIVACYMODES;
}


midw_ext_fi_tcl_e8_TCU_PrivacyModes::~midw_ext_fi_tcl_e8_TCU_PrivacyModes()
{}

tU32 midw_ext_fi_tcl_e8_TCU_PrivacyModes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TCU_PrivacyModes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TCU_PrivacyModes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_Data_Header_Part::midw_ext_fi_tcl_usb_tcu_Data_Header_Part(const midw_ext_fi_tcl_usb_tcu_Data_Header_Part& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8NumOfPOI = coRef.u8NumOfPOI;
}
midw_ext_fi_tcl_usb_tcu_Data_Header_Part& midw_ext_fi_tcl_usb_tcu_Data_Header_Part::operator=(const midw_ext_fi_tcl_usb_tcu_Data_Header_Part& coRef)
{
   if (this == &coRef) return *this;
   u8NumOfPOI = coRef.u8NumOfPOI;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_usb_tcu_Data_Header_Part::midw_ext_fi_tcl_usb_tcu_Data_Header_Part()
:u8NumOfPOI(0)
 {}

tS32 midw_ext_fi_tcl_usb_tcu_Data_Header_Part::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_DATA_HEADER_PART;
}


midw_ext_fi_tcl_usb_tcu_Data_Header_Part::~midw_ext_fi_tcl_usb_tcu_Data_Header_Part()
{}

tU32 midw_ext_fi_tcl_usb_tcu_Data_Header_Part::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_Data_Header_Part::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumOfPOI);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_Data_Header_Part::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumOfPOI);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_Data_Header_Part::operator==(const midw_ext_fi_tcl_usb_tcu_Data_Header_Part& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumOfPOI == roRef.u8NumOfPOI);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_Location::midw_ext_fi_tcl_usb_tcu_Location(const midw_ext_fi_tcl_usb_tcu_Location& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8Direction = coRef.u8Direction;
   u8Reserved = coRef.u8Reserved;
   u8Longitude_Degree = coRef.u8Longitude_Degree;
   u8Longitude_minute = coRef.u8Longitude_minute;
   u16Longitude_second = coRef.u16Longitude_second;
   u8Latitude_degree = coRef.u8Latitude_degree;
   u8Latitude_minute = coRef.u8Latitude_minute;
   u16Latitude_second = coRef.u16Latitude_second;
}
midw_ext_fi_tcl_usb_tcu_Location& midw_ext_fi_tcl_usb_tcu_Location::operator=(const midw_ext_fi_tcl_usb_tcu_Location& coRef)
{
   if (this == &coRef) return *this;
   u8Direction = coRef.u8Direction;
   u8Reserved = coRef.u8Reserved;
   u8Longitude_Degree = coRef.u8Longitude_Degree;
   u8Longitude_minute = coRef.u8Longitude_minute;
   u16Longitude_second = coRef.u16Longitude_second;
   u8Latitude_degree = coRef.u8Latitude_degree;
   u8Latitude_minute = coRef.u8Latitude_minute;
   u16Latitude_second = coRef.u16Latitude_second;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_usb_tcu_Location::midw_ext_fi_tcl_usb_tcu_Location()
:u8Direction(0)
,u8Reserved(0)
,u8Longitude_Degree(0)
,u8Longitude_minute(0)
,u16Longitude_second(0)
,u8Latitude_degree(0)
,u8Latitude_minute(0)
,u16Latitude_second(0)
 {}

tS32 midw_ext_fi_tcl_usb_tcu_Location::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_LOCATION;
}


midw_ext_fi_tcl_usb_tcu_Location::~midw_ext_fi_tcl_usb_tcu_Location()
{}

tU32 midw_ext_fi_tcl_usb_tcu_Location::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_Location::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Direction);
   (tVoid) (oIn >> u8Reserved);
   (tVoid) (oIn >> u8Longitude_Degree);
   (tVoid) (oIn >> u8Longitude_minute);
   (tVoid) (oIn >> u16Longitude_second);
   (tVoid) (oIn >> u8Latitude_degree);
   (tVoid) (oIn >> u8Latitude_minute);
   (tVoid) (oIn >> u16Latitude_second);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_Location::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Direction);
   (tVoid) (oOut << u8Reserved);
   (tVoid) (oOut << u8Longitude_Degree);
   (tVoid) (oOut << u8Longitude_minute);
   (tVoid) (oOut << u16Longitude_second);
   (tVoid) (oOut << u8Latitude_degree);
   (tVoid) (oOut << u8Latitude_minute);
   (tVoid) (oOut << u16Latitude_second);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_Location::operator==(const midw_ext_fi_tcl_usb_tcu_Location& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Direction == roRef.u8Direction);
   bResult = bResult && (u8Reserved == roRef.u8Reserved);
   bResult = bResult && (u8Longitude_Degree == roRef.u8Longitude_Degree);
   bResult = bResult && (u8Longitude_minute == roRef.u8Longitude_minute);
   bResult = bResult && (u16Longitude_second == roRef.u16Longitude_second);
   bResult = bResult && (u8Latitude_degree == roRef.u8Latitude_degree);
   bResult = bResult && (u8Latitude_minute == roRef.u8Latitude_minute);
   bResult = bResult && (u16Latitude_second == roRef.u16Latitude_second);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_Data_Record::midw_ext_fi_tcl_usb_tcu_Data_Record(const midw_ext_fi_tcl_usb_tcu_Data_Record& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8SizeOfPOIName = coRef.u8SizeOfPOIName;
   strPOIName = coRef.strPOIName;
   Location = coRef.Location;
   u8SizeOfAddress = coRef.u8SizeOfAddress;
   strAddress = coRef.strAddress;
   u8SizeOfPhoneNumber = coRef.u8SizeOfPhoneNumber;
   strPhoneNumber = coRef.strPhoneNumber;
   u8SizeOfPhoneNumberForDisp = coRef.u8SizeOfPhoneNumberForDisp;
   strPhoneNumberForDisp = coRef.strPhoneNumberForDisp;
   u8SizeOfCategory = coRef.u8SizeOfCategory;
   strCategory = coRef.strCategory;
}
midw_ext_fi_tcl_usb_tcu_Data_Record& midw_ext_fi_tcl_usb_tcu_Data_Record::operator=(const midw_ext_fi_tcl_usb_tcu_Data_Record& coRef)
{
   if (this == &coRef) return *this;
   u8SizeOfPOIName = coRef.u8SizeOfPOIName;
   strPOIName = coRef.strPOIName;
   Location = coRef.Location;
   u8SizeOfAddress = coRef.u8SizeOfAddress;
   strAddress = coRef.strAddress;
   u8SizeOfPhoneNumber = coRef.u8SizeOfPhoneNumber;
   strPhoneNumber = coRef.strPhoneNumber;
   u8SizeOfPhoneNumberForDisp = coRef.u8SizeOfPhoneNumberForDisp;
   strPhoneNumberForDisp = coRef.strPhoneNumberForDisp;
   u8SizeOfCategory = coRef.u8SizeOfCategory;
   strCategory = coRef.strCategory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_usb_tcu_Data_Record::vDestroy()
{
   strPOIName.vDestroy();
   Location.vDestroy(); 
   strAddress.vDestroy();
   strPhoneNumber.vDestroy();
   strPhoneNumberForDisp.vDestroy();
   strCategory.vDestroy();
}

midw_ext_fi_tcl_usb_tcu_Data_Record::midw_ext_fi_tcl_usb_tcu_Data_Record()
:u8SizeOfPOIName(0)
,strPOIName()
,Location()
,u8SizeOfAddress(0)
,strAddress()
,u8SizeOfPhoneNumber(0)
,strPhoneNumber()
,u8SizeOfPhoneNumberForDisp(0)
,strPhoneNumberForDisp()
,u8SizeOfCategory(0)
,strCategory()
 {}

tS32 midw_ext_fi_tcl_usb_tcu_Data_Record::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_DATA_RECORD;
}


midw_ext_fi_tcl_usb_tcu_Data_Record::~midw_ext_fi_tcl_usb_tcu_Data_Record()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_usb_tcu_Data_Record::u32GetSize(tU16 u16MajorVersion) const
{
   return 15+strPOIName.u32GetSize(u16MajorVersion)+strAddress.u32GetSize(u16MajorVersion)+strPhoneNumber.u32GetSize(u16MajorVersion)+strPhoneNumberForDisp.u32GetSize(u16MajorVersion)+strCategory.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_Data_Record::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SizeOfPOIName);
   (tVoid) (oIn >> strPOIName);
   (tVoid) (oIn >> Location);
   (tVoid) (oIn >> u8SizeOfAddress);
   (tVoid) (oIn >> strAddress);
   (tVoid) (oIn >> u8SizeOfPhoneNumber);
   (tVoid) (oIn >> strPhoneNumber);
   (tVoid) (oIn >> u8SizeOfPhoneNumberForDisp);
   (tVoid) (oIn >> strPhoneNumberForDisp);
   (tVoid) (oIn >> u8SizeOfCategory);
   (tVoid) (oIn >> strCategory);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_Data_Record::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SizeOfPOIName);
   (tVoid) (oOut << strPOIName);
   (tVoid) (oOut << Location);
   (tVoid) (oOut << u8SizeOfAddress);
   (tVoid) (oOut << strAddress);
   (tVoid) (oOut << u8SizeOfPhoneNumber);
   (tVoid) (oOut << strPhoneNumber);
   (tVoid) (oOut << u8SizeOfPhoneNumberForDisp);
   (tVoid) (oOut << strPhoneNumberForDisp);
   (tVoid) (oOut << u8SizeOfCategory);
   (tVoid) (oOut << strCategory);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_Data_Record::operator==(const midw_ext_fi_tcl_usb_tcu_Data_Record& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SizeOfPOIName == roRef.u8SizeOfPOIName);
   bResult = bResult && (strPOIName == roRef.strPOIName);
   bResult = bResult && (Location == roRef.Location);
   bResult = bResult && (u8SizeOfAddress == roRef.u8SizeOfAddress);
   bResult = bResult && (strAddress == roRef.strAddress);
   bResult = bResult && (u8SizeOfPhoneNumber == roRef.u8SizeOfPhoneNumber);
   bResult = bResult && (strPhoneNumber == roRef.strPhoneNumber);
   bResult = bResult && (u8SizeOfPhoneNumberForDisp == roRef.u8SizeOfPhoneNumberForDisp);
   bResult = bResult && (strPhoneNumberForDisp == roRef.strPhoneNumberForDisp);
   bResult = bResult && (u8SizeOfCategory == roRef.u8SizeOfCategory);
   bResult = bResult && (strCategory == roRef.strCategory);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_connected_search_result::midw_ext_fi_tcl_usb_tcu_connected_search_result(const midw_ext_fi_tcl_usb_tcu_connected_search_result& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8NumOfPOI = coRef.u8NumOfPOI;
   DataRecord = coRef.DataRecord;
}
midw_ext_fi_tcl_usb_tcu_connected_search_result& midw_ext_fi_tcl_usb_tcu_connected_search_result::operator=(const midw_ext_fi_tcl_usb_tcu_connected_search_result& coRef)
{
   if (this == &coRef) return *this;
   u8NumOfPOI = coRef.u8NumOfPOI;
   DataRecord = coRef.DataRecord;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_usb_tcu_connected_search_result::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DataRecord.size(); ++u32Idx)
         DataRecord[u32Idx].vDestroy();
   DataRecord.clear();
   }
}

midw_ext_fi_tcl_usb_tcu_connected_search_result::midw_ext_fi_tcl_usb_tcu_connected_search_result()
:u8NumOfPOI(0)

 {}

tS32 midw_ext_fi_tcl_usb_tcu_connected_search_result::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_CONNECTED_SEARCH_RESULT;
}


midw_ext_fi_tcl_usb_tcu_connected_search_result::~midw_ext_fi_tcl_usb_tcu_connected_search_result()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_usb_tcu_connected_search_result::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DataRecord.size(); ++u32ListIdx)
      u32DynamicSize += DataRecord[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_connected_search_result::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumOfPOI);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DataRecord.size(); ++u32Idx)
      {
         DataRecord[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DataRecord.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DataRecord[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_connected_search_result::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumOfPOI);
   (tVoid) (oOut << (tU32)DataRecord.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DataRecord.size(); ++u32Idx)
         (tVoid) (oOut << DataRecord[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_connected_search_result::operator==(const midw_ext_fi_tcl_usb_tcu_connected_search_result& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumOfPOI == roRef.u8NumOfPOI);
      bResult = bResult && (DataRecord.size() == roRef.DataRecord.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DataRecord.size()); ++u32Idx)
            bResult = bResult && (DataRecord[u32Idx] == roRef.DataRecord[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_channel_master_data_header::midw_ext_fi_tcl_usb_tcu_channel_master_data_header(const midw_ext_fi_tcl_usb_tcu_channel_master_data_header& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8NumOfFolderDefInfo = coRef.u8NumOfFolderDefInfo;
   u16NumOfChannelDefInfo = coRef.u16NumOfChannelDefInfo;
}
midw_ext_fi_tcl_usb_tcu_channel_master_data_header& midw_ext_fi_tcl_usb_tcu_channel_master_data_header::operator=(const midw_ext_fi_tcl_usb_tcu_channel_master_data_header& coRef)
{
   if (this == &coRef) return *this;
   u8NumOfFolderDefInfo = coRef.u8NumOfFolderDefInfo;
   u16NumOfChannelDefInfo = coRef.u16NumOfChannelDefInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_usb_tcu_channel_master_data_header::midw_ext_fi_tcl_usb_tcu_channel_master_data_header()
:u8NumOfFolderDefInfo(0)
,u16NumOfChannelDefInfo(0)
 {}

tS32 midw_ext_fi_tcl_usb_tcu_channel_master_data_header::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_CHANNEL_MASTER_DATA_HEADER;
}


midw_ext_fi_tcl_usb_tcu_channel_master_data_header::~midw_ext_fi_tcl_usb_tcu_channel_master_data_header()
{}

tU32 midw_ext_fi_tcl_usb_tcu_channel_master_data_header::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_channel_master_data_header::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumOfFolderDefInfo);
   (tVoid) (oIn >> u16NumOfChannelDefInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_channel_master_data_header::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumOfFolderDefInfo);
   (tVoid) (oOut << u16NumOfChannelDefInfo);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_channel_master_data_header::operator==(const midw_ext_fi_tcl_usb_tcu_channel_master_data_header& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumOfFolderDefInfo == roRef.u8NumOfFolderDefInfo);
   bResult = bResult && (u16NumOfChannelDefInfo == roRef.u16NumOfChannelDefInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_Folder_definition_information::midw_ext_fi_tcl_usb_tcu_Folder_definition_information(const midw_ext_fi_tcl_usb_tcu_Folder_definition_information& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u16FolderID = coRef.u16FolderID;
   u16SizeOfFolderDefInfo = coRef.u16SizeOfFolderDefInfo;
   u8SizeOfFolderName = coRef.u8SizeOfFolderName;
   strFolderName = coRef.strFolderName;
   u8FixedData1 = coRef.u8FixedData1;
   u16FolderIconID = coRef.u16FolderIconID;
   u8FixedData2 = coRef.u8FixedData2;
}
midw_ext_fi_tcl_usb_tcu_Folder_definition_information& midw_ext_fi_tcl_usb_tcu_Folder_definition_information::operator=(const midw_ext_fi_tcl_usb_tcu_Folder_definition_information& coRef)
{
   if (this == &coRef) return *this;
   u16FolderID = coRef.u16FolderID;
   u16SizeOfFolderDefInfo = coRef.u16SizeOfFolderDefInfo;
   u8SizeOfFolderName = coRef.u8SizeOfFolderName;
   strFolderName = coRef.strFolderName;
   u8FixedData1 = coRef.u8FixedData1;
   u16FolderIconID = coRef.u16FolderIconID;
   u8FixedData2 = coRef.u8FixedData2;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_usb_tcu_Folder_definition_information::vDestroy()
{
   strFolderName.vDestroy();
}

midw_ext_fi_tcl_usb_tcu_Folder_definition_information::midw_ext_fi_tcl_usb_tcu_Folder_definition_information()
:u16FolderID(0)
,u16SizeOfFolderDefInfo(0)
,u8SizeOfFolderName(0)
,strFolderName()
,u8FixedData1(0)
,u16FolderIconID(0)
,u8FixedData2(0)
 {}

tS32 midw_ext_fi_tcl_usb_tcu_Folder_definition_information::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_FOLDER_DEFINITION_INFORMATION;
}


midw_ext_fi_tcl_usb_tcu_Folder_definition_information::~midw_ext_fi_tcl_usb_tcu_Folder_definition_information()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_usb_tcu_Folder_definition_information::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+strFolderName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_Folder_definition_information::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FolderID);
   (tVoid) (oIn >> u16SizeOfFolderDefInfo);
   (tVoid) (oIn >> u8SizeOfFolderName);
   (tVoid) (oIn >> strFolderName);
   (tVoid) (oIn >> u8FixedData1);
   (tVoid) (oIn >> u16FolderIconID);
   (tVoid) (oIn >> u8FixedData2);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_Folder_definition_information::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FolderID);
   (tVoid) (oOut << u16SizeOfFolderDefInfo);
   (tVoid) (oOut << u8SizeOfFolderName);
   (tVoid) (oOut << strFolderName);
   (tVoid) (oOut << u8FixedData1);
   (tVoid) (oOut << u16FolderIconID);
   (tVoid) (oOut << u8FixedData2);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_Folder_definition_information::operator==(const midw_ext_fi_tcl_usb_tcu_Folder_definition_information& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FolderID == roRef.u16FolderID);
   bResult = bResult && (u16SizeOfFolderDefInfo == roRef.u16SizeOfFolderDefInfo);
   bResult = bResult && (u8SizeOfFolderName == roRef.u8SizeOfFolderName);
   bResult = bResult && (strFolderName == roRef.strFolderName);
   bResult = bResult && (u8FixedData1 == roRef.u8FixedData1);
   bResult = bResult && (u16FolderIconID == roRef.u16FolderIconID);
   bResult = bResult && (u8FixedData2 == roRef.u8FixedData2);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_Channel_definition_information::midw_ext_fi_tcl_usb_tcu_Channel_definition_information(const midw_ext_fi_tcl_usb_tcu_Channel_definition_information& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u16ChannelID = coRef.u16ChannelID;
   u16SizeOfChannelDefInfo = coRef.u16SizeOfChannelDefInfo;
   u8SizeOfChannelName = coRef.u8SizeOfChannelName;
   strChannelName = coRef.strChannelName;
   u8FixedData1 = coRef.u8FixedData1;
   u16FolderID = coRef.u16FolderID;
   u16ChannelIconID = coRef.u16ChannelIconID;
   u8FixedData2 = coRef.u8FixedData2;
   u8FixedData3 = coRef.u8FixedData3;
   FixedData4 = coRef.FixedData4;
   FixedData5 = coRef.FixedData5;
   u8FlagOfChannelInfo = coRef.u8FlagOfChannelInfo;
   u8FixedData6 = coRef.u8FixedData6;
   u8FixedData7 = coRef.u8FixedData7;
   u8FixedData8 = coRef.u8FixedData8;
   u8FixedData9 = coRef.u8FixedData9;
}
midw_ext_fi_tcl_usb_tcu_Channel_definition_information& midw_ext_fi_tcl_usb_tcu_Channel_definition_information::operator=(const midw_ext_fi_tcl_usb_tcu_Channel_definition_information& coRef)
{
   if (this == &coRef) return *this;
   u16ChannelID = coRef.u16ChannelID;
   u16SizeOfChannelDefInfo = coRef.u16SizeOfChannelDefInfo;
   u8SizeOfChannelName = coRef.u8SizeOfChannelName;
   strChannelName = coRef.strChannelName;
   u8FixedData1 = coRef.u8FixedData1;
   u16FolderID = coRef.u16FolderID;
   u16ChannelIconID = coRef.u16ChannelIconID;
   u8FixedData2 = coRef.u8FixedData2;
   u8FixedData3 = coRef.u8FixedData3;
   FixedData4 = coRef.FixedData4;
   FixedData5 = coRef.FixedData5;
   u8FlagOfChannelInfo = coRef.u8FlagOfChannelInfo;
   u8FixedData6 = coRef.u8FixedData6;
   u8FixedData7 = coRef.u8FixedData7;
   u8FixedData8 = coRef.u8FixedData8;
   u8FixedData9 = coRef.u8FixedData9;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_usb_tcu_Channel_definition_information::vDestroy()
{
   strChannelName.vDestroy();
   {
   FixedData4.clear();
   }
   {
   FixedData5.clear();
   }
}

midw_ext_fi_tcl_usb_tcu_Channel_definition_information::midw_ext_fi_tcl_usb_tcu_Channel_definition_information()
:u16ChannelID(0)
,u16SizeOfChannelDefInfo(0)
,u8SizeOfChannelName(0)
,strChannelName()
,u8FixedData1(0)
,u16FolderID(0)
,u16ChannelIconID(0)
,u8FixedData2(0)
,u8FixedData3(0)


,u8FlagOfChannelInfo(0)
,u8FixedData6(0)
,u8FixedData7(0)
,u8FixedData8(0)
,u8FixedData9(0)
 {}

tS32 midw_ext_fi_tcl_usb_tcu_Channel_definition_information::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_CHANNEL_DEFINITION_INFORMATION;
}


midw_ext_fi_tcl_usb_tcu_Channel_definition_information::~midw_ext_fi_tcl_usb_tcu_Channel_definition_information()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_usb_tcu_Channel_definition_information::u32GetSize(tU16 u16MajorVersion) const
{
   return 25+strChannelName.u32GetSize(u16MajorVersion)+ static_cast<tU32>(FixedData4.size()*1)+ static_cast<tU32>(FixedData5.size()*1);
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_Channel_definition_information::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ChannelID);
   (tVoid) (oIn >> u16SizeOfChannelDefInfo);
   (tVoid) (oIn >> u8SizeOfChannelName);
   (tVoid) (oIn >> strChannelName);
   (tVoid) (oIn >> u8FixedData1);
   (tVoid) (oIn >> u16FolderID);
   (tVoid) (oIn >> u16ChannelIconID);
   (tVoid) (oIn >> u8FixedData2);
   (tVoid) (oIn >> u8FixedData3);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      FixedData4.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FixedData4[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      FixedData5.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FixedData5[u32Idx]);
      }
   }
   (tVoid) (oIn >> u8FlagOfChannelInfo);
   (tVoid) (oIn >> u8FixedData6);
   (tVoid) (oIn >> u8FixedData7);
   (tVoid) (oIn >> u8FixedData8);
   (tVoid) (oIn >> u8FixedData9);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_Channel_definition_information::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ChannelID);
   (tVoid) (oOut << u16SizeOfChannelDefInfo);
   (tVoid) (oOut << u8SizeOfChannelName);
   (tVoid) (oOut << strChannelName);
   (tVoid) (oOut << u8FixedData1);
   (tVoid) (oOut << u16FolderID);
   (tVoid) (oOut << u16ChannelIconID);
   (tVoid) (oOut << u8FixedData2);
   (tVoid) (oOut << u8FixedData3);
   (tVoid) (oOut << (tU32)FixedData4.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FixedData4.size(); ++u32Idx)
         (tVoid) (oOut << FixedData4[u32Idx]);
   }
   (tVoid) (oOut << (tU32)FixedData5.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FixedData5.size(); ++u32Idx)
         (tVoid) (oOut << FixedData5[u32Idx]);
   }
   (tVoid) (oOut << u8FlagOfChannelInfo);
   (tVoid) (oOut << u8FixedData6);
   (tVoid) (oOut << u8FixedData7);
   (tVoid) (oOut << u8FixedData8);
   (tVoid) (oOut << u8FixedData9);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_Channel_definition_information::operator==(const midw_ext_fi_tcl_usb_tcu_Channel_definition_information& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ChannelID == roRef.u16ChannelID);
   bResult = bResult && (u16SizeOfChannelDefInfo == roRef.u16SizeOfChannelDefInfo);
   bResult = bResult && (u8SizeOfChannelName == roRef.u8SizeOfChannelName);
   bResult = bResult && (strChannelName == roRef.strChannelName);
   bResult = bResult && (u8FixedData1 == roRef.u8FixedData1);
   bResult = bResult && (u16FolderID == roRef.u16FolderID);
   bResult = bResult && (u16ChannelIconID == roRef.u16ChannelIconID);
   bResult = bResult && (u8FixedData2 == roRef.u8FixedData2);
   bResult = bResult && (u8FixedData3 == roRef.u8FixedData3);
      bResult = bResult && (FixedData4.size() == roRef.FixedData4.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FixedData4.size()); ++u32Idx)
            bResult = bResult && (FixedData4[u32Idx] == roRef.FixedData4[u32Idx]);
      }
      bResult = bResult && (FixedData5.size() == roRef.FixedData5.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FixedData5.size()); ++u32Idx)
            bResult = bResult && (FixedData5[u32Idx] == roRef.FixedData5[u32Idx]);
      }
   bResult = bResult && (u8FlagOfChannelInfo == roRef.u8FlagOfChannelInfo);
   bResult = bResult && (u8FixedData6 == roRef.u8FixedData6);
   bResult = bResult && (u8FixedData7 == roRef.u8FixedData7);
   bResult = bResult && (u8FixedData8 == roRef.u8FixedData8);
   bResult = bResult && (u8FixedData9 == roRef.u8FixedData9);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_channel_master_data::midw_ext_fi_tcl_usb_tcu_channel_master_data(const midw_ext_fi_tcl_usb_tcu_channel_master_data& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ChannelMasterDataHeader = coRef.ChannelMasterDataHeader;
   FolderDefinitionInformation = coRef.FolderDefinitionInformation;
   ChannelDefinitionInformation = coRef.ChannelDefinitionInformation;
}
midw_ext_fi_tcl_usb_tcu_channel_master_data& midw_ext_fi_tcl_usb_tcu_channel_master_data::operator=(const midw_ext_fi_tcl_usb_tcu_channel_master_data& coRef)
{
   if (this == &coRef) return *this;
   ChannelMasterDataHeader = coRef.ChannelMasterDataHeader;
   FolderDefinitionInformation = coRef.FolderDefinitionInformation;
   ChannelDefinitionInformation = coRef.ChannelDefinitionInformation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_usb_tcu_channel_master_data::vDestroy()
{
   ChannelMasterDataHeader.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < FolderDefinitionInformation.size(); ++u32Idx)
         FolderDefinitionInformation[u32Idx].vDestroy();
   FolderDefinitionInformation.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelDefinitionInformation.size(); ++u32Idx)
         ChannelDefinitionInformation[u32Idx].vDestroy();
   ChannelDefinitionInformation.clear();
   }
}

midw_ext_fi_tcl_usb_tcu_channel_master_data::midw_ext_fi_tcl_usb_tcu_channel_master_data()
:ChannelMasterDataHeader()


 {}

tS32 midw_ext_fi_tcl_usb_tcu_channel_master_data::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_CHANNEL_MASTER_DATA;
}


midw_ext_fi_tcl_usb_tcu_channel_master_data::~midw_ext_fi_tcl_usb_tcu_channel_master_data()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_usb_tcu_channel_master_data::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FolderDefinitionInformation.size(); ++u32ListIdx)
      u32DynamicSize += FolderDefinitionInformation[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < ChannelDefinitionInformation.size(); ++u32ListIdx)
      u32DynamicSize += ChannelDefinitionInformation[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+11;
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_channel_master_data::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelMasterDataHeader);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FolderDefinitionInformation.size(); ++u32Idx)
      {
         FolderDefinitionInformation[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FolderDefinitionInformation.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FolderDefinitionInformation[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelDefinitionInformation.size(); ++u32Idx)
      {
         ChannelDefinitionInformation[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelDefinitionInformation.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelDefinitionInformation[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_channel_master_data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelMasterDataHeader);
   (tVoid) (oOut << (tU32)FolderDefinitionInformation.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FolderDefinitionInformation.size(); ++u32Idx)
         (tVoid) (oOut << FolderDefinitionInformation[u32Idx]);
   }
   (tVoid) (oOut << (tU32)ChannelDefinitionInformation.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelDefinitionInformation.size(); ++u32Idx)
         (tVoid) (oOut << ChannelDefinitionInformation[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_channel_master_data::operator==(const midw_ext_fi_tcl_usb_tcu_channel_master_data& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelMasterDataHeader == roRef.ChannelMasterDataHeader);
      bResult = bResult && (FolderDefinitionInformation.size() == roRef.FolderDefinitionInformation.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FolderDefinitionInformation.size()); ++u32Idx)
            bResult = bResult && (FolderDefinitionInformation[u32Idx] == roRef.FolderDefinitionInformation[u32Idx]);
      }
      bResult = bResult && (ChannelDefinitionInformation.size() == roRef.ChannelDefinitionInformation.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelDefinitionInformation.size()); ++u32Idx)
            bResult = bResult && (ChannelDefinitionInformation[u32Idx] == roRef.ChannelDefinitionInformation[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_tcu_AudioActivity::midw_ext_fi_tcl_e8_tcu_AudioActivity():enType(FI_EN_NONE) {}

tS32 midw_ext_fi_tcl_e8_tcu_AudioActivity::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_AUDIOACTIVITY;
}


midw_ext_fi_tcl_e8_tcu_AudioActivity::~midw_ext_fi_tcl_e8_tcu_AudioActivity()
{}

tU32 midw_ext_fi_tcl_e8_tcu_AudioActivity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_tcu_AudioActivity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_tcu_AudioActivity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_Channel_Info::midw_ext_fi_tcl_usb_tcu_Channel_Info(const midw_ext_fi_tcl_usb_tcu_Channel_Info& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u16ChannelID = coRef.u16ChannelID;
   u8ChannelContentID = coRef.u8ChannelContentID;
   u8ResumeDownload = coRef.u8ResumeDownload;
}
midw_ext_fi_tcl_usb_tcu_Channel_Info& midw_ext_fi_tcl_usb_tcu_Channel_Info::operator=(const midw_ext_fi_tcl_usb_tcu_Channel_Info& coRef)
{
   if (this == &coRef) return *this;
   u16ChannelID = coRef.u16ChannelID;
   u8ChannelContentID = coRef.u8ChannelContentID;
   u8ResumeDownload = coRef.u8ResumeDownload;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_usb_tcu_Channel_Info::midw_ext_fi_tcl_usb_tcu_Channel_Info()
:u16ChannelID(0)
,u8ChannelContentID(0)
,u8ResumeDownload(0)
 {}

tS32 midw_ext_fi_tcl_usb_tcu_Channel_Info::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_CHANNEL_INFO;
}


midw_ext_fi_tcl_usb_tcu_Channel_Info::~midw_ext_fi_tcl_usb_tcu_Channel_Info()
{}

tU32 midw_ext_fi_tcl_usb_tcu_Channel_Info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_Channel_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ChannelID);
   (tVoid) (oIn >> u8ChannelContentID);
   (tVoid) (oIn >> u8ResumeDownload);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_Channel_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ChannelID);
   (tVoid) (oOut << u8ChannelContentID);
   (tVoid) (oOut << u8ResumeDownload);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_Channel_Info::operator==(const midw_ext_fi_tcl_usb_tcu_Channel_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ChannelID == roRef.u16ChannelID);
   bResult = bResult && (u8ChannelContentID == roRef.u8ChannelContentID);
   bResult = bResult && (u8ResumeDownload == roRef.u8ResumeDownload);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_Channel_Info_List::midw_ext_fi_tcl_usb_tcu_Channel_Info_List(const midw_ext_fi_tcl_usb_tcu_Channel_Info_List& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ChannelInfoList = coRef.ChannelInfoList;
}
midw_ext_fi_tcl_usb_tcu_Channel_Info_List& midw_ext_fi_tcl_usb_tcu_Channel_Info_List::operator=(const midw_ext_fi_tcl_usb_tcu_Channel_Info_List& coRef)
{
   if (this == &coRef) return *this;
   ChannelInfoList = coRef.ChannelInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_usb_tcu_Channel_Info_List::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelInfoList.size(); ++u32Idx)
         ChannelInfoList[u32Idx].vDestroy();
   ChannelInfoList.clear();
   }
}

midw_ext_fi_tcl_usb_tcu_Channel_Info_List::midw_ext_fi_tcl_usb_tcu_Channel_Info_List()

 {}

tS32 midw_ext_fi_tcl_usb_tcu_Channel_Info_List::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_CHANNEL_INFO_LIST;
}


midw_ext_fi_tcl_usb_tcu_Channel_Info_List::~midw_ext_fi_tcl_usb_tcu_Channel_Info_List()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_usb_tcu_Channel_Info_List::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ChannelInfoList.size()*4);
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_Channel_Info_List::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelInfoList.size(); ++u32Idx)
      {
         ChannelInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_Channel_Info_List::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ChannelInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelInfoList.size(); ++u32Idx)
         (tVoid) (oOut << ChannelInfoList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_Channel_Info_List::operator==(const midw_ext_fi_tcl_usb_tcu_Channel_Info_List& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ChannelInfoList.size() == roRef.ChannelInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelInfoList.size()); ++u32Idx)
            bResult = bResult && (ChannelInfoList[u32Idx] == roRef.ChannelInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info::midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info(const midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   strNaviID = coRef.strNaviID;
   strSimID = coRef.strSimID;
   strVinID = coRef.strVinID;
}
midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info& midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info::operator=(const midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info& coRef)
{
   if (this == &coRef) return *this;
   strNaviID = coRef.strNaviID;
   strSimID = coRef.strSimID;
   strVinID = coRef.strVinID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info::vDestroy()
{
   strNaviID.vDestroy();
   strSimID.vDestroy();
   strVinID.vDestroy();
}

midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info::midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info()
:strNaviID()
,strSimID()
,strVinID()
 {}

tS32 midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_GROUPA_AUTHORIZATION_INFO;
}


midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info::~midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strNaviID.u32GetSize(u16MajorVersion)+strSimID.u32GetSize(u16MajorVersion)+strVinID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strNaviID);
   (tVoid) (oIn >> strSimID);
   (tVoid) (oIn >> strVinID);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strNaviID);
   (tVoid) (oOut << strSimID);
   (tVoid) (oOut << strVinID);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info::operator==(const midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strNaviID == roRef.strNaviID);
   bResult = bResult && (strSimID == roRef.strSimID);
   bResult = bResult && (strVinID == roRef.strVinID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info::midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info(const midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   strNaviSWVersion = coRef.strNaviSWVersion;
   strMapVersion = coRef.strMapVersion;
   strDcmVersion = coRef.strDcmVersion;
   strDatum = coRef.strDatum;
   strLatitude = coRef.strLatitude;
   strLongitude = coRef.strLongitude;
   strLanguage = coRef.strLanguage;
}
midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info& midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info::operator=(const midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info& coRef)
{
   if (this == &coRef) return *this;
   strNaviSWVersion = coRef.strNaviSWVersion;
   strMapVersion = coRef.strMapVersion;
   strDcmVersion = coRef.strDcmVersion;
   strDatum = coRef.strDatum;
   strLatitude = coRef.strLatitude;
   strLongitude = coRef.strLongitude;
   strLanguage = coRef.strLanguage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info::vDestroy()
{
   strNaviSWVersion.vDestroy();
   strMapVersion.vDestroy();
   strDcmVersion.vDestroy();
   strDatum.vDestroy();
   strLatitude.vDestroy();
   strLongitude.vDestroy();
   strLanguage.vDestroy();
}

midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info::midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info()
:strNaviSWVersion()
,strMapVersion()
,strDcmVersion()
,strDatum()
,strLatitude()
,strLongitude()
,strLanguage()
 {}

tS32 midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_GROUPA_BASICSERVICES_INFO;
}


midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info::~midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strNaviSWVersion.u32GetSize(u16MajorVersion)+strMapVersion.u32GetSize(u16MajorVersion)+strDcmVersion.u32GetSize(u16MajorVersion)+strDatum.u32GetSize(u16MajorVersion)+strLatitude.u32GetSize(u16MajorVersion)+strLongitude.u32GetSize(u16MajorVersion)+strLanguage.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strNaviSWVersion);
   (tVoid) (oIn >> strMapVersion);
   (tVoid) (oIn >> strDcmVersion);
   (tVoid) (oIn >> strDatum);
   (tVoid) (oIn >> strLatitude);
   (tVoid) (oIn >> strLongitude);
   (tVoid) (oIn >> strLanguage);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strNaviSWVersion);
   (tVoid) (oOut << strMapVersion);
   (tVoid) (oOut << strDcmVersion);
   (tVoid) (oOut << strDatum);
   (tVoid) (oOut << strLatitude);
   (tVoid) (oOut << strLongitude);
   (tVoid) (oOut << strLanguage);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info::operator==(const midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strNaviSWVersion == roRef.strNaviSWVersion);
   bResult = bResult && (strMapVersion == roRef.strMapVersion);
   bResult = bResult && (strDcmVersion == roRef.strDcmVersion);
   bResult = bResult && (strDatum == roRef.strDatum);
   bResult = bResult && (strLatitude == roRef.strLatitude);
   bResult = bResult && (strLongitude == roRef.strLongitude);
   bResult = bResult && (strLanguage == roRef.strLanguage);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_GroupA_Info::midw_ext_fi_tcl_usb_tcu_GroupA_Info(const midw_ext_fi_tcl_usb_tcu_GroupA_Info& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   GroupA_Authorization_Info = coRef.GroupA_Authorization_Info;
   GroupA_BasicServices_Info = coRef.GroupA_BasicServices_Info;
}
midw_ext_fi_tcl_usb_tcu_GroupA_Info& midw_ext_fi_tcl_usb_tcu_GroupA_Info::operator=(const midw_ext_fi_tcl_usb_tcu_GroupA_Info& coRef)
{
   if (this == &coRef) return *this;
   GroupA_Authorization_Info = coRef.GroupA_Authorization_Info;
   GroupA_BasicServices_Info = coRef.GroupA_BasicServices_Info;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_usb_tcu_GroupA_Info::vDestroy()
{
   GroupA_Authorization_Info.vDestroy(); 
   GroupA_BasicServices_Info.vDestroy(); 
}

midw_ext_fi_tcl_usb_tcu_GroupA_Info::midw_ext_fi_tcl_usb_tcu_GroupA_Info()
:GroupA_Authorization_Info()
,GroupA_BasicServices_Info()
 {}

tS32 midw_ext_fi_tcl_usb_tcu_GroupA_Info::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_GROUPA_INFO;
}


midw_ext_fi_tcl_usb_tcu_GroupA_Info::~midw_ext_fi_tcl_usb_tcu_GroupA_Info()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_usb_tcu_GroupA_Info::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+GroupA_Authorization_Info.u32GetSize(u16MajorVersion)+GroupA_BasicServices_Info.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_GroupA_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GroupA_Authorization_Info);
   (tVoid) (oIn >> GroupA_BasicServices_Info);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_GroupA_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GroupA_Authorization_Info);
   (tVoid) (oOut << GroupA_BasicServices_Info);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_GroupA_Info::operator==(const midw_ext_fi_tcl_usb_tcu_GroupA_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GroupA_Authorization_Info == roRef.GroupA_Authorization_Info);
   bResult = bResult && (GroupA_BasicServices_Info == roRef.GroupA_BasicServices_Info);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_ConnectedSearchServiceType::midw_ext_fi_tcl_e8_ConnectedSearchServiceType():enType(FI_EN_USB_TCU_CONNECTED_SEARCH_SERVICE_TYPE_NONE) {}

tS32 midw_ext_fi_tcl_e8_ConnectedSearchServiceType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_CONNECTEDSEARCHSERVICETYPE;
}


midw_ext_fi_tcl_e8_ConnectedSearchServiceType::~midw_ext_fi_tcl_e8_ConnectedSearchServiceType()
{}

tU32 midw_ext_fi_tcl_e8_ConnectedSearchServiceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_ConnectedSearchServiceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_ConnectedSearchServiceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_tcu_ExecType::midw_ext_fi_tcl_e8_tcu_ExecType():enType(FI_EN_RESERVED) {}

tS32 midw_ext_fi_tcl_e8_tcu_ExecType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_EXECTYPE;
}


midw_ext_fi_tcl_e8_tcu_ExecType::~midw_ext_fi_tcl_e8_tcu_ExecType()
{}

tU32 midw_ext_fi_tcl_e8_tcu_ExecType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_tcu_ExecType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_tcu_ExecType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DatabaseStatus::midw_ext_fi_tcl_e8_DatabaseStatus():enType(FI_EN_DATABASE_STATUS_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_DatabaseStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DATABASESTATUS;
}


midw_ext_fi_tcl_e8_DatabaseStatus::~midw_ext_fi_tcl_e8_DatabaseStatus()
{}

tU32 midw_ext_fi_tcl_e8_DatabaseStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DatabaseStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DatabaseStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DatabaseServiceType::midw_ext_fi_tcl_e8_DatabaseServiceType():enType(FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_DatabaseServiceType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DATABASESERVICETYPE;
}


midw_ext_fi_tcl_e8_DatabaseServiceType::~midw_ext_fi_tcl_e8_DatabaseServiceType()
{}

tU32 midw_ext_fi_tcl_e8_DatabaseServiceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DatabaseServiceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DatabaseServiceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_CancelRequestType::midw_ext_fi_tcl_e8_CancelRequestType():enType(FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_NONE) {}

tS32 midw_ext_fi_tcl_e8_CancelRequestType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_CANCELREQUESTTYPE;
}


midw_ext_fi_tcl_e8_CancelRequestType::~midw_ext_fi_tcl_e8_CancelRequestType()
{}

tU32 midw_ext_fi_tcl_e8_CancelRequestType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_CancelRequestType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_CancelRequestType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_Server_Info::midw_ext_fi_tcl_usb_tcu_Server_Info(const midw_ext_fi_tcl_usb_tcu_Server_Info& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   u8ServerId = coRef.u8ServerId;
   strServerName = coRef.strServerName;
   strServerAddress = coRef.strServerAddress;
}
midw_ext_fi_tcl_usb_tcu_Server_Info& midw_ext_fi_tcl_usb_tcu_Server_Info::operator=(const midw_ext_fi_tcl_usb_tcu_Server_Info& coRef)
{
   if (this == &coRef) return *this;
   u8ServerId = coRef.u8ServerId;
   strServerName = coRef.strServerName;
   strServerAddress = coRef.strServerAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_usb_tcu_Server_Info::vDestroy()
{
   strServerName.vDestroy();
   strServerAddress.vDestroy();
}

midw_ext_fi_tcl_usb_tcu_Server_Info::midw_ext_fi_tcl_usb_tcu_Server_Info()
:u8ServerId(0)
,strServerName()
,strServerAddress()
 {}

tS32 midw_ext_fi_tcl_usb_tcu_Server_Info::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_SERVER_INFO;
}


midw_ext_fi_tcl_usb_tcu_Server_Info::~midw_ext_fi_tcl_usb_tcu_Server_Info()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_usb_tcu_Server_Info::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+strServerName.u32GetSize(u16MajorVersion)+strServerAddress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_Server_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8ServerId);
   (tVoid) (oIn >> strServerName);
   (tVoid) (oIn >> strServerAddress);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_Server_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8ServerId);
   (tVoid) (oOut << strServerName);
   (tVoid) (oOut << strServerAddress);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_Server_Info::operator==(const midw_ext_fi_tcl_usb_tcu_Server_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8ServerId == roRef.u8ServerId);
   bResult = bResult && (strServerName == roRef.strServerName);
   bResult = bResult && (strServerAddress == roRef.strServerAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_Server_Info_List::midw_ext_fi_tcl_usb_tcu_Server_Info_List(const midw_ext_fi_tcl_usb_tcu_Server_Info_List& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ServerInfoList = coRef.ServerInfoList;
}
midw_ext_fi_tcl_usb_tcu_Server_Info_List& midw_ext_fi_tcl_usb_tcu_Server_Info_List::operator=(const midw_ext_fi_tcl_usb_tcu_Server_Info_List& coRef)
{
   if (this == &coRef) return *this;
   ServerInfoList = coRef.ServerInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_usb_tcu_Server_Info_List::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ServerInfoList.size(); ++u32Idx)
         ServerInfoList[u32Idx].vDestroy();
   ServerInfoList.clear();
   }
}

midw_ext_fi_tcl_usb_tcu_Server_Info_List::midw_ext_fi_tcl_usb_tcu_Server_Info_List()

 {}

tS32 midw_ext_fi_tcl_usb_tcu_Server_Info_List::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_SERVER_INFO_LIST;
}


midw_ext_fi_tcl_usb_tcu_Server_Info_List::~midw_ext_fi_tcl_usb_tcu_Server_Info_List()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_usb_tcu_Server_Info_List::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ServerInfoList.size(); ++u32ListIdx)
      u32DynamicSize += ServerInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_Server_Info_List::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ServerInfoList.size(); ++u32Idx)
      {
         ServerInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ServerInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ServerInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_Server_Info_List::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ServerInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ServerInfoList.size(); ++u32Idx)
         (tVoid) (oOut << ServerInfoList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_Server_Info_List::operator==(const midw_ext_fi_tcl_usb_tcu_Server_Info_List& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ServerInfoList.size() == roRef.ServerInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ServerInfoList.size()); ++u32Idx)
            bResult = bResult && (ServerInfoList[u32Idx] == roRef.ServerInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DataConnectionStatus::midw_ext_fi_tcl_e8_DataConnectionStatus():enType(FI_EN_USB_TCU_DATA_CONNECTION_STATUS_DISCONNECTED) {}

tS32 midw_ext_fi_tcl_e8_DataConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DATACONNECTIONSTATUS;
}


midw_ext_fi_tcl_e8_DataConnectionStatus::~midw_ext_fi_tcl_e8_DataConnectionStatus()
{}

tU32 midw_ext_fi_tcl_e8_DataConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DataConnectionStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DataConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_DataDownloadStatus::midw_ext_fi_tcl_e8_DataDownloadStatus():enType(FI_EN_USB_TCU_DATA_DOWNLOAD_STATUS_NONE) {}

tS32 midw_ext_fi_tcl_e8_DataDownloadStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_DATADOWNLOADSTATUS;
}


midw_ext_fi_tcl_e8_DataDownloadStatus::~midw_ext_fi_tcl_e8_DataDownloadStatus()
{}

tU32 midw_ext_fi_tcl_e8_DataDownloadStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_DataDownloadStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_DataDownloadStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e16_DataConnectionError::midw_ext_fi_tcl_e16_DataConnectionError():enType(FI_EN_USB_TCU_DATA_CONNECTION_ERROR_IDLE_OR_NOERROR) {}

tS32 midw_ext_fi_tcl_e16_DataConnectionError::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E16_DATACONNECTIONERROR;
}


midw_ext_fi_tcl_e16_DataConnectionError::~midw_ext_fi_tcl_e16_DataConnectionError()
{}

tU32 midw_ext_fi_tcl_e16_DataConnectionError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_e16_DataConnectionError::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e16_DataConnectionError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_ModemType::midw_ext_fi_tcl_e8_ModemType():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_ModemType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_MODEMTYPE;
}


midw_ext_fi_tcl_e8_ModemType::~midw_ext_fi_tcl_e8_ModemType()
{}

tU32 midw_ext_fi_tcl_e8_ModemType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_ModemType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_ModemType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_usb_tcu_TCUDevice_Info::midw_ext_fi_tcl_usb_tcu_TCUDevice_Info(const midw_ext_fi_tcl_usb_tcu_TCUDevice_Info& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   bUSBConnectionStatus = coRef.bUSBConnectionStatus;
   eModemType = coRef.eModemType;
}
midw_ext_fi_tcl_usb_tcu_TCUDevice_Info& midw_ext_fi_tcl_usb_tcu_TCUDevice_Info::operator=(const midw_ext_fi_tcl_usb_tcu_TCUDevice_Info& coRef)
{
   if (this == &coRef) return *this;
   bUSBConnectionStatus = coRef.bUSBConnectionStatus;
   eModemType = coRef.eModemType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_usb_tcu_TCUDevice_Info::midw_ext_fi_tcl_usb_tcu_TCUDevice_Info()
:bUSBConnectionStatus(0)
,eModemType()
 {}

tS32 midw_ext_fi_tcl_usb_tcu_TCUDevice_Info::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_USB_TCU_TCUDEVICE_INFO;
}


midw_ext_fi_tcl_usb_tcu_TCUDevice_Info::~midw_ext_fi_tcl_usb_tcu_TCUDevice_Info()
{}

tU32 midw_ext_fi_tcl_usb_tcu_TCUDevice_Info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_usb_tcu_TCUDevice_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bUSBConnectionStatus);
   (tVoid) (oIn >> eModemType);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_usb_tcu_TCUDevice_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bUSBConnectionStatus);
   (tVoid) (oOut << eModemType);
   return oOut;
}

tBool midw_ext_fi_tcl_usb_tcu_TCUDevice_Info::operator==(const midw_ext_fi_tcl_usb_tcu_TCUDevice_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bUSBConnectionStatus == roRef.bUSBConnectionStatus);
   bResult = bResult && (eModemType == roRef.eModemType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_tcu_LogLevel::midw_ext_fi_tcl_e8_tcu_LogLevel():enType(FI_EN_USB_TCU_LOG_LEVEL_DEBUG) {}

tS32 midw_ext_fi_tcl_e8_tcu_LogLevel::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TCU_LOGLEVEL;
}


midw_ext_fi_tcl_e8_tcu_LogLevel::~midw_ext_fi_tcl_e8_tcu_LogLevel()
{}

tU32 midw_ext_fi_tcl_e8_tcu_LogLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_tcu_LogLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_tcu_LogLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SxmPredefinedListIds::midw_ext_fi_tcl_e8_SxmPredefinedListIds():enType(FI_EN_NEAR_BY) {}

tS32 midw_ext_fi_tcl_e8_SxmPredefinedListIds::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SXMPREDEFINEDLISTIDS;
}


midw_ext_fi_tcl_e8_SxmPredefinedListIds::~midw_ext_fi_tcl_e8_SxmPredefinedListIds()
{}

tU32 midw_ext_fi_tcl_e8_SxmPredefinedListIds::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SxmPredefinedListIds::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SxmPredefinedListIds::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SxmListType::midw_ext_fi_tcl_e8_SxmListType():enType(FI_EN_NEAR_BY) {}

tS32 midw_ext_fi_tcl_e8_SxmListType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SXMLISTTYPE;
}


midw_ext_fi_tcl_e8_SxmListType::~midw_ext_fi_tcl_e8_SxmListType()
{}

tU32 midw_ext_fi_tcl_e8_SxmListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SxmListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SxmListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SxmListStatus::midw_ext_fi_tcl_e8_SxmListStatus():enType(FI_EN_INVALID) {}

tS32 midw_ext_fi_tcl_e8_SxmListStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SXMLISTSTATUS;
}


midw_ext_fi_tcl_e8_SxmListStatus::~midw_ext_fi_tcl_e8_SxmListStatus()
{}

tU32 midw_ext_fi_tcl_e8_SxmListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SxmListStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SxmListStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SxmListMode::midw_ext_fi_tcl_e8_SxmListMode():enType(FI_EN_RELEASE) {}

tS32 midw_ext_fi_tcl_e8_SxmListMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SXMLISTMODE;
}


midw_ext_fi_tcl_e8_SxmListMode::~midw_ext_fi_tcl_e8_SxmListMode()
{}

tU32 midw_ext_fi_tcl_e8_SxmListMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SxmListMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SxmListMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmListMode::midw_ext_fi_tcl_SxmListMode(const midw_ext_fi_tcl_SxmListMode& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ListID = coRef.ListID;
   Mode = coRef.Mode;
}
midw_ext_fi_tcl_SxmListMode& midw_ext_fi_tcl_SxmListMode::operator=(const midw_ext_fi_tcl_SxmListMode& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Mode = coRef.Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SxmListMode::midw_ext_fi_tcl_SxmListMode()
:ListID(0)
,Mode()
 {}

tS32 midw_ext_fi_tcl_SxmListMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMLISTMODE;
}


midw_ext_fi_tcl_SxmListMode::~midw_ext_fi_tcl_SxmListMode()
{}

tU32 midw_ext_fi_tcl_SxmListMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_fi_tcl_SxmListMode::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Mode);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmListMode::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Mode);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmListMode::operator==(const midw_ext_fi_tcl_SxmListMode& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Mode == roRef.Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SxmListOperation::midw_ext_fi_tcl_e8_SxmListOperation():enType(FI_EN_IDLE) {}

tS32 midw_ext_fi_tcl_e8_SxmListOperation::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SXMLISTOPERATION;
}


midw_ext_fi_tcl_e8_SxmListOperation::~midw_ext_fi_tcl_e8_SxmListOperation()
{}

tU32 midw_ext_fi_tcl_e8_SxmListOperation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SxmListOperation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SxmListOperation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmLocation::midw_ext_fi_tcl_SxmLocation(const midw_ext_fi_tcl_SxmLocation& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Lat = coRef.Lat;
   Lon = coRef.Lon;
   Radius = coRef.Radius;
}
midw_ext_fi_tcl_SxmLocation& midw_ext_fi_tcl_SxmLocation::operator=(const midw_ext_fi_tcl_SxmLocation& coRef)
{
   if (this == &coRef) return *this;
   Lat = coRef.Lat;
   Lon = coRef.Lon;
   Radius = coRef.Radius;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SxmLocation::midw_ext_fi_tcl_SxmLocation()
:Lat(0)
,Lon(0)
,Radius(0)
 {}

tS32 midw_ext_fi_tcl_SxmLocation::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMLOCATION;
}


midw_ext_fi_tcl_SxmLocation::~midw_ext_fi_tcl_SxmLocation()
{}

tU32 midw_ext_fi_tcl_SxmLocation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_ext_fi_tcl_SxmLocation::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Lat);
   (tVoid) (oIn >> Lon);
   (tVoid) (oIn >> Radius);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmLocation::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Lat);
   (tVoid) (oOut << Lon);
   (tVoid) (oOut << Radius);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmLocation::operator==(const midw_ext_fi_tcl_SxmLocation& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Lat == roRef.Lat);
   bResult = bResult && (Lon == roRef.Lon);
   bResult = bResult && (Radius == roRef.Radius);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmListInfo::midw_ext_fi_tcl_SxmListInfo(const midw_ext_fi_tcl_SxmListInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ListID = coRef.ListID;
   ListType = coRef.ListType;
   Status = coRef.Status;
   State = coRef.State;
   Mode = coRef.Mode;
   bEmpty = coRef.bEmpty;
   Size = coRef.Size;
}
midw_ext_fi_tcl_SxmListInfo& midw_ext_fi_tcl_SxmListInfo::operator=(const midw_ext_fi_tcl_SxmListInfo& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   ListType = coRef.ListType;
   Status = coRef.Status;
   State = coRef.State;
   Mode = coRef.Mode;
   bEmpty = coRef.bEmpty;
   Size = coRef.Size;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SxmListInfo::midw_ext_fi_tcl_SxmListInfo()
:ListID(0)
,ListType()
,Status()
,State()
,Mode()
,bEmpty(0)
,Size(0)
 {}

tS32 midw_ext_fi_tcl_SxmListInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMLISTINFO;
}


midw_ext_fi_tcl_SxmListInfo::~midw_ext_fi_tcl_SxmListInfo()
{}

tU32 midw_ext_fi_tcl_SxmListInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& midw_ext_fi_tcl_SxmListInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> ListType);
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Mode);
   (tVoid) (oIn >> bEmpty);
   (tVoid) (oIn >> Size);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmListInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << ListType);
   (tVoid) (oOut << Status);
   (tVoid) (oOut << State);
   (tVoid) (oOut << Mode);
   (tVoid) (oOut << bEmpty);
   (tVoid) (oOut << Size);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmListInfo::operator==(const midw_ext_fi_tcl_SxmListInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (ListType == roRef.ListType);
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Mode == roRef.Mode);
   bResult = bResult && (bEmpty == roRef.bEmpty);
   bResult = bResult && (Size == roRef.Size);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmListsConfig::midw_ext_fi_tcl_SxmListsConfig(const midw_ext_fi_tcl_SxmListsConfig& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Capacity = coRef.Capacity;
}
midw_ext_fi_tcl_SxmListsConfig& midw_ext_fi_tcl_SxmListsConfig::operator=(const midw_ext_fi_tcl_SxmListsConfig& coRef)
{
   if (this == &coRef) return *this;
   Capacity = coRef.Capacity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SxmListsConfig::midw_ext_fi_tcl_SxmListsConfig()
:Capacity(0)
 {}

tS32 midw_ext_fi_tcl_SxmListsConfig::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMLISTSCONFIG;
}


midw_ext_fi_tcl_SxmListsConfig::~midw_ext_fi_tcl_SxmListsConfig()
{}

tU32 midw_ext_fi_tcl_SxmListsConfig::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_SxmListsConfig::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Capacity);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmListsConfig::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Capacity);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmListsConfig::operator==(const midw_ext_fi_tcl_SxmListsConfig& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Capacity == roRef.Capacity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmListInfos::midw_ext_fi_tcl_SxmListInfos(const midw_ext_fi_tcl_SxmListInfos& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   GenericConfig = coRef.GenericConfig;
   ListInfo = coRef.ListInfo;
}
midw_ext_fi_tcl_SxmListInfos& midw_ext_fi_tcl_SxmListInfos::operator=(const midw_ext_fi_tcl_SxmListInfos& coRef)
{
   if (this == &coRef) return *this;
   GenericConfig = coRef.GenericConfig;
   ListInfo = coRef.ListInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SxmListInfos::vDestroy()
{
   GenericConfig.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < ListInfo.size(); ++u32Idx)
         ListInfo[u32Idx].vDestroy();
   ListInfo.clear();
   }
}

midw_ext_fi_tcl_SxmListInfos::midw_ext_fi_tcl_SxmListInfos()
:GenericConfig()

 {}

tS32 midw_ext_fi_tcl_SxmListInfos::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMLISTINFOS;
}


midw_ext_fi_tcl_SxmListInfos::~midw_ext_fi_tcl_SxmListInfos()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SxmListInfos::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(ListInfo.size()*13);
}

fi_tclInContext& midw_ext_fi_tcl_SxmListInfos::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GenericConfig);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListInfo.size(); ++u32Idx)
      {
         ListInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListInfo[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmListInfos::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GenericConfig);
   (tVoid) (oOut << (tU32)ListInfo.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListInfo.size(); ++u32Idx)
         (tVoid) (oOut << ListInfo[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_SxmListInfos::operator==(const midw_ext_fi_tcl_SxmListInfos& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GenericConfig == roRef.GenericConfig);
      bResult = bResult && (ListInfo.size() == roRef.ListInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListInfo.size()); ++u32Idx)
            bResult = bResult && (ListInfo[u32Idx] == roRef.ListInfo[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SxmDataServiceStatus::midw_ext_fi_tcl_e8_SxmDataServiceStatus():enType(FI_EN_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_SxmDataServiceStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SXMDATASERVICESTATUS;
}


midw_ext_fi_tcl_e8_SxmDataServiceStatus::~midw_ext_fi_tcl_e8_SxmDataServiceStatus()
{}

tU32 midw_ext_fi_tcl_e8_SxmDataServiceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SxmDataServiceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SxmDataServiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmDataSrvState::midw_ext_fi_tcl_SxmDataSrvState(const midw_ext_fi_tcl_SxmDataSrvState& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
}
midw_ext_fi_tcl_SxmDataSrvState& midw_ext_fi_tcl_SxmDataSrvState::operator=(const midw_ext_fi_tcl_SxmDataSrvState& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SxmDataSrvState::midw_ext_fi_tcl_SxmDataSrvState()
:Status()
 {}

tS32 midw_ext_fi_tcl_SxmDataSrvState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMDATASRVSTATE;
}


midw_ext_fi_tcl_SxmDataSrvState::~midw_ext_fi_tcl_SxmDataSrvState()
{}

tU32 midw_ext_fi_tcl_SxmDataSrvState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_SxmDataSrvState::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmDataSrvState::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmDataSrvState::operator==(const midw_ext_fi_tcl_SxmDataSrvState& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SxmDataServiceType::midw_ext_fi_tcl_e8_SxmDataServiceType():enType(FI_EN_CHANNELART) {}

tS32 midw_ext_fi_tcl_e8_SxmDataServiceType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SXMDATASERVICETYPE;
}


midw_ext_fi_tcl_e8_SxmDataServiceType::~midw_ext_fi_tcl_e8_SxmDataServiceType()
{}

tU32 midw_ext_fi_tcl_e8_SxmDataServiceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SxmDataServiceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SxmDataServiceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmListElemDataSrvState::midw_ext_fi_tcl_SxmListElemDataSrvState(const midw_ext_fi_tcl_SxmListElemDataSrvState& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Type = coRef.Type;
   Status = coRef.Status;
}
midw_ext_fi_tcl_SxmListElemDataSrvState& midw_ext_fi_tcl_SxmListElemDataSrvState::operator=(const midw_ext_fi_tcl_SxmListElemDataSrvState& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SxmListElemDataSrvState::midw_ext_fi_tcl_SxmListElemDataSrvState()
:Type()
,Status()
 {}

tS32 midw_ext_fi_tcl_SxmListElemDataSrvState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMLISTELEMDATASRVSTATE;
}


midw_ext_fi_tcl_SxmListElemDataSrvState::~midw_ext_fi_tcl_SxmListElemDataSrvState()
{}

tU32 midw_ext_fi_tcl_SxmListElemDataSrvState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_SxmListElemDataSrvState::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Type);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmListElemDataSrvState::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Type);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmListElemDataSrvState::operator==(const midw_ext_fi_tcl_SxmListElemDataSrvState& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Type == roRef.Type);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_RGBAcolor::midw_ext_fi_tcl_RGBAcolor(const midw_ext_fi_tcl_RGBAcolor& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Red = coRef.Red;
   Green = coRef.Green;
   Blue = coRef.Blue;
   Alpha = coRef.Alpha;
}
midw_ext_fi_tcl_RGBAcolor& midw_ext_fi_tcl_RGBAcolor::operator=(const midw_ext_fi_tcl_RGBAcolor& coRef)
{
   if (this == &coRef) return *this;
   Red = coRef.Red;
   Green = coRef.Green;
   Blue = coRef.Blue;
   Alpha = coRef.Alpha;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_RGBAcolor::midw_ext_fi_tcl_RGBAcolor()
:Red(0)
,Green(0)
,Blue(0)
,Alpha(0)
 {}

tS32 midw_ext_fi_tcl_RGBAcolor::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_RGBACOLOR;
}


midw_ext_fi_tcl_RGBAcolor::~midw_ext_fi_tcl_RGBAcolor()
{}

tU32 midw_ext_fi_tcl_RGBAcolor::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_RGBAcolor::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Red);
   (tVoid) (oIn >> Green);
   (tVoid) (oIn >> Blue);
   (tVoid) (oIn >> Alpha);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_RGBAcolor::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Red);
   (tVoid) (oOut << Green);
   (tVoid) (oOut << Blue);
   (tVoid) (oOut << Alpha);
   return oOut;
}

tBool midw_ext_fi_tcl_RGBAcolor::operator==(const midw_ext_fi_tcl_RGBAcolor& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Red == roRef.Red);
   bResult = bResult && (Green == roRef.Green);
   bResult = bResult && (Blue == roRef.Blue);
   bResult = bResult && (Alpha == roRef.Alpha);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Graphics::midw_ext_fi_tcl_e8_Graphics():enType(FI_EN_GRAPHICS_NEEDS_NOREFRESH) {}

tS32 midw_ext_fi_tcl_e8_Graphics::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_GRAPHICS;
}


midw_ext_fi_tcl_e8_Graphics::~midw_ext_fi_tcl_e8_Graphics()
{}

tU32 midw_ext_fi_tcl_e8_Graphics::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Graphics::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Graphics::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_ChannelSkipType::midw_ext_fi_tcl_e8_ChannelSkipType():enType(FI_EN_SKIP_ALL) {}

tS32 midw_ext_fi_tcl_e8_ChannelSkipType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_CHANNELSKIPTYPE;
}


midw_ext_fi_tcl_e8_ChannelSkipType::~midw_ext_fi_tcl_e8_ChannelSkipType()
{}

tU32 midw_ext_fi_tcl_e8_ChannelSkipType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_ChannelSkipType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_ChannelSkipType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_ChannelListEntry::midw_ext_fi_tcl_ChannelListEntry(const midw_ext_fi_tcl_ChannelListEntry& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
   ChannelNameAvail = coRef.ChannelNameAvail;
   ChannelName = coRef.ChannelName;
   ChannelArtistName = coRef.ChannelArtistName;
   ChannelSongName = coRef.ChannelSongName;
   PresetNumber = coRef.PresetNumber;
   IsLocked = coRef.IsLocked;
   IsAvailable = coRef.IsAvailable;
   IsMature = coRef.IsMature;
   IsSkipped = coRef.IsSkipped;
   ChannelGraphicAvail = coRef.ChannelGraphicAvail;
}
midw_ext_fi_tcl_ChannelListEntry& midw_ext_fi_tcl_ChannelListEntry::operator=(const midw_ext_fi_tcl_ChannelListEntry& coRef)
{
   if (this == &coRef) return *this;
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
   ChannelNameAvail = coRef.ChannelNameAvail;
   ChannelName = coRef.ChannelName;
   ChannelArtistName = coRef.ChannelArtistName;
   ChannelSongName = coRef.ChannelSongName;
   PresetNumber = coRef.PresetNumber;
   IsLocked = coRef.IsLocked;
   IsAvailable = coRef.IsAvailable;
   IsMature = coRef.IsMature;
   IsSkipped = coRef.IsSkipped;
   ChannelGraphicAvail = coRef.ChannelGraphicAvail;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_ChannelListEntry::vDestroy()
{
   ChannelName.vDestroy();
   ChannelArtistName.vDestroy();
   ChannelSongName.vDestroy();
}

midw_ext_fi_tcl_ChannelListEntry::midw_ext_fi_tcl_ChannelListEntry()
:ServiceID(0)
,ChannelID(0)
,ChannelNameAvail(0)
,ChannelName()
,ChannelArtistName()
,ChannelSongName()
,PresetNumber(0)
,IsLocked(0)
,IsAvailable(0)
,IsMature(0)
,IsSkipped(0)
,ChannelGraphicAvail()
 {}

tS32 midw_ext_fi_tcl_ChannelListEntry::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_CHANNELLISTENTRY;
}


midw_ext_fi_tcl_ChannelListEntry::~midw_ext_fi_tcl_ChannelListEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_ChannelListEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 11+ChannelName.u32GetSize(u16MajorVersion)+ChannelArtistName.u32GetSize(u16MajorVersion)+ChannelSongName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_ChannelListEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceID);
   (tVoid) (oIn >> ChannelID);
   (tVoid) (oIn >> ChannelNameAvail);
   (tVoid) (oIn >> ChannelName);
   (tVoid) (oIn >> ChannelArtistName);
   (tVoid) (oIn >> ChannelSongName);
   (tVoid) (oIn >> PresetNumber);
   (tVoid) (oIn >> IsLocked);
   (tVoid) (oIn >> IsAvailable);
   (tVoid) (oIn >> IsMature);
   (tVoid) (oIn >> IsSkipped);
   (tVoid) (oIn >> ChannelGraphicAvail);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_ChannelListEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceID);
   (tVoid) (oOut << ChannelID);
   (tVoid) (oOut << ChannelNameAvail);
   (tVoid) (oOut << ChannelName);
   (tVoid) (oOut << ChannelArtistName);
   (tVoid) (oOut << ChannelSongName);
   (tVoid) (oOut << PresetNumber);
   (tVoid) (oOut << IsLocked);
   (tVoid) (oOut << IsAvailable);
   (tVoid) (oOut << IsMature);
   (tVoid) (oOut << IsSkipped);
   (tVoid) (oOut << ChannelGraphicAvail);
   return oOut;
}

tBool midw_ext_fi_tcl_ChannelListEntry::operator==(const midw_ext_fi_tcl_ChannelListEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceID == roRef.ServiceID);
   bResult = bResult && (ChannelID == roRef.ChannelID);
   bResult = bResult && (ChannelNameAvail == roRef.ChannelNameAvail);
   bResult = bResult && (ChannelName == roRef.ChannelName);
   bResult = bResult && (ChannelArtistName == roRef.ChannelArtistName);
   bResult = bResult && (ChannelSongName == roRef.ChannelSongName);
   bResult = bResult && (PresetNumber == roRef.PresetNumber);
   bResult = bResult && (IsLocked == roRef.IsLocked);
   bResult = bResult && (IsAvailable == roRef.IsAvailable);
   bResult = bResult && (IsMature == roRef.IsMature);
   bResult = bResult && (IsSkipped == roRef.IsSkipped);
   bResult = bResult && (ChannelGraphicAvail == roRef.ChannelGraphicAvail);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_MethodStatus::midw_ext_fi_tcl_e8_MethodStatus():enType(FI_EN_XMTUN_MS_FAILURE) {}

tS32 midw_ext_fi_tcl_e8_MethodStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_METHODSTATUS;
}


midw_ext_fi_tcl_e8_MethodStatus::~midw_ext_fi_tcl_e8_MethodStatus()
{}

tU32 midw_ext_fi_tcl_e8_MethodStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_MethodStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_MethodStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_ErrorTypes::midw_ext_fi_tcl_e8_ErrorTypes():enType(FI_EN_XMTUN_INVALID_OPCODE) {}

tS32 midw_ext_fi_tcl_e8_ErrorTypes::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_ERRORTYPES;
}


midw_ext_fi_tcl_e8_ErrorTypes::~midw_ext_fi_tcl_e8_ErrorTypes()
{}

tU32 midw_ext_fi_tcl_e8_ErrorTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_ErrorTypes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_ErrorTypes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_ChannelList::midw_ext_fi_tcl_ChannelList(const midw_ext_fi_tcl_ChannelList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ChannelList = coRef.ChannelList;
}
midw_ext_fi_tcl_ChannelList& midw_ext_fi_tcl_ChannelList::operator=(const midw_ext_fi_tcl_ChannelList& coRef)
{
   if (this == &coRef) return *this;
   ChannelList = coRef.ChannelList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_ChannelList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
         ChannelList[u32Idx].vDestroy();
   ChannelList.clear();
   }
}

midw_ext_fi_tcl_ChannelList::midw_ext_fi_tcl_ChannelList()

 {}

tS32 midw_ext_fi_tcl_ChannelList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_CHANNELLIST;
}


midw_ext_fi_tcl_ChannelList::~midw_ext_fi_tcl_ChannelList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_ChannelList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ChannelList.size(); ++u32ListIdx)
      u32DynamicSize += ChannelList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_ChannelList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
      {
         ChannelList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_ChannelList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ChannelList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
         (tVoid) (oOut << ChannelList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_ChannelList::operator==(const midw_ext_fi_tcl_ChannelList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ChannelList.size() == roRef.ChannelList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelList.size()); ++u32Idx)
            bResult = bResult && (ChannelList[u32Idx] == roRef.ChannelList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PresetListEntry::midw_ext_fi_tcl_PresetListEntry(const midw_ext_fi_tcl_PresetListEntry& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
   ChannelNameAvail = coRef.ChannelNameAvail;
   ChannelName = coRef.ChannelName;
   ChannelActive = coRef.ChannelActive;
   ChnGraphicAvail = coRef.ChnGraphicAvail;
   IsSmartFavorite = coRef.IsSmartFavorite;
   IsLocked = coRef.IsLocked;
   IsAvailable = coRef.IsAvailable;
   IsMature = coRef.IsMature;
   IsSkipped = coRef.IsSkipped;
}
midw_ext_fi_tcl_PresetListEntry& midw_ext_fi_tcl_PresetListEntry::operator=(const midw_ext_fi_tcl_PresetListEntry& coRef)
{
   if (this == &coRef) return *this;
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
   ChannelNameAvail = coRef.ChannelNameAvail;
   ChannelName = coRef.ChannelName;
   ChannelActive = coRef.ChannelActive;
   ChnGraphicAvail = coRef.ChnGraphicAvail;
   IsSmartFavorite = coRef.IsSmartFavorite;
   IsLocked = coRef.IsLocked;
   IsAvailable = coRef.IsAvailable;
   IsMature = coRef.IsMature;
   IsSkipped = coRef.IsSkipped;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PresetListEntry::vDestroy()
{
   ChannelName.vDestroy();
}

midw_ext_fi_tcl_PresetListEntry::midw_ext_fi_tcl_PresetListEntry()
:ServiceID(0)
,ChannelID(0)
,ChannelNameAvail(0)
,ChannelName()
,ChannelActive(0)
,ChnGraphicAvail()
,IsSmartFavorite(0)
,IsLocked(0)
,IsAvailable(0)
,IsMature(0)
,IsSkipped(0)
 {}

tS32 midw_ext_fi_tcl_PresetListEntry::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PRESETLISTENTRY;
}


midw_ext_fi_tcl_PresetListEntry::~midw_ext_fi_tcl_PresetListEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PresetListEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+ChannelName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_PresetListEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceID);
   (tVoid) (oIn >> ChannelID);
   (tVoid) (oIn >> ChannelNameAvail);
   (tVoid) (oIn >> ChannelName);
   (tVoid) (oIn >> ChannelActive);
   (tVoid) (oIn >> ChnGraphicAvail);
   (tVoid) (oIn >> IsSmartFavorite);
   (tVoid) (oIn >> IsLocked);
   (tVoid) (oIn >> IsAvailable);
   (tVoid) (oIn >> IsMature);
   (tVoid) (oIn >> IsSkipped);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PresetListEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceID);
   (tVoid) (oOut << ChannelID);
   (tVoid) (oOut << ChannelNameAvail);
   (tVoid) (oOut << ChannelName);
   (tVoid) (oOut << ChannelActive);
   (tVoid) (oOut << ChnGraphicAvail);
   (tVoid) (oOut << IsSmartFavorite);
   (tVoid) (oOut << IsLocked);
   (tVoid) (oOut << IsAvailable);
   (tVoid) (oOut << IsMature);
   (tVoid) (oOut << IsSkipped);
   return oOut;
}

tBool midw_ext_fi_tcl_PresetListEntry::operator==(const midw_ext_fi_tcl_PresetListEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceID == roRef.ServiceID);
   bResult = bResult && (ChannelID == roRef.ChannelID);
   bResult = bResult && (ChannelNameAvail == roRef.ChannelNameAvail);
   bResult = bResult && (ChannelName == roRef.ChannelName);
   bResult = bResult && (ChannelActive == roRef.ChannelActive);
   bResult = bResult && (ChnGraphicAvail == roRef.ChnGraphicAvail);
   bResult = bResult && (IsSmartFavorite == roRef.IsSmartFavorite);
   bResult = bResult && (IsLocked == roRef.IsLocked);
   bResult = bResult && (IsAvailable == roRef.IsAvailable);
   bResult = bResult && (IsMature == roRef.IsMature);
   bResult = bResult && (IsSkipped == roRef.IsSkipped);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_CategoryListEntry::midw_ext_fi_tcl_CategoryListEntry(const midw_ext_fi_tcl_CategoryListEntry& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   CategoryType = coRef.CategoryType;
   CategoryNameAvail = coRef.CategoryNameAvail;
   CategoryName = coRef.CategoryName;
   ChannelList = coRef.ChannelList;
}
midw_ext_fi_tcl_CategoryListEntry& midw_ext_fi_tcl_CategoryListEntry::operator=(const midw_ext_fi_tcl_CategoryListEntry& coRef)
{
   if (this == &coRef) return *this;
   CategoryType = coRef.CategoryType;
   CategoryNameAvail = coRef.CategoryNameAvail;
   CategoryName = coRef.CategoryName;
   ChannelList = coRef.ChannelList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_CategoryListEntry::vDestroy()
{
   CategoryName.vDestroy();
   ChannelList.vDestroy(); 
}

midw_ext_fi_tcl_CategoryListEntry::midw_ext_fi_tcl_CategoryListEntry()
:CategoryType(0)
,CategoryNameAvail(0)
,CategoryName()
,ChannelList()
 {}

tS32 midw_ext_fi_tcl_CategoryListEntry::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_CATEGORYLISTENTRY;
}


midw_ext_fi_tcl_CategoryListEntry::~midw_ext_fi_tcl_CategoryListEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_CategoryListEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+CategoryName.u32GetSize(u16MajorVersion)+ChannelList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_CategoryListEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CategoryType);
   (tVoid) (oIn >> CategoryNameAvail);
   (tVoid) (oIn >> CategoryName);
   (tVoid) (oIn >> ChannelList);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_CategoryListEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CategoryType);
   (tVoid) (oOut << CategoryNameAvail);
   (tVoid) (oOut << CategoryName);
   (tVoid) (oOut << ChannelList);
   return oOut;
}

tBool midw_ext_fi_tcl_CategoryListEntry::operator==(const midw_ext_fi_tcl_CategoryListEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CategoryType == roRef.CategoryType);
   bResult = bResult && (CategoryNameAvail == roRef.CategoryNameAvail);
   bResult = bResult && (CategoryName == roRef.CategoryName);
   bResult = bResult && (ChannelList == roRef.ChannelList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SelectChannelMode::midw_ext_fi_tcl_e8_SelectChannelMode():enType(FI_EN_XMTUN_SELECT_SID) {}

tS32 midw_ext_fi_tcl_e8_SelectChannelMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SELECTCHANNELMODE;
}


midw_ext_fi_tcl_e8_SelectChannelMode::~midw_ext_fi_tcl_e8_SelectChannelMode()
{}

tU32 midw_ext_fi_tcl_e8_SelectChannelMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SelectChannelMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SelectChannelMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PresetChannelList::midw_ext_fi_tcl_PresetChannelList(const midw_ext_fi_tcl_PresetChannelList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ChannelList = coRef.ChannelList;
}
midw_ext_fi_tcl_PresetChannelList& midw_ext_fi_tcl_PresetChannelList::operator=(const midw_ext_fi_tcl_PresetChannelList& coRef)
{
   if (this == &coRef) return *this;
   ChannelList = coRef.ChannelList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_PresetChannelList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
         ChannelList[u32Idx].vDestroy();
   ChannelList.clear();
   }
}

midw_ext_fi_tcl_PresetChannelList::midw_ext_fi_tcl_PresetChannelList()

 {}

tS32 midw_ext_fi_tcl_PresetChannelList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PRESETCHANNELLIST;
}


midw_ext_fi_tcl_PresetChannelList::~midw_ext_fi_tcl_PresetChannelList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_PresetChannelList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ChannelList.size(); ++u32ListIdx)
      u32DynamicSize += ChannelList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_PresetChannelList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
      {
         ChannelList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PresetChannelList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ChannelList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
         (tVoid) (oOut << ChannelList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_PresetChannelList::operator==(const midw_ext_fi_tcl_PresetChannelList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ChannelList.size() == roRef.ChannelList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelList.size()); ++u32Idx)
            bResult = bResult && (ChannelList[u32Idx] == roRef.ChannelList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_ChannelInformation::midw_ext_fi_tcl_ChannelInformation(const midw_ext_fi_tcl_ChannelInformation& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ChannelNumber = coRef.ChannelNumber;
   SID = coRef.SID;
   ChannelNameAvail = coRef.ChannelNameAvail;
   ChannelName = coRef.ChannelName;
   CategoryType = coRef.CategoryType;
   PrimaryCategoryType = coRef.PrimaryCategoryType;
   CategoryNameAvail = coRef.CategoryNameAvail;
   CategoryName = coRef.CategoryName;
   ArtistSongnameAvail = coRef.ArtistSongnameAvail;
   ArtistNameAvail = coRef.ArtistNameAvail;
   ArtistName = coRef.ArtistName;
   SongNameAvail = coRef.SongNameAvail;
   SongName = coRef.SongName;
   ExtSongNameAvail = coRef.ExtSongNameAvail;
   ExtSongName = coRef.ExtSongName;
   ExtArtistNameAvail = coRef.ExtArtistNameAvail;
   ExtArtistName = coRef.ExtArtistName;
   ChnGraphicAvail = coRef.ChnGraphicAvail;
   ChnArtAvail = coRef.ChnArtAvail;
   AlbumArtAvail = coRef.AlbumArtAvail;
   IsLocked = coRef.IsLocked;
   IsAvailable = coRef.IsAvailable;
   IsMature = coRef.IsMature;
   IsSkipped = coRef.IsSkipped;
   ArtistAlertStatus = coRef.ArtistAlertStatus;
   SongAlertStatus = coRef.SongAlertStatus;
}
midw_ext_fi_tcl_ChannelInformation& midw_ext_fi_tcl_ChannelInformation::operator=(const midw_ext_fi_tcl_ChannelInformation& coRef)
{
   if (this == &coRef) return *this;
   ChannelNumber = coRef.ChannelNumber;
   SID = coRef.SID;
   ChannelNameAvail = coRef.ChannelNameAvail;
   ChannelName = coRef.ChannelName;
   CategoryType = coRef.CategoryType;
   PrimaryCategoryType = coRef.PrimaryCategoryType;
   CategoryNameAvail = coRef.CategoryNameAvail;
   CategoryName = coRef.CategoryName;
   ArtistSongnameAvail = coRef.ArtistSongnameAvail;
   ArtistNameAvail = coRef.ArtistNameAvail;
   ArtistName = coRef.ArtistName;
   SongNameAvail = coRef.SongNameAvail;
   SongName = coRef.SongName;
   ExtSongNameAvail = coRef.ExtSongNameAvail;
   ExtSongName = coRef.ExtSongName;
   ExtArtistNameAvail = coRef.ExtArtistNameAvail;
   ExtArtistName = coRef.ExtArtistName;
   ChnGraphicAvail = coRef.ChnGraphicAvail;
   ChnArtAvail = coRef.ChnArtAvail;
   AlbumArtAvail = coRef.AlbumArtAvail;
   IsLocked = coRef.IsLocked;
   IsAvailable = coRef.IsAvailable;
   IsMature = coRef.IsMature;
   IsSkipped = coRef.IsSkipped;
   ArtistAlertStatus = coRef.ArtistAlertStatus;
   SongAlertStatus = coRef.SongAlertStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_ChannelInformation::vDestroy()
{
   ChannelName.vDestroy();
   CategoryName.vDestroy();
   ArtistName.vDestroy();
   SongName.vDestroy();
   ExtSongName.vDestroy();
   ExtArtistName.vDestroy();
}

midw_ext_fi_tcl_ChannelInformation::midw_ext_fi_tcl_ChannelInformation()
:ChannelNumber(0)
,SID(0)
,ChannelNameAvail(0)
,ChannelName()
,CategoryType(0)
,PrimaryCategoryType(0)
,CategoryNameAvail(0)
,CategoryName()
,ArtistSongnameAvail(0)
,ArtistNameAvail(0)
,ArtistName()
,SongNameAvail(0)
,SongName()
,ExtSongNameAvail(0)
,ExtSongName()
,ExtArtistNameAvail(0)
,ExtArtistName()
,ChnGraphicAvail(0)
,ChnArtAvail()
,AlbumArtAvail()
,IsLocked(0)
,IsAvailable(0)
,IsMature(0)
,IsSkipped(0)
,ArtistAlertStatus(0)
,SongAlertStatus(0)
 {}

tS32 midw_ext_fi_tcl_ChannelInformation::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_CHANNELINFORMATION;
}


midw_ext_fi_tcl_ChannelInformation::~midw_ext_fi_tcl_ChannelInformation()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_ChannelInformation::u32GetSize(tU16 u16MajorVersion) const
{
   return 24+ChannelName.u32GetSize(u16MajorVersion)+CategoryName.u32GetSize(u16MajorVersion)+ArtistName.u32GetSize(u16MajorVersion)+SongName.u32GetSize(u16MajorVersion)+ExtSongName.u32GetSize(u16MajorVersion)+ExtArtistName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_ChannelInformation::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelNumber);
   (tVoid) (oIn >> SID);
   (tVoid) (oIn >> ChannelNameAvail);
   (tVoid) (oIn >> ChannelName);
   (tVoid) (oIn >> CategoryType);
   (tVoid) (oIn >> PrimaryCategoryType);
   (tVoid) (oIn >> CategoryNameAvail);
   (tVoid) (oIn >> CategoryName);
   (tVoid) (oIn >> ArtistSongnameAvail);
   (tVoid) (oIn >> ArtistNameAvail);
   (tVoid) (oIn >> ArtistName);
   (tVoid) (oIn >> SongNameAvail);
   (tVoid) (oIn >> SongName);
   (tVoid) (oIn >> ExtSongNameAvail);
   (tVoid) (oIn >> ExtSongName);
   (tVoid) (oIn >> ExtArtistNameAvail);
   (tVoid) (oIn >> ExtArtistName);
   (tVoid) (oIn >> ChnGraphicAvail);
   (tVoid) (oIn >> ChnArtAvail);
   (tVoid) (oIn >> AlbumArtAvail);
   (tVoid) (oIn >> IsLocked);
   (tVoid) (oIn >> IsAvailable);
   (tVoid) (oIn >> IsMature);
   (tVoid) (oIn >> IsSkipped);
   (tVoid) (oIn >> ArtistAlertStatus);
   (tVoid) (oIn >> SongAlertStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_ChannelInformation::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelNumber);
   (tVoid) (oOut << SID);
   (tVoid) (oOut << ChannelNameAvail);
   (tVoid) (oOut << ChannelName);
   (tVoid) (oOut << CategoryType);
   (tVoid) (oOut << PrimaryCategoryType);
   (tVoid) (oOut << CategoryNameAvail);
   (tVoid) (oOut << CategoryName);
   (tVoid) (oOut << ArtistSongnameAvail);
   (tVoid) (oOut << ArtistNameAvail);
   (tVoid) (oOut << ArtistName);
   (tVoid) (oOut << SongNameAvail);
   (tVoid) (oOut << SongName);
   (tVoid) (oOut << ExtSongNameAvail);
   (tVoid) (oOut << ExtSongName);
   (tVoid) (oOut << ExtArtistNameAvail);
   (tVoid) (oOut << ExtArtistName);
   (tVoid) (oOut << ChnGraphicAvail);
   (tVoid) (oOut << ChnArtAvail);
   (tVoid) (oOut << AlbumArtAvail);
   (tVoid) (oOut << IsLocked);
   (tVoid) (oOut << IsAvailable);
   (tVoid) (oOut << IsMature);
   (tVoid) (oOut << IsSkipped);
   (tVoid) (oOut << ArtistAlertStatus);
   (tVoid) (oOut << SongAlertStatus);
   return oOut;
}

tBool midw_ext_fi_tcl_ChannelInformation::operator==(const midw_ext_fi_tcl_ChannelInformation& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelNumber == roRef.ChannelNumber);
   bResult = bResult && (SID == roRef.SID);
   bResult = bResult && (ChannelNameAvail == roRef.ChannelNameAvail);
   bResult = bResult && (ChannelName == roRef.ChannelName);
   bResult = bResult && (CategoryType == roRef.CategoryType);
   bResult = bResult && (PrimaryCategoryType == roRef.PrimaryCategoryType);
   bResult = bResult && (CategoryNameAvail == roRef.CategoryNameAvail);
   bResult = bResult && (CategoryName == roRef.CategoryName);
   bResult = bResult && (ArtistSongnameAvail == roRef.ArtistSongnameAvail);
   bResult = bResult && (ArtistNameAvail == roRef.ArtistNameAvail);
   bResult = bResult && (ArtistName == roRef.ArtistName);
   bResult = bResult && (SongNameAvail == roRef.SongNameAvail);
   bResult = bResult && (SongName == roRef.SongName);
   bResult = bResult && (ExtSongNameAvail == roRef.ExtSongNameAvail);
   bResult = bResult && (ExtSongName == roRef.ExtSongName);
   bResult = bResult && (ExtArtistNameAvail == roRef.ExtArtistNameAvail);
   bResult = bResult && (ExtArtistName == roRef.ExtArtistName);
   bResult = bResult && (ChnGraphicAvail == roRef.ChnGraphicAvail);
   bResult = bResult && (ChnArtAvail == roRef.ChnArtAvail);
   bResult = bResult && (AlbumArtAvail == roRef.AlbumArtAvail);
   bResult = bResult && (IsLocked == roRef.IsLocked);
   bResult = bResult && (IsAvailable == roRef.IsAvailable);
   bResult = bResult && (IsMature == roRef.IsMature);
   bResult = bResult && (IsSkipped == roRef.IsSkipped);
   bResult = bResult && (ArtistAlertStatus == roRef.ArtistAlertStatus);
   bResult = bResult && (SongAlertStatus == roRef.SongAlertStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SportsFlash_Sport::midw_ext_fi_tcl_e8_SportsFlash_Sport():enType(FI_EN_SPORTS_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_SportsFlash_Sport::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SPORTSFLASH_SPORT;
}


midw_ext_fi_tcl_e8_SportsFlash_Sport::~midw_ext_fi_tcl_e8_SportsFlash_Sport()
{}

tU32 midw_ext_fi_tcl_e8_SportsFlash_Sport::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SportsFlash_Sport::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SportsFlash_Sport::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SportsFlash_League::midw_ext_fi_tcl_e8_SportsFlash_League():enType(FI_EN_LEAGUE_NFL) {}

tS32 midw_ext_fi_tcl_e8_SportsFlash_League::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SPORTSFLASH_LEAGUE;
}


midw_ext_fi_tcl_e8_SportsFlash_League::~midw_ext_fi_tcl_e8_SportsFlash_League()
{}

tU32 midw_ext_fi_tcl_e8_SportsFlash_League::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SportsFlash_League::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SportsFlash_League::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus::midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus():enType(FI_EN_PROGRAM_AVAILABLE) {}

tS32 midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SPORTSFLASH_PROGRAMSTATUS;
}


midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus::~midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus()
{}

tU32 midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus::midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus():enType(FI_EN_SPORTS_FLASH_EVENT_OCCURED) {}

tS32 midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SPORTSFLASH_FLASHEVENTSTATUS;
}


midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus::~midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus()
{}

tU32 midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SystemMessage::midw_ext_fi_tcl_e8_SystemMessage():enType(FI_EN_XMTUN_SYSTEM_MSG_NO_ERROR) {}

tS32 midw_ext_fi_tcl_e8_SystemMessage::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SYSTEMMESSAGE;
}


midw_ext_fi_tcl_e8_SystemMessage::~midw_ext_fi_tcl_e8_SystemMessage()
{}

tU32 midw_ext_fi_tcl_e8_SystemMessage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SystemMessage::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SystemMessage::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Sxm_AntennaState::midw_ext_fi_tcl_e8_Sxm_AntennaState():enType(FI_EN_FC_SXM_DIAG_ANT_UNSUPPORTED) {}

tS32 midw_ext_fi_tcl_e8_Sxm_AntennaState::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SXM_ANTENNASTATE;
}


midw_ext_fi_tcl_e8_Sxm_AntennaState::~midw_ext_fi_tcl_e8_Sxm_AntennaState()
{}

tU32 midw_ext_fi_tcl_e8_Sxm_AntennaState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Sxm_AntennaState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Sxm_AntennaState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Sxm_SignalQuality::midw_ext_fi_tcl_e8_Sxm_SignalQuality():enType(FI_EN_FC_SXM_DIAG_SQ_NO_SIGNAL) {}

tS32 midw_ext_fi_tcl_e8_Sxm_SignalQuality::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SXM_SIGNALQUALITY;
}


midw_ext_fi_tcl_e8_Sxm_SignalQuality::~midw_ext_fi_tcl_e8_Sxm_SignalQuality()
{}

tU32 midw_ext_fi_tcl_e8_Sxm_SignalQuality::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Sxm_SignalQuality::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Sxm_SignalQuality::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmSignalQuality::midw_ext_fi_tcl_SxmSignalQuality(const midw_ext_fi_tcl_SxmSignalQuality& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   AntennaStatus = coRef.AntennaStatus;
   SignalQualityStatus = coRef.SignalQualityStatus;
}
midw_ext_fi_tcl_SxmSignalQuality& midw_ext_fi_tcl_SxmSignalQuality::operator=(const midw_ext_fi_tcl_SxmSignalQuality& coRef)
{
   if (this == &coRef) return *this;
   AntennaStatus = coRef.AntennaStatus;
   SignalQualityStatus = coRef.SignalQualityStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SxmSignalQuality::midw_ext_fi_tcl_SxmSignalQuality()
:AntennaStatus()
,SignalQualityStatus()
 {}

tS32 midw_ext_fi_tcl_SxmSignalQuality::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMSIGNALQUALITY;
}


midw_ext_fi_tcl_SxmSignalQuality::~midw_ext_fi_tcl_SxmSignalQuality()
{}

tU32 midw_ext_fi_tcl_SxmSignalQuality::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_SxmSignalQuality::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AntennaStatus);
   (tVoid) (oIn >> SignalQualityStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmSignalQuality::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AntennaStatus);
   (tVoid) (oOut << SignalQualityStatus);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmSignalQuality::operator==(const midw_ext_fi_tcl_SxmSignalQuality& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AntennaStatus == roRef.AntennaStatus);
   bResult = bResult && (SignalQualityStatus == roRef.SignalQualityStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmDetSignalQuality::midw_ext_fi_tcl_SxmDetSignalQuality(const midw_ext_fi_tcl_SxmDetSignalQuality& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   SigQuality = coRef.SigQuality;
   TunerStatus = coRef.TunerStatus;
   ENSALockStatus = coRef.ENSALockStatus;
   ENSBLockStatus = coRef.ENSBLockStatus;
   BerS1 = coRef.BerS1;
   BerS2 = coRef.BerS2;
   BerT = coRef.BerT;
   CtoNS1A = coRef.CtoNS1A;
   CtoNS1B = coRef.CtoNS1B;
   CtoNS2A = coRef.CtoNS2A;
   CtoNS2B = coRef.CtoNS2B;
   RSErrsWords = coRef.RSErrsWords;
   RSErrSatSymb = coRef.RSErrSatSymb;
   RSErrTerrSymb = coRef.RSErrTerrSymb;
   TunerCarrFreqOfset = coRef.TunerCarrFreqOfset;
   RSSI = coRef.RSSI;
}
midw_ext_fi_tcl_SxmDetSignalQuality& midw_ext_fi_tcl_SxmDetSignalQuality::operator=(const midw_ext_fi_tcl_SxmDetSignalQuality& coRef)
{
   if (this == &coRef) return *this;
   SigQuality = coRef.SigQuality;
   TunerStatus = coRef.TunerStatus;
   ENSALockStatus = coRef.ENSALockStatus;
   ENSBLockStatus = coRef.ENSBLockStatus;
   BerS1 = coRef.BerS1;
   BerS2 = coRef.BerS2;
   BerT = coRef.BerT;
   CtoNS1A = coRef.CtoNS1A;
   CtoNS1B = coRef.CtoNS1B;
   CtoNS2A = coRef.CtoNS2A;
   CtoNS2B = coRef.CtoNS2B;
   RSErrsWords = coRef.RSErrsWords;
   RSErrSatSymb = coRef.RSErrSatSymb;
   RSErrTerrSymb = coRef.RSErrTerrSymb;
   TunerCarrFreqOfset = coRef.TunerCarrFreqOfset;
   RSSI = coRef.RSSI;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SxmDetSignalQuality::vDestroy()
{
   SigQuality.vDestroy();
   TunerStatus.vDestroy();
   ENSALockStatus.vDestroy();
   ENSBLockStatus.vDestroy();
   BerS1.vDestroy();
   BerS2.vDestroy();
   BerT.vDestroy();
   CtoNS1A.vDestroy();
   CtoNS1B.vDestroy();
   CtoNS2A.vDestroy();
   CtoNS2B.vDestroy();
   RSErrsWords.vDestroy();
   RSErrSatSymb.vDestroy();
   RSErrTerrSymb.vDestroy();
   TunerCarrFreqOfset.vDestroy();
   RSSI.vDestroy();
}

midw_ext_fi_tcl_SxmDetSignalQuality::midw_ext_fi_tcl_SxmDetSignalQuality()
:SigQuality()
,TunerStatus()
,ENSALockStatus()
,ENSBLockStatus()
,BerS1()
,BerS2()
,BerT()
,CtoNS1A()
,CtoNS1B()
,CtoNS2A()
,CtoNS2B()
,RSErrsWords()
,RSErrSatSymb()
,RSErrTerrSymb()
,TunerCarrFreqOfset()
,RSSI()
 {}

tS32 midw_ext_fi_tcl_SxmDetSignalQuality::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMDETSIGNALQUALITY;
}


midw_ext_fi_tcl_SxmDetSignalQuality::~midw_ext_fi_tcl_SxmDetSignalQuality()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SxmDetSignalQuality::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+SigQuality.u32GetSize(u16MajorVersion)+TunerStatus.u32GetSize(u16MajorVersion)+ENSALockStatus.u32GetSize(u16MajorVersion)+ENSBLockStatus.u32GetSize(u16MajorVersion)+BerS1.u32GetSize(u16MajorVersion)+BerS2.u32GetSize(u16MajorVersion)+BerT.u32GetSize(u16MajorVersion)+CtoNS1A.u32GetSize(u16MajorVersion)+CtoNS1B.u32GetSize(u16MajorVersion)+CtoNS2A.u32GetSize(u16MajorVersion)+CtoNS2B.u32GetSize(u16MajorVersion)+RSErrsWords.u32GetSize(u16MajorVersion)+RSErrSatSymb.u32GetSize(u16MajorVersion)+RSErrTerrSymb.u32GetSize(u16MajorVersion)+TunerCarrFreqOfset.u32GetSize(u16MajorVersion)+RSSI.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_SxmDetSignalQuality::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SigQuality);
   (tVoid) (oIn >> TunerStatus);
   (tVoid) (oIn >> ENSALockStatus);
   (tVoid) (oIn >> ENSBLockStatus);
   (tVoid) (oIn >> BerS1);
   (tVoid) (oIn >> BerS2);
   (tVoid) (oIn >> BerT);
   (tVoid) (oIn >> CtoNS1A);
   (tVoid) (oIn >> CtoNS1B);
   (tVoid) (oIn >> CtoNS2A);
   (tVoid) (oIn >> CtoNS2B);
   (tVoid) (oIn >> RSErrsWords);
   (tVoid) (oIn >> RSErrSatSymb);
   (tVoid) (oIn >> RSErrTerrSymb);
   (tVoid) (oIn >> TunerCarrFreqOfset);
   (tVoid) (oIn >> RSSI);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmDetSignalQuality::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SigQuality);
   (tVoid) (oOut << TunerStatus);
   (tVoid) (oOut << ENSALockStatus);
   (tVoid) (oOut << ENSBLockStatus);
   (tVoid) (oOut << BerS1);
   (tVoid) (oOut << BerS2);
   (tVoid) (oOut << BerT);
   (tVoid) (oOut << CtoNS1A);
   (tVoid) (oOut << CtoNS1B);
   (tVoid) (oOut << CtoNS2A);
   (tVoid) (oOut << CtoNS2B);
   (tVoid) (oOut << RSErrsWords);
   (tVoid) (oOut << RSErrSatSymb);
   (tVoid) (oOut << RSErrTerrSymb);
   (tVoid) (oOut << TunerCarrFreqOfset);
   (tVoid) (oOut << RSSI);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmDetSignalQuality::operator==(const midw_ext_fi_tcl_SxmDetSignalQuality& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SigQuality == roRef.SigQuality);
   bResult = bResult && (TunerStatus == roRef.TunerStatus);
   bResult = bResult && (ENSALockStatus == roRef.ENSALockStatus);
   bResult = bResult && (ENSBLockStatus == roRef.ENSBLockStatus);
   bResult = bResult && (BerS1 == roRef.BerS1);
   bResult = bResult && (BerS2 == roRef.BerS2);
   bResult = bResult && (BerT == roRef.BerT);
   bResult = bResult && (CtoNS1A == roRef.CtoNS1A);
   bResult = bResult && (CtoNS1B == roRef.CtoNS1B);
   bResult = bResult && (CtoNS2A == roRef.CtoNS2A);
   bResult = bResult && (CtoNS2B == roRef.CtoNS2B);
   bResult = bResult && (RSErrsWords == roRef.RSErrsWords);
   bResult = bResult && (RSErrSatSymb == roRef.RSErrSatSymb);
   bResult = bResult && (RSErrTerrSymb == roRef.RSErrTerrSymb);
   bResult = bResult && (TunerCarrFreqOfset == roRef.TunerCarrFreqOfset);
   bResult = bResult && (RSSI == roRef.RSSI);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmDetOvrlSignalQuality::midw_ext_fi_tcl_SxmDetOvrlSignalQuality(const midw_ext_fi_tcl_SxmDetOvrlSignalQuality& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ReceiverState = coRef.ReceiverState;
   OBerS1A = coRef.OBerS1A;
   OBerS2A = coRef.OBerS2A;
   OBerTA = coRef.OBerTA;
   OBerS1B = coRef.OBerS1B;
   OBerS2B = coRef.OBerS2B;
   OBerTB = coRef.OBerTB;
   OBERTrbWrdErRt0A = coRef.OBERTrbWrdErRt0A;
   OBERTrbWrdErRt0B = coRef.OBERTrbWrdErRt0B;
   OBERTrbWrdErRt1A = coRef.OBERTrbWrdErRt1A;
   OBERTrbWrdErRt1B = coRef.OBERTrbWrdErRt1B;
   OBERTrbWrdErRt2A = coRef.OBERTrbWrdErRt2A;
   OBERTrbWrdErRt2B = coRef.OBERTrbWrdErRt2B;
}
midw_ext_fi_tcl_SxmDetOvrlSignalQuality& midw_ext_fi_tcl_SxmDetOvrlSignalQuality::operator=(const midw_ext_fi_tcl_SxmDetOvrlSignalQuality& coRef)
{
   if (this == &coRef) return *this;
   ReceiverState = coRef.ReceiverState;
   OBerS1A = coRef.OBerS1A;
   OBerS2A = coRef.OBerS2A;
   OBerTA = coRef.OBerTA;
   OBerS1B = coRef.OBerS1B;
   OBerS2B = coRef.OBerS2B;
   OBerTB = coRef.OBerTB;
   OBERTrbWrdErRt0A = coRef.OBERTrbWrdErRt0A;
   OBERTrbWrdErRt0B = coRef.OBERTrbWrdErRt0B;
   OBERTrbWrdErRt1A = coRef.OBERTrbWrdErRt1A;
   OBERTrbWrdErRt1B = coRef.OBERTrbWrdErRt1B;
   OBERTrbWrdErRt2A = coRef.OBERTrbWrdErRt2A;
   OBERTrbWrdErRt2B = coRef.OBERTrbWrdErRt2B;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SxmDetOvrlSignalQuality::vDestroy()
{
   ReceiverState.vDestroy();
   OBerS1A.vDestroy();
   OBerS2A.vDestroy();
   OBerTA.vDestroy();
   OBerS1B.vDestroy();
   OBerS2B.vDestroy();
   OBerTB.vDestroy();
   OBERTrbWrdErRt0A.vDestroy();
   OBERTrbWrdErRt0B.vDestroy();
   OBERTrbWrdErRt1A.vDestroy();
   OBERTrbWrdErRt1B.vDestroy();
   OBERTrbWrdErRt2A.vDestroy();
   OBERTrbWrdErRt2B.vDestroy();
}

midw_ext_fi_tcl_SxmDetOvrlSignalQuality::midw_ext_fi_tcl_SxmDetOvrlSignalQuality()
:ReceiverState()
,OBerS1A()
,OBerS2A()
,OBerTA()
,OBerS1B()
,OBerS2B()
,OBerTB()
,OBERTrbWrdErRt0A()
,OBERTrbWrdErRt0B()
,OBERTrbWrdErRt1A()
,OBERTrbWrdErRt1B()
,OBERTrbWrdErRt2A()
,OBERTrbWrdErRt2B()
 {}

tS32 midw_ext_fi_tcl_SxmDetOvrlSignalQuality::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMDETOVRLSIGNALQUALITY;
}


midw_ext_fi_tcl_SxmDetOvrlSignalQuality::~midw_ext_fi_tcl_SxmDetOvrlSignalQuality()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SxmDetOvrlSignalQuality::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ReceiverState.u32GetSize(u16MajorVersion)+OBerS1A.u32GetSize(u16MajorVersion)+OBerS2A.u32GetSize(u16MajorVersion)+OBerTA.u32GetSize(u16MajorVersion)+OBerS1B.u32GetSize(u16MajorVersion)+OBerS2B.u32GetSize(u16MajorVersion)+OBerTB.u32GetSize(u16MajorVersion)+OBERTrbWrdErRt0A.u32GetSize(u16MajorVersion)+OBERTrbWrdErRt0B.u32GetSize(u16MajorVersion)+OBERTrbWrdErRt1A.u32GetSize(u16MajorVersion)+OBERTrbWrdErRt1B.u32GetSize(u16MajorVersion)+OBERTrbWrdErRt2A.u32GetSize(u16MajorVersion)+OBERTrbWrdErRt2B.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_SxmDetOvrlSignalQuality::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ReceiverState);
   (tVoid) (oIn >> OBerS1A);
   (tVoid) (oIn >> OBerS2A);
   (tVoid) (oIn >> OBerTA);
   (tVoid) (oIn >> OBerS1B);
   (tVoid) (oIn >> OBerS2B);
   (tVoid) (oIn >> OBerTB);
   (tVoid) (oIn >> OBERTrbWrdErRt0A);
   (tVoid) (oIn >> OBERTrbWrdErRt0B);
   (tVoid) (oIn >> OBERTrbWrdErRt1A);
   (tVoid) (oIn >> OBERTrbWrdErRt1B);
   (tVoid) (oIn >> OBERTrbWrdErRt2A);
   (tVoid) (oIn >> OBERTrbWrdErRt2B);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmDetOvrlSignalQuality::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ReceiverState);
   (tVoid) (oOut << OBerS1A);
   (tVoid) (oOut << OBerS2A);
   (tVoid) (oOut << OBerTA);
   (tVoid) (oOut << OBerS1B);
   (tVoid) (oOut << OBerS2B);
   (tVoid) (oOut << OBerTB);
   (tVoid) (oOut << OBERTrbWrdErRt0A);
   (tVoid) (oOut << OBERTrbWrdErRt0B);
   (tVoid) (oOut << OBERTrbWrdErRt1A);
   (tVoid) (oOut << OBERTrbWrdErRt1B);
   (tVoid) (oOut << OBERTrbWrdErRt2A);
   (tVoid) (oOut << OBERTrbWrdErRt2B);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmDetOvrlSignalQuality::operator==(const midw_ext_fi_tcl_SxmDetOvrlSignalQuality& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ReceiverState == roRef.ReceiverState);
   bResult = bResult && (OBerS1A == roRef.OBerS1A);
   bResult = bResult && (OBerS2A == roRef.OBerS2A);
   bResult = bResult && (OBerTA == roRef.OBerTA);
   bResult = bResult && (OBerS1B == roRef.OBerS1B);
   bResult = bResult && (OBerS2B == roRef.OBerS2B);
   bResult = bResult && (OBerTB == roRef.OBerTB);
   bResult = bResult && (OBERTrbWrdErRt0A == roRef.OBERTrbWrdErRt0A);
   bResult = bResult && (OBERTrbWrdErRt0B == roRef.OBERTrbWrdErRt0B);
   bResult = bResult && (OBERTrbWrdErRt1A == roRef.OBERTrbWrdErRt1A);
   bResult = bResult && (OBERTrbWrdErRt1B == roRef.OBERTrbWrdErRt1B);
   bResult = bResult && (OBERTrbWrdErRt2A == roRef.OBERTrbWrdErRt2A);
   bResult = bResult && (OBERTrbWrdErRt2B == roRef.OBERTrbWrdErRt2B);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmVersionInfo::midw_ext_fi_tcl_SxmVersionInfo(const midw_ext_fi_tcl_SxmVersionInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ModuleId = coRef.ModuleId;
   HwRev = coRef.HwRev;
   SwRev = coRef.SwRev;
   SxiRev = coRef.SxiRev;
   BbRev = coRef.BbRev;
   HDecRev = coRef.HDecRev;
   RFRev = coRef.RFRev;
   Capability = coRef.Capability;
   SPLRev = coRef.SPLRev;
}
midw_ext_fi_tcl_SxmVersionInfo& midw_ext_fi_tcl_SxmVersionInfo::operator=(const midw_ext_fi_tcl_SxmVersionInfo& coRef)
{
   if (this == &coRef) return *this;
   ModuleId = coRef.ModuleId;
   HwRev = coRef.HwRev;
   SwRev = coRef.SwRev;
   SxiRev = coRef.SxiRev;
   BbRev = coRef.BbRev;
   HDecRev = coRef.HDecRev;
   RFRev = coRef.RFRev;
   Capability = coRef.Capability;
   SPLRev = coRef.SPLRev;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SxmVersionInfo::vDestroy()
{
   ModuleId.vDestroy();
   HwRev.vDestroy();
   SwRev.vDestroy();
   SxiRev.vDestroy();
   BbRev.vDestroy();
   HDecRev.vDestroy();
   RFRev.vDestroy();
   Capability.vDestroy();
   SPLRev.vDestroy();
}

midw_ext_fi_tcl_SxmVersionInfo::midw_ext_fi_tcl_SxmVersionInfo()
:ModuleId()
,HwRev()
,SwRev()
,SxiRev()
,BbRev()
,HDecRev()
,RFRev()
,Capability()
,SPLRev()
 {}

tS32 midw_ext_fi_tcl_SxmVersionInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMVERSIONINFO;
}


midw_ext_fi_tcl_SxmVersionInfo::~midw_ext_fi_tcl_SxmVersionInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SxmVersionInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ModuleId.u32GetSize(u16MajorVersion)+HwRev.u32GetSize(u16MajorVersion)+SwRev.u32GetSize(u16MajorVersion)+SxiRev.u32GetSize(u16MajorVersion)+BbRev.u32GetSize(u16MajorVersion)+HDecRev.u32GetSize(u16MajorVersion)+RFRev.u32GetSize(u16MajorVersion)+Capability.u32GetSize(u16MajorVersion)+SPLRev.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_SxmVersionInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ModuleId);
   (tVoid) (oIn >> HwRev);
   (tVoid) (oIn >> SwRev);
   (tVoid) (oIn >> SxiRev);
   (tVoid) (oIn >> BbRev);
   (tVoid) (oIn >> HDecRev);
   (tVoid) (oIn >> RFRev);
   (tVoid) (oIn >> Capability);
   (tVoid) (oIn >> SPLRev);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmVersionInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ModuleId);
   (tVoid) (oOut << HwRev);
   (tVoid) (oOut << SwRev);
   (tVoid) (oOut << SxiRev);
   (tVoid) (oOut << BbRev);
   (tVoid) (oOut << HDecRev);
   (tVoid) (oOut << RFRev);
   (tVoid) (oOut << Capability);
   (tVoid) (oOut << SPLRev);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmVersionInfo::operator==(const midw_ext_fi_tcl_SxmVersionInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ModuleId == roRef.ModuleId);
   bResult = bResult && (HwRev == roRef.HwRev);
   bResult = bResult && (SwRev == roRef.SwRev);
   bResult = bResult && (SxiRev == roRef.SxiRev);
   bResult = bResult && (BbRev == roRef.BbRev);
   bResult = bResult && (HDecRev == roRef.HDecRev);
   bResult = bResult && (RFRev == roRef.RFRev);
   bResult = bResult && (Capability == roRef.Capability);
   bResult = bResult && (SPLRev == roRef.SPLRev);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmDataSubStatus::midw_ext_fi_tcl_SxmDataSubStatus(const midw_ext_fi_tcl_SxmDataSubStatus& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   SubStatus = coRef.SubStatus;
   ReasonCode = coRef.ReasonCode;
   SuspendedDate = coRef.SuspendedDate;
}
midw_ext_fi_tcl_SxmDataSubStatus& midw_ext_fi_tcl_SxmDataSubStatus::operator=(const midw_ext_fi_tcl_SxmDataSubStatus& coRef)
{
   if (this == &coRef) return *this;
   SubStatus = coRef.SubStatus;
   ReasonCode = coRef.ReasonCode;
   SuspendedDate = coRef.SuspendedDate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SxmDataSubStatus::midw_ext_fi_tcl_SxmDataSubStatus()
:SubStatus(0)
,ReasonCode(0)
,SuspendedDate(0)
 {}

tS32 midw_ext_fi_tcl_SxmDataSubStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMDATASUBSTATUS;
}


midw_ext_fi_tcl_SxmDataSubStatus::~midw_ext_fi_tcl_SxmDataSubStatus()
{}

tU32 midw_ext_fi_tcl_SxmDataSubStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_fi_tcl_SxmDataSubStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SubStatus);
   (tVoid) (oIn >> ReasonCode);
   (tVoid) (oIn >> SuspendedDate);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmDataSubStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SubStatus);
   (tVoid) (oOut << ReasonCode);
   (tVoid) (oOut << SuspendedDate);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmDataSubStatus::operator==(const midw_ext_fi_tcl_SxmDataSubStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SubStatus == roRef.SubStatus);
   bResult = bResult && (ReasonCode == roRef.ReasonCode);
   bResult = bResult && (SuspendedDate == roRef.SuspendedDate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmDiagTestModeData::midw_ext_fi_tcl_SxmDiagTestModeData(const midw_ext_fi_tcl_SxmDiagTestModeData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   DetSignalQuality = coRef.DetSignalQuality;
   DetOvrlSignalQuality = coRef.DetOvrlSignalQuality;
   SxmVersionInfo = coRef.SxmVersionInfo;
   SxmSubscriptionState = coRef.SxmSubscriptionState;
}
midw_ext_fi_tcl_SxmDiagTestModeData& midw_ext_fi_tcl_SxmDiagTestModeData::operator=(const midw_ext_fi_tcl_SxmDiagTestModeData& coRef)
{
   if (this == &coRef) return *this;
   DetSignalQuality = coRef.DetSignalQuality;
   DetOvrlSignalQuality = coRef.DetOvrlSignalQuality;
   SxmVersionInfo = coRef.SxmVersionInfo;
   SxmSubscriptionState = coRef.SxmSubscriptionState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SxmDiagTestModeData::vDestroy()
{
   DetSignalQuality.vDestroy(); 
   DetOvrlSignalQuality.vDestroy(); 
   SxmVersionInfo.vDestroy(); 
   SxmSubscriptionState.vDestroy(); 
}

midw_ext_fi_tcl_SxmDiagTestModeData::midw_ext_fi_tcl_SxmDiagTestModeData()
:DetSignalQuality()
,DetOvrlSignalQuality()
,SxmVersionInfo()
,SxmSubscriptionState()
 {}

tS32 midw_ext_fi_tcl_SxmDiagTestModeData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMDIAGTESTMODEDATA;
}


midw_ext_fi_tcl_SxmDiagTestModeData::~midw_ext_fi_tcl_SxmDiagTestModeData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SxmDiagTestModeData::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+DetSignalQuality.u32GetSize(u16MajorVersion)+DetOvrlSignalQuality.u32GetSize(u16MajorVersion)+SxmVersionInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_SxmDiagTestModeData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DetSignalQuality);
   (tVoid) (oIn >> DetOvrlSignalQuality);
   (tVoid) (oIn >> SxmVersionInfo);
   (tVoid) (oIn >> SxmSubscriptionState);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmDiagTestModeData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DetSignalQuality);
   (tVoid) (oOut << DetOvrlSignalQuality);
   (tVoid) (oOut << SxmVersionInfo);
   (tVoid) (oOut << SxmSubscriptionState);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmDiagTestModeData::operator==(const midw_ext_fi_tcl_SxmDiagTestModeData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DetSignalQuality == roRef.DetSignalQuality);
   bResult = bResult && (DetOvrlSignalQuality == roRef.DetOvrlSignalQuality);
   bResult = bResult && (SxmVersionInfo == roRef.SxmVersionInfo);
   bResult = bResult && (SxmSubscriptionState == roRef.SxmSubscriptionState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmSmsDbInfo::midw_ext_fi_tcl_SxmSmsDbInfo(const midw_ext_fi_tcl_SxmSmsDbInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   CgsDb = coRef.CgsDb;
   FuelDb = coRef.FuelDb;
   MovieDb = coRef.MovieDb;
   TabWeatherDb = coRef.TabWeatherDb;
   StockDb = coRef.StockDb;
   WsAlertsDb = coRef.WsAlertsDb;
   SportsDB = coRef.SportsDB;
   ParkingDB = coRef.ParkingDB;
   PhoneticsDB = coRef.PhoneticsDB;
   FuelCanadaDB = coRef.FuelCanadaDB;
   SafeViewdb = coRef.SafeViewdb;
   SmsVersion = coRef.SmsVersion;
}
midw_ext_fi_tcl_SxmSmsDbInfo& midw_ext_fi_tcl_SxmSmsDbInfo::operator=(const midw_ext_fi_tcl_SxmSmsDbInfo& coRef)
{
   if (this == &coRef) return *this;
   CgsDb = coRef.CgsDb;
   FuelDb = coRef.FuelDb;
   MovieDb = coRef.MovieDb;
   TabWeatherDb = coRef.TabWeatherDb;
   StockDb = coRef.StockDb;
   WsAlertsDb = coRef.WsAlertsDb;
   SportsDB = coRef.SportsDB;
   ParkingDB = coRef.ParkingDB;
   PhoneticsDB = coRef.PhoneticsDB;
   FuelCanadaDB = coRef.FuelCanadaDB;
   SafeViewdb = coRef.SafeViewdb;
   SmsVersion = coRef.SmsVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SxmSmsDbInfo::vDestroy()
{
   CgsDb.vDestroy();
   FuelDb.vDestroy();
   MovieDb.vDestroy();
   TabWeatherDb.vDestroy();
   StockDb.vDestroy();
   WsAlertsDb.vDestroy();
   SportsDB.vDestroy();
   ParkingDB.vDestroy();
   PhoneticsDB.vDestroy();
   FuelCanadaDB.vDestroy();
   SafeViewdb.vDestroy();
   SmsVersion.vDestroy();
}

midw_ext_fi_tcl_SxmSmsDbInfo::midw_ext_fi_tcl_SxmSmsDbInfo()
:CgsDb()
,FuelDb()
,MovieDb()
,TabWeatherDb()
,StockDb()
,WsAlertsDb()
,SportsDB()
,ParkingDB()
,PhoneticsDB()
,FuelCanadaDB()
,SafeViewdb()
,SmsVersion()
 {}

tS32 midw_ext_fi_tcl_SxmSmsDbInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMSMSDBINFO;
}


midw_ext_fi_tcl_SxmSmsDbInfo::~midw_ext_fi_tcl_SxmSmsDbInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SxmSmsDbInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CgsDb.u32GetSize(u16MajorVersion)+FuelDb.u32GetSize(u16MajorVersion)+MovieDb.u32GetSize(u16MajorVersion)+TabWeatherDb.u32GetSize(u16MajorVersion)+StockDb.u32GetSize(u16MajorVersion)+WsAlertsDb.u32GetSize(u16MajorVersion)+SportsDB.u32GetSize(u16MajorVersion)+ParkingDB.u32GetSize(u16MajorVersion)+PhoneticsDB.u32GetSize(u16MajorVersion)+FuelCanadaDB.u32GetSize(u16MajorVersion)+SafeViewdb.u32GetSize(u16MajorVersion)+SmsVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_SxmSmsDbInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CgsDb);
   (tVoid) (oIn >> FuelDb);
   (tVoid) (oIn >> MovieDb);
   (tVoid) (oIn >> TabWeatherDb);
   (tVoid) (oIn >> StockDb);
   (tVoid) (oIn >> WsAlertsDb);
   (tVoid) (oIn >> SportsDB);
   (tVoid) (oIn >> ParkingDB);
   (tVoid) (oIn >> PhoneticsDB);
   (tVoid) (oIn >> FuelCanadaDB);
   (tVoid) (oIn >> SafeViewdb);
   (tVoid) (oIn >> SmsVersion);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmSmsDbInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CgsDb);
   (tVoid) (oOut << FuelDb);
   (tVoid) (oOut << MovieDb);
   (tVoid) (oOut << TabWeatherDb);
   (tVoid) (oOut << StockDb);
   (tVoid) (oOut << WsAlertsDb);
   (tVoid) (oOut << SportsDB);
   (tVoid) (oOut << ParkingDB);
   (tVoid) (oOut << PhoneticsDB);
   (tVoid) (oOut << FuelCanadaDB);
   (tVoid) (oOut << SafeViewdb);
   (tVoid) (oOut << SmsVersion);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmSmsDbInfo::operator==(const midw_ext_fi_tcl_SxmSmsDbInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CgsDb == roRef.CgsDb);
   bResult = bResult && (FuelDb == roRef.FuelDb);
   bResult = bResult && (MovieDb == roRef.MovieDb);
   bResult = bResult && (TabWeatherDb == roRef.TabWeatherDb);
   bResult = bResult && (StockDb == roRef.StockDb);
   bResult = bResult && (WsAlertsDb == roRef.WsAlertsDb);
   bResult = bResult && (SportsDB == roRef.SportsDB);
   bResult = bResult && (ParkingDB == roRef.ParkingDB);
   bResult = bResult && (PhoneticsDB == roRef.PhoneticsDB);
   bResult = bResult && (FuelCanadaDB == roRef.FuelCanadaDB);
   bResult = bResult && (SafeViewdb == roRef.SafeViewdb);
   bResult = bResult && (SmsVersion == roRef.SmsVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SxmAudioSubInfo::midw_ext_fi_tcl_SxmAudioSubInfo(const midw_ext_fi_tcl_SxmAudioSubInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   SubStatus = coRef.SubStatus;
}
midw_ext_fi_tcl_SxmAudioSubInfo& midw_ext_fi_tcl_SxmAudioSubInfo::operator=(const midw_ext_fi_tcl_SxmAudioSubInfo& coRef)
{
   if (this == &coRef) return *this;
   SubStatus = coRef.SubStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SxmAudioSubInfo::midw_ext_fi_tcl_SxmAudioSubInfo()
:SubStatus(0)
 {}

tS32 midw_ext_fi_tcl_SxmAudioSubInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SXMAUDIOSUBINFO;
}


midw_ext_fi_tcl_SxmAudioSubInfo::~midw_ext_fi_tcl_SxmAudioSubInfo()
{}

tU32 midw_ext_fi_tcl_SxmAudioSubInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_SxmAudioSubInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SubStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SxmAudioSubInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SubStatus);
   return oOut;
}

tBool midw_ext_fi_tcl_SxmAudioSubInfo::operator==(const midw_ext_fi_tcl_SxmAudioSubInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SubStatus == roRef.SubStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult():enType(FI_EN_NOERROR) {}

tS32 midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SXMFIRMWAREDOWNLOADRESULT;
}


midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::~midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult()
{}

tU32 midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SxmExtDiagMode::midw_ext_fi_tcl_e8_SxmExtDiagMode():enType(FI_EN_FC_SXM_EXTERNAL_DIAG_MODE_START) {}

tS32 midw_ext_fi_tcl_e8_SxmExtDiagMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SXMEXTDIAGMODE;
}


midw_ext_fi_tcl_e8_SxmExtDiagMode::~midw_ext_fi_tcl_e8_SxmExtDiagMode()
{}

tU32 midw_ext_fi_tcl_e8_SxmExtDiagMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SxmExtDiagMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SxmExtDiagMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SmartFavoritePreset::midw_ext_fi_tcl_SmartFavoritePreset(const midw_ext_fi_tcl_SmartFavoritePreset& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   PresetIndex = coRef.PresetIndex;
   IsSmartFavorite = coRef.IsSmartFavorite;
}
midw_ext_fi_tcl_SmartFavoritePreset& midw_ext_fi_tcl_SmartFavoritePreset::operator=(const midw_ext_fi_tcl_SmartFavoritePreset& coRef)
{
   if (this == &coRef) return *this;
   PresetIndex = coRef.PresetIndex;
   IsSmartFavorite = coRef.IsSmartFavorite;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SmartFavoritePreset::midw_ext_fi_tcl_SmartFavoritePreset()
:PresetIndex(0)
,IsSmartFavorite(0)
 {}

tS32 midw_ext_fi_tcl_SmartFavoritePreset::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SMARTFAVORITEPRESET;
}


midw_ext_fi_tcl_SmartFavoritePreset::~midw_ext_fi_tcl_SmartFavoritePreset()
{}

tU32 midw_ext_fi_tcl_SmartFavoritePreset::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_SmartFavoritePreset::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetIndex);
   (tVoid) (oIn >> IsSmartFavorite);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SmartFavoritePreset::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetIndex);
   (tVoid) (oOut << IsSmartFavorite);
   return oOut;
}

tBool midw_ext_fi_tcl_SmartFavoritePreset::operator==(const midw_ext_fi_tcl_SmartFavoritePreset& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetIndex == roRef.PresetIndex);
   bResult = bResult && (IsSmartFavorite == roRef.IsSmartFavorite);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SFListElement::midw_ext_fi_tcl_SFListElement(const midw_ext_fi_tcl_SFListElement& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   PresetIndex = coRef.PresetIndex;
   IsRepeated = coRef.IsRepeated;
}
midw_ext_fi_tcl_SFListElement& midw_ext_fi_tcl_SFListElement::operator=(const midw_ext_fi_tcl_SFListElement& coRef)
{
   if (this == &coRef) return *this;
   PresetIndex = coRef.PresetIndex;
   IsRepeated = coRef.IsRepeated;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SFListElement::midw_ext_fi_tcl_SFListElement()
:PresetIndex(0)
,IsRepeated(0)
 {}

tS32 midw_ext_fi_tcl_SFListElement::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SFLISTELEMENT;
}


midw_ext_fi_tcl_SFListElement::~midw_ext_fi_tcl_SFListElement()
{}

tU32 midw_ext_fi_tcl_SFListElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_SFListElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetIndex);
   (tVoid) (oIn >> IsRepeated);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SFListElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetIndex);
   (tVoid) (oOut << IsRepeated);
   return oOut;
}

tBool midw_ext_fi_tcl_SFListElement::operator==(const midw_ext_fi_tcl_SFListElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetIndex == roRef.PresetIndex);
   bResult = bResult && (IsRepeated == roRef.IsRepeated);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SFOperation::midw_ext_fi_tcl_e8_SFOperation():enType(FI_EN_SXM_AUDIO_GET_SF_LIST) {}

tS32 midw_ext_fi_tcl_e8_SFOperation::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SFOPERATION;
}


midw_ext_fi_tcl_e8_SFOperation::~midw_ext_fi_tcl_e8_SFOperation()
{}

tU32 midw_ext_fi_tcl_e8_SFOperation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SFOperation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SFOperation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_IRPlaybackMode::midw_ext_fi_tcl_e8_IRPlaybackMode():enType(FI_EN_SXM_AUDIO_IR_PLAY_MODE) {}

tS32 midw_ext_fi_tcl_e8_IRPlaybackMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_IRPLAYBACKMODE;
}


midw_ext_fi_tcl_e8_IRPlaybackMode::~midw_ext_fi_tcl_e8_IRPlaybackMode()
{}

tU32 midw_ext_fi_tcl_e8_IRPlaybackMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_IRPlaybackMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_IRPlaybackMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_IRPlaybackStatus::midw_ext_fi_tcl_e8_IRPlaybackStatus():enType(FI_EN_SXM_AUDIO_IR_PLAY_STATE) {}

tS32 midw_ext_fi_tcl_e8_IRPlaybackStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_IRPLAYBACKSTATUS;
}


midw_ext_fi_tcl_e8_IRPlaybackStatus::~midw_ext_fi_tcl_e8_IRPlaybackStatus()
{}

tU32 midw_ext_fi_tcl_e8_IRPlaybackStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_IRPlaybackStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_IRPlaybackStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_InstantReplayStatus::midw_ext_fi_tcl_InstantReplayStatus(const midw_ext_fi_tcl_InstantReplayStatus& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   RecordDuration = coRef.RecordDuration;
   TimeToLive = coRef.TimeToLive;
   PlayPercentage = coRef.PlayPercentage;
   FillPercentage = coRef.FillPercentage;
   ElapsedTime = coRef.ElapsedTime;
   PlaybackStatus = coRef.PlaybackStatus;
}
midw_ext_fi_tcl_InstantReplayStatus& midw_ext_fi_tcl_InstantReplayStatus::operator=(const midw_ext_fi_tcl_InstantReplayStatus& coRef)
{
   if (this == &coRef) return *this;
   RecordDuration = coRef.RecordDuration;
   TimeToLive = coRef.TimeToLive;
   PlayPercentage = coRef.PlayPercentage;
   FillPercentage = coRef.FillPercentage;
   ElapsedTime = coRef.ElapsedTime;
   PlaybackStatus = coRef.PlaybackStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_InstantReplayStatus::midw_ext_fi_tcl_InstantReplayStatus()
:RecordDuration(0)
,TimeToLive(0)
,PlayPercentage(0)
,FillPercentage(0)
,ElapsedTime(0)
,PlaybackStatus()
 {}

tS32 midw_ext_fi_tcl_InstantReplayStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_INSTANTREPLAYSTATUS;
}


midw_ext_fi_tcl_InstantReplayStatus::~midw_ext_fi_tcl_InstantReplayStatus()
{}

tU32 midw_ext_fi_tcl_InstantReplayStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& midw_ext_fi_tcl_InstantReplayStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecordDuration);
   (tVoid) (oIn >> TimeToLive);
   (tVoid) (oIn >> PlayPercentage);
   (tVoid) (oIn >> FillPercentage);
   (tVoid) (oIn >> ElapsedTime);
   (tVoid) (oIn >> PlaybackStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_InstantReplayStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecordDuration);
   (tVoid) (oOut << TimeToLive);
   (tVoid) (oOut << PlayPercentage);
   (tVoid) (oOut << FillPercentage);
   (tVoid) (oOut << ElapsedTime);
   (tVoid) (oOut << PlaybackStatus);
   return oOut;
}

tBool midw_ext_fi_tcl_InstantReplayStatus::operator==(const midw_ext_fi_tcl_InstantReplayStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecordDuration == roRef.RecordDuration);
   bResult = bResult && (TimeToLive == roRef.TimeToLive);
   bResult = bResult && (PlayPercentage == roRef.PlayPercentage);
   bResult = bResult && (FillPercentage == roRef.FillPercentage);
   bResult = bResult && (ElapsedTime == roRef.ElapsedTime);
   bResult = bResult && (PlaybackStatus == roRef.PlaybackStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TuneScanMode::midw_ext_fi_tcl_e8_TuneScanMode():enType(FI_EN_SXM_AUDIO_TUNE_SCAN_START_MODE) {}

tS32 midw_ext_fi_tcl_e8_TuneScanMode::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TUNESCANMODE;
}


midw_ext_fi_tcl_e8_TuneScanMode::~midw_ext_fi_tcl_e8_TuneScanMode()
{}

tU32 midw_ext_fi_tcl_e8_TuneScanMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TuneScanMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TuneScanMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_FavoriteType::midw_ext_fi_tcl_e8_FavoriteType():enType(FI_EN_FAVORITE_ARTIST) {}

tS32 midw_ext_fi_tcl_e8_FavoriteType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_FAVORITETYPE;
}


midw_ext_fi_tcl_e8_FavoriteType::~midw_ext_fi_tcl_e8_FavoriteType()
{}

tU32 midw_ext_fi_tcl_e8_FavoriteType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_FavoriteType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_FavoriteType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_FavoriteStatus::midw_ext_fi_tcl_e8_FavoriteStatus():enType(FI_EN_CONTENT_REGISTERED) {}

tS32 midw_ext_fi_tcl_e8_FavoriteStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_FAVORITESTATUS;
}


midw_ext_fi_tcl_e8_FavoriteStatus::~midw_ext_fi_tcl_e8_FavoriteStatus()
{}

tU32 midw_ext_fi_tcl_e8_FavoriteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_FavoriteStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_FavoriteStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Action::midw_ext_fi_tcl_e8_Action():enType(FI_EN_ENABLE) {}

tS32 midw_ext_fi_tcl_e8_Action::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_ACTION;
}


midw_ext_fi_tcl_e8_Action::~midw_ext_fi_tcl_e8_Action()
{}

tU32 midw_ext_fi_tcl_e8_Action::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_Action::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_Action::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_RegisteredFavorite::midw_ext_fi_tcl_RegisteredFavorite(const midw_ext_fi_tcl_RegisteredFavorite& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ContentName = coRef.ContentName;
   IsEnabled = coRef.IsEnabled;
}
midw_ext_fi_tcl_RegisteredFavorite& midw_ext_fi_tcl_RegisteredFavorite::operator=(const midw_ext_fi_tcl_RegisteredFavorite& coRef)
{
   if (this == &coRef) return *this;
   ContentName = coRef.ContentName;
   IsEnabled = coRef.IsEnabled;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_RegisteredFavorite::vDestroy()
{
   ContentName.vDestroy();
}

midw_ext_fi_tcl_RegisteredFavorite::midw_ext_fi_tcl_RegisteredFavorite()
:ContentName()
,IsEnabled(0)
 {}

tS32 midw_ext_fi_tcl_RegisteredFavorite::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_REGISTEREDFAVORITE;
}


midw_ext_fi_tcl_RegisteredFavorite::~midw_ext_fi_tcl_RegisteredFavorite()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_RegisteredFavorite::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+ContentName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_RegisteredFavorite::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContentName);
   (tVoid) (oIn >> IsEnabled);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_RegisteredFavorite::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContentName);
   (tVoid) (oOut << IsEnabled);
   return oOut;
}

tBool midw_ext_fi_tcl_RegisteredFavorite::operator==(const midw_ext_fi_tcl_RegisteredFavorite& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContentName == roRef.ContentName);
   bResult = bResult && (IsEnabled == roRef.IsEnabled);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b8_ChannelStatus::midw_ext_fi_tcl_b8_ChannelStatus():u8Value(0)
{}

tS32 midw_ext_fi_tcl_b8_ChannelStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B8_CHANNELSTATUS;
}


midw_ext_fi_tcl_b8_ChannelStatus::~midw_ext_fi_tcl_b8_ChannelStatus()
{}

tU32 midw_ext_fi_tcl_b8_ChannelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_b8_ChannelStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b8_ChannelStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_AlertInfo::midw_ext_fi_tcl_AlertInfo(const midw_ext_fi_tcl_AlertInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
   FavoriteType = coRef.FavoriteType;
   ChannelName = coRef.ChannelName;
   ArtistName = coRef.ArtistName;
   SongName = coRef.SongName;
   ChnGraphicsAvailable = coRef.ChnGraphicsAvailable;
   ChannelStatus = coRef.ChannelStatus;
   IsExpired = coRef.IsExpired;
}
midw_ext_fi_tcl_AlertInfo& midw_ext_fi_tcl_AlertInfo::operator=(const midw_ext_fi_tcl_AlertInfo& coRef)
{
   if (this == &coRef) return *this;
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
   FavoriteType = coRef.FavoriteType;
   ChannelName = coRef.ChannelName;
   ArtistName = coRef.ArtistName;
   SongName = coRef.SongName;
   ChnGraphicsAvailable = coRef.ChnGraphicsAvailable;
   ChannelStatus = coRef.ChannelStatus;
   IsExpired = coRef.IsExpired;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_AlertInfo::vDestroy()
{
   ChannelName.vDestroy();
   ArtistName.vDestroy();
   SongName.vDestroy();
}

midw_ext_fi_tcl_AlertInfo::midw_ext_fi_tcl_AlertInfo()
:ServiceID(0)
,ChannelID(0)
,FavoriteType()
,ChannelName()
,ArtistName()
,SongName()
,ChnGraphicsAvailable()
,ChannelStatus()
,IsExpired(0)
 {}

tS32 midw_ext_fi_tcl_AlertInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_ALERTINFO;
}


midw_ext_fi_tcl_AlertInfo::~midw_ext_fi_tcl_AlertInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_AlertInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+ChannelName.u32GetSize(u16MajorVersion)+ArtistName.u32GetSize(u16MajorVersion)+SongName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_AlertInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceID);
   (tVoid) (oIn >> ChannelID);
   (tVoid) (oIn >> FavoriteType);
   (tVoid) (oIn >> ChannelName);
   (tVoid) (oIn >> ArtistName);
   (tVoid) (oIn >> SongName);
   (tVoid) (oIn >> ChnGraphicsAvailable);
   (tVoid) (oIn >> ChannelStatus);
   (tVoid) (oIn >> IsExpired);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_AlertInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceID);
   (tVoid) (oOut << ChannelID);
   (tVoid) (oOut << FavoriteType);
   (tVoid) (oOut << ChannelName);
   (tVoid) (oOut << ArtistName);
   (tVoid) (oOut << SongName);
   (tVoid) (oOut << ChnGraphicsAvailable);
   (tVoid) (oOut << ChannelStatus);
   (tVoid) (oOut << IsExpired);
   return oOut;
}

tBool midw_ext_fi_tcl_AlertInfo::operator==(const midw_ext_fi_tcl_AlertInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceID == roRef.ServiceID);
   bResult = bResult && (ChannelID == roRef.ChannelID);
   bResult = bResult && (FavoriteType == roRef.FavoriteType);
   bResult = bResult && (ChannelName == roRef.ChannelName);
   bResult = bResult && (ArtistName == roRef.ArtistName);
   bResult = bResult && (SongName == roRef.SongName);
   bResult = bResult && (ChnGraphicsAvailable == roRef.ChnGraphicsAvailable);
   bResult = bResult && (ChannelStatus == roRef.ChannelStatus);
   bResult = bResult && (IsExpired == roRef.IsExpired);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_FlashServiceStatus::midw_ext_fi_tcl_e8_FlashServiceStatus():enType(FI_EN_FLASH_SERVICE_STARTED) {}

tS32 midw_ext_fi_tcl_e8_FlashServiceStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_FLASHSERVICESTATUS;
}


midw_ext_fi_tcl_e8_FlashServiceStatus::~midw_ext_fi_tcl_e8_FlashServiceStatus()
{}

tU32 midw_ext_fi_tcl_e8_FlashServiceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_FlashServiceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_FlashServiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction::midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction():enType(FI_EN_TWNOW_BULLETIN_ACTION_PLAY) {}

tS32 midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TWNOW_BULLETIN_PLAYBACKACTION;
}


midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction::~midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction()
{}

tU32 midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TWNow_Bulletin_Status::midw_ext_fi_tcl_e8_TWNow_Bulletin_Status():enType(FI_EN_TWNOW_NO_BULLETIN_AVAILABLE) {}

tS32 midw_ext_fi_tcl_e8_TWNow_Bulletin_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TWNOW_BULLETIN_STATUS;
}


midw_ext_fi_tcl_e8_TWNow_Bulletin_Status::~midw_ext_fi_tcl_e8_TWNow_Bulletin_Status()
{}

tU32 midw_ext_fi_tcl_e8_TWNow_Bulletin_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TWNow_Bulletin_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TWNow_Bulletin_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_MarketListEntry::midw_ext_fi_tcl_MarketListEntry(const midw_ext_fi_tcl_MarketListEntry& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   AbbrMarketName = coRef.AbbrMarketName;
   FullMarketName = coRef.FullMarketName;
   bIsActiveMarket = coRef.bIsActiveMarket;
}
midw_ext_fi_tcl_MarketListEntry& midw_ext_fi_tcl_MarketListEntry::operator=(const midw_ext_fi_tcl_MarketListEntry& coRef)
{
   if (this == &coRef) return *this;
   AbbrMarketName = coRef.AbbrMarketName;
   FullMarketName = coRef.FullMarketName;
   bIsActiveMarket = coRef.bIsActiveMarket;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_MarketListEntry::vDestroy()
{
   AbbrMarketName.vDestroy();
   FullMarketName.vDestroy();
}

midw_ext_fi_tcl_MarketListEntry::midw_ext_fi_tcl_MarketListEntry()
:AbbrMarketName()
,FullMarketName()
,bIsActiveMarket(0)
 {}

tS32 midw_ext_fi_tcl_MarketListEntry::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_MARKETLISTENTRY;
}


midw_ext_fi_tcl_MarketListEntry::~midw_ext_fi_tcl_MarketListEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_MarketListEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+AbbrMarketName.u32GetSize(u16MajorVersion)+FullMarketName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_MarketListEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AbbrMarketName);
   (tVoid) (oIn >> FullMarketName);
   (tVoid) (oIn >> bIsActiveMarket);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_MarketListEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AbbrMarketName);
   (tVoid) (oOut << FullMarketName);
   (tVoid) (oOut << bIsActiveMarket);
   return oOut;
}

tBool midw_ext_fi_tcl_MarketListEntry::operator==(const midw_ext_fi_tcl_MarketListEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AbbrMarketName == roRef.AbbrMarketName);
   bResult = bResult && (FullMarketName == roRef.FullMarketName);
   bResult = bResult && (bIsActiveMarket == roRef.bIsActiveMarket);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_MarketList::midw_ext_fi_tcl_MarketList(const midw_ext_fi_tcl_MarketList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Market = coRef.Market;
}
midw_ext_fi_tcl_MarketList& midw_ext_fi_tcl_MarketList::operator=(const midw_ext_fi_tcl_MarketList& coRef)
{
   if (this == &coRef) return *this;
   Market = coRef.Market;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_MarketList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Market.size(); ++u32Idx)
         Market[u32Idx].vDestroy();
   Market.clear();
   }
}

midw_ext_fi_tcl_MarketList::midw_ext_fi_tcl_MarketList()

 {}

tS32 midw_ext_fi_tcl_MarketList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_MARKETLIST;
}


midw_ext_fi_tcl_MarketList::~midw_ext_fi_tcl_MarketList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_MarketList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Market.size(); ++u32ListIdx)
      u32DynamicSize += Market[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_MarketList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Market.size(); ++u32Idx)
      {
         Market[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Market.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Market[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_MarketList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Market.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Market.size(); ++u32Idx)
         (tVoid) (oOut << Market[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_MarketList::operator==(const midw_ext_fi_tcl_MarketList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Market.size() == roRef.Market.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Market.size()); ++u32Idx)
            bResult = bResult && (Market[u32Idx] == roRef.Market[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SportsFlash_FavoriteTeam::midw_ext_fi_tcl_SportsFlash_FavoriteTeam(const midw_ext_fi_tcl_SportsFlash_FavoriteTeam& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   SportType = coRef.SportType;
   LeagueID = coRef.LeagueID;
   LeagueType = coRef.LeagueType;
   LeagueAbbrName = coRef.LeagueAbbrName;
   LeagueFullName = coRef.LeagueFullName;
   TeamID = coRef.TeamID;
   TeamName = coRef.TeamName;
   TeamNickName = coRef.TeamNickName;
   TeamAbbrName = coRef.TeamAbbrName;
   TeamFullName = coRef.TeamFullName;
   IsFavorite = coRef.IsFavorite;
   IsMonitored = coRef.IsMonitored;
}
midw_ext_fi_tcl_SportsFlash_FavoriteTeam& midw_ext_fi_tcl_SportsFlash_FavoriteTeam::operator=(const midw_ext_fi_tcl_SportsFlash_FavoriteTeam& coRef)
{
   if (this == &coRef) return *this;
   SportType = coRef.SportType;
   LeagueID = coRef.LeagueID;
   LeagueType = coRef.LeagueType;
   LeagueAbbrName = coRef.LeagueAbbrName;
   LeagueFullName = coRef.LeagueFullName;
   TeamID = coRef.TeamID;
   TeamName = coRef.TeamName;
   TeamNickName = coRef.TeamNickName;
   TeamAbbrName = coRef.TeamAbbrName;
   TeamFullName = coRef.TeamFullName;
   IsFavorite = coRef.IsFavorite;
   IsMonitored = coRef.IsMonitored;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SportsFlash_FavoriteTeam::vDestroy()
{
   LeagueAbbrName.vDestroy();
   LeagueFullName.vDestroy();
   TeamName.vDestroy();
   TeamNickName.vDestroy();
   TeamAbbrName.vDestroy();
   TeamFullName.vDestroy();
}

midw_ext_fi_tcl_SportsFlash_FavoriteTeam::midw_ext_fi_tcl_SportsFlash_FavoriteTeam()
:SportType()
,LeagueID(0)
,LeagueType()
,LeagueAbbrName()
,LeagueFullName()
,TeamID(0)
,TeamName()
,TeamNickName()
,TeamAbbrName()
,TeamFullName()
,IsFavorite(0)
,IsMonitored(0)
 {}

tS32 midw_ext_fi_tcl_SportsFlash_FavoriteTeam::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SPORTSFLASH_FAVORITETEAM;
}


midw_ext_fi_tcl_SportsFlash_FavoriteTeam::~midw_ext_fi_tcl_SportsFlash_FavoriteTeam()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SportsFlash_FavoriteTeam::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+LeagueAbbrName.u32GetSize(u16MajorVersion)+LeagueFullName.u32GetSize(u16MajorVersion)+TeamName.u32GetSize(u16MajorVersion)+TeamNickName.u32GetSize(u16MajorVersion)+TeamAbbrName.u32GetSize(u16MajorVersion)+TeamFullName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_SportsFlash_FavoriteTeam::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportType);
   (tVoid) (oIn >> LeagueID);
   (tVoid) (oIn >> LeagueType);
   (tVoid) (oIn >> LeagueAbbrName);
   (tVoid) (oIn >> LeagueFullName);
   (tVoid) (oIn >> TeamID);
   (tVoid) (oIn >> TeamName);
   (tVoid) (oIn >> TeamNickName);
   (tVoid) (oIn >> TeamAbbrName);
   (tVoid) (oIn >> TeamFullName);
   (tVoid) (oIn >> IsFavorite);
   (tVoid) (oIn >> IsMonitored);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SportsFlash_FavoriteTeam::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportType);
   (tVoid) (oOut << LeagueID);
   (tVoid) (oOut << LeagueType);
   (tVoid) (oOut << LeagueAbbrName);
   (tVoid) (oOut << LeagueFullName);
   (tVoid) (oOut << TeamID);
   (tVoid) (oOut << TeamName);
   (tVoid) (oOut << TeamNickName);
   (tVoid) (oOut << TeamAbbrName);
   (tVoid) (oOut << TeamFullName);
   (tVoid) (oOut << IsFavorite);
   (tVoid) (oOut << IsMonitored);
   return oOut;
}

tBool midw_ext_fi_tcl_SportsFlash_FavoriteTeam::operator==(const midw_ext_fi_tcl_SportsFlash_FavoriteTeam& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportType == roRef.SportType);
   bResult = bResult && (LeagueID == roRef.LeagueID);
   bResult = bResult && (LeagueType == roRef.LeagueType);
   bResult = bResult && (LeagueAbbrName == roRef.LeagueAbbrName);
   bResult = bResult && (LeagueFullName == roRef.LeagueFullName);
   bResult = bResult && (TeamID == roRef.TeamID);
   bResult = bResult && (TeamName == roRef.TeamName);
   bResult = bResult && (TeamNickName == roRef.TeamNickName);
   bResult = bResult && (TeamAbbrName == roRef.TeamAbbrName);
   bResult = bResult && (TeamFullName == roRef.TeamFullName);
   bResult = bResult && (IsFavorite == roRef.IsFavorite);
   bResult = bResult && (IsMonitored == roRef.IsMonitored);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SportsFlash_Game::midw_ext_fi_tcl_SportsFlash_Game(const midw_ext_fi_tcl_SportsFlash_Game& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ChannelID = coRef.ChannelID;
   ServiceID = coRef.ServiceID;
   IsLocked = coRef.IsLocked;
   IsMature = coRef.IsMature;
   IsSkipped = coRef.IsSkipped;
   Bias = coRef.Bias;
   HomeTeam = coRef.HomeTeam;
   AwayTeam = coRef.AwayTeam;
   ChnGraphicsAvailable = coRef.ChnGraphicsAvailable;
}
midw_ext_fi_tcl_SportsFlash_Game& midw_ext_fi_tcl_SportsFlash_Game::operator=(const midw_ext_fi_tcl_SportsFlash_Game& coRef)
{
   if (this == &coRef) return *this;
   ChannelID = coRef.ChannelID;
   ServiceID = coRef.ServiceID;
   IsLocked = coRef.IsLocked;
   IsMature = coRef.IsMature;
   IsSkipped = coRef.IsSkipped;
   Bias = coRef.Bias;
   HomeTeam = coRef.HomeTeam;
   AwayTeam = coRef.AwayTeam;
   ChnGraphicsAvailable = coRef.ChnGraphicsAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SportsFlash_Game::vDestroy()
{
   HomeTeam.vDestroy(); 
   AwayTeam.vDestroy(); 
}

midw_ext_fi_tcl_SportsFlash_Game::midw_ext_fi_tcl_SportsFlash_Game()
:ChannelID(0)
,ServiceID(0)
,IsLocked(0)
,IsMature(0)
,IsSkipped(0)
,Bias(0)
,HomeTeam()
,AwayTeam()
,ChnGraphicsAvailable()
 {}

tS32 midw_ext_fi_tcl_SportsFlash_Game::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SPORTSFLASH_GAME;
}


midw_ext_fi_tcl_SportsFlash_Game::~midw_ext_fi_tcl_SportsFlash_Game()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SportsFlash_Game::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+HomeTeam.u32GetSize(u16MajorVersion)+AwayTeam.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_SportsFlash_Game::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelID);
   (tVoid) (oIn >> ServiceID);
   (tVoid) (oIn >> IsLocked);
   (tVoid) (oIn >> IsMature);
   (tVoid) (oIn >> IsSkipped);
   (tVoid) (oIn >> Bias);
   (tVoid) (oIn >> HomeTeam);
   (tVoid) (oIn >> AwayTeam);
   (tVoid) (oIn >> ChnGraphicsAvailable);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SportsFlash_Game::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelID);
   (tVoid) (oOut << ServiceID);
   (tVoid) (oOut << IsLocked);
   (tVoid) (oOut << IsMature);
   (tVoid) (oOut << IsSkipped);
   (tVoid) (oOut << Bias);
   (tVoid) (oOut << HomeTeam);
   (tVoid) (oOut << AwayTeam);
   (tVoid) (oOut << ChnGraphicsAvailable);
   return oOut;
}

tBool midw_ext_fi_tcl_SportsFlash_Game::operator==(const midw_ext_fi_tcl_SportsFlash_Game& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelID == roRef.ChannelID);
   bResult = bResult && (ServiceID == roRef.ServiceID);
   bResult = bResult && (IsLocked == roRef.IsLocked);
   bResult = bResult && (IsMature == roRef.IsMature);
   bResult = bResult && (IsSkipped == roRef.IsSkipped);
   bResult = bResult && (Bias == roRef.Bias);
   bResult = bResult && (HomeTeam == roRef.HomeTeam);
   bResult = bResult && (AwayTeam == roRef.AwayTeam);
   bResult = bResult && (ChnGraphicsAvailable == roRef.ChnGraphicsAvailable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SportsFlash_FlashEvent::midw_ext_fi_tcl_SportsFlash_FlashEvent(const midw_ext_fi_tcl_SportsFlash_FlashEvent& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   GameInfo = coRef.GameInfo;
   FlashEventID = coRef.FlashEventID;
}
midw_ext_fi_tcl_SportsFlash_FlashEvent& midw_ext_fi_tcl_SportsFlash_FlashEvent::operator=(const midw_ext_fi_tcl_SportsFlash_FlashEvent& coRef)
{
   if (this == &coRef) return *this;
   GameInfo = coRef.GameInfo;
   FlashEventID = coRef.FlashEventID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SportsFlash_FlashEvent::vDestroy()
{
   GameInfo.vDestroy(); 
}

midw_ext_fi_tcl_SportsFlash_FlashEvent::midw_ext_fi_tcl_SportsFlash_FlashEvent()
:GameInfo()
,FlashEventID(0)
 {}

tS32 midw_ext_fi_tcl_SportsFlash_FlashEvent::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SPORTSFLASH_FLASHEVENT;
}


midw_ext_fi_tcl_SportsFlash_FlashEvent::~midw_ext_fi_tcl_SportsFlash_FlashEvent()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SportsFlash_FlashEvent::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+GameInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_SportsFlash_FlashEvent::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GameInfo);
   (tVoid) (oIn >> FlashEventID);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SportsFlash_FlashEvent::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GameInfo);
   (tVoid) (oOut << FlashEventID);
   return oOut;
}

tBool midw_ext_fi_tcl_SportsFlash_FlashEvent::operator==(const midw_ext_fi_tcl_SportsFlash_FlashEvent& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GameInfo == roRef.GameInfo);
   bResult = bResult && (FlashEventID == roRef.FlashEventID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SportsFlash_League::midw_ext_fi_tcl_SportsFlash_League(const midw_ext_fi_tcl_SportsFlash_League& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   SportType = coRef.SportType;
   LeagueID = coRef.LeagueID;
   LeagueType = coRef.LeagueType;
   LeagueAbbrName = coRef.LeagueAbbrName;
   LeagueFullName = coRef.LeagueFullName;
}
midw_ext_fi_tcl_SportsFlash_League& midw_ext_fi_tcl_SportsFlash_League::operator=(const midw_ext_fi_tcl_SportsFlash_League& coRef)
{
   if (this == &coRef) return *this;
   SportType = coRef.SportType;
   LeagueID = coRef.LeagueID;
   LeagueType = coRef.LeagueType;
   LeagueAbbrName = coRef.LeagueAbbrName;
   LeagueFullName = coRef.LeagueFullName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SportsFlash_League::vDestroy()
{
   LeagueAbbrName.vDestroy();
   LeagueFullName.vDestroy();
}

midw_ext_fi_tcl_SportsFlash_League::midw_ext_fi_tcl_SportsFlash_League()
:SportType()
,LeagueID(0)
,LeagueType()
,LeagueAbbrName()
,LeagueFullName()
 {}

tS32 midw_ext_fi_tcl_SportsFlash_League::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SPORTSFLASH_LEAGUE;
}


midw_ext_fi_tcl_SportsFlash_League::~midw_ext_fi_tcl_SportsFlash_League()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SportsFlash_League::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+LeagueAbbrName.u32GetSize(u16MajorVersion)+LeagueFullName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_SportsFlash_League::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportType);
   (tVoid) (oIn >> LeagueID);
   (tVoid) (oIn >> LeagueType);
   (tVoid) (oIn >> LeagueAbbrName);
   (tVoid) (oIn >> LeagueFullName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SportsFlash_League::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportType);
   (tVoid) (oOut << LeagueID);
   (tVoid) (oOut << LeagueType);
   (tVoid) (oOut << LeagueAbbrName);
   (tVoid) (oOut << LeagueFullName);
   return oOut;
}

tBool midw_ext_fi_tcl_SportsFlash_League::operator==(const midw_ext_fi_tcl_SportsFlash_League& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportType == roRef.SportType);
   bResult = bResult && (LeagueID == roRef.LeagueID);
   bResult = bResult && (LeagueType == roRef.LeagueType);
   bResult = bResult && (LeagueAbbrName == roRef.LeagueAbbrName);
   bResult = bResult && (LeagueFullName == roRef.LeagueFullName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SportsFlash_Team::midw_ext_fi_tcl_SportsFlash_Team(const midw_ext_fi_tcl_SportsFlash_Team& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   TeamID = coRef.TeamID;
   TeamName = coRef.TeamName;
   TeamNickName = coRef.TeamNickName;
   TeamAbbrName = coRef.TeamAbbrName;
   TeamFullName = coRef.TeamFullName;
   IsFavorite = coRef.IsFavorite;
}
midw_ext_fi_tcl_SportsFlash_Team& midw_ext_fi_tcl_SportsFlash_Team::operator=(const midw_ext_fi_tcl_SportsFlash_Team& coRef)
{
   if (this == &coRef) return *this;
   TeamID = coRef.TeamID;
   TeamName = coRef.TeamName;
   TeamNickName = coRef.TeamNickName;
   TeamAbbrName = coRef.TeamAbbrName;
   TeamFullName = coRef.TeamFullName;
   IsFavorite = coRef.IsFavorite;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SportsFlash_Team::vDestroy()
{
   TeamName.vDestroy();
   TeamNickName.vDestroy();
   TeamAbbrName.vDestroy();
   TeamFullName.vDestroy();
}

midw_ext_fi_tcl_SportsFlash_Team::midw_ext_fi_tcl_SportsFlash_Team()
:TeamID(0)
,TeamName()
,TeamNickName()
,TeamAbbrName()
,TeamFullName()
,IsFavorite(0)
 {}

tS32 midw_ext_fi_tcl_SportsFlash_Team::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SPORTSFLASH_TEAM;
}


midw_ext_fi_tcl_SportsFlash_Team::~midw_ext_fi_tcl_SportsFlash_Team()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SportsFlash_Team::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+TeamName.u32GetSize(u16MajorVersion)+TeamNickName.u32GetSize(u16MajorVersion)+TeamAbbrName.u32GetSize(u16MajorVersion)+TeamFullName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_SportsFlash_Team::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TeamID);
   (tVoid) (oIn >> TeamName);
   (tVoid) (oIn >> TeamNickName);
   (tVoid) (oIn >> TeamAbbrName);
   (tVoid) (oIn >> TeamFullName);
   (tVoid) (oIn >> IsFavorite);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SportsFlash_Team::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TeamID);
   (tVoid) (oOut << TeamName);
   (tVoid) (oOut << TeamNickName);
   (tVoid) (oOut << TeamAbbrName);
   (tVoid) (oOut << TeamFullName);
   (tVoid) (oOut << IsFavorite);
   return oOut;
}

tBool midw_ext_fi_tcl_SportsFlash_Team::operator==(const midw_ext_fi_tcl_SportsFlash_Team& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TeamID == roRef.TeamID);
   bResult = bResult && (TeamName == roRef.TeamName);
   bResult = bResult && (TeamNickName == roRef.TeamNickName);
   bResult = bResult && (TeamAbbrName == roRef.TeamAbbrName);
   bResult = bResult && (TeamFullName == roRef.TeamFullName);
   bResult = bResult && (IsFavorite == roRef.IsFavorite);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TuneScanStatus::midw_ext_fi_tcl_e8_TuneScanStatus():enType(FI_EN_TUNE_SCAN_NA) {}

tS32 midw_ext_fi_tcl_e8_TuneScanStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_TUNESCANSTATUS;
}


midw_ext_fi_tcl_e8_TuneScanStatus::~midw_ext_fi_tcl_e8_TuneScanStatus()
{}

tU32 midw_ext_fi_tcl_e8_TuneScanStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TuneScanStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TuneScanStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SportsFlash_MonitorTeam::midw_ext_fi_tcl_SportsFlash_MonitorTeam(const midw_ext_fi_tcl_SportsFlash_MonitorTeam& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   LeagueID = coRef.LeagueID;
   TeamID = coRef.TeamID;
   Status = coRef.Status;
}
midw_ext_fi_tcl_SportsFlash_MonitorTeam& midw_ext_fi_tcl_SportsFlash_MonitorTeam::operator=(const midw_ext_fi_tcl_SportsFlash_MonitorTeam& coRef)
{
   if (this == &coRef) return *this;
   LeagueID = coRef.LeagueID;
   TeamID = coRef.TeamID;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_SportsFlash_MonitorTeam::midw_ext_fi_tcl_SportsFlash_MonitorTeam()
:LeagueID(0)
,TeamID(0)
,Status(0)
 {}

tS32 midw_ext_fi_tcl_SportsFlash_MonitorTeam::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SPORTSFLASH_MONITORTEAM;
}


midw_ext_fi_tcl_SportsFlash_MonitorTeam::~midw_ext_fi_tcl_SportsFlash_MonitorTeam()
{}

tU32 midw_ext_fi_tcl_SportsFlash_MonitorTeam::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_SportsFlash_MonitorTeam::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LeagueID);
   (tVoid) (oIn >> TeamID);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SportsFlash_MonitorTeam::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LeagueID);
   (tVoid) (oOut << TeamID);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_fi_tcl_SportsFlash_MonitorTeam::operator==(const midw_ext_fi_tcl_SportsFlash_MonitorTeam& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LeagueID == roRef.LeagueID);
   bResult = bResult && (TeamID == roRef.TeamID);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_FlashEventPlaybackStatus::midw_ext_fi_tcl_e8_FlashEventPlaybackStatus():enType(FI_EN_FLASHEVENT_UNKNOWN) {}

tS32 midw_ext_fi_tcl_e8_FlashEventPlaybackStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_FLASHEVENTPLAYBACKSTATUS;
}


midw_ext_fi_tcl_e8_FlashEventPlaybackStatus::~midw_ext_fi_tcl_e8_FlashEventPlaybackStatus()
{}

tU32 midw_ext_fi_tcl_e8_FlashEventPlaybackStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_FlashEventPlaybackStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_FlashEventPlaybackStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_BrowseDirection::midw_ext_fi_tcl_e8_BrowseDirection():enType(FI_EN_BROWSE_INVALID) {}

tS32 midw_ext_fi_tcl_e8_BrowseDirection::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_BROWSEDIRECTION;
}


midw_ext_fi_tcl_e8_BrowseDirection::~midw_ext_fi_tcl_e8_BrowseDirection()
{}

tU32 midw_ext_fi_tcl_e8_BrowseDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_BrowseDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_BrowseDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_BrowseRateConfiguration::midw_ext_fi_tcl_BrowseRateConfiguration(const midw_ext_fi_tcl_BrowseRateConfiguration& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   duration = coRef.duration;
   rate = coRef.rate;
}
midw_ext_fi_tcl_BrowseRateConfiguration& midw_ext_fi_tcl_BrowseRateConfiguration::operator=(const midw_ext_fi_tcl_BrowseRateConfiguration& coRef)
{
   if (this == &coRef) return *this;
   duration = coRef.duration;
   rate = coRef.rate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_BrowseRateConfiguration::midw_ext_fi_tcl_BrowseRateConfiguration()
:duration(0)
,rate(0)
 {}

tS32 midw_ext_fi_tcl_BrowseRateConfiguration::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_BROWSERATECONFIGURATION;
}


midw_ext_fi_tcl_BrowseRateConfiguration::~midw_ext_fi_tcl_BrowseRateConfiguration()
{}

tU32 midw_ext_fi_tcl_BrowseRateConfiguration::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_BrowseRateConfiguration::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> duration);
   (tVoid) (oIn >> rate);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_BrowseRateConfiguration::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << duration);
   (tVoid) (oOut << rate);
   return oOut;
}

tBool midw_ext_fi_tcl_BrowseRateConfiguration::operator==(const midw_ext_fi_tcl_BrowseRateConfiguration& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (duration == roRef.duration);
   bResult = bResult && (rate == roRef.rate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_BrowseChannelLoop::midw_ext_fi_tcl_e8_BrowseChannelLoop():enType(FI_EN_LOOP_AROUND) {}

tS32 midw_ext_fi_tcl_e8_BrowseChannelLoop::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_BROWSECHANNELLOOP;
}


midw_ext_fi_tcl_e8_BrowseChannelLoop::~midw_ext_fi_tcl_e8_BrowseChannelLoop()
{}

tU32 midw_ext_fi_tcl_e8_BrowseChannelLoop::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_BrowseChannelLoop::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_BrowseChannelLoop::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_BrowseChannelType::midw_ext_fi_tcl_e8_BrowseChannelType():enType(FI_EN_BROWSETYPE_ALL_CHANNELS) {}

tS32 midw_ext_fi_tcl_e8_BrowseChannelType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_BROWSECHANNELTYPE;
}


midw_ext_fi_tcl_e8_BrowseChannelType::~midw_ext_fi_tcl_e8_BrowseChannelType()
{}

tU32 midw_ext_fi_tcl_e8_BrowseChannelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_BrowseChannelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_BrowseChannelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_BrowseChannelConfig::midw_ext_fi_tcl_BrowseChannelConfig(const midw_ext_fi_tcl_BrowseChannelConfig& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Configuration = coRef.Configuration;
   Loop = coRef.Loop;
   Type = coRef.Type;
}
midw_ext_fi_tcl_BrowseChannelConfig& midw_ext_fi_tcl_BrowseChannelConfig::operator=(const midw_ext_fi_tcl_BrowseChannelConfig& coRef)
{
   if (this == &coRef) return *this;
   Configuration = coRef.Configuration;
   Loop = coRef.Loop;
   Type = coRef.Type;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_BrowseChannelConfig::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Configuration.size(); ++u32Idx)
         Configuration[u32Idx].vDestroy();
   Configuration.clear();
   }
}

midw_ext_fi_tcl_BrowseChannelConfig::midw_ext_fi_tcl_BrowseChannelConfig()

:Loop()
,Type()
 {}

tS32 midw_ext_fi_tcl_BrowseChannelConfig::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_BROWSECHANNELCONFIG;
}


midw_ext_fi_tcl_BrowseChannelConfig::~midw_ext_fi_tcl_BrowseChannelConfig()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_BrowseChannelConfig::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(Configuration.size()*4);
}

fi_tclInContext& midw_ext_fi_tcl_BrowseChannelConfig::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Configuration.size(); ++u32Idx)
      {
         Configuration[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Configuration.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Configuration[u32Idx]);
      }
   }
   (tVoid) (oIn >> Loop);
   (tVoid) (oIn >> Type);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_BrowseChannelConfig::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Configuration.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Configuration.size(); ++u32Idx)
         (tVoid) (oOut << Configuration[u32Idx]);
   }
   (tVoid) (oOut << Loop);
   (tVoid) (oOut << Type);
   return oOut;
}

tBool midw_ext_fi_tcl_BrowseChannelConfig::operator==(const midw_ext_fi_tcl_BrowseChannelConfig& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Configuration.size() == roRef.Configuration.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Configuration.size()); ++u32Idx)
            bResult = bResult && (Configuration[u32Idx] == roRef.Configuration[u32Idx]);
      }
   bResult = bResult && (Loop == roRef.Loop);
   bResult = bResult && (Type == roRef.Type);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_b16_CHANNEL_EVENT::midw_ext_fi_tcl_b16_CHANNEL_EVENT():u16Value(0)
{}

tS32 midw_ext_fi_tcl_b16_CHANNEL_EVENT::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_B16_CHANNEL_EVENT;
}


midw_ext_fi_tcl_b16_CHANNEL_EVENT::~midw_ext_fi_tcl_b16_CHANNEL_EVENT()
{}

tU32 midw_ext_fi_tcl_b16_CHANNEL_EVENT::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_b16_CHANNEL_EVENT::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_ext_fi_tcl_b16_CHANNEL_EVENT::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_LocalTimeDate::midw_ext_fi_tcl_LocalTimeDate(const midw_ext_fi_tcl_LocalTimeDate& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
}
midw_ext_fi_tcl_LocalTimeDate& midw_ext_fi_tcl_LocalTimeDate::operator=(const midw_ext_fi_tcl_LocalTimeDate& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_LocalTimeDate::midw_ext_fi_tcl_LocalTimeDate()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
 {}

tS32 midw_ext_fi_tcl_LocalTimeDate::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_LOCALTIMEDATE;
}


midw_ext_fi_tcl_LocalTimeDate::~midw_ext_fi_tcl_LocalTimeDate()
{}

tU32 midw_ext_fi_tcl_LocalTimeDate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_fi_tcl_LocalTimeDate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_LocalTimeDate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   return oOut;
}

tBool midw_ext_fi_tcl_LocalTimeDate::operator==(const midw_ext_fi_tcl_LocalTimeDate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PresetEntry::midw_ext_fi_tcl_PresetEntry(const midw_ext_fi_tcl_PresetEntry& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Index = coRef.Index;
   SID = coRef.SID;
}
midw_ext_fi_tcl_PresetEntry& midw_ext_fi_tcl_PresetEntry::operator=(const midw_ext_fi_tcl_PresetEntry& coRef)
{
   if (this == &coRef) return *this;
   Index = coRef.Index;
   SID = coRef.SID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PresetEntry::midw_ext_fi_tcl_PresetEntry()
:Index(0)
,SID(0)
 {}

tS32 midw_ext_fi_tcl_PresetEntry::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PRESETENTRY;
}


midw_ext_fi_tcl_PresetEntry::~midw_ext_fi_tcl_PresetEntry()
{}

tU32 midw_ext_fi_tcl_PresetEntry::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_PresetEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Index);
   (tVoid) (oIn >> SID);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PresetEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Index);
   (tVoid) (oOut << SID);
   return oOut;
}

tBool midw_ext_fi_tcl_PresetEntry::operator==(const midw_ext_fi_tcl_PresetEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Index == roRef.Index);
   bResult = bResult && (SID == roRef.SID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_Status::midw_ext_fi_tcl_Status():enType(FI_EN_FAILED) {}

tS32 midw_ext_fi_tcl_Status::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_STATUS;
}


midw_ext_fi_tcl_Status::~midw_ext_fi_tcl_Status()
{}

tU32 midw_ext_fi_tcl_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_ProfileStatus::midw_ext_fi_tcl_ProfileStatus():enType(FI_EN_IDLE) {}

tS32 midw_ext_fi_tcl_ProfileStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PROFILESTATUS;
}


midw_ext_fi_tcl_ProfileStatus::~midw_ext_fi_tcl_ProfileStatus()
{}

tU32 midw_ext_fi_tcl_ProfileStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_ProfileStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_ProfileStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_ProfileAction::midw_ext_fi_tcl_ProfileAction():enType(FI_EN_ACTIVEPROFILE) {}

tS32 midw_ext_fi_tcl_ProfileAction::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PROFILEACTION;
}


midw_ext_fi_tcl_ProfileAction::~midw_ext_fi_tcl_ProfileAction()
{}

tU32 midw_ext_fi_tcl_ProfileAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_ProfileAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_ProfileAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_ProfileResponse::midw_ext_fi_tcl_ProfileResponse(const midw_ext_fi_tcl_ProfileResponse& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
   ProfileAction = coRef.ProfileAction;
   ProfileStatus = coRef.ProfileStatus;
}
midw_ext_fi_tcl_ProfileResponse& midw_ext_fi_tcl_ProfileResponse::operator=(const midw_ext_fi_tcl_ProfileResponse& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   ProfileAction = coRef.ProfileAction;
   ProfileStatus = coRef.ProfileStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_ProfileResponse::midw_ext_fi_tcl_ProfileResponse()
:Status()
,ProfileAction()
,ProfileStatus()
 {}

tS32 midw_ext_fi_tcl_ProfileResponse::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PROFILERESPONSE;
}


midw_ext_fi_tcl_ProfileResponse::~midw_ext_fi_tcl_ProfileResponse()
{}

tU32 midw_ext_fi_tcl_ProfileResponse::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_fi_tcl_ProfileResponse::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> ProfileAction);
   (tVoid) (oIn >> ProfileStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_ProfileResponse::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << ProfileAction);
   (tVoid) (oOut << ProfileStatus);
   return oOut;
}

tBool midw_ext_fi_tcl_ProfileResponse::operator==(const midw_ext_fi_tcl_ProfileResponse& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (ProfileAction == roRef.ProfileAction);
   bResult = bResult && (ProfileStatus == roRef.ProfileStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_PresetsConfiguration::midw_ext_fi_tcl_PresetsConfiguration(const midw_ext_fi_tcl_PresetsConfiguration& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   BandCount = coRef.BandCount;
   BandCapacity = coRef.BandCapacity;
}
midw_ext_fi_tcl_PresetsConfiguration& midw_ext_fi_tcl_PresetsConfiguration::operator=(const midw_ext_fi_tcl_PresetsConfiguration& coRef)
{
   if (this == &coRef) return *this;
   BandCount = coRef.BandCount;
   BandCapacity = coRef.BandCapacity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_PresetsConfiguration::midw_ext_fi_tcl_PresetsConfiguration()
:BandCount(0)
,BandCapacity(0)
 {}

tS32 midw_ext_fi_tcl_PresetsConfiguration::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_PRESETSCONFIGURATION;
}


midw_ext_fi_tcl_PresetsConfiguration::~midw_ext_fi_tcl_PresetsConfiguration()
{}

tU32 midw_ext_fi_tcl_PresetsConfiguration::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_fi_tcl_PresetsConfiguration::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BandCount);
   (tVoid) (oIn >> BandCapacity);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_PresetsConfiguration::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BandCount);
   (tVoid) (oOut << BandCapacity);
   return oOut;
}

tBool midw_ext_fi_tcl_PresetsConfiguration::operator==(const midw_ext_fi_tcl_PresetsConfiguration& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BandCount == roRef.BandCount);
   bResult = bResult && (BandCapacity == roRef.BandCapacity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8ChannelArtErrorTypes::midw_ext_fi_tcl_e8ChannelArtErrorTypes():enType(FI_EN_CHANNELART_SERVICE_ERROR) {}

tS32 midw_ext_fi_tcl_e8ChannelArtErrorTypes::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8CHANNELARTERRORTYPES;
}


midw_ext_fi_tcl_e8ChannelArtErrorTypes::~midw_ext_fi_tcl_e8ChannelArtErrorTypes()
{}

tU32 midw_ext_fi_tcl_e8ChannelArtErrorTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8ChannelArtErrorTypes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8ChannelArtErrorTypes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_ChnGraphicsTypes::midw_ext_fi_tcl_e8_ChnGraphicsTypes():enType(FI_EN_CHANNEL_ART_AVAILABLE_IMAGE_NONE) {}

tS32 midw_ext_fi_tcl_e8_ChnGraphicsTypes::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_CHNGRAPHICSTYPES;
}


midw_ext_fi_tcl_e8_ChnGraphicsTypes::~midw_ext_fi_tcl_e8_ChnGraphicsTypes()
{}

tU32 midw_ext_fi_tcl_e8_ChnGraphicsTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_ChnGraphicsTypes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_ChnGraphicsTypes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_ImageData::midw_ext_fi_tcl_ImageData(const midw_ext_fi_tcl_ImageData& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   SID = coRef.SID;
   ImageData = coRef.ImageData;
   ImageDataSize = coRef.ImageDataSize;
}
midw_ext_fi_tcl_ImageData& midw_ext_fi_tcl_ImageData::operator=(const midw_ext_fi_tcl_ImageData& coRef)
{
   if (this == &coRef) return *this;
   SID = coRef.SID;
   ImageData = coRef.ImageData;
   ImageDataSize = coRef.ImageDataSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_ImageData::vDestroy()
{
   {
   ImageData.clear();
   }
}

midw_ext_fi_tcl_ImageData::midw_ext_fi_tcl_ImageData()
:SID(0)

,ImageDataSize(0)
 {}

tS32 midw_ext_fi_tcl_ImageData::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_IMAGEDATA;
}


midw_ext_fi_tcl_ImageData::~midw_ext_fi_tcl_ImageData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_ImageData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10+ static_cast<tU32>(ImageData.size()*1);
}

fi_tclInContext& midw_ext_fi_tcl_ImageData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SID);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ImageData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ImageData[u32Idx]);
      }
   }
   (tVoid) (oIn >> ImageDataSize);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_ImageData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SID);
   (tVoid) (oOut << (tU32)ImageData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ImageData.size(); ++u32Idx)
         (tVoid) (oOut << ImageData[u32Idx]);
   }
   (tVoid) (oOut << ImageDataSize);
   return oOut;
}

tBool midw_ext_fi_tcl_ImageData::operator==(const midw_ext_fi_tcl_ImageData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SID == roRef.SID);
      bResult = bResult && (ImageData.size() == roRef.ImageData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ImageData.size()); ++u32Idx)
            bResult = bResult && (ImageData[u32Idx] == roRef.ImageData[u32Idx]);
      }
   bResult = bResult && (ImageDataSize == roRef.ImageDataSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_FuelTypeEnum::midw_ext_fi_tcl_e8_FuelTypeEnum():enType(FI_EN_FUEL_TYPE_REGULAR) {}

tS32 midw_ext_fi_tcl_e8_FuelTypeEnum::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_FUELTYPEENUM;
}


midw_ext_fi_tcl_e8_FuelTypeEnum::~midw_ext_fi_tcl_e8_FuelTypeEnum()
{}

tU32 midw_ext_fi_tcl_e8_FuelTypeEnum::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_FuelTypeEnum::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_FuelTypeEnum::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_FuelStationAmenity::midw_ext_fi_tcl_e8_FuelStationAmenity():enType(FI_EN_FUEL_STATION_AMENITY_OPEN_24HR) {}

tS32 midw_ext_fi_tcl_e8_FuelStationAmenity::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_FUELSTATIONAMENITY;
}


midw_ext_fi_tcl_e8_FuelStationAmenity::~midw_ext_fi_tcl_e8_FuelStationAmenity()
{}

tU32 midw_ext_fi_tcl_e8_FuelStationAmenity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_FuelStationAmenity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_FuelStationAmenity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_SortType::midw_ext_fi_tcl_e8_SortType():enType(FI_EN_FUEL_SORT_BY_NONE) {}

tS32 midw_ext_fi_tcl_e8_SortType::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_SORTTYPE;
}


midw_ext_fi_tcl_e8_SortType::~midw_ext_fi_tcl_e8_SortType()
{}

tU32 midw_ext_fi_tcl_e8_SortType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_SortType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_SortType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_FuelInfo::midw_ext_fi_tcl_FuelInfo(const midw_ext_fi_tcl_FuelInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   StationName = coRef.StationName;
   Brand = coRef.Brand;
   FuelType = coRef.FuelType;
   Fuel_LOCID = coRef.Fuel_LOCID;
   FuelName = coRef.FuelName;
   FuelPrice = coRef.FuelPrice;
   FuelAge = coRef.FuelAge;
   FuelLoc = coRef.FuelLoc;
   FuelDistKm = coRef.FuelDistKm;
   FuelDistMile = coRef.FuelDistMile;
   NumPrices = coRef.NumPrices;
}
midw_ext_fi_tcl_FuelInfo& midw_ext_fi_tcl_FuelInfo::operator=(const midw_ext_fi_tcl_FuelInfo& coRef)
{
   if (this == &coRef) return *this;
   StationName = coRef.StationName;
   Brand = coRef.Brand;
   FuelType = coRef.FuelType;
   Fuel_LOCID = coRef.Fuel_LOCID;
   FuelName = coRef.FuelName;
   FuelPrice = coRef.FuelPrice;
   FuelAge = coRef.FuelAge;
   FuelLoc = coRef.FuelLoc;
   FuelDistKm = coRef.FuelDistKm;
   FuelDistMile = coRef.FuelDistMile;
   NumPrices = coRef.NumPrices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_FuelInfo::vDestroy()
{
   StationName.vDestroy();
   Brand.vDestroy();
   FuelName.vDestroy();
   FuelPrice.vDestroy();
   FuelLoc.vDestroy(); 
}

midw_ext_fi_tcl_FuelInfo::midw_ext_fi_tcl_FuelInfo()
:StationName()
,Brand()
,FuelType()
,Fuel_LOCID(0)
,FuelName()
,FuelPrice()
,FuelAge(0)
,FuelLoc()
,FuelDistKm(0)
,FuelDistMile(0)
,NumPrices(0)
 {}

tS32 midw_ext_fi_tcl_FuelInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_FUELINFO;
}


midw_ext_fi_tcl_FuelInfo::~midw_ext_fi_tcl_FuelInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_FuelInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 30+StationName.u32GetSize(u16MajorVersion)+Brand.u32GetSize(u16MajorVersion)+FuelName.u32GetSize(u16MajorVersion)+FuelPrice.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_FuelInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StationName);
   (tVoid) (oIn >> Brand);
   (tVoid) (oIn >> FuelType);
   (tVoid) (oIn >> Fuel_LOCID);
   (tVoid) (oIn >> FuelName);
   (tVoid) (oIn >> FuelPrice);
   (tVoid) (oIn >> FuelAge);
   (tVoid) (oIn >> FuelLoc);
   (tVoid) (oIn >> FuelDistKm);
   (tVoid) (oIn >> FuelDistMile);
   (tVoid) (oIn >> NumPrices);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_FuelInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StationName);
   (tVoid) (oOut << Brand);
   (tVoid) (oOut << FuelType);
   (tVoid) (oOut << Fuel_LOCID);
   (tVoid) (oOut << FuelName);
   (tVoid) (oOut << FuelPrice);
   (tVoid) (oOut << FuelAge);
   (tVoid) (oOut << FuelLoc);
   (tVoid) (oOut << FuelDistKm);
   (tVoid) (oOut << FuelDistMile);
   (tVoid) (oOut << NumPrices);
   return oOut;
}

tBool midw_ext_fi_tcl_FuelInfo::operator==(const midw_ext_fi_tcl_FuelInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StationName == roRef.StationName);
   bResult = bResult && (Brand == roRef.Brand);
   bResult = bResult && (FuelType == roRef.FuelType);
   bResult = bResult && (Fuel_LOCID == roRef.Fuel_LOCID);
   bResult = bResult && (FuelName == roRef.FuelName);
   bResult = bResult && (FuelPrice == roRef.FuelPrice);
   bResult = bResult && (FuelAge == roRef.FuelAge);
   bResult = bResult && (FuelLoc == roRef.FuelLoc);
   bResult = bResult && (FuelDistKm == roRef.FuelDistKm);
   bResult = bResult && (FuelDistMile == roRef.FuelDistMile);
   bResult = bResult && (NumPrices == roRef.NumPrices);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_FuelTypeInfo::midw_ext_fi_tcl_FuelTypeInfo(const midw_ext_fi_tcl_FuelTypeInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   FuelType = coRef.FuelType;
   FuelName = coRef.FuelName;
}
midw_ext_fi_tcl_FuelTypeInfo& midw_ext_fi_tcl_FuelTypeInfo::operator=(const midw_ext_fi_tcl_FuelTypeInfo& coRef)
{
   if (this == &coRef) return *this;
   FuelType = coRef.FuelType;
   FuelName = coRef.FuelName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_FuelTypeInfo::vDestroy()
{
   FuelName.vDestroy();
}

midw_ext_fi_tcl_FuelTypeInfo::midw_ext_fi_tcl_FuelTypeInfo()
:FuelType()
,FuelName()
 {}

tS32 midw_ext_fi_tcl_FuelTypeInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_FUELTYPEINFO;
}


midw_ext_fi_tcl_FuelTypeInfo::~midw_ext_fi_tcl_FuelTypeInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_FuelTypeInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+FuelName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_FuelTypeInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FuelType);
   (tVoid) (oIn >> FuelName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_FuelTypeInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FuelType);
   (tVoid) (oOut << FuelName);
   return oOut;
}

tBool midw_ext_fi_tcl_FuelTypeInfo::operator==(const midw_ext_fi_tcl_FuelTypeInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FuelType == roRef.FuelType);
   bResult = bResult && (FuelName == roRef.FuelName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8FuelErrorTypes::midw_ext_fi_tcl_e8FuelErrorTypes():enType(FI_EN_FUEL_INFOLIST_EMPTY) {}

tS32 midw_ext_fi_tcl_e8FuelErrorTypes::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8FUELERRORTYPES;
}


midw_ext_fi_tcl_e8FuelErrorTypes::~midw_ext_fi_tcl_e8FuelErrorTypes()
{}

tU32 midw_ext_fi_tcl_e8FuelErrorTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8FuelErrorTypes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8FuelErrorTypes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_FuelTypeInfolist::midw_ext_fi_tcl_FuelTypeInfolist(const midw_ext_fi_tcl_FuelTypeInfolist& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   FuelName = coRef.FuelName;
   FuelPrice = coRef.FuelPrice;
   FuelAge = coRef.FuelAge;
   FuelAvail = coRef.FuelAvail;
   FuelType = coRef.FuelType;
}
midw_ext_fi_tcl_FuelTypeInfolist& midw_ext_fi_tcl_FuelTypeInfolist::operator=(const midw_ext_fi_tcl_FuelTypeInfolist& coRef)
{
   if (this == &coRef) return *this;
   FuelName = coRef.FuelName;
   FuelPrice = coRef.FuelPrice;
   FuelAge = coRef.FuelAge;
   FuelAvail = coRef.FuelAvail;
   FuelType = coRef.FuelType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_FuelTypeInfolist::vDestroy()
{
   FuelName.vDestroy();
   FuelPrice.vDestroy();
}

midw_ext_fi_tcl_FuelTypeInfolist::midw_ext_fi_tcl_FuelTypeInfolist()
:FuelName()
,FuelPrice()
,FuelAge(0)
,FuelAvail(0)
,FuelType()
 {}

tS32 midw_ext_fi_tcl_FuelTypeInfolist::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_FUELTYPEINFOLIST;
}


midw_ext_fi_tcl_FuelTypeInfolist::~midw_ext_fi_tcl_FuelTypeInfolist()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_FuelTypeInfolist::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+FuelName.u32GetSize(u16MajorVersion)+FuelPrice.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_FuelTypeInfolist::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FuelName);
   (tVoid) (oIn >> FuelPrice);
   (tVoid) (oIn >> FuelAge);
   (tVoid) (oIn >> FuelAvail);
   (tVoid) (oIn >> FuelType);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_FuelTypeInfolist::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FuelName);
   (tVoid) (oOut << FuelPrice);
   (tVoid) (oOut << FuelAge);
   (tVoid) (oOut << FuelAvail);
   (tVoid) (oOut << FuelType);
   return oOut;
}

tBool midw_ext_fi_tcl_FuelTypeInfolist::operator==(const midw_ext_fi_tcl_FuelTypeInfolist& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FuelName == roRef.FuelName);
   bResult = bResult && (FuelPrice == roRef.FuelPrice);
   bResult = bResult && (FuelAge == roRef.FuelAge);
   bResult = bResult && (FuelAvail == roRef.FuelAvail);
   bResult = bResult && (FuelType == roRef.FuelType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_FuelStationInfo::midw_ext_fi_tcl_FuelStationInfo(const midw_ext_fi_tcl_FuelStationInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   StationName = coRef.StationName;
   Brand = coRef.Brand;
   StreetName = coRef.StreetName;
   City = coRef.City;
   State = coRef.State;
   ZipCode = coRef.ZipCode;
   Phone = coRef.Phone;
   Fuel_LOCID = coRef.Fuel_LOCID;
   Amenity = coRef.Amenity;
   FuelFavInfo = coRef.FuelFavInfo;
   FuelLocation = coRef.FuelLocation;
   FuelTypelist = coRef.FuelTypelist;
   StationAmenitylist = coRef.StationAmenitylist;
   NumPrices = coRef.NumPrices;
}
midw_ext_fi_tcl_FuelStationInfo& midw_ext_fi_tcl_FuelStationInfo::operator=(const midw_ext_fi_tcl_FuelStationInfo& coRef)
{
   if (this == &coRef) return *this;
   StationName = coRef.StationName;
   Brand = coRef.Brand;
   StreetName = coRef.StreetName;
   City = coRef.City;
   State = coRef.State;
   ZipCode = coRef.ZipCode;
   Phone = coRef.Phone;
   Fuel_LOCID = coRef.Fuel_LOCID;
   Amenity = coRef.Amenity;
   FuelFavInfo = coRef.FuelFavInfo;
   FuelLocation = coRef.FuelLocation;
   FuelTypelist = coRef.FuelTypelist;
   StationAmenitylist = coRef.StationAmenitylist;
   NumPrices = coRef.NumPrices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_FuelStationInfo::vDestroy()
{
   StationName.vDestroy();
   Brand.vDestroy();
   StreetName.vDestroy();
   City.vDestroy();
   State.vDestroy();
   ZipCode.vDestroy();
   Phone.vDestroy();
   Amenity.vDestroy();
   FuelLocation.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypelist.size(); ++u32Idx)
         FuelTypelist[u32Idx].vDestroy();
   FuelTypelist.clear();
   }
   {
   StationAmenitylist.clear();
   }
}

midw_ext_fi_tcl_FuelStationInfo::midw_ext_fi_tcl_FuelStationInfo()
:StationName()
,Brand()
,StreetName()
,City()
,State()
,ZipCode()
,Phone()
,Fuel_LOCID(0)
,Amenity()
,FuelFavInfo(0)
,FuelLocation()


,NumPrices(0)
 {}

tS32 midw_ext_fi_tcl_FuelStationInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_FUELSTATIONINFO;
}


midw_ext_fi_tcl_FuelStationInfo::~midw_ext_fi_tcl_FuelStationInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_FuelStationInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FuelTypelist.size(); ++u32ListIdx)
      u32DynamicSize += FuelTypelist[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+29+StationName.u32GetSize(u16MajorVersion)+Brand.u32GetSize(u16MajorVersion)+StreetName.u32GetSize(u16MajorVersion)+City.u32GetSize(u16MajorVersion)+State.u32GetSize(u16MajorVersion)+ZipCode.u32GetSize(u16MajorVersion)+Phone.u32GetSize(u16MajorVersion)+Amenity.u32GetSize(u16MajorVersion)+ static_cast<tU32>(StationAmenitylist.size()*1);
}

fi_tclInContext& midw_ext_fi_tcl_FuelStationInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StationName);
   (tVoid) (oIn >> Brand);
   (tVoid) (oIn >> StreetName);
   (tVoid) (oIn >> City);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> ZipCode);
   (tVoid) (oIn >> Phone);
   (tVoid) (oIn >> Fuel_LOCID);
   (tVoid) (oIn >> Amenity);
   (tVoid) (oIn >> FuelFavInfo);
   (tVoid) (oIn >> FuelLocation);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelTypelist.size(); ++u32Idx)
      {
         FuelTypelist[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FuelTypelist.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FuelTypelist[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      StationAmenitylist.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StationAmenitylist[u32Idx]);
      }
   }
   (tVoid) (oIn >> NumPrices);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_FuelStationInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StationName);
   (tVoid) (oOut << Brand);
   (tVoid) (oOut << StreetName);
   (tVoid) (oOut << City);
   (tVoid) (oOut << State);
   (tVoid) (oOut << ZipCode);
   (tVoid) (oOut << Phone);
   (tVoid) (oOut << Fuel_LOCID);
   (tVoid) (oOut << Amenity);
   (tVoid) (oOut << FuelFavInfo);
   (tVoid) (oOut << FuelLocation);
   (tVoid) (oOut << (tU32)FuelTypelist.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypelist.size(); ++u32Idx)
         (tVoid) (oOut << FuelTypelist[u32Idx]);
   }
   (tVoid) (oOut << (tU32)StationAmenitylist.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StationAmenitylist.size(); ++u32Idx)
         (tVoid) (oOut << StationAmenitylist[u32Idx]);
   }
   (tVoid) (oOut << NumPrices);
   return oOut;
}

tBool midw_ext_fi_tcl_FuelStationInfo::operator==(const midw_ext_fi_tcl_FuelStationInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StationName == roRef.StationName);
   bResult = bResult && (Brand == roRef.Brand);
   bResult = bResult && (StreetName == roRef.StreetName);
   bResult = bResult && (City == roRef.City);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (ZipCode == roRef.ZipCode);
   bResult = bResult && (Phone == roRef.Phone);
   bResult = bResult && (Fuel_LOCID == roRef.Fuel_LOCID);
   bResult = bResult && (Amenity == roRef.Amenity);
   bResult = bResult && (FuelFavInfo == roRef.FuelFavInfo);
   bResult = bResult && (FuelLocation == roRef.FuelLocation);
      bResult = bResult && (FuelTypelist.size() == roRef.FuelTypelist.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelTypelist.size()); ++u32Idx)
            bResult = bResult && (FuelTypelist[u32Idx] == roRef.FuelTypelist[u32Idx]);
      }
      bResult = bResult && (StationAmenitylist.size() == roRef.StationAmenitylist.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StationAmenitylist.size()); ++u32Idx)
            bResult = bResult && (StationAmenitylist[u32Idx] == roRef.StationAmenitylist[u32Idx]);
      }
   bResult = bResult && (NumPrices == roRef.NumPrices);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_FuelInfoList::midw_ext_fi_tcl_FuelInfoList(const midw_ext_fi_tcl_FuelInfoList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   FuelInfolist = coRef.FuelInfolist;
}
midw_ext_fi_tcl_FuelInfoList& midw_ext_fi_tcl_FuelInfoList::operator=(const midw_ext_fi_tcl_FuelInfoList& coRef)
{
   if (this == &coRef) return *this;
   FuelInfolist = coRef.FuelInfolist;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_FuelInfoList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FuelInfolist.size(); ++u32Idx)
         FuelInfolist[u32Idx].vDestroy();
   FuelInfolist.clear();
   }
}

midw_ext_fi_tcl_FuelInfoList::midw_ext_fi_tcl_FuelInfoList()

 {}

tS32 midw_ext_fi_tcl_FuelInfoList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_FUELINFOLIST;
}


midw_ext_fi_tcl_FuelInfoList::~midw_ext_fi_tcl_FuelInfoList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_FuelInfoList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FuelInfolist.size(); ++u32ListIdx)
      u32DynamicSize += FuelInfolist[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_FuelInfoList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelInfolist.size(); ++u32Idx)
      {
         FuelInfolist[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FuelInfolist.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FuelInfolist[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_FuelInfoList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)FuelInfolist.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FuelInfolist.size(); ++u32Idx)
         (tVoid) (oOut << FuelInfolist[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_FuelInfoList::operator==(const midw_ext_fi_tcl_FuelInfoList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (FuelInfolist.size() == roRef.FuelInfolist.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelInfolist.size()); ++u32Idx)
            bResult = bResult && (FuelInfolist[u32Idx] == roRef.FuelInfolist[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_BrandNameList::midw_ext_fi_tcl_BrandNameList(const midw_ext_fi_tcl_BrandNameList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   BrandNameList = coRef.BrandNameList;
}
midw_ext_fi_tcl_BrandNameList& midw_ext_fi_tcl_BrandNameList::operator=(const midw_ext_fi_tcl_BrandNameList& coRef)
{
   if (this == &coRef) return *this;
   BrandNameList = coRef.BrandNameList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_BrandNameList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < BrandNameList.size(); ++u32Idx)
         BrandNameList[u32Idx].vDestroy();
   BrandNameList.clear();
   }
}

midw_ext_fi_tcl_BrandNameList::midw_ext_fi_tcl_BrandNameList()

 {}

tS32 midw_ext_fi_tcl_BrandNameList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_BRANDNAMELIST;
}


midw_ext_fi_tcl_BrandNameList::~midw_ext_fi_tcl_BrandNameList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_BrandNameList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < BrandNameList.size(); ++u32ListIdx)
      u32DynamicSize += BrandNameList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_BrandNameList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BrandNameList.size(); ++u32Idx)
      {
         BrandNameList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      BrandNameList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> BrandNameList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_BrandNameList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)BrandNameList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < BrandNameList.size(); ++u32Idx)
         (tVoid) (oOut << BrandNameList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_BrandNameList::operator==(const midw_ext_fi_tcl_BrandNameList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (BrandNameList.size() == roRef.BrandNameList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BrandNameList.size()); ++u32Idx)
            bResult = bResult && (BrandNameList[u32Idx] == roRef.BrandNameList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_FuelTypeList::midw_ext_fi_tcl_FuelTypeList(const midw_ext_fi_tcl_FuelTypeList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   TypeNameList = coRef.TypeNameList;
}
midw_ext_fi_tcl_FuelTypeList& midw_ext_fi_tcl_FuelTypeList::operator=(const midw_ext_fi_tcl_FuelTypeList& coRef)
{
   if (this == &coRef) return *this;
   TypeNameList = coRef.TypeNameList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_FuelTypeList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TypeNameList.size(); ++u32Idx)
         TypeNameList[u32Idx].vDestroy();
   TypeNameList.clear();
   }
}

midw_ext_fi_tcl_FuelTypeList::midw_ext_fi_tcl_FuelTypeList()

 {}

tS32 midw_ext_fi_tcl_FuelTypeList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_FUELTYPELIST;
}


midw_ext_fi_tcl_FuelTypeList::~midw_ext_fi_tcl_FuelTypeList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_FuelTypeList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TypeNameList.size(); ++u32ListIdx)
      u32DynamicSize += TypeNameList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_FuelTypeList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TypeNameList.size(); ++u32Idx)
      {
         TypeNameList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TypeNameList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TypeNameList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_FuelTypeList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TypeNameList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TypeNameList.size(); ++u32Idx)
         (tVoid) (oOut << TypeNameList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_FuelTypeList::operator==(const midw_ext_fi_tcl_FuelTypeList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TypeNameList.size() == roRef.TypeNameList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TypeNameList.size()); ++u32Idx)
            bResult = bResult && (TypeNameList[u32Idx] == roRef.TypeNameList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_TheatreAmenities::midw_ext_fi_tcl_e8_TheatreAmenities():enType(FI_EN_THEATRE_AMENITIES_STADIUM_SEATING) {}

tS32 midw_ext_fi_tcl_e8_TheatreAmenities::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8_THEATREAMENITIES;
}


midw_ext_fi_tcl_e8_TheatreAmenities::~midw_ext_fi_tcl_e8_TheatreAmenities()
{}

tU32 midw_ext_fi_tcl_e8_TheatreAmenities::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8_TheatreAmenities::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8_TheatreAmenities::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TheatreInfo::midw_ext_fi_tcl_TheatreInfo(const midw_ext_fi_tcl_TheatreInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Theater_LOCID = coRef.Theater_LOCID;
   TheatreName = coRef.TheatreName;
   TheaterCity = coRef.TheaterCity;
   Distance = coRef.Distance;
   TheaterLocation = coRef.TheaterLocation;
}
midw_ext_fi_tcl_TheatreInfo& midw_ext_fi_tcl_TheatreInfo::operator=(const midw_ext_fi_tcl_TheatreInfo& coRef)
{
   if (this == &coRef) return *this;
   Theater_LOCID = coRef.Theater_LOCID;
   TheatreName = coRef.TheatreName;
   TheaterCity = coRef.TheaterCity;
   Distance = coRef.Distance;
   TheaterLocation = coRef.TheaterLocation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TheatreInfo::vDestroy()
{
   TheatreName.vDestroy();
   TheaterCity.vDestroy();
   TheaterLocation.vDestroy(); 
}

midw_ext_fi_tcl_TheatreInfo::midw_ext_fi_tcl_TheatreInfo()
:Theater_LOCID(0)
,TheatreName()
,TheaterCity()
,Distance(0)
,TheaterLocation()
 {}

tS32 midw_ext_fi_tcl_TheatreInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_THEATREINFO;
}


midw_ext_fi_tcl_TheatreInfo::~midw_ext_fi_tcl_TheatreInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TheatreInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 20+TheatreName.u32GetSize(u16MajorVersion)+TheaterCity.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_TheatreInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Theater_LOCID);
   (tVoid) (oIn >> TheatreName);
   (tVoid) (oIn >> TheaterCity);
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> TheaterLocation);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TheatreInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Theater_LOCID);
   (tVoid) (oOut << TheatreName);
   (tVoid) (oOut << TheaterCity);
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << TheaterLocation);
   return oOut;
}

tBool midw_ext_fi_tcl_TheatreInfo::operator==(const midw_ext_fi_tcl_TheatreInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Theater_LOCID == roRef.Theater_LOCID);
   bResult = bResult && (TheatreName == roRef.TheatreName);
   bResult = bResult && (TheaterCity == roRef.TheaterCity);
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (TheaterLocation == roRef.TheaterLocation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_MovieInfo::midw_ext_fi_tcl_MovieInfo(const midw_ext_fi_tcl_MovieInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   MOVIE_ID = coRef.MOVIE_ID;
   MovieName = coRef.MovieName;
   MovieRating = coRef.MovieRating;
}
midw_ext_fi_tcl_MovieInfo& midw_ext_fi_tcl_MovieInfo::operator=(const midw_ext_fi_tcl_MovieInfo& coRef)
{
   if (this == &coRef) return *this;
   MOVIE_ID = coRef.MOVIE_ID;
   MovieName = coRef.MovieName;
   MovieRating = coRef.MovieRating;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_MovieInfo::vDestroy()
{
   MovieName.vDestroy();
   MovieRating.vDestroy();
}

midw_ext_fi_tcl_MovieInfo::midw_ext_fi_tcl_MovieInfo()
:MOVIE_ID(0)
,MovieName()
,MovieRating()
 {}

tS32 midw_ext_fi_tcl_MovieInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_MOVIEINFO;
}


midw_ext_fi_tcl_MovieInfo::~midw_ext_fi_tcl_MovieInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_MovieInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+MovieName.u32GetSize(u16MajorVersion)+MovieRating.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_MovieInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MOVIE_ID);
   (tVoid) (oIn >> MovieName);
   (tVoid) (oIn >> MovieRating);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_MovieInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MOVIE_ID);
   (tVoid) (oOut << MovieName);
   (tVoid) (oOut << MovieRating);
   return oOut;
}

tBool midw_ext_fi_tcl_MovieInfo::operator==(const midw_ext_fi_tcl_MovieInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MOVIE_ID == roRef.MOVIE_ID);
   bResult = bResult && (MovieName == roRef.MovieName);
   bResult = bResult && (MovieRating == roRef.MovieRating);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TheatreDetails::midw_ext_fi_tcl_TheatreDetails(const midw_ext_fi_tcl_TheatreDetails& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Theater_LOCID = coRef.Theater_LOCID;
   TheatreName = coRef.TheatreName;
   TheatreStreetNum = coRef.TheatreStreetNum;
   TheatreStreetName = coRef.TheatreStreetName;
   TheatreCity = coRef.TheatreCity;
   TheatreState = coRef.TheatreState;
   TheatreZip = coRef.TheatreZip;
   TheatrePhone = coRef.TheatrePhone;
   isTheaterFavorite = coRef.isTheaterFavorite;
   TheaterLocation = coRef.TheaterLocation;
   TheaterAmenities = coRef.TheaterAmenities;
}
midw_ext_fi_tcl_TheatreDetails& midw_ext_fi_tcl_TheatreDetails::operator=(const midw_ext_fi_tcl_TheatreDetails& coRef)
{
   if (this == &coRef) return *this;
   Theater_LOCID = coRef.Theater_LOCID;
   TheatreName = coRef.TheatreName;
   TheatreStreetNum = coRef.TheatreStreetNum;
   TheatreStreetName = coRef.TheatreStreetName;
   TheatreCity = coRef.TheatreCity;
   TheatreState = coRef.TheatreState;
   TheatreZip = coRef.TheatreZip;
   TheatrePhone = coRef.TheatrePhone;
   isTheaterFavorite = coRef.isTheaterFavorite;
   TheaterLocation = coRef.TheaterLocation;
   TheaterAmenities = coRef.TheaterAmenities;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TheatreDetails::vDestroy()
{
   TheatreName.vDestroy();
   TheatreStreetNum.vDestroy();
   TheatreStreetName.vDestroy();
   TheatreCity.vDestroy();
   TheatreState.vDestroy();
   TheatreZip.vDestroy();
   TheatrePhone.vDestroy();
   TheaterLocation.vDestroy(); 
   {
   TheaterAmenities.clear();
   }
}

midw_ext_fi_tcl_TheatreDetails::midw_ext_fi_tcl_TheatreDetails()
:Theater_LOCID(0)
,TheatreName()
,TheatreStreetNum()
,TheatreStreetName()
,TheatreCity()
,TheatreState()
,TheatreZip()
,TheatrePhone()
,isTheaterFavorite(0)
,TheaterLocation()

 {}

tS32 midw_ext_fi_tcl_TheatreDetails::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_THEATREDETAILS;
}


midw_ext_fi_tcl_TheatreDetails::~midw_ext_fi_tcl_TheatreDetails()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TheatreDetails::u32GetSize(tU16 u16MajorVersion) const
{
   return 21+TheatreName.u32GetSize(u16MajorVersion)+TheatreStreetNum.u32GetSize(u16MajorVersion)+TheatreStreetName.u32GetSize(u16MajorVersion)+TheatreCity.u32GetSize(u16MajorVersion)+TheatreState.u32GetSize(u16MajorVersion)+TheatreZip.u32GetSize(u16MajorVersion)+TheatrePhone.u32GetSize(u16MajorVersion)+ static_cast<tU32>(TheaterAmenities.size()*1);
}

fi_tclInContext& midw_ext_fi_tcl_TheatreDetails::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Theater_LOCID);
   (tVoid) (oIn >> TheatreName);
   (tVoid) (oIn >> TheatreStreetNum);
   (tVoid) (oIn >> TheatreStreetName);
   (tVoid) (oIn >> TheatreCity);
   (tVoid) (oIn >> TheatreState);
   (tVoid) (oIn >> TheatreZip);
   (tVoid) (oIn >> TheatrePhone);
   (tVoid) (oIn >> isTheaterFavorite);
   (tVoid) (oIn >> TheaterLocation);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      TheaterAmenities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TheaterAmenities[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TheatreDetails::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Theater_LOCID);
   (tVoid) (oOut << TheatreName);
   (tVoid) (oOut << TheatreStreetNum);
   (tVoid) (oOut << TheatreStreetName);
   (tVoid) (oOut << TheatreCity);
   (tVoid) (oOut << TheatreState);
   (tVoid) (oOut << TheatreZip);
   (tVoid) (oOut << TheatrePhone);
   (tVoid) (oOut << isTheaterFavorite);
   (tVoid) (oOut << TheaterLocation);
   (tVoid) (oOut << (tU32)TheaterAmenities.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TheaterAmenities.size(); ++u32Idx)
         (tVoid) (oOut << TheaterAmenities[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_TheatreDetails::operator==(const midw_ext_fi_tcl_TheatreDetails& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Theater_LOCID == roRef.Theater_LOCID);
   bResult = bResult && (TheatreName == roRef.TheatreName);
   bResult = bResult && (TheatreStreetNum == roRef.TheatreStreetNum);
   bResult = bResult && (TheatreStreetName == roRef.TheatreStreetName);
   bResult = bResult && (TheatreCity == roRef.TheatreCity);
   bResult = bResult && (TheatreState == roRef.TheatreState);
   bResult = bResult && (TheatreZip == roRef.TheatreZip);
   bResult = bResult && (TheatrePhone == roRef.TheatrePhone);
   bResult = bResult && (isTheaterFavorite == roRef.isTheaterFavorite);
   bResult = bResult && (TheaterLocation == roRef.TheaterLocation);
      bResult = bResult && (TheaterAmenities.size() == roRef.TheaterAmenities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TheaterAmenities.size()); ++u32Idx)
            bResult = bResult && (TheaterAmenities[u32Idx] == roRef.TheaterAmenities[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_ShowDate::midw_ext_fi_tcl_ShowDate(const midw_ext_fi_tcl_ShowDate& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Date = coRef.Date;
   Month = coRef.Month;
   Year = coRef.Year;
}
midw_ext_fi_tcl_ShowDate& midw_ext_fi_tcl_ShowDate::operator=(const midw_ext_fi_tcl_ShowDate& coRef)
{
   if (this == &coRef) return *this;
   Date = coRef.Date;
   Month = coRef.Month;
   Year = coRef.Year;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_ShowDate::midw_ext_fi_tcl_ShowDate()
:Date(0)
,Month(0)
,Year(0)
 {}

tS32 midw_ext_fi_tcl_ShowDate::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SHOWDATE;
}


midw_ext_fi_tcl_ShowDate::~midw_ext_fi_tcl_ShowDate()
{}

tU32 midw_ext_fi_tcl_ShowDate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_fi_tcl_ShowDate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Date);
   (tVoid) (oIn >> Month);
   (tVoid) (oIn >> Year);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_ShowDate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Date);
   (tVoid) (oOut << Month);
   (tVoid) (oOut << Year);
   return oOut;
}

tBool midw_ext_fi_tcl_ShowDate::operator==(const midw_ext_fi_tcl_ShowDate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Date == roRef.Date);
   bResult = bResult && (Month == roRef.Month);
   bResult = bResult && (Year == roRef.Year);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_TheatreInfoList::midw_ext_fi_tcl_TheatreInfoList(const midw_ext_fi_tcl_TheatreInfoList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   TheatreInfolist = coRef.TheatreInfolist;
}
midw_ext_fi_tcl_TheatreInfoList& midw_ext_fi_tcl_TheatreInfoList::operator=(const midw_ext_fi_tcl_TheatreInfoList& coRef)
{
   if (this == &coRef) return *this;
   TheatreInfolist = coRef.TheatreInfolist;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_TheatreInfoList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TheatreInfolist.size(); ++u32Idx)
         TheatreInfolist[u32Idx].vDestroy();
   TheatreInfolist.clear();
   }
}

midw_ext_fi_tcl_TheatreInfoList::midw_ext_fi_tcl_TheatreInfoList()

 {}

tS32 midw_ext_fi_tcl_TheatreInfoList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_THEATREINFOLIST;
}


midw_ext_fi_tcl_TheatreInfoList::~midw_ext_fi_tcl_TheatreInfoList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_TheatreInfoList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TheatreInfolist.size(); ++u32ListIdx)
      u32DynamicSize += TheatreInfolist[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_TheatreInfoList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TheatreInfolist.size(); ++u32Idx)
      {
         TheatreInfolist[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TheatreInfolist.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TheatreInfolist[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_TheatreInfoList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TheatreInfolist.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TheatreInfolist.size(); ++u32Idx)
         (tVoid) (oOut << TheatreInfolist[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_TheatreInfoList::operator==(const midw_ext_fi_tcl_TheatreInfoList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TheatreInfolist.size() == roRef.TheatreInfolist.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TheatreInfolist.size()); ++u32Idx)
            bResult = bResult && (TheatreInfolist[u32Idx] == roRef.TheatreInfolist[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_MoviesList::midw_ext_fi_tcl_MoviesList(const midw_ext_fi_tcl_MoviesList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   MoviesList = coRef.MoviesList;
}
midw_ext_fi_tcl_MoviesList& midw_ext_fi_tcl_MoviesList::operator=(const midw_ext_fi_tcl_MoviesList& coRef)
{
   if (this == &coRef) return *this;
   MoviesList = coRef.MoviesList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_MoviesList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MoviesList.size(); ++u32Idx)
         MoviesList[u32Idx].vDestroy();
   MoviesList.clear();
   }
}

midw_ext_fi_tcl_MoviesList::midw_ext_fi_tcl_MoviesList()

 {}

tS32 midw_ext_fi_tcl_MoviesList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_MOVIESLIST;
}


midw_ext_fi_tcl_MoviesList::~midw_ext_fi_tcl_MoviesList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_MoviesList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < MoviesList.size(); ++u32ListIdx)
      u32DynamicSize += MoviesList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_MoviesList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MoviesList.size(); ++u32Idx)
      {
         MoviesList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      MoviesList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MoviesList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_MoviesList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)MoviesList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MoviesList.size(); ++u32Idx)
         (tVoid) (oOut << MoviesList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_MoviesList::operator==(const midw_ext_fi_tcl_MoviesList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (MoviesList.size() == roRef.MoviesList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MoviesList.size()); ++u32Idx)
            bResult = bResult && (MoviesList[u32Idx] == roRef.MoviesList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_ShowTimes::midw_ext_fi_tcl_ShowTimes(const midw_ext_fi_tcl_ShowTimes& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   Hour = coRef.Hour;
   Minutes = coRef.Minutes;
}
midw_ext_fi_tcl_ShowTimes& midw_ext_fi_tcl_ShowTimes::operator=(const midw_ext_fi_tcl_ShowTimes& coRef)
{
   if (this == &coRef) return *this;
   Hour = coRef.Hour;
   Minutes = coRef.Minutes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_ShowTimes::midw_ext_fi_tcl_ShowTimes()
:Hour(0)
,Minutes(0)
 {}

tS32 midw_ext_fi_tcl_ShowTimes::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SHOWTIMES;
}


midw_ext_fi_tcl_ShowTimes::~midw_ext_fi_tcl_ShowTimes()
{}

tU32 midw_ext_fi_tcl_ShowTimes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_fi_tcl_ShowTimes::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Hour);
   (tVoid) (oIn >> Minutes);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_ShowTimes::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Hour);
   (tVoid) (oOut << Minutes);
   return oOut;
}

tBool midw_ext_fi_tcl_ShowTimes::operator==(const midw_ext_fi_tcl_ShowTimes& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Hour == roRef.Hour);
   bResult = bResult && (Minutes == roRef.Minutes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_MovieTimes::midw_ext_fi_tcl_MovieTimes(const midw_ext_fi_tcl_MovieTimes& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   ShowDate = coRef.ShowDate;
   ShowTimes = coRef.ShowTimes;
}
midw_ext_fi_tcl_MovieTimes& midw_ext_fi_tcl_MovieTimes::operator=(const midw_ext_fi_tcl_MovieTimes& coRef)
{
   if (this == &coRef) return *this;
   ShowDate = coRef.ShowDate;
   ShowTimes = coRef.ShowTimes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_MovieTimes::vDestroy()
{
   ShowDate.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < ShowTimes.size(); ++u32Idx)
         ShowTimes[u32Idx].vDestroy();
   ShowTimes.clear();
   }
}

midw_ext_fi_tcl_MovieTimes::midw_ext_fi_tcl_MovieTimes()
:ShowDate()

 {}

tS32 midw_ext_fi_tcl_MovieTimes::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_MOVIETIMES;
}


midw_ext_fi_tcl_MovieTimes::~midw_ext_fi_tcl_MovieTimes()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_MovieTimes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12+ static_cast<tU32>(ShowTimes.size()*4);
}

fi_tclInContext& midw_ext_fi_tcl_MovieTimes::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ShowDate);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ShowTimes.size(); ++u32Idx)
      {
         ShowTimes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ShowTimes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ShowTimes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_MovieTimes::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ShowDate);
   (tVoid) (oOut << (tU32)ShowTimes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ShowTimes.size(); ++u32Idx)
         (tVoid) (oOut << ShowTimes[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_MovieTimes::operator==(const midw_ext_fi_tcl_MovieTimes& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ShowDate == roRef.ShowDate);
      bResult = bResult && (ShowTimes.size() == roRef.ShowTimes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ShowTimes.size()); ++u32Idx)
            bResult = bResult && (ShowTimes[u32Idx] == roRef.ShowTimes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_MovieTimesList::midw_ext_fi_tcl_MovieTimesList(const midw_ext_fi_tcl_MovieTimesList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   MovieTimes = coRef.MovieTimes;
}
midw_ext_fi_tcl_MovieTimesList& midw_ext_fi_tcl_MovieTimesList::operator=(const midw_ext_fi_tcl_MovieTimesList& coRef)
{
   if (this == &coRef) return *this;
   MovieTimes = coRef.MovieTimes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_MovieTimesList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MovieTimes.size(); ++u32Idx)
         MovieTimes[u32Idx].vDestroy();
   MovieTimes.clear();
   }
}

midw_ext_fi_tcl_MovieTimesList::midw_ext_fi_tcl_MovieTimesList()

 {}

tS32 midw_ext_fi_tcl_MovieTimesList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_MOVIETIMESLIST;
}


midw_ext_fi_tcl_MovieTimesList::~midw_ext_fi_tcl_MovieTimesList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_MovieTimesList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < MovieTimes.size(); ++u32ListIdx)
      u32DynamicSize += MovieTimes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_MovieTimesList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MovieTimes.size(); ++u32Idx)
      {
         MovieTimes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      MovieTimes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MovieTimes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_MovieTimesList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)MovieTimes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MovieTimes.size(); ++u32Idx)
         (tVoid) (oOut << MovieTimes[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_MovieTimesList::operator==(const midw_ext_fi_tcl_MovieTimesList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (MovieTimes.size() == roRef.MovieTimes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MovieTimes.size()); ++u32Idx)
            bResult = bResult && (MovieTimes[u32Idx] == roRef.MovieTimes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_MovieDetails::midw_ext_fi_tcl_MovieDetails(const midw_ext_fi_tcl_MovieDetails& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   MOVIE_ID = coRef.MOVIE_ID;
   MovieName = coRef.MovieName;
   MovieRating = coRef.MovieRating;
   sMovieLength = coRef.sMovieLength;
   MovieActors = coRef.MovieActors;
   MovieSummury = coRef.MovieSummury;
   MovieTimesList = coRef.MovieTimesList;
}
midw_ext_fi_tcl_MovieDetails& midw_ext_fi_tcl_MovieDetails::operator=(const midw_ext_fi_tcl_MovieDetails& coRef)
{
   if (this == &coRef) return *this;
   MOVIE_ID = coRef.MOVIE_ID;
   MovieName = coRef.MovieName;
   MovieRating = coRef.MovieRating;
   sMovieLength = coRef.sMovieLength;
   MovieActors = coRef.MovieActors;
   MovieSummury = coRef.MovieSummury;
   MovieTimesList = coRef.MovieTimesList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_MovieDetails::vDestroy()
{
   MovieName.vDestroy();
   MovieRating.vDestroy();
   sMovieLength.vDestroy();
   MovieActors.vDestroy();
   MovieSummury.vDestroy();
   MovieTimesList.vDestroy(); 
}

midw_ext_fi_tcl_MovieDetails::midw_ext_fi_tcl_MovieDetails()
:MOVIE_ID(0)
,MovieName()
,MovieRating()
,sMovieLength()
,MovieActors()
,MovieSummury()
,MovieTimesList()
 {}

tS32 midw_ext_fi_tcl_MovieDetails::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_MOVIEDETAILS;
}


midw_ext_fi_tcl_MovieDetails::~midw_ext_fi_tcl_MovieDetails()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_MovieDetails::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+MovieName.u32GetSize(u16MajorVersion)+MovieRating.u32GetSize(u16MajorVersion)+sMovieLength.u32GetSize(u16MajorVersion)+MovieActors.u32GetSize(u16MajorVersion)+MovieSummury.u32GetSize(u16MajorVersion)+MovieTimesList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_MovieDetails::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MOVIE_ID);
   (tVoid) (oIn >> MovieName);
   (tVoid) (oIn >> MovieRating);
   (tVoid) (oIn >> sMovieLength);
   (tVoid) (oIn >> MovieActors);
   (tVoid) (oIn >> MovieSummury);
   (tVoid) (oIn >> MovieTimesList);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_MovieDetails::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MOVIE_ID);
   (tVoid) (oOut << MovieName);
   (tVoid) (oOut << MovieRating);
   (tVoid) (oOut << sMovieLength);
   (tVoid) (oOut << MovieActors);
   (tVoid) (oOut << MovieSummury);
   (tVoid) (oOut << MovieTimesList);
   return oOut;
}

tBool midw_ext_fi_tcl_MovieDetails::operator==(const midw_ext_fi_tcl_MovieDetails& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MOVIE_ID == roRef.MOVIE_ID);
   bResult = bResult && (MovieName == roRef.MovieName);
   bResult = bResult && (MovieRating == roRef.MovieRating);
   bResult = bResult && (sMovieLength == roRef.sMovieLength);
   bResult = bResult && (MovieActors == roRef.MovieActors);
   bResult = bResult && (MovieSummury == roRef.MovieSummury);
   bResult = bResult && (MovieTimesList == roRef.MovieTimesList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8MovieErrorTypes::midw_ext_fi_tcl_e8MovieErrorTypes():enType(FI_EN_UNAVAILABLE) {}

tS32 midw_ext_fi_tcl_e8MovieErrorTypes::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_E8MOVIEERRORTYPES;
}


midw_ext_fi_tcl_e8MovieErrorTypes::~midw_ext_fi_tcl_e8MovieErrorTypes()
{}

tU32 midw_ext_fi_tcl_e8MovieErrorTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_fi_tcl_e8MovieErrorTypes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_e8MovieErrorTypes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SportInfo::midw_ext_fi_tcl_SportInfo(const midw_ext_fi_tcl_SportInfo& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   SPORT_ID = coRef.SPORT_ID;
   SportName = coRef.SportName;
}
midw_ext_fi_tcl_SportInfo& midw_ext_fi_tcl_SportInfo::operator=(const midw_ext_fi_tcl_SportInfo& coRef)
{
   if (this == &coRef) return *this;
   SPORT_ID = coRef.SPORT_ID;
   SportName = coRef.SportName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SportInfo::vDestroy()
{
   SportName.vDestroy();
}

midw_ext_fi_tcl_SportInfo::midw_ext_fi_tcl_SportInfo()
:SPORT_ID(0)
,SportName()
 {}

tS32 midw_ext_fi_tcl_SportInfo::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SPORTINFO;
}


midw_ext_fi_tcl_SportInfo::~midw_ext_fi_tcl_SportInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SportInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+SportName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_fi_tcl_SportInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SPORT_ID);
   (tVoid) (oIn >> SportName);
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SportInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SPORT_ID);
   (tVoid) (oOut << SportName);
   return oOut;
}

tBool midw_ext_fi_tcl_SportInfo::operator==(const midw_ext_fi_tcl_SportInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SPORT_ID == roRef.SPORT_ID);
   bResult = bResult && (SportName == roRef.SportName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_fi_tcl_SportList::midw_ext_fi_tcl_SportList(const midw_ext_fi_tcl_SportList& coRef)
   : midw_ext_fi_tclVisitableTypeBase(coRef)
{
   SportList = coRef.SportList;
}
midw_ext_fi_tcl_SportList& midw_ext_fi_tcl_SportList::operator=(const midw_ext_fi_tcl_SportList& coRef)
{
   if (this == &coRef) return *this;
   SportList = coRef.SportList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_fi_tcl_SportList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SportList.size(); ++u32Idx)
         SportList[u32Idx].vDestroy();
   SportList.clear();
   }
}

midw_ext_fi_tcl_SportList::midw_ext_fi_tcl_SportList()

 {}

tS32 midw_ext_fi_tcl_SportList::s32GetTypeId() const
{
   return (tS32) midw_ext_typesfi_tclToken::EN_SPORTLIST;
}


midw_ext_fi_tcl_SportList::~midw_ext_fi_tcl_SportList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_fi_tcl_SportList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SportList.size(); ++u32ListIdx)
      u32DynamicSize += SportList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_fi_tcl_SportList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SportList.size(); ++u32Idx)
      {
         SportList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SportList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SportList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_fi_tcl_SportList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SportList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SportList.size(); ++u32Idx)
         (tVoid) (oOut << SportList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_fi_tcl_SportList::operator==(const midw_ext_fi_tcl_SportList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SportList.size() == roRef.SportList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SportList.size()); ++u32Idx)
            bResult = bResult && (SportList[u32Idx] == roRef.SportList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_fi_tcl_e8_Game_Status::midw_ext_fi_tcl_e8_Game_Status():enType(FI_EN_GAME_STATUS_SCHEDULED) {}

tS32 midw_ext_fi_tcl_e8_Game_Status::s32GetTypeId() co