#ifndef MIDW_EXT_FIVISITOR_HEADER
#define MIDW_EXT_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class midw_ext_fi_tclOutput {
public:
   midw_ext_fi_tclOutput();
   virtual ~midw_ext_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class midw_ext_fi_tclFileOutput : public midw_ext_fi_tclOutput 
{
public:
   midw_ext_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   midw_ext_fi_tclFileOutput(); //lint !e1704
   midw_ext_fi_tclFileOutput& operator=(const midw_ext_fi_tclFileOutput& coRef);
   midw_ext_fi_tclFileOutput(const midw_ext_fi_tclFileOutput& coRef); //lint !e1704
};

class midw_ext_fi_tclMemOutput : public midw_ext_fi_tclOutput
{
public:
   midw_ext_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~midw_ext_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   midw_ext_fi_tclMemOutput(); //lint !e1704
   midw_ext_fi_tclMemOutput(const midw_ext_fi_tclMemOutput& coRef); //lint !e1704
   midw_ext_fi_tclMemOutput& operator=(const midw_ext_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL midw_ext_fi_tclVisitorBase {
public:

   // --Konstruktor
   midw_ext_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~midw_ext_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(midw_ext_fi_tclU8& oU8);
   virtual tVoid vVisitS8(midw_ext_fi_tclS8& oS8);
   virtual tVoid vVisitU16(midw_ext_fi_tclU16& oU16);
   virtual tVoid vVisitS16(midw_ext_fi_tclS16& oS16);
   virtual tVoid vVisitU24(midw_ext_fi_tclU24& oU24);
   virtual tVoid vVisitS24(midw_ext_fi_tclS24& oS24);
   virtual tVoid vVisitU32(midw_ext_fi_tclU32& oU32);
   virtual tVoid vVisitS32(midw_ext_fi_tclS32& oS32);
   virtual tVoid vVisitU64(midw_ext_fi_tclU64& oU64);
   virtual tVoid vVisitS64(midw_ext_fi_tclS64& oS64);
   virtual tVoid vVisitF32(midw_ext_fi_tclF32& oF32);
   virtual tVoid vVisitF64(midw_ext_fi_tclF64& oF64);
   virtual tVoid vVisitBool(midw_ext_fi_tclBool& oBool);
   virtual tVoid vVisitString(midw_ext_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(midw_ext_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(midw_ext_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(midw_ext_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(midw_ext_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(midw_ext_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(midw_ext_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(midw_ext_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(midw_ext_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(midw_ext_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(midw_ext_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(midw_ext_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(midw_ext_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(midw_ext_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(midw_ext_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(midw_ext_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(midw_ext_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(midw_ext_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(midw_ext_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(midw_ext_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(midw_ext_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(midw_ext_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(midw_ext_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(midw_ext_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(midw_ext_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(midw_ext_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(midw_ext_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(midw_ext_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(midw_ext_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(midw_ext_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(midw_ext_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(midw_ext_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(midw_ext_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(midw_ext_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(midw_ext_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(midw_ext_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(midw_ext_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(midw_ext_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(midw_ext_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(midw_ext_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(midw_ext_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(midw_ext_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(midw_ext_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(midw_ext_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(midw_ext_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(midw_ext_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(midw_ext_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(midw_ext_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e8_DAB_Response(midw_ext_fi_tcl_e8_DAB_Response& oe8_DAB_Response);

   virtual tVoid vVisit_e8_DAB_UserProfileAction(midw_ext_fi_tcl_e8_DAB_UserProfileAction& oe8_DAB_UserProfileAction);

   virtual tVoid vVisit_e8_DAB_SourceState(midw_ext_fi_tcl_e8_DAB_SourceState& oe8_DAB_SourceState);

   virtual tVoid vVisit_DAB_Label(midw_ext_fi_tcl_DAB_Label& oDAB_Label);

   virtual tVoid vVisit_e8_DAB_ServiceType(midw_ext_fi_tcl_e8_DAB_ServiceType& oe8_DAB_ServiceType);

   virtual tVoid vVisit_e8_DAB_ServiceListSortingType(midw_ext_fi_tcl_e8_DAB_ServiceListSortingType& oe8_DAB_ServiceListSortingType);

   virtual tVoid vVisit_e8_DAB_EnsembleListSortingType(midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType& oe8_DAB_EnsembleListSortingType);

   virtual tVoid vVisit_e8_DAB_AST_Type(midw_ext_fi_tcl_e8_DAB_AST_Type& oe8_DAB_AST_Type);

   virtual tVoid vVisit_e8_DAB_ServiceLinkingMode(midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode& oe8_DAB_ServiceLinkingMode);

   virtual tVoid vVisit_b8_DAB_MTC_SetMode(midw_ext_fi_tcl_b8_DAB_MTC_SetMode& ob8_DAB_MTC_SetMode);

   virtual tVoid vVisit_e8_MTC_Request(midw_ext_fi_tcl_e8_MTC_Request& oe8_MTC_Request);

   virtual tVoid vVisit_e8_MTC_Tuner_Status(midw_ext_fi_tcl_e8_MTC_Tuner_Status& oe8_MTC_Tuner_Status);

   virtual tVoid vVisit_e8_MTC_Tuner_ActivityState(midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState& oe8_MTC_Tuner_ActivityState);

   virtual tVoid vVisit_e8_StationType(midw_ext_fi_tcl_e8_StationType& oe8_StationType);

   virtual tVoid vVisit_e8_TPState(midw_ext_fi_tcl_e8_TPState& oe8_TPState);

   virtual tVoid vVisit_e8_DAB_SampleRate(midw_ext_fi_tcl_e8_DAB_SampleRate& oe8_DAB_SampleRate);

   virtual tVoid vVisit_e8_DAB_AudioMode(midw_ext_fi_tcl_e8_DAB_AudioMode& oe8_DAB_AudioMode);

   virtual tVoid vVisit_e8_DAB_AudioCodec(midw_ext_fi_tcl_e8_DAB_AudioCodec& oe8_DAB_AudioCodec);

   virtual tVoid vVisit_e8_DAB_Encoding(midw_ext_fi_tcl_e8_DAB_Encoding& oe8_DAB_Encoding);

   virtual tVoid vVisit_e8_DAB_ComponentType(midw_ext_fi_tcl_e8_DAB_ComponentType& oe8_DAB_ComponentType);

   virtual tVoid vVisit_e8_DAB_TMIdType(midw_ext_fi_tcl_e8_DAB_TMIdType& oe8_DAB_TMIdType);

   virtual tVoid vVisit_e8_DAB_AudioServiceComponentType(midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType& oe8_DAB_AudioServiceComponentType);

   virtual tVoid vVisit_e8_DAB_DataServiceComponentType(midw_ext_fi_tcl_e8_DAB_DataServiceComponentType& oe8_DAB_DataServiceComponentType);

   virtual tVoid vVisit_b16_DAB_AnnouncementType(midw_ext_fi_tcl_b16_DAB_AnnouncementType& ob16_DAB_AnnouncementType);

   virtual tVoid vVisit_e8_DAB_AnnouncementSelectState(midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState& oe8_DAB_AnnouncementSelectState);

   virtual tVoid vVisit_e8_DAB_AnnouncementStatus(midw_ext_fi_tcl_e8_DAB_AnnouncementStatus& oe8_DAB_AnnouncementStatus);

   virtual tVoid vVisit_e8_DAB_AnnouncementSource(midw_ext_fi_tcl_e8_DAB_AnnouncementSource& oe8_DAB_AnnouncementSource);

   virtual tVoid vVisit_e8_DAB_ChnSelectMode(midw_ext_fi_tcl_e8_DAB_ChnSelectMode& oe8_DAB_ChnSelectMode);

   virtual tVoid vVisit_e8_DAB_EnsSelectMode(midw_ext_fi_tcl_e8_DAB_EnsSelectMode& oe8_DAB_EnsSelectMode);

   virtual tVoid vVisit_e8_DAB_CompSelectMode(midw_ext_fi_tcl_e8_DAB_CompSelectMode& oe8_DAB_CompSelectMode);

   virtual tVoid vVisit_e8_DAB_UriSelectState(midw_ext_fi_tcl_e8_DAB_UriSelectState& oe8_DAB_UriSelectState);

   virtual tVoid vVisit_e8_DAB_TunerActivityType(midw_ext_fi_tcl_e8_DAB_TunerActivityType& oe8_DAB_TunerActivityType);

   virtual tVoid vVisit_DAB_Frequency(midw_ext_fi_tcl_DAB_Frequency& oDAB_Frequency);

   virtual tVoid vVisit_e8_DAB_FrequencyTable(midw_ext_fi_tcl_e8_DAB_FrequencyTable& oe8_DAB_FrequencyTable);

   virtual tVoid vVisit_b16_DAB_TunerStatusFlags(midw_ext_fi_tcl_b16_DAB_TunerStatusFlags& ob16_DAB_TunerStatusFlags);

   virtual tVoid vVisit_DAB_TunerStatus(midw_ext_fi_tcl_DAB_TunerStatus& oDAB_TunerStatus);

   virtual tVoid vVisit_DAB_RadioText(midw_ext_fi_tcl_DAB_RadioText& oDAB_RadioText);

   virtual tVoid vVisit_DAB_RadioTextPlus(midw_ext_fi_tcl_DAB_RadioTextPlus& oDAB_RadioTextPlus);

   virtual tVoid vVisit_DAB_EnsembleInfo(midw_ext_fi_tcl_DAB_EnsembleInfo& oDAB_EnsembleInfo);

   virtual tVoid vVisit_b8_DAB_ServiceInfoFlags(midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags& ob8_DAB_ServiceInfoFlags);

   virtual tVoid vVisit_DAB_ServiceInfo(midw_ext_fi_tcl_DAB_ServiceInfo& oDAB_ServiceInfo);

   virtual tVoid vVisit_e8_DAB_ChannelInfoState(midw_ext_fi_tcl_e8_DAB_ChannelInfoState& oe8_DAB_ChannelInfoState);

   virtual tVoid vVisit_DAB_ChannelInfo(midw_ext_fi_tcl_DAB_ChannelInfo& oDAB_ChannelInfo);

   virtual tVoid vVisit_DAB_ComponentInfo(midw_ext_fi_tcl_DAB_ComponentInfo& oDAB_ComponentInfo);

   virtual tVoid vVisit_DAB_AnnoConfig(midw_ext_fi_tcl_DAB_AnnoConfig& oDAB_AnnoConfig);

   virtual tVoid vVisit_DAB_AnnoElement(midw_ext_fi_tcl_DAB_AnnoElement& oDAB_AnnoElement);

   virtual tVoid vVisit_DAB_AnnoStatus(midw_ext_fi_tcl_DAB_AnnoStatus& oDAB_AnnoStatus);

   virtual tVoid vVisit_DAB_ADRMsg(midw_ext_fi_tcl_DAB_ADRMsg& oDAB_ADRMsg);

   virtual tVoid vVisit_DAB_LogoElement(midw_ext_fi_tcl_DAB_LogoElement& oDAB_LogoElement);

   virtual tVoid vVisit_DAB_ContentID(midw_ext_fi_tcl_DAB_ContentID& oDAB_ContentID);

   virtual tVoid vVisit_e8_DAB_TuneType(midw_ext_fi_tcl_e8_DAB_TuneType& oe8_DAB_TuneType);

   virtual tVoid vVisit_DAB_TuneParam(midw_ext_fi_tcl_DAB_TuneParam& oDAB_TuneParam);

   virtual tVoid vVisit_e8_DAB_LearnType(midw_ext_fi_tcl_e8_DAB_LearnType& oe8_DAB_LearnType);

   virtual tVoid vVisit_DAB_LearnParam(midw_ext_fi_tcl_DAB_LearnParam& oDAB_LearnParam);

   virtual tVoid vVisit_b32_DAB_SetupMask(midw_ext_fi_tcl_b32_DAB_SetupMask& ob32_DAB_SetupMask);

   virtual tVoid vVisit_b32_DAB_SetupFlags(midw_ext_fi_tcl_b32_DAB_SetupFlags& ob32_DAB_SetupFlags);

   virtual tVoid vVisit_b8_DAB_LinkingSetupMask(midw_ext_fi_tcl_b8_DAB_LinkingSetupMask& ob8_DAB_LinkingSetupMask);

   virtual tVoid vVisit_e8_DAB_SwitchTuner(midw_ext_fi_tcl_e8_DAB_SwitchTuner& oe8_DAB_SwitchTuner);

   virtual tVoid vVisit_e8_DAB_ServiceFollowingTuner(midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner& oe8_DAB_ServiceFollowingTuner);

   virtual tVoid vVisit_e8_DAB_MuteStatus(midw_ext_fi_tcl_e8_DAB_MuteStatus& oe8_DAB_MuteStatus);

   virtual tVoid vVisit_e8_DAB_Source(midw_ext_fi_tcl_e8_DAB_Source& oe8_DAB_Source);

   virtual tVoid vVisit_b8_DAB_ExtServFollowingFlags(midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags& ob8_DAB_ExtServFollowingFlags);

   virtual tVoid vVisit_e8_DAB_DeleteAction(midw_ext_fi_tcl_e8_DAB_DeleteAction& oe8_DAB_DeleteAction);

   virtual tVoid vVisit_DAB_PresetListElement(midw_ext_fi_tcl_DAB_PresetListElement& oDAB_PresetListElement);

   virtual tVoid vVisit_e8_DAB_ListOperation(midw_ext_fi_tcl_e8_DAB_ListOperation& oe8_DAB_ListOperation);

   virtual tVoid vVisit_e8_DAB_ServiceListType(midw_ext_fi_tcl_e8_DAB_ServiceListType& oe8_DAB_ServiceListType);

   virtual tVoid vVisit_DAB_ChnListElement(midw_ext_fi_tcl_DAB_ChnListElement& oDAB_ChnListElement);

   virtual tVoid vVisit_DAB_ListElementAvailInfo(midw_ext_fi_tcl_DAB_ListElementAvailInfo& oDAB_ListElementAvailInfo);

   virtual tVoid vVisit_DAB_TIIListElement(midw_ext_fi_tcl_DAB_TIIListElement& oDAB_TIIListElement);

   virtual tVoid vVisit_e8_DAB_BankList(midw_ext_fi_tcl_e8_DAB_BankList& oe8_DAB_BankList);

   virtual tVoid vVisit_e8_DAB_TestOperation(midw_ext_fi_tcl_e8_DAB_TestOperation& oe8_DAB_TestOperation);

   virtual tVoid vVisit_e8_DAB_ManualMode_TuneOperation(midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation& oe8_DAB_ManualMode_TuneOperation);

   virtual tVoid vVisit_b8_DAB_TestMode_Flags(midw_ext_fi_tcl_b8_DAB_TestMode_Flags& ob8_DAB_TestMode_Flags);

   virtual tVoid vVisit_b8_DAB_ALT_FM_Valid_Flags(midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags& ob8_DAB_ALT_FM_Valid_Flags);

   virtual tVoid vVisit_e8_DAB_LinkType(midw_ext_fi_tcl_e8_DAB_LinkType& oe8_DAB_LinkType);

   virtual tVoid vVisit_DAB_BG_TestModeData(midw_ext_fi_tcl_DAB_BG_TestModeData& oDAB_BG_TestModeData);

   virtual tVoid vVisit_DAB_Time(midw_ext_fi_tcl_DAB_Time& oDAB_Time);

   virtual tVoid vVisit_DAB_TMC_TPEG_TestModeData(midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData& oDAB_TMC_TPEG_TestModeData);

   virtual tVoid vVisit_DAB_LinkListElem(midw_ext_fi_tcl_DAB_LinkListElem& oDAB_LinkListElem);

   virtual tVoid vVisit_DAB_AltFreqInfo(midw_ext_fi_tcl_DAB_AltFreqInfo& oDAB_AltFreqInfo);

   virtual tVoid vVisit_DAB_TestModeData(midw_ext_fi_tcl_DAB_TestModeData& oDAB_TestModeData);

   virtual tVoid vVisit_DAB_RdbId(midw_ext_fi_tcl_DAB_RdbId& oDAB_RdbId);

   virtual tVoid vVisit_DAB_TmcData(midw_ext_fi_tcl_DAB_TmcData& oDAB_TmcData);

   virtual tVoid vVisit_DAB_Encryption(midw_ext_fi_tcl_DAB_Encryption& oDAB_Encryption);

   virtual tVoid vVisit_e8_DAB_TmcMediumType(midw_ext_fi_tcl_e8_DAB_TmcMediumType& oe8_DAB_TmcMediumType);

   virtual tVoid vVisit_e8_DAB_TuneCmd(midw_ext_fi_tcl_e8_DAB_TuneCmd& oe8_DAB_TuneCmd);

   virtual tVoid vVisit_DAB_MsgSource(midw_ext_fi_tcl_DAB_MsgSource& oDAB_MsgSource);

   virtual tVoid vVisit_DAB_TmcInfo(midw_ext_fi_tcl_DAB_TmcInfo& oDAB_TmcInfo);

   virtual tVoid vVisit_DAB_EnsembleTmcInfo(midw_ext_fi_tcl_DAB_EnsembleTmcInfo& oDAB_EnsembleTmcInfo);

   virtual tVoid vVisit_DAB_TpegInfo(midw_ext_fi_tcl_DAB_TpegInfo& oDAB_TpegInfo);

   virtual tVoid vVisit_DAB_TpegUriChannel(midw_ext_fi_tcl_DAB_TpegUriChannel& oDAB_TpegUriChannel);

   virtual tVoid vVisit_e8_DefSetMode(midw_ext_fi_tcl_e8_DefSetMode& oe8_DefSetMode);

   virtual tVoid vVisit_e8_DefSetServiceStatus(midw_ext_fi_tcl_e8_DefSetServiceStatus& oe8_DefSetServiceStatus);

   virtual tVoid vVisit_e8_DefSetGroups(midw_ext_fi_tcl_e8_DefSetGroups& oe8_DefSetGroups);

   virtual tVoid vVisit_e8_RCtrlSource(midw_ext_fi_tcl_e8_RCtrlSource& oe8_RCtrlSource);

   virtual tVoid vVisit_e8_RCtrlCommand(midw_ext_fi_tcl_e8_RCtrlCommand& oe8_RCtrlCommand);

   virtual tVoid vVisit_e8_RCtrlSignal(midw_ext_fi_tcl_e8_RCtrlSignal& oe8_RCtrlSignal);

   virtual tVoid vVisit_e8_PHN_VAG_CCAError(midw_ext_fi_tcl_e8_PHN_VAG_CCAError& oe8_PHN_VAG_CCAError);

   virtual tVoid vVisit_e8_PHN_VAG_PhoneError(midw_ext_fi_tcl_e8_PHN_VAG_PhoneError& oe8_PHN_VAG_PhoneError);

   virtual tVoid vVisit_e8_PHN_VAG_AudioMuteRequestAckStatus(midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus& oe8_PHN_VAG_AudioMuteRequestAckStatus);

   virtual tVoid vVisit_e8_PHN_VAG_BTVisibleState(midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState& oe8_PHN_VAG_BTVisibleState);

   virtual tVoid vVisit_PHN_VAG_BTDeviceName(midw_ext_fi_tcl_PHN_VAG_BTDeviceName& oPHN_VAG_BTDeviceName);

   virtual tVoid vVisit_PHN_VAG_BTDeviceAddress(midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress& oPHN_VAG_BTDeviceAddress);

   virtual tVoid vVisit_PHN_VAG_PairedBTDevice(midw_ext_fi_tcl_PHN_VAG_PairedBTDevice& oPHN_VAG_PairedBTDevice);

   virtual tVoid vVisit_PHN_U8_Handle(midw_ext_fi_tcl_PHN_U8_Handle& oPHN_U8_Handle);

   virtual tVoid vVisit_e8_PHN_BTVirtualDeviceService(midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService& oe8_PHN_BTVirtualDeviceService);

   virtual tVoid vVisit_PHN_BT_SPP_ServiceInformation(midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation& oPHN_BT_SPP_ServiceInformation);

   virtual tVoid vVisit_PHN_BTVirtualDeviceData(midw_ext_fi_tcl_PHN_BTVirtualDeviceData& oPHN_BTVirtualDeviceData);

   virtual tVoid vVisit_PHN_VAG_BTDevice(midw_ext_fi_tcl_PHN_VAG_BTDevice& oPHN_VAG_BTDevice);

   virtual tVoid vVisit_PHN_VAG_PINString(midw_ext_fi_tcl_PHN_VAG_PINString& oPHN_VAG_PINString);

   virtual tVoid vVisit_e8_PHN_VAG_ProviderInfoAvailability(midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability& oe8_PHN_VAG_ProviderInfoAvailability);

   virtual tVoid vVisit_PHN_VAG_ProviderName(midw_ext_fi_tcl_PHN_VAG_ProviderName& oPHN_VAG_ProviderName);

   virtual tVoid vVisit_e8_PHN_VAG_BTM_On_Off(midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off& oe8_PHN_VAG_BTM_On_Off);

   virtual tVoid vVisit_e8_PHN_VAG_DeviceType(midw_ext_fi_tcl_e8_PHN_VAG_DeviceType& oe8_PHN_VAG_DeviceType);

   virtual tVoid vVisit_PHN_VAG_BAP_TelFctList(midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList& oPHN_VAG_BAP_TelFctList);

   virtual tVoid vVisit_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics(midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics& ob8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics);

   virtual tVoid vVisit_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType(midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType& oe8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType);

   virtual tVoid vVisit_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType(midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType& oe8_PHN_VAG_BAP_TelFsgSetup_PhoneType);

   virtual tVoid vVisit_PHN_VAG_BAP_TelFsgSetup(midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup& oPHN_VAG_BAP_TelFsgSetup);

   virtual tVoid vVisit_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus(midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus& oe8_PHN_VAG_BAP_TelFsgOperationState_OPStatus);

   virtual tVoid vVisit_PHN_VAG_BAP_TelFsgOperationState(midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState& oPHN_VAG_BAP_TelFsgOperationState);

   virtual tVoid vVisit_PHN_VAG_BAP_TelUserList_Item(midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item& oPHN_VAG_BAP_TelUserList_Item);

   virtual tVoid vVisit_PHN_VAG_BAP_TelUserList(midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList& oPHN_VAG_BAP_TelUserList);

   virtual tVoid vVisit_PHN_VAG_BAP_TelActiveUser(midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser& oPHN_VAG_BAP_TelActiveUser);

   virtual tVoid vVisit_PHN_VAG_BAP_TelRegisterState(midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState& oPHN_VAG_BAP_TelRegisterState);

   virtual tVoid vVisit_PHN_VAG_BAP_TelLockState(midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState& oPHN_VAG_BAP_TelLockState);

   virtual tVoid vVisit_PHN_VAG_BAP_PBFctList(midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList& oPHN_VAG_BAP_PBFctList);

   virtual tVoid vVisit_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure(midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure& oe8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure);

   virtual tVoid vVisit_PHN_VAG_BAP_PBFsgSetup(midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup& oPHN_VAG_BAP_PBFsgSetup);

   virtual tVoid vVisit_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus(midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus& oe8_PHN_VAG_BAP_PBFsgOperationState_OPStatus);

   virtual tVoid vVisit_PHN_VAG_BAP_PBFsgOperationState(midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState& oPHN_VAG_BAP_PBFsgOperationState);

   virtual tVoid vVisit_PHN_VAG_BAP_PBMissedCallIndication(midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication& oPHN_VAG_BAP_PBMissedCallIndication);

   virtual tVoid vVisit_e8_PHN_VAG_BAP_PBCallList_Item_NumberType(midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType& oe8_PHN_VAG_BAP_PBCallList_Item_NumberType);

   virtual tVoid vVisit_PHN_VAG_BAP_PBCallList_Item(midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item& oPHN_VAG_BAP_PBCallList_Item);

   virtual tVoid vVisit_PHN_VAG_BAP_PBCallList(midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList& oPHN_VAG_BAP_PBCallList);

   virtual tVoid vVisit_e8_PHN_VAG_BAP_PBDownloadState(midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState& oe8_PHN_VAG_BAP_PBDownloadState);

   virtual tVoid vVisit_PHN_HASH_Value(midw_ext_fi_tcl_PHN_HASH_Value& oPHN_HASH_Value);

   virtual tVoid vVisit_PHN_VAG_BAP_PBState(midw_ext_fi_tcl_PHN_VAG_BAP_PBState& oPHN_VAG_BAP_PBState);

   virtual tVoid vVisit_PHN_VAG_BAP_TelCallInformation_CallState(midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState& oPHN_VAG_BAP_TelCallInformation_CallState);

   virtual tVoid vVisit_PHN_VAG_BAP_TelCallInformation_CallType(midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType& oPHN_VAG_BAP_TelCallInformation_CallType);

   virtual tVoid vVisit_PHN_VAG_BAP_TelCallInformation_DivertState(midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState& oPHN_VAG_BAP_TelCallInformation_DivertState);

   virtual tVoid vVisit_PHN_VAG_BAP_TelCallInformation_CallLine(midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine& oPHN_VAG_BAP_TelCallInformation_CallLine);

   virtual tVoid vVisit_PHN_VAG_BAP_TelCallInformation(midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation& oPHN_VAG_BAP_TelCallInformation);

   virtual tVoid vVisit_PHN_VAG_BAP_TelCallDuration(midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration& oPHN_VAG_BAP_TelCallDuration);

   virtual tVoid vVisit_PHN_VAG_BTM_PIN(midw_ext_fi_tcl_PHN_VAG_BTM_PIN& oPHN_VAG_BTM_PIN);

   virtual tVoid vVisit_e8_PHN_BTM_TEST_MODE(midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE& oe8_PHN_BTM_TEST_MODE);

   virtual tVoid vVisit_e8_PHN_BTTestAction(midw_ext_fi_tcl_e8_PHN_BTTestAction& oe8_PHN_BTTestAction);

   virtual tVoid vVisit_PHN_SetGetShortcutNumber(midw_ext_fi_tcl_PHN_SetGetShortcutNumber& oPHN_SetGetShortcutNumber);

   virtual tVoid vVisit_PHN_SetGetShortcutNumberRequest(midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest& oPHN_SetGetShortcutNumberRequest);

   virtual tVoid vVisit_b8_PHN_DISPLAY_CONTROL(midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL& ob8_PHN_DISPLAY_CONTROL);

   virtual tVoid vVisit_PHN_SMS_Handle(midw_ext_fi_tcl_PHN_SMS_Handle& oPHN_SMS_Handle);

   virtual tVoid vVisit_e8_PHN_SMS_Message_Status(midw_ext_fi_tcl_e8_PHN_SMS_Message_Status& oe8_PHN_SMS_Message_Status);

   virtual tVoid vVisit_e8_PHN_SMS_INBOX_Update_Status(midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status& oe8_PHN_SMS_INBOX_Update_Status);

   virtual tVoid vVisit_e8_PHN_SMS_Sending_Status(midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status& oe8_PHN_SMS_Sending_Status);

   virtual tVoid vVisit_e8_PHN_VAG_NumberType(midw_ext_fi_tcl_e8_PHN_VAG_NumberType& oe8_PHN_VAG_NumberType);

   virtual tVoid vVisit_PHN_SMS_PREDEFINED_MESSAGE(midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE& oPHN_SMS_PREDEFINED_MESSAGE);

   virtual tVoid vVisit_PHN_VAG_StartPairingRequest(midw_ext_fi_tcl_PHN_VAG_StartPairingRequest& oPHN_VAG_StartPairingRequest);

   virtual tVoid vVisit_PHN_VAG_DeletePairedDeviceRequest(midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest& oPHN_VAG_DeletePairedDeviceRequest);

   virtual tVoid vVisit_PHN_VAG_ConnectBTDeviceRequest(midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest& oPHN_VAG_ConnectBTDeviceRequest);

   virtual tVoid vVisit_PHN_VAG_SetBTMOnOffRequest(midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest& oPHN_VAG_SetBTMOnOffRequest);

   virtual tVoid vVisit_e8_PHN_BT_Profile(midw_ext_fi_tcl_e8_PHN_BT_Profile& oe8_PHN_BT_Profile);

   virtual tVoid vVisit_PHN_VAG_BAP_TelStartPhoneEnable_CodeType(midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType& oPHN_VAG_BAP_TelStartPhoneEnable_CodeType);

   virtual tVoid vVisit_PHN_VAG_BAP_TelStartPhoneEnable(midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable& oPHN_VAG_BAP_TelStartPhoneEnable);

   virtual tVoid vVisit_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType(midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType& oe8_PHN_VAG_BAP_TelStartDialNumber_NumberType);

   virtual tVoid vVisit_PHN_VAG_BAP_TelStartDialNumber(midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber& oPHN_VAG_BAP_TelStartDialNumber);

   virtual tVoid vVisit_PHN_VAG_BAP_TelStartHangupCall(midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall& oPHN_VAG_BAP_TelStartHangupCall);

   virtual tVoid vVisit_PHN_VAG_BAP_TelPhoneOnOff(midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff& oPHN_VAG_BAP_TelPhoneOnOff);

   virtual tVoid vVisit_PHN_VAG_BAP_TelRestoreFactorySettings_Mode(midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode& oPHN_VAG_BAP_TelRestoreFactorySettings_Mode);

   virtual tVoid vVisit_PHN_VAG_BAP_PBCallStackDeleteAll_Storage(midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage& oPHN_VAG_BAP_PBCallStackDeleteAll_Storage);

   virtual tVoid vVisit_e8_PHN_VAG_BAP_PB_SearchDirection(midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection& oe8_PHN_VAG_BAP_PB_SearchDirection);

   virtual tVoid vVisit_PHN_VAG_BAP_PB_PhonebookRequest(midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest& oPHN_VAG_BAP_PB_PhonebookRequest);

   virtual tVoid vVisit_PHN_VAG_BAP_PB_SpellerRequest(midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest& oPHN_VAG_BAP_PB_SpellerRequest);

   virtual tVoid vVisit_PHN_VAG_VOICE_RECOGNITION_REQUEST(midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST& oPHN_VAG_VOICE_RECOGNITION_REQUEST);

   virtual tVoid vVisit_e8_PHN_VAG_SetBTVisibilityResult(midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult& oe8_PHN_VAG_SetBTVisibilityResult);

   virtual tVoid vVisit_e8_PHN_VAG_StartPairingResult(midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult& oe8_PHN_VAG_StartPairingResult);

   virtual tVoid vVisit_PHN_VAG_StartPairingResult(midw_ext_fi_tcl_PHN_VAG_StartPairingResult& oPHN_VAG_StartPairingResult);

   virtual tVoid vVisit_PHN_VAG_PairedBTDeviceList(midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList& oPHN_VAG_PairedBTDeviceList);

   virtual tVoid vVisit_e8_PHN_VAG_DeletePairedBTDevResult(midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult& oe8_PHN_VAG_DeletePairedBTDevResult);

   virtual tVoid vVisit_PHN_VAG_DeletePairedBTDevResult(midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult& oPHN_VAG_DeletePairedBTDevResult);

   virtual tVoid vVisit_e8_PHN_ReplacePairedBTDevResult(midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult& oe8_PHN_ReplacePairedBTDevResult);

   virtual tVoid vVisit_e8_PHN_VAG_ConnectBTDevResult(midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult& oe8_PHN_VAG_ConnectBTDevResult);

   virtual tVoid vVisit_PHN_VAG_ConnectBTDevResult(midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult& oPHN_VAG_ConnectBTDevResult);

   virtual tVoid vVisit_e8_PHN_VAG_BAP_Result(midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result& oe8_PHN_VAG_BAP_Result);

   virtual tVoid vVisit_PHN_VAG_BAP_PB_Phonebook_Name(midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name& oPHN_VAG_BAP_PB_Phonebook_Name);

   virtual tVoid vVisit_PHN_VAG_BAP_PB_Phonebook_Window(midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window& oPHN_VAG_BAP_PB_Phonebook_Window);

   virtual tVoid vVisit_PHN_VAG_BAP_PB_PhonebookResult(midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult& oPHN_VAG_BAP_PB_PhonebookResult);

   virtual tVoid vVisit_PHN_VAG_BAP_PB_Phonebook_NumberItem(midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem& oPHN_VAG_BAP_PB_Phonebook_NumberItem);

   virtual tVoid vVisit_PHN_VAG_BAP_PB_Phonebook_Item(midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item& oPHN_VAG_BAP_PB_Phonebook_Item);

   virtual tVoid vVisit_PHN_VAG_BAP_PB_PhonebookDetailsResult(midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult& oPHN_VAG_BAP_PB_PhonebookDetailsResult);

   virtual tVoid vVisit_PHN_SMS_LIST_MESSAGE(midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE& oPHN_SMS_LIST_MESSAGE);

   virtual tVoid vVisit_PHN_PB_FLI_Phonebook_Name(midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name& oPHN_PB_FLI_Phonebook_Name);

   virtual tVoid vVisit_PHN_PB_FLI_Result(midw_ext_fi_tcl_PHN_PB_FLI_Result& oPHN_PB_FLI_Result);

   virtual tVoid vVisit_PHN_PB_FLI_Details_Result(midw_ext_fi_tcl_PHN_PB_FLI_Details_Result& oPHN_PB_FLI_Details_Result);

   virtual tVoid vVisit_PHN_PB_ENTRIES_CHECK_ITEM(midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM& oPHN_PB_ENTRIES_CHECK_ITEM);

   virtual tVoid vVisit_PHN_PB_TELEPHONE_NUMBER_ITEM(midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM& oPHN_PB_TELEPHONE_NUMBER_ITEM);

   virtual tVoid vVisit_PHN_VAG_BAP_PB_PBSpellerResult(midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult& oPHN_VAG_BAP_PB_PBSpellerResult);

   virtual tVoid vVisit_e8_PHN_VAG_SearchDir(midw_ext_fi_tcl_e8_PHN_VAG_SearchDir& oe8_PHN_VAG_SearchDir);

   virtual tVoid vVisit_e8_PHN_VAG_QuickSearchResult(midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult& oe8_PHN_VAG_QuickSearchResult);

   virtual tVoid vVisit_PHN_VAG_BAP_PB_QuicksearchResult(midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult& oPHN_VAG_BAP_PB_QuicksearchResult);

   virtual tVoid vVisit_e8_PHN_VAG_DIAG_Mute_State(midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State& oe8_PHN_VAG_DIAG_Mute_State);

   virtual tVoid vVisit_e8_PHN_VAG_DIAG_CAN_Mute_Reason(midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason& oe8_PHN_VAG_DIAG_CAN_Mute_Reason);

   virtual tVoid vVisit_PHN_VAG_AudioMuteIndication(midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication& oPHN_VAG_AudioMuteIndication);

   virtual tVoid vVisit_e8_PHN_VAG_MIC_CONN_STATUS(midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS& oe8_PHN_VAG_MIC_CONN_STATUS);

   virtual tVoid vVisit_e8_PHN_VAG_BT_SETUP_STATUS(midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS& oe8_PHN_VAG_BT_SETUP_STATUS);

   virtual tVoid vVisit_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason(midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason& oe8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason);

   virtual tVoid vVisit_e8_PHN_VAG_HMI_Audio_Mute_Action(midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action& oe8_PHN_VAG_HMI_Audio_Mute_Action);

   virtual tVoid vVisit_e8_PHN_VAG_AudioMute_TelephoneSource(midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource& oe8_PHN_VAG_AudioMute_TelephoneSource);

   virtual tVoid vVisit_e8_PHN_GAIN_SETTING(midw_ext_fi_tcl_e8_PHN_GAIN_SETTING& oe8_PHN_GAIN_SETTING);

   virtual tVoid vVisit_e8_PHN_VAG_PB_SORTING_ORDER(midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER& oe8_PHN_VAG_PB_SORTING_ORDER);

   virtual tVoid vVisit_e8_PHN_VAG_PB_SOURCE_FILTER(midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER& oe8_PHN_VAG_PB_SOURCE_FILTER);

   virtual tVoid vVisit_e8_PHN_BATTERY_STATUS(midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS& oe8_PHN_BATTERY_STATUS);

   virtual tVoid vVisit_e8_PHN_TX_MODE_SET(midw_ext_fi_tcl_e8_PHN_TX_MODE_SET& oe8_PHN_TX_MODE_SET);

   virtual tVoid vVisit_e8_PHN_TX_SLOT_LENGTH(midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH& oe8_PHN_TX_SLOT_LENGTH);

   virtual tVoid vVisit_e8_PHN_LOCAL_BT_DEVICE_MODE(midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE& oe8_PHN_LOCAL_BT_DEVICE_MODE);

   virtual tVoid vVisit_e8_Meter_UnitType(midw_ext_fi_tcl_e8_Meter_UnitType& oe8_Meter_UnitType);

   virtual tVoid vVisit_e8_Meter_ConfigurationStatus(midw_ext_fi_tcl_e8_Meter_ConfigurationStatus& oe8_Meter_ConfigurationStatus);

   virtual tVoid vVisit_Meter_VersionInfo(midw_ext_fi_tcl_Meter_VersionInfo& oMeter_VersionInfo);

   virtual tVoid vVisit_Meter_UnitConnectionStatus(midw_ext_fi_tcl_Meter_UnitConnectionStatus& oMeter_UnitConnectionStatus);

   virtual tVoid vVisit_Meter_UnitConfiguration(midw_ext_fi_tcl_Meter_UnitConfiguration& oMeter_UnitConfiguration);

   virtual tVoid vVisit_Meter_UnitVersion(midw_ext_fi_tcl_Meter_UnitVersion& oMeter_UnitVersion);

   virtual tVoid vVisit_Meter_UnitDataTransmissionStatus(midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus& oMeter_UnitDataTransmissionStatus);

   virtual tVoid vVisit_e8_Meter_Language(midw_ext_fi_tcl_e8_Meter_Language& oe8_Meter_Language);

   virtual tVoid vVisit_e8_Meter_Language_Action(midw_ext_fi_tcl_e8_Meter_Language_Action& oe8_Meter_Language_Action);

   virtual tVoid vVisit_e8_Lang_Sync_Mode_Type(midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type& oe8_Lang_Sync_Mode_Type);

   virtual tVoid vVisit_e8_Meter_Language_Status(midw_ext_fi_tcl_e8_Meter_Language_Status& oe8_Meter_Language_Status);

   virtual tVoid vVisit_e8_Meter_RequestedLanguageResult(midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult& oe8_Meter_RequestedLanguageResult);

   virtual tVoid vVisit_e8_Meter_DistanceUnit(midw_ext_fi_tcl_e8_Meter_DistanceUnit& oe8_Meter_DistanceUnit);

   virtual tVoid vVisit_e8_Meter_FuelConsumptionUnit(midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit& oe8_Meter_FuelConsumptionUnit);

   virtual tVoid vVisit_e8_Meter_TemperatureUnit(midw_ext_fi_tcl_e8_Meter_TemperatureUnit& oe8_Meter_TemperatureUnit);

   virtual tVoid vVisit_e8_Meter_PressureUnit(midw_ext_fi_tcl_e8_Meter_PressureUnit& oe8_Meter_PressureUnit);

   virtual tVoid vVisit_Meter_Audio_NoData(midw_ext_fi_tcl_Meter_Audio_NoData& oMeter_Audio_NoData);

   virtual tVoid vVisit_e8_Meter_Audio_RadioSource(midw_ext_fi_tcl_e8_Meter_Audio_RadioSource& oe8_Meter_Audio_RadioSource);

   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoUpdate(midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate& oe8_Meter_Audio_HDRadioSourceInfoUpdate);

   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoName(midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName& oe8_Meter_Audio_HDRadioSourceInfoName);

   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSource(midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource& oe8_Meter_Audio_HDRadioSource);

   virtual tVoid vVisit_e8_Meter_Audio_RadioLabelType(midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType& oe8_Meter_Audio_RadioLabelType);

   virtual tVoid vVisit_Meter_Audio_RadioLabel(midw_ext_fi_tcl_Meter_Audio_RadioLabel& oMeter_Audio_RadioLabel);

   virtual tVoid vVisit_e8_Meter_Audio_RadioFrequencyUnit(midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit& oe8_Meter_Audio_RadioFrequencyUnit);

   virtual tVoid vVisit_Meter_Audio_RadioFrequency(midw_ext_fi_tcl_Meter_Audio_RadioFrequency& oMeter_Audio_RadioFrequency);

   virtual tVoid vVisit_e8_Meter_Audio_RadioCategoryType(midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType& oe8_Meter_Audio_RadioCategoryType);

   virtual tVoid vVisit_Meter_Audio_RadioCategory(midw_ext_fi_tcl_Meter_Audio_RadioCategory& oMeter_Audio_RadioCategory);

   virtual tVoid vVisit_Meter_Audio_RadioData(midw_ext_fi_tcl_Meter_Audio_RadioData& oMeter_Audio_RadioData);

   virtual tVoid vVisit_Meter_Audio_HDRadioData(midw_ext_fi_tcl_Meter_Audio_HDRadioData& oMeter_Audio_HDRadioData);

   virtual tVoid vVisit_e8_Meter_Audio_MediaType(midw_ext_fi_tcl_e8_Meter_Audio_MediaType& oe8_Meter_Audio_MediaType);

   virtual tVoid vVisit_e8_Meter_Audio_TrackLabelType(midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType& oe8_Meter_Audio_TrackLabelType);

   virtual tVoid vVisit_Meter_Audio_TrackInfo(midw_ext_fi_tcl_Meter_Audio_TrackInfo& oMeter_Audio_TrackInfo);

   virtual tVoid vVisit_e8_Meter_Audio_GroupLabelType(midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType& oe8_Meter_Audio_GroupLabelType);

   virtual tVoid vVisit_Meter_Audio_GroupInfo(midw_ext_fi_tcl_Meter_Audio_GroupInfo& oMeter_Audio_GroupInfo);

   virtual tVoid vVisit_e8_Meter_Audio_ArtistLabelType(midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType& oe8_Meter_Audio_ArtistLabelType);

   virtual tVoid vVisit_Meter_Audio_ArtistInfo(midw_ext_fi_tcl_Meter_Audio_ArtistInfo& oMeter_Audio_ArtistInfo);

   virtual tVoid vVisit_Meter_Audio_MediaData(midw_ext_fi_tcl_Meter_Audio_MediaData& oMeter_Audio_MediaData);

   virtual tVoid vVisit_e8_Meter_Audio_AuxType(midw_ext_fi_tcl_e8_Meter_Audio_AuxType& oe8_Meter_Audio_AuxType);

   virtual tVoid vVisit_Meter_Audio_AuxData(midw_ext_fi_tcl_Meter_Audio_AuxData& oMeter_Audio_AuxData);

   virtual tVoid vVisit_Meter_Audio_ExternalSoundData(midw_ext_fi_tcl_Meter_Audio_ExternalSoundData& oMeter_Audio_ExternalSoundData);

   virtual tVoid vVisit_Meter_Audio_InternetRadioData(midw_ext_fi_tcl_Meter_Audio_InternetRadioData& oMeter_Audio_InternetRadioData);

   virtual tVoid vVisit_e8_Meter_Audio_SourceInfoType(midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType& oe8_Meter_Audio_SourceInfoType);

   virtual tVoid vVisit_Meter_Audio_SourceInfoUnion(midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion& oMeter_Audio_SourceInfoUnion);

   virtual tVoid vVisit_e8_Meter_Audio_WarningSource(midw_ext_fi_tcl_e8_Meter_Audio_WarningSource& oe8_Meter_Audio_WarningSource);

   virtual tVoid vVisit_e8_Meter_Audio_WarningState(midw_ext_fi_tcl_e8_Meter_Audio_WarningState& oe8_Meter_Audio_WarningState);

   virtual tVoid vVisit_e8_Meter_Audio_SpecialMode(midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode& oe8_Meter_Audio_SpecialMode);

   virtual tVoid vVisit_e8_NavStatus(midw_ext_fi_tcl_e8_NavStatus& oe8_NavStatus);

   virtual tVoid vVisit_e8_RoadClass(midw_ext_fi_tcl_e8_RoadClass& oe8_RoadClass);

   virtual tVoid vVisit_e8_Unit(midw_ext_fi_tcl_e8_Unit& oe8_Unit);

   virtual tVoid vVisit_e8_ManeuverSymbol(midw_ext_fi_tcl_e8_ManeuverSymbol& oe8_ManeuverSymbol);

   virtual tVoid vVisit_e8_SpeedUnit(midw_ext_fi_tcl_e8_SpeedUnit& oe8_SpeedUnit);

   virtual tVoid vVisit_e8_ManeuverRecommendationType(midw_ext_fi_tcl_e8_ManeuverRecommendationType& oe8_ManeuverRecommendationType);

   virtual tVoid vVisit_e8_TimeType(midw_ext_fi_tcl_e8_TimeType& oe8_TimeType);

   virtual tVoid vVisit_e8_TimeFormat(midw_ext_fi_tcl_e8_TimeFormat& oe8_TimeFormat);

   virtual tVoid vVisit_e8_ManeuverView(midw_ext_fi_tcl_e8_ManeuverView& oe8_ManeuverView);

   virtual tVoid vVisit_e8_DeformedImageRoad(midw_ext_fi_tcl_e8_DeformedImageRoad& oe8_DeformedImageRoad);

   virtual tVoid vVisit_e8_DeformedImageArrow(midw_ext_fi_tcl_e8_DeformedImageArrow& oe8_DeformedImageArrow);

   virtual tVoid vVisit_e8_LaneStatus(midw_ext_fi_tcl_e8_LaneStatus& oe8_LaneStatus);

   virtual tVoid vVisit_LaneRecommendation(midw_ext_fi_tcl_LaneRecommendation& oLaneRecommendation);

   virtual tVoid vVisit_ArrivalInformation(midw_ext_fi_tcl_ArrivalInformation& oArrivalInformation);

   virtual tVoid vVisit_ScreenCoordinate(midw_ext_fi_tcl_ScreenCoordinate& oScreenCoordinate);

   virtual tVoid vVisit_e8_AdminRoadClass(midw_ext_fi_tcl_e8_AdminRoadClass& oe8_AdminRoadClass);

   virtual tVoid vVisit_IntersectionMapRoadLine(midw_ext_fi_tcl_IntersectionMapRoadLine& oIntersectionMapRoadLine);

   virtual tVoid vVisit_e8_IntersectionMapCarsorState(midw_ext_fi_tcl_e8_IntersectionMapCarsorState& oe8_IntersectionMapCarsorState);

   virtual tVoid vVisit_e8_SpiNavigation_NavigationAppState(midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState& oe8_SpiNavigation_NavigationAppState);

   virtual tVoid vVisit_e8_SpiNavigation_TurnSide(midw_ext_fi_tcl_e8_SpiNavigation_TurnSide& oe8_SpiNavigation_TurnSide);

   virtual tVoid vVisit_e8_SpiNavigation_NextTurnEvent(midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent& oe8_SpiNavigation_NextTurnEvent);

   virtual tVoid vVisit_e8_Meter_SWSC_KeyCode(midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode& oe8_Meter_SWSC_KeyCode);

   virtual tVoid vVisit_e8_Meter_Phone_SMS_State(midw_ext_fi_tcl_e8_Meter_Phone_SMS_State& oe8_Meter_Phone_SMS_State);

   virtual tVoid vVisit_e8_Meter_Phone_SMS_Selected_Menu(midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu& oe8_Meter_Phone_SMS_Selected_Menu);

   virtual tVoid vVisit_e8_Meter_Phone_SMS_PopupType(midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType& oe8_Meter_Phone_SMS_PopupType);

   virtual tVoid vVisit_e8_Meter_VR_State(midw_ext_fi_tcl_e8_Meter_VR_State& oe8_Meter_VR_State);

   virtual tVoid vVisit_e8_Meter_VR_Digit_Type2(midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2& oe8_Meter_VR_Digit_Type2);

   virtual tVoid vVisit_e8_Meter_PowerState(midw_ext_fi_tcl_e8_Meter_PowerState& oe8_Meter_PowerState);

   virtual tVoid vVisit_e8_Meter_TimeInfoType(midw_ext_fi_tcl_e8_Meter_TimeInfoType& oe8_Meter_TimeInfoType);

   virtual tVoid vVisit_e8_Meter_PhoneCall_Menu_Action(midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action& oe8_Meter_PhoneCall_Menu_Action);

   virtual tVoid vVisit_e8_Meter_PhoneCall_State(midw_ext_fi_tcl_e8_Meter_PhoneCall_State& oe8_Meter_PhoneCall_State);

   virtual tVoid vVisit_e8_Language_InvalidParameter(midw_ext_fi_tcl_e8_Language_InvalidParameter& oe8_Language_InvalidParameter);

   virtual tVoid vVisit_e8_TCU_ConfigurationStatus(midw_ext_fi_tcl_e8_TCU_ConfigurationStatus& oe8_TCU_ConfigurationStatus);

   virtual tVoid vVisit_TCU_VersionInfo(midw_ext_fi_tcl_TCU_VersionInfo& oTCU_VersionInfo);

   virtual tVoid vVisit_e8_TCU_CommunicationStatus(midw_ext_fi_tcl_e8_TCU_CommunicationStatus& oe8_TCU_CommunicationStatus);

   virtual tVoid vVisit_e8_TCU_ServiceState(midw_ext_fi_tcl_e8_TCU_ServiceState& oe8_TCU_ServiceState);

   virtual tVoid vVisit_e8_TCU_CurfewWarning(midw_ext_fi_tcl_e8_TCU_CurfewWarning& oe8_TCU_CurfewWarning);

   virtual tVoid vVisit_e8_TCU_ModemStatus(midw_ext_fi_tcl_e8_TCU_ModemStatus& oe8_TCU_ModemStatus);

   virtual tVoid vVisit_e8_TCU_TCUStatus(midw_ext_fi_tcl_e8_TCU_TCUStatus& oe8_TCU_TCUStatus);

   virtual tVoid vVisit_e8_TCU_GSMStatus(midw_ext_fi_tcl_e8_TCU_GSMStatus& oe8_TCU_GSMStatus);

   virtual tVoid vVisit_e8_TCU_WifiStatus(midw_ext_fi_tcl_e8_TCU_WifiStatus& oe8_TCU_WifiStatus);

   virtual tVoid vVisit_e8_TCU_WifiMode(midw_ext_fi_tcl_e8_TCU_WifiMode& oe8_TCU_WifiMode);

   virtual tVoid vVisit_e8_TCU_WifiHotSpotStatus(midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus& oe8_TCU_WifiHotSpotStatus);

   virtual tVoid vVisit_e8_TCU_WifiClientStatus(midw_ext_fi_tcl_e8_TCU_WifiClientStatus& oe8_TCU_WifiClientStatus);

   virtual tVoid vVisit_e8_TCU_GSMDataMode(midw_ext_fi_tcl_e8_TCU_GSMDataMode& oe8_TCU_GSMDataMode);

   virtual tVoid vVisit_e8_TCU_Invalid_Parameter(midw_ext_fi_tcl_e8_TCU_Invalid_Parameter& oe8_TCU_Invalid_Parameter);

   virtual tVoid vVisit_e8_TCU_RoamingStatus(midw_ext_fi_tcl_e8_TCU_RoamingStatus& oe8_TCU_RoamingStatus);

   virtual tVoid vVisit_e8_TCU_PPPConnectionStatus(midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus& oe8_TCU_PPPConnectionStatus);

   virtual tVoid vVisit_e8_TCU_InvalidParameter(midw_ext_fi_tcl_e8_TCU_InvalidParameter& oe8_TCU_InvalidParameter);

   virtual tVoid vVisit_e8_TCU_PermitSetting(midw_ext_fi_tcl_e8_TCU_PermitSetting& oe8_TCU_PermitSetting);

   virtual tVoid vVisit_e8_TCU_APP_Context(midw_ext_fi_tcl_e8_TCU_APP_Context& oe8_TCU_APP_Context);

   virtual tVoid vVisit_e8_TCU_ProbePermitSetting(midw_ext_fi_tcl_e8_TCU_ProbePermitSetting& oe8_TCU_ProbePermitSetting);

   virtual tVoid vVisit_e8_TCU_PopUpFlag(midw_ext_fi_tcl_e8_TCU_PopUpFlag& oe8_TCU_PopUpFlag);

   virtual tVoid vVisit_e8_TCU_OperationRequest(midw_ext_fi_tcl_e8_TCU_OperationRequest& oe8_TCU_OperationRequest);

   virtual tVoid vVisit_TCU_Date_Time(midw_ext_fi_tcl_TCU_Date_Time& oTCU_Date_Time);

   virtual tVoid vVisit_e8_TCU_LocationType(midw_ext_fi_tcl_e8_TCU_LocationType& oe8_TCU_LocationType);

   virtual tVoid vVisit_TCU_Score_Info(midw_ext_fi_tcl_TCU_Score_Info& oTCU_Score_Info);

   virtual tVoid vVisit_TCU_Navi_Road_classification(midw_ext_fi_tcl_TCU_Navi_Road_classification& oTCU_Navi_Road_classification);

   virtual tVoid vVisit_TCU_Distance_Value(midw_ext_fi_tcl_TCU_Distance_Value& oTCU_Distance_Value);

   virtual tVoid vVisit_e8_TCU_Distance_Unit(midw_ext_fi_tcl_e8_TCU_Distance_Unit& oe8_TCU_Distance_Unit);

   virtual tVoid vVisit_TCU_Provision_List(midw_ext_fi_tcl_TCU_Provision_List& oTCU_Provision_List);

   virtual tVoid vVisit_e8_TCU_EcallStateDisplay(midw_ext_fi_tcl_e8_TCU_EcallStateDisplay& oe8_TCU_EcallStateDisplay);

   virtual tVoid vVisit_TCU_Maintenance_Info(midw_ext_fi_tcl_TCU_Maintenance_Info& oTCU_Maintenance_Info);

   virtual tVoid vVisit_e8_TCU_LatitudeMode(midw_ext_fi_tcl_e8_TCU_LatitudeMode& oe8_TCU_LatitudeMode);

   virtual tVoid vVisit_e8_TCU_LongitudeMode(midw_ext_fi_tcl_e8_TCU_LongitudeMode& oe8_TCU_LongitudeMode);

   virtual tVoid vVisit_e8_TCU_Sign(midw_ext_fi_tcl_e8_TCU_Sign& oe8_TCU_Sign);

   virtual tVoid vVisit_e8_TCU_Home(midw_ext_fi_tcl_e8_TCU_Home& oe8_TCU_Home);

   virtual tVoid vVisit_TCU_Altitude(midw_ext_fi_tcl_TCU_Altitude& oTCU_Altitude);

   virtual tVoid vVisit_TCU_LocationInfo(midw_ext_fi_tcl_TCU_LocationInfo& oTCU_LocationInfo);

   virtual tVoid vVisit_TCU_Navi_Info(midw_ext_fi_tcl_TCU_Navi_Info& oTCU_Navi_Info);

   virtual tVoid vVisit_TCU_Probe_Vehicle_Info(midw_ext_fi_tcl_TCU_Probe_Vehicle_Info& oTCU_Probe_Vehicle_Info);

   virtual tVoid vVisit_e8_TCU_Opcode(midw_ext_fi_tcl_e8_TCU_Opcode& oe8_TCU_Opcode);

   virtual tVoid vVisit_e8_TCU_Mode(midw_ext_fi_tcl_e8_TCU_Mode& oe8_TCU_Mode);

   virtual tVoid vVisit_TCU_ReminderInfo(midw_ext_fi_tcl_TCU_ReminderInfo& oTCU_ReminderInfo);

   virtual tVoid vVisit_e8_TCU_Service_Type(midw_ext_fi_tcl_e8_TCU_Service_Type& oe8_TCU_Service_Type);

   virtual tVoid vVisit_e8_TCU_ePOI_Type(midw_ext_fi_tcl_e8_TCU_ePOI_Type& oe8_TCU_ePOI_Type);

   virtual tVoid vVisit_e8_TCU_Finder_Status(midw_ext_fi_tcl_e8_TCU_Finder_Status& oe8_TCU_Finder_Status);

   virtual tVoid vVisit_TCU_GPS_Position(midw_ext_fi_tcl_TCU_GPS_Position& oTCU_GPS_Position);

   virtual tVoid vVisit_TCU_Time_Stamp(midw_ext_fi_tcl_TCU_Time_Stamp& oTCU_Time_Stamp);

   virtual tVoid vVisit_TCU_Opening_Hour_Day(midw_ext_fi_tcl_TCU_Opening_Hour_Day& oTCU_Opening_Hour_Day);

   virtual tVoid vVisit_TCU_Opening_Hour(midw_ext_fi_tcl_TCU_Opening_Hour& oTCU_Opening_Hour);

   virtual tVoid vVisit_TCU_Charge_Station_Accessibility(midw_ext_fi_tcl_TCU_Charge_Station_Accessibility& oTCU_Charge_Station_Accessibility);

   virtual tVoid vVisit_TCU_Payment_Method_Type(midw_ext_fi_tcl_TCU_Payment_Method_Type& oTCU_Payment_Method_Type);

   virtual tVoid vVisit_TCU_Full_Address(midw_ext_fi_tcl_TCU_Full_Address& oTCU_Full_Address);

   virtual tVoid vVisit_e8_TCU_Bookable_Information(midw_ext_fi_tcl_e8_TCU_Bookable_Information& oe8_TCU_Bookable_Information);

   virtual tVoid vVisit_e8_TCU_Spot_Availability(midw_ext_fi_tcl_e8_TCU_Spot_Availability& oe8_TCU_Spot_Availability);

   virtual tVoid vVisit_TCU_Bookable_Free_Text(midw_ext_fi_tcl_TCU_Bookable_Free_Text& oTCU_Bookable_Free_Text);

   virtual tVoid vVisit_e8_TCU_Charge_Receptacle_Type(midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type& oe8_TCU_Charge_Receptacle_Type);

   virtual tVoid vVisit_e8_TCU_Charge_Receptacle_Facility(midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility& oe8_TCU_Charge_Receptacle_Facility);

   virtual tVoid vVisit_TCU_Receptacle(midw_ext_fi_tcl_TCU_Receptacle& oTCU_Receptacle);

   virtual tVoid vVisit_TCU_Spot_List(midw_ext_fi_tcl_TCU_Spot_List& oTCU_Spot_List);

   virtual tVoid vVisit_TCU_Charge_Spot_List(midw_ext_fi_tcl_TCU_Charge_Spot_List& oTCU_Charge_Spot_List);

   virtual tVoid vVisit_TCU_Time(midw_ext_fi_tcl_TCU_Time& oTCU_Time);

   virtual tVoid vVisit_e8_Language_Family_Type(midw_ext_fi_tcl_e8_Language_Family_Type& oe8_Language_Family_Type);

   virtual tVoid vVisit_e8_Language_Type(midw_ext_fi_tcl_e8_Language_Type& oe8_Language_Type);

   virtual tVoid vVisit_TCU_Navigation_Language(midw_ext_fi_tcl_TCU_Navigation_Language& oTCU_Navigation_Language);

   virtual tVoid vVisit_e8_TCU_Booking_Status(midw_ext_fi_tcl_e8_TCU_Booking_Status& oe8_TCU_Booking_Status);

   virtual tVoid vVisit_e8_TCU_Unbooking_Status(midw_ext_fi_tcl_e8_TCU_Unbooking_Status& oe8_TCU_Unbooking_Status);

   virtual tVoid vVisit_e8_TCU_Update_Status(midw_ext_fi_tcl_e8_TCU_Update_Status& oe8_TCU_Update_Status);

   virtual tVoid vVisit_e8_TCU_Sch_Activation_State(midw_ext_fi_tcl_e8_TCU_Sch_Activation_State& oe8_TCU_Sch_Activation_State);

   virtual tVoid vVisit_TCU_Charge_Days(midw_ext_fi_tcl_TCU_Charge_Days& oTCU_Charge_Days);

   virtual tVoid vVisit_e8_TCU_Charge_Blocked_Status(midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status& oe8_TCU_Charge_Blocked_Status);

   virtual tVoid vVisit_TCU_Spot_Receptacle_Type(midw_ext_fi_tcl_TCU_Spot_Receptacle_Type& oTCU_Spot_Receptacle_Type);

   virtual tVoid vVisitIN_Data(midw_ext_fi_tclIN_Data& oN_Data);

   virtual tVoid vVisit_TCU_PIN(midw_ext_fi_tcl_TCU_PIN& oTCU_PIN);

   virtual tVoid vVisit_TCU_Wifi_SSID_Name(midw_ext_fi_tcl_TCU_Wifi_SSID_Name& oTCU_Wifi_SSID_Name);

   virtual tVoid vVisit_TCU_Wifi_PassKey(midw_ext_fi_tcl_TCU_Wifi_PassKey& oTCU_Wifi_PassKey);

   virtual tVoid vVisit_e8_TCU_Wifi_Security_Mode(midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode& oe8_TCU_Wifi_Security_Mode);

   virtual tVoid vVisit_e8_TCU_Wifi_Visibility(midw_ext_fi_tcl_e8_TCU_Wifi_Visibility& oe8_TCU_Wifi_Visibility);

   virtual tVoid vVisit_e8_TCU_Wifi_Status(midw_ext_fi_tcl_e8_TCU_Wifi_Status& oe8_TCU_Wifi_Status);

   virtual tVoid vVisit_e8_TCU_Wifi_Mode(midw_ext_fi_tcl_e8_TCU_Wifi_Mode& oe8_TCU_Wifi_Mode);

   virtual tVoid vVisit_e8_TCU_Wifi_Connection_Status(midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status& oe8_TCU_Wifi_Connection_Status);

   virtual tVoid vVisit_e8_TCU_Wifi_Wifi_Scan_Security(midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security& oe8_TCU_Wifi_Wifi_Scan_Security);

   virtual tVoid vVisit_e8_TCU_Wifi_Wifi_Client_Status(midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status& oe8_TCU_Wifi_Wifi_Client_Status);

   virtual tVoid vVisit_e8_TCU_Audio_SourceActivity(midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity& oe8_TCU_Audio_SourceActivity);

   virtual tVoid vVisit_e8_TCU_Cycle(midw_ext_fi_tcl_e8_TCU_Cycle& oe8_TCU_Cycle);

   virtual tVoid vVisit_TCU_Time_Slot(midw_ext_fi_tcl_TCU_Time_Slot& oTCU_Time_Slot);

   virtual tVoid vVisit_TCU_Coordinates(midw_ext_fi_tcl_TCU_Coordinates& oTCU_Coordinates);

   virtual tVoid vVisit_e8_TCU_Restriction_Area_Type(midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type& oe8_TCU_Restriction_Area_Type);

   virtual tVoid vVisit_e8_TCU_Area_Form(midw_ext_fi_tcl_e8_TCU_Area_Form& oe8_TCU_Area_Form);

   virtual tVoid vVisit_TCU_Area_Coordinate(midw_ext_fi_tcl_TCU_Area_Coordinate& oTCU_Area_Coordinate);

   virtual tVoid vVisit_TCU_Area_Limit_Coordinates(midw_ext_fi_tcl_TCU_Area_Limit_Coordinates& oTCU_Area_Limit_Coordinates);

   virtual tVoid vVisit_e8_TCU_Restrictions_State(midw_ext_fi_tcl_e8_TCU_Restrictions_State& oe8_TCU_Restrictions_State);

   virtual tVoid vVisit_TCU_Time_Limit_Restriction(midw_ext_fi_tcl_TCU_Time_Limit_Restriction& oTCU_Time_Limit_Restriction);

   virtual tVoid vVisit_e8_TCU_Time_Slot_State(midw_ext_fi_tcl_e8_TCU_Time_Slot_State& oe8_TCU_Time_Slot_State);

   virtual tVoid vVisit_TCU_Speed_Limit_Restriction(midw_ext_fi_tcl_TCU_Speed_Limit_Restriction& oTCU_Speed_Limit_Restriction);

   virtual tVoid vVisit_TCU_Area_Limit_Restriction(midw_ext_fi_tcl_TCU_Area_Limit_Restriction& oTCU_Area_Limit_Restriction);

   virtual tVoid vVisit_e8_TCU_ConnectionType(midw_ext_fi_tcl_e8_TCU_ConnectionType& oe8_TCU_ConnectionType);

   virtual tVoid vVisit_e8_TCU_XCALL_Type(midw_ext_fi_tcl_e8_TCU_XCALL_Type& oe8_TCU_XCALL_Type);

   virtual tVoid vVisit_e8_TCU_XCALL_Language(midw_ext_fi_tcl_e8_TCU_XCALL_Language& oe8_TCU_XCALL_Language);

   virtual tVoid vVisit_e8_TCU_Response_Time_Out(midw_ext_fi_tcl_e8_TCU_Response_Time_Out& oe8_TCU_Response_Time_Out);

   virtual tVoid vVisit_TCU_Response_Time_Out(midw_ext_fi_tcl_TCU_Response_Time_Out& oTCU_Response_Time_Out);

   virtual tVoid vVisit_e8_TCU_Availability(midw_ext_fi_tcl_e8_TCU_Availability& oe8_TCU_Availability);

   virtual tVoid vVisit_e8_TCU_CallType(midw_ext_fi_tcl_e8_TCU_CallType& oe8_TCU_CallType);

   virtual tVoid vVisit_e8_TCU_PrivacyModes(midw_ext_fi_tcl_e8_TCU_PrivacyModes& oe8_TCU_PrivacyModes);

   virtual tVoid vVisit_usb_tcu_Data_Header_Part(midw_ext_fi_tcl_usb_tcu_Data_Header_Part& ousb_tcu_Data_Header_Part);

   virtual tVoid vVisit_usb_tcu_Location(midw_ext_fi_tcl_usb_tcu_Location& ousb_tcu_Location);

   virtual tVoid vVisit_usb_tcu_Data_Record(midw_ext_fi_tcl_usb_tcu_Data_Record& ousb_tcu_Data_Record);

   virtual tVoid vVisit_usb_tcu_connected_search_result(midw_ext_fi_tcl_usb_tcu_connected_search_result& ousb_tcu_connected_search_result);

   virtual tVoid vVisit_usb_tcu_channel_master_data_header(midw_ext_fi_tcl_usb_tcu_channel_master_data_header& ousb_tcu_channel_master_data_header);

   virtual tVoid vVisit_usb_tcu_Folder_definition_information(midw_ext_fi_tcl_usb_tcu_Folder_definition_information& ousb_tcu_Folder_definition_information);

   virtual tVoid vVisit_usb_tcu_Channel_definition_information(midw_ext_fi_tcl_usb_tcu_Channel_definition_information& ousb_tcu_Channel_definition_information);

   virtual tVoid vVisit_usb_tcu_channel_master_data(midw_ext_fi_tcl_usb_tcu_channel_master_data& ousb_tcu_channel_master_data);

   virtual tVoid vVisit_e8_tcu_AudioActivity(midw_ext_fi_tcl_e8_tcu_AudioActivity& oe8_tcu_AudioActivity);

   virtual tVoid vVisit_usb_tcu_Channel_Info(midw_ext_fi_tcl_usb_tcu_Channel_Info& ousb_tcu_Channel_Info);

   virtual tVoid vVisit_usb_tcu_Channel_Info_List(midw_ext_fi_tcl_usb_tcu_Channel_Info_List& ousb_tcu_Channel_Info_List);

   virtual tVoid vVisit_usb_tcu_GroupA_Authorization_Info(midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info& ousb_tcu_GroupA_Authorization_Info);

   virtual tVoid vVisit_usb_tcu_GroupA_BasicServices_Info(midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info& ousb_tcu_GroupA_BasicServices_Info);

   virtual tVoid vVisit_usb_tcu_GroupA_Info(midw_ext_fi_tcl_usb_tcu_GroupA_Info& ousb_tcu_GroupA_Info);

   virtual tVoid vVisit_e8_ConnectedSearchServiceType(midw_ext_fi_tcl_e8_ConnectedSearchServiceType& oe8_ConnectedSearchServiceType);

   virtual tVoid vVisit_e8_tcu_ExecType(midw_ext_fi_tcl_e8_tcu_ExecType& oe8_tcu_ExecType);

   virtual tVoid vVisit_e8_DatabaseStatus(midw_ext_fi_tcl_e8_DatabaseStatus& oe8_DatabaseStatus);

   virtual tVoid vVisit_e8_DatabaseServiceType(midw_ext_fi_tcl_e8_DatabaseServiceType& oe8_DatabaseServiceType);

   virtual tVoid vVisit_e8_CancelRequestType(midw_ext_fi_tcl_e8_CancelRequestType& oe8_CancelRequestType);

   virtual tVoid vVisit_usb_tcu_Server_Info(midw_ext_fi_tcl_usb_tcu_Server_Info& ousb_tcu_Server_Info);

   virtual tVoid vVisit_usb_tcu_Server_Info_List(midw_ext_fi_tcl_usb_tcu_Server_Info_List& ousb_tcu_Server_Info_List);

   virtual tVoid vVisit_e8_DataConnectionStatus(midw_ext_fi_tcl_e8_DataConnectionStatus& oe8_DataConnectionStatus);

   virtual tVoid vVisit_e8_DataDownloadStatus(midw_ext_fi_tcl_e8_DataDownloadStatus& oe8_DataDownloadStatus);

   virtual tVoid vVisit_e16_DataConnectionError(midw_ext_fi_tcl_e16_DataConnectionError& oe16_DataConnectionError);

   virtual tVoid vVisit_e8_ModemType(midw_ext_fi_tcl_e8_ModemType& oe8_ModemType);

   virtual tVoid vVisit_usb_tcu_TCUDevice_Info(midw_ext_fi_tcl_usb_tcu_TCUDevice_Info& ousb_tcu_TCUDevice_Info);

   virtual tVoid vVisit_e8_tcu_LogLevel(midw_ext_fi_tcl_e8_tcu_LogLevel& oe8_tcu_LogLevel);

   virtual tVoid vVisit_e8_SxmPredefinedListIds(midw_ext_fi_tcl_e8_SxmPredefinedListIds& oe8_SxmPredefinedListIds);

   virtual tVoid vVisit_e8_SxmListType(midw_ext_fi_tcl_e8_SxmListType& oe8_SxmListType);

   virtual tVoid vVisit_e8_SxmListStatus(midw_ext_fi_tcl_e8_SxmListStatus& oe8_SxmListStatus);

   virtual tVoid vVisit_e8_SxmListMode(midw_ext_fi_tcl_e8_SxmListMode& oe8_SxmListMode);

   virtual tVoid vVisit_SxmListMode(midw_ext_fi_tcl_SxmListMode& oSxmListMode);

   virtual tVoid vVisit_e8_SxmListOperation(midw_ext_fi_tcl_e8_SxmListOperation& oe8_SxmListOperation);

   virtual tVoid vVisit_SxmLocation(midw_ext_fi_tcl_SxmLocation& oSxmLocation);

   virtual tVoid vVisit_SxmListInfo(midw_ext_fi_tcl_SxmListInfo& oSxmListInfo);

   virtual tVoid vVisit_SxmListsConfig(midw_ext_fi_tcl_SxmListsConfig& oSxmListsConfig);

   virtual tVoid vVisit_SxmListInfos(midw_ext_fi_tcl_SxmListInfos& oSxmListInfos);

   virtual tVoid vVisit_e8_SxmDataServiceStatus(midw_ext_fi_tcl_e8_SxmDataServiceStatus& oe8_SxmDataServiceStatus);

   virtual tVoid vVisit_SxmDataSrvState(midw_ext_fi_tcl_SxmDataSrvState& oSxmDataSrvState);

   virtual tVoid vVisit_e8_SxmDataServiceType(midw_ext_fi_tcl_e8_SxmDataServiceType& oe8_SxmDataServiceType);

   virtual tVoid vVisit_SxmListElemDataSrvState(midw_ext_fi_tcl_SxmListElemDataSrvState& oSxmListElemDataSrvState);

   virtual tVoid vVisit_RGBAcolor(midw_ext_fi_tcl_RGBAcolor& oRGBAcolor);

   virtual tVoid vVisit_e8_Graphics(midw_ext_fi_tcl_e8_Graphics& oe8_Graphics);

   virtual tVoid vVisit_e8_ChannelSkipType(midw_ext_fi_tcl_e8_ChannelSkipType& oe8_ChannelSkipType);

   virtual tVoid vVisit_ChannelListEntry(midw_ext_fi_tcl_ChannelListEntry& oChannelListEntry);

   virtual tVoid vVisit_e8_MethodStatus(midw_ext_fi_tcl_e8_MethodStatus& oe8_MethodStatus);

   virtual tVoid vVisit_e8_ErrorTypes(midw_ext_fi_tcl_e8_ErrorTypes& oe8_ErrorTypes);

   virtual tVoid vVisit_ChannelList(midw_ext_fi_tcl_ChannelList& oChannelList);

   virtual tVoid vVisit_PresetListEntry(midw_ext_fi_tcl_PresetListEntry& oPresetListEntry);

   virtual tVoid vVisit_CategoryListEntry(midw_ext_fi_tcl_CategoryListEntry& oCategoryListEntry);

   virtual tVoid vVisit_e8_SelectChannelMode(midw_ext_fi_tcl_e8_SelectChannelMode& oe8_SelectChannelMode);

   virtual tVoid vVisit_PresetChannelList(midw_ext_fi_tcl_PresetChannelList& oPresetChannelList);

   virtual tVoid vVisit_ChannelInformation(midw_ext_fi_tcl_ChannelInformation& oChannelInformation);

   virtual tVoid vVisit_e8_SportsFlash_Sport(midw_ext_fi_tcl_e8_SportsFlash_Sport& oe8_SportsFlash_Sport);

   virtual tVoid vVisit_e8_SportsFlash_League(midw_ext_fi_tcl_e8_SportsFlash_League& oe8_SportsFlash_League);

   virtual tVoid vVisit_e8_SportsFlash_ProgramStatus(midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus& oe8_SportsFlash_ProgramStatus);

   virtual tVoid vVisit_e8_SportsFlash_FlashEventStatus(midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus& oe8_SportsFlash_FlashEventStatus);

   virtual tVoid vVisit_e8_SystemMessage(midw_ext_fi_tcl_e8_SystemMessage& oe8_SystemMessage);

   virtual tVoid vVisit_e8_Sxm_AntennaState(midw_ext_fi_tcl_e8_Sxm_AntennaState& oe8_Sxm_AntennaState);

   virtual tVoid vVisit_e8_Sxm_SignalQuality(midw_ext_fi_tcl_e8_Sxm_SignalQuality& oe8_Sxm_SignalQuality);

   virtual tVoid vVisit_SxmSignalQuality(midw_ext_fi_tcl_SxmSignalQuality& oSxmSignalQuality);

   virtual tVoid vVisit_SxmDetSignalQuality(midw_ext_fi_tcl_SxmDetSignalQuality& oSxmDetSignalQuality);

   virtual tVoid vVisit_SxmDetOvrlSignalQuality(midw_ext_fi_tcl_SxmDetOvrlSignalQuality& oSxmDetOvrlSignalQuality);

   virtual tVoid vVisit_SxmVersionInfo(midw_ext_fi_tcl_SxmVersionInfo& oSxmVersionInfo);

   virtual tVoid vVisit_SxmDataSubStatus(midw_ext_fi_tcl_SxmDataSubStatus& oSxmDataSubStatus);

   virtual tVoid vVisit_SxmDiagTestModeData(midw_ext_fi_tcl_SxmDiagTestModeData& oSxmDiagTestModeData);

   virtual tVoid vVisit_SxmSmsDbInfo(midw_ext_fi_tcl_SxmSmsDbInfo& oSxmSmsDbInfo);

   virtual tVoid vVisit_SxmAudioSubInfo(midw_ext_fi_tcl_SxmAudioSubInfo& oSxmAudioSubInfo);

   virtual tVoid vVisit_e8_SxmFirmwareDownloadResult(midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult& oe8_SxmFirmwareDownloadResult);

   virtual tVoid vVisit_e8_SxmExtDiagMode(midw_ext_fi_tcl_e8_SxmExtDiagMode& oe8_SxmExtDiagMode);

   virtual tVoid vVisit_SmartFavoritePreset(midw_ext_fi_tcl_SmartFavoritePreset& oSmartFavoritePreset);

   virtual tVoid vVisit_SFListElement(midw_ext_fi_tcl_SFListElement& oSFListElement);

   virtual tVoid vVisit_e8_SFOperation(midw_ext_fi_tcl_e8_SFOperation& oe8_SFOperation);

   virtual tVoid vVisit_e8_IRPlaybackMode(midw_ext_fi_tcl_e8_IRPlaybackMode& oe8_IRPlaybackMode);

   virtual tVoid vVisit_e8_IRPlaybackStatus(midw_ext_fi_tcl_e8_IRPlaybackStatus& oe8_IRPlaybackStatus);

   virtual tVoid vVisit_InstantReplayStatus(midw_ext_fi_tcl_InstantReplayStatus& oInstantReplayStatus);

   virtual tVoid vVisit_e8_TuneScanMode(midw_ext_fi_tcl_e8_TuneScanMode& oe8_TuneScanMode);

   virtual tVoid vVisit_e8_FavoriteType(midw_ext_fi_tcl_e8_FavoriteType& oe8_FavoriteType);

   virtual tVoid vVisit_e8_FavoriteStatus(midw_ext_fi_tcl_e8_FavoriteStatus& oe8_FavoriteStatus);

   virtual tVoid vVisit_e8_Action(midw_ext_fi_tcl_e8_Action& oe8_Action);

   virtual tVoid vVisit_RegisteredFavorite(midw_ext_fi_tcl_RegisteredFavorite& oRegisteredFavorite);

   virtual tVoid vVisit_b8_ChannelStatus(midw_ext_fi_tcl_b8_ChannelStatus& ob8_ChannelStatus);

   virtual tVoid vVisit_AlertInfo(midw_ext_fi_tcl_AlertInfo& oAlertInfo);

   virtual tVoid vVisit_e8_FlashServiceStatus(midw_ext_fi_tcl_e8_FlashServiceStatus& oe8_FlashServiceStatus);

   virtual tVoid vVisit_e8_TWNow_Bulletin_PlayBackAction(midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction& oe8_TWNow_Bulletin_PlayBackAction);

   virtual tVoid vVisit_e8_TWNow_Bulletin_Status(midw_ext_fi_tcl_e8_TWNow_Bulletin_Status& oe8_TWNow_Bulletin_Status);

   virtual tVoid vVisit_MarketListEntry(midw_ext_fi_tcl_MarketListEntry& oMarketListEntry);

   virtual tVoid vVisit_MarketList(midw_ext_fi_tcl_MarketList& oMarketList);

   virtual tVoid vVisit_SportsFlash_FavoriteTeam(midw_ext_fi_tcl_SportsFlash_FavoriteTeam& oSportsFlash_FavoriteTeam);

   virtual tVoid vVisit_SportsFlash_Game(midw_ext_fi_tcl_SportsFlash_Game& oSportsFlash_Game);

   virtual tVoid vVisit_SportsFlash_FlashEvent(midw_ext_fi_tcl_SportsFlash_FlashEvent& oSportsFlash_FlashEvent);

   virtual tVoid vVisit_SportsFlash_League(midw_ext_fi_tcl_SportsFlash_League& oSportsFlash_League);

   virtual tVoid vVisit_SportsFlash_Team(midw_ext_fi_tcl_SportsFlash_Team& oSportsFlash_Team);

   virtual tVoid vVisit_e8_TuneScanStatus(midw_ext_fi_tcl_e8_TuneScanStatus& oe8_TuneScanStatus);

   virtual tVoid vVisit_SportsFlash_MonitorTeam(midw_ext_fi_tcl_SportsFlash_MonitorTeam& oSportsFlash_MonitorTeam);

   virtual tVoid vVisit_e8_FlashEventPlaybackStatus(midw_ext_fi_tcl_e8_FlashEventPlaybackStatus& oe8_FlashEventPlaybackStatus);

   virtual tVoid vVisit_e8_BrowseDirection(midw_ext_fi_tcl_e8_BrowseDirection& oe8_BrowseDirection);

   virtual tVoid vVisit_BrowseRateConfiguration(midw_ext_fi_tcl_BrowseRateConfiguration& oBrowseRateConfiguration);

   virtual tVoid vVisit_e8_BrowseChannelLoop(midw_ext_fi_tcl_e8_BrowseChannelLoop& oe8_BrowseChannelLoop);

   virtual tVoid vVisit_e8_BrowseChannelType(midw_ext_fi_tcl_e8_BrowseChannelType& oe8_BrowseChannelType);

   virtual tVoid vVisit_BrowseChannelConfig(midw_ext_fi_tcl_BrowseChannelConfig& oBrowseChannelConfig);

   virtual tVoid vVisit_b16_CHANNEL_EVENT(midw_ext_fi_tcl_b16_CHANNEL_EVENT& ob16_CHANNEL_EVENT);

   virtual tVoid vVisit_LocalTimeDate(midw_ext_fi_tcl_LocalTimeDate& oLocalTimeDate);

   virtual tVoid vVisit_PresetEntry(midw_ext_fi_tcl_PresetEntry& oPresetEntry);

   virtual tVoid vVisit_Status(midw_ext_fi_tcl_Status& oStatus);

   virtual tVoid vVisit_ProfileStatus(midw_ext_fi_tcl_ProfileStatus& oProfileStatus);

   virtual tVoid vVisit_ProfileAction(midw_ext_fi_tcl_ProfileAction& oProfileAction);

   virtual tVoid vVisit_ProfileResponse(midw_ext_fi_tcl_ProfileResponse& oProfileResponse);

   virtual tVoid vVisit_PresetsConfiguration(midw_ext_fi_tcl_PresetsConfiguration& oPresetsConfiguration);

   virtual tVoid vVisit_e8ChannelArtErrorTypes(midw_ext_fi_tcl_e8ChannelArtErrorTypes& oe8ChannelArtErrorTypes);

   virtual tVoid vVisit_e8_ChnGraphicsTypes(midw_ext_fi_tcl_e8_ChnGraphicsTypes& oe8_ChnGraphicsTypes);

   virtual tVoid vVisit_ImageData(midw_ext_fi_tcl_ImageData& oImageData);

   virtual tVoid vVisit_e8_FuelTypeEnum(midw_ext_fi_tcl_e8_FuelTypeEnum& oe8_FuelTypeEnum);

   virtual tVoid vVisit_e8_FuelStationAmenity(midw_ext_fi_tcl_e8_FuelStationAmenity& oe8_FuelStationAmenity);

   virtual tVoid vVisit_e8_SortType(midw_ext_fi_tcl_e8_SortType& oe8_SortType);

   virtual tVoid vVisit_FuelInfo(midw_ext_fi_tcl_FuelInfo& oFuelInfo);

   virtual tVoid vVisit_FuelTypeInfo(midw_ext_fi_tcl_FuelTypeInfo& oFuelTypeInfo);

   virtual tVoid vVisit_e8FuelErrorTypes(midw_ext_fi_tcl_e8FuelErrorTypes& oe8FuelErrorTypes);

   virtual tVoid vVisit_FuelTypeInfolist(midw_ext_fi_tcl_FuelTypeInfolist& oFuelTypeInfolist);

   virtual tVoid vVisit_FuelStationInfo(midw_ext_fi_tcl_FuelStationInfo& oFuelStationInfo);

   virtual tVoid vVisit_FuelInfoList(midw_ext_fi_tcl_FuelInfoList& oFuelInfoList);

   virtual tVoid vVisit_BrandNameList(midw_ext_fi_tcl_BrandNameList& oBrandNameList);

   virtual tVoid vVisit_FuelTypeList(midw_ext_fi_tcl_FuelTypeList& oFuelTypeList);

   virtual tVoid vVisit_e8_TheatreAmenities(midw_ext_fi_tcl_e8_TheatreAmenities& oe8_TheatreAmenities);

   virtual tVoid vVisit_TheatreInfo(midw_ext_fi_tcl_TheatreInfo& oTheatreInfo);

   virtual tVoid vVisit_MovieInfo(midw_ext_fi_tcl_MovieInfo& oMovieInfo);

   virtual tVoid vVisit_TheatreDetails(midw_ext_fi_tcl_TheatreDetails& oTheatreDetails);

   virtual tVoid vVisit_ShowDate(midw_ext_fi_tcl_ShowDate& oShowDate);

   virtual tVoid vVisit_TheatreInfoList(midw_ext_fi_tcl_TheatreInfoList& oTheatreInfoList);

   virtual tVoid vVisit_MoviesList(midw_ext_fi_tcl_MoviesList& oMoviesList);

   virtual tVoid vVisit_ShowTimes(midw_ext_fi_tcl_ShowTimes& oShowTimes);

   virtual tVoid vVisit_MovieTimes(midw_ext_fi_tcl_MovieTimes& oMovieTimes);

   virtual tVoid vVisit_MovieTimesList(midw_ext_fi_tcl_MovieTimesList& oMovieTimesList);

   virtual tVoid vVisit_MovieDetails(midw_ext_fi_tcl_MovieDetails& oMovieDetails);

   virtual tVoid vVisit_e8MovieErrorTypes(midw_ext_fi_tcl_e8MovieErrorTypes& oe8MovieErrorTypes);

   virtual tVoid vVisit_SportInfo(midw_ext_fi_tcl_SportInfo& oSportInfo);

   virtual tVoid vVisit_SportList(midw_ext_fi_tcl_SportList& oSportList);

   virtual tVoid vVisit_e8_Game_Status(midw_ext_fi_tcl_e8_Game_Status& oe8_Game_Status);

   virtual tVoid vVisit_AffiliateInfo(midw_ext_fi_tcl_AffiliateInfo& oAffiliateInfo);

   virtual tVoid vVisit_RootAffiliateList(midw_ext_fi_tcl_RootAffiliateList& oRootAffiliateList);

   virtual tVoid vVisit_AffiliateCategories(midw_ext_fi_tcl_AffiliateCategories& oAffiliateCategories);

   virtual tVoid vVisit_SubLeagues(midw_ext_fi_tcl_SubLeagues& oSubLeagues);

   virtual tVoid vVisit_e8CategoryAvailability(midw_ext_fi_tcl_e8CategoryAvailability& oe8CategoryAvailability);

   virtual tVoid vVisit_TimeInfo(midw_ext_fi_tcl_TimeInfo& oTimeInfo);

   virtual tVoid vVisit_XMChannelType(midw_ext_fi_tcl_XMChannelType& oXMChannelType);

   virtual tVoid vVisit_XMChannel(midw_ext_fi_tcl_XMChannel& oXMChannel);

   virtual tVoid vVisit_Details(midw_ext_fi_tcl_Details& oDetails);

   virtual tVoid vVisit_TeamInfo(midw_ext_fi_tcl_TeamInfo& oTeamInfo);

   virtual tVoid vVisit_GameType(midw_ext_fi_tcl_GameType& oGameType);

   virtual tVoid vVisit_GameInfo(midw_ext_fi_tcl_GameInfo& oGameInfo);

   virtual tVoid vVisit_AvailableGames(midw_ext_fi_tcl_AvailableGames& oAvailableGames);

   virtual tVoid vVisit_TeamList(midw_ext_fi_tcl_TeamList& oTeamList);

   virtual tVoid vVisit_AllTeams(midw_ext_fi_tcl_AllTeams& oAllTeams);

   virtual tVoid vVisit_GameList(midw_ext_fi_tcl_GameList& oGameList);

   virtual tVoid vVisit_FavoriteInfo(midw_ext_fi_tcl_FavoriteInfo& oFavoriteInfo);

   virtual tVoid vVisit_FavoriteList(midw_ext_fi_tcl_FavoriteList& oFavoriteList);

   virtual tVoid vVisit_AffiliateDetailInfo(midw_ext_fi_tcl_AffiliateDetailInfo& oAffiliateDetailInfo);

   virtual tVoid vVisit_SportsUpdateType(midw_ext_fi_tcl_SportsUpdateType& oSportsUpdateType);

   virtual tVoid vVisit_AffiliateDetails(midw_ext_fi_tcl_AffiliateDetails& oAffiliateDetails);

   virtual tVoid vVisit_e8SportsErrorTypes(midw_ext_fi_tcl_e8SportsErrorTypes& oe8SportsErrorTypes);

   virtual tVoid vVisit_EventSchedule(midw_ext_fi_tcl_EventSchedule& oEventSchedule);

   virtual tVoid vVisit_EventSchedule_List(midw_ext_fi_tcl_EventSchedule_List& oEventSchedule_List);

   virtual tVoid vVisit_EventRank(midw_ext_fi_tcl_EventRank& oEventRank);

   virtual tVoid vVisit_EventRankList(midw_ext_fi_tcl_EventRankList& oEventRankList);

   virtual tVoid vVisit_NewsInfo(midw_ext_fi_tcl_NewsInfo& oNewsInfo);

   virtual tVoid vVisit_NewsList(midw_ext_fi_tcl_NewsList& oNewsList);

   virtual tVoid vVisit_e8SportsServiceDataStatus(midw_ext_fi_tcl_e8SportsServiceDataStatus& oe8SportsServiceDataStatus);

   virtual tVoid vVisit_e8_ForecastType(midw_ext_fi_tcl_e8_ForecastType& oe8_ForecastType);

   virtual tVoid vVisit_e8_PollenLevelType(midw_ext_fi_tcl_e8_PollenLevelType& oe8_PollenLevelType);

   virtual tVoid vVisit_e8_AirQualityType(midw_ext_fi_tcl_e8_AirQualityType& oe8_AirQualityType);

   virtual tVoid vVisit_e8_CloudCoverType(midw_ext_fi_tcl_e8_CloudCoverType& oe8_CloudCoverType);

   virtual tVoid vVisit_WeatherInfo(midw_ext_fi_tcl_WeatherInfo& oWeatherInfo);

   virtual tVoid vVisit_WeatherInfoList(midw_ext_fi_tcl_WeatherInfoList& oWeatherInfoList);

   virtual tVoid vVisit_e8_TabWeather_ErrorTypes(midw_ext_fi_tcl_e8_TabWeather_ErrorTypes& oe8_TabWeather_ErrorTypes);

   virtual tVoid vVisit_e8_SXMTileType(midw_ext_fi_tcl_e8_SXMTileType& oe8_SXMTileType);

   virtual tVoid vVisit_e8_SXMShapeType(midw_ext_fi_tcl_e8_SXMShapeType& oe8_SXMShapeType);

   virtual tVoid vVisit_e8_SXMTileDataType(midw_ext_fi_tcl_e8_SXMTileDataType& oe8_SXMTileDataType);

   virtual tVoid vVisit_SXMSharedMemoryDescription(midw_ext_fi_tcl_SXMSharedMemoryDescription& oSXMSharedMemoryDescription);

   virtual tVoid vVisit_SXMSharedMemoryTile(midw_ext_fi_tcl_SXMSharedMemoryTile& oSXMSharedMemoryTile);

   virtual tVoid vVisit_SXMShape(midw_ext_fi_tcl_SXMShape& oSXMShape);

   virtual tVoid vVisit_e8_FrontType(midw_ext_fi_tcl_e8_FrontType& oe8_FrontType);

   virtual tVoid vVisit_e8_PressureType(midw_ext_fi_tcl_e8_PressureType& oe8_PressureType);

   virtual tVoid vVisit_SXMShapeTypeIsobar(midw_ext_fi_tcl_SXMShapeTypeIsobar& oSXMShapeTypeIsobar);

   virtual tVoid vVisit_SXMShapeTypeWindRadius(midw_ext_fi_tcl_SXMShapeTypeWindRadius& oSXMShapeTypeWindRadius);

   virtual tVoid vVisit_e8_StormPositionType(midw_ext_fi_tcl_e8_StormPositionType& oe8_StormPositionType);

   virtual tVoid vVisit_e8_StormType(midw_ext_fi_tcl_e8_StormType& oe8_StormType);

   virtual tVoid vVisit_b8_StormType(midw_ext_fi_tcl_b8_StormType& ob8_StormType);

   virtual tVoid vVisit_SXMShapeTypeStormAttributes(midw_ext_fi_tcl_SXMShapeTypeStormAttributes& oSXMShapeTypeStormAttributes);

   virtual tVoid vVisit_SXMShapeTypeFront(midw_ext_fi_tcl_SXMShapeTypeFront& oSXMShapeTypeFront);

   virtual tVoid vVisit_SXMShapeTypePressureCenter(midw_ext_fi_tcl_SXMShapeTypePressureCenter& oSXMShapeTypePressureCenter);

   virtual tVoid vVisit_SXMShapeTypeStormPosition(midw_ext_fi_tcl_SXMShapeTypeStormPosition& oSXMShapeTypeStormPosition);

   virtual tVoid vVisit_SXMShapeTypeStormTrack(midw_ext_fi_tcl_SXMShapeTypeStormTrack& oSXMShapeTypeStormTrack);

   virtual tVoid vVisit_e8_STOCK_PRICE_DIRECTION(midw_ext_fi_tcl_e8_STOCK_PRICE_DIRECTION& oe8_STOCK_PRICE_DIRECTION);

   virtual tVoid vVisit_e8_Stock_ErrorTypes(midw_ext_fi_tcl_e8_Stock_ErrorTypes& oe8_Stock_ErrorTypes);

   virtual tVoid vVisit_StockQuote(midw_ext_fi_tcl_StockQuote& oStockQuote);

   virtual tVoid vVisit_StockQuoteList(midw_ext_fi_tcl_StockQuoteList& oStockQuoteList);

   virtual tVoid vVisit_StockFilterList(midw_ext_fi_tcl_StockFilterList& oStockFilterList);

   virtual tVoid vVisit_SXMSafeviewSubLocationInfo(midw_ext_fi_tcl_SXMSafeviewSubLocationInfo& oSXMSafeviewSubLocationInfo);

   virtual tVoid vVisit_SXMSafeviewLocationAndSubLocationInfo(midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo& oSXMSafeviewLocationAndSubLocationInfo);

   virtual tVoid vVisit_SXMSafeviewLocationAndSubLocationInfoList(midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfoList& oSXMSafeviewLocationAndSubLocationInfoList);

   virtual tVoid vVisit_e8_SXMSafeview_ErrorTypes(midw_ext_fi_tcl_e8_SXMSafeview_ErrorTypes& oe8_SXMSafeview_ErrorTypes);

   virtual tVoid vVisitDCLK_TEN_DST_Setting(midw_ext_fi_tclDCLK_TEN_DST_Setting& oCLK_TEN_DST_Setting);

   virtual tVoid vVisitDCLK_TEN_GPS_EPOCH(midw_ext_fi_tclDCLK_TEN_GPS_EPOCH& oCLK_TEN_GPS_EPOCH);

   virtual tVoid vVisitDCLK_TEN_GPSRTCTIMESTATE(midw_ext_fi_tclDCLK_TEN_GPSRTCTIMESTATE& oCLK_TEN_GPSRTCTIMESTATE);

   virtual tVoid vVisitDCLK_TEN_TimeDateStatus(midw_ext_fi_tclDCLK_TEN_TimeDateStatus& oCLK_TEN_TimeDateStatus);

   virtual tVoid vVisitDCLK_TEN_FormatSourceStatus(midw_ext_fi_tclDCLK_TEN_FormatSourceStatus& oCLK_TEN_FormatSourceStatus);

   virtual tVoid vVisitDCLK_TEN_ClockSourceStatus(midw_ext_fi_tclDCLK_TEN_ClockSourceStatus& oCLK_TEN_ClockSourceStatus);

   virtual tVoid vVisitDCLK_TEN_TimeFormat(midw_ext_fi_tclDCLK_TEN_TimeFormat& oCLK_TEN_TimeFormat);

   virtual tVoid vVisitDCLK_TEN_DateFormat(midw_ext_fi_tclDCLK_TEN_DateFormat& oCLK_TEN_DateFormat);

   virtual tVoid vVisitDCLK_TEN_SyncMode(midw_ext_fi_tclDCLK_TEN_SyncMode& oCLK_TEN_SyncMode);

   virtual tVoid vVisit_WSAlertLocation(midw_ext_fi_tcl_WSAlertLocation& oWSAlertLocation);

   virtual tVoid vVisit_e8_WSAlertAnnounceStatus(midw_ext_fi_tcl_e8_WSAlertAnnounceStatus& oe8_WSAlertAnnounceStatus);

   virtual tVoid vVisit_e8_WSAlertAnnounceAction(midw_ext_fi_tcl_e8_WSAlertAnnounceAction& oe8_WSAlertAnnounceAction);

   virtual tVoid vVisit_e8_WSAlertListStatus(midw_ext_fi_tcl_e8_WSAlertListStatus& oe8_WSAlertListStatus);

   virtual tVoid vVisit_e8_WSAlertTypes(midw_ext_fi_tcl_e8_WSAlertTypes& oe8_WSAlertTypes);

   virtual tVoid vVisit_WSAlertInfo(midw_ext_fi_tcl_WSAlertInfo& oWSAlertInfo);

   virtual tVoid vVisit_WSAlertConfig(midw_ext_fi_tcl_WSAlertConfig& oWSAlertConfig);

   virtual tVoid vVisit_e8_Language(midw_ext_fi_tcl_e8_Language& oe8_Language);

   virtual tVoid vVisit_WSAlertMsg(midw_ext_fi_tcl_WSAlertMsg& oWSAlertMsg);

   virtual tVoid vVisit_e8_WSAlertActionType(midw_ext_fi_tcl_e8_WSAlertActionType& oe8_WSAlertActionType);

   virtual tVoid vVisit_e8_WSAlerts_ErrorTypes(midw_ext_fi_tcl_e8_WSAlerts_ErrorTypes& oe8_WSAlerts_ErrorTypes);

   virtual tVoid vVisit_e8FullType(midw_ext_fi_tcl_e8FullType& oe8FullType);

   virtual tVoid vVisit_Fullness(midw_ext_fi_tcl_Fullness& oFullness);

   virtual tVoid vVisit_e8Open24Hours(midw_ext_fi_tcl_e8Open24Hours& oe8Open24Hours);

   virtual tVoid vVisit_e8CashOrCard(midw_ext_fi_tcl_e8CashOrCard& oe8CashOrCard);

   virtual tVoid vVisit_e8ParkingType(midw_ext_fi_tcl_e8ParkingType& oe8ParkingType);

   virtual tVoid vVisit_e8MetroLocation(midw_ext_fi_tcl_e8MetroLocation& oe8MetroLocation);

   virtual tVoid vVisit_e8AirPort(midw_ext_fi_tcl_e8AirPort& oe8AirPort);

   virtual tVoid vVisit_e8OvernightParking(midw_ext_fi_tcl_e8OvernightParking& oe8OvernightParking);

   virtual tVoid vVisit_e8Reservations(midw_ext_fi_tcl_e8Reservations& oe8Reservations);

   virtual tVoid vVisit_e8SelfParking(midw_ext_fi_tcl_e8SelfParking& oe8SelfParking);

   virtual tVoid vVisit_e8Security(midw_ext_fi_tcl_e8Security& oe8Security);

   virtual tVoid vVisit_e8TollTag(midw_ext_fi_tcl_e8TollTag& oe8TollTag);

   virtual tVoid vVisit_e8SUVCharges(midw_ext_fi_tcl_e8SUVCharges& oe8SUVCharges);

   virtual tVoid vVisit_e8RV(midw_ext_fi_tcl_e8RV& oe8RV);

   virtual tVoid vVisit_e8OpenStatus(midw_ext_fi_tcl_e8OpenStatus& oe8OpenStatus);

   virtual tVoid vVisit_AmenityInfo(midw_ext_fi_tcl_AmenityInfo& oAmenityInfo);

   virtual tVoid vVisit_PriceInfo(midw_ext_fi_tcl_PriceInfo& oPriceInfo);

   virtual tVoid vVisit_Time(midw_ext_fi_tcl_Time& oTime);

   virtual tVoid vVisit_PerDayOpeningTimes(midw_ext_fi_tcl_PerDayOpeningTimes& oPerDayOpeningTimes);

   virtual tVoid vVisit_e8DayType(midw_ext_fi_tcl_e8DayType& oe8DayType);

   virtual tVoid vVisit_OpeningTime(midw_ext_fi_tcl_OpeningTime& oOpeningTime);

   virtual tVoid vVisit_ParkingInfo(midw_ext_fi_tcl_ParkingInfo& oParkingInfo);

   virtual tVoid vVisit_FilterConfig(midw_ext_fi_tcl_FilterConfig& oFilterConfig);

   virtual tVoid vVisit_AmenityConfig(midw_ext_fi_tcl_AmenityConfig& oAmenityConfig);

   virtual tVoid vVisit_FilterConfiguration(midw_ext_fi_tcl_FilterConfiguration& oFilterConfiguration);

   virtual tVoid vVisit_e8ParkingErrorTypes(midw_ext_fi_tcl_e8ParkingErrorTypes& oe8ParkingErrorTypes);

   virtual tVoid vVisit_e8_CanFuelTypeEnum(midw_ext_fi_tcl_e8_CanFuelTypeEnum& oe8_CanFuelTypeEnum);

   virtual tVoid vVisit_e8_CanFuelStationAmenity(midw_ext_fi_tcl_e8_CanFuelStationAmenity& oe8_CanFuelStationAmenity);

   virtual tVoid vVisit_e8_CanFuelSortType(midw_ext_fi_tcl_e8_CanFuelSortType& oe8_CanFuelSortType);

   virtual tVoid vVisit_CanFuelInfo(midw_ext_fi_tcl_CanFuelInfo& oCanFuelInfo);

   virtual tVoid vVisit_CanFuelTypeInfo(midw_ext_fi_tcl_CanFuelTypeInfo& oCanFuelTypeInfo);

   virtual tVoid vVisit_e8CanFuelErrorTypes(midw_ext_fi_tcl_e8CanFuelErrorTypes& oe8CanFuelErrorTypes);

   virtual tVoid vVisit_CanFuelTypeInfolist(midw_ext_fi_tcl_CanFuelTypeInfolist& oCanFuelTypeInfolist);

   virtual tVoid vVisit_CanFuelStationInfo(midw_ext_fi_tcl_CanFuelStationInfo& oCanFuelStationInfo);

   virtual tVoid vVisit_CanFuelInfoList(midw_ext_fi_tcl_CanFuelInfoList& oCanFuelInfoList);

   virtual tVoid vVisit_CanBrandNameList(midw_ext_fi_tcl_CanBrandNameList& oCanBrandNameList);

   virtual tVoid vVisit_CanFuelTypeList(midw_ext_fi_tcl_CanFuelTypeList& oCanFuelTypeList);

   virtual tVoid vVisit_ChannelPhoneticsInfo(midw_ext_fi_tcl_ChannelPhoneticsInfo& oChannelPhoneticsInfo);

   virtual tVoid vVisit_CategoryPhoneticsInfo(midw_ext_fi_tcl_CategoryPhoneticsInfo& oCategoryPhoneticsInfo);

   virtual tVoid vVisit_LeaguePhoneticsInfo(midw_ext_fi_tcl_LeaguePhoneticsInfo& oLeaguePhoneticsInfo);

   virtual tVoid vVisit_MarketPhoneticsInfo(midw_ext_fi_tcl_MarketPhoneticsInfo& oMarketPhoneticsInfo);

   virtual tVoid vVisit_TeamPhoneticsInfo(midw_ext_fi_tcl_TeamPhoneticsInfo& oTeamPhoneticsInfo);

   virtual tVoid vVisit_e8PhoneticsErrorTypes(midw_ext_fi_tcl_e8PhoneticsErrorTypes& oe8PhoneticsErrorTypes);

   virtual tVoid vVisit_e8PhoneticsType(midw_ext_fi_tcl_e8PhoneticsType& oe8PhoneticsType);

   virtual tVoid vVisit_e8LanguageType(midw_ext_fi_tcl_e8LanguageType& oe8LanguageType);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
