/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_TCUFITYPES_HEADER
#define MIDW_EXT_TCUFITYPES_HEADER


class midw_ext_tcufi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_ext_tcu_fi message types

fi_tclMessageBase* midw_ext_tcufi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_tcufi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_tcufi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart& operator=(const midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart& coRef);
   midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart(const midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bECallAccepted;
   virtual ~midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgAcceptECallRequestMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgAcceptECallRequestMethodResult();

   virtual ~midw_ext_tcufi_tclMsgAcceptECallRequestMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgAcceptECallRequestMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgECallCancellationOrderMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgECallCancellationOrderMethodStart();

   virtual ~midw_ext_tcufi_tclMsgECallCancellationOrderMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgECallCancellationOrderMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgECallCancellationOrderMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgECallCancellationOrderMethodResult();

   virtual ~midw_ext_tcufi_tclMsgECallCancellationOrderMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgECallCancellationOrderMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetTCUStateMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetTCUStateMethodStart();

   virtual ~midw_ext_tcufi_tclMsgGetTCUStateMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetTCUStateMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetTCUStateMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetTCUStateMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetTCUStateMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetTCUStateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetIDInfoMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetIDInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgGetIDInfoMethodStart& operator=(const midw_ext_tcufi_tclMsgGetIDInfoMethodStart& coRef);
   midw_ext_tcufi_tclMsgGetIDInfoMethodStart(const midw_ext_tcufi_tclMsgGetIDInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString NaviId;
   midw_ext_fi_tclString MapVersion;
   virtual ~midw_ext_tcufi_tclMsgGetIDInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgGetIDInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetIDInfoMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetIDInfoMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetIDInfoMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetIDInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart& operator=(const midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart(const midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_PermitSetting e8PermitSetting;
   virtual ~midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodStart();

   virtual ~midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart& operator=(const midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart(const midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_ProbePermitSetting e8ProbePermitSetting;
   virtual ~midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodStart();

   virtual ~midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart& operator=(const midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart(const midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_OperationRequest e8OperationRequest;
   virtual ~midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetServiceCallOperationMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetServiceCallOperationMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetServiceCallOperationMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetServiceCallOperationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetNaviInfoMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetNaviInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetNaviInfoMethodStart& operator=(const midw_ext_tcufi_tclMsgSetNaviInfoMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetNaviInfoMethodStart(const midw_ext_tcufi_tclMsgSetNaviInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Navi_Info rNaviData;
   virtual ~midw_ext_tcufi_tclMsgSetNaviInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetNaviInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetNaviInfoMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetNaviInfoMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetNaviInfoMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetNaviInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart& operator=(const midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart(const midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Score_Info rTripEcoScoreInfo;
   virtual ~midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetTripScoreInfoMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetTripScoreInfoMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetTripScoreInfoMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetTripScoreInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart& operator=(const midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart(const midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Probe_Vehicle_Info rProbeVehicleInfo;
   virtual ~midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart& operator=(const midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart& coRef);
   midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart(const midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Maintenance_Info MaintenanceInfo;
   virtual ~midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgMaintenanceInfoMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgMaintenanceInfoMethodResult();

   virtual ~midw_ext_tcufi_tclMsgMaintenanceInfoMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgMaintenanceInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodStart();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodResult();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetTCUResetMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetTCUResetMethodStart();

   virtual ~midw_ext_tcufi_tclMsgSetTCUResetMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetTCUResetMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetTCUResetMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetTCUResetMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetTCUResetMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetTCUResetMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodStart();

   virtual ~midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetPINSettingMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetPINSettingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetPINSettingMethodStart& operator=(const midw_ext_tcufi_tclMsgSetPINSettingMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetPINSettingMethodStart(const midw_ext_tcufi_tclMsgSetPINSettingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_PIN rPIN;
   virtual ~midw_ext_tcufi_tclMsgSetPINSettingMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetPINSettingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetPINSettingMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetPINSettingMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetPINSettingMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetPINSettingMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetChargeReminderMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetChargeReminderMethodStart();

   virtual ~midw_ext_tcufi_tclMsgGetChargeReminderMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetChargeReminderMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetChargeReminderMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetChargeReminderMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetChargeReminderMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetChargeReminderMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetChargeReminderMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetChargeReminderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetChargeReminderMethodStart& operator=(const midw_ext_tcufi_tclMsgSetChargeReminderMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetChargeReminderMethodStart(const midw_ext_tcufi_tclMsgSetChargeReminderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_ReminderInfo rReminderInfo;
   virtual ~midw_ext_tcufi_tclMsgSetChargeReminderMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetChargeReminderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetChargeReminderMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetChargeReminderMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetChargeReminderMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetChargeReminderMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetStationFinderMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetStationFinderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgGetStationFinderMethodStart& operator=(const midw_ext_tcufi_tclMsgGetStationFinderMethodStart& coRef);
   midw_ext_tcufi_tclMsgGetStationFinderMethodStart(const midw_ext_tcufi_tclMsgGetStationFinderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Service_Type e8ServiceType;
   midw_ext_fi_tclString sCurrentCountry;
   midw_ext_fi_tcl_TCU_GPS_Position rSearch_GPS_Position;
   midw_ext_fi_tcl_e8_TCU_ePOI_Type e8ePOI_Type;
   midw_ext_fi_tcl_TCU_Spot_Receptacle_Type rSpot_Receptacle_Type;
   tU16 u16Vehicle_Autonomy;
   tU32 u32BatteryIdentificationNumber;
   midw_ext_fi_tcl_TCU_Navigation_Language rNavigation_Language;
   virtual ~midw_ext_tcufi_tclMsgGetStationFinderMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgGetStationFinderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetStationFinderMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetStationFinderMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetStationFinderMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetStationFinderMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetChargeStationMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetChargeStationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgGetChargeStationMethodStart& operator=(const midw_ext_tcufi_tclMsgGetChargeStationMethodStart& coRef);
   midw_ext_tcufi_tclMsgGetChargeStationMethodStart(const midw_ext_tcufi_tclMsgGetChargeStationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Station_List_Number;
   virtual ~midw_ext_tcufi_tclMsgGetChargeStationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgGetChargeStationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetChargeStationMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetChargeStationMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetChargeStationMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetChargeStationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart& operator=(const midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart& coRef);
   midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart(const midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Station_List_Number;
   tU8 u8Pages_Of_List;
   virtual ~midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetChargeSpotListMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetChargeSpotListMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetChargeSpotListMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetChargeSpotListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetShortBookingMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetShortBookingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgGetShortBookingMethodStart& operator=(const midw_ext_tcufi_tclMsgGetShortBookingMethodStart& coRef);
   midw_ext_tcufi_tclMsgGetShortBookingMethodStart(const midw_ext_tcufi_tclMsgGetShortBookingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sCharge_Station_ID;
   midw_ext_fi_tclString sCustomer_Contract_ID;
   midw_ext_fi_tcl_e8_TCU_ePOI_Type e8ePOI_Type;
   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type e8Charge_Receptacle_Type;
   midw_ext_fi_tclString sUtility_Aggregator_ID;
   midw_ext_fi_tclString sCurrent_Country;
   midw_ext_fi_tclString sCharge_Spot_ID;
   tU32 u32Battery_Identification_Number;
   midw_ext_fi_tcl_TCU_Time rService_Time_Request;
   midw_ext_fi_tcl_TCU_Navigation_Language rNavigation_Language;
   midw_ext_fi_tcl_TCU_Time_Stamp rTime_Stamp;
   virtual ~midw_ext_tcufi_tclMsgGetShortBookingMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgGetShortBookingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetShortBookingMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetShortBookingMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetShortBookingMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetShortBookingMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart& operator=(const midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart& coRef);
   midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart(const midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sCustomer_Contract_ID;
   midw_ext_fi_tclString sUtility_Aggregator_ID;
   midw_ext_fi_tclString sCurrent_Country;
   midw_ext_fi_tclString sCharge_Spot_ID;
   midw_ext_fi_tclString sCharge_Station_ID;
   midw_ext_fi_tclString sBooking_ID;
   virtual ~midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetShortUnbookingMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetShortUnbookingMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetShortUnbookingMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetShortUnbookingMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart& operator=(const midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart& coRef);
   midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart(const midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sCurrent_Country;
   midw_ext_fi_tcl_TCU_GPS_Position rEPOI_GPS_Position;
   midw_ext_fi_tclString sCharge_Station_ID;
   midw_ext_fi_tclString sUtility_Aggregator_ID;
   tU32 u32Battery_Identification_Number;
   midw_ext_fi_tcl_TCU_Navigation_Language rNavigation_Language;
   midw_ext_fi_tclString sBooking_ID;
   virtual ~midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart& operator=(const midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart(const midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Sch_Activation_State e8Sch_Activation_State;
   virtual ~midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetSCH_ActivationMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetSCH_ActivationMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetSCH_ActivationMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetSCH_ActivationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart& operator=(const midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart(const midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Charge_Days rCharge_Day1_7_Start;
   midw_ext_fi_tcl_TCU_Charge_Days rCharge_Day1_7_End;
   virtual ~midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetSCH_StateMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetSCH_StateMethodStart();

   virtual ~midw_ext_tcufi_tclMsgGetSCH_StateMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetSCH_StateMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetSCH_StateMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetSCH_StateMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetSCH_StateMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetSCH_StateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart& operator=(const midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart(const midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Wifi_SSID_Name rWifi_SSID_Name;
   midw_ext_fi_tcl_TCU_Wifi_PassKey rWifi_PassKey;
   midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode;
   tU8 u8Wifi_Channel_Number;
   midw_ext_fi_tcl_e8_TCU_Wifi_Visibility e8Wifi_Visibility;
   virtual ~midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart& operator=(const midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart(const midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Wifi_Status e8Wifi_Status;
   midw_ext_fi_tcl_e8_TCU_Wifi_Mode e8Wifi_Mode;
   virtual ~midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiDataResetMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiDataResetMethodStart();

   virtual ~midw_ext_tcufi_tclMsgSetWifiDataResetMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetWifiDataResetMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiDataResetMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiDataResetMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetWifiDataResetMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetWifiDataResetMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiClientScanMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiClientScanMethodStart();

   virtual ~midw_ext_tcufi_tclMsgSetWifiClientScanMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetWifiClientScanMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiClientScanMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiClientScanMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetWifiClientScanMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetWifiClientScanMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart& operator=(const midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart(const midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Wifi_SSID_Name rWifi_Scan_SSID_Name;
   midw_ext_fi_tcl_TCU_Wifi_PassKey rWifi_PassKey;
   virtual ~midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodStart();

   virtual ~midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodStart();

   virtual ~midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetWifiClientStateMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetWifiClientStateMethodStart();

   virtual ~midw_ext_tcufi_tclMsgGetWifiClientStateMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetWifiClientStateMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetWifiClientStateMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetWifiClientStateMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetWifiClientStateMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetWifiClientStateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgDTMEcallMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgDTMEcallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgDTMEcallMethodStart& operator=(const midw_ext_tcufi_tclMsgDTMEcallMethodStart& coRef);
   midw_ext_tcufi_tclMsgDTMEcallMethodStart(const midw_ext_tcufi_tclMsgDTMEcallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity e8SourceActivity;
   virtual ~midw_ext_tcufi_tclMsgDTMEcallMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgDTMEcallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgDTMEcallMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgDTMEcallMethodResult();

   virtual ~midw_ext_tcufi_tclMsgDTMEcallMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgDTMEcallMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgResetHistoryMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgResetHistoryMethodStart();

   virtual ~midw_ext_tcufi_tclMsgResetHistoryMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgResetHistoryMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgResetHistoryMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgResetHistoryMethodResult();

   virtual ~midw_ext_tcufi_tclMsgResetHistoryMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgResetHistoryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetHardwareVersionMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetHardwareVersionMethodStart();

   virtual ~midw_ext_tcufi_tclMsgGetHardwareVersionMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetHardwareVersionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetHardwareVersionMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetHardwareVersionMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetHardwareVersionMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetHardwareVersionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetSoftwareVersionMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetSoftwareVersionMethodStart();

   virtual ~midw_ext_tcufi_tclMsgGetSoftwareVersionMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetSoftwareVersionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetSoftwareVersionMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetSoftwareVersionMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetSoftwareVersionMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetSoftwareVersionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart& operator=(const midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart(const midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_InvalidParameter e8InvalidParmeter;
   virtual ~midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetPush_POIStatusMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetPush_POIStatusMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetPush_POIStatusMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetPush_POIStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart& operator=(const midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart(const midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_InvalidParameter e8InvalidParmeter;
   tU8 u8Geofencing_Activation_State ;
   virtual ~midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodStart();

   virtual ~midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodResult();

   virtual ~midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallStartMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallStartMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgXCallStartMethodStart& operator=(const midw_ext_tcufi_tclMsgXCallStartMethodStart& coRef);
   midw_ext_tcufi_tclMsgXCallStartMethodStart(const midw_ext_tcufi_tclMsgXCallStartMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_XCALL_Type e8XCallType;
   midw_ext_fi_tcl_e8_TCU_XCALL_Language e8XCallLanguage;
   virtual ~midw_ext_tcufi_tclMsgXCallStartMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgXCallStartMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallStartMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallStartMethodResult();

   virtual ~midw_ext_tcufi_tclMsgXCallStartMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgXCallStartMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart& operator=(const midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart& coRef);
   midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart(const midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_PrivacyModes e8PrivacyMode;
   virtual ~midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSetPrivicyModeMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSetPrivicyModeMethodResult();

   virtual ~midw_ext_tcufi_tclMsgSetPrivicyModeMethodResult();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSetPrivicyModeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodStart : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodStart();

   virtual ~midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodStart();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult& operator=(const midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult& coRef);
   midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult(const midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Availability rTCU_CurrentAvailabilityConfiguration;
   tBool bAutoConfigured;
   virtual ~midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConnectionUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConnectionUpReg();

   virtual ~midw_ext_tcufi_tclMsgConnectionUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConnectionRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConnectionRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgConnectionRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConnectionGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConnectionGet();

   virtual ~midw_ext_tcufi_tclMsgConnectionGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConnectionStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgConnectionStatus& operator=(const midw_ext_tcufi_tclMsgConnectionStatus& coRef);
   midw_ext_tcufi_tclMsgConnectionStatus(const midw_ext_tcufi_tclMsgConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bConnected;
   tU8 u8AbsenceState;
   tU8 u8MuteState;
   midw_ext_fi_tcl_e8_TCU_CommunicationStatus e8CommunicationStatus;
   virtual ~midw_ext_tcufi_tclMsgConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConfigurationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConfigurationUpReg();

   virtual ~midw_ext_tcufi_tclMsgConfigurationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgConfigurationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConfigurationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConfigurationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgConfigurationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgConfigurationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConfigurationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConfigurationGet();

   virtual ~midw_ext_tcufi_tclMsgConfigurationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgConfigurationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConfigurationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConfigurationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgConfigurationStatus& operator=(const midw_ext_tcufi_tclMsgConfigurationStatus& coRef);
   midw_ext_tcufi_tclMsgConfigurationStatus(const midw_ext_tcufi_tclMsgConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_ConfigurationStatus e8ConfigurationStatus;
   tU8 u8UnitId;
   midw_ext_fi_tcl_TCU_VersionInfo rMessageVersion;
   virtual ~midw_ext_tcufi_tclMsgConfigurationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgConfigurationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgDataTransmissionUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgDataTransmissionUpReg();

   virtual ~midw_ext_tcufi_tclMsgDataTransmissionUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgDataTransmissionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgDataTransmissionRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgDataTransmissionRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgDataTransmissionRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgDataTransmissionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgDataTransmissionGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgDataTransmissionGet();

   virtual ~midw_ext_tcufi_tclMsgDataTransmissionGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgDataTransmissionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgDataTransmissionStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgDataTransmissionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgDataTransmissionStatus& operator=(const midw_ext_tcufi_tclMsgDataTransmissionStatus& coRef);
   midw_ext_tcufi_tclMsgDataTransmissionStatus(const midw_ext_tcufi_tclMsgDataTransmissionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8MPDTMuteState;
   virtual ~midw_ext_tcufi_tclMsgDataTransmissionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgDataTransmissionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgECallRequestUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgECallRequestUpReg();

   virtual ~midw_ext_tcufi_tclMsgECallRequestUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgECallRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgECallRequestRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgECallRequestRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgECallRequestRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgECallRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgECallRequestGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgECallRequestGet();

   virtual ~midw_ext_tcufi_tclMsgECallRequestGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgECallRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgECallRequestStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgECallRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgECallRequestStatus& operator=(const midw_ext_tcufi_tclMsgECallRequestStatus& coRef);
   midw_ext_tcufi_tclMsgECallRequestStatus(const midw_ext_tcufi_tclMsgECallRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bECallActive;
   tBool bValid;
   tBool bIsECallCallBackRequest;
   virtual ~midw_ext_tcufi_tclMsgECallRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgECallRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgECallServiceStateUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgECallServiceStateUpReg();

   virtual ~midw_ext_tcufi_tclMsgECallServiceStateUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgECallServiceStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgECallServiceStateRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgECallServiceStateRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgECallServiceStateRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgECallServiceStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgECallServiceStateGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgECallServiceStateGet();

   virtual ~midw_ext_tcufi_tclMsgECallServiceStateGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgECallServiceStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgECallServiceStateStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgECallServiceStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgECallServiceStateStatus& operator=(const midw_ext_tcufi_tclMsgECallServiceStateStatus& coRef);
   midw_ext_tcufi_tclMsgECallServiceStateStatus(const midw_ext_tcufi_tclMsgECallServiceStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_ServiceState e8ECallServiceState;
   virtual ~midw_ext_tcufi_tclMsgECallServiceStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgECallServiceStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgACNRequestUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgACNRequestUpReg();

   virtual ~midw_ext_tcufi_tclMsgACNRequestUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgACNRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgACNRequestRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgACNRequestRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgACNRequestRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgACNRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgACNRequestGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgACNRequestGet();

   virtual ~midw_ext_tcufi_tclMsgACNRequestGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgACNRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgACNRequestStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgACNRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgACNRequestStatus& operator=(const midw_ext_tcufi_tclMsgACNRequestStatus& coRef);
   midw_ext_tcufi_tclMsgACNRequestStatus(const midw_ext_tcufi_tclMsgACNRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bACNActive;
   tBool bValid;
   virtual ~midw_ext_tcufi_tclMsgACNRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgACNRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgACNServiceStateUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgACNServiceStateUpReg();

   virtual ~midw_ext_tcufi_tclMsgACNServiceStateUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgACNServiceStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgACNServiceStateRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgACNServiceStateRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgACNServiceStateRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgACNServiceStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgACNServiceStateGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgACNServiceStateGet();

   virtual ~midw_ext_tcufi_tclMsgACNServiceStateGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgACNServiceStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgACNServiceStateStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgACNServiceStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgACNServiceStateStatus& operator=(const midw_ext_tcufi_tclMsgACNServiceStateStatus& coRef);
   midw_ext_tcufi_tclMsgACNServiceStateStatus(const midw_ext_tcufi_tclMsgACNServiceStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_ServiceState e8ACNServiceState;
   virtual ~midw_ext_tcufi_tclMsgACNServiceStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgACNServiceStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCurfewAlertUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCurfewAlertUpReg();

   virtual ~midw_ext_tcufi_tclMsgCurfewAlertUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCurfewAlertUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCurfewAlertRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCurfewAlertRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgCurfewAlertRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCurfewAlertRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCurfewAlertGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCurfewAlertGet();

   virtual ~midw_ext_tcufi_tclMsgCurfewAlertGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCurfewAlertGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCurfewAlertStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCurfewAlertStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgCurfewAlertStatus& operator=(const midw_ext_tcufi_tclMsgCurfewAlertStatus& coRef);
   midw_ext_tcufi_tclMsgCurfewAlertStatus(const midw_ext_tcufi_tclMsgCurfewAlertStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_CurfewWarning e8CurfewAlertWarning;
   virtual ~midw_ext_tcufi_tclMsgCurfewAlertStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgCurfewAlertStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGeoFenceUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGeoFenceUpReg();

   virtual ~midw_ext_tcufi_tclMsgGeoFenceUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGeoFenceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGeoFenceRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGeoFenceRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgGeoFenceRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGeoFenceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGeoFenceGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGeoFenceGet();

   virtual ~midw_ext_tcufi_tclMsgGeoFenceGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGeoFenceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGeoFenceStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGeoFenceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgGeoFenceStatus& operator=(const midw_ext_tcufi_tclMsgGeoFenceStatus& coRef);
   midw_ext_tcufi_tclMsgGeoFenceStatus(const midw_ext_tcufi_tclMsgGeoFenceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bStatusFromTCU;
   virtual ~midw_ext_tcufi_tclMsgGeoFenceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgGeoFenceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSpeedAlertUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSpeedAlertUpReg();

   virtual ~midw_ext_tcufi_tclMsgSpeedAlertUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSpeedAlertUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSpeedAlertRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSpeedAlertRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgSpeedAlertRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSpeedAlertRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSpeedAlertGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSpeedAlertGet();

   virtual ~midw_ext_tcufi_tclMsgSpeedAlertGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSpeedAlertGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSpeedAlertStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSpeedAlertStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSpeedAlertStatus& operator=(const midw_ext_tcufi_tclMsgSpeedAlertStatus& coRef);
   midw_ext_tcufi_tclMsgSpeedAlertStatus(const midw_ext_tcufi_tclMsgSpeedAlertStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bStatusFromTCU;
   virtual ~midw_ext_tcufi_tclMsgSpeedAlertStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSpeedAlertStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUStateUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUStateUpReg();

   virtual ~midw_ext_tcufi_tclMsgTCUStateUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUStateRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUStateRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgTCUStateRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUStateGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUStateGet();

   virtual ~midw_ext_tcufi_tclMsgTCUStateGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUStateStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgTCUStateStatus& operator=(const midw_ext_tcufi_tclMsgTCUStateStatus& coRef);
   midw_ext_tcufi_tclMsgTCUStateStatus(const midw_ext_tcufi_tclMsgTCUStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_ModemStatus e8ModemStatus;
   midw_ext_fi_tcl_e8_TCU_TCUStatus e8TcuStatus;
   midw_ext_fi_tcl_e8_TCU_GSMStatus e8GSMStatus;
   tU8 u8GSMRSSILevel;
   midw_ext_fi_tcl_e8_TCU_WifiStatus e8WifiStatus;
   midw_ext_fi_tcl_e8_TCU_WifiMode e8WifiMode;
   midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus e8WifiHotSpotStatus;
   midw_ext_fi_tcl_e8_TCU_WifiClientStatus e8WifiClientStatus;
   midw_ext_fi_tcl_e8_TCU_GSMDataMode e8GSMDataMode;
   tU8 u8WifiClientSSID;
   tU8 u8WifiClientPower;
   midw_ext_fi_tcl_e8_TCU_Opcode e8Opcode;
   virtual ~midw_ext_tcufi_tclMsgTCUStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgTCUStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgIDInfoStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgIDInfoStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgIDInfoStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgIDInfoStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgIDInfoStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgIDInfoStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgIDInfoStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgIDInfoStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgIDInfoStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgIDInfoStatusGet();

   virtual ~midw_ext_tcufi_tclMsgIDInfoStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgIDInfoStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgIDInfoStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgIDInfoStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgIDInfoStatusStatus& operator=(const midw_ext_tcufi_tclMsgIDInfoStatusStatus& coRef);
   midw_ext_tcufi_tclMsgIDInfoStatusStatus(const midw_ext_tcufi_tclMsgIDInfoStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_InvalidParameter e8InvalidParameter;
   midw_ext_fi_tclString sTCUID;
   midw_ext_fi_tclString sICCID;
   midw_ext_fi_tclString sVIN;
   virtual ~midw_ext_tcufi_tclMsgIDInfoStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgIDInfoStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusGet();

   virtual ~midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus& operator=(const midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus& coRef);
   midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus(const midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_InvalidParameter e8InvalidParameter;
   midw_ext_fi_tcl_e8_TCU_PermitSetting e8PermitSetting;
   tBool bValid;
   midw_ext_fi_tcl_e8_TCU_APP_Context e8AppContext;
   virtual ~midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSMSNotificationStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSMSNotificationStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgSMSNotificationStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSMSNotificationStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSMSNotificationStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSMSNotificationStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgSMSNotificationStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSMSNotificationStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSMSNotificationStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSMSNotificationStatusGet();

   virtual ~midw_ext_tcufi_tclMsgSMSNotificationStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSMSNotificationStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSMSNotificationStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSMSNotificationStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSMSNotificationStatusStatus& operator=(const midw_ext_tcufi_tclMsgSMSNotificationStatusStatus& coRef);
   midw_ext_tcufi_tclMsgSMSNotificationStatusStatus(const midw_ext_tcufi_tclMsgSMSNotificationStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_PopUpFlag e8PopUpFlag;
   tU8 u8ConnectingPoint;
   tU16 u16InformationChannel;
   virtual ~midw_ext_tcufi_tclMsgSMSNotificationStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSMSNotificationStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProbeUploadPermitStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProbeUploadPermitStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgProbeUploadPermitStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgProbeUploadPermitStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProbeUploadPermitStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProbeUploadPermitStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgProbeUploadPermitStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgProbeUploadPermitStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProbeUploadPermitStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProbeUploadPermitStatusGet();

   virtual ~midw_ext_tcufi_tclMsgProbeUploadPermitStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgProbeUploadPermitStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus& operator=(const midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus& coRef);
   midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus(const midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_InvalidParameter e8InvalidParameter;
   midw_ext_fi_tcl_e8_TCU_ProbePermitSetting e8ProbePermitSetting;
   virtual ~midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProbeInfoDeleteStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProbeInfoDeleteStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgProbeInfoDeleteStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgProbeInfoDeleteStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProbeInfoDeleteStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProbeInfoDeleteStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgProbeInfoDeleteStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgProbeInfoDeleteStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProbeInfoDeleteStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProbeInfoDeleteStatusGet();

   virtual ~midw_ext_tcufi_tclMsgProbeInfoDeleteStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgProbeInfoDeleteStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus& operator=(const midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus& coRef);
   midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus(const midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bStatusFromTCU;
   virtual ~midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallStateUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallStateUpReg();

   virtual ~midw_ext_tcufi_tclMsgServiceCallStateUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgServiceCallStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallStateRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallStateRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgServiceCallStateRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgServiceCallStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallStateGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallStateGet();

   virtual ~midw_ext_tcufi_tclMsgServiceCallStateGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgServiceCallStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallStateStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgServiceCallStateStatus& operator=(const midw_ext_tcufi_tclMsgServiceCallStateStatus& coRef);
   midw_ext_tcufi_tclMsgServiceCallStateStatus(const midw_ext_tcufi_tclMsgServiceCallStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_ServiceState e8ServiceState;
   virtual ~midw_ext_tcufi_tclMsgServiceCallStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgServiceCallStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallRequestUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallRequestUpReg();

   virtual ~midw_ext_tcufi_tclMsgServiceCallRequestUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgServiceCallRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallRequestRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallRequestRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgServiceCallRequestRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgServiceCallRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallRequestGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallRequestGet();

   virtual ~midw_ext_tcufi_tclMsgServiceCallRequestGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgServiceCallRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallRequestStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgServiceCallRequestStatus& operator=(const midw_ext_tcufi_tclMsgServiceCallRequestStatus& coRef);
   midw_ext_tcufi_tclMsgServiceCallRequestStatus(const midw_ext_tcufi_tclMsgServiceCallRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bServiceCallActive;
   tBool bValid;
   virtual ~midw_ext_tcufi_tclMsgServiceCallRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgServiceCallRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallOperationStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallOperationStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgServiceCallOperationStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgServiceCallOperationStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallOperationStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallOperationStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgServiceCallOperationStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgServiceCallOperationStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallOperationStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallOperationStatusGet();

   virtual ~midw_ext_tcufi_tclMsgServiceCallOperationStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgServiceCallOperationStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgServiceCallOperationStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgServiceCallOperationStatusStatus();

   virtual ~midw_ext_tcufi_tclMsgServiceCallOperationStatusStatus();

   inline tBool operator==(const midw_ext_tcufi_tclMsgServiceCallOperationStatusStatus& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTcuCallServiceStateUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTcuCallServiceStateUpReg();

   virtual ~midw_ext_tcufi_tclMsgTcuCallServiceStateUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTcuCallServiceStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTcuCallServiceStateRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTcuCallServiceStateRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgTcuCallServiceStateRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTcuCallServiceStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTcuCallServiceStateGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTcuCallServiceStateGet();

   virtual ~midw_ext_tcufi_tclMsgTcuCallServiceStateGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTcuCallServiceStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTcuCallServiceStateStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTcuCallServiceStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgTcuCallServiceStateStatus& operator=(const midw_ext_tcufi_tclMsgTcuCallServiceStateStatus& coRef);
   midw_ext_tcufi_tclMsgTcuCallServiceStateStatus(const midw_ext_tcufi_tclMsgTcuCallServiceStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_ServiceState e8ACNCallServiceState;
   midw_ext_fi_tcl_e8_TCU_ServiceState e8EmergencyCallServiceState;
   virtual ~midw_ext_tcufi_tclMsgTcuCallServiceStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgTcuCallServiceStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProvisionServiceUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProvisionServiceUpReg();

   virtual ~midw_ext_tcufi_tclMsgProvisionServiceUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgProvisionServiceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProvisionServiceRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProvisionServiceRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgProvisionServiceRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgProvisionServiceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProvisionServiceGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProvisionServiceGet();

   virtual ~midw_ext_tcufi_tclMsgProvisionServiceGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgProvisionServiceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgProvisionServiceStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgProvisionServiceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgProvisionServiceStatus& operator=(const midw_ext_tcufi_tclMsgProvisionServiceStatus& coRef);
   midw_ext_tcufi_tclMsgProvisionServiceStatus(const midw_ext_tcufi_tclMsgProvisionServiceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Provision_List ProvisionService;
   virtual ~midw_ext_tcufi_tclMsgProvisionServiceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgProvisionServiceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallStateUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallStateUpReg();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallStateUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallStateRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallStateRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallStateRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallStateGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallStateGet();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallStateGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallStateStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgCOMEcallStateStatus& operator=(const midw_ext_tcufi_tclMsgCOMEcallStateStatus& coRef);
   midw_ext_tcufi_tclMsgCOMEcallStateStatus(const midw_ext_tcufi_tclMsgCOMEcallStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_EcallStateDisplay e8EcallStateDisplay;
   virtual ~midw_ext_tcufi_tclMsgCOMEcallStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallStartUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallStartUpReg();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallStartUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallStartUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallStartRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallStartRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallStartRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallStartRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallStartGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallStartGet();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallStartGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallStartGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallStartStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallStartStatus();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallStartStatus();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallStartStatus& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallEndUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallEndUpReg();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallEndUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallEndUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallEndRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallEndRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallEndRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallEndRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallEndGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallEndGet();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallEndGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallEndGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCOMEcallEndStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCOMEcallEndStatus();

   virtual ~midw_ext_tcufi_tclMsgCOMEcallEndStatus();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCOMEcallEndStatus& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUResetStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUResetStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgTCUResetStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUResetStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUResetStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUResetStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgTCUResetStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUResetStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUResetStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUResetStatusGet();

   virtual ~midw_ext_tcufi_tclMsgTCUResetStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUResetStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUResetStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUResetStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgTCUResetStatusStatus& operator=(const midw_ext_tcufi_tclMsgTCUResetStatusStatus& coRef);
   midw_ext_tcufi_tclMsgTCUResetStatusStatus(const midw_ext_tcufi_tclMsgTCUResetStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bStatusFromTCU;
   virtual ~midw_ext_tcufi_tclMsgTCUResetStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgTCUResetStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgEmergencyStateUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgEmergencyStateUpReg();

   virtual ~midw_ext_tcufi_tclMsgEmergencyStateUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgEmergencyStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgEmergencyStateRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgEmergencyStateRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgEmergencyStateRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgEmergencyStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgEmergencyStateGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgEmergencyStateGet();

   virtual ~midw_ext_tcufi_tclMsgEmergencyStateGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgEmergencyStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgEmergencyStateStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgEmergencyStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgEmergencyStateStatus& operator=(const midw_ext_tcufi_tclMsgEmergencyStateStatus& coRef);
   midw_ext_tcufi_tclMsgEmergencyStateStatus(const midw_ext_tcufi_tclMsgEmergencyStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEmergencyStateFromTCU;
   virtual ~midw_ext_tcufi_tclMsgEmergencyStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgEmergencyStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUResponseTimeOutUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUResponseTimeOutUpReg();

   virtual ~midw_ext_tcufi_tclMsgTCUResponseTimeOutUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUResponseTimeOutUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUResponseTimeOutRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUResponseTimeOutRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgTCUResponseTimeOutRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUResponseTimeOutRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUResponseTimeOutGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUResponseTimeOutGet();

   virtual ~midw_ext_tcufi_tclMsgTCUResponseTimeOutGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUResponseTimeOutGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus& operator=(const midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus& coRef);
   midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus(const midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8TcuResponseTimeOut;
   midw_ext_fi_tcl_TCU_Response_Time_Out TcuResponseTimeOut;
   tBool bTcuServiceCallOperationSetTimeOut;
   virtual ~midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUExtendedStateUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUExtendedStateUpReg();

   virtual ~midw_ext_tcufi_tclMsgTCUExtendedStateUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUExtendedStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUExtendedStateRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUExtendedStateRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgTCUExtendedStateRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUExtendedStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUExtendedStateGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUExtendedStateGet();

   virtual ~midw_ext_tcufi_tclMsgTCUExtendedStateGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUExtendedStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUExtendedStateStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUExtendedStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgTCUExtendedStateStatus& operator=(const midw_ext_tcufi_tclMsgTCUExtendedStateStatus& coRef);
   midw_ext_tcufi_tclMsgTCUExtendedStateStatus(const midw_ext_tcufi_tclMsgTCUExtendedStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8Invalid_Parameter;
   midw_ext_fi_tclString sIMEINumber;
   midw_ext_fi_tclString sICC_ID;
   tU16 u16MCC;
   tU8 u8MNC;
   midw_ext_fi_tclString sMobile_Network_Name;
   midw_ext_fi_tcl_e8_TCU_RoamingStatus e8RoamingStatus;
   midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus e8PPP_Connection_Status;
   midw_ext_fi_tcl_e8_TCU_Opcode e8Opcode;
   virtual ~midw_ext_tcufi_tclMsgTCUExtendedStateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgTCUExtendedStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPINSettingStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPINSettingStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgPINSettingStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgPINSettingStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPINSettingStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPINSettingStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgPINSettingStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgPINSettingStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPINSettingStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPINSettingStatusGet();

   virtual ~midw_ext_tcufi_tclMsgPINSettingStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgPINSettingStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPINSettingStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPINSettingStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgPINSettingStatusStatus& operator=(const midw_ext_tcufi_tclMsgPINSettingStatusStatus& coRef);
   midw_ext_tcufi_tclMsgPINSettingStatusStatus(const midw_ext_tcufi_tclMsgPINSettingStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8Invalid_Parameter;
   virtual ~midw_ext_tcufi_tclMsgPINSettingStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgPINSettingStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeReminderStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeReminderStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgChargeReminderStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeReminderStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeReminderStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeReminderStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgChargeReminderStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeReminderStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeReminderStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeReminderStatusGet();

   virtual ~midw_ext_tcufi_tclMsgChargeReminderStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeReminderStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeReminderStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeReminderStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgChargeReminderStatusStatus& operator=(const midw_ext_tcufi_tclMsgChargeReminderStatusStatus& coRef);
   midw_ext_tcufi_tclMsgChargeReminderStatusStatus(const midw_ext_tcufi_tclMsgChargeReminderStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_ReminderInfo rReminderInfo;
   virtual ~midw_ext_tcufi_tclMsgChargeReminderStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgChargeReminderStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeRecordDeleteUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeRecordDeleteUpReg();

   virtual ~midw_ext_tcufi_tclMsgChargeRecordDeleteUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeRecordDeleteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeRecordDeleteRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeRecordDeleteRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgChargeRecordDeleteRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeRecordDeleteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeRecordDeleteGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeRecordDeleteGet();

   virtual ~midw_ext_tcufi_tclMsgChargeRecordDeleteGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeRecordDeleteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeRecordDeleteStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeRecordDeleteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgChargeRecordDeleteStatus& operator=(const midw_ext_tcufi_tclMsgChargeRecordDeleteStatus& coRef);
   midw_ext_tcufi_tclMsgChargeRecordDeleteStatus(const midw_ext_tcufi_tclMsgChargeRecordDeleteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_ReminderInfo rReminderInfo;
   virtual ~midw_ext_tcufi_tclMsgChargeRecordDeleteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgChargeRecordDeleteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgStationFinderStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgStationFinderStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgStationFinderStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgStationFinderStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgStationFinderStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgStationFinderStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgStationFinderStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgStationFinderStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgStationFinderStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgStationFinderStatusGet();

   virtual ~midw_ext_tcufi_tclMsgStationFinderStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgStationFinderStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgStationFinderStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgStationFinderStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgStationFinderStatusStatus& operator=(const midw_ext_tcufi_tclMsgStationFinderStatusStatus& coRef);
   midw_ext_tcufi_tclMsgStationFinderStatusStatus(const midw_ext_tcufi_tclMsgStationFinderStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8Invalid_Parameter;
   midw_ext_fi_tcl_e8_TCU_Finder_Status e8FinderStatus;
   tU8 u8Total_Station_Number;
   virtual ~midw_ext_tcufi_tclMsgStationFinderStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgStationFinderStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeStationStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeStationStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgChargeStationStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeStationStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeStationStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeStationStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgChargeStationStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeStationStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeStationStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeStationStatusGet();

   virtual ~midw_ext_tcufi_tclMsgChargeStationStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeStationStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeStationStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeStationStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgChargeStationStatusStatus& operator=(const midw_ext_tcufi_tclMsgChargeStationStatusStatus& coRef);
   midw_ext_tcufi_tclMsgChargeStationStatusStatus(const midw_ext_tcufi_tclMsgChargeStationStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Station_List_Number;
   midw_ext_fi_tclString sCharge_Station_ID;
   midw_ext_fi_tcl_TCU_GPS_Position rEPOI_GPS_Position;
   midw_ext_fi_tclString sEnergy_Provider_Name;
   midw_ext_fi_tclString sUtility_Aggregator_ID;
   midw_ext_fi_tcl_TCU_Time_Stamp rTime_Stamp;
   midw_ext_fi_tclString sPhone_Number;
   midw_ext_fi_tcl_TCU_Opening_Hour rOpening_Hour;
   midw_ext_fi_tcl_TCU_Charge_Station_Accessibility e8Charge_Station_Accessibility;
   midw_ext_fi_tcl_TCU_Payment_Method_Type e8Payment_Method_Type;
   tU8 u8Spot_Total_Number;
   tU8 u8Number_Available_Batteries;
   midw_ext_fi_tcl_TCU_Full_Address rFull_Address;
   tU8 u8Charge_Staion_Ranking;
   virtual ~midw_ext_tcufi_tclMsgChargeStationStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgChargeStationStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_BookingStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_BookingStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgShort_BookingStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_BookingStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_BookingStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_BookingStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgShort_BookingStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_BookingStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_BookingStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_BookingStatusGet();

   virtual ~midw_ext_tcufi_tclMsgShort_BookingStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_BookingStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_BookingStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_BookingStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgShort_BookingStatusStatus& operator=(const midw_ext_tcufi_tclMsgShort_BookingStatusStatus& coRef);
   midw_ext_tcufi_tclMsgShort_BookingStatusStatus(const midw_ext_tcufi_tclMsgShort_BookingStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8InvalidParameter;
   midw_ext_fi_tcl_e8_TCU_Booking_Status e8Booking_Status;
   virtual ~midw_ext_tcufi_tclMsgShort_BookingStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgShort_BookingStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_BookingIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_BookingIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgShort_BookingIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_BookingIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_BookingIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_BookingIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgShort_BookingIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_BookingIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_BookingIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_BookingIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgShort_BookingIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_BookingIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_BookingIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_BookingIndicationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgShort_BookingIndicationStatus& operator=(const midw_ext_tcufi_tclMsgShort_BookingIndicationStatus& coRef);
   midw_ext_tcufi_tclMsgShort_BookingIndicationStatus(const midw_ext_tcufi_tclMsgShort_BookingIndicationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Booking_Status e8Booking_Status;
   midw_ext_fi_tclString sCharge_Station_ID;
   midw_ext_fi_tclString sCharge_Spot_ID;
   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type e8Charge_Receptacle_Type;
   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility e8Charge_Receptacle_Facility_Byte;
   midw_ext_fi_tcl_TCU_Time rMax_Time_To_Arrive;
   midw_ext_fi_tcl_TCU_Time rMax_Time_To_Unbook;
   midw_ext_fi_tclString sBooking_ID;
   midw_ext_fi_tcl_TCU_Bookable_Free_Text rBookable_Free_Text;
   midw_ext_fi_tcl_TCU_Time_Stamp rTime_Stamp;
   virtual ~midw_ext_tcufi_tclMsgShort_BookingIndicationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgShort_BookingIndicationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_UnbookingStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_UnbookingStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgShort_UnbookingStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_UnbookingStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_UnbookingStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_UnbookingStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgShort_UnbookingStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_UnbookingStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_UnbookingStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_UnbookingStatusGet();

   virtual ~midw_ext_tcufi_tclMsgShort_UnbookingStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_UnbookingStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus& operator=(const midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus& coRef);
   midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus(const midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8InvalidParameter;
   midw_ext_fi_tcl_e8_TCU_Unbooking_Status e8Unbooking_Status;
   virtual ~midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_UnbookingIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_UnbookingIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgShort_UnbookingIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_UnbookingIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_UnbookingIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_UnbookingIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgShort_UnbookingIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_UnbookingIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_UnbookingIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_UnbookingIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgShort_UnbookingIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgShort_UnbookingIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus& operator=(const midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus& coRef);
   midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus(const midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sCharge_Station_ID;
   midw_ext_fi_tclString sCharge_Spot_ID;
   midw_ext_fi_tclString sBooking_ID;
   midw_ext_fi_tcl_e8_TCU_Unbooking_Status e8Unbooking_Status;
   virtual ~midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgUpdateEnergyPointStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgUpdateEnergyPointStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgUpdateEnergyPointStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgUpdateEnergyPointStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgUpdateEnergyPointStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgUpdateEnergyPointStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgUpdateEnergyPointStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgUpdateEnergyPointStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgUpdateEnergyPointStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgUpdateEnergyPointStatusGet();

   virtual ~midw_ext_tcufi_tclMsgUpdateEnergyPointStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgUpdateEnergyPointStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus& operator=(const midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus& coRef);
   midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus(const midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8Invalid_Parameter;
   midw_ext_fi_tcl_e8_TCU_Update_Status e8Update_Status;
   virtual ~midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus& operator=(const midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus& coRef);
   midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus(const midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Update_Status e8Update_Status;
   virtual ~midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_ActivationStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_ActivationStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgSCH_ActivationStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_ActivationStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_ActivationStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_ActivationStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgSCH_ActivationStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_ActivationStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_ActivationStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_ActivationStatusGet();

   virtual ~midw_ext_tcufi_tclMsgSCH_ActivationStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_ActivationStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus& operator=(const midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus& coRef);
   midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus(const midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8Invalid_Parameter;
   midw_ext_fi_tcl_e8_TCU_Sch_Activation_State e8Sch_Activation_State;
   virtual ~midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusGet();

   virtual ~midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus& operator=(const midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus& coRef);
   midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus(const midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8Invalid_Parameter;
   midw_ext_fi_tcl_TCU_Charge_Days rCharge_Day1_7_Start;
   midw_ext_fi_tcl_TCU_Charge_Days rCharge_Day1_7_End;
   virtual ~midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCharge_BlockedIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCharge_BlockedIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgCharge_BlockedIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCharge_BlockedIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCharge_BlockedIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCharge_BlockedIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgCharge_BlockedIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCharge_BlockedIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCharge_BlockedIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCharge_BlockedIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgCharge_BlockedIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCharge_BlockedIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus& operator=(const midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus& coRef);
   midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus(const midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status e8Charge_Blocked_Status;
   virtual ~midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_StateStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_StateStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgSCH_StateStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_StateStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_StateStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_StateStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgSCH_StateStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_StateStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_StateStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_StateStatusGet();

   virtual ~midw_ext_tcufi_tclMsgSCH_StateStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_StateStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_StateStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_StateStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSCH_StateStatusStatus& operator=(const midw_ext_tcufi_tclMsgSCH_StateStatusStatus& coRef);
   midw_ext_tcufi_tclMsgSCH_StateStatusStatus(const midw_ext_tcufi_tclMsgSCH_StateStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8Invalid_Parameter;
   midw_ext_fi_tcl_e8_TCU_Sch_Activation_State e8Sch_Activation_State;
   midw_ext_fi_tcl_TCU_Charge_Days rCharge_Day1_7_Start;
   midw_ext_fi_tcl_TCU_Charge_Days rCharge_Day1_7_End;
   virtual ~midw_ext_tcufi_tclMsgSCH_StateStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSCH_StateStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_StateIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_StateIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgSCH_StateIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_StateIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_StateIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_StateIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgSCH_StateIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_StateIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_StateIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_StateIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgSCH_StateIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSCH_StateIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSCH_StateIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSCH_StateIndicationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSCH_StateIndicationStatus& operator=(const midw_ext_tcufi_tclMsgSCH_StateIndicationStatus& coRef);
   midw_ext_tcufi_tclMsgSCH_StateIndicationStatus(const midw_ext_tcufi_tclMsgSCH_StateIndicationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Sch_Activation_State e8Sch_Activation_State;
   midw_ext_fi_tcl_TCU_Charge_Days rCharge_Day1_7_Start;
   midw_ext_fi_tcl_TCU_Charge_Days rCharge_Day1_7_End;
   virtual ~midw_ext_tcufi_tclMsgSCH_StateIndicationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSCH_StateIndicationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgStationFinderIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgStationFinderIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgStationFinderIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgStationFinderIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgStationFinderIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgStationFinderIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgStationFinderIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgStationFinderIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgStationFinderIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgStationFinderIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgStationFinderIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgStationFinderIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgStationFinderIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgStationFinderIndicationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgStationFinderIndicationStatus& operator=(const midw_ext_tcufi_tclMsgStationFinderIndicationStatus& coRef);
   midw_ext_tcufi_tclMsgStationFinderIndicationStatus(const midw_ext_tcufi_tclMsgStationFinderIndicationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Finder_Status e8FinderStatus;
   tU8 u8Total_Station_Number;
   virtual ~midw_ext_tcufi_tclMsgStationFinderIndicationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgStationFinderIndicationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeSpotListStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeSpotListStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgChargeSpotListStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeSpotListStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeSpotListStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeSpotListStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgChargeSpotListStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeSpotListStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeSpotListStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeSpotListStatusGet();

   virtual ~midw_ext_tcufi_tclMsgChargeSpotListStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgChargeSpotListStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgChargeSpotListStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgChargeSpotListStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgChargeSpotListStatusStatus& operator=(const midw_ext_tcufi_tclMsgChargeSpotListStatusStatus& coRef);
   midw_ext_tcufi_tclMsgChargeSpotListStatusStatus(const midw_ext_tcufi_tclMsgChargeSpotListStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8InvalidParameter;
   midw_ext_fi_tcl_TCU_Charge_Spot_List rChargeSpotList;
   virtual ~midw_ext_tcufi_tclMsgChargeSpotListStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgChargeSpotListStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus& operator=(const midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus& coRef);
   midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus(const midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Wifi_SSID_Name rWifi_SSID_Name;
   midw_ext_fi_tcl_TCU_Wifi_PassKey rWifi_PassKey;
   midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode;
   tU8 u8Wifi_Channel_Number;
   midw_ext_fi_tcl_e8_TCU_Wifi_Visibility e8Wifi_Visibility;
   virtual ~midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiHotSpotRequestUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiHotSpotRequestUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiHotSpotRequestUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiHotSpotRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiHotSpotRequestRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiHotSpotRequestRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiHotSpotRequestRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiHotSpotRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiHotSpotRequestGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiHotSpotRequestGet();

   virtual ~midw_ext_tcufi_tclMsgWifiHotSpotRequestGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiHotSpotRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus& operator=(const midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus& coRef);
   midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus(const midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8Invalid_Parameter;
   midw_ext_fi_tcl_TCU_Wifi_SSID_Name rWifi_SSID_Name;
   midw_ext_fi_tcl_TCU_Wifi_PassKey rWifi_PassKey;
   midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode;
   tU8 u8Wifi_Channel_Number;
   midw_ext_fi_tcl_e8_TCU_Wifi_Visibility e8Wifi_Visibility;
   virtual ~midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiActivationRequestUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiActivationRequestUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiActivationRequestUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiActivationRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiActivationRequestRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiActivationRequestRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiActivationRequestRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiActivationRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiActivationRequestGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiActivationRequestGet();

   virtual ~midw_ext_tcufi_tclMsgWifiActivationRequestGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiActivationRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiActivationRequestStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiActivationRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgWifiActivationRequestStatus& operator=(const midw_ext_tcufi_tclMsgWifiActivationRequestStatus& coRef);
   midw_ext_tcufi_tclMsgWifiActivationRequestStatus(const midw_ext_tcufi_tclMsgWifiActivationRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8Invalid_Parameter;
   midw_ext_fi_tcl_e8_TCU_Wifi_Status e8Wifi_Status;
   midw_ext_fi_tcl_e8_TCU_Wifi_Mode e8Wifi_Mode;
   virtual ~midw_ext_tcufi_tclMsgWifiActivationRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgWifiActivationRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiDataResetUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiDataResetUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiDataResetUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiDataResetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiDataResetRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiDataResetRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiDataResetRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiDataResetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiDataResetGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiDataResetGet();

   virtual ~midw_ext_tcufi_tclMsgWifiDataResetGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiDataResetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiDataResetStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiDataResetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgWifiDataResetStatus& operator=(const midw_ext_tcufi_tclMsgWifiDataResetStatus& coRef);
   midw_ext_tcufi_tclMsgWifiDataResetStatus(const midw_ext_tcufi_tclMsgWifiDataResetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Wifi_SSID_Name rWifi_SSID_Name;
   midw_ext_fi_tcl_TCU_Wifi_PassKey rWifi_PassKey;
   midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode;
   tU8 u8Wifi_Channel_Number;
   midw_ext_fi_tcl_e8_TCU_Wifi_Visibility e8Wifi_Visibility;
   virtual ~midw_ext_tcufi_tclMsgWifiDataResetStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgWifiDataResetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientScanUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientScanRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanGet();

   virtual ~midw_ext_tcufi_tclMsgWifiClientScanGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanStatus();

   virtual ~midw_ext_tcufi_tclMsgWifiClientScanStatus();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanStatus& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientScanIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientScanIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgWifiClientScanIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanIndicationStatus();

   virtual ~midw_ext_tcufi_tclMsgWifiClientScanIndicationStatus();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanIndicationStatus& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientConnectionUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientConnectionUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientConnectionUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientConnectionRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientConnectionRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientConnectionRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientConnectionGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientConnectionGet();

   virtual ~midw_ext_tcufi_tclMsgWifiClientConnectionGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientConnectionStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgWifiClientConnectionStatus& operator=(const midw_ext_tcufi_tclMsgWifiClientConnectionStatus& coRef);
   midw_ext_tcufi_tclMsgWifiClientConnectionStatus(const midw_ext_tcufi_tclMsgWifiClientConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8Invalid_Parameter;
   midw_ext_fi_tcl_TCU_Wifi_SSID_Name rWifi_Scan_SSID_Name;
   midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status e8Wifi_Connection_Status;
   virtual ~midw_ext_tcufi_tclMsgWifiClientConnectionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgWifiClientConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientConnectionIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientConnectionIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientConnectionIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientConnectionIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientConnectionIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientConnectionIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientConnectionIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientConnectionIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientConnectionIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientConnectionIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgWifiClientConnectionIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientConnectionIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus& operator=(const midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus& coRef);
   midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus(const midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Wifi_SSID_Name rWifi_Scan_SSID_Name;
   midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status e8Wifi_Connection_Status;
   virtual ~midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientDisconnectionUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientDisconnectionUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientDisconnectionUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientDisconnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientDisconnectionRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientDisconnectionRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientDisconnectionRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientDisconnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientDisconnectionGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientDisconnectionGet();

   virtual ~midw_ext_tcufi_tclMsgWifiClientDisconnectionGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientDisconnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientDisconnectionStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientDisconnectionStatus();

   virtual ~midw_ext_tcufi_tclMsgWifiClientDisconnectionStatus();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientDisconnectionStatus& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanResultIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanResultIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientScanResultIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanResultIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanResultIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanResultIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientScanResultIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanResultIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanResultIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanResultIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgWifiClientScanResultIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanResultIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus& operator=(const midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus& coRef);
   midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus(const midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Wifi_SSID_Name rWifi_Scan_SSID_Name;
   tU8 u8Wifi_Scan_Power;
   midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security e8Wifi_Scan_Security;
   virtual ~midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestGet();

   virtual ~midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus& operator=(const midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus& coRef);
   midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus(const midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Wifi_Connected_Devices;
   virtual ~midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientStateUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientStateUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientStateUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientStateRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientStateRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientStateRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientStateGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientStateGet();

   virtual ~midw_ext_tcufi_tclMsgWifiClientStateGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientStateStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgWifiClientStateStatus& operator=(const midw_ext_tcufi_tclMsgWifiClientStateStatus& coRef);
   midw_ext_tcufi_tclMsgWifiClientStateStatus(const midw_ext_tcufi_tclMsgWifiClientStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status e8Wifi_Client_Status;
   midw_ext_fi_tcl_TCU_Wifi_SSID_Name rWifi_SSID;
   tU8 u8Wifi_Client_Power;
   virtual ~midw_ext_tcufi_tclMsgWifiClientStateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgWifiClientStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientStateIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientStateIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientStateIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientStateIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientStateIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientStateIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiClientStateIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientStateIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientStateIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientStateIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgWifiClientStateIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiClientStateIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus& operator=(const midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus& coRef);
   midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus(const midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status e8Wifi_Client_Status;
   midw_ext_fi_tcl_TCU_Wifi_SSID_Name rWifi_SSID;
   tU8 u8Wifi_Client_Power;
   virtual ~midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationGet();

   virtual ~midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationStatus();

   virtual ~midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationStatus();

   inline tBool operator==(const midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationStatus& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgHardwareVersionUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgHardwareVersionUpReg();

   virtual ~midw_ext_tcufi_tclMsgHardwareVersionUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgHardwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgHardwareVersionRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgHardwareVersionRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgHardwareVersionRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgHardwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgHardwareVersionGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgHardwareVersionGet();

   virtual ~midw_ext_tcufi_tclMsgHardwareVersionGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgHardwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgHardwareVersionStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgHardwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgHardwareVersionStatus& operator=(const midw_ext_tcufi_tclMsgHardwareVersionStatus& coRef);
   midw_ext_tcufi_tclMsgHardwareVersionStatus(const midw_ext_tcufi_tclMsgHardwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_VersionInfo rHardwareVersion;
   virtual ~midw_ext_tcufi_tclMsgHardwareVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgHardwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSoftwareVersionUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSoftwareVersionUpReg();

   virtual ~midw_ext_tcufi_tclMsgSoftwareVersionUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSoftwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSoftwareVersionRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSoftwareVersionRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgSoftwareVersionRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSoftwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSoftwareVersionGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSoftwareVersionGet();

   virtual ~midw_ext_tcufi_tclMsgSoftwareVersionGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSoftwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSoftwareVersionStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSoftwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSoftwareVersionStatus& operator=(const midw_ext_tcufi_tclMsgSoftwareVersionStatus& coRef);
   midw_ext_tcufi_tclMsgSoftwareVersionStatus(const midw_ext_tcufi_tclMsgSoftwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_VersionInfo rSoftwareVersion;
   virtual ~midw_ext_tcufi_tclMsgSoftwareVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSoftwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPush_POIUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPush_POIUpReg();

   virtual ~midw_ext_tcufi_tclMsgPush_POIUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgPush_POIUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPush_POIRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPush_POIRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgPush_POIRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgPush_POIRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPush_POIGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPush_POIGet();

   virtual ~midw_ext_tcufi_tclMsgPush_POIGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgPush_POIGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPush_POIStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPush_POIStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgPush_POIStatus& operator=(const midw_ext_tcufi_tclMsgPush_POIStatus& coRef);
   midw_ext_tcufi_tclMsgPush_POIStatus(const midw_ext_tcufi_tclMsgPush_POIStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bValid;
   tU32 u32POI_ID;
   midw_ext_fi_tcl_TCU_GPS_Position rPOI_GPS_Position;
   midw_ext_fi_tclString sPOI_Name;
   virtual ~midw_ext_tcufi_tclMsgPush_POIStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgPush_POIStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTime_LimitUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTime_LimitUpReg();

   virtual ~midw_ext_tcufi_tclMsgTime_LimitUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTime_LimitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTime_LimitRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTime_LimitRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgTime_LimitRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTime_LimitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTime_LimitGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTime_LimitGet();

   virtual ~midw_ext_tcufi_tclMsgTime_LimitGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTime_LimitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTime_LimitStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTime_LimitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgTime_LimitStatus& operator=(const midw_ext_tcufi_tclMsgTime_LimitStatus& coRef);
   midw_ext_tcufi_tclMsgTime_LimitStatus(const midw_ext_tcufi_tclMsgTime_LimitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bValid;
   midw_ext_fi_tcl_TCU_Time_Slot rTime_Slot;
   virtual ~midw_ext_tcufi_tclMsgTime_LimitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgTime_LimitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSpeed_LimitUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSpeed_LimitUpReg();

   virtual ~midw_ext_tcufi_tclMsgSpeed_LimitUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSpeed_LimitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSpeed_LimitRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSpeed_LimitRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgSpeed_LimitRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSpeed_LimitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSpeed_LimitGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSpeed_LimitGet();

   virtual ~midw_ext_tcufi_tclMsgSpeed_LimitGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgSpeed_LimitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgSpeed_LimitStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgSpeed_LimitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgSpeed_LimitStatus& operator=(const midw_ext_tcufi_tclMsgSpeed_LimitStatus& coRef);
   midw_ext_tcufi_tclMsgSpeed_LimitStatus(const midw_ext_tcufi_tclMsgSpeed_LimitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bValid;
   tU16 u16Limited_Vehicle_Speed;
   midw_ext_fi_tcl_TCU_Time_Slot rTime_Slot;
   virtual ~midw_ext_tcufi_tclMsgSpeed_LimitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgSpeed_LimitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgArea_LimitUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgArea_LimitUpReg();

   virtual ~midw_ext_tcufi_tclMsgArea_LimitUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgArea_LimitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgArea_LimitRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgArea_LimitRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgArea_LimitRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgArea_LimitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgArea_LimitGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgArea_LimitGet();

   virtual ~midw_ext_tcufi_tclMsgArea_LimitGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgArea_LimitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgArea_LimitStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgArea_LimitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgArea_LimitStatus& operator=(const midw_ext_tcufi_tclMsgArea_LimitStatus& coRef);
   midw_ext_tcufi_tclMsgArea_LimitStatus(const midw_ext_tcufi_tclMsgArea_LimitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bValid;
   midw_ext_fi_tcl_TCU_Area_Limit_Coordinates rArea_Limit_Coordinates;
   midw_ext_fi_tcl_TCU_Time_Slot rTime_Slot;
   virtual ~midw_ext_tcufi_tclMsgArea_LimitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgArea_LimitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGeofencing_ActivationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGeofencing_ActivationUpReg();

   virtual ~midw_ext_tcufi_tclMsgGeofencing_ActivationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGeofencing_ActivationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGeofencing_ActivationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGeofencing_ActivationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgGeofencing_ActivationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGeofencing_ActivationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGeofencing_ActivationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGeofencing_ActivationGet();

   virtual ~midw_ext_tcufi_tclMsgGeofencing_ActivationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgGeofencing_ActivationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgGeofencing_ActivationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgGeofencing_ActivationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgGeofencing_ActivationStatus& operator=(const midw_ext_tcufi_tclMsgGeofencing_ActivationStatus& coRef);
   midw_ext_tcufi_tclMsgGeofencing_ActivationStatus(const midw_ext_tcufi_tclMsgGeofencing_ActivationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bValid;
   tU8 u8Geofencing_Activation_State ;
   virtual ~midw_ext_tcufi_tclMsgGeofencing_ActivationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgGeofencing_ActivationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgRestriction_SettingsUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgRestriction_SettingsUpReg();

   virtual ~midw_ext_tcufi_tclMsgRestriction_SettingsUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgRestriction_SettingsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgRestriction_SettingsRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgRestriction_SettingsRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgRestriction_SettingsRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgRestriction_SettingsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgRestriction_SettingsGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgRestriction_SettingsGet();

   virtual ~midw_ext_tcufi_tclMsgRestriction_SettingsGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgRestriction_SettingsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgRestriction_SettingsStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgRestriction_SettingsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgRestriction_SettingsStatus& operator=(const midw_ext_tcufi_tclMsgRestriction_SettingsStatus& coRef);
   midw_ext_tcufi_tclMsgRestriction_SettingsStatus(const midw_ext_tcufi_tclMsgRestriction_SettingsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bValid;
   midw_ext_fi_tcl_TCU_Time_Limit_Restriction rTime_Limit_Restriction;
   midw_ext_fi_tcl_TCU_Speed_Limit_Restriction rSpeed_Limit_Restriction;
   midw_ext_fi_tcl_TCU_Area_Limit_Restriction rArea_Limit_Restriction;
   virtual ~midw_ext_tcufi_tclMsgRestriction_SettingsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgRestriction_SettingsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConnection_Setup_StatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConnection_Setup_StatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgConnection_Setup_StatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgConnection_Setup_StatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConnection_Setup_StatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConnection_Setup_StatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgConnection_Setup_StatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgConnection_Setup_StatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConnection_Setup_StatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConnection_Setup_StatusGet();

   virtual ~midw_ext_tcufi_tclMsgConnection_Setup_StatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgConnection_Setup_StatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus& operator=(const midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus& coRef);
   midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus(const midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_ConnectionType e8ConnectionType;
   virtual ~midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgXCallStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgXCallStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgXCallStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgXCallStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallStatusGet();

   virtual ~midw_ext_tcufi_tclMsgXCallStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgXCallStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgXCallStatusStatus& operator=(const midw_ext_tcufi_tclMsgXCallStatusStatus& coRef);
   midw_ext_tcufi_tclMsgXCallStatusStatus(const midw_ext_tcufi_tclMsgXCallStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8InvalidParameter;
   virtual ~midw_ext_tcufi_tclMsgXCallStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgXCallStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallStateUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallStateUpReg();

   virtual ~midw_ext_tcufi_tclMsgXCallStateUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgXCallStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallStateRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallStateRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgXCallStateRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgXCallStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallStateGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallStateGet();

   virtual ~midw_ext_tcufi_tclMsgXCallStateGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgXCallStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallStateStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgXCallStateStatus& operator=(const midw_ext_tcufi_tclMsgXCallStateStatus& coRef);
   midw_ext_tcufi_tclMsgXCallStateStatus(const midw_ext_tcufi_tclMsgXCallStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_ServiceState e8XCallState;
   virtual ~midw_ext_tcufi_tclMsgXCallStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgXCallStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallEndUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallEndUpReg();

   virtual ~midw_ext_tcufi_tclMsgXCallEndUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgXCallEndUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallEndRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallEndRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgXCallEndRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgXCallEndRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallEndGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallEndGet();

   virtual ~midw_ext_tcufi_tclMsgXCallEndGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgXCallEndGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgXCallEndStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgXCallEndStatus();

   virtual ~midw_ext_tcufi_tclMsgXCallEndStatus();

   inline tBool operator==(const midw_ext_tcufi_tclMsgXCallEndStatus& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCallDuartionUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCallDuartionUpReg();

   virtual ~midw_ext_tcufi_tclMsgCallDuartionUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCallDuartionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCallDuartionRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCallDuartionRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgCallDuartionRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCallDuartionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCallDuartionGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCallDuartionGet();

   virtual ~midw_ext_tcufi_tclMsgCallDuartionGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgCallDuartionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgCallDuartionStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgCallDuartionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgCallDuartionStatus& operator=(const midw_ext_tcufi_tclMsgCallDuartionStatus& coRef);
   midw_ext_tcufi_tclMsgCallDuartionStatus(const midw_ext_tcufi_tclMsgCallDuartionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bIsValid;
   midw_ext_fi_tcl_e8_TCU_CallType rCallType;
   midw_ext_fi_tcl_TCU_Time rCallDuartion;
   virtual ~midw_ext_tcufi_tclMsgCallDuartionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgCallDuartionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPrivacyModeActivationUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPrivacyModeActivationUpReg();

   virtual ~midw_ext_tcufi_tclMsgPrivacyModeActivationUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgPrivacyModeActivationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPrivacyModeActivationRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPrivacyModeActivationRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgPrivacyModeActivationRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgPrivacyModeActivationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPrivacyModeActivationGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPrivacyModeActivationGet();

   virtual ~midw_ext_tcufi_tclMsgPrivacyModeActivationGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgPrivacyModeActivationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgPrivacyModeActivationStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgPrivacyModeActivationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgPrivacyModeActivationStatus& operator=(const midw_ext_tcufi_tclMsgPrivacyModeActivationStatus& coRef);
   midw_ext_tcufi_tclMsgPrivacyModeActivationStatus(const midw_ext_tcufi_tclMsgPrivacyModeActivationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bIsValid;
   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter e8InvalidParameter;
   midw_ext_fi_tcl_e8_TCU_PrivacyModes e8PrivacyMode;
   virtual ~midw_ext_tcufi_tclMsgPrivacyModeActivationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgPrivacyModeActivationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUConfigurationStatusUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUConfigurationStatusUpReg();

   virtual ~midw_ext_tcufi_tclMsgTCUConfigurationStatusUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUConfigurationStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUConfigurationStatusRelUpReg : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUConfigurationStatusRelUpReg();

   virtual ~midw_ext_tcufi_tclMsgTCUConfigurationStatusRelUpReg();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUConfigurationStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUConfigurationStatusGet : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUConfigurationStatusGet();

   virtual ~midw_ext_tcufi_tclMsgTCUConfigurationStatusGet();

   inline tBool operator==(const midw_ext_tcufi_tclMsgTCUConfigurationStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus : public midw_ext_tcufi_tclMsgBaseMessage
{
public:

   midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus& operator=(const midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus& coRef);
   midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus(const midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Availability rTCU_CurrentAvailabilityConfiguration;
   tBool bAutoConfigured;
   virtual ~midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
