/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_TCUFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_TCUFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_TCUFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_ext_tcu_fi message types

fi_tclMessageBase* midw_ext_tcufi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_tcufi_tclToken::EN_MSG_ACCEPTECALLREQUESTMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_ACCEPTECALLREQUESTMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgAcceptECallRequestMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_ECALLCANCELLATIONORDERMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgECallCancellationOrderMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_ECALLCANCELLATIONORDERMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgECallCancellationOrderMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETTCUSTATEMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetTCUStateMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETTCUSTATEMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetTCUStateMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETIDINFOMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetIDInfoMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETIDINFOMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetIDInfoMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETDRIVERINFOUPLOADPERMITMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETDRIVERINFOUPLOADPERMITMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETSERVICECALLOPERATIONMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETSERVICECALLOPERATIONMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetServiceCallOperationMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETNAVIINFOMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetNaviInfoMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETNAVIINFOMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetNaviInfoMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETTRIPSCOREINFOMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETTRIPSCOREINFOMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetTripScoreInfoMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPROBEVEHICLEINFOMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPROBEVEHICLEINFOMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_MAINTENANCEINFOMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_MAINTENANCEINFOMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgMaintenanceInfoMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTSTATUSMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTSTATUSMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETTCURESETMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetTCUResetMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETTCURESETMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetTCUResetMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETTCUEXTENDEDSTATEMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETTCUEXTENDEDSTATEMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPINSETTINGMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetPINSettingMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPINSETTINGMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetPINSettingMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETCHARGEREMINDERMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetChargeReminderMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETCHARGEREMINDERMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetChargeReminderMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETCHARGEREMINDERMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetChargeReminderMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETCHARGEREMINDERMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetChargeReminderMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETSTATIONFINDERMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetStationFinderMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETSTATIONFINDERMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetStationFinderMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETCHARGESTATIONMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetChargeStationMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETCHARGESTATIONMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetChargeStationMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETCHARGESPOTLISTMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETCHARGESPOTLISTMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetChargeSpotListMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETSHORTBOOKINGMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetShortBookingMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETSHORTBOOKINGMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetShortBookingMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETSHORTUNBOOKINGMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETSHORTUNBOOKINGMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetShortUnbookingMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETUPDATEENERGYPOINTMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETUPDATEENERGYPOINTMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETSCH_ACTIVATIONMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETSCH_ACTIVATIONMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetSCH_ActivationMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETSCH_UPDATE_ONBOARDMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETSCH_UPDATE_ONBOARDMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETSCH_STATEMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetSCH_StateMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETSCH_STATEMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetSCH_StateMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFIHOTSPOTREQUESTMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFIHOTSPOTREQUESTMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFIACTIVATIONREQUESTMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFIACTIVATIONREQUESTMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFIDATARESETMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiDataResetMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFIDATARESETMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiDataResetMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTSCANMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiClientScanMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTSCANMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiClientScanMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTCONNECTIONMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTCONNECTIONMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTDISCONNECTIONMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTDISCONNECTIONMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETWIFICONNECTEDDEVICESREQUESTMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETWIFICONNECTEDDEVICESREQUESTMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETWIFICLIENTSTATEMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetWifiClientStateMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETWIFICLIENTSTATEMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetWifiClientStateMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_DTMECALLMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgDTMEcallMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_DTMECALLMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgDTMEcallMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_RESETHISTORYMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgResetHistoryMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgResetHistoryMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETHARDWAREVERSIONMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetHardwareVersionMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETHARDWAREVERSIONMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetHardwareVersionMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETSOFTWAREVERSIONMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetSoftwareVersionMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETSOFTWAREVERSIONMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetSoftwareVersionMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPUSH_POISTATUSMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPUSH_POISTATUSMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetPush_POIStatusMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETGEOFENCING_ACTIVATIONSTATUSMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETGEOFENCING_ACTIVATIONSTATUSMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETRESTRICTION_SETTINGSMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETRESTRICTION_SETTINGSMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLSTARTMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallStartMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLSTARTMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallStartMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPRIVICYMODEMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_SETPRIVICYMODEMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgSetPrivicyModeMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_GETTCUCONFIGURATIONSTATUSMETHODSTART:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodStart;

      case midw_ext_tcufi_tclToken::EN_MSG_GETTCUCONFIGURATIONSTATUSMETHODRESULT:
         return OSAL_NEW midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult;

      case midw_ext_tcufi_tclToken::EN_MSG_CONNECTIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgConnectionUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CONNECTIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgConnectionRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CONNECTIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgConnectionGet;

      case midw_ext_tcufi_tclToken::EN_MSG_CONNECTIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgConnectionStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_CONFIGURATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgConfigurationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CONFIGURATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgConfigurationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CONFIGURATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgConfigurationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_CONFIGURATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgConfigurationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_DATATRANSMISSIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgDataTransmissionUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_DATATRANSMISSIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgDataTransmissionRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_DATATRANSMISSIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgDataTransmissionGet;

      case midw_ext_tcufi_tclToken::EN_MSG_DATATRANSMISSIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgDataTransmissionStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_ECALLREQUESTUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgECallRequestUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_ECALLREQUESTRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgECallRequestRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_ECALLREQUESTGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgECallRequestGet;

      case midw_ext_tcufi_tclToken::EN_MSG_ECALLREQUESTSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgECallRequestStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_ECALLSERVICESTATEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgECallServiceStateUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_ECALLSERVICESTATERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgECallServiceStateRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_ECALLSERVICESTATEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgECallServiceStateGet;

      case midw_ext_tcufi_tclToken::EN_MSG_ECALLSERVICESTATESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgECallServiceStateStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_ACNREQUESTUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgACNRequestUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_ACNREQUESTRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgACNRequestRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_ACNREQUESTGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgACNRequestGet;

      case midw_ext_tcufi_tclToken::EN_MSG_ACNREQUESTSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgACNRequestStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_ACNSERVICESTATEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgACNServiceStateUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_ACNSERVICESTATERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgACNServiceStateRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_ACNSERVICESTATEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgACNServiceStateGet;

      case midw_ext_tcufi_tclToken::EN_MSG_ACNSERVICESTATESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgACNServiceStateStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_CURFEWALERTUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCurfewAlertUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CURFEWALERTRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCurfewAlertRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CURFEWALERTGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgCurfewAlertGet;

      case midw_ext_tcufi_tclToken::EN_MSG_CURFEWALERTSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgCurfewAlertStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_GEOFENCEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgGeoFenceUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_GEOFENCERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgGeoFenceRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_GEOFENCEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgGeoFenceGet;

      case midw_ext_tcufi_tclToken::EN_MSG_GEOFENCESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgGeoFenceStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SPEEDALERTUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSpeedAlertUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SPEEDALERTRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSpeedAlertRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SPEEDALERTGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgSpeedAlertGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SPEEDALERTSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgSpeedAlertStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUSTATEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUStateUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUSTATERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUStateRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUSTATEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUStateGet;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUSTATESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUStateStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_IDINFOSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgIDInfoStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_IDINFOSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgIDInfoStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_IDINFOSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgIDInfoStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_IDINFOSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgIDInfoStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_DRIVERINFOUPLOADPERMITSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_DRIVERINFOUPLOADPERMITSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_DRIVERINFOUPLOADPERMITSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_DRIVERINFOUPLOADPERMITSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SMSNOTIFICATIONSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSMSNotificationStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SMSNOTIFICATIONSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSMSNotificationStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SMSNOTIFICATIONSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgSMSNotificationStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SMSNOTIFICATIONSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgSMSNotificationStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_PROBEUPLOADPERMITSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgProbeUploadPermitStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PROBEUPLOADPERMITSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgProbeUploadPermitStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PROBEUPLOADPERMITSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgProbeUploadPermitStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_PROBEUPLOADPERMITSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_PROBEINFODELETESTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgProbeInfoDeleteStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PROBEINFODELETESTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgProbeInfoDeleteStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PROBEINFODELETESTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgProbeInfoDeleteStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_PROBEINFODELETESTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLSTATEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallStateUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLSTATERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallStateRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLSTATEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallStateGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLSTATESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallStateStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLREQUESTUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallRequestUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLREQUESTRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallRequestRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLREQUESTGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallRequestGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLREQUESTSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallRequestStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLOPERATIONSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallOperationStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLOPERATIONSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallOperationStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLOPERATIONSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallOperationStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLOPERATIONSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgServiceCallOperationStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUCALLSERVICESTATEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTcuCallServiceStateUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUCALLSERVICESTATERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTcuCallServiceStateRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUCALLSERVICESTATEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgTcuCallServiceStateGet;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUCALLSERVICESTATESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgTcuCallServiceStateStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_PROVISIONSERVICEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgProvisionServiceUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PROVISIONSERVICERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgProvisionServiceRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PROVISIONSERVICEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgProvisionServiceGet;

      case midw_ext_tcufi_tclToken::EN_MSG_PROVISIONSERVICESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgProvisionServiceStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTATEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallStateUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTATERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallStateRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTATEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallStateGet;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTATESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallStateStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallStartUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallStartRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallStartGet;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallStartStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLENDUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallEndUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLENDRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallEndRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLENDGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallEndGet;

      case midw_ext_tcufi_tclToken::EN_MSG_COMECALLENDSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgCOMEcallEndStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_TCURESETSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUResetStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCURESETSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUResetStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCURESETSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUResetStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_TCURESETSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUResetStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_EMERGENCYSTATEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgEmergencyStateUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_EMERGENCYSTATERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgEmergencyStateRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_EMERGENCYSTATEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgEmergencyStateGet;

      case midw_ext_tcufi_tclToken::EN_MSG_EMERGENCYSTATESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgEmergencyStateStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_TCURESPONSETIMEOUTUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUResponseTimeOutUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCURESPONSETIMEOUTRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUResponseTimeOutRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCURESPONSETIMEOUTGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUResponseTimeOutGet;

      case midw_ext_tcufi_tclToken::EN_MSG_TCURESPONSETIMEOUTSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUEXTENDEDSTATEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUExtendedStateUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUEXTENDEDSTATERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUExtendedStateRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUEXTENDEDSTATEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUExtendedStateGet;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUEXTENDEDSTATESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUExtendedStateStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_PINSETTINGSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgPINSettingStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PINSETTINGSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgPINSettingStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PINSETTINGSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgPINSettingStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_PINSETTINGSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgPINSettingStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGEREMINDERSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeReminderStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGEREMINDERSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeReminderStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGEREMINDERSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeReminderStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGEREMINDERSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeReminderStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGERECORDDELETEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeRecordDeleteUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGERECORDDELETERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeRecordDeleteRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGERECORDDELETEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeRecordDeleteGet;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGERECORDDELETESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeRecordDeleteStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgStationFinderStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgStationFinderStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgStationFinderStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgStationFinderStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGESTATIONSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeStationStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGESTATIONSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeStationStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGESTATIONSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeStationStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGESTATIONSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeStationStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_BookingStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_BookingStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_BookingStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_BookingStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_BookingIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_BookingIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_BookingIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_BookingIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_UnbookingStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_UnbookingStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_UnbookingStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_UnbookingIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_UnbookingIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_UnbookingIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgUpdateEnergyPointStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgUpdateEnergyPointStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgUpdateEnergyPointStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_ACTIVATIONSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_ActivationStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_ACTIVATIONSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_ActivationStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_ACTIVATIONSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_ActivationStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_ACTIVATIONSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_UPDATE_ONBOARDSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_UPDATE_ONBOARDSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_UPDATE_ONBOARDSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_UPDATE_ONBOARDSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGE_BLOCKEDINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCharge_BlockedIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGE_BLOCKEDINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCharge_BlockedIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGE_BLOCKEDINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgCharge_BlockedIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGE_BLOCKEDINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_STATESTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_StateStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_STATESTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_StateStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_STATESTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_StateStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_STATESTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_StateStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_STATEINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_StateIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_STATEINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_StateIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_STATEINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_StateIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SCH_STATEINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgSCH_StateIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgStationFinderIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgStationFinderIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgStationFinderIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgStationFinderIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGESPOTLISTSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeSpotListStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGESPOTLISTSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeSpotListStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGESPOTLISTSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeSpotListStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_CHARGESPOTLISTSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgChargeSpotListStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiHotSpotRequestUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiHotSpotRequestRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiHotSpotRequestGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIACTIVATIONREQUESTUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiActivationRequestUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIACTIVATIONREQUESTRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiActivationRequestRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIACTIVATIONREQUESTGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiActivationRequestGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIACTIVATIONREQUESTSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiActivationRequestStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIDATARESETUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiDataResetUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIDATARESETRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiDataResetRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIDATARESETGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiDataResetGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFIDATARESETSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiDataResetStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientConnectionUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientConnectionRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientConnectionGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientConnectionStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientConnectionIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientConnectionIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientConnectionIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTDISCONNECTIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientDisconnectionUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTDISCONNECTIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientDisconnectionRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTDISCONNECTIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientDisconnectionGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTDISCONNECTIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientDisconnectionStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANRESULTINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanResultIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANRESULTINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanResultIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANRESULTINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanResultIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANRESULTINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTEDDEVICESREQUESTUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTEDDEVICESREQUESTRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTEDDEVICESREQUESTGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTEDDEVICESREQUESTSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientStateUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientStateRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientStateGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientStateStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientStateIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientStateIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientStateIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_HARDWAREVERSIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgHardwareVersionUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgHardwareVersionRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_HARDWAREVERSIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgHardwareVersionGet;

      case midw_ext_tcufi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgHardwareVersionStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSoftwareVersionUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSoftwareVersionRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SOFTWAREVERSIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgSoftwareVersionGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgSoftwareVersionStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_PUSH_POIUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgPush_POIUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PUSH_POIRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgPush_POIRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PUSH_POIGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgPush_POIGet;

      case midw_ext_tcufi_tclToken::EN_MSG_PUSH_POISTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgPush_POIStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_TIME_LIMITUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTime_LimitUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TIME_LIMITRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTime_LimitRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TIME_LIMITGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgTime_LimitGet;

      case midw_ext_tcufi_tclToken::EN_MSG_TIME_LIMITSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgTime_LimitStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_SPEED_LIMITUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSpeed_LimitUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SPEED_LIMITRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgSpeed_LimitRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_SPEED_LIMITGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgSpeed_LimitGet;

      case midw_ext_tcufi_tclToken::EN_MSG_SPEED_LIMITSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgSpeed_LimitStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_AREA_LIMITUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgArea_LimitUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_AREA_LIMITRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgArea_LimitRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_AREA_LIMITGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgArea_LimitGet;

      case midw_ext_tcufi_tclToken::EN_MSG_AREA_LIMITSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgArea_LimitStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_GEOFENCING_ACTIVATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgGeofencing_ActivationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_GEOFENCING_ACTIVATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgGeofencing_ActivationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_GEOFENCING_ACTIVATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgGeofencing_ActivationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_GEOFENCING_ACTIVATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgGeofencing_ActivationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_RESTRICTION_SETTINGSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgRestriction_SettingsUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_RESTRICTION_SETTINGSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgRestriction_SettingsRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_RESTRICTION_SETTINGSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgRestriction_SettingsGet;

      case midw_ext_tcufi_tclToken::EN_MSG_RESTRICTION_SETTINGSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgRestriction_SettingsStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_CONNECTION_SETUP_STATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgConnection_Setup_StatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CONNECTION_SETUP_STATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgConnection_Setup_StatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CONNECTION_SETUP_STATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgConnection_Setup_StatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_CONNECTION_SETUP_STATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallStatusStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATEUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallStateUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATERELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallStateRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATEGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallStateGet;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATESTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallStateStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLENDUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallEndUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLENDRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallEndRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLENDGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallEndGet;

      case midw_ext_tcufi_tclToken::EN_MSG_XCALLENDSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgXCallEndStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_CALLDUARTIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCallDuartionUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CALLDUARTIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgCallDuartionRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_CALLDUARTIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgCallDuartionGet;

      case midw_ext_tcufi_tclToken::EN_MSG_CALLDUARTIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgCallDuartionStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_PRIVACYMODEACTIVATIONUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgPrivacyModeActivationUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PRIVACYMODEACTIVATIONRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgPrivacyModeActivationRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_PRIVACYMODEACTIVATIONGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgPrivacyModeActivationGet;

      case midw_ext_tcufi_tclToken::EN_MSG_PRIVACYMODEACTIVATIONSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgPrivacyModeActivationStatus;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUCONFIGURATIONSTATUSUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUConfigurationStatusUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUCONFIGURATIONSTATUSRELUPREG:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUConfigurationStatusRelUpReg;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUCONFIGURATIONSTATUSGET:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUConfigurationStatusGet;

      case midw_ext_tcufi_tclToken::EN_MSG_TCUCONFIGURATIONSTATUSSTATUS:
         return OSAL_NEW midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_tcufifi messages

// common functions

tU16 midw_ext_tcufi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_TCUFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_tcufi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_tcufi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_tcufi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_tcufi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_tcufi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_tcufi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart::midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart(const midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bECallAccepted = coRef.bECallAccepted;
}
midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart& midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart::operator=(const midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bECallAccepted = coRef.bECallAccepted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart::midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart()
:bECallAccepted(0)
 {}

tS32 midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ACCEPTECALLREQUESTMETHODSTART;
}


midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart::~midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bECallAccepted);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bECallAccepted);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart::operator==(const midw_ext_tcufi_tclMsgAcceptECallRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bECallAccepted == roRef.bECallAccepted);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgAcceptECallRequestMethodResult::midw_ext_tcufi_tclMsgAcceptECallRequestMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgAcceptECallRequestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ACCEPTECALLREQUESTMETHODRESULT;
}


midw_ext_tcufi_tclMsgAcceptECallRequestMethodResult::~midw_ext_tcufi_tclMsgAcceptECallRequestMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgECallCancellationOrderMethodStart::midw_ext_tcufi_tclMsgECallCancellationOrderMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgECallCancellationOrderMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ECALLCANCELLATIONORDERMETHODSTART;
}


midw_ext_tcufi_tclMsgECallCancellationOrderMethodStart::~midw_ext_tcufi_tclMsgECallCancellationOrderMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgECallCancellationOrderMethodResult::midw_ext_tcufi_tclMsgECallCancellationOrderMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgECallCancellationOrderMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ECALLCANCELLATIONORDERMETHODRESULT;
}


midw_ext_tcufi_tclMsgECallCancellationOrderMethodResult::~midw_ext_tcufi_tclMsgECallCancellationOrderMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetTCUStateMethodStart::midw_ext_tcufi_tclMsgGetTCUStateMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgGetTCUStateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETTCUSTATEMETHODSTART;
}


midw_ext_tcufi_tclMsgGetTCUStateMethodStart::~midw_ext_tcufi_tclMsgGetTCUStateMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetTCUStateMethodResult::midw_ext_tcufi_tclMsgGetTCUStateMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetTCUStateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETTCUSTATEMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetTCUStateMethodResult::~midw_ext_tcufi_tclMsgGetTCUStateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgGetIDInfoMethodStart::midw_ext_tcufi_tclMsgGetIDInfoMethodStart(const midw_ext_tcufi_tclMsgGetIDInfoMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   NaviId = coRef.NaviId;
   MapVersion = coRef.MapVersion;
}
midw_ext_tcufi_tclMsgGetIDInfoMethodStart& midw_ext_tcufi_tclMsgGetIDInfoMethodStart::operator=(const midw_ext_tcufi_tclMsgGetIDInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NaviId = coRef.NaviId;
   MapVersion = coRef.MapVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgGetIDInfoMethodStart::vDestroy()
{
   NaviId.vDestroy();
   MapVersion.vDestroy();
}

midw_ext_tcufi_tclMsgGetIDInfoMethodStart::midw_ext_tcufi_tclMsgGetIDInfoMethodStart()
:NaviId()
,MapVersion()
 {}

tS32 midw_ext_tcufi_tclMsgGetIDInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETIDINFOMETHODSTART;
}


midw_ext_tcufi_tclMsgGetIDInfoMethodStart::~midw_ext_tcufi_tclMsgGetIDInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgGetIDInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+NaviId.u32GetSize(u16MajorVersion)+MapVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgGetIDInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NaviId);
   (tVoid) (oIn >> MapVersion);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgGetIDInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NaviId);
   (tVoid) (oOut << MapVersion);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgGetIDInfoMethodStart::operator==(const midw_ext_tcufi_tclMsgGetIDInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NaviId == roRef.NaviId);
   bResult = bResult && (MapVersion == roRef.MapVersion);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgGetIDInfoMethodResult::midw_ext_tcufi_tclMsgGetIDInfoMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetIDInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETIDINFOMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetIDInfoMethodResult::~midw_ext_tcufi_tclMsgGetIDInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart::midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart(const midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8PermitSetting = coRef.e8PermitSetting;
}
midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart& midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart::operator=(const midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8PermitSetting = coRef.e8PermitSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart::midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart()
:e8PermitSetting()
 {}

tS32 midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETDRIVERINFOUPLOADPERMITMETHODSTART;
}


midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart::~midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PermitSetting);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PermitSetting);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart::operator==(const midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PermitSetting == roRef.e8PermitSetting);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodResult::midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETDRIVERINFOUPLOADPERMITMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodResult::~midw_ext_tcufi_tclMsgSetDriverInfoUploadPermitMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodStart::midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODSTART;
}


midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodStart::~midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodResult::midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodResult::~midw_ext_tcufi_tclMsgGetProbeUploadPermitMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart::midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart(const midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8ProbePermitSetting = coRef.e8ProbePermitSetting;
}
midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart& midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart::operator=(const midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ProbePermitSetting = coRef.e8ProbePermitSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart::midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart()
:e8ProbePermitSetting()
 {}

tS32 midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODSTART;
}


midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart::~midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ProbePermitSetting);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ProbePermitSetting);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart::operator==(const midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ProbePermitSetting == roRef.e8ProbePermitSetting);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodResult::midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodResult::~midw_ext_tcufi_tclMsgSetProbeUploadPermitMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodStart::midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODSTART;
}


midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodStart::~midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodResult::midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodResult::~midw_ext_tcufi_tclMsgSetProbeInfoDeleteMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart::midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart(const midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8OperationRequest = coRef.e8OperationRequest;
}
midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart& midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart::operator=(const midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8OperationRequest = coRef.e8OperationRequest;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart::midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart()
:e8OperationRequest()
 {}

tS32 midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETSERVICECALLOPERATIONMETHODSTART;
}


midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart::~midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8OperationRequest);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8OperationRequest);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart::operator==(const midw_ext_tcufi_tclMsgSetServiceCallOperationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8OperationRequest == roRef.e8OperationRequest);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetServiceCallOperationMethodResult::midw_ext_tcufi_tclMsgSetServiceCallOperationMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetServiceCallOperationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETSERVICECALLOPERATIONMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetServiceCallOperationMethodResult::~midw_ext_tcufi_tclMsgSetServiceCallOperationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetNaviInfoMethodStart::midw_ext_tcufi_tclMsgSetNaviInfoMethodStart(const midw_ext_tcufi_tclMsgSetNaviInfoMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rNaviData = coRef.rNaviData;
}
midw_ext_tcufi_tclMsgSetNaviInfoMethodStart& midw_ext_tcufi_tclMsgSetNaviInfoMethodStart::operator=(const midw_ext_tcufi_tclMsgSetNaviInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   rNaviData = coRef.rNaviData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetNaviInfoMethodStart::midw_ext_tcufi_tclMsgSetNaviInfoMethodStart()
:rNaviData()
 {}

tS32 midw_ext_tcufi_tclMsgSetNaviInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETNAVIINFOMETHODSTART;
}


midw_ext_tcufi_tclMsgSetNaviInfoMethodStart::~midw_ext_tcufi_tclMsgSetNaviInfoMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetNaviInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 28;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetNaviInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rNaviData);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetNaviInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rNaviData);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetNaviInfoMethodStart::operator==(const midw_ext_tcufi_tclMsgSetNaviInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rNaviData == roRef.rNaviData);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetNaviInfoMethodResult::midw_ext_tcufi_tclMsgSetNaviInfoMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetNaviInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETNAVIINFOMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetNaviInfoMethodResult::~midw_ext_tcufi_tclMsgSetNaviInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart::midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart(const midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rTripEcoScoreInfo = coRef.rTripEcoScoreInfo;
}
midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart& midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart::operator=(const midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   rTripEcoScoreInfo = coRef.rTripEcoScoreInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart::midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart()
:rTripEcoScoreInfo()
 {}

tS32 midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETTRIPSCOREINFOMETHODSTART;
}


midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart::~midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rTripEcoScoreInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rTripEcoScoreInfo);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart::operator==(const midw_ext_tcufi_tclMsgSetTripScoreInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rTripEcoScoreInfo == roRef.rTripEcoScoreInfo);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetTripScoreInfoMethodResult::midw_ext_tcufi_tclMsgSetTripScoreInfoMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetTripScoreInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETTRIPSCOREINFOMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetTripScoreInfoMethodResult::~midw_ext_tcufi_tclMsgSetTripScoreInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart::midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart(const midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rProbeVehicleInfo = coRef.rProbeVehicleInfo;
}
midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart& midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart::operator=(const midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   rProbeVehicleInfo = coRef.rProbeVehicleInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart::midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart()
:rProbeVehicleInfo()
 {}

tS32 midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPROBEVEHICLEINFOMETHODSTART;
}


midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart::~midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rProbeVehicleInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rProbeVehicleInfo);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart::operator==(const midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rProbeVehicleInfo == roRef.rProbeVehicleInfo);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodResult::midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPROBEVEHICLEINFOMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodResult::~midw_ext_tcufi_tclMsgSetProbeVehicleInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart::midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart(const midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   MaintenanceInfo = coRef.MaintenanceInfo;
}
midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart& midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart::operator=(const midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MaintenanceInfo = coRef.MaintenanceInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart::midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart()
:MaintenanceInfo()
 {}

tS32 midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_MAINTENANCEINFOMETHODSTART;
}


midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart::~midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MaintenanceInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MaintenanceInfo);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart::operator==(const midw_ext_tcufi_tclMsgMaintenanceInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MaintenanceInfo == roRef.MaintenanceInfo);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgMaintenanceInfoMethodResult::midw_ext_tcufi_tclMsgMaintenanceInfoMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgMaintenanceInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_MAINTENANCEINFOMETHODRESULT;
}


midw_ext_tcufi_tclMsgMaintenanceInfoMethodResult::~midw_ext_tcufi_tclMsgMaintenanceInfoMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodStart::midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTSTATUSMETHODSTART;
}


midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodStart::~midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodResult::midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTSTATUSMETHODRESULT;
}


midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodResult::~midw_ext_tcufi_tclMsgCOMEcallStartStatusMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSetTCUResetMethodStart::midw_ext_tcufi_tclMsgSetTCUResetMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgSetTCUResetMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETTCURESETMETHODSTART;
}


midw_ext_tcufi_tclMsgSetTCUResetMethodStart::~midw_ext_tcufi_tclMsgSetTCUResetMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSetTCUResetMethodResult::midw_ext_tcufi_tclMsgSetTCUResetMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetTCUResetMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETTCURESETMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetTCUResetMethodResult::~midw_ext_tcufi_tclMsgSetTCUResetMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodStart::midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETTCUEXTENDEDSTATEMETHODSTART;
}


midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodStart::~midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodResult::midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETTCUEXTENDEDSTATEMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodResult::~midw_ext_tcufi_tclMsgGetTCUExtendedStateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetPINSettingMethodStart::midw_ext_tcufi_tclMsgSetPINSettingMethodStart(const midw_ext_tcufi_tclMsgSetPINSettingMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rPIN = coRef.rPIN;
}
midw_ext_tcufi_tclMsgSetPINSettingMethodStart& midw_ext_tcufi_tclMsgSetPINSettingMethodStart::operator=(const midw_ext_tcufi_tclMsgSetPINSettingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   rPIN = coRef.rPIN;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgSetPINSettingMethodStart::vDestroy()
{
   rPIN.vDestroy(); 
}

midw_ext_tcufi_tclMsgSetPINSettingMethodStart::midw_ext_tcufi_tclMsgSetPINSettingMethodStart()
:rPIN()
 {}

tS32 midw_ext_tcufi_tclMsgSetPINSettingMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPINSETTINGMETHODSTART;
}


midw_ext_tcufi_tclMsgSetPINSettingMethodStart::~midw_ext_tcufi_tclMsgSetPINSettingMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgSetPINSettingMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+rPIN.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetPINSettingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rPIN);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetPINSettingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rPIN);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetPINSettingMethodStart::operator==(const midw_ext_tcufi_tclMsgSetPINSettingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rPIN == roRef.rPIN);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetPINSettingMethodResult::midw_ext_tcufi_tclMsgSetPINSettingMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetPINSettingMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPINSETTINGMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetPINSettingMethodResult::~midw_ext_tcufi_tclMsgSetPINSettingMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetChargeReminderMethodStart::midw_ext_tcufi_tclMsgGetChargeReminderMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgGetChargeReminderMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETCHARGEREMINDERMETHODSTART;
}


midw_ext_tcufi_tclMsgGetChargeReminderMethodStart::~midw_ext_tcufi_tclMsgGetChargeReminderMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetChargeReminderMethodResult::midw_ext_tcufi_tclMsgGetChargeReminderMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetChargeReminderMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETCHARGEREMINDERMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetChargeReminderMethodResult::~midw_ext_tcufi_tclMsgGetChargeReminderMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetChargeReminderMethodStart::midw_ext_tcufi_tclMsgSetChargeReminderMethodStart(const midw_ext_tcufi_tclMsgSetChargeReminderMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rReminderInfo = coRef.rReminderInfo;
}
midw_ext_tcufi_tclMsgSetChargeReminderMethodStart& midw_ext_tcufi_tclMsgSetChargeReminderMethodStart::operator=(const midw_ext_tcufi_tclMsgSetChargeReminderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   rReminderInfo = coRef.rReminderInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetChargeReminderMethodStart::midw_ext_tcufi_tclMsgSetChargeReminderMethodStart()
:rReminderInfo()
 {}

tS32 midw_ext_tcufi_tclMsgSetChargeReminderMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETCHARGEREMINDERMETHODSTART;
}


midw_ext_tcufi_tclMsgSetChargeReminderMethodStart::~midw_ext_tcufi_tclMsgSetChargeReminderMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetChargeReminderMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetChargeReminderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rReminderInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetChargeReminderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rReminderInfo);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetChargeReminderMethodStart::operator==(const midw_ext_tcufi_tclMsgSetChargeReminderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rReminderInfo == roRef.rReminderInfo);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetChargeReminderMethodResult::midw_ext_tcufi_tclMsgSetChargeReminderMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetChargeReminderMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETCHARGEREMINDERMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetChargeReminderMethodResult::~midw_ext_tcufi_tclMsgSetChargeReminderMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgGetStationFinderMethodStart::midw_ext_tcufi_tclMsgGetStationFinderMethodStart(const midw_ext_tcufi_tclMsgGetStationFinderMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8ServiceType = coRef.e8ServiceType;
   sCurrentCountry = coRef.sCurrentCountry;
   rSearch_GPS_Position = coRef.rSearch_GPS_Position;
   e8ePOI_Type = coRef.e8ePOI_Type;
   rSpot_Receptacle_Type = coRef.rSpot_Receptacle_Type;
   u16Vehicle_Autonomy = coRef.u16Vehicle_Autonomy;
   u32BatteryIdentificationNumber = coRef.u32BatteryIdentificationNumber;
   rNavigation_Language = coRef.rNavigation_Language;
}
midw_ext_tcufi_tclMsgGetStationFinderMethodStart& midw_ext_tcufi_tclMsgGetStationFinderMethodStart::operator=(const midw_ext_tcufi_tclMsgGetStationFinderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ServiceType = coRef.e8ServiceType;
   sCurrentCountry = coRef.sCurrentCountry;
   rSearch_GPS_Position = coRef.rSearch_GPS_Position;
   e8ePOI_Type = coRef.e8ePOI_Type;
   rSpot_Receptacle_Type = coRef.rSpot_Receptacle_Type;
   u16Vehicle_Autonomy = coRef.u16Vehicle_Autonomy;
   u32BatteryIdentificationNumber = coRef.u32BatteryIdentificationNumber;
   rNavigation_Language = coRef.rNavigation_Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgGetStationFinderMethodStart::vDestroy()
{
   sCurrentCountry.vDestroy();
   rSearch_GPS_Position.vDestroy(); 
   rSpot_Receptacle_Type.vDestroy(); 
   rNavigation_Language.vDestroy(); 
}

midw_ext_tcufi_tclMsgGetStationFinderMethodStart::midw_ext_tcufi_tclMsgGetStationFinderMethodStart()
:e8ServiceType()
,sCurrentCountry()
,rSearch_GPS_Position()
,e8ePOI_Type()
,rSpot_Receptacle_Type()
,u16Vehicle_Autonomy(0)
,u32BatteryIdentificationNumber(0)
,rNavigation_Language()
 {}

tS32 midw_ext_tcufi_tclMsgGetStationFinderMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETSTATIONFINDERMETHODSTART;
}


midw_ext_tcufi_tclMsgGetStationFinderMethodStart::~midw_ext_tcufi_tclMsgGetStationFinderMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgGetStationFinderMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 31+sCurrentCountry.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgGetStationFinderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ServiceType);
   (tVoid) (oIn >> sCurrentCountry);
   (tVoid) (oIn >> rSearch_GPS_Position);
   (tVoid) (oIn >> e8ePOI_Type);
   (tVoid) (oIn >> rSpot_Receptacle_Type);
   (tVoid) (oIn >> u16Vehicle_Autonomy);
   (tVoid) (oIn >> u32BatteryIdentificationNumber);
   (tVoid) (oIn >> rNavigation_Language);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgGetStationFinderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ServiceType);
   (tVoid) (oOut << sCurrentCountry);
   (tVoid) (oOut << rSearch_GPS_Position);
   (tVoid) (oOut << e8ePOI_Type);
   (tVoid) (oOut << rSpot_Receptacle_Type);
   (tVoid) (oOut << u16Vehicle_Autonomy);
   (tVoid) (oOut << u32BatteryIdentificationNumber);
   (tVoid) (oOut << rNavigation_Language);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgGetStationFinderMethodStart::operator==(const midw_ext_tcufi_tclMsgGetStationFinderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ServiceType == roRef.e8ServiceType);
   bResult = bResult && (sCurrentCountry == roRef.sCurrentCountry);
   bResult = bResult && (rSearch_GPS_Position == roRef.rSearch_GPS_Position);
   bResult = bResult && (e8ePOI_Type == roRef.e8ePOI_Type);
   bResult = bResult && (rSpot_Receptacle_Type == roRef.rSpot_Receptacle_Type);
   bResult = bResult && (u16Vehicle_Autonomy == roRef.u16Vehicle_Autonomy);
   bResult = bResult && (u32BatteryIdentificationNumber == roRef.u32BatteryIdentificationNumber);
   bResult = bResult && (rNavigation_Language == roRef.rNavigation_Language);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgGetStationFinderMethodResult::midw_ext_tcufi_tclMsgGetStationFinderMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetStationFinderMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETSTATIONFINDERMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetStationFinderMethodResult::~midw_ext_tcufi_tclMsgGetStationFinderMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgGetChargeStationMethodStart::midw_ext_tcufi_tclMsgGetChargeStationMethodStart(const midw_ext_tcufi_tclMsgGetChargeStationMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   u8Station_List_Number = coRef.u8Station_List_Number;
}
midw_ext_tcufi_tclMsgGetChargeStationMethodStart& midw_ext_tcufi_tclMsgGetChargeStationMethodStart::operator=(const midw_ext_tcufi_tclMsgGetChargeStationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Station_List_Number = coRef.u8Station_List_Number;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgGetChargeStationMethodStart::midw_ext_tcufi_tclMsgGetChargeStationMethodStart()
:u8Station_List_Number(0)
 {}

tS32 midw_ext_tcufi_tclMsgGetChargeStationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETCHARGESTATIONMETHODSTART;
}


midw_ext_tcufi_tclMsgGetChargeStationMethodStart::~midw_ext_tcufi_tclMsgGetChargeStationMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgGetChargeStationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgGetChargeStationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Station_List_Number);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgGetChargeStationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Station_List_Number);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgGetChargeStationMethodStart::operator==(const midw_ext_tcufi_tclMsgGetChargeStationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Station_List_Number == roRef.u8Station_List_Number);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgGetChargeStationMethodResult::midw_ext_tcufi_tclMsgGetChargeStationMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetChargeStationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETCHARGESTATIONMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetChargeStationMethodResult::~midw_ext_tcufi_tclMsgGetChargeStationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart::midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart(const midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   u8Station_List_Number = coRef.u8Station_List_Number;
   u8Pages_Of_List = coRef.u8Pages_Of_List;
}
midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart& midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart::operator=(const midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Station_List_Number = coRef.u8Station_List_Number;
   u8Pages_Of_List = coRef.u8Pages_Of_List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart::midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart()
:u8Station_List_Number(0)
,u8Pages_Of_List(0)
 {}

tS32 midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETCHARGESPOTLISTMETHODSTART;
}


midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart::~midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Station_List_Number);
   (tVoid) (oIn >> u8Pages_Of_List);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Station_List_Number);
   (tVoid) (oOut << u8Pages_Of_List);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart::operator==(const midw_ext_tcufi_tclMsgGetChargeSpotListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Station_List_Number == roRef.u8Station_List_Number);
   bResult = bResult && (u8Pages_Of_List == roRef.u8Pages_Of_List);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgGetChargeSpotListMethodResult::midw_ext_tcufi_tclMsgGetChargeSpotListMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetChargeSpotListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETCHARGESPOTLISTMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetChargeSpotListMethodResult::~midw_ext_tcufi_tclMsgGetChargeSpotListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgGetShortBookingMethodStart::midw_ext_tcufi_tclMsgGetShortBookingMethodStart(const midw_ext_tcufi_tclMsgGetShortBookingMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   sCustomer_Contract_ID = coRef.sCustomer_Contract_ID;
   e8ePOI_Type = coRef.e8ePOI_Type;
   e8Charge_Receptacle_Type = coRef.e8Charge_Receptacle_Type;
   sUtility_Aggregator_ID = coRef.sUtility_Aggregator_ID;
   sCurrent_Country = coRef.sCurrent_Country;
   sCharge_Spot_ID = coRef.sCharge_Spot_ID;
   u32Battery_Identification_Number = coRef.u32Battery_Identification_Number;
   rService_Time_Request = coRef.rService_Time_Request;
   rNavigation_Language = coRef.rNavigation_Language;
   rTime_Stamp = coRef.rTime_Stamp;
}
midw_ext_tcufi_tclMsgGetShortBookingMethodStart& midw_ext_tcufi_tclMsgGetShortBookingMethodStart::operator=(const midw_ext_tcufi_tclMsgGetShortBookingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   sCustomer_Contract_ID = coRef.sCustomer_Contract_ID;
   e8ePOI_Type = coRef.e8ePOI_Type;
   e8Charge_Receptacle_Type = coRef.e8Charge_Receptacle_Type;
   sUtility_Aggregator_ID = coRef.sUtility_Aggregator_ID;
   sCurrent_Country = coRef.sCurrent_Country;
   sCharge_Spot_ID = coRef.sCharge_Spot_ID;
   u32Battery_Identification_Number = coRef.u32Battery_Identification_Number;
   rService_Time_Request = coRef.rService_Time_Request;
   rNavigation_Language = coRef.rNavigation_Language;
   rTime_Stamp = coRef.rTime_Stamp;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgGetShortBookingMethodStart::vDestroy()
{
   sCharge_Station_ID.vDestroy();
   sCustomer_Contract_ID.vDestroy();
   sUtility_Aggregator_ID.vDestroy();
   sCurrent_Country.vDestroy();
   sCharge_Spot_ID.vDestroy();
   rService_Time_Request.vDestroy(); 
   rNavigation_Language.vDestroy(); 
   rTime_Stamp.vDestroy(); 
}

midw_ext_tcufi_tclMsgGetShortBookingMethodStart::midw_ext_tcufi_tclMsgGetShortBookingMethodStart()
:sCharge_Station_ID()
,sCustomer_Contract_ID()
,e8ePOI_Type()
,e8Charge_Receptacle_Type()
,sUtility_Aggregator_ID()
,sCurrent_Country()
,sCharge_Spot_ID()
,u32Battery_Identification_Number(0)
,rService_Time_Request()
,rNavigation_Language()
,rTime_Stamp()
 {}

tS32 midw_ext_tcufi_tclMsgGetShortBookingMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETSHORTBOOKINGMETHODSTART;
}


midw_ext_tcufi_tclMsgGetShortBookingMethodStart::~midw_ext_tcufi_tclMsgGetShortBookingMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgGetShortBookingMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 18+sCharge_Station_ID.u32GetSize(u16MajorVersion)+sCustomer_Contract_ID.u32GetSize(u16MajorVersion)+sUtility_Aggregator_ID.u32GetSize(u16MajorVersion)+sCurrent_Country.u32GetSize(u16MajorVersion)+sCharge_Spot_ID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgGetShortBookingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sCharge_Station_ID);
   (tVoid) (oIn >> sCustomer_Contract_ID);
   (tVoid) (oIn >> e8ePOI_Type);
   (tVoid) (oIn >> e8Charge_Receptacle_Type);
   (tVoid) (oIn >> sUtility_Aggregator_ID);
   (tVoid) (oIn >> sCurrent_Country);
   (tVoid) (oIn >> sCharge_Spot_ID);
   (tVoid) (oIn >> u32Battery_Identification_Number);
   (tVoid) (oIn >> rService_Time_Request);
   (tVoid) (oIn >> rNavigation_Language);
   (tVoid) (oIn >> rTime_Stamp);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgGetShortBookingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sCharge_Station_ID);
   (tVoid) (oOut << sCustomer_Contract_ID);
   (tVoid) (oOut << e8ePOI_Type);
   (tVoid) (oOut << e8Charge_Receptacle_Type);
   (tVoid) (oOut << sUtility_Aggregator_ID);
   (tVoid) (oOut << sCurrent_Country);
   (tVoid) (oOut << sCharge_Spot_ID);
   (tVoid) (oOut << u32Battery_Identification_Number);
   (tVoid) (oOut << rService_Time_Request);
   (tVoid) (oOut << rNavigation_Language);
   (tVoid) (oOut << rTime_Stamp);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgGetShortBookingMethodStart::operator==(const midw_ext_tcufi_tclMsgGetShortBookingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sCharge_Station_ID == roRef.sCharge_Station_ID);
   bResult = bResult && (sCustomer_Contract_ID == roRef.sCustomer_Contract_ID);
   bResult = bResult && (e8ePOI_Type == roRef.e8ePOI_Type);
   bResult = bResult && (e8Charge_Receptacle_Type == roRef.e8Charge_Receptacle_Type);
   bResult = bResult && (sUtility_Aggregator_ID == roRef.sUtility_Aggregator_ID);
   bResult = bResult && (sCurrent_Country == roRef.sCurrent_Country);
   bResult = bResult && (sCharge_Spot_ID == roRef.sCharge_Spot_ID);
   bResult = bResult && (u32Battery_Identification_Number == roRef.u32Battery_Identification_Number);
   bResult = bResult && (rService_Time_Request == roRef.rService_Time_Request);
   bResult = bResult && (rNavigation_Language == roRef.rNavigation_Language);
   bResult = bResult && (rTime_Stamp == roRef.rTime_Stamp);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgGetShortBookingMethodResult::midw_ext_tcufi_tclMsgGetShortBookingMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetShortBookingMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETSHORTBOOKINGMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetShortBookingMethodResult::~midw_ext_tcufi_tclMsgGetShortBookingMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart::midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart(const midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   sCustomer_Contract_ID = coRef.sCustomer_Contract_ID;
   sUtility_Aggregator_ID = coRef.sUtility_Aggregator_ID;
   sCurrent_Country = coRef.sCurrent_Country;
   sCharge_Spot_ID = coRef.sCharge_Spot_ID;
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   sBooking_ID = coRef.sBooking_ID;
}
midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart& midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart::operator=(const midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sCustomer_Contract_ID = coRef.sCustomer_Contract_ID;
   sUtility_Aggregator_ID = coRef.sUtility_Aggregator_ID;
   sCurrent_Country = coRef.sCurrent_Country;
   sCharge_Spot_ID = coRef.sCharge_Spot_ID;
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   sBooking_ID = coRef.sBooking_ID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart::vDestroy()
{
   sCustomer_Contract_ID.vDestroy();
   sUtility_Aggregator_ID.vDestroy();
   sCurrent_Country.vDestroy();
   sCharge_Spot_ID.vDestroy();
   sCharge_Station_ID.vDestroy();
   sBooking_ID.vDestroy();
}

midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart::midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart()
:sCustomer_Contract_ID()
,sUtility_Aggregator_ID()
,sCurrent_Country()
,sCharge_Spot_ID()
,sCharge_Station_ID()
,sBooking_ID()
 {}

tS32 midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETSHORTUNBOOKINGMETHODSTART;
}


midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart::~midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sCustomer_Contract_ID.u32GetSize(u16MajorVersion)+sUtility_Aggregator_ID.u32GetSize(u16MajorVersion)+sCurrent_Country.u32GetSize(u16MajorVersion)+sCharge_Spot_ID.u32GetSize(u16MajorVersion)+sCharge_Station_ID.u32GetSize(u16MajorVersion)+sBooking_ID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sCustomer_Contract_ID);
   (tVoid) (oIn >> sUtility_Aggregator_ID);
   (tVoid) (oIn >> sCurrent_Country);
   (tVoid) (oIn >> sCharge_Spot_ID);
   (tVoid) (oIn >> sCharge_Station_ID);
   (tVoid) (oIn >> sBooking_ID);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sCustomer_Contract_ID);
   (tVoid) (oOut << sUtility_Aggregator_ID);
   (tVoid) (oOut << sCurrent_Country);
   (tVoid) (oOut << sCharge_Spot_ID);
   (tVoid) (oOut << sCharge_Station_ID);
   (tVoid) (oOut << sBooking_ID);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart::operator==(const midw_ext_tcufi_tclMsgGetShortUnbookingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sCustomer_Contract_ID == roRef.sCustomer_Contract_ID);
   bResult = bResult && (sUtility_Aggregator_ID == roRef.sUtility_Aggregator_ID);
   bResult = bResult && (sCurrent_Country == roRef.sCurrent_Country);
   bResult = bResult && (sCharge_Spot_ID == roRef.sCharge_Spot_ID);
   bResult = bResult && (sCharge_Station_ID == roRef.sCharge_Station_ID);
   bResult = bResult && (sBooking_ID == roRef.sBooking_ID);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgGetShortUnbookingMethodResult::midw_ext_tcufi_tclMsgGetShortUnbookingMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetShortUnbookingMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETSHORTUNBOOKINGMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetShortUnbookingMethodResult::~midw_ext_tcufi_tclMsgGetShortUnbookingMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart::midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart(const midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   sCurrent_Country = coRef.sCurrent_Country;
   rEPOI_GPS_Position = coRef.rEPOI_GPS_Position;
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   sUtility_Aggregator_ID = coRef.sUtility_Aggregator_ID;
   u32Battery_Identification_Number = coRef.u32Battery_Identification_Number;
   rNavigation_Language = coRef.rNavigation_Language;
   sBooking_ID = coRef.sBooking_ID;
}
midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart& midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart::operator=(const midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sCurrent_Country = coRef.sCurrent_Country;
   rEPOI_GPS_Position = coRef.rEPOI_GPS_Position;
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   sUtility_Aggregator_ID = coRef.sUtility_Aggregator_ID;
   u32Battery_Identification_Number = coRef.u32Battery_Identification_Number;
   rNavigation_Language = coRef.rNavigation_Language;
   sBooking_ID = coRef.sBooking_ID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart::vDestroy()
{
   sCurrent_Country.vDestroy();
   rEPOI_GPS_Position.vDestroy(); 
   sCharge_Station_ID.vDestroy();
   sUtility_Aggregator_ID.vDestroy();
   rNavigation_Language.vDestroy(); 
   sBooking_ID.vDestroy();
}

midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart::midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart()
:sCurrent_Country()
,rEPOI_GPS_Position()
,sCharge_Station_ID()
,sUtility_Aggregator_ID()
,u32Battery_Identification_Number(0)
,rNavigation_Language()
,sBooking_ID()
 {}

tS32 midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETUPDATEENERGYPOINTMETHODSTART;
}


midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart::~midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 19+sCurrent_Country.u32GetSize(u16MajorVersion)+sCharge_Station_ID.u32GetSize(u16MajorVersion)+sUtility_Aggregator_ID.u32GetSize(u16MajorVersion)+sBooking_ID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sCurrent_Country);
   (tVoid) (oIn >> rEPOI_GPS_Position);
   (tVoid) (oIn >> sCharge_Station_ID);
   (tVoid) (oIn >> sUtility_Aggregator_ID);
   (tVoid) (oIn >> u32Battery_Identification_Number);
   (tVoid) (oIn >> rNavigation_Language);
   (tVoid) (oIn >> sBooking_ID);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sCurrent_Country);
   (tVoid) (oOut << rEPOI_GPS_Position);
   (tVoid) (oOut << sCharge_Station_ID);
   (tVoid) (oOut << sUtility_Aggregator_ID);
   (tVoid) (oOut << u32Battery_Identification_Number);
   (tVoid) (oOut << rNavigation_Language);
   (tVoid) (oOut << sBooking_ID);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart::operator==(const midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sCurrent_Country == roRef.sCurrent_Country);
   bResult = bResult && (rEPOI_GPS_Position == roRef.rEPOI_GPS_Position);
   bResult = bResult && (sCharge_Station_ID == roRef.sCharge_Station_ID);
   bResult = bResult && (sUtility_Aggregator_ID == roRef.sUtility_Aggregator_ID);
   bResult = bResult && (u32Battery_Identification_Number == roRef.u32Battery_Identification_Number);
   bResult = bResult && (rNavigation_Language == roRef.rNavigation_Language);
   bResult = bResult && (sBooking_ID == roRef.sBooking_ID);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodResult::midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETUPDATEENERGYPOINTMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodResult::~midw_ext_tcufi_tclMsgGetUpdateEnergyPointMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart::midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart(const midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Sch_Activation_State = coRef.e8Sch_Activation_State;
}
midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart& midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart::operator=(const midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Sch_Activation_State = coRef.e8Sch_Activation_State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart::midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart()
:e8Sch_Activation_State()
 {}

tS32 midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETSCH_ACTIVATIONMETHODSTART;
}


midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart::~midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Sch_Activation_State);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Sch_Activation_State);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart::operator==(const midw_ext_tcufi_tclMsgSetSCH_ActivationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Sch_Activation_State == roRef.e8Sch_Activation_State);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetSCH_ActivationMethodResult::midw_ext_tcufi_tclMsgSetSCH_ActivationMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetSCH_ActivationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETSCH_ACTIVATIONMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetSCH_ActivationMethodResult::~midw_ext_tcufi_tclMsgSetSCH_ActivationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart::midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart(const midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rCharge_Day1_7_Start = coRef.rCharge_Day1_7_Start;
   rCharge_Day1_7_End = coRef.rCharge_Day1_7_End;
}
midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart& midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart::operator=(const midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart& coRef)
{
   if (this == &coRef) return *this;
   rCharge_Day1_7_Start = coRef.rCharge_Day1_7_Start;
   rCharge_Day1_7_End = coRef.rCharge_Day1_7_End;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart::midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart()
:rCharge_Day1_7_Start()
,rCharge_Day1_7_End()
 {}

tS32 midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETSCH_UPDATE_ONBOARDMETHODSTART;
}


midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart::~midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rCharge_Day1_7_Start);
   (tVoid) (oIn >> rCharge_Day1_7_End);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rCharge_Day1_7_Start);
   (tVoid) (oOut << rCharge_Day1_7_End);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart::operator==(const midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rCharge_Day1_7_Start == roRef.rCharge_Day1_7_Start);
   bResult = bResult && (rCharge_Day1_7_End == roRef.rCharge_Day1_7_End);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodResult::midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETSCH_UPDATE_ONBOARDMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodResult::~midw_ext_tcufi_tclMsgSetSCH_Update_ONBOARDMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetSCH_StateMethodStart::midw_ext_tcufi_tclMsgGetSCH_StateMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgGetSCH_StateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETSCH_STATEMETHODSTART;
}


midw_ext_tcufi_tclMsgGetSCH_StateMethodStart::~midw_ext_tcufi_tclMsgGetSCH_StateMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetSCH_StateMethodResult::midw_ext_tcufi_tclMsgGetSCH_StateMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetSCH_StateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETSCH_STATEMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetSCH_StateMethodResult::~midw_ext_tcufi_tclMsgGetSCH_StateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart::midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart(const midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rWifi_SSID_Name = coRef.rWifi_SSID_Name;
   rWifi_PassKey = coRef.rWifi_PassKey;
   e8Wifi_Security_Mode = coRef.e8Wifi_Security_Mode;
   u8Wifi_Channel_Number = coRef.u8Wifi_Channel_Number;
   e8Wifi_Visibility = coRef.e8Wifi_Visibility;
}
midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart& midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart::operator=(const midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   rWifi_SSID_Name = coRef.rWifi_SSID_Name;
   rWifi_PassKey = coRef.rWifi_PassKey;
   e8Wifi_Security_Mode = coRef.e8Wifi_Security_Mode;
   u8Wifi_Channel_Number = coRef.u8Wifi_Channel_Number;
   e8Wifi_Visibility = coRef.e8Wifi_Visibility;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart::vDestroy()
{
   rWifi_SSID_Name.vDestroy(); 
   rWifi_PassKey.vDestroy(); 
}

midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart::midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart()
:rWifi_SSID_Name()
,rWifi_PassKey()
,e8Wifi_Security_Mode()
,u8Wifi_Channel_Number(0)
,e8Wifi_Visibility()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFIHOTSPOTREQUESTMETHODSTART;
}


midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart::~midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+rWifi_SSID_Name.u32GetSize(u16MajorVersion)+rWifi_PassKey.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rWifi_SSID_Name);
   (tVoid) (oIn >> rWifi_PassKey);
   (tVoid) (oIn >> e8Wifi_Security_Mode);
   (tVoid) (oIn >> u8Wifi_Channel_Number);
   (tVoid) (oIn >> e8Wifi_Visibility);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rWifi_SSID_Name);
   (tVoid) (oOut << rWifi_PassKey);
   (tVoid) (oOut << e8Wifi_Security_Mode);
   (tVoid) (oOut << u8Wifi_Channel_Number);
   (tVoid) (oOut << e8Wifi_Visibility);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart::operator==(const midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rWifi_SSID_Name == roRef.rWifi_SSID_Name);
   bResult = bResult && (rWifi_PassKey == roRef.rWifi_PassKey);
   bResult = bResult && (e8Wifi_Security_Mode == roRef.e8Wifi_Security_Mode);
   bResult = bResult && (u8Wifi_Channel_Number == roRef.u8Wifi_Channel_Number);
   bResult = bResult && (e8Wifi_Visibility == roRef.e8Wifi_Visibility);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodResult::midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFIHOTSPOTREQUESTMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodResult::~midw_ext_tcufi_tclMsgSetWifiHotSpotRequestMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart::midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart(const midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Wifi_Status = coRef.e8Wifi_Status;
   e8Wifi_Mode = coRef.e8Wifi_Mode;
}
midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart& midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart::operator=(const midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Wifi_Status = coRef.e8Wifi_Status;
   e8Wifi_Mode = coRef.e8Wifi_Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart::midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart()
:e8Wifi_Status()
,e8Wifi_Mode()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFIACTIVATIONREQUESTMETHODSTART;
}


midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart::~midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Wifi_Status);
   (tVoid) (oIn >> e8Wifi_Mode);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Wifi_Status);
   (tVoid) (oOut << e8Wifi_Mode);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart::operator==(const midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Wifi_Status == roRef.e8Wifi_Status);
   bResult = bResult && (e8Wifi_Mode == roRef.e8Wifi_Mode);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodResult::midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFIACTIVATIONREQUESTMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodResult::~midw_ext_tcufi_tclMsgSetWifiActivationRequestMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSetWifiDataResetMethodStart::midw_ext_tcufi_tclMsgSetWifiDataResetMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiDataResetMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFIDATARESETMETHODSTART;
}


midw_ext_tcufi_tclMsgSetWifiDataResetMethodStart::~midw_ext_tcufi_tclMsgSetWifiDataResetMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSetWifiDataResetMethodResult::midw_ext_tcufi_tclMsgSetWifiDataResetMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiDataResetMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFIDATARESETMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetWifiDataResetMethodResult::~midw_ext_tcufi_tclMsgSetWifiDataResetMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSetWifiClientScanMethodStart::midw_ext_tcufi_tclMsgSetWifiClientScanMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiClientScanMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTSCANMETHODSTART;
}


midw_ext_tcufi_tclMsgSetWifiClientScanMethodStart::~midw_ext_tcufi_tclMsgSetWifiClientScanMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSetWifiClientScanMethodResult::midw_ext_tcufi_tclMsgSetWifiClientScanMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiClientScanMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTSCANMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetWifiClientScanMethodResult::~midw_ext_tcufi_tclMsgSetWifiClientScanMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart::midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart(const midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rWifi_Scan_SSID_Name = coRef.rWifi_Scan_SSID_Name;
   rWifi_PassKey = coRef.rWifi_PassKey;
}
midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart& midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart::operator=(const midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   rWifi_Scan_SSID_Name = coRef.rWifi_Scan_SSID_Name;
   rWifi_PassKey = coRef.rWifi_PassKey;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart::vDestroy()
{
   rWifi_Scan_SSID_Name.vDestroy(); 
   rWifi_PassKey.vDestroy(); 
}

midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart::midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart()
:rWifi_Scan_SSID_Name()
,rWifi_PassKey()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTCONNECTIONMETHODSTART;
}


midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart::~midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+rWifi_Scan_SSID_Name.u32GetSize(u16MajorVersion)+rWifi_PassKey.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rWifi_Scan_SSID_Name);
   (tVoid) (oIn >> rWifi_PassKey);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rWifi_Scan_SSID_Name);
   (tVoid) (oOut << rWifi_PassKey);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart::operator==(const midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rWifi_Scan_SSID_Name == roRef.rWifi_Scan_SSID_Name);
   bResult = bResult && (rWifi_PassKey == roRef.rWifi_PassKey);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodResult::midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTCONNECTIONMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodResult::~midw_ext_tcufi_tclMsgSetWifiClientConnectionMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodStart::midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTDISCONNECTIONMETHODSTART;
}


midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodStart::~midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodResult::midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETWIFICLIENTDISCONNECTIONMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodResult::~midw_ext_tcufi_tclMsgSetWifiClientDisconnectionMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodStart::midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETWIFICONNECTEDDEVICESREQUESTMETHODSTART;
}


midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodStart::~midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodResult::midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETWIFICONNECTEDDEVICESREQUESTMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodResult::~midw_ext_tcufi_tclMsgGetWifiConnectedDevicesRequestMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetWifiClientStateMethodStart::midw_ext_tcufi_tclMsgGetWifiClientStateMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgGetWifiClientStateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETWIFICLIENTSTATEMETHODSTART;
}


midw_ext_tcufi_tclMsgGetWifiClientStateMethodStart::~midw_ext_tcufi_tclMsgGetWifiClientStateMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetWifiClientStateMethodResult::midw_ext_tcufi_tclMsgGetWifiClientStateMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetWifiClientStateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETWIFICLIENTSTATEMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetWifiClientStateMethodResult::~midw_ext_tcufi_tclMsgGetWifiClientStateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgDTMEcallMethodStart::midw_ext_tcufi_tclMsgDTMEcallMethodStart(const midw_ext_tcufi_tclMsgDTMEcallMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8SourceActivity = coRef.e8SourceActivity;
}
midw_ext_tcufi_tclMsgDTMEcallMethodStart& midw_ext_tcufi_tclMsgDTMEcallMethodStart::operator=(const midw_ext_tcufi_tclMsgDTMEcallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SourceActivity = coRef.e8SourceActivity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgDTMEcallMethodStart::midw_ext_tcufi_tclMsgDTMEcallMethodStart()
:e8SourceActivity()
 {}

tS32 midw_ext_tcufi_tclMsgDTMEcallMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_DTMECALLMETHODSTART;
}


midw_ext_tcufi_tclMsgDTMEcallMethodStart::~midw_ext_tcufi_tclMsgDTMEcallMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgDTMEcallMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgDTMEcallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SourceActivity);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgDTMEcallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SourceActivity);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgDTMEcallMethodStart::operator==(const midw_ext_tcufi_tclMsgDTMEcallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SourceActivity == roRef.e8SourceActivity);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgDTMEcallMethodResult::midw_ext_tcufi_tclMsgDTMEcallMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgDTMEcallMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_DTMECALLMETHODRESULT;
}


midw_ext_tcufi_tclMsgDTMEcallMethodResult::~midw_ext_tcufi_tclMsgDTMEcallMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgResetHistoryMethodStart::midw_ext_tcufi_tclMsgResetHistoryMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgResetHistoryMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_RESETHISTORYMETHODSTART;
}


midw_ext_tcufi_tclMsgResetHistoryMethodStart::~midw_ext_tcufi_tclMsgResetHistoryMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgResetHistoryMethodResult::midw_ext_tcufi_tclMsgResetHistoryMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgResetHistoryMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT;
}


midw_ext_tcufi_tclMsgResetHistoryMethodResult::~midw_ext_tcufi_tclMsgResetHistoryMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetHardwareVersionMethodStart::midw_ext_tcufi_tclMsgGetHardwareVersionMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgGetHardwareVersionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETHARDWAREVERSIONMETHODSTART;
}


midw_ext_tcufi_tclMsgGetHardwareVersionMethodStart::~midw_ext_tcufi_tclMsgGetHardwareVersionMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetHardwareVersionMethodResult::midw_ext_tcufi_tclMsgGetHardwareVersionMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetHardwareVersionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETHARDWAREVERSIONMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetHardwareVersionMethodResult::~midw_ext_tcufi_tclMsgGetHardwareVersionMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetSoftwareVersionMethodStart::midw_ext_tcufi_tclMsgGetSoftwareVersionMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgGetSoftwareVersionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETSOFTWAREVERSIONMETHODSTART;
}


midw_ext_tcufi_tclMsgGetSoftwareVersionMethodStart::~midw_ext_tcufi_tclMsgGetSoftwareVersionMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetSoftwareVersionMethodResult::midw_ext_tcufi_tclMsgGetSoftwareVersionMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetSoftwareVersionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETSOFTWAREVERSIONMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetSoftwareVersionMethodResult::~midw_ext_tcufi_tclMsgGetSoftwareVersionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart::midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart(const midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8InvalidParmeter = coRef.e8InvalidParmeter;
}
midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart& midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart::operator=(const midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8InvalidParmeter = coRef.e8InvalidParmeter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart::midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart()
:e8InvalidParmeter()
 {}

tS32 midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPUSH_POISTATUSMETHODSTART;
}


midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart::~midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8InvalidParmeter);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8InvalidParmeter);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart::operator==(const midw_ext_tcufi_tclMsgSetPush_POIStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8InvalidParmeter == roRef.e8InvalidParmeter);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetPush_POIStatusMethodResult::midw_ext_tcufi_tclMsgSetPush_POIStatusMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetPush_POIStatusMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPUSH_POISTATUSMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetPush_POIStatusMethodResult::~midw_ext_tcufi_tclMsgSetPush_POIStatusMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart::midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart(const midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8InvalidParmeter = coRef.e8InvalidParmeter;
   u8Geofencing_Activation_State  = coRef.u8Geofencing_Activation_State ;
}
midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart& midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart::operator=(const midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8InvalidParmeter = coRef.e8InvalidParmeter;
   u8Geofencing_Activation_State  = coRef.u8Geofencing_Activation_State ;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart::midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart()
:e8InvalidParmeter()
,u8Geofencing_Activation_State (0)
 {}

tS32 midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETGEOFENCING_ACTIVATIONSTATUSMETHODSTART;
}


midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart::~midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8InvalidParmeter);
   (tVoid) (oIn >> u8Geofencing_Activation_State );
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8InvalidParmeter);
   (tVoid) (oOut << u8Geofencing_Activation_State );
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart::operator==(const midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8InvalidParmeter == roRef.e8InvalidParmeter);
   bResult = bResult && (u8Geofencing_Activation_State  == roRef.u8Geofencing_Activation_State );
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodResult::midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETGEOFENCING_ACTIVATIONSTATUSMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodResult::~midw_ext_tcufi_tclMsgSetGeofencing_ActivationStatusMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodStart::midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETRESTRICTION_SETTINGSMETHODSTART;
}


midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodStart::~midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodStart()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodResult::midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETRESTRICTION_SETTINGSMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodResult::~midw_ext_tcufi_tclMsgGetRestriction_SettingsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgXCallStartMethodStart::midw_ext_tcufi_tclMsgXCallStartMethodStart(const midw_ext_tcufi_tclMsgXCallStartMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8XCallType = coRef.e8XCallType;
   e8XCallLanguage = coRef.e8XCallLanguage;
}
midw_ext_tcufi_tclMsgXCallStartMethodStart& midw_ext_tcufi_tclMsgXCallStartMethodStart::operator=(const midw_ext_tcufi_tclMsgXCallStartMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8XCallType = coRef.e8XCallType;
   e8XCallLanguage = coRef.e8XCallLanguage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgXCallStartMethodStart::midw_ext_tcufi_tclMsgXCallStartMethodStart()
:e8XCallType()
,e8XCallLanguage()
 {}

tS32 midw_ext_tcufi_tclMsgXCallStartMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLSTARTMETHODSTART;
}


midw_ext_tcufi_tclMsgXCallStartMethodStart::~midw_ext_tcufi_tclMsgXCallStartMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgXCallStartMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgXCallStartMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8XCallType);
   (tVoid) (oIn >> e8XCallLanguage);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgXCallStartMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8XCallType);
   (tVoid) (oOut << e8XCallLanguage);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgXCallStartMethodStart::operator==(const midw_ext_tcufi_tclMsgXCallStartMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8XCallType == roRef.e8XCallType);
   bResult = bResult && (e8XCallLanguage == roRef.e8XCallLanguage);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgXCallStartMethodResult::midw_ext_tcufi_tclMsgXCallStartMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgXCallStartMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLSTARTMETHODRESULT;
}


midw_ext_tcufi_tclMsgXCallStartMethodResult::~midw_ext_tcufi_tclMsgXCallStartMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart::midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart(const midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8PrivacyMode = coRef.e8PrivacyMode;
}
midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart& midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart::operator=(const midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8PrivacyMode = coRef.e8PrivacyMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart::midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart()
:e8PrivacyMode()
 {}

tS32 midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPRIVICYMODEMETHODSTART;
}


midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart::~midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart()
{}

tU32 midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PrivacyMode);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PrivacyMode);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart::operator==(const midw_ext_tcufi_tclMsgSetPrivicyModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PrivacyMode == roRef.e8PrivacyMode);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSetPrivicyModeMethodResult::midw_ext_tcufi_tclMsgSetPrivicyModeMethodResult()
 {}

tS32 midw_ext_tcufi_tclMsgSetPrivicyModeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SETPRIVICYMODEMETHODRESULT;
}


midw_ext_tcufi_tclMsgSetPrivicyModeMethodResult::~midw_ext_tcufi_tclMsgSetPrivicyModeMethodResult()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodStart::midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodStart()
 {}

tS32 midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETTCUCONFIGURATIONSTATUSMETHODSTART;
}


midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodStart::~midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult::midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult(const midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rTCU_CurrentAvailabilityConfiguration = coRef.rTCU_CurrentAvailabilityConfiguration;
   bAutoConfigured = coRef.bAutoConfigured;
}
midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult& midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult::operator=(const midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   rTCU_CurrentAvailabilityConfiguration = coRef.rTCU_CurrentAvailabilityConfiguration;
   bAutoConfigured = coRef.bAutoConfigured;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult::midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult()
:rTCU_CurrentAvailabilityConfiguration()
,bAutoConfigured(0)
 {}

tS32 midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GETTCUCONFIGURATIONSTATUSMETHODRESULT;
}


midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult::~midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult()
{}

tU32 midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rTCU_CurrentAvailabilityConfiguration);
   (tVoid) (oIn >> bAutoConfigured);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rTCU_CurrentAvailabilityConfiguration);
   (tVoid) (oOut << bAutoConfigured);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult::operator==(const midw_ext_tcufi_tclMsgGetTCUConfigurationStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rTCU_CurrentAvailabilityConfiguration == roRef.rTCU_CurrentAvailabilityConfiguration);
   bResult = bResult && (bAutoConfigured == roRef.bAutoConfigured);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgConnectionUpReg::midw_ext_tcufi_tclMsgConnectionUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgConnectionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONNECTIONUPREG;
}


midw_ext_tcufi_tclMsgConnectionUpReg::~midw_ext_tcufi_tclMsgConnectionUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgConnectionRelUpReg::midw_ext_tcufi_tclMsgConnectionRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONNECTIONRELUPREG;
}


midw_ext_tcufi_tclMsgConnectionRelUpReg::~midw_ext_tcufi_tclMsgConnectionRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgConnectionGet::midw_ext_tcufi_tclMsgConnectionGet()
 {}

tS32 midw_ext_tcufi_tclMsgConnectionGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONNECTIONGET;
}


midw_ext_tcufi_tclMsgConnectionGet::~midw_ext_tcufi_tclMsgConnectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgConnectionStatus::midw_ext_tcufi_tclMsgConnectionStatus(const midw_ext_tcufi_tclMsgConnectionStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bConnected = coRef.bConnected;
   u8AbsenceState = coRef.u8AbsenceState;
   u8MuteState = coRef.u8MuteState;
   e8CommunicationStatus = coRef.e8CommunicationStatus;
}
midw_ext_tcufi_tclMsgConnectionStatus& midw_ext_tcufi_tclMsgConnectionStatus::operator=(const midw_ext_tcufi_tclMsgConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   bConnected = coRef.bConnected;
   u8AbsenceState = coRef.u8AbsenceState;
   u8MuteState = coRef.u8MuteState;
   e8CommunicationStatus = coRef.e8CommunicationStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgConnectionStatus::midw_ext_tcufi_tclMsgConnectionStatus()
:bConnected(0)
,u8AbsenceState(0)
,u8MuteState(0)
,e8CommunicationStatus()
 {}

tS32 midw_ext_tcufi_tclMsgConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONNECTIONSTATUS;
}


midw_ext_tcufi_tclMsgConnectionStatus::~midw_ext_tcufi_tclMsgConnectionStatus()
{}

tU32 midw_ext_tcufi_tclMsgConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_tcufi_tclMsgConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bConnected);
   (tVoid) (oIn >> u8AbsenceState);
   (tVoid) (oIn >> u8MuteState);
   (tVoid) (oIn >> e8CommunicationStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bConnected);
   (tVoid) (oOut << u8AbsenceState);
   (tVoid) (oOut << u8MuteState);
   (tVoid) (oOut << e8CommunicationStatus);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgConnectionStatus::operator==(const midw_ext_tcufi_tclMsgConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bConnected == roRef.bConnected);
   bResult = bResult && (u8AbsenceState == roRef.u8AbsenceState);
   bResult = bResult && (u8MuteState == roRef.u8MuteState);
   bResult = bResult && (e8CommunicationStatus == roRef.e8CommunicationStatus);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgConfigurationUpReg::midw_ext_tcufi_tclMsgConfigurationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgConfigurationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONFIGURATIONUPREG;
}


midw_ext_tcufi_tclMsgConfigurationUpReg::~midw_ext_tcufi_tclMsgConfigurationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgConfigurationRelUpReg::midw_ext_tcufi_tclMsgConfigurationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgConfigurationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONFIGURATIONRELUPREG;
}


midw_ext_tcufi_tclMsgConfigurationRelUpReg::~midw_ext_tcufi_tclMsgConfigurationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgConfigurationGet::midw_ext_tcufi_tclMsgConfigurationGet()
 {}

tS32 midw_ext_tcufi_tclMsgConfigurationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONFIGURATIONGET;
}


midw_ext_tcufi_tclMsgConfigurationGet::~midw_ext_tcufi_tclMsgConfigurationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgConfigurationStatus::midw_ext_tcufi_tclMsgConfigurationStatus(const midw_ext_tcufi_tclMsgConfigurationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8ConfigurationStatus = coRef.e8ConfigurationStatus;
   u8UnitId = coRef.u8UnitId;
   rMessageVersion = coRef.rMessageVersion;
}
midw_ext_tcufi_tclMsgConfigurationStatus& midw_ext_tcufi_tclMsgConfigurationStatus::operator=(const midw_ext_tcufi_tclMsgConfigurationStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ConfigurationStatus = coRef.e8ConfigurationStatus;
   u8UnitId = coRef.u8UnitId;
   rMessageVersion = coRef.rMessageVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgConfigurationStatus::midw_ext_tcufi_tclMsgConfigurationStatus()
:e8ConfigurationStatus()
,u8UnitId(0)
,rMessageVersion()
 {}

tS32 midw_ext_tcufi_tclMsgConfigurationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONFIGURATIONSTATUS;
}


midw_ext_tcufi_tclMsgConfigurationStatus::~midw_ext_tcufi_tclMsgConfigurationStatus()
{}

tU32 midw_ext_tcufi_tclMsgConfigurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_tcufi_tclMsgConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConfigurationStatus);
   (tVoid) (oIn >> u8UnitId);
   (tVoid) (oIn >> rMessageVersion);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConfigurationStatus);
   (tVoid) (oOut << u8UnitId);
   (tVoid) (oOut << rMessageVersion);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgConfigurationStatus::operator==(const midw_ext_tcufi_tclMsgConfigurationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConfigurationStatus == roRef.e8ConfigurationStatus);
   bResult = bResult && (u8UnitId == roRef.u8UnitId);
   bResult = bResult && (rMessageVersion == roRef.rMessageVersion);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgDataTransmissionUpReg::midw_ext_tcufi_tclMsgDataTransmissionUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgDataTransmissionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_DATATRANSMISSIONUPREG;
}


midw_ext_tcufi_tclMsgDataTransmissionUpReg::~midw_ext_tcufi_tclMsgDataTransmissionUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgDataTransmissionRelUpReg::midw_ext_tcufi_tclMsgDataTransmissionRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgDataTransmissionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_DATATRANSMISSIONRELUPREG;
}


midw_ext_tcufi_tclMsgDataTransmissionRelUpReg::~midw_ext_tcufi_tclMsgDataTransmissionRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgDataTransmissionGet::midw_ext_tcufi_tclMsgDataTransmissionGet()
 {}

tS32 midw_ext_tcufi_tclMsgDataTransmissionGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_DATATRANSMISSIONGET;
}


midw_ext_tcufi_tclMsgDataTransmissionGet::~midw_ext_tcufi_tclMsgDataTransmissionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgDataTransmissionStatus::midw_ext_tcufi_tclMsgDataTransmissionStatus(const midw_ext_tcufi_tclMsgDataTransmissionStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   u8MPDTMuteState = coRef.u8MPDTMuteState;
}
midw_ext_tcufi_tclMsgDataTransmissionStatus& midw_ext_tcufi_tclMsgDataTransmissionStatus::operator=(const midw_ext_tcufi_tclMsgDataTransmissionStatus& coRef)
{
   if (this == &coRef) return *this;
   u8MPDTMuteState = coRef.u8MPDTMuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgDataTransmissionStatus::midw_ext_tcufi_tclMsgDataTransmissionStatus()
:u8MPDTMuteState(0)
 {}

tS32 midw_ext_tcufi_tclMsgDataTransmissionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_DATATRANSMISSIONSTATUS;
}


midw_ext_tcufi_tclMsgDataTransmissionStatus::~midw_ext_tcufi_tclMsgDataTransmissionStatus()
{}

tU32 midw_ext_tcufi_tclMsgDataTransmissionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgDataTransmissionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8MPDTMuteState);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgDataTransmissionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8MPDTMuteState);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgDataTransmissionStatus::operator==(const midw_ext_tcufi_tclMsgDataTransmissionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8MPDTMuteState == roRef.u8MPDTMuteState);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgECallRequestUpReg::midw_ext_tcufi_tclMsgECallRequestUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgECallRequestUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ECALLREQUESTUPREG;
}


midw_ext_tcufi_tclMsgECallRequestUpReg::~midw_ext_tcufi_tclMsgECallRequestUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgECallRequestRelUpReg::midw_ext_tcufi_tclMsgECallRequestRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgECallRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ECALLREQUESTRELUPREG;
}


midw_ext_tcufi_tclMsgECallRequestRelUpReg::~midw_ext_tcufi_tclMsgECallRequestRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgECallRequestGet::midw_ext_tcufi_tclMsgECallRequestGet()
 {}

tS32 midw_ext_tcufi_tclMsgECallRequestGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ECALLREQUESTGET;
}


midw_ext_tcufi_tclMsgECallRequestGet::~midw_ext_tcufi_tclMsgECallRequestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgECallRequestStatus::midw_ext_tcufi_tclMsgECallRequestStatus(const midw_ext_tcufi_tclMsgECallRequestStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bECallActive = coRef.bECallActive;
   bValid = coRef.bValid;
   bIsECallCallBackRequest = coRef.bIsECallCallBackRequest;
}
midw_ext_tcufi_tclMsgECallRequestStatus& midw_ext_tcufi_tclMsgECallRequestStatus::operator=(const midw_ext_tcufi_tclMsgECallRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   bECallActive = coRef.bECallActive;
   bValid = coRef.bValid;
   bIsECallCallBackRequest = coRef.bIsECallCallBackRequest;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgECallRequestStatus::midw_ext_tcufi_tclMsgECallRequestStatus()
:bECallActive(0)
,bValid(0)
,bIsECallCallBackRequest(0)
 {}

tS32 midw_ext_tcufi_tclMsgECallRequestStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ECALLREQUESTSTATUS;
}


midw_ext_tcufi_tclMsgECallRequestStatus::~midw_ext_tcufi_tclMsgECallRequestStatus()
{}

tU32 midw_ext_tcufi_tclMsgECallRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_tcufi_tclMsgECallRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bECallActive);
   (tVoid) (oIn >> bValid);
   (tVoid) (oIn >> bIsECallCallBackRequest);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgECallRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bECallActive);
   (tVoid) (oOut << bValid);
   (tVoid) (oOut << bIsECallCallBackRequest);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgECallRequestStatus::operator==(const midw_ext_tcufi_tclMsgECallRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bECallActive == roRef.bECallActive);
   bResult = bResult && (bValid == roRef.bValid);
   bResult = bResult && (bIsECallCallBackRequest == roRef.bIsECallCallBackRequest);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgECallServiceStateUpReg::midw_ext_tcufi_tclMsgECallServiceStateUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgECallServiceStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ECALLSERVICESTATEUPREG;
}


midw_ext_tcufi_tclMsgECallServiceStateUpReg::~midw_ext_tcufi_tclMsgECallServiceStateUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgECallServiceStateRelUpReg::midw_ext_tcufi_tclMsgECallServiceStateRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgECallServiceStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ECALLSERVICESTATERELUPREG;
}


midw_ext_tcufi_tclMsgECallServiceStateRelUpReg::~midw_ext_tcufi_tclMsgECallServiceStateRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgECallServiceStateGet::midw_ext_tcufi_tclMsgECallServiceStateGet()
 {}

tS32 midw_ext_tcufi_tclMsgECallServiceStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ECALLSERVICESTATEGET;
}


midw_ext_tcufi_tclMsgECallServiceStateGet::~midw_ext_tcufi_tclMsgECallServiceStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgECallServiceStateStatus::midw_ext_tcufi_tclMsgECallServiceStateStatus(const midw_ext_tcufi_tclMsgECallServiceStateStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8ECallServiceState = coRef.e8ECallServiceState;
}
midw_ext_tcufi_tclMsgECallServiceStateStatus& midw_ext_tcufi_tclMsgECallServiceStateStatus::operator=(const midw_ext_tcufi_tclMsgECallServiceStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ECallServiceState = coRef.e8ECallServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgECallServiceStateStatus::midw_ext_tcufi_tclMsgECallServiceStateStatus()
:e8ECallServiceState()
 {}

tS32 midw_ext_tcufi_tclMsgECallServiceStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ECALLSERVICESTATESTATUS;
}


midw_ext_tcufi_tclMsgECallServiceStateStatus::~midw_ext_tcufi_tclMsgECallServiceStateStatus()
{}

tU32 midw_ext_tcufi_tclMsgECallServiceStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgECallServiceStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ECallServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgECallServiceStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ECallServiceState);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgECallServiceStateStatus::operator==(const midw_ext_tcufi_tclMsgECallServiceStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ECallServiceState == roRef.e8ECallServiceState);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgACNRequestUpReg::midw_ext_tcufi_tclMsgACNRequestUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgACNRequestUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ACNREQUESTUPREG;
}


midw_ext_tcufi_tclMsgACNRequestUpReg::~midw_ext_tcufi_tclMsgACNRequestUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgACNRequestRelUpReg::midw_ext_tcufi_tclMsgACNRequestRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgACNRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ACNREQUESTRELUPREG;
}


midw_ext_tcufi_tclMsgACNRequestRelUpReg::~midw_ext_tcufi_tclMsgACNRequestRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgACNRequestGet::midw_ext_tcufi_tclMsgACNRequestGet()
 {}

tS32 midw_ext_tcufi_tclMsgACNRequestGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ACNREQUESTGET;
}


midw_ext_tcufi_tclMsgACNRequestGet::~midw_ext_tcufi_tclMsgACNRequestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgACNRequestStatus::midw_ext_tcufi_tclMsgACNRequestStatus(const midw_ext_tcufi_tclMsgACNRequestStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bACNActive = coRef.bACNActive;
   bValid = coRef.bValid;
}
midw_ext_tcufi_tclMsgACNRequestStatus& midw_ext_tcufi_tclMsgACNRequestStatus::operator=(const midw_ext_tcufi_tclMsgACNRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   bACNActive = coRef.bACNActive;
   bValid = coRef.bValid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgACNRequestStatus::midw_ext_tcufi_tclMsgACNRequestStatus()
:bACNActive(0)
,bValid(0)
 {}

tS32 midw_ext_tcufi_tclMsgACNRequestStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ACNREQUESTSTATUS;
}


midw_ext_tcufi_tclMsgACNRequestStatus::~midw_ext_tcufi_tclMsgACNRequestStatus()
{}

tU32 midw_ext_tcufi_tclMsgACNRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgACNRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bACNActive);
   (tVoid) (oIn >> bValid);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgACNRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bACNActive);
   (tVoid) (oOut << bValid);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgACNRequestStatus::operator==(const midw_ext_tcufi_tclMsgACNRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bACNActive == roRef.bACNActive);
   bResult = bResult && (bValid == roRef.bValid);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgACNServiceStateUpReg::midw_ext_tcufi_tclMsgACNServiceStateUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgACNServiceStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ACNSERVICESTATEUPREG;
}


midw_ext_tcufi_tclMsgACNServiceStateUpReg::~midw_ext_tcufi_tclMsgACNServiceStateUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgACNServiceStateRelUpReg::midw_ext_tcufi_tclMsgACNServiceStateRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgACNServiceStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ACNSERVICESTATERELUPREG;
}


midw_ext_tcufi_tclMsgACNServiceStateRelUpReg::~midw_ext_tcufi_tclMsgACNServiceStateRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgACNServiceStateGet::midw_ext_tcufi_tclMsgACNServiceStateGet()
 {}

tS32 midw_ext_tcufi_tclMsgACNServiceStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ACNSERVICESTATEGET;
}


midw_ext_tcufi_tclMsgACNServiceStateGet::~midw_ext_tcufi_tclMsgACNServiceStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgACNServiceStateStatus::midw_ext_tcufi_tclMsgACNServiceStateStatus(const midw_ext_tcufi_tclMsgACNServiceStateStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8ACNServiceState = coRef.e8ACNServiceState;
}
midw_ext_tcufi_tclMsgACNServiceStateStatus& midw_ext_tcufi_tclMsgACNServiceStateStatus::operator=(const midw_ext_tcufi_tclMsgACNServiceStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ACNServiceState = coRef.e8ACNServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgACNServiceStateStatus::midw_ext_tcufi_tclMsgACNServiceStateStatus()
:e8ACNServiceState()
 {}

tS32 midw_ext_tcufi_tclMsgACNServiceStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_ACNSERVICESTATESTATUS;
}


midw_ext_tcufi_tclMsgACNServiceStateStatus::~midw_ext_tcufi_tclMsgACNServiceStateStatus()
{}

tU32 midw_ext_tcufi_tclMsgACNServiceStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgACNServiceStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ACNServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgACNServiceStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ACNServiceState);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgACNServiceStateStatus::operator==(const midw_ext_tcufi_tclMsgACNServiceStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ACNServiceState == roRef.e8ACNServiceState);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgCurfewAlertUpReg::midw_ext_tcufi_tclMsgCurfewAlertUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCurfewAlertUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CURFEWALERTUPREG;
}


midw_ext_tcufi_tclMsgCurfewAlertUpReg::~midw_ext_tcufi_tclMsgCurfewAlertUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCurfewAlertRelUpReg::midw_ext_tcufi_tclMsgCurfewAlertRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCurfewAlertRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CURFEWALERTRELUPREG;
}


midw_ext_tcufi_tclMsgCurfewAlertRelUpReg::~midw_ext_tcufi_tclMsgCurfewAlertRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCurfewAlertGet::midw_ext_tcufi_tclMsgCurfewAlertGet()
 {}

tS32 midw_ext_tcufi_tclMsgCurfewAlertGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CURFEWALERTGET;
}


midw_ext_tcufi_tclMsgCurfewAlertGet::~midw_ext_tcufi_tclMsgCurfewAlertGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgCurfewAlertStatus::midw_ext_tcufi_tclMsgCurfewAlertStatus(const midw_ext_tcufi_tclMsgCurfewAlertStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8CurfewAlertWarning = coRef.e8CurfewAlertWarning;
}
midw_ext_tcufi_tclMsgCurfewAlertStatus& midw_ext_tcufi_tclMsgCurfewAlertStatus::operator=(const midw_ext_tcufi_tclMsgCurfewAlertStatus& coRef)
{
   if (this == &coRef) return *this;
   e8CurfewAlertWarning = coRef.e8CurfewAlertWarning;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgCurfewAlertStatus::midw_ext_tcufi_tclMsgCurfewAlertStatus()
:e8CurfewAlertWarning()
 {}

tS32 midw_ext_tcufi_tclMsgCurfewAlertStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CURFEWALERTSTATUS;
}


midw_ext_tcufi_tclMsgCurfewAlertStatus::~midw_ext_tcufi_tclMsgCurfewAlertStatus()
{}

tU32 midw_ext_tcufi_tclMsgCurfewAlertStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgCurfewAlertStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CurfewAlertWarning);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgCurfewAlertStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CurfewAlertWarning);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgCurfewAlertStatus::operator==(const midw_ext_tcufi_tclMsgCurfewAlertStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CurfewAlertWarning == roRef.e8CurfewAlertWarning);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgGeoFenceUpReg::midw_ext_tcufi_tclMsgGeoFenceUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgGeoFenceUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GEOFENCEUPREG;
}


midw_ext_tcufi_tclMsgGeoFenceUpReg::~midw_ext_tcufi_tclMsgGeoFenceUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGeoFenceRelUpReg::midw_ext_tcufi_tclMsgGeoFenceRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgGeoFenceRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GEOFENCERELUPREG;
}


midw_ext_tcufi_tclMsgGeoFenceRelUpReg::~midw_ext_tcufi_tclMsgGeoFenceRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGeoFenceGet::midw_ext_tcufi_tclMsgGeoFenceGet()
 {}

tS32 midw_ext_tcufi_tclMsgGeoFenceGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GEOFENCEGET;
}


midw_ext_tcufi_tclMsgGeoFenceGet::~midw_ext_tcufi_tclMsgGeoFenceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgGeoFenceStatus::midw_ext_tcufi_tclMsgGeoFenceStatus(const midw_ext_tcufi_tclMsgGeoFenceStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bStatusFromTCU = coRef.bStatusFromTCU;
}
midw_ext_tcufi_tclMsgGeoFenceStatus& midw_ext_tcufi_tclMsgGeoFenceStatus::operator=(const midw_ext_tcufi_tclMsgGeoFenceStatus& coRef)
{
   if (this == &coRef) return *this;
   bStatusFromTCU = coRef.bStatusFromTCU;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgGeoFenceStatus::midw_ext_tcufi_tclMsgGeoFenceStatus()
:bStatusFromTCU(0)
 {}

tS32 midw_ext_tcufi_tclMsgGeoFenceStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GEOFENCESTATUS;
}


midw_ext_tcufi_tclMsgGeoFenceStatus::~midw_ext_tcufi_tclMsgGeoFenceStatus()
{}

tU32 midw_ext_tcufi_tclMsgGeoFenceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgGeoFenceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bStatusFromTCU);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgGeoFenceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bStatusFromTCU);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgGeoFenceStatus::operator==(const midw_ext_tcufi_tclMsgGeoFenceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bStatusFromTCU == roRef.bStatusFromTCU);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSpeedAlertUpReg::midw_ext_tcufi_tclMsgSpeedAlertUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSpeedAlertUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SPEEDALERTUPREG;
}


midw_ext_tcufi_tclMsgSpeedAlertUpReg::~midw_ext_tcufi_tclMsgSpeedAlertUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSpeedAlertRelUpReg::midw_ext_tcufi_tclMsgSpeedAlertRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSpeedAlertRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SPEEDALERTRELUPREG;
}


midw_ext_tcufi_tclMsgSpeedAlertRelUpReg::~midw_ext_tcufi_tclMsgSpeedAlertRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSpeedAlertGet::midw_ext_tcufi_tclMsgSpeedAlertGet()
 {}

tS32 midw_ext_tcufi_tclMsgSpeedAlertGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SPEEDALERTGET;
}


midw_ext_tcufi_tclMsgSpeedAlertGet::~midw_ext_tcufi_tclMsgSpeedAlertGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSpeedAlertStatus::midw_ext_tcufi_tclMsgSpeedAlertStatus(const midw_ext_tcufi_tclMsgSpeedAlertStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bStatusFromTCU = coRef.bStatusFromTCU;
}
midw_ext_tcufi_tclMsgSpeedAlertStatus& midw_ext_tcufi_tclMsgSpeedAlertStatus::operator=(const midw_ext_tcufi_tclMsgSpeedAlertStatus& coRef)
{
   if (this == &coRef) return *this;
   bStatusFromTCU = coRef.bStatusFromTCU;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSpeedAlertStatus::midw_ext_tcufi_tclMsgSpeedAlertStatus()
:bStatusFromTCU(0)
 {}

tS32 midw_ext_tcufi_tclMsgSpeedAlertStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SPEEDALERTSTATUS;
}


midw_ext_tcufi_tclMsgSpeedAlertStatus::~midw_ext_tcufi_tclMsgSpeedAlertStatus()
{}

tU32 midw_ext_tcufi_tclMsgSpeedAlertStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSpeedAlertStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bStatusFromTCU);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSpeedAlertStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bStatusFromTCU);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSpeedAlertStatus::operator==(const midw_ext_tcufi_tclMsgSpeedAlertStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bStatusFromTCU == roRef.bStatusFromTCU);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgTCUStateUpReg::midw_ext_tcufi_tclMsgTCUStateUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTCUStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUSTATEUPREG;
}


midw_ext_tcufi_tclMsgTCUStateUpReg::~midw_ext_tcufi_tclMsgTCUStateUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTCUStateRelUpReg::midw_ext_tcufi_tclMsgTCUStateRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTCUStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUSTATERELUPREG;
}


midw_ext_tcufi_tclMsgTCUStateRelUpReg::~midw_ext_tcufi_tclMsgTCUStateRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTCUStateGet::midw_ext_tcufi_tclMsgTCUStateGet()
 {}

tS32 midw_ext_tcufi_tclMsgTCUStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUSTATEGET;
}


midw_ext_tcufi_tclMsgTCUStateGet::~midw_ext_tcufi_tclMsgTCUStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgTCUStateStatus::midw_ext_tcufi_tclMsgTCUStateStatus(const midw_ext_tcufi_tclMsgTCUStateStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8ModemStatus = coRef.e8ModemStatus;
   e8TcuStatus = coRef.e8TcuStatus;
   e8GSMStatus = coRef.e8GSMStatus;
   u8GSMRSSILevel = coRef.u8GSMRSSILevel;
   e8WifiStatus = coRef.e8WifiStatus;
   e8WifiMode = coRef.e8WifiMode;
   e8WifiHotSpotStatus = coRef.e8WifiHotSpotStatus;
   e8WifiClientStatus = coRef.e8WifiClientStatus;
   e8GSMDataMode = coRef.e8GSMDataMode;
   u8WifiClientSSID = coRef.u8WifiClientSSID;
   u8WifiClientPower = coRef.u8WifiClientPower;
   e8Opcode = coRef.e8Opcode;
}
midw_ext_tcufi_tclMsgTCUStateStatus& midw_ext_tcufi_tclMsgTCUStateStatus::operator=(const midw_ext_tcufi_tclMsgTCUStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ModemStatus = coRef.e8ModemStatus;
   e8TcuStatus = coRef.e8TcuStatus;
   e8GSMStatus = coRef.e8GSMStatus;
   u8GSMRSSILevel = coRef.u8GSMRSSILevel;
   e8WifiStatus = coRef.e8WifiStatus;
   e8WifiMode = coRef.e8WifiMode;
   e8WifiHotSpotStatus = coRef.e8WifiHotSpotStatus;
   e8WifiClientStatus = coRef.e8WifiClientStatus;
   e8GSMDataMode = coRef.e8GSMDataMode;
   u8WifiClientSSID = coRef.u8WifiClientSSID;
   u8WifiClientPower = coRef.u8WifiClientPower;
   e8Opcode = coRef.e8Opcode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgTCUStateStatus::midw_ext_tcufi_tclMsgTCUStateStatus()
:e8ModemStatus()
,e8TcuStatus()
,e8GSMStatus()
,u8GSMRSSILevel(0)
,e8WifiStatus()
,e8WifiMode()
,e8WifiHotSpotStatus()
,e8WifiClientStatus()
,e8GSMDataMode()
,u8WifiClientSSID(0)
,u8WifiClientPower(0)
,e8Opcode()
 {}

tS32 midw_ext_tcufi_tclMsgTCUStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUSTATESTATUS;
}


midw_ext_tcufi_tclMsgTCUStateStatus::~midw_ext_tcufi_tclMsgTCUStateStatus()
{}

tU32 midw_ext_tcufi_tclMsgTCUStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_ext_tcufi_tclMsgTCUStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ModemStatus);
   (tVoid) (oIn >> e8TcuStatus);
   (tVoid) (oIn >> e8GSMStatus);
   (tVoid) (oIn >> u8GSMRSSILevel);
   (tVoid) (oIn >> e8WifiStatus);
   (tVoid) (oIn >> e8WifiMode);
   (tVoid) (oIn >> e8WifiHotSpotStatus);
   (tVoid) (oIn >> e8WifiClientStatus);
   (tVoid) (oIn >> e8GSMDataMode);
   (tVoid) (oIn >> u8WifiClientSSID);
   (tVoid) (oIn >> u8WifiClientPower);
   (tVoid) (oIn >> e8Opcode);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgTCUStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ModemStatus);
   (tVoid) (oOut << e8TcuStatus);
   (tVoid) (oOut << e8GSMStatus);
   (tVoid) (oOut << u8GSMRSSILevel);
   (tVoid) (oOut << e8WifiStatus);
   (tVoid) (oOut << e8WifiMode);
   (tVoid) (oOut << e8WifiHotSpotStatus);
   (tVoid) (oOut << e8WifiClientStatus);
   (tVoid) (oOut << e8GSMDataMode);
   (tVoid) (oOut << u8WifiClientSSID);
   (tVoid) (oOut << u8WifiClientPower);
   (tVoid) (oOut << e8Opcode);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgTCUStateStatus::operator==(const midw_ext_tcufi_tclMsgTCUStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ModemStatus == roRef.e8ModemStatus);
   bResult = bResult && (e8TcuStatus == roRef.e8TcuStatus);
   bResult = bResult && (e8GSMStatus == roRef.e8GSMStatus);
   bResult = bResult && (u8GSMRSSILevel == roRef.u8GSMRSSILevel);
   bResult = bResult && (e8WifiStatus == roRef.e8WifiStatus);
   bResult = bResult && (e8WifiMode == roRef.e8WifiMode);
   bResult = bResult && (e8WifiHotSpotStatus == roRef.e8WifiHotSpotStatus);
   bResult = bResult && (e8WifiClientStatus == roRef.e8WifiClientStatus);
   bResult = bResult && (e8GSMDataMode == roRef.e8GSMDataMode);
   bResult = bResult && (u8WifiClientSSID == roRef.u8WifiClientSSID);
   bResult = bResult && (u8WifiClientPower == roRef.u8WifiClientPower);
   bResult = bResult && (e8Opcode == roRef.e8Opcode);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgIDInfoStatusUpReg::midw_ext_tcufi_tclMsgIDInfoStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgIDInfoStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_IDINFOSTATUSUPREG;
}


midw_ext_tcufi_tclMsgIDInfoStatusUpReg::~midw_ext_tcufi_tclMsgIDInfoStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgIDInfoStatusRelUpReg::midw_ext_tcufi_tclMsgIDInfoStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgIDInfoStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_IDINFOSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgIDInfoStatusRelUpReg::~midw_ext_tcufi_tclMsgIDInfoStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgIDInfoStatusGet::midw_ext_tcufi_tclMsgIDInfoStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgIDInfoStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_IDINFOSTATUSGET;
}


midw_ext_tcufi_tclMsgIDInfoStatusGet::~midw_ext_tcufi_tclMsgIDInfoStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgIDInfoStatusStatus::midw_ext_tcufi_tclMsgIDInfoStatusStatus(const midw_ext_tcufi_tclMsgIDInfoStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8InvalidParameter = coRef.e8InvalidParameter;
   sTCUID = coRef.sTCUID;
   sICCID = coRef.sICCID;
   sVIN = coRef.sVIN;
}
midw_ext_tcufi_tclMsgIDInfoStatusStatus& midw_ext_tcufi_tclMsgIDInfoStatusStatus::operator=(const midw_ext_tcufi_tclMsgIDInfoStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8InvalidParameter = coRef.e8InvalidParameter;
   sTCUID = coRef.sTCUID;
   sICCID = coRef.sICCID;
   sVIN = coRef.sVIN;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgIDInfoStatusStatus::vDestroy()
{
   sTCUID.vDestroy();
   sICCID.vDestroy();
   sVIN.vDestroy();
}

midw_ext_tcufi_tclMsgIDInfoStatusStatus::midw_ext_tcufi_tclMsgIDInfoStatusStatus()
:e8InvalidParameter()
,sTCUID()
,sICCID()
,sVIN()
 {}

tS32 midw_ext_tcufi_tclMsgIDInfoStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_IDINFOSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgIDInfoStatusStatus::~midw_ext_tcufi_tclMsgIDInfoStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgIDInfoStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sTCUID.u32GetSize(u16MajorVersion)+sICCID.u32GetSize(u16MajorVersion)+sVIN.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgIDInfoStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8InvalidParameter);
   (tVoid) (oIn >> sTCUID);
   (tVoid) (oIn >> sICCID);
   (tVoid) (oIn >> sVIN);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgIDInfoStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8InvalidParameter);
   (tVoid) (oOut << sTCUID);
   (tVoid) (oOut << sICCID);
   (tVoid) (oOut << sVIN);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgIDInfoStatusStatus::operator==(const midw_ext_tcufi_tclMsgIDInfoStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8InvalidParameter == roRef.e8InvalidParameter);
   bResult = bResult && (sTCUID == roRef.sTCUID);
   bResult = bResult && (sICCID == roRef.sICCID);
   bResult = bResult && (sVIN == roRef.sVIN);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusUpReg::midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_DRIVERINFOUPLOADPERMITSTATUSUPREG;
}


midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusUpReg::~midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusRelUpReg::midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_DRIVERINFOUPLOADPERMITSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusRelUpReg::~midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusGet::midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_DRIVERINFOUPLOADPERMITSTATUSGET;
}


midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusGet::~midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus::midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus(const midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8PermitSetting = coRef.e8PermitSetting;
   bValid = coRef.bValid;
   e8AppContext = coRef.e8AppContext;
}
midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus& midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus::operator=(const midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8PermitSetting = coRef.e8PermitSetting;
   bValid = coRef.bValid;
   e8AppContext = coRef.e8AppContext;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus::midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus()
:e8InvalidParameter()
,e8PermitSetting()
,bValid(0)
,e8AppContext()
 {}

tS32 midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_DRIVERINFOUPLOADPERMITSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus::~midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8InvalidParameter);
   (tVoid) (oIn >> e8PermitSetting);
   (tVoid) (oIn >> bValid);
   (tVoid) (oIn >> e8AppContext);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8InvalidParameter);
   (tVoid) (oOut << e8PermitSetting);
   (tVoid) (oOut << bValid);
   (tVoid) (oOut << e8AppContext);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus::operator==(const midw_ext_tcufi_tclMsgDriverInfoUploadPermitStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8InvalidParameter == roRef.e8InvalidParameter);
   bResult = bResult && (e8PermitSetting == roRef.e8PermitSetting);
   bResult = bResult && (bValid == roRef.bValid);
   bResult = bResult && (e8AppContext == roRef.e8AppContext);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSMSNotificationStatusUpReg::midw_ext_tcufi_tclMsgSMSNotificationStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSMSNotificationStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SMSNOTIFICATIONSTATUSUPREG;
}


midw_ext_tcufi_tclMsgSMSNotificationStatusUpReg::~midw_ext_tcufi_tclMsgSMSNotificationStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSMSNotificationStatusRelUpReg::midw_ext_tcufi_tclMsgSMSNotificationStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSMSNotificationStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SMSNOTIFICATIONSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgSMSNotificationStatusRelUpReg::~midw_ext_tcufi_tclMsgSMSNotificationStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSMSNotificationStatusGet::midw_ext_tcufi_tclMsgSMSNotificationStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgSMSNotificationStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SMSNOTIFICATIONSTATUSGET;
}


midw_ext_tcufi_tclMsgSMSNotificationStatusGet::~midw_ext_tcufi_tclMsgSMSNotificationStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSMSNotificationStatusStatus::midw_ext_tcufi_tclMsgSMSNotificationStatusStatus(const midw_ext_tcufi_tclMsgSMSNotificationStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8PopUpFlag = coRef.e8PopUpFlag;
   u8ConnectingPoint = coRef.u8ConnectingPoint;
   u16InformationChannel = coRef.u16InformationChannel;
}
midw_ext_tcufi_tclMsgSMSNotificationStatusStatus& midw_ext_tcufi_tclMsgSMSNotificationStatusStatus::operator=(const midw_ext_tcufi_tclMsgSMSNotificationStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8PopUpFlag = coRef.e8PopUpFlag;
   u8ConnectingPoint = coRef.u8ConnectingPoint;
   u16InformationChannel = coRef.u16InformationChannel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSMSNotificationStatusStatus::midw_ext_tcufi_tclMsgSMSNotificationStatusStatus()
:e8PopUpFlag()
,u8ConnectingPoint(0)
,u16InformationChannel(0)
 {}

tS32 midw_ext_tcufi_tclMsgSMSNotificationStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SMSNOTIFICATIONSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgSMSNotificationStatusStatus::~midw_ext_tcufi_tclMsgSMSNotificationStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgSMSNotificationStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSMSNotificationStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PopUpFlag);
   (tVoid) (oIn >> u8ConnectingPoint);
   (tVoid) (oIn >> u16InformationChannel);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSMSNotificationStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PopUpFlag);
   (tVoid) (oOut << u8ConnectingPoint);
   (tVoid) (oOut << u16InformationChannel);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSMSNotificationStatusStatus::operator==(const midw_ext_tcufi_tclMsgSMSNotificationStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PopUpFlag == roRef.e8PopUpFlag);
   bResult = bResult && (u8ConnectingPoint == roRef.u8ConnectingPoint);
   bResult = bResult && (u16InformationChannel == roRef.u16InformationChannel);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgProbeUploadPermitStatusUpReg::midw_ext_tcufi_tclMsgProbeUploadPermitStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgProbeUploadPermitStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROBEUPLOADPERMITSTATUSUPREG;
}


midw_ext_tcufi_tclMsgProbeUploadPermitStatusUpReg::~midw_ext_tcufi_tclMsgProbeUploadPermitStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgProbeUploadPermitStatusRelUpReg::midw_ext_tcufi_tclMsgProbeUploadPermitStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgProbeUploadPermitStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROBEUPLOADPERMITSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgProbeUploadPermitStatusRelUpReg::~midw_ext_tcufi_tclMsgProbeUploadPermitStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgProbeUploadPermitStatusGet::midw_ext_tcufi_tclMsgProbeUploadPermitStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgProbeUploadPermitStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROBEUPLOADPERMITSTATUSGET;
}


midw_ext_tcufi_tclMsgProbeUploadPermitStatusGet::~midw_ext_tcufi_tclMsgProbeUploadPermitStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus::midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus(const midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8ProbePermitSetting = coRef.e8ProbePermitSetting;
}
midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus& midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus::operator=(const midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8ProbePermitSetting = coRef.e8ProbePermitSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus::midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus()
:e8InvalidParameter()
,e8ProbePermitSetting()
 {}

tS32 midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROBEUPLOADPERMITSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus::~midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8InvalidParameter);
   (tVoid) (oIn >> e8ProbePermitSetting);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8InvalidParameter);
   (tVoid) (oOut << e8ProbePermitSetting);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus::operator==(const midw_ext_tcufi_tclMsgProbeUploadPermitStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8InvalidParameter == roRef.e8InvalidParameter);
   bResult = bResult && (e8ProbePermitSetting == roRef.e8ProbePermitSetting);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgProbeInfoDeleteStatusUpReg::midw_ext_tcufi_tclMsgProbeInfoDeleteStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgProbeInfoDeleteStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROBEINFODELETESTATUSUPREG;
}


midw_ext_tcufi_tclMsgProbeInfoDeleteStatusUpReg::~midw_ext_tcufi_tclMsgProbeInfoDeleteStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgProbeInfoDeleteStatusRelUpReg::midw_ext_tcufi_tclMsgProbeInfoDeleteStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgProbeInfoDeleteStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROBEINFODELETESTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgProbeInfoDeleteStatusRelUpReg::~midw_ext_tcufi_tclMsgProbeInfoDeleteStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgProbeInfoDeleteStatusGet::midw_ext_tcufi_tclMsgProbeInfoDeleteStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgProbeInfoDeleteStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROBEINFODELETESTATUSGET;
}


midw_ext_tcufi_tclMsgProbeInfoDeleteStatusGet::~midw_ext_tcufi_tclMsgProbeInfoDeleteStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus::midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus(const midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bStatusFromTCU = coRef.bStatusFromTCU;
}
midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus& midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus::operator=(const midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   bStatusFromTCU = coRef.bStatusFromTCU;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus::midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus()
:bStatusFromTCU(0)
 {}

tS32 midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROBEINFODELETESTATUSSTATUS;
}


midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus::~midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bStatusFromTCU);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bStatusFromTCU);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus::operator==(const midw_ext_tcufi_tclMsgProbeInfoDeleteStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bStatusFromTCU == roRef.bStatusFromTCU);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgServiceCallStateUpReg::midw_ext_tcufi_tclMsgServiceCallStateUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLSTATEUPREG;
}


midw_ext_tcufi_tclMsgServiceCallStateUpReg::~midw_ext_tcufi_tclMsgServiceCallStateUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgServiceCallStateRelUpReg::midw_ext_tcufi_tclMsgServiceCallStateRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLSTATERELUPREG;
}


midw_ext_tcufi_tclMsgServiceCallStateRelUpReg::~midw_ext_tcufi_tclMsgServiceCallStateRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgServiceCallStateGet::midw_ext_tcufi_tclMsgServiceCallStateGet()
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLSTATEGET;
}


midw_ext_tcufi_tclMsgServiceCallStateGet::~midw_ext_tcufi_tclMsgServiceCallStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgServiceCallStateStatus::midw_ext_tcufi_tclMsgServiceCallStateStatus(const midw_ext_tcufi_tclMsgServiceCallStateStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8ServiceState = coRef.e8ServiceState;
}
midw_ext_tcufi_tclMsgServiceCallStateStatus& midw_ext_tcufi_tclMsgServiceCallStateStatus::operator=(const midw_ext_tcufi_tclMsgServiceCallStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ServiceState = coRef.e8ServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgServiceCallStateStatus::midw_ext_tcufi_tclMsgServiceCallStateStatus()
:e8ServiceState()
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLSTATESTATUS;
}


midw_ext_tcufi_tclMsgServiceCallStateStatus::~midw_ext_tcufi_tclMsgServiceCallStateStatus()
{}

tU32 midw_ext_tcufi_tclMsgServiceCallStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgServiceCallStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgServiceCallStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ServiceState);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgServiceCallStateStatus::operator==(const midw_ext_tcufi_tclMsgServiceCallStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ServiceState == roRef.e8ServiceState);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgServiceCallRequestUpReg::midw_ext_tcufi_tclMsgServiceCallRequestUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallRequestUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLREQUESTUPREG;
}


midw_ext_tcufi_tclMsgServiceCallRequestUpReg::~midw_ext_tcufi_tclMsgServiceCallRequestUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgServiceCallRequestRelUpReg::midw_ext_tcufi_tclMsgServiceCallRequestRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLREQUESTRELUPREG;
}


midw_ext_tcufi_tclMsgServiceCallRequestRelUpReg::~midw_ext_tcufi_tclMsgServiceCallRequestRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgServiceCallRequestGet::midw_ext_tcufi_tclMsgServiceCallRequestGet()
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallRequestGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLREQUESTGET;
}


midw_ext_tcufi_tclMsgServiceCallRequestGet::~midw_ext_tcufi_tclMsgServiceCallRequestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgServiceCallRequestStatus::midw_ext_tcufi_tclMsgServiceCallRequestStatus(const midw_ext_tcufi_tclMsgServiceCallRequestStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bServiceCallActive = coRef.bServiceCallActive;
   bValid = coRef.bValid;
}
midw_ext_tcufi_tclMsgServiceCallRequestStatus& midw_ext_tcufi_tclMsgServiceCallRequestStatus::operator=(const midw_ext_tcufi_tclMsgServiceCallRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   bServiceCallActive = coRef.bServiceCallActive;
   bValid = coRef.bValid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgServiceCallRequestStatus::midw_ext_tcufi_tclMsgServiceCallRequestStatus()
:bServiceCallActive(0)
,bValid(0)
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallRequestStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLREQUESTSTATUS;
}


midw_ext_tcufi_tclMsgServiceCallRequestStatus::~midw_ext_tcufi_tclMsgServiceCallRequestStatus()
{}

tU32 midw_ext_tcufi_tclMsgServiceCallRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgServiceCallRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bServiceCallActive);
   (tVoid) (oIn >> bValid);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgServiceCallRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bServiceCallActive);
   (tVoid) (oOut << bValid);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgServiceCallRequestStatus::operator==(const midw_ext_tcufi_tclMsgServiceCallRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bServiceCallActive == roRef.bServiceCallActive);
   bResult = bResult && (bValid == roRef.bValid);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgServiceCallOperationStatusUpReg::midw_ext_tcufi_tclMsgServiceCallOperationStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallOperationStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLOPERATIONSTATUSUPREG;
}


midw_ext_tcufi_tclMsgServiceCallOperationStatusUpReg::~midw_ext_tcufi_tclMsgServiceCallOperationStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgServiceCallOperationStatusRelUpReg::midw_ext_tcufi_tclMsgServiceCallOperationStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallOperationStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLOPERATIONSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgServiceCallOperationStatusRelUpReg::~midw_ext_tcufi_tclMsgServiceCallOperationStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgServiceCallOperationStatusGet::midw_ext_tcufi_tclMsgServiceCallOperationStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallOperationStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLOPERATIONSTATUSGET;
}


midw_ext_tcufi_tclMsgServiceCallOperationStatusGet::~midw_ext_tcufi_tclMsgServiceCallOperationStatusGet()
{}

//=============================================================================

midw_ext_tcufi_tclMsgServiceCallOperationStatusStatus::midw_ext_tcufi_tclMsgServiceCallOperationStatusStatus()
 {}

tS32 midw_ext_tcufi_tclMsgServiceCallOperationStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SERVICECALLOPERATIONSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgServiceCallOperationStatusStatus::~midw_ext_tcufi_tclMsgServiceCallOperationStatusStatus()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTcuCallServiceStateUpReg::midw_ext_tcufi_tclMsgTcuCallServiceStateUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTcuCallServiceStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUCALLSERVICESTATEUPREG;
}


midw_ext_tcufi_tclMsgTcuCallServiceStateUpReg::~midw_ext_tcufi_tclMsgTcuCallServiceStateUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTcuCallServiceStateRelUpReg::midw_ext_tcufi_tclMsgTcuCallServiceStateRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTcuCallServiceStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUCALLSERVICESTATERELUPREG;
}


midw_ext_tcufi_tclMsgTcuCallServiceStateRelUpReg::~midw_ext_tcufi_tclMsgTcuCallServiceStateRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTcuCallServiceStateGet::midw_ext_tcufi_tclMsgTcuCallServiceStateGet()
 {}

tS32 midw_ext_tcufi_tclMsgTcuCallServiceStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUCALLSERVICESTATEGET;
}


midw_ext_tcufi_tclMsgTcuCallServiceStateGet::~midw_ext_tcufi_tclMsgTcuCallServiceStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgTcuCallServiceStateStatus::midw_ext_tcufi_tclMsgTcuCallServiceStateStatus(const midw_ext_tcufi_tclMsgTcuCallServiceStateStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8ACNCallServiceState = coRef.e8ACNCallServiceState;
   e8EmergencyCallServiceState = coRef.e8EmergencyCallServiceState;
}
midw_ext_tcufi_tclMsgTcuCallServiceStateStatus& midw_ext_tcufi_tclMsgTcuCallServiceStateStatus::operator=(const midw_ext_tcufi_tclMsgTcuCallServiceStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ACNCallServiceState = coRef.e8ACNCallServiceState;
   e8EmergencyCallServiceState = coRef.e8EmergencyCallServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgTcuCallServiceStateStatus::midw_ext_tcufi_tclMsgTcuCallServiceStateStatus()
:e8ACNCallServiceState()
,e8EmergencyCallServiceState()
 {}

tS32 midw_ext_tcufi_tclMsgTcuCallServiceStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUCALLSERVICESTATESTATUS;
}


midw_ext_tcufi_tclMsgTcuCallServiceStateStatus::~midw_ext_tcufi_tclMsgTcuCallServiceStateStatus()
{}

tU32 midw_ext_tcufi_tclMsgTcuCallServiceStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgTcuCallServiceStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ACNCallServiceState);
   (tVoid) (oIn >> e8EmergencyCallServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgTcuCallServiceStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ACNCallServiceState);
   (tVoid) (oOut << e8EmergencyCallServiceState);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgTcuCallServiceStateStatus::operator==(const midw_ext_tcufi_tclMsgTcuCallServiceStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ACNCallServiceState == roRef.e8ACNCallServiceState);
   bResult = bResult && (e8EmergencyCallServiceState == roRef.e8EmergencyCallServiceState);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgProvisionServiceUpReg::midw_ext_tcufi_tclMsgProvisionServiceUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgProvisionServiceUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROVISIONSERVICEUPREG;
}


midw_ext_tcufi_tclMsgProvisionServiceUpReg::~midw_ext_tcufi_tclMsgProvisionServiceUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgProvisionServiceRelUpReg::midw_ext_tcufi_tclMsgProvisionServiceRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgProvisionServiceRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROVISIONSERVICERELUPREG;
}


midw_ext_tcufi_tclMsgProvisionServiceRelUpReg::~midw_ext_tcufi_tclMsgProvisionServiceRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgProvisionServiceGet::midw_ext_tcufi_tclMsgProvisionServiceGet()
 {}

tS32 midw_ext_tcufi_tclMsgProvisionServiceGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROVISIONSERVICEGET;
}


midw_ext_tcufi_tclMsgProvisionServiceGet::~midw_ext_tcufi_tclMsgProvisionServiceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgProvisionServiceStatus::midw_ext_tcufi_tclMsgProvisionServiceStatus(const midw_ext_tcufi_tclMsgProvisionServiceStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   ProvisionService = coRef.ProvisionService;
}
midw_ext_tcufi_tclMsgProvisionServiceStatus& midw_ext_tcufi_tclMsgProvisionServiceStatus::operator=(const midw_ext_tcufi_tclMsgProvisionServiceStatus& coRef)
{
   if (this == &coRef) return *this;
   ProvisionService = coRef.ProvisionService;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgProvisionServiceStatus::midw_ext_tcufi_tclMsgProvisionServiceStatus()
:ProvisionService()
 {}

tS32 midw_ext_tcufi_tclMsgProvisionServiceStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PROVISIONSERVICESTATUS;
}


midw_ext_tcufi_tclMsgProvisionServiceStatus::~midw_ext_tcufi_tclMsgProvisionServiceStatus()
{}

tU32 midw_ext_tcufi_tclMsgProvisionServiceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& midw_ext_tcufi_tclMsgProvisionServiceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProvisionService);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgProvisionServiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProvisionService);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgProvisionServiceStatus::operator==(const midw_ext_tcufi_tclMsgProvisionServiceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProvisionService == roRef.ProvisionService);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallStateUpReg::midw_ext_tcufi_tclMsgCOMEcallStateUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTATEUPREG;
}


midw_ext_tcufi_tclMsgCOMEcallStateUpReg::~midw_ext_tcufi_tclMsgCOMEcallStateUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallStateRelUpReg::midw_ext_tcufi_tclMsgCOMEcallStateRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTATERELUPREG;
}


midw_ext_tcufi_tclMsgCOMEcallStateRelUpReg::~midw_ext_tcufi_tclMsgCOMEcallStateRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallStateGet::midw_ext_tcufi_tclMsgCOMEcallStateGet()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTATEGET;
}


midw_ext_tcufi_tclMsgCOMEcallStateGet::~midw_ext_tcufi_tclMsgCOMEcallStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgCOMEcallStateStatus::midw_ext_tcufi_tclMsgCOMEcallStateStatus(const midw_ext_tcufi_tclMsgCOMEcallStateStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8EcallStateDisplay = coRef.e8EcallStateDisplay;
}
midw_ext_tcufi_tclMsgCOMEcallStateStatus& midw_ext_tcufi_tclMsgCOMEcallStateStatus::operator=(const midw_ext_tcufi_tclMsgCOMEcallStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8EcallStateDisplay = coRef.e8EcallStateDisplay;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgCOMEcallStateStatus::midw_ext_tcufi_tclMsgCOMEcallStateStatus()
:e8EcallStateDisplay()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTATESTATUS;
}


midw_ext_tcufi_tclMsgCOMEcallStateStatus::~midw_ext_tcufi_tclMsgCOMEcallStateStatus()
{}

tU32 midw_ext_tcufi_tclMsgCOMEcallStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgCOMEcallStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8EcallStateDisplay);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgCOMEcallStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8EcallStateDisplay);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgCOMEcallStateStatus::operator==(const midw_ext_tcufi_tclMsgCOMEcallStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8EcallStateDisplay == roRef.e8EcallStateDisplay);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallStartUpReg::midw_ext_tcufi_tclMsgCOMEcallStartUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallStartUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTUPREG;
}


midw_ext_tcufi_tclMsgCOMEcallStartUpReg::~midw_ext_tcufi_tclMsgCOMEcallStartUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallStartRelUpReg::midw_ext_tcufi_tclMsgCOMEcallStartRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallStartRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTRELUPREG;
}


midw_ext_tcufi_tclMsgCOMEcallStartRelUpReg::~midw_ext_tcufi_tclMsgCOMEcallStartRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallStartGet::midw_ext_tcufi_tclMsgCOMEcallStartGet()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallStartGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTGET;
}


midw_ext_tcufi_tclMsgCOMEcallStartGet::~midw_ext_tcufi_tclMsgCOMEcallStartGet()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallStartStatus::midw_ext_tcufi_tclMsgCOMEcallStartStatus()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallStartStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLSTARTSTATUS;
}


midw_ext_tcufi_tclMsgCOMEcallStartStatus::~midw_ext_tcufi_tclMsgCOMEcallStartStatus()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallEndUpReg::midw_ext_tcufi_tclMsgCOMEcallEndUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallEndUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLENDUPREG;
}


midw_ext_tcufi_tclMsgCOMEcallEndUpReg::~midw_ext_tcufi_tclMsgCOMEcallEndUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallEndRelUpReg::midw_ext_tcufi_tclMsgCOMEcallEndRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallEndRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLENDRELUPREG;
}


midw_ext_tcufi_tclMsgCOMEcallEndRelUpReg::~midw_ext_tcufi_tclMsgCOMEcallEndRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallEndGet::midw_ext_tcufi_tclMsgCOMEcallEndGet()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallEndGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLENDGET;
}


midw_ext_tcufi_tclMsgCOMEcallEndGet::~midw_ext_tcufi_tclMsgCOMEcallEndGet()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCOMEcallEndStatus::midw_ext_tcufi_tclMsgCOMEcallEndStatus()
 {}

tS32 midw_ext_tcufi_tclMsgCOMEcallEndStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_COMECALLENDSTATUS;
}


midw_ext_tcufi_tclMsgCOMEcallEndStatus::~midw_ext_tcufi_tclMsgCOMEcallEndStatus()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTCUResetStatusUpReg::midw_ext_tcufi_tclMsgTCUResetStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTCUResetStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCURESETSTATUSUPREG;
}


midw_ext_tcufi_tclMsgTCUResetStatusUpReg::~midw_ext_tcufi_tclMsgTCUResetStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTCUResetStatusRelUpReg::midw_ext_tcufi_tclMsgTCUResetStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTCUResetStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCURESETSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgTCUResetStatusRelUpReg::~midw_ext_tcufi_tclMsgTCUResetStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTCUResetStatusGet::midw_ext_tcufi_tclMsgTCUResetStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgTCUResetStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCURESETSTATUSGET;
}


midw_ext_tcufi_tclMsgTCUResetStatusGet::~midw_ext_tcufi_tclMsgTCUResetStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgTCUResetStatusStatus::midw_ext_tcufi_tclMsgTCUResetStatusStatus(const midw_ext_tcufi_tclMsgTCUResetStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bStatusFromTCU = coRef.bStatusFromTCU;
}
midw_ext_tcufi_tclMsgTCUResetStatusStatus& midw_ext_tcufi_tclMsgTCUResetStatusStatus::operator=(const midw_ext_tcufi_tclMsgTCUResetStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   bStatusFromTCU = coRef.bStatusFromTCU;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgTCUResetStatusStatus::midw_ext_tcufi_tclMsgTCUResetStatusStatus()
:bStatusFromTCU(0)
 {}

tS32 midw_ext_tcufi_tclMsgTCUResetStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCURESETSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgTCUResetStatusStatus::~midw_ext_tcufi_tclMsgTCUResetStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgTCUResetStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgTCUResetStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bStatusFromTCU);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgTCUResetStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bStatusFromTCU);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgTCUResetStatusStatus::operator==(const midw_ext_tcufi_tclMsgTCUResetStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bStatusFromTCU == roRef.bStatusFromTCU);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgEmergencyStateUpReg::midw_ext_tcufi_tclMsgEmergencyStateUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgEmergencyStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_EMERGENCYSTATEUPREG;
}


midw_ext_tcufi_tclMsgEmergencyStateUpReg::~midw_ext_tcufi_tclMsgEmergencyStateUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgEmergencyStateRelUpReg::midw_ext_tcufi_tclMsgEmergencyStateRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgEmergencyStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_EMERGENCYSTATERELUPREG;
}


midw_ext_tcufi_tclMsgEmergencyStateRelUpReg::~midw_ext_tcufi_tclMsgEmergencyStateRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgEmergencyStateGet::midw_ext_tcufi_tclMsgEmergencyStateGet()
 {}

tS32 midw_ext_tcufi_tclMsgEmergencyStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_EMERGENCYSTATEGET;
}


midw_ext_tcufi_tclMsgEmergencyStateGet::~midw_ext_tcufi_tclMsgEmergencyStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgEmergencyStateStatus::midw_ext_tcufi_tclMsgEmergencyStateStatus(const midw_ext_tcufi_tclMsgEmergencyStateStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bEmergencyStateFromTCU = coRef.bEmergencyStateFromTCU;
}
midw_ext_tcufi_tclMsgEmergencyStateStatus& midw_ext_tcufi_tclMsgEmergencyStateStatus::operator=(const midw_ext_tcufi_tclMsgEmergencyStateStatus& coRef)
{
   if (this == &coRef) return *this;
   bEmergencyStateFromTCU = coRef.bEmergencyStateFromTCU;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgEmergencyStateStatus::midw_ext_tcufi_tclMsgEmergencyStateStatus()
:bEmergencyStateFromTCU(0)
 {}

tS32 midw_ext_tcufi_tclMsgEmergencyStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_EMERGENCYSTATESTATUS;
}


midw_ext_tcufi_tclMsgEmergencyStateStatus::~midw_ext_tcufi_tclMsgEmergencyStateStatus()
{}

tU32 midw_ext_tcufi_tclMsgEmergencyStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgEmergencyStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEmergencyStateFromTCU);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgEmergencyStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEmergencyStateFromTCU);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgEmergencyStateStatus::operator==(const midw_ext_tcufi_tclMsgEmergencyStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEmergencyStateFromTCU == roRef.bEmergencyStateFromTCU);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgTCUResponseTimeOutUpReg::midw_ext_tcufi_tclMsgTCUResponseTimeOutUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTCUResponseTimeOutUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCURESPONSETIMEOUTUPREG;
}


midw_ext_tcufi_tclMsgTCUResponseTimeOutUpReg::~midw_ext_tcufi_tclMsgTCUResponseTimeOutUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTCUResponseTimeOutRelUpReg::midw_ext_tcufi_tclMsgTCUResponseTimeOutRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTCUResponseTimeOutRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCURESPONSETIMEOUTRELUPREG;
}


midw_ext_tcufi_tclMsgTCUResponseTimeOutRelUpReg::~midw_ext_tcufi_tclMsgTCUResponseTimeOutRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTCUResponseTimeOutGet::midw_ext_tcufi_tclMsgTCUResponseTimeOutGet()
 {}

tS32 midw_ext_tcufi_tclMsgTCUResponseTimeOutGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCURESPONSETIMEOUTGET;
}


midw_ext_tcufi_tclMsgTCUResponseTimeOutGet::~midw_ext_tcufi_tclMsgTCUResponseTimeOutGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus::midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus(const midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   u8TcuResponseTimeOut = coRef.u8TcuResponseTimeOut;
   TcuResponseTimeOut = coRef.TcuResponseTimeOut;
   bTcuServiceCallOperationSetTimeOut = coRef.bTcuServiceCallOperationSetTimeOut;
}
midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus& midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus::operator=(const midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus& coRef)
{
   if (this == &coRef) return *this;
   u8TcuResponseTimeOut = coRef.u8TcuResponseTimeOut;
   TcuResponseTimeOut = coRef.TcuResponseTimeOut;
   bTcuServiceCallOperationSetTimeOut = coRef.bTcuServiceCallOperationSetTimeOut;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus::vDestroy()
{
   TcuResponseTimeOut.vDestroy(); 
}

midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus::midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus()
:u8TcuResponseTimeOut(0)
,TcuResponseTimeOut()
,bTcuServiceCallOperationSetTimeOut(0)
 {}

tS32 midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCURESPONSETIMEOUTSTATUS;
}


midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus::~midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+TcuResponseTimeOut.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TcuResponseTimeOut);
   (tVoid) (oIn >> TcuResponseTimeOut);
   (tVoid) (oIn >> bTcuServiceCallOperationSetTimeOut);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TcuResponseTimeOut);
   (tVoid) (oOut << TcuResponseTimeOut);
   (tVoid) (oOut << bTcuServiceCallOperationSetTimeOut);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus::operator==(const midw_ext_tcufi_tclMsgTCUResponseTimeOutStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TcuResponseTimeOut == roRef.u8TcuResponseTimeOut);
   bResult = bResult && (TcuResponseTimeOut == roRef.TcuResponseTimeOut);
   bResult = bResult && (bTcuServiceCallOperationSetTimeOut == roRef.bTcuServiceCallOperationSetTimeOut);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgTCUExtendedStateUpReg::midw_ext_tcufi_tclMsgTCUExtendedStateUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTCUExtendedStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUEXTENDEDSTATEUPREG;
}


midw_ext_tcufi_tclMsgTCUExtendedStateUpReg::~midw_ext_tcufi_tclMsgTCUExtendedStateUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTCUExtendedStateRelUpReg::midw_ext_tcufi_tclMsgTCUExtendedStateRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTCUExtendedStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUEXTENDEDSTATERELUPREG;
}


midw_ext_tcufi_tclMsgTCUExtendedStateRelUpReg::~midw_ext_tcufi_tclMsgTCUExtendedStateRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTCUExtendedStateGet::midw_ext_tcufi_tclMsgTCUExtendedStateGet()
 {}

tS32 midw_ext_tcufi_tclMsgTCUExtendedStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUEXTENDEDSTATEGET;
}


midw_ext_tcufi_tclMsgTCUExtendedStateGet::~midw_ext_tcufi_tclMsgTCUExtendedStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgTCUExtendedStateStatus::midw_ext_tcufi_tclMsgTCUExtendedStateStatus(const midw_ext_tcufi_tclMsgTCUExtendedStateStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   sIMEINumber = coRef.sIMEINumber;
   sICC_ID = coRef.sICC_ID;
   u16MCC = coRef.u16MCC;
   u8MNC = coRef.u8MNC;
   sMobile_Network_Name = coRef.sMobile_Network_Name;
   e8RoamingStatus = coRef.e8RoamingStatus;
   e8PPP_Connection_Status = coRef.e8PPP_Connection_Status;
   e8Opcode = coRef.e8Opcode;
}
midw_ext_tcufi_tclMsgTCUExtendedStateStatus& midw_ext_tcufi_tclMsgTCUExtendedStateStatus::operator=(const midw_ext_tcufi_tclMsgTCUExtendedStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   sIMEINumber = coRef.sIMEINumber;
   sICC_ID = coRef.sICC_ID;
   u16MCC = coRef.u16MCC;
   u8MNC = coRef.u8MNC;
   sMobile_Network_Name = coRef.sMobile_Network_Name;
   e8RoamingStatus = coRef.e8RoamingStatus;
   e8PPP_Connection_Status = coRef.e8PPP_Connection_Status;
   e8Opcode = coRef.e8Opcode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgTCUExtendedStateStatus::vDestroy()
{
   sIMEINumber.vDestroy();
   sICC_ID.vDestroy();
   sMobile_Network_Name.vDestroy();
}

midw_ext_tcufi_tclMsgTCUExtendedStateStatus::midw_ext_tcufi_tclMsgTCUExtendedStateStatus()
:e8Invalid_Parameter()
,sIMEINumber()
,sICC_ID()
,u16MCC(0)
,u8MNC(0)
,sMobile_Network_Name()
,e8RoamingStatus()
,e8PPP_Connection_Status()
,e8Opcode()
 {}

tS32 midw_ext_tcufi_tclMsgTCUExtendedStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUEXTENDEDSTATESTATUS;
}


midw_ext_tcufi_tclMsgTCUExtendedStateStatus::~midw_ext_tcufi_tclMsgTCUExtendedStateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgTCUExtendedStateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+sIMEINumber.u32GetSize(u16MajorVersion)+sICC_ID.u32GetSize(u16MajorVersion)+sMobile_Network_Name.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgTCUExtendedStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Invalid_Parameter);
   (tVoid) (oIn >> sIMEINumber);
   (tVoid) (oIn >> sICC_ID);
   (tVoid) (oIn >> u16MCC);
   (tVoid) (oIn >> u8MNC);
   (tVoid) (oIn >> sMobile_Network_Name);
   (tVoid) (oIn >> e8RoamingStatus);
   (tVoid) (oIn >> e8PPP_Connection_Status);
   (tVoid) (oIn >> e8Opcode);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgTCUExtendedStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Invalid_Parameter);
   (tVoid) (oOut << sIMEINumber);
   (tVoid) (oOut << sICC_ID);
   (tVoid) (oOut << u16MCC);
   (tVoid) (oOut << u8MNC);
   (tVoid) (oOut << sMobile_Network_Name);
   (tVoid) (oOut << e8RoamingStatus);
   (tVoid) (oOut << e8PPP_Connection_Status);
   (tVoid) (oOut << e8Opcode);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgTCUExtendedStateStatus::operator==(const midw_ext_tcufi_tclMsgTCUExtendedStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Invalid_Parameter == roRef.e8Invalid_Parameter);
   bResult = bResult && (sIMEINumber == roRef.sIMEINumber);
   bResult = bResult && (sICC_ID == roRef.sICC_ID);
   bResult = bResult && (u16MCC == roRef.u16MCC);
   bResult = bResult && (u8MNC == roRef.u8MNC);
   bResult = bResult && (sMobile_Network_Name == roRef.sMobile_Network_Name);
   bResult = bResult && (e8RoamingStatus == roRef.e8RoamingStatus);
   bResult = bResult && (e8PPP_Connection_Status == roRef.e8PPP_Connection_Status);
   bResult = bResult && (e8Opcode == roRef.e8Opcode);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgPINSettingStatusUpReg::midw_ext_tcufi_tclMsgPINSettingStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgPINSettingStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PINSETTINGSTATUSUPREG;
}


midw_ext_tcufi_tclMsgPINSettingStatusUpReg::~midw_ext_tcufi_tclMsgPINSettingStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgPINSettingStatusRelUpReg::midw_ext_tcufi_tclMsgPINSettingStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgPINSettingStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PINSETTINGSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgPINSettingStatusRelUpReg::~midw_ext_tcufi_tclMsgPINSettingStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgPINSettingStatusGet::midw_ext_tcufi_tclMsgPINSettingStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgPINSettingStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PINSETTINGSTATUSGET;
}


midw_ext_tcufi_tclMsgPINSettingStatusGet::~midw_ext_tcufi_tclMsgPINSettingStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgPINSettingStatusStatus::midw_ext_tcufi_tclMsgPINSettingStatusStatus(const midw_ext_tcufi_tclMsgPINSettingStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
}
midw_ext_tcufi_tclMsgPINSettingStatusStatus& midw_ext_tcufi_tclMsgPINSettingStatusStatus::operator=(const midw_ext_tcufi_tclMsgPINSettingStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgPINSettingStatusStatus::midw_ext_tcufi_tclMsgPINSettingStatusStatus()
:e8Invalid_Parameter()
 {}

tS32 midw_ext_tcufi_tclMsgPINSettingStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PINSETTINGSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgPINSettingStatusStatus::~midw_ext_tcufi_tclMsgPINSettingStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgPINSettingStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgPINSettingStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Invalid_Parameter);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgPINSettingStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Invalid_Parameter);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgPINSettingStatusStatus::operator==(const midw_ext_tcufi_tclMsgPINSettingStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Invalid_Parameter == roRef.e8Invalid_Parameter);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgChargeReminderStatusUpReg::midw_ext_tcufi_tclMsgChargeReminderStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgChargeReminderStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGEREMINDERSTATUSUPREG;
}


midw_ext_tcufi_tclMsgChargeReminderStatusUpReg::~midw_ext_tcufi_tclMsgChargeReminderStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgChargeReminderStatusRelUpReg::midw_ext_tcufi_tclMsgChargeReminderStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgChargeReminderStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGEREMINDERSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgChargeReminderStatusRelUpReg::~midw_ext_tcufi_tclMsgChargeReminderStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgChargeReminderStatusGet::midw_ext_tcufi_tclMsgChargeReminderStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgChargeReminderStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGEREMINDERSTATUSGET;
}


midw_ext_tcufi_tclMsgChargeReminderStatusGet::~midw_ext_tcufi_tclMsgChargeReminderStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgChargeReminderStatusStatus::midw_ext_tcufi_tclMsgChargeReminderStatusStatus(const midw_ext_tcufi_tclMsgChargeReminderStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rReminderInfo = coRef.rReminderInfo;
}
midw_ext_tcufi_tclMsgChargeReminderStatusStatus& midw_ext_tcufi_tclMsgChargeReminderStatusStatus::operator=(const midw_ext_tcufi_tclMsgChargeReminderStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   rReminderInfo = coRef.rReminderInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgChargeReminderStatusStatus::midw_ext_tcufi_tclMsgChargeReminderStatusStatus()
:rReminderInfo()
 {}

tS32 midw_ext_tcufi_tclMsgChargeReminderStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGEREMINDERSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgChargeReminderStatusStatus::~midw_ext_tcufi_tclMsgChargeReminderStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgChargeReminderStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_tcufi_tclMsgChargeReminderStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rReminderInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgChargeReminderStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rReminderInfo);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgChargeReminderStatusStatus::operator==(const midw_ext_tcufi_tclMsgChargeReminderStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rReminderInfo == roRef.rReminderInfo);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgChargeRecordDeleteUpReg::midw_ext_tcufi_tclMsgChargeRecordDeleteUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgChargeRecordDeleteUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGERECORDDELETEUPREG;
}


midw_ext_tcufi_tclMsgChargeRecordDeleteUpReg::~midw_ext_tcufi_tclMsgChargeRecordDeleteUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgChargeRecordDeleteRelUpReg::midw_ext_tcufi_tclMsgChargeRecordDeleteRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgChargeRecordDeleteRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGERECORDDELETERELUPREG;
}


midw_ext_tcufi_tclMsgChargeRecordDeleteRelUpReg::~midw_ext_tcufi_tclMsgChargeRecordDeleteRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgChargeRecordDeleteGet::midw_ext_tcufi_tclMsgChargeRecordDeleteGet()
 {}

tS32 midw_ext_tcufi_tclMsgChargeRecordDeleteGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGERECORDDELETEGET;
}


midw_ext_tcufi_tclMsgChargeRecordDeleteGet::~midw_ext_tcufi_tclMsgChargeRecordDeleteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgChargeRecordDeleteStatus::midw_ext_tcufi_tclMsgChargeRecordDeleteStatus(const midw_ext_tcufi_tclMsgChargeRecordDeleteStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rReminderInfo = coRef.rReminderInfo;
}
midw_ext_tcufi_tclMsgChargeRecordDeleteStatus& midw_ext_tcufi_tclMsgChargeRecordDeleteStatus::operator=(const midw_ext_tcufi_tclMsgChargeRecordDeleteStatus& coRef)
{
   if (this == &coRef) return *this;
   rReminderInfo = coRef.rReminderInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgChargeRecordDeleteStatus::midw_ext_tcufi_tclMsgChargeRecordDeleteStatus()
:rReminderInfo()
 {}

tS32 midw_ext_tcufi_tclMsgChargeRecordDeleteStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGERECORDDELETESTATUS;
}


midw_ext_tcufi_tclMsgChargeRecordDeleteStatus::~midw_ext_tcufi_tclMsgChargeRecordDeleteStatus()
{}

tU32 midw_ext_tcufi_tclMsgChargeRecordDeleteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_tcufi_tclMsgChargeRecordDeleteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rReminderInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgChargeRecordDeleteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rReminderInfo);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgChargeRecordDeleteStatus::operator==(const midw_ext_tcufi_tclMsgChargeRecordDeleteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rReminderInfo == roRef.rReminderInfo);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgStationFinderStatusUpReg::midw_ext_tcufi_tclMsgStationFinderStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgStationFinderStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERSTATUSUPREG;
}


midw_ext_tcufi_tclMsgStationFinderStatusUpReg::~midw_ext_tcufi_tclMsgStationFinderStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgStationFinderStatusRelUpReg::midw_ext_tcufi_tclMsgStationFinderStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgStationFinderStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgStationFinderStatusRelUpReg::~midw_ext_tcufi_tclMsgStationFinderStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgStationFinderStatusGet::midw_ext_tcufi_tclMsgStationFinderStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgStationFinderStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERSTATUSGET;
}


midw_ext_tcufi_tclMsgStationFinderStatusGet::~midw_ext_tcufi_tclMsgStationFinderStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgStationFinderStatusStatus::midw_ext_tcufi_tclMsgStationFinderStatusStatus(const midw_ext_tcufi_tclMsgStationFinderStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   e8FinderStatus = coRef.e8FinderStatus;
   u8Total_Station_Number = coRef.u8Total_Station_Number;
}
midw_ext_tcufi_tclMsgStationFinderStatusStatus& midw_ext_tcufi_tclMsgStationFinderStatusStatus::operator=(const midw_ext_tcufi_tclMsgStationFinderStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   e8FinderStatus = coRef.e8FinderStatus;
   u8Total_Station_Number = coRef.u8Total_Station_Number;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgStationFinderStatusStatus::midw_ext_tcufi_tclMsgStationFinderStatusStatus()
:e8Invalid_Parameter()
,e8FinderStatus()
,u8Total_Station_Number(0)
 {}

tS32 midw_ext_tcufi_tclMsgStationFinderStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgStationFinderStatusStatus::~midw_ext_tcufi_tclMsgStationFinderStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgStationFinderStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_tcufi_tclMsgStationFinderStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Invalid_Parameter);
   (tVoid) (oIn >> e8FinderStatus);
   (tVoid) (oIn >> u8Total_Station_Number);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgStationFinderStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Invalid_Parameter);
   (tVoid) (oOut << e8FinderStatus);
   (tVoid) (oOut << u8Total_Station_Number);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgStationFinderStatusStatus::operator==(const midw_ext_tcufi_tclMsgStationFinderStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Invalid_Parameter == roRef.e8Invalid_Parameter);
   bResult = bResult && (e8FinderStatus == roRef.e8FinderStatus);
   bResult = bResult && (u8Total_Station_Number == roRef.u8Total_Station_Number);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgChargeStationStatusUpReg::midw_ext_tcufi_tclMsgChargeStationStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgChargeStationStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGESTATIONSTATUSUPREG;
}


midw_ext_tcufi_tclMsgChargeStationStatusUpReg::~midw_ext_tcufi_tclMsgChargeStationStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgChargeStationStatusRelUpReg::midw_ext_tcufi_tclMsgChargeStationStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgChargeStationStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGESTATIONSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgChargeStationStatusRelUpReg::~midw_ext_tcufi_tclMsgChargeStationStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgChargeStationStatusGet::midw_ext_tcufi_tclMsgChargeStationStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgChargeStationStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGESTATIONSTATUSGET;
}


midw_ext_tcufi_tclMsgChargeStationStatusGet::~midw_ext_tcufi_tclMsgChargeStationStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgChargeStationStatusStatus::midw_ext_tcufi_tclMsgChargeStationStatusStatus(const midw_ext_tcufi_tclMsgChargeStationStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   u8Station_List_Number = coRef.u8Station_List_Number;
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   rEPOI_GPS_Position = coRef.rEPOI_GPS_Position;
   sEnergy_Provider_Name = coRef.sEnergy_Provider_Name;
   sUtility_Aggregator_ID = coRef.sUtility_Aggregator_ID;
   rTime_Stamp = coRef.rTime_Stamp;
   sPhone_Number = coRef.sPhone_Number;
   rOpening_Hour = coRef.rOpening_Hour;
   e8Charge_Station_Accessibility = coRef.e8Charge_Station_Accessibility;
   e8Payment_Method_Type = coRef.e8Payment_Method_Type;
   u8Spot_Total_Number = coRef.u8Spot_Total_Number;
   u8Number_Available_Batteries = coRef.u8Number_Available_Batteries;
   rFull_Address = coRef.rFull_Address;
   u8Charge_Staion_Ranking = coRef.u8Charge_Staion_Ranking;
}
midw_ext_tcufi_tclMsgChargeStationStatusStatus& midw_ext_tcufi_tclMsgChargeStationStatusStatus::operator=(const midw_ext_tcufi_tclMsgChargeStationStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Station_List_Number = coRef.u8Station_List_Number;
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   rEPOI_GPS_Position = coRef.rEPOI_GPS_Position;
   sEnergy_Provider_Name = coRef.sEnergy_Provider_Name;
   sUtility_Aggregator_ID = coRef.sUtility_Aggregator_ID;
   rTime_Stamp = coRef.rTime_Stamp;
   sPhone_Number = coRef.sPhone_Number;
   rOpening_Hour = coRef.rOpening_Hour;
   e8Charge_Station_Accessibility = coRef.e8Charge_Station_Accessibility;
   e8Payment_Method_Type = coRef.e8Payment_Method_Type;
   u8Spot_Total_Number = coRef.u8Spot_Total_Number;
   u8Number_Available_Batteries = coRef.u8Number_Available_Batteries;
   rFull_Address = coRef.rFull_Address;
   u8Charge_Staion_Ranking = coRef.u8Charge_Staion_Ranking;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgChargeStationStatusStatus::vDestroy()
{
   sCharge_Station_ID.vDestroy();
   rEPOI_GPS_Position.vDestroy(); 
   sEnergy_Provider_Name.vDestroy();
   sUtility_Aggregator_ID.vDestroy();
   rTime_Stamp.vDestroy(); 
   sPhone_Number.vDestroy();
   rOpening_Hour.vDestroy(); 
   rFull_Address.vDestroy(); 
}

midw_ext_tcufi_tclMsgChargeStationStatusStatus::midw_ext_tcufi_tclMsgChargeStationStatusStatus()
:u8Station_List_Number(0)
,sCharge_Station_ID()
,rEPOI_GPS_Position()
,sEnergy_Provider_Name()
,sUtility_Aggregator_ID()
,rTime_Stamp()
,sPhone_Number()
,rOpening_Hour()
,e8Charge_Station_Accessibility()
,e8Payment_Method_Type()
,u8Spot_Total_Number(0)
,u8Number_Available_Batteries(0)
,rFull_Address()
,u8Charge_Staion_Ranking(0)
 {}

tS32 midw_ext_tcufi_tclMsgChargeStationStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGESTATIONSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgChargeStationStatusStatus::~midw_ext_tcufi_tclMsgChargeStationStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgChargeStationStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 52+sCharge_Station_ID.u32GetSize(u16MajorVersion)+sEnergy_Provider_Name.u32GetSize(u16MajorVersion)+sUtility_Aggregator_ID.u32GetSize(u16MajorVersion)+sPhone_Number.u32GetSize(u16MajorVersion)+rFull_Address.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgChargeStationStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Station_List_Number);
   (tVoid) (oIn >> sCharge_Station_ID);
   (tVoid) (oIn >> rEPOI_GPS_Position);
   (tVoid) (oIn >> sEnergy_Provider_Name);
   (tVoid) (oIn >> sUtility_Aggregator_ID);
   (tVoid) (oIn >> rTime_Stamp);
   (tVoid) (oIn >> sPhone_Number);
   (tVoid) (oIn >> rOpening_Hour);
   (tVoid) (oIn >> e8Charge_Station_Accessibility);
   (tVoid) (oIn >> e8Payment_Method_Type);
   (tVoid) (oIn >> u8Spot_Total_Number);
   (tVoid) (oIn >> u8Number_Available_Batteries);
   (tVoid) (oIn >> rFull_Address);
   (tVoid) (oIn >> u8Charge_Staion_Ranking);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgChargeStationStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Station_List_Number);
   (tVoid) (oOut << sCharge_Station_ID);
   (tVoid) (oOut << rEPOI_GPS_Position);
   (tVoid) (oOut << sEnergy_Provider_Name);
   (tVoid) (oOut << sUtility_Aggregator_ID);
   (tVoid) (oOut << rTime_Stamp);
   (tVoid) (oOut << sPhone_Number);
   (tVoid) (oOut << rOpening_Hour);
   (tVoid) (oOut << e8Charge_Station_Accessibility);
   (tVoid) (oOut << e8Payment_Method_Type);
   (tVoid) (oOut << u8Spot_Total_Number);
   (tVoid) (oOut << u8Number_Available_Batteries);
   (tVoid) (oOut << rFull_Address);
   (tVoid) (oOut << u8Charge_Staion_Ranking);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgChargeStationStatusStatus::operator==(const midw_ext_tcufi_tclMsgChargeStationStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Station_List_Number == roRef.u8Station_List_Number);
   bResult = bResult && (sCharge_Station_ID == roRef.sCharge_Station_ID);
   bResult = bResult && (rEPOI_GPS_Position == roRef.rEPOI_GPS_Position);
   bResult = bResult && (sEnergy_Provider_Name == roRef.sEnergy_Provider_Name);
   bResult = bResult && (sUtility_Aggregator_ID == roRef.sUtility_Aggregator_ID);
   bResult = bResult && (rTime_Stamp == roRef.rTime_Stamp);
   bResult = bResult && (sPhone_Number == roRef.sPhone_Number);
   bResult = bResult && (rOpening_Hour == roRef.rOpening_Hour);
   bResult = bResult && (e8Charge_Station_Accessibility == roRef.e8Charge_Station_Accessibility);
   bResult = bResult && (e8Payment_Method_Type == roRef.e8Payment_Method_Type);
   bResult = bResult && (u8Spot_Total_Number == roRef.u8Spot_Total_Number);
   bResult = bResult && (u8Number_Available_Batteries == roRef.u8Number_Available_Batteries);
   bResult = bResult && (rFull_Address == roRef.rFull_Address);
   bResult = bResult && (u8Charge_Staion_Ranking == roRef.u8Charge_Staion_Ranking);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgShort_BookingStatusUpReg::midw_ext_tcufi_tclMsgShort_BookingStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgShort_BookingStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGSTATUSUPREG;
}


midw_ext_tcufi_tclMsgShort_BookingStatusUpReg::~midw_ext_tcufi_tclMsgShort_BookingStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgShort_BookingStatusRelUpReg::midw_ext_tcufi_tclMsgShort_BookingStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgShort_BookingStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgShort_BookingStatusRelUpReg::~midw_ext_tcufi_tclMsgShort_BookingStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgShort_BookingStatusGet::midw_ext_tcufi_tclMsgShort_BookingStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgShort_BookingStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGSTATUSGET;
}


midw_ext_tcufi_tclMsgShort_BookingStatusGet::~midw_ext_tcufi_tclMsgShort_BookingStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgShort_BookingStatusStatus::midw_ext_tcufi_tclMsgShort_BookingStatusStatus(const midw_ext_tcufi_tclMsgShort_BookingStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8Booking_Status = coRef.e8Booking_Status;
}
midw_ext_tcufi_tclMsgShort_BookingStatusStatus& midw_ext_tcufi_tclMsgShort_BookingStatusStatus::operator=(const midw_ext_tcufi_tclMsgShort_BookingStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8Booking_Status = coRef.e8Booking_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgShort_BookingStatusStatus::midw_ext_tcufi_tclMsgShort_BookingStatusStatus()
:e8InvalidParameter()
,e8Booking_Status()
 {}

tS32 midw_ext_tcufi_tclMsgShort_BookingStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgShort_BookingStatusStatus::~midw_ext_tcufi_tclMsgShort_BookingStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgShort_BookingStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgShort_BookingStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8InvalidParameter);
   (tVoid) (oIn >> e8Booking_Status);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgShort_BookingStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8InvalidParameter);
   (tVoid) (oOut << e8Booking_Status);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgShort_BookingStatusStatus::operator==(const midw_ext_tcufi_tclMsgShort_BookingStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8InvalidParameter == roRef.e8InvalidParameter);
   bResult = bResult && (e8Booking_Status == roRef.e8Booking_Status);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgShort_BookingIndicationUpReg::midw_ext_tcufi_tclMsgShort_BookingIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgShort_BookingIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgShort_BookingIndicationUpReg::~midw_ext_tcufi_tclMsgShort_BookingIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgShort_BookingIndicationRelUpReg::midw_ext_tcufi_tclMsgShort_BookingIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgShort_BookingIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgShort_BookingIndicationRelUpReg::~midw_ext_tcufi_tclMsgShort_BookingIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgShort_BookingIndicationGet::midw_ext_tcufi_tclMsgShort_BookingIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgShort_BookingIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGINDICATIONGET;
}


midw_ext_tcufi_tclMsgShort_BookingIndicationGet::~midw_ext_tcufi_tclMsgShort_BookingIndicationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgShort_BookingIndicationStatus::midw_ext_tcufi_tclMsgShort_BookingIndicationStatus(const midw_ext_tcufi_tclMsgShort_BookingIndicationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Booking_Status = coRef.e8Booking_Status;
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   sCharge_Spot_ID = coRef.sCharge_Spot_ID;
   e8Charge_Receptacle_Type = coRef.e8Charge_Receptacle_Type;
   e8Charge_Receptacle_Facility_Byte = coRef.e8Charge_Receptacle_Facility_Byte;
   rMax_Time_To_Arrive = coRef.rMax_Time_To_Arrive;
   rMax_Time_To_Unbook = coRef.rMax_Time_To_Unbook;
   sBooking_ID = coRef.sBooking_ID;
   rBookable_Free_Text = coRef.rBookable_Free_Text;
   rTime_Stamp = coRef.rTime_Stamp;
}
midw_ext_tcufi_tclMsgShort_BookingIndicationStatus& midw_ext_tcufi_tclMsgShort_BookingIndicationStatus::operator=(const midw_ext_tcufi_tclMsgShort_BookingIndicationStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Booking_Status = coRef.e8Booking_Status;
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   sCharge_Spot_ID = coRef.sCharge_Spot_ID;
   e8Charge_Receptacle_Type = coRef.e8Charge_Receptacle_Type;
   e8Charge_Receptacle_Facility_Byte = coRef.e8Charge_Receptacle_Facility_Byte;
   rMax_Time_To_Arrive = coRef.rMax_Time_To_Arrive;
   rMax_Time_To_Unbook = coRef.rMax_Time_To_Unbook;
   sBooking_ID = coRef.sBooking_ID;
   rBookable_Free_Text = coRef.rBookable_Free_Text;
   rTime_Stamp = coRef.rTime_Stamp;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgShort_BookingIndicationStatus::vDestroy()
{
   sCharge_Station_ID.vDestroy();
   sCharge_Spot_ID.vDestroy();
   rMax_Time_To_Arrive.vDestroy(); 
   rMax_Time_To_Unbook.vDestroy(); 
   sBooking_ID.vDestroy();
   rBookable_Free_Text.vDestroy(); 
   rTime_Stamp.vDestroy(); 
}

midw_ext_tcufi_tclMsgShort_BookingIndicationStatus::midw_ext_tcufi_tclMsgShort_BookingIndicationStatus()
:e8Booking_Status()
,sCharge_Station_ID()
,sCharge_Spot_ID()
,e8Charge_Receptacle_Type()
,e8Charge_Receptacle_Facility_Byte()
,rMax_Time_To_Arrive()
,rMax_Time_To_Unbook()
,sBooking_ID()
,rBookable_Free_Text()
,rTime_Stamp()
 {}

tS32 midw_ext_tcufi_tclMsgShort_BookingIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_BOOKINGINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgShort_BookingIndicationStatus::~midw_ext_tcufi_tclMsgShort_BookingIndicationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgShort_BookingIndicationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 15+sCharge_Station_ID.u32GetSize(u16MajorVersion)+sCharge_Spot_ID.u32GetSize(u16MajorVersion)+sBooking_ID.u32GetSize(u16MajorVersion)+rBookable_Free_Text.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgShort_BookingIndicationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Booking_Status);
   (tVoid) (oIn >> sCharge_Station_ID);
   (tVoid) (oIn >> sCharge_Spot_ID);
   (tVoid) (oIn >> e8Charge_Receptacle_Type);
   (tVoid) (oIn >> e8Charge_Receptacle_Facility_Byte);
   (tVoid) (oIn >> rMax_Time_To_Arrive);
   (tVoid) (oIn >> rMax_Time_To_Unbook);
   (tVoid) (oIn >> sBooking_ID);
   (tVoid) (oIn >> rBookable_Free_Text);
   (tVoid) (oIn >> rTime_Stamp);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgShort_BookingIndicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Booking_Status);
   (tVoid) (oOut << sCharge_Station_ID);
   (tVoid) (oOut << sCharge_Spot_ID);
   (tVoid) (oOut << e8Charge_Receptacle_Type);
   (tVoid) (oOut << e8Charge_Receptacle_Facility_Byte);
   (tVoid) (oOut << rMax_Time_To_Arrive);
   (tVoid) (oOut << rMax_Time_To_Unbook);
   (tVoid) (oOut << sBooking_ID);
   (tVoid) (oOut << rBookable_Free_Text);
   (tVoid) (oOut << rTime_Stamp);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgShort_BookingIndicationStatus::operator==(const midw_ext_tcufi_tclMsgShort_BookingIndicationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Booking_Status == roRef.e8Booking_Status);
   bResult = bResult && (sCharge_Station_ID == roRef.sCharge_Station_ID);
   bResult = bResult && (sCharge_Spot_ID == roRef.sCharge_Spot_ID);
   bResult = bResult && (e8Charge_Receptacle_Type == roRef.e8Charge_Receptacle_Type);
   bResult = bResult && (e8Charge_Receptacle_Facility_Byte == roRef.e8Charge_Receptacle_Facility_Byte);
   bResult = bResult && (rMax_Time_To_Arrive == roRef.rMax_Time_To_Arrive);
   bResult = bResult && (rMax_Time_To_Unbook == roRef.rMax_Time_To_Unbook);
   bResult = bResult && (sBooking_ID == roRef.sBooking_ID);
   bResult = bResult && (rBookable_Free_Text == roRef.rBookable_Free_Text);
   bResult = bResult && (rTime_Stamp == roRef.rTime_Stamp);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgShort_UnbookingStatusUpReg::midw_ext_tcufi_tclMsgShort_UnbookingStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgShort_UnbookingStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGSTATUSUPREG;
}


midw_ext_tcufi_tclMsgShort_UnbookingStatusUpReg::~midw_ext_tcufi_tclMsgShort_UnbookingStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgShort_UnbookingStatusRelUpReg::midw_ext_tcufi_tclMsgShort_UnbookingStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgShort_UnbookingStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgShort_UnbookingStatusRelUpReg::~midw_ext_tcufi_tclMsgShort_UnbookingStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgShort_UnbookingStatusGet::midw_ext_tcufi_tclMsgShort_UnbookingStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgShort_UnbookingStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGSTATUSGET;
}


midw_ext_tcufi_tclMsgShort_UnbookingStatusGet::~midw_ext_tcufi_tclMsgShort_UnbookingStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus::midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus(const midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8Unbooking_Status = coRef.e8Unbooking_Status;
}
midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus& midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus::operator=(const midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8Unbooking_Status = coRef.e8Unbooking_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus::midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus()
:e8InvalidParameter()
,e8Unbooking_Status()
 {}

tS32 midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus::~midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8InvalidParameter);
   (tVoid) (oIn >> e8Unbooking_Status);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8InvalidParameter);
   (tVoid) (oOut << e8Unbooking_Status);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus::operator==(const midw_ext_tcufi_tclMsgShort_UnbookingStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8InvalidParameter == roRef.e8InvalidParameter);
   bResult = bResult && (e8Unbooking_Status == roRef.e8Unbooking_Status);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgShort_UnbookingIndicationUpReg::midw_ext_tcufi_tclMsgShort_UnbookingIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgShort_UnbookingIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgShort_UnbookingIndicationUpReg::~midw_ext_tcufi_tclMsgShort_UnbookingIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgShort_UnbookingIndicationRelUpReg::midw_ext_tcufi_tclMsgShort_UnbookingIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgShort_UnbookingIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgShort_UnbookingIndicationRelUpReg::~midw_ext_tcufi_tclMsgShort_UnbookingIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgShort_UnbookingIndicationGet::midw_ext_tcufi_tclMsgShort_UnbookingIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgShort_UnbookingIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGINDICATIONGET;
}


midw_ext_tcufi_tclMsgShort_UnbookingIndicationGet::~midw_ext_tcufi_tclMsgShort_UnbookingIndicationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus::midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus(const midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   sCharge_Spot_ID = coRef.sCharge_Spot_ID;
   sBooking_ID = coRef.sBooking_ID;
   e8Unbooking_Status = coRef.e8Unbooking_Status;
}
midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus& midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus::operator=(const midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus& coRef)
{
   if (this == &coRef) return *this;
   sCharge_Station_ID = coRef.sCharge_Station_ID;
   sCharge_Spot_ID = coRef.sCharge_Spot_ID;
   sBooking_ID = coRef.sBooking_ID;
   e8Unbooking_Status = coRef.e8Unbooking_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus::vDestroy()
{
   sCharge_Station_ID.vDestroy();
   sCharge_Spot_ID.vDestroy();
   sBooking_ID.vDestroy();
}

midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus::midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus()
:sCharge_Station_ID()
,sCharge_Spot_ID()
,sBooking_ID()
,e8Unbooking_Status()
 {}

tS32 midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SHORT_UNBOOKINGINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus::~midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sCharge_Station_ID.u32GetSize(u16MajorVersion)+sCharge_Spot_ID.u32GetSize(u16MajorVersion)+sBooking_ID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sCharge_Station_ID);
   (tVoid) (oIn >> sCharge_Spot_ID);
   (tVoid) (oIn >> sBooking_ID);
   (tVoid) (oIn >> e8Unbooking_Status);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sCharge_Station_ID);
   (tVoid) (oOut << sCharge_Spot_ID);
   (tVoid) (oOut << sBooking_ID);
   (tVoid) (oOut << e8Unbooking_Status);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus::operator==(const midw_ext_tcufi_tclMsgShort_UnbookingIndicationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sCharge_Station_ID == roRef.sCharge_Station_ID);
   bResult = bResult && (sCharge_Spot_ID == roRef.sCharge_Spot_ID);
   bResult = bResult && (sBooking_ID == roRef.sBooking_ID);
   bResult = bResult && (e8Unbooking_Status == roRef.e8Unbooking_Status);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgUpdateEnergyPointStatusUpReg::midw_ext_tcufi_tclMsgUpdateEnergyPointStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgUpdateEnergyPointStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTSTATUSUPREG;
}


midw_ext_tcufi_tclMsgUpdateEnergyPointStatusUpReg::~midw_ext_tcufi_tclMsgUpdateEnergyPointStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgUpdateEnergyPointStatusRelUpReg::midw_ext_tcufi_tclMsgUpdateEnergyPointStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgUpdateEnergyPointStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgUpdateEnergyPointStatusRelUpReg::~midw_ext_tcufi_tclMsgUpdateEnergyPointStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgUpdateEnergyPointStatusGet::midw_ext_tcufi_tclMsgUpdateEnergyPointStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgUpdateEnergyPointStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTSTATUSGET;
}


midw_ext_tcufi_tclMsgUpdateEnergyPointStatusGet::~midw_ext_tcufi_tclMsgUpdateEnergyPointStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus::midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus(const midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   e8Update_Status = coRef.e8Update_Status;
}
midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus& midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus::operator=(const midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   e8Update_Status = coRef.e8Update_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus::midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus()
:e8Invalid_Parameter()
,e8Update_Status()
 {}

tS32 midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus::~midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Invalid_Parameter);
   (tVoid) (oIn >> e8Update_Status);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Invalid_Parameter);
   (tVoid) (oOut << e8Update_Status);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus::operator==(const midw_ext_tcufi_tclMsgUpdateEnergyPointStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Invalid_Parameter == roRef.e8Invalid_Parameter);
   bResult = bResult && (e8Update_Status == roRef.e8Update_Status);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationUpReg::midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationUpReg::~midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationRelUpReg::midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationRelUpReg::~midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationGet::midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTINDICATIONGET;
}


midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationGet::~midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus::midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus(const midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Update_Status = coRef.e8Update_Status;
}
midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus& midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus::operator=(const midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Update_Status = coRef.e8Update_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus::midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus()
:e8Update_Status()
 {}

tS32 midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_UPDATEENERGYPOINTINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus::~midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus()
{}

tU32 midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Update_Status);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Update_Status);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus::operator==(const midw_ext_tcufi_tclMsgUpdateEnergyPointIndicationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Update_Status == roRef.e8Update_Status);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_ActivationStatusUpReg::midw_ext_tcufi_tclMsgSCH_ActivationStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_ActivationStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_ACTIVATIONSTATUSUPREG;
}


midw_ext_tcufi_tclMsgSCH_ActivationStatusUpReg::~midw_ext_tcufi_tclMsgSCH_ActivationStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_ActivationStatusRelUpReg::midw_ext_tcufi_tclMsgSCH_ActivationStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_ActivationStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_ACTIVATIONSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgSCH_ActivationStatusRelUpReg::~midw_ext_tcufi_tclMsgSCH_ActivationStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_ActivationStatusGet::midw_ext_tcufi_tclMsgSCH_ActivationStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_ActivationStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_ACTIVATIONSTATUSGET;
}


midw_ext_tcufi_tclMsgSCH_ActivationStatusGet::~midw_ext_tcufi_tclMsgSCH_ActivationStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus::midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus(const midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   e8Sch_Activation_State = coRef.e8Sch_Activation_State;
}
midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus& midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus::operator=(const midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   e8Sch_Activation_State = coRef.e8Sch_Activation_State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus::midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus()
:e8Invalid_Parameter()
,e8Sch_Activation_State()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_ACTIVATIONSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus::~midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Invalid_Parameter);
   (tVoid) (oIn >> e8Sch_Activation_State);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Invalid_Parameter);
   (tVoid) (oOut << e8Sch_Activation_State);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus::operator==(const midw_ext_tcufi_tclMsgSCH_ActivationStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Invalid_Parameter == roRef.e8Invalid_Parameter);
   bResult = bResult && (e8Sch_Activation_State == roRef.e8Sch_Activation_State);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusUpReg::midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_UPDATE_ONBOARDSTATUSUPREG;
}


midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusUpReg::~midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusRelUpReg::midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_UPDATE_ONBOARDSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusRelUpReg::~midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusGet::midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_UPDATE_ONBOARDSTATUSGET;
}


midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusGet::~midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus::midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus(const midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   rCharge_Day1_7_Start = coRef.rCharge_Day1_7_Start;
   rCharge_Day1_7_End = coRef.rCharge_Day1_7_End;
}
midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus& midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus::operator=(const midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   rCharge_Day1_7_Start = coRef.rCharge_Day1_7_Start;
   rCharge_Day1_7_End = coRef.rCharge_Day1_7_End;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus::midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus()
:e8Invalid_Parameter()
,rCharge_Day1_7_Start()
,rCharge_Day1_7_End()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_UPDATE_ONBOARDSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus::~midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Invalid_Parameter);
   (tVoid) (oIn >> rCharge_Day1_7_Start);
   (tVoid) (oIn >> rCharge_Day1_7_End);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Invalid_Parameter);
   (tVoid) (oOut << rCharge_Day1_7_Start);
   (tVoid) (oOut << rCharge_Day1_7_End);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus::operator==(const midw_ext_tcufi_tclMsgSCH_Update_ONBOARDStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Invalid_Parameter == roRef.e8Invalid_Parameter);
   bResult = bResult && (rCharge_Day1_7_Start == roRef.rCharge_Day1_7_Start);
   bResult = bResult && (rCharge_Day1_7_End == roRef.rCharge_Day1_7_End);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgCharge_BlockedIndicationUpReg::midw_ext_tcufi_tclMsgCharge_BlockedIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCharge_BlockedIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGE_BLOCKEDINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgCharge_BlockedIndicationUpReg::~midw_ext_tcufi_tclMsgCharge_BlockedIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCharge_BlockedIndicationRelUpReg::midw_ext_tcufi_tclMsgCharge_BlockedIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCharge_BlockedIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGE_BLOCKEDINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgCharge_BlockedIndicationRelUpReg::~midw_ext_tcufi_tclMsgCharge_BlockedIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCharge_BlockedIndicationGet::midw_ext_tcufi_tclMsgCharge_BlockedIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgCharge_BlockedIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGE_BLOCKEDINDICATIONGET;
}


midw_ext_tcufi_tclMsgCharge_BlockedIndicationGet::~midw_ext_tcufi_tclMsgCharge_BlockedIndicationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus::midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus(const midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Charge_Blocked_Status = coRef.e8Charge_Blocked_Status;
}
midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus& midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus::operator=(const midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Charge_Blocked_Status = coRef.e8Charge_Blocked_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus::midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus()
:e8Charge_Blocked_Status()
 {}

tS32 midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGE_BLOCKEDINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus::~midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus()
{}

tU32 midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Charge_Blocked_Status);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Charge_Blocked_Status);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus::operator==(const midw_ext_tcufi_tclMsgCharge_BlockedIndicationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Charge_Blocked_Status == roRef.e8Charge_Blocked_Status);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_StateStatusUpReg::midw_ext_tcufi_tclMsgSCH_StateStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_StateStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_STATESTATUSUPREG;
}


midw_ext_tcufi_tclMsgSCH_StateStatusUpReg::~midw_ext_tcufi_tclMsgSCH_StateStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_StateStatusRelUpReg::midw_ext_tcufi_tclMsgSCH_StateStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_StateStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_STATESTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgSCH_StateStatusRelUpReg::~midw_ext_tcufi_tclMsgSCH_StateStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_StateStatusGet::midw_ext_tcufi_tclMsgSCH_StateStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_StateStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_STATESTATUSGET;
}


midw_ext_tcufi_tclMsgSCH_StateStatusGet::~midw_ext_tcufi_tclMsgSCH_StateStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSCH_StateStatusStatus::midw_ext_tcufi_tclMsgSCH_StateStatusStatus(const midw_ext_tcufi_tclMsgSCH_StateStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   e8Sch_Activation_State = coRef.e8Sch_Activation_State;
   rCharge_Day1_7_Start = coRef.rCharge_Day1_7_Start;
   rCharge_Day1_7_End = coRef.rCharge_Day1_7_End;
}
midw_ext_tcufi_tclMsgSCH_StateStatusStatus& midw_ext_tcufi_tclMsgSCH_StateStatusStatus::operator=(const midw_ext_tcufi_tclMsgSCH_StateStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   e8Sch_Activation_State = coRef.e8Sch_Activation_State;
   rCharge_Day1_7_Start = coRef.rCharge_Day1_7_Start;
   rCharge_Day1_7_End = coRef.rCharge_Day1_7_End;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSCH_StateStatusStatus::midw_ext_tcufi_tclMsgSCH_StateStatusStatus()
:e8Invalid_Parameter()
,e8Sch_Activation_State()
,rCharge_Day1_7_Start()
,rCharge_Day1_7_End()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_StateStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_STATESTATUSSTATUS;
}


midw_ext_tcufi_tclMsgSCH_StateStatusStatus::~midw_ext_tcufi_tclMsgSCH_StateStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgSCH_StateStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSCH_StateStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Invalid_Parameter);
   (tVoid) (oIn >> e8Sch_Activation_State);
   (tVoid) (oIn >> rCharge_Day1_7_Start);
   (tVoid) (oIn >> rCharge_Day1_7_End);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSCH_StateStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Invalid_Parameter);
   (tVoid) (oOut << e8Sch_Activation_State);
   (tVoid) (oOut << rCharge_Day1_7_Start);
   (tVoid) (oOut << rCharge_Day1_7_End);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSCH_StateStatusStatus::operator==(const midw_ext_tcufi_tclMsgSCH_StateStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Invalid_Parameter == roRef.e8Invalid_Parameter);
   bResult = bResult && (e8Sch_Activation_State == roRef.e8Sch_Activation_State);
   bResult = bResult && (rCharge_Day1_7_Start == roRef.rCharge_Day1_7_Start);
   bResult = bResult && (rCharge_Day1_7_End == roRef.rCharge_Day1_7_End);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_StateIndicationUpReg::midw_ext_tcufi_tclMsgSCH_StateIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_StateIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_STATEINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgSCH_StateIndicationUpReg::~midw_ext_tcufi_tclMsgSCH_StateIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_StateIndicationRelUpReg::midw_ext_tcufi_tclMsgSCH_StateIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_StateIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_STATEINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgSCH_StateIndicationRelUpReg::~midw_ext_tcufi_tclMsgSCH_StateIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSCH_StateIndicationGet::midw_ext_tcufi_tclMsgSCH_StateIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_StateIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_STATEINDICATIONGET;
}


midw_ext_tcufi_tclMsgSCH_StateIndicationGet::~midw_ext_tcufi_tclMsgSCH_StateIndicationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSCH_StateIndicationStatus::midw_ext_tcufi_tclMsgSCH_StateIndicationStatus(const midw_ext_tcufi_tclMsgSCH_StateIndicationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Sch_Activation_State = coRef.e8Sch_Activation_State;
   rCharge_Day1_7_Start = coRef.rCharge_Day1_7_Start;
   rCharge_Day1_7_End = coRef.rCharge_Day1_7_End;
}
midw_ext_tcufi_tclMsgSCH_StateIndicationStatus& midw_ext_tcufi_tclMsgSCH_StateIndicationStatus::operator=(const midw_ext_tcufi_tclMsgSCH_StateIndicationStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Sch_Activation_State = coRef.e8Sch_Activation_State;
   rCharge_Day1_7_Start = coRef.rCharge_Day1_7_Start;
   rCharge_Day1_7_End = coRef.rCharge_Day1_7_End;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSCH_StateIndicationStatus::midw_ext_tcufi_tclMsgSCH_StateIndicationStatus()
:e8Sch_Activation_State()
,rCharge_Day1_7_Start()
,rCharge_Day1_7_End()
 {}

tS32 midw_ext_tcufi_tclMsgSCH_StateIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SCH_STATEINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgSCH_StateIndicationStatus::~midw_ext_tcufi_tclMsgSCH_StateIndicationStatus()
{}

tU32 midw_ext_tcufi_tclMsgSCH_StateIndicationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSCH_StateIndicationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Sch_Activation_State);
   (tVoid) (oIn >> rCharge_Day1_7_Start);
   (tVoid) (oIn >> rCharge_Day1_7_End);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSCH_StateIndicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Sch_Activation_State);
   (tVoid) (oOut << rCharge_Day1_7_Start);
   (tVoid) (oOut << rCharge_Day1_7_End);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSCH_StateIndicationStatus::operator==(const midw_ext_tcufi_tclMsgSCH_StateIndicationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Sch_Activation_State == roRef.e8Sch_Activation_State);
   bResult = bResult && (rCharge_Day1_7_Start == roRef.rCharge_Day1_7_Start);
   bResult = bResult && (rCharge_Day1_7_End == roRef.rCharge_Day1_7_End);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgStationFinderIndicationUpReg::midw_ext_tcufi_tclMsgStationFinderIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgStationFinderIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgStationFinderIndicationUpReg::~midw_ext_tcufi_tclMsgStationFinderIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgStationFinderIndicationRelUpReg::midw_ext_tcufi_tclMsgStationFinderIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgStationFinderIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgStationFinderIndicationRelUpReg::~midw_ext_tcufi_tclMsgStationFinderIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgStationFinderIndicationGet::midw_ext_tcufi_tclMsgStationFinderIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgStationFinderIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERINDICATIONGET;
}


midw_ext_tcufi_tclMsgStationFinderIndicationGet::~midw_ext_tcufi_tclMsgStationFinderIndicationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgStationFinderIndicationStatus::midw_ext_tcufi_tclMsgStationFinderIndicationStatus(const midw_ext_tcufi_tclMsgStationFinderIndicationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8FinderStatus = coRef.e8FinderStatus;
   u8Total_Station_Number = coRef.u8Total_Station_Number;
}
midw_ext_tcufi_tclMsgStationFinderIndicationStatus& midw_ext_tcufi_tclMsgStationFinderIndicationStatus::operator=(const midw_ext_tcufi_tclMsgStationFinderIndicationStatus& coRef)
{
   if (this == &coRef) return *this;
   e8FinderStatus = coRef.e8FinderStatus;
   u8Total_Station_Number = coRef.u8Total_Station_Number;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgStationFinderIndicationStatus::midw_ext_tcufi_tclMsgStationFinderIndicationStatus()
:e8FinderStatus()
,u8Total_Station_Number(0)
 {}

tS32 midw_ext_tcufi_tclMsgStationFinderIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_STATIONFINDERINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgStationFinderIndicationStatus::~midw_ext_tcufi_tclMsgStationFinderIndicationStatus()
{}

tU32 midw_ext_tcufi_tclMsgStationFinderIndicationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgStationFinderIndicationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8FinderStatus);
   (tVoid) (oIn >> u8Total_Station_Number);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgStationFinderIndicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8FinderStatus);
   (tVoid) (oOut << u8Total_Station_Number);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgStationFinderIndicationStatus::operator==(const midw_ext_tcufi_tclMsgStationFinderIndicationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8FinderStatus == roRef.e8FinderStatus);
   bResult = bResult && (u8Total_Station_Number == roRef.u8Total_Station_Number);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgChargeSpotListStatusUpReg::midw_ext_tcufi_tclMsgChargeSpotListStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgChargeSpotListStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGESPOTLISTSTATUSUPREG;
}


midw_ext_tcufi_tclMsgChargeSpotListStatusUpReg::~midw_ext_tcufi_tclMsgChargeSpotListStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgChargeSpotListStatusRelUpReg::midw_ext_tcufi_tclMsgChargeSpotListStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgChargeSpotListStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGESPOTLISTSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgChargeSpotListStatusRelUpReg::~midw_ext_tcufi_tclMsgChargeSpotListStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgChargeSpotListStatusGet::midw_ext_tcufi_tclMsgChargeSpotListStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgChargeSpotListStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGESPOTLISTSTATUSGET;
}


midw_ext_tcufi_tclMsgChargeSpotListStatusGet::~midw_ext_tcufi_tclMsgChargeSpotListStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgChargeSpotListStatusStatus::midw_ext_tcufi_tclMsgChargeSpotListStatusStatus(const midw_ext_tcufi_tclMsgChargeSpotListStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8InvalidParameter = coRef.e8InvalidParameter;
   rChargeSpotList = coRef.rChargeSpotList;
}
midw_ext_tcufi_tclMsgChargeSpotListStatusStatus& midw_ext_tcufi_tclMsgChargeSpotListStatusStatus::operator=(const midw_ext_tcufi_tclMsgChargeSpotListStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8InvalidParameter = coRef.e8InvalidParameter;
   rChargeSpotList = coRef.rChargeSpotList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgChargeSpotListStatusStatus::vDestroy()
{
   rChargeSpotList.vDestroy(); 
}

midw_ext_tcufi_tclMsgChargeSpotListStatusStatus::midw_ext_tcufi_tclMsgChargeSpotListStatusStatus()
:e8InvalidParameter()
,rChargeSpotList()
 {}

tS32 midw_ext_tcufi_tclMsgChargeSpotListStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CHARGESPOTLISTSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgChargeSpotListStatusStatus::~midw_ext_tcufi_tclMsgChargeSpotListStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgChargeSpotListStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+rChargeSpotList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgChargeSpotListStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8InvalidParameter);
   (tVoid) (oIn >> rChargeSpotList);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgChargeSpotListStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8InvalidParameter);
   (tVoid) (oOut << rChargeSpotList);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgChargeSpotListStatusStatus::operator==(const midw_ext_tcufi_tclMsgChargeSpotListStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8InvalidParameter == roRef.e8InvalidParameter);
   bResult = bResult && (rChargeSpotList == roRef.rChargeSpotList);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationUpReg::midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationUpReg::~midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationRelUpReg::midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationRelUpReg::~midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationGet::midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTINDICATIONGET;
}


midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationGet::~midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus::midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus(const midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rWifi_SSID_Name = coRef.rWifi_SSID_Name;
   rWifi_PassKey = coRef.rWifi_PassKey;
   e8Wifi_Security_Mode = coRef.e8Wifi_Security_Mode;
   u8Wifi_Channel_Number = coRef.u8Wifi_Channel_Number;
   e8Wifi_Visibility = coRef.e8Wifi_Visibility;
}
midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus& midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus::operator=(const midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus& coRef)
{
   if (this == &coRef) return *this;
   rWifi_SSID_Name = coRef.rWifi_SSID_Name;
   rWifi_PassKey = coRef.rWifi_PassKey;
   e8Wifi_Security_Mode = coRef.e8Wifi_Security_Mode;
   u8Wifi_Channel_Number = coRef.u8Wifi_Channel_Number;
   e8Wifi_Visibility = coRef.e8Wifi_Visibility;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus::vDestroy()
{
   rWifi_SSID_Name.vDestroy(); 
   rWifi_PassKey.vDestroy(); 
}

midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus::midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus()
:rWifi_SSID_Name()
,rWifi_PassKey()
,e8Wifi_Security_Mode()
,u8Wifi_Channel_Number(0)
,e8Wifi_Visibility()
 {}

tS32 midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus::~midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+rWifi_SSID_Name.u32GetSize(u16MajorVersion)+rWifi_PassKey.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rWifi_SSID_Name);
   (tVoid) (oIn >> rWifi_PassKey);
   (tVoid) (oIn >> e8Wifi_Security_Mode);
   (tVoid) (oIn >> u8Wifi_Channel_Number);
   (tVoid) (oIn >> e8Wifi_Visibility);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rWifi_SSID_Name);
   (tVoid) (oOut << rWifi_PassKey);
   (tVoid) (oOut << e8Wifi_Security_Mode);
   (tVoid) (oOut << u8Wifi_Channel_Number);
   (tVoid) (oOut << e8Wifi_Visibility);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus::operator==(const midw_ext_tcufi_tclMsgWifiHotSpotRequestIndicationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rWifi_SSID_Name == roRef.rWifi_SSID_Name);
   bResult = bResult && (rWifi_PassKey == roRef.rWifi_PassKey);
   bResult = bResult && (e8Wifi_Security_Mode == roRef.e8Wifi_Security_Mode);
   bResult = bResult && (u8Wifi_Channel_Number == roRef.u8Wifi_Channel_Number);
   bResult = bResult && (e8Wifi_Visibility == roRef.e8Wifi_Visibility);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgWifiHotSpotRequestUpReg::midw_ext_tcufi_tclMsgWifiHotSpotRequestUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiHotSpotRequestUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTUPREG;
}


midw_ext_tcufi_tclMsgWifiHotSpotRequestUpReg::~midw_ext_tcufi_tclMsgWifiHotSpotRequestUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiHotSpotRequestRelUpReg::midw_ext_tcufi_tclMsgWifiHotSpotRequestRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiHotSpotRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTRELUPREG;
}


midw_ext_tcufi_tclMsgWifiHotSpotRequestRelUpReg::~midw_ext_tcufi_tclMsgWifiHotSpotRequestRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiHotSpotRequestGet::midw_ext_tcufi_tclMsgWifiHotSpotRequestGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiHotSpotRequestGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTGET;
}


midw_ext_tcufi_tclMsgWifiHotSpotRequestGet::~midw_ext_tcufi_tclMsgWifiHotSpotRequestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus::midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus(const midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   rWifi_SSID_Name = coRef.rWifi_SSID_Name;
   rWifi_PassKey = coRef.rWifi_PassKey;
   e8Wifi_Security_Mode = coRef.e8Wifi_Security_Mode;
   u8Wifi_Channel_Number = coRef.u8Wifi_Channel_Number;
   e8Wifi_Visibility = coRef.e8Wifi_Visibility;
}
midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus& midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus::operator=(const midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   rWifi_SSID_Name = coRef.rWifi_SSID_Name;
   rWifi_PassKey = coRef.rWifi_PassKey;
   e8Wifi_Security_Mode = coRef.e8Wifi_Security_Mode;
   u8Wifi_Channel_Number = coRef.u8Wifi_Channel_Number;
   e8Wifi_Visibility = coRef.e8Wifi_Visibility;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus::vDestroy()
{
   rWifi_SSID_Name.vDestroy(); 
   rWifi_PassKey.vDestroy(); 
}

midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus::midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus()
:e8Invalid_Parameter()
,rWifi_SSID_Name()
,rWifi_PassKey()
,e8Wifi_Security_Mode()
,u8Wifi_Channel_Number(0)
,e8Wifi_Visibility()
 {}

tS32 midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIHOTSPOTREQUESTSTATUS;
}


midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus::~midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+rWifi_SSID_Name.u32GetSize(u16MajorVersion)+rWifi_PassKey.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Invalid_Parameter);
   (tVoid) (oIn >> rWifi_SSID_Name);
   (tVoid) (oIn >> rWifi_PassKey);
   (tVoid) (oIn >> e8Wifi_Security_Mode);
   (tVoid) (oIn >> u8Wifi_Channel_Number);
   (tVoid) (oIn >> e8Wifi_Visibility);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Invalid_Parameter);
   (tVoid) (oOut << rWifi_SSID_Name);
   (tVoid) (oOut << rWifi_PassKey);
   (tVoid) (oOut << e8Wifi_Security_Mode);
   (tVoid) (oOut << u8Wifi_Channel_Number);
   (tVoid) (oOut << e8Wifi_Visibility);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus::operator==(const midw_ext_tcufi_tclMsgWifiHotSpotRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Invalid_Parameter == roRef.e8Invalid_Parameter);
   bResult = bResult && (rWifi_SSID_Name == roRef.rWifi_SSID_Name);
   bResult = bResult && (rWifi_PassKey == roRef.rWifi_PassKey);
   bResult = bResult && (e8Wifi_Security_Mode == roRef.e8Wifi_Security_Mode);
   bResult = bResult && (u8Wifi_Channel_Number == roRef.u8Wifi_Channel_Number);
   bResult = bResult && (e8Wifi_Visibility == roRef.e8Wifi_Visibility);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgWifiActivationRequestUpReg::midw_ext_tcufi_tclMsgWifiActivationRequestUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiActivationRequestUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIACTIVATIONREQUESTUPREG;
}


midw_ext_tcufi_tclMsgWifiActivationRequestUpReg::~midw_ext_tcufi_tclMsgWifiActivationRequestUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiActivationRequestRelUpReg::midw_ext_tcufi_tclMsgWifiActivationRequestRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiActivationRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIACTIVATIONREQUESTRELUPREG;
}


midw_ext_tcufi_tclMsgWifiActivationRequestRelUpReg::~midw_ext_tcufi_tclMsgWifiActivationRequestRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiActivationRequestGet::midw_ext_tcufi_tclMsgWifiActivationRequestGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiActivationRequestGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIACTIVATIONREQUESTGET;
}


midw_ext_tcufi_tclMsgWifiActivationRequestGet::~midw_ext_tcufi_tclMsgWifiActivationRequestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgWifiActivationRequestStatus::midw_ext_tcufi_tclMsgWifiActivationRequestStatus(const midw_ext_tcufi_tclMsgWifiActivationRequestStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   e8Wifi_Status = coRef.e8Wifi_Status;
   e8Wifi_Mode = coRef.e8Wifi_Mode;
}
midw_ext_tcufi_tclMsgWifiActivationRequestStatus& midw_ext_tcufi_tclMsgWifiActivationRequestStatus::operator=(const midw_ext_tcufi_tclMsgWifiActivationRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   e8Wifi_Status = coRef.e8Wifi_Status;
   e8Wifi_Mode = coRef.e8Wifi_Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgWifiActivationRequestStatus::midw_ext_tcufi_tclMsgWifiActivationRequestStatus()
:e8Invalid_Parameter()
,e8Wifi_Status()
,e8Wifi_Mode()
 {}

tS32 midw_ext_tcufi_tclMsgWifiActivationRequestStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIACTIVATIONREQUESTSTATUS;
}


midw_ext_tcufi_tclMsgWifiActivationRequestStatus::~midw_ext_tcufi_tclMsgWifiActivationRequestStatus()
{}

tU32 midw_ext_tcufi_tclMsgWifiActivationRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_tcufi_tclMsgWifiActivationRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Invalid_Parameter);
   (tVoid) (oIn >> e8Wifi_Status);
   (tVoid) (oIn >> e8Wifi_Mode);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgWifiActivationRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Invalid_Parameter);
   (tVoid) (oOut << e8Wifi_Status);
   (tVoid) (oOut << e8Wifi_Mode);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgWifiActivationRequestStatus::operator==(const midw_ext_tcufi_tclMsgWifiActivationRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Invalid_Parameter == roRef.e8Invalid_Parameter);
   bResult = bResult && (e8Wifi_Status == roRef.e8Wifi_Status);
   bResult = bResult && (e8Wifi_Mode == roRef.e8Wifi_Mode);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgWifiDataResetUpReg::midw_ext_tcufi_tclMsgWifiDataResetUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiDataResetUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIDATARESETUPREG;
}


midw_ext_tcufi_tclMsgWifiDataResetUpReg::~midw_ext_tcufi_tclMsgWifiDataResetUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiDataResetRelUpReg::midw_ext_tcufi_tclMsgWifiDataResetRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiDataResetRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIDATARESETRELUPREG;
}


midw_ext_tcufi_tclMsgWifiDataResetRelUpReg::~midw_ext_tcufi_tclMsgWifiDataResetRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiDataResetGet::midw_ext_tcufi_tclMsgWifiDataResetGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiDataResetGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIDATARESETGET;
}


midw_ext_tcufi_tclMsgWifiDataResetGet::~midw_ext_tcufi_tclMsgWifiDataResetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgWifiDataResetStatus::midw_ext_tcufi_tclMsgWifiDataResetStatus(const midw_ext_tcufi_tclMsgWifiDataResetStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rWifi_SSID_Name = coRef.rWifi_SSID_Name;
   rWifi_PassKey = coRef.rWifi_PassKey;
   e8Wifi_Security_Mode = coRef.e8Wifi_Security_Mode;
   u8Wifi_Channel_Number = coRef.u8Wifi_Channel_Number;
   e8Wifi_Visibility = coRef.e8Wifi_Visibility;
}
midw_ext_tcufi_tclMsgWifiDataResetStatus& midw_ext_tcufi_tclMsgWifiDataResetStatus::operator=(const midw_ext_tcufi_tclMsgWifiDataResetStatus& coRef)
{
   if (this == &coRef) return *this;
   rWifi_SSID_Name = coRef.rWifi_SSID_Name;
   rWifi_PassKey = coRef.rWifi_PassKey;
   e8Wifi_Security_Mode = coRef.e8Wifi_Security_Mode;
   u8Wifi_Channel_Number = coRef.u8Wifi_Channel_Number;
   e8Wifi_Visibility = coRef.e8Wifi_Visibility;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgWifiDataResetStatus::vDestroy()
{
   rWifi_SSID_Name.vDestroy(); 
   rWifi_PassKey.vDestroy(); 
}

midw_ext_tcufi_tclMsgWifiDataResetStatus::midw_ext_tcufi_tclMsgWifiDataResetStatus()
:rWifi_SSID_Name()
,rWifi_PassKey()
,e8Wifi_Security_Mode()
,u8Wifi_Channel_Number(0)
,e8Wifi_Visibility()
 {}

tS32 midw_ext_tcufi_tclMsgWifiDataResetStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFIDATARESETSTATUS;
}


midw_ext_tcufi_tclMsgWifiDataResetStatus::~midw_ext_tcufi_tclMsgWifiDataResetStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgWifiDataResetStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+rWifi_SSID_Name.u32GetSize(u16MajorVersion)+rWifi_PassKey.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgWifiDataResetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rWifi_SSID_Name);
   (tVoid) (oIn >> rWifi_PassKey);
   (tVoid) (oIn >> e8Wifi_Security_Mode);
   (tVoid) (oIn >> u8Wifi_Channel_Number);
   (tVoid) (oIn >> e8Wifi_Visibility);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgWifiDataResetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rWifi_SSID_Name);
   (tVoid) (oOut << rWifi_PassKey);
   (tVoid) (oOut << e8Wifi_Security_Mode);
   (tVoid) (oOut << u8Wifi_Channel_Number);
   (tVoid) (oOut << e8Wifi_Visibility);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgWifiDataResetStatus::operator==(const midw_ext_tcufi_tclMsgWifiDataResetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rWifi_SSID_Name == roRef.rWifi_SSID_Name);
   bResult = bResult && (rWifi_PassKey == roRef.rWifi_PassKey);
   bResult = bResult && (e8Wifi_Security_Mode == roRef.e8Wifi_Security_Mode);
   bResult = bResult && (u8Wifi_Channel_Number == roRef.u8Wifi_Channel_Number);
   bResult = bResult && (e8Wifi_Visibility == roRef.e8Wifi_Visibility);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientScanUpReg::midw_ext_tcufi_tclMsgWifiClientScanUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANUPREG;
}


midw_ext_tcufi_tclMsgWifiClientScanUpReg::~midw_ext_tcufi_tclMsgWifiClientScanUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientScanRelUpReg::midw_ext_tcufi_tclMsgWifiClientScanRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANRELUPREG;
}


midw_ext_tcufi_tclMsgWifiClientScanRelUpReg::~midw_ext_tcufi_tclMsgWifiClientScanRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientScanGet::midw_ext_tcufi_tclMsgWifiClientScanGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANGET;
}


midw_ext_tcufi_tclMsgWifiClientScanGet::~midw_ext_tcufi_tclMsgWifiClientScanGet()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientScanStatus::midw_ext_tcufi_tclMsgWifiClientScanStatus()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANSTATUS;
}


midw_ext_tcufi_tclMsgWifiClientScanStatus::~midw_ext_tcufi_tclMsgWifiClientScanStatus()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientScanIndicationUpReg::midw_ext_tcufi_tclMsgWifiClientScanIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgWifiClientScanIndicationUpReg::~midw_ext_tcufi_tclMsgWifiClientScanIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientScanIndicationRelUpReg::midw_ext_tcufi_tclMsgWifiClientScanIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgWifiClientScanIndicationRelUpReg::~midw_ext_tcufi_tclMsgWifiClientScanIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientScanIndicationGet::midw_ext_tcufi_tclMsgWifiClientScanIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANINDICATIONGET;
}


midw_ext_tcufi_tclMsgWifiClientScanIndicationGet::~midw_ext_tcufi_tclMsgWifiClientScanIndicationGet()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientScanIndicationStatus::midw_ext_tcufi_tclMsgWifiClientScanIndicationStatus()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgWifiClientScanIndicationStatus::~midw_ext_tcufi_tclMsgWifiClientScanIndicationStatus()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientConnectionUpReg::midw_ext_tcufi_tclMsgWifiClientConnectionUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientConnectionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONUPREG;
}


midw_ext_tcufi_tclMsgWifiClientConnectionUpReg::~midw_ext_tcufi_tclMsgWifiClientConnectionUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientConnectionRelUpReg::midw_ext_tcufi_tclMsgWifiClientConnectionRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONRELUPREG;
}


midw_ext_tcufi_tclMsgWifiClientConnectionRelUpReg::~midw_ext_tcufi_tclMsgWifiClientConnectionRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientConnectionGet::midw_ext_tcufi_tclMsgWifiClientConnectionGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientConnectionGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONGET;
}


midw_ext_tcufi_tclMsgWifiClientConnectionGet::~midw_ext_tcufi_tclMsgWifiClientConnectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgWifiClientConnectionStatus::midw_ext_tcufi_tclMsgWifiClientConnectionStatus(const midw_ext_tcufi_tclMsgWifiClientConnectionStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   rWifi_Scan_SSID_Name = coRef.rWifi_Scan_SSID_Name;
   e8Wifi_Connection_Status = coRef.e8Wifi_Connection_Status;
}
midw_ext_tcufi_tclMsgWifiClientConnectionStatus& midw_ext_tcufi_tclMsgWifiClientConnectionStatus::operator=(const midw_ext_tcufi_tclMsgWifiClientConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Invalid_Parameter = coRef.e8Invalid_Parameter;
   rWifi_Scan_SSID_Name = coRef.rWifi_Scan_SSID_Name;
   e8Wifi_Connection_Status = coRef.e8Wifi_Connection_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgWifiClientConnectionStatus::vDestroy()
{
   rWifi_Scan_SSID_Name.vDestroy(); 
}

midw_ext_tcufi_tclMsgWifiClientConnectionStatus::midw_ext_tcufi_tclMsgWifiClientConnectionStatus()
:e8Invalid_Parameter()
,rWifi_Scan_SSID_Name()
,e8Wifi_Connection_Status()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONSTATUS;
}


midw_ext_tcufi_tclMsgWifiClientConnectionStatus::~midw_ext_tcufi_tclMsgWifiClientConnectionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgWifiClientConnectionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+rWifi_Scan_SSID_Name.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgWifiClientConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Invalid_Parameter);
   (tVoid) (oIn >> rWifi_Scan_SSID_Name);
   (tVoid) (oIn >> e8Wifi_Connection_Status);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgWifiClientConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Invalid_Parameter);
   (tVoid) (oOut << rWifi_Scan_SSID_Name);
   (tVoid) (oOut << e8Wifi_Connection_Status);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgWifiClientConnectionStatus::operator==(const midw_ext_tcufi_tclMsgWifiClientConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Invalid_Parameter == roRef.e8Invalid_Parameter);
   bResult = bResult && (rWifi_Scan_SSID_Name == roRef.rWifi_Scan_SSID_Name);
   bResult = bResult && (e8Wifi_Connection_Status == roRef.e8Wifi_Connection_Status);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientConnectionIndicationUpReg::midw_ext_tcufi_tclMsgWifiClientConnectionIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientConnectionIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgWifiClientConnectionIndicationUpReg::~midw_ext_tcufi_tclMsgWifiClientConnectionIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientConnectionIndicationRelUpReg::midw_ext_tcufi_tclMsgWifiClientConnectionIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientConnectionIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgWifiClientConnectionIndicationRelUpReg::~midw_ext_tcufi_tclMsgWifiClientConnectionIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientConnectionIndicationGet::midw_ext_tcufi_tclMsgWifiClientConnectionIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientConnectionIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONINDICATIONGET;
}


midw_ext_tcufi_tclMsgWifiClientConnectionIndicationGet::~midw_ext_tcufi_tclMsgWifiClientConnectionIndicationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus::midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus(const midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rWifi_Scan_SSID_Name = coRef.rWifi_Scan_SSID_Name;
   e8Wifi_Connection_Status = coRef.e8Wifi_Connection_Status;
}
midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus& midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus::operator=(const midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus& coRef)
{
   if (this == &coRef) return *this;
   rWifi_Scan_SSID_Name = coRef.rWifi_Scan_SSID_Name;
   e8Wifi_Connection_Status = coRef.e8Wifi_Connection_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus::vDestroy()
{
   rWifi_Scan_SSID_Name.vDestroy(); 
}

midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus::midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus()
:rWifi_Scan_SSID_Name()
,e8Wifi_Connection_Status()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTCONNECTIONINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus::~midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+rWifi_Scan_SSID_Name.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rWifi_Scan_SSID_Name);
   (tVoid) (oIn >> e8Wifi_Connection_Status);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rWifi_Scan_SSID_Name);
   (tVoid) (oOut << e8Wifi_Connection_Status);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus::operator==(const midw_ext_tcufi_tclMsgWifiClientConnectionIndicationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rWifi_Scan_SSID_Name == roRef.rWifi_Scan_SSID_Name);
   bResult = bResult && (e8Wifi_Connection_Status == roRef.e8Wifi_Connection_Status);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientDisconnectionUpReg::midw_ext_tcufi_tclMsgWifiClientDisconnectionUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientDisconnectionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTDISCONNECTIONUPREG;
}


midw_ext_tcufi_tclMsgWifiClientDisconnectionUpReg::~midw_ext_tcufi_tclMsgWifiClientDisconnectionUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientDisconnectionRelUpReg::midw_ext_tcufi_tclMsgWifiClientDisconnectionRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientDisconnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTDISCONNECTIONRELUPREG;
}


midw_ext_tcufi_tclMsgWifiClientDisconnectionRelUpReg::~midw_ext_tcufi_tclMsgWifiClientDisconnectionRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientDisconnectionGet::midw_ext_tcufi_tclMsgWifiClientDisconnectionGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientDisconnectionGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTDISCONNECTIONGET;
}


midw_ext_tcufi_tclMsgWifiClientDisconnectionGet::~midw_ext_tcufi_tclMsgWifiClientDisconnectionGet()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientDisconnectionStatus::midw_ext_tcufi_tclMsgWifiClientDisconnectionStatus()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientDisconnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTDISCONNECTIONSTATUS;
}


midw_ext_tcufi_tclMsgWifiClientDisconnectionStatus::~midw_ext_tcufi_tclMsgWifiClientDisconnectionStatus()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientScanResultIndicationUpReg::midw_ext_tcufi_tclMsgWifiClientScanResultIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanResultIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANRESULTINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgWifiClientScanResultIndicationUpReg::~midw_ext_tcufi_tclMsgWifiClientScanResultIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientScanResultIndicationRelUpReg::midw_ext_tcufi_tclMsgWifiClientScanResultIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanResultIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANRESULTINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgWifiClientScanResultIndicationRelUpReg::~midw_ext_tcufi_tclMsgWifiClientScanResultIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientScanResultIndicationGet::midw_ext_tcufi_tclMsgWifiClientScanResultIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanResultIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANRESULTINDICATIONGET;
}


midw_ext_tcufi_tclMsgWifiClientScanResultIndicationGet::~midw_ext_tcufi_tclMsgWifiClientScanResultIndicationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus::midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus(const midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rWifi_Scan_SSID_Name = coRef.rWifi_Scan_SSID_Name;
   u8Wifi_Scan_Power = coRef.u8Wifi_Scan_Power;
   e8Wifi_Scan_Security = coRef.e8Wifi_Scan_Security;
}
midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus& midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus::operator=(const midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus& coRef)
{
   if (this == &coRef) return *this;
   rWifi_Scan_SSID_Name = coRef.rWifi_Scan_SSID_Name;
   u8Wifi_Scan_Power = coRef.u8Wifi_Scan_Power;
   e8Wifi_Scan_Security = coRef.e8Wifi_Scan_Security;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus::vDestroy()
{
   rWifi_Scan_SSID_Name.vDestroy(); 
}

midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus::midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus()
:rWifi_Scan_SSID_Name()
,u8Wifi_Scan_Power(0)
,e8Wifi_Scan_Security()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSCANRESULTINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus::~midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+rWifi_Scan_SSID_Name.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rWifi_Scan_SSID_Name);
   (tVoid) (oIn >> u8Wifi_Scan_Power);
   (tVoid) (oIn >> e8Wifi_Scan_Security);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rWifi_Scan_SSID_Name);
   (tVoid) (oOut << u8Wifi_Scan_Power);
   (tVoid) (oOut << e8Wifi_Scan_Security);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus::operator==(const midw_ext_tcufi_tclMsgWifiClientScanResultIndicationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rWifi_Scan_SSID_Name == roRef.rWifi_Scan_SSID_Name);
   bResult = bResult && (u8Wifi_Scan_Power == roRef.u8Wifi_Scan_Power);
   bResult = bResult && (e8Wifi_Scan_Security == roRef.e8Wifi_Scan_Security);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestUpReg::midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTEDDEVICESREQUESTUPREG;
}


midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestUpReg::~midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestRelUpReg::midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTEDDEVICESREQUESTRELUPREG;
}


midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestRelUpReg::~midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestGet::midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTEDDEVICESREQUESTGET;
}


midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestGet::~midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus::midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus(const midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   u8Wifi_Connected_Devices = coRef.u8Wifi_Connected_Devices;
}
midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus& midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus::operator=(const midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Wifi_Connected_Devices = coRef.u8Wifi_Connected_Devices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus::midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus()
:u8Wifi_Connected_Devices(0)
 {}

tS32 midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTEDDEVICESREQUESTSTATUS;
}


midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus::~midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus()
{}

tU32 midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Wifi_Connected_Devices);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Wifi_Connected_Devices);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus::operator==(const midw_ext_tcufi_tclMsgWifiConnectedDevicesRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Wifi_Connected_Devices == roRef.u8Wifi_Connected_Devices);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientStateUpReg::midw_ext_tcufi_tclMsgWifiClientStateUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEUPREG;
}


midw_ext_tcufi_tclMsgWifiClientStateUpReg::~midw_ext_tcufi_tclMsgWifiClientStateUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientStateRelUpReg::midw_ext_tcufi_tclMsgWifiClientStateRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATERELUPREG;
}


midw_ext_tcufi_tclMsgWifiClientStateRelUpReg::~midw_ext_tcufi_tclMsgWifiClientStateRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientStateGet::midw_ext_tcufi_tclMsgWifiClientStateGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEGET;
}


midw_ext_tcufi_tclMsgWifiClientStateGet::~midw_ext_tcufi_tclMsgWifiClientStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgWifiClientStateStatus::midw_ext_tcufi_tclMsgWifiClientStateStatus(const midw_ext_tcufi_tclMsgWifiClientStateStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Wifi_Client_Status = coRef.e8Wifi_Client_Status;
   rWifi_SSID = coRef.rWifi_SSID;
   u8Wifi_Client_Power = coRef.u8Wifi_Client_Power;
}
midw_ext_tcufi_tclMsgWifiClientStateStatus& midw_ext_tcufi_tclMsgWifiClientStateStatus::operator=(const midw_ext_tcufi_tclMsgWifiClientStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Wifi_Client_Status = coRef.e8Wifi_Client_Status;
   rWifi_SSID = coRef.rWifi_SSID;
   u8Wifi_Client_Power = coRef.u8Wifi_Client_Power;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgWifiClientStateStatus::vDestroy()
{
   rWifi_SSID.vDestroy(); 
}

midw_ext_tcufi_tclMsgWifiClientStateStatus::midw_ext_tcufi_tclMsgWifiClientStateStatus()
:e8Wifi_Client_Status()
,rWifi_SSID()
,u8Wifi_Client_Power(0)
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATESTATUS;
}


midw_ext_tcufi_tclMsgWifiClientStateStatus::~midw_ext_tcufi_tclMsgWifiClientStateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgWifiClientStateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+rWifi_SSID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgWifiClientStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Wifi_Client_Status);
   (tVoid) (oIn >> rWifi_SSID);
   (tVoid) (oIn >> u8Wifi_Client_Power);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgWifiClientStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Wifi_Client_Status);
   (tVoid) (oOut << rWifi_SSID);
   (tVoid) (oOut << u8Wifi_Client_Power);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgWifiClientStateStatus::operator==(const midw_ext_tcufi_tclMsgWifiClientStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Wifi_Client_Status == roRef.e8Wifi_Client_Status);
   bResult = bResult && (rWifi_SSID == roRef.rWifi_SSID);
   bResult = bResult && (u8Wifi_Client_Power == roRef.u8Wifi_Client_Power);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientStateIndicationUpReg::midw_ext_tcufi_tclMsgWifiClientStateIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientStateIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgWifiClientStateIndicationUpReg::~midw_ext_tcufi_tclMsgWifiClientStateIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientStateIndicationRelUpReg::midw_ext_tcufi_tclMsgWifiClientStateIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientStateIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgWifiClientStateIndicationRelUpReg::~midw_ext_tcufi_tclMsgWifiClientStateIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiClientStateIndicationGet::midw_ext_tcufi_tclMsgWifiClientStateIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientStateIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEINDICATIONGET;
}


midw_ext_tcufi_tclMsgWifiClientStateIndicationGet::~midw_ext_tcufi_tclMsgWifiClientStateIndicationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus::midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus(const midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8Wifi_Client_Status = coRef.e8Wifi_Client_Status;
   rWifi_SSID = coRef.rWifi_SSID;
   u8Wifi_Client_Power = coRef.u8Wifi_Client_Power;
}
midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus& midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus::operator=(const midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Wifi_Client_Status = coRef.e8Wifi_Client_Status;
   rWifi_SSID = coRef.rWifi_SSID;
   u8Wifi_Client_Power = coRef.u8Wifi_Client_Power;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus::vDestroy()
{
   rWifi_SSID.vDestroy(); 
}

midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus::midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus()
:e8Wifi_Client_Status()
,rWifi_SSID()
,u8Wifi_Client_Power(0)
 {}

tS32 midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICLIENTSTATEINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus::~midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+rWifi_SSID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Wifi_Client_Status);
   (tVoid) (oIn >> rWifi_SSID);
   (tVoid) (oIn >> u8Wifi_Client_Power);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Wifi_Client_Status);
   (tVoid) (oOut << rWifi_SSID);
   (tVoid) (oOut << u8Wifi_Client_Power);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus::operator==(const midw_ext_tcufi_tclMsgWifiClientStateIndicationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Wifi_Client_Status == roRef.e8Wifi_Client_Status);
   bResult = bResult && (rWifi_SSID == roRef.rWifi_SSID);
   bResult = bResult && (u8Wifi_Client_Power == roRef.u8Wifi_Client_Power);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationUpReg::midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONUPREG;
}


midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationUpReg::~midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationRelUpReg::midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONRELUPREG;
}


midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationRelUpReg::~midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationGet::midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationGet()
 {}

tS32 midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONGET;
}


midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationGet::~midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationGet()
{}

//=============================================================================

midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationStatus::midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationStatus()
 {}

tS32 midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONSTATUS;
}


midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationStatus::~midw_ext_tcufi_tclMsgWifiConnectionDeviceRejectedIndicationStatus()
{}

//=============================================================================

midw_ext_tcufi_tclMsgHardwareVersionUpReg::midw_ext_tcufi_tclMsgHardwareVersionUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgHardwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_HARDWAREVERSIONUPREG;
}


midw_ext_tcufi_tclMsgHardwareVersionUpReg::~midw_ext_tcufi_tclMsgHardwareVersionUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgHardwareVersionRelUpReg::midw_ext_tcufi_tclMsgHardwareVersionRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgHardwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG;
}


midw_ext_tcufi_tclMsgHardwareVersionRelUpReg::~midw_ext_tcufi_tclMsgHardwareVersionRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgHardwareVersionGet::midw_ext_tcufi_tclMsgHardwareVersionGet()
 {}

tS32 midw_ext_tcufi_tclMsgHardwareVersionGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_HARDWAREVERSIONGET;
}


midw_ext_tcufi_tclMsgHardwareVersionGet::~midw_ext_tcufi_tclMsgHardwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgHardwareVersionStatus::midw_ext_tcufi_tclMsgHardwareVersionStatus(const midw_ext_tcufi_tclMsgHardwareVersionStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rHardwareVersion = coRef.rHardwareVersion;
}
midw_ext_tcufi_tclMsgHardwareVersionStatus& midw_ext_tcufi_tclMsgHardwareVersionStatus::operator=(const midw_ext_tcufi_tclMsgHardwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   rHardwareVersion = coRef.rHardwareVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgHardwareVersionStatus::midw_ext_tcufi_tclMsgHardwareVersionStatus()
:rHardwareVersion()
 {}

tS32 midw_ext_tcufi_tclMsgHardwareVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS;
}


midw_ext_tcufi_tclMsgHardwareVersionStatus::~midw_ext_tcufi_tclMsgHardwareVersionStatus()
{}

tU32 midw_ext_tcufi_tclMsgHardwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_tcufi_tclMsgHardwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rHardwareVersion);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgHardwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rHardwareVersion);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgHardwareVersionStatus::operator==(const midw_ext_tcufi_tclMsgHardwareVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rHardwareVersion == roRef.rHardwareVersion);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSoftwareVersionUpReg::midw_ext_tcufi_tclMsgSoftwareVersionUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSoftwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG;
}


midw_ext_tcufi_tclMsgSoftwareVersionUpReg::~midw_ext_tcufi_tclMsgSoftwareVersionUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSoftwareVersionRelUpReg::midw_ext_tcufi_tclMsgSoftwareVersionRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSoftwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG;
}


midw_ext_tcufi_tclMsgSoftwareVersionRelUpReg::~midw_ext_tcufi_tclMsgSoftwareVersionRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSoftwareVersionGet::midw_ext_tcufi_tclMsgSoftwareVersionGet()
 {}

tS32 midw_ext_tcufi_tclMsgSoftwareVersionGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SOFTWAREVERSIONGET;
}


midw_ext_tcufi_tclMsgSoftwareVersionGet::~midw_ext_tcufi_tclMsgSoftwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSoftwareVersionStatus::midw_ext_tcufi_tclMsgSoftwareVersionStatus(const midw_ext_tcufi_tclMsgSoftwareVersionStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rSoftwareVersion = coRef.rSoftwareVersion;
}
midw_ext_tcufi_tclMsgSoftwareVersionStatus& midw_ext_tcufi_tclMsgSoftwareVersionStatus::operator=(const midw_ext_tcufi_tclMsgSoftwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   rSoftwareVersion = coRef.rSoftwareVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSoftwareVersionStatus::midw_ext_tcufi_tclMsgSoftwareVersionStatus()
:rSoftwareVersion()
 {}

tS32 midw_ext_tcufi_tclMsgSoftwareVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS;
}


midw_ext_tcufi_tclMsgSoftwareVersionStatus::~midw_ext_tcufi_tclMsgSoftwareVersionStatus()
{}

tU32 midw_ext_tcufi_tclMsgSoftwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSoftwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rSoftwareVersion);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSoftwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rSoftwareVersion);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSoftwareVersionStatus::operator==(const midw_ext_tcufi_tclMsgSoftwareVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rSoftwareVersion == roRef.rSoftwareVersion);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgPush_POIUpReg::midw_ext_tcufi_tclMsgPush_POIUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgPush_POIUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PUSH_POIUPREG;
}


midw_ext_tcufi_tclMsgPush_POIUpReg::~midw_ext_tcufi_tclMsgPush_POIUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgPush_POIRelUpReg::midw_ext_tcufi_tclMsgPush_POIRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgPush_POIRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PUSH_POIRELUPREG;
}


midw_ext_tcufi_tclMsgPush_POIRelUpReg::~midw_ext_tcufi_tclMsgPush_POIRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgPush_POIGet::midw_ext_tcufi_tclMsgPush_POIGet()
 {}

tS32 midw_ext_tcufi_tclMsgPush_POIGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PUSH_POIGET;
}


midw_ext_tcufi_tclMsgPush_POIGet::~midw_ext_tcufi_tclMsgPush_POIGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgPush_POIStatus::midw_ext_tcufi_tclMsgPush_POIStatus(const midw_ext_tcufi_tclMsgPush_POIStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bValid = coRef.bValid;
   u32POI_ID = coRef.u32POI_ID;
   rPOI_GPS_Position = coRef.rPOI_GPS_Position;
   sPOI_Name = coRef.sPOI_Name;
}
midw_ext_tcufi_tclMsgPush_POIStatus& midw_ext_tcufi_tclMsgPush_POIStatus::operator=(const midw_ext_tcufi_tclMsgPush_POIStatus& coRef)
{
   if (this == &coRef) return *this;
   bValid = coRef.bValid;
   u32POI_ID = coRef.u32POI_ID;
   rPOI_GPS_Position = coRef.rPOI_GPS_Position;
   sPOI_Name = coRef.sPOI_Name;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgPush_POIStatus::vDestroy()
{
   rPOI_GPS_Position.vDestroy(); 
   sPOI_Name.vDestroy();
}

midw_ext_tcufi_tclMsgPush_POIStatus::midw_ext_tcufi_tclMsgPush_POIStatus()
:bValid(0)
,u32POI_ID(0)
,rPOI_GPS_Position()
,sPOI_Name()
 {}

tS32 midw_ext_tcufi_tclMsgPush_POIStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PUSH_POISTATUS;
}


midw_ext_tcufi_tclMsgPush_POIStatus::~midw_ext_tcufi_tclMsgPush_POIStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgPush_POIStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 17+sPOI_Name.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgPush_POIStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bValid);
   (tVoid) (oIn >> u32POI_ID);
   (tVoid) (oIn >> rPOI_GPS_Position);
   (tVoid) (oIn >> sPOI_Name);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgPush_POIStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bValid);
   (tVoid) (oOut << u32POI_ID);
   (tVoid) (oOut << rPOI_GPS_Position);
   (tVoid) (oOut << sPOI_Name);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgPush_POIStatus::operator==(const midw_ext_tcufi_tclMsgPush_POIStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bValid == roRef.bValid);
   bResult = bResult && (u32POI_ID == roRef.u32POI_ID);
   bResult = bResult && (rPOI_GPS_Position == roRef.rPOI_GPS_Position);
   bResult = bResult && (sPOI_Name == roRef.sPOI_Name);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgTime_LimitUpReg::midw_ext_tcufi_tclMsgTime_LimitUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTime_LimitUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TIME_LIMITUPREG;
}


midw_ext_tcufi_tclMsgTime_LimitUpReg::~midw_ext_tcufi_tclMsgTime_LimitUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTime_LimitRelUpReg::midw_ext_tcufi_tclMsgTime_LimitRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTime_LimitRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TIME_LIMITRELUPREG;
}


midw_ext_tcufi_tclMsgTime_LimitRelUpReg::~midw_ext_tcufi_tclMsgTime_LimitRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTime_LimitGet::midw_ext_tcufi_tclMsgTime_LimitGet()
 {}

tS32 midw_ext_tcufi_tclMsgTime_LimitGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TIME_LIMITGET;
}


midw_ext_tcufi_tclMsgTime_LimitGet::~midw_ext_tcufi_tclMsgTime_LimitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgTime_LimitStatus::midw_ext_tcufi_tclMsgTime_LimitStatus(const midw_ext_tcufi_tclMsgTime_LimitStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bValid = coRef.bValid;
   rTime_Slot = coRef.rTime_Slot;
}
midw_ext_tcufi_tclMsgTime_LimitStatus& midw_ext_tcufi_tclMsgTime_LimitStatus::operator=(const midw_ext_tcufi_tclMsgTime_LimitStatus& coRef)
{
   if (this == &coRef) return *this;
   bValid = coRef.bValid;
   rTime_Slot = coRef.rTime_Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgTime_LimitStatus::midw_ext_tcufi_tclMsgTime_LimitStatus()
:bValid(0)
,rTime_Slot()
 {}

tS32 midw_ext_tcufi_tclMsgTime_LimitStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TIME_LIMITSTATUS;
}


midw_ext_tcufi_tclMsgTime_LimitStatus::~midw_ext_tcufi_tclMsgTime_LimitStatus()
{}

tU32 midw_ext_tcufi_tclMsgTime_LimitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& midw_ext_tcufi_tclMsgTime_LimitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bValid);
   (tVoid) (oIn >> rTime_Slot);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgTime_LimitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bValid);
   (tVoid) (oOut << rTime_Slot);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgTime_LimitStatus::operator==(const midw_ext_tcufi_tclMsgTime_LimitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bValid == roRef.bValid);
   bResult = bResult && (rTime_Slot == roRef.rTime_Slot);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgSpeed_LimitUpReg::midw_ext_tcufi_tclMsgSpeed_LimitUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSpeed_LimitUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SPEED_LIMITUPREG;
}


midw_ext_tcufi_tclMsgSpeed_LimitUpReg::~midw_ext_tcufi_tclMsgSpeed_LimitUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSpeed_LimitRelUpReg::midw_ext_tcufi_tclMsgSpeed_LimitRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgSpeed_LimitRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SPEED_LIMITRELUPREG;
}


midw_ext_tcufi_tclMsgSpeed_LimitRelUpReg::~midw_ext_tcufi_tclMsgSpeed_LimitRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgSpeed_LimitGet::midw_ext_tcufi_tclMsgSpeed_LimitGet()
 {}

tS32 midw_ext_tcufi_tclMsgSpeed_LimitGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SPEED_LIMITGET;
}


midw_ext_tcufi_tclMsgSpeed_LimitGet::~midw_ext_tcufi_tclMsgSpeed_LimitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgSpeed_LimitStatus::midw_ext_tcufi_tclMsgSpeed_LimitStatus(const midw_ext_tcufi_tclMsgSpeed_LimitStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bValid = coRef.bValid;
   u16Limited_Vehicle_Speed = coRef.u16Limited_Vehicle_Speed;
   rTime_Slot = coRef.rTime_Slot;
}
midw_ext_tcufi_tclMsgSpeed_LimitStatus& midw_ext_tcufi_tclMsgSpeed_LimitStatus::operator=(const midw_ext_tcufi_tclMsgSpeed_LimitStatus& coRef)
{
   if (this == &coRef) return *this;
   bValid = coRef.bValid;
   u16Limited_Vehicle_Speed = coRef.u16Limited_Vehicle_Speed;
   rTime_Slot = coRef.rTime_Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgSpeed_LimitStatus::midw_ext_tcufi_tclMsgSpeed_LimitStatus()
:bValid(0)
,u16Limited_Vehicle_Speed(0)
,rTime_Slot()
 {}

tS32 midw_ext_tcufi_tclMsgSpeed_LimitStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_SPEED_LIMITSTATUS;
}


midw_ext_tcufi_tclMsgSpeed_LimitStatus::~midw_ext_tcufi_tclMsgSpeed_LimitStatus()
{}

tU32 midw_ext_tcufi_tclMsgSpeed_LimitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

fi_tclInContext& midw_ext_tcufi_tclMsgSpeed_LimitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bValid);
   (tVoid) (oIn >> u16Limited_Vehicle_Speed);
   (tVoid) (oIn >> rTime_Slot);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgSpeed_LimitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bValid);
   (tVoid) (oOut << u16Limited_Vehicle_Speed);
   (tVoid) (oOut << rTime_Slot);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgSpeed_LimitStatus::operator==(const midw_ext_tcufi_tclMsgSpeed_LimitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bValid == roRef.bValid);
   bResult = bResult && (u16Limited_Vehicle_Speed == roRef.u16Limited_Vehicle_Speed);
   bResult = bResult && (rTime_Slot == roRef.rTime_Slot);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgArea_LimitUpReg::midw_ext_tcufi_tclMsgArea_LimitUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgArea_LimitUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_AREA_LIMITUPREG;
}


midw_ext_tcufi_tclMsgArea_LimitUpReg::~midw_ext_tcufi_tclMsgArea_LimitUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgArea_LimitRelUpReg::midw_ext_tcufi_tclMsgArea_LimitRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgArea_LimitRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_AREA_LIMITRELUPREG;
}


midw_ext_tcufi_tclMsgArea_LimitRelUpReg::~midw_ext_tcufi_tclMsgArea_LimitRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgArea_LimitGet::midw_ext_tcufi_tclMsgArea_LimitGet()
 {}

tS32 midw_ext_tcufi_tclMsgArea_LimitGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_AREA_LIMITGET;
}


midw_ext_tcufi_tclMsgArea_LimitGet::~midw_ext_tcufi_tclMsgArea_LimitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgArea_LimitStatus::midw_ext_tcufi_tclMsgArea_LimitStatus(const midw_ext_tcufi_tclMsgArea_LimitStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bValid = coRef.bValid;
   rArea_Limit_Coordinates = coRef.rArea_Limit_Coordinates;
   rTime_Slot = coRef.rTime_Slot;
}
midw_ext_tcufi_tclMsgArea_LimitStatus& midw_ext_tcufi_tclMsgArea_LimitStatus::operator=(const midw_ext_tcufi_tclMsgArea_LimitStatus& coRef)
{
   if (this == &coRef) return *this;
   bValid = coRef.bValid;
   rArea_Limit_Coordinates = coRef.rArea_Limit_Coordinates;
   rTime_Slot = coRef.rTime_Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgArea_LimitStatus::midw_ext_tcufi_tclMsgArea_LimitStatus()
:bValid(0)
,rArea_Limit_Coordinates()
,rTime_Slot()
 {}

tS32 midw_ext_tcufi_tclMsgArea_LimitStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_AREA_LIMITSTATUS;
}


midw_ext_tcufi_tclMsgArea_LimitStatus::~midw_ext_tcufi_tclMsgArea_LimitStatus()
{}

tU32 midw_ext_tcufi_tclMsgArea_LimitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 45;
}

fi_tclInContext& midw_ext_tcufi_tclMsgArea_LimitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bValid);
   (tVoid) (oIn >> rArea_Limit_Coordinates);
   (tVoid) (oIn >> rTime_Slot);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgArea_LimitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bValid);
   (tVoid) (oOut << rArea_Limit_Coordinates);
   (tVoid) (oOut << rTime_Slot);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgArea_LimitStatus::operator==(const midw_ext_tcufi_tclMsgArea_LimitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bValid == roRef.bValid);
   bResult = bResult && (rArea_Limit_Coordinates == roRef.rArea_Limit_Coordinates);
   bResult = bResult && (rTime_Slot == roRef.rTime_Slot);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgGeofencing_ActivationUpReg::midw_ext_tcufi_tclMsgGeofencing_ActivationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgGeofencing_ActivationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GEOFENCING_ACTIVATIONUPREG;
}


midw_ext_tcufi_tclMsgGeofencing_ActivationUpReg::~midw_ext_tcufi_tclMsgGeofencing_ActivationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGeofencing_ActivationRelUpReg::midw_ext_tcufi_tclMsgGeofencing_ActivationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgGeofencing_ActivationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GEOFENCING_ACTIVATIONRELUPREG;
}


midw_ext_tcufi_tclMsgGeofencing_ActivationRelUpReg::~midw_ext_tcufi_tclMsgGeofencing_ActivationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgGeofencing_ActivationGet::midw_ext_tcufi_tclMsgGeofencing_ActivationGet()
 {}

tS32 midw_ext_tcufi_tclMsgGeofencing_ActivationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GEOFENCING_ACTIVATIONGET;
}


midw_ext_tcufi_tclMsgGeofencing_ActivationGet::~midw_ext_tcufi_tclMsgGeofencing_ActivationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgGeofencing_ActivationStatus::midw_ext_tcufi_tclMsgGeofencing_ActivationStatus(const midw_ext_tcufi_tclMsgGeofencing_ActivationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bValid = coRef.bValid;
   u8Geofencing_Activation_State  = coRef.u8Geofencing_Activation_State ;
}
midw_ext_tcufi_tclMsgGeofencing_ActivationStatus& midw_ext_tcufi_tclMsgGeofencing_ActivationStatus::operator=(const midw_ext_tcufi_tclMsgGeofencing_ActivationStatus& coRef)
{
   if (this == &coRef) return *this;
   bValid = coRef.bValid;
   u8Geofencing_Activation_State  = coRef.u8Geofencing_Activation_State ;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgGeofencing_ActivationStatus::midw_ext_tcufi_tclMsgGeofencing_ActivationStatus()
:bValid(0)
,u8Geofencing_Activation_State (0)
 {}

tS32 midw_ext_tcufi_tclMsgGeofencing_ActivationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_GEOFENCING_ACTIVATIONSTATUS;
}


midw_ext_tcufi_tclMsgGeofencing_ActivationStatus::~midw_ext_tcufi_tclMsgGeofencing_ActivationStatus()
{}

tU32 midw_ext_tcufi_tclMsgGeofencing_ActivationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgGeofencing_ActivationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bValid);
   (tVoid) (oIn >> u8Geofencing_Activation_State );
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgGeofencing_ActivationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bValid);
   (tVoid) (oOut << u8Geofencing_Activation_State );
   return oOut;
}

tBool midw_ext_tcufi_tclMsgGeofencing_ActivationStatus::operator==(const midw_ext_tcufi_tclMsgGeofencing_ActivationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bValid == roRef.bValid);
   bResult = bResult && (u8Geofencing_Activation_State  == roRef.u8Geofencing_Activation_State );
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgRestriction_SettingsUpReg::midw_ext_tcufi_tclMsgRestriction_SettingsUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgRestriction_SettingsUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_RESTRICTION_SETTINGSUPREG;
}


midw_ext_tcufi_tclMsgRestriction_SettingsUpReg::~midw_ext_tcufi_tclMsgRestriction_SettingsUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgRestriction_SettingsRelUpReg::midw_ext_tcufi_tclMsgRestriction_SettingsRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgRestriction_SettingsRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_RESTRICTION_SETTINGSRELUPREG;
}


midw_ext_tcufi_tclMsgRestriction_SettingsRelUpReg::~midw_ext_tcufi_tclMsgRestriction_SettingsRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgRestriction_SettingsGet::midw_ext_tcufi_tclMsgRestriction_SettingsGet()
 {}

tS32 midw_ext_tcufi_tclMsgRestriction_SettingsGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_RESTRICTION_SETTINGSGET;
}


midw_ext_tcufi_tclMsgRestriction_SettingsGet::~midw_ext_tcufi_tclMsgRestriction_SettingsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgRestriction_SettingsStatus::midw_ext_tcufi_tclMsgRestriction_SettingsStatus(const midw_ext_tcufi_tclMsgRestriction_SettingsStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bValid = coRef.bValid;
   rTime_Limit_Restriction = coRef.rTime_Limit_Restriction;
   rSpeed_Limit_Restriction = coRef.rSpeed_Limit_Restriction;
   rArea_Limit_Restriction = coRef.rArea_Limit_Restriction;
}
midw_ext_tcufi_tclMsgRestriction_SettingsStatus& midw_ext_tcufi_tclMsgRestriction_SettingsStatus::operator=(const midw_ext_tcufi_tclMsgRestriction_SettingsStatus& coRef)
{
   if (this == &coRef) return *this;
   bValid = coRef.bValid;
   rTime_Limit_Restriction = coRef.rTime_Limit_Restriction;
   rSpeed_Limit_Restriction = coRef.rSpeed_Limit_Restriction;
   rArea_Limit_Restriction = coRef.rArea_Limit_Restriction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_tcufi_tclMsgRestriction_SettingsStatus::vDestroy()
{
   rTime_Limit_Restriction.vDestroy(); 
   rSpeed_Limit_Restriction.vDestroy(); 
   rArea_Limit_Restriction.vDestroy(); 
}

midw_ext_tcufi_tclMsgRestriction_SettingsStatus::midw_ext_tcufi_tclMsgRestriction_SettingsStatus()
:bValid(0)
,rTime_Limit_Restriction()
,rSpeed_Limit_Restriction()
,rArea_Limit_Restriction()
 {}

tS32 midw_ext_tcufi_tclMsgRestriction_SettingsStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_RESTRICTION_SETTINGSSTATUS;
}


midw_ext_tcufi_tclMsgRestriction_SettingsStatus::~midw_ext_tcufi_tclMsgRestriction_SettingsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_tcufi_tclMsgRestriction_SettingsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+rTime_Limit_Restriction.u32GetSize(u16MajorVersion)+rSpeed_Limit_Restriction.u32GetSize(u16MajorVersion)+rArea_Limit_Restriction.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_tcufi_tclMsgRestriction_SettingsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bValid);
   (tVoid) (oIn >> rTime_Limit_Restriction);
   (tVoid) (oIn >> rSpeed_Limit_Restriction);
   (tVoid) (oIn >> rArea_Limit_Restriction);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgRestriction_SettingsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bValid);
   (tVoid) (oOut << rTime_Limit_Restriction);
   (tVoid) (oOut << rSpeed_Limit_Restriction);
   (tVoid) (oOut << rArea_Limit_Restriction);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgRestriction_SettingsStatus::operator==(const midw_ext_tcufi_tclMsgRestriction_SettingsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bValid == roRef.bValid);
   bResult = bResult && (rTime_Limit_Restriction == roRef.rTime_Limit_Restriction);
   bResult = bResult && (rSpeed_Limit_Restriction == roRef.rSpeed_Limit_Restriction);
   bResult = bResult && (rArea_Limit_Restriction == roRef.rArea_Limit_Restriction);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgConnection_Setup_StatusUpReg::midw_ext_tcufi_tclMsgConnection_Setup_StatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgConnection_Setup_StatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONNECTION_SETUP_STATUSUPREG;
}


midw_ext_tcufi_tclMsgConnection_Setup_StatusUpReg::~midw_ext_tcufi_tclMsgConnection_Setup_StatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgConnection_Setup_StatusRelUpReg::midw_ext_tcufi_tclMsgConnection_Setup_StatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgConnection_Setup_StatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONNECTION_SETUP_STATUSRELUPREG;
}


midw_ext_tcufi_tclMsgConnection_Setup_StatusRelUpReg::~midw_ext_tcufi_tclMsgConnection_Setup_StatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgConnection_Setup_StatusGet::midw_ext_tcufi_tclMsgConnection_Setup_StatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgConnection_Setup_StatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONNECTION_SETUP_STATUSGET;
}


midw_ext_tcufi_tclMsgConnection_Setup_StatusGet::~midw_ext_tcufi_tclMsgConnection_Setup_StatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus::midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus(const midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8ConnectionType = coRef.e8ConnectionType;
}
midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus& midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus::operator=(const midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ConnectionType = coRef.e8ConnectionType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus::midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus()
:e8ConnectionType()
 {}

tS32 midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CONNECTION_SETUP_STATUSSTATUS;
}


midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus::~midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConnectionType);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConnectionType);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus::operator==(const midw_ext_tcufi_tclMsgConnection_Setup_StatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConnectionType == roRef.e8ConnectionType);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgXCallStatusUpReg::midw_ext_tcufi_tclMsgXCallStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgXCallStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATUSUPREG;
}


midw_ext_tcufi_tclMsgXCallStatusUpReg::~midw_ext_tcufi_tclMsgXCallStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgXCallStatusRelUpReg::midw_ext_tcufi_tclMsgXCallStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgXCallStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgXCallStatusRelUpReg::~midw_ext_tcufi_tclMsgXCallStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgXCallStatusGet::midw_ext_tcufi_tclMsgXCallStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgXCallStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATUSGET;
}


midw_ext_tcufi_tclMsgXCallStatusGet::~midw_ext_tcufi_tclMsgXCallStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgXCallStatusStatus::midw_ext_tcufi_tclMsgXCallStatusStatus(const midw_ext_tcufi_tclMsgXCallStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8InvalidParameter = coRef.e8InvalidParameter;
}
midw_ext_tcufi_tclMsgXCallStatusStatus& midw_ext_tcufi_tclMsgXCallStatusStatus::operator=(const midw_ext_tcufi_tclMsgXCallStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8InvalidParameter = coRef.e8InvalidParameter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgXCallStatusStatus::midw_ext_tcufi_tclMsgXCallStatusStatus()
:e8InvalidParameter()
 {}

tS32 midw_ext_tcufi_tclMsgXCallStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgXCallStatusStatus::~midw_ext_tcufi_tclMsgXCallStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgXCallStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgXCallStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8InvalidParameter);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgXCallStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8InvalidParameter);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgXCallStatusStatus::operator==(const midw_ext_tcufi_tclMsgXCallStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8InvalidParameter == roRef.e8InvalidParameter);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgXCallStateUpReg::midw_ext_tcufi_tclMsgXCallStateUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgXCallStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATEUPREG;
}


midw_ext_tcufi_tclMsgXCallStateUpReg::~midw_ext_tcufi_tclMsgXCallStateUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgXCallStateRelUpReg::midw_ext_tcufi_tclMsgXCallStateRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgXCallStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATERELUPREG;
}


midw_ext_tcufi_tclMsgXCallStateRelUpReg::~midw_ext_tcufi_tclMsgXCallStateRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgXCallStateGet::midw_ext_tcufi_tclMsgXCallStateGet()
 {}

tS32 midw_ext_tcufi_tclMsgXCallStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATEGET;
}


midw_ext_tcufi_tclMsgXCallStateGet::~midw_ext_tcufi_tclMsgXCallStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgXCallStateStatus::midw_ext_tcufi_tclMsgXCallStateStatus(const midw_ext_tcufi_tclMsgXCallStateStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   e8XCallState = coRef.e8XCallState;
}
midw_ext_tcufi_tclMsgXCallStateStatus& midw_ext_tcufi_tclMsgXCallStateStatus::operator=(const midw_ext_tcufi_tclMsgXCallStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8XCallState = coRef.e8XCallState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgXCallStateStatus::midw_ext_tcufi_tclMsgXCallStateStatus()
:e8XCallState()
 {}

tS32 midw_ext_tcufi_tclMsgXCallStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLSTATESTATUS;
}


midw_ext_tcufi_tclMsgXCallStateStatus::~midw_ext_tcufi_tclMsgXCallStateStatus()
{}

tU32 midw_ext_tcufi_tclMsgXCallStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_tcufi_tclMsgXCallStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8XCallState);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgXCallStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8XCallState);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgXCallStateStatus::operator==(const midw_ext_tcufi_tclMsgXCallStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8XCallState == roRef.e8XCallState);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgXCallEndUpReg::midw_ext_tcufi_tclMsgXCallEndUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgXCallEndUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLENDUPREG;
}


midw_ext_tcufi_tclMsgXCallEndUpReg::~midw_ext_tcufi_tclMsgXCallEndUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgXCallEndRelUpReg::midw_ext_tcufi_tclMsgXCallEndRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgXCallEndRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLENDRELUPREG;
}


midw_ext_tcufi_tclMsgXCallEndRelUpReg::~midw_ext_tcufi_tclMsgXCallEndRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgXCallEndGet::midw_ext_tcufi_tclMsgXCallEndGet()
 {}

tS32 midw_ext_tcufi_tclMsgXCallEndGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLENDGET;
}


midw_ext_tcufi_tclMsgXCallEndGet::~midw_ext_tcufi_tclMsgXCallEndGet()
{}

//=============================================================================

midw_ext_tcufi_tclMsgXCallEndStatus::midw_ext_tcufi_tclMsgXCallEndStatus()
 {}

tS32 midw_ext_tcufi_tclMsgXCallEndStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_XCALLENDSTATUS;
}


midw_ext_tcufi_tclMsgXCallEndStatus::~midw_ext_tcufi_tclMsgXCallEndStatus()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCallDuartionUpReg::midw_ext_tcufi_tclMsgCallDuartionUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCallDuartionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CALLDUARTIONUPREG;
}


midw_ext_tcufi_tclMsgCallDuartionUpReg::~midw_ext_tcufi_tclMsgCallDuartionUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCallDuartionRelUpReg::midw_ext_tcufi_tclMsgCallDuartionRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgCallDuartionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CALLDUARTIONRELUPREG;
}


midw_ext_tcufi_tclMsgCallDuartionRelUpReg::~midw_ext_tcufi_tclMsgCallDuartionRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgCallDuartionGet::midw_ext_tcufi_tclMsgCallDuartionGet()
 {}

tS32 midw_ext_tcufi_tclMsgCallDuartionGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CALLDUARTIONGET;
}


midw_ext_tcufi_tclMsgCallDuartionGet::~midw_ext_tcufi_tclMsgCallDuartionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgCallDuartionStatus::midw_ext_tcufi_tclMsgCallDuartionStatus(const midw_ext_tcufi_tclMsgCallDuartionStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bIsValid = coRef.bIsValid;
   rCallType = coRef.rCallType;
   rCallDuartion = coRef.rCallDuartion;
}
midw_ext_tcufi_tclMsgCallDuartionStatus& midw_ext_tcufi_tclMsgCallDuartionStatus::operator=(const midw_ext_tcufi_tclMsgCallDuartionStatus& coRef)
{
   if (this == &coRef) return *this;
   bIsValid = coRef.bIsValid;
   rCallType = coRef.rCallType;
   rCallDuartion = coRef.rCallDuartion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgCallDuartionStatus::midw_ext_tcufi_tclMsgCallDuartionStatus()
:bIsValid(0)
,rCallType()
,rCallDuartion()
 {}

tS32 midw_ext_tcufi_tclMsgCallDuartionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_CALLDUARTIONSTATUS;
}


midw_ext_tcufi_tclMsgCallDuartionStatus::~midw_ext_tcufi_tclMsgCallDuartionStatus()
{}

tU32 midw_ext_tcufi_tclMsgCallDuartionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_tcufi_tclMsgCallDuartionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bIsValid);
   (tVoid) (oIn >> rCallType);
   (tVoid) (oIn >> rCallDuartion);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgCallDuartionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bIsValid);
   (tVoid) (oOut << rCallType);
   (tVoid) (oOut << rCallDuartion);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgCallDuartionStatus::operator==(const midw_ext_tcufi_tclMsgCallDuartionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bIsValid == roRef.bIsValid);
   bResult = bResult && (rCallType == roRef.rCallType);
   bResult = bResult && (rCallDuartion == roRef.rCallDuartion);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgPrivacyModeActivationUpReg::midw_ext_tcufi_tclMsgPrivacyModeActivationUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgPrivacyModeActivationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PRIVACYMODEACTIVATIONUPREG;
}


midw_ext_tcufi_tclMsgPrivacyModeActivationUpReg::~midw_ext_tcufi_tclMsgPrivacyModeActivationUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgPrivacyModeActivationRelUpReg::midw_ext_tcufi_tclMsgPrivacyModeActivationRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgPrivacyModeActivationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PRIVACYMODEACTIVATIONRELUPREG;
}


midw_ext_tcufi_tclMsgPrivacyModeActivationRelUpReg::~midw_ext_tcufi_tclMsgPrivacyModeActivationRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgPrivacyModeActivationGet::midw_ext_tcufi_tclMsgPrivacyModeActivationGet()
 {}

tS32 midw_ext_tcufi_tclMsgPrivacyModeActivationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PRIVACYMODEACTIVATIONGET;
}


midw_ext_tcufi_tclMsgPrivacyModeActivationGet::~midw_ext_tcufi_tclMsgPrivacyModeActivationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgPrivacyModeActivationStatus::midw_ext_tcufi_tclMsgPrivacyModeActivationStatus(const midw_ext_tcufi_tclMsgPrivacyModeActivationStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   bIsValid = coRef.bIsValid;
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8PrivacyMode = coRef.e8PrivacyMode;
}
midw_ext_tcufi_tclMsgPrivacyModeActivationStatus& midw_ext_tcufi_tclMsgPrivacyModeActivationStatus::operator=(const midw_ext_tcufi_tclMsgPrivacyModeActivationStatus& coRef)
{
   if (this == &coRef) return *this;
   bIsValid = coRef.bIsValid;
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8PrivacyMode = coRef.e8PrivacyMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgPrivacyModeActivationStatus::midw_ext_tcufi_tclMsgPrivacyModeActivationStatus()
:bIsValid(0)
,e8InvalidParameter()
,e8PrivacyMode()
 {}

tS32 midw_ext_tcufi_tclMsgPrivacyModeActivationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_PRIVACYMODEACTIVATIONSTATUS;
}


midw_ext_tcufi_tclMsgPrivacyModeActivationStatus::~midw_ext_tcufi_tclMsgPrivacyModeActivationStatus()
{}

tU32 midw_ext_tcufi_tclMsgPrivacyModeActivationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_tcufi_tclMsgPrivacyModeActivationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bIsValid);
   (tVoid) (oIn >> e8InvalidParameter);
   (tVoid) (oIn >> e8PrivacyMode);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgPrivacyModeActivationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bIsValid);
   (tVoid) (oOut << e8InvalidParameter);
   (tVoid) (oOut << e8PrivacyMode);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgPrivacyModeActivationStatus::operator==(const midw_ext_tcufi_tclMsgPrivacyModeActivationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bIsValid == roRef.bIsValid);
   bResult = bResult && (e8InvalidParameter == roRef.e8InvalidParameter);
   bResult = bResult && (e8PrivacyMode == roRef.e8PrivacyMode);
   return bResult;
}

//=============================================================================

midw_ext_tcufi_tclMsgTCUConfigurationStatusUpReg::midw_ext_tcufi_tclMsgTCUConfigurationStatusUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTCUConfigurationStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUCONFIGURATIONSTATUSUPREG;
}


midw_ext_tcufi_tclMsgTCUConfigurationStatusUpReg::~midw_ext_tcufi_tclMsgTCUConfigurationStatusUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTCUConfigurationStatusRelUpReg::midw_ext_tcufi_tclMsgTCUConfigurationStatusRelUpReg()
 {}

tS32 midw_ext_tcufi_tclMsgTCUConfigurationStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUCONFIGURATIONSTATUSRELUPREG;
}


midw_ext_tcufi_tclMsgTCUConfigurationStatusRelUpReg::~midw_ext_tcufi_tclMsgTCUConfigurationStatusRelUpReg()
{}

//=============================================================================

midw_ext_tcufi_tclMsgTCUConfigurationStatusGet::midw_ext_tcufi_tclMsgTCUConfigurationStatusGet()
 {}

tS32 midw_ext_tcufi_tclMsgTCUConfigurationStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUCONFIGURATIONSTATUSGET;
}


midw_ext_tcufi_tclMsgTCUConfigurationStatusGet::~midw_ext_tcufi_tclMsgTCUConfigurationStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus::midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus(const midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus& coRef)
   : midw_ext_tcufi_tclMsgBaseMessage(coRef)
{
   rTCU_CurrentAvailabilityConfiguration = coRef.rTCU_CurrentAvailabilityConfiguration;
   bAutoConfigured = coRef.bAutoConfigured;
}
midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus& midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus::operator=(const midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   rTCU_CurrentAvailabilityConfiguration = coRef.rTCU_CurrentAvailabilityConfiguration;
   bAutoConfigured = coRef.bAutoConfigured;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus::midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus()
:rTCU_CurrentAvailabilityConfiguration()
,bAutoConfigured(0)
 {}

tS32 midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_tcufi_tclToken::EN_MSG_TCUCONFIGURATIONSTATUSSTATUS;
}


midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus::~midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus()
{}

tU32 midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rTCU_CurrentAvailabilityConfiguration);
   (tVoid) (oIn >> bAutoConfigured);
   return oIn;
}

fi_tclOutContext& midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rTCU_CurrentAvailabilityConfiguration);
   (tVoid) (oOut << bAutoConfigured);
   return oOut;
}

tBool midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus::operator==(const midw_ext_tcufi_tclMsgTCUConfigurationStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rTCU_CurrentAvailabilityConfiguration == roRef.rTCU_CurrentAvailabilityConfiguration);
   bResult = bResult && (bAutoConfigured == roRef.bAutoConfigured);
   return bResult;
}

