/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_TABWEATHERFITYPES_HEADER
#define MIDW_EXT_SXM_TABWEATHERFITYPES_HEADER


class midw_ext_sxm_tabweatherfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_TABWEATHER_FI message types

fi_tclMessageBase* midw_ext_sxm_tabweatherfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_tabweatherfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_tabweatherfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart& operator=(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListId;
   midw_ext_fi_tcl_e8_SxmListOperation Operation;
   midw_ext_fi_tcl_SxmLocation Location;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult& operator=(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListId;
   midw_ext_fi_tcl_e8_SxmListOperation Operation;
   midw_ext_fi_tcl_SxmListInfo ListInfo;
   midw_ext_fi_tcl_WeatherInfoList TabWeatherInfo;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart& operator=(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmLocation Location;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult& operator=(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_WeatherInfoList TabWeatherInfo;
   tBool FavStatus;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart& operator=(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TabWeather_LOCID;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult& operator=(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool FavStatus;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart& operator=(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TabWeather_LOCID;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult& operator=(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_WeatherInfoList TabWeatherInfo;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart& operator=(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListsConfig Config;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult& operator=(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusGet : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusGet();

   virtual ~midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusGet();

   inline tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus& operator=(const midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus(const midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListInfos TabweatherListStatus;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusUpReg : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusUpReg();

   virtual ~midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusRelUpReg : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusRelUpReg();

   virtual ~midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusGet : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusGet();

   virtual ~midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusGet();

   inline tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus& operator=(const midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmDataSrvState DataServiceState;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusUpReg : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusUpReg();

   virtual ~midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusRelUpReg : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusRelUpReg();

   virtual ~midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet& operator=(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus : public midw_ext_sxm_tabweatherfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus& operator=(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus& coRef);
   midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
