/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_TABWEATHERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_TABWEATHERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_TABWEATHERFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_TABWEATHER_FI message types

fi_tclMessageBase* midw_ext_sxm_tabweatherfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_GETTABWEATHERINFOLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_GETTABWEATHERINFOLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_GETFAVORITEINFOMETHODSTART:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_GETFAVORITEINFOMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_TABWEATHERINFOLISTSTATUSGET:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusGet;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_TABWEATHERINFOLISTSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_TABWEATHERINFOLISTSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusUpReg;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_TABWEATHERINFOLISTSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusRelUpReg;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusGet;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusUpReg;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusRelUpReg;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMLISTMODESET:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet;

      case midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMLISTMODESTATUS:
         return OSAL_NEW midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_tabweatherfifi messages

// common functions

tU16 midw_ext_sxm_tabweatherfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_TABWEATHERFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_tabweatherfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_tabweatherfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_tabweatherfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_tabweatherfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_tabweatherfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart::midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   ListId = coRef.ListId;
   Operation = coRef.Operation;
   Location = coRef.Location;
}
midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart& midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart::operator=(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListId = coRef.ListId;
   Operation = coRef.Operation;
   Location = coRef.Location;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart::midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart()
:ListId(0)
,Operation()
,Location()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_GETTABWEATHERINFOLISTMETHODSTART;
}


midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart::~midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart()
{}

tU32 midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListId);
   (tVoid) (oIn >> Operation);
   (tVoid) (oIn >> Location);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListId);
   (tVoid) (oOut << Operation);
   (tVoid) (oOut << Location);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart::operator==(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListId == roRef.ListId);
   bResult = bResult && (Operation == roRef.Operation);
   bResult = bResult && (Location == roRef.Location);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult::midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   ListId = coRef.ListId;
   Operation = coRef.Operation;
   ListInfo = coRef.ListInfo;
   TabWeatherInfo = coRef.TabWeatherInfo;
}
midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult& midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult::operator=(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListId = coRef.ListId;
   Operation = coRef.Operation;
   ListInfo = coRef.ListInfo;
   TabWeatherInfo = coRef.TabWeatherInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult::vDestroy()
{
   ListInfo.vDestroy(); 
   TabWeatherInfo.vDestroy(); 
}

midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult::midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult()
:ListId(0)
,Operation()
,ListInfo()
,TabWeatherInfo()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_GETTABWEATHERINFOLISTMETHODRESULT;
}


midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult::~midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 18+TabWeatherInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListId);
   (tVoid) (oIn >> Operation);
   (tVoid) (oIn >> ListInfo);
   (tVoid) (oIn >> TabWeatherInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListId);
   (tVoid) (oOut << Operation);
   (tVoid) (oOut << ListInfo);
   (tVoid) (oOut << TabWeatherInfo);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult::operator==(const midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListId == roRef.ListId);
   bResult = bResult && (Operation == roRef.Operation);
   bResult = bResult && (ListInfo == roRef.ListInfo);
   bResult = bResult && (TabWeatherInfo == roRef.TabWeatherInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   Location = coRef.Location;
}
midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart& midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart::operator=(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Location = coRef.Location;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart()
:Location()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART;
}


midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart::~midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart()
{}

tU32 midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Location);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Location);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart::operator==(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Location == roRef.Location);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   TabWeatherInfo = coRef.TabWeatherInfo;
   FavStatus = coRef.FavStatus;
}
midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult& midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult::operator=(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TabWeatherInfo = coRef.TabWeatherInfo;
   FavStatus = coRef.FavStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult::vDestroy()
{
   TabWeatherInfo.vDestroy(); 
}

midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult()
:TabWeatherInfo()
,FavStatus(0)
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT;
}


midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult::~midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+TabWeatherInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TabWeatherInfo);
   (tVoid) (oIn >> FavStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TabWeatherInfo);
   (tVoid) (oOut << FavStatus);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult::operator==(const midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TabWeatherInfo == roRef.TabWeatherInfo);
   bResult = bResult && (FavStatus == roRef.FavStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   TabWeather_LOCID = coRef.TabWeather_LOCID;
}
midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart& midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart::operator=(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TabWeather_LOCID = coRef.TabWeather_LOCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart()
:TabWeather_LOCID(0)
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART;
}


midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart::~midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart()
{}

tU32 midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TabWeather_LOCID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TabWeather_LOCID);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart::operator==(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TabWeather_LOCID == roRef.TabWeather_LOCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   FavStatus = coRef.FavStatus;
}
midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult& midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult::operator=(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FavStatus = coRef.FavStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult()
:FavStatus(0)
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT;
}


midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult::~midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult()
{}

tU32 midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FavStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FavStatus);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult::operator==(const midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FavStatus == roRef.FavStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart::midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   TabWeather_LOCID = coRef.TabWeather_LOCID;
}
midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart& midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart::operator=(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TabWeather_LOCID = coRef.TabWeather_LOCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart::midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart()
:TabWeather_LOCID(0)
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_GETFAVORITEINFOMETHODSTART;
}


midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart::~midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart()
{}

tU32 midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TabWeather_LOCID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TabWeather_LOCID);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart::operator==(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TabWeather_LOCID == roRef.TabWeather_LOCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult::midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   TabWeatherInfo = coRef.TabWeatherInfo;
}
midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult& midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult::operator=(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TabWeatherInfo = coRef.TabWeatherInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult::vDestroy()
{
   TabWeatherInfo.vDestroy(); 
}

midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult::midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult()
:TabWeatherInfo()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_GETFAVORITEINFOMETHODRESULT;
}


midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult::~midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TabWeatherInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TabWeatherInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TabWeatherInfo);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult::operator==(const midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TabWeatherInfo == roRef.TabWeatherInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   Config = coRef.Config;
}
midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart& midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart::operator=(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Config = coRef.Config;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart()
:Config()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART;
}


midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart::~midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart()
{}

tU32 midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Config);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Config);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart::operator==(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Config == roRef.Config);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult& midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult::operator=(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT;
}


midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult::~midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult()
{}

tU32 midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult::operator==(const midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusGet::midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusGet()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_TABWEATHERINFOLISTSTATUSGET;
}


midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusGet::~midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus::midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus(const midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   TabweatherListStatus = coRef.TabweatherListStatus;
}
midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus& midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus::operator=(const midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   TabweatherListStatus = coRef.TabweatherListStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus::vDestroy()
{
   TabweatherListStatus.vDestroy(); 
}

midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus::midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus()
:TabweatherListStatus()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_TABWEATHERINFOLISTSTATUSSTATUS;
}


midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus::~midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TabweatherListStatus.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TabweatherListStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TabweatherListStatus);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus::operator==(const midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TabweatherListStatus == roRef.TabweatherListStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusUpReg::midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusUpReg()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_TABWEATHERINFOLISTSTATUSUPREG;
}


midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusUpReg::~midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusRelUpReg::midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusRelUpReg()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_TABWEATHERINFOLISTSTATUSRELUPREG;
}


midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusRelUpReg::~midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusGet::midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusGet()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET;
}


midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusGet::~midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   DataServiceState = coRef.DataServiceState;
}
midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus& midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus::operator=(const midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DataServiceState = coRef.DataServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus()
:DataServiceState()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS;
}


midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus::~midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus()
{}

tU32 midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataServiceState);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus::operator==(const midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataServiceState == roRef.DataServiceState);
   return bResult;
}

//=============================================================================

midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusUpReg::midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusUpReg()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG;
}


midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusUpReg::~midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusRelUpReg::midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG;
}


midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusRelUpReg::~midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet::midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet& midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet::operator=(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet::midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet()
:ListMode()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMLISTMODESET;
}


midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet::~midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet()
{}

tU32 midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet::operator==(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus::midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus& coRef)
   : midw_ext_sxm_tabweatherfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus& midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus::operator=(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus::midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus()
:ListMode()
 {}

tS32 midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_tabweatherfi_tclToken::EN_MSG_SXMLISTMODESTATUS;
}


midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus::~midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus()
{}

tU32 midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus::operator==(const midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

