/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_STOCKSFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_STOCKSFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_STOCKSFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_STOCKS_FI message types

fi_tclMessageBase* midw_ext_sxm_stocksfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETFAVORITESTOCKSYMBOLSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETFAVORITESTOCKSYMBOLSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETSTOCKSYMBOLSBYFILTERMETHODSTART:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETSTOCKSYMBOLSBYFILTERMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETDATAPROVIDERINFOMETHODSTART:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodStart;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETDATAPROVIDERINFOMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETSTOCKSYMBOLSBYFILTERPSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETSTOCKSYMBOLSBYFILTERPSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_CLEARALLFAVORITESMETHODSTART:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodStart;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_CLEARALLFAVORITESMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodResult;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_STOCKSTATUSGET:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgStockStatusGet;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_STOCKSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgStockStatusStatus;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_STOCKSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgStockStatusUpReg;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_STOCKSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgStockStatusRelUpReg;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusGet;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusUpReg;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusRelUpReg;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMLISTMODESET:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSxmListModeSet;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMLISTMODESTATUS:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMSTOCKSDATAPROVIDERINFOSTATUSGET:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusGet;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMSTOCKSDATAPROVIDERINFOSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMSTOCKSDATAPROVIDERINFOSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusUpReg;

      case midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMSTOCKSDATAPROVIDERINFOSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusRelUpReg;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_stocksfifi messages

// common functions

tU16 midw_ext_sxm_stocksfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_STOCKSFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_stocksfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_stocksfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_stocksfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_stocksfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_stocksfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart::midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   Operation = coRef.Operation;
}
midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart& midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart::operator=(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart::midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart()
:ListID(0)
,Operation()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETFAVORITESTOCKSYMBOLSMETHODSTART;
}


midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart::~midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart()
{}

tU32 midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Operation);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Operation);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart::operator==(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Operation == roRef.Operation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult::midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   ListInfo = coRef.ListInfo;
   StocksQuoteList = coRef.StocksQuoteList;
}
midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult& midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult::operator=(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   ListInfo = coRef.ListInfo;
   StocksQuoteList = coRef.StocksQuoteList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult::vDestroy()
{
   ListInfo.vDestroy(); 
   StocksQuoteList.vDestroy(); 
}

midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult::midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult()
:ListID(0)
,Operation()
,ListInfo()
,StocksQuoteList()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETFAVORITESTOCKSYMBOLSMETHODRESULT;
}


midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult::~midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 18+StocksQuoteList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Operation);
   (tVoid) (oIn >> ListInfo);
   (tVoid) (oIn >> StocksQuoteList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Operation);
   (tVoid) (oOut << ListInfo);
   (tVoid) (oOut << StocksQuoteList);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult::operator==(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Operation == roRef.Operation);
   bResult = bResult && (ListInfo == roRef.ListInfo);
   bResult = bResult && (StocksQuoteList == roRef.StocksQuoteList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   StockSymbol = coRef.StockSymbol;
}
midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart& midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart::operator=(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StockSymbol = coRef.StockSymbol;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart::vDestroy()
{
   StockSymbol.vDestroy();
}

midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart()
:StockSymbol()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART;
}


midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart::~midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+StockSymbol.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StockSymbol);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StockSymbol);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart::operator==(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StockSymbol == roRef.StockSymbol);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult& midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult::operator=(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT;
}


midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult::~midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult()
{}

tU32 midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult::operator==(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   StockSymbol = coRef.StockSymbol;
}
midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart& midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart::operator=(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StockSymbol = coRef.StockSymbol;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart::vDestroy()
{
   StockSymbol.vDestroy();
}

midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart()
:StockSymbol()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART;
}


midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart::~midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+StockSymbol.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StockSymbol);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StockSymbol);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart::operator==(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StockSymbol == roRef.StockSymbol);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult& midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult::operator=(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT;
}


midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult::~midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult()
{}

tU32 midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult::operator==(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart::midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   StockFilter = coRef.StockFilter;
}
midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart::operator=(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StockFilter = coRef.StockFilter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart::vDestroy()
{
   StockFilter.vDestroy();
}

midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart::midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart()
:StockFilter()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETSTOCKSYMBOLSBYFILTERMETHODSTART;
}


midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart::~midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+StockFilter.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StockFilter);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StockFilter);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart::operator==(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StockFilter == roRef.StockFilter);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult::midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   StockFilterList = coRef.StockFilterList;
}
midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult::operator=(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StockFilterList = coRef.StockFilterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult::vDestroy()
{
   StockFilterList.vDestroy(); 
}

midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult::midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult()
:StockFilterList()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETSTOCKSYMBOLSBYFILTERMETHODRESULT;
}


midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult::~midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+StockFilterList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StockFilterList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StockFilterList);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult::operator==(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StockFilterList == roRef.StockFilterList);
   return bResult;
}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodStart::midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodStart()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETDATAPROVIDERINFOMETHODSTART;
}


midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodStart::~midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult::midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult(const midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   DataProviderInfo = coRef.DataProviderInfo;
}
midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult& midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult::operator=(const midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DataProviderInfo = coRef.DataProviderInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult::vDestroy()
{
   DataProviderInfo.vDestroy();
}

midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult::midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult()
:DataProviderInfo()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETDATAPROVIDERINFOMETHODRESULT;
}


midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult::~midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DataProviderInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataProviderInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataProviderInfo);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult::operator==(const midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataProviderInfo == roRef.DataProviderInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   Config = coRef.Config;
}
midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart& midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart::operator=(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Config = coRef.Config;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart()
:Config()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART;
}


midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart::~midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart()
{}

tU32 midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Config);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Config);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart::operator==(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Config == roRef.Config);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult& midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult::operator=(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT;
}


midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult::~midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult()
{}

tU32 midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult::operator==(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart::midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   StockFilter = coRef.StockFilter;
   IsBackSpace = coRef.IsBackSpace;
}
midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart::operator=(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StockFilter = coRef.StockFilter;
   IsBackSpace = coRef.IsBackSpace;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart::vDestroy()
{
   StockFilter.vDestroy();
}

midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart::midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart()
:StockFilter()
,IsBackSpace(0)
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETSTOCKSYMBOLSBYFILTERPSMETHODSTART;
}


midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart::~midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+StockFilter.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StockFilter);
   (tVoid) (oIn >> IsBackSpace);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StockFilter);
   (tVoid) (oOut << IsBackSpace);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart::operator==(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StockFilter == roRef.StockFilter);
   bResult = bResult && (IsBackSpace == roRef.IsBackSpace);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult::midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   StockFilterList = coRef.StockFilterList;
   AllCharsToEnable = coRef.AllCharsToEnable;
   DisplayString = coRef.DisplayString;
   Count = coRef.Count;
}
midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult::operator=(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StockFilterList = coRef.StockFilterList;
   AllCharsToEnable = coRef.AllCharsToEnable;
   DisplayString = coRef.DisplayString;
   Count = coRef.Count;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult::vDestroy()
{
   StockFilterList.vDestroy(); 
   AllCharsToEnable.vDestroy();
   DisplayString.vDestroy();
}

midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult::midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult()
:StockFilterList()
,AllCharsToEnable()
,DisplayString()
,Count(0)
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_GETSTOCKSYMBOLSBYFILTERPSMETHODRESULT;
}


midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult::~midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+StockFilterList.u32GetSize(u16MajorVersion)+AllCharsToEnable.u32GetSize(u16MajorVersion)+DisplayString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StockFilterList);
   (tVoid) (oIn >> AllCharsToEnable);
   (tVoid) (oIn >> DisplayString);
   (tVoid) (oIn >> Count);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StockFilterList);
   (tVoid) (oOut << AllCharsToEnable);
   (tVoid) (oOut << DisplayString);
   (tVoid) (oOut << Count);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult::operator==(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StockFilterList == roRef.StockFilterList);
   bResult = bResult && (AllCharsToEnable == roRef.AllCharsToEnable);
   bResult = bResult && (DisplayString == roRef.DisplayString);
   bResult = bResult && (Count == roRef.Count);
   return bResult;
}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodStart::midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodStart()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_CLEARALLFAVORITESMETHODSTART;
}


midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodStart::~midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodStart()
{}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodResult::midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodResult()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_CLEARALLFAVORITESMETHODRESULT;
}


midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodResult::~midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodResult()
{}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgStockStatusGet::midw_ext_sxm_stocksfi_tclMsgStockStatusGet()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgStockStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_STOCKSTATUSGET;
}


midw_ext_sxm_stocksfi_tclMsgStockStatusGet::~midw_ext_sxm_stocksfi_tclMsgStockStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgStockStatusStatus::midw_ext_sxm_stocksfi_tclMsgStockStatusStatus(const midw_ext_sxm_stocksfi_tclMsgStockStatusStatus& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   StockStatus = coRef.StockStatus;
}
midw_ext_sxm_stocksfi_tclMsgStockStatusStatus& midw_ext_sxm_stocksfi_tclMsgStockStatusStatus::operator=(const midw_ext_sxm_stocksfi_tclMsgStockStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   StockStatus = coRef.StockStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_stocksfi_tclMsgStockStatusStatus::vDestroy()
{
   StockStatus.vDestroy(); 
}

midw_ext_sxm_stocksfi_tclMsgStockStatusStatus::midw_ext_sxm_stocksfi_tclMsgStockStatusStatus()
:StockStatus()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgStockStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_STOCKSTATUSSTATUS;
}


midw_ext_sxm_stocksfi_tclMsgStockStatusStatus::~midw_ext_sxm_stocksfi_tclMsgStockStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_stocksfi_tclMsgStockStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+StockStatus.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgStockStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StockStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgStockStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StockStatus);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgStockStatusStatus::operator==(const midw_ext_sxm_stocksfi_tclMsgStockStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StockStatus == roRef.StockStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgStockStatusUpReg::midw_ext_sxm_stocksfi_tclMsgStockStatusUpReg()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgStockStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_STOCKSTATUSUPREG;
}


midw_ext_sxm_stocksfi_tclMsgStockStatusUpReg::~midw_ext_sxm_stocksfi_tclMsgStockStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgStockStatusRelUpReg::midw_ext_sxm_stocksfi_tclMsgStockStatusRelUpReg()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgStockStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_STOCKSTATUSRELUPREG;
}


midw_ext_sxm_stocksfi_tclMsgStockStatusRelUpReg::~midw_ext_sxm_stocksfi_tclMsgStockStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusGet::midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusGet()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET;
}


midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusGet::~midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   DataServiceState = coRef.DataServiceState;
}
midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus& midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus::operator=(const midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DataServiceState = coRef.DataServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus()
:DataServiceState()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS;
}


midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus::~midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus()
{}

tU32 midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataServiceState);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus::operator==(const midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataServiceState == roRef.DataServiceState);
   return bResult;
}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusUpReg::midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusUpReg()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG;
}


midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusUpReg::~midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusRelUpReg::midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG;
}


midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusRelUpReg::~midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgSxmListModeSet::midw_ext_sxm_stocksfi_tclMsgSxmListModeSet(const midw_ext_sxm_stocksfi_tclMsgSxmListModeSet& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_stocksfi_tclMsgSxmListModeSet& midw_ext_sxm_stocksfi_tclMsgSxmListModeSet::operator=(const midw_ext_sxm_stocksfi_tclMsgSxmListModeSet& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_stocksfi_tclMsgSxmListModeSet::midw_ext_sxm_stocksfi_tclMsgSxmListModeSet()
:ListMode()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSxmListModeSet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMLISTMODESET;
}


midw_ext_sxm_stocksfi_tclMsgSxmListModeSet::~midw_ext_sxm_stocksfi_tclMsgSxmListModeSet()
{}

tU32 midw_ext_sxm_stocksfi_tclMsgSxmListModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgSxmListModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgSxmListModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgSxmListModeSet::operator==(const midw_ext_sxm_stocksfi_tclMsgSxmListModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus::midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus(const midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus& midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus::operator=(const midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus::midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus()
:ListMode()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMLISTMODESTATUS;
}


midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus::~midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus()
{}

tU32 midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus::operator==(const midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusGet::midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusGet()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMSTOCKSDATAPROVIDERINFOSTATUSGET;
}


midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusGet::~midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus::midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus(const midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus& coRef)
   : midw_ext_sxm_stocksfi_tclMsgBaseMessage(coRef)
{
   DataProviderInfoStatus = coRef.DataProviderInfoStatus;
}
midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus& midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus::operator=(const midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DataProviderInfoStatus = coRef.DataProviderInfoStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus::midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus()
:DataProviderInfoStatus(0)
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMSTOCKSDATAPROVIDERINFOSTATUSSTATUS;
}


midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus::~midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus()
{}

tU32 midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataProviderInfoStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataProviderInfoStatus);
   return oOut;
}

tBool midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus::operator==(const midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataProviderInfoStatus == roRef.DataProviderInfoStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusUpReg::midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusUpReg()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMSTOCKSDATAPROVIDERINFOSTATUSUPREG;
}


midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusUpReg::~midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusRelUpReg::midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusRelUpReg()
 {}

tS32 midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_stocksfi_tclToken::EN_MSG_SXMSTOCKSDATAPROVIDERINFOSTATUSRELUPREG;
}


midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusRelUpReg::~midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusRelUpReg()
{}

