/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_SPORTSFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_SPORTSFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_SPORTSFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_SPORTS_FI message types

fi_tclMessageBase* midw_ext_sxm_sportsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSPORTLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetSportListMethodStart;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSPORTLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETROOTAFFILIATELISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETROOTAFFILIATELISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETAFFILIATEDETAILSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETAFFILIATEDETAILSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETGAMELISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETGAMELISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETNEWSDETAILSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETNEWSDETAILSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETTOPTEAMSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETTOPTEAMSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETALLTEAMSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETALLTEAMSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETFAVORITESMETHODSTART:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodStart;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETFAVORITESMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SETASFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SETASFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSCHEDULEDEVENTSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSCHEDULEDEVENTSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETEVENTRANKLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETEVENTRANKLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSGET:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusGet;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusUpReg;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusRelUpReg;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATEGET:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateGet;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATESTATUS:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATEUPREG:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateUpReg;

      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATERELUPREG:
         return OSAL_NEW midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateRelUpReg;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_sportsfifi messages

// common functions

tU16 midw_ext_sxm_sportsfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_SPORTSFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_sportsfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_sportsfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_sportsfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_sportsfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_sportsfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

midw_ext_sxm_sportsfi_tclMsgGetSportListMethodStart::midw_ext_sxm_sportsfi_tclMsgGetSportListMethodStart()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetSportListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSPORTLISTMETHODSTART;
}


midw_ext_sxm_sportsfi_tclMsgGetSportListMethodStart::~midw_ext_sxm_sportsfi_tclMsgGetSportListMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult::midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   SportList = coRef.SportList;
}
midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult& midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult::operator=(const midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SportList = coRef.SportList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult::vDestroy()
{
   SportList.vDestroy(); 
}

midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult::midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult()
:SportList()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSPORTLISTMETHODRESULT;
}


midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult::~midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+SportList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportList);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult::operator==(const midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportList == roRef.SportList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart::midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   SportID = coRef.SportID;
}
midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart& midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart::operator=(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SportID = coRef.SportID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart::midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart()
:SportID(0)
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETROOTAFFILIATELISTMETHODSTART;
}


midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart::~midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportID);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart::operator==(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportID == roRef.SportID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult::midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   RootAffiliateList = coRef.RootAffiliateList;
}
midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult& midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult::operator=(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RootAffiliateList = coRef.RootAffiliateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult::vDestroy()
{
   RootAffiliateList.vDestroy(); 
}

midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult::midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult()
:RootAffiliateList()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETROOTAFFILIATELISTMETHODRESULT;
}


midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult::~midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+RootAffiliateList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RootAffiliateList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RootAffiliateList);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult::operator==(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RootAffiliateList == roRef.RootAffiliateList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart::midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   SportID = coRef.SportID;
}
midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart& midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart::operator=(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   SportID = coRef.SportID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart::midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart()
:AFFILIATE_ID(0)
,SportID(0)
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETAFFILIATEDETAILSMETHODSTART;
}


midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart::~midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AFFILIATE_ID);
   (tVoid) (oIn >> SportID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AFFILIATE_ID);
   (tVoid) (oOut << SportID);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart::operator==(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AFFILIATE_ID == roRef.AFFILIATE_ID);
   bResult = bResult && (SportID == roRef.SportID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult::midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   AffiliateDetails = coRef.AffiliateDetails;
}
midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult& midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult::operator=(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AffiliateDetails = coRef.AffiliateDetails;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult::vDestroy()
{
   AffiliateDetails.vDestroy(); 
}

midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult::midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult()
:AffiliateDetails()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETAFFILIATEDETAILSMETHODRESULT;
}


midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult::~midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AffiliateDetails.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AffiliateDetails);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AffiliateDetails);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult::operator==(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AffiliateDetails == roRef.AffiliateDetails);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart::midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   SportID = coRef.SportID;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   TEAM_ID = coRef.TEAM_ID;
   GameType = coRef.GameType;
   Game_ID = coRef.Game_ID;
}
midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart& midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart::operator=(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SportID = coRef.SportID;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   TEAM_ID = coRef.TEAM_ID;
   GameType = coRef.GameType;
   Game_ID = coRef.Game_ID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart::midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart()
:SportID(0)
,AFFILIATE_ID(0)
,TEAM_ID(0)
,GameType()
,Game_ID(0)
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETGAMELISTMETHODSTART;
}


midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart::~midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportID);
   (tVoid) (oIn >> AFFILIATE_ID);
   (tVoid) (oIn >> TEAM_ID);
   (tVoid) (oIn >> GameType);
   (tVoid) (oIn >> Game_ID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportID);
   (tVoid) (oOut << AFFILIATE_ID);
   (tVoid) (oOut << TEAM_ID);
   (tVoid) (oOut << GameType);
   (tVoid) (oOut << Game_ID);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart::operator==(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportID == roRef.SportID);
   bResult = bResult && (AFFILIATE_ID == roRef.AFFILIATE_ID);
   bResult = bResult && (TEAM_ID == roRef.TEAM_ID);
   bResult = bResult && (GameType == roRef.GameType);
   bResult = bResult && (Game_ID == roRef.Game_ID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult::midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   GameList = coRef.GameList;
}
midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult& midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult::operator=(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   GameList = coRef.GameList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult::vDestroy()
{
   GameList.vDestroy(); 
}

midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult::midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult()
:GameList()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETGAMELISTMETHODRESULT;
}


midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult::~midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+GameList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GameList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GameList);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult::operator==(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GameList == roRef.GameList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart::midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   SportID = coRef.SportID;
}
midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart& midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart::operator=(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   SportID = coRef.SportID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart::midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart()
:AFFILIATE_ID(0)
,SportID(0)
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETNEWSDETAILSMETHODSTART;
}


midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart::~midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AFFILIATE_ID);
   (tVoid) (oIn >> SportID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AFFILIATE_ID);
   (tVoid) (oOut << SportID);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart::operator==(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AFFILIATE_ID == roRef.AFFILIATE_ID);
   bResult = bResult && (SportID == roRef.SportID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult::midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   News = coRef.News;
}
midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult& midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult::operator=(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   News = coRef.News;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult::vDestroy()
{
   News.vDestroy(); 
}

midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult::midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult()
:News()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETNEWSDETAILSMETHODRESULT;
}


midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult::~midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+News.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> News);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << News);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult::operator==(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (News == roRef.News);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart::midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   SportID = coRef.SportID;
}
midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart& midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart::operator=(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   SportID = coRef.SportID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart::midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart()
:AFFILIATE_ID(0)
,SportID(0)
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETTOPTEAMSMETHODSTART;
}


midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart::~midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AFFILIATE_ID);
   (tVoid) (oIn >> SportID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AFFILIATE_ID);
   (tVoid) (oOut << SportID);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart::operator==(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AFFILIATE_ID == roRef.AFFILIATE_ID);
   bResult = bResult && (SportID == roRef.SportID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult::midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   TeamList = coRef.TeamList;
}
midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult& midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult::operator=(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TeamList = coRef.TeamList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult::vDestroy()
{
   TeamList.vDestroy(); 
}

midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult::midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult()
:TeamList()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETTOPTEAMSMETHODRESULT;
}


midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult::~midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TeamList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TeamList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TeamList);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult::operator==(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TeamList == roRef.TeamList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart::midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   SportID = coRef.SportID;
}
midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart& midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart::operator=(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   SportID = coRef.SportID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart::midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart()
:AFFILIATE_ID(0)
,SportID(0)
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETALLTEAMSMETHODSTART;
}


midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart::~midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AFFILIATE_ID);
   (tVoid) (oIn >> SportID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AFFILIATE_ID);
   (tVoid) (oOut << SportID);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart::operator==(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AFFILIATE_ID == roRef.AFFILIATE_ID);
   bResult = bResult && (SportID == roRef.SportID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult::midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   AllTeamList = coRef.AllTeamList;
}
midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult& midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult::operator=(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AllTeamList = coRef.AllTeamList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult::vDestroy()
{
   AllTeamList.vDestroy(); 
}

midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult::midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult()
:AllTeamList()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETALLTEAMSMETHODRESULT;
}


midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult::~midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AllTeamList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AllTeamList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AllTeamList);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult::operator==(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AllTeamList == roRef.AllTeamList);
   return bResult;
}

//=============================================================================

midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodStart::midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodStart()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETFAVORITESMETHODSTART;
}


midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodStart::~midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult::midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   FavoriteList = coRef.FavoriteList;
}
midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult& midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult::operator=(const midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FavoriteList = coRef.FavoriteList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult::vDestroy()
{
   FavoriteList.vDestroy(); 
}

midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult::midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult()
:FavoriteList()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETFAVORITESMETHODRESULT;
}


midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult::~midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+FavoriteList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FavoriteList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FavoriteList);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult::operator==(const midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FavoriteList == roRef.FavoriteList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart::midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   SportID = coRef.SportID;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   TEAM_ID = coRef.TEAM_ID;
   FavoriteControl = coRef.FavoriteControl;
}
midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart& midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart::operator=(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SportID = coRef.SportID;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   TEAM_ID = coRef.TEAM_ID;
   FavoriteControl = coRef.FavoriteControl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart::midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart()
:SportID(0)
,AFFILIATE_ID(0)
,TEAM_ID(0)
,FavoriteControl(0)
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_SETASFAVORITEMETHODSTART;
}


midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart::~midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportID);
   (tVoid) (oIn >> AFFILIATE_ID);
   (tVoid) (oIn >> TEAM_ID);
   (tVoid) (oIn >> FavoriteControl);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportID);
   (tVoid) (oOut << AFFILIATE_ID);
   (tVoid) (oOut << TEAM_ID);
   (tVoid) (oOut << FavoriteControl);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart::operator==(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportID == roRef.SportID);
   bResult = bResult && (AFFILIATE_ID == roRef.AFFILIATE_ID);
   bResult = bResult && (TEAM_ID == roRef.TEAM_ID);
   bResult = bResult && (FavoriteControl == roRef.FavoriteControl);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult::midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
   FavoriteControl = coRef.FavoriteControl;
}
midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult& midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult::operator=(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   FavoriteControl = coRef.FavoriteControl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult::midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult()
:Result(0)
,FavoriteControl(0)
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_SETASFAVORITEMETHODRESULT;
}


midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult::~midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   (tVoid) (oIn >> FavoriteControl);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   (tVoid) (oOut << FavoriteControl);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult::operator==(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   bResult = bResult && (FavoriteControl == roRef.FavoriteControl);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart::midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   SportID = coRef.SportID;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   EventType = coRef.EventType;
   Event_ID = coRef.Event_ID;
}
midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart& midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart::operator=(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SportID = coRef.SportID;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   EventType = coRef.EventType;
   Event_ID = coRef.Event_ID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart::midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart()
:SportID(0)
,AFFILIATE_ID(0)
,EventType()
,Event_ID(0)
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSCHEDULEDEVENTSMETHODSTART;
}


midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart::~midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportID);
   (tVoid) (oIn >> AFFILIATE_ID);
   (tVoid) (oIn >> EventType);
   (tVoid) (oIn >> Event_ID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportID);
   (tVoid) (oOut << AFFILIATE_ID);
   (tVoid) (oOut << EventType);
   (tVoid) (oOut << Event_ID);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart::operator==(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportID == roRef.SportID);
   bResult = bResult && (AFFILIATE_ID == roRef.AFFILIATE_ID);
   bResult = bResult && (EventType == roRef.EventType);
   bResult = bResult && (Event_ID == roRef.Event_ID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult::midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   ScheduledEvents = coRef.ScheduledEvents;
}
midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult& midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult::operator=(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ScheduledEvents = coRef.ScheduledEvents;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult::vDestroy()
{
   ScheduledEvents.vDestroy(); 
}

midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult::midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult()
:ScheduledEvents()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSCHEDULEDEVENTSMETHODRESULT;
}


midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult::~midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ScheduledEvents.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ScheduledEvents);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ScheduledEvents);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult::operator==(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ScheduledEvents == roRef.ScheduledEvents);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart::midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   SportID = coRef.SportID;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   EventType = coRef.EventType;
   TableParam = coRef.TableParam;
   TableRef = coRef.TableRef;
}
midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart& midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart::operator=(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SportID = coRef.SportID;
   AFFILIATE_ID = coRef.AFFILIATE_ID;
   EventType = coRef.EventType;
   TableParam = coRef.TableParam;
   TableRef = coRef.TableRef;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart::midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart()
:SportID(0)
,AFFILIATE_ID(0)
,EventType()
,TableParam(0)
,TableRef(0)
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETEVENTRANKLISTMETHODSTART;
}


midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart::~midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportID);
   (tVoid) (oIn >> AFFILIATE_ID);
   (tVoid) (oIn >> EventType);
   (tVoid) (oIn >> TableParam);
   (tVoid) (oIn >> TableRef);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportID);
   (tVoid) (oOut << AFFILIATE_ID);
   (tVoid) (oOut << EventType);
   (tVoid) (oOut << TableParam);
   (tVoid) (oOut << TableRef);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart::operator==(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportID == roRef.SportID);
   bResult = bResult && (AFFILIATE_ID == roRef.AFFILIATE_ID);
   bResult = bResult && (EventType == roRef.EventType);
   bResult = bResult && (TableParam == roRef.TableParam);
   bResult = bResult && (TableRef == roRef.TableRef);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult::midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   EventInfo = coRef.EventInfo;
}
midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult& midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult::operator=(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   EventInfo = coRef.EventInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult::vDestroy()
{
   EventInfo.vDestroy(); 
}

midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult::midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult()
:EventInfo()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETEVENTRANKLISTMETHODRESULT;
}


midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult::~midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+EventInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EventInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EventInfo);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult::operator==(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EventInfo == roRef.EventInfo);
   return bResult;
}

//=============================================================================

midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusGet::midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusGet()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSGET;
}


midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusGet::~midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus::midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus(const midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   SportsStatus = coRef.SportsStatus;
}
midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus& midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus::operator=(const midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   SportsStatus = coRef.SportsStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus::midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus()
:SportsStatus()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSSTATUS;
}


midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus::~midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportsStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportsStatus);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus::operator==(const midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportsStatus == roRef.SportsStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusUpReg::midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusUpReg()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSUPREG;
}


midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusUpReg::~midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusRelUpReg::midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusRelUpReg()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSRELUPREG;
}


midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusRelUpReg::~midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateGet::midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateGet()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATEGET;
}


midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateGet::~midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus::midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus(const midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus& coRef)
   : midw_ext_sxm_sportsfi_tclMsgBaseMessage(coRef)
{
   SportID = coRef.SportID;
   LeagueID = coRef.LeagueID;
   UpdateType = coRef.UpdateType;
   UpdateStatus = coRef.UpdateStatus;
}
midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus& midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus::operator=(const midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   SportID = coRef.SportID;
   LeagueID = coRef.LeagueID;
   UpdateType = coRef.UpdateType;
   UpdateStatus = coRef.UpdateStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus::midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus()
:SportID(0)
,LeagueID(0)
,UpdateType()
,UpdateStatus()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATESTATUS;
}


midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus::~midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus()
{}

tU32 midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportID);
   (tVoid) (oIn >> LeagueID);
   (tVoid) (oIn >> UpdateType);
   (tVoid) (oIn >> UpdateStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportID);
   (tVoid) (oOut << LeagueID);
   (tVoid) (oOut << UpdateType);
   (tVoid) (oOut << UpdateStatus);
   return oOut;
}

tBool midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus::operator==(const midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportID == roRef.SportID);
   bResult = bResult && (LeagueID == roRef.LeagueID);
   bResult = bResult && (UpdateType == roRef.UpdateType);
   bResult = bResult && (UpdateStatus == roRef.UpdateStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateUpReg::midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateUpReg()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATEUPREG;
}


midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateUpReg::~midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateUpReg()
{}

//=============================================================================

midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateRelUpReg::midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateRelUpReg()
 {}

tS32 midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATERELUPREG;
}


midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateRelUpReg::~midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateRelUpReg()
{}

