/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_PHONETICSFITYPES_HEADER
#define MIDW_EXT_SXM_PHONETICSFITYPES_HEADER


class midw_ext_sxm_phoneticsfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_PHONETICS_FI message types

fi_tclMessageBase* midw_ext_sxm_phoneticsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_phoneticsfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_phoneticsfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart : public midw_ext_sxm_phoneticsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart& operator=(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart& coRef);
   midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PhoneticsType;
   tU8 LanguageType;
   virtual ~midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult : public midw_ext_sxm_phoneticsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult& operator=(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult& coRef);
   midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PhoneticsType;
   tU8 LanguageType;
   std::vector<midw_ext_fi_tcl_ChannelPhoneticsInfo, std::allocator<midw_ext_fi_tcl_ChannelPhoneticsInfo> > ChannelList;
   std::vector<midw_ext_fi_tcl_CategoryPhoneticsInfo, std::allocator<midw_ext_fi_tcl_CategoryPhoneticsInfo> > CategoryList;
   std::vector<midw_ext_fi_tcl_MarketPhoneticsInfo, std::allocator<midw_ext_fi_tcl_MarketPhoneticsInfo> > MarketList;
   std::vector<midw_ext_fi_tcl_LeaguePhoneticsInfo, std::allocator<midw_ext_fi_tcl_LeaguePhoneticsInfo> > LeagueList;
   std::vector<midw_ext_fi_tcl_TeamPhoneticsInfo, std::allocator<midw_ext_fi_tcl_TeamPhoneticsInfo> > TeamList;
   virtual ~midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateGet : public midw_ext_sxm_phoneticsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateGet();

   virtual ~midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateGet();

   inline tBool operator==(const midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus : public midw_ext_sxm_phoneticsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus& operator=(const midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus& coRef);
   midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus(const midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PhoneticsType;
   tU8 LanguageType;
   virtual ~midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateUpReg : public midw_ext_sxm_phoneticsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateUpReg();

   virtual ~midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateUpReg();

   inline tBool operator==(const midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateRelUpReg : public midw_ext_sxm_phoneticsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateRelUpReg();

   virtual ~midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateRelUpReg();

   inline tBool operator==(const midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
