/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_PHONETICSFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_PHONETICSFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_PHONETICSFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_PHONETICS_FI message types

fi_tclMessageBase* midw_ext_sxm_phoneticsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_GETPHONETICSDATAMETHODSTART:
         return OSAL_NEW midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart;

      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_GETPHONETICSDATAMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult;

      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATEGET:
         return OSAL_NEW midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateGet;

      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATESTATUS:
         return OSAL_NEW midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus;

      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATEUPREG:
         return OSAL_NEW midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateUpReg;

      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATERELUPREG:
         return OSAL_NEW midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateRelUpReg;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_phoneticsfifi messages

// common functions

tU16 midw_ext_sxm_phoneticsfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_PHONETICSFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_phoneticsfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_phoneticsfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_phoneticsfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_phoneticsfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_phoneticsfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_phoneticsfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_phoneticsfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart::midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart& coRef)
   : midw_ext_sxm_phoneticsfi_tclMsgBaseMessage(coRef)
{
   PhoneticsType = coRef.PhoneticsType;
   LanguageType = coRef.LanguageType;
}
midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart& midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart::operator=(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PhoneticsType = coRef.PhoneticsType;
   LanguageType = coRef.LanguageType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart::midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart()
:PhoneticsType(0)
,LanguageType(0)
 {}

tS32 midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_GETPHONETICSDATAMETHODSTART;
}


midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart::~midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart()
{}

tU32 midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneticsType);
   (tVoid) (oIn >> LanguageType);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneticsType);
   (tVoid) (oOut << LanguageType);
   return oOut;
}

tBool midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart::operator==(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneticsType == roRef.PhoneticsType);
   bResult = bResult && (LanguageType == roRef.LanguageType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult::midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult& coRef)
   : midw_ext_sxm_phoneticsfi_tclMsgBaseMessage(coRef)
{
   PhoneticsType = coRef.PhoneticsType;
   LanguageType = coRef.LanguageType;
   ChannelList = coRef.ChannelList;
   CategoryList = coRef.CategoryList;
   MarketList = coRef.MarketList;
   LeagueList = coRef.LeagueList;
   TeamList = coRef.TeamList;
}
midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult& midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult::operator=(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   PhoneticsType = coRef.PhoneticsType;
   LanguageType = coRef.LanguageType;
   ChannelList = coRef.ChannelList;
   CategoryList = coRef.CategoryList;
   MarketList = coRef.MarketList;
   LeagueList = coRef.LeagueList;
   TeamList = coRef.TeamList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
         ChannelList[u32Idx].vDestroy();
   ChannelList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < CategoryList.size(); ++u32Idx)
         CategoryList[u32Idx].vDestroy();
   CategoryList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < MarketList.size(); ++u32Idx)
         MarketList[u32Idx].vDestroy();
   MarketList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < LeagueList.size(); ++u32Idx)
         LeagueList[u32Idx].vDestroy();
   LeagueList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < TeamList.size(); ++u32Idx)
         TeamList[u32Idx].vDestroy();
   TeamList.clear();
   }
}

midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult::midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult()
:PhoneticsType(0)
,LanguageType(0)





 {}

tS32 midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_GETPHONETICSDATAMETHODRESULT;
}


midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult::~midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ChannelList.size(); ++u32ListIdx)
      u32DynamicSize += ChannelList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < CategoryList.size(); ++u32ListIdx)
      u32DynamicSize += CategoryList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < MarketList.size(); ++u32ListIdx)
      u32DynamicSize += MarketList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < LeagueList.size(); ++u32ListIdx)
      u32DynamicSize += LeagueList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < TeamList.size(); ++u32ListIdx)
      u32DynamicSize += TeamList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+22;
}

fi_tclInContext& midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneticsType);
   (tVoid) (oIn >> LanguageType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
      {
         ChannelList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CategoryList.size(); ++u32Idx)
      {
         CategoryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CategoryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CategoryList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MarketList.size(); ++u32Idx)
      {
         MarketList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      MarketList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MarketList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LeagueList.size(); ++u32Idx)
      {
         LeagueList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      LeagueList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> LeagueList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TeamList.size(); ++u32Idx)
      {
         TeamList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TeamList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TeamList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneticsType);
   (tVoid) (oOut << LanguageType);
   (tVoid) (oOut << (tU32)ChannelList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
         (tVoid) (oOut << ChannelList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)CategoryList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CategoryList.size(); ++u32Idx)
         (tVoid) (oOut << CategoryList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)MarketList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MarketList.size(); ++u32Idx)
         (tVoid) (oOut << MarketList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)LeagueList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < LeagueList.size(); ++u32Idx)
         (tVoid) (oOut << LeagueList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)TeamList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TeamList.size(); ++u32Idx)
         (tVoid) (oOut << TeamList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult::operator==(const midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneticsType == roRef.PhoneticsType);
   bResult = bResult && (LanguageType == roRef.LanguageType);
      bResult = bResult && (ChannelList.size() == roRef.ChannelList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelList.size()); ++u32Idx)
            bResult = bResult && (ChannelList[u32Idx] == roRef.ChannelList[u32Idx]);
      }
      bResult = bResult && (CategoryList.size() == roRef.CategoryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CategoryList.size()); ++u32Idx)
            bResult = bResult && (CategoryList[u32Idx] == roRef.CategoryList[u32Idx]);
      }
      bResult = bResult && (MarketList.size() == roRef.MarketList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MarketList.size()); ++u32Idx)
            bResult = bResult && (MarketList[u32Idx] == roRef.MarketList[u32Idx]);
      }
      bResult = bResult && (LeagueList.size() == roRef.LeagueList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LeagueList.size()); ++u32Idx)
            bResult = bResult && (LeagueList[u32Idx] == roRef.LeagueList[u32Idx]);
      }
      bResult = bResult && (TeamList.size() == roRef.TeamList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TeamList.size()); ++u32Idx)
            bResult = bResult && (TeamList[u32Idx] == roRef.TeamList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateGet::midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateGet()
 {}

tS32 midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATEGET;
}


midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateGet::~midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus::midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus(const midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus& coRef)
   : midw_ext_sxm_phoneticsfi_tclMsgBaseMessage(coRef)
{
   PhoneticsType = coRef.PhoneticsType;
   LanguageType = coRef.LanguageType;
}
midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus& midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus::operator=(const midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   PhoneticsType = coRef.PhoneticsType;
   LanguageType = coRef.LanguageType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus::midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus()
:PhoneticsType(0)
,LanguageType(0)
 {}

tS32 midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATESTATUS;
}


midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus::~midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus()
{}

tU32 midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneticsType);
   (tVoid) (oIn >> LanguageType);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneticsType);
   (tVoid) (oOut << LanguageType);
   return oOut;
}

tBool midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus::operator==(const midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneticsType == roRef.PhoneticsType);
   bResult = bResult && (LanguageType == roRef.LanguageType);
   return bResult;
}

//=============================================================================

midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateUpReg::midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateUpReg()
 {}

tS32 midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATEUPREG;
}


midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateUpReg::~midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateUpReg()
{}

//=============================================================================

midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateRelUpReg::midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateRelUpReg()
 {}

tS32 midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATERELUPREG;
}


midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateRelUpReg::~midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateRelUpReg()
{}

