#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_PHONETICSFI_STDVISITORS
#include "midw_ext_fi_gen_if.h"

tBool midw_ext_sxm_phoneticsfi_tclDescription::bInitMessage(midw_ext_sxm_phoneticsfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_ext_sxm_phoneticsfi_tclToken::EN_LAST_TOKEN:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_LIST:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_END_OF_STRUCT:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_GETPHONETICSDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U8,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_MSG_LANGUAGETYPE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U8,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_MSG_PHONETICSTYPE)) && bResult;
   } break;
   case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_GETPHONETICSDATAMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_TEAMPHONETICSINFO,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_MSG_TEAMLIST)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LEAGUEPHONETICSINFO,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_MSG_LEAGUELIST)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_MARKETPHONETICSINFO,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_MSG_MARKETLIST)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_CATEGORYPHONETICSINFO,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_MSG_CATEGORYLIST)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_CHANNELPHONETICSINFO,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_MSG_CHANNELLIST)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U8,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_MSG_LANGUAGETYPE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U8,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_MSG_PHONETICSTYPE)) && bResult;
   } break;
   case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATESTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U8,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_MSG_LANGUAGETYPE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U8,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_MSG_PHONETICSTYPE)) && bResult;
   } break;
   case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATEGET:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATEUPREG:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATERELUPREG:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_BINCONTAINER:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_CHANNELPHONETICSINFO:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_CATEGORYPHONETICSINFO:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_LEAGUEPHONETICSINFO:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_MARKETPHONETICSINFO:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_TEAMPHONETICSINFO:
   case midw_ext_sxm_phoneticsfi_tclToken::EN_U8:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_S8:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_U16:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_S16:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_U24:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_S24:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_U32:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_S32:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_U64:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_S64:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_F32:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_F64:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_BOOL:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_STRING:   
   case midw_ext_sxm_phoneticsfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(enMsgToken,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_ext_sxm_phoneticsfi_tclDescription::bDoIt(midw_ext_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_ext_sxm_phoneticsfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_ext_sxm_phoneticsfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_ext_sxm_phoneticsfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_ext_sxm_phoneticsfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_ext_sxm_phoneticsfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_LIST: 
      {
         midw_ext_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_sxm_phoneticsfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_sxm_phoneticsfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_U8: 
      {
         midw_ext_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_U16: 
      {
         midw_ext_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_U24: 
      {
         midw_ext_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_U32: 
      {
         midw_ext_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_U64: 
      {
         midw_ext_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_S8: 
      {
         midw_ext_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_S16: 
      {
         midw_ext_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_S24: 
      {
         midw_ext_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_S32: 
      {
         midw_ext_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_S64: 
      {
         midw_ext_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_F32: 
      {
         midw_ext_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_F64: 
      {
         midw_ext_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_BOOL: 
      {
         midw_ext_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_STRING: 
      {
         midw_ext_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_ext_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_GETPHONETICSDATAMETHODSTART:
      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_GETPHONETICSDATAMETHODRESULT:
      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATEGET:
      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATESTATUS:
      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATEUPREG:
      case midw_ext_sxm_phoneticsfi_tclToken::EN_MSG_PHONETICSUPDATERELUPREG:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U8,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_ext_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_CHANNELPHONETICSINFO:
      {
      if (poVisitor->bDoExpand_ChannelPhoneticsInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_STRING,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_PHONETICSDATA));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U32,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         midw_ext_fi_tcl_ChannelPhoneticsInfo o_ChannelPhoneticsInfo;
         if (!bDoIt(o_ChannelPhoneticsInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ChannelPhoneticsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ChannelPhoneticsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_CATEGORYPHONETICSINFO:
      {
      if (poVisitor->bDoExpand_CategoryPhoneticsInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_STRING,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_PHONETICSDATA));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U32,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         midw_ext_fi_tcl_CategoryPhoneticsInfo o_CategoryPhoneticsInfo;
         if (!bDoIt(o_CategoryPhoneticsInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CategoryPhoneticsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CategoryPhoneticsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_LEAGUEPHONETICSINFO:
      {
      if (poVisitor->bDoExpand_LeaguePhoneticsInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_STRING,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_PHONETICSDATA));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U32,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         midw_ext_fi_tcl_LeaguePhoneticsInfo o_LeaguePhoneticsInfo;
         if (!bDoIt(o_LeaguePhoneticsInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LeaguePhoneticsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LeaguePhoneticsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_MARKETPHONETICSINFO:
      {
      if (poVisitor->bDoExpand_MarketPhoneticsInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_STRING,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_PHONETICSDATA));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_STRING,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         midw_ext_fi_tcl_MarketPhoneticsInfo o_MarketPhoneticsInfo;
         if (!bDoIt(o_MarketPhoneticsInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MarketPhoneticsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MarketPhoneticsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_TEAMPHONETICSINFO:
      {
      if (poVisitor->bDoExpand_TeamPhoneticsInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_STRING,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_PHONETICSDATA));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U8,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_LIST,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_LEAGUEID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_phoneticsfi_tclKnot(midw_ext_sxm_phoneticsfi_tclToken::EN_U32,midw_ext_sxm_phoneticsfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         midw_ext_fi_tcl_TeamPhoneticsInfo o_TeamPhoneticsInfo;
         if (!bDoIt(o_TeamPhoneticsInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TeamPhoneticsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TeamPhoneticsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_phoneticsfi_tclToken::EN_UNKNOWN:
      case midw_ext_sxm_phoneticsfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

