/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_FUELFITYPES_HEADER
#define MIDW_EXT_SXM_FUELFITYPES_HEADER


class midw_ext_sxm_fuelfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_FUEL_FI message types

fi_tclMessageBase* midw_ext_sxm_fuelfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_fuelfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_fuelfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart& operator=(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart& coRef);
   midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_e8_SxmListOperation Operation;
   midw_ext_fi_tclString Brand;
   midw_ext_fi_tcl_FuelTypeInfo FuelType;
   midw_ext_fi_tcl_e8_SortType SortType;
   virtual ~midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult& operator=(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult& coRef);
   midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_e8_SxmListOperation Operation;
   midw_ext_fi_tcl_SxmListInfo ListInfo;
   midw_ext_fi_tcl_FuelInfoList FuelInfoList;
   virtual ~midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart& operator=(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart& coRef);
   midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 FUEL_LOCID;
   tU32 ListID;
   virtual ~midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult& operator=(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult& coRef);
   midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_FuelStationInfo FuelStationInfo;
   tU32 ListID;
   virtual ~midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart& operator=(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart& coRef);
   midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 FUEL_LOCID;
   virtual ~midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult& operator=(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult& coRef);
   midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart& operator=(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart& coRef);
   midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 FUEL_LOCID;
   virtual ~midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult& operator=(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult& coRef);
   midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart& operator=(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart& coRef);
   midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListsConfig Config;
   virtual ~midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult& operator=(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult& coRef);
   midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusGet : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusGet();

   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusGet();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus& operator=(const midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus& coRef);
   midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus(const midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListInfos InfoList;
   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusUpReg : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusUpReg();

   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusRelUpReg : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusRelUpReg();

   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListGet : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListGet();

   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListGet();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus& operator=(const midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus& coRef);
   midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus(const midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_BrandNameList BrandName;
   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListUpReg : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListUpReg();

   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListUpReg();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListRelUpReg : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListRelUpReg();

   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListRelUpReg();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelTypeListGet : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelTypeListGet();

   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelTypeListGet();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelTypeListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus& operator=(const midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus& coRef);
   midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus(const midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_FuelTypeList TypeName;
   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelTypeListUpReg : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelTypeListUpReg();

   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelTypeListUpReg();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelTypeListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgFuelTypeListRelUpReg : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgFuelTypeListRelUpReg();

   virtual ~midw_ext_sxm_fuelfi_tclMsgFuelTypeListRelUpReg();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgFuelTypeListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusGet : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusGet();

   virtual ~midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusGet();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus& operator=(const midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus& coRef);
   midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmDataSrvState DataServiceState;
   virtual ~midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusUpReg : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusUpReg();

   virtual ~midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusRelUpReg : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusRelUpReg();

   virtual ~midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgSxmListModeSet : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgSxmListModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgSxmListModeSet& operator=(const midw_ext_sxm_fuelfi_tclMsgSxmListModeSet& coRef);
   midw_ext_sxm_fuelfi_tclMsgSxmListModeSet(const midw_ext_sxm_fuelfi_tclMsgSxmListModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_fuelfi_tclMsgSxmListModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgSxmListModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus : public midw_ext_sxm_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus& operator=(const midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus& coRef);
   midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus(const midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
