/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_FUELFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_FUELFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_FUELFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_FUEL_FI message types

fi_tclMessageBase* midw_ext_sxm_fuelfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELINFOLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELINFOLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELSTATIONINFOMETHODSTART:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELSTATIONINFOMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSGET:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusGet;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusUpReg;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusRelUpReg;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTGET:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListGet;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTSTATUS:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTUPREG:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListUpReg;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTRELUPREG:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListRelUpReg;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTGET:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelTypeListGet;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTSTATUS:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTUPREG:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelTypeListUpReg;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTRELUPREG:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgFuelTypeListRelUpReg;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusGet;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusUpReg;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusRelUpReg;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMLISTMODESET:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgSxmListModeSet;

      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMLISTMODESTATUS:
         return OSAL_NEW midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_fuelfifi messages

// common functions

tU16 midw_ext_sxm_fuelfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_FUELFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_fuelfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_fuelfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_fuelfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_fuelfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_fuelfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart::midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   Brand = coRef.Brand;
   FuelType = coRef.FuelType;
   SortType = coRef.SortType;
}
midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart& midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart::operator=(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   Brand = coRef.Brand;
   FuelType = coRef.FuelType;
   SortType = coRef.SortType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart::vDestroy()
{
   Brand.vDestroy();
   FuelType.vDestroy(); 
}

midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart::midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart()
:ListID(0)
,Operation()
,Brand()
,FuelType()
,SortType()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELINFOLISTMETHODSTART;
}


midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart::~midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+Brand.u32GetSize(u16MajorVersion)+FuelType.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Operation);
   (tVoid) (oIn >> Brand);
   (tVoid) (oIn >> FuelType);
   (tVoid) (oIn >> SortType);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Operation);
   (tVoid) (oOut << Brand);
   (tVoid) (oOut << FuelType);
   (tVoid) (oOut << SortType);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart::operator==(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Operation == roRef.Operation);
   bResult = bResult && (Brand == roRef.Brand);
   bResult = bResult && (FuelType == roRef.FuelType);
   bResult = bResult && (SortType == roRef.SortType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult::midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   ListInfo = coRef.ListInfo;
   FuelInfoList = coRef.FuelInfoList;
}
midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult& midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult::operator=(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   ListInfo = coRef.ListInfo;
   FuelInfoList = coRef.FuelInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult::vDestroy()
{
   ListInfo.vDestroy(); 
   FuelInfoList.vDestroy(); 
}

midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult::midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult()
:ListID(0)
,Operation()
,ListInfo()
,FuelInfoList()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELINFOLISTMETHODRESULT;
}


midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult::~midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 18+FuelInfoList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Operation);
   (tVoid) (oIn >> ListInfo);
   (tVoid) (oIn >> FuelInfoList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Operation);
   (tVoid) (oOut << ListInfo);
   (tVoid) (oOut << FuelInfoList);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult::operator==(const midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Operation == roRef.Operation);
   bResult = bResult && (ListInfo == roRef.ListInfo);
   bResult = bResult && (FuelInfoList == roRef.FuelInfoList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart::midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   FUEL_LOCID = coRef.FUEL_LOCID;
   ListID = coRef.ListID;
}
midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart& midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart::operator=(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FUEL_LOCID = coRef.FUEL_LOCID;
   ListID = coRef.ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart::midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart()
:FUEL_LOCID(0)
,ListID(0)
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELSTATIONINFOMETHODSTART;
}


midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart::~midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart()
{}

tU32 midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FUEL_LOCID);
   (tVoid) (oIn >> ListID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FUEL_LOCID);
   (tVoid) (oOut << ListID);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart::operator==(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FUEL_LOCID == roRef.FUEL_LOCID);
   bResult = bResult && (ListID == roRef.ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult::midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   FuelStationInfo = coRef.FuelStationInfo;
   ListID = coRef.ListID;
}
midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult& midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult::operator=(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FuelStationInfo = coRef.FuelStationInfo;
   ListID = coRef.ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult::vDestroy()
{
   FuelStationInfo.vDestroy(); 
}

midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult::midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult()
:FuelStationInfo()
,ListID(0)
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELSTATIONINFOMETHODRESULT;
}


midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult::~midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+FuelStationInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FuelStationInfo);
   (tVoid) (oIn >> ListID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FuelStationInfo);
   (tVoid) (oOut << ListID);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult::operator==(const midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FuelStationInfo == roRef.FuelStationInfo);
   bResult = bResult && (ListID == roRef.ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   FUEL_LOCID = coRef.FUEL_LOCID;
}
midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart& midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart::operator=(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FUEL_LOCID = coRef.FUEL_LOCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart()
:FUEL_LOCID(0)
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART;
}


midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart::~midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart()
{}

tU32 midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FUEL_LOCID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FUEL_LOCID);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart::operator==(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FUEL_LOCID == roRef.FUEL_LOCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult& midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult::operator=(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT;
}


midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult::~midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult()
{}

tU32 midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult::operator==(const midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   FUEL_LOCID = coRef.FUEL_LOCID;
}
midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart& midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart::operator=(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FUEL_LOCID = coRef.FUEL_LOCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart()
:FUEL_LOCID(0)
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART;
}


midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart::~midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart()
{}

tU32 midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FUEL_LOCID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FUEL_LOCID);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart::operator==(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FUEL_LOCID == roRef.FUEL_LOCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult& midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult::operator=(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT;
}


midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult::~midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult()
{}

tU32 midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult::operator==(const midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   Config = coRef.Config;
}
midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart& midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart::operator=(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Config = coRef.Config;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart()
:Config()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART;
}


midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart::~midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart()
{}

tU32 midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Config);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Config);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart::operator==(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Config == roRef.Config);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult& midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult::operator=(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT;
}


midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult::~midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult()
{}

tU32 midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult::operator==(const midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusGet::midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusGet()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSGET;
}


midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusGet::~midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus::midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus(const midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   InfoList = coRef.InfoList;
}
midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus& midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus::operator=(const midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   InfoList = coRef.InfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus::vDestroy()
{
   InfoList.vDestroy(); 
}

midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus::midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus()
:InfoList()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSSTATUS;
}


midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus::~midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+InfoList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> InfoList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << InfoList);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus::operator==(const midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (InfoList == roRef.InfoList);
   return bResult;
}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusUpReg::midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusUpReg()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSUPREG;
}


midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusUpReg::~midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusRelUpReg::midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusRelUpReg()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSRELUPREG;
}


midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusRelUpReg::~midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListGet::midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListGet()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTGET;
}


midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListGet::~midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus::midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus(const midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   BrandName = coRef.BrandName;
}
midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus& midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus::operator=(const midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus& coRef)
{
   if (this == &coRef) return *this;
   BrandName = coRef.BrandName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus::vDestroy()
{
   BrandName.vDestroy(); 
}

midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus::midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus()
:BrandName()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTSTATUS;
}


midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus::~midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+BrandName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrandName);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrandName);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus::operator==(const midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrandName == roRef.BrandName);
   return bResult;
}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListUpReg::midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListUpReg()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTUPREG;
}


midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListUpReg::~midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListUpReg()
{}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListRelUpReg::midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListRelUpReg()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTRELUPREG;
}


midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListRelUpReg::~midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListRelUpReg()
{}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgFuelTypeListGet::midw_ext_sxm_fuelfi_tclMsgFuelTypeListGet()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelTypeListGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTGET;
}


midw_ext_sxm_fuelfi_tclMsgFuelTypeListGet::~midw_ext_sxm_fuelfi_tclMsgFuelTypeListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus::midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus(const midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   TypeName = coRef.TypeName;
}
midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus& midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus::operator=(const midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus& coRef)
{
   if (this == &coRef) return *this;
   TypeName = coRef.TypeName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus::vDestroy()
{
   TypeName.vDestroy(); 
}

midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus::midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus()
:TypeName()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTSTATUS;
}


midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus::~midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TypeName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TypeName);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TypeName);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus::operator==(const midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TypeName == roRef.TypeName);
   return bResult;
}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgFuelTypeListUpReg::midw_ext_sxm_fuelfi_tclMsgFuelTypeListUpReg()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelTypeListUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTUPREG;
}


midw_ext_sxm_fuelfi_tclMsgFuelTypeListUpReg::~midw_ext_sxm_fuelfi_tclMsgFuelTypeListUpReg()
{}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgFuelTypeListRelUpReg::midw_ext_sxm_fuelfi_tclMsgFuelTypeListRelUpReg()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgFuelTypeListRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTRELUPREG;
}


midw_ext_sxm_fuelfi_tclMsgFuelTypeListRelUpReg::~midw_ext_sxm_fuelfi_tclMsgFuelTypeListRelUpReg()
{}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusGet::midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusGet()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET;
}


midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusGet::~midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   DataServiceState = coRef.DataServiceState;
}
midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus& midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus::operator=(const midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DataServiceState = coRef.DataServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus()
:DataServiceState()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS;
}


midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus::~midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus()
{}

tU32 midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataServiceState);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus::operator==(const midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataServiceState == roRef.DataServiceState);
   return bResult;
}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusUpReg::midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusUpReg()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG;
}


midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusUpReg::~midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusRelUpReg::midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG;
}


midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusRelUpReg::~midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgSxmListModeSet::midw_ext_sxm_fuelfi_tclMsgSxmListModeSet(const midw_ext_sxm_fuelfi_tclMsgSxmListModeSet& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_fuelfi_tclMsgSxmListModeSet& midw_ext_sxm_fuelfi_tclMsgSxmListModeSet::operator=(const midw_ext_sxm_fuelfi_tclMsgSxmListModeSet& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_fuelfi_tclMsgSxmListModeSet::midw_ext_sxm_fuelfi_tclMsgSxmListModeSet()
:ListMode()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgSxmListModeSet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMLISTMODESET;
}


midw_ext_sxm_fuelfi_tclMsgSxmListModeSet::~midw_ext_sxm_fuelfi_tclMsgSxmListModeSet()
{}

tU32 midw_ext_sxm_fuelfi_tclMsgSxmListModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgSxmListModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgSxmListModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgSxmListModeSet::operator==(const midw_ext_sxm_fuelfi_tclMsgSxmListModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus::midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus(const midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus& coRef)
   : midw_ext_sxm_fuelfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus& midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus::operator=(const midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus::midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus()
:ListMode()
 {}

tS32 midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMLISTMODESTATUS;
}


midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus::~midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus()
{}

tU32 midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus::operator==(const midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

