#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_FUELFI_STDVISITORS
#include "midw_ext_fi_gen_if.h"

tBool midw_ext_sxm_fuelfi_tclDescription::bInitMessage(midw_ext_sxm_fuelfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_ext_sxm_fuelfi_tclToken::EN_LAST_TOKEN:
   case midw_ext_sxm_fuelfi_tclToken::EN_LIST:
   case midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT:
   case midw_ext_sxm_fuelfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELINFOLISTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_SORTTYPE,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_SORTTYPE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_FUELTYPEINFO,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_FUELTYPE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_BRAND)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTOPERATION,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_OPERATION)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_LISTID)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELINFOLISTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_FUELINFOLIST,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_FUELINFOLIST)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTINFO,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_LISTINFO)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTOPERATION,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_OPERATION)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_LISTID)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELSTATIONINFOMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_LISTID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_FUEL_LOCID)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELSTATIONINFOMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_LISTID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_FUELSTATIONINFO,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_FUELSTATIONINFO)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_FUEL_LOCID)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_FUEL_LOCID)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTSCONFIG,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_CONFIG)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTINFOS,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_INFOLIST)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_BRANDNAMELIST,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_BRANDNAME)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_FUELTYPELIST,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_TYPENAME)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_SXMDATASRVSTATE,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_DATASERVICESTATE)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMLISTMODESET:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTMODE,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_LISTMODE)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMLISTMODESTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTMODE,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MSG_LISTMODE)) && bResult;
   } break;
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSGET:
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSUPREG:
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSRELUPREG:
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTGET:
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTUPREG:
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTRELUPREG:
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTGET:
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTUPREG:
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTRELUPREG:
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
   case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
   case midw_ext_sxm_fuelfi_tclToken::EN_BINCONTAINER:
   case midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTTYPE:
   case midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTSTATUS:
   case midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTMODE:
   case midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTMODE:
   case midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTOPERATION:
   case midw_ext_sxm_fuelfi_tclToken::EN_SXMLOCATION:
   case midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTINFO:
   case midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTSCONFIG:
   case midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTINFOS:
   case midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMDATASERVICESTATUS:
   case midw_ext_sxm_fuelfi_tclToken::EN_SXMDATASRVSTATE:
   case midw_ext_sxm_fuelfi_tclToken::EN_E8_FUELTYPEENUM:
   case midw_ext_sxm_fuelfi_tclToken::EN_E8_FUELSTATIONAMENITY:
   case midw_ext_sxm_fuelfi_tclToken::EN_E8_SORTTYPE:
   case midw_ext_sxm_fuelfi_tclToken::EN_FUELINFO:
   case midw_ext_sxm_fuelfi_tclToken::EN_FUELTYPEINFO:
   case midw_ext_sxm_fuelfi_tclToken::EN_FUELTYPEINFOLIST:
   case midw_ext_sxm_fuelfi_tclToken::EN_FUELSTATIONINFO:
   case midw_ext_sxm_fuelfi_tclToken::EN_FUELINFOLIST:
   case midw_ext_sxm_fuelfi_tclToken::EN_BRANDNAMELIST:
   case midw_ext_sxm_fuelfi_tclToken::EN_FUELTYPELIST:
   case midw_ext_sxm_fuelfi_tclToken::EN_U8:   
   case midw_ext_sxm_fuelfi_tclToken::EN_S8:   
   case midw_ext_sxm_fuelfi_tclToken::EN_U16:   
   case midw_ext_sxm_fuelfi_tclToken::EN_S16:   
   case midw_ext_sxm_fuelfi_tclToken::EN_U24:   
   case midw_ext_sxm_fuelfi_tclToken::EN_S24:   
   case midw_ext_sxm_fuelfi_tclToken::EN_U32:   
   case midw_ext_sxm_fuelfi_tclToken::EN_S32:   
   case midw_ext_sxm_fuelfi_tclToken::EN_U64:   
   case midw_ext_sxm_fuelfi_tclToken::EN_S64:   
   case midw_ext_sxm_fuelfi_tclToken::EN_F32:   
   case midw_ext_sxm_fuelfi_tclToken::EN_F64:   
   case midw_ext_sxm_fuelfi_tclToken::EN_BOOL:   
   case midw_ext_sxm_fuelfi_tclToken::EN_STRING:   
   case midw_ext_sxm_fuelfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(enMsgToken,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_ext_sxm_fuelfi_tclDescription::bDoIt(midw_ext_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_ext_sxm_fuelfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_ext_sxm_fuelfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_ext_sxm_fuelfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_ext_sxm_fuelfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_ext_sxm_fuelfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_ext_sxm_fuelfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_LIST: 
      {
         midw_ext_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_sxm_fuelfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_sxm_fuelfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_U8: 
      {
         midw_ext_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_U16: 
      {
         midw_ext_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_U24: 
      {
         midw_ext_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_U32: 
      {
         midw_ext_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_U64: 
      {
         midw_ext_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_S8: 
      {
         midw_ext_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_S16: 
      {
         midw_ext_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_S24: 
      {
         midw_ext_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_S32: 
      {
         midw_ext_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_S64: 
      {
         midw_ext_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_F32: 
      {
         midw_ext_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_F64: 
      {
         midw_ext_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_BOOL: 
      {
         midw_ext_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_STRING: 
      {
         midw_ext_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_ext_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELINFOLISTMETHODSTART:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELINFOLISTMETHODRESULT:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELSTATIONINFOMETHODSTART:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_GETFUELSTATIONINFOMETHODRESULT:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSGET:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSSTATUS:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSUPREG:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELINFOLISTSSTATUSRELUPREG:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTGET:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTSTATUS:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTUPREG:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELBRANDNAMELISTRELUPREG:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTGET:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTSTATUS:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTUPREG:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_FUELTYPELISTRELUPREG:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMLISTMODESET:
      case midw_ext_sxm_fuelfi_tclToken::EN_MSG_SXMLISTMODESTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_ext_sxm_fuelfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U8,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_LIST,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_ext_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTTYPE:
      {
         midw_ext_fi_tcl_e8_SxmListType o_e8_SxmListType;
         if (!bDoIt(o_e8_SxmListType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTSTATUS:
      {
         midw_ext_fi_tcl_e8_SxmListStatus o_e8_SxmListStatus;
         if (!bDoIt(o_e8_SxmListStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTMODE:
      {
         midw_ext_fi_tcl_e8_SxmListMode o_e8_SxmListMode;
         if (!bDoIt(o_e8_SxmListMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTMODE:
      {
      if (poVisitor->bDoExpand_SxmListMode(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTMODE,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MODE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LISTID));
      }
      else
      {
         midw_ext_fi_tcl_SxmListMode o_SxmListMode;
         if (!bDoIt(o_SxmListMode))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListMode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListMode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTOPERATION:
      {
         midw_ext_fi_tcl_e8_SxmListOperation o_e8_SxmListOperation;
         if (!bDoIt(o_e8_SxmListOperation))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_SXMLOCATION:
      {
      if (poVisitor->bDoExpand_SxmLocation(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_RADIUS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_S32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LON));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_S32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LAT));
      }
      else
      {
         midw_ext_fi_tcl_SxmLocation o_SxmLocation;
         if (!bDoIt(o_SxmLocation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTINFO:
      {
      if (poVisitor->bDoExpand_SxmListInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_SIZE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_BEMPTY));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTMODE,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_MODE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTSTATUS,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_STATE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTSTATUS,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_STATUS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMLISTTYPE,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LISTTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LISTID));
      }
      else
      {
         midw_ext_fi_tcl_SxmListInfo o_SxmListInfo;
         if (!bDoIt(o_SxmListInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTSCONFIG:
      {
      if (poVisitor->bDoExpand_SxmListsConfig(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_CAPACITY));
      }
      else
      {
         midw_ext_fi_tcl_SxmListsConfig o_SxmListsConfig;
         if (!bDoIt(o_SxmListsConfig))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListsConfig.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListsConfig.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTINFOS:
      {
      if (poVisitor->bDoExpand_SxmListInfos(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTINFO,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_LIST,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LISTINFO));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_SXMLISTSCONFIG,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_GENERICCONFIG));
      }
      else
      {
         midw_ext_fi_tcl_SxmListInfos o_SxmListInfos;
         if (!bDoIt(o_SxmListInfos))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListInfos.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListInfos.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMDATASERVICESTATUS:
      {
         midw_ext_fi_tcl_e8_SxmDataServiceStatus o_e8_SxmDataServiceStatus;
         if (!bDoIt(o_e8_SxmDataServiceStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_SXMDATASRVSTATE:
      {
      if (poVisitor->bDoExpand_SxmDataSrvState(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_SXMDATASERVICESTATUS,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         midw_ext_fi_tcl_SxmDataSrvState o_SxmDataSrvState;
         if (!bDoIt(o_SxmDataSrvState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmDataSrvState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmDataSrvState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_E8_FUELTYPEENUM:
      {
         midw_ext_fi_tcl_e8_FuelTypeEnum o_e8_FuelTypeEnum;
         if (!bDoIt(o_e8_FuelTypeEnum))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_E8_FUELSTATIONAMENITY:
      {
         midw_ext_fi_tcl_e8_FuelStationAmenity o_e8_FuelStationAmenity;
         if (!bDoIt(o_e8_FuelStationAmenity))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_E8_SORTTYPE:
      {
         midw_ext_fi_tcl_e8_SortType o_e8_SortType;
         if (!bDoIt(o_e8_SortType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_FUELINFO:
      {
      if (poVisitor->bDoExpand_FuelInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_NUMPRICES));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_F32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELDISTMILE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_F32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELDISTKM));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_SXMLOCATION,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELLOC));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U8,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELAGE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELPRICE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELNAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUEL_LOCID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_FUELTYPEENUM,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_BRAND));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_STATIONNAME));
      }
      else
      {
         midw_ext_fi_tcl_FuelInfo o_FuelInfo;
         if (!bDoIt(o_FuelInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_FUELTYPEINFO:
      {
      if (poVisitor->bDoExpand_FuelTypeInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELNAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_FUELTYPEENUM,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELTYPE));
      }
      else
      {
         midw_ext_fi_tcl_FuelTypeInfo o_FuelTypeInfo;
         if (!bDoIt(o_FuelTypeInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelTypeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelTypeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_FUELTYPEINFOLIST:
      {
      if (poVisitor->bDoExpand_FuelTypeInfolist(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_FUELTYPEENUM,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELAVAIL));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U8,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELAGE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELPRICE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELNAME));
      }
      else
      {
         midw_ext_fi_tcl_FuelTypeInfolist o_FuelTypeInfolist;
         if (!bDoIt(o_FuelTypeInfolist))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelTypeInfolist.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelTypeInfolist.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_FUELSTATIONINFO:
      {
      if (poVisitor->bDoExpand_FuelStationInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_NUMPRICES));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_E8_FUELSTATIONAMENITY,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_LIST,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_STATIONAMENITYLIST));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_FUELTYPEINFOLIST,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_LIST,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELTYPELIST));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_SXMLOCATION,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELLOCATION));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELFAVINFO));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_AMENITY));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_U32,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUEL_LOCID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_PHONE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_ZIPCODE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_STATE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_CITY));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_STREETNAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_BRAND));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_STATIONNAME));
      }
      else
      {
         midw_ext_fi_tcl_FuelStationInfo o_FuelStationInfo;
         if (!bDoIt(o_FuelStationInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_FUELINFOLIST:
      {
      if (poVisitor->bDoExpand_FuelInfoList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_FUELINFO,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_LIST,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_FUELINFOLIST));
      }
      else
      {
         midw_ext_fi_tcl_FuelInfoList o_FuelInfoList;
         if (!bDoIt(o_FuelInfoList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelInfoList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelInfoList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_BRANDNAMELIST:
      {
      if (poVisitor->bDoExpand_BrandNameList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_STRING,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_LIST,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_BRANDNAMELIST));
      }
      else
      {
         midw_ext_fi_tcl_BrandNameList o_BrandNameList;
         if (!bDoIt(o_BrandNameList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BrandNameList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BrandNameList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_FUELTYPELIST:
      {
      if (poVisitor->bDoExpand_FuelTypeList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_FUELTYPEINFO,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_fuelfi_tclKnot(midw_ext_sxm_fuelfi_tclToken::EN_LIST,midw_ext_sxm_fuelfi_tclSemanticDomain::EN_TYPENAMELIST));
      }
      else
      {
         midw_ext_fi_tcl_FuelTypeList o_FuelTypeList;
         if (!bDoIt(o_FuelTypeList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelTypeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelTypeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_fuelfi_tclToken::EN_UNKNOWN:
      case midw_ext_sxm_fuelfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

