/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_CHANNELARTFITYPES_HEADER
#define MIDW_EXT_SXM_CHANNELARTFITYPES_HEADER


class midw_ext_sxm_channelartfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_CHANNELART_FI message types

fi_tclMessageBase* midw_ext_sxm_channelartfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_channelartfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_channelartfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart : public midw_ext_sxm_channelartfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart& operator=(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart& coRef);
   midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 SID;
   tU8 ChannelGraphicsType;
   virtual ~midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult : public midw_ext_sxm_channelartfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult& operator=(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult& coRef);
   midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ChannelGraphicsType;
   std::vector<tU8, std::allocator<tU8> > u8ImageData;
   std::vector<tU8, std::allocator<tU8> > AlbumImageData;
   tU32 ImageDataSize;
   tU32 AlbumImageSize;
   tU16 SID;
   virtual ~midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart : public midw_ext_sxm_channelartfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart& operator=(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart& coRef);
   midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU16, std::allocator<tU16> > ListOfSID;
   tU8 ChannelGraphicsType;
   virtual ~midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult : public midw_ext_sxm_channelartfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult& operator=(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult& coRef);
   midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ChannelGraphicsType;
   std::vector<midw_ext_fi_tcl_ImageData, std::allocator<midw_ext_fi_tcl_ImageData> > ImageDataList;
   virtual ~midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusGet : public midw_ext_sxm_channelartfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusGet();

   virtual ~midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusGet();

   inline tBool operator==(const midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus : public midw_ext_sxm_channelartfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus& operator=(const midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus& coRef);
   midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmDataSrvState DataServiceState;
   virtual ~midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusUpReg : public midw_ext_sxm_channelartfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusUpReg();

   virtual ~midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusRelUpReg : public midw_ext_sxm_channelartfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusRelUpReg();

   virtual ~midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
