/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_CHANNELARTFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_CHANNELARTFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_CHANNELARTFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_CHANNELART_FI message types

fi_tclMessageBase* midw_ext_sxm_channelartfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_channelartfi_tclToken::EN_MSG_GETCHANNELARTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart;

      case midw_ext_sxm_channelartfi_tclToken::EN_MSG_GETCHANNELARTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult;

      case midw_ext_sxm_channelartfi_tclToken::EN_MSG_GETCHANNELARTLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart;

      case midw_ext_sxm_channelartfi_tclToken::EN_MSG_GETCHANNELARTLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult;

      case midw_ext_sxm_channelartfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
         return OSAL_NEW midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusGet;

      case midw_ext_sxm_channelartfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus;

      case midw_ext_sxm_channelartfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusUpReg;

      case midw_ext_sxm_channelartfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusRelUpReg;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_channelartfifi messages

// common functions

tU16 midw_ext_sxm_channelartfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_CHANNELARTFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_channelartfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_channelartfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_channelartfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_channelartfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_channelartfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_channelartfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_channelartfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart::midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart& coRef)
   : midw_ext_sxm_channelartfi_tclMsgBaseMessage(coRef)
{
   SID = coRef.SID;
   ChannelGraphicsType = coRef.ChannelGraphicsType;
}
midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart& midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart::operator=(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SID = coRef.SID;
   ChannelGraphicsType = coRef.ChannelGraphicsType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart::midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart()
:SID(0)
,ChannelGraphicsType(0)
 {}

tS32 midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_channelartfi_tclToken::EN_MSG_GETCHANNELARTMETHODSTART;
}


midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart::~midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart()
{}

tU32 midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SID);
   (tVoid) (oIn >> ChannelGraphicsType);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SID);
   (tVoid) (oOut << ChannelGraphicsType);
   return oOut;
}

tBool midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart::operator==(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SID == roRef.SID);
   bResult = bResult && (ChannelGraphicsType == roRef.ChannelGraphicsType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult::midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult& coRef)
   : midw_ext_sxm_channelartfi_tclMsgBaseMessage(coRef)
{
   ChannelGraphicsType = coRef.ChannelGraphicsType;
   u8ImageData = coRef.u8ImageData;
   AlbumImageData = coRef.AlbumImageData;
   ImageDataSize = coRef.ImageDataSize;
   AlbumImageSize = coRef.AlbumImageSize;
   SID = coRef.SID;
}
midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult& midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult::operator=(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ChannelGraphicsType = coRef.ChannelGraphicsType;
   u8ImageData = coRef.u8ImageData;
   AlbumImageData = coRef.AlbumImageData;
   ImageDataSize = coRef.ImageDataSize;
   AlbumImageSize = coRef.AlbumImageSize;
   SID = coRef.SID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult::vDestroy()
{
   {
   u8ImageData.clear();
   }
   {
   AlbumImageData.clear();
   }
}

midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult::midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult()
:ChannelGraphicsType(0)


,ImageDataSize(0)
,AlbumImageSize(0)
,SID(0)
 {}

tS32 midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_channelartfi_tclToken::EN_MSG_GETCHANNELARTMETHODRESULT;
}


midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult::~midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 19+ static_cast<tU32>(u8ImageData.size()*1)+ static_cast<tU32>(AlbumImageData.size()*1);
}

fi_tclInContext& midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelGraphicsType);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u8ImageData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u8ImageData[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      AlbumImageData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AlbumImageData[u32Idx]);
      }
   }
   (tVoid) (oIn >> ImageDataSize);
   (tVoid) (oIn >> AlbumImageSize);
   (tVoid) (oIn >> SID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelGraphicsType);
   (tVoid) (oOut << (tU32)u8ImageData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u8ImageData.size(); ++u32Idx)
         (tVoid) (oOut << u8ImageData[u32Idx]);
   }
   (tVoid) (oOut << (tU32)AlbumImageData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AlbumImageData.size(); ++u32Idx)
         (tVoid) (oOut << AlbumImageData[u32Idx]);
   }
   (tVoid) (oOut << ImageDataSize);
   (tVoid) (oOut << AlbumImageSize);
   (tVoid) (oOut << SID);
   return oOut;
}

tBool midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult::operator==(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelGraphicsType == roRef.ChannelGraphicsType);
      bResult = bResult && (u8ImageData.size() == roRef.u8ImageData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u8ImageData.size()); ++u32Idx)
            bResult = bResult && (u8ImageData[u32Idx] == roRef.u8ImageData[u32Idx]);
      }
      bResult = bResult && (AlbumImageData.size() == roRef.AlbumImageData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlbumImageData.size()); ++u32Idx)
            bResult = bResult && (AlbumImageData[u32Idx] == roRef.AlbumImageData[u32Idx]);
      }
   bResult = bResult && (ImageDataSize == roRef.ImageDataSize);
   bResult = bResult && (AlbumImageSize == roRef.AlbumImageSize);
   bResult = bResult && (SID == roRef.SID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart::midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart& coRef)
   : midw_ext_sxm_channelartfi_tclMsgBaseMessage(coRef)
{
   ListOfSID = coRef.ListOfSID;
   ChannelGraphicsType = coRef.ChannelGraphicsType;
}
midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart& midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart::operator=(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListOfSID = coRef.ListOfSID;
   ChannelGraphicsType = coRef.ChannelGraphicsType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart::vDestroy()
{
   {
   ListOfSID.clear();
   }
}

midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart::midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart()

:ChannelGraphicsType(0)
 {}

tS32 midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_channelartfi_tclToken::EN_MSG_GETCHANNELARTLISTMETHODSTART;
}


midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart::~midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(ListOfSID.size()*2);
}

fi_tclInContext& midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ListOfSID.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListOfSID[u32Idx]);
      }
   }
   (tVoid) (oIn >> ChannelGraphicsType);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ListOfSID.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfSID.size(); ++u32Idx)
         (tVoid) (oOut << ListOfSID[u32Idx]);
   }
   (tVoid) (oOut << ChannelGraphicsType);
   return oOut;
}

tBool midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart::operator==(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfSID.size() == roRef.ListOfSID.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfSID.size()); ++u32Idx)
            bResult = bResult && (ListOfSID[u32Idx] == roRef.ListOfSID[u32Idx]);
      }
   bResult = bResult && (ChannelGraphicsType == roRef.ChannelGraphicsType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult::midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult& coRef)
   : midw_ext_sxm_channelartfi_tclMsgBaseMessage(coRef)
{
   ChannelGraphicsType = coRef.ChannelGraphicsType;
   ImageDataList = coRef.ImageDataList;
}
midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult& midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult::operator=(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ChannelGraphicsType = coRef.ChannelGraphicsType;
   ImageDataList = coRef.ImageDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ImageDataList.size(); ++u32Idx)
         ImageDataList[u32Idx].vDestroy();
   ImageDataList.clear();
   }
}

midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult::midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult()
:ChannelGraphicsType(0)

 {}

tS32 midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_channelartfi_tclToken::EN_MSG_GETCHANNELARTLISTMETHODRESULT;
}


midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult::~midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ImageDataList.size(); ++u32ListIdx)
      u32DynamicSize += ImageDataList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelGraphicsType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ImageDataList.size(); ++u32Idx)
      {
         ImageDataList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ImageDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ImageDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelGraphicsType);
   (tVoid) (oOut << (tU32)ImageDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ImageDataList.size(); ++u32Idx)
         (tVoid) (oOut << ImageDataList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult::operator==(const midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelGraphicsType == roRef.ChannelGraphicsType);
      bResult = bResult && (ImageDataList.size() == roRef.ImageDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ImageDataList.size()); ++u32Idx)
            bResult = bResult && (ImageDataList[u32Idx] == roRef.ImageDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusGet::midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusGet()
 {}

tS32 midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_channelartfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET;
}


midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusGet::~midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus& coRef)
   : midw_ext_sxm_channelartfi_tclMsgBaseMessage(coRef)
{
   DataServiceState = coRef.DataServiceState;
}
midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus& midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus::operator=(const midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DataServiceState = coRef.DataServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus()
:DataServiceState()
 {}

tS32 midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_channelartfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS;
}


midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus::~midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus()
{}

tU32 midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataServiceState);
   return oOut;
}

tBool midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus::operator==(const midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataServiceState == roRef.DataServiceState);
   return bResult;
}

//=============================================================================

midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusUpReg::midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusUpReg()
 {}

tS32 midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_channelartfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG;
}


midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusUpReg::~midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusRelUpReg::midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_channelartfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG;
}


midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusRelUpReg::~midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusRelUpReg()
{}

