/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_CANADIAN_FUELFITYPES_HEADER
#define MIDW_EXT_SXM_CANADIAN_FUELFITYPES_HEADER


class midw_ext_sxm_canadian_fuelfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_CANADIAN_FUEL_FI message types

fi_tclMessageBase* midw_ext_sxm_canadian_fuelfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_e8_SxmListOperation Operation;
   midw_ext_fi_tclString Brand;
   midw_ext_fi_tcl_CanFuelTypeInfo CanadianFuelType;
   midw_ext_fi_tcl_e8_CanFuelSortType SortType;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_e8_SxmListOperation Operation;
   midw_ext_fi_tcl_SxmListInfo ListInfo;
   midw_ext_fi_tcl_CanFuelInfoList CanadianFuelInfoList;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 CANADIAN_FUEL_LOCID;
   tU32 ListID;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_CanFuelStationInfo CanadianFuelStationInfo;
   tU32 ListID;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 CANADIAN_FUEL_LOCID;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 CANADIAN_FUEL_LOCID;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListsConfig Config;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusGet : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusGet();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusGet();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListInfos InfoList;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusUpReg : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusUpReg();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusRelUpReg : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusRelUpReg();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListGet : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListGet();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListGet();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_CanBrandNameList BrandName;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListUpReg : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListUpReg();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListUpReg();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListRelUpReg : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListRelUpReg();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListRelUpReg();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListGet : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListGet();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListGet();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_CanFuelTypeList TypeName;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListUpReg : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListUpReg();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListUpReg();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListRelUpReg : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListRelUpReg();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListRelUpReg();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusGet : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusGet();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusGet();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmDataSrvState DataServiceState;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusUpReg : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusUpReg();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusRelUpReg : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusRelUpReg();

   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus : public midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus& operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus& coRef);
   midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
