#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_CANADIAN_FUELFI_STDVISITORS
#include "midw_ext_fi_gen_if.h"

tBool midw_ext_sxm_canadian_fuelfi_tclDescription::bInitMessage(midw_ext_sxm_canadian_fuelfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_LAST_TOKEN:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_LIST:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELINFOLISTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_CANFUELSORTTYPE,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_SORTTYPE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELTYPEINFO,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_CANADIANFUELTYPE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_BRAND)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTOPERATION,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_OPERATION)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_LISTID)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELINFOLISTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELINFOLIST,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_CANADIANFUELINFOLIST)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTINFO,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_LISTINFO)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTOPERATION,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_OPERATION)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_LISTID)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELSTATIONINFOMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_LISTID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_CANADIAN_FUEL_LOCID)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELSTATIONINFOMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_LISTID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELSTATIONINFO,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_CANADIANFUELSTATIONINFO)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_CANADIAN_FUEL_LOCID)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_CANADIAN_FUEL_LOCID)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTSCONFIG,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_CONFIG)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTINFOS,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_INFOLIST)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANBRANDNAMELIST,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_BRANDNAME)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELTYPELIST,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_TYPENAME)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMDATASRVSTATE,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_DATASERVICESTATE)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMLISTMODESET:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTMODE,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_LISTMODE)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMLISTMODESTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTMODE,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MSG_LISTMODE)) && bResult;
   } break;
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSGET:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSUPREG:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSRELUPREG:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTGET:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTUPREG:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTRELUPREG:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTGET:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTUPREG:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTRELUPREG:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_BINCONTAINER:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTTYPE:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTSTATUS:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTMODE:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTMODE:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTOPERATION:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLOCATION:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTINFO:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTSCONFIG:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTINFOS:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMDATASERVICESTATUS:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMDATASRVSTATE:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_CANFUELTYPEENUM:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_CANFUELSTATIONAMENITY:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_CANFUELSORTTYPE:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELINFO:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELTYPEINFO:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELTYPEINFOLIST:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELSTATIONINFO:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELINFOLIST:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANBRANDNAMELIST:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELTYPELIST:
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_U8:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_S8:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_U16:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_S16:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_U24:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_S24:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_S32:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_U64:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_S64:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_F32:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_F64:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_BOOL:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING:   
   case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(enMsgToken,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_ext_sxm_canadian_fuelfi_tclDescription::bDoIt(midw_ext_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_ext_sxm_canadian_fuelfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_ext_sxm_canadian_fuelfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_ext_sxm_canadian_fuelfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_LIST: 
      {
         midw_ext_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_sxm_canadian_fuelfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_sxm_canadian_fuelfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_U8: 
      {
         midw_ext_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_U16: 
      {
         midw_ext_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_U24: 
      {
         midw_ext_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32: 
      {
         midw_ext_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_U64: 
      {
         midw_ext_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_S8: 
      {
         midw_ext_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_S16: 
      {
         midw_ext_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_S24: 
      {
         midw_ext_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_S32: 
      {
         midw_ext_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_S64: 
      {
         midw_ext_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_F32: 
      {
         midw_ext_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_F64: 
      {
         midw_ext_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_BOOL: 
      {
         midw_ext_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING: 
      {
         midw_ext_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_ext_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELINFOLISTMETHODSTART:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELINFOLISTMETHODRESULT:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELSTATIONINFOMETHODSTART:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELSTATIONINFOMETHODRESULT:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSGET:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSSTATUS:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSUPREG:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSRELUPREG:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTGET:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTSTATUS:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTUPREG:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTRELUPREG:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTGET:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTSTATUS:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTUPREG:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTRELUPREG:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMLISTMODESET:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMLISTMODESTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U8,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_LIST,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_ext_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTTYPE:
      {
         midw_ext_fi_tcl_e8_SxmListType o_e8_SxmListType;
         if (!bDoIt(o_e8_SxmListType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTSTATUS:
      {
         midw_ext_fi_tcl_e8_SxmListStatus o_e8_SxmListStatus;
         if (!bDoIt(o_e8_SxmListStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTMODE:
      {
         midw_ext_fi_tcl_e8_SxmListMode o_e8_SxmListMode;
         if (!bDoIt(o_e8_SxmListMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTMODE:
      {
      if (poVisitor->bDoExpand_SxmListMode(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTMODE,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MODE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LISTID));
      }
      else
      {
         midw_ext_fi_tcl_SxmListMode o_SxmListMode;
         if (!bDoIt(o_SxmListMode))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListMode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListMode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTOPERATION:
      {
         midw_ext_fi_tcl_e8_SxmListOperation o_e8_SxmListOperation;
         if (!bDoIt(o_e8_SxmListOperation))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLOCATION:
      {
      if (poVisitor->bDoExpand_SxmLocation(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_RADIUS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_S32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LON));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_S32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LAT));
      }
      else
      {
         midw_ext_fi_tcl_SxmLocation o_SxmLocation;
         if (!bDoIt(o_SxmLocation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTINFO:
      {
      if (poVisitor->bDoExpand_SxmListInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_SIZE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_BEMPTY));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTMODE,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_MODE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTSTATUS,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_STATE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTSTATUS,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_STATUS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMLISTTYPE,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LISTTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LISTID));
      }
      else
      {
         midw_ext_fi_tcl_SxmListInfo o_SxmListInfo;
         if (!bDoIt(o_SxmListInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTSCONFIG:
      {
      if (poVisitor->bDoExpand_SxmListsConfig(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CAPACITY));
      }
      else
      {
         midw_ext_fi_tcl_SxmListsConfig o_SxmListsConfig;
         if (!bDoIt(o_SxmListsConfig))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListsConfig.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListsConfig.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTINFOS:
      {
      if (poVisitor->bDoExpand_SxmListInfos(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTINFO,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_LIST,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LISTINFO));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLISTSCONFIG,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_GENERICCONFIG));
      }
      else
      {
         midw_ext_fi_tcl_SxmListInfos o_SxmListInfos;
         if (!bDoIt(o_SxmListInfos))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListInfos.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmListInfos.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMDATASERVICESTATUS:
      {
         midw_ext_fi_tcl_e8_SxmDataServiceStatus o_e8_SxmDataServiceStatus;
         if (!bDoIt(o_e8_SxmDataServiceStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMDATASRVSTATE:
      {
      if (poVisitor->bDoExpand_SxmDataSrvState(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_SXMDATASERVICESTATUS,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         midw_ext_fi_tcl_SxmDataSrvState o_SxmDataSrvState;
         if (!bDoIt(o_SxmDataSrvState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmDataSrvState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SxmDataSrvState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_CANFUELTYPEENUM:
      {
         midw_ext_fi_tcl_e8_CanFuelTypeEnum o_e8_CanFuelTypeEnum;
         if (!bDoIt(o_e8_CanFuelTypeEnum))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_CANFUELSTATIONAMENITY:
      {
         midw_ext_fi_tcl_e8_CanFuelStationAmenity o_e8_CanFuelStationAmenity;
         if (!bDoIt(o_e8_CanFuelStationAmenity))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_CANFUELSORTTYPE:
      {
         midw_ext_fi_tcl_e8_CanFuelSortType o_e8_CanFuelSortType;
         if (!bDoIt(o_e8_CanFuelSortType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELINFO:
      {
      if (poVisitor->bDoExpand_CanFuelInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_NUMPRICES));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_F32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELDISTMILE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_F32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELDISTKM));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLOCATION,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELLOC));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U8,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELAGE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELPRICE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELNAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUEL_LOCID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_CANFUELTYPEENUM,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_BRAND));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_STATIONNAME));
      }
      else
      {
         midw_ext_fi_tcl_CanFuelInfo o_CanFuelInfo;
         if (!bDoIt(o_CanFuelInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELTYPEINFO:
      {
      if (poVisitor->bDoExpand_CanFuelTypeInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELNAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_CANFUELTYPEENUM,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELTYPE));
      }
      else
      {
         midw_ext_fi_tcl_CanFuelTypeInfo o_CanFuelTypeInfo;
         if (!bDoIt(o_CanFuelTypeInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelTypeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelTypeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELTYPEINFOLIST:
      {
      if (poVisitor->bDoExpand_CanFuelTypeInfolist(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_CANFUELTYPEENUM,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_FUELTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_FUELAVAIL));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U8,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_FUELAGE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_FUELPRICE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_FUELNAME));
      }
      else
      {
         midw_ext_fi_tcl_CanFuelTypeInfolist o_CanFuelTypeInfolist;
         if (!bDoIt(o_CanFuelTypeInfolist))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelTypeInfolist.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelTypeInfolist.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELSTATIONINFO:
      {
      if (poVisitor->bDoExpand_CanFuelStationInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_NUMPRICES));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_E8_CANFUELSTATIONAMENITY,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_LIST,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_STATIONAMENITYLIST));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELTYPEINFOLIST,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_LIST,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELTYPELIST));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_SXMLOCATION,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELLOCATION));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_BOOL,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELFAVINFO));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_AMENITY));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_U32,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_FUEL_LOCID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_PHONE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_ZIPCODE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_STATE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CITY));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_STREETNAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_BRAND));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_STATIONNAME));
      }
      else
      {
         midw_ext_fi_tcl_CanFuelStationInfo o_CanFuelStationInfo;
         if (!bDoIt(o_CanFuelStationInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelStationInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelStationInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELINFOLIST:
      {
      if (poVisitor->bDoExpand_CanFuelInfoList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELINFO,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_LIST,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_CANFUELINFOLIST));
      }
      else
      {
         midw_ext_fi_tcl_CanFuelInfoList o_CanFuelInfoList;
         if (!bDoIt(o_CanFuelInfoList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelInfoList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelInfoList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANBRANDNAMELIST:
      {
      if (poVisitor->bDoExpand_CanBrandNameList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_STRING,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_LIST,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_BRANDNAMELIST));
      }
      else
      {
         midw_ext_fi_tcl_CanBrandNameList o_CanBrandNameList;
         if (!bDoIt(o_CanBrandNameList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanBrandNameList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanBrandNameList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELTYPELIST:
      {
      if (poVisitor->bDoExpand_CanFuelTypeList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_CANFUELTYPEINFO,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_canadian_fuelfi_tclKnot(midw_ext_sxm_canadian_fuelfi_tclToken::EN_LIST,midw_ext_sxm_canadian_fuelfi_tclSemanticDomain::EN_TYPENAMELIST));
      }
      else
      {
         midw_ext_fi_tcl_CanFuelTypeList o_CanFuelTypeList;
         if (!bDoIt(o_CanFuelTypeList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelTypeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CanFuelTypeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_UNKNOWN:
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

