/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_AUDIO_FI message types

fi_tclMessageBase* midw_ext_sxm_audiofi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCHANNELLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCHANNELLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCATEGORYLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCATEGORYLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SELECTCHANNELMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SELECTCHANNELMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SELECTCHANNELWITHDWELLTIMEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SELECTCHANNELWITHDWELLTIMEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_STOREPRESETMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_STOREPRESETMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RECALLPRESETMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RECALLPRESETMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETAUTOCOMPAREPARAMETERSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETAUTOCOMPAREPARAMETERSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETDESTINATIONPOSITIONMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETDESTINATIONPOSITIONMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGTESTMODEENABLEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGTESTMODEENABLEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGUPCVALUESMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGUPCVALUESMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSETMARKETMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSETMARKETMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETACTIVEMARKETMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETACTIVEMARKETMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINPLAYBACKMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINPLAYBACKMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETBULLETINIDMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETBULLETINIDMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETAVAILABLEMARKETSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETAVAILABLEMARKETSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWENABLEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWENABLEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGSXMRESETMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGSXMRESETMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_EXTERNALDIAGNOSISMODEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_EXTERNALDIAGNOSISMODEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYCONTROLMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYCONTROLMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_ENABLETUNESTARTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_ENABLETUNESTARTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SMARTFAVORITELISTCONTROLMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SMARTFAVORITELISTCONTROLMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCURRENTVOLUMEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCURRENTVOLUMEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTROLMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTROLMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETPRESETLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETPRESETLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DISABLEMATURECHANNELSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DISABLEMATURECHANNELSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SKIPCHANNELMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SKIPCHANNELMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SAVEFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SAVEFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETFAVORITELISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETFAVORITELISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_MODIFYFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_MODIFYFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETALERTNOTICELISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETALERTNOTICELISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHENABLENOTIFICATIONMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHENABLENOTIFICATIONMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHADDFAVORITETEAMMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHADDFAVORITETEAMMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHREMOVEFAVORITETEAMMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHREMOVEFAVORITETEAMMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHREMOVEALLFAVORITETEAMSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHREMOVEALLFAVORITETEAMSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETALLFAVORITESMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETALLFAVORITESMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTGAMESMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTGAMESMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHSETGAMESMONITORMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHSETGAMESMONITORMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTFLASHEVENTSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTFLASHEVENTSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHPLAYFLASHEVENTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHPLAYFLASHEVENTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHABORTFLASHEVENTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHABORTFLASHEVENTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTFLASHEVENTIDMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTFLASHEVENTIDMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHENABLEDLEAGUESMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHENABLEDLEAGUESMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETTEAMSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETTEAMSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHMONITORTEAMSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHMONITORTEAMSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCHANNELINFOMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCHANNELINFOMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETDEVICEPOSITIONMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETDEVICEPOSITIONMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCATEGORYMONITORMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCATEGORYMONITORMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSESTARTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSESTARTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSESTOPMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSESTOPMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RESETSXMMODULEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RESETSXMMODULEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_USERPROFILEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_USERPROFILEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETPRESETSCONFIGMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_GETPRESETSCONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETPRESETLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETPRESETLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELINFORMATIONGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgChannelInformationGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELINFORMATIONSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgChannelInformationStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELINFORMATIONUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgChannelInformationUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELINFORMATIONRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgChannelInformationRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_AUTOCOMPAREGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgAutoCompareGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_AUTOCOMPARESTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgAutoCompareStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_AUTOCOMPAREUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgAutoCompareUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_AUTOCOMPARERELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgAutoCompareRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SYSTEMMESSAGEGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSystemMessageGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SYSTEMMESSAGESTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSystemMessageStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SYSTEMMESSAGEUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSystemMessageUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SYSTEMMESSAGERELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSystemMessageRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELLISTSTATUSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgChannelListStatusGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELLISTSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELLISTSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgChannelListStatusUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELLISTSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgChannelListStatusRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CURRENTCHANNELGRAPHICGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CURRENTCHANNELGRAPHICSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CURRENTCHANNELGRAPHICUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CURRENTCHANNELGRAPHICRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CATEGORYLISTSTATUSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgCategoryListStatusGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CATEGORYLISTSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CATEGORYLISTSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgCategoryListStatusUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_CATEGORYLISTSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgCategoryListStatusRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYSTATUSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgInstantReplayStatusGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgInstantReplayStatusUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgInstantReplayStatusRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYMODEGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgInstantReplayModeGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYMODESTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYMODEUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgInstantReplayModeUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYMODERELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgInstantReplayModeRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTENTSTATUSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTENTSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTENTSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTENTSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETCHANNELUPDATEGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETCHANNELUPDATESTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETCHANNELUPDATEUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETCHANNELUPDATERELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICEANTENNASTATUSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICEANTENNASTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICEANTENNASTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICEANTENNASTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETLISTUPDATEGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgPresetListUpdateGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETLISTUPDATESTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETLISTUPDATEUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgPresetListUpdateUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETLISTUPDATERELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgPresetListUpdateRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGTESTMODEDATASTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGTESTMODEDATAUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagTestModeDataUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGTESTMODEDATARELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagTestModeDataRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGSXMVERSIONSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGSXMVERSIONUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagSxmVersionUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGSXMVERSIONRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgDiagSxmVersionRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGSIGNALQUALITYGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGSIGNALQUALITYSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGSIGNALQUALITYUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGSIGNALQUALITYRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGANTENNASTATEGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGANTENNASTATESTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGANTENNASTATEUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGANTENNASTATERELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMRADIOIDGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmRadioIdGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMRADIOIDSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMRADIOIDUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmRadioIdUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMRADIOIDRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmRadioIdRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMSMSDBVERSIONSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMSMSDBVERSIONSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMSMSDBVERSIONSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMAUDIOSUBINFOSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMAUDIOSUBINFOUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMAUDIOSUBINFORELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMMODULESUBINFOSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMMODULESUBINFOUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMMODULESUBINFORELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADPROGRESSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADPROGRESSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADPROGRESSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADPROGRESSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_FAVORITECONTENTALERTINFOGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_FAVORITECONTENTALERTINFOSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_FAVORITECONTENTALERTINFOUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_FAVORITECONTENTALERTINFORELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_ALERTNOTICELISTUPDATEGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_ALERTNOTICELISTUPDATESTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_ALERTNOTICELISTUPDATEUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_ALERTNOTICELISTUPDATERELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSERVICESTATUSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSERVICESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSERVICESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSERVICESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINSTATUSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCLOCKPARAMSSET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetClockParamsSet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCLOCKPARAMSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCLOCKPARAMSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetClockParamsUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCLOCKPARAMSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSetClockParamsRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_SERVICESTATUSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_SERVICESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_SERVICESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_SERVICESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_GAMEEVENTNOTIFICATIONGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_GAMEEVENTNOTIFICATIONSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_GAMEEVENTNOTIFICATIONUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_GAMEEVENTNOTIFICATIONRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_FLASHEVENTNOTIFICATIONGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_FLASHEVENTNOTIFICATIONSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_FLASHEVENTNOTIFICATIONUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_FLASHEVENTNOTIFICATIONRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWPLAYBACKSTATUSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWPLAYBACKSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWPLAYBACKSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWPLAYBACKSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_PLAYBACKSTATUSGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_PLAYBACKSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_PLAYBACKSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_PLAYBACKSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusRelUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSEINFOGET:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoGet;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSEINFOSTATUS:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSEINFOUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoUpReg;

      case midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSEINFORELUPREG:
         return OSAL_NEW midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoRelUpReg;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_audiofifi messages

// common functions

tU16 midw_ext_sxm_audiofi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_AUDIOFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_audiofi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_audiofi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_audiofi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_audiofi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_audiofi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart::midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Index = coRef.Index;
   Range = coRef.Range;
}
midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart& midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Index = coRef.Index;
   Range = coRef.Range;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart::midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart()
:Index(0)
,Range(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCHANNELLISTMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart::~midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Index);
   (tVoid) (oIn >> Range);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Index);
   (tVoid) (oOut << Range);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Index == roRef.Index);
   bResult = bResult && (Range == roRef.Range);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult::midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ChannelList = coRef.ChannelList;
   NextIndex = coRef.NextIndex;
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult& midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ChannelList = coRef.ChannelList;
   NextIndex = coRef.NextIndex;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
         ChannelList[u32Idx].vDestroy();
   ChannelList.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult::midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult()

:NextIndex(0)
,Status()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCHANNELLISTMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult::~midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ChannelList.size(); ++u32ListIdx)
      u32DynamicSize += ChannelList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
      {
         ChannelList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelList[u32Idx]);
      }
   }
   (tVoid) (oIn >> NextIndex);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ChannelList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
         (tVoid) (oOut << ChannelList[u32Idx]);
   }
   (tVoid) (oOut << NextIndex);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ChannelList.size() == roRef.ChannelList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelList.size()); ++u32Idx)
            bResult = bResult && (ChannelList[u32Idx] == roRef.ChannelList[u32Idx]);
      }
   bResult = bResult && (NextIndex == roRef.NextIndex);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart::midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   CategoryType = coRef.CategoryType;
}
midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart& midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CategoryType = coRef.CategoryType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart::midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart()
:CategoryType(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCATEGORYLISTMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart::~midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CategoryType);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CategoryType);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CategoryType == roRef.CategoryType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult::midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   CategoryList = coRef.CategoryList;
   CategoryType = coRef.CategoryType;
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult& midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CategoryList = coRef.CategoryList;
   CategoryType = coRef.CategoryType;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CategoryList.size(); ++u32Idx)
         CategoryList[u32Idx].vDestroy();
   CategoryList.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult::midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult()

:CategoryType(0)
,Status()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCATEGORYLISTMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult::~midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CategoryList.size(); ++u32ListIdx)
      u32DynamicSize += CategoryList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CategoryList.size(); ++u32Idx)
      {
         CategoryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CategoryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CategoryList[u32Idx]);
      }
   }
   (tVoid) (oIn >> CategoryType);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CategoryList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CategoryList.size(); ++u32Idx)
         (tVoid) (oOut << CategoryList[u32Idx]);
   }
   (tVoid) (oOut << CategoryType);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CategoryList.size() == roRef.CategoryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CategoryList.size()); ++u32Idx)
            bResult = bResult && (CategoryList[u32Idx] == roRef.CategoryList[u32Idx]);
      }
   bResult = bResult && (CategoryType == roRef.CategoryType);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart::midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   SelectionMode = coRef.SelectionMode;
   CidOrSid = coRef.CidOrSid;
   CategoryType = coRef.CategoryType;
   Steps = coRef.Steps;
}
midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart& midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SelectionMode = coRef.SelectionMode;
   CidOrSid = coRef.CidOrSid;
   CategoryType = coRef.CategoryType;
   Steps = coRef.Steps;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart::midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart()
:SelectionMode()
,CidOrSid(0)
,CategoryType(0)
,Steps(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SELECTCHANNELMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart::~midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectionMode);
   (tVoid) (oIn >> CidOrSid);
   (tVoid) (oIn >> CategoryType);
   (tVoid) (oIn >> Steps);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectionMode);
   (tVoid) (oOut << CidOrSid);
   (tVoid) (oOut << CategoryType);
   (tVoid) (oOut << Steps);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectionMode == roRef.SelectionMode);
   bResult = bResult && (CidOrSid == roRef.CidOrSid);
   bResult = bResult && (CategoryType == roRef.CategoryType);
   bResult = bResult && (Steps == roRef.Steps);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult::midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   SelectionMode = coRef.SelectionMode;
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult& midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SelectionMode = coRef.SelectionMode;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult::midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult()
:SelectionMode()
,Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SELECTCHANNELMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult::~midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectionMode);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectionMode);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectionMode == roRef.SelectionMode);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart::midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   SelectionMode = coRef.SelectionMode;
   CidOrSid = coRef.CidOrSid;
   CategoryType = coRef.CategoryType;
   Steps = coRef.Steps;
   DwellTime = coRef.DwellTime;
}
midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart& midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SelectionMode = coRef.SelectionMode;
   CidOrSid = coRef.CidOrSid;
   CategoryType = coRef.CategoryType;
   Steps = coRef.Steps;
   DwellTime = coRef.DwellTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart::midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart()
:SelectionMode()
,CidOrSid(0)
,CategoryType(0)
,Steps(0)
,DwellTime(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SELECTCHANNELWITHDWELLTIMEMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart::~midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectionMode);
   (tVoid) (oIn >> CidOrSid);
   (tVoid) (oIn >> CategoryType);
   (tVoid) (oIn >> Steps);
   (tVoid) (oIn >> DwellTime);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectionMode);
   (tVoid) (oOut << CidOrSid);
   (tVoid) (oOut << CategoryType);
   (tVoid) (oOut << Steps);
   (tVoid) (oOut << DwellTime);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectionMode == roRef.SelectionMode);
   bResult = bResult && (CidOrSid == roRef.CidOrSid);
   bResult = bResult && (CategoryType == roRef.CategoryType);
   bResult = bResult && (Steps == roRef.Steps);
   bResult = bResult && (DwellTime == roRef.DwellTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult::midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult& midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult::midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SELECTCHANNELWITHDWELLTIMEMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult::~midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart::midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   PresetElement = coRef.PresetElement;
}
midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart& midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PresetElement = coRef.PresetElement;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart::midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart()
:PresetElement(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_STOREPRESETMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart::~midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetElement);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetElement);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetElement == roRef.PresetElement);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult::midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   PresetElement = coRef.PresetElement;
   SmartFavoriteList = coRef.SmartFavoriteList;
   Status = coRef.Status;
   PresetListElement = coRef.PresetListElement;
}
midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult& midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult& coRef)
{
   if (this == &coRef) return *this;
   PresetElement = coRef.PresetElement;
   SmartFavoriteList = coRef.SmartFavoriteList;
   Status = coRef.Status;
   PresetListElement = coRef.PresetListElement;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SmartFavoriteList.size(); ++u32Idx)
         SmartFavoriteList[u32Idx].vDestroy();
   SmartFavoriteList.clear();
   }
   PresetListElement.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult::midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult()
:PresetElement(0)

,Status(0)
,PresetListElement()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_STOREPRESETMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult::~midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+ static_cast<tU32>(SmartFavoriteList.size()*2)+PresetListElement.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetElement);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SmartFavoriteList.size(); ++u32Idx)
      {
         SmartFavoriteList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SmartFavoriteList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SmartFavoriteList[u32Idx]);
      }
   }
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> PresetListElement);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetElement);
   (tVoid) (oOut << (tU32)SmartFavoriteList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SmartFavoriteList.size(); ++u32Idx)
         (tVoid) (oOut << SmartFavoriteList[u32Idx]);
   }
   (tVoid) (oOut << Status);
   (tVoid) (oOut << PresetListElement);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetElement == roRef.PresetElement);
      bResult = bResult && (SmartFavoriteList.size() == roRef.SmartFavoriteList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SmartFavoriteList.size()); ++u32Idx)
            bResult = bResult && (SmartFavoriteList[u32Idx] == roRef.SmartFavoriteList[u32Idx]);
      }
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (PresetListElement == roRef.PresetListElement);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart::midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   PresetElement = coRef.PresetElement;
}
midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart& midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PresetElement = coRef.PresetElement;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart::midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart()
:PresetElement(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RECALLPRESETMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart::~midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetElement);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetElement);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetElement == roRef.PresetElement);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult::midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   PresetElement = coRef.PresetElement;
   Status = coRef.Status;
   PresetListElement = coRef.PresetListElement;
}
midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult& midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult& coRef)
{
   if (this == &coRef) return *this;
   PresetElement = coRef.PresetElement;
   Status = coRef.Status;
   PresetListElement = coRef.PresetListElement;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult::vDestroy()
{
   PresetListElement.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult::midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult()
:PresetElement(0)
,Status(0)
,PresetListElement()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RECALLPRESETMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult::~midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+PresetListElement.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetElement);
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> PresetListElement);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetElement);
   (tVoid) (oOut << Status);
   (tVoid) (oOut << PresetListElement);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetElement == roRef.PresetElement);
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (PresetListElement == roRef.PresetListElement);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart::midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   u8FirstElement = coRef.u8FirstElement;
   u8LastElement = coRef.u8LastElement;
}
midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart& midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8FirstElement = coRef.u8FirstElement;
   u8LastElement = coRef.u8LastElement;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart::midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart()
:u8FirstElement(0)
,u8LastElement(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETAUTOCOMPAREPARAMETERSMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart::~midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8FirstElement);
   (tVoid) (oIn >> u8LastElement);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8FirstElement);
   (tVoid) (oOut << u8LastElement);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8FirstElement == roRef.u8FirstElement);
   bResult = bResult && (u8LastElement == roRef.u8LastElement);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult::midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult& midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult::midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETAUTOCOMPAREPARAMETERSMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult::~midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart::midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   s32Latitude = coRef.s32Latitude;
   s32Longitude = coRef.s32Longitude;
}
midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart& midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   s32Latitude = coRef.s32Latitude;
   s32Longitude = coRef.s32Longitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart::midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart()
:s32Latitude(0)
,s32Longitude(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETDESTINATIONPOSITIONMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart::~midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32Latitude);
   (tVoid) (oIn >> s32Longitude);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32Latitude);
   (tVoid) (oOut << s32Longitude);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32Latitude == roRef.s32Latitude);
   bResult = bResult && (s32Longitude == roRef.s32Longitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult::midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult& midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult::midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETDESTINATIONPOSITIONMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult::~midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart::midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart(const midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   bEnable = coRef.bEnable;
}
midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart& midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bEnable = coRef.bEnable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart::midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart()
:bEnable(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGTESTMODEENABLEMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart::~midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnable);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnable);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnable == roRef.bEnable);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodResult::midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodResult()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGTESTMODEENABLEMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodResult::~midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart::midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   GetVal = coRef.GetVal;
}
midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart& midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   GetVal = coRef.GetVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart::midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart()
:GetVal(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGUPCVALUESMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart::~midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GetVal);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GetVal);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GetVal == roRef.GetVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult::midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   UpcLid0 = coRef.UpcLid0;
   UpcLid1 = coRef.UpcLid1;
}
midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult& midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpcLid0 = coRef.UpcLid0;
   UpcLid1 = coRef.UpcLid1;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult::vDestroy()
{
   UpcLid0.vDestroy();
   UpcLid1.vDestroy();
}

midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult::midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult()
:UpcLid0()
,UpcLid1()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGUPCVALUESMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult::~midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+UpcLid0.u32GetSize(u16MajorVersion)+UpcLid1.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UpcLid0);
   (tVoid) (oIn >> UpcLid1);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UpcLid0);
   (tVoid) (oOut << UpcLid1);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpcLid0 == roRef.UpcLid0);
   bResult = bResult && (UpcLid1 == roRef.UpcLid1);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart::midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   Market = coRef.Market;
}
midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart& midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   Market = coRef.Market;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart::vDestroy()
{
   Market.vDestroy();
}

midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart::midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart()
:Status(0)
,Market()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSETMARKETMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart::~midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Market.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> Market);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << Market);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (Market == roRef.Market);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult& midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSETMARKETMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult::~midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart::midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETACTIVEMARKETMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart::~midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Market = coRef.Market;
}
midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult& midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Market = coRef.Market;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult::vDestroy()
{
   Market.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult()
:Market()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETACTIVEMARKETMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult::~midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Market.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Market);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Market);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Market == roRef.Market);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart::midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   BulletinID = coRef.BulletinID;
   Action = coRef.Action;
}
midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart& midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BulletinID = coRef.BulletinID;
   Action = coRef.Action;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart::midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart()
:BulletinID(0)
,Action()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINPLAYBACKMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart::~midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BulletinID);
   (tVoid) (oIn >> Action);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BulletinID);
   (tVoid) (oOut << Action);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BulletinID == roRef.BulletinID);
   bResult = bResult && (Action == roRef.Action);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   Action = coRef.Action;
}
midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult& midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   Action = coRef.Action;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult()
:Status(0)
,Action()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINPLAYBACKMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult::~midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> Action);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << Action);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (Action == roRef.Action);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart::midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETBULLETINIDMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart::~midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   BulletinID = coRef.BulletinID;
}
midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult& midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult& coRef)
{
   if (this == &coRef) return *this;
   BulletinID = coRef.BulletinID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult()
:BulletinID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETBULLETINIDMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult::~midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BulletinID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BulletinID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BulletinID == roRef.BulletinID);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart::midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETAVAILABLEMARKETSMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart::~midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Markets = coRef.Markets;
}
midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult& midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Markets = coRef.Markets;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult::vDestroy()
{
   Markets.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult()
:Markets()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWGETAVAILABLEMARKETSMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult::~midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Markets.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Markets);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Markets);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Markets == roRef.Markets);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart::midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart& midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart::midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWENABLEMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart::~midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult& midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult::midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWENABLEMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult::~midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart::midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart(const midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   tU8Request = coRef.tU8Request;
}
midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart& midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart& coRef)
{
   if (this == &coRef) return *this;
   tU8Request = coRef.tU8Request;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart::midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart()
:tU8Request(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGSXMRESETMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart::~midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tU8Request);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tU8Request);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tU8Request == roRef.tU8Request);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodResult::midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodResult()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGSXMRESETMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodResult::~midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart::midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   File = coRef.File;
   Version = coRef.Version;
   bForced = coRef.bForced;
}
midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart& midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart& coRef)
{
   if (this == &coRef) return *this;
   File = coRef.File;
   Version = coRef.Version;
   bForced = coRef.bForced;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart::vDestroy()
{
   File.vDestroy();
   Version.vDestroy();
}

midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart::midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart()
:File()
,Version()
,bForced(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart::~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+File.u32GetSize(u16MajorVersion)+Version.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> File);
   (tVoid) (oIn >> Version);
   (tVoid) (oIn >> bForced);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << File);
   (tVoid) (oOut << Version);
   (tVoid) (oOut << bForced);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (File == roRef.File);
   bResult = bResult && (Version == roRef.Version);
   bResult = bResult && (bForced == roRef.bForced);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult::midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   enResult = coRef.enResult;
}
midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult& midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult& coRef)
{
   if (this == &coRef) return *this;
   enResult = coRef.enResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult::midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult()
:enResult()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult::~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enResult);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enResult);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enResult == roRef.enResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart::midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart(const midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Mode = coRef.Mode;
}
midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart& midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Mode = coRef.Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart::midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart()
:Mode()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_EXTERNALDIAGNOSISMODEMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart::~midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mode);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mode == roRef.Mode);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodResult::midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodResult()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_EXTERNALDIAGNOSISMODEMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodResult::~midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart::midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   u8IRPlaybackMode = coRef.u8IRPlaybackMode;
}
midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart& midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8IRPlaybackMode = coRef.u8IRPlaybackMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart::midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart()
:u8IRPlaybackMode()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYCONTROLMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart::~midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8IRPlaybackMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8IRPlaybackMode);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8IRPlaybackMode == roRef.u8IRPlaybackMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult::midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   u8IRPlaybackMode = coRef.u8IRPlaybackMode;
   u8IRPlaybackState = coRef.u8IRPlaybackState;
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult& midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8IRPlaybackMode = coRef.u8IRPlaybackMode;
   u8IRPlaybackState = coRef.u8IRPlaybackState;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult::midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult()
:u8IRPlaybackMode()
,u8IRPlaybackState()
,Status()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYCONTROLMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult::~midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8IRPlaybackMode);
   (tVoid) (oIn >> u8IRPlaybackState);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8IRPlaybackMode);
   (tVoid) (oOut << u8IRPlaybackState);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8IRPlaybackMode == roRef.u8IRPlaybackMode);
   bResult = bResult && (u8IRPlaybackState == roRef.u8IRPlaybackState);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart::midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   bEnableTuneStart = coRef.bEnableTuneStart;
}
midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart& midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bEnableTuneStart = coRef.bEnableTuneStart;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart::midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart()
:bEnableTuneStart(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_ENABLETUNESTARTMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart::~midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnableTuneStart);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnableTuneStart);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnableTuneStart == roRef.bEnableTuneStart);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult::midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   bEnableTuneStart = coRef.bEnableTuneStart;
}
midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult& midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   bEnableTuneStart = coRef.bEnableTuneStart;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult::midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult()
:Status()
,bEnableTuneStart(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_ENABLETUNESTARTMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult::~midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> bEnableTuneStart);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << bEnableTuneStart);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (bEnableTuneStart == roRef.bEnableTuneStart);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart::midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Operation = coRef.Operation;
   ListIndex = coRef.ListIndex;
}
midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart& midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Operation = coRef.Operation;
   ListIndex = coRef.ListIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart::midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart()
:Operation()
,ListIndex(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SMARTFAVORITELISTCONTROLMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart::~midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Operation);
   (tVoid) (oIn >> ListIndex);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Operation);
   (tVoid) (oOut << ListIndex);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Operation == roRef.Operation);
   bResult = bResult && (ListIndex == roRef.ListIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult::midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Operation = coRef.Operation;
   SmartFavoriteList = coRef.SmartFavoriteList;
   EnableAddPreset = coRef.EnableAddPreset;
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult& midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Operation = coRef.Operation;
   SmartFavoriteList = coRef.SmartFavoriteList;
   EnableAddPreset = coRef.EnableAddPreset;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SmartFavoriteList.size(); ++u32Idx)
         SmartFavoriteList[u32Idx].vDestroy();
   SmartFavoriteList.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult::midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult()
:Operation()

,EnableAddPreset(0)
,Status()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SMARTFAVORITELISTCONTROLMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult::~midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7+ static_cast<tU32>(SmartFavoriteList.size()*2);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Operation);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SmartFavoriteList.size(); ++u32Idx)
      {
         SmartFavoriteList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SmartFavoriteList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SmartFavoriteList[u32Idx]);
      }
   }
   (tVoid) (oIn >> EnableAddPreset);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Operation);
   (tVoid) (oOut << (tU32)SmartFavoriteList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SmartFavoriteList.size(); ++u32Idx)
         (tVoid) (oOut << SmartFavoriteList[u32Idx]);
   }
   (tVoid) (oOut << EnableAddPreset);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Operation == roRef.Operation);
      bResult = bResult && (SmartFavoriteList.size() == roRef.SmartFavoriteList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SmartFavoriteList.size()); ++u32Idx)
            bResult = bResult && (SmartFavoriteList[u32Idx] == roRef.SmartFavoriteList[u32Idx]);
      }
   bResult = bResult && (EnableAddPreset == roRef.EnableAddPreset);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart::midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   IsMuteActive = coRef.IsMuteActive;
}
midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart& midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   IsMuteActive = coRef.IsMuteActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart::midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart()
:IsMuteActive(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCURRENTVOLUMEMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart::~midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IsMuteActive);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IsMuteActive);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IsMuteActive == roRef.IsMuteActive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult::midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   IsMuteActive = coRef.IsMuteActive;
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult& midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   IsMuteActive = coRef.IsMuteActive;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult::midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult()
:IsMuteActive(0)
,Status()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCURRENTVOLUMEMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult::~midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IsMuteActive);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IsMuteActive);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IsMuteActive == roRef.IsMuteActive);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart::midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   TuneScanMode = coRef.TuneScanMode;
}
midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart& midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TuneScanMode = coRef.TuneScanMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart::midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart()
:TuneScanMode()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTROLMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart::~midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TuneScanMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TuneScanMode);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TuneScanMode == roRef.TuneScanMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult::midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult& midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult::midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult()
:Status()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTROLMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult::~midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart::midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   PresetBand = coRef.PresetBand;
}
midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart& midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PresetBand = coRef.PresetBand;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart::midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart()
:PresetBand(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETPRESETLISTMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart::~midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetBand);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetBand);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetBand == roRef.PresetBand);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult::midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   PresetChannels = coRef.PresetChannels;
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult& midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   PresetChannels = coRef.PresetChannels;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult::vDestroy()
{
   PresetChannels.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult::midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult()
:PresetChannels()
,Status()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETPRESETLISTMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult::~midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+PresetChannels.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetChannels);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetChannels);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetChannels == roRef.PresetChannels);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart::midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart& midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart::midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DISABLEMATURECHANNELSMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart::~midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult::midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   LockStatus = coRef.LockStatus;
}
midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult& midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LockStatus = coRef.LockStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult::midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult()
:LockStatus(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DISABLEMATURECHANNELSMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult::~midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LockStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LockStatus);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LockStatus == roRef.LockStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart::midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   SkipChannelType = coRef.SkipChannelType;
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
}
midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart& midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SkipChannelType = coRef.SkipChannelType;
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart::midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart()
:SkipChannelType()
,ServiceID(0)
,ChannelID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SKIPCHANNELMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart::~midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SkipChannelType);
   (tVoid) (oIn >> ServiceID);
   (tVoid) (oIn >> ChannelID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SkipChannelType);
   (tVoid) (oOut << ServiceID);
   (tVoid) (oOut << ChannelID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SkipChannelType == roRef.SkipChannelType);
   bResult = bResult && (ServiceID == roRef.ServiceID);
   bResult = bResult && (ChannelID == roRef.ChannelID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult::midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult& midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult::midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SKIPCHANNELMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult::~midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart::midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
   FavoriteType = coRef.FavoriteType;
   MaxFavoriteCount = coRef.MaxFavoriteCount;
}
midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart& midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
   FavoriteType = coRef.FavoriteType;
   MaxFavoriteCount = coRef.MaxFavoriteCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart::midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart()
:ServiceID(0)
,ChannelID(0)
,FavoriteType()
,MaxFavoriteCount(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SAVEFAVORITEMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart::~midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceID);
   (tVoid) (oIn >> ChannelID);
   (tVoid) (oIn >> FavoriteType);
   (tVoid) (oIn >> MaxFavoriteCount);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceID);
   (tVoid) (oOut << ChannelID);
   (tVoid) (oOut << FavoriteType);
   (tVoid) (oOut << MaxFavoriteCount);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceID == roRef.ServiceID);
   bResult = bResult && (ChannelID == roRef.ChannelID);
   bResult = bResult && (FavoriteType == roRef.FavoriteType);
   bResult = bResult && (MaxFavoriteCount == roRef.MaxFavoriteCount);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult::midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ContentName = coRef.ContentName;
   FavoriteType = coRef.FavoriteType;
   FavoriteCount = coRef.FavoriteCount;
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult& midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ContentName = coRef.ContentName;
   FavoriteType = coRef.FavoriteType;
   FavoriteCount = coRef.FavoriteCount;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult::vDestroy()
{
   ContentName.vDestroy();
}

midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult::midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult()
:ContentName()
,FavoriteType()
,FavoriteCount(0)
,Status()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SAVEFAVORITEMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult::~midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+ContentName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContentName);
   (tVoid) (oIn >> FavoriteType);
   (tVoid) (oIn >> FavoriteCount);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContentName);
   (tVoid) (oOut << FavoriteType);
   (tVoid) (oOut << FavoriteCount);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContentName == roRef.ContentName);
   bResult = bResult && (FavoriteType == roRef.FavoriteType);
   bResult = bResult && (FavoriteCount == roRef.FavoriteCount);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart::midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FavoriteType = coRef.FavoriteType;
}
midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart& midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FavoriteType = coRef.FavoriteType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart::midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart()
:FavoriteType()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETFAVORITELISTMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart::~midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FavoriteType);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FavoriteType);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FavoriteType == roRef.FavoriteType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult::midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   RegisteredFavoriteList = coRef.RegisteredFavoriteList;
}
midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult& midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RegisteredFavoriteList = coRef.RegisteredFavoriteList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RegisteredFavoriteList.size(); ++u32Idx)
         RegisteredFavoriteList[u32Idx].vDestroy();
   RegisteredFavoriteList.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult::midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETFAVORITELISTMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult::~midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RegisteredFavoriteList.size(); ++u32ListIdx)
      u32DynamicSize += RegisteredFavoriteList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RegisteredFavoriteList.size(); ++u32Idx)
      {
         RegisteredFavoriteList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RegisteredFavoriteList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RegisteredFavoriteList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)RegisteredFavoriteList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RegisteredFavoriteList.size(); ++u32Idx)
         (tVoid) (oOut << RegisteredFavoriteList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (RegisteredFavoriteList.size() == roRef.RegisteredFavoriteList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegisteredFavoriteList.size()); ++u32Idx)
            bResult = bResult && (RegisteredFavoriteList[u32Idx] == roRef.RegisteredFavoriteList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart::midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FavoriteType = coRef.FavoriteType;
   Action = coRef.Action;
   ContentName = coRef.ContentName;
}
midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart& midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FavoriteType = coRef.FavoriteType;
   Action = coRef.Action;
   ContentName = coRef.ContentName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart::vDestroy()
{
   ContentName.vDestroy();
}

midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart::midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart()
:FavoriteType()
,Action()
,ContentName()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_MODIFYFAVORITEMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart::~midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ContentName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FavoriteType);
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> ContentName);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FavoriteType);
   (tVoid) (oOut << Action);
   (tVoid) (oOut << ContentName);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FavoriteType == roRef.FavoriteType);
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (ContentName == roRef.ContentName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult::midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FavoriteType = coRef.FavoriteType;
   Action = coRef.Action;
   ContentName = coRef.ContentName;
}
midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult& midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FavoriteType = coRef.FavoriteType;
   Action = coRef.Action;
   ContentName = coRef.ContentName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult::vDestroy()
{
   ContentName.vDestroy();
}

midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult::midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult()
:FavoriteType()
,Action()
,ContentName()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_MODIFYFAVORITEMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult::~midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ContentName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FavoriteType);
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> ContentName);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FavoriteType);
   (tVoid) (oOut << Action);
   (tVoid) (oOut << ContentName);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FavoriteType == roRef.FavoriteType);
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (ContentName == roRef.ContentName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart::midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FavoriteType = coRef.FavoriteType;
}
midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart& midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FavoriteType = coRef.FavoriteType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart::midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart()
:FavoriteType()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETALERTNOTICELISTMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart::~midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FavoriteType);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FavoriteType);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FavoriteType == roRef.FavoriteType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult::midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   AlertInfoList = coRef.AlertInfoList;
}
midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult& midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AlertInfoList = coRef.AlertInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AlertInfoList.size(); ++u32Idx)
         AlertInfoList[u32Idx].vDestroy();
   AlertInfoList.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult::midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETALERTNOTICELISTMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult::~midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AlertInfoList.size(); ++u32ListIdx)
      u32DynamicSize += AlertInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlertInfoList.size(); ++u32Idx)
      {
         AlertInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AlertInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AlertInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AlertInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AlertInfoList.size(); ++u32Idx)
         (tVoid) (oOut << AlertInfoList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AlertInfoList.size() == roRef.AlertInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlertInfoList.size()); ++u32Idx)
            bResult = bResult && (AlertInfoList[u32Idx] == roRef.AlertInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Enable = coRef.Enable;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart& midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Enable = coRef.Enable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart()
:Enable(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHENABLENOTIFICATIONMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Enable);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Enable);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Enable == roRef.Enable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHENABLENOTIFICATIONMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   SportType = coRef.SportType;
   LeagueID = coRef.LeagueID;
   TeamID = coRef.TeamID;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart& midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SportType = coRef.SportType;
   LeagueID = coRef.LeagueID;
   TeamID = coRef.TeamID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart()
:SportType()
,LeagueID(0)
,TeamID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHADDFAVORITETEAMMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportType);
   (tVoid) (oIn >> LeagueID);
   (tVoid) (oIn >> TeamID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportType);
   (tVoid) (oOut << LeagueID);
   (tVoid) (oOut << TeamID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportType == roRef.SportType);
   bResult = bResult && (LeagueID == roRef.LeagueID);
   bResult = bResult && (TeamID == roRef.TeamID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHADDFAVORITETEAMMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   SportType = coRef.SportType;
   LeagueID = coRef.LeagueID;
   TeamID = coRef.TeamID;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart& midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SportType = coRef.SportType;
   LeagueID = coRef.LeagueID;
   TeamID = coRef.TeamID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart()
:SportType()
,LeagueID(0)
,TeamID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHREMOVEFAVORITETEAMMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportType);
   (tVoid) (oIn >> LeagueID);
   (tVoid) (oIn >> TeamID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportType);
   (tVoid) (oOut << LeagueID);
   (tVoid) (oOut << TeamID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportType == roRef.SportType);
   bResult = bResult && (LeagueID == roRef.LeagueID);
   bResult = bResult && (TeamID == roRef.TeamID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHREMOVEFAVORITETEAMMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHREMOVEALLFAVORITETEAMSMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHREMOVEALLFAVORITETEAMSMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETALLFAVORITESMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FavouritesList = coRef.FavouritesList;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FavouritesList = coRef.FavouritesList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FavouritesList.size(); ++u32Idx)
         FavouritesList[u32Idx].vDestroy();
   FavouritesList.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETALLFAVORITESMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FavouritesList.size(); ++u32ListIdx)
      u32DynamicSize += FavouritesList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FavouritesList.size(); ++u32Idx)
      {
         FavouritesList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FavouritesList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FavouritesList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)FavouritesList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FavouritesList.size(); ++u32Idx)
         (tVoid) (oOut << FavouritesList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (FavouritesList.size() == roRef.FavouritesList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FavouritesList.size()); ++u32Idx)
            bResult = bResult && (FavouritesList[u32Idx] == roRef.FavouritesList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTGAMESMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Games = coRef.Games;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Games = coRef.Games;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Games.size(); ++u32Idx)
         Games[u32Idx].vDestroy();
   Games.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTGAMESMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Games.size(); ++u32ListIdx)
      u32DynamicSize += Games[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Games.size(); ++u32Idx)
      {
         Games[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Games.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Games[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Games.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Games.size(); ++u32Idx)
         (tVoid) (oOut << Games[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Games.size() == roRef.Games.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Games.size()); ++u32Idx)
            bResult = bResult && (Games[u32Idx] == roRef.Games[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ChannelIDs = coRef.ChannelIDs;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart& midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ChannelIDs = coRef.ChannelIDs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart::vDestroy()
{
   {
   ChannelIDs.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHSETGAMESMONITORMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ChannelIDs.size()*2);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ChannelIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelIDs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ChannelIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelIDs.size(); ++u32Idx)
         (tVoid) (oOut << ChannelIDs[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ChannelIDs.size() == roRef.ChannelIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelIDs.size()); ++u32Idx)
            bResult = bResult && (ChannelIDs[u32Idx] == roRef.ChannelIDs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHSETGAMESMONITORMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTFLASHEVENTSMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FlashEvents = coRef.FlashEvents;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FlashEvents = coRef.FlashEvents;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FlashEvents.size(); ++u32Idx)
         FlashEvents[u32Idx].vDestroy();
   FlashEvents.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTFLASHEVENTSMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FlashEvents.size(); ++u32ListIdx)
      u32DynamicSize += FlashEvents[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FlashEvents.size(); ++u32Idx)
      {
         FlashEvents[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FlashEvents.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FlashEvents[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)FlashEvents.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FlashEvents.size(); ++u32Idx)
         (tVoid) (oOut << FlashEvents[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (FlashEvents.size() == roRef.FlashEvents.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FlashEvents.size()); ++u32Idx)
            bResult = bResult && (FlashEvents[u32Idx] == roRef.FlashEvents[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FlashEventID = coRef.FlashEventID;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart& midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FlashEventID = coRef.FlashEventID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart()
:FlashEventID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHPLAYFLASHEVENTMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FlashEventID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FlashEventID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FlashEventID == roRef.FlashEventID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHPLAYFLASHEVENTMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHABORTFLASHEVENTMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHABORTFLASHEVENTMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTFLASHEVENTIDMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FlashEventID = coRef.FlashEventID;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FlashEventID = coRef.FlashEventID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult()
:FlashEventID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETCURRENTFLASHEVENTIDMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FlashEventID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FlashEventID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FlashEventID == roRef.FlashEventID);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHENABLEDLEAGUESMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Leagues = coRef.Leagues;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Leagues = coRef.Leagues;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Leagues.size(); ++u32Idx)
         Leagues[u32Idx].vDestroy();
   Leagues.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHENABLEDLEAGUESMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Leagues.size(); ++u32ListIdx)
      u32DynamicSize += Leagues[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Leagues.size(); ++u32Idx)
      {
         Leagues[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Leagues.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Leagues[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Leagues.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Leagues.size(); ++u32Idx)
         (tVoid) (oOut << Leagues[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Leagues.size() == roRef.Leagues.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Leagues.size()); ++u32Idx)
            bResult = bResult && (Leagues[u32Idx] == roRef.Leagues[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   SportType = coRef.SportType;
   LeagueID = coRef.LeagueID;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart& midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SportType = coRef.SportType;
   LeagueID = coRef.LeagueID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart()
:SportType()
,LeagueID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETTEAMSMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SportType);
   (tVoid) (oIn >> LeagueID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SportType);
   (tVoid) (oOut << LeagueID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SportType == roRef.SportType);
   bResult = bResult && (LeagueID == roRef.LeagueID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Teams = coRef.Teams;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Teams = coRef.Teams;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Teams.size(); ++u32Idx)
         Teams[u32Idx].vDestroy();
   Teams.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHGETTEAMSMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Teams.size(); ++u32ListIdx)
      u32DynamicSize += Teams[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Teams.size(); ++u32Idx)
      {
         Teams[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Teams.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Teams[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Teams.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Teams.size(); ++u32Idx)
         (tVoid) (oOut << Teams[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Teams.size() == roRef.Teams.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Teams.size()); ++u32Idx)
            bResult = bResult && (Teams[u32Idx] == roRef.Teams[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FavoriteTeams = coRef.FavoriteTeams;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart& midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FavoriteTeams = coRef.FavoriteTeams;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FavoriteTeams.size(); ++u32Idx)
         FavoriteTeams[u32Idx].vDestroy();
   FavoriteTeams.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart::midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHMONITORTEAMSMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart::~midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(FavoriteTeams.size()*4);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FavoriteTeams.size(); ++u32Idx)
      {
         FavoriteTeams[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FavoriteTeams.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FavoriteTeams[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)FavoriteTeams.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FavoriteTeams.size(); ++u32Idx)
         (tVoid) (oOut << FavoriteTeams[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (FavoriteTeams.size() == roRef.FavoriteTeams.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FavoriteTeams.size()); ++u32Idx)
            bResult = bResult && (FavoriteTeams[u32Idx] == roRef.FavoriteTeams[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult& midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult::midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASHMONITORTEAMSMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult::~midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart::midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   SIDList = coRef.SIDList;
}
midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart& midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SIDList = coRef.SIDList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart::vDestroy()
{
   {
   SIDList.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart::midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCHANNELINFOMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart::~midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(SIDList.size()*2);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      SIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SIDList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SIDList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SIDList.size(); ++u32Idx)
         (tVoid) (oOut << SIDList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SIDList.size() == roRef.SIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SIDList.size()); ++u32Idx)
            bResult = bResult && (SIDList[u32Idx] == roRef.SIDList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult::midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ChannelInfoList = coRef.ChannelInfoList;
}
midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult& midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ChannelInfoList = coRef.ChannelInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelInfoList.size(); ++u32Idx)
         ChannelInfoList[u32Idx].vDestroy();
   ChannelInfoList.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult::midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETCHANNELINFOMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult::~midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ChannelInfoList.size(); ++u32ListIdx)
      u32DynamicSize += ChannelInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelInfoList.size(); ++u32Idx)
      {
         ChannelInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ChannelInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelInfoList.size(); ++u32Idx)
         (tVoid) (oOut << ChannelInfoList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ChannelInfoList.size() == roRef.ChannelInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelInfoList.size()); ++u32Idx)
            bResult = bResult && (ChannelInfoList[u32Idx] == roRef.ChannelInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart::midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Latitude = coRef.Latitude;
   Longitude = coRef.Longitude;
}
midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart& midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Latitude = coRef.Latitude;
   Longitude = coRef.Longitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart::midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart()
:Latitude(0)
,Longitude(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETDEVICEPOSITIONMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart::~midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Latitude);
   (tVoid) (oIn >> Longitude);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Latitude);
   (tVoid) (oOut << Longitude);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Latitude == roRef.Latitude);
   bResult = bResult && (Longitude == roRef.Longitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult::midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult& midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult::midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETDEVICEPOSITIONMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult::~midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart::midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   CategoryID = coRef.CategoryID;
   ChannelEvents = coRef.ChannelEvents;
   MonitorBrowsableChannels = coRef.MonitorBrowsableChannels;
   EnableMonitoring = coRef.EnableMonitoring;
}
midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart& midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CategoryID = coRef.CategoryID;
   ChannelEvents = coRef.ChannelEvents;
   MonitorBrowsableChannels = coRef.MonitorBrowsableChannels;
   EnableMonitoring = coRef.EnableMonitoring;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart::midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart()
:CategoryID(0)
,ChannelEvents()
,MonitorBrowsableChannels(0)
,EnableMonitoring(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCATEGORYMONITORMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart::~midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CategoryID);
   (tVoid) (oIn >> ChannelEvents);
   (tVoid) (oIn >> MonitorBrowsableChannels);
   (tVoid) (oIn >> EnableMonitoring);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CategoryID);
   (tVoid) (oOut << ChannelEvents);
   (tVoid) (oOut << MonitorBrowsableChannels);
   (tVoid) (oOut << EnableMonitoring);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CategoryID == roRef.CategoryID);
   bResult = bResult && (ChannelEvents == roRef.ChannelEvents);
   bResult = bResult && (MonitorBrowsableChannels == roRef.MonitorBrowsableChannels);
   bResult = bResult && (EnableMonitoring == roRef.EnableMonitoring);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult::midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult& midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult::midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCATEGORYMONITORMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult::~midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Direction = coRef.Direction;
   Config = coRef.Config;
   CategoryID = coRef.CategoryID;
}
midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Direction = coRef.Direction;
   Config = coRef.Config;
   CategoryID = coRef.CategoryID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart::vDestroy()
{
   Config.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart()
:Direction()
,Config()
,CategoryID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSESTARTMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart::~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+Config.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Direction);
   (tVoid) (oIn >> Config);
   (tVoid) (oIn >> CategoryID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Direction);
   (tVoid) (oOut << Config);
   (tVoid) (oOut << CategoryID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Direction == roRef.Direction);
   bResult = bResult && (Config == roRef.Config);
   bResult = bResult && (CategoryID == roRef.CategoryID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSESTARTMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult::~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ChannelID = coRef.ChannelID;
}
midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ChannelID = coRef.ChannelID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart()
:ChannelID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSESTOPMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart::~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelID == roRef.ChannelID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSESTOPMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult::~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodStart::midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RESETSXMMODULEMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodStart::~midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult::midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult(const midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult& midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult::midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RESETSXMMODULEMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult::~midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart::midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ProfileAction = coRef.ProfileAction;
   ProfileStatus = coRef.ProfileStatus;
   SourceID = coRef.SourceID;
   DestinationID = coRef.DestinationID;
}
midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart& midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ProfileAction = coRef.ProfileAction;
   ProfileStatus = coRef.ProfileStatus;
   SourceID = coRef.SourceID;
   DestinationID = coRef.DestinationID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart::midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart()
:ProfileAction()
,ProfileStatus()
,SourceID(0)
,DestinationID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_USERPROFILEMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart::~midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart()
{}

tU32 midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProfileAction);
   (tVoid) (oIn >> ProfileStatus);
   (tVoid) (oIn >> SourceID);
   (tVoid) (oIn >> DestinationID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProfileAction);
   (tVoid) (oOut << ProfileStatus);
   (tVoid) (oOut << SourceID);
   (tVoid) (oOut << DestinationID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProfileAction == roRef.ProfileAction);
   bResult = bResult && (ProfileStatus == roRef.ProfileStatus);
   bResult = bResult && (SourceID == roRef.SourceID);
   bResult = bResult && (DestinationID == roRef.DestinationID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult::midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ProfileResponse = coRef.ProfileResponse;
}
midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult& midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ProfileResponse = coRef.ProfileResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult::midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult()
:ProfileResponse()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_USERPROFILEMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult::~midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProfileResponse);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProfileResponse);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProfileResponse == roRef.ProfileResponse);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodStart::midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodStart()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETPRESETSCONFIGMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodStart::~midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult::midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult(const midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   PresetsConfiguration = coRef.PresetsConfiguration;
}
midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult& midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   PresetsConfiguration = coRef.PresetsConfiguration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult::midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult()
:PresetsConfiguration()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_GETPRESETSCONFIGMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult::~midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetsConfiguration);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetsConfiguration);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetsConfiguration == roRef.PresetsConfiguration);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart::midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   PresetEntry = coRef.PresetEntry;
}
midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart& midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart::operator=(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PresetEntry = coRef.PresetEntry;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PresetEntry.size(); ++u32Idx)
         PresetEntry[u32Idx].vDestroy();
   PresetEntry.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart::midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETPRESETLISTMETHODSTART;
}


midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart::~midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(PresetEntry.size()*4);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PresetEntry.size(); ++u32Idx)
      {
         PresetEntry[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PresetEntry.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PresetEntry[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)PresetEntry.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PresetEntry.size(); ++u32Idx)
         (tVoid) (oOut << PresetEntry[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart::operator==(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PresetEntry.size() == roRef.PresetEntry.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresetEntry.size()); ++u32Idx)
            bResult = bResult && (PresetEntry[u32Idx] == roRef.PresetEntry[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult::midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult& midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult::operator=(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult::midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETPRESETLISTMETHODRESULT;
}


midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult::~midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult::operator==(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgChannelInformationGet::midw_ext_sxm_audiofi_tclMsgChannelInformationGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgChannelInformationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELINFORMATIONGET;
}


midw_ext_sxm_audiofi_tclMsgChannelInformationGet::~midw_ext_sxm_audiofi_tclMsgChannelInformationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgChannelInformationStatus::midw_ext_sxm_audiofi_tclMsgChannelInformationStatus(const midw_ext_sxm_audiofi_tclMsgChannelInformationStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ChannelInformation = coRef.ChannelInformation;
}
midw_ext_sxm_audiofi_tclMsgChannelInformationStatus& midw_ext_sxm_audiofi_tclMsgChannelInformationStatus::operator=(const midw_ext_sxm_audiofi_tclMsgChannelInformationStatus& coRef)
{
   if (this == &coRef) return *this;
   ChannelInformation = coRef.ChannelInformation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgChannelInformationStatus::vDestroy()
{
   ChannelInformation.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgChannelInformationStatus::midw_ext_sxm_audiofi_tclMsgChannelInformationStatus()
:ChannelInformation()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgChannelInformationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELINFORMATIONSTATUS;
}


midw_ext_sxm_audiofi_tclMsgChannelInformationStatus::~midw_ext_sxm_audiofi_tclMsgChannelInformationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgChannelInformationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ChannelInformation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgChannelInformationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelInformation);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgChannelInformationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelInformation);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgChannelInformationStatus::operator==(const midw_ext_sxm_audiofi_tclMsgChannelInformationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelInformation == roRef.ChannelInformation);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgChannelInformationUpReg::midw_ext_sxm_audiofi_tclMsgChannelInformationUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgChannelInformationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELINFORMATIONUPREG;
}


midw_ext_sxm_audiofi_tclMsgChannelInformationUpReg::~midw_ext_sxm_audiofi_tclMsgChannelInformationUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgChannelInformationRelUpReg::midw_ext_sxm_audiofi_tclMsgChannelInformationRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgChannelInformationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELINFORMATIONRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgChannelInformationRelUpReg::~midw_ext_sxm_audiofi_tclMsgChannelInformationRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgAutoCompareGet::midw_ext_sxm_audiofi_tclMsgAutoCompareGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgAutoCompareGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_AUTOCOMPAREGET;
}


midw_ext_sxm_audiofi_tclMsgAutoCompareGet::~midw_ext_sxm_audiofi_tclMsgAutoCompareGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgAutoCompareStatus::midw_ext_sxm_audiofi_tclMsgAutoCompareStatus(const midw_ext_sxm_audiofi_tclMsgAutoCompareStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   CurrentTunerElemNr = coRef.CurrentTunerElemNr;
   TunerElemNr = coRef.TunerElemNr;
   SmartFavoriteList = coRef.SmartFavoriteList;
}
midw_ext_sxm_audiofi_tclMsgAutoCompareStatus& midw_ext_sxm_audiofi_tclMsgAutoCompareStatus::operator=(const midw_ext_sxm_audiofi_tclMsgAutoCompareStatus& coRef)
{
   if (this == &coRef) return *this;
   CurrentTunerElemNr = coRef.CurrentTunerElemNr;
   TunerElemNr = coRef.TunerElemNr;
   SmartFavoriteList = coRef.SmartFavoriteList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgAutoCompareStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SmartFavoriteList.size(); ++u32Idx)
         SmartFavoriteList[u32Idx].vDestroy();
   SmartFavoriteList.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgAutoCompareStatus::midw_ext_sxm_audiofi_tclMsgAutoCompareStatus()
:CurrentTunerElemNr(0)
,TunerElemNr(0)

 {}

tS32 midw_ext_sxm_audiofi_tclMsgAutoCompareStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_AUTOCOMPARESTATUS;
}


midw_ext_sxm_audiofi_tclMsgAutoCompareStatus::~midw_ext_sxm_audiofi_tclMsgAutoCompareStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgAutoCompareStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(SmartFavoriteList.size()*2);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgAutoCompareStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentTunerElemNr);
   (tVoid) (oIn >> TunerElemNr);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SmartFavoriteList.size(); ++u32Idx)
      {
         SmartFavoriteList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SmartFavoriteList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SmartFavoriteList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgAutoCompareStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentTunerElemNr);
   (tVoid) (oOut << TunerElemNr);
   (tVoid) (oOut << (tU32)SmartFavoriteList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SmartFavoriteList.size(); ++u32Idx)
         (tVoid) (oOut << SmartFavoriteList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgAutoCompareStatus::operator==(const midw_ext_sxm_audiofi_tclMsgAutoCompareStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentTunerElemNr == roRef.CurrentTunerElemNr);
   bResult = bResult && (TunerElemNr == roRef.TunerElemNr);
      bResult = bResult && (SmartFavoriteList.size() == roRef.SmartFavoriteList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SmartFavoriteList.size()); ++u32Idx)
            bResult = bResult && (SmartFavoriteList[u32Idx] == roRef.SmartFavoriteList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgAutoCompareUpReg::midw_ext_sxm_audiofi_tclMsgAutoCompareUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgAutoCompareUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_AUTOCOMPAREUPREG;
}


midw_ext_sxm_audiofi_tclMsgAutoCompareUpReg::~midw_ext_sxm_audiofi_tclMsgAutoCompareUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgAutoCompareRelUpReg::midw_ext_sxm_audiofi_tclMsgAutoCompareRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgAutoCompareRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_AUTOCOMPARERELUPREG;
}


midw_ext_sxm_audiofi_tclMsgAutoCompareRelUpReg::~midw_ext_sxm_audiofi_tclMsgAutoCompareRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSystemMessageGet::midw_ext_sxm_audiofi_tclMsgSystemMessageGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSystemMessageGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SYSTEMMESSAGEGET;
}


midw_ext_sxm_audiofi_tclMsgSystemMessageGet::~midw_ext_sxm_audiofi_tclMsgSystemMessageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSystemMessageStatus::midw_ext_sxm_audiofi_tclMsgSystemMessageStatus(const midw_ext_sxm_audiofi_tclMsgSystemMessageStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   SystemErrorType = coRef.SystemErrorType;
   CID = coRef.CID;
}
midw_ext_sxm_audiofi_tclMsgSystemMessageStatus& midw_ext_sxm_audiofi_tclMsgSystemMessageStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSystemMessageStatus& coRef)
{
   if (this == &coRef) return *this;
   SystemErrorType = coRef.SystemErrorType;
   CID = coRef.CID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSystemMessageStatus::midw_ext_sxm_audiofi_tclMsgSystemMessageStatus()
:SystemErrorType()
,CID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSystemMessageStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SYSTEMMESSAGESTATUS;
}


midw_ext_sxm_audiofi_tclMsgSystemMessageStatus::~midw_ext_sxm_audiofi_tclMsgSystemMessageStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSystemMessageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSystemMessageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemErrorType);
   (tVoid) (oIn >> CID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSystemMessageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemErrorType);
   (tVoid) (oOut << CID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSystemMessageStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSystemMessageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemErrorType == roRef.SystemErrorType);
   bResult = bResult && (CID == roRef.CID);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSystemMessageUpReg::midw_ext_sxm_audiofi_tclMsgSystemMessageUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSystemMessageUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SYSTEMMESSAGEUPREG;
}


midw_ext_sxm_audiofi_tclMsgSystemMessageUpReg::~midw_ext_sxm_audiofi_tclMsgSystemMessageUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSystemMessageRelUpReg::midw_ext_sxm_audiofi_tclMsgSystemMessageRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSystemMessageRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SYSTEMMESSAGERELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSystemMessageRelUpReg::~midw_ext_sxm_audiofi_tclMsgSystemMessageRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgChannelListStatusGet::midw_ext_sxm_audiofi_tclMsgChannelListStatusGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgChannelListStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELLISTSTATUSGET;
}


midw_ext_sxm_audiofi_tclMsgChannelListStatusGet::~midw_ext_sxm_audiofi_tclMsgChannelListStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus::midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus(const midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Availability = coRef.Availability;
}
midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus& midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus::operator=(const midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Availability = coRef.Availability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus::midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus()
:Availability(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELLISTSTATUSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus::~midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Availability);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Availability);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus::operator==(const midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Availability == roRef.Availability);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgChannelListStatusUpReg::midw_ext_sxm_audiofi_tclMsgChannelListStatusUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgChannelListStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELLISTSTATUSUPREG;
}


midw_ext_sxm_audiofi_tclMsgChannelListStatusUpReg::~midw_ext_sxm_audiofi_tclMsgChannelListStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgChannelListStatusRelUpReg::midw_ext_sxm_audiofi_tclMsgChannelListStatusRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgChannelListStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CHANNELLISTSTATUSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgChannelListStatusRelUpReg::~midw_ext_sxm_audiofi_tclMsgChannelListStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicGet::midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CURRENTCHANNELGRAPHICGET;
}


midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicGet::~midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus::midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus(const midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   SID = coRef.SID;
   Avail = coRef.Avail;
   RgbDataLen = coRef.RgbDataLen;
   RgbData = coRef.RgbData;
}
midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus& midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus::operator=(const midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus& coRef)
{
   if (this == &coRef) return *this;
   SID = coRef.SID;
   Avail = coRef.Avail;
   RgbDataLen = coRef.RgbDataLen;
   RgbData = coRef.RgbData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus::vDestroy()
{
   {
   RgbData.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus::midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus()
:SID(0)
,Avail(0)
,RgbDataLen(0)

 {}

tS32 midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CURRENTCHANNELGRAPHICSTATUS;
}


midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus::~midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11+ static_cast<tU32>(RgbData.size()*1);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SID);
   (tVoid) (oIn >> Avail);
   (tVoid) (oIn >> RgbDataLen);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      RgbData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RgbData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SID);
   (tVoid) (oOut << Avail);
   (tVoid) (oOut << RgbDataLen);
   (tVoid) (oOut << (tU32)RgbData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RgbData.size(); ++u32Idx)
         (tVoid) (oOut << RgbData[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus::operator==(const midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SID == roRef.SID);
   bResult = bResult && (Avail == roRef.Avail);
   bResult = bResult && (RgbDataLen == roRef.RgbDataLen);
      bResult = bResult && (RgbData.size() == roRef.RgbData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RgbData.size()); ++u32Idx)
            bResult = bResult && (RgbData[u32Idx] == roRef.RgbData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicUpReg::midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CURRENTCHANNELGRAPHICUPREG;
}


midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicUpReg::~midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicRelUpReg::midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CURRENTCHANNELGRAPHICRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicRelUpReg::~midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgCategoryListStatusGet::midw_ext_sxm_audiofi_tclMsgCategoryListStatusGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgCategoryListStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CATEGORYLISTSTATUSGET;
}


midw_ext_sxm_audiofi_tclMsgCategoryListStatusGet::~midw_ext_sxm_audiofi_tclMsgCategoryListStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus::midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus(const midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Availability = coRef.Availability;
   CategoryListContentUpdate = coRef.CategoryListContentUpdate;
}
midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus& midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus::operator=(const midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Availability = coRef.Availability;
   CategoryListContentUpdate = coRef.CategoryListContentUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus::midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus()
:Availability(0)
,CategoryListContentUpdate(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CATEGORYLISTSTATUSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus::~midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Availability);
   (tVoid) (oIn >> CategoryListContentUpdate);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Availability);
   (tVoid) (oOut << CategoryListContentUpdate);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus::operator==(const midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Availability == roRef.Availability);
   bResult = bResult && (CategoryListContentUpdate == roRef.CategoryListContentUpdate);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgCategoryListStatusUpReg::midw_ext_sxm_audiofi_tclMsgCategoryListStatusUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgCategoryListStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CATEGORYLISTSTATUSUPREG;
}


midw_ext_sxm_audiofi_tclMsgCategoryListStatusUpReg::~midw_ext_sxm_audiofi_tclMsgCategoryListStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgCategoryListStatusRelUpReg::midw_ext_sxm_audiofi_tclMsgCategoryListStatusRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgCategoryListStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_CATEGORYLISTSTATUSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgCategoryListStatusRelUpReg::~midw_ext_sxm_audiofi_tclMsgCategoryListStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgInstantReplayStatusGet::midw_ext_sxm_audiofi_tclMsgInstantReplayStatusGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgInstantReplayStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYSTATUSGET;
}


midw_ext_sxm_audiofi_tclMsgInstantReplayStatusGet::~midw_ext_sxm_audiofi_tclMsgInstantReplayStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus::midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus(const midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   InstantReplayStatus = coRef.InstantReplayStatus;
}
midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus& midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus::operator=(const midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   InstantReplayStatus = coRef.InstantReplayStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus::midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus()
:InstantReplayStatus()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYSTATUSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus::~midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> InstantReplayStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << InstantReplayStatus);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus::operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (InstantReplayStatus == roRef.InstantReplayStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgInstantReplayStatusUpReg::midw_ext_sxm_audiofi_tclMsgInstantReplayStatusUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgInstantReplayStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYSTATUSUPREG;
}


midw_ext_sxm_audiofi_tclMsgInstantReplayStatusUpReg::~midw_ext_sxm_audiofi_tclMsgInstantReplayStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgInstantReplayStatusRelUpReg::midw_ext_sxm_audiofi_tclMsgInstantReplayStatusRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgInstantReplayStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYSTATUSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgInstantReplayStatusRelUpReg::~midw_ext_sxm_audiofi_tclMsgInstantReplayStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgInstantReplayModeGet::midw_ext_sxm_audiofi_tclMsgInstantReplayModeGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgInstantReplayModeGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYMODEGET;
}


midw_ext_sxm_audiofi_tclMsgInstantReplayModeGet::~midw_ext_sxm_audiofi_tclMsgInstantReplayModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus::midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus(const midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   IsIRModeActive = coRef.IsIRModeActive;
}
midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus& midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus::operator=(const midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus& coRef)
{
   if (this == &coRef) return *this;
   IsIRModeActive = coRef.IsIRModeActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus::midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus()
:IsIRModeActive(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYMODESTATUS;
}


midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus::~midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IsIRModeActive);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IsIRModeActive);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus::operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IsIRModeActive == roRef.IsIRModeActive);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgInstantReplayModeUpReg::midw_ext_sxm_audiofi_tclMsgInstantReplayModeUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgInstantReplayModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYMODEUPREG;
}


midw_ext_sxm_audiofi_tclMsgInstantReplayModeUpReg::~midw_ext_sxm_audiofi_tclMsgInstantReplayModeUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgInstantReplayModeRelUpReg::midw_ext_sxm_audiofi_tclMsgInstantReplayModeRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgInstantReplayModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_INSTANTREPLAYMODERELUPREG;
}


midw_ext_sxm_audiofi_tclMsgInstantReplayModeRelUpReg::~midw_ext_sxm_audiofi_tclMsgInstantReplayModeRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusGet::midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTENTSTATUSGET;
}


midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusGet::~midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus::midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus(const midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   TuneScanStatus = coRef.TuneScanStatus;
}
midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus& midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus::operator=(const midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   TuneScanStatus = coRef.TuneScanStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus::midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus()
:TuneScanStatus()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTENTSTATUSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus::~midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TuneScanStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TuneScanStatus);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus::operator==(const midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TuneScanStatus == roRef.TuneScanStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusUpReg::midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTENTSTATUSUPREG;
}


midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusUpReg::~midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusRelUpReg::midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TUNESCANCONTENTSTATUSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusRelUpReg::~midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateGet::midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETCHANNELUPDATEGET;
}


midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateGet::~midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus::midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus(const midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   PresetIndex = coRef.PresetIndex;
   PresetBand = coRef.PresetBand;
   ChannelInfo = coRef.ChannelInfo;
   LinearPresetIndex = coRef.LinearPresetIndex;
}
midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus& midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus::operator=(const midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   PresetIndex = coRef.PresetIndex;
   PresetBand = coRef.PresetBand;
   ChannelInfo = coRef.ChannelInfo;
   LinearPresetIndex = coRef.LinearPresetIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus::vDestroy()
{
   ChannelInfo.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus::midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus()
:PresetIndex(0)
,PresetBand(0)
,ChannelInfo()
,LinearPresetIndex(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETCHANNELUPDATESTATUS;
}


midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus::~midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+ChannelInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetIndex);
   (tVoid) (oIn >> PresetBand);
   (tVoid) (oIn >> ChannelInfo);
   (tVoid) (oIn >> LinearPresetIndex);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetIndex);
   (tVoid) (oOut << PresetBand);
   (tVoid) (oOut << ChannelInfo);
   (tVoid) (oOut << LinearPresetIndex);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus::operator==(const midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetIndex == roRef.PresetIndex);
   bResult = bResult && (PresetBand == roRef.PresetBand);
   bResult = bResult && (ChannelInfo == roRef.ChannelInfo);
   bResult = bResult && (LinearPresetIndex == roRef.LinearPresetIndex);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateUpReg::midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETCHANNELUPDATEUPREG;
}


midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateUpReg::~midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateRelUpReg::midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETCHANNELUPDATERELUPREG;
}


midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateRelUpReg::~midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusGet::midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET;
}


midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusGet::~midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   List = coRef.List;
}
midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus& midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   List = coRef.List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < List.size(); ++u32Idx)
         List[u32Idx].vDestroy();
   List.clear();
   }
}

midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus()

 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus::~midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(List.size()*2);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < List.size(); ++u32Idx)
      {
         List[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      List.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> List[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)List.size());
   {
      for (tU32 u32Idx = 0; u32Idx < List.size(); ++u32Idx)
         (tVoid) (oOut << List[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (List.size() == roRef.List.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < List.size()); ++u32Idx)
            bResult = bResult && (List[u32Idx] == roRef.List[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusUpReg::midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusUpReg::~midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusRelUpReg::midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusRelUpReg::~midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusGet::midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICEANTENNASTATUSGET;
}


midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusGet::~midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus::midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   IsAntennaConnected = coRef.IsAntennaConnected;
}
midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus& midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   IsAntennaConnected = coRef.IsAntennaConnected;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus::midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus()
:IsAntennaConnected(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICEANTENNASTATUSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus::~midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IsAntennaConnected);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IsAntennaConnected);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IsAntennaConnected == roRef.IsAntennaConnected);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusUpReg::midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICEANTENNASTATUSUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusUpReg::~midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusRelUpReg::midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDATASERVICEANTENNASTATUSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusRelUpReg::~midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgPresetListUpdateGet::midw_ext_sxm_audiofi_tclMsgPresetListUpdateGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgPresetListUpdateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETLISTUPDATEGET;
}


midw_ext_sxm_audiofi_tclMsgPresetListUpdateGet::~midw_ext_sxm_audiofi_tclMsgPresetListUpdateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus::midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus(const midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ListUpdate = coRef.ListUpdate;
}
midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus& midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus::operator=(const midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   ListUpdate = coRef.ListUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus::midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus()
:ListUpdate(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETLISTUPDATESTATUS;
}


midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus::~midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListUpdate);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListUpdate);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus::operator==(const midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListUpdate == roRef.ListUpdate);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgPresetListUpdateUpReg::midw_ext_sxm_audiofi_tclMsgPresetListUpdateUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgPresetListUpdateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETLISTUPDATEUPREG;
}


midw_ext_sxm_audiofi_tclMsgPresetListUpdateUpReg::~midw_ext_sxm_audiofi_tclMsgPresetListUpdateUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgPresetListUpdateRelUpReg::midw_ext_sxm_audiofi_tclMsgPresetListUpdateRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgPresetListUpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_PRESETLISTUPDATERELUPREG;
}


midw_ext_sxm_audiofi_tclMsgPresetListUpdateRelUpReg::~midw_ext_sxm_audiofi_tclMsgPresetListUpdateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus::midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus(const midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
}
midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus& midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus::operator=(const midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus::vDestroy()
{
   Data.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus::midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus()
:Data()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGTESTMODEDATASTATUS;
}


midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus::~midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Data.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus::operator==(const midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgDiagTestModeDataUpReg::midw_ext_sxm_audiofi_tclMsgDiagTestModeDataUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagTestModeDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGTESTMODEDATAUPREG;
}


midw_ext_sxm_audiofi_tclMsgDiagTestModeDataUpReg::~midw_ext_sxm_audiofi_tclMsgDiagTestModeDataUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgDiagTestModeDataRelUpReg::midw_ext_sxm_audiofi_tclMsgDiagTestModeDataRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagTestModeDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGTESTMODEDATARELUPREG;
}


midw_ext_sxm_audiofi_tclMsgDiagTestModeDataRelUpReg::~midw_ext_sxm_audiofi_tclMsgDiagTestModeDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus::midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus(const midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
}
midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus& midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus::operator=(const midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus::vDestroy()
{
   Data.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus::midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus()
:Data()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGSXMVERSIONSTATUS;
}


midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus::~midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Data.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus::operator==(const midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgDiagSxmVersionUpReg::midw_ext_sxm_audiofi_tclMsgDiagSxmVersionUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagSxmVersionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGSXMVERSIONUPREG;
}


midw_ext_sxm_audiofi_tclMsgDiagSxmVersionUpReg::~midw_ext_sxm_audiofi_tclMsgDiagSxmVersionUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgDiagSxmVersionRelUpReg::midw_ext_sxm_audiofi_tclMsgDiagSxmVersionRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgDiagSxmVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_DIAGSXMVERSIONRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgDiagSxmVersionRelUpReg::~midw_ext_sxm_audiofi_tclMsgDiagSxmVersionRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityGet::midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGSIGNALQUALITYGET;
}


midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityGet::~midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus::midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus(const midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   SignalQualityStatus = coRef.SignalQualityStatus;
}
midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus& midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus& coRef)
{
   if (this == &coRef) return *this;
   SignalQualityStatus = coRef.SignalQualityStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus::midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus()
:SignalQualityStatus()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGSIGNALQUALITYSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus::~midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SignalQualityStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SignalQualityStatus);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SignalQualityStatus == roRef.SignalQualityStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityUpReg::midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGSIGNALQUALITYUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityUpReg::~midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityRelUpReg::midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGSIGNALQUALITYRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityRelUpReg::~midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateGet::midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGANTENNASTATEGET;
}


midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateGet::~midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus::midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus(const midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   AntennaStatus = coRef.AntennaStatus;
}
midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus& midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus& coRef)
{
   if (this == &coRef) return *this;
   AntennaStatus = coRef.AntennaStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus::midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus()
:AntennaStatus()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGANTENNASTATESTATUS;
}


midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus::~midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AntennaStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AntennaStatus);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AntennaStatus == roRef.AntennaStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateUpReg::midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGANTENNASTATEUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateUpReg::~midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateRelUpReg::midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMDIAGANTENNASTATERELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateRelUpReg::~midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmRadioIdGet::midw_ext_sxm_audiofi_tclMsgSxmRadioIdGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmRadioIdGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMRADIOIDGET;
}


midw_ext_sxm_audiofi_tclMsgSxmRadioIdGet::~midw_ext_sxm_audiofi_tclMsgSxmRadioIdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus::midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus(const midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   RadioId = coRef.RadioId;
}
midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus& midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus& coRef)
{
   if (this == &coRef) return *this;
   RadioId = coRef.RadioId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus::vDestroy()
{
   RadioId.vDestroy();
}

midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus::midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus()
:RadioId()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMRADIOIDSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus::~midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+RadioId.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RadioId);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RadioId);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RadioId == roRef.RadioId);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmRadioIdUpReg::midw_ext_sxm_audiofi_tclMsgSxmRadioIdUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmRadioIdUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMRADIOIDUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmRadioIdUpReg::~midw_ext_sxm_audiofi_tclMsgSxmRadioIdUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmRadioIdRelUpReg::midw_ext_sxm_audiofi_tclMsgSxmRadioIdRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmRadioIdRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMRADIOIDRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmRadioIdRelUpReg::~midw_ext_sxm_audiofi_tclMsgSxmRadioIdRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus::midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus(const midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
}
midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus& midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus::vDestroy()
{
   Data.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus::midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus()
:Data()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMSMSDBVERSIONSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus::~midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Data.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsUpReg::midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMSMSDBVERSIONSUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsUpReg::~midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsRelUpReg::midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMSMSDBVERSIONSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsRelUpReg::~midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus::midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus(const midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
}
midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus& midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus::midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus()
:Data()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMAUDIOSUBINFOSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus::~midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoUpReg::midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMAUDIOSUBINFOUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoUpReg::~midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoRelUpReg::midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMAUDIOSUBINFORELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoRelUpReg::~midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus::midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus(const midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
}
midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus& midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus::midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus()
:Data()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMMODULESUBINFOSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus::~midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoUpReg::midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMMODULESUBINFOUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoUpReg::~midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoRelUpReg::midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SXMMODULESUBINFORELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoRelUpReg::~midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressGet::midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADPROGRESSGET;
}


midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressGet::~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus::midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   bActive = coRef.bActive;
   Progress = coRef.Progress;
}
midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus& midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus::operator=(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus& coRef)
{
   if (this == &coRef) return *this;
   bActive = coRef.bActive;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus::midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus()
:bActive(0)
,Progress(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADPROGRESSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus::~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bActive);
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bActive);
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus::operator==(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bActive == roRef.bActive);
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressUpReg::midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADPROGRESSUPREG;
}


midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressUpReg::~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressRelUpReg::midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_FIRMWAREDOWNLOADPROGRESSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressRelUpReg::~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoGet::midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_FAVORITECONTENTALERTINFOGET;
}


midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoGet::~midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus::midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus(const midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   AlertInfo = coRef.AlertInfo;
}
midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus& midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus::operator=(const midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   AlertInfo = coRef.AlertInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus::vDestroy()
{
   AlertInfo.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus::midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus()
:AlertInfo()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_FAVORITECONTENTALERTINFOSTATUS;
}


midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus::~midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AlertInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AlertInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AlertInfo);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus::operator==(const midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AlertInfo == roRef.AlertInfo);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoUpReg::midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_FAVORITECONTENTALERTINFOUPREG;
}


midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoUpReg::~midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoRelUpReg::midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_FAVORITECONTENTALERTINFORELUPREG;
}


midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoRelUpReg::~midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateGet::midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_ALERTNOTICELISTUPDATEGET;
}


midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateGet::~midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus::midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus(const midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FavoriteType = coRef.FavoriteType;
   UpdateAvailable = coRef.UpdateAvailable;
}
midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus& midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus::operator=(const midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   FavoriteType = coRef.FavoriteType;
   UpdateAvailable = coRef.UpdateAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus::midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus()
:FavoriteType()
,UpdateAvailable(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_ALERTNOTICELISTUPDATESTATUS;
}


midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus::~midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FavoriteType);
   (tVoid) (oIn >> UpdateAvailable);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FavoriteType);
   (tVoid) (oOut << UpdateAvailable);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus::operator==(const midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FavoriteType == roRef.FavoriteType);
   bResult = bResult && (UpdateAvailable == roRef.UpdateAvailable);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateUpReg::midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_ALERTNOTICELISTUPDATEUPREG;
}


midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateUpReg::~midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateRelUpReg::midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_ALERTNOTICELISTUPDATERELUPREG;
}


midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateRelUpReg::~midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusGet::midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSERVICESTATUSGET;
}


midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusGet::~midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus::midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus(const midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus& midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus::midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus()
:ServiceStatus()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSERVICESTATUSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus::~midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusUpReg::midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSERVICESTATUSUPREG;
}


midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusUpReg::~midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusRelUpReg::midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWSERVICESTATUSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusRelUpReg::~midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusGet::midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINSTATUSGET;
}


midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusGet::~midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus::midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   BulletinStatus = coRef.BulletinStatus;
   BulletinID = coRef.BulletinID;
}
midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus& midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   BulletinStatus = coRef.BulletinStatus;
   BulletinID = coRef.BulletinID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus::midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus()
:BulletinStatus()
,BulletinID(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINSTATUSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus::~midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BulletinStatus);
   (tVoid) (oIn >> BulletinID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BulletinStatus);
   (tVoid) (oOut << BulletinID);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BulletinStatus == roRef.BulletinStatus);
   bResult = bResult && (BulletinID == roRef.BulletinID);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusUpReg::midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINSTATUSUPREG;
}


midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusUpReg::~midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusRelUpReg::midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWBULLETINSTATUSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusRelUpReg::~midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetClockParamsSet::midw_ext_sxm_audiofi_tclMsgSetClockParamsSet(const midw_ext_sxm_audiofi_tclMsgSetClockParamsSet& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   TimeZone = coRef.TimeZone;
   DST = coRef.DST;
   LocalTimeDate = coRef.LocalTimeDate;
   Result = coRef.Result;
}
midw_ext_sxm_audiofi_tclMsgSetClockParamsSet& midw_ext_sxm_audiofi_tclMsgSetClockParamsSet::operator=(const midw_ext_sxm_audiofi_tclMsgSetClockParamsSet& coRef)
{
   if (this == &coRef) return *this;
   TimeZone = coRef.TimeZone;
   DST = coRef.DST;
   LocalTimeDate = coRef.LocalTimeDate;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSetClockParamsSet::vDestroy()
{
   TimeZone.vDestroy();
   LocalTimeDate.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgSetClockParamsSet::midw_ext_sxm_audiofi_tclMsgSetClockParamsSet()
:TimeZone()
,DST(0)
,LocalTimeDate()
,Result(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetClockParamsSet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCLOCKPARAMSSET;
}


midw_ext_sxm_audiofi_tclMsgSetClockParamsSet::~midw_ext_sxm_audiofi_tclMsgSetClockParamsSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSetClockParamsSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+TimeZone.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetClockParamsSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TimeZone);
   (tVoid) (oIn >> DST);
   (tVoid) (oIn >> LocalTimeDate);
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetClockParamsSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TimeZone);
   (tVoid) (oOut << DST);
   (tVoid) (oOut << LocalTimeDate);
   (tVoid) (oOut << Result);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetClockParamsSet::operator==(const midw_ext_sxm_audiofi_tclMsgSetClockParamsSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TimeZone == roRef.TimeZone);
   bResult = bResult && (DST == roRef.DST);
   bResult = bResult && (LocalTimeDate == roRef.LocalTimeDate);
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus::midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus(const midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   TimeZone = coRef.TimeZone;
   DST = coRef.DST;
   LocalTimeDate = coRef.LocalTimeDate;
   Result = coRef.Result;
}
midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus& midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus& coRef)
{
   if (this == &coRef) return *this;
   TimeZone = coRef.TimeZone;
   DST = coRef.DST;
   LocalTimeDate = coRef.LocalTimeDate;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus::vDestroy()
{
   TimeZone.vDestroy();
   LocalTimeDate.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus::midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus()
:TimeZone()
,DST(0)
,LocalTimeDate()
,Result(0)
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCLOCKPARAMSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus::~midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+TimeZone.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TimeZone);
   (tVoid) (oIn >> DST);
   (tVoid) (oIn >> LocalTimeDate);
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TimeZone);
   (tVoid) (oOut << DST);
   (tVoid) (oOut << LocalTimeDate);
   (tVoid) (oOut << Result);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TimeZone == roRef.TimeZone);
   bResult = bResult && (DST == roRef.DST);
   bResult = bResult && (LocalTimeDate == roRef.LocalTimeDate);
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSetClockParamsUpReg::midw_ext_sxm_audiofi_tclMsgSetClockParamsUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetClockParamsUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCLOCKPARAMSUPREG;
}


midw_ext_sxm_audiofi_tclMsgSetClockParamsUpReg::~midw_ext_sxm_audiofi_tclMsgSetClockParamsUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSetClockParamsRelUpReg::midw_ext_sxm_audiofi_tclMsgSetClockParamsRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSetClockParamsRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SETCLOCKPARAMSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSetClockParamsRelUpReg::~midw_ext_sxm_audiofi_tclMsgSetClockParamsRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusGet::midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_SERVICESTATUSGET;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusGet::~midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus::midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus(const midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus& midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus::midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus()
:ServiceStatus()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_SERVICESTATUSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus::~midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusUpReg::midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_SERVICESTATUSUPREG;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusUpReg::~midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusRelUpReg::midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_SERVICESTATUSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusRelUpReg::~midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationGet::midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_GAMEEVENTNOTIFICATIONGET;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationGet::~midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus::midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus(const midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ProgramStatus = coRef.ProgramStatus;
   GameInfo = coRef.GameInfo;
}
midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus& midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus& coRef)
{
   if (this == &coRef) return *this;
   ProgramStatus = coRef.ProgramStatus;
   GameInfo = coRef.GameInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus::vDestroy()
{
   GameInfo.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus::midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus()
:ProgramStatus()
,GameInfo()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_GAMEEVENTNOTIFICATIONSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus::~midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+GameInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProgramStatus);
   (tVoid) (oIn >> GameInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProgramStatus);
   (tVoid) (oOut << GameInfo);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProgramStatus == roRef.ProgramStatus);
   bResult = bResult && (GameInfo == roRef.GameInfo);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationUpReg::midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_GAMEEVENTNOTIFICATIONUPREG;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationUpReg::~midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationRelUpReg::midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_GAMEEVENTNOTIFICATIONRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationRelUpReg::~midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationGet::midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_FLASHEVENTNOTIFICATIONGET;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationGet::~midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus::midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus(const midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FlashEventID = coRef.FlashEventID;
   GameInfo = coRef.GameInfo;
   FlashEventStatus = coRef.FlashEventStatus;
}
midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus& midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus& coRef)
{
   if (this == &coRef) return *this;
   FlashEventID = coRef.FlashEventID;
   GameInfo = coRef.GameInfo;
   FlashEventStatus = coRef.FlashEventStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus::vDestroy()
{
   GameInfo.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus::midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus()
:FlashEventID(0)
,GameInfo()
,FlashEventStatus()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_FLASHEVENTNOTIFICATIONSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus::~midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+GameInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FlashEventID);
   (tVoid) (oIn >> GameInfo);
   (tVoid) (oIn >> FlashEventStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FlashEventID);
   (tVoid) (oOut << GameInfo);
   (tVoid) (oOut << FlashEventStatus);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FlashEventID == roRef.FlashEventID);
   bResult = bResult && (GameInfo == roRef.GameInfo);
   bResult = bResult && (FlashEventStatus == roRef.FlashEventStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationUpReg::midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_FLASHEVENTNOTIFICATIONUPREG;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationUpReg::~midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationRelUpReg::midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_FLASHEVENTNOTIFICATIONRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationRelUpReg::~midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusGet::midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWPLAYBACKSTATUSGET;
}


midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusGet::~midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus::midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus(const midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FlashEventPlayState = coRef.FlashEventPlayState;
}
midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus& midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus::operator=(const midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   FlashEventPlayState = coRef.FlashEventPlayState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus::midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus()
:FlashEventPlayState()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWPLAYBACKSTATUSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus::~midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FlashEventPlayState);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FlashEventPlayState);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus::operator==(const midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FlashEventPlayState == roRef.FlashEventPlayState);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusUpReg::midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWPLAYBACKSTATUSUPREG;
}


midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusUpReg::~midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusRelUpReg::midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_TWNOWPLAYBACKSTATUSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusRelUpReg::~midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusGet::midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_PLAYBACKSTATUSGET;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusGet::~midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus::midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus(const midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   FlashEventPlayState = coRef.FlashEventPlayState;
}
midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus& midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus::operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   FlashEventPlayState = coRef.FlashEventPlayState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus::midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus()
:FlashEventPlayState()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_PLAYBACKSTATUSSTATUS;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus::~midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus()
{}

tU32 midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FlashEventPlayState);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FlashEventPlayState);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus::operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FlashEventPlayState == roRef.FlashEventPlayState);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusUpReg::midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_PLAYBACKSTATUSUPREG;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusUpReg::~midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusRelUpReg::midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_SPORTSFLASH_PLAYBACKSTATUSRELUPREG;
}


midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusRelUpReg::~midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoGet::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoGet()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSEINFOGET;
}


midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoGet::~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus& coRef)
   : midw_ext_sxm_audiofi_tclMsgBaseMessage(coRef)
{
   ChannelInfo = coRef.ChannelInfo;
}
midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus::operator=(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   ChannelInfo = coRef.ChannelInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus::vDestroy()
{
   ChannelInfo.vDestroy(); 
}

midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus()
:ChannelInfo()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSEINFOSTATUS;
}


midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus::~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ChannelInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelInfo);
   return oOut;
}

tBool midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus::operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelInfo == roRef.ChannelInfo);
   return bResult;
}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoUpReg::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSEINFOUPREG;
}


midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoUpReg::~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoUpReg()
{}

//=============================================================================

midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoRelUpReg::midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoRelUpReg()
 {}

tS32 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_audiofi_tclToken::EN_MSG_RAPIDCHANNELBROWSEINFORELUPREG;
}


midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoRelUpReg::~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoRelUpReg()
{}

