/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_AGWFITYPES_HEADER
#define MIDW_EXT_SXM_AGWFITYPES_HEADER


class midw_ext_sxm_agwfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_AGW_FI message types

fi_tclMessageBase* midw_ext_sxm_agwfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_agwfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_agwfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart& operator=(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart& coRef);
   midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_SXMSharedMemoryDescription, std::allocator<midw_ext_fi_tcl_SXMSharedMemoryDescription> > SharedMemories;
   virtual ~midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult& operator=(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult& coRef);
   midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_SXMSharedMemoryDescription, std::allocator<midw_ext_fi_tcl_SXMSharedMemoryDescription> > SharedMemories;
   virtual ~midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart();

   virtual ~midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult& operator=(const midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult& coRef);
   midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult(const midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   std::vector<midw_ext_fi_tcl_SXMShape, std::allocator<midw_ext_fi_tcl_SXMShape> > Shapes;
   virtual ~midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart();

   virtual ~midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult& operator=(const midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult& coRef);
   midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult(const midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   std::vector<midw_ext_fi_tcl_SXMShape, std::allocator<midw_ext_fi_tcl_SXMShape> > Shapes;
   virtual ~midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart();

   virtual ~midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult& operator=(const midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult& coRef);
   midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult(const midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   std::vector<midw_ext_fi_tcl_SXMShape, std::allocator<midw_ext_fi_tcl_SXMShape> > Shapes;
   virtual ~midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart& operator=(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart& coRef);
   midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SXMTileType TileType;
   virtual ~midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult& operator=(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult& coRef);
   midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SXMTileType TileType;
   tBool AccessGranted;
   tU32 UpdateCounter;
   std::vector<midw_ext_fi_tcl_SXMSharedMemoryTile, std::allocator<midw_ext_fi_tcl_SXMSharedMemoryTile> > TileList;
   virtual ~midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& operator=(const midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& coRef);
   midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart(const midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SXMTileType TileType;
   virtual ~midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodResult : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodResult();

   virtual ~midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodResult();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgNowradDataUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgNowradDataUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgNowradDataUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgNowradDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgNowradDataRelUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgNowradDataRelUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgNowradDataRelUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgNowradDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgNowradDataGet : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgNowradDataGet();

   virtual ~midw_ext_sxm_agwfi_tclMsgNowradDataGet();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgNowradDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgNowradDataStatus : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgNowradDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgNowradDataStatus& operator=(const midw_ext_sxm_agwfi_tclMsgNowradDataStatus& coRef);
   midw_ext_sxm_agwfi_tclMsgNowradDataStatus(const midw_ext_sxm_agwfi_tclMsgNowradDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   virtual ~midw_ext_sxm_agwfi_tclMsgNowradDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgNowradDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataRelUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataRelUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataRelUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataGet : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataGet();

   virtual ~midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataGet();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus& operator=(const midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus& coRef);
   midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus(const midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   virtual ~midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindDirectionDataUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindDirectionDataUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgWindDirectionDataUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindDirectionDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindDirectionDataRelUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindDirectionDataRelUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgWindDirectionDataRelUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindDirectionDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindDirectionDataGet : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindDirectionDataGet();

   virtual ~midw_ext_sxm_agwfi_tclMsgWindDirectionDataGet();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindDirectionDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus& operator=(const midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus& coRef);
   midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus(const midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   virtual ~midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgSurfaceDataUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgSurfaceDataUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgSurfaceDataUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgSurfaceDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgSurfaceDataRelUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgSurfaceDataRelUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgSurfaceDataRelUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgSurfaceDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgSurfaceDataGet : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgSurfaceDataGet();

   virtual ~midw_ext_sxm_agwfi_tclMsgSurfaceDataGet();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgSurfaceDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus& operator=(const midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus& coRef);
   midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus(const midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   virtual ~midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgStormAttributesDataUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgStormAttributesDataUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgStormAttributesDataUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgStormAttributesDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgStormAttributesDataRelUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgStormAttributesDataRelUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgStormAttributesDataRelUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgStormAttributesDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgStormAttributesDataGet : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgStormAttributesDataGet();

   virtual ~midw_ext_sxm_agwfi_tclMsgStormAttributesDataGet();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgStormAttributesDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus& operator=(const midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus& coRef);
   midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus(const midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   virtual ~midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgStormTrackDataUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgStormTrackDataUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgStormTrackDataUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgStormTrackDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgStormTrackDataRelUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgStormTrackDataRelUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgStormTrackDataRelUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgStormTrackDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgStormTrackDataGet : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgStormTrackDataGet();

   virtual ~midw_ext_sxm_agwfi_tclMsgStormTrackDataGet();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgStormTrackDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus& operator=(const midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus& coRef);
   midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus(const midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   virtual ~midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindDataUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindDataUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgWindDataUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindDataRelUpReg : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindDataRelUpReg();

   virtual ~midw_ext_sxm_agwfi_tclMsgWindDataRelUpReg();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindDataGet : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindDataGet();

   virtual ~midw_ext_sxm_agwfi_tclMsgWindDataGet();

   inline tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_agwfi_tclMsgWindDataStatus : public midw_ext_sxm_agwfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_agwfi_tclMsgWindDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_agwfi_tclMsgWindDataStatus& operator=(const midw_ext_sxm_agwfi_tclMsgWindDataStatus& coRef);
   midw_ext_sxm_agwfi_tclMsgWindDataStatus(const midw_ext_sxm_agwfi_tclMsgWindDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   virtual ~midw_ext_sxm_agwfi_tclMsgWindDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_agwfi_tclMsgWindDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
