/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AGWFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AGWFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AGWFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_AGW_FI message types

fi_tclMessageBase* midw_ext_sxm_agwfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSURFACEDATAMETHODSTART:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODSTART:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODSTART:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODSTART:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODSTART:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodResult;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATAUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgNowradDataUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATARELUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgNowradDataRelUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATAGET:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgNowradDataGet;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATASTATUS:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgNowradDataStatus;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATAUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATARELUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataRelUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATAGET:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataGet;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATASTATUS:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATAUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindDirectionDataUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATARELUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindDirectionDataRelUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATAGET:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindDirectionDataGet;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATASTATUS:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATAUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgSurfaceDataUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATARELUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgSurfaceDataRelUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATAGET:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgSurfaceDataGet;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATASTATUS:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATAUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgStormAttributesDataUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATARELUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgStormAttributesDataRelUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATAGET:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgStormAttributesDataGet;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATAUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgStormTrackDataUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATARELUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgStormTrackDataRelUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATAGET:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgStormTrackDataGet;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATASTATUS:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATAUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindDataUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATARELUPREG:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindDataRelUpReg;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATAGET:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindDataGet;

      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATASTATUS:
         return OSAL_NEW midw_ext_sxm_agwfi_tclMsgWindDataStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_agwfifi messages

// common functions

tU16 midw_ext_sxm_agwfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_AGWFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_agwfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_agwfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_agwfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_agwfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_agwfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart::midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   SharedMemories = coRef.SharedMemories;
}
midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart& midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart::operator=(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SharedMemories = coRef.SharedMemories;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
         SharedMemories[u32Idx].vDestroy();
   SharedMemories.clear();
   }
}

midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart::midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart()

 {}

tS32 midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART;
}


midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart::~midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SharedMemories.size(); ++u32ListIdx)
      u32DynamicSize += SharedMemories[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
      {
         SharedMemories[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SharedMemories.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SharedMemories[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SharedMemories.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
         (tVoid) (oOut << SharedMemories[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart::operator==(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SharedMemories.size() == roRef.SharedMemories.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SharedMemories.size()); ++u32Idx)
            bResult = bResult && (SharedMemories[u32Idx] == roRef.SharedMemories[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult::midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   SharedMemories = coRef.SharedMemories;
}
midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult& midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult::operator=(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SharedMemories = coRef.SharedMemories;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
         SharedMemories[u32Idx].vDestroy();
   SharedMemories.clear();
   }
}

midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult::midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult()

 {}

tS32 midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT;
}


midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult::~midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SharedMemories.size(); ++u32ListIdx)
      u32DynamicSize += SharedMemories[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
      {
         SharedMemories[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SharedMemories.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SharedMemories[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SharedMemories.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
         (tVoid) (oOut << SharedMemories[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult::operator==(const midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SharedMemories.size() == roRef.SharedMemories.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SharedMemories.size()); ++u32Idx)
            bResult = bResult && (SharedMemories[u32Idx] == roRef.SharedMemories[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart::midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSURFACEDATAMETHODSTART;
}


midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart::~midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult::midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult(const midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
}
midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult& midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult::operator=(const midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         Shapes[u32Idx].vDestroy();
   Shapes.clear();
   }
}

midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult::midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult()
:UpdateCounter(0)

 {}

tS32 midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT;
}


midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult::~midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Shapes.size(); ++u32ListIdx)
      u32DynamicSize += Shapes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult::oRead(fi_tclInContext& oIn)
{
   if (1 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> UpdateCounter);
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
      {
         Shapes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Shapes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Shapes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (1 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << UpdateCounter);
   }
   (tVoid) (oOut << (tU32)Shapes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         (tVoid) (oOut << Shapes[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult::operator==(const midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
      bResult = bResult && (Shapes.size() == roRef.Shapes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Shapes.size()); ++u32Idx)
            bResult = bResult && (Shapes[u32Idx] == roRef.Shapes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart::midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODSTART;
}


midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart::~midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult::midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult(const midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
}
midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult& midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult::operator=(const midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         Shapes[u32Idx].vDestroy();
   Shapes.clear();
   }
}

midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult::midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult()
:UpdateCounter(0)

 {}

tS32 midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT;
}


midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult::~midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Shapes.size(); ++u32ListIdx)
      u32DynamicSize += Shapes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult::oRead(fi_tclInContext& oIn)
{
   if (1 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> UpdateCounter);
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
      {
         Shapes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Shapes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Shapes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (1 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << UpdateCounter);
   }
   (tVoid) (oOut << (tU32)Shapes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         (tVoid) (oOut << Shapes[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult::operator==(const midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
      bResult = bResult && (Shapes.size() == roRef.Shapes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Shapes.size()); ++u32Idx)
            bResult = bResult && (Shapes[u32Idx] == roRef.Shapes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart::midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODSTART;
}


midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart::~midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult::midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult(const midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
}
midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult& midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult::operator=(const midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   Shapes = coRef.Shapes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         Shapes[u32Idx].vDestroy();
   Shapes.clear();
   }
}

midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult::midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult()
:UpdateCounter(0)

 {}

tS32 midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT;
}


midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult::~midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Shapes.size(); ++u32ListIdx)
      u32DynamicSize += Shapes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult::oRead(fi_tclInContext& oIn)
{
   if (1 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> UpdateCounter);
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
      {
         Shapes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Shapes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Shapes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (1 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << UpdateCounter);
   }
   (tVoid) (oOut << (tU32)Shapes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Shapes.size(); ++u32Idx)
         (tVoid) (oOut << Shapes[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult::operator==(const midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
      bResult = bResult && (Shapes.size() == roRef.Shapes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Shapes.size()); ++u32Idx)
            bResult = bResult && (Shapes[u32Idx] == roRef.Shapes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart::midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   TileType = coRef.TileType;
}
midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart& midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart::operator=(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TileType = coRef.TileType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart::midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart()
:TileType()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODSTART;
}


midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart::~midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart()
{}

tU32 midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TileType);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TileType);
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart::operator==(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TileType == roRef.TileType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult::midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   TileType = coRef.TileType;
   AccessGranted = coRef.AccessGranted;
   UpdateCounter = coRef.UpdateCounter;
   TileList = coRef.TileList;
}
midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult& midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult::operator=(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TileType = coRef.TileType;
   AccessGranted = coRef.AccessGranted;
   UpdateCounter = coRef.UpdateCounter;
   TileList = coRef.TileList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TileList.size(); ++u32Idx)
         TileList[u32Idx].vDestroy();
   TileList.clear();
   }
}

midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult::midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult()
:TileType()
,AccessGranted(0)
,UpdateCounter(0)

 {}

tS32 midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODRESULT;
}


midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult::~midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+5+ static_cast<tU32>(TileList.size()*44);
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TileType);
   if (2 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> AccessGranted);
   }
   if (2 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> UpdateCounter);
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TileList.size(); ++u32Idx)
      {
         TileList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TileList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TileList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TileType);
   if (2 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << AccessGranted);
   }
   if (2 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << UpdateCounter);
   }
   (tVoid) (oOut << (tU32)TileList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TileList.size(); ++u32Idx)
         (tVoid) (oOut << TileList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult::operator==(const midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TileType == roRef.TileType);
   bResult = bResult && (AccessGranted == roRef.AccessGranted);
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
      bResult = bResult && (TileList.size() == roRef.TileList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TileList.size()); ++u32Idx)
            bResult = bResult && (TileList[u32Idx] == roRef.TileList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart(const midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   TileType = coRef.TileType;
}
midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::operator=(const midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TileType = coRef.TileType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart()
:TileType()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODSTART;
}


midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::~midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart()
{}

tU32 midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TileType);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TileType);
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart::operator==(const midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TileType == roRef.TileType);
   return bResult;
}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodResult()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODRESULT;
}


midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodResult::~midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodResult()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgNowradDataUpReg::midw_ext_sxm_agwfi_tclMsgNowradDataUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgNowradDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATAUPREG;
}


midw_ext_sxm_agwfi_tclMsgNowradDataUpReg::~midw_ext_sxm_agwfi_tclMsgNowradDataUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgNowradDataRelUpReg::midw_ext_sxm_agwfi_tclMsgNowradDataRelUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgNowradDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATARELUPREG;
}


midw_ext_sxm_agwfi_tclMsgNowradDataRelUpReg::~midw_ext_sxm_agwfi_tclMsgNowradDataRelUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgNowradDataGet::midw_ext_sxm_agwfi_tclMsgNowradDataGet()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgNowradDataGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATAGET;
}


midw_ext_sxm_agwfi_tclMsgNowradDataGet::~midw_ext_sxm_agwfi_tclMsgNowradDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgNowradDataStatus::midw_ext_sxm_agwfi_tclMsgNowradDataStatus(const midw_ext_sxm_agwfi_tclMsgNowradDataStatus& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}
midw_ext_sxm_agwfi_tclMsgNowradDataStatus& midw_ext_sxm_agwfi_tclMsgNowradDataStatus::operator=(const midw_ext_sxm_agwfi_tclMsgNowradDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_agwfi_tclMsgNowradDataStatus::midw_ext_sxm_agwfi_tclMsgNowradDataStatus()
:UpdateCounter(0)
 {}

tS32 midw_ext_sxm_agwfi_tclMsgNowradDataStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATASTATUS;
}


midw_ext_sxm_agwfi_tclMsgNowradDataStatus::~midw_ext_sxm_agwfi_tclMsgNowradDataStatus()
{}

tU32 midw_ext_sxm_agwfi_tclMsgNowradDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgNowradDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UpdateCounter);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgNowradDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UpdateCounter);
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgNowradDataStatus::operator==(const midw_ext_sxm_agwfi_tclMsgNowradDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
   return bResult;
}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataUpReg::midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATAUPREG;
}


midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataUpReg::~midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataRelUpReg::midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataRelUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATARELUPREG;
}


midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataRelUpReg::~midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataRelUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataGet::midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataGet()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATAGET;
}


midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataGet::~midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus::midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus(const midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}
midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus& midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus::operator=(const midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus::midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus()
:UpdateCounter(0)
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATASTATUS;
}


midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus::~midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus()
{}

tU32 midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UpdateCounter);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UpdateCounter);
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus::operator==(const midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
   return bResult;
}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgWindDirectionDataUpReg::midw_ext_sxm_agwfi_tclMsgWindDirectionDataUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindDirectionDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATAUPREG;
}


midw_ext_sxm_agwfi_tclMsgWindDirectionDataUpReg::~midw_ext_sxm_agwfi_tclMsgWindDirectionDataUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgWindDirectionDataRelUpReg::midw_ext_sxm_agwfi_tclMsgWindDirectionDataRelUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindDirectionDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATARELUPREG;
}


midw_ext_sxm_agwfi_tclMsgWindDirectionDataRelUpReg::~midw_ext_sxm_agwfi_tclMsgWindDirectionDataRelUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgWindDirectionDataGet::midw_ext_sxm_agwfi_tclMsgWindDirectionDataGet()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindDirectionDataGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATAGET;
}


midw_ext_sxm_agwfi_tclMsgWindDirectionDataGet::~midw_ext_sxm_agwfi_tclMsgWindDirectionDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus::midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus(const midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}
midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus& midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus::operator=(const midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus::midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus()
:UpdateCounter(0)
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATASTATUS;
}


midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus::~midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus()
{}

tU32 midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UpdateCounter);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UpdateCounter);
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus::operator==(const midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
   return bResult;
}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgSurfaceDataUpReg::midw_ext_sxm_agwfi_tclMsgSurfaceDataUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgSurfaceDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATAUPREG;
}


midw_ext_sxm_agwfi_tclMsgSurfaceDataUpReg::~midw_ext_sxm_agwfi_tclMsgSurfaceDataUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgSurfaceDataRelUpReg::midw_ext_sxm_agwfi_tclMsgSurfaceDataRelUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgSurfaceDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATARELUPREG;
}


midw_ext_sxm_agwfi_tclMsgSurfaceDataRelUpReg::~midw_ext_sxm_agwfi_tclMsgSurfaceDataRelUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgSurfaceDataGet::midw_ext_sxm_agwfi_tclMsgSurfaceDataGet()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgSurfaceDataGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATAGET;
}


midw_ext_sxm_agwfi_tclMsgSurfaceDataGet::~midw_ext_sxm_agwfi_tclMsgSurfaceDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus::midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus(const midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}
midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus& midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus::operator=(const midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus::midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus()
:UpdateCounter(0)
 {}

tS32 midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATASTATUS;
}


midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus::~midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus()
{}

tU32 midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UpdateCounter);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UpdateCounter);
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus::operator==(const midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
   return bResult;
}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgStormAttributesDataUpReg::midw_ext_sxm_agwfi_tclMsgStormAttributesDataUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgStormAttributesDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATAUPREG;
}


midw_ext_sxm_agwfi_tclMsgStormAttributesDataUpReg::~midw_ext_sxm_agwfi_tclMsgStormAttributesDataUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgStormAttributesDataRelUpReg::midw_ext_sxm_agwfi_tclMsgStormAttributesDataRelUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgStormAttributesDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATARELUPREG;
}


midw_ext_sxm_agwfi_tclMsgStormAttributesDataRelUpReg::~midw_ext_sxm_agwfi_tclMsgStormAttributesDataRelUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgStormAttributesDataGet::midw_ext_sxm_agwfi_tclMsgStormAttributesDataGet()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgStormAttributesDataGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATAGET;
}


midw_ext_sxm_agwfi_tclMsgStormAttributesDataGet::~midw_ext_sxm_agwfi_tclMsgStormAttributesDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus::midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus(const midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}
midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus& midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus::operator=(const midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus::midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus()
:UpdateCounter(0)
 {}

tS32 midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS;
}


midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus::~midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus()
{}

tU32 midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UpdateCounter);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UpdateCounter);
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus::operator==(const midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
   return bResult;
}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgStormTrackDataUpReg::midw_ext_sxm_agwfi_tclMsgStormTrackDataUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgStormTrackDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATAUPREG;
}


midw_ext_sxm_agwfi_tclMsgStormTrackDataUpReg::~midw_ext_sxm_agwfi_tclMsgStormTrackDataUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgStormTrackDataRelUpReg::midw_ext_sxm_agwfi_tclMsgStormTrackDataRelUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgStormTrackDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATARELUPREG;
}


midw_ext_sxm_agwfi_tclMsgStormTrackDataRelUpReg::~midw_ext_sxm_agwfi_tclMsgStormTrackDataRelUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgStormTrackDataGet::midw_ext_sxm_agwfi_tclMsgStormTrackDataGet()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgStormTrackDataGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATAGET;
}


midw_ext_sxm_agwfi_tclMsgStormTrackDataGet::~midw_ext_sxm_agwfi_tclMsgStormTrackDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus::midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus(const midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}
midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus& midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus::operator=(const midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus::midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus()
:UpdateCounter(0)
 {}

tS32 midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATASTATUS;
}


midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus::~midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus()
{}

tU32 midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UpdateCounter);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UpdateCounter);
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus::operator==(const midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
   return bResult;
}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgWindDataUpReg::midw_ext_sxm_agwfi_tclMsgWindDataUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATAUPREG;
}


midw_ext_sxm_agwfi_tclMsgWindDataUpReg::~midw_ext_sxm_agwfi_tclMsgWindDataUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgWindDataRelUpReg::midw_ext_sxm_agwfi_tclMsgWindDataRelUpReg()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATARELUPREG;
}


midw_ext_sxm_agwfi_tclMsgWindDataRelUpReg::~midw_ext_sxm_agwfi_tclMsgWindDataRelUpReg()
{}

//=============================================================================

midw_ext_sxm_agwfi_tclMsgWindDataGet::midw_ext_sxm_agwfi_tclMsgWindDataGet()
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindDataGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATAGET;
}


midw_ext_sxm_agwfi_tclMsgWindDataGet::~midw_ext_sxm_agwfi_tclMsgWindDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_agwfi_tclMsgWindDataStatus::midw_ext_sxm_agwfi_tclMsgWindDataStatus(const midw_ext_sxm_agwfi_tclMsgWindDataStatus& coRef)
   : midw_ext_sxm_agwfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}
midw_ext_sxm_agwfi_tclMsgWindDataStatus& midw_ext_sxm_agwfi_tclMsgWindDataStatus::operator=(const midw_ext_sxm_agwfi_tclMsgWindDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_agwfi_tclMsgWindDataStatus::midw_ext_sxm_agwfi_tclMsgWindDataStatus()
:UpdateCounter(0)
 {}

tS32 midw_ext_sxm_agwfi_tclMsgWindDataStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATASTATUS;
}


midw_ext_sxm_agwfi_tclMsgWindDataStatus::~midw_ext_sxm_agwfi_tclMsgWindDataStatus()
{}

tU32 midw_ext_sxm_agwfi_tclMsgWindDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_agwfi_tclMsgWindDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UpdateCounter);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_agwfi_tclMsgWindDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UpdateCounter);
   return oOut;
}

tBool midw_ext_sxm_agwfi_tclMsgWindDataStatus::operator==(const midw_ext_sxm_agwfi_tclMsgWindDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
   return bResult;
}

