/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_METERFITYPES_HEADER
#define MIDW_EXT_METERFITYPES_HEADER


class midw_ext_meterfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_ext_meter_fi message types

fi_tclMessageBase* midw_ext_meterfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_meterfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_meterfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart& operator=(const midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart(const midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_DistanceUnit e8DistanceUnit;
   virtual ~midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& operator=(const midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart(const midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit e8FuelConsumptionUnit;
   virtual ~midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart& operator=(const midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart(const midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_TemperatureUnit e8TemperatureUnit;
   virtual ~midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart& operator=(const midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart(const midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_PressureUnit e8PressureUnit;
   virtual ~midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart& operator=(const midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart(const midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult e8Resultoneway;
   midw_ext_fi_tcl_e8_Meter_Language_Status e8Resulttwoway;
   virtual ~midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgGetMeterLanguageMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgGetMeterLanguageMethodStart();

   virtual ~midw_ext_meterfi_tclMsgGetMeterLanguageMethodStart();

   inline tBool operator==(const midw_ext_meterfi_tclMsgGetMeterLanguageMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult& operator=(const midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult& coRef);
   midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult(const midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Language e8Language;
   virtual ~midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart();

   virtual ~midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart();

   inline tBool operator==(const midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& operator=(const midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& coRef);
   midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult(const midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Language e8DefaultLanguage;
   midw_ext_fi_tcl_e8_Meter_Language e8CurrentLanguage;
   tU8 e8LanguageAvailable_Byte_1;
   tU8 e8LanguageAvailable_Byte_2;
   tU8 e8LanguageAvailable_Byte_3;
   virtual ~midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart& operator=(const midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart(const midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Language e8Language;
   virtual ~midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart& operator=(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart& coRef);
   midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Language e8Language;
   virtual ~midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult& operator=(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult& coRef);
   midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Language_Status e8LanguageStatus;
   virtual ~midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart& operator=(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Language e8Language;
   virtual ~midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult& operator=(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult& coRef);
   midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Language_Status e8LanguageStatus;
   virtual ~midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart& operator=(const midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart& coRef);
   midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart(const midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32SourceListLowByte;
   tU32 u32SourceListHighByte;
   tU32 u32SourceListGen2Byte;
   virtual ~midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgGetAvailableSourceListMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgGetAvailableSourceListMethodResult();

   virtual ~midw_ext_meterfi_tclMsgGetAvailableSourceListMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgGetAvailableSourceListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart& operator=(const midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart(const midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bCausedByUser;
   midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion SourceInfo;
   virtual ~midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetAudioWarningMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetAudioWarningMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetAudioWarningMethodStart& operator=(const midw_ext_meterfi_tclMsgSetAudioWarningMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetAudioWarningMethodStart(const midw_ext_meterfi_tclMsgSetAudioWarningMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bCausedByUser;
   midw_ext_fi_tcl_e8_Meter_Audio_WarningSource e8WarningSource;
   midw_ext_fi_tcl_e8_Meter_Audio_WarningState e8WarningState;
   midw_ext_fi_tclString strWarningText;
   virtual ~midw_ext_meterfi_tclMsgSetAudioWarningMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetAudioWarningMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetAudioWarningMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetAudioWarningMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetAudioWarningMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetAudioWarningMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart& operator=(const midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart(const midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode e8SpecialMode;
   tBool bSpecialModeInterrupt;
   virtual ~midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart& operator=(const midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart(const midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMute;
   virtual ~midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetAudioExternalMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetAudioExternalMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetAudioExternalMethodStart& operator=(const midw_ext_meterfi_tclMsgSetAudioExternalMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetAudioExternalMethodStart(const midw_ext_meterfi_tclMsgSetAudioExternalMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bExternalAudio;
   virtual ~midw_ext_meterfi_tclMsgSetAudioExternalMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetAudioExternalMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetAudioExternalMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetAudioExternalMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetAudioExternalMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetAudioExternalMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart(const midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_NavStatus e8NavStatus;
   virtual ~midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviNavStatusMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviNavStatusMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviNavStatusMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviNavStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart(const midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString strPositionInformationCountryCode;
   midw_ext_fi_tcl_e8_RoadClass e8PositionInformationRoadClass;
   tU32 f32PositionInformationVehicleSpeed;
   tU32 f32PositionInformationVehicleHeading;
   virtual ~midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart(const midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DistanceToDestinationDistanceToDestination;
   midw_ext_fi_tcl_e8_Unit e8DistanceToDestinationUnit;
   virtual ~midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart(const midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString strCurrentStreet;
   virtual ~midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart(const midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString strTurntoStreet;
   virtual ~midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart(const midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString strNextTurntoStreet;
   virtual ~midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart(const midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bBarGraphInfoValid;
   tU16 u16BarGraphInfoValue;
   tU16 u16BarGraphInfoScale;
   midw_ext_fi_tcl_e8_Unit e8BarGraphInfoUnit;
   virtual ~midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart(const midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_ManeuverSymbol e8ManeuverSymbol;
   virtual ~midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart(const midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16RoundaboutExitNumber;
   virtual ~midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart(const midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDeformedImageValid;
   midw_ext_fi_tcl_e8_DeformedImageRoad e8DeformedImageDeformedImageRoad;
   midw_ext_fi_tcl_e8_DeformedImageArrow e8DeformedImageDeformedImageArrow;
   virtual ~midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart(const midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_ManeuverView e8ManeuverViewManeuverView;
   tBool bManeuverViewDeformedImageValid;
   midw_ext_fi_tcl_e8_DeformedImageRoad e8ManeuverViewDeformedImageDeformedImageRoad;
   midw_ext_fi_tcl_e8_DeformedImageArrow e8ManeuverViewDeformedImageDeformedImageArrow;
   tU32 u32ManeuverViewIntersectionMapId;
   virtual ~midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart(const midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_LaneRecommendation, std::allocator<midw_ext_fi_tcl_LaneRecommendation> > tLaneRecommendationList;
   virtual ~midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart(const midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSpeedLimitPresent;
   midw_ext_fi_tclString strSpeedLimitCountryCode;
   tU16 u16SpeedLimitValue;
   midw_ext_fi_tcl_e8_SpeedUnit e8SpeedLimitSpeedUnit;
   virtual ~midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart(const midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString strNextManeuverDetailsDistanceToManeuver;
   midw_ext_fi_tcl_e8_Unit e8NextManeuverDetailsDistanceToManeuverUnit;
   midw_ext_fi_tcl_e8_ManeuverRecommendationType e8NextManeuverDetailsRecommendationType;
   tBool bNextManeuverDetailsIsNewManeuver;
   tBool bNextManeuverDetailsIsReRouted;
   virtual ~midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart(const midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_ArrivalInformation, std::allocator<midw_ext_fi_tcl_ArrivalInformation> > tArrivalInformation;
   virtual ~midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_IntersectionMapRoadLine, std::allocator<midw_ext_fi_tcl_IntersectionMapRoadLine> > tIntersectionMapRoadLineRoadList;
   std::vector<midw_ext_fi_tcl_IntersectionMapRoadLine, std::allocator<midw_ext_fi_tcl_IntersectionMapRoadLine> > tIntersectionMapRoadLineRouteList;
   std::vector<midw_ext_fi_tcl_ScreenCoordinate, std::allocator<midw_ext_fi_tcl_ScreenCoordinate> > tIntersectionMapNoEntryIconsList;
   tU8 u8IntersectionMapIntersectionNumber;
   virtual ~midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& operator=(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32IntersectionMapCarsorPositionIntersectionMapId;
   midw_ext_fi_tcl_e8_IntersectionMapCarsorState e8IntersectionMapCarsorPositionIntersectionMapCarsorState;
   midw_ext_fi_tcl_ScreenCoordinate tIntersectionMapCarsorPositionScreenCoordinate;
   tS32 s32IntersectionMapCarsorPositionCarsorAngle;
   virtual ~midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart& operator=(const midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart(const midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SxmTabWeatherInfoEventCodeCurrentWeather;
   tU8 u8SxmTabWeatherInfoEventCodeDestinationWeather;
   virtual ~midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart& operator=(const midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart(const midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState e8SpiNavgationStatus;
   virtual ~midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& operator=(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString strSpiNavigationRoadName;
   midw_ext_fi_tcl_e8_SpiNavigation_TurnSide e8SpiNavigationTurnSide;
   midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent e8SpiNavigationNextTurnEvent;
   midw_ext_fi_tclString strSpiNavigationImage;
   tS32 s32SpiNavigationTurnAngle;
   tS32 s32SpiNavigationTurnNumber;
   virtual ~midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& operator=(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32SpiNavigationDistanceInMeters;
   tS32 s32SpiNavigationTimeInSeconds;
   virtual ~midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart& operator=(const midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart(const midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_PhoneCall_State e8CallState;
   midw_ext_fi_tclString strCallerInfo;
   tBool bSwitch_1;
   tBool bSwitch_2;
   tBool IsMuteOn;
   virtual ~midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& operator=(const midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart(const midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Phone_SMS_State e8SMSState;
   midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType e8SMSPopupType;
   tU8 u8MsgNumber;
   midw_ext_fi_tclString strSenderInfo;
   virtual ~midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart& operator=(const midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart(const midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_VR_State e8VRState;
   tU8 u8NumberOfDigits;
   midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2 e8VRDigitType;
   virtual ~midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetPowerOnKeepMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetPowerOnKeepMethodStart();

   virtual ~midw_ext_meterfi_tclMsgSetPowerOnKeepMethodStart();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetPowerOnKeepMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetPowerOnKeepMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetPowerOnKeepMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetPowerOnKeepMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetPowerOnKeepMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetTimeInfoMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetTimeInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetTimeInfoMethodStart& operator=(const midw_ext_meterfi_tclMsgSetTimeInfoMethodStart& coRef);
   midw_ext_meterfi_tclMsgSetTimeInfoMethodStart(const midw_ext_meterfi_tclMsgSetTimeInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_TimeInfoType e8TimeInfoType;
   tU8 u8TensHour;
   tU8 u8OnesHour;
   tU8 u8TensMinute;
   tU8 u8OnesMinute;
   virtual ~midw_ext_meterfi_tclMsgSetTimeInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetTimeInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetTimeInfoMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetTimeInfoMethodResult();

   virtual ~midw_ext_meterfi_tclMsgSetTimeInfoMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetTimeInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgResetHistoryMethodStart : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgResetHistoryMethodStart();

   virtual ~midw_ext_meterfi_tclMsgResetHistoryMethodStart();

   inline tBool operator==(const midw_ext_meterfi_tclMsgResetHistoryMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgResetHistoryMethodResult : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgResetHistoryMethodResult();

   virtual ~midw_ext_meterfi_tclMsgResetHistoryMethodResult();

   inline tBool operator==(const midw_ext_meterfi_tclMsgResetHistoryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgConnectionUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgConnectionUpReg();

   virtual ~midw_ext_meterfi_tclMsgConnectionUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgConnectionRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgConnectionRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgConnectionRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgConnectionGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgConnectionGet();

   virtual ~midw_ext_meterfi_tclMsgConnectionGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgConnectionStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgConnectionStatus& operator=(const midw_ext_meterfi_tclMsgConnectionStatus& coRef);
   midw_ext_meterfi_tclMsgConnectionStatus(const midw_ext_meterfi_tclMsgConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_Meter_UnitConnectionStatus, std::allocator<midw_ext_fi_tcl_Meter_UnitConnectionStatus> > arConnectionStatusList;
   virtual ~midw_ext_meterfi_tclMsgConnectionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgConfigurationUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgConfigurationUpReg();

   virtual ~midw_ext_meterfi_tclMsgConfigurationUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgConfigurationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgConfigurationRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgConfigurationRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgConfigurationRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgConfigurationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgConfigurationGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgConfigurationGet();

   virtual ~midw_ext_meterfi_tclMsgConfigurationGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgConfigurationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgConfigurationStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgConfigurationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgConfigurationStatus& operator=(const midw_ext_meterfi_tclMsgConfigurationStatus& coRef);
   midw_ext_meterfi_tclMsgConfigurationStatus(const midw_ext_meterfi_tclMsgConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_Meter_UnitConfiguration, std::allocator<midw_ext_fi_tcl_Meter_UnitConfiguration> > arConfigurationList;
   virtual ~midw_ext_meterfi_tclMsgConfigurationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgConfigurationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgHardwareVersionUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgHardwareVersionUpReg();

   virtual ~midw_ext_meterfi_tclMsgHardwareVersionUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgHardwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgHardwareVersionRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgHardwareVersionRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgHardwareVersionRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgHardwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgHardwareVersionGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgHardwareVersionGet();

   virtual ~midw_ext_meterfi_tclMsgHardwareVersionGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgHardwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgHardwareVersionStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgHardwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgHardwareVersionStatus& operator=(const midw_ext_meterfi_tclMsgHardwareVersionStatus& coRef);
   midw_ext_meterfi_tclMsgHardwareVersionStatus(const midw_ext_meterfi_tclMsgHardwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_Meter_UnitVersion, std::allocator<midw_ext_fi_tcl_Meter_UnitVersion> > arHardwareVersionList;
   virtual ~midw_ext_meterfi_tclMsgHardwareVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgHardwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSoftwareVersionUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSoftwareVersionUpReg();

   virtual ~midw_ext_meterfi_tclMsgSoftwareVersionUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSoftwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSoftwareVersionRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSoftwareVersionRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgSoftwareVersionRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSoftwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSoftwareVersionGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSoftwareVersionGet();

   virtual ~midw_ext_meterfi_tclMsgSoftwareVersionGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSoftwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSoftwareVersionStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSoftwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSoftwareVersionStatus& operator=(const midw_ext_meterfi_tclMsgSoftwareVersionStatus& coRef);
   midw_ext_meterfi_tclMsgSoftwareVersionStatus(const midw_ext_meterfi_tclMsgSoftwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_Meter_UnitVersion, std::allocator<midw_ext_fi_tcl_Meter_UnitVersion> > arSoftwareVersionList;
   virtual ~midw_ext_meterfi_tclMsgSoftwareVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSoftwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgDataTransmissionUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgDataTransmissionUpReg();

   virtual ~midw_ext_meterfi_tclMsgDataTransmissionUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgDataTransmissionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgDataTransmissionRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgDataTransmissionRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgDataTransmissionRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgDataTransmissionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgDataTransmissionGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgDataTransmissionGet();

   virtual ~midw_ext_meterfi_tclMsgDataTransmissionGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgDataTransmissionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgDataTransmissionStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgDataTransmissionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgDataTransmissionStatus& operator=(const midw_ext_meterfi_tclMsgDataTransmissionStatus& coRef);
   midw_ext_meterfi_tclMsgDataTransmissionStatus(const midw_ext_meterfi_tclMsgDataTransmissionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus, std::allocator<midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus> > arDataTransmissionStatusList;
   virtual ~midw_ext_meterfi_tclMsgDataTransmissionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgDataTransmissionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgCurrentMeterSettingsUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgCurrentMeterSettingsUpReg();

   virtual ~midw_ext_meterfi_tclMsgCurrentMeterSettingsUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgCurrentMeterSettingsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgCurrentMeterSettingsRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgCurrentMeterSettingsRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgCurrentMeterSettingsRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgCurrentMeterSettingsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgCurrentMeterSettingsGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgCurrentMeterSettingsGet();

   virtual ~midw_ext_meterfi_tclMsgCurrentMeterSettingsGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgCurrentMeterSettingsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus& operator=(const midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus& coRef);
   midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus(const midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Language e8Language;
   midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit e8FuelConsumptionUnit;
   midw_ext_fi_tcl_e8_Meter_TemperatureUnit e8TemperatureUnit;
   midw_ext_fi_tcl_e8_Meter_PressureUnit e8PressureUnit;
   virtual ~midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsUpReg();

   virtual ~midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsGet();

   virtual ~midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus& operator=(const midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus& coRef);
   midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus(const midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool b_km_per_l;
   tBool b_l_per_100km;
   tBool b_US_MPG;
   tBool b_UK_MPG;
   virtual ~midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailableTemperatureUnitsUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailableTemperatureUnitsUpReg();

   virtual ~midw_ext_meterfi_tclMsgAvailableTemperatureUnitsUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgAvailableTemperatureUnitsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailableTemperatureUnitsRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailableTemperatureUnitsRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgAvailableTemperatureUnitsRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgAvailableTemperatureUnitsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailableTemperatureUnitsGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailableTemperatureUnitsGet();

   virtual ~midw_ext_meterfi_tclMsgAvailableTemperatureUnitsGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgAvailableTemperatureUnitsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus& operator=(const midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus& coRef);
   midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus(const midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool b_deg_C;
   tBool b_deg_F;
   virtual ~midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailablePressureUnitsUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailablePressureUnitsUpReg();

   virtual ~midw_ext_meterfi_tclMsgAvailablePressureUnitsUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgAvailablePressureUnitsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailablePressureUnitsRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailablePressureUnitsRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgAvailablePressureUnitsRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgAvailablePressureUnitsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailablePressureUnitsGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailablePressureUnitsGet();

   virtual ~midw_ext_meterfi_tclMsgAvailablePressureUnitsGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgAvailablePressureUnitsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus& operator=(const midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus& coRef);
   midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus(const midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool b_kPa;
   tBool b_PSI;
   tBool b_bar;
   tBool b_kgf_cm2;
   virtual ~midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitGet();

   virtual ~midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus& operator=(const midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus& coRef);
   midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus(const midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit e8FuelConsumptionUnit;
   virtual ~midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedTemperatureUnitUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedTemperatureUnitUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedTemperatureUnitUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedTemperatureUnitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedTemperatureUnitRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedTemperatureUnitRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedTemperatureUnitRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedTemperatureUnitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedTemperatureUnitGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedTemperatureUnitGet();

   virtual ~midw_ext_meterfi_tclMsgRequestedTemperatureUnitGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedTemperatureUnitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus& operator=(const midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus& coRef);
   midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus(const midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_TemperatureUnit e8TemperatureUnit;
   virtual ~midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedPressureUnitUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedPressureUnitUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedPressureUnitUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedPressureUnitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedPressureUnitRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedPressureUnitRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedPressureUnitRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedPressureUnitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedPressureUnitGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedPressureUnitGet();

   virtual ~midw_ext_meterfi_tclMsgRequestedPressureUnitGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedPressureUnitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedPressureUnitStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedPressureUnitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgRequestedPressureUnitStatus& operator=(const midw_ext_meterfi_tclMsgRequestedPressureUnitStatus& coRef);
   midw_ext_meterfi_tclMsgRequestedPressureUnitStatus(const midw_ext_meterfi_tclMsgRequestedPressureUnitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_PressureUnit e8PressureUnit;
   virtual ~midw_ext_meterfi_tclMsgRequestedPressureUnitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgRequestedPressureUnitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSupportedLangSyncModeUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSupportedLangSyncModeUpReg();

   virtual ~midw_ext_meterfi_tclMsgSupportedLangSyncModeUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSupportedLangSyncModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSupportedLangSyncModeRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSupportedLangSyncModeRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgSupportedLangSyncModeRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSupportedLangSyncModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSupportedLangSyncModeGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSupportedLangSyncModeGet();

   virtual ~midw_ext_meterfi_tclMsgSupportedLangSyncModeGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSupportedLangSyncModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus& operator=(const midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus& coRef);
   midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus(const midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type e8LangSyncMode;
   virtual ~midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedLanguageUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedLanguageUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedLanguageUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedLanguageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedLanguageRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedLanguageRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedLanguageRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedLanguageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedLanguageGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedLanguageGet();

   virtual ~midw_ext_meterfi_tclMsgRequestedLanguageGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedLanguageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedLanguageStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedLanguageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgRequestedLanguageStatus& operator=(const midw_ext_meterfi_tclMsgRequestedLanguageStatus& coRef);
   midw_ext_meterfi_tclMsgRequestedLanguageStatus(const midw_ext_meterfi_tclMsgRequestedLanguageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Language e8Language;
   midw_ext_fi_tcl_e8_Meter_Language_Action e8MeterLanguageAction;
   virtual ~midw_ext_meterfi_tclMsgRequestedLanguageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgRequestedLanguageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgLanguageSettingsStatusUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgLanguageSettingsStatusUpReg();

   virtual ~midw_ext_meterfi_tclMsgLanguageSettingsStatusUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgLanguageSettingsStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgLanguageSettingsStatusRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgLanguageSettingsStatusRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgLanguageSettingsStatusRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgLanguageSettingsStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgLanguageSettingsStatusGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgLanguageSettingsStatusGet();

   virtual ~midw_ext_meterfi_tclMsgLanguageSettingsStatusGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgLanguageSettingsStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus& operator=(const midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus& coRef);
   midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus(const midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Language_InvalidParameter e8InvalidParameter;
   midw_ext_fi_tcl_e8_Meter_Language e8DefaultLanguage;
   midw_ext_fi_tcl_e8_Meter_Language e8CurrentLanguage;
   tU8 e8LanguageAvailable_Byte_1;
   tU8 e8LanguageAvailable_Byte_2;
   tU8 e8LanguageAvailable_Byte_3;
   virtual ~midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSelectedSourceOnMeterUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSelectedSourceOnMeterUpReg();

   virtual ~midw_ext_meterfi_tclMsgSelectedSourceOnMeterUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSelectedSourceOnMeterUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSelectedSourceOnMeterRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSelectedSourceOnMeterRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgSelectedSourceOnMeterRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSelectedSourceOnMeterRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSelectedSourceOnMeterGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSelectedSourceOnMeterGet();

   virtual ~midw_ext_meterfi_tclMsgSelectedSourceOnMeterGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSelectedSourceOnMeterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus& operator=(const midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus& coRef);
   midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus(const midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 e8SelectedSource;
   virtual ~midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviSwipeUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviSwipeUpReg();

   virtual ~midw_ext_meterfi_tclMsgSetNaviSwipeUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviSwipeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviSwipeRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviSwipeRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgSetNaviSwipeRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviSwipeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviSwipeSet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviSwipeSet();

   virtual ~midw_ext_meterfi_tclMsgSetNaviSwipeSet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgSetNaviSwipeSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgSetNaviSwipeStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgSetNaviSwipeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgSetNaviSwipeStatus& operator=(const midw_ext_meterfi_tclMsgSetNaviSwipeStatus& coRef);
   midw_ext_meterfi_tclMsgSetNaviSwipeStatus(const midw_ext_meterfi_tclMsgSetNaviSwipeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSwipeBeep;
   virtual ~midw_ext_meterfi_tclMsgSetNaviSwipeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgSetNaviSwipeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgKeyEventUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgKeyEventUpReg();

   virtual ~midw_ext_meterfi_tclMsgKeyEventUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgKeyEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgKeyEventRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgKeyEventRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgKeyEventRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgKeyEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgKeyEventStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgKeyEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgKeyEventStatus& operator=(const midw_ext_meterfi_tclMsgKeyEventStatus& coRef);
   midw_ext_meterfi_tclMsgKeyEventStatus(const midw_ext_meterfi_tclMsgKeyEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bKeyPressed;
   midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode e8KeyCode;
   virtual ~midw_ext_meterfi_tclMsgKeyEventStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgKeyEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus& operator=(const midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus& coRef);
   midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus(const midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action e8CallMenuSelection;
   virtual ~midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedSMSMenuActionUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedSMSMenuActionUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedSMSMenuActionUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedSMSMenuActionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedSMSMenuActionRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedSMSMenuActionRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgRequestedSMSMenuActionRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgRequestedSMSMenuActionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus& operator=(const midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus& coRef);
   midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus(const midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu e8SelectedSMSMenu;
   virtual ~midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgVehiclePowerStateUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgVehiclePowerStateUpReg();

   virtual ~midw_ext_meterfi_tclMsgVehiclePowerStateUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgVehiclePowerStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgVehiclePowerStateRelUpReg : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgVehiclePowerStateRelUpReg();

   virtual ~midw_ext_meterfi_tclMsgVehiclePowerStateRelUpReg();

   inline tBool operator==(const midw_ext_meterfi_tclMsgVehiclePowerStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgVehiclePowerStateGet : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgVehiclePowerStateGet();

   virtual ~midw_ext_meterfi_tclMsgVehiclePowerStateGet();

   inline tBool operator==(const midw_ext_meterfi_tclMsgVehiclePowerStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_meterfi_tclMsgVehiclePowerStateStatus : public midw_ext_meterfi_tclMsgBaseMessage
{
public:

   midw_ext_meterfi_tclMsgVehiclePowerStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_meterfi_tclMsgVehiclePowerStateStatus& operator=(const midw_ext_meterfi_tclMsgVehiclePowerStateStatus& coRef);
   midw_ext_meterfi_tclMsgVehiclePowerStateStatus(const midw_ext_meterfi_tclMsgVehiclePowerStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_PowerState e8PowerState;
   virtual ~midw_ext_meterfi_tclMsgVehiclePowerStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_meterfi_tclMsgVehiclePowerStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
