#ifndef __MIDW_EXT_METERFIDEBUGVISITOR_H__
#define __MIDW_EXT_METERFIDEBUGVISITOR_H__

class MY_DECL midw_ext_meterfi_tclPrintVisitor : public midw_ext_meterfi_tclVisitorBase {

private:
   /* default constructor */ midw_ext_meterfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   midw_ext_meterfi_tclPrintVisitor(midw_ext_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(midw_ext_fi_tclU8& oU8);
   virtual tVoid vVisitS8(midw_ext_fi_tclS8& oS8);
   virtual tVoid vVisitU16(midw_ext_fi_tclU16& oU16);
   virtual tVoid vVisitS16(midw_ext_fi_tclS16& oS16);
   virtual tVoid vVisitU24(midw_ext_fi_tclU24& oU24);
   virtual tVoid vVisitS24(midw_ext_fi_tclS24& oS24);
   virtual tVoid vVisitU32(midw_ext_fi_tclU32& oU32);
   virtual tVoid vVisitS32(midw_ext_fi_tclS32& oS32);
   virtual tVoid vVisitU64(midw_ext_fi_tclU64& oU64);
   virtual tVoid vVisitS64(midw_ext_fi_tclS64& oS64);
   virtual tVoid vVisitBool(midw_ext_fi_tclBool& oBool);
   virtual tVoid vVisitString(midw_ext_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(midw_ext_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(midw_ext_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_UnitType(midw_ext_fi_tcl_e8_Meter_UnitType& o_e8_Meter_UnitType);
   virtual tVoid vVisit_e8_Meter_ConfigurationStatus(midw_ext_fi_tcl_e8_Meter_ConfigurationStatus& o_e8_Meter_ConfigurationStatus);
   virtual tBool bDoExpand_Meter_VersionInfo(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_UnitConnectionStatus(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_UnitConfiguration(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_UnitVersion(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_UnitDataTransmissionStatus(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Language(midw_ext_fi_tcl_e8_Meter_Language& o_e8_Meter_Language);
   virtual tVoid vVisit_e8_Meter_Language_Action(midw_ext_fi_tcl_e8_Meter_Language_Action& o_e8_Meter_Language_Action);
   virtual tVoid vVisit_e8_Lang_Sync_Mode_Type(midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type& o_e8_Lang_Sync_Mode_Type);
   virtual tVoid vVisit_e8_Meter_Language_Status(midw_ext_fi_tcl_e8_Meter_Language_Status& o_e8_Meter_Language_Status);
   virtual tVoid vVisit_e8_Meter_RequestedLanguageResult(midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult& o_e8_Meter_RequestedLanguageResult);
   virtual tVoid vVisit_e8_Meter_DistanceUnit(midw_ext_fi_tcl_e8_Meter_DistanceUnit& o_e8_Meter_DistanceUnit);
   virtual tVoid vVisit_e8_Meter_FuelConsumptionUnit(midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit& o_e8_Meter_FuelConsumptionUnit);
   virtual tVoid vVisit_e8_Meter_TemperatureUnit(midw_ext_fi_tcl_e8_Meter_TemperatureUnit& o_e8_Meter_TemperatureUnit);
   virtual tVoid vVisit_e8_Meter_PressureUnit(midw_ext_fi_tcl_e8_Meter_PressureUnit& o_e8_Meter_PressureUnit);
   virtual tBool bDoExpand_Meter_Audio_NoData(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_RadioSource(midw_ext_fi_tcl_e8_Meter_Audio_RadioSource& o_e8_Meter_Audio_RadioSource);
   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoUpdate(midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate& o_e8_Meter_Audio_HDRadioSourceInfoUpdate);
   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoName(midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName& o_e8_Meter_Audio_HDRadioSourceInfoName);
   virtual tBool bDoExpand_e8_Meter_Audio_HDRadioSource(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_RadioLabelType(midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType& o_e8_Meter_Audio_RadioLabelType);
   virtual tBool bDoExpand_Meter_Audio_RadioLabel(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_RadioFrequencyUnit(midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit& o_e8_Meter_Audio_RadioFrequencyUnit);
   virtual tBool bDoExpand_Meter_Audio_RadioFrequency(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_RadioCategoryType(midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType& o_e8_Meter_Audio_RadioCategoryType);
   virtual tBool bDoExpand_Meter_Audio_RadioCategory(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_RadioData(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_HDRadioData(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_MediaType(midw_ext_fi_tcl_e8_Meter_Audio_MediaType& o_e8_Meter_Audio_MediaType);
   virtual tVoid vVisit_e8_Meter_Audio_TrackLabelType(midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType& o_e8_Meter_Audio_TrackLabelType);
   virtual tBool bDoExpand_Meter_Audio_TrackInfo(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_GroupLabelType(midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType& o_e8_Meter_Audio_GroupLabelType);
   virtual tBool bDoExpand_Meter_Audio_GroupInfo(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_ArtistLabelType(midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType& o_e8_Meter_Audio_ArtistLabelType);
   virtual tBool bDoExpand_Meter_Audio_ArtistInfo(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_MediaData(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_AuxType(midw_ext_fi_tcl_e8_Meter_Audio_AuxType& o_e8_Meter_Audio_AuxType);
   virtual tBool bDoExpand_Meter_Audio_AuxData(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_ExternalSoundData(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_InternetRadioData(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_SourceInfoType(midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType& o_e8_Meter_Audio_SourceInfoType);
   virtual tBool bDoExpand_Meter_Audio_SourceInfoUnion(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_WarningSource(midw_ext_fi_tcl_e8_Meter_Audio_WarningSource& o_e8_Meter_Audio_WarningSource);
   virtual tVoid vVisit_e8_Meter_Audio_WarningState(midw_ext_fi_tcl_e8_Meter_Audio_WarningState& o_e8_Meter_Audio_WarningState);
   virtual tVoid vVisit_e8_Meter_Audio_SpecialMode(midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode& o_e8_Meter_Audio_SpecialMode);
   virtual tVoid vVisit_e8_NavStatus(midw_ext_fi_tcl_e8_NavStatus& o_e8_NavStatus);
   virtual tVoid vVisit_e8_RoadClass(midw_ext_fi_tcl_e8_RoadClass& o_e8_RoadClass);
   virtual tVoid vVisit_e8_Unit(midw_ext_fi_tcl_e8_Unit& o_e8_Unit);
   virtual tVoid vVisit_e8_ManeuverSymbol(midw_ext_fi_tcl_e8_ManeuverSymbol& o_e8_ManeuverSymbol);
   virtual tVoid vVisit_e8_SpeedUnit(midw_ext_fi_tcl_e8_SpeedUnit& o_e8_SpeedUnit);
   virtual tVoid vVisit_e8_ManeuverRecommendationType(midw_ext_fi_tcl_e8_ManeuverRecommendationType& o_e8_ManeuverRecommendationType);
   virtual tVoid vVisit_e8_TimeType(midw_ext_fi_tcl_e8_TimeType& o_e8_TimeType);
   virtual tVoid vVisit_e8_TimeFormat(midw_ext_fi_tcl_e8_TimeFormat& o_e8_TimeFormat);
   virtual tVoid vVisit_e8_ManeuverView(midw_ext_fi_tcl_e8_ManeuverView& o_e8_ManeuverView);
   virtual tVoid vVisit_e8_DeformedImageRoad(midw_ext_fi_tcl_e8_DeformedImageRoad& o_e8_DeformedImageRoad);
   virtual tVoid vVisit_e8_DeformedImageArrow(midw_ext_fi_tcl_e8_DeformedImageArrow& o_e8_DeformedImageArrow);
   virtual tVoid vVisit_e8_LaneStatus(midw_ext_fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tBool bDoExpand_LaneRecommendation(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ArrivalInformation(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ScreenCoordinate(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_AdminRoadClass(midw_ext_fi_tcl_e8_AdminRoadClass& o_e8_AdminRoadClass);
   virtual tBool bDoExpand_IntersectionMapRoadLine(midw_ext_meterfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_IntersectionMapCarsorState(midw_ext_fi_tcl_e8_IntersectionMapCarsorState& o_e8_IntersectionMapCarsorState);
   virtual tVoid vVisit_e8_SpiNavigation_NavigationAppState(midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState& o_e8_SpiNavigation_NavigationAppState);
   virtual tVoid vVisit_e8_SpiNavigation_TurnSide(midw_ext_fi_tcl_e8_SpiNavigation_TurnSide& o_e8_SpiNavigation_TurnSide);
   virtual tVoid vVisit_e8_SpiNavigation_NextTurnEvent(midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent& o_e8_SpiNavigation_NextTurnEvent);
   virtual tVoid vVisit_e8_Meter_SWSC_KeyCode(midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode& o_e8_Meter_SWSC_KeyCode);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_State(midw_ext_fi_tcl_e8_Meter_Phone_SMS_State& o_e8_Meter_Phone_SMS_State);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_Selected_Menu(midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu& o_e8_Meter_Phone_SMS_Selected_Menu);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_PopupType(midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType& o_e8_Meter_Phone_SMS_PopupType);
   virtual tVoid vVisit_e8_Meter_VR_State(midw_ext_fi_tcl_e8_Meter_VR_State& o_e8_Meter_VR_State);
   virtual tVoid vVisit_e8_Meter_VR_Digit_Type2(midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2& o_e8_Meter_VR_Digit_Type2);
   virtual tVoid vVisit_e8_Meter_PowerState(midw_ext_fi_tcl_e8_Meter_PowerState& o_e8_Meter_PowerState);
   virtual tVoid vVisit_e8_Meter_TimeInfoType(midw_ext_fi_tcl_e8_Meter_TimeInfoType& o_e8_Meter_TimeInfoType);
   virtual tVoid vVisit_e8_Meter_PhoneCall_Menu_Action(midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action& o_e8_Meter_PhoneCall_Menu_Action);
   virtual tVoid vVisit_e8_Meter_PhoneCall_State(midw_ext_fi_tcl_e8_Meter_PhoneCall_State& o_e8_Meter_PhoneCall_State);
   virtual tVoid vVisit_e8_Language_InvalidParameter(midw_ext_fi_tcl_e8_Language_InvalidParameter& o_e8_Language_InvalidParameter);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   midw_ext_fi_tclOutput* poOutput;
};


class MY_DECL midw_ext_meterfi_tclRandomInitVisitor : public midw_ext_meterfi_tclVisitorBase {
public:

   midw_ext_meterfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(midw_ext_fi_tclU8& oU8);
   virtual tVoid vVisitS8(midw_ext_fi_tclS8& oS8);
   virtual tVoid vVisitU16(midw_ext_fi_tclU16& oU16);
   virtual tVoid vVisitS16(midw_ext_fi_tclS16& oS16);
   virtual tVoid vVisitU24(midw_ext_fi_tclU24& oU24);
   virtual tVoid vVisitS24(midw_ext_fi_tclS24& oS24);
   virtual tVoid vVisitU32(midw_ext_fi_tclU32& oU32);
   virtual tVoid vVisitS32(midw_ext_fi_tclS32& oS32);
   virtual tVoid vVisitU64(midw_ext_fi_tclU64& oU64);
   virtual tVoid vVisitS64(midw_ext_fi_tclS64& oS64);
   virtual tVoid vVisitBool(midw_ext_fi_tclBool& oBool);
   virtual tVoid vVisitString(midw_ext_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(midw_ext_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(midw_ext_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e8_Meter_UnitType(midw_ext_fi_tcl_e8_Meter_UnitType& o_e8_Meter_UnitType);
   virtual tVoid vVisit_e8_Meter_ConfigurationStatus(midw_ext_fi_tcl_e8_Meter_ConfigurationStatus& o_e8_Meter_ConfigurationStatus);
   virtual tVoid vVisit_e8_Meter_Language(midw_ext_fi_tcl_e8_Meter_Language& o_e8_Meter_Language);
   virtual tVoid vVisit_e8_Meter_Language_Action(midw_ext_fi_tcl_e8_Meter_Language_Action& o_e8_Meter_Language_Action);
   virtual tVoid vVisit_e8_Lang_Sync_Mode_Type(midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type& o_e8_Lang_Sync_Mode_Type);
   virtual tVoid vVisit_e8_Meter_Language_Status(midw_ext_fi_tcl_e8_Meter_Language_Status& o_e8_Meter_Language_Status);
   virtual tVoid vVisit_e8_Meter_RequestedLanguageResult(midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult& o_e8_Meter_RequestedLanguageResult);
   virtual tVoid vVisit_e8_Meter_DistanceUnit(midw_ext_fi_tcl_e8_Meter_DistanceUnit& o_e8_Meter_DistanceUnit);
   virtual tVoid vVisit_e8_Meter_FuelConsumptionUnit(midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit& o_e8_Meter_FuelConsumptionUnit);
   virtual tVoid vVisit_e8_Meter_TemperatureUnit(midw_ext_fi_tcl_e8_Meter_TemperatureUnit& o_e8_Meter_TemperatureUnit);
   virtual tVoid vVisit_e8_Meter_PressureUnit(midw_ext_fi_tcl_e8_Meter_PressureUnit& o_e8_Meter_PressureUnit);
   virtual tVoid vVisit_e8_Meter_Audio_RadioSource(midw_ext_fi_tcl_e8_Meter_Audio_RadioSource& o_e8_Meter_Audio_RadioSource);
   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoUpdate(midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate& o_e8_Meter_Audio_HDRadioSourceInfoUpdate);
   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoName(midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName& o_e8_Meter_Audio_HDRadioSourceInfoName);
   virtual tVoid vVisit_e8_Meter_Audio_RadioLabelType(midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType& o_e8_Meter_Audio_RadioLabelType);
   virtual tVoid vVisit_e8_Meter_Audio_RadioFrequencyUnit(midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit& o_e8_Meter_Audio_RadioFrequencyUnit);
   virtual tVoid vVisit_e8_Meter_Audio_RadioCategoryType(midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType& o_e8_Meter_Audio_RadioCategoryType);
   virtual tVoid vVisit_e8_Meter_Audio_MediaType(midw_ext_fi_tcl_e8_Meter_Audio_MediaType& o_e8_Meter_Audio_MediaType);
   virtual tVoid vVisit_e8_Meter_Audio_TrackLabelType(midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType& o_e8_Meter_Audio_TrackLabelType);
   virtual tVoid vVisit_e8_Meter_Audio_GroupLabelType(midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType& o_e8_Meter_Audio_GroupLabelType);
   virtual tVoid vVisit_e8_Meter_Audio_ArtistLabelType(midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType& o_e8_Meter_Audio_ArtistLabelType);
   virtual tVoid vVisit_e8_Meter_Audio_AuxType(midw_ext_fi_tcl_e8_Meter_Audio_AuxType& o_e8_Meter_Audio_AuxType);
   virtual tVoid vVisit_e8_Meter_Audio_SourceInfoType(midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType& o_e8_Meter_Audio_SourceInfoType);
   virtual tVoid vVisit_e8_Meter_Audio_WarningSource(midw_ext_fi_tcl_e8_Meter_Audio_WarningSource& o_e8_Meter_Audio_WarningSource);
   virtual tVoid vVisit_e8_Meter_Audio_WarningState(midw_ext_fi_tcl_e8_Meter_Audio_WarningState& o_e8_Meter_Audio_WarningState);
   virtual tVoid vVisit_e8_Meter_Audio_SpecialMode(midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode& o_e8_Meter_Audio_SpecialMode);
   virtual tVoid vVisit_e8_NavStatus(midw_ext_fi_tcl_e8_NavStatus& o_e8_NavStatus);
   virtual tVoid vVisit_e8_RoadClass(midw_ext_fi_tcl_e8_RoadClass& o_e8_RoadClass);
   virtual tVoid vVisit_e8_Unit(midw_ext_fi_tcl_e8_Unit& o_e8_Unit);
   virtual tVoid vVisit_e8_ManeuverSymbol(midw_ext_fi_tcl_e8_ManeuverSymbol& o_e8_ManeuverSymbol);
   virtual tVoid vVisit_e8_SpeedUnit(midw_ext_fi_tcl_e8_SpeedUnit& o_e8_SpeedUnit);
   virtual tVoid vVisit_e8_ManeuverRecommendationType(midw_ext_fi_tcl_e8_ManeuverRecommendationType& o_e8_ManeuverRecommendationType);
   virtual tVoid vVisit_e8_TimeType(midw_ext_fi_tcl_e8_TimeType& o_e8_TimeType);
   virtual tVoid vVisit_e8_TimeFormat(midw_ext_fi_tcl_e8_TimeFormat& o_e8_TimeFormat);
   virtual tVoid vVisit_e8_ManeuverView(midw_ext_fi_tcl_e8_ManeuverView& o_e8_ManeuverView);
   virtual tVoid vVisit_e8_DeformedImageRoad(midw_ext_fi_tcl_e8_DeformedImageRoad& o_e8_DeformedImageRoad);
   virtual tVoid vVisit_e8_DeformedImageArrow(midw_ext_fi_tcl_e8_DeformedImageArrow& o_e8_DeformedImageArrow);
   virtual tVoid vVisit_e8_LaneStatus(midw_ext_fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tVoid vVisit_e8_AdminRoadClass(midw_ext_fi_tcl_e8_AdminRoadClass& o_e8_AdminRoadClass);
   virtual tVoid vVisit_e8_IntersectionMapCarsorState(midw_ext_fi_tcl_e8_IntersectionMapCarsorState& o_e8_IntersectionMapCarsorState);
   virtual tVoid vVisit_e8_SpiNavigation_NavigationAppState(midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState& o_e8_SpiNavigation_NavigationAppState);
   virtual tVoid vVisit_e8_SpiNavigation_TurnSide(midw_ext_fi_tcl_e8_SpiNavigation_TurnSide& o_e8_SpiNavigation_TurnSide);
   virtual tVoid vVisit_e8_SpiNavigation_NextTurnEvent(midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent& o_e8_SpiNavigation_NextTurnEvent);
   virtual tVoid vVisit_e8_Meter_SWSC_KeyCode(midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode& o_e8_Meter_SWSC_KeyCode);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_State(midw_ext_fi_tcl_e8_Meter_Phone_SMS_State& o_e8_Meter_Phone_SMS_State);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_Selected_Menu(midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu& o_e8_Meter_Phone_SMS_Selected_Menu);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_PopupType(midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType& o_e8_Meter_Phone_SMS_PopupType);
   virtual tVoid vVisit_e8_Meter_VR_State(midw_ext_fi_tcl_e8_Meter_VR_State& o_e8_Meter_VR_State);
   virtual tVoid vVisit_e8_Meter_VR_Digit_Type2(midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2& o_e8_Meter_VR_Digit_Type2);
   virtual tVoid vVisit_e8_Meter_PowerState(midw_ext_fi_tcl_e8_Meter_PowerState& o_e8_Meter_PowerState);
   virtual tVoid vVisit_e8_Meter_TimeInfoType(midw_ext_fi_tcl_e8_Meter_TimeInfoType& o_e8_Meter_TimeInfoType);
   virtual tVoid vVisit_e8_Meter_PhoneCall_Menu_Action(midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action& o_e8_Meter_PhoneCall_Menu_Action);
   virtual tVoid vVisit_e8_Meter_PhoneCall_State(midw_ext_fi_tcl_e8_Meter_PhoneCall_State& o_e8_Meter_PhoneCall_State);
   virtual tVoid vVisit_e8_Language_InvalidParameter(midw_ext_fi_tcl_e8_Language_InvalidParameter& o_e8_Language_InvalidParameter);
	tU32 u32ListSize;
};

#endif
