/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_DABTUNER_FI message types

fi_tclMessageBase* midw_ext_dabtunerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_START_SCANMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_START_SCANMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_LEARNMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_LEARNMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_TIILISTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_TIILISTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ENS_SELECTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ENS_SELECTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SRV_SELECTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SRV_SELECTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_COMP_SELECTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_COMP_SELECTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SOURCE_STATEMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SOURCE_STATEMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_FIELDSTRENGTHMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_FIELDSTRENGTHMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SETUPMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SETUPMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ANNO_CONFIGMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ANNO_CONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_ANNOMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_ANNOMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_BANKMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_BANKMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SAVE_PRESET_LIST_ELEMMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SAVE_PRESET_LIST_ELEMMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DELETE_PRESET_LIST_ELEMMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DELETE_PRESET_LIST_ELEMMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SAVE_PRESET_LISTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SAVE_PRESET_LISTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_PRESET_LISTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_PRESET_LISTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_AUTOSTOREMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_AUTOSTOREMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_ENS_LISTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_ENS_LISTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_SRV_LISTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_SRV_LISTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_COMP_LISTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_COMP_LISTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_VALIDATE_EPG_LISTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_VALIDATE_EPG_LISTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TEST_OPERATIONMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TEST_OPERATIONMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DEFAULT_SETTINGSMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DEFAULT_SETTINGSMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_STOP_ANNOMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_STOP_ANNOMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_TMCMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_TMCMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TPEG_URI_LISTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TPEG_URI_LISTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_TPEG_CHNMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_TPEG_CHNMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_RDBID_WISH_LISTMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_RDBID_WISH_LISTMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_TESTMODEMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_TESTMODEMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_EXP_API_INFOMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_EXP_API_INFOMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DB_QUERYMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DB_QUERYMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SEEK_ENSEMBLEMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SEEK_ENSEMBLEMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SEEK_SERVICEMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SEEK_SERVICEMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TARGET_SEEKMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TARGET_SEEKMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_MUTE_STATUSMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_MUTE_STATUSMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DATASERVICES_DATAMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DATASERVICES_DATAMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DSM_MSGMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DSM_MSGMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_MTC_SETMODEMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_MTC_SETMODEMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TUNE_FREQUENCY_LABELMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TUNE_FREQUENCY_LABELMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_USER_PROFILE_UPDATEMETHODSTART:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_USER_PROFILE_UPDATEMETHODRESULT:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TUNER_STATUSUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TUNER_STATUSRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TUNER_STATUSGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TUNER_STATUSSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_AVAILABILITYUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_AVAILABILITYRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_AVAILABILITYGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_AVAILABILITYSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ADR_MSGUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ADR_MSGRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ADR_MSGGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ADR_MSGSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LOCAL_OFFSETUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LOCAL_OFFSETRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LOCAL_OFFSETGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LOCAL_OFFSETSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ANNO_STATUSUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ANNO_STATUSRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ANNO_STATUSGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ANNO_STATUSSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_CHANNEL_INFOUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_CHANNEL_INFORELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFORelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_CHANNEL_INFOGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_CHANNEL_INFOSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_COMP_LISTUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_COMP_LISTRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_COMP_LISTGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_COMP_LISTSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_PRESET_LISTUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_PRESET_LISTRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_PRESET_LISTGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_PRESET_LISTSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SETUP_STATUSUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SETUP_STATUSRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SETUP_STATUSGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SETUP_STATUSSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SERVICE_FOLLOWING_STATUSUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SERVICE_FOLLOWING_STATUSRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SERVICE_FOLLOWING_STATUSGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SERVICE_FOLLOWING_STATUSSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_STATUSUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_STATUSRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_STATUSGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_STATUSSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_REQUESTUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_REQUESTRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_REQUESTGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_REQUESTSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LEARNUPDATE_PROGRESSUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LEARNUPDATE_PROGRESSRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LEARNUPDATE_PROGRESSGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LEARNUPDATE_PROGRESSSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRV_LIST_UPDATEUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRV_LIST_UPDATERELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATERelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRV_LIST_UPDATEGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRV_LIST_UPDATESTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TESTMODE_DATAUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TESTMODE_DATARELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TESTMODE_DATAGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TESTMODE_DATASTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_ENSEMBLE_INFOUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_ENSEMBLE_INFORELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_ENSEMBLE_INFOSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_SERVICE_INFOUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_SERVICE_INFORELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_SERVICE_INFOGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_SERVICE_INFOSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_COMPONENT_INFOUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_COMPONENT_INFORELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_COMPONENT_INFOGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_COMPONENT_INFOSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_BG_TESTMODE_DATAUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_BG_TESTMODE_DATARELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_BG_TESTMODE_DATAGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_BG_TESTMODE_DATASTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_TPEG_DATAUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_TPEG_DATARELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_TPEG_DATASTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_DATAUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_DATARELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_DATASTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_AVAIL_LISTGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_AVAIL_LISTSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_DATAUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_DATARELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_DATASTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_URI_LISTUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_URI_LISTRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_URI_LISTSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SETMODE_STATUSUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SETMODE_STATUSRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SETMODE_STATUSGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SETMODE_STATUSSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_TUNER_STATUSUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_TUNER_STATUSRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_TUNER_STATUSGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_TUNER_STATUSSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SURVEILLANCE_MONITORUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SURVEILLANCE_MONITORRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SURVEILLANCE_MONITORGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SURVEILLANCE_MONITORSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRVLIST_NOTIFICATIONUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRVLIST_NOTIFICATIONRELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRVLIST_NOTIFICATIONSTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LIST_UPDATEUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LIST_UPDATERELUPREG:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LIST_UPDATEGET:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet;

      case midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LIST_UPDATESTATUS:
         return OSAL_NEW midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_dabtunerfifi messages

// common functions

tU16 midw_ext_dabtunerfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_DABTUNERFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_dabtunerfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_dabtunerfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_dabtunerfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_dabtunerfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_dabtunerfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   StartScan = coRef.StartScan;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StartScan = coRef.StartScan;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart()
:StartScan(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_START_SCANMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StartScan);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StartScan);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StartScan == roRef.StartScan);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_START_SCANMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   LearnParam = coRef.LearnParam;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LearnParam = coRef.LearnParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart()
:LearnParam()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_LEARNMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LearnParam);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LearnParam);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LearnParam == roRef.LearnParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_LEARNMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_TIILISTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
   TIIList = coRef.TIIList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   TIIList = coRef.TIIList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TIIList.size(); ++u32Idx)
         TIIList[u32Idx].vDestroy();
   TIIList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult()
:e8MethodResult()

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_TIILISTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(TIIList.size()*10);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TIIList.size(); ++u32Idx)
      {
         TIIList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TIIList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TIIList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   (tVoid) (oOut << (tU32)TIIList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TIIList.size(); ++u32Idx)
         (tVoid) (oOut << TIIList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
      bResult = bResult && (TIIList.size() == roRef.TIIList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TIIList.size()); ++u32Idx)
            bResult = bResult && (TIIList[u32Idx] == roRef.TIIList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   SelectMode = coRef.SelectMode;
   u32Value = coRef.u32Value;
   bNegative = coRef.bNegative;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SelectMode = coRef.SelectMode;
   u32Value = coRef.u32Value;
   bNegative = coRef.bNegative;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart()
:SelectMode()
,u32Value(0)
,bNegative(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ENS_SELECTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectMode);
   (tVoid) (oIn >> u32Value);
   (tVoid) (oIn >> bNegative);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectMode);
   (tVoid) (oOut << u32Value);
   (tVoid) (oOut << bNegative);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectMode == roRef.SelectMode);
   bResult = bResult && (u32Value == roRef.u32Value);
   bResult = bResult && (bNegative == roRef.bNegative);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ENS_SELECTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   SelectMode = coRef.SelectMode;
   u32Value = coRef.u32Value;
   u16Scids = coRef.u16Scids;
   bNegative = coRef.bNegative;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SelectMode = coRef.SelectMode;
   u32Value = coRef.u32Value;
   u16Scids = coRef.u16Scids;
   bNegative = coRef.bNegative;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart()
:SelectMode()
,u32Value(0)
,u16Scids(0)
,bNegative(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SRV_SELECTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectMode);
   (tVoid) (oIn >> u32Value);
   (tVoid) (oIn >> u16Scids);
   (tVoid) (oIn >> bNegative);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectMode);
   (tVoid) (oOut << u32Value);
   (tVoid) (oOut << u16Scids);
   (tVoid) (oOut << bNegative);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectMode == roRef.SelectMode);
   bResult = bResult && (u32Value == roRef.u32Value);
   bResult = bResult && (u16Scids == roRef.u16Scids);
   bResult = bResult && (bNegative == roRef.bNegative);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SRV_SELECTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   SelectMode = coRef.SelectMode;
   u32Value = coRef.u32Value;
   bNegative = coRef.bNegative;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SelectMode = coRef.SelectMode;
   u32Value = coRef.u32Value;
   bNegative = coRef.bNegative;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart()
:SelectMode()
,u32Value(0)
,bNegative(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_COMP_SELECTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectMode);
   (tVoid) (oIn >> u32Value);
   (tVoid) (oIn >> bNegative);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectMode);
   (tVoid) (oOut << u32Value);
   (tVoid) (oOut << bNegative);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectMode == roRef.SelectMode);
   bResult = bResult && (u32Value == roRef.u32Value);
   bResult = bResult && (bNegative == roRef.bNegative);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_COMP_SELECTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8SourceState = coRef.e8SourceState;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SourceState = coRef.e8SourceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart()
:e8SourceState()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SOURCE_STATEMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SourceState);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SourceState);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SourceState == roRef.e8SourceState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
   e8SourceState = coRef.e8SourceState;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   e8SourceState = coRef.e8SourceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult()
:e8MethodResult()
,e8SourceState()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SOURCE_STATEMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   (tVoid) (oIn >> e8SourceState);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   (tVoid) (oOut << e8SourceState);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   bResult = bResult && (e8SourceState == roRef.e8SourceState);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_FIELDSTRENGTHMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
   s8FieldStrength = coRef.s8FieldStrength;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   s8FieldStrength = coRef.s8FieldStrength;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult()
:e8MethodResult()
,s8FieldStrength(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_FIELDSTRENGTHMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   (tVoid) (oIn >> s8FieldStrength);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   (tVoid) (oOut << s8FieldStrength);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   bResult = bResult && (s8FieldStrength == roRef.s8FieldStrength);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   b32SetupMask = coRef.b32SetupMask;
   b32SetupFlags = coRef.b32SetupFlags;
   bUseConcealmentLevel = coRef.bUseConcealmentLevel;
   u8ConcealmentLevel = coRef.u8ConcealmentLevel;
   bUseServiceLinkingMode = coRef.bUseServiceLinkingMode;
   e8ServiceLinkingMode = coRef.e8ServiceLinkingMode;
   bUseEnsInsertThreshold = coRef.bUseEnsInsertThreshold;
   u8EnsInsertThreshold = coRef.u8EnsInsertThreshold;
   bUseEnsDeleteThreshold = coRef.bUseEnsDeleteThreshold;
   u8EnsDeleteThreshold = coRef.u8EnsDeleteThreshold;
   bBgLearnUpdateTime = coRef.bBgLearnUpdateTime;
   u8BgLearnUpdateTime = coRef.u8BgLearnUpdateTime;
   bDABScanThreshold = coRef.bDABScanThreshold;
   u8DABScanThreshold = coRef.u8DABScanThreshold;
   bSwitchMeasurementMode = coRef.bSwitchMeasurementMode;
   b8LinkingSetupMask = coRef.b8LinkingSetupMask;
   u8DABFMLinkingThreshold = coRef.u8DABFMLinkingThreshold;
   u8DABFMLinkingBackThreshold = coRef.u8DABFMLinkingBackThreshold;
   u8DABFMLinkingBackValidationTime = coRef.u8DABFMLinkingBackValidationTime;
   u8DABFMLinkBackDelay = coRef.u8DABFMLinkBackDelay;
   bIsTestmode = coRef.bIsTestmode;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart& coRef)
{
   if (this == &coRef) return *this;
   b32SetupMask = coRef.b32SetupMask;
   b32SetupFlags = coRef.b32SetupFlags;
   bUseConcealmentLevel = coRef.bUseConcealmentLevel;
   u8ConcealmentLevel = coRef.u8ConcealmentLevel;
   bUseServiceLinkingMode = coRef.bUseServiceLinkingMode;
   e8ServiceLinkingMode = coRef.e8ServiceLinkingMode;
   bUseEnsInsertThreshold = coRef.bUseEnsInsertThreshold;
   u8EnsInsertThreshold = coRef.u8EnsInsertThreshold;
   bUseEnsDeleteThreshold = coRef.bUseEnsDeleteThreshold;
   u8EnsDeleteThreshold = coRef.u8EnsDeleteThreshold;
   bBgLearnUpdateTime = coRef.bBgLearnUpdateTime;
   u8BgLearnUpdateTime = coRef.u8BgLearnUpdateTime;
   bDABScanThreshold = coRef.bDABScanThreshold;
   u8DABScanThreshold = coRef.u8DABScanThreshold;
   bSwitchMeasurementMode = coRef.bSwitchMeasurementMode;
   b8LinkingSetupMask = coRef.b8LinkingSetupMask;
   u8DABFMLinkingThreshold = coRef.u8DABFMLinkingThreshold;
   u8DABFMLinkingBackThreshold = coRef.u8DABFMLinkingBackThreshold;
   u8DABFMLinkingBackValidationTime = coRef.u8DABFMLinkingBackValidationTime;
   u8DABFMLinkBackDelay = coRef.u8DABFMLinkBackDelay;
   bIsTestmode = coRef.bIsTestmode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart()
:b32SetupMask()
,b32SetupFlags()
,bUseConcealmentLevel(0)
,u8ConcealmentLevel(0)
,bUseServiceLinkingMode(0)
,e8ServiceLinkingMode()
,bUseEnsInsertThreshold(0)
,u8EnsInsertThreshold(0)
,bUseEnsDeleteThreshold(0)
,u8EnsDeleteThreshold(0)
,bBgLearnUpdateTime(0)
,u8BgLearnUpdateTime(0)
,bDABScanThreshold(0)
,u8DABScanThreshold(0)
,bSwitchMeasurementMode(0)
,b8LinkingSetupMask()
,u8DABFMLinkingThreshold(0)
,u8DABFMLinkingBackThreshold(0)
,u8DABFMLinkingBackValidationTime(0)
,u8DABFMLinkBackDelay(0)
,bIsTestmode(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SETUPMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 27;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b32SetupMask);
   (tVoid) (oIn >> b32SetupFlags);
   (tVoid) (oIn >> bUseConcealmentLevel);
   (tVoid) (oIn >> u8ConcealmentLevel);
   (tVoid) (oIn >> bUseServiceLinkingMode);
   (tVoid) (oIn >> e8ServiceLinkingMode);
   (tVoid) (oIn >> bUseEnsInsertThreshold);
   (tVoid) (oIn >> u8EnsInsertThreshold);
   (tVoid) (oIn >> bUseEnsDeleteThreshold);
   (tVoid) (oIn >> u8EnsDeleteThreshold);
   (tVoid) (oIn >> bBgLearnUpdateTime);
   (tVoid) (oIn >> u8BgLearnUpdateTime);
   (tVoid) (oIn >> bDABScanThreshold);
   (tVoid) (oIn >> u8DABScanThreshold);
   (tVoid) (oIn >> bSwitchMeasurementMode);
   (tVoid) (oIn >> b8LinkingSetupMask);
   (tVoid) (oIn >> u8DABFMLinkingThreshold);
   (tVoid) (oIn >> u8DABFMLinkingBackThreshold);
   (tVoid) (oIn >> u8DABFMLinkingBackValidationTime);
   (tVoid) (oIn >> u8DABFMLinkBackDelay);
   (tVoid) (oIn >> bIsTestmode);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b32SetupMask);
   (tVoid) (oOut << b32SetupFlags);
   (tVoid) (oOut << bUseConcealmentLevel);
   (tVoid) (oOut << u8ConcealmentLevel);
   (tVoid) (oOut << bUseServiceLinkingMode);
   (tVoid) (oOut << e8ServiceLinkingMode);
   (tVoid) (oOut << bUseEnsInsertThreshold);
   (tVoid) (oOut << u8EnsInsertThreshold);
   (tVoid) (oOut << bUseEnsDeleteThreshold);
   (tVoid) (oOut << u8EnsDeleteThreshold);
   (tVoid) (oOut << bBgLearnUpdateTime);
   (tVoid) (oOut << u8BgLearnUpdateTime);
   (tVoid) (oOut << bDABScanThreshold);
   (tVoid) (oOut << u8DABScanThreshold);
   (tVoid) (oOut << bSwitchMeasurementMode);
   (tVoid) (oOut << b8LinkingSetupMask);
   (tVoid) (oOut << u8DABFMLinkingThreshold);
   (tVoid) (oOut << u8DABFMLinkingBackThreshold);
   (tVoid) (oOut << u8DABFMLinkingBackValidationTime);
   (tVoid) (oOut << u8DABFMLinkBackDelay);
   (tVoid) (oOut << bIsTestmode);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b32SetupMask == roRef.b32SetupMask);
   bResult = bResult && (b32SetupFlags == roRef.b32SetupFlags);
   bResult = bResult && (bUseConcealmentLevel == roRef.bUseConcealmentLevel);
   bResult = bResult && (u8ConcealmentLevel == roRef.u8ConcealmentLevel);
   bResult = bResult && (bUseServiceLinkingMode == roRef.bUseServiceLinkingMode);
   bResult = bResult && (e8ServiceLinkingMode == roRef.e8ServiceLinkingMode);
   bResult = bResult && (bUseEnsInsertThreshold == roRef.bUseEnsInsertThreshold);
   bResult = bResult && (u8EnsInsertThreshold == roRef.u8EnsInsertThreshold);
   bResult = bResult && (bUseEnsDeleteThreshold == roRef.bUseEnsDeleteThreshold);
   bResult = bResult && (u8EnsDeleteThreshold == roRef.u8EnsDeleteThreshold);
   bResult = bResult && (bBgLearnUpdateTime == roRef.bBgLearnUpdateTime);
   bResult = bResult && (u8BgLearnUpdateTime == roRef.u8BgLearnUpdateTime);
   bResult = bResult && (bDABScanThreshold == roRef.bDABScanThreshold);
   bResult = bResult && (u8DABScanThreshold == roRef.u8DABScanThreshold);
   bResult = bResult && (bSwitchMeasurementMode == roRef.bSwitchMeasurementMode);
   bResult = bResult && (b8LinkingSetupMask == roRef.b8LinkingSetupMask);
   bResult = bResult && (u8DABFMLinkingThreshold == roRef.u8DABFMLinkingThreshold);
   bResult = bResult && (u8DABFMLinkingBackThreshold == roRef.u8DABFMLinkingBackThreshold);
   bResult = bResult && (u8DABFMLinkingBackValidationTime == roRef.u8DABFMLinkingBackValidationTime);
   bResult = bResult && (u8DABFMLinkBackDelay == roRef.u8DABFMLinkBackDelay);
   bResult = bResult && (bIsTestmode == roRef.bIsTestmode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SETUPMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   AnnoConfig = coRef.AnnoConfig;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AnnoConfig = coRef.AnnoConfig;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart()
:AnnoConfig()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ANNO_CONFIGMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AnnoConfig);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AnnoConfig);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AnnoConfig == roRef.AnnoConfig);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ANNO_CONFIGMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   bSelect = coRef.bSelect;
   u16AnnoNumber = coRef.u16AnnoNumber;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bSelect = coRef.bSelect;
   u16AnnoNumber = coRef.u16AnnoNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart()
:bSelect(0)
,u16AnnoNumber(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_ANNOMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSelect);
   (tVoid) (oIn >> u16AnnoNumber);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSelect);
   (tVoid) (oOut << u16AnnoNumber);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSelect == roRef.bSelect);
   bResult = bResult && (u16AnnoNumber == roRef.u16AnnoNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_ANNOMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8BankId = coRef.e8BankId;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8BankId = coRef.e8BankId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart()
:e8BankId()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_BANKMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8BankId);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8BankId);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8BankId == roRef.e8BankId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_BANKMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   u8PresetElemId = coRef.u8PresetElemId;
   u32PSID = coRef.u32PSID;
   u8Scids = coRef.u8Scids;
   u32EnsFrequency = coRef.u32EnsFrequency;
   bDelete = coRef.bDelete;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8PresetElemId = coRef.u8PresetElemId;
   u32PSID = coRef.u32PSID;
   u8Scids = coRef.u8Scids;
   u32EnsFrequency = coRef.u32EnsFrequency;
   bDelete = coRef.bDelete;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart()
:u8PresetElemId(0)
,u32PSID(0)
,u8Scids(0)
,u32EnsFrequency(0)
,bDelete(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SAVE_PRESET_LIST_ELEMMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8PresetElemId);
   (tVoid) (oIn >> u32PSID);
   (tVoid) (oIn >> u8Scids);
   (tVoid) (oIn >> u32EnsFrequency);
   (tVoid) (oIn >> bDelete);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8PresetElemId);
   (tVoid) (oOut << u32PSID);
   (tVoid) (oOut << u8Scids);
   (tVoid) (oOut << u32EnsFrequency);
   (tVoid) (oOut << bDelete);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8PresetElemId == roRef.u8PresetElemId);
   bResult = bResult && (u32PSID == roRef.u32PSID);
   bResult = bResult && (u8Scids == roRef.u8Scids);
   bResult = bResult && (u32EnsFrequency == roRef.u32EnsFrequency);
   bResult = bResult && (bDelete == roRef.bDelete);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SAVE_PRESET_LIST_ELEMMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8Action = coRef.e8Action;
   u8DelPresetElemId = coRef.u8DelPresetElemId;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Action = coRef.e8Action;
   u8DelPresetElemId = coRef.u8DelPresetElemId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart()
:e8Action()
,u8DelPresetElemId(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DELETE_PRESET_LIST_ELEMMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Action);
   (tVoid) (oIn >> u8DelPresetElemId);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Action);
   (tVoid) (oOut << u8DelPresetElemId);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Action == roRef.e8Action);
   bResult = bResult && (u8DelPresetElemId == roRef.u8DelPresetElemId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DELETE_PRESET_LIST_ELEMMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   u8ActPresetElemID = coRef.u8ActPresetElemID;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8ActPresetElemID = coRef.u8ActPresetElemID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart()
:u8ActPresetElemID(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8ActPresetElemID);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8ActPresetElemID);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8ActPresetElemID == roRef.u8ActPresetElemID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   PresetList = coRef.PresetList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PresetList = coRef.PresetList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
         PresetList[u32Idx].vDestroy();
   PresetList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart()

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SAVE_PRESET_LISTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PresetList.size(); ++u32ListIdx)
      u32DynamicSize += PresetList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
      {
         PresetList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PresetList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PresetList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)PresetList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
         (tVoid) (oOut << PresetList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PresetList.size() == roRef.PresetList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresetList.size()); ++u32Idx)
            bResult = bResult && (PresetList[u32Idx] == roRef.PresetList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SAVE_PRESET_LISTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   u8FirstElementID = coRef.u8FirstElementID;
   u8NumberOfElements = coRef.u8NumberOfElements;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8FirstElementID = coRef.u8FirstElementID;
   u8NumberOfElements = coRef.u8NumberOfElements;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart()
:u8FirstElementID(0)
,u8NumberOfElements(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_PRESET_LISTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8FirstElementID);
   (tVoid) (oIn >> u8NumberOfElements);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8FirstElementID);
   (tVoid) (oOut << u8NumberOfElements);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8FirstElementID == roRef.u8FirstElementID);
   bResult = bResult && (u8NumberOfElements == roRef.u8NumberOfElements);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
   u8FirstElementID = coRef.u8FirstElementID;
   u8NumberOfElements = coRef.u8NumberOfElements;
   PresetList = coRef.PresetList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   u8FirstElementID = coRef.u8FirstElementID;
   u8NumberOfElements = coRef.u8NumberOfElements;
   PresetList = coRef.PresetList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
         PresetList[u32Idx].vDestroy();
   PresetList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult()
:e8MethodResult()
,u8FirstElementID(0)
,u8NumberOfElements(0)

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_PRESET_LISTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PresetList.size(); ++u32ListIdx)
      u32DynamicSize += PresetList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   (tVoid) (oIn >> u8FirstElementID);
   (tVoid) (oIn >> u8NumberOfElements);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
      {
         PresetList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PresetList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PresetList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   (tVoid) (oOut << u8FirstElementID);
   (tVoid) (oOut << u8NumberOfElements);
   (tVoid) (oOut << (tU32)PresetList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
         (tVoid) (oOut << PresetList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   bResult = bResult && (u8FirstElementID == roRef.u8FirstElementID);
   bResult = bResult && (u8NumberOfElements == roRef.u8NumberOfElements);
      bResult = bResult && (PresetList.size() == roRef.PresetList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresetList.size()); ++u32Idx)
            bResult = bResult && (PresetList[u32Idx] == roRef.PresetList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   StartAutostore = coRef.StartAutostore;
   AST_Type = coRef.AST_Type;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StartAutostore = coRef.StartAutostore;
   AST_Type = coRef.AST_Type;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart()
:StartAutostore(0)
,AST_Type()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_AUTOSTOREMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StartAutostore);
   (tVoid) (oIn >> AST_Type);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StartAutostore);
   (tVoid) (oOut << AST_Type);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StartAutostore == roRef.StartAutostore);
   bResult = bResult && (AST_Type == roRef.AST_Type);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
   u8NumberOfStationsFound = coRef.u8NumberOfStationsFound;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   u8NumberOfStationsFound = coRef.u8NumberOfStationsFound;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult()
:e8MethodResult()
,u8NumberOfStationsFound(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_AUTOSTOREMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   (tVoid) (oIn >> u8NumberOfStationsFound);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   (tVoid) (oOut << u8NumberOfStationsFound);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   bResult = bResult && (u8NumberOfStationsFound == roRef.u8NumberOfStationsFound);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   enOperation = coRef.enOperation;
   u16FirstElemId = coRef.u16FirstElemId;
   u16NumElem = coRef.u16NumElem;
   enSortingType = coRef.enSortingType;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   enOperation = coRef.enOperation;
   u16FirstElemId = coRef.u16FirstElemId;
   u16NumElem = coRef.u16NumElem;
   enSortingType = coRef.enSortingType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart()
:enOperation()
,u16FirstElemId(0)
,u16NumElem(0)
,enSortingType()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_ENS_LISTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enOperation);
   (tVoid) (oIn >> u16FirstElemId);
   (tVoid) (oIn >> u16NumElem);
   (tVoid) (oIn >> enSortingType);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enOperation);
   (tVoid) (oOut << u16FirstElemId);
   (tVoid) (oOut << u16NumElem);
   (tVoid) (oOut << enSortingType);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enOperation == roRef.enOperation);
   bResult = bResult && (u16FirstElemId == roRef.u16FirstElemId);
   bResult = bResult && (u16NumElem == roRef.u16NumElem);
   bResult = bResult && (enSortingType == roRef.enSortingType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
   EnsembleList = coRef.EnsembleList;
   bOpen = coRef.bOpen;
   u16TotalNumberOfElements = coRef.u16TotalNumberOfElements;
   u16SentNumberOfElements = coRef.u16SentNumberOfElements;
   u16InitialActivatedElementId = coRef.u16InitialActivatedElementId;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   EnsembleList = coRef.EnsembleList;
   bOpen = coRef.bOpen;
   u16TotalNumberOfElements = coRef.u16TotalNumberOfElements;
   u16SentNumberOfElements = coRef.u16SentNumberOfElements;
   u16InitialActivatedElementId = coRef.u16InitialActivatedElementId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < EnsembleList.size(); ++u32Idx)
         EnsembleList[u32Idx].vDestroy();
   EnsembleList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult()
:e8MethodResult()

,bOpen(0)
,u16TotalNumberOfElements(0)
,u16SentNumberOfElements(0)
,u16InitialActivatedElementId(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_ENS_LISTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < EnsembleList.size(); ++u32ListIdx)
      u32DynamicSize += EnsembleList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < EnsembleList.size(); ++u32Idx)
      {
         EnsembleList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      EnsembleList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> EnsembleList[u32Idx]);
      }
   }
   (tVoid) (oIn >> bOpen);
   (tVoid) (oIn >> u16TotalNumberOfElements);
   (tVoid) (oIn >> u16SentNumberOfElements);
   (tVoid) (oIn >> u16InitialActivatedElementId);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   (tVoid) (oOut << (tU32)EnsembleList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < EnsembleList.size(); ++u32Idx)
         (tVoid) (oOut << EnsembleList[u32Idx]);
   }
   (tVoid) (oOut << bOpen);
   (tVoid) (oOut << u16TotalNumberOfElements);
   (tVoid) (oOut << u16SentNumberOfElements);
   (tVoid) (oOut << u16InitialActivatedElementId);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
      bResult = bResult && (EnsembleList.size() == roRef.EnsembleList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < EnsembleList.size()); ++u32Idx)
            bResult = bResult && (EnsembleList[u32Idx] == roRef.EnsembleList[u32Idx]);
      }
   bResult = bResult && (bOpen == roRef.bOpen);
   bResult = bResult && (u16TotalNumberOfElements == roRef.u16TotalNumberOfElements);
   bResult = bResult && (u16SentNumberOfElements == roRef.u16SentNumberOfElements);
   bResult = bResult && (u16InitialActivatedElementId == roRef.u16InitialActivatedElementId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   enOperation = coRef.enOperation;
   enServiceListType = coRef.enServiceListType;
   u32PTYFilter = coRef.u32PTYFilter;
   u16FirstElemId = coRef.u16FirstElemId;
   u16NumElem = coRef.u16NumElem;
   enSortingType = coRef.enSortingType;
   u16EnsembleIndex = coRef.u16EnsembleIndex;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   enOperation = coRef.enOperation;
   enServiceListType = coRef.enServiceListType;
   u32PTYFilter = coRef.u32PTYFilter;
   u16FirstElemId = coRef.u16FirstElemId;
   u16NumElem = coRef.u16NumElem;
   enSortingType = coRef.enSortingType;
   u16EnsembleIndex = coRef.u16EnsembleIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart()
:enOperation()
,enServiceListType()
,u32PTYFilter(0)
,u16FirstElemId(0)
,u16NumElem(0)
,enSortingType()
,u16EnsembleIndex(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_SRV_LISTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enOperation);
   (tVoid) (oIn >> enServiceListType);
   (tVoid) (oIn >> u32PTYFilter);
   (tVoid) (oIn >> u16FirstElemId);
   (tVoid) (oIn >> u16NumElem);
   (tVoid) (oIn >> enSortingType);
   (tVoid) (oIn >> u16EnsembleIndex);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enOperation);
   (tVoid) (oOut << enServiceListType);
   (tVoid) (oOut << u32PTYFilter);
   (tVoid) (oOut << u16FirstElemId);
   (tVoid) (oOut << u16NumElem);
   (tVoid) (oOut << enSortingType);
   (tVoid) (oOut << u16EnsembleIndex);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enOperation == roRef.enOperation);
   bResult = bResult && (enServiceListType == roRef.enServiceListType);
   bResult = bResult && (u32PTYFilter == roRef.u32PTYFilter);
   bResult = bResult && (u16FirstElemId == roRef.u16FirstElemId);
   bResult = bResult && (u16NumElem == roRef.u16NumElem);
   bResult = bResult && (enSortingType == roRef.enSortingType);
   bResult = bResult && (u16EnsembleIndex == roRef.u16EnsembleIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
   enServiceListType = coRef.enServiceListType;
   ChannelList = coRef.ChannelList;
   bOpen = coRef.bOpen;
   u16TotalNumberOfElements = coRef.u16TotalNumberOfElements;
   u16SentNumberOfElements = coRef.u16SentNumberOfElements;
   u16InitialActivatedElementId = coRef.u16InitialActivatedElementId;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   enServiceListType = coRef.enServiceListType;
   ChannelList = coRef.ChannelList;
   bOpen = coRef.bOpen;
   u16TotalNumberOfElements = coRef.u16TotalNumberOfElements;
   u16SentNumberOfElements = coRef.u16SentNumberOfElements;
   u16InitialActivatedElementId = coRef.u16InitialActivatedElementId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
         ChannelList[u32Idx].vDestroy();
   ChannelList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult()
:e8MethodResult()
,enServiceListType()

,bOpen(0)
,u16TotalNumberOfElements(0)
,u16SentNumberOfElements(0)
,u16InitialActivatedElementId(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_SRV_LISTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ChannelList.size(); ++u32ListIdx)
      u32DynamicSize += ChannelList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+13;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   (tVoid) (oIn >> enServiceListType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
      {
         ChannelList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelList[u32Idx]);
      }
   }
   (tVoid) (oIn >> bOpen);
   (tVoid) (oIn >> u16TotalNumberOfElements);
   (tVoid) (oIn >> u16SentNumberOfElements);
   (tVoid) (oIn >> u16InitialActivatedElementId);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   (tVoid) (oOut << enServiceListType);
   (tVoid) (oOut << (tU32)ChannelList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelList.size(); ++u32Idx)
         (tVoid) (oOut << ChannelList[u32Idx]);
   }
   (tVoid) (oOut << bOpen);
   (tVoid) (oOut << u16TotalNumberOfElements);
   (tVoid) (oOut << u16SentNumberOfElements);
   (tVoid) (oOut << u16InitialActivatedElementId);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   bResult = bResult && (enServiceListType == roRef.enServiceListType);
      bResult = bResult && (ChannelList.size() == roRef.ChannelList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelList.size()); ++u32Idx)
            bResult = bResult && (ChannelList[u32Idx] == roRef.ChannelList[u32Idx]);
      }
   bResult = bResult && (bOpen == roRef.bOpen);
   bResult = bResult && (u16TotalNumberOfElements == roRef.u16TotalNumberOfElements);
   bResult = bResult && (u16SentNumberOfElements == roRef.u16SentNumberOfElements);
   bResult = bResult && (u16InitialActivatedElementId == roRef.u16InitialActivatedElementId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   enOperation = coRef.enOperation;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   enOperation = coRef.enOperation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart()
:enOperation()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_COMP_LISTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enOperation);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enOperation);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enOperation == roRef.enOperation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_COMP_LISTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_VALIDATE_EPG_LISTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
   bEPGAvailability = coRef.bEPGAvailability;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   bEPGAvailability = coRef.bEPGAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult()
:e8MethodResult()
,bEPGAvailability(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_VALIDATE_EPG_LISTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   (tVoid) (oIn >> bEPGAvailability);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   (tVoid) (oOut << bEPGAvailability);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   bResult = bResult && (bEPGAvailability == roRef.bEPGAvailability);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   enOperation = coRef.enOperation;
   u32Value1 = coRef.u32Value1;
   u32Value2 = coRef.u32Value2;
   u32Value3 = coRef.u32Value3;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart& coRef)
{
   if (this == &coRef) return *this;
   enOperation = coRef.enOperation;
   u32Value1 = coRef.u32Value1;
   u32Value2 = coRef.u32Value2;
   u32Value3 = coRef.u32Value3;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart()
:enOperation()
,u32Value1(0)
,u32Value2(0)
,u32Value3(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TEST_OPERATIONMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enOperation);
   (tVoid) (oIn >> u32Value1);
   (tVoid) (oIn >> u32Value2);
   (tVoid) (oIn >> u32Value3);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enOperation);
   (tVoid) (oOut << u32Value1);
   (tVoid) (oOut << u32Value2);
   (tVoid) (oOut << u32Value3);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enOperation == roRef.enOperation);
   bResult = bResult && (u32Value1 == roRef.u32Value1);
   bResult = bResult && (u32Value2 == roRef.u32Value2);
   bResult = bResult && (u32Value3 == roRef.u32Value3);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TEST_OPERATIONMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   bSet = coRef.bSet;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bSet = coRef.bSet;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart()
:bSet(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DEFAULT_SETTINGSMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSet);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSet);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSet == roRef.bSet);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DEFAULT_SETTINGSMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_STOP_ANNOMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_STOP_ANNOMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   u32EnsembleId = coRef.u32EnsembleId;
   RdbIDList = coRef.RdbIDList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32EnsembleId = coRef.u32EnsembleId;
   RdbIDList = coRef.RdbIDList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RdbIDList.size(); ++u32Idx)
         RdbIDList[u32Idx].vDestroy();
   RdbIDList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart()
:u32EnsembleId(0)

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_TMCMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(RdbIDList.size()*7);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32EnsembleId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RdbIDList.size(); ++u32Idx)
      {
         RdbIDList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RdbIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RdbIDList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32EnsembleId);
   (tVoid) (oOut << (tU32)RdbIDList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RdbIDList.size(); ++u32Idx)
         (tVoid) (oOut << RdbIDList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32EnsembleId == roRef.u32EnsembleId);
      bResult = bResult && (RdbIDList.size() == roRef.RdbIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RdbIDList.size()); ++u32Idx)
            bResult = bResult && (RdbIDList[u32Idx] == roRef.RdbIDList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SELECT_TMCMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   u8NumberOfElements = coRef.u8NumberOfElements;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8NumberOfElements = coRef.u8NumberOfElements;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart()
:u8NumberOfElements(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TPEG_URI_LISTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumberOfElements);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumberOfElements);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumberOfElements == roRef.u8NumberOfElements);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
   TpegUriChannelList = coRef.TpegUriChannelList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   TpegUriChannelList = coRef.TpegUriChannelList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TpegUriChannelList.size(); ++u32Idx)
         TpegUriChannelList[u32Idx].vDestroy();
   TpegUriChannelList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult()
:e8MethodResult()

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TPEG_URI_LISTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TpegUriChannelList.size(); ++u32ListIdx)
      u32DynamicSize += TpegUriChannelList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TpegUriChannelList.size(); ++u32Idx)
      {
         TpegUriChannelList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TpegUriChannelList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TpegUriChannelList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   (tVoid) (oOut << (tU32)TpegUriChannelList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TpegUriChannelList.size(); ++u32Idx)
         (tVoid) (oOut << TpegUriChannelList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
      bResult = bResult && (TpegUriChannelList.size() == roRef.TpegUriChannelList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TpegUriChannelList.size()); ++u32Idx)
            bResult = bResult && (TpegUriChannelList[u32Idx] == roRef.TpegUriChannelList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   bActive = coRef.bActive;
   sTpegUriChn = coRef.sTpegUriChn;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bActive = coRef.bActive;
   sTpegUriChn = coRef.sTpegUriChn;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart::vDestroy()
{
   sTpegUriChn.vDestroy(); 
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart()
:bActive(0)
,sTpegUriChn()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_TPEG_CHNMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sTpegUriChn.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bActive);
   (tVoid) (oIn >> sTpegUriChn);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bActive);
   (tVoid) (oOut << sTpegUriChn);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bActive == roRef.bActive);
   bResult = bResult && (sTpegUriChn == roRef.sTpegUriChn);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_TPEG_CHNMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   RdbIDList = coRef.RdbIDList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RdbIDList = coRef.RdbIDList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RdbIDList.size(); ++u32Idx)
         RdbIDList[u32Idx].vDestroy();
   RdbIDList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart()

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_RDBID_WISH_LISTMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(RdbIDList.size()*7);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RdbIDList.size(); ++u32Idx)
      {
         RdbIDList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RdbIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RdbIDList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)RdbIDList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RdbIDList.size(); ++u32Idx)
         (tVoid) (oOut << RdbIDList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (RdbIDList.size() == roRef.RdbIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RdbIDList.size()); ++u32Idx)
            bResult = bResult && (RdbIDList[u32Idx] == roRef.RdbIDList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   RdbIDList = coRef.RdbIDList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RdbIDList = coRef.RdbIDList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RdbIDList.size(); ++u32Idx)
         RdbIDList[u32Idx].vDestroy();
   RdbIDList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult()

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_RDBID_WISH_LISTMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(RdbIDList.size()*7);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RdbIDList.size(); ++u32Idx)
      {
         RdbIDList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RdbIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RdbIDList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)RdbIDList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RdbIDList.size(); ++u32Idx)
         (tVoid) (oOut << RdbIDList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (RdbIDList.size() == roRef.RdbIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RdbIDList.size()); ++u32Idx)
            bResult = bResult && (RdbIDList[u32Idx] == roRef.RdbIDList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   bActive = coRef.bActive;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bActive = coRef.bActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart()
:bActive(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_TESTMODEMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bActive);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bActive);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bActive == roRef.bActive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_TESTMODEMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   u16ExpApiId = coRef.u16ExpApiId;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ExpApiId = coRef.u16ExpApiId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart()
:u16ExpApiId(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_EXP_API_INFOMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ExpApiId);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ExpApiId);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ExpApiId == roRef.u16ExpApiId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   u16ExpApiId = coRef.u16ExpApiId;
   sLabel = coRef.sLabel;
   sValue = coRef.sValue;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16ExpApiId = coRef.u16ExpApiId;
   sLabel = coRef.sLabel;
   sValue = coRef.sValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult::vDestroy()
{
   sLabel.vDestroy();
   sValue.vDestroy();
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult()
:u16ExpApiId(0)
,sLabel()
,sValue()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_GET_EXP_API_INFOMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sLabel.u32GetSize(u16MajorVersion)+sValue.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ExpApiId);
   (tVoid) (oIn >> sLabel);
   (tVoid) (oIn >> sValue);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ExpApiId);
   (tVoid) (oOut << sLabel);
   (tVoid) (oOut << sValue);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ExpApiId == roRef.u16ExpApiId);
   bResult = bResult && (sLabel == roRef.sLabel);
   bResult = bResult && (sValue == roRef.sValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   u8Adr3DbQuery = coRef.u8Adr3DbQuery;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Adr3DbQuery = coRef.u8Adr3DbQuery;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart()
:u8Adr3DbQuery(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DB_QUERYMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Adr3DbQuery);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Adr3DbQuery);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Adr3DbQuery == roRef.u8Adr3DbQuery);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   u8Adr3DbQuery = coRef.u8Adr3DbQuery;
   sDbQuery = coRef.sDbQuery;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8Adr3DbQuery = coRef.u8Adr3DbQuery;
   sDbQuery = coRef.sDbQuery;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult::vDestroy()
{
   sDbQuery.vDestroy();
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult()
:u8Adr3DbQuery(0)
,sDbQuery()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DB_QUERYMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sDbQuery.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Adr3DbQuery);
   (tVoid) (oIn >> sDbQuery);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Adr3DbQuery);
   (tVoid) (oOut << sDbQuery);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Adr3DbQuery == roRef.u8Adr3DbQuery);
   bResult = bResult && (sDbQuery == roRef.sDbQuery);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   enTuneCmd = coRef.enTuneCmd;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   enTuneCmd = coRef.enTuneCmd;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart()
:enTuneCmd()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SEEK_ENSEMBLEMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enTuneCmd);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enTuneCmd);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enTuneCmd == roRef.enTuneCmd);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SEEK_ENSEMBLEMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   enTuneCmd = coRef.enTuneCmd;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   enTuneCmd = coRef.enTuneCmd;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart()
:enTuneCmd()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SEEK_SERVICEMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enTuneCmd);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enTuneCmd);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enTuneCmd == roRef.enTuneCmd);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SEEK_SERVICEMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   enTuneCmd = coRef.enTuneCmd;
   u32Frequency = coRef.u32Frequency;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart& coRef)
{
   if (this == &coRef) return *this;
   enTuneCmd = coRef.enTuneCmd;
   u32Frequency = coRef.u32Frequency;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart()
:enTuneCmd()
,u32Frequency(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TARGET_SEEKMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enTuneCmd);
   (tVoid) (oIn >> u32Frequency);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enTuneCmd);
   (tVoid) (oOut << u32Frequency);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enTuneCmd == roRef.enTuneCmd);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TARGET_SEEKMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8DabSource = coRef.e8DabSource;
   e8MuteStatus = coRef.e8MuteStatus;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8DabSource = coRef.e8DabSource;
   e8MuteStatus = coRef.e8MuteStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart()
:e8DabSource()
,e8MuteStatus()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_MUTE_STATUSMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DabSource);
   (tVoid) (oIn >> e8MuteStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DabSource);
   (tVoid) (oOut << e8MuteStatus);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DabSource == roRef.e8DabSource);
   bResult = bResult && (e8MuteStatus == roRef.e8MuteStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_SET_MUTE_STATUSMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   LogoList = coRef.LogoList;
   ContentIDList = coRef.ContentIDList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LogoList = coRef.LogoList;
   ContentIDList = coRef.ContentIDList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LogoList.size(); ++u32Idx)
         LogoList[u32Idx].vDestroy();
   LogoList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < ContentIDList.size(); ++u32Idx)
         ContentIDList[u32Idx].vDestroy();
   ContentIDList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart()


 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DATASERVICES_DATAMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LogoList.size(); ++u32ListIdx)
      u32DynamicSize += LogoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+ static_cast<tU32>(ContentIDList.size()*5);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LogoList.size(); ++u32Idx)
      {
         LogoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      LogoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> LogoList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ContentIDList.size(); ++u32Idx)
      {
         ContentIDList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ContentIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContentIDList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)LogoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < LogoList.size(); ++u32Idx)
         (tVoid) (oOut << LogoList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)ContentIDList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContentIDList.size(); ++u32Idx)
         (tVoid) (oOut << ContentIDList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (LogoList.size() == roRef.LogoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LogoList.size()); ++u32Idx)
            bResult = bResult && (LogoList[u32Idx] == roRef.LogoList[u32Idx]);
      }
      bResult = bResult && (ContentIDList.size() == roRef.ContentIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContentIDList.size()); ++u32Idx)
            bResult = bResult && (ContentIDList[u32Idx] == roRef.ContentIDList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DATASERVICES_DATAMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   DSMMsg = coRef.DSMMsg;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DSMMsg = coRef.DSMMsg;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart::vDestroy()
{
   DSMMsg.vDestroy(); 
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart()
:DSMMsg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DSM_MSGMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DSMMsg.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DSMMsg);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DSMMsg);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DSMMsg == roRef.DSMMsg);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_DSM_MSGMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   b8Mode = coRef.b8Mode;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   b8Mode = coRef.b8Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart()
:b8Mode()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_MTC_SETMODEMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b8Mode);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b8Mode);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b8Mode == roRef.b8Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_MTC_SETMODEMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   FrequencyLabel = coRef.FrequencyLabel;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FrequencyLabel = coRef.FrequencyLabel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart::vDestroy()
{
   FrequencyLabel.vDestroy();
}

midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart()
:FrequencyLabel()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TUNE_FREQUENCY_LABELMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+FrequencyLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FrequencyLabel);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FrequencyLabel);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FrequencyLabel == roRef.FrequencyLabel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult()
:e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_TUNE_FREQUENCY_LABELMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   Action = coRef.Action;
   UserID = coRef.UserID;
   DestinationUserID = coRef.DestinationUserID;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart& midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Action = coRef.Action;
   UserID = coRef.UserID;
   DestinationUserID = coRef.DestinationUserID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart::midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart()
:Action()
,UserID(0)
,DestinationUserID(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_USER_PROFILE_UPDATEMETHODSTART;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> UserID);
   (tVoid) (oIn >> DestinationUserID);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Action);
   (tVoid) (oOut << UserID);
   (tVoid) (oOut << DestinationUserID);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (UserID == roRef.UserID);
   bResult = bResult && (DestinationUserID == roRef.DestinationUserID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   Action = coRef.Action;
   ActiveUserID = coRef.ActiveUserID;
   e8MethodResult = coRef.e8MethodResult;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult& midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Action = coRef.Action;
   ActiveUserID = coRef.ActiveUserID;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult::midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult()
:Action()
,ActiveUserID(0)
,e8MethodResult()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_S_USER_PROFILE_UPDATEMETHODRESULT;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult::~midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> ActiveUserID);
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Action);
   (tVoid) (oOut << ActiveUserID);
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (ActiveUserID == roRef.ActiveUserID);
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TUNER_STATUSUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TUNER_STATUSRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TUNER_STATUSGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   TunerStatus = coRef.TunerStatus;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   TunerStatus = coRef.TunerStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus::vDestroy()
{
   TunerStatus.vDestroy(); 
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus()
:TunerStatus()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TUNER_STATUSSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TunerStatus.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerStatus);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerStatus == roRef.TunerStatus);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_AVAILABILITYUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_AVAILABILITYRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_AVAILABILITYGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   bIsDABAvailable = coRef.bIsDABAvailable;
   e8SourceState = coRef.e8SourceState;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus& coRef)
{
   if (this == &coRef) return *this;
   bIsDABAvailable = coRef.bIsDABAvailable;
   e8SourceState = coRef.e8SourceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus()
:bIsDABAvailable(0)
,e8SourceState()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_AVAILABILITYSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bIsDABAvailable);
   (tVoid) (oIn >> e8SourceState);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bIsDABAvailable);
   (tVoid) (oOut << e8SourceState);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bIsDABAvailable == roRef.bIsDABAvailable);
   bResult = bResult && (e8SourceState == roRef.e8SourceState);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ADR_MSGUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ADR_MSGRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ADR_MSGGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   TunerStatus = coRef.TunerStatus;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus& coRef)
{
   if (this == &coRef) return *this;
   TunerStatus = coRef.TunerStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus::vDestroy()
{
   TunerStatus.vDestroy(); 
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus()
:TunerStatus()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ADR_MSGSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TunerStatus.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerStatus);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerStatus == roRef.TunerStatus);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LOCAL_OFFSETUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LOCAL_OFFSETRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LOCAL_OFFSETGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   LocalOffset = coRef.LocalOffset;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus& coRef)
{
   if (this == &coRef) return *this;
   LocalOffset = coRef.LocalOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus()
:LocalOffset(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LOCAL_OFFSETSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LocalOffset);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LocalOffset);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LocalOffset == roRef.LocalOffset);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ANNO_STATUSUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ANNO_STATUSRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ANNO_STATUSGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   AnnoStatus = coRef.AnnoStatus;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   AnnoStatus = coRef.AnnoStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus::vDestroy()
{
   AnnoStatus.vDestroy(); 
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus()
:AnnoStatus()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ANNO_STATUSSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AnnoStatus.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AnnoStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AnnoStatus);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AnnoStatus == roRef.AnnoStatus);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_CHANNEL_INFOUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFORelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFORelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFORelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_CHANNEL_INFORELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFORelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFORelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_CHANNEL_INFOGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   ChannelInfo = coRef.ChannelInfo;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus& coRef)
{
   if (this == &coRef) return *this;
   ChannelInfo = coRef.ChannelInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus::vDestroy()
{
   ChannelInfo.vDestroy(); 
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus()
:ChannelInfo()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_CHANNEL_INFOSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ChannelInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelInfo);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelInfo == roRef.ChannelInfo);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_COMP_LISTUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_COMP_LISTRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_COMP_LISTGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   bOpen = coRef.bOpen;
   u16NumberOfComponents = coRef.u16NumberOfComponents;
   u16ActivatedElementId = coRef.u16ActivatedElementId;
   ComponentList = coRef.ComponentList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus& coRef)
{
   if (this == &coRef) return *this;
   bOpen = coRef.bOpen;
   u16NumberOfComponents = coRef.u16NumberOfComponents;
   u16ActivatedElementId = coRef.u16ActivatedElementId;
   ComponentList = coRef.ComponentList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ComponentList.size(); ++u32Idx)
         ComponentList[u32Idx].vDestroy();
   ComponentList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus()
:bOpen(0)
,u16NumberOfComponents(0)
,u16ActivatedElementId(0)

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_COMP_LISTSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ComponentList.size(); ++u32ListIdx)
      u32DynamicSize += ComponentList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bOpen);
   (tVoid) (oIn >> u16NumberOfComponents);
   (tVoid) (oIn >> u16ActivatedElementId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ComponentList.size(); ++u32Idx)
      {
         ComponentList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ComponentList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ComponentList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bOpen);
   (tVoid) (oOut << u16NumberOfComponents);
   (tVoid) (oOut << u16ActivatedElementId);
   (tVoid) (oOut << (tU32)ComponentList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ComponentList.size(); ++u32Idx)
         (tVoid) (oOut << ComponentList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bOpen == roRef.bOpen);
   bResult = bResult && (u16NumberOfComponents == roRef.u16NumberOfComponents);
   bResult = bResult && (u16ActivatedElementId == roRef.u16ActivatedElementId);
      bResult = bResult && (ComponentList.size() == roRef.ComponentList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ComponentList.size()); ++u32Idx)
            bResult = bResult && (ComponentList[u32Idx] == roRef.ComponentList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_PRESET_LISTUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_PRESET_LISTRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_PRESET_LISTGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   u8FirstElementID = coRef.u8FirstElementID;
   u8NumberOfElements = coRef.u8NumberOfElements;
   PresetList = coRef.PresetList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus& coRef)
{
   if (this == &coRef) return *this;
   u8FirstElementID = coRef.u8FirstElementID;
   u8NumberOfElements = coRef.u8NumberOfElements;
   PresetList = coRef.PresetList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
         PresetList[u32Idx].vDestroy();
   PresetList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus()
:u8FirstElementID(0)
,u8NumberOfElements(0)

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_PRESET_LISTSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PresetList.size(); ++u32ListIdx)
      u32DynamicSize += PresetList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8FirstElementID);
   (tVoid) (oIn >> u8NumberOfElements);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
      {
         PresetList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PresetList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PresetList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8FirstElementID);
   (tVoid) (oOut << u8NumberOfElements);
   (tVoid) (oOut << (tU32)PresetList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
         (tVoid) (oOut << PresetList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8FirstElementID == roRef.u8FirstElementID);
   bResult = bResult && (u8NumberOfElements == roRef.u8NumberOfElements);
      bResult = bResult && (PresetList.size() == roRef.PresetList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresetList.size()); ++u32Idx)
            bResult = bResult && (PresetList[u32Idx] == roRef.PresetList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SETUP_STATUSUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SETUP_STATUSRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SETUP_STATUSGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   b32SetupFlags = coRef.b32SetupFlags;
   e8ServiceLinkingMode = coRef.e8ServiceLinkingMode;
   u8ConcealmentLevel = coRef.u8ConcealmentLevel;
   u8DABFMLinkingThreshold = coRef.u8DABFMLinkingThreshold;
   u8DABFMLinkBackDelay = coRef.u8DABFMLinkBackDelay;
   u8DABFMLinkingBackThreshold = coRef.u8DABFMLinkingBackThreshold;
   u8DABFMLinkingBackValidationTime = coRef.u8DABFMLinkingBackValidationTime;
   u8EnsInsertThreshold = coRef.u8EnsInsertThreshold;
   u8EnsDeleteThreshold = coRef.u8EnsDeleteThreshold;
   u8BgLearnUpdateTime = coRef.u8BgLearnUpdateTime;
   u8DABScanThreshold = coRef.u8DABScanThreshold;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   b32SetupFlags = coRef.b32SetupFlags;
   e8ServiceLinkingMode = coRef.e8ServiceLinkingMode;
   u8ConcealmentLevel = coRef.u8ConcealmentLevel;
   u8DABFMLinkingThreshold = coRef.u8DABFMLinkingThreshold;
   u8DABFMLinkBackDelay = coRef.u8DABFMLinkBackDelay;
   u8DABFMLinkingBackThreshold = coRef.u8DABFMLinkingBackThreshold;
   u8DABFMLinkingBackValidationTime = coRef.u8DABFMLinkingBackValidationTime;
   u8EnsInsertThreshold = coRef.u8EnsInsertThreshold;
   u8EnsDeleteThreshold = coRef.u8EnsDeleteThreshold;
   u8BgLearnUpdateTime = coRef.u8BgLearnUpdateTime;
   u8DABScanThreshold = coRef.u8DABScanThreshold;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus()
:b32SetupFlags()
,e8ServiceLinkingMode()
,u8ConcealmentLevel(0)
,u8DABFMLinkingThreshold(0)
,u8DABFMLinkBackDelay(0)
,u8DABFMLinkingBackThreshold(0)
,u8DABFMLinkingBackValidationTime(0)
,u8EnsInsertThreshold(0)
,u8EnsDeleteThreshold(0)
,u8BgLearnUpdateTime(0)
,u8DABScanThreshold(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SETUP_STATUSSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b32SetupFlags);
   (tVoid) (oIn >> e8ServiceLinkingMode);
   (tVoid) (oIn >> u8ConcealmentLevel);
   (tVoid) (oIn >> u8DABFMLinkingThreshold);
   (tVoid) (oIn >> u8DABFMLinkBackDelay);
   (tVoid) (oIn >> u8DABFMLinkingBackThreshold);
   (tVoid) (oIn >> u8DABFMLinkingBackValidationTime);
   (tVoid) (oIn >> u8EnsInsertThreshold);
   (tVoid) (oIn >> u8EnsDeleteThreshold);
   (tVoid) (oIn >> u8BgLearnUpdateTime);
   (tVoid) (oIn >> u8DABScanThreshold);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b32SetupFlags);
   (tVoid) (oOut << e8ServiceLinkingMode);
   (tVoid) (oOut << u8ConcealmentLevel);
   (tVoid) (oOut << u8DABFMLinkingThreshold);
   (tVoid) (oOut << u8DABFMLinkBackDelay);
   (tVoid) (oOut << u8DABFMLinkingBackThreshold);
   (tVoid) (oOut << u8DABFMLinkingBackValidationTime);
   (tVoid) (oOut << u8EnsInsertThreshold);
   (tVoid) (oOut << u8EnsDeleteThreshold);
   (tVoid) (oOut << u8BgLearnUpdateTime);
   (tVoid) (oOut << u8DABScanThreshold);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b32SetupFlags == roRef.b32SetupFlags);
   bResult = bResult && (e8ServiceLinkingMode == roRef.e8ServiceLinkingMode);
   bResult = bResult && (u8ConcealmentLevel == roRef.u8ConcealmentLevel);
   bResult = bResult && (u8DABFMLinkingThreshold == roRef.u8DABFMLinkingThreshold);
   bResult = bResult && (u8DABFMLinkBackDelay == roRef.u8DABFMLinkBackDelay);
   bResult = bResult && (u8DABFMLinkingBackThreshold == roRef.u8DABFMLinkingBackThreshold);
   bResult = bResult && (u8DABFMLinkingBackValidationTime == roRef.u8DABFMLinkingBackValidationTime);
   bResult = bResult && (u8EnsInsertThreshold == roRef.u8EnsInsertThreshold);
   bResult = bResult && (u8EnsDeleteThreshold == roRef.u8EnsDeleteThreshold);
   bResult = bResult && (u8BgLearnUpdateTime == roRef.u8BgLearnUpdateTime);
   bResult = bResult && (u8DABScanThreshold == roRef.u8DABScanThreshold);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SERVICE_FOLLOWING_STATUSUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SERVICE_FOLLOWING_STATUSRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SERVICE_FOLLOWING_STATUSGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8ServiceFollowingTuner = coRef.e8ServiceFollowingTuner;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ServiceFollowingTuner = coRef.e8ServiceFollowingTuner;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus()
:e8ServiceFollowingTuner()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SERVICE_FOLLOWING_STATUSSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ServiceFollowingTuner);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ServiceFollowingTuner);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ServiceFollowingTuner == roRef.e8ServiceFollowingTuner);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_STATUSUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_STATUSRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_STATUSGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   e8MuteStatus = coRef.e8MuteStatus;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   e8MuteStatus = coRef.e8MuteStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus()
:e8MuteStatus()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_STATUSSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MuteStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MuteStatus);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MuteStatus == roRef.e8MuteStatus);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_REQUESTUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_REQUESTRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_REQUESTGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   bRequestMute = coRef.bRequestMute;
   u8Attenuation = coRef.u8Attenuation;
   bMute_Interrupt = coRef.bMute_Interrupt;
   bTa = coRef.bTa;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus& coRef)
{
   if (this == &coRef) return *this;
   bRequestMute = coRef.bRequestMute;
   u8Attenuation = coRef.u8Attenuation;
   bMute_Interrupt = coRef.bMute_Interrupt;
   bTa = coRef.bTa;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus()
:bRequestMute(0)
,u8Attenuation(0)
,bMute_Interrupt(0)
,bTa(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MUTE_REQUESTSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRequestMute);
   (tVoid) (oIn >> u8Attenuation);
   (tVoid) (oIn >> bMute_Interrupt);
   (tVoid) (oIn >> bTa);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRequestMute);
   (tVoid) (oOut << u8Attenuation);
   (tVoid) (oOut << bMute_Interrupt);
   (tVoid) (oOut << bTa);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRequestMute == roRef.bRequestMute);
   bResult = bResult && (u8Attenuation == roRef.u8Attenuation);
   bResult = bResult && (bMute_Interrupt == roRef.bMute_Interrupt);
   bResult = bResult && (bTa == roRef.bTa);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LEARNUPDATE_PROGRESSUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LEARNUPDATE_PROGRESSRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LEARNUPDATE_PROGRESSGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   u8LearnPercentage = coRef.u8LearnPercentage;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus& coRef)
{
   if (this == &coRef) return *this;
   u8LearnPercentage = coRef.u8LearnPercentage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus()
:u8LearnPercentage(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LEARNUPDATE_PROGRESSSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8LearnPercentage);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8LearnPercentage);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8LearnPercentage == roRef.u8LearnPercentage);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRV_LIST_UPDATEUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATERelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATERelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRV_LIST_UPDATERELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATERelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATERelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRV_LIST_UPDATEGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   bActive = coRef.bActive;
   bUpdateRunning = coRef.bUpdateRunning;
   u16ActivatedElementId = coRef.u16ActivatedElementId;
   ChangedSrvAvailList = coRef.ChangedSrvAvailList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus& coRef)
{
   if (this == &coRef) return *this;
   bActive = coRef.bActive;
   bUpdateRunning = coRef.bUpdateRunning;
   u16ActivatedElementId = coRef.u16ActivatedElementId;
   ChangedSrvAvailList = coRef.ChangedSrvAvailList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChangedSrvAvailList.size(); ++u32Idx)
         ChangedSrvAvailList[u32Idx].vDestroy();
   ChangedSrvAvailList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus()
:bActive(0)
,bUpdateRunning(0)
,u16ActivatedElementId(0)

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRV_LIST_UPDATESTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(ChangedSrvAvailList.size()*3);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bActive);
   (tVoid) (oIn >> bUpdateRunning);
   (tVoid) (oIn >> u16ActivatedElementId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChangedSrvAvailList.size(); ++u32Idx)
      {
         ChangedSrvAvailList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChangedSrvAvailList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChangedSrvAvailList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bActive);
   (tVoid) (oOut << bUpdateRunning);
   (tVoid) (oOut << u16ActivatedElementId);
   (tVoid) (oOut << (tU32)ChangedSrvAvailList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChangedSrvAvailList.size(); ++u32Idx)
         (tVoid) (oOut << ChangedSrvAvailList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bActive == roRef.bActive);
   bResult = bResult && (bUpdateRunning == roRef.bUpdateRunning);
   bResult = bResult && (u16ActivatedElementId == roRef.u16ActivatedElementId);
      bResult = bResult && (ChangedSrvAvailList.size() == roRef.ChangedSrvAvailList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChangedSrvAvailList.size()); ++u32Idx)
            bResult = bResult && (ChangedSrvAvailList[u32Idx] == roRef.ChangedSrvAvailList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TESTMODE_DATAUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TESTMODE_DATARELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TESTMODE_DATAGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   TestModeData = coRef.TestModeData;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus& coRef)
{
   if (this == &coRef) return *this;
   TestModeData = coRef.TestModeData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus::vDestroy()
{
   TestModeData.vDestroy(); 
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus()
:TestModeData()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TESTMODE_DATASTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TestModeData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestModeData);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestModeData);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestModeData == roRef.TestModeData);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_ENSEMBLE_INFOUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_ENSEMBLE_INFORELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   EnsembleInfo = coRef.EnsembleInfo;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& coRef)
{
   if (this == &coRef) return *this;
   EnsembleInfo = coRef.EnsembleInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus::vDestroy()
{
   EnsembleInfo.vDestroy(); 
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus()
:EnsembleInfo()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_ENSEMBLE_INFOSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+EnsembleInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EnsembleInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EnsembleInfo);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EnsembleInfo == roRef.EnsembleInfo);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_SERVICE_INFOUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_SERVICE_INFORELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_SERVICE_INFOGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   ServiceInfo = coRef.ServiceInfo;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus& coRef)
{
   if (this == &coRef) return *this;
   ServiceInfo = coRef.ServiceInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus::vDestroy()
{
   ServiceInfo.vDestroy(); 
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus()
:ServiceInfo()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_SERVICE_INFOSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ServiceInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceInfo);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceInfo == roRef.ServiceInfo);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_COMPONENT_INFOUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_COMPONENT_INFORELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_COMPONENT_INFOGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   ComponentInfo = coRef.ComponentInfo;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus& coRef)
{
   if (this == &coRef) return *this;
   ComponentInfo = coRef.ComponentInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus::vDestroy()
{
   ComponentInfo.vDestroy(); 
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus()
:ComponentInfo()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_ACTIVE_COMPONENT_INFOSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ComponentInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ComponentInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ComponentInfo);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ComponentInfo == roRef.ComponentInfo);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_BG_TESTMODE_DATAUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_BG_TESTMODE_DATARELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_BG_TESTMODE_DATAGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   BG_TestModeData = coRef.BG_TestModeData;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus& coRef)
{
   if (this == &coRef) return *this;
   BG_TestModeData = coRef.BG_TestModeData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus::vDestroy()
{
   BG_TestModeData.vDestroy(); 
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus()
:BG_TestModeData()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_BG_TESTMODE_DATASTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+BG_TestModeData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BG_TestModeData);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BG_TestModeData);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BG_TestModeData == roRef.BG_TestModeData);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_TPEG_DATAUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_TPEG_DATARELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   TestModeData = coRef.TestModeData;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus& coRef)
{
   if (this == &coRef) return *this;
   TestModeData = coRef.TestModeData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus()
:TestModeData()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_TPEG_DATASTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 52;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestModeData);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestModeData);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestModeData == roRef.TestModeData);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_DATAUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_DATARELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   TmcData = coRef.TmcData;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus& coRef)
{
   if (this == &coRef) return *this;
   TmcData = coRef.TmcData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TmcData.size(); ++u32Idx)
         TmcData[u32Idx].vDestroy();
   TmcData.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus()

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_DATASTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TmcData.size(); ++u32ListIdx)
      u32DynamicSize += TmcData[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TmcData.size(); ++u32Idx)
      {
         TmcData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TmcData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TmcData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TmcData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TmcData.size(); ++u32Idx)
         (tVoid) (oOut << TmcData[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TmcData.size() == roRef.TmcData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TmcData.size()); ++u32Idx)
            bResult = bResult && (TmcData[u32Idx] == roRef.TmcData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_AVAIL_LISTGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   EnsembleTmcInfoList = coRef.EnsembleTmcInfoList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus& coRef)
{
   if (this == &coRef) return *this;
   EnsembleTmcInfoList = coRef.EnsembleTmcInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < EnsembleTmcInfoList.size(); ++u32Idx)
         EnsembleTmcInfoList[u32Idx].vDestroy();
   EnsembleTmcInfoList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus()

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TMC_AVAIL_LISTSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < EnsembleTmcInfoList.size(); ++u32ListIdx)
      u32DynamicSize += EnsembleTmcInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < EnsembleTmcInfoList.size(); ++u32Idx)
      {
         EnsembleTmcInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      EnsembleTmcInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> EnsembleTmcInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)EnsembleTmcInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < EnsembleTmcInfoList.size(); ++u32Idx)
         (tVoid) (oOut << EnsembleTmcInfoList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (EnsembleTmcInfoList.size() == roRef.EnsembleTmcInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < EnsembleTmcInfoList.size()); ++u32Idx)
            bResult = bResult && (EnsembleTmcInfoList[u32Idx] == roRef.EnsembleTmcInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_DATAUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_DATARELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   TpegData = coRef.TpegData;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus& coRef)
{
   if (this == &coRef) return *this;
   TpegData = coRef.TpegData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TpegData.size(); ++u32Idx)
         TpegData[u32Idx].vDestroy();
   TpegData.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus()

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_DATASTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TpegData.size(); ++u32ListIdx)
      u32DynamicSize += TpegData[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TpegData.size(); ++u32Idx)
      {
         TpegData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TpegData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TpegData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TpegData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TpegData.size(); ++u32Idx)
         (tVoid) (oOut << TpegData[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TpegData.size() == roRef.TpegData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TpegData.size()); ++u32Idx)
            bResult = bResult && (TpegData[u32Idx] == roRef.TpegData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_URI_LISTUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_URI_LISTRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   TpegUriChannelList = coRef.TpegUriChannelList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus& coRef)
{
   if (this == &coRef) return *this;
   TpegUriChannelList = coRef.TpegUriChannelList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TpegUriChannelList.size(); ++u32Idx)
         TpegUriChannelList[u32Idx].vDestroy();
   TpegUriChannelList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus()

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_TPEG_URI_LISTSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TpegUriChannelList.size(); ++u32ListIdx)
      u32DynamicSize += TpegUriChannelList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TpegUriChannelList.size(); ++u32Idx)
      {
         TpegUriChannelList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TpegUriChannelList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TpegUriChannelList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TpegUriChannelList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TpegUriChannelList.size(); ++u32Idx)
         (tVoid) (oOut << TpegUriChannelList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TpegUriChannelList.size() == roRef.TpegUriChannelList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TpegUriChannelList.size()); ++u32Idx)
            bResult = bResult && (TpegUriChannelList[u32Idx] == roRef.TpegUriChannelList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SETMODE_STATUSUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SETMODE_STATUSRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SETMODE_STATUSGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   Mode = coRef.Mode;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   Mode = coRef.Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus()
:Mode()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SETMODE_STATUSSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mode);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mode);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mode == roRef.Mode);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_TUNER_STATUSUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_TUNER_STATUSRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_TUNER_STATUSGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus()
:State()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_TUNER_STATUSSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SURVEILLANCE_MONITORUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SURVEILLANCE_MONITORRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SURVEILLANCE_MONITORGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   StationType = coRef.StationType;
   StationFrequency = coRef.StationFrequency;
   StationId = coRef.StationId;
   EnsID = coRef.EnsID;
   TPState = coRef.TPState;
   StationNameFM = coRef.StationNameFM;
   StationNameDAB = coRef.StationNameDAB;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus& coRef)
{
   if (this == &coRef) return *this;
   StationType = coRef.StationType;
   StationFrequency = coRef.StationFrequency;
   StationId = coRef.StationId;
   EnsID = coRef.EnsID;
   TPState = coRef.TPState;
   StationNameFM = coRef.StationNameFM;
   StationNameDAB = coRef.StationNameDAB;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus::vDestroy()
{
   StationNameFM.vDestroy();
   StationNameDAB.vDestroy();
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus()
:StationType()
,StationFrequency(0)
,StationId(0)
,EnsID(0)
,TPState()
,StationNameFM()
,StationNameDAB()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_MTC_SURVEILLANCE_MONITORSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+StationNameFM.u32GetSize(u16MajorVersion)+StationNameDAB.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StationType);
   (tVoid) (oIn >> StationFrequency);
   (tVoid) (oIn >> StationId);
   (tVoid) (oIn >> EnsID);
   (tVoid) (oIn >> TPState);
   (tVoid) (oIn >> StationNameFM);
   (tVoid) (oIn >> StationNameDAB);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StationType);
   (tVoid) (oOut << StationFrequency);
   (tVoid) (oOut << StationId);
   (tVoid) (oOut << EnsID);
   (tVoid) (oOut << TPState);
   (tVoid) (oOut << StationNameFM);
   (tVoid) (oOut << StationNameDAB);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StationType == roRef.StationType);
   bResult = bResult && (StationFrequency == roRef.StationFrequency);
   bResult = bResult && (StationId == roRef.StationId);
   bResult = bResult && (EnsID == roRef.EnsID);
   bResult = bResult && (TPState == roRef.TPState);
   bResult = bResult && (StationNameFM == roRef.StationNameFM);
   bResult = bResult && (StationNameDAB == roRef.StationNameDAB);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRVLIST_NOTIFICATIONUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRVLIST_NOTIFICATIONRELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   bListUpdate = coRef.bListUpdate;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus& coRef)
{
   if (this == &coRef) return *this;
   bListUpdate = coRef.bListUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus()
:bListUpdate(0)
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_SRVLIST_NOTIFICATIONSTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus()
{}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bListUpdate);
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bListUpdate);
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bListUpdate == roRef.bListUpdate);
   return bResult;
}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LIST_UPDATEUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LIST_UPDATERELUPREG;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg()
{}

//=============================================================================

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet()
 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LIST_UPDATEGET;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus& coRef)
   : midw_ext_dabtunerfi_tclMsgBaseMessage(coRef)
{
   AvailSrvList = coRef.AvailSrvList;
}
midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus& midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus::operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus& coRef)
{
   if (this == &coRef) return *this;
   AvailSrvList = coRef.AvailSrvList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailSrvList.size(); ++u32Idx)
         AvailSrvList[u32Idx].vDestroy();
   AvailSrvList.clear();
   }
}

midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus::midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus()

 {}

tS32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_dabtunerfi_tclToken::EN_MSG_FID_DAB_G_LIST_UPDATESTATUS;
}


midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus::~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AvailSrvList.size(); ++u32ListIdx)
      u32DynamicSize += AvailSrvList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailSrvList.size(); ++u32Idx)
      {
         AvailSrvList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AvailSrvList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailSrvList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailSrvList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailSrvList.size(); ++u32Idx)
         (tVoid) (oOut << AvailSrvList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus::operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailSrvList.size() == roRef.AvailSrvList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailSrvList.size()); ++u32Idx)
            bResult = bResult && (AvailSrvList[u32Idx] == roRef.AvailSrvList[u32Idx]);
      }
   return bResult;
}

