/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_CLOCKFITYPES_HEADER
#define MIDW_EXT_CLOCKFITYPES_HEADER


class midw_ext_clockfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_ext_clock_fi message types

fi_tclMessageBase* midw_ext_clockfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_clockfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_clockfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodStart : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodStart();

   virtual ~midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodStart();

   inline tBool operator==(const midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult& operator=(const midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult& coRef);
   midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult(const midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tclString, std::allocator<midw_ext_fi_tclString> > aszDescriptions;
   std::vector<tU16, std::allocator<tU16> > u16Indexes;
   virtual ~midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart& operator=(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart& coRef);
   midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32TimeDateValue;
   tU8 u8SourceDomain;
   tU8 u8TargetDomain;
   virtual ~midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult& operator=(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult& coRef);
   midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   virtual ~midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart& operator=(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart& coRef);
   midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   virtual ~midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult& operator=(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult& coRef);
   midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumberOfDays;
   virtual ~midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& operator=(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& coRef);
   midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DefSetGroups DefSetStateGroup;
   midw_ext_fi_tcl_e8_DefSetMode DefSetStateMode;
   virtual ~midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& operator=(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& coRef);
   midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DefSetGroups DefSetStateGroup;
   midw_ext_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool Status;
   virtual ~midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgTimeZoneGet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgTimeZoneGet();

   virtual ~midw_ext_clockfi_tclMsgTimeZoneGet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgTimeZoneGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgTimeZoneSet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgTimeZoneSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgTimeZoneSet& operator=(const midw_ext_clockfi_tclMsgTimeZoneSet& coRef);
   midw_ext_clockfi_tclMsgTimeZoneSet(const midw_ext_clockfi_tclMsgTimeZoneSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16Index;
   virtual ~midw_ext_clockfi_tclMsgTimeZoneSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgTimeZoneSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgTimeZoneUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgTimeZoneUpReg();

   virtual ~midw_ext_clockfi_tclMsgTimeZoneUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgTimeZoneUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgTimeZoneRelUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgTimeZoneRelUpReg();

   virtual ~midw_ext_clockfi_tclMsgTimeZoneRelUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgTimeZoneRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgTimeZoneStatus : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgTimeZoneStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgTimeZoneStatus& operator=(const midw_ext_clockfi_tclMsgTimeZoneStatus& coRef);
   midw_ext_clockfi_tclMsgTimeZoneStatus(const midw_ext_clockfi_tclMsgTimeZoneStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16Index;
   midw_ext_fi_tclString szDescription;
   virtual ~midw_ext_clockfi_tclMsgTimeZoneStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgTimeZoneStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgDaylightSavingTimeGet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgDaylightSavingTimeGet();

   virtual ~midw_ext_clockfi_tclMsgDaylightSavingTimeGet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgDaylightSavingTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgDaylightSavingTimeSet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgDaylightSavingTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgDaylightSavingTimeSet& operator=(const midw_ext_clockfi_tclMsgDaylightSavingTimeSet& coRef);
   midw_ext_clockfi_tclMsgDaylightSavingTimeSet(const midw_ext_clockfi_tclMsgDaylightSavingTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclDCLK_TEN_DST_Setting enDST_Setting;
   virtual ~midw_ext_clockfi_tclMsgDaylightSavingTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgDaylightSavingTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgDaylightSavingTimeUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgDaylightSavingTimeUpReg();

   virtual ~midw_ext_clockfi_tclMsgDaylightSavingTimeUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgDaylightSavingTimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgDaylightSavingTimeRelUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgDaylightSavingTimeRelUpReg();

   virtual ~midw_ext_clockfi_tclMsgDaylightSavingTimeRelUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgDaylightSavingTimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgDaylightSavingTimeStatus : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgDaylightSavingTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgDaylightSavingTimeStatus& operator=(const midw_ext_clockfi_tclMsgDaylightSavingTimeStatus& coRef);
   midw_ext_clockfi_tclMsgDaylightSavingTimeStatus(const midw_ext_clockfi_tclMsgDaylightSavingTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDST_Status;
   tBool bDST_AutoAdjust;
   midw_ext_fi_tclDCLK_TEN_DST_Setting enDST_Status;
   virtual ~midw_ext_clockfi_tclMsgDaylightSavingTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgDaylightSavingTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGPS_AutoSyncGet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGPS_AutoSyncGet();

   virtual ~midw_ext_clockfi_tclMsgGPS_AutoSyncGet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgGPS_AutoSyncGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGPS_AutoSyncSet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGPS_AutoSyncSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgGPS_AutoSyncSet& operator=(const midw_ext_clockfi_tclMsgGPS_AutoSyncSet& coRef);
   midw_ext_clockfi_tclMsgGPS_AutoSyncSet(const midw_ext_clockfi_tclMsgGPS_AutoSyncSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnabled;
   tBool bPositionBased;
   virtual ~midw_ext_clockfi_tclMsgGPS_AutoSyncSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgGPS_AutoSyncSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGPS_AutoSyncUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGPS_AutoSyncUpReg();

   virtual ~midw_ext_clockfi_tclMsgGPS_AutoSyncUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgGPS_AutoSyncUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGPS_AutoSyncRelUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGPS_AutoSyncRelUpReg();

   virtual ~midw_ext_clockfi_tclMsgGPS_AutoSyncRelUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgGPS_AutoSyncRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGPS_AutoSyncStatus : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGPS_AutoSyncStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgGPS_AutoSyncStatus& operator=(const midw_ext_clockfi_tclMsgGPS_AutoSyncStatus& coRef);
   midw_ext_clockfi_tclMsgGPS_AutoSyncStatus(const midw_ext_clockfi_tclMsgGPS_AutoSyncStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnabled;
   tBool bPositionBased;
   virtual ~midw_ext_clockfi_tclMsgGPS_AutoSyncStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgGPS_AutoSyncStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgSyncModeGet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgSyncModeGet();

   virtual ~midw_ext_clockfi_tclMsgSyncModeGet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgSyncModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgSyncModeSet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgSyncModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgSyncModeSet& operator=(const midw_ext_clockfi_tclMsgSyncModeSet& coRef);
   midw_ext_clockfi_tclMsgSyncModeSet(const midw_ext_clockfi_tclMsgSyncModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclDCLK_TEN_SyncMode enMode;
   virtual ~midw_ext_clockfi_tclMsgSyncModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgSyncModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgSyncModeUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgSyncModeUpReg();

   virtual ~midw_ext_clockfi_tclMsgSyncModeUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgSyncModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgSyncModeRelUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgSyncModeRelUpReg();

   virtual ~midw_ext_clockfi_tclMsgSyncModeRelUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgSyncModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgSyncModeStatus : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgSyncModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgSyncModeStatus& operator=(const midw_ext_clockfi_tclMsgSyncModeStatus& coRef);
   midw_ext_clockfi_tclMsgSyncModeStatus(const midw_ext_clockfi_tclMsgSyncModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclDCLK_TEN_SyncMode enMode;
   virtual ~midw_ext_clockfi_tclMsgSyncModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgSyncModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGPS_WeekEpochGet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGPS_WeekEpochGet();

   virtual ~midw_ext_clockfi_tclMsgGPS_WeekEpochGet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgGPS_WeekEpochGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGPS_WeekEpochSet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGPS_WeekEpochSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgGPS_WeekEpochSet& operator=(const midw_ext_clockfi_tclMsgGPS_WeekEpochSet& coRef);
   midw_ext_clockfi_tclMsgGPS_WeekEpochSet(const midw_ext_clockfi_tclMsgGPS_WeekEpochSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch;
   virtual ~midw_ext_clockfi_tclMsgGPS_WeekEpochSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgGPS_WeekEpochSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGPS_WeekEpochUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGPS_WeekEpochUpReg();

   virtual ~midw_ext_clockfi_tclMsgGPS_WeekEpochUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgGPS_WeekEpochUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGPS_WeekEpochRelUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGPS_WeekEpochRelUpReg();

   virtual ~midw_ext_clockfi_tclMsgGPS_WeekEpochRelUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgGPS_WeekEpochRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgGPS_WeekEpochStatus : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgGPS_WeekEpochStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgGPS_WeekEpochStatus& operator=(const midw_ext_clockfi_tclMsgGPS_WeekEpochStatus& coRef);
   midw_ext_clockfi_tclMsgGPS_WeekEpochStatus(const midw_ext_clockfi_tclMsgGPS_WeekEpochStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch;
   virtual ~midw_ext_clockfi_tclMsgGPS_WeekEpochStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgGPS_WeekEpochStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgLocalTimeOffsetUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgLocalTimeOffsetUpReg();

   virtual ~midw_ext_clockfi_tclMsgLocalTimeOffsetUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgLocalTimeOffsetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgLocalTimeOffsetRelUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgLocalTimeOffsetRelUpReg();

   virtual ~midw_ext_clockfi_tclMsgLocalTimeOffsetRelUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgLocalTimeOffsetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgLocalTimeOffsetGet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgLocalTimeOffsetGet();

   virtual ~midw_ext_clockfi_tclMsgLocalTimeOffsetGet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgLocalTimeOffsetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgLocalTimeOffsetStatus : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgLocalTimeOffsetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgLocalTimeOffsetStatus& operator=(const midw_ext_clockfi_tclMsgLocalTimeOffsetStatus& coRef);
   midw_ext_clockfi_tclMsgLocalTimeOffsetStatus(const midw_ext_clockfi_tclMsgLocalTimeOffsetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS64 s64Offset_ScalarValue;
   tBool bIsOffsetPostive;
   tS16 s16Offset_Year;
   tU8 u8Offset_Month;
   tU8 u8Offset_Day;
   tU8 u8Offset_Hour;
   tU8 u8Offset_Minute;
   tU8 u8Offset_Second;
   tU32 u32UTCTimeDate_ScalarValue;
   tS16 s16UTCTimeDate_Year;
   tU8 u8UTCTimeDate_Month;
   tU8 u8UTCTimeDate_Day;
   tU8 u8UTCTimeDate_Hour;
   tU8 u8UTCTimeDate_Minute;
   tU8 u8UTCTimeDate_Second;
   tU8 u8UTCTimeDate_Weekday;
   midw_ext_fi_tclDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState;
   virtual ~midw_ext_clockfi_tclMsgLocalTimeOffsetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgLocalTimeOffsetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgLocalTimeOffsetSet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgLocalTimeOffsetSet();

   virtual ~midw_ext_clockfi_tclMsgLocalTimeOffsetSet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgLocalTimeOffsetSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgLocalTimeDateUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgLocalTimeDateUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgLocalTimeDateUpReg& operator=(const midw_ext_clockfi_tclMsgLocalTimeDateUpReg& coRef);
   midw_ext_clockfi_tclMsgLocalTimeDateUpReg(const midw_ext_clockfi_tclMsgLocalTimeDateUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8UpdatePeriod;
   virtual ~midw_ext_clockfi_tclMsgLocalTimeDateUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgLocalTimeDateUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg& operator=(const midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg& coRef);
   midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg(const midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8UpdatePeriod;
   virtual ~midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgLocalTimeDateGet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgLocalTimeDateGet();

   virtual ~midw_ext_clockfi_tclMsgLocalTimeDateGet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgLocalTimeDateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgLocalTimeDateStatus : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgLocalTimeDateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgLocalTimeDateStatus& operator=(const midw_ext_clockfi_tclMsgLocalTimeDateStatus& coRef);
   midw_ext_clockfi_tclMsgLocalTimeDateStatus(const midw_ext_clockfi_tclMsgLocalTimeDateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   tU8 u8TimeDateStatus;
   tU32 u32TimeDateValue;
   virtual ~midw_ext_clockfi_tclMsgLocalTimeDateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgLocalTimeDateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgLocalTimeDateSet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgLocalTimeDateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgLocalTimeDateSet& operator=(const midw_ext_clockfi_tclMsgLocalTimeDateSet& coRef);
   midw_ext_clockfi_tclMsgLocalTimeDateSet(const midw_ext_clockfi_tclMsgLocalTimeDateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   tU8 u8ChangeMask;
   virtual ~midw_ext_clockfi_tclMsgLocalTimeDateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgLocalTimeDateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgTimeFormatUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgTimeFormatUpReg();

   virtual ~midw_ext_clockfi_tclMsgTimeFormatUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgTimeFormatUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgTimeFormatRelUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgTimeFormatRelUpReg();

   virtual ~midw_ext_clockfi_tclMsgTimeFormatRelUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgTimeFormatRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgTimeFormatGet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgTimeFormatGet();

   virtual ~midw_ext_clockfi_tclMsgTimeFormatGet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgTimeFormatGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgTimeFormatStatus : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgTimeFormatStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgTimeFormatStatus& operator=(const midw_ext_clockfi_tclMsgTimeFormatStatus& coRef);
   midw_ext_clockfi_tclMsgTimeFormatStatus(const midw_ext_clockfi_tclMsgTimeFormatStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclDCLK_TEN_TimeFormat enTimeFormat;
   virtual ~midw_ext_clockfi_tclMsgTimeFormatStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgTimeFormatStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgTimeFormatSet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgTimeFormatSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgTimeFormatSet& operator=(const midw_ext_clockfi_tclMsgTimeFormatSet& coRef);
   midw_ext_clockfi_tclMsgTimeFormatSet(const midw_ext_clockfi_tclMsgTimeFormatSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclDCLK_TEN_TimeFormat enTimeFormat;
   virtual ~midw_ext_clockfi_tclMsgTimeFormatSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgTimeFormatSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgDateFormatUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgDateFormatUpReg();

   virtual ~midw_ext_clockfi_tclMsgDateFormatUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgDateFormatUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgDateFormatRelUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgDateFormatRelUpReg();

   virtual ~midw_ext_clockfi_tclMsgDateFormatRelUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgDateFormatRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgDateFormatGet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgDateFormatGet();

   virtual ~midw_ext_clockfi_tclMsgDateFormatGet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgDateFormatGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgDateFormatStatus : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgDateFormatStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgDateFormatStatus& operator=(const midw_ext_clockfi_tclMsgDateFormatStatus& coRef);
   midw_ext_clockfi_tclMsgDateFormatStatus(const midw_ext_clockfi_tclMsgDateFormatStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclDCLK_TEN_DateFormat enDateFormat;
   virtual ~midw_ext_clockfi_tclMsgDateFormatStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgDateFormatStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgDateFormatSet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgDateFormatSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgDateFormatSet& operator=(const midw_ext_clockfi_tclMsgDateFormatSet& coRef);
   midw_ext_clockfi_tclMsgDateFormatSet(const midw_ext_clockfi_tclMsgDateFormatSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclDCLK_TEN_DateFormat enDateFormat;
   virtual ~midw_ext_clockfi_tclMsgDateFormatSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgDateFormatSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgClockSourceStatusUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgClockSourceStatusUpReg();

   virtual ~midw_ext_clockfi_tclMsgClockSourceStatusUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgClockSourceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgClockSourceStatusRelUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgClockSourceStatusRelUpReg();

   virtual ~midw_ext_clockfi_tclMsgClockSourceStatusRelUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgClockSourceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgClockSourceStatusGet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgClockSourceStatusGet();

   virtual ~midw_ext_clockfi_tclMsgClockSourceStatusGet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgClockSourceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgClockSourceStatusStatus : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgClockSourceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgClockSourceStatusStatus& operator=(const midw_ext_clockfi_tclMsgClockSourceStatusStatus& coRef);
   midw_ext_clockfi_tclMsgClockSourceStatusStatus(const midw_ext_clockfi_tclMsgClockSourceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclDCLK_TEN_ClockSourceStatus enSourcesValid;
   virtual ~midw_ext_clockfi_tclMsgClockSourceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgClockSourceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgFormatSourceStatusUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgFormatSourceStatusUpReg();

   virtual ~midw_ext_clockfi_tclMsgFormatSourceStatusUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgFormatSourceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgFormatSourceStatusRelUpReg : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgFormatSourceStatusRelUpReg();

   virtual ~midw_ext_clockfi_tclMsgFormatSourceStatusRelUpReg();

   inline tBool operator==(const midw_ext_clockfi_tclMsgFormatSourceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgFormatSourceStatusGet : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgFormatSourceStatusGet();

   virtual ~midw_ext_clockfi_tclMsgFormatSourceStatusGet();

   inline tBool operator==(const midw_ext_clockfi_tclMsgFormatSourceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_clockfi_tclMsgFormatSourceStatusStatus : public midw_ext_clockfi_tclMsgBaseMessage
{
public:

   midw_ext_clockfi_tclMsgFormatSourceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_clockfi_tclMsgFormatSourceStatusStatus& operator=(const midw_ext_clockfi_tclMsgFormatSourceStatusStatus& coRef);
   midw_ext_clockfi_tclMsgFormatSourceStatusStatus(const midw_ext_clockfi_tclMsgFormatSourceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclDCLK_TEN_FormatSourceStatus enFormatSourceStatus;
   virtual ~midw_ext_clockfi_tclMsgFormatSourceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_clockfi_tclMsgFormatSourceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
