#ifndef METERSRV_FIVISITOR_HEADER
#define METERSRV_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class metersrv_fi_tclOutput {
public:
   metersrv_fi_tclOutput();
   virtual ~metersrv_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class metersrv_fi_tclFileOutput : public metersrv_fi_tclOutput 
{
public:
   metersrv_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   metersrv_fi_tclFileOutput(); //lint !e1704
   metersrv_fi_tclFileOutput& operator=(const metersrv_fi_tclFileOutput& coRef);
   metersrv_fi_tclFileOutput(const metersrv_fi_tclFileOutput& coRef); //lint !e1704
};

class metersrv_fi_tclMemOutput : public metersrv_fi_tclOutput
{
public:
   metersrv_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~metersrv_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   metersrv_fi_tclMemOutput(); //lint !e1704
   metersrv_fi_tclMemOutput(const metersrv_fi_tclMemOutput& coRef); //lint !e1704
   metersrv_fi_tclMemOutput& operator=(const metersrv_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL metersrv_fi_tclVisitorBase {
public:

   // --Konstruktor
   metersrv_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~metersrv_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(metersrv_fi_tclU8& oU8);
   virtual tVoid vVisitS8(metersrv_fi_tclS8& oS8);
   virtual tVoid vVisitU16(metersrv_fi_tclU16& oU16);
   virtual tVoid vVisitS16(metersrv_fi_tclS16& oS16);
   virtual tVoid vVisitU24(metersrv_fi_tclU24& oU24);
   virtual tVoid vVisitS24(metersrv_fi_tclS24& oS24);
   virtual tVoid vVisitU32(metersrv_fi_tclU32& oU32);
   virtual tVoid vVisitS32(metersrv_fi_tclS32& oS32);
   virtual tVoid vVisitU64(metersrv_fi_tclU64& oU64);
   virtual tVoid vVisitS64(metersrv_fi_tclS64& oS64);
   virtual tVoid vVisitF32(metersrv_fi_tclF32& oF32);
   virtual tVoid vVisitF64(metersrv_fi_tclF64& oF64);
   virtual tVoid vVisitBool(metersrv_fi_tclBool& oBool);
   virtual tVoid vVisitString(metersrv_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(metersrv_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(metersrv_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(metersrv_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(metersrv_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(metersrv_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(metersrv_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(metersrv_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(metersrv_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(metersrv_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(metersrv_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(metersrv_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(metersrv_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(metersrv_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(metersrv_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(metersrv_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(metersrv_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(metersrv_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(metersrv_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(metersrv_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(metersrv_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(metersrv_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(metersrv_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(metersrv_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(metersrv_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(metersrv_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(metersrv_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(metersrv_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(metersrv_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(metersrv_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(metersrv_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(metersrv_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(metersrv_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(metersrv_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(metersrv_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(metersrv_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(metersrv_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(metersrv_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(metersrv_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(metersrv_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(metersrv_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(metersrv_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(metersrv_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(metersrv_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(metersrv_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(metersrv_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(metersrv_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(metersrv_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(metersrv_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(metersrv_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e8_Meter_UnitType(metersrv_fi_tcl_e8_Meter_UnitType& oe8_Meter_UnitType);

   virtual tVoid vVisit_e8_Meter_ConfigurationStatus(metersrv_fi_tcl_e8_Meter_ConfigurationStatus& oe8_Meter_ConfigurationStatus);

   virtual tVoid vVisit_Meter_VersionInfo(metersrv_fi_tcl_Meter_VersionInfo& oMeter_VersionInfo);

   virtual tVoid vVisit_Meter_UnitConnectionStatus(metersrv_fi_tcl_Meter_UnitConnectionStatus& oMeter_UnitConnectionStatus);

   virtual tVoid vVisit_Meter_UnitConfiguration(metersrv_fi_tcl_Meter_UnitConfiguration& oMeter_UnitConfiguration);

   virtual tVoid vVisit_Meter_UnitVersion(metersrv_fi_tcl_Meter_UnitVersion& oMeter_UnitVersion);

   virtual tVoid vVisit_Meter_UnitDataTransmissionStatus(metersrv_fi_tcl_Meter_UnitDataTransmissionStatus& oMeter_UnitDataTransmissionStatus);

   virtual tVoid vVisit_e8VersionInfo(metersrv_fi_tcl_e8VersionInfo& oe8VersionInfo);

   virtual tVoid vVisit_e8_Meter_SupportedFunction(metersrv_fi_tcl_e8_Meter_SupportedFunction& oe8_Meter_SupportedFunction);

   virtual tVoid vVisit_e8_Meter_Language(metersrv_fi_tcl_e8_Meter_Language& oe8_Meter_Language);

   virtual tVoid vVisit_e8_Meter_Language_Action(metersrv_fi_tcl_e8_Meter_Language_Action& oe8_Meter_Language_Action);

   virtual tVoid vVisit_e8_Lang_Sync_Mode_Type(metersrv_fi_tcl_e8_Lang_Sync_Mode_Type& oe8_Lang_Sync_Mode_Type);

   virtual tVoid vVisit_e8_Meter_Language_Status(metersrv_fi_tcl_e8_Meter_Language_Status& oe8_Meter_Language_Status);

   virtual tVoid vVisit_e8_Meter_RequestedLanguageResult(metersrv_fi_tcl_e8_Meter_RequestedLanguageResult& oe8_Meter_RequestedLanguageResult);

   virtual tVoid vVisit_e8_Meter_DistanceUnit(metersrv_fi_tcl_e8_Meter_DistanceUnit& oe8_Meter_DistanceUnit);

   virtual tVoid vVisit_e8_Meter_FuelConsumptionUnit(metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit& oe8_Meter_FuelConsumptionUnit);

   virtual tVoid vVisit_e8_Meter_TemperatureUnit(metersrv_fi_tcl_e8_Meter_TemperatureUnit& oe8_Meter_TemperatureUnit);

   virtual tVoid vVisit_e8_Meter_PressureUnit(metersrv_fi_tcl_e8_Meter_PressureUnit& oe8_Meter_PressureUnit);

   virtual tVoid vVisit_e8_Meter_Switch(metersrv_fi_tcl_e8_Meter_Switch& oe8_Meter_Switch);

   virtual tVoid vVisit_e8_Meter_Eco_Drive(metersrv_fi_tcl_e8_Meter_Eco_Drive& oe8_Meter_Eco_Drive);

   virtual tVoid vVisit_e8_Meter_Low_Temp(metersrv_fi_tcl_e8_Meter_Low_Temp& oe8_Meter_Low_Temp);

   virtual tVoid vVisit_e8_ProPilot_Meter_Switch(metersrv_fi_tcl_e8_ProPilot_Meter_Switch& oe8_ProPilot_Meter_Switch);

   virtual tVoid vVisit_e8_ProPilot_State_Switch(metersrv_fi_tcl_e8_ProPilot_State_Switch& oe8_ProPilot_State_Switch);

   virtual tVoid vVisit_e8_Meter_ECO_Accel(metersrv_fi_tcl_e8_Meter_ECO_Accel& oe8_Meter_ECO_Accel);

   virtual tVoid vVisit_e8_Meter_ReceivedDataErrorCode(metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode& oe8_Meter_ReceivedDataErrorCode);

   virtual tVoid vVisit_Meter_Audio_NoData(metersrv_fi_tcl_Meter_Audio_NoData& oMeter_Audio_NoData);

   virtual tVoid vVisit_e8_Meter_Audio_RadioSource(metersrv_fi_tcl_e8_Meter_Audio_RadioSource& oe8_Meter_Audio_RadioSource);

   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoUpdate(metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate& oe8_Meter_Audio_HDRadioSourceInfoUpdate);

   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoName(metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName& oe8_Meter_Audio_HDRadioSourceInfoName);

   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSource(metersrv_fi_tcl_e8_Meter_Audio_HDRadioSource& oe8_Meter_Audio_HDRadioSource);

   virtual tVoid vVisit_e8_Meter_Audio_RadioLabelType(metersrv_fi_tcl_e8_Meter_Audio_RadioLabelType& oe8_Meter_Audio_RadioLabelType);

   virtual tVoid vVisit_Meter_Audio_RadioLabel(metersrv_fi_tcl_Meter_Audio_RadioLabel& oMeter_Audio_RadioLabel);

   virtual tVoid vVisit_e8_Meter_Audio_RadioFrequencyUnit(metersrv_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit& oe8_Meter_Audio_RadioFrequencyUnit);

   virtual tVoid vVisit_Meter_Audio_RadioFrequency(metersrv_fi_tcl_Meter_Audio_RadioFrequency& oMeter_Audio_RadioFrequency);

   virtual tVoid vVisit_e8_Meter_Audio_RadioCategoryType(metersrv_fi_tcl_e8_Meter_Audio_RadioCategoryType& oe8_Meter_Audio_RadioCategoryType);

   virtual tVoid vVisit_Meter_Audio_RadioCategory(metersrv_fi_tcl_Meter_Audio_RadioCategory& oMeter_Audio_RadioCategory);

   virtual tVoid vVisit_Meter_Audio_RadioData(metersrv_fi_tcl_Meter_Audio_RadioData& oMeter_Audio_RadioData);

   virtual tVoid vVisit_Meter_Audio_HDRadioData(metersrv_fi_tcl_Meter_Audio_HDRadioData& oMeter_Audio_HDRadioData);

   virtual tVoid vVisit_e8_Meter_Audio_DTVSourceInfoUpdate(metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoUpdate& oe8_Meter_Audio_DTVSourceInfoUpdate);

   virtual tVoid vVisit_e8_Meter_Audio_DTVSourceInfoName(metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoName& oe8_Meter_Audio_DTVSourceInfoName);

   virtual tVoid vVisit_e8_Meter_Audio_DTVSource(metersrv_fi_tcl_e8_Meter_Audio_DTVSource& oe8_Meter_Audio_DTVSource);

   virtual tVoid vVisit_Meter_Audio_DTVFrequency(metersrv_fi_tcl_Meter_Audio_DTVFrequency& oMeter_Audio_DTVFrequency);

   virtual tVoid vVisit_e8_Meter_Audio_DTVLabelType(metersrv_fi_tcl_e8_Meter_Audio_DTVLabelType& oe8_Meter_Audio_DTVLabelType);

   virtual tVoid vVisit_Meter_Audio_DTVLabel(metersrv_fi_tcl_Meter_Audio_DTVLabel& oMeter_Audio_DTVLabel);

   virtual tVoid vVisit_Meter_Audio_DTVData(metersrv_fi_tcl_Meter_Audio_DTVData& oMeter_Audio_DTVData);

   virtual tVoid vVisit_e8_Meter_Audio_MediaType(metersrv_fi_tcl_e8_Meter_Audio_MediaType& oe8_Meter_Audio_MediaType);

   virtual tVoid vVisit_e8_Meter_Audio_TrackLabelType(metersrv_fi_tcl_e8_Meter_Audio_TrackLabelType& oe8_Meter_Audio_TrackLabelType);

   virtual tVoid vVisit_Meter_Audio_TrackInfo(metersrv_fi_tcl_Meter_Audio_TrackInfo& oMeter_Audio_TrackInfo);

   virtual tVoid vVisit_e8_Meter_Audio_GroupLabelType(metersrv_fi_tcl_e8_Meter_Audio_GroupLabelType& oe8_Meter_Audio_GroupLabelType);

   virtual tVoid vVisit_Meter_Audio_GroupInfo(metersrv_fi_tcl_Meter_Audio_GroupInfo& oMeter_Audio_GroupInfo);

   virtual tVoid vVisit_e8_Meter_Audio_ArtistLabelType(metersrv_fi_tcl_e8_Meter_Audio_ArtistLabelType& oe8_Meter_Audio_ArtistLabelType);

   virtual tVoid vVisit_Meter_Audio_ArtistInfo(metersrv_fi_tcl_Meter_Audio_ArtistInfo& oMeter_Audio_ArtistInfo);

   virtual tVoid vVisit_Meter_Audio_MediaData(metersrv_fi_tcl_Meter_Audio_MediaData& oMeter_Audio_MediaData);

   virtual tVoid vVisit_e8_Meter_Audio_AuxType(metersrv_fi_tcl_e8_Meter_Audio_AuxType& oe8_Meter_Audio_AuxType);

   virtual tVoid vVisit_Meter_Audio_AuxData(metersrv_fi_tcl_Meter_Audio_AuxData& oMeter_Audio_AuxData);

   virtual tVoid vVisit_Meter_Audio_ExternalSoundData(metersrv_fi_tcl_Meter_Audio_ExternalSoundData& oMeter_Audio_ExternalSoundData);

   virtual tVoid vVisit_Meter_Audio_InternetRadioData(metersrv_fi_tcl_Meter_Audio_InternetRadioData& oMeter_Audio_InternetRadioData);

   virtual tVoid vVisit_e8_Meter_Audio_SourceInfoType(metersrv_fi_tcl_e8_Meter_Audio_SourceInfoType& oe8_Meter_Audio_SourceInfoType);

   virtual tVoid vVisit_Meter_Audio_SourceInfoUnion(metersrv_fi_tcl_Meter_Audio_SourceInfoUnion& oMeter_Audio_SourceInfoUnion);

   virtual tVoid vVisit_e8_Meter_Audio_WarningSource(metersrv_fi_tcl_e8_Meter_Audio_WarningSource& oe8_Meter_Audio_WarningSource);

   virtual tVoid vVisit_e8_Meter_Audio_WarningState(metersrv_fi_tcl_e8_Meter_Audio_WarningState& oe8_Meter_Audio_WarningState);

   virtual tVoid vVisit_e8_Meter_Audio_SpecialMode(metersrv_fi_tcl_e8_Meter_Audio_SpecialMode& oe8_Meter_Audio_SpecialMode);

   virtual tVoid vVisit_e8_Meter_Audio_SourceType(metersrv_fi_tcl_e8_Meter_Audio_SourceType& oe8_Meter_Audio_SourceType);

   virtual tVoid vVisit_e8_Meter_Current_Radio_Mode(metersrv_fi_tcl_e8_Meter_Current_Radio_Mode& oe8_Meter_Current_Radio_Mode);

   virtual tVoid vVisit_e8_meter_Renault_Update_List_Value(metersrv_fi_tcl_e8_meter_Renault_Update_List_Value& oe8_meter_Renault_Update_List_Value);

   virtual tVoid vVisit_e8_NavStatus(metersrv_fi_tcl_e8_NavStatus& oe8_NavStatus);

   virtual tVoid vVisit_e8_RoadClass(metersrv_fi_tcl_e8_RoadClass& oe8_RoadClass);

   virtual tVoid vVisit_e8_DistanceUnit(metersrv_fi_tcl_e8_DistanceUnit& oe8_DistanceUnit);

   virtual tVoid vVisit_e8_ManeuverSymbol(metersrv_fi_tcl_e8_ManeuverSymbol& oe8_ManeuverSymbol);

   virtual tVoid vVisit_e8_SpeedUnit(metersrv_fi_tcl_e8_SpeedUnit& oe8_SpeedUnit);

   virtual tVoid vVisit_e8_ManeuverRecommendationType(metersrv_fi_tcl_e8_ManeuverRecommendationType& oe8_ManeuverRecommendationType);

   virtual tVoid vVisit_e8_EstimatedTimeType(metersrv_fi_tcl_e8_EstimatedTimeType& oe8_EstimatedTimeType);

   virtual tVoid vVisit_e8_TimeType(metersrv_fi_tcl_e8_TimeType& oe8_TimeType);

   virtual tVoid vVisit_e8_TimeFormat(metersrv_fi_tcl_e8_TimeFormat& oe8_TimeFormat);

   virtual tVoid vVisit_e8_ManeuverView(metersrv_fi_tcl_e8_ManeuverView& oe8_ManeuverView);

   virtual tVoid vVisit_e8_DeformedImageRoad(metersrv_fi_tcl_e8_DeformedImageRoad& oe8_DeformedImageRoad);

   virtual tVoid vVisit_e8_DeformedImageArrow(metersrv_fi_tcl_e8_DeformedImageArrow& oe8_DeformedImageArrow);

   virtual tVoid vVisit_e8_LaneStatus(metersrv_fi_tcl_e8_LaneStatus& oe8_LaneStatus);

   virtual tVoid vVisit_LaneRecommendation(metersrv_fi_tcl_LaneRecommendation& oLaneRecommendation);

   virtual tVoid vVisit_ArrivalInformation(metersrv_fi_tcl_ArrivalInformation& oArrivalInformation);

   virtual tVoid vVisit_ScreenCoordinate(metersrv_fi_tcl_ScreenCoordinate& oScreenCoordinate);

   virtual tVoid vVisit_e8_AdminRoadClass(metersrv_fi_tcl_e8_AdminRoadClass& oe8_AdminRoadClass);

   virtual tVoid vVisit_IntersectionMapRoadLine(metersrv_fi_tcl_IntersectionMapRoadLine& oIntersectionMapRoadLine);

   virtual tVoid vVisit_e8_IntersectionMapCarsorState(metersrv_fi_tcl_e8_IntersectionMapCarsorState& oe8_IntersectionMapCarsorState);

   virtual tVoid vVisit_e8_SpiNavigation_NavigationAppState(metersrv_fi_tcl_e8_SpiNavigation_NavigationAppState& oe8_SpiNavigation_NavigationAppState);

   virtual tVoid vVisit_e8_SpiNavigation_TurnSide(metersrv_fi_tcl_e8_SpiNavigation_TurnSide& oe8_SpiNavigation_TurnSide);

   virtual tVoid vVisit_e8_SpiNavigation_NextTurnEvent(metersrv_fi_tcl_e8_SpiNavigation_NextTurnEvent& oe8_SpiNavigation_NextTurnEvent);

   virtual tVoid vVisit_e8_SpiNavigation_ManeuverDistanceUnits(metersrv_fi_tcl_e8_SpiNavigation_ManeuverDistanceUnits& oe8_SpiNavigation_ManeuverDistanceUnits);

   virtual tVoid vVisit_e8_DistanceUnits(metersrv_fi_tcl_e8_DistanceUnits& oe8_DistanceUnits);

   virtual tVoid vVisit_e8_TrafficEnforcement_TrafficEnforcementAlertState(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementAlertState& oe8_TrafficEnforcement_TrafficEnforcementAlertState);

   virtual tVoid vVisit_e8_TrafficEnforcement_TrafficEnforcementCameraType(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementCameraType& oe8_TrafficEnforcement_TrafficEnforcementCameraType);

   virtual tVoid vVisit_e8_TrafficEnforcement_TrafficEnforcementDistanceType(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementDistanceType& oe8_TrafficEnforcement_TrafficEnforcementDistanceType);

   virtual tVoid vVisit_e8_DeviceCategory(metersrv_fi_tcl_e8_DeviceCategory& oe8_DeviceCategory);

   virtual tVoid vVisit_e8_DiPoRouteGuidanceState(metersrv_fi_tcl_e8_DiPoRouteGuidanceState& oe8_DiPoRouteGuidanceState);

   virtual tVoid vVisit_e8_AAutoTurnSide(metersrv_fi_tcl_e8_AAutoTurnSide& oe8_AAutoTurnSide);

   virtual tVoid vVisit_e8_BDCLNavigationAppState(metersrv_fi_tcl_e8_BDCLNavigationAppState& oe8_BDCLNavigationAppState);

   virtual tVoid vVisit_e8_MLGuidanceState(metersrv_fi_tcl_e8_MLGuidanceState& oe8_MLGuidanceState);

   virtual tVoid vVisit_e8_MLNextDirection(metersrv_fi_tcl_e8_MLNextDirection& oe8_MLNextDirection);

   virtual tVoid vVisit_MLSpeedLimitUpdate(metersrv_fi_tcl_MLSpeedLimitUpdate& oMLSpeedLimitUpdate);

   virtual tVoid vVisit_MLNavigationNextDistanceUpdate(metersrv_fi_tcl_MLNavigationNextDistanceUpdate& oMLNavigationNextDistanceUpdate);

   virtual tVoid vVisit_MLNavigationTripInfoUpdate(metersrv_fi_tcl_MLNavigationTripInfoUpdate& oMLNavigationTripInfoUpdate);

   virtual tVoid vVisit_e8_MLGuidanceActive(metersrv_fi_tcl_e8_MLGuidanceActive& oe8_MLGuidanceActive);

   virtual tVoid vVisit_MLNavigationInfoUpdate(metersrv_fi_tcl_MLNavigationInfoUpdate& oMLNavigationInfoUpdate);

   virtual tVoid vVisit_MLNavigationNextManeuverUpdate(metersrv_fi_tcl_MLNavigationNextManeuverUpdate& oMLNavigationNextManeuverUpdate);

   virtual tVoid vVisit_MLTBTUpdate(metersrv_fi_tcl_MLTBTUpdate& oMLTBTUpdate);

   virtual tVoid vVisit_e8_DiPoManeuverState(metersrv_fi_tcl_e8_DiPoManeuverState& oe8_DiPoManeuverState);

   virtual tVoid vVisit_DiPORouteGuidanceUpdate(metersrv_fi_tcl_DiPORouteGuidanceUpdate& oDiPORouteGuidanceUpdate);

   virtual tVoid vVisit_e8_DiPoManeuverType(metersrv_fi_tcl_e8_DiPoManeuverType& oe8_DiPoManeuverType);

   virtual tVoid vVisit_e8_DiPoDrivingSide(metersrv_fi_tcl_e8_DiPoDrivingSide& oe8_DiPoDrivingSide);

   virtual tVoid vVisit_e8_DiPoJunctionType(metersrv_fi_tcl_e8_DiPoJunctionType& oe8_DiPoJunctionType);

   virtual tVoid vVisit_DiPORouteGuidanceManeuverUpdate(metersrv_fi_tcl_DiPORouteGuidanceManeuverUpdate& oDiPORouteGuidanceManeuverUpdate);

   virtual tVoid vVisit_CarPlayTBTUpdate(metersrv_fi_tcl_CarPlayTBTUpdate& oCarPlayTBTUpdate);

   virtual tVoid vVisit_e8_AAutoNextTurnEvent(metersrv_fi_tcl_e8_AAutoNextTurnEvent& oe8_AAutoNextTurnEvent);

   virtual tVoid vVisit_AAutoNavigationNextTurnData(metersrv_fi_tcl_AAutoNavigationNextTurnData& oAAutoNavigationNextTurnData);

   virtual tVoid vVisit_AAutoNavigationNextTurnDistanceData(metersrv_fi_tcl_AAutoNavigationNextTurnDistanceData& oAAutoNavigationNextTurnDistanceData);

   virtual tVoid vVisit_e8_AAutoNavigationAppState(metersrv_fi_tcl_e8_AAutoNavigationAppState& oe8_AAutoNavigationAppState);

   virtual tVoid vVisit_AAutoTBTUpdate(metersrv_fi_tcl_AAutoTBTUpdate& oAAutoTBTUpdate);

   virtual tVoid vVisit_e8_BDCLNextTurnType(metersrv_fi_tcl_e8_BDCLNextTurnType& oe8_BDCLNextTurnType);

   virtual tVoid vVisit_CarlifeNaviNextTurnInfo(metersrv_fi_tcl_CarlifeNaviNextTurnInfo& oCarlifeNaviNextTurnInfo);

   virtual tVoid vVisit_e8_BDCLAssistantType(metersrv_fi_tcl_e8_BDCLAssistantType& oe8_BDCLAssistantType);

   virtual tVoid vVisit_e8_BDCLTrafficSignType(metersrv_fi_tcl_e8_BDCLTrafficSignType& oe8_BDCLTrafficSignType);

   virtual tVoid vVisit_CarlifeNaviAssistantGuideInfo(metersrv_fi_tcl_CarlifeNaviAssistantGuideInfo& oCarlifeNaviAssistantGuideInfo);

   virtual tVoid vVisit_BDCLTBTUpdate(metersrv_fi_tcl_BDCLTBTUpdate& oBDCLTBTUpdate);

   virtual tVoid vVisit_e8_WeatherInformationSource(metersrv_fi_tcl_e8_WeatherInformationSource& oe8_WeatherInformationSource);

   virtual tVoid vVisit_e8_WeatherLocationType(metersrv_fi_tcl_e8_WeatherLocationType& oe8_WeatherLocationType);

   virtual tVoid vVisit_e8_WeatherReportType(metersrv_fi_tcl_e8_WeatherReportType& oe8_WeatherReportType);

   virtual tVoid vVisit_e8_CloudCoverage(metersrv_fi_tcl_e8_CloudCoverage& oe8_CloudCoverage);

   virtual tVoid vVisit_e8_UVIndex(metersrv_fi_tcl_e8_UVIndex& oe8_UVIndex);

   virtual tVoid vVisit_e8_WeatherSituation(metersrv_fi_tcl_e8_WeatherSituation& oe8_WeatherSituation);

   virtual tVoid vVisit_e8_WeatherSeverity(metersrv_fi_tcl_e8_WeatherSeverity& oe8_WeatherSeverity);

   virtual tVoid vVisit_WeatherConfigurationInformation(metersrv_fi_tcl_WeatherConfigurationInformation& oWeatherConfigurationInformation);

   virtual tVoid vVisit_WeatherReportConfiguration(metersrv_fi_tcl_WeatherReportConfiguration& oWeatherReportConfiguration);

   virtual tVoid vVisit_WeatherReport(metersrv_fi_tcl_WeatherReport& oWeatherReport);

   virtual tVoid vVisit_WeatherReportInfo(metersrv_fi_tcl_WeatherReportInfo& oWeatherReportInfo);

   virtual tVoid vVisit_e8_Meter_SWSC_KeyCode(metersrv_fi_tcl_e8_Meter_SWSC_KeyCode& oe8_Meter_SWSC_KeyCode);

   virtual tVoid vVisit_e8_Meter_Phone_SMS_State(metersrv_fi_tcl_e8_Meter_Phone_SMS_State& oe8_Meter_Phone_SMS_State);

   virtual tVoid vVisit_e8_Meter_Phone_SMS_Selected_Menu(metersrv_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu& oe8_Meter_Phone_SMS_Selected_Menu);

   virtual tVoid vVisit_e8_Meter_Phone_SMS_PopupType(metersrv_fi_tcl_e8_Meter_Phone_SMS_PopupType& oe8_Meter_Phone_SMS_PopupType);

   virtual tVoid vVisit_e8_meter_Phone_SMS_Action(metersrv_fi_tcl_e8_meter_Phone_SMS_Action& oe8_meter_Phone_SMS_Action);

   virtual tVoid vVisit_e8_meter_SmsTextTypes(metersrv_fi_tcl_e8_meter_SmsTextTypes& oe8_meter_SmsTextTypes);

   virtual tVoid vVisit_e8_MeterCallStatus(metersrv_fi_tcl_e8_MeterCallStatus& oe8_MeterCallStatus);

   virtual tVoid vVisit_e8_meter_Phone_SMS_Command(metersrv_fi_tcl_e8_meter_Phone_SMS_Command& oe8_meter_Phone_SMS_Command);

   virtual tVoid vVisit_e8_MeterCallType(metersrv_fi_tcl_e8_MeterCallType& oe8_MeterCallType);

   virtual tVoid vVisit_Meter_PhoneCallInfoList(metersrv_fi_tcl_Meter_PhoneCallInfoList& oMeter_PhoneCallInfoList);

   virtual tVoid vVisit_Meter_PhoneTextTranslation(metersrv_fi_tcl_Meter_PhoneTextTranslation& oMeter_PhoneTextTranslation);

   virtual tVoid vVisit_MsgMessageHandle(metersrv_fi_tcl_MsgMessageHandle& oMsgMessageHandle);

   virtual tVoid vVisit_e8_Meter_VR_State(metersrv_fi_tcl_e8_Meter_VR_State& oe8_Meter_VR_State);

   virtual tVoid vVisit_e8_Meter_VR_Digit_Type2(metersrv_fi_tcl_e8_Meter_VR_Digit_Type2& oe8_Meter_VR_Digit_Type2);

   virtual tVoid vVisit_e8_Meter_PowerState(metersrv_fi_tcl_e8_Meter_PowerState& oe8_Meter_PowerState);

   virtual tVoid vVisit_e8_Meter_TimeInfoType(metersrv_fi_tcl_e8_Meter_TimeInfoType& oe8_Meter_TimeInfoType);

   virtual tVoid vVisit_e8_Meter_PhoneCall_Menu_Action(metersrv_fi_tcl_e8_Meter_PhoneCall_Menu_Action& oe8_Meter_PhoneCall_Menu_Action);

   virtual tVoid vVisit_e8_Meter_PhoneCall_State(metersrv_fi_tcl_e8_Meter_PhoneCall_State& oe8_Meter_PhoneCall_State);

   virtual tVoid vVisit_e8_Language_InvalidParameter(metersrv_fi_tcl_e8_Language_InvalidParameter& oe8_Language_InvalidParameter);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
