/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef METERSRV_ALLFITYPES_HEADER
#define METERSRV_ALLFITYPES_HEADER

#include <vector>

class metersrv_fi_tclVisitorBase;

const tU16 METERSRV_FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 METERSRV_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 METERSRV_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class metersrv_fi_tclTypeBase : public fi_tclTypeBase
{
public:
  metersrv_fi_tclTypeBase() {}
  virtual ~metersrv_fi_tclTypeBase() {}
   
  virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& /*oVisitor*/) {}
};

class metersrv_fi_tclVisitableTypeBase :public metersrv_fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& /*oVisitor*/) {}
};

class metersrv_fi_tclU8 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclU8& roRef) const
      { return (u8Value == roRef.u8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_U8;}
};

class metersrv_fi_tclS8 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclS8& roRef) const
      { return (s8Value == roRef.s8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_S8;}
};

class metersrv_fi_tclU16 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclU16& roRef) const
      { return (u16Value == roRef.u16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_U16;}
};

class metersrv_fi_tclS16 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclS16& roRef) const
      { return (s16Value == roRef.s16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_S16;}
};

class metersrv_fi_tclU24 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclU24& roRef) const
      { return (u24Value == roRef.u24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_U24;}
};

class metersrv_fi_tclS24 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclS24& roRef) const
      { return (s24Value == roRef.s24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_S24;}
};

class metersrv_fi_tclU32 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclU32& roRef) const
      { return (u32Value == roRef.u32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_U32;}
};

class metersrv_fi_tclS32 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclS32& roRef) const
      { return (s32Value == roRef.s32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_S32;}
};

class metersrv_fi_tclU64 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclU64& roRef) const
      { return (u64Value == roRef.u64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_U64;}
};

class metersrv_fi_tclS64 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclS64& roRef) const
      { return (s64Value == roRef.s64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_S64;}
};

class metersrv_fi_tclF32 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclF32& roRef) const
      { return (f32Value == roRef.f32Value);  } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_F32;}
};

class metersrv_fi_tclF64 : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclF64& roRef) const
      { return (f64Value == roRef.f64Value); } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_F64;}
};

class metersrv_fi_tclBool : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const metersrv_fi_tclBool& roRef) const
      { return (bValue == roRef.bValue); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_BOOL;}
};

class metersrv_fi_tclString : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tclString(const metersrv_fi_tclString& coRef);
   metersrv_fi_tclString& operator=(const metersrv_fi_tclString& coRef);
   virtual ~metersrv_fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const metersrv_fi_tclString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   metersrv_fi_tclString& operator=(tCString coszString); // ADDED
   metersrv_fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const metersrv_fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class metersrv_fi_tclList : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const metersrv_fi_tclList& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_LIST;}
};

class metersrv_fi_tclMultiLanguageString : public metersrv_fi_tclVisitableTypeBase
{
public:
   metersrv_fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tclMultiLanguageString(const metersrv_fi_tclMultiLanguageString& coRef);
   metersrv_fi_tclMultiLanguageString& operator=(const metersrv_fi_tclMultiLanguageString& coRef);
   virtual ~metersrv_fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const metersrv_fi_tclMultiLanguageString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(metersrv_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   metersrv_fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   metersrv_fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return metersrv_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const metersrv_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class metersrv_fi_tcl_BinContainer;
class metersrv_fi_tcl_Reserved;
class metersrv_fi_tcl_u8_Percent;
class metersrv_fi_tcl_s16_PerThousand;
class metersrv_fi_tcl_u16_IndexInReferenceList;
class metersrv_fi_tcl_u16_ErrorCode;
class metersrv_fi_tcl_u16_RPM;
class metersrv_fi_tcl_s32_Kilogram;
class metersrv_fi_tcl_s32_Pound;
class metersrv_fi_tcl_s16_Meter;
class metersrv_fi_tcl_s32_Meter;
class metersrv_fi_tcl_s32_Yards;
class metersrv_fi_tcl_s32_Foot;
class metersrv_fi_tcl_s32_Centimeter;
class metersrv_fi_tcl_s32_Inch;
class metersrv_fi_tcl_s32_Millimeter;
class metersrv_fi_tcl_s32_Microliter;
class metersrv_fi_tcl_s32_Second;
class metersrv_fi_tcl_u16_MilliSecond;
class metersrv_fi_tcl_s32_MilliSecond;
class metersrv_fi_tcl_POSIXTime;
class metersrv_fi_tcl_e8_DST_State;
class metersrv_fi_tcl_TimeZoneElement;
class metersrv_fi_tcl_s16_KmPerHour;
class metersrv_fi_tcl_s16_MilesPerHour;
class metersrv_fi_tcl_s16_Knot;
class metersrv_fi_tcl_s16_CentimeterSecond;
class metersrv_fi_tcl_s16_Kelvin;
class metersrv_fi_tcl_s16_Fahrenheit;
class metersrv_fi_tcl_s32_Pascal;
class metersrv_fi_tcl_s32_Watt;
class metersrv_fi_tcl_FIVersion;
class metersrv_fi_tcl_s32_Longitude;
class metersrv_fi_tcl_s32_Latitude;
class metersrv_fi_tcl_PositionWGS84;
class metersrv_fi_tcl_RectangleWGS84;
class metersrv_fi_tcl_e16_ISOCountryCode;
class metersrv_fi_tcl_e16_ISOLanguageCode;
class metersrv_fi_tcl_LanguageID;
class metersrv_fi_tcl_u8_DirectionAbsolute;
class metersrv_fi_tcl_u8_DirectionRelative;
class metersrv_fi_tcl_s16_CentiDegree;
class metersrv_fi_tcl_s16_Degree;
class metersrv_fi_tcl_u16_DirectionAbsolute_CentiDegree;
class metersrv_fi_tcl_s16_DirectionRelative_CentiDegree;
class metersrv_fi_tcl_e8_FuelType;
class metersrv_fi_tcl_DistTimeFuel;
class metersrv_fi_tcl_e8_Meter_UnitType;
class metersrv_fi_tcl_e8_Meter_ConfigurationStatus;
class metersrv_fi_tcl_Meter_VersionInfo;
class metersrv_fi_tcl_Meter_UnitConnectionStatus;
class metersrv_fi_tcl_Meter_UnitConfiguration;
class metersrv_fi_tcl_Meter_UnitVersion;
class metersrv_fi_tcl_Meter_UnitDataTransmissionStatus;
class metersrv_fi_tcl_e8VersionInfo;
class metersrv_fi_tcl_e8_Meter_SupportedFunction;
class metersrv_fi_tcl_e8_Meter_Language;
class metersrv_fi_tcl_e8_Meter_Language_Action;
class metersrv_fi_tcl_e8_Lang_Sync_Mode_Type;
class metersrv_fi_tcl_e8_Meter_Language_Status;
class metersrv_fi_tcl_e8_Meter_RequestedLanguageResult;
class metersrv_fi_tcl_e8_Meter_DistanceUnit;
class metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit;
class metersrv_fi_tcl_e8_Meter_TemperatureUnit;
class metersrv_fi_tcl_e8_Meter_PressureUnit;
class metersrv_fi_tcl_e8_Meter_Switch;
class metersrv_fi_tcl_e8_Meter_Eco_Drive;
class metersrv_fi_tcl_e8_Meter_Low_Temp;
class metersrv_fi_tcl_e8_ProPilot_Meter_Switch;
class metersrv_fi_tcl_e8_ProPilot_State_Switch;
class metersrv_fi_tcl_e8_Meter_ECO_Accel;
class metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode;
class metersrv_fi_tcl_Meter_Audio_NoData;
class metersrv_fi_tcl_e8_Meter_Audio_RadioSource;
class metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate;
class metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName;
class metersrv_fi_tcl_e8_Meter_Audio_HDRadioSource;
class metersrv_fi_tcl_e8_Meter_Audio_RadioLabelType;
class metersrv_fi_tcl_Meter_Audio_RadioLabel;
class metersrv_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit;
class metersrv_fi_tcl_Meter_Audio_RadioFrequency;
class metersrv_fi_tcl_e8_Meter_Audio_RadioCategoryType;
class metersrv_fi_tcl_Meter_Audio_RadioCategory;
class metersrv_fi_tcl_Meter_Audio_RadioData;
class metersrv_fi_tcl_Meter_Audio_HDRadioData;
class metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoUpdate;
class metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoName;
class metersrv_fi_tcl_e8_Meter_Audio_DTVSource;
class metersrv_fi_tcl_Meter_Audio_DTVFrequency;
class metersrv_fi_tcl_e8_Meter_Audio_DTVLabelType;
class metersrv_fi_tcl_Meter_Audio_DTVLabel;
class metersrv_fi_tcl_Meter_Audio_DTVData;
class metersrv_fi_tcl_e8_Meter_Audio_MediaType;
class metersrv_fi_tcl_e8_Meter_Audio_TrackLabelType;
class metersrv_fi_tcl_Meter_Audio_TrackInfo;
class metersrv_fi_tcl_e8_Meter_Audio_GroupLabelType;
class metersrv_fi_tcl_Meter_Audio_GroupInfo;
class metersrv_fi_tcl_e8_Meter_Audio_ArtistLabelType;
class metersrv_fi_tcl_Meter_Audio_ArtistInfo;
class metersrv_fi_tcl_Meter_Audio_MediaData;
class metersrv_fi_tcl_e8_Meter_Audio_AuxType;
class metersrv_fi_tcl_Meter_Audio_AuxData;
class metersrv_fi_tcl_Meter_Audio_ExternalSoundData;
class metersrv_fi_tcl_Meter_Audio_InternetRadioData;
class metersrv_fi_tcl_e8_Meter_Audio_SourceInfoType;
class metersrv_fi_tcl_Meter_Audio_SourceInfoUnion;
class metersrv_fi_tcl_e8_Meter_Audio_WarningSource;
class metersrv_fi_tcl_e8_Meter_Audio_WarningState;
class metersrv_fi_tcl_e8_Meter_Audio_SpecialMode;
class metersrv_fi_tcl_e8_Meter_Audio_SourceType;
class metersrv_fi_tcl_e8_Meter_Current_Radio_Mode;
class metersrv_fi_tcl_e8_meter_Renault_Update_List_Value;
class metersrv_fi_tcl_e8_NavStatus;
class metersrv_fi_tcl_e8_RoadClass;
class metersrv_fi_tcl_e8_DistanceUnit;
class metersrv_fi_tcl_e8_ManeuverSymbol;
class metersrv_fi_tcl_e8_SpeedUnit;
class metersrv_fi_tcl_e8_ManeuverRecommendationType;
class metersrv_fi_tcl_e8_EstimatedTimeType;
class metersrv_fi_tcl_e8_TimeType;
class metersrv_fi_tcl_e8_TimeFormat;
class metersrv_fi_tcl_e8_ManeuverView;
class metersrv_fi_tcl_e8_DeformedImageRoad;
class metersrv_fi_tcl_e8_DeformedImageArrow;
class metersrv_fi_tcl_e8_LaneStatus;
class metersrv_fi_tcl_LaneRecommendation;
class metersrv_fi_tcl_ArrivalInformation;
class metersrv_fi_tcl_ScreenCoordinate;
class metersrv_fi_tcl_e8_AdminRoadClass;
class metersrv_fi_tcl_IntersectionMapRoadLine;
class metersrv_fi_tcl_e8_IntersectionMapCarsorState;
class metersrv_fi_tcl_e8_SpiNavigation_NavigationAppState;
class metersrv_fi_tcl_e8_SpiNavigation_TurnSide;
class metersrv_fi_tcl_e8_SpiNavigation_NextTurnEvent;
class metersrv_fi_tcl_e8_SpiNavigation_ManeuverDistanceUnits;
class metersrv_fi_tcl_e8_DistanceUnits;
class metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementAlertState;
class metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementCameraType;
class metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementDistanceType;
class metersrv_fi_tcl_e8_DeviceCategory;
class metersrv_fi_tcl_e8_DiPoRouteGuidanceState;
class metersrv_fi_tcl_e8_AAutoTurnSide;
class metersrv_fi_tcl_e8_BDCLNavigationAppState;
class metersrv_fi_tcl_e8_MLGuidanceState;
class metersrv_fi_tcl_e8_MLNextDirection;
class metersrv_fi_tcl_MLSpeedLimitUpdate;
class metersrv_fi_tcl_MLNavigationNextDistanceUpdate;
class metersrv_fi_tcl_MLNavigationTripInfoUpdate;
class metersrv_fi_tcl_e8_MLGuidanceActive;
class metersrv_fi_tcl_MLNavigationInfoUpdate;
class metersrv_fi_tcl_MLNavigationNextManeuverUpdate;
class metersrv_fi_tcl_MLTBTUpdate;
class metersrv_fi_tcl_e8_DiPoManeuverState;
class metersrv_fi_tcl_DiPORouteGuidanceUpdate;
class metersrv_fi_tcl_e8_DiPoManeuverType;
class metersrv_fi_tcl_e8_DiPoDrivingSide;
class metersrv_fi_tcl_e8_DiPoJunctionType;
class metersrv_fi_tcl_DiPORouteGuidanceManeuverUpdate;
class metersrv_fi_tcl_CarPlayTBTUpdate;
class metersrv_fi_tcl_e8_AAutoNextTurnEvent;
class metersrv_fi_tcl_AAutoNavigationNextTurnData;
class metersrv_fi_tcl_AAutoNavigationNextTurnDistanceData;
class metersrv_fi_tcl_e8_AAutoNavigationAppState;
class metersrv_fi_tcl_AAutoTBTUpdate;
class metersrv_fi_tcl_e8_BDCLNextTurnType;
class metersrv_fi_tcl_CarlifeNaviNextTurnInfo;
class metersrv_fi_tcl_e8_BDCLAssistantType;
class metersrv_fi_tcl_e8_BDCLTrafficSignType;
class metersrv_fi_tcl_CarlifeNaviAssistantGuideInfo;
class metersrv_fi_tcl_BDCLTBTUpdate;
class metersrv_fi_tcl_e8_WeatherInformationSource;
class metersrv_fi_tcl_e8_WeatherLocationType;
class metersrv_fi_tcl_e8_WeatherReportType;
class metersrv_fi_tcl_e8_CloudCoverage;
class metersrv_fi_tcl_e8_UVIndex;
class metersrv_fi_tcl_e8_WeatherSituation;
class metersrv_fi_tcl_e8_WeatherSeverity;
class metersrv_fi_tcl_WeatherConfigurationInformation;
class metersrv_fi_tcl_WeatherReportConfiguration;
class metersrv_fi_tcl_WeatherReport;
class metersrv_fi_tcl_WeatherReportInfo;
class metersrv_fi_tcl_e8_Meter_SWSC_KeyCode;
class metersrv_fi_tcl_e8_Meter_Phone_SMS_State;
class metersrv_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu;
class metersrv_fi_tcl_e8_Meter_Phone_SMS_PopupType;
class metersrv_fi_tcl_e8_meter_Phone_SMS_Action;
class metersrv_fi_tcl_e8_meter_SmsTextTypes;
class metersrv_fi_tcl_e8_MeterCallStatus;
class metersrv_fi_tcl_e8_meter_Phone_SMS_Command;
class metersrv_fi_tcl_e8_MeterCallType;
class metersrv_fi_tcl_Meter_PhoneCallInfoList;
class metersrv_fi_tcl_Meter_PhoneTextTranslation;
class metersrv_fi_tcl_MsgMessageHandle;
class metersrv_fi_tcl_e8_Meter_VR_State;
class metersrv_fi_tcl_e8_Meter_VR_Digit_Type2;
class metersrv_fi_tcl_e8_Meter_PowerState;
class metersrv_fi_tcl_e8_Meter_TimeInfoType;
class metersrv_fi_tcl_e8_Meter_PhoneCall_Menu_Action;
class metersrv_fi_tcl_e8_Meter_PhoneCall_State;
class metersrv_fi_tcl_e8_Language_InvalidParameter;
class metersrv_fi_tcl_BinContainer : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_BinContainer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_BinContainer& operator=(const metersrv_fi_tcl_BinContainer& coRef);
   metersrv_fi_tcl_BinContainer(const metersrv_fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ContainerDataList;
   virtual ~metersrv_fi_tcl_BinContainer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_BinContainer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Reserved : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Reserved();

   virtual ~metersrv_fi_tcl_Reserved();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_Reserved& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_u8_Percent : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_u8_Percent(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~metersrv_fi_tcl_u8_Percent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_u8_Percent& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s16_PerThousand : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s16_PerThousand(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~metersrv_fi_tcl_s16_PerThousand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s16_PerThousand& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_u16_IndexInReferenceList : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~metersrv_fi_tcl_u16_IndexInReferenceList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_u16_IndexInReferenceList& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_u16_ErrorCode : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_u16_ErrorCode(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~metersrv_fi_tcl_u16_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_u16_ErrorCode& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_u16_RPM : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_u16_RPM(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~metersrv_fi_tcl_u16_RPM();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_u16_RPM& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Kilogram : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Kilogram(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Kilogram();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Kilogram& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Pound : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Pound(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Pound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Pound& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s16_Meter : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s16_Meter(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~metersrv_fi_tcl_s16_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s16_Meter& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Meter : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Meter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Meter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Yards : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Yards(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Yards();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Yards& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Foot : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Foot(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Foot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Foot& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Centimeter : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Centimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Centimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Centimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Inch : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Inch(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Inch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Inch& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Millimeter : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Millimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Millimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Millimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Microliter : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Microliter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Microliter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Microliter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Second : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Second(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Second();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Second& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_u16_MilliSecond : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_u16_MilliSecond(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~metersrv_fi_tcl_u16_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_u16_MilliSecond& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_MilliSecond : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_MilliSecond(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_MilliSecond& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_POSIXTime : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_POSIXTime();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_POSIXTime& operator=(const metersrv_fi_tcl_POSIXTime& coRef);
   metersrv_fi_tcl_POSIXTime(const metersrv_fi_tcl_POSIXTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Time;
   virtual ~metersrv_fi_tcl_POSIXTime();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_POSIXTime& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_DST_State : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_DST_State();
   enum tenType {
      FI_EN_T_STANDARDTIME = 0UL,
      FI_EN_T_DAYLIGHTSAVINGTIME = 1UL,
      FI_EN_T_EVALUATIONNECESSARY = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_DST_State(metersrv_fi_tcl_e8_DST_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_DST_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_DST_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_TimeZoneElement : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_TimeZoneElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_TimeZoneElement& operator=(const metersrv_fi_tcl_TimeZoneElement& coRef);
   metersrv_fi_tcl_TimeZoneElement(const metersrv_fi_tcl_TimeZoneElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclMultiLanguageString Abbreviation_StandardTime;
   metersrv_fi_tclMultiLanguageString Abbreviation_DST_in_effect;
   metersrv_fi_tcl_s32_Second TimeZoneDifference;
   metersrv_fi_tcl_e8_DST_State DST_State;
   metersrv_fi_tcl_s32_Second DSTDifference;
   std::vector<tU8, std::allocator<tU8> > DST_TimeDomain;
   virtual ~metersrv_fi_tcl_TimeZoneElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_TimeZoneElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s16_KmPerHour : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s16_KmPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~metersrv_fi_tcl_s16_KmPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s16_KmPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s16_MilesPerHour : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s16_MilesPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~metersrv_fi_tcl_s16_MilesPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s16_MilesPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s16_Knot : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s16_Knot(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~metersrv_fi_tcl_s16_Knot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s16_Knot& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s16_CentimeterSecond : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s16_CentimeterSecond(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~metersrv_fi_tcl_s16_CentimeterSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s16_CentimeterSecond& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s16_Kelvin : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s16_Kelvin(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~metersrv_fi_tcl_s16_Kelvin();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s16_Kelvin& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s16_Fahrenheit : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s16_Fahrenheit(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~metersrv_fi_tcl_s16_Fahrenheit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s16_Fahrenheit& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Pascal : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Pascal(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Pascal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Pascal& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Watt : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Watt(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Watt();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Watt& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_FIVersion : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_FIVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_FIVersion& operator=(const metersrv_fi_tcl_FIVersion& coRef);
   metersrv_fi_tcl_FIVersion(const metersrv_fi_tcl_FIVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MajorVersion;
   tU8 MinorVersion;
   tU8 PatchVersion;
   virtual ~metersrv_fi_tcl_FIVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_FIVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Longitude : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Longitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Longitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Longitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s32_Latitude : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s32_Latitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~metersrv_fi_tcl_s32_Latitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s32_Latitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_PositionWGS84 : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_PositionWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_PositionWGS84& operator=(const metersrv_fi_tcl_PositionWGS84& coRef);
   metersrv_fi_tcl_PositionWGS84(const metersrv_fi_tcl_PositionWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_s32_Longitude Longitude;
   metersrv_fi_tcl_s32_Latitude Latitude;
   virtual ~metersrv_fi_tcl_PositionWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_PositionWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_RectangleWGS84 : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_RectangleWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_RectangleWGS84& operator=(const metersrv_fi_tcl_RectangleWGS84& coRef);
   metersrv_fi_tcl_RectangleWGS84(const metersrv_fi_tcl_RectangleWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_s32_Longitude LongitudeMin;
   metersrv_fi_tcl_s32_Latitude LatitudeMin;
   metersrv_fi_tcl_s32_Longitude LongitudeMax;
   metersrv_fi_tcl_s32_Latitude LatitudeMax;
   virtual ~metersrv_fi_tcl_RectangleWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_RectangleWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e16_ISOCountryCode : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e16_ISOCountryCode();
   enum tenType {
      FI_EN_ISO_ALPHA_3_UNDEFINED = 0UL,
      FI_EN_ISO_ALPHA_3_AFG = 1223UL,
      FI_EN_ISO_ALPHA_3_ALB = 1410UL,
      FI_EN_ISO_ALPHA_3_DZA = 4929UL,
      FI_EN_ISO_ALPHA_3_ASM = 1645UL,
      FI_EN_ISO_ALPHA_3_AND = 1476UL,
      FI_EN_ISO_ALPHA_3_AGO = 1263UL,
      FI_EN_ISO_ALPHA_3_AIA = 1313UL,
      FI_EN_ISO_ALPHA_3_ATG = 1671UL,
      FI_EN_ISO_ALPHA_3_ARG = 1607UL,
      FI_EN_ISO_ALPHA_3_ARM = 1613UL,
      FI_EN_ISO_ALPHA_3_ABW = 1111UL,
      FI_EN_ISO_ALPHA_3_AUS = 1715UL,
      FI_EN_ISO_ALPHA_3_AUT = 1716UL,
      FI_EN_ISO_ALPHA_3_AZE = 1861UL,
      FI_EN_ISO_ALPHA_3_BHS = 2323UL,
      FI_EN_ISO_ALPHA_3_BHR = 2322UL,
      FI_EN_ISO_ALPHA_3_BGD = 2276UL,
      FI_EN_ISO_ALPHA_3_BRB = 2626UL,
      FI_EN_ISO_ALPHA_3_BLR = 2450UL,
      FI_EN_ISO_ALPHA_3_BEL = 2220UL,
      FI_EN_ISO_ALPHA_3_BLZ = 2458UL,
      FI_EN_ISO_ALPHA_3_BEN = 2222UL,
      FI_EN_ISO_ALPHA_3_BMU = 2485UL,
      FI_EN_ISO_ALPHA_3_BTN = 2702UL,
      FI_EN_ISO_ALPHA_3_BOL = 2540UL,
      FI_EN_ISO_ALPHA_3_BIH = 2344UL,
      FI_EN_ISO_ALPHA_3_BWA = 2785UL,
      FI_EN_ISO_ALPHA_3_BRA = 2625UL,
      FI_EN_ISO_ALPHA_3_BRN = 2638UL,
      FI_EN_ISO_ALPHA_3_BGR = 2290UL,
      FI_EN_ISO_ALPHA_3_BFA = 2241UL,
      FI_EN_ISO_ALPHA_3_BDI = 2185UL,
      FI_EN_ISO_ALPHA_3_KHM = 11533UL,
      FI_EN_ISO_ALPHA_3_CMR = 3506UL,
      FI_EN_ISO_ALPHA_3_CAN = 3118UL,
      FI_EN_ISO_ALPHA_3_CPV = 3606UL,
      FI_EN_ISO_ALPHA_3_CYM = 3885UL,
      FI_EN_ISO_ALPHA_3_CAF = 3110UL,
      FI_EN_ISO_ALPHA_3_TCD = 20580UL,
      FI_EN_ISO_ALPHA_3_CHL = 3340UL,
      FI_EN_ISO_ALPHA_3_CHN = 3342UL,
      FI_EN_ISO_ALPHA_3_COL = 3564UL,
      FI_EN_ISO_ALPHA_3_COM = 3565UL,
      FI_EN_ISO_ALPHA_3_COG = 3559UL,
      FI_EN_ISO_ALPHA_3_COD = 3556UL,
      FI_EN_ISO_ALPHA_3_COK = 3563UL,
      FI_EN_ISO_ALPHA_3_CRI = 3657UL,
      FI_EN_ISO_ALPHA_3_CIV = 3382UL,
      FI_EN_ISO_ALPHA_3_HRV = 8790UL,
      FI_EN_ISO_ALPHA_3_CUB = 3746UL,
      FI_EN_ISO_ALPHA_3_CYP = 3888UL,
      FI_EN_ISO_ALPHA_3_CZE = 3909UL,
      FI_EN_ISO_ALPHA_3_DNK = 4555UL,
      FI_EN_ISO_ALPHA_3_DJI = 4425UL,
      FI_EN_ISO_ALPHA_3_DMA = 4513UL,
      FI_EN_ISO_ALPHA_3_DOM = 4589UL,
      FI_EN_ISO_ALPHA_3_ECU = 5237UL,
      FI_EN_ISO_ALPHA_3_EGY = 5369UL,
      FI_EN_ISO_ALPHA_3_SLV = 19862UL,
      FI_EN_ISO_ALPHA_3_GNQ = 7633UL,
      FI_EN_ISO_ALPHA_3_ERI = 5705UL,
      FI_EN_ISO_ALPHA_3_EST = 5748UL,
      FI_EN_ISO_ALPHA_3_ETH = 5768UL,
      FI_EN_ISO_ALPHA_3_FLK = 6539UL,
      FI_EN_ISO_ALPHA_3_FRO = 6735UL,
      FI_EN_ISO_ALPHA_3_FJI = 6473UL,
      FI_EN_ISO_ALPHA_3_FIN = 6446UL,
      FI_EN_ISO_ALPHA_3_FRA = 6721UL,
      FI_EN_ISO_ALPHA_3_GUF = 7846UL,
      FI_EN_ISO_ALPHA_3_PYF = 17190UL,
      FI_EN_ISO_ALPHA_3_GAB = 7202UL,
      FI_EN_ISO_ALPHA_3_GMB = 7586UL,
      FI_EN_ISO_ALPHA_3_GEO = 7343UL,
      FI_EN_ISO_ALPHA_3_DEU = 4277UL,
      FI_EN_ISO_ALPHA_3_GHA = 7425UL,
      FI_EN_ISO_ALPHA_3_GIB = 7458UL,
      FI_EN_ISO_ALPHA_3_GRC = 7747UL,
      FI_EN_ISO_ALPHA_3_GRL = 7756UL,
      FI_EN_ISO_ALPHA_3_GRD = 7748UL,
      FI_EN_ISO_ALPHA_3_GLP = 7568UL,
      FI_EN_ISO_ALPHA_3_GUM = 7853UL,
      FI_EN_ISO_ALPHA_3_GTM = 7821UL,
      FI_EN_ISO_ALPHA_3_GIN = 7470UL,
      FI_EN_ISO_ALPHA_3_GNB = 7618UL,
      FI_EN_ISO_ALPHA_3_GUY = 7865UL,
      FI_EN_ISO_ALPHA_3_HTI = 8841UL,
      FI_EN_ISO_ALPHA_3_VAT = 22580UL,
      FI_EN_ISO_ALPHA_3_HND = 8644UL,
      FI_EN_ISO_ALPHA_3_HKG = 8551UL,
      FI_EN_ISO_ALPHA_3_HUN = 8878UL,
      FI_EN_ISO_ALPHA_3_ISL = 9836UL,
      FI_EN_ISO_ALPHA_3_IND = 9668UL,
      FI_EN_ISO_ALPHA_3_IDN = 9358UL,
      FI_EN_ISO_ALPHA_3_INT = 9684UL,
      FI_EN_ISO_ALPHA_3_IRN = 9806UL,
      FI_EN_ISO_ALPHA_3_IRQ = 9809UL,
      FI_EN_ISO_ALPHA_3_IRL = 9804UL,
      FI_EN_ISO_ALPHA_3_ISR = 9842UL,
      FI_EN_ISO_ALPHA_3_ITA = 9857UL,
      FI_EN_ISO_ALPHA_3_JAM = 10285UL,
      FI_EN_ISO_ALPHA_3_JPN = 10766UL,
      FI_EN_ISO_ALPHA_3_JOR = 10738UL,
      FI_EN_ISO_ALPHA_3_KAZ = 11322UL,
      FI_EN_ISO_ALPHA_3_KEN = 11438UL,
      FI_EN_ISO_ALPHA_3_KIR = 11570UL,
      FI_EN_ISO_ALPHA_3_PRK = 16971UL,
      FI_EN_ISO_ALPHA_3_KOR = 11762UL,
      FI_EN_ISO_ALPHA_3_KWT = 12020UL,
      FI_EN_ISO_ALPHA_3_KGZ = 11514UL,
      FI_EN_ISO_ALPHA_3_LAO = 12335UL,
      FI_EN_ISO_ALPHA_3_LVA = 12993UL,
      FI_EN_ISO_ALPHA_3_LBN = 12366UL,
      FI_EN_ISO_ALPHA_3_LSO = 12911UL,
      FI_EN_ISO_ALPHA_3_LBR = 12370UL,
      FI_EN_ISO_ALPHA_3_LBY = 12377UL,
      FI_EN_ISO_ALPHA_3_LIE = 12581UL,
      FI_EN_ISO_ALPHA_3_LTU = 12949UL,
      FI_EN_ISO_ALPHA_3_LUX = 12984UL,
      FI_EN_ISO_ALPHA_3_MAC = 13347UL,
      FI_EN_ISO_ALPHA_3_MKD = 13668UL,
      FI_EN_ISO_ALPHA_3_MDG = 13447UL,
      FI_EN_ISO_ALPHA_3_MWI = 14057UL,
      FI_EN_ISO_ALPHA_3_MYS = 14131UL,
      FI_EN_ISO_ALPHA_3_MDV = 13462UL,
      FI_EN_ISO_ALPHA_3_MLI = 13705UL,
      FI_EN_ISO_ALPHA_3_MLT = 13716UL,
      FI_EN_ISO_ALPHA_3_MHL = 13580UL,
      FI_EN_ISO_ALPHA_3_MTQ = 13969UL,
      FI_EN_ISO_ALPHA_3_MRT = 13908UL,
      FI_EN_ISO_ALPHA_3_MUS = 14003UL,
      FI_EN_ISO_ALPHA_3_MYT = 14132UL,
      FI_EN_ISO_ALPHA_3_MEX = 13496UL,
      FI_EN_ISO_ALPHA_3_FSM = 6765UL,
      FI_EN_ISO_ALPHA_3_MDA = 13441UL,
      FI_EN_ISO_ALPHA_3_MCO = 13423UL,
      FI_EN_ISO_ALPHA_3_MNG = 13767UL,
      FI_EN_ISO_ALPHA_3_MNE = 13765UL,
      FI_EN_ISO_ALPHA_3_MSR = 13938UL,
      FI_EN_ISO_ALPHA_3_MAR = 13362UL,
      FI_EN_ISO_ALPHA_3_MOZ = 13818UL,
      FI_EN_ISO_ALPHA_3_MMR = 13746UL,
      FI_EN_ISO_ALPHA_3_NAM = 14381UL,
      FI_EN_ISO_ALPHA_3_NRU = 14933UL,
      FI_EN_ISO_ALPHA_3_NPL = 14860UL,
      FI_EN_ISO_ALPHA_3_NLD = 14724UL,
      FI_EN_ISO_ALPHA_3_ANT = 1492UL,
      FI_EN_ISO_ALPHA_3_NCL = 14444UL,
      FI_EN_ISO_ALPHA_3_NZL = 15180UL,
      FI_EN_ISO_ALPHA_3_NIC = 14627UL,
      FI_EN_ISO_ALPHA_3_NER = 14514UL,
      FI_EN_ISO_ALPHA_3_NGA = 14561UL,
      FI_EN_ISO_ALPHA_3_NIU = 14645UL,
      FI_EN_ISO_ALPHA_3_NFK = 14539UL,
      FI_EN_ISO_ALPHA_3_MNP = 13776UL,
      FI_EN_ISO_ALPHA_3_NOR = 14834UL,
      FI_EN_ISO_ALPHA_3_PSE = 16997UL,
      FI_EN_ISO_ALPHA_3_OMN = 15790UL,
      FI_EN_ISO_ALPHA_3_PAK = 16427UL,
      FI_EN_ISO_ALPHA_3_PLW = 16791UL,
      FI_EN_ISO_ALPHA_3_PAN = 16430UL,
      FI_EN_ISO_ALPHA_3_PNG = 16839UL,
      FI_EN_ISO_ALPHA_3_PRY = 16985UL,
      FI_EN_ISO_ALPHA_3_PER = 16562UL,
      FI_EN_ISO_ALPHA_3_PHL = 16652UL,
      FI_EN_ISO_ALPHA_3_PCN = 16494UL,
      FI_EN_ISO_ALPHA_3_POL = 16876UL,
      FI_EN_ISO_ALPHA_3_PRT = 16980UL,
      FI_EN_ISO_ALPHA_3_PRI = 16969UL,
      FI_EN_ISO_ALPHA_3_QAT = 17460UL,
      FI_EN_ISO_ALPHA_3_REU = 18613UL,
      FI_EN_ISO_ALPHA_3_ROU = 18933UL,
      FI_EN_ISO_ALPHA_3_RUS = 19123UL,
      FI_EN_ISO_ALPHA_3_RWA = 19169UL,
      FI_EN_ISO_ALPHA_3_KNA = 11713UL,
      FI_EN_ISO_ALPHA_3_LCA = 12385UL,
      FI_EN_ISO_ALPHA_3_VCT = 22644UL,
      FI_EN_ISO_ALPHA_3_WSM = 24173UL,
      FI_EN_ISO_ALPHA_3_SMR = 19890UL,
      FI_EN_ISO_ALPHA_3_STP = 20112UL,
      FI_EN_ISO_ALPHA_3_SAU = 19509UL,
      FI_EN_ISO_ALPHA_3_SEN = 19630UL,
      FI_EN_ISO_ALPHA_3_SRB = 20034UL,
      FI_EN_ISO_ALPHA_3_SYC = 20259UL,
      FI_EN_ISO_ALPHA_3_SLE = 19845UL,
      FI_EN_ISO_ALPHA_3_SGP = 19696UL,
      FI_EN_ISO_ALPHA_3_SVK = 20171UL,
      FI_EN_ISO_ALPHA_3_SVN = 20174UL,
      FI_EN_ISO_ALPHA_3_SLB = 19842UL,
      FI_EN_ISO_ALPHA_3_SOM = 19949UL,
      FI_EN_ISO_ALPHA_3_ZAF = 26662UL,
      FI_EN_ISO_ALPHA_3_ESP = 5744UL,
      FI_EN_ISO_ALPHA_3_LKA = 12641UL,
      FI_EN_ISO_ALPHA_3_SHN = 19726UL,
      FI_EN_ISO_ALPHA_3_SPM = 19981UL,
      FI_EN_ISO_ALPHA_3_SDN = 19598UL,
      FI_EN_ISO_ALPHA_3_SUR = 20146UL,
      FI_EN_ISO_ALPHA_3_SJM = 19789UL,
      FI_EN_ISO_ALPHA_3_SWZ = 20218UL,
      FI_EN_ISO_ALPHA_3_SWE = 20197UL,
      FI_EN_ISO_ALPHA_3_CHE = 3333UL,
      FI_EN_ISO_ALPHA_3_SYR = 20274UL,
      FI_EN_ISO_ALPHA_3_TWN = 21230UL,
      FI_EN_ISO_ALPHA_3_TJK = 20811UL,
      FI_EN_ISO_ALPHA_3_TZA = 21313UL,
      FI_EN_ISO_ALPHA_3_THA = 20737UL,
      FI_EN_ISO_ALPHA_3_TLS = 20883UL,
      FI_EN_ISO_ALPHA_3_TGO = 20719UL,
      FI_EN_ISO_ALPHA_3_TKL = 20844UL,
      FI_EN_ISO_ALPHA_3_TON = 20974UL,
      FI_EN_ISO_ALPHA_3_TTO = 21135UL,
      FI_EN_ISO_ALPHA_3_TUN = 21166UL,
      FI_EN_ISO_ALPHA_3_TUR = 21170UL,
      FI_EN_ISO_ALPHA_3_TKM = 20845UL,
      FI_EN_ISO_ALPHA_3_TCA = 20577UL,
      FI_EN_ISO_ALPHA_3_TUV = 21174UL,
      FI_EN_ISO_ALPHA_3_UGA = 21729UL,
      FI_EN_ISO_ALPHA_3_UKR = 21874UL,
      FI_EN_ISO_ALPHA_3_ARE = 1605UL,
      FI_EN_ISO_ALPHA_3_GBR = 7250UL,
      FI_EN_ISO_ALPHA_3_USA = 22113UL,
      FI_EN_ISO_ALPHA_3_URY = 22105UL,
      FI_EN_ISO_ALPHA_3_UZB = 22338UL,
      FI_EN_ISO_ALPHA_3_VUT = 23220UL,
      FI_EN_ISO_ALPHA_3_VEN = 22702UL,
      FI_EN_ISO_ALPHA_3_VNM = 22989UL,
      FI_EN_ISO_ALPHA_3_VGB = 22754UL,
      FI_EN_ISO_ALPHA_3_VIR = 22834UL,
      FI_EN_ISO_ALPHA_3_WLF = 23942UL,
      FI_EN_ISO_ALPHA_3_ESH = 5736UL,
      FI_EN_ISO_ALPHA_3_YEM = 25773UL,
      FI_EN_ISO_ALPHA_3_YUG = 26279UL,
      FI_EN_ISO_ALPHA_3_ZMB = 27042UL,
      FI_EN_ISO_ALPHA_3_ZWE = 27365UL
   };
   tenType enType;

   metersrv_fi_tcl_e16_ISOCountryCode(metersrv_fi_tcl_e16_ISOCountryCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e16_ISOCountryCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e16_ISOCountryCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e16_ISOLanguageCode : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e16_ISOLanguageCode();
   enum tenType {
      FI_EN_ISO_639_1_UNDEFINED = 0UL,
      FI_EN_ISO_639_1_AA = 24929UL,
      FI_EN_ISO_639_1_AB = 24930UL,
      FI_EN_ISO_639_1_AE = 24933UL,
      FI_EN_ISO_639_1_AF = 24934UL,
      FI_EN_ISO_639_1_AK = 24939UL,
      FI_EN_ISO_639_1_AM = 24941UL,
      FI_EN_ISO_639_1_AN = 24942UL,
      FI_EN_ISO_639_1_AR = 24946UL,
      FI_EN_ISO_639_1_AS = 24947UL,
      FI_EN_ISO_639_1_AV = 24950UL,
      FI_EN_ISO_639_1_AY = 24953UL,
      FI_EN_ISO_639_1_AZ = 24954UL,
      FI_EN_ISO_639_1_BA = 25185UL,
      FI_EN_ISO_639_1_BE = 25189UL,
      FI_EN_ISO_639_1_BG = 25191UL,
      FI_EN_ISO_639_1_BH = 25192UL,
      FI_EN_ISO_639_1_BI = 25193UL,
      FI_EN_ISO_639_1_BL = 25196UL,
      FI_EN_ISO_639_1_BM = 25197UL,
      FI_EN_ISO_639_1_BN = 25198UL,
      FI_EN_ISO_639_1_BO = 25199UL,
      FI_EN_ISO_639_1_BR = 25202UL,
      FI_EN_ISO_639_1_BS = 25203UL,
      FI_EN_ISO_639_1_BT = 25204UL,
      FI_EN_ISO_639_1_CA = 25441UL,
      FI_EN_ISO_639_1_CE = 25445UL,
      FI_EN_ISO_639_1_CF = 25446UL,
      FI_EN_ISO_639_1_CH = 25448UL,
      FI_EN_ISO_639_1_CL = 25452UL,
      FI_EN_ISO_639_1_CN = 25454UL,
      FI_EN_ISO_639_1_CO = 25455UL,
      FI_EN_ISO_639_1_CR = 25458UL,
      FI_EN_ISO_639_1_CS = 25459UL,
      FI_EN_ISO_639_1_CT = 25460UL,
      FI_EN_ISO_639_1_CU = 25461UL,
      FI_EN_ISO_639_1_CV = 25462UL,
      FI_EN_ISO_639_1_CY = 25465UL,
      FI_EN_ISO_639_1_DA = 25697UL,
      FI_EN_ISO_639_1_DE = 25701UL,
      FI_EN_ISO_639_1_DV = 25718UL,
      FI_EN_ISO_639_1_DZ = 25722UL,
      FI_EN_ISO_639_1_EE = 25957UL,
      FI_EN_ISO_639_1_EG = 25959UL,
      FI_EN_ISO_639_1_EL = 25964UL,
      FI_EN_ISO_639_1_EN = 25966UL,
      FI_EN_ISO_639_1_EO = 25967UL,
      FI_EN_ISO_639_1_ES = 25971UL,
      FI_EN_ISO_639_1_ET = 25972UL,
      FI_EN_ISO_639_1_EU = 25973UL,
      FI_EN_ISO_639_1_FA = 26209UL,
      FI_EN_ISO_639_1_FF = 26214UL,
      FI_EN_ISO_639_1_FI = 26217UL,
      FI_EN_ISO_639_1_FJ = 26218UL,
      FI_EN_ISO_639_1_FO = 26223UL,
      FI_EN_ISO_639_1_FR = 26226UL,
      FI_EN_ISO_639_1_FY = 26233UL,
      FI_EN_ISO_639_1_GA = 26465UL,
      FI_EN_ISO_639_1_GD = 26468UL,
      FI_EN_ISO_639_1_GL = 26476UL,
      FI_EN_ISO_639_1_GN = 26478UL,
      FI_EN_ISO_639_1_GU = 26485UL,
      FI_EN_ISO_639_1_GV = 26486UL,
      FI_EN_ISO_639_1_HA = 26721UL,
      FI_EN_ISO_639_1_HE = 26725UL,
      FI_EN_ISO_639_1_HI = 26729UL,
      FI_EN_ISO_639_1_HO = 26735UL,
      FI_EN_ISO_639_1_HR = 26738UL,
      FI_EN_ISO_639_1_HU = 26741UL,
      FI_EN_ISO_639_1_HY = 26745UL,
      FI_EN_ISO_639_1_HZ = 26746UL,
      FI_EN_ISO_639_1_IA = 26977UL,
      FI_EN_ISO_639_1_ID = 26980UL,
      FI_EN_ISO_639_1_IE = 26981UL,
      FI_EN_ISO_639_1_IG = 26983UL,
      FI_EN_ISO_639_1_II = 26985UL,
      FI_EN_ISO_639_1_IK = 26987UL,
      FI_EN_ISO_639_1_IO = 26991UL,
      FI_EN_ISO_639_1_IS = 26995UL,
      FI_EN_ISO_639_1_IT = 26996UL,
      FI_EN_ISO_639_1_IU = 26997UL,
      FI_EN_ISO_639_1_JA = 27233UL,
      FI_EN_ISO_639_1_JV = 27254UL,
      FI_EN_ISO_639_1_KA = 27489UL,
      FI_EN_ISO_639_1_KG = 27495UL,
      FI_EN_ISO_639_1_KI = 27497UL,
      FI_EN_ISO_639_1_KJ = 27498UL,
      FI_EN_ISO_639_1_KK = 27499UL,
      FI_EN_ISO_639_1_KL = 27500UL,
      FI_EN_ISO_639_1_KM = 27501UL,
      FI_EN_ISO_639_1_KN = 27502UL,
      FI_EN_ISO_639_1_KO = 27503UL,
      FI_EN_ISO_639_1_KR = 27506UL,
      FI_EN_ISO_639_1_KS = 27507UL,
      FI_EN_ISO_639_1_KU = 27509UL,
      FI_EN_ISO_639_1_KV = 27510UL,
      FI_EN_ISO_639_1_KW = 27511UL,
      FI_EN_ISO_639_1_KY = 27513UL,
      FI_EN_ISO_639_1_LA = 27745UL,
      FI_EN_ISO_639_1_LB = 27746UL,
      FI_EN_ISO_639_1_LG = 27751UL,
      FI_EN_ISO_639_1_LI = 27753UL,
      FI_EN_ISO_639_1_LN = 27758UL,
      FI_EN_ISO_639_1_LO = 27759UL,
      FI_EN_ISO_639_1_LT = 27764UL,
      FI_EN_ISO_639_1_LU = 27765UL,
      FI_EN_ISO_639_1_LV = 27766UL,
      FI_EN_ISO_639_1_MC = 28003UL,
      FI_EN_ISO_639_1_MG = 28007UL,
      FI_EN_ISO_639_1_MH = 28008UL,
      FI_EN_ISO_639_1_MI = 28009UL,
      FI_EN_ISO_639_1_MK = 28011UL,
      FI_EN_ISO_639_1_ML = 28012UL,
      FI_EN_ISO_639_1_MN = 28014UL,
      FI_EN_ISO_639_1_MO = 28015UL,
      FI_EN_ISO_639_1_MR = 28018UL,
      FI_EN_ISO_639_1_MS = 28019UL,
      FI_EN_ISO_639_1_MT = 28020UL,
      FI_EN_ISO_639_1_MY = 28025UL,
      FI_EN_ISO_639_1_NA = 28257UL,
      FI_EN_ISO_639_1_NB = 28258UL,
      FI_EN_ISO_639_1_ND = 28260UL,
      FI_EN_ISO_639_1_NE = 28261UL,
      FI_EN_ISO_639_1_NG = 28263UL,
      FI_EN_ISO_639_1_NL = 28268UL,
      FI_EN_ISO_639_1_NN = 28270UL,
      FI_EN_ISO_639_1_NO = 28271UL,
      FI_EN_ISO_639_1_NR = 28274UL,
      FI_EN_ISO_639_1_NV = 28278UL,
      FI_EN_ISO_639_1_NY = 28281UL,
      FI_EN_ISO_639_1_OC = 28515UL,
      FI_EN_ISO_639_1_OJ = 28522UL,
      FI_EN_ISO_639_1_OM = 28525UL,
      FI_EN_ISO_639_1_OR = 28530UL,
      FI_EN_ISO_639_1_OS = 28531UL,
      FI_EN_ISO_639_1_PA = 28769UL,
      FI_EN_ISO_639_1_PI = 28777UL,
      FI_EN_ISO_639_1_PL = 28780UL,
      FI_EN_ISO_639_1_PS = 28787UL,
      FI_EN_ISO_639_1_PT = 28788UL,
      FI_EN_ISO_639_1_QU = 29045UL,
      FI_EN_ISO_639_1_RM = 29293UL,
      FI_EN_ISO_639_1_RN = 29294UL,
      FI_EN_ISO_639_1_RO = 29295UL,
      FI_EN_ISO_639_1_RT = 29300UL,
      FI_EN_ISO_639_1_RU = 29301UL,
      FI_EN_ISO_639_1_RW = 29303UL,
      FI_EN_ISO_639_1_SA = 29537UL,
      FI_EN_ISO_639_1_SB = 29538UL,
      FI_EN_ISO_639_1_SC = 29539UL,
      FI_EN_ISO_639_1_SD = 29540UL,
      FI_EN_ISO_639_1_SE = 29541UL,
      FI_EN_ISO_639_1_SG = 29543UL,
      FI_EN_ISO_639_1_SH = 29544UL,
      FI_EN_ISO_639_1_SI = 29545UL,
      FI_EN_ISO_639_1_SK = 29547UL,
      FI_EN_ISO_639_1_SL = 29548UL,
      FI_EN_ISO_639_1_SM = 29549UL,
      FI_EN_ISO_639_1_SN = 29550UL,
      FI_EN_ISO_639_1_SO = 29551UL,
      FI_EN_ISO_639_1_SQ = 29553UL,
      FI_EN_ISO_639_1_SR = 29554UL,
      FI_EN_ISO_639_1_SS = 29555UL,
      FI_EN_ISO_639_1_ST = 29556UL,
      FI_EN_ISO_639_1_SU = 29557UL,
      FI_EN_ISO_639_1_SV = 29558UL,
      FI_EN_ISO_639_1_SW = 29559UL,
      FI_EN_ISO_639_1_SX = 29560UL,
      FI_EN_ISO_639_1_TA = 29793UL,
      FI_EN_ISO_639_1_TE = 29797UL,
      FI_EN_ISO_639_1_TG = 29799UL,
      FI_EN_ISO_639_1_TH = 29800UL,
      FI_EN_ISO_639_1_TI = 29801UL,
      FI_EN_ISO_639_1_TK = 29803UL,
      FI_EN_ISO_639_1_TL = 29804UL,
      FI_EN_ISO_639_1_TN = 29806UL,
      FI_EN_ISO_639_1_TO = 29807UL,
      FI_EN_ISO_639_1_TR = 29810UL,
      FI_EN_ISO_639_1_TS = 29811UL,
      FI_EN_ISO_639_1_TT = 29812UL,
      FI_EN_ISO_639_1_TW = 29815UL,
      FI_EN_ISO_639_1_TY = 29817UL,
      FI_EN_ISO_639_1_UE = 30053UL,
      FI_EN_ISO_639_1_UG = 30055UL,
      FI_EN_ISO_639_1_UK = 30059UL,
      FI_EN_ISO_639_1_UL = 30060UL,
      FI_EN_ISO_639_1_UR = 30066UL,
      FI_EN_ISO_639_1_UZ = 30074UL,
      FI_EN_ISO_639_1_VA = 30305UL,
      FI_EN_ISO_639_1_VE = 30309UL,
      FI_EN_ISO_639_1_VI = 30313UL,
      FI_EN_ISO_639_1_VO = 30319UL,
      FI_EN_ISO_639_1_WA = 30561UL,
      FI_EN_ISO_639_1_WO = 30575UL,
      FI_EN_ISO_639_1_XH = 30824UL,
      FI_EN_ISO_639_1_YI = 31081UL,
      FI_EN_ISO_639_1_YO = 31087UL,
      FI_EN_ISO_639_1_ZA = 31329UL,
      FI_EN_ISO_639_1_ZH = 31336UL,
      FI_EN_ISO_639_1_ZL = 31340UL,
      FI_EN_ISO_639_1_ZU = 31349UL
   };
   tenType enType;

   metersrv_fi_tcl_e16_ISOLanguageCode(metersrv_fi_tcl_e16_ISOLanguageCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e16_ISOLanguageCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e16_ISOLanguageCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_LanguageID : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_LanguageID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_LanguageID& operator=(const metersrv_fi_tcl_LanguageID& coRef);
   metersrv_fi_tcl_LanguageID(const metersrv_fi_tcl_LanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e16_ISOLanguageCode ISO639_LanguageCode;
   metersrv_fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;
   virtual ~metersrv_fi_tcl_LanguageID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_LanguageID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_u8_DirectionAbsolute : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~metersrv_fi_tcl_u8_DirectionAbsolute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_u8_DirectionAbsolute& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_u8_DirectionRelative : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_u8_DirectionRelative(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~metersrv_fi_tcl_u8_DirectionRelative();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_u8_DirectionRelative& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s16_CentiDegree : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s16_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~metersrv_fi_tcl_s16_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s16_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s16_Degree : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s16_Degree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~metersrv_fi_tcl_s16_Degree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s16_Degree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_u16_DirectionAbsolute_CentiDegree : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~metersrv_fi_tcl_u16_DirectionAbsolute_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_u16_DirectionAbsolute_CentiDegree& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_s16_DirectionRelative_CentiDegree : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~metersrv_fi_tcl_s16_DirectionRelative_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_s16_DirectionRelative_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_FuelType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_FuelType();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_PETROL = 1UL,
      FI_EN_DIESEL = 2UL,
      FI_EN_HYDROGEN = 3UL,
      FI_EN_COMPRESSEDNATURALGAS = 4UL,
      FI_EN_LIQUIFIEDPETROLEUMGAS = 5UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_FuelType(metersrv_fi_tcl_e8_FuelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_FuelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_FuelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_DistTimeFuel : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_DistTimeFuel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_DistTimeFuel& operator=(const metersrv_fi_tcl_DistTimeFuel& coRef);
   metersrv_fi_tcl_DistTimeFuel(const metersrv_fi_tcl_DistTimeFuel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_s32_Meter Distance;
   metersrv_fi_tcl_s32_Second Time;
   metersrv_fi_tcl_s32_Microliter Fuel;
   virtual ~metersrv_fi_tcl_DistTimeFuel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_DistTimeFuel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_UnitType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_UnitType();
   enum tenType {
      FI_EN_AUDIO = 0UL,
      FI_EN_NAVI = 1UL,
      FI_EN_SWSC = 2UL,
      FI_EN_NAVI2 = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_UnitType(metersrv_fi_tcl_e8_Meter_UnitType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_UnitType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_UnitType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_ConfigurationStatus : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_ConfigurationStatus();
   enum tenType {
      FI_EN_UNDEFINED = 0UL,
      FI_EN_VALID = 1UL,
      FI_EN_INVALID = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_ConfigurationStatus(metersrv_fi_tcl_e8_Meter_ConfigurationStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_ConfigurationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_ConfigurationStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_VersionInfo : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_VersionInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_VersionInfo& operator=(const metersrv_fi_tcl_Meter_VersionInfo& coRef);
   metersrv_fi_tcl_Meter_VersionInfo(const metersrv_fi_tcl_Meter_VersionInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Upper;
   tU8 u8Mid;
   tU8 u8Lower;
   virtual ~metersrv_fi_tcl_Meter_VersionInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_VersionInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_UnitConnectionStatus : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_UnitConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_UnitConnectionStatus& operator=(const metersrv_fi_tcl_Meter_UnitConnectionStatus& coRef);
   metersrv_fi_tcl_Meter_UnitConnectionStatus(const metersrv_fi_tcl_Meter_UnitConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_UnitType e8UnitType;
   tBool bConnected;
   tU8 u8AbsenceState;
   tU8 u8MuteState;
   tU8 u8CommunicationState;
   virtual ~metersrv_fi_tcl_Meter_UnitConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_UnitConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_UnitConfiguration : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_UnitConfiguration();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_UnitConfiguration& operator=(const metersrv_fi_tcl_Meter_UnitConfiguration& coRef);
   metersrv_fi_tcl_Meter_UnitConfiguration(const metersrv_fi_tcl_Meter_UnitConfiguration& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_UnitType e8UnitType;
   metersrv_fi_tcl_e8_Meter_ConfigurationStatus e8ConfigurationStatus;
   tU8 u8UnitId;
   metersrv_fi_tcl_Meter_VersionInfo rMessageVersion;
   virtual ~metersrv_fi_tcl_Meter_UnitConfiguration();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_UnitConfiguration& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_UnitVersion : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_UnitVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_UnitVersion& operator=(const metersrv_fi_tcl_Meter_UnitVersion& coRef);
   metersrv_fi_tcl_Meter_UnitVersion(const metersrv_fi_tcl_Meter_UnitVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_UnitType e8UnitType;
   metersrv_fi_tcl_Meter_VersionInfo rVersion;
   virtual ~metersrv_fi_tcl_Meter_UnitVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_UnitVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_UnitDataTransmissionStatus : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_UnitDataTransmissionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_UnitDataTransmissionStatus& operator=(const metersrv_fi_tcl_Meter_UnitDataTransmissionStatus& coRef);
   metersrv_fi_tcl_Meter_UnitDataTransmissionStatus(const metersrv_fi_tcl_Meter_UnitDataTransmissionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_UnitType e8UnitType;
   tU8 u8MPDTMuteState;
   virtual ~metersrv_fi_tcl_Meter_UnitDataTransmissionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_UnitDataTransmissionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8VersionInfo : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8VersionInfo();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_HARDWAREVERSION = 1UL,
      FI_EN_SOFTWAREVERSION = 2UL,
      FI_EN_HWSWVERSION = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8VersionInfo(metersrv_fi_tcl_e8VersionInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8VersionInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8VersionInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_SupportedFunction : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_SupportedFunction();
   enum tenType {
      FI_EN_PHONEINFONOTSUPPORTEDINMETER = 0UL,
      FI_EN_PHONEINFOSUPPORTEDINMETER = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_SupportedFunction(metersrv_fi_tcl_e8_Meter_SupportedFunction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_SupportedFunction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_SupportedFunction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Language : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Language();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_US_ENGLISH = 1UL,
      FI_EN_CANADIAN_FRENCH = 2UL,
      FI_EN_MEXICAN_SPANISH = 3UL,
      FI_EN_JAPANESE = 4UL,
      FI_EN_MANDARIN_CHINESE = 5UL,
      FI_EN_TRADITIONAL_CHINESE = 6UL,
      FI_EN_KOREAN = 7UL,
      FI_EN_ARABIC = 8UL,
      FI_EN_THAI = 9UL,
      FI_EN_ENGLISH = 10UL,
      FI_EN_FRENCH = 11UL,
      FI_EN_SPANISH = 12UL,
      FI_EN_GERMAN = 13UL,
      FI_EN_ITALIAN = 14UL,
      FI_EN_PORTUGUESE = 15UL,
      FI_EN_BRAZILIAN_PORTUGUESE = 16UL,
      FI_EN_DUTCH = 17UL,
      FI_EN_TURKISH = 18UL,
      FI_EN_RUSSIAN = 19UL,
      FI_EN_DANISH = 20UL,
      FI_EN_SWEDISH = 21UL,
      FI_EN_FINNISH = 22UL,
      FI_EN_NORWEGIAN = 23UL,
      FI_EN_GREEK = 24UL,
      FI_EN_POLISH = 25UL,
      FI_EN_CZECH = 26UL,
      FI_EN_SLOVAKIAN = 27UL,
      FI_EN_HUNGARIAN = 28UL,
      FI_EN_AUSTRALIAN_ENGLISH = 29UL,
      FI_EN_INDONESIAN = 30UL,
      FI_EN_TRADITIONAL_CANTONESE = 31UL,
      FI_EN_HEBREW = 32UL,
      FI_EN_ROMANIAN = 33UL,
      FI_EN_UNUSED = 254UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Language(metersrv_fi_tcl_e8_Meter_Language::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Language();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Language& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Language_Action : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Language_Action();
   enum tenType {
      FI_EN_INVALID_ACTION = 0UL,
      FI_EN_GETREQUESTEDLANGUAGEAVAILABILITY = 1UL,
      FI_EN_SETREQUESTEDLANGUAGEONMETERONEWAY = 2UL,
      FI_EN_SETREQUESTEDLANGUAGEONMETERTWOWAY = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Language_Action(metersrv_fi_tcl_e8_Meter_Language_Action::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Language_Action();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Language_Action& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Lang_Sync_Mode_Type : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Lang_Sync_Mode_Type();
   enum tenType {
      FI_EN_NOT_AVAILABLE = 0UL,
      FI_EN_ONEWAYSYNC = 1UL,
      FI_EN_TWOWAYSYNC = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Lang_Sync_Mode_Type(metersrv_fi_tcl_e8_Lang_Sync_Mode_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Lang_Sync_Mode_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Lang_Sync_Mode_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Language_Status : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Language_Status();
   enum tenType {
      FI_EN_UNAVAILABLE = 0UL,
      FI_EN_AVAILABLE_UNSET = 1UL,
      FI_EN_AVAILABLE_SET = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Language_Status(metersrv_fi_tcl_e8_Meter_Language_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Language_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Language_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_RequestedLanguageResult : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_RequestedLanguageResult();
   enum tenType {
      FI_EN_INVALID_PARAMETER = 0UL,
      FI_EN_UNCHANGEDNOTAUTO = 1UL,
      FI_EN_UNCHANGEDAUTO = 2UL,
      FI_EN_CHANGED = 3UL,
      FI_EN_AVAILABLE_UNSET = 4UL,
      FI_EN_AVAILABLE_SET = 5UL,
      FI_EN_UNAVAILABLE = 6UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_RequestedLanguageResult(metersrv_fi_tcl_e8_Meter_RequestedLanguageResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_RequestedLanguageResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_RequestedLanguageResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_DistanceUnit : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_DistanceUnit();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_M = 1UL,
      FI_EN_MI = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_DistanceUnit(metersrv_fi_tcl_e8_Meter_DistanceUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_DistanceUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_DistanceUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_KM_PER_L = 1UL,
      FI_EN_L_PER_100KM = 2UL,
      FI_EN_US_MPG = 3UL,
      FI_EN_UK_MPG = 4UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit(metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_TemperatureUnit : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_TemperatureUnit();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_DEG_C = 1UL,
      FI_EN_DEG_F = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_TemperatureUnit(metersrv_fi_tcl_e8_Meter_TemperatureUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_TemperatureUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_TemperatureUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_PressureUnit : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_PressureUnit();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_KPA = 1UL,
      FI_EN_PSI = 2UL,
      FI_EN_BAR = 3UL,
      FI_EN_KGF_CM2 = 4UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_PressureUnit(metersrv_fi_tcl_e8_Meter_PressureUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_PressureUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_PressureUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Switch : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Switch();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL,
      FI_EN_NOTAVAILABLE = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Switch(metersrv_fi_tcl_e8_Meter_Switch::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Switch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Switch& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Eco_Drive : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Eco_Drive();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL,
      FI_EN_NOTAVAILABLE = 255UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Eco_Drive(metersrv_fi_tcl_e8_Meter_Eco_Drive::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Eco_Drive();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Eco_Drive& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Low_Temp : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Low_Temp();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL,
      FI_EN_NOTAVAILABLE = 255UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Low_Temp(metersrv_fi_tcl_e8_Meter_Low_Temp::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Low_Temp();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Low_Temp& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_ProPilot_Meter_Switch : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_ProPilot_Meter_Switch();
   enum tenType {
      FI_EN_NOTAVAILABLE = 0UL,
      FI_EN_OFF = 1UL,
      FI_EN_ON = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_ProPilot_Meter_Switch(metersrv_fi_tcl_e8_ProPilot_Meter_Switch::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_ProPilot_Meter_Switch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_ProPilot_Meter_Switch& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_ProPilot_State_Switch : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_ProPilot_State_Switch();
   enum tenType {
      FI_EN_UNAVAILABLE = 0UL,
      FI_EN_AVAILABLE = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_ProPilot_State_Switch(metersrv_fi_tcl_e8_ProPilot_State_Switch::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_ProPilot_State_Switch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_ProPilot_State_Switch& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_ECO_Accel : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_ECO_Accel();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_SYNCHRONIZEDECO = 1UL,
      FI_EN_NOTAVAILABLE = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_ECO_Accel(metersrv_fi_tcl_e8_Meter_ECO_Accel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_ECO_Accel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_ECO_Accel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode();
   enum tenType {
      FI_EN_NO_ERROR = 0UL,
      FI_EN_OUT_OF_RANGE = 1UL,
      FI_EN_INVALIDPARAMETERLENGTH = 2UL,
      FI_EN_INTERNALERROR = 3UL,
      FI_EN_OTHER = 4UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode(metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_NoData : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_NoData();

   virtual ~metersrv_fi_tcl_Meter_Audio_NoData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_Meter_Audio_NoData& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_RadioSource : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_RadioSource();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_FM = 1UL,
      FI_EN_FM1 = 2UL,
      FI_EN_FM2 = 3UL,
      FI_EN_FM_AP = 4UL,
      FI_EN_AM = 16UL,
      FI_EN_AM_AP = 17UL,
      FI_EN_XM1 = 32UL,
      FI_EN_XM2 = 33UL,
      FI_EN_XM3 = 34UL,
      FI_EN_SXM = 35UL,
      FI_EN_SXM1 = 36UL,
      FI_EN_SXM2 = 37UL,
      FI_EN_SXM3 = 38UL,
      FI_EN_TA_JPN = 48UL,
      FI_EN_TA_RDS = 49UL,
      FI_EN_FM_PTY = 50UL,
      FI_EN_ALARM_RDS = 64UL,
      FI_EN_DAB = 80UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_RadioSource(metersrv_fi_tcl_e8_Meter_Audio_RadioSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_RadioSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_RadioSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate();
   enum tenType {
      FI_EN_NOT_UPDATED = 0UL,
      FI_EN_UPDATED = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate(metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName();
   enum tenType {
      FI_EN_FM_HD = 1UL,
      FI_EN_AM_HD = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName(metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_HDRadioSource : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_HDRadioSource();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_e8_Meter_Audio_HDRadioSource& operator=(const metersrv_fi_tcl_e8_Meter_Audio_HDRadioSource& coRef);
   metersrv_fi_tcl_e8_Meter_Audio_HDRadioSource(const metersrv_fi_tcl_e8_Meter_Audio_HDRadioSource& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate e8Update;
   metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName e8Name;
   virtual ~metersrv_fi_tcl_e8_Meter_Audio_HDRadioSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_HDRadioSource& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_RadioLabelType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_RadioLabelType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_PRESET = 1UL,
      FI_EN_CHANNEL = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_RadioLabelType(metersrv_fi_tcl_e8_Meter_Audio_RadioLabelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_RadioLabelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_RadioLabelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_RadioLabel : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_RadioLabel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_RadioLabel& operator=(const metersrv_fi_tcl_Meter_Audio_RadioLabel& coRef);
   metersrv_fi_tcl_Meter_Audio_RadioLabel(const metersrv_fi_tcl_Meter_Audio_RadioLabel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_RadioLabelType e8Type;
   tU8 u8Id;
   virtual ~metersrv_fi_tcl_Meter_Audio_RadioLabel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_RadioLabel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_FM = 1UL,
      FI_EN_AM = 2UL,
      FI_EN_XM = 3UL,
      FI_EN_KHZ = 4UL,
      FI_EN_MHZ = 5UL,
      FI_EN_CH = 6UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit(metersrv_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_RadioFrequency : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_RadioFrequency();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_RadioFrequency& operator=(const metersrv_fi_tcl_Meter_Audio_RadioFrequency& coRef);
   metersrv_fi_tcl_Meter_Audio_RadioFrequency(const metersrv_fi_tcl_Meter_Audio_RadioFrequency& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Thousands;
   tU8 u8Hundreds;
   tU8 u8Tens;
   tU8 u8Ones;
   tBool bShowDecimalPoint;
   tU8 u8Tenths;
   tU8 u8Hundredths;
   metersrv_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit e8Unit;
   virtual ~metersrv_fi_tcl_Meter_Audio_RadioFrequency();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_RadioFrequency& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_RadioCategoryType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_RadioCategoryType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_CATEGORY = 1UL,
      FI_EN_PTY = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_RadioCategoryType(metersrv_fi_tcl_e8_Meter_Audio_RadioCategoryType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_RadioCategoryType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_RadioCategoryType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_RadioCategory : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_RadioCategory();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_RadioCategory& operator=(const metersrv_fi_tcl_Meter_Audio_RadioCategory& coRef);
   metersrv_fi_tcl_Meter_Audio_RadioCategory(const metersrv_fi_tcl_Meter_Audio_RadioCategory& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_RadioCategoryType e8Type;
   metersrv_fi_tclString strCategoryName;
   virtual ~metersrv_fi_tcl_Meter_Audio_RadioCategory();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_RadioCategory& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_RadioData : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_RadioData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_RadioData& operator=(const metersrv_fi_tcl_Meter_Audio_RadioData& coRef);
   metersrv_fi_tcl_Meter_Audio_RadioData(const metersrv_fi_tcl_Meter_Audio_RadioData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_RadioSource e8RadioSource;
   metersrv_fi_tcl_Meter_Audio_RadioLabel rLabel;
   metersrv_fi_tcl_Meter_Audio_RadioFrequency rFrequency;
   metersrv_fi_tcl_Meter_Audio_RadioCategory rCategory;
   metersrv_fi_tclString strStationName;
   virtual ~metersrv_fi_tcl_Meter_Audio_RadioData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_RadioData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_HDRadioData : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_HDRadioData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_HDRadioData& operator=(const metersrv_fi_tcl_Meter_Audio_HDRadioData& coRef);
   metersrv_fi_tcl_Meter_Audio_HDRadioData(const metersrv_fi_tcl_Meter_Audio_HDRadioData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_HDRadioSource e8RadioSource;
   metersrv_fi_tcl_Meter_Audio_RadioLabel rLabel;
   metersrv_fi_tcl_Meter_Audio_RadioFrequency rFrequency;
   metersrv_fi_tcl_Meter_Audio_RadioCategory rCategory;
   metersrv_fi_tclString strStationName;
   tU8 u8MulticastChannel;
   metersrv_fi_tclString strArtistName;
   metersrv_fi_tclString strSongName;
   virtual ~metersrv_fi_tcl_Meter_Audio_HDRadioData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_HDRadioData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoUpdate();
   enum tenType {
      FI_EN_NOT_UPDATED = 0UL,
      FI_EN_UPDATED = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoUpdate(metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoUpdate::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoUpdate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoUpdate& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoName : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoName();
   enum tenType {
      FI_EN_TV = 1UL,
      FI_EN_TV1 = 2UL,
      FI_EN_TV2 = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoName(metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoName::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoName();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoName& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_DTVSource : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_DTVSource();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_e8_Meter_Audio_DTVSource& operator=(const metersrv_fi_tcl_e8_Meter_Audio_DTVSource& coRef);
   metersrv_fi_tcl_e8_Meter_Audio_DTVSource(const metersrv_fi_tcl_e8_Meter_Audio_DTVSource& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoUpdate e8Update;
   metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoName e8Name;
   virtual ~metersrv_fi_tcl_e8_Meter_Audio_DTVSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_DTVSource& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_DTVFrequency : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_DTVFrequency();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_DTVFrequency& operator=(const metersrv_fi_tcl_Meter_Audio_DTVFrequency& coRef);
   metersrv_fi_tcl_Meter_Audio_DTVFrequency(const metersrv_fi_tcl_Meter_Audio_DTVFrequency& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Thousands;
   tU8 u8Hundreds;
   tU8 u8Tens;
   tU8 u8Ones;
   tBool bShowDecimalPoint;
   tU8 u8Tenths;
   tU8 u8Hundredths;
   virtual ~metersrv_fi_tcl_Meter_Audio_DTVFrequency();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_DTVFrequency& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_DTVLabelType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_DTVLabelType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_CHANNEL = 1UL,
      FI_EN_PRESET = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_DTVLabelType(metersrv_fi_tcl_e8_Meter_Audio_DTVLabelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_DTVLabelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_DTVLabelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_DTVLabel : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_DTVLabel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_DTVLabel& operator=(const metersrv_fi_tcl_Meter_Audio_DTVLabel& coRef);
   metersrv_fi_tcl_Meter_Audio_DTVLabel(const metersrv_fi_tcl_Meter_Audio_DTVLabel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_DTVLabelType e8Type;
   tU8 u8Id;
   virtual ~metersrv_fi_tcl_Meter_Audio_DTVLabel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_DTVLabel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_DTVData : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_DTVData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_DTVData& operator=(const metersrv_fi_tcl_Meter_Audio_DTVData& coRef);
   metersrv_fi_tcl_Meter_Audio_DTVData(const metersrv_fi_tcl_Meter_Audio_DTVData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_DTVSource e8DtvSource;
   metersrv_fi_tcl_Meter_Audio_DTVFrequency rFrequency;
   metersrv_fi_tcl_Meter_Audio_DTVLabel rLabel;
   metersrv_fi_tclString strStationName;
   virtual ~metersrv_fi_tcl_Meter_Audio_DTVData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_DTVData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_MediaType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_MediaType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_CD = 1UL,
      FI_EN_MUSIC_BOX = 2UL,
      FI_EN_IPOD = 3UL,
      FI_EN_USB = 4UL,
      FI_EN_BT_AUDIO = 5UL,
      FI_EN_DVD = 6UL,
      FI_EN_PANDORA = 7UL,
      FI_EN_DISC = 8UL,
      FI_EN_IPOD1 = 9UL,
      FI_EN_IPOD2 = 10UL,
      FI_EN_USB1 = 11UL,
      FI_EN_USB2 = 12UL,
      FI_EN_BLU_RAY = 13UL,
      FI_EN_SD = 14UL,
      FI_EN_CAR_PLAY = 15UL,
      FI_EN_ANDROID_AUTO = 16UL,
      FI_EN_MYSPIN = 17UL,
      FI_EN_CAR_LIFE = 18UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_MediaType(metersrv_fi_tcl_e8_Meter_Audio_MediaType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_MediaType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_MediaType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_TrackLabelType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_TrackLabelType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_TRACK = 1UL,
      FI_EN_CHAPTER = 2UL,
      FI_EN_FILE = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_TrackLabelType(metersrv_fi_tcl_e8_Meter_Audio_TrackLabelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_TrackLabelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_TrackLabelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_TrackInfo : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_TrackInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_TrackInfo& operator=(const metersrv_fi_tcl_Meter_Audio_TrackInfo& coRef);
   metersrv_fi_tcl_Meter_Audio_TrackInfo(const metersrv_fi_tcl_Meter_Audio_TrackInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_TrackLabelType e8LabelType;
   tU32 u32TrackNumber;
   metersrv_fi_tclString strTrackName;
   virtual ~metersrv_fi_tcl_Meter_Audio_TrackInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_TrackInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_GroupLabelType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_GroupLabelType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_DISC = 1UL,
      FI_EN_ALBUM = 2UL,
      FI_EN_GROUP = 3UL,
      FI_EN_FOLDER = 4UL,
      FI_EN_TITLE = 5UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_GroupLabelType(metersrv_fi_tcl_e8_Meter_Audio_GroupLabelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_GroupLabelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_GroupLabelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_GroupInfo : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_GroupInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_GroupInfo& operator=(const metersrv_fi_tcl_Meter_Audio_GroupInfo& coRef);
   metersrv_fi_tcl_Meter_Audio_GroupInfo(const metersrv_fi_tcl_Meter_Audio_GroupInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_GroupLabelType e8LabelType;
   tU16 u16GroupNumber;
   metersrv_fi_tclString strGroupName;
   virtual ~metersrv_fi_tcl_Meter_Audio_GroupInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_GroupInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_ArtistLabelType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_ArtistLabelType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_ARTIST = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_ArtistLabelType(metersrv_fi_tcl_e8_Meter_Audio_ArtistLabelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_ArtistLabelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_ArtistLabelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_ArtistInfo : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_ArtistInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_ArtistInfo& operator=(const metersrv_fi_tcl_Meter_Audio_ArtistInfo& coRef);
   metersrv_fi_tcl_Meter_Audio_ArtistInfo(const metersrv_fi_tcl_Meter_Audio_ArtistInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_ArtistLabelType e8LabelType;
   metersrv_fi_tclString strArtistName;
   virtual ~metersrv_fi_tcl_Meter_Audio_ArtistInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_ArtistInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_MediaData : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_MediaData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_MediaData& operator=(const metersrv_fi_tcl_Meter_Audio_MediaData& coRef);
   metersrv_fi_tcl_Meter_Audio_MediaData(const metersrv_fi_tcl_Meter_Audio_MediaData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_MediaType e8MediaType;
   metersrv_fi_tcl_Meter_Audio_TrackInfo rTrackInfo;
   metersrv_fi_tcl_Meter_Audio_GroupInfo rGroupInfo;
   metersrv_fi_tcl_Meter_Audio_ArtistInfo rArtistInfo;
   virtual ~metersrv_fi_tcl_Meter_Audio_MediaData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_MediaData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_AuxType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_AuxType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_VTR_JACK = 1UL,
      FI_EN_PIN_AUX = 2UL,
      FI_EN_PIN_RSE = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_AuxType(metersrv_fi_tcl_e8_Meter_Audio_AuxType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_AuxType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_AuxType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_AuxData : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_AuxData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_AuxData& operator=(const metersrv_fi_tcl_Meter_Audio_AuxData& coRef);
   metersrv_fi_tcl_Meter_Audio_AuxData(const metersrv_fi_tcl_Meter_Audio_AuxData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_AuxType e8AuxType;
   virtual ~metersrv_fi_tcl_Meter_Audio_AuxData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_AuxData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_ExternalSoundData : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_ExternalSoundData();

   virtual ~metersrv_fi_tcl_Meter_Audio_ExternalSoundData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_Meter_Audio_ExternalSoundData& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_InternetRadioData : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_InternetRadioData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_InternetRadioData& operator=(const metersrv_fi_tcl_Meter_Audio_InternetRadioData& coRef);
   metersrv_fi_tcl_Meter_Audio_InternetRadioData(const metersrv_fi_tcl_Meter_Audio_InternetRadioData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString strSourceName;
   metersrv_fi_tcl_Meter_Audio_TrackInfo rTrackInfo;
   metersrv_fi_tcl_Meter_Audio_GroupInfo rGroupInfo;
   metersrv_fi_tcl_Meter_Audio_ArtistInfo rArtistInfo;
   virtual ~metersrv_fi_tcl_Meter_Audio_InternetRadioData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_InternetRadioData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_SourceInfoType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_SourceInfoType();
   enum tenType {
      FI_EN_T_METER_AUDIO_NODATA = 0UL,
      FI_EN_T_METER_AUDIO_RADIODATA = 1UL,
      FI_EN_T_METER_AUDIO_MEDIADATA = 2UL,
      FI_EN_T_METER_AUDIO_AUXDATA = 3UL,
      FI_EN_T_METER_AUDIO_EXTERNALSOUNDDATA = 4UL,
      FI_EN_T_METER_AUDIO_INTERNETRADIODATA = 5UL,
      FI_EN_T_METER_AUDIO_HDRADIODATA = 6UL,
      FI_EN_T_METER_AUDIO_DTVDATA = 7UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_SourceInfoType(metersrv_fi_tcl_e8_Meter_Audio_SourceInfoType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_SourceInfoType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_SourceInfoType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_Audio_SourceInfoUnion : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_Audio_SourceInfoUnion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_Audio_SourceInfoUnion& operator=(const metersrv_fi_tcl_Meter_Audio_SourceInfoUnion& coRef);
   metersrv_fi_tcl_Meter_Audio_SourceInfoUnion(const metersrv_fi_tcl_Meter_Audio_SourceInfoUnion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_SourceInfoType SourceInfoType;
   fi_tclTypeBase* poSourceInfoData;
   virtual ~metersrv_fi_tcl_Meter_Audio_SourceInfoUnion();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_Audio_SourceInfoUnion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_WarningSource : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_WarningSource();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_FM = 1UL,
      FI_EN_FM1 = 2UL,
      FI_EN_FM2 = 3UL,
      FI_EN_FM_AP = 4UL,
      FI_EN_AM = 5UL,
      FI_EN_AM_AP = 6UL,
      FI_EN_XM1 = 7UL,
      FI_EN_XM2 = 8UL,
      FI_EN_XM3 = 9UL,
      FI_EN_TA_JPN = 10UL,
      FI_EN_TA_RDS = 11UL,
      FI_EN_ALARM_RDS = 12UL,
      FI_EN_FM_PTY = 13UL,
      FI_EN_CD = 16UL,
      FI_EN_MUSIC_BOX = 17UL,
      FI_EN_IPOD = 18UL,
      FI_EN_USB = 19UL,
      FI_EN_BT_AUDIO = 20UL,
      FI_EN_DVD = 21UL,
      FI_EN_PANDORA = 22UL,
      FI_EN_DISC = 23UL,
      FI_EN_TV = 32UL,
      FI_EN_TV1 = 33UL,
      FI_EN_TV2 = 34UL,
      FI_EN_VTR_JACK = 48UL,
      FI_EN_PIN_AUX = 49UL,
      FI_EN_DAB = 64UL,
      FI_EN_SXM = 65UL,
      FI_EN_SXM1 = 66UL,
      FI_EN_SXM2 = 67UL,
      FI_EN_SXM3 = 68UL,
      FI_EN_FM_HD = 69UL,
      FI_EN_AM_HD = 70UL,
      FI_EN_RSE = 80UL,
      FI_EN_BLU_RAY = 81UL,
      FI_EN_DRM = 82UL,
      FI_EN_SD = 83UL,
      FI_EN_CAR_PLAY = 84UL,
      FI_EN_ANDROID_AUTO = 85UL,
      FI_EN_MYSPIN = 86UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_WarningSource(metersrv_fi_tcl_e8_Meter_Audio_WarningSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_WarningSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_WarningSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_WarningState : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_WarningState();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_AUDIO_OFF = 1UL,
      FI_EN_EXTERNAL_SOUND = 2UL,
      FI_EN_AUTO_PRESETTING = 16UL,
      FI_EN_LIST_UPDATING = 17UL,
      FI_EN_CHECK_ANTENNA = 18UL,
      FI_EN_NO_SIGNAL = 19UL,
      FI_EN_CH_UNAUTHORIZED = 20UL,
      FI_EN_OFF_AIR = 21UL,
      FI_EN_LOADING = 22UL,
      FI_EN_NO_DISC = 32UL,
      FI_EN_LOADING_DISC = 33UL,
      FI_EN_EJECTING_DISC = 34UL,
      FI_EN_READING_DISC = 35UL,
      FI_EN_READING_USB_MEMORY = 36UL,
      FI_EN_READING_IPOD = 37UL,
      FI_EN_UNPLAYABLE_FILE = 38UL,
      FI_EN_DISC_READ_ERROR = 39UL,
      FI_EN_REGION_INVALID = 40UL,
      FI_EN_NO_AUDIO_FILE = 41UL,
      FI_EN_NO_SONG = 42UL,
      FI_EN_IPOD_NOT_CONNECTED = 43UL,
      FI_EN_NO_USB = 44UL,
      FI_EN_CHECK_DEVICE = 45UL,
      FI_EN_OTHER_ERROR = 46UL,
      FI_EN_PLEASE_WAIT = 47UL,
      FI_EN_PLEASE_EJECT_DISC = 48UL,
      FI_EN_CH_UNAVAILABLE = 49UL,
      FI_EN_NO_SERVICE = 50UL,
      FI_EN_NO_STATION = 51UL,
      FI_EN_NO_MORE_SKIPS = 52UL,
      FI_EN_CHECK_DEVICE_FOR_PANDORA = 53UL,
      FI_EN_SERVICE_UNAVAILABLE = 54UL,
      FI_EN_LOADING_AUDIO_FILE_LIST = 55UL,
      FI_EN_NO_MUSIC_FOUND = 56UL,
      FI_EN_CHECK_CONNECTED_DEVICE = 57UL,
      FI_EN_NO_DEVICES_CONNECTED = 58UL,
      FI_EN_EXTERNAL_TEXT = 255UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_WarningState(metersrv_fi_tcl_e8_Meter_Audio_WarningState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_WarningState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_WarningState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_SpecialMode : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_SpecialMode();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_SCAN = 1UL,
      FI_EN_SEARCH = 2UL,
      FI_EN_FASTFORWARD = 3UL,
      FI_EN_REWIND = 4UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_SpecialMode(metersrv_fi_tcl_e8_Meter_Audio_SpecialMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_SpecialMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_SpecialMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Audio_SourceType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Audio_SourceType();
   enum tenType {
      FI_EN_NOEXTSOURCE = 0UL,
      FI_EN_PHONEINCOMING = 1UL,
      FI_EN_PHONEOUTGOING = 2UL,
      FI_EN_PHONE = 3UL,
      FI_EN_SMS = 4UL,
      FI_EN_VOICE = 5UL,
      FI_EN_SPI = 6UL,
      FI_EN_VOICESPI = 7UL,
      FI_EN_UNKNOWN = 8UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Audio_SourceType(metersrv_fi_tcl_e8_Meter_Audio_SourceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Audio_SourceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Audio_SourceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Current_Radio_Mode : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Current_Radio_Mode();
   enum tenType {
      FI_EN_LIST = 0UL,
      FI_EN_FREQUENCY = 1UL,
      FI_EN_PRESET = 2UL,
      FI_EN_UNUSED = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Current_Radio_Mode(metersrv_fi_tcl_e8_Meter_Current_Radio_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Current_Radio_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Current_Radio_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_meter_Renault_Update_List_Value : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_meter_Renault_Update_List_Value();
   enum tenType {
      FI_EN_UPDATING_NOTACTIVE = 0UL,
      FI_EN_UPDATING_ACTIVE = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_meter_Renault_Update_List_Value(metersrv_fi_tcl_e8_meter_Renault_Update_List_Value::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_meter_Renault_Update_List_Value();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_meter_Renault_Update_List_Value& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_NavStatus : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_NavStatus();
   enum tenType {
      FI_EN_NAVSTATUS_UNKNOWN = 0UL,
      FI_EN_NAVSTATUS_BUSY = 1UL,
      FI_EN_NAVSTATUS_NAVDATA_UPDATING = 2UL,
      FI_EN_NAVSTATUS_MAP_RECOVERY_MODE = 3UL,
      FI_EN_NAVSTATUS_IDLE = 4UL,
      FI_EN_NAVSTATUS_GUIDANCE_ACTIVE = 5UL,
      FI_EN_NAVSTATUS_CALCULATING_ROUTE = 6UL,
      FI_EN_NAVSTATUS_GUIDANCE_ACTIVE_OFFBOARD = 7UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_NavStatus(metersrv_fi_tcl_e8_NavStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_NavStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_NavStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_RoadClass : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_RoadClass();
   enum tenType {
      FI_EN_ROAD_CLASS_NONE = 0UL,
      FI_EN_ROAD_CLASS_MOTORWAY = 1UL,
      FI_EN_ROAD_CLASS_FREEWAY = 2UL,
      FI_EN_ROAD_CLASS_HIGHWAY = 3UL,
      FI_EN_ROAD_CLASS_ARTERIAL = 4UL,
      FI_EN_ROAD_CLASS_COLLECTOR = 5UL,
      FI_EN_ROAD_CLASS_LOCAL = 6UL,
      FI_EN_ROAD_CLASS_ADRESSABLESTREET = 7UL,
      FI_EN_ROAD_CLASS_TRAIL = 8UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_RoadClass(metersrv_fi_tcl_e8_RoadClass::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_RoadClass();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_RoadClass& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_DistanceUnit : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_DistanceUnit();
   enum tenType {
      FI_EN_UNIT_NONDISPLAY = 99UL,
      FI_EN_UNIT_METER = 0UL,
      FI_EN_UNIT_KILOMETERS = 1UL,
      FI_EN_UNIT_FEET = 2UL,
      FI_EN_UNIT_YARD = 3UL,
      FI_EN_UNIT_MILES = 4UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_DistanceUnit(metersrv_fi_tcl_e8_DistanceUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_DistanceUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_DistanceUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_ManeuverSymbol : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_ManeuverSymbol();
   enum tenType {
      FI_EN_MANEUVER_SYMBOL_NO_SYMBOL = 0UL,
      FI_EN_MANEUVER_SYMBOL_NO_INFO = 1UL,
      FI_EN_MANEUVER_SYMBOL_FOLLOW = 2UL,
      FI_EN_MANEUVER_SYMBOL_RECALC = 3UL,
      FI_EN_MANEUVER_SYMBOL_DEST_REACHED = 4UL,
      FI_EN_MANEUVER_SYMBOL_DEST_REACHED_LEFT = 5UL,
      FI_EN_MANEUVER_SYMBOL_DEST_REACHED_RIGHT = 6UL,
      FI_EN_MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED = 7UL,
      FI_EN_MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_LEFT = 8UL,
      FI_EN_MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_RIGHT = 9UL,
      FI_EN_MANEUVER_SYMBOL_EXIT_LEFT = 10UL,
      FI_EN_MANEUVER_SYMBOL_EXIT_RIGHT = 11UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_STRAIGHT = 12UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFRIGHT = 13UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_RIGHT = 14UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPRIGHT = 15UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_REVERSE = 16UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPLEFT = 17UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_LEFT = 18UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFLEFT = 19UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_STRAIGHT = 20UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFRIGHT = 21UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_RIGHT = 22UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPRIGHT = 23UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_REVERSE = 24UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPLEFT = 25UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_LEFT = 26UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFLEFT = 27UL,
      FI_EN_MANEUVER_SYMBOL_STRAIGHT = 28UL,
      FI_EN_MANEUVER_SYMBOL_TURN_HALFRIGHT = 29UL,
      FI_EN_MANEUVER_SYMBOL_TURN_RIGHT = 30UL,
      FI_EN_MANEUVER_SYMBOL_TURN_SHARPRIGHT = 31UL,
      FI_EN_MANEUVER_SYMBOL_TURN_SHARPLEFT = 32UL,
      FI_EN_MANEUVER_SYMBOL_TURN_LEFT = 33UL,
      FI_EN_MANEUVER_SYMBOL_TURN_HALFLEFT = 34UL,
      FI_EN_MANEUVER_SYMBOL_UTURN_LEFT = 35UL,
      FI_EN_MANEUVER_SYMBOL_UTURN_RIGHT = 36UL,
      FI_EN_MANEUVER_SYMBOL_KEEP_LEFT = 37UL,
      FI_EN_MANEUVER_SYMBOL_KEEP_RIGHT = 38UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_001 = 39UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_009 = 40UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_025 = 41UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_041 = 42UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_057 = 43UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_073 = 44UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_089 = 45UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_105 = 46UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_121 = 47UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_137 = 48UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_153 = 49UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_169 = 50UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_185 = 51UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_201 = 52UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_217 = 53UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_233 = 54UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_ManeuverSymbol(metersrv_fi_tcl_e8_ManeuverSymbol::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_ManeuverSymbol();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_ManeuverSymbol& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_SpeedUnit : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_SpeedUnit();
   enum tenType {
      FI_EN_SPEEDUNIT_KM_PER_HOUR = 0UL,
      FI_EN_SPEEDUNIT_MI_PER_HOUR = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_SpeedUnit(metersrv_fi_tcl_e8_SpeedUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_SpeedUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_SpeedUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_ManeuverRecommendationType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_ManeuverRecommendationType();
   enum tenType {
      FI_EN_PREVIEW = 0UL,
      FI_EN_PRELIMINARY = 1UL,
      FI_EN_REGULAR = 2UL,
      FI_EN_REPEATED = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_ManeuverRecommendationType(metersrv_fi_tcl_e8_ManeuverRecommendationType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_ManeuverRecommendationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_ManeuverRecommendationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_EstimatedTimeType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_EstimatedTimeType();
   enum tenType {
      FI_EN_DESTINATION = 0UL,
      FI_EN_WAYPOINT = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_EstimatedTimeType(metersrv_fi_tcl_e8_EstimatedTimeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_EstimatedTimeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_EstimatedTimeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_TimeType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_TimeType();
   enum tenType {
      FI_EN_REMAININGTIME = 0UL,
      FI_EN_ETA = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_TimeType(metersrv_fi_tcl_e8_TimeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_TimeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_TimeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_TimeFormat : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_TimeFormat();
   enum tenType {
      FI_EN_UNSET = 0UL,
      FI_EN_TWELVEHOURS = 1UL,
      FI_EN_TWENTYFOURHOURS = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_TimeFormat(metersrv_fi_tcl_e8_TimeFormat::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_TimeFormat();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_TimeFormat& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_ManeuverView : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_ManeuverView();
   enum tenType {
      FI_EN_MANEUVER_VIEW_NONE = 0UL,
      FI_EN_MANEUVER_VIEW_DEFORMED_IMAGE = 1UL,
      FI_EN_MANEUVER_VIEW_INTERSECTION_MAP = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_ManeuverView(metersrv_fi_tcl_e8_ManeuverView::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_ManeuverView();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_ManeuverView& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_DeformedImageRoad : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_DeformedImageRoad();
   enum tenType {
      FI_EN_DEFORMED_IMAGE_ROAD_TYPE_NONE = 0UL,
      FI_EN_DEFORMED_IMAGE_ROAD_TYPE_FORK = 1UL,
      FI_EN_DEFORMED_IMAGE_ROAD_TYPE_EXIT_LEFT = 2UL,
      FI_EN_DEFORMED_IMAGE_ROAD_TYPE_EXIT_RIGHT = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_DeformedImageRoad(metersrv_fi_tcl_e8_DeformedImageRoad::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_DeformedImageRoad();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_DeformedImageRoad& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_DeformedImageArrow : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_DeformedImageArrow();
   enum tenType {
      FI_EN_DEFORMED_IMAGE_ARROW_TYPE_NONE = 0UL,
      FI_EN_DEFORMED_IMAGE_ARROW_TYPE_STRAIGHT = 1UL,
      FI_EN_DEFORMED_IMAGE_ARROW_TYPE_LEFT = 2UL,
      FI_EN_DEFORMED_IMAGE_ARROW_TYPE_RIGHT = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_DeformedImageArrow(metersrv_fi_tcl_e8_DeformedImageArrow::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_DeformedImageArrow();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_DeformedImageArrow& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_LaneStatus : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_LaneStatus();
   enum tenType {
      FI_EN_LANE_STATUS_UNKNOWN = 0UL,
      FI_EN_LANE_STATUS_FORBIDDEN = 1UL,
      FI_EN_LANE_STATUS_NOT_RECOMMENDED = 2UL,
      FI_EN_LANE_STATUS_RECOMMENDED = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_LaneStatus(metersrv_fi_tcl_e8_LaneStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_LaneStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_LaneStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_LaneRecommendation : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_LaneRecommendation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_LaneRecommendation& operator=(const metersrv_fi_tcl_LaneRecommendation& coRef);
   metersrv_fi_tcl_LaneRecommendation(const metersrv_fi_tcl_LaneRecommendation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_LaneStatus e8LaneRecommendationListLaneStatus;
   tS32 s32LaneRecommendationListCombinedFollowingLaneDirection;
   tS32 s32LaneRecommendationListGuidedFollowingLaneDirection;
   virtual ~metersrv_fi_tcl_LaneRecommendation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_LaneRecommendation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_ArrivalInformation : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_ArrivalInformation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_ArrivalInformation& operator=(const metersrv_fi_tcl_ArrivalInformation& coRef);
   metersrv_fi_tcl_ArrivalInformation(const metersrv_fi_tcl_ArrivalInformation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString;
   tU32 u32ArrivalInformationListDistanceToDestinationDistanceToDestination;
   metersrv_fi_tcl_e8_DistanceUnit e8ArrivalInformationListDistanceToDestinationUnit;
   metersrv_fi_tclString strArrivalInformationListDistanceToDestinationTimeToDestinationAsString;
   tS32 s32ArrivalInformationListTimeToDestination;
   metersrv_fi_tclString strArrivalInformationListEstimatedTimeOfArrivalAsString;
   tS32 s32ArrivalInformationListEstimatedTimeOfArrivalHour;
   tS32 s32ArrivalInformationListEstimatedTimeOfArrivalMinute;
   metersrv_fi_tcl_e8_EstimatedTimeType e8ArrivalInformationListEstimatedTimeType;
   metersrv_fi_tcl_e8_TimeType e8ArrivalInformationListDisplayTimeType;
   metersrv_fi_tcl_e8_TimeFormat e8ArrivalInformationListDisplayTimeFormat;
   tS32 s32ArrivalInformationListDestinationIndex;
   virtual ~metersrv_fi_tcl_ArrivalInformation();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_ArrivalInformation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_ScreenCoordinate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_ScreenCoordinate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_ScreenCoordinate& operator=(const metersrv_fi_tcl_ScreenCoordinate& coRef);
   metersrv_fi_tcl_ScreenCoordinate(const metersrv_fi_tcl_ScreenCoordinate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ScreenCoordinateXPos;
   tU32 u32ScreenCoordinateYPos;
   virtual ~metersrv_fi_tcl_ScreenCoordinate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_ScreenCoordinate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_AdminRoadClass : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_AdminRoadClass();
   enum tenType {
      FI_EN_ADMIN_ROAD_CLASS_UNKNOWN = 0UL,
      FI_EN_ADMIN_ROAD_CLASS_MOST_IMPORTANT = 1UL,
      FI_EN_ADMIN_ROAD_CLASS_SECOND_IMPORTANT = 2UL,
      FI_EN_ADMIN_ROAD_CLASS_THIRD_IMPORTANT = 3UL,
      FI_EN_ADMIN_ROAD_CLASS_FOURTH_IMPORTANT = 4UL,
      FI_EN_ADMIN_ROAD_CLASS_FIFTH_IMPORTANT = 5UL,
      FI_EN_ADMIN_ROAD_CLASS_SIXTH_IMPORTANT = 6UL,
      FI_EN_ADMIN_ROAD_CLASS_LEAST_IMPORTANT = 7UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_AdminRoadClass(metersrv_fi_tcl_e8_AdminRoadClass::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_AdminRoadClass();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_AdminRoadClass& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_IntersectionMapRoadLine : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_IntersectionMapRoadLine();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_IntersectionMapRoadLine& operator=(const metersrv_fi_tcl_IntersectionMapRoadLine& coRef);
   metersrv_fi_tcl_IntersectionMapRoadLine(const metersrv_fi_tcl_IntersectionMapRoadLine& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<metersrv_fi_tcl_ScreenCoordinate, std::allocator<metersrv_fi_tcl_ScreenCoordinate> > tIntersectionMapRoadLineCoordinates;
   metersrv_fi_tcl_e8_AdminRoadClass e8IntersectionMapRoadLineRoadClass;
   virtual ~metersrv_fi_tcl_IntersectionMapRoadLine();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_IntersectionMapRoadLine& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_IntersectionMapCarsorState : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_IntersectionMapCarsorState();
   enum tenType {
      FI_EN_INTERSECTION_MAP_CARSOR_STATE_OFF = 0UL,
      FI_EN_INTERSECTION_MAP_CARSOR_STATE_ON = 1UL,
      FI_EN_INTERSECTION_MAP_CARSOR_STATE_STANDBY = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_IntersectionMapCarsorState(metersrv_fi_tcl_e8_IntersectionMapCarsorState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_IntersectionMapCarsorState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_IntersectionMapCarsorState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_SpiNavigation_NavigationAppState : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_SpiNavigation_NavigationAppState();
   enum tenType {
      FI_EN_SPI_APP_STATE_NAV_UNKNOWN = 0UL,
      FI_EN_SPI_APP_STATE_NAV_ACTIVE = 1UL,
      FI_EN_SPI_APP_STATE_NAV_NOTACTIVE = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_SpiNavigation_NavigationAppState(metersrv_fi_tcl_e8_SpiNavigation_NavigationAppState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_SpiNavigation_NavigationAppState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_SpiNavigation_NavigationAppState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_SpiNavigation_TurnSide : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_SpiNavigation_TurnSide();
   enum tenType {
      FI_EN_TURN_SIDE_LEFT = 1UL,
      FI_EN_TURN_SIDE_RIGHT = 2UL,
      FI_EN_TURN_SIDE_UNSPECIFIED = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_SpiNavigation_TurnSide(metersrv_fi_tcl_e8_SpiNavigation_TurnSide::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_SpiNavigation_TurnSide();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_SpiNavigation_TurnSide& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_SpiNavigation_NextTurnEvent : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_SpiNavigation_NextTurnEvent();
   enum tenType {
      FI_EN_NEXT_TURN_UNKNOWN = 0UL,
      FI_EN_NEXT_TURN_DEPART = 1UL,
      FI_EN_NEXT_TURN_NAME_CHANGE = 2UL,
      FI_EN_NEXT_TURN_SLIGHT_TURN = 3UL,
      FI_EN_NEXT_TURN_TURN = 4UL,
      FI_EN_NEXT_TURN_SHARP_TURN = 5UL,
      FI_EN_NEXT_TURN_U_TURN = 6UL,
      FI_EN_NEXT_TURN_ON_RAMP = 7UL,
      FI_EN_NEXT_TURN_OFF_RAMP = 8UL,
      FI_EN_NEXT_TURN_FORK = 9UL,
      FI_EN_NEXT_TURN_MERGE = 10UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_ENTER = 11UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_EXIT = 12UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_ENTER_AND_EXIT = 13UL,
      FI_EN_NEXT_TURN_STRAIGHT = 14UL,
      FI_EN_NEXT_TURN_FERRY_BOAT = 16UL,
      FI_EN_NEXT_TURN_FERRY_TRAIN = 17UL,
      FI_EN_NEXT_TURN_DESTINATION = 19UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_SpiNavigation_NextTurnEvent(metersrv_fi_tcl_e8_SpiNavigation_NextTurnEvent::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_SpiNavigation_NextTurnEvent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_SpiNavigation_NextTurnEvent& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_SpiNavigation_ManeuverDistanceUnits : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_SpiNavigation_ManeuverDistanceUnits();
   enum tenType {
      FI_EN_MANEUVER_DISTANCE_UNITS_UNKNOWN = 0UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_METERS = 1UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_KILOMETERS = 2UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_KILOMETERS_P1 = 3UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_MILES = 4UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_MILES_P1 = 5UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_FEET = 6UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_YARDS = 7UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_SpiNavigation_ManeuverDistanceUnits(metersrv_fi_tcl_e8_SpiNavigation_ManeuverDistanceUnits::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_SpiNavigation_ManeuverDistanceUnits();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_SpiNavigation_ManeuverDistanceUnits& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_DistanceUnits : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_DistanceUnits();
   enum tenType {
      FI_EN_MANEUVER_DISTANCE_UNITS_UNKNOWN = 0UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_METERS = 1UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_KILOMETERS = 2UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_KILOMETERS_P1 = 3UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_MILES = 4UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_MILES_P1 = 5UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_FEET = 6UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_YARDS  = 7UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_DistanceUnits(metersrv_fi_tcl_e8_DistanceUnits::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_DistanceUnits();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_DistanceUnits& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementAlertState : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementAlertState();
   enum tenType {
      FI_EN_NO_ALERT = 0UL,
      FI_EN_PRE_ALERT = 1UL,
      FI_EN_ALERT = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementAlertState(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementAlertState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementAlertState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementAlertState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementCameraType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementCameraType();
   enum tenType {
      FI_EN_FIXED_SPEED = 0UL,
      FI_EN_MOBILE_SPEED = 1UL,
      FI_EN_REDLIGHT = 2UL,
      FI_EN_TOLL_ROAD = 3UL,
      FI_EN_PECCANCY = 4UL,
      FI_EN_SPECIAL_LANE = 5UL,
      FI_EN_FIXED_SPEED_AND_REDLIGHT = 6UL,
      FI_EN_BUSLANE = 7UL,
      FI_EN_FAKE = 8UL,
      FI_EN_PARKING_VIOLATION = 9UL,
      FI_EN_OTHER = 10UL,
      FI_EN_AVERAGE_SPEED_ZONE = 11UL,
      FI_EN_SPEED_ENFORCEMENT_ZONE = 12UL,
      FI_EN_DANGER_ZONE = 13UL,
      FI_EN_MOBILE_SPEED_HOTSPOT_ZONE = 14UL,
      FI_EN_ACCIDENT_BLACKSPOT_ZONE = 15UL,
      FI_EN_RISK_ZONE = 16UL,
      FI_EN_RESTRICTED_ACCESS = 17UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementCameraType(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementCameraType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementCameraType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementCameraType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementDistanceType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementDistanceType();
   enum tenType {
      FI_EN_TO_ZONE_BEGIN = 0UL,
      FI_EN_TO_ZONE_END = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementDistanceType(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementDistanceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementDistanceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementDistanceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_DeviceCategory : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_DeviceCategory();
   enum tenType {
      FI_EN_DEV_TYPE_UNKNOWN = 0UL,
      FI_EN_DEV_TYPE_DIPO = 1UL,
      FI_EN_DEV_TYPE_MIRRORLINK = 2UL,
      FI_EN_DEV_TYPE_ANDROIDAUTO = 3UL,
      FI_EN_DEV_TYPE_MYSPIN = 4UL,
      FI_EN_DEV_TYPE_CARLIFE = 5UL,
      FI_EN_DEV_TYPE_DEFAULT = 15UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_DeviceCategory(metersrv_fi_tcl_e8_DeviceCategory::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_DeviceCategory();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_DeviceCategory& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_DiPoRouteGuidanceState : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_DiPoRouteGuidanceState();
   enum tenType {
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET = 0UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_ROUTE_SET = 1UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_ARRIVED = 2UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_LOADING = 3UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_LOCATING = 4UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_REROUTING = 5UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_PROCEEDTOROUTE = 6UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_DiPoRouteGuidanceState(metersrv_fi_tcl_e8_DiPoRouteGuidanceState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_DiPoRouteGuidanceState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_DiPoRouteGuidanceState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_AAutoTurnSide : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_AAutoTurnSide();
   enum tenType {
      FI_EN_TURN_SIDE_LEFT = 1UL,
      FI_EN_TURN_SIDE_RIGHT = 2UL,
      FI_EN_TURN_SIDE_UNSPECIFIED = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_AAutoTurnSide(metersrv_fi_tcl_e8_AAutoTurnSide::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_AAutoTurnSide();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_AAutoTurnSide& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_BDCLNavigationAppState : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_BDCLNavigationAppState();
   enum tenType {
      FI_EN_BDCL_NAV_STATE_ACTION_INVALID = 0UL,
      FI_EN_BDCL_NAV_STATE_ACTION_SHOW = 1UL,
      FI_EN_BDCL_NAV_STATE_ACTION_UPDATE = 2UL,
      FI_EN_BDCL_NAV_STATE_ACTION_HIDE = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_BDCLNavigationAppState(metersrv_fi_tcl_e8_BDCLNavigationAppState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_BDCLNavigationAppState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_BDCLNavigationAppState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_MLGuidanceState : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_MLGuidanceState();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NO_DESTINATION_SET = 1UL,
      FI_EN_CALCULATING_ROUTE = 2UL,
      FI_EN_NEW_ROUTE = 3UL,
      FI_EN_NO_ROUTE = 4UL,
      FI_EN_NORMAL_OPERATION = 5UL,
      FI_EN_OFF_ROAD = 6UL,
      FI_EN_OFF_MAP = 7UL,
      FI_EN_DESTINATION_AREA = 8UL,
      FI_EN_DESTINATION_REACHED = 9UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_MLGuidanceState(metersrv_fi_tcl_e8_MLGuidanceState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_MLGuidanceState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_MLGuidanceState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_MLNextDirection : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_MLNextDirection();
   enum tenType {
      FI_EN_NO_SYMBOL = 0UL,
      FI_EN_NO_INFO = 1UL,
      FI_EN_FOLLOW_STREET = 2UL,
      FI_EN_TURN_STRAIGHT = 3UL,
      FI_EN_TURN_SLIGHT_RIGHT = 4UL,
      FI_EN_TURN_SLIGHT_LEFT = 5UL,
      FI_EN_TURN_RIGHT = 6UL,
      FI_EN_TURN_LEFT = 7UL,
      FI_EN_TURN_SHARP_RIGHT = 8UL,
      FI_EN_TURN_SHARP_LEFT = 9UL,
      FI_EN_UTURN_RIGHT = 10UL,
      FI_EN_UTURN_LEFT = 11UL,
      FI_EN_KEEP_RIGHT = 12UL,
      FI_EN_KEEP_LEFT = 13UL,
      FI_EN_EXIT_RIGHT = 14UL,
      FI_EN_EXIT_LEFT = 15UL,
      FI_EN_DOUBLE_TURN_SLIGHT_RIGHT_AND_SLIGHT_RIGHT_AGAIN = 16UL,
      FI_EN_DOUBLE_TURN_SLIGHT_LEFT_AND_SLIGHT_LEFT_AGAIN = 17UL,
      FI_EN_DOUBLE_TURN_SLIGHT_RIGHT_AND_STRAIGHT = 18UL,
      FI_EN_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT = 19UL,
      FI_EN_DOUBLE_TURN_RIGHT_AND_RIGHT = 20UL,
      FI_EN_DOUBLE_TURN_LEFT_AND_LEFT = 21UL,
      FI_EN_DOUBLE_TURN_RIGHT_AND_LEFT = 22UL,
      FI_EN_DOUBLE_TURN_LEFT_AND_RIGHT = 23UL,
      FI_EN_MERGE = 24UL,
      FI_EN_HIGHWAY_FOLLOW = 25UL,
      FI_EN_HIGHWAY_SLIGHT_RIGHT = 26UL,
      FI_EN_HIGHWAY_SLIGHT_LEFT = 27UL,
      FI_EN_HIGHWAY_DOUBLE_TURN_SLIGHT_RIGHT_AND_SLIGHT_RIGHT = 28UL,
      FI_EN_HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_SLIGHT_LEFT = 29UL,
      FI_EN_HIGHWAY_DOUBLE_TURN_SLIGHT_RIGHT_AND_STRAIGHT = 30UL,
      FI_EN_HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT = 31UL,
      FI_EN_MICHIGAN_TURN_VARIANT_1_RIGHT = 32UL,
      FI_EN_MICHIGAN_TURN_VARIANT_1_LEFT = 33UL,
      FI_EN_MICHIGAN_TURN_VARIANT_2_RIGHT = 34UL,
      FI_EN_MICHIGAN_TURN_VARIANT_2_LEFT = 35UL,
      FI_EN_TUNNEL_ENTER = 36UL,
      FI_EN_TUNNEL = 37UL,
      FI_EN_TUNNEL_EXIT = 38UL,
      FI_EN_FERRY_ENTER = 39UL,
      FI_EN_FERRY = 40UL,
      FI_EN_FERRY_EXIT = 41UL,
      FI_EN_PUBLIC_TRANSPORTATION = 42UL,
      FI_EN_WALK = 43UL,
      FI_EN_COMPASS = 44UL,
      FI_EN_DIRECTION_TO_DESTINATION = 45UL,
      FI_EN_ROUNDABOUT_RIGHT_EXIT_NOW = 46UL,
      FI_EN_ROUNDABOUT_LEFT_EXIT_NOW = 47UL,
      FI_EN_ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER = 48UL,
      FI_EN_ROUNDABOUT_RIGHT_KNOWN_EXIT_NUMBER = 49UL,
      FI_EN_ROUNDABOUT_LEFT_UNKNOWN_EXIT_NUMBER = 64UL,
      FI_EN_ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER = 65UL,
      FI_EN_FINAL_DESTINATION = 80UL,
      FI_EN_FINAL_DESTINATION_ON_THE_RIGHT = 81UL,
      FI_EN_FINAL_DESTINATION_ON_THE_LEFT = 82UL,
      FI_EN_INTERMEDIATE_DESTINATION = 83UL,
      FI_EN_INTERMEDIATE_DESTINATION_ON_THE_RIGHT = 84UL,
      FI_EN_INTERMEDIATE_DESTINATION_ON_THE_LEFT = 85UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_MLNextDirection(metersrv_fi_tcl_e8_MLNextDirection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_MLNextDirection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_MLNextDirection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_MLSpeedLimitUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_MLSpeedLimitUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_MLSpeedLimitUpdate& operator=(const metersrv_fi_tcl_MLSpeedLimitUpdate& coRef);
   metersrv_fi_tcl_MLSpeedLimitUpdate(const metersrv_fi_tcl_MLSpeedLimitUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 CurrentSpeedLimit;
   tU32 NextSpeedLimit;
   tU32 Distance;
   metersrv_fi_tcl_e8_DistanceUnit DistanceUnit;
   virtual ~metersrv_fi_tcl_MLSpeedLimitUpdate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_MLSpeedLimitUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_MLNavigationNextDistanceUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_MLNavigationNextDistanceUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_MLNavigationNextDistanceUpdate& operator=(const metersrv_fi_tcl_MLNavigationNextDistanceUpdate& coRef);
   metersrv_fi_tcl_MLNavigationNextDistanceUpdate(const metersrv_fi_tcl_MLNavigationNextDistanceUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Distance;
   metersrv_fi_tcl_e8_DistanceUnit DistanceUnit;
   tU64 Time;
   tU32 Percentage;
   virtual ~metersrv_fi_tcl_MLNavigationNextDistanceUpdate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_MLNavigationNextDistanceUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_MLNavigationTripInfoUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_MLNavigationTripInfoUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_MLNavigationTripInfoUpdate& operator=(const metersrv_fi_tcl_MLNavigationTripInfoUpdate& coRef);
   metersrv_fi_tcl_MLNavigationTripInfoUpdate(const metersrv_fi_tcl_MLNavigationTripInfoUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString Destination;
   tU32 Distance;
   metersrv_fi_tcl_e8_DistanceUnit DistanceUnit;
   tU64 RemainingTravelTime;
   tU64 RemainingTrafficTime;
   virtual ~metersrv_fi_tcl_MLNavigationTripInfoUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_MLNavigationTripInfoUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_MLGuidanceActive : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_MLGuidanceActive();
   enum tenType {
      FI_EN_GUIDANCE_CLIENT = 0UL,
      FI_EN_GUIDANCE_NONE = 1UL,
      FI_EN_GUIDANCE_SERVER = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_MLGuidanceActive(metersrv_fi_tcl_e8_MLGuidanceActive::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_MLGuidanceActive();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_MLGuidanceActive& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_MLNavigationInfoUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_MLNavigationInfoUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_MLNavigationInfoUpdate& operator=(const metersrv_fi_tcl_MLNavigationInfoUpdate& coRef);
   metersrv_fi_tcl_MLNavigationInfoUpdate(const metersrv_fi_tcl_MLNavigationInfoUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString MLNavigationAppName;
   metersrv_fi_tcl_e8_MLGuidanceState MLNaviGuidanceState;
   metersrv_fi_tcl_e8_MLGuidanceActive MLNaviGuidanceActive;
   tBool MLMetricSystem;
   tBool MLRightDriving;
   virtual ~metersrv_fi_tcl_MLNavigationInfoUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_MLNavigationInfoUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_MLNavigationNextManeuverUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_MLNavigationNextManeuverUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_MLNavigationNextManeuverUpdate& operator=(const metersrv_fi_tcl_MLNavigationNextManeuverUpdate& coRef);
   metersrv_fi_tcl_MLNavigationNextManeuverUpdate(const metersrv_fi_tcl_MLNavigationNextManeuverUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_MLNextDirection MLNextDirection;
   tU32 MLNextManeuverIndex;
   tU32 MLNextAngle;
   std::vector<tU32, std::allocator<tU32> > NextSideStreetAngles_1;
   std::vector<tU32, std::allocator<tU32> > NextSideStreetAngles_2;
   std::vector<tU32, std::allocator<tU32> > NextSideStreetAngles_3;
   metersrv_fi_tclString NextStreetName;
   metersrv_fi_tclString CurrentStreetName;
   tU32 NumOfSideStreetAngles_1;
   tU32 NumOfSideStreetAngles_2;
   tU32 NumOfSideStreetAngles_3;
   virtual ~metersrv_fi_tcl_MLNavigationNextManeuverUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_MLNavigationNextManeuverUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_MLTBTUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_MLTBTUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_MLTBTUpdate& operator=(const metersrv_fi_tcl_MLTBTUpdate& coRef);
   metersrv_fi_tcl_MLTBTUpdate(const metersrv_fi_tcl_MLTBTUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_MLNavigationInfoUpdate MirrorLinkNavigationInfoUpdate;
   tBool isMirrorLinkNavigationInfoUpdateValid;
   metersrv_fi_tcl_MLNavigationNextManeuverUpdate MirrorLinkNavigationNextManeuverUpdate;
   tBool isMirrorLinkNavigationNextManeuverUpdateValid;
   metersrv_fi_tcl_MLSpeedLimitUpdate MirrorLinkSpeedLimitUpdate;
   tBool isMirrorLinkSpeedLimitUpdateValid;
   metersrv_fi_tcl_MLNavigationNextDistanceUpdate MirrorLinkNavigationNextDistanceUpdate;
   tBool isMirrorLinkNavigationNextDistanceUpdateValid;
   metersrv_fi_tcl_MLNavigationTripInfoUpdate MirrorLinkNavigationTripInfoUpdate;
   tBool isMirrorLinkNavigationTripInfoUpdateValid;
   virtual ~metersrv_fi_tcl_MLTBTUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_MLTBTUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_DiPoManeuverState : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_DiPoManeuverState();
   enum tenType {
      FI_EN_E8DIPO_MANEUVER_STATE_CONTINUE = 0UL,
      FI_EN_E8DIPO_MANEUVER_STATE_INITIAL = 1UL,
      FI_EN_E8DIPO_MANEUVER_STATE_PREPARE = 2UL,
      FI_EN_E8DIPO_MANEUVER_STATE_EXECUTE = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_DiPoManeuverState(metersrv_fi_tcl_e8_DiPoManeuverState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_DiPoManeuverState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_DiPoManeuverState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_DiPORouteGuidanceUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_DiPORouteGuidanceUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_DiPORouteGuidanceUpdate& operator=(const metersrv_fi_tcl_DiPORouteGuidanceUpdate& coRef);
   metersrv_fi_tcl_DiPORouteGuidanceUpdate(const metersrv_fi_tcl_DiPORouteGuidanceUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_DiPoRouteGuidanceState e8RouteGuidanceState;
   metersrv_fi_tcl_e8_DiPoManeuverState e8ManeuverState;
   metersrv_fi_tclString szCurrentRoadName;
   metersrv_fi_tclString szDestinationName;
   tU64 u64EstimatedTimeOfArrival;
   tU64 u64TimeRemainingToDestination;
   tU32 u32DistanceRemaining;
   metersrv_fi_tclString szDistanceRemainingDisplayStr;
   metersrv_fi_tcl_e8_DistanceUnits e8DistanceRemainingDisplayUnits;
   tU32 u32DistanceToNextManeuver;
   metersrv_fi_tclString szDistanceToNextManeuverDisplayStr;
   metersrv_fi_tcl_e8_DistanceUnits e8DistanceToNextManeuverDisplayUnits;
   std::vector<tU16, std::allocator<tU16> > u16RouteGuidanceManeuverCurrentList;
   tU16 u16RouteGuidanceManeuverCount;
   tBool bIsRouteGuidanceVisibleInApp;
   virtual ~metersrv_fi_tcl_DiPORouteGuidanceUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_DiPORouteGuidanceUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_DiPoManeuverType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_DiPoManeuverType();
   enum tenType {
      FI_EN_E8DIPO_MANEUVER_TYPE_NO_TURN = 0UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_LEFT_TURN = 1UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_RIGHT_TURN = 2UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_STRAIGHT_AHEAD = 3UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN = 4UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CONTINUE = 5UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ENTER_ROUNDABOUT = 6UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_EXIT_ROUNDABOUT = 7UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_OFF_RAMP = 8UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ON_RAMP = 9UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_NAVIGATION = 10UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_PROCEED_TO_THE_BEGINNING_OF_ROUTE = 11UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION = 12UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_KEEP_LEFT = 13UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_KEEP_RIGHT = 14UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ENTER_FERRY = 15UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_EXIT_FERRY = 16UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_TO_DIFFERENT_FERRY = 17UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_AND_PROCEED_TO_ROUTE = 18UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_USE_ROUNDABOUT_TO_MAKE_U_TURN = 19UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_LEFT = 20UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_RIGHT = 21UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_LEFT = 22UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_RIGHT = 23UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_LEFT = 24UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_RIGHT = 25UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_WHEN_POSSIBLE = 26UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_DIRECTIONS = 27UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_1 = 28UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_2 = 29UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_3 = 30UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_4 = 31UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_5 = 32UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_6 = 33UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_7 = 34UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_8 = 35UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_9 = 36UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_10 = 37UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_11 = 38UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_12 = 39UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_13 = 40UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_14 = 41UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_15 = 42UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_16 = 43UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_17 = 44UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_18 = 45UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_19 = 46UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SHARP_LEFT_TURN = 47UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SHARP_RIGHT_TURN = 48UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SLIGHT_LEFT_TURN = 49UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SLIGHT_RIGHT_TURN = 50UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY = 51UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_LEFT = 52UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_RIGHT = 53UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_DiPoManeuverType(metersrv_fi_tcl_e8_DiPoManeuverType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_DiPoManeuverType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_DiPoManeuverType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_DiPoDrivingSide : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_DiPoDrivingSide();
   enum tenType {
      FI_EN_E8DIPO_DRIVING_SIDE_RIGHT = 0UL,
      FI_EN_E8DIPO_DRIVING_SIDE_LEFT = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_DiPoDrivingSide(metersrv_fi_tcl_e8_DiPoDrivingSide::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_DiPoDrivingSide();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_DiPoDrivingSide& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_DiPoJunctionType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_DiPoJunctionType();
   enum tenType {
      FI_EN_E8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION = 0UL,
      FI_EN_E8DIPO_JUNCTION_TYPE_ROUNDABOUT = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_DiPoJunctionType(metersrv_fi_tcl_e8_DiPoJunctionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_DiPoJunctionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_DiPoJunctionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_DiPORouteGuidanceManeuverUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_DiPORouteGuidanceManeuverUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_DiPORouteGuidanceManeuverUpdate& operator=(const metersrv_fi_tcl_DiPORouteGuidanceManeuverUpdate& coRef);
   metersrv_fi_tcl_DiPORouteGuidanceManeuverUpdate(const metersrv_fi_tcl_DiPORouteGuidanceManeuverUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16Index;
   metersrv_fi_tclString szManeuverDescription;
   metersrv_fi_tcl_e8_DiPoManeuverType e8ManeuverType;
   metersrv_fi_tclString szAfterManeuverRoadName;
   tU32 u32DistanceBetweenManeuver;
   metersrv_fi_tclString szDistanceBetweenManeuverDisplayStr;
   metersrv_fi_tcl_e8_DistanceUnits e8DistanceBetweenManeuverDisplayUnits;
   metersrv_fi_tcl_e8_DiPoDrivingSide e8DrivingSide;
   metersrv_fi_tcl_e8_DiPoJunctionType e8JunctionType;
   tS16 s16JunctionElementAngle;
   tS16 s16JunctionElementExitAngle;
   virtual ~metersrv_fi_tcl_DiPORouteGuidanceManeuverUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_DiPORouteGuidanceManeuverUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_CarPlayTBTUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_CarPlayTBTUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_CarPlayTBTUpdate& operator=(const metersrv_fi_tcl_CarPlayTBTUpdate& coRef);
   metersrv_fi_tcl_CarPlayTBTUpdate(const metersrv_fi_tcl_CarPlayTBTUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_DiPORouteGuidanceUpdate DiPoRouteGuidanceUpdate;
   tBool isDiPoRouteGuidanceUpdateValid;
   metersrv_fi_tcl_DiPORouteGuidanceManeuverUpdate DiPoRouteGuidanceManeuverUpdate;
   tBool isDiPoRouteGuidanceManeuverUpdateValid;
   virtual ~metersrv_fi_tcl_CarPlayTBTUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_CarPlayTBTUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_AAutoNextTurnEvent : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_AAutoNextTurnEvent();
   enum tenType {
      FI_EN_NEXT_TURN_UNKNOWN = 0UL,
      FI_EN_NEXT_TURN_DEPART = 1UL,
      FI_EN_NEXT_TURN_NAME_CHANGE = 2UL,
      FI_EN_NEXT_TURN_SLIGHT_TURN = 3UL,
      FI_EN_NEXT_TURN_TURN = 4UL,
      FI_EN_NEXT_TURN_SHARP_TURN = 5UL,
      FI_EN_NEXT_TURN_U_TURN = 6UL,
      FI_EN_NEXT_TURN_ON_RAMP = 7UL,
      FI_EN_NEXT_TURN_OFF_RAMP = 8UL,
      FI_EN_NEXT_TURN_FORK = 9UL,
      FI_EN_NEXT_TURN_MERGE = 10UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_ENTER = 11UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_EXIT = 12UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_ENTER_AND_EXIT = 13UL,
      FI_EN_NEXT_TURN_STRAIGHT = 14UL,
      FI_EN_NEXT_TURN_FERRY_BOAT = 16UL,
      FI_EN_NEXT_TURN_FERRY_TRAIN = 17UL,
      FI_EN_NEXT_TURN_DESTINATION = 19UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_AAutoNextTurnEvent(metersrv_fi_tcl_e8_AAutoNextTurnEvent::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_AAutoNextTurnEvent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_AAutoNextTurnEvent& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_AAutoNavigationNextTurnData : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_AAutoNavigationNextTurnData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_AAutoNavigationNextTurnData& operator=(const metersrv_fi_tcl_AAutoNavigationNextTurnData& coRef);
   metersrv_fi_tcl_AAutoNavigationNextTurnData(const metersrv_fi_tcl_AAutoNavigationNextTurnData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString RoadName;
   metersrv_fi_tcl_e8_AAutoTurnSide TurnSide;
   metersrv_fi_tcl_e8_AAutoNextTurnEvent NextTurnEvent;
   std::vector<tU8, std::allocator<tU8> > Image;
   tS32 TurnAngle;
   tS32 TurnNumber;
   virtual ~metersrv_fi_tcl_AAutoNavigationNextTurnData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_AAutoNavigationNextTurnData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_AAutoNavigationNextTurnDistanceData : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_AAutoNavigationNextTurnDistanceData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_AAutoNavigationNextTurnDistanceData& operator=(const metersrv_fi_tcl_AAutoNavigationNextTurnDistanceData& coRef);
   metersrv_fi_tcl_AAutoNavigationNextTurnDistanceData(const metersrv_fi_tcl_AAutoNavigationNextTurnDistanceData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 DistanceInMeters;
   tS32 TimeInSec;
   tS32 DistanceToManeuver;
   metersrv_fi_tcl_e8_DistanceUnits ManeuverDistanceUnits ;
   virtual ~metersrv_fi_tcl_AAutoNavigationNextTurnDistanceData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_AAutoNavigationNextTurnDistanceData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_AAutoNavigationAppState : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_AAutoNavigationAppState();
   enum tenType {
      FI_EN_AAUTO_STATE_NAV_UNKNOWN = 0UL,
      FI_EN_AAUTO_STATE_NAV_ACTIVE = 1UL,
      FI_EN_AAUTO_STATE_NAV_NOTACTIVE = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_AAutoNavigationAppState(metersrv_fi_tcl_e8_AAutoNavigationAppState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_AAutoNavigationAppState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_AAutoNavigationAppState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_AAutoTBTUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_AAutoTBTUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_AAutoTBTUpdate& operator=(const metersrv_fi_tcl_AAutoTBTUpdate& coRef);
   metersrv_fi_tcl_AAutoTBTUpdate(const metersrv_fi_tcl_AAutoTBTUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_AAutoNavigationNextTurnData AAutoNavigationNextTurnData;
   tBool isAAutoNavigationNextTurnDataValid;
   metersrv_fi_tcl_AAutoNavigationNextTurnDistanceData AAutoNavigationNextTurnDistanceData;
   tBool isAAutoNavigationNextTurnDistanceDataValid;
   metersrv_fi_tcl_e8_AAutoNavigationAppState AAutoNavigationStatus;
   tBool isAAutoNavigationStatusValid;
   virtual ~metersrv_fi_tcl_AAutoTBTUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_AAutoTBTUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_BDCLNextTurnType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_BDCLNextTurnType();
   enum tenType {
      FI_EN_NEXT_TURN_UNKNOWN = 0UL,
      FI_EN_TURN_KIND_FRONT = 1UL,
      FI_EN_TURN_KIND_RIGHT_FRONT = 2UL,
      FI_EN_TURN_KIND_RIGHT = 3UL,
      FI_EN_TURN_KIND_RIGHT_BACK = 4UL,
      FI_EN_TURN_KIND_BACK = 5UL,
      FI_EN_TURN_KIND_LEFT_BACK = 6UL,
      FI_EN_TURN_KIND_LEFT = 7UL,
      FI_EN_TURN_KIND_LEFT_FRONT = 8UL,
      FI_EN_TURN_KIND_LEFT_SIDE = 9UL,
      FI_EN_TURN_KIND_RIGHT_SIDE = 10UL,
      FI_EN_TURN_KIND_BRANCH_LEFT = 11UL,
      FI_EN_TURN_KIND_BRANCH_CENTER = 12UL,
      FI_EN_TURN_KIND_BRANCH_RIGHT = 13UL,
      FI_EN_TURN_KIND_RING = 14UL,
      FI_EN_TURN_KIND_INFERRY = 15UL,
      FI_EN_TURN_KIND_OUTFERRY = 16UL,
      FI_EN_TURN_KIND_TOLLGATE = 17UL,
      FI_EN_TURN_KIND_LEFT_SIDE_MAIN = 18UL,
      FI_EN_TURN_KIND_RIGHT_SIDE_MAIN = 19UL,
      FI_EN_TURN_KIND_LEFT_SIDE_IC = 20UL,
      FI_EN_TURN_KIND_RIGHT_SIDE_IC = 21UL,
      FI_EN_TURN_KIND_LEFT_SIDE_STRAIGHT_IC = 22UL,
      FI_EN_TURN_KIND_RIGHT_SIDE_STRAIGHT_IC = 23UL,
      FI_EN_TURN_KIND_LEFT_SIDE_STRAIGHT = 24UL,
      FI_EN_TURN_KIND_RIGHT_SIDE_STRAIGHT = 25UL,
      FI_EN_TURN_KIND_BRANCH_LEFT_STRAIGHT = 26UL,
      FI_EN_TURN_KIND_BRANCH_CENTER_STRAIGHT = 27UL,
      FI_EN_TURN_KIND_BRANCH_RIGHT_STRAIGHT = 28UL,
      FI_EN_TURN_KIND_BRANCH_LEFT_IC = 29UL,
      FI_EN_TURN_KIND_BRANCH_CENTER_IC = 30UL,
      FI_EN_TURN_KIND_BRANCH_RIGHT_IC = 31UL,
      FI_EN_TURN_KIND_BRANCH_LEFT_IC_STRAIGHT = 32UL,
      FI_EN_TURN_KIND_BRANCH_CENTER_IC_STRAIGHT = 33UL,
      FI_EN_TURN_KIND_BRANCH_RIGHT_IC_STRAIGHT = 34UL,
      FI_EN_TURN_KIND_STRAIGHT_2BRANCH_LEFT_BASE = 35UL,
      FI_EN_TURN_KIND_STRAIGHT_2BRANCH_RIGHT_BASE = 36UL,
      FI_EN_TURN_KIND_STRAIGHT_3BRANCH_LEFT_BASE = 37UL,
      FI_EN_TURN_KIND_STRAIGHT_3BRANCH_MIDDLE_BASE = 38UL,
      FI_EN_TURN_KIND_STRAIGHT_3BRANCH_RIGHT_BASE = 39UL,
      FI_EN_TURN_KIND_LEFT_2BRANCH_LEFT_BASE = 40UL,
      FI_EN_TURN_KIND_LEFT_2BRANCH_RIGHT_BASE = 41UL,
      FI_EN_TURN_KIND_LEFT_3BRANCH_LEFT_BASE = 42UL,
      FI_EN_TURN_KIND_LEFT_3BRANCH_MIDDLE_BASE = 43UL,
      FI_EN_TURN_KIND_LEFT_3BRANCH_RIGHT_BASE = 44UL,
      FI_EN_TURN_KIND_RIGHT_2BRANCH_LEFT_BASE = 45UL,
      FI_EN_TURN_KIND_RIGHT_2BRANCH_RIGHT_BASE = 46UL,
      FI_EN_TURN_KIND_RIGHT_3BRANCH_LEFT_BASE = 47UL,
      FI_EN_TURN_KIND_RIGHT_3BRANCH_MIDDLE_BASE = 48UL,
      FI_EN_TURN_KIND_RIGHT_3BRANCH_RIGHT_BASE = 49UL,
      FI_EN_TURN_KIND_LEFT_FRONT_2BRANCH_LEFT_BASE = 50UL,
      FI_EN_TURN_KIND_LEFT_FRONT_2BRANCH_RIGHT_BASE = 51UL,
      FI_EN_TURN_KIND_RIGHT_FRONT_2BRANCH_LEFT_BASE = 52UL,
      FI_EN_TURN_KIND_RIGHT_FRONT_2BRANCH_RIGHT_BASE = 53UL,
      FI_EN_TURN_KIND_BACK_2BRANCH_LEFT_BASE = 54UL,
      FI_EN_TURN_KIND_BACK_2BRANCH_RIGHT_BASE = 55UL,
      FI_EN_TURN_KIND_BACK_3BRANCH_LEFT_BASE = 56UL,
      FI_EN_TURN_KIND_BACK_3BRANCH_MIDDLE_BASE = 57UL,
      FI_EN_TURN_KIND_BACK_3BRANCH_RIGHT_BASE = 58UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_BDCLNextTurnType(metersrv_fi_tcl_e8_BDCLNextTurnType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_BDCLNextTurnType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_BDCLNextTurnType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_CarlifeNaviNextTurnInfo : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_CarlifeNaviNextTurnInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_CarlifeNaviNextTurnInfo& operator=(const metersrv_fi_tcl_CarlifeNaviNextTurnInfo& coRef);
   metersrv_fi_tcl_CarlifeNaviNextTurnInfo(const metersrv_fi_tcl_CarlifeNaviNextTurnInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_BDCLNavigationAppState BDCLNavigationAppState;
   metersrv_fi_tcl_e8_BDCLNextTurnType BDCLNaviTurnType;
   metersrv_fi_tclString RoadName;
   tU32 TotalDistance;
   tU32 RemainDistance;
   tU32 Time;
   std::vector<tU8, std::allocator<tU8> > TurnIconData;
   virtual ~metersrv_fi_tcl_CarlifeNaviNextTurnInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_CarlifeNaviNextTurnInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_BDCLAssistantType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_BDCLAssistantType();
   enum tenType {
      FI_EN_BDCL_ASSISTANT_TYPE_INVALID = 0UL,
      FI_EN_BDCL_ASSISTANT_TYPE_TRAFFICSIGN = 1UL,
      FI_EN_BDCL_ASSISTANT_TYPE_SPEEDCAMERA = 2UL,
      FI_EN_BDCL_ASSISTANT_TYPE_TRAFFICLIGHTCAMERA = 3UL,
      FI_EN_BDCL_ASSISTANT_TYPE_PECCANRYCAMERA = 4UL,
      FI_EN_BDCL_ASSISTANT_TYPE_INTERVALCAMERA = 5UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_BDCLAssistantType(metersrv_fi_tcl_e8_BDCLAssistantType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_BDCLAssistantType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_BDCLAssistantType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_BDCLTrafficSignType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_BDCLTrafficSignType();
   enum tenType {
      FI_EN_BDCL_TRAFFICSIGNTYPE_INVALID = 0UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_BDCLTrafficSignType(metersrv_fi_tcl_e8_BDCLTrafficSignType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_BDCLTrafficSignType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_BDCLTrafficSignType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_CarlifeNaviAssistantGuideInfo : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_CarlifeNaviAssistantGuideInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_CarlifeNaviAssistantGuideInfo& operator=(const metersrv_fi_tcl_CarlifeNaviAssistantGuideInfo& coRef);
   metersrv_fi_tcl_CarlifeNaviAssistantGuideInfo(const metersrv_fi_tcl_CarlifeNaviAssistantGuideInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_BDCLNavigationAppState BDCLAssistantGuideAppState;
   metersrv_fi_tcl_e8_BDCLAssistantType AssistantType;
   metersrv_fi_tcl_e8_BDCLTrafficSignType TrafficSignType;
   tU32 TotalDistance;
   tU32 RemainDistance;
   tU32 CameraSpeed;
   virtual ~metersrv_fi_tcl_CarlifeNaviAssistantGuideInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_CarlifeNaviAssistantGuideInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_BDCLTBTUpdate : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_BDCLTBTUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_BDCLTBTUpdate& operator=(const metersrv_fi_tcl_BDCLTBTUpdate& coRef);
   metersrv_fi_tcl_BDCLTBTUpdate(const metersrv_fi_tcl_BDCLTBTUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_CarlifeNaviNextTurnInfo CarlifeNaviNextTurnInfo;
   tBool isCarlifeNaviNextTurnInfoValid;
   metersrv_fi_tcl_CarlifeNaviAssistantGuideInfo CarlifeNaviAssistantGuideInfo;
   tBool isCarlifeNaviAssistantGuideInfoValid;
   virtual ~metersrv_fi_tcl_BDCLTBTUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_BDCLTBTUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_WeatherInformationSource : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_WeatherInformationSource();
   enum tenType {
      FI_EN_SXM = 0UL,
      FI_EN_TOMTOM = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_WeatherInformationSource(metersrv_fi_tcl_e8_WeatherInformationSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_WeatherInformationSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_WeatherInformationSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_WeatherLocationType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_WeatherLocationType();
   enum tenType {
      FI_EN_CURRENT_VEHICLE_POSITION = 0UL,
      FI_EN_INTERMEDIATE_DESTINATION = 1UL,
      FI_EN_FINAL_DESTINATION = 2UL,
      FI_EN_ARBITRARY_LOCATION = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_WeatherLocationType(metersrv_fi_tcl_e8_WeatherLocationType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_WeatherLocationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_WeatherLocationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_WeatherReportType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_WeatherReportType();
   enum tenType {
      FI_EN_OVERVIEW = 0UL,
      FI_EN_DAILY = 1UL,
      FI_EN_SUB_DAILY = 2UL,
      FI_EN_TIMED = 3UL,
      FI_EN_HISTORICAL = 4UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_WeatherReportType(metersrv_fi_tcl_e8_WeatherReportType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_WeatherReportType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_WeatherReportType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_CloudCoverage : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_CloudCoverage();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_CLEAR = 1UL,
      FI_EN_FEW_CLOUDS = 2UL,
      FI_EN_PARTLY_CLOUDS = 3UL,
      FI_EN_CLOUDY = 4UL,
      FI_EN_VERY_CLOUDY = 5UL,
      FI_EN_OVERCAST = 6UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_CloudCoverage(metersrv_fi_tcl_e8_CloudCoverage::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_CloudCoverage();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_CloudCoverage& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_UVIndex : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_UVIndex();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_ONE_LOW = 1UL,
      FI_EN_TWO_LOW = 2UL,
      FI_EN_THREE_MODERATE = 3UL,
      FI_EN_FOUR_MODERATE = 4UL,
      FI_EN_FIVE_MODERATE = 5UL,
      FI_EN_SIX_HIGH = 6UL,
      FI_EN_SEVEN_HIGH = 7UL,
      FI_EN_EIGHT_VERY_HIGH = 8UL,
      FI_EN_NINE_VERY_HIGH = 9UL,
      FI_EN_TEN_VERY_HIGH = 10UL,
      FI_EN_ELEVEN_EXTREME = 11UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_UVIndex(metersrv_fi_tcl_e8_UVIndex::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_UVIndex();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_UVIndex& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_WeatherSituation : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_WeatherSituation();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_CLEAR_SKY = 1UL,
      FI_EN_A_FEW_CLOUDS = 2UL,
      FI_EN_PARTLY_CLOUDY = 3UL,
      FI_EN_PARTLY_CLOUDY_SLIGHT_RAIN = 4UL,
      FI_EN_PARTLY_CLOUDY_RAIN = 5UL,
      FI_EN_PARTLY_CLOUDY_SLIGHT_SLEET = 6UL,
      FI_EN_PARTLY_CLOUDY_SLEET = 7UL,
      FI_EN_PARTLY_CLOUDY_SLIGHT_SNOW = 8UL,
      FI_EN_PARTLY_CLOUDY_SNOW = 9UL,
      FI_EN_PARTLY_CLOUDY_THUNDERSTORM = 10UL,
      FI_EN_CLOUDY = 11UL,
      FI_EN_CLOUDY_SLIGHT_RAIN = 12UL,
      FI_EN_CLOUDY_RAIN = 13UL,
      FI_EN_CLOUDY_SLIGHT_SLEET = 14UL,
      FI_EN_CLOUDY_SLEET = 15UL,
      FI_EN_CLOUDY_SLIGHT_SNOW = 16UL,
      FI_EN_CLOUDY_SNOW = 17UL,
      FI_EN_CLOUDY_THUNDERSTORM = 18UL,
      FI_EN_OVERCAST = 19UL,
      FI_EN_OVERCAST_SLIGHT_RAIN = 20UL,
      FI_EN_OVERCAST_RAIN = 21UL,
      FI_EN_OVERCAST_SEVERE_RAIN = 22UL,
      FI_EN_OVERCAST_SLIGHT_SLEET = 23UL,
      FI_EN_OVERCAST_SLEET = 24UL,
      FI_EN_OVERCAST_SEVERE_SLEET = 25UL,
      FI_EN_OVERCAST_SLIGHT_SNOW = 26UL,
      FI_EN_OVERCAST_SNOW = 27UL,
      FI_EN_OVERCAST_SEVERE_SNOW = 28UL,
      FI_EN_OVERCAST_THUNDERSTORM = 29UL,
      FI_EN_MIST = 30UL,
      FI_EN_FOG = 31UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_WeatherSituation(metersrv_fi_tcl_e8_WeatherSituation::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_WeatherSituation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_WeatherSituation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_WeatherSeverity : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_WeatherSeverity();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SEVERE_RAIN = 1UL,
      FI_EN_SEVERE_SLEET = 2UL,
      FI_EN_SEVERE_SNOW = 3UL,
      FI_EN_SEVERE_FOG = 4UL,
      FI_EN_SEVERE_STORM = 5UL,
      FI_EN_EXTREME_WEATHER_CONDITIONS = 6UL,
      FI_EN_VISIBILITY_REDUCED = 7UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_WeatherSeverity(metersrv_fi_tcl_e8_WeatherSeverity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_WeatherSeverity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_WeatherSeverity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_WeatherConfigurationInformation : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_WeatherConfigurationInformation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_WeatherConfigurationInformation& operator=(const metersrv_fi_tcl_WeatherConfigurationInformation& coRef);
   metersrv_fi_tcl_WeatherConfigurationInformation(const metersrv_fi_tcl_WeatherConfigurationInformation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 timeInterval;
   tU8 numberOfHours;
   virtual ~metersrv_fi_tcl_WeatherConfigurationInformation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_WeatherConfigurationInformation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_WeatherReportConfiguration : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_WeatherReportConfiguration();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_WeatherReportConfiguration& operator=(const metersrv_fi_tcl_WeatherReportConfiguration& coRef);
   metersrv_fi_tcl_WeatherReportConfiguration(const metersrv_fi_tcl_WeatherReportConfiguration& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_WeatherReportType weatherReportType;
   metersrv_fi_tcl_e8_WeatherLocationType weatherLocationType;
   metersrv_fi_tcl_WeatherConfigurationInformation weatherConfigurationInformation;
   virtual ~metersrv_fi_tcl_WeatherReportConfiguration();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_WeatherReportConfiguration& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_WeatherReport : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_WeatherReport();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_WeatherReport& operator=(const metersrv_fi_tcl_WeatherReport& coRef);
   metersrv_fi_tcl_WeatherReport(const metersrv_fi_tcl_WeatherReport& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8WeatherReport_currentTemperatureInMilliKelvin;
   tU8 u8WeatherReport_minimumTemperatureInMilliKelvin;
   tU8 u8WeatherReport_maximumTemperatureInMilliKelvin;
   tU8 u8WeatherReport_humidityInPercentage;
   tU8 u8WeatherReport_windSpeedInCentimeterSecond;
   tU8 u8WeatherReport_windDirectionInDegree;
   tU8 u8WeatherReport_precipitationInPercentage;
   metersrv_fi_tcl_e8_CloudCoverage e8WeatherReport_cloudCover;
   metersrv_fi_tcl_e8_UVIndex e8WeatherReport_uVIndex;
   metersrv_fi_tcl_e8_WeatherSituation e8WeatherReport_weatherSituation;
   metersrv_fi_tcl_e8_WeatherSeverity e8WeatherReport_weatherSeverity;
   metersrv_fi_tclString strWeatherReport_cityName;
   virtual ~metersrv_fi_tcl_WeatherReport();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_WeatherReport& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_WeatherReportInfo : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_WeatherReportInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_WeatherReportInfo& operator=(const metersrv_fi_tcl_WeatherReportInfo& coRef);
   metersrv_fi_tcl_WeatherReportInfo(const metersrv_fi_tcl_WeatherReportInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u8WeatherReportInfo_requestId;
   std::vector<metersrv_fi_tcl_WeatherReport, std::allocator<metersrv_fi_tcl_WeatherReport> > weatherReportList;
   virtual ~metersrv_fi_tcl_WeatherReportInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_WeatherReportInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_SWSC_KeyCode : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_SWSC_KeyCode();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_SOURCE = 1UL,
      FI_EN_ENTER = 2UL,
      FI_EN_BACK = 3UL,
      FI_EN_VR = 4UL,
      FI_EN_TEL = 5UL,
      FI_EN_TELON = 6UL,
      FI_EN_TELOFF = 7UL,
      FI_EN_VR_TELON = 8UL,
      FI_EN_SOURCE_TELOFF = 9UL,
      FI_EN_VOLUP = 10UL,
      FI_EN_VOLDOWN = 11UL,
      FI_EN_UP = 12UL,
      FI_EN_DOWN = 13UL,
      FI_EN_RIGHT = 14UL,
      FI_EN_LEFT = 15UL,
      FI_EN_MUTE = 16UL,
      FI_EN_MENU_UP = 17UL,
      FI_EN_MENU_DOWN = 18UL,
      FI_EN_MENU_OK = 19UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_SWSC_KeyCode(metersrv_fi_tcl_e8_Meter_SWSC_KeyCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_SWSC_KeyCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_SWSC_KeyCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Phone_SMS_State : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Phone_SMS_State();
   enum tenType {
      FI_EN_NO_ACTION = 0UL,
      FI_EN_SHOW_POPUP = 1UL,
      FI_EN_UPDATE_MSG_NUMBER = 2UL,
      FI_EN_RECEIVING = 3UL,
      FI_EN_READING = 4UL,
      FI_EN_REPLY_MENU = 5UL,
      FI_EN_END_SMS = 6UL,
      FI_EN_SMS_SENT_SUCCESSFULLY = 7UL,
      FI_EN_SMS_SENT_FAILUERE = 8UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Phone_SMS_State(metersrv_fi_tcl_e8_Meter_Phone_SMS_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Phone_SMS_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Phone_SMS_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu();
   enum tenType {
      FI_EN_NO_ACTION = 0UL,
      FI_EN_READ = 1UL,
      FI_EN_IGNORE = 2UL,
      FI_EN_REPLY = 3UL,
      FI_EN_EXIT = 4UL,
      FI_EN_CALL_BACK = 5UL,
      FI_EN_OUT_OF_SMS = 6UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu(metersrv_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_Phone_SMS_PopupType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_Phone_SMS_PopupType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_INCOMING = 1UL,
      FI_EN_READING = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_Phone_SMS_PopupType(metersrv_fi_tcl_e8_Meter_Phone_SMS_PopupType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_Phone_SMS_PopupType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_Phone_SMS_PopupType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_meter_Phone_SMS_Action : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_meter_Phone_SMS_Action();
   enum tenType {
      FI_EN_NOACTION = 0UL,
      FI_EN_READSELECTED = 1UL,
      FI_EN_IGNORESELECTED = 2UL,
      FI_EN_REPLYSELECTED = 3UL,
      FI_EN_EXITSELECTED = 4UL,
      FI_EN_ENTEREDSMSCONTEXT = 5UL,
      FI_EN_EXITEDSMSCONTEXT = 6UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_meter_Phone_SMS_Action(metersrv_fi_tcl_e8_meter_Phone_SMS_Action::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_meter_Phone_SMS_Action();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_meter_Phone_SMS_Action& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_meter_SmsTextTypes : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_meter_SmsTextTypes();
   enum tenType {
      FI_EN_ECALLBACK = 0UL,
      FI_EN_EOUTOFSMS = 1UL,
      FI_EN_EDRIVING = 2UL,
      FI_EN_ECALLME = 3UL,
      FI_EN_EONMYWAY = 4UL,
      FI_EN_ERUNNINGLATE = 5UL,
      FI_EN_EOKAY = 6UL,
      FI_EN_EYES = 7UL,
      FI_EN_ENO = 8UL,
      FI_EN_EWHEREAREYOU = 9UL,
      FI_EN_EWHEN = 10UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_meter_SmsTextTypes(metersrv_fi_tcl_e8_meter_SmsTextTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_meter_SmsTextTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_meter_SmsTextTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_MeterCallStatus : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_MeterCallStatus();
   enum tenType {
      FI_EN_E8IDLE = 0UL,
      FI_EN_E8DIALING = 1UL,
      FI_EN_E8ACTIVE = 2UL,
      FI_EN_E8ON_HOLD = 3UL,
      FI_EN_E8DISCONNECTING = 4UL,
      FI_EN_E8BUSY = 5UL,
      FI_EN_E8CONFERENCE = 6UL,
      FI_EN_E8IN_VOICEMAIL = 7UL,
      FI_EN_E8RINGTONE = 8UL,
      FI_EN_E8INCOMING_HOLD = 9UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_MeterCallStatus(metersrv_fi_tcl_e8_MeterCallStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_MeterCallStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_MeterCallStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_meter_Phone_SMS_Command : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_meter_Phone_SMS_Command();
   enum tenType {
      FI_EN_EREADSMS = 0UL,
      FI_EN_ESENDSMS = 1UL,
      FI_EN_ECALLBACK = 2UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_meter_Phone_SMS_Command(metersrv_fi_tcl_e8_meter_Phone_SMS_Command::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_meter_Phone_SMS_Command();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_meter_Phone_SMS_Command& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_MeterCallType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_MeterCallType();
   enum tenType {
      FI_EN_E8BT = 0UL,
      FI_EN_E8CARPLAY = 1UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_MeterCallType(metersrv_fi_tcl_e8_MeterCallType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_MeterCallType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_MeterCallType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_PhoneCallInfoList : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_PhoneCallInfoList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_PhoneCallInfoList& operator=(const metersrv_fi_tcl_Meter_PhoneCallInfoList& coRef);
   metersrv_fi_tcl_Meter_PhoneCallInfoList(const metersrv_fi_tcl_Meter_PhoneCallInfoList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   metersrv_fi_tcl_e8_MeterCallType e8CallType;
   metersrv_fi_tcl_e8_MeterCallStatus e8CallStatus;
   metersrv_fi_tclString strCallerName;
   metersrv_fi_tclString strCallerNumber;
   virtual ~metersrv_fi_tcl_Meter_PhoneCallInfoList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_PhoneCallInfoList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_Meter_PhoneTextTranslation : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_Meter_PhoneTextTranslation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_Meter_PhoneTextTranslation& operator=(const metersrv_fi_tcl_Meter_PhoneTextTranslation& coRef);
   metersrv_fi_tcl_Meter_PhoneTextTranslation(const metersrv_fi_tcl_Meter_PhoneTextTranslation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_meter_SmsTextTypes eTextMessageID;
   metersrv_fi_tclString strSmsText;
   virtual ~metersrv_fi_tcl_Meter_PhoneTextTranslation();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_Meter_PhoneTextTranslation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_MsgMessageHandle : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_MsgMessageHandle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_fi_tcl_MsgMessageHandle& operator=(const metersrv_fi_tcl_MsgMessageHandle& coRef);
   metersrv_fi_tcl_MsgMessageHandle(const metersrv_fi_tcl_MsgMessageHandle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU32 u32MsgHandleUpper;
   tU32 u32MsgHandleLower;
   virtual ~metersrv_fi_tcl_MsgMessageHandle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_fi_tcl_MsgMessageHandle& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_VR_State : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_VR_State();
   enum tenType {
      FI_EN_IDLE = 0UL,
      FI_EN_LISTENING = 1UL,
      FI_EN_PROCESSING = 2UL,
      FI_EN_SMS_SENDING = 3UL,
      FI_EN_MANUAL_MODE = 4UL,
      FI_EN_SMART_PHONE_VR_ON = 5UL,
      FI_EN_SMART_PHONE_VR_OFF = 6UL,
      FI_EN_HF_MODE = 7UL,
      FI_EN_DIGIT_OFF = 8UL,
      FI_EN_DIGIT_ON = 9UL,
      FI_EN_SMS_SENDING_FAILURE = 10UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_VR_State(metersrv_fi_tcl_e8_Meter_VR_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_VR_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_VR_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_VR_Digit_Type2 : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_VR_Digit_Type2();
   enum tenType {
      FI_EN_0 = 0UL,
      FI_EN_1 = 1UL,
      FI_EN_2 = 2UL,
      FI_EN_3 = 3UL,
      FI_EN_4 = 4UL,
      FI_EN_5 = 5UL,
      FI_EN_6 = 6UL,
      FI_EN_7 = 7UL,
      FI_EN_8 = 8UL,
      FI_EN_9 = 9UL,
      FI_EN_MINUS = 10UL,
      FI_EN_PLUS = 11UL,
      FI_EN_STAR = 12UL,
      FI_EN_HASH = 13UL,
      FI_EN_NONDISPLAY = 15UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_VR_Digit_Type2(metersrv_fi_tcl_e8_Meter_VR_Digit_Type2::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_VR_Digit_Type2();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_VR_Digit_Type2& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_PowerState : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_PowerState();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SHUTDOWN = 1UL,
      FI_EN_PREPARETOSHUTDOWN = 2UL,
      FI_EN_USINGACCESSORY = 3UL,
      FI_EN_IGNITIONON = 4UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_PowerState(metersrv_fi_tcl_e8_Meter_PowerState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_PowerState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_PowerState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_TimeInfoType : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_TimeInfoType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_24H = 1UL,
      FI_EN_AM = 2UL,
      FI_EN_PM = 3UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_TimeInfoType(metersrv_fi_tcl_e8_Meter_TimeInfoType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_TimeInfoType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_TimeInfoType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_PhoneCall_Menu_Action : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_PhoneCall_Menu_Action();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_ANSWER = 1UL,
      FI_EN_DECLINE = 2UL,
      FI_EN_END = 3UL,
      FI_EN_USEHANDSET = 4UL,
      FI_EN_ENTERDIGITS = 5UL,
      FI_EN_MUTEONOFF = 6UL,
      FI_EN_SWITCHCALL = 7UL,
      FI_EN_HOLD = 8UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_PhoneCall_Menu_Action(metersrv_fi_tcl_e8_Meter_PhoneCall_Menu_Action::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_PhoneCall_Menu_Action();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_PhoneCall_Menu_Action& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Meter_PhoneCall_State : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Meter_PhoneCall_State();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_INCOMING = 1UL,
      FI_EN_DURINGCALL = 2UL,
      FI_EN_ENDCALL = 3UL,
      FI_EN_OUTGOING = 4UL,
      FI_EN_OUTGOINGFAILURE = 5UL,
      FI_EN_CALLWAITING = 6UL,
      FI_EN_DURINGCALLCARPLAY = 7UL,
      FI_EN_CALLWAITINGCARPLAY = 8UL,
      FI_EN_HANDSETCALL = 9UL,
      FI_EN_INCOMINGHOLD = 10UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Meter_PhoneCall_State(metersrv_fi_tcl_e8_Meter_PhoneCall_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Meter_PhoneCall_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Meter_PhoneCall_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

class metersrv_fi_tcl_e8_Language_InvalidParameter : public metersrv_fi_tclVisitableTypeBase
{
public:

   metersrv_fi_tcl_e8_Language_InvalidParameter();
   enum tenType {
      FI_EN_NORMAL = 0UL,
      FI_EN_OUTOFRANGE = 1UL,
      FI_EN_INVALEDPARAMETER = 2UL,
      FI_EN_INTERNALERROR = 3UL,
      FI_EN_OTHER = 4UL
   };
   tenType enType;

   metersrv_fi_tcl_e8_Language_InvalidParameter(metersrv_fi_tcl_e8_Language_InvalidParameter::tenType newValue)
      :enType(newValue)
   {}

   virtual ~metersrv_fi_tcl_e8_Language_InvalidParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const metersrv_fi_tcl_e8_Language_InvalidParameter& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(metersrv_fi_tclVisitorBase& rfoVisitor);
};

#endif
