/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef METERSRV_MAINFITYPES_HEADER
#define METERSRV_MAINFITYPES_HEADER


class metersrv_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for metersrv_main_fi message types

fi_tclMessageBase* metersrv_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class metersrv_mainfi_tclMsgBaseMessage : public metersrv_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   metersrv_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodStart& operator=(const metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodStart& coRef);
   metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodStart(const metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8VersionInfo e8Version;
   virtual ~metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodResult();

   virtual ~metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgUpdateVersionInfotoMeterMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodStart& operator=(const metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodStart& coRef);
   metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodStart(const metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_DistanceUnit e8DistanceUnit;
   virtual ~metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetHMIDistanceUnitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& operator=(const metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& coRef);
   metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodStart(const metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit e8FuelConsumptionUnit;
   virtual ~metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetHMIFuelConsumptionUnitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodStart& operator=(const metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodStart& coRef);
   metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodStart(const metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_TemperatureUnit e8TemperatureUnit;
   virtual ~metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetHMITemperatureUnitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetHMIPressureUnitMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetHMIPressureUnitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetHMIPressureUnitMethodStart& operator=(const metersrv_mainfi_tclMsgSetHMIPressureUnitMethodStart& coRef);
   metersrv_mainfi_tclMsgSetHMIPressureUnitMethodStart(const metersrv_mainfi_tclMsgSetHMIPressureUnitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_PressureUnit e8PressureUnit;
   virtual ~metersrv_mainfi_tclMsgSetHMIPressureUnitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetHMIPressureUnitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetHMIPressureUnitMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetHMIPressureUnitMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetHMIPressureUnitMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetHMIPressureUnitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodStart& operator=(const metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodStart& coRef);
   metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodStart(const metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_RequestedLanguageResult e8Resultoneway;
   metersrv_fi_tcl_e8_Meter_Language_Status e8Resulttwoway;
   virtual ~metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetRequestedLanguageResultMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetMeterLanguageMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetMeterLanguageMethodStart();

   virtual ~metersrv_mainfi_tclMsgGetMeterLanguageMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgGetMeterLanguageMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetMeterLanguageMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetMeterLanguageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgGetMeterLanguageMethodResult& operator=(const metersrv_mainfi_tclMsgGetMeterLanguageMethodResult& coRef);
   metersrv_mainfi_tclMsgGetMeterLanguageMethodResult(const metersrv_mainfi_tclMsgGetMeterLanguageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Language e8Language;
   virtual ~metersrv_mainfi_tclMsgGetMeterLanguageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgGetMeterLanguageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart();

   virtual ~metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& operator=(const metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& coRef);
   metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult(const metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Language e8DefaultLanguage;
   metersrv_fi_tcl_e8_Meter_Language e8CurrentLanguage;
   tU8 e8LanguageAvailable_Byte_1;
   tU8 e8LanguageAvailable_Byte_2;
   tU8 e8LanguageAvailable_Byte_3;
   virtual ~metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodStart& operator=(const metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodStart& coRef);
   metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodStart(const metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Language e8Language;
   virtual ~metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetLanguageSettingsfromLCNMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodStart& operator=(const metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodStart& coRef);
   metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodStart(const metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Language e8Language;
   virtual ~metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodResult& operator=(const metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodResult& coRef);
   metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodResult(const metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Language_Status e8LanguageStatus;
   virtual ~metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgGetLanguageAvailabilityMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetMeterLanguageMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetMeterLanguageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetMeterLanguageMethodStart& operator=(const metersrv_mainfi_tclMsgSetMeterLanguageMethodStart& coRef);
   metersrv_mainfi_tclMsgSetMeterLanguageMethodStart(const metersrv_mainfi_tclMsgSetMeterLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Language e8Language;
   virtual ~metersrv_mainfi_tclMsgSetMeterLanguageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetMeterLanguageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetMeterLanguageMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetMeterLanguageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetMeterLanguageMethodResult& operator=(const metersrv_mainfi_tclMsgSetMeterLanguageMethodResult& coRef);
   metersrv_mainfi_tclMsgSetMeterLanguageMethodResult(const metersrv_mainfi_tclMsgSetMeterLanguageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Language_Status e8LanguageStatus;
   virtual ~metersrv_mainfi_tclMsgSetMeterLanguageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetMeterLanguageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetAvailableSourceListMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetAvailableSourceListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgGetAvailableSourceListMethodStart& operator=(const metersrv_mainfi_tclMsgGetAvailableSourceListMethodStart& coRef);
   metersrv_mainfi_tclMsgGetAvailableSourceListMethodStart(const metersrv_mainfi_tclMsgGetAvailableSourceListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32SourceListLowByte;
   tU32 u32SourceListHighByte;
   tU32 u32SourceListGen2Byte;
   virtual ~metersrv_mainfi_tclMsgGetAvailableSourceListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgGetAvailableSourceListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetAvailableSourceListMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetAvailableSourceListMethodResult();

   virtual ~metersrv_mainfi_tclMsgGetAvailableSourceListMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgGetAvailableSourceListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodStart();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSettingListMenu;
   tBool bCarSymbolColorMenu;
   tBool bECOSettingMenu;
   tBool bPopupSettingMenu;
   tBool bIlluminationMenu;
   tBool bLanguageSettingMenu;
   tBool bTPMSSettingMenu;
   tBool bInitSettingResetMenu;
   tBool bTJPSettingMenu;
   tBool bProPilotSettingMenu;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_GetAvailableMenusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodStart();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_Switch e8ITSStatus;
   metersrv_fi_tcl_e8_Meter_Switch e8AverageSpeed;
   metersrv_fi_tcl_e8_Meter_Switch e8DrivingDistanceTime;
   metersrv_fi_tcl_e8_Meter_Switch e8DTE;
   metersrv_fi_tcl_e8_Meter_Switch e8InstSpeed;
   metersrv_fi_tcl_e8_Meter_Switch e8InstFE_AveFE;
   metersrv_fi_tcl_e8_Meter_Switch e8AccelGuide;
   metersrv_fi_tcl_e8_Meter_Switch e8TPMS;
   metersrv_fi_tcl_e8_Meter_Switch e8Audio;
   metersrv_fi_tcl_e8_Meter_Switch e8TBTGuide;
   metersrv_fi_tcl_e8_Meter_Switch e84WD;
   metersrv_fi_tcl_e8_Meter_Switch e8HEVEnergyFlow;
   metersrv_fi_tcl_e8_Meter_Switch e8SOC;
   metersrv_fi_tcl_e8_Meter_Switch e8EVOdo;
   metersrv_fi_tcl_e8_Meter_Switch e8WaterTemperature;
   metersrv_fi_tcl_e8_Meter_Switch e8HomeDisplay;
   metersrv_fi_tcl_e8_Meter_Switch e8IdolStopTime;
   metersrv_fi_tcl_e8_Meter_Switch e8SumIdolStopTime;
   metersrv_fi_tcl_e8_Meter_Switch e8Torque;
   metersrv_fi_tcl_e8_Meter_Switch e8IDM;
   metersrv_fi_tcl_e8_Meter_Switch e8DriverAttentionSupport;
   metersrv_fi_tcl_e8_Meter_Switch e8AdditionalMenu1;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_TSR;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_OLS;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_Convinience;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_Drive_Computer;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_TJP;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_VCR;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_GetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodStart& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodStart& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodStart(const metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_Switch e8ITSStatus;
   metersrv_fi_tcl_e8_Meter_Switch e8AverageSpeed;
   metersrv_fi_tcl_e8_Meter_Switch e8DrivingDistanceTime;
   metersrv_fi_tcl_e8_Meter_Switch e8DTE;
   metersrv_fi_tcl_e8_Meter_Switch e8InstSpeed;
   metersrv_fi_tcl_e8_Meter_Switch e8InstFE_AveFE;
   metersrv_fi_tcl_e8_Meter_Switch e8AccelGuide;
   metersrv_fi_tcl_e8_Meter_Switch e8TPMS;
   metersrv_fi_tcl_e8_Meter_Switch e8Audio;
   metersrv_fi_tcl_e8_Meter_Switch e8TBTGuide;
   metersrv_fi_tcl_e8_Meter_Switch e84WD;
   metersrv_fi_tcl_e8_Meter_Switch e8HEVEnergyFlow;
   metersrv_fi_tcl_e8_Meter_Switch e8SOC;
   metersrv_fi_tcl_e8_Meter_Switch e8EVOdo;
   metersrv_fi_tcl_e8_Meter_Switch e8WaterTemperature;
   metersrv_fi_tcl_e8_Meter_Switch e8HomeDisplay;
   metersrv_fi_tcl_e8_Meter_Switch e8IdolStopTime;
   metersrv_fi_tcl_e8_Meter_Switch e8SumIdolStopTime;
   metersrv_fi_tcl_e8_Meter_Switch e8Torque;
   metersrv_fi_tcl_e8_Meter_Switch e8IDM;
   metersrv_fi_tcl_e8_Meter_Switch e8DriverAttentionSupport;
   metersrv_fi_tcl_e8_Meter_Switch e8AdditionalMenu1;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_TSR;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_OLS;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_Convinience;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_Drive_Computer;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_TJP;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_VCR;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8SetDataResult;
   metersrv_fi_tcl_e8_Meter_Switch e8ITSStatus;
   metersrv_fi_tcl_e8_Meter_Switch e8AverageSpeed;
   metersrv_fi_tcl_e8_Meter_Switch e8DrivingDistanceTime;
   metersrv_fi_tcl_e8_Meter_Switch e8DTE;
   metersrv_fi_tcl_e8_Meter_Switch e8InstSpeed;
   metersrv_fi_tcl_e8_Meter_Switch e8InstFE_AveFE;
   metersrv_fi_tcl_e8_Meter_Switch e8AccelGuide;
   metersrv_fi_tcl_e8_Meter_Switch e8TPMS;
   metersrv_fi_tcl_e8_Meter_Switch e8Audio;
   metersrv_fi_tcl_e8_Meter_Switch e8TBTGuide;
   metersrv_fi_tcl_e8_Meter_Switch e84WD;
   metersrv_fi_tcl_e8_Meter_Switch e8HEVEnergyFlow;
   metersrv_fi_tcl_e8_Meter_Switch e8SOC;
   metersrv_fi_tcl_e8_Meter_Switch e8EVOdo;
   metersrv_fi_tcl_e8_Meter_Switch e8WaterTemperature;
   metersrv_fi_tcl_e8_Meter_Switch e8HomeDisplay;
   metersrv_fi_tcl_e8_Meter_Switch e8IdolStopTime;
   metersrv_fi_tcl_e8_Meter_Switch e8SumIdolStopTime;
   metersrv_fi_tcl_e8_Meter_Switch e8Torque;
   metersrv_fi_tcl_e8_Meter_Switch e8IDM;
   metersrv_fi_tcl_e8_Meter_Switch e8DriverAttentionSupport;
   metersrv_fi_tcl_e8_Meter_Switch e8AdditionalMenu1;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_TSR;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_OLS;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_Convinience;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_Drive_Computer;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_TJP;
   metersrv_fi_tcl_e8_Meter_Switch eAdditional_Menu1_VCR;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_SettingsList_SetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodStart();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_Switch e8Blue;
   metersrv_fi_tcl_e8_Meter_Switch e8Brown;
   metersrv_fi_tcl_e8_Meter_Switch e8Reg;
   metersrv_fi_tcl_e8_Meter_Switch e8Beige;
   metersrv_fi_tcl_e8_Meter_Switch e8Black;
   metersrv_fi_tcl_e8_Meter_Switch e8Gray;
   metersrv_fi_tcl_e8_Meter_Switch e8White;
   metersrv_fi_tcl_e8_Meter_Switch e8Silver;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_GetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodStart& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodStart& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodStart(const metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_Switch e8Blue;
   metersrv_fi_tcl_e8_Meter_Switch e8Brown;
   metersrv_fi_tcl_e8_Meter_Switch e8Reg;
   metersrv_fi_tcl_e8_Meter_Switch e8Beige;
   metersrv_fi_tcl_e8_Meter_Switch e8Black;
   metersrv_fi_tcl_e8_Meter_Switch e8Gray;
   metersrv_fi_tcl_e8_Meter_Switch e8White;
   metersrv_fi_tcl_e8_Meter_Switch e8Silver;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8SetDataResult;
   metersrv_fi_tcl_e8_Meter_Switch e8Blue;
   metersrv_fi_tcl_e8_Meter_Switch e8Brown;
   metersrv_fi_tcl_e8_Meter_Switch e8Reg;
   metersrv_fi_tcl_e8_Meter_Switch e8Beige;
   metersrv_fi_tcl_e8_Meter_Switch e8Black;
   metersrv_fi_tcl_e8_Meter_Switch e8Gray;
   metersrv_fi_tcl_e8_Meter_Switch e8White;
   metersrv_fi_tcl_e8_Meter_Switch e8Silver;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_CarSymbolColor_SetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodStart();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_ECO_Accel AccelGuide;
   metersrv_fi_tcl_e8_Meter_Eco_Drive DriveReport;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_ECO_GetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodStart& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodStart& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodStart(const metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_ECO_Accel AccelGuide;
   metersrv_fi_tcl_e8_Meter_Eco_Drive DriveReport;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8SetDataResult;
   metersrv_fi_tcl_e8_Meter_ECO_Accel AccelGuide;
   metersrv_fi_tcl_e8_Meter_Eco_Drive DriveReport;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_ECO_SetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodStart();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_Low_Temp LowTemperature;
   metersrv_fi_tcl_e8_Meter_Low_Temp TBT;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Popup_GetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodStart& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodStart& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodStart(const metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_Low_Temp LowTemperature;
   metersrv_fi_tcl_e8_Meter_Low_Temp TBT;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8SetDataResult;
   metersrv_fi_tcl_e8_Meter_Low_Temp LowTemperature;
   metersrv_fi_tcl_e8_Meter_Low_Temp TBT;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Popup_SetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodStart();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_Switch IlluminationEffect;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_GetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodStart& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodStart& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodStart(const metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_Switch IlluminationEffect;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8SetDataResult;
   metersrv_fi_tcl_e8_Meter_Switch IlluminationEffect;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Illumination_SetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodStart();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_Language DefaultLanguage;
   metersrv_fi_tcl_e8_Meter_Language CurrentLanguage;
   tBool USEnglish_AvailabeOnMeter;
   tBool CanadianFrench_AvailabeOnMeter;
   tBool MexicanSpanish_AvailabeOnMeter;
   tBool Japanese_AvailabeOnMeter;
   tBool MandarinChinese_AvailabeOnMeter;
   tBool TraditionalChinese_AvailabeOnMeter;
   tBool Korean_AvailabeOnMeter;
   tBool Arabic_AvailabeOnMeter;
   tBool Thai_AvailabeOnMeter;
   tBool UKEnglish_AvailabeOnMeter;
   tBool Fench_AvailabeOnMeter;
   tBool Spanish_AvailabeOnHeadUnit;
   tBool German_AvailabeOnMeter;
   tBool Italian_AvailabeOnMeter;
   tBool Portugese_AvailabeOnMeter;
   tBool BrazilPortugese_AvailabeOnMeter;
   tBool Dutch_AvailabeOnMeter;
   tBool Turkish_AvailabeOnMeter;
   tBool Russian_AvailabeOnMeter;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Language_GetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodStart& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodStart& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodStart(const metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_Language DefaultLanguage;
   metersrv_fi_tcl_e8_Meter_Language CurrentLanguage;
   tBool USEnglish_AvailabeOnHeadUnit;
   tBool CanadianFrench_AvailabeOnHeadUnit;
   tBool MexicanSpanish_AvailabeOnHeadUnit;
   tBool Japanese_AvailabeOnHeadUnit;
   tBool MandarinChinese_AvailabeOnHeadUnit;
   tBool TraditionalChinese_AvailabeOnHeadUnit;
   tBool Korean_AvailabeOnHeadUnit;
   tBool Arabic_AvailabeOnHeadUnit;
   tBool Thai_AvailabeOnHeadUnit;
   tBool UKEnglish_AvailabeOnHeadUnit;
   tBool Fench_AvailabeOnHeadUnit;
   tBool Spanish_AvailabeOnHeadUnit;
   tBool German_AvailabeOnHeadUnit;
   tBool Italian_AvailabeOnHeadUnit;
   tBool Portugese_AvailabeOnHeadUnit;
   tBool BrazilPortugese_AvailabeOnHeadUnit;
   tBool Dutch_AvailabeOnHeadUnit;
   tBool Turkish_AvailabeOnHeadUnit;
   tBool Russian_AvailabeOnHeadUnit;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8SetDataResult;
   metersrv_fi_tcl_e8_Meter_Language DefaultLanguage;
   metersrv_fi_tcl_e8_Meter_Language CurrentLanguage;
   tBool USEnglish_AvailabeOnHeadUnit;
   tBool CanadianFrench_AvailabeOnHeadUnit;
   tBool MexicanSpanish_AvailabeOnHeadUnit;
   tBool Japanese_AvailabeOnHeadUnit;
   tBool MandarinChinese_AvailabeOnHeadUnit;
   tBool TraditionalChinese_AvailabeOnHeadUnit;
   tBool Korean_AvailabeOnHeadUnit;
   tBool Arabic_AvailabeOnHeadUnit;
   tBool Thai_AvailabeOnHeadUnit;
   tBool UKEnglish_AvailabeOnHeadUnit;
   tBool Fench_AvailabeOnHeadUnit;
   tBool Spanish_AvailabeOnHeadUnit;
   tBool German_AvailabeOnHeadUnit;
   tBool Italian_AvailabeOnHeadUnit;
   tBool Portugese_AvailabeOnHeadUnit;
   tBool BrazilPortugese_AvailabeOnHeadUnit;
   tBool Dutch_AvailabeOnHeadUnit;
   tBool Turkish_AvailabeOnHeadUnit;
   tBool Russian_AvailabeOnHeadUnit;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_Language_SetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodStart();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_PressureUnit DefaultPressureUnit;
   metersrv_fi_tcl_e8_Meter_PressureUnit CurrentPressureUnit;
   tBool kPa_AvailableOnMeter;
   tBool PSI_AvailableOnMeter;
   tBool bar_AvailableOnMeter;
   tBool kgf_cm2_AvailableOnMeter;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_GetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodStart& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodStart& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodStart(const metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_PressureUnit DefaultPressureUnit;
   metersrv_fi_tcl_e8_Meter_PressureUnit CurrentPressureUnit;
   tBool kPa_AvailableOnHeadUnit;
   tBool PSI_AvailableOnHeadUnit;
   tBool bar_AvailableOnHeadUnit;
   tBool kgf_cm2_AvailableOnHeadUnit;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8SetDataResult;
   metersrv_fi_tcl_e8_Meter_PressureUnit DefaultPressureUnit;
   metersrv_fi_tcl_e8_Meter_PressureUnit CurrentPressureUnit;
   tBool kPa_AvailableOnMeter;
   tBool PSI_AvailableOnMeter;
   tBool bar_AvailableOnMeter;
   tBool kgf_cm2_AvailableOnMeter;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_TPMS_SetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_InitSettingReset_SetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_InitSettingReset_SetDataMethodStart();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_InitSettingReset_SetDataMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_InitSettingReset_SetDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_InitSettingReset_SetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_InitSettingReset_SetDataMethodResult();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_InitSettingReset_SetDataMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_InitSettingReset_SetDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodStart();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_Meter_Switch TJP_DisplayStatus;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_TJP_GetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodStart& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodStart& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodStart(const metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Switch TJP_DisplayStatus;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8SetDataResult;
   metersrv_fi_tcl_e8_Meter_Switch TJP_DisplayStatus;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_TJP_SetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodStart();

   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8GetDataResult;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8TJPPopupState;
   metersrv_fi_tcl_e8_ProPilot_State_Switch e8ViewMode_State;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8ViewMode_Auto;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8ViewMode_QuarterView;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8ViewMode_PlanView;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8LaneChangePopup;
   metersrv_fi_tcl_e8_ProPilot_State_Switch e8ViewScale_State;
   tU8 u8ViewScale_MaxScale;
   tU8 u8ViewScale_CurrentScale;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_GetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodStart& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodStart& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodStart(const metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8TJPPopupState;
   metersrv_fi_tcl_e8_ProPilot_State_Switch e8ViewMode_State;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8ViewMode_Auto;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8ViewMode_QuarterView;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8ViewMode_PlanView;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8LaneChangePopup;
   metersrv_fi_tcl_e8_ProPilot_State_Switch e8ViewScale_State;
   tU8 u8ViewScale_MaxScale;
   tU8 u8ViewScale_CurrentScale;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodResult& operator=(const metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodResult& coRef);
   metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodResult(const metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode e8SetDataResult;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8TJPPopupState;
   metersrv_fi_tcl_e8_ProPilot_State_Switch e8ViewMode_State;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8ViewMode_Auto;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8ViewMode_QuarterView;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8ViewMode_PlanView;
   metersrv_fi_tcl_e8_ProPilot_Meter_Switch e8LaneChangePopup;
   metersrv_fi_tcl_e8_ProPilot_State_Switch e8ViewScale_State;
   tU8 u8ViewScale_MaxScale;
   tU8 u8ViewScale_CurrentScale;
   virtual ~metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterSettingMenu_ProPilot_SetDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetAudioSourceInfoMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetAudioSourceInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetAudioSourceInfoMethodStart& operator=(const metersrv_mainfi_tclMsgSetAudioSourceInfoMethodStart& coRef);
   metersrv_mainfi_tclMsgSetAudioSourceInfoMethodStart(const metersrv_mainfi_tclMsgSetAudioSourceInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bCausedByUser;
   metersrv_fi_tcl_Meter_Audio_SourceInfoUnion SourceInfo;
   virtual ~metersrv_mainfi_tclMsgSetAudioSourceInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetAudioSourceInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetAudioSourceInfoMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetAudioSourceInfoMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetAudioSourceInfoMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetAudioSourceInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetAudioWarningMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetAudioWarningMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetAudioWarningMethodStart& operator=(const metersrv_mainfi_tclMsgSetAudioWarningMethodStart& coRef);
   metersrv_mainfi_tclMsgSetAudioWarningMethodStart(const metersrv_mainfi_tclMsgSetAudioWarningMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bCausedByUser;
   metersrv_fi_tcl_e8_Meter_Audio_WarningSource e8WarningSource;
   metersrv_fi_tcl_e8_Meter_Audio_WarningState e8WarningState;
   metersrv_fi_tclString strWarningText;
   virtual ~metersrv_mainfi_tclMsgSetAudioWarningMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetAudioWarningMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetAudioWarningMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetAudioWarningMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetAudioWarningMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetAudioWarningMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetAudioSpecialModeMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetAudioSpecialModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetAudioSpecialModeMethodStart& operator=(const metersrv_mainfi_tclMsgSetAudioSpecialModeMethodStart& coRef);
   metersrv_mainfi_tclMsgSetAudioSpecialModeMethodStart(const metersrv_mainfi_tclMsgSetAudioSpecialModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Audio_SpecialMode e8SpecialMode;
   tBool bSpecialModeInterrupt;
   virtual ~metersrv_mainfi_tclMsgSetAudioSpecialModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetAudioSpecialModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetAudioSpecialModeMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetAudioSpecialModeMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetAudioSpecialModeMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetAudioSpecialModeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodStart& operator=(const metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodStart& coRef);
   metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodStart(const metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMute;
   virtual ~metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetAudioEntertainMuteMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetAudioExternalMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetAudioExternalMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetAudioExternalMethodStart& operator=(const metersrv_mainfi_tclMsgSetAudioExternalMethodStart& coRef);
   metersrv_mainfi_tclMsgSetAudioExternalMethodStart(const metersrv_mainfi_tclMsgSetAudioExternalMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bExternalAudio;
   metersrv_fi_tcl_e8_Meter_Audio_SourceType e8SourceType;
   virtual ~metersrv_mainfi_tclMsgSetAudioExternalMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetAudioExternalMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetAudioExternalMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetAudioExternalMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetAudioExternalMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetAudioExternalMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetTimerCountDownEndMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetTimerCountDownEndMethodStart();

   virtual ~metersrv_mainfi_tclMsgSetTimerCountDownEndMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetTimerCountDownEndMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetTimerCountDownEndMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetTimerCountDownEndMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetTimerCountDownEndMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetTimerCountDownEndMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodStart& operator=(const metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodStart& coRef);
   metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodStart(const metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Current_Radio_Mode e8CurrentHeadUnitTunerMode;
   virtual ~metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetCurrentHeadUnitTunerModeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodStart& operator=(const metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodStart& coRef);
   metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodStart(const metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString e8CurrentAudioSource;
   virtual ~metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetCurrentAudioSourceInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodStart& operator=(const metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodStart& coRef);
   metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodStart(const metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_meter_Renault_Update_List_Value e8RenaultUpdateListStatus;
   virtual ~metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetRenaultUpdateListStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviNavStatusMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviNavStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviNavStatusMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviNavStatusMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviNavStatusMethodStart(const metersrv_mainfi_tclMsgSetNaviNavStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_NavStatus e8NavStatus;
   virtual ~metersrv_mainfi_tclMsgSetNaviNavStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviNavStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviNavStatusMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviNavStatusMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviNavStatusMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviNavStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviPositionInformationMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviPositionInformationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviPositionInformationMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviPositionInformationMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviPositionInformationMethodStart(const metersrv_mainfi_tclMsgSetNaviPositionInformationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString strPositionInformationCountryCode;
   metersrv_fi_tcl_e8_RoadClass e8PositionInformationRoadClass;
   tU32 f32PositionInformationVehicleSpeed;
   tU32 f32PositionInformationVehicleHeading;
   virtual ~metersrv_mainfi_tclMsgSetNaviPositionInformationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviPositionInformationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviPositionInformationMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviPositionInformationMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviPositionInformationMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviPositionInformationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodStart(const metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DistanceToDestinationDistanceToDestination;
   metersrv_fi_tcl_e8_DistanceUnit e8DistanceToDestinationUnit;
   virtual ~metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviDistanceToDestinationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodStart(const metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString strCurrentStreet;
   virtual ~metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviCurrentStreetMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodStart(const metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32TurntoStreetManeuverId;
   metersrv_fi_tclString strTurntoStreetTurntoStreet;
   virtual ~metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviTurntoStreetMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodStart(const metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString strNextTurntoStreet;
   virtual ~metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviNextTurntoStreetMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodStart(const metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bBarGraphInfoValid;
   tU16 u16BarGraphInfoValue;
   tU16 u16BarGraphInfoScale;
   metersrv_fi_tcl_e8_DistanceUnit e8BarGraphInfoUnit;
   virtual ~metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviBarGraphInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodStart(const metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_ManeuverSymbol e8ManeuverSymbol;
   virtual ~metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviManeuverSymbolMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodStart(const metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16RoundaboutExitNumber;
   virtual ~metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviRoundaboutExitNumberMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviDeformedImageMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviDeformedImageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviDeformedImageMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviDeformedImageMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviDeformedImageMethodStart(const metersrv_mainfi_tclMsgSetNaviDeformedImageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDeformedImageValid;
   metersrv_fi_tcl_e8_DeformedImageRoad e8DeformedImageDeformedImageRoad;
   metersrv_fi_tcl_e8_DeformedImageArrow e8DeformedImageDeformedImageArrow;
   virtual ~metersrv_mainfi_tclMsgSetNaviDeformedImageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviDeformedImageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviDeformedImageMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviDeformedImageMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviDeformedImageMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviDeformedImageMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviManeuverViewMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviManeuverViewMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviManeuverViewMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviManeuverViewMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviManeuverViewMethodStart(const metersrv_mainfi_tclMsgSetNaviManeuverViewMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ManeuverViewManeuverId;
   metersrv_fi_tcl_e8_ManeuverView e8ManeuverViewManeuverView;
   tBool bManeuverViewDeformedImageValid;
   metersrv_fi_tcl_e8_DeformedImageRoad e8ManeuverViewDeformedImageDeformedImageRoad;
   metersrv_fi_tcl_e8_DeformedImageArrow e8ManeuverViewDeformedImageDeformedImageArrow;
   virtual ~metersrv_mainfi_tclMsgSetNaviManeuverViewMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviManeuverViewMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviManeuverViewMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviManeuverViewMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviManeuverViewMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviManeuverViewMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodStart(const metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<metersrv_fi_tcl_LaneRecommendation, std::allocator<metersrv_fi_tcl_LaneRecommendation> > tLaneRecommendationList;
   virtual ~metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviLaneRecommendationListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodStart(const metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSpeedLimitPresent;
   metersrv_fi_tclString strSpeedLimitCountryCode;
   tU16 u16SpeedLimitValue;
   metersrv_fi_tcl_e8_SpeedUnit e8SpeedLimitSpeedUnit;
   virtual ~metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviSpeedLimitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodStart(const metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString strNextManeuverDetailsDistanceToManeuver;
   metersrv_fi_tcl_e8_DistanceUnit e8NextManeuverDetailsDistanceToManeuverUnit;
   metersrv_fi_tcl_e8_ManeuverRecommendationType e8NextManeuverDetailsRecommendationType;
   tBool bNextManeuverDetailsIsNewManeuver;
   tBool bNextManeuverDetailsIsReRouted;
   virtual ~metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviNextManeuverDetailsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodStart(const metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<metersrv_fi_tcl_ArrivalInformation, std::allocator<metersrv_fi_tcl_ArrivalInformation> > tArrivalInformation;
   virtual ~metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviArrivalInformationListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodStart(const metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32IntersectionMapManeuverId;
   std::vector<metersrv_fi_tcl_IntersectionMapRoadLine, std::allocator<metersrv_fi_tcl_IntersectionMapRoadLine> > tIntersectionMapRoadLineRoadList;
   std::vector<metersrv_fi_tcl_IntersectionMapRoadLine, std::allocator<metersrv_fi_tcl_IntersectionMapRoadLine> > tIntersectionMapRoadLineRouteList;
   std::vector<metersrv_fi_tcl_ScreenCoordinate, std::allocator<metersrv_fi_tcl_ScreenCoordinate> > tIntersectionMapNoEntryIconsList;
   virtual ~metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviIntersectionMapMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart(const metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32IntersectionMapCarsorPositionManeuverId;
   metersrv_fi_tcl_e8_IntersectionMapCarsorState e8IntersectionMapCarsorPositionIntersectionMapCarsorState;
   metersrv_fi_tcl_ScreenCoordinate tIntersectionMapCarsorPositionScreenCoordinate;
   tS32 s32IntersectionMapCarsorPositionCarsorAngle;
   virtual ~metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodStart(const metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementAlertState e8TrafficEnforcementTrafficEnforcementAlertState;
   metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementCameraType e8TrafficEnforcementTrafficEnforcementCameraType;
   metersrv_fi_tclString strTrafficEnforcementDistance;
   metersrv_fi_tcl_e8_DistanceUnit e8TrafficEnforcementDistanceUnit;
   metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementDistanceType e8TrafficEnforcementTrafficEnforcementDistanceType;
   tU32 u32TrafficEnforcementSpeedLimit;
   virtual ~metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviTrafficEnforcementMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodStart(const metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_WeatherInformationSource e8WeatherInformationSourceWeatherInformationSource;
   virtual ~metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviWeatherInformationSourceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodStart& operator=(const metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodStart& coRef);
   metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodStart(const metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<metersrv_fi_tcl_WeatherReportInfo, std::allocator<metersrv_fi_tcl_WeatherReportInfo> > weatherReportInfosWeatherReportInfoList;
   virtual ~metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviWeatherReportInfosMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSxmTabWeatherMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSxmTabWeatherMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetSxmTabWeatherMethodStart& operator=(const metersrv_mainfi_tclMsgSetSxmTabWeatherMethodStart& coRef);
   metersrv_mainfi_tclMsgSetSxmTabWeatherMethodStart(const metersrv_mainfi_tclMsgSetSxmTabWeatherMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SxmTabWeatherInfoEventCodeCurrentWeather;
   tU8 u8SxmTabWeatherInfoEventCodeDestinationWeather;
   virtual ~metersrv_mainfi_tclMsgSetSxmTabWeatherMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetSxmTabWeatherMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSxmTabWeatherMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSxmTabWeatherMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetSxmTabWeatherMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetSxmTabWeatherMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodStart& operator=(const metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodStart& coRef);
   metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodStart(const metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_SpiNavigation_NavigationAppState e8SpiNavgationStatus;
   virtual ~metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetSpiNavigationStatusInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& operator=(const metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& coRef);
   metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodStart(const metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString strSpiNavigationRoadName;
   metersrv_fi_tcl_e8_SpiNavigation_TurnSide e8SpiNavigationTurnSide;
   metersrv_fi_tcl_e8_SpiNavigation_NextTurnEvent e8SpiNavigationNextTurnEvent;
   metersrv_fi_tclString strSpiNavigationImage;
   tS32 s32SpiNavigationTurnAngle;
   tS32 s32SpiNavigationTurnNumber;
   virtual ~metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& operator=(const metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& coRef);
   metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart(const metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32SpiNavigationDistanceInMeters;
   tS32 s32SpiNavigationTimeInSeconds;
   tS32 s32SpiNavigationDistanceToManeuver;
   metersrv_fi_tcl_e8_SpiNavigation_ManeuverDistanceUnits e8SpiNavigationManeuverDistanceUnits;
   virtual ~metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodStart& operator=(const metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodStart& coRef);
   metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodStart(const metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_DeviceCategory e8DeviceCategory;
   metersrv_fi_tcl_CarPlayTBTUpdate CarPlayTBTUpdate;
   metersrv_fi_tcl_AAutoTBTUpdate AAutoTBTUpdate;
   metersrv_fi_tcl_BDCLTBTUpdate BDCLTBTUpdate;
   metersrv_fi_tcl_MLTBTUpdate MLTBTUpdate;
   virtual ~metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetSpiTurnByTurnInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodStart();

   virtual ~metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodResult& operator=(const metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodResult& coRef);
   metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodResult(const metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bIsNaviGen2Connected;
   virtual ~metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgGetMeterNaviGen2ConnectionStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodStart();

   virtual ~metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodResult& operator=(const metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodResult& coRef);
   metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodResult(const metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bIsWeatherConfiguredAndEnabled;
   virtual ~metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgGetWeatherMessageConfigurationStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodStart& operator=(const metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodStart& coRef);
   metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodStart(const metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_PhoneCall_State e8CallState;
   metersrv_fi_tclString strCallerInfo;
   tBool bSwitch_1;
   tBool bSwitch_2;
   tBool IsMuteOn;
   metersrv_fi_tclString strCallerNumber;
   virtual ~metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetPhoneIncomingCallInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& operator=(const metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& coRef);
   metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodStart(const metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Phone_SMS_State e8SMSState;
   metersrv_fi_tcl_e8_Meter_Phone_SMS_PopupType e8SMSPopupType;
   tU8 u8MsgNumber;
   metersrv_fi_tclString strSenderInfo;
   metersrv_fi_tcl_MsgMessageHandle tSmsMessageHandleInfo;
   virtual ~metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetPhoneIncomingSMSInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodStart& operator=(const metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodStart& coRef);
   metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodStart(const metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bIsMuteOn;
   tBool bIsHandestOn;
   std::vector<metersrv_fi_tcl_Meter_PhoneCallInfoList, std::allocator<metersrv_fi_tcl_Meter_PhoneCallInfoList> > arCallInfoStatusList;
   virtual ~metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetPhoneCallInfoListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodStart& operator=(const metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodStart& coRef);
   metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodStart(const metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_meter_Phone_SMS_Action e8SMSAction;
   virtual ~metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodResult();

   virtual ~metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodStart& operator=(const metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodStart& coRef);
   metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodStart(const metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<metersrv_fi_tcl_Meter_PhoneTextTranslation, std::allocator<metersrv_fi_tcl_Meter_PhoneTextTranslation> > arTextTransitionList;
   virtual ~metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetSmsTextMessageTranslationListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodStart& operator=(const metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodStart& coRef);
   metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodStart(const metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bIsPrivateModeOn;
   virtual ~metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetPhonePrivateModeSettingsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodStart& operator=(const metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodStart& coRef);
   metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodStart(const metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_meter_Phone_SMS_Action e8SMSAction;
   metersrv_fi_tcl_MsgMessageHandle tSmsMessageHandleInfo;
   metersrv_fi_tclString strSenderName;
   metersrv_fi_tclString strSenderNumber;
   virtual ~metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodResult();

   virtual ~metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgPhoneSMSHMIActionNotificationExtendedMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodStart& operator=(const metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodStart& coRef);
   metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodStart(const metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bIsPhoneAutoHoldOn;
   virtual ~metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetPhoneAutoHoldSettingsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodStart& operator=(const metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodStart& coRef);
   metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodStart(const metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_VR_State e8VRState;
   virtual ~metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetVoiceRecognitionStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodStart& operator=(const metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodStart& coRef);
   metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodStart(const metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tclString strDigits;
   virtual ~metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetVoiceRecognitionInputDigitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPowerOnKeepMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPowerOnKeepMethodStart();

   virtual ~metersrv_mainfi_tclMsgSetPowerOnKeepMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetPowerOnKeepMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetPowerOnKeepMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetPowerOnKeepMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetPowerOnKeepMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetPowerOnKeepMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetTimeInfoMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetTimeInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetTimeInfoMethodStart& operator=(const metersrv_mainfi_tclMsgSetTimeInfoMethodStart& coRef);
   metersrv_mainfi_tclMsgSetTimeInfoMethodStart(const metersrv_mainfi_tclMsgSetTimeInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_TimeInfoType e8TimeInfoType;
   tU8 u8TensHour;
   tU8 u8OnesHour;
   tU8 u8TensMinute;
   tU8 u8OnesMinute;
   virtual ~metersrv_mainfi_tclMsgSetTimeInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetTimeInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetTimeInfoMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetTimeInfoMethodResult();

   virtual ~metersrv_mainfi_tclMsgSetTimeInfoMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetTimeInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgResetHistoryMethodStart : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgResetHistoryMethodStart();

   virtual ~metersrv_mainfi_tclMsgResetHistoryMethodStart();

   inline tBool operator==(const metersrv_mainfi_tclMsgResetHistoryMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgResetHistoryMethodResult : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgResetHistoryMethodResult();

   virtual ~metersrv_mainfi_tclMsgResetHistoryMethodResult();

   inline tBool operator==(const metersrv_mainfi_tclMsgResetHistoryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgConnectionUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgConnectionUpReg();

   virtual ~metersrv_mainfi_tclMsgConnectionUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgConnectionRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgConnectionRelUpReg();

   virtual ~metersrv_mainfi_tclMsgConnectionRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgConnectionGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgConnectionGet();

   virtual ~metersrv_mainfi_tclMsgConnectionGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgConnectionStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgConnectionStatus& operator=(const metersrv_mainfi_tclMsgConnectionStatus& coRef);
   metersrv_mainfi_tclMsgConnectionStatus(const metersrv_mainfi_tclMsgConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<metersrv_fi_tcl_Meter_UnitConnectionStatus, std::allocator<metersrv_fi_tcl_Meter_UnitConnectionStatus> > arConnectionStatusList;
   virtual ~metersrv_mainfi_tclMsgConnectionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgConfigurationUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgConfigurationUpReg();

   virtual ~metersrv_mainfi_tclMsgConfigurationUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgConfigurationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgConfigurationRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgConfigurationRelUpReg();

   virtual ~metersrv_mainfi_tclMsgConfigurationRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgConfigurationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgConfigurationGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgConfigurationGet();

   virtual ~metersrv_mainfi_tclMsgConfigurationGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgConfigurationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgConfigurationStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgConfigurationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgConfigurationStatus& operator=(const metersrv_mainfi_tclMsgConfigurationStatus& coRef);
   metersrv_mainfi_tclMsgConfigurationStatus(const metersrv_mainfi_tclMsgConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<metersrv_fi_tcl_Meter_UnitConfiguration, std::allocator<metersrv_fi_tcl_Meter_UnitConfiguration> > arConfigurationList;
   virtual ~metersrv_mainfi_tclMsgConfigurationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgConfigurationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgHardwareVersionUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgHardwareVersionUpReg();

   virtual ~metersrv_mainfi_tclMsgHardwareVersionUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgHardwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgHardwareVersionRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgHardwareVersionRelUpReg();

   virtual ~metersrv_mainfi_tclMsgHardwareVersionRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgHardwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgHardwareVersionGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgHardwareVersionGet();

   virtual ~metersrv_mainfi_tclMsgHardwareVersionGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgHardwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgHardwareVersionStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgHardwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgHardwareVersionStatus& operator=(const metersrv_mainfi_tclMsgHardwareVersionStatus& coRef);
   metersrv_mainfi_tclMsgHardwareVersionStatus(const metersrv_mainfi_tclMsgHardwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<metersrv_fi_tcl_Meter_UnitVersion, std::allocator<metersrv_fi_tcl_Meter_UnitVersion> > arHardwareVersionList;
   virtual ~metersrv_mainfi_tclMsgHardwareVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgHardwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSoftwareVersionUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSoftwareVersionUpReg();

   virtual ~metersrv_mainfi_tclMsgSoftwareVersionUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgSoftwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSoftwareVersionRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSoftwareVersionRelUpReg();

   virtual ~metersrv_mainfi_tclMsgSoftwareVersionRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgSoftwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSoftwareVersionGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSoftwareVersionGet();

   virtual ~metersrv_mainfi_tclMsgSoftwareVersionGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgSoftwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSoftwareVersionStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSoftwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSoftwareVersionStatus& operator=(const metersrv_mainfi_tclMsgSoftwareVersionStatus& coRef);
   metersrv_mainfi_tclMsgSoftwareVersionStatus(const metersrv_mainfi_tclMsgSoftwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<metersrv_fi_tcl_Meter_UnitVersion, std::allocator<metersrv_fi_tcl_Meter_UnitVersion> > arSoftwareVersionList;
   virtual ~metersrv_mainfi_tclMsgSoftwareVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSoftwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgDataTransmissionUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgDataTransmissionUpReg();

   virtual ~metersrv_mainfi_tclMsgDataTransmissionUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgDataTransmissionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgDataTransmissionRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgDataTransmissionRelUpReg();

   virtual ~metersrv_mainfi_tclMsgDataTransmissionRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgDataTransmissionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgDataTransmissionGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgDataTransmissionGet();

   virtual ~metersrv_mainfi_tclMsgDataTransmissionGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgDataTransmissionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgDataTransmissionStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgDataTransmissionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgDataTransmissionStatus& operator=(const metersrv_mainfi_tclMsgDataTransmissionStatus& coRef);
   metersrv_mainfi_tclMsgDataTransmissionStatus(const metersrv_mainfi_tclMsgDataTransmissionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<metersrv_fi_tcl_Meter_UnitDataTransmissionStatus, std::allocator<metersrv_fi_tcl_Meter_UnitDataTransmissionStatus> > arDataTransmissionStatusList;
   virtual ~metersrv_mainfi_tclMsgDataTransmissionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgDataTransmissionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterFeatureSupportedUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterFeatureSupportedUpReg();

   virtual ~metersrv_mainfi_tclMsgMeterFeatureSupportedUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterFeatureSupportedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterFeatureSupportedRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterFeatureSupportedRelUpReg();

   virtual ~metersrv_mainfi_tclMsgMeterFeatureSupportedRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterFeatureSupportedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterFeatureSupportedGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterFeatureSupportedGet();

   virtual ~metersrv_mainfi_tclMsgMeterFeatureSupportedGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterFeatureSupportedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterFeatureSupportedStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterFeatureSupportedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterFeatureSupportedStatus& operator=(const metersrv_mainfi_tclMsgMeterFeatureSupportedStatus& coRef);
   metersrv_mainfi_tclMsgMeterFeatureSupportedStatus(const metersrv_mainfi_tclMsgMeterFeatureSupportedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_SupportedFunction e8MeterSupportedFeature;
   virtual ~metersrv_mainfi_tclMsgMeterFeatureSupportedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterFeatureSupportedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgCurrentMeterSettingsUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgCurrentMeterSettingsUpReg();

   virtual ~metersrv_mainfi_tclMsgCurrentMeterSettingsUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgCurrentMeterSettingsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgCurrentMeterSettingsRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgCurrentMeterSettingsRelUpReg();

   virtual ~metersrv_mainfi_tclMsgCurrentMeterSettingsRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgCurrentMeterSettingsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgCurrentMeterSettingsGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgCurrentMeterSettingsGet();

   virtual ~metersrv_mainfi_tclMsgCurrentMeterSettingsGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgCurrentMeterSettingsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgCurrentMeterSettingsStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgCurrentMeterSettingsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgCurrentMeterSettingsStatus& operator=(const metersrv_mainfi_tclMsgCurrentMeterSettingsStatus& coRef);
   metersrv_mainfi_tclMsgCurrentMeterSettingsStatus(const metersrv_mainfi_tclMsgCurrentMeterSettingsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Language e8Language;
   metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit e8FuelConsumptionUnit;
   metersrv_fi_tcl_e8_Meter_TemperatureUnit e8TemperatureUnit;
   metersrv_fi_tcl_e8_Meter_PressureUnit e8PressureUnit;
   virtual ~metersrv_mainfi_tclMsgCurrentMeterSettingsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgCurrentMeterSettingsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsUpReg();

   virtual ~metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg();

   virtual ~metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsGet();

   virtual ~metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsStatus& operator=(const metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsStatus& coRef);
   metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsStatus(const metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool b_km_per_l;
   tBool b_l_per_100km;
   tBool b_US_MPG;
   tBool b_UK_MPG;
   virtual ~metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgAvailableFuelConsumptionUnitsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailableTemperatureUnitsUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailableTemperatureUnitsUpReg();

   virtual ~metersrv_mainfi_tclMsgAvailableTemperatureUnitsUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgAvailableTemperatureUnitsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailableTemperatureUnitsRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailableTemperatureUnitsRelUpReg();

   virtual ~metersrv_mainfi_tclMsgAvailableTemperatureUnitsRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgAvailableTemperatureUnitsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailableTemperatureUnitsGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailableTemperatureUnitsGet();

   virtual ~metersrv_mainfi_tclMsgAvailableTemperatureUnitsGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgAvailableTemperatureUnitsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailableTemperatureUnitsStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailableTemperatureUnitsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgAvailableTemperatureUnitsStatus& operator=(const metersrv_mainfi_tclMsgAvailableTemperatureUnitsStatus& coRef);
   metersrv_mainfi_tclMsgAvailableTemperatureUnitsStatus(const metersrv_mainfi_tclMsgAvailableTemperatureUnitsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool b_deg_C;
   tBool b_deg_F;
   virtual ~metersrv_mainfi_tclMsgAvailableTemperatureUnitsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgAvailableTemperatureUnitsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailablePressureUnitsUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailablePressureUnitsUpReg();

   virtual ~metersrv_mainfi_tclMsgAvailablePressureUnitsUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgAvailablePressureUnitsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailablePressureUnitsRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailablePressureUnitsRelUpReg();

   virtual ~metersrv_mainfi_tclMsgAvailablePressureUnitsRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgAvailablePressureUnitsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailablePressureUnitsGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailablePressureUnitsGet();

   virtual ~metersrv_mainfi_tclMsgAvailablePressureUnitsGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgAvailablePressureUnitsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgAvailablePressureUnitsStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgAvailablePressureUnitsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgAvailablePressureUnitsStatus& operator=(const metersrv_mainfi_tclMsgAvailablePressureUnitsStatus& coRef);
   metersrv_mainfi_tclMsgAvailablePressureUnitsStatus(const metersrv_mainfi_tclMsgAvailablePressureUnitsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool b_kPa;
   tBool b_PSI;
   tBool b_bar;
   tBool b_kgf_cm2;
   virtual ~metersrv_mainfi_tclMsgAvailablePressureUnitsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgAvailablePressureUnitsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitRelUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitGet();

   virtual ~metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitStatus& operator=(const metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitStatus& coRef);
   metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitStatus(const metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit e8FuelConsumptionUnit;
   virtual ~metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgRequestedFuelConsumptionUnitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedTemperatureUnitUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedTemperatureUnitUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedTemperatureUnitUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedTemperatureUnitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedTemperatureUnitRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedTemperatureUnitRelUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedTemperatureUnitRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedTemperatureUnitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedTemperatureUnitGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedTemperatureUnitGet();

   virtual ~metersrv_mainfi_tclMsgRequestedTemperatureUnitGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedTemperatureUnitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedTemperatureUnitStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedTemperatureUnitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgRequestedTemperatureUnitStatus& operator=(const metersrv_mainfi_tclMsgRequestedTemperatureUnitStatus& coRef);
   metersrv_mainfi_tclMsgRequestedTemperatureUnitStatus(const metersrv_mainfi_tclMsgRequestedTemperatureUnitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_TemperatureUnit e8TemperatureUnit;
   virtual ~metersrv_mainfi_tclMsgRequestedTemperatureUnitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgRequestedTemperatureUnitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedPressureUnitUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedPressureUnitUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedPressureUnitUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedPressureUnitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedPressureUnitRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedPressureUnitRelUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedPressureUnitRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedPressureUnitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedPressureUnitGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedPressureUnitGet();

   virtual ~metersrv_mainfi_tclMsgRequestedPressureUnitGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedPressureUnitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedPressureUnitStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedPressureUnitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgRequestedPressureUnitStatus& operator=(const metersrv_mainfi_tclMsgRequestedPressureUnitStatus& coRef);
   metersrv_mainfi_tclMsgRequestedPressureUnitStatus(const metersrv_mainfi_tclMsgRequestedPressureUnitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_PressureUnit e8PressureUnit;
   virtual ~metersrv_mainfi_tclMsgRequestedPressureUnitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgRequestedPressureUnitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSupportedLangSyncModeUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSupportedLangSyncModeUpReg();

   virtual ~metersrv_mainfi_tclMsgSupportedLangSyncModeUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgSupportedLangSyncModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSupportedLangSyncModeRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSupportedLangSyncModeRelUpReg();

   virtual ~metersrv_mainfi_tclMsgSupportedLangSyncModeRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgSupportedLangSyncModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSupportedLangSyncModeGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSupportedLangSyncModeGet();

   virtual ~metersrv_mainfi_tclMsgSupportedLangSyncModeGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgSupportedLangSyncModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSupportedLangSyncModeStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSupportedLangSyncModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSupportedLangSyncModeStatus& operator=(const metersrv_mainfi_tclMsgSupportedLangSyncModeStatus& coRef);
   metersrv_mainfi_tclMsgSupportedLangSyncModeStatus(const metersrv_mainfi_tclMsgSupportedLangSyncModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Lang_Sync_Mode_Type e8LangSyncMode;
   virtual ~metersrv_mainfi_tclMsgSupportedLangSyncModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSupportedLangSyncModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedLanguageUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedLanguageUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedLanguageUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedLanguageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedLanguageRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedLanguageRelUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedLanguageRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedLanguageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedLanguageGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedLanguageGet();

   virtual ~metersrv_mainfi_tclMsgRequestedLanguageGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedLanguageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedLanguageStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedLanguageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgRequestedLanguageStatus& operator=(const metersrv_mainfi_tclMsgRequestedLanguageStatus& coRef);
   metersrv_mainfi_tclMsgRequestedLanguageStatus(const metersrv_mainfi_tclMsgRequestedLanguageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Language e8Language;
   metersrv_fi_tcl_e8_Meter_Language_Action e8MeterLanguageAction;
   virtual ~metersrv_mainfi_tclMsgRequestedLanguageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgRequestedLanguageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgLanguageSettingsStatusUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgLanguageSettingsStatusUpReg();

   virtual ~metersrv_mainfi_tclMsgLanguageSettingsStatusUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgLanguageSettingsStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgLanguageSettingsStatusRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgLanguageSettingsStatusRelUpReg();

   virtual ~metersrv_mainfi_tclMsgLanguageSettingsStatusRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgLanguageSettingsStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgLanguageSettingsStatusGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgLanguageSettingsStatusGet();

   virtual ~metersrv_mainfi_tclMsgLanguageSettingsStatusGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgLanguageSettingsStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgLanguageSettingsStatusStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgLanguageSettingsStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgLanguageSettingsStatusStatus& operator=(const metersrv_mainfi_tclMsgLanguageSettingsStatusStatus& coRef);
   metersrv_mainfi_tclMsgLanguageSettingsStatusStatus(const metersrv_mainfi_tclMsgLanguageSettingsStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Language_InvalidParameter e8InvalidParameter;
   metersrv_fi_tcl_e8_Meter_Language e8DefaultLanguage;
   metersrv_fi_tcl_e8_Meter_Language e8CurrentLanguage;
   tU8 e8LanguageAvailable_Byte_1;
   tU8 e8LanguageAvailable_Byte_2;
   tU8 e8LanguageAvailable_Byte_3;
   virtual ~metersrv_mainfi_tclMsgLanguageSettingsStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgLanguageSettingsStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSelectedSourceOnMeterUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSelectedSourceOnMeterUpReg();

   virtual ~metersrv_mainfi_tclMsgSelectedSourceOnMeterUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgSelectedSourceOnMeterUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSelectedSourceOnMeterRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSelectedSourceOnMeterRelUpReg();

   virtual ~metersrv_mainfi_tclMsgSelectedSourceOnMeterRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgSelectedSourceOnMeterRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSelectedSourceOnMeterGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSelectedSourceOnMeterGet();

   virtual ~metersrv_mainfi_tclMsgSelectedSourceOnMeterGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgSelectedSourceOnMeterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSelectedSourceOnMeterStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSelectedSourceOnMeterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSelectedSourceOnMeterStatus& operator=(const metersrv_mainfi_tclMsgSelectedSourceOnMeterStatus& coRef);
   metersrv_mainfi_tclMsgSelectedSourceOnMeterStatus(const metersrv_mainfi_tclMsgSelectedSourceOnMeterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 e8SelectedSource;
   virtual ~metersrv_mainfi_tclMsgSelectedSourceOnMeterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSelectedSourceOnMeterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviSwipeUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviSwipeUpReg();

   virtual ~metersrv_mainfi_tclMsgSetNaviSwipeUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviSwipeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviSwipeRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviSwipeRelUpReg();

   virtual ~metersrv_mainfi_tclMsgSetNaviSwipeRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviSwipeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviSwipeSet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviSwipeSet();

   virtual ~metersrv_mainfi_tclMsgSetNaviSwipeSet();

   inline tBool operator==(const metersrv_mainfi_tclMsgSetNaviSwipeSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgSetNaviSwipeStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgSetNaviSwipeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgSetNaviSwipeStatus& operator=(const metersrv_mainfi_tclMsgSetNaviSwipeStatus& coRef);
   metersrv_mainfi_tclMsgSetNaviSwipeStatus(const metersrv_mainfi_tclMsgSetNaviSwipeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSwipeBeep;
   virtual ~metersrv_mainfi_tclMsgSetNaviSwipeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgSetNaviSwipeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterWeatherMessageConfigUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterWeatherMessageConfigUpReg();

   virtual ~metersrv_mainfi_tclMsgMeterWeatherMessageConfigUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterWeatherMessageConfigUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterWeatherMessageConfigRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterWeatherMessageConfigRelUpReg();

   virtual ~metersrv_mainfi_tclMsgMeterWeatherMessageConfigRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterWeatherMessageConfigRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterWeatherMessageConfigSet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterWeatherMessageConfigSet();

   virtual ~metersrv_mainfi_tclMsgMeterWeatherMessageConfigSet();

   inline tBool operator==(const metersrv_mainfi_tclMsgMeterWeatherMessageConfigSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgMeterWeatherMessageConfigStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgMeterWeatherMessageConfigStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgMeterWeatherMessageConfigStatus& operator=(const metersrv_mainfi_tclMsgMeterWeatherMessageConfigStatus& coRef);
   metersrv_mainfi_tclMsgMeterWeatherMessageConfigStatus(const metersrv_mainfi_tclMsgMeterWeatherMessageConfigStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bWeatherConfiguredAndEnabled;
   virtual ~metersrv_mainfi_tclMsgMeterWeatherMessageConfigStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgMeterWeatherMessageConfigStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgKeyEventUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgKeyEventUpReg();

   virtual ~metersrv_mainfi_tclMsgKeyEventUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgKeyEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgKeyEventRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgKeyEventRelUpReg();

   virtual ~metersrv_mainfi_tclMsgKeyEventRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgKeyEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgKeyEventStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgKeyEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgKeyEventStatus& operator=(const metersrv_mainfi_tclMsgKeyEventStatus& coRef);
   metersrv_mainfi_tclMsgKeyEventStatus(const metersrv_mainfi_tclMsgKeyEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bKeyPressed;
   metersrv_fi_tcl_e8_Meter_SWSC_KeyCode e8KeyCode;
   virtual ~metersrv_mainfi_tclMsgKeyEventStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgKeyEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionRelUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionStatus& operator=(const metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionStatus& coRef);
   metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionStatus(const metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_PhoneCall_Menu_Action e8CallMenuSelection;
   virtual ~metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgRequestedPhoneCallMenuActionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedSMSMenuActionUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedSMSMenuActionUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedSMSMenuActionUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedSMSMenuActionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedSMSMenuActionRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedSMSMenuActionRelUpReg();

   virtual ~metersrv_mainfi_tclMsgRequestedSMSMenuActionRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgRequestedSMSMenuActionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgRequestedSMSMenuActionStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgRequestedSMSMenuActionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgRequestedSMSMenuActionStatus& operator=(const metersrv_mainfi_tclMsgRequestedSMSMenuActionStatus& coRef);
   metersrv_mainfi_tclMsgRequestedSMSMenuActionStatus(const metersrv_mainfi_tclMsgRequestedSMSMenuActionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu e8SelectedSMSMenu;
   virtual ~metersrv_mainfi_tclMsgRequestedSMSMenuActionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgRequestedSMSMenuActionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationUpReg();

   virtual ~metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationRelUpReg();

   virtual ~metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationStatus& operator=(const metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationStatus& coRef);
   metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationStatus(const metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_meter_Phone_SMS_Action e8SMSAction;
   virtual ~metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgPhoneSMSMeterActionNotificationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgPhoneSmsActionNotificationUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgPhoneSmsActionNotificationUpReg();

   virtual ~metersrv_mainfi_tclMsgPhoneSmsActionNotificationUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgPhoneSmsActionNotificationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgPhoneSmsActionNotificationRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgPhoneSmsActionNotificationRelUpReg();

   virtual ~metersrv_mainfi_tclMsgPhoneSmsActionNotificationRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgPhoneSmsActionNotificationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgPhoneSmsActionNotificationStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgPhoneSmsActionNotificationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgPhoneSmsActionNotificationStatus& operator=(const metersrv_mainfi_tclMsgPhoneSmsActionNotificationStatus& coRef);
   metersrv_mainfi_tclMsgPhoneSmsActionNotificationStatus(const metersrv_mainfi_tclMsgPhoneSmsActionNotificationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_meter_Phone_SMS_Command eCommand;
   metersrv_fi_tclString strText;
   metersrv_fi_tcl_MsgMessageHandle tSmsMessageHandleInfo;
   virtual ~metersrv_mainfi_tclMsgPhoneSmsActionNotificationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgPhoneSmsActionNotificationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgVehiclePowerStateUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgVehiclePowerStateUpReg();

   virtual ~metersrv_mainfi_tclMsgVehiclePowerStateUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgVehiclePowerStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgVehiclePowerStateRelUpReg : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgVehiclePowerStateRelUpReg();

   virtual ~metersrv_mainfi_tclMsgVehiclePowerStateRelUpReg();

   inline tBool operator==(const metersrv_mainfi_tclMsgVehiclePowerStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgVehiclePowerStateGet : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgVehiclePowerStateGet();

   virtual ~metersrv_mainfi_tclMsgVehiclePowerStateGet();

   inline tBool operator==(const metersrv_mainfi_tclMsgVehiclePowerStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class metersrv_mainfi_tclMsgVehiclePowerStateStatus : public metersrv_mainfi_tclMsgBaseMessage
{
public:

   metersrv_mainfi_tclMsgVehiclePowerStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   metersrv_mainfi_tclMsgVehiclePowerStateStatus& operator=(const metersrv_mainfi_tclMsgVehiclePowerStateStatus& coRef);
   metersrv_mainfi_tclMsgVehiclePowerStateStatus(const metersrv_mainfi_tclMsgVehiclePowerStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   metersrv_fi_tcl_e8_Meter_PowerState e8PowerState;
   virtual ~metersrv_mainfi_tclMsgVehiclePowerStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const metersrv_mainfi_tclMsgVehiclePowerStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
