#ifndef __METERSRV_MAINFIDEBUGVISITOR_H__
#define __METERSRV_MAINFIDEBUGVISITOR_H__

class MY_DECL metersrv_mainfi_tclPrintVisitor : public metersrv_mainfi_tclVisitorBase {

private:
   /* default constructor */ metersrv_mainfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   metersrv_mainfi_tclPrintVisitor(metersrv_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(metersrv_fi_tclU8& oU8);
   virtual tVoid vVisitS8(metersrv_fi_tclS8& oS8);
   virtual tVoid vVisitU16(metersrv_fi_tclU16& oU16);
   virtual tVoid vVisitS16(metersrv_fi_tclS16& oS16);
   virtual tVoid vVisitU24(metersrv_fi_tclU24& oU24);
   virtual tVoid vVisitS24(metersrv_fi_tclS24& oS24);
   virtual tVoid vVisitU32(metersrv_fi_tclU32& oU32);
   virtual tVoid vVisitS32(metersrv_fi_tclS32& oS32);
   virtual tVoid vVisitU64(metersrv_fi_tclU64& oU64);
   virtual tVoid vVisitS64(metersrv_fi_tclS64& oS64);
   virtual tVoid vVisitBool(metersrv_fi_tclBool& oBool);
   virtual tVoid vVisitString(metersrv_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(metersrv_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(metersrv_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_UnitType(metersrv_fi_tcl_e8_Meter_UnitType& o_e8_Meter_UnitType);
   virtual tVoid vVisit_e8_Meter_ConfigurationStatus(metersrv_fi_tcl_e8_Meter_ConfigurationStatus& o_e8_Meter_ConfigurationStatus);
   virtual tBool bDoExpand_Meter_VersionInfo(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_UnitConnectionStatus(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_UnitConfiguration(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_UnitVersion(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_UnitDataTransmissionStatus(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8VersionInfo(metersrv_fi_tcl_e8VersionInfo& o_e8VersionInfo);
   virtual tVoid vVisit_e8_Meter_SupportedFunction(metersrv_fi_tcl_e8_Meter_SupportedFunction& o_e8_Meter_SupportedFunction);
   virtual tVoid vVisit_e8_Meter_Language(metersrv_fi_tcl_e8_Meter_Language& o_e8_Meter_Language);
   virtual tVoid vVisit_e8_Meter_Language_Action(metersrv_fi_tcl_e8_Meter_Language_Action& o_e8_Meter_Language_Action);
   virtual tVoid vVisit_e8_Lang_Sync_Mode_Type(metersrv_fi_tcl_e8_Lang_Sync_Mode_Type& o_e8_Lang_Sync_Mode_Type);
   virtual tVoid vVisit_e8_Meter_Language_Status(metersrv_fi_tcl_e8_Meter_Language_Status& o_e8_Meter_Language_Status);
   virtual tVoid vVisit_e8_Meter_RequestedLanguageResult(metersrv_fi_tcl_e8_Meter_RequestedLanguageResult& o_e8_Meter_RequestedLanguageResult);
   virtual tVoid vVisit_e8_Meter_DistanceUnit(metersrv_fi_tcl_e8_Meter_DistanceUnit& o_e8_Meter_DistanceUnit);
   virtual tVoid vVisit_e8_Meter_FuelConsumptionUnit(metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit& o_e8_Meter_FuelConsumptionUnit);
   virtual tVoid vVisit_e8_Meter_TemperatureUnit(metersrv_fi_tcl_e8_Meter_TemperatureUnit& o_e8_Meter_TemperatureUnit);
   virtual tVoid vVisit_e8_Meter_PressureUnit(metersrv_fi_tcl_e8_Meter_PressureUnit& o_e8_Meter_PressureUnit);
   virtual tVoid vVisit_e8_Meter_Switch(metersrv_fi_tcl_e8_Meter_Switch& o_e8_Meter_Switch);
   virtual tVoid vVisit_e8_Meter_Eco_Drive(metersrv_fi_tcl_e8_Meter_Eco_Drive& o_e8_Meter_Eco_Drive);
   virtual tVoid vVisit_e8_Meter_Low_Temp(metersrv_fi_tcl_e8_Meter_Low_Temp& o_e8_Meter_Low_Temp);
   virtual tVoid vVisit_e8_ProPilot_Meter_Switch(metersrv_fi_tcl_e8_ProPilot_Meter_Switch& o_e8_ProPilot_Meter_Switch);
   virtual tVoid vVisit_e8_ProPilot_State_Switch(metersrv_fi_tcl_e8_ProPilot_State_Switch& o_e8_ProPilot_State_Switch);
   virtual tVoid vVisit_e8_Meter_ECO_Accel(metersrv_fi_tcl_e8_Meter_ECO_Accel& o_e8_Meter_ECO_Accel);
   virtual tVoid vVisit_e8_Meter_ReceivedDataErrorCode(metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode& o_e8_Meter_ReceivedDataErrorCode);
   virtual tBool bDoExpand_Meter_Audio_NoData(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_RadioSource(metersrv_fi_tcl_e8_Meter_Audio_RadioSource& o_e8_Meter_Audio_RadioSource);
   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoUpdate(metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate& o_e8_Meter_Audio_HDRadioSourceInfoUpdate);
   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoName(metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName& o_e8_Meter_Audio_HDRadioSourceInfoName);
   virtual tBool bDoExpand_e8_Meter_Audio_HDRadioSource(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_RadioLabelType(metersrv_fi_tcl_e8_Meter_Audio_RadioLabelType& o_e8_Meter_Audio_RadioLabelType);
   virtual tBool bDoExpand_Meter_Audio_RadioLabel(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_RadioFrequencyUnit(metersrv_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit& o_e8_Meter_Audio_RadioFrequencyUnit);
   virtual tBool bDoExpand_Meter_Audio_RadioFrequency(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_RadioCategoryType(metersrv_fi_tcl_e8_Meter_Audio_RadioCategoryType& o_e8_Meter_Audio_RadioCategoryType);
   virtual tBool bDoExpand_Meter_Audio_RadioCategory(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_RadioData(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_HDRadioData(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_DTVSourceInfoUpdate(metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoUpdate& o_e8_Meter_Audio_DTVSourceInfoUpdate);
   virtual tVoid vVisit_e8_Meter_Audio_DTVSourceInfoName(metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoName& o_e8_Meter_Audio_DTVSourceInfoName);
   virtual tBool bDoExpand_e8_Meter_Audio_DTVSource(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_DTVFrequency(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_DTVLabelType(metersrv_fi_tcl_e8_Meter_Audio_DTVLabelType& o_e8_Meter_Audio_DTVLabelType);
   virtual tBool bDoExpand_Meter_Audio_DTVLabel(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_DTVData(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_MediaType(metersrv_fi_tcl_e8_Meter_Audio_MediaType& o_e8_Meter_Audio_MediaType);
   virtual tVoid vVisit_e8_Meter_Audio_TrackLabelType(metersrv_fi_tcl_e8_Meter_Audio_TrackLabelType& o_e8_Meter_Audio_TrackLabelType);
   virtual tBool bDoExpand_Meter_Audio_TrackInfo(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_GroupLabelType(metersrv_fi_tcl_e8_Meter_Audio_GroupLabelType& o_e8_Meter_Audio_GroupLabelType);
   virtual tBool bDoExpand_Meter_Audio_GroupInfo(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_ArtistLabelType(metersrv_fi_tcl_e8_Meter_Audio_ArtistLabelType& o_e8_Meter_Audio_ArtistLabelType);
   virtual tBool bDoExpand_Meter_Audio_ArtistInfo(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_MediaData(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_AuxType(metersrv_fi_tcl_e8_Meter_Audio_AuxType& o_e8_Meter_Audio_AuxType);
   virtual tBool bDoExpand_Meter_Audio_AuxData(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_ExternalSoundData(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_Audio_InternetRadioData(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_SourceInfoType(metersrv_fi_tcl_e8_Meter_Audio_SourceInfoType& o_e8_Meter_Audio_SourceInfoType);
   virtual tBool bDoExpand_Meter_Audio_SourceInfoUnion(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_Audio_WarningSource(metersrv_fi_tcl_e8_Meter_Audio_WarningSource& o_e8_Meter_Audio_WarningSource);
   virtual tVoid vVisit_e8_Meter_Audio_WarningState(metersrv_fi_tcl_e8_Meter_Audio_WarningState& o_e8_Meter_Audio_WarningState);
   virtual tVoid vVisit_e8_Meter_Audio_SpecialMode(metersrv_fi_tcl_e8_Meter_Audio_SpecialMode& o_e8_Meter_Audio_SpecialMode);
   virtual tVoid vVisit_e8_Meter_Audio_SourceType(metersrv_fi_tcl_e8_Meter_Audio_SourceType& o_e8_Meter_Audio_SourceType);
   virtual tVoid vVisit_e8_Meter_Current_Radio_Mode(metersrv_fi_tcl_e8_Meter_Current_Radio_Mode& o_e8_Meter_Current_Radio_Mode);
   virtual tVoid vVisit_e8_meter_Renault_Update_List_Value(metersrv_fi_tcl_e8_meter_Renault_Update_List_Value& o_e8_meter_Renault_Update_List_Value);
   virtual tVoid vVisit_e8_NavStatus(metersrv_fi_tcl_e8_NavStatus& o_e8_NavStatus);
   virtual tVoid vVisit_e8_RoadClass(metersrv_fi_tcl_e8_RoadClass& o_e8_RoadClass);
   virtual tVoid vVisit_e8_DistanceUnit(metersrv_fi_tcl_e8_DistanceUnit& o_e8_DistanceUnit);
   virtual tVoid vVisit_e8_ManeuverSymbol(metersrv_fi_tcl_e8_ManeuverSymbol& o_e8_ManeuverSymbol);
   virtual tVoid vVisit_e8_SpeedUnit(metersrv_fi_tcl_e8_SpeedUnit& o_e8_SpeedUnit);
   virtual tVoid vVisit_e8_ManeuverRecommendationType(metersrv_fi_tcl_e8_ManeuverRecommendationType& o_e8_ManeuverRecommendationType);
   virtual tVoid vVisit_e8_EstimatedTimeType(metersrv_fi_tcl_e8_EstimatedTimeType& o_e8_EstimatedTimeType);
   virtual tVoid vVisit_e8_TimeType(metersrv_fi_tcl_e8_TimeType& o_e8_TimeType);
   virtual tVoid vVisit_e8_TimeFormat(metersrv_fi_tcl_e8_TimeFormat& o_e8_TimeFormat);
   virtual tVoid vVisit_e8_ManeuverView(metersrv_fi_tcl_e8_ManeuverView& o_e8_ManeuverView);
   virtual tVoid vVisit_e8_DeformedImageRoad(metersrv_fi_tcl_e8_DeformedImageRoad& o_e8_DeformedImageRoad);
   virtual tVoid vVisit_e8_DeformedImageArrow(metersrv_fi_tcl_e8_DeformedImageArrow& o_e8_DeformedImageArrow);
   virtual tVoid vVisit_e8_LaneStatus(metersrv_fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tBool bDoExpand_LaneRecommendation(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ArrivalInformation(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ScreenCoordinate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_AdminRoadClass(metersrv_fi_tcl_e8_AdminRoadClass& o_e8_AdminRoadClass);
   virtual tBool bDoExpand_IntersectionMapRoadLine(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_IntersectionMapCarsorState(metersrv_fi_tcl_e8_IntersectionMapCarsorState& o_e8_IntersectionMapCarsorState);
   virtual tVoid vVisit_e8_SpiNavigation_NavigationAppState(metersrv_fi_tcl_e8_SpiNavigation_NavigationAppState& o_e8_SpiNavigation_NavigationAppState);
   virtual tVoid vVisit_e8_SpiNavigation_TurnSide(metersrv_fi_tcl_e8_SpiNavigation_TurnSide& o_e8_SpiNavigation_TurnSide);
   virtual tVoid vVisit_e8_SpiNavigation_NextTurnEvent(metersrv_fi_tcl_e8_SpiNavigation_NextTurnEvent& o_e8_SpiNavigation_NextTurnEvent);
   virtual tVoid vVisit_e8_SpiNavigation_ManeuverDistanceUnits(metersrv_fi_tcl_e8_SpiNavigation_ManeuverDistanceUnits& o_e8_SpiNavigation_ManeuverDistanceUnits);
   virtual tVoid vVisit_e8_DistanceUnits(metersrv_fi_tcl_e8_DistanceUnits& o_e8_DistanceUnits);
   virtual tVoid vVisit_e8_TrafficEnforcement_TrafficEnforcementAlertState(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementAlertState& o_e8_TrafficEnforcement_TrafficEnforcementAlertState);
   virtual tVoid vVisit_e8_TrafficEnforcement_TrafficEnforcementCameraType(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementCameraType& o_e8_TrafficEnforcement_TrafficEnforcementCameraType);
   virtual tVoid vVisit_e8_TrafficEnforcement_TrafficEnforcementDistanceType(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementDistanceType& o_e8_TrafficEnforcement_TrafficEnforcementDistanceType);
   virtual tVoid vVisit_e8_DeviceCategory(metersrv_fi_tcl_e8_DeviceCategory& o_e8_DeviceCategory);
   virtual tVoid vVisit_e8_DiPoRouteGuidanceState(metersrv_fi_tcl_e8_DiPoRouteGuidanceState& o_e8_DiPoRouteGuidanceState);
   virtual tVoid vVisit_e8_AAutoTurnSide(metersrv_fi_tcl_e8_AAutoTurnSide& o_e8_AAutoTurnSide);
   virtual tVoid vVisit_e8_BDCLNavigationAppState(metersrv_fi_tcl_e8_BDCLNavigationAppState& o_e8_BDCLNavigationAppState);
   virtual tVoid vVisit_e8_MLGuidanceState(metersrv_fi_tcl_e8_MLGuidanceState& o_e8_MLGuidanceState);
   virtual tVoid vVisit_e8_MLNextDirection(metersrv_fi_tcl_e8_MLNextDirection& o_e8_MLNextDirection);
   virtual tBool bDoExpand_MLSpeedLimitUpdate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MLNavigationNextDistanceUpdate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MLNavigationTripInfoUpdate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MLGuidanceActive(metersrv_fi_tcl_e8_MLGuidanceActive& o_e8_MLGuidanceActive);
   virtual tBool bDoExpand_MLNavigationInfoUpdate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MLNavigationNextManeuverUpdate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MLTBTUpdate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DiPoManeuverState(metersrv_fi_tcl_e8_DiPoManeuverState& o_e8_DiPoManeuverState);
   virtual tBool bDoExpand_DiPORouteGuidanceUpdate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DiPoManeuverType(metersrv_fi_tcl_e8_DiPoManeuverType& o_e8_DiPoManeuverType);
   virtual tVoid vVisit_e8_DiPoDrivingSide(metersrv_fi_tcl_e8_DiPoDrivingSide& o_e8_DiPoDrivingSide);
   virtual tVoid vVisit_e8_DiPoJunctionType(metersrv_fi_tcl_e8_DiPoJunctionType& o_e8_DiPoJunctionType);
   virtual tBool bDoExpand_DiPORouteGuidanceManeuverUpdate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CarPlayTBTUpdate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_AAutoNextTurnEvent(metersrv_fi_tcl_e8_AAutoNextTurnEvent& o_e8_AAutoNextTurnEvent);
   virtual tBool bDoExpand_AAutoNavigationNextTurnData(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AAutoNavigationNextTurnDistanceData(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_AAutoNavigationAppState(metersrv_fi_tcl_e8_AAutoNavigationAppState& o_e8_AAutoNavigationAppState);
   virtual tBool bDoExpand_AAutoTBTUpdate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_BDCLNextTurnType(metersrv_fi_tcl_e8_BDCLNextTurnType& o_e8_BDCLNextTurnType);
   virtual tBool bDoExpand_CarlifeNaviNextTurnInfo(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_BDCLAssistantType(metersrv_fi_tcl_e8_BDCLAssistantType& o_e8_BDCLAssistantType);
   virtual tVoid vVisit_e8_BDCLTrafficSignType(metersrv_fi_tcl_e8_BDCLTrafficSignType& o_e8_BDCLTrafficSignType);
   virtual tBool bDoExpand_CarlifeNaviAssistantGuideInfo(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BDCLTBTUpdate(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_WeatherInformationSource(metersrv_fi_tcl_e8_WeatherInformationSource& o_e8_WeatherInformationSource);
   virtual tVoid vVisit_e8_CloudCoverage(metersrv_fi_tcl_e8_CloudCoverage& o_e8_CloudCoverage);
   virtual tVoid vVisit_e8_UVIndex(metersrv_fi_tcl_e8_UVIndex& o_e8_UVIndex);
   virtual tVoid vVisit_e8_WeatherSituation(metersrv_fi_tcl_e8_WeatherSituation& o_e8_WeatherSituation);
   virtual tVoid vVisit_e8_WeatherSeverity(metersrv_fi_tcl_e8_WeatherSeverity& o_e8_WeatherSeverity);
   virtual tBool bDoExpand_WeatherReport(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherReportInfo(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_SWSC_KeyCode(metersrv_fi_tcl_e8_Meter_SWSC_KeyCode& o_e8_Meter_SWSC_KeyCode);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_State(metersrv_fi_tcl_e8_Meter_Phone_SMS_State& o_e8_Meter_Phone_SMS_State);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_Selected_Menu(metersrv_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu& o_e8_Meter_Phone_SMS_Selected_Menu);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_PopupType(metersrv_fi_tcl_e8_Meter_Phone_SMS_PopupType& o_e8_Meter_Phone_SMS_PopupType);
   virtual tVoid vVisit_e8_meter_Phone_SMS_Action(metersrv_fi_tcl_e8_meter_Phone_SMS_Action& o_e8_meter_Phone_SMS_Action);
   virtual tVoid vVisit_e8_meter_SmsTextTypes(metersrv_fi_tcl_e8_meter_SmsTextTypes& o_e8_meter_SmsTextTypes);
   virtual tVoid vVisit_e8_MeterCallStatus(metersrv_fi_tcl_e8_MeterCallStatus& o_e8_MeterCallStatus);
   virtual tVoid vVisit_e8_meter_Phone_SMS_Command(metersrv_fi_tcl_e8_meter_Phone_SMS_Command& o_e8_meter_Phone_SMS_Command);
   virtual tVoid vVisit_e8_MeterCallType(metersrv_fi_tcl_e8_MeterCallType& o_e8_MeterCallType);
   virtual tBool bDoExpand_Meter_PhoneCallInfoList(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Meter_PhoneTextTranslation(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MsgMessageHandle(metersrv_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Meter_VR_State(metersrv_fi_tcl_e8_Meter_VR_State& o_e8_Meter_VR_State);
   virtual tVoid vVisit_e8_Meter_PowerState(metersrv_fi_tcl_e8_Meter_PowerState& o_e8_Meter_PowerState);
   virtual tVoid vVisit_e8_Meter_TimeInfoType(metersrv_fi_tcl_e8_Meter_TimeInfoType& o_e8_Meter_TimeInfoType);
   virtual tVoid vVisit_e8_Meter_PhoneCall_Menu_Action(metersrv_fi_tcl_e8_Meter_PhoneCall_Menu_Action& o_e8_Meter_PhoneCall_Menu_Action);
   virtual tVoid vVisit_e8_Meter_PhoneCall_State(metersrv_fi_tcl_e8_Meter_PhoneCall_State& o_e8_Meter_PhoneCall_State);
   virtual tVoid vVisit_e8_Language_InvalidParameter(metersrv_fi_tcl_e8_Language_InvalidParameter& o_e8_Language_InvalidParameter);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   metersrv_fi_tclOutput* poOutput;
};


class MY_DECL metersrv_mainfi_tclRandomInitVisitor : public metersrv_mainfi_tclVisitorBase {
public:

   metersrv_mainfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(metersrv_fi_tclU8& oU8);
   virtual tVoid vVisitS8(metersrv_fi_tclS8& oS8);
   virtual tVoid vVisitU16(metersrv_fi_tclU16& oU16);
   virtual tVoid vVisitS16(metersrv_fi_tclS16& oS16);
   virtual tVoid vVisitU24(metersrv_fi_tclU24& oU24);
   virtual tVoid vVisitS24(metersrv_fi_tclS24& oS24);
   virtual tVoid vVisitU32(metersrv_fi_tclU32& oU32);
   virtual tVoid vVisitS32(metersrv_fi_tclS32& oS32);
   virtual tVoid vVisitU64(metersrv_fi_tclU64& oU64);
   virtual tVoid vVisitS64(metersrv_fi_tclS64& oS64);
   virtual tVoid vVisitBool(metersrv_fi_tclBool& oBool);
   virtual tVoid vVisitString(metersrv_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(metersrv_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(metersrv_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e8_Meter_UnitType(metersrv_fi_tcl_e8_Meter_UnitType& o_e8_Meter_UnitType);
   virtual tVoid vVisit_e8_Meter_ConfigurationStatus(metersrv_fi_tcl_e8_Meter_ConfigurationStatus& o_e8_Meter_ConfigurationStatus);
   virtual tVoid vVisit_e8VersionInfo(metersrv_fi_tcl_e8VersionInfo& o_e8VersionInfo);
   virtual tVoid vVisit_e8_Meter_SupportedFunction(metersrv_fi_tcl_e8_Meter_SupportedFunction& o_e8_Meter_SupportedFunction);
   virtual tVoid vVisit_e8_Meter_Language(metersrv_fi_tcl_e8_Meter_Language& o_e8_Meter_Language);
   virtual tVoid vVisit_e8_Meter_Language_Action(metersrv_fi_tcl_e8_Meter_Language_Action& o_e8_Meter_Language_Action);
   virtual tVoid vVisit_e8_Lang_Sync_Mode_Type(metersrv_fi_tcl_e8_Lang_Sync_Mode_Type& o_e8_Lang_Sync_Mode_Type);
   virtual tVoid vVisit_e8_Meter_Language_Status(metersrv_fi_tcl_e8_Meter_Language_Status& o_e8_Meter_Language_Status);
   virtual tVoid vVisit_e8_Meter_RequestedLanguageResult(metersrv_fi_tcl_e8_Meter_RequestedLanguageResult& o_e8_Meter_RequestedLanguageResult);
   virtual tVoid vVisit_e8_Meter_DistanceUnit(metersrv_fi_tcl_e8_Meter_DistanceUnit& o_e8_Meter_DistanceUnit);
   virtual tVoid vVisit_e8_Meter_FuelConsumptionUnit(metersrv_fi_tcl_e8_Meter_FuelConsumptionUnit& o_e8_Meter_FuelConsumptionUnit);
   virtual tVoid vVisit_e8_Meter_TemperatureUnit(metersrv_fi_tcl_e8_Meter_TemperatureUnit& o_e8_Meter_TemperatureUnit);
   virtual tVoid vVisit_e8_Meter_PressureUnit(metersrv_fi_tcl_e8_Meter_PressureUnit& o_e8_Meter_PressureUnit);
   virtual tVoid vVisit_e8_Meter_Switch(metersrv_fi_tcl_e8_Meter_Switch& o_e8_Meter_Switch);
   virtual tVoid vVisit_e8_Meter_Eco_Drive(metersrv_fi_tcl_e8_Meter_Eco_Drive& o_e8_Meter_Eco_Drive);
   virtual tVoid vVisit_e8_Meter_Low_Temp(metersrv_fi_tcl_e8_Meter_Low_Temp& o_e8_Meter_Low_Temp);
   virtual tVoid vVisit_e8_ProPilot_Meter_Switch(metersrv_fi_tcl_e8_ProPilot_Meter_Switch& o_e8_ProPilot_Meter_Switch);
   virtual tVoid vVisit_e8_ProPilot_State_Switch(metersrv_fi_tcl_e8_ProPilot_State_Switch& o_e8_ProPilot_State_Switch);
   virtual tVoid vVisit_e8_Meter_ECO_Accel(metersrv_fi_tcl_e8_Meter_ECO_Accel& o_e8_Meter_ECO_Accel);
   virtual tVoid vVisit_e8_Meter_ReceivedDataErrorCode(metersrv_fi_tcl_e8_Meter_ReceivedDataErrorCode& o_e8_Meter_ReceivedDataErrorCode);
   virtual tVoid vVisit_e8_Meter_Audio_RadioSource(metersrv_fi_tcl_e8_Meter_Audio_RadioSource& o_e8_Meter_Audio_RadioSource);
   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoUpdate(metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate& o_e8_Meter_Audio_HDRadioSourceInfoUpdate);
   virtual tVoid vVisit_e8_Meter_Audio_HDRadioSourceInfoName(metersrv_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName& o_e8_Meter_Audio_HDRadioSourceInfoName);
   virtual tVoid vVisit_e8_Meter_Audio_RadioLabelType(metersrv_fi_tcl_e8_Meter_Audio_RadioLabelType& o_e8_Meter_Audio_RadioLabelType);
   virtual tVoid vVisit_e8_Meter_Audio_RadioFrequencyUnit(metersrv_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit& o_e8_Meter_Audio_RadioFrequencyUnit);
   virtual tVoid vVisit_e8_Meter_Audio_RadioCategoryType(metersrv_fi_tcl_e8_Meter_Audio_RadioCategoryType& o_e8_Meter_Audio_RadioCategoryType);
   virtual tVoid vVisit_e8_Meter_Audio_DTVSourceInfoUpdate(metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoUpdate& o_e8_Meter_Audio_DTVSourceInfoUpdate);
   virtual tVoid vVisit_e8_Meter_Audio_DTVSourceInfoName(metersrv_fi_tcl_e8_Meter_Audio_DTVSourceInfoName& o_e8_Meter_Audio_DTVSourceInfoName);
   virtual tVoid vVisit_e8_Meter_Audio_DTVLabelType(metersrv_fi_tcl_e8_Meter_Audio_DTVLabelType& o_e8_Meter_Audio_DTVLabelType);
   virtual tVoid vVisit_e8_Meter_Audio_MediaType(metersrv_fi_tcl_e8_Meter_Audio_MediaType& o_e8_Meter_Audio_MediaType);
   virtual tVoid vVisit_e8_Meter_Audio_TrackLabelType(metersrv_fi_tcl_e8_Meter_Audio_TrackLabelType& o_e8_Meter_Audio_TrackLabelType);
   virtual tVoid vVisit_e8_Meter_Audio_GroupLabelType(metersrv_fi_tcl_e8_Meter_Audio_GroupLabelType& o_e8_Meter_Audio_GroupLabelType);
   virtual tVoid vVisit_e8_Meter_Audio_ArtistLabelType(metersrv_fi_tcl_e8_Meter_Audio_ArtistLabelType& o_e8_Meter_Audio_ArtistLabelType);
   virtual tVoid vVisit_e8_Meter_Audio_AuxType(metersrv_fi_tcl_e8_Meter_Audio_AuxType& o_e8_Meter_Audio_AuxType);
   virtual tVoid vVisit_e8_Meter_Audio_SourceInfoType(metersrv_fi_tcl_e8_Meter_Audio_SourceInfoType& o_e8_Meter_Audio_SourceInfoType);
   virtual tVoid vVisit_e8_Meter_Audio_WarningSource(metersrv_fi_tcl_e8_Meter_Audio_WarningSource& o_e8_Meter_Audio_WarningSource);
   virtual tVoid vVisit_e8_Meter_Audio_WarningState(metersrv_fi_tcl_e8_Meter_Audio_WarningState& o_e8_Meter_Audio_WarningState);
   virtual tVoid vVisit_e8_Meter_Audio_SpecialMode(metersrv_fi_tcl_e8_Meter_Audio_SpecialMode& o_e8_Meter_Audio_SpecialMode);
   virtual tVoid vVisit_e8_Meter_Audio_SourceType(metersrv_fi_tcl_e8_Meter_Audio_SourceType& o_e8_Meter_Audio_SourceType);
   virtual tVoid vVisit_e8_Meter_Current_Radio_Mode(metersrv_fi_tcl_e8_Meter_Current_Radio_Mode& o_e8_Meter_Current_Radio_Mode);
   virtual tVoid vVisit_e8_meter_Renault_Update_List_Value(metersrv_fi_tcl_e8_meter_Renault_Update_List_Value& o_e8_meter_Renault_Update_List_Value);
   virtual tVoid vVisit_e8_NavStatus(metersrv_fi_tcl_e8_NavStatus& o_e8_NavStatus);
   virtual tVoid vVisit_e8_RoadClass(metersrv_fi_tcl_e8_RoadClass& o_e8_RoadClass);
   virtual tVoid vVisit_e8_DistanceUnit(metersrv_fi_tcl_e8_DistanceUnit& o_e8_DistanceUnit);
   virtual tVoid vVisit_e8_ManeuverSymbol(metersrv_fi_tcl_e8_ManeuverSymbol& o_e8_ManeuverSymbol);
   virtual tVoid vVisit_e8_SpeedUnit(metersrv_fi_tcl_e8_SpeedUnit& o_e8_SpeedUnit);
   virtual tVoid vVisit_e8_ManeuverRecommendationType(metersrv_fi_tcl_e8_ManeuverRecommendationType& o_e8_ManeuverRecommendationType);
   virtual tVoid vVisit_e8_EstimatedTimeType(metersrv_fi_tcl_e8_EstimatedTimeType& o_e8_EstimatedTimeType);
   virtual tVoid vVisit_e8_TimeType(metersrv_fi_tcl_e8_TimeType& o_e8_TimeType);
   virtual tVoid vVisit_e8_TimeFormat(metersrv_fi_tcl_e8_TimeFormat& o_e8_TimeFormat);
   virtual tVoid vVisit_e8_ManeuverView(metersrv_fi_tcl_e8_ManeuverView& o_e8_ManeuverView);
   virtual tVoid vVisit_e8_DeformedImageRoad(metersrv_fi_tcl_e8_DeformedImageRoad& o_e8_DeformedImageRoad);
   virtual tVoid vVisit_e8_DeformedImageArrow(metersrv_fi_tcl_e8_DeformedImageArrow& o_e8_DeformedImageArrow);
   virtual tVoid vVisit_e8_LaneStatus(metersrv_fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tVoid vVisit_e8_AdminRoadClass(metersrv_fi_tcl_e8_AdminRoadClass& o_e8_AdminRoadClass);
   virtual tVoid vVisit_e8_IntersectionMapCarsorState(metersrv_fi_tcl_e8_IntersectionMapCarsorState& o_e8_IntersectionMapCarsorState);
   virtual tVoid vVisit_e8_SpiNavigation_NavigationAppState(metersrv_fi_tcl_e8_SpiNavigation_NavigationAppState& o_e8_SpiNavigation_NavigationAppState);
   virtual tVoid vVisit_e8_SpiNavigation_TurnSide(metersrv_fi_tcl_e8_SpiNavigation_TurnSide& o_e8_SpiNavigation_TurnSide);
   virtual tVoid vVisit_e8_SpiNavigation_NextTurnEvent(metersrv_fi_tcl_e8_SpiNavigation_NextTurnEvent& o_e8_SpiNavigation_NextTurnEvent);
   virtual tVoid vVisit_e8_SpiNavigation_ManeuverDistanceUnits(metersrv_fi_tcl_e8_SpiNavigation_ManeuverDistanceUnits& o_e8_SpiNavigation_ManeuverDistanceUnits);
   virtual tVoid vVisit_e8_DistanceUnits(metersrv_fi_tcl_e8_DistanceUnits& o_e8_DistanceUnits);
   virtual tVoid vVisit_e8_TrafficEnforcement_TrafficEnforcementAlertState(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementAlertState& o_e8_TrafficEnforcement_TrafficEnforcementAlertState);
   virtual tVoid vVisit_e8_TrafficEnforcement_TrafficEnforcementCameraType(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementCameraType& o_e8_TrafficEnforcement_TrafficEnforcementCameraType);
   virtual tVoid vVisit_e8_TrafficEnforcement_TrafficEnforcementDistanceType(metersrv_fi_tcl_e8_TrafficEnforcement_TrafficEnforcementDistanceType& o_e8_TrafficEnforcement_TrafficEnforcementDistanceType);
   virtual tVoid vVisit_e8_DeviceCategory(metersrv_fi_tcl_e8_DeviceCategory& o_e8_DeviceCategory);
   virtual tVoid vVisit_e8_DiPoRouteGuidanceState(metersrv_fi_tcl_e8_DiPoRouteGuidanceState& o_e8_DiPoRouteGuidanceState);
   virtual tVoid vVisit_e8_AAutoTurnSide(metersrv_fi_tcl_e8_AAutoTurnSide& o_e8_AAutoTurnSide);
   virtual tVoid vVisit_e8_BDCLNavigationAppState(metersrv_fi_tcl_e8_BDCLNavigationAppState& o_e8_BDCLNavigationAppState);
   virtual tVoid vVisit_e8_MLGuidanceState(metersrv_fi_tcl_e8_MLGuidanceState& o_e8_MLGuidanceState);
   virtual tVoid vVisit_e8_MLNextDirection(metersrv_fi_tcl_e8_MLNextDirection& o_e8_MLNextDirection);
   virtual tVoid vVisit_e8_MLGuidanceActive(metersrv_fi_tcl_e8_MLGuidanceActive& o_e8_MLGuidanceActive);
   virtual tVoid vVisit_e8_DiPoManeuverState(metersrv_fi_tcl_e8_DiPoManeuverState& o_e8_DiPoManeuverState);
   virtual tVoid vVisit_e8_DiPoManeuverType(metersrv_fi_tcl_e8_DiPoManeuverType& o_e8_DiPoManeuverType);
   virtual tVoid vVisit_e8_DiPoDrivingSide(metersrv_fi_tcl_e8_DiPoDrivingSide& o_e8_DiPoDrivingSide);
   virtual tVoid vVisit_e8_DiPoJunctionType(metersrv_fi_tcl_e8_DiPoJunctionType& o_e8_DiPoJunctionType);
   virtual tVoid vVisit_e8_AAutoNextTurnEvent(metersrv_fi_tcl_e8_AAutoNextTurnEvent& o_e8_AAutoNextTurnEvent);
   virtual tVoid vVisit_e8_AAutoNavigationAppState(metersrv_fi_tcl_e8_AAutoNavigationAppState& o_e8_AAutoNavigationAppState);
   virtual tVoid vVisit_e8_BDCLNextTurnType(metersrv_fi_tcl_e8_BDCLNextTurnType& o_e8_BDCLNextTurnType);
   virtual tVoid vVisit_e8_BDCLAssistantType(metersrv_fi_tcl_e8_BDCLAssistantType& o_e8_BDCLAssistantType);
   virtual tVoid vVisit_e8_BDCLTrafficSignType(metersrv_fi_tcl_e8_BDCLTrafficSignType& o_e8_BDCLTrafficSignType);
   virtual tVoid vVisit_e8_WeatherInformationSource(metersrv_fi_tcl_e8_WeatherInformationSource& o_e8_WeatherInformationSource);
   virtual tVoid vVisit_e8_CloudCoverage(metersrv_fi_tcl_e8_CloudCoverage& o_e8_CloudCoverage);
   virtual tVoid vVisit_e8_UVIndex(metersrv_fi_tcl_e8_UVIndex& o_e8_UVIndex);
   virtual tVoid vVisit_e8_WeatherSituation(metersrv_fi_tcl_e8_WeatherSituation& o_e8_WeatherSituation);
   virtual tVoid vVisit_e8_WeatherSeverity(metersrv_fi_tcl_e8_WeatherSeverity& o_e8_WeatherSeverity);
   virtual tVoid vVisit_e8_Meter_SWSC_KeyCode(metersrv_fi_tcl_e8_Meter_SWSC_KeyCode& o_e8_Meter_SWSC_KeyCode);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_State(metersrv_fi_tcl_e8_Meter_Phone_SMS_State& o_e8_Meter_Phone_SMS_State);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_Selected_Menu(metersrv_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu& o_e8_Meter_Phone_SMS_Selected_Menu);
   virtual tVoid vVisit_e8_Meter_Phone_SMS_PopupType(metersrv_fi_tcl_e8_Meter_Phone_SMS_PopupType& o_e8_Meter_Phone_SMS_PopupType);
   virtual tVoid vVisit_e8_meter_Phone_SMS_Action(metersrv_fi_tcl_e8_meter_Phone_SMS_Action& o_e8_meter_Phone_SMS_Action);
   virtual tVoid vVisit_e8_meter_SmsTextTypes(metersrv_fi_tcl_e8_meter_SmsTextTypes& o_e8_meter_SmsTextTypes);
   virtual tVoid vVisit_e8_MeterCallStatus(metersrv_fi_tcl_e8_MeterCallStatus& o_e8_MeterCallStatus);
   virtual tVoid vVisit_e8_meter_Phone_SMS_Command(metersrv_fi_tcl_e8_meter_Phone_SMS_Command& o_e8_meter_Phone_SMS_Command);
   virtual tVoid vVisit_e8_MeterCallType(metersrv_fi_tcl_e8_MeterCallType& o_e8_MeterCallType);
   virtual tVoid vVisit_e8_Meter_VR_State(metersrv_fi_tcl_e8_Meter_VR_State& o_e8_Meter_VR_State);
   virtual tVoid vVisit_e8_Meter_PowerState(metersrv_fi_tcl_e8_Meter_PowerState& o_e8_Meter_PowerState);
   virtual tVoid vVisit_e8_Meter_TimeInfoType(metersrv_fi_tcl_e8_Meter_TimeInfoType& o_e8_Meter_TimeInfoType);
   virtual tVoid vVisit_e8_Meter_PhoneCall_Menu_Action(metersrv_fi_tcl_e8_Meter_PhoneCall_Menu_Action& o_e8_Meter_PhoneCall_Menu_Action);
   virtual tVoid vVisit_e8_Meter_PhoneCall_State(metersrv_fi_tcl_e8_Meter_PhoneCall_State& o_e8_Meter_PhoneCall_State);
   virtual tVoid vVisit_e8_Language_InvalidParameter(metersrv_fi_tcl_e8_Language_InvalidParameter& o_e8_Language_InvalidParameter);
	tU32 u32ListSize;
};

#endif
