/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define MASCF_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "mascf_fi_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 mascf_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 mascf_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 mascf_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 mascf_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 mascf_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 mascf_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 mascf_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 mascf_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 mascf_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 mascf_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 mascf_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& mascf_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 mascf_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& mascf_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 mascf_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid mascf_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tclString::~mascf_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

mascf_fi_tclString& mascf_fi_tclString::operator=(const mascf_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

mascf_fi_tclString::mascf_fi_tclString(const mascf_fi_tclString& coRef):mascf_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& mascf_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool mascf_fi_tclString::operator==(const mascf_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 mascf_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
mascf_fi_tclString& mascf_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
mascf_fi_tclString::mascf_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool mascf_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

mascf_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

mascf_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool mascf_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar mascf_FI_C_U8_NULLCHAR = '\0';

tChar* mascf_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* mascf_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* mascf_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& mascf_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return mascf_FI_C_U8_NULLCHAR;
}

tChar& mascf_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return mascf_FI_C_U8_NULLCHAR;
}

tChar& mascf_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return mascf_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool mascf_fi_tclString::bSet(const mascf_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool mascf_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString mascf_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& mascf_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool mascf_fi_tclList::operator==(const mascf_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 mascf_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mascf_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid mascf_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tclMultiLanguageString::~mascf_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

mascf_fi_tclMultiLanguageString& mascf_fi_tclMultiLanguageString::operator=(const mascf_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

mascf_fi_tclMultiLanguageString::mascf_fi_tclMultiLanguageString(const mascf_fi_tclMultiLanguageString& coRef):mascf_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& mascf_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool mascf_fi_tclMultiLanguageString::operator==(const mascf_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 mascf_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
mascf_fi_tclMultiLanguageString& mascf_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
mascf_fi_tclMultiLanguageString::mascf_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool mascf_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

mascf_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

mascf_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool mascf_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* mascf_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* mascf_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* mascf_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& mascf_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return mascf_FI_C_U8_NULLCHAR;
}

tChar& mascf_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return mascf_FI_C_U8_NULLCHAR;
}

tChar& mascf_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return mascf_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool mascf_fi_tclMultiLanguageString::bSet(const mascf_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool mascf_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString mascf_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_BinContainer::mascf_fi_tcl_BinContainer(const mascf_fi_tcl_BinContainer& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
mascf_fi_tcl_BinContainer& mascf_fi_tcl_BinContainer::operator=(const mascf_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

mascf_fi_tcl_BinContainer::mascf_fi_tcl_BinContainer()

 {}

tS32 mascf_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_BINCONTAINER;
}


mascf_fi_tcl_BinContainer::~mascf_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& mascf_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool mascf_fi_tcl_BinContainer::operator==(const mascf_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

mascf_fi_tcl_Reserved::mascf_fi_tcl_Reserved()
 {}

tS32 mascf_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_RESERVED;
}


mascf_fi_tcl_Reserved::~mascf_fi_tcl_Reserved()
{}

tU32 mascf_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& mascf_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_u8_Percent::mascf_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 mascf_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_U8_PERCENT;
}


mascf_fi_tcl_u8_Percent::~mascf_fi_tcl_u8_Percent()
{}

tU32 mascf_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& mascf_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s16_PerThousand::mascf_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 mascf_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


mascf_fi_tcl_s16_PerThousand::~mascf_fi_tcl_s16_PerThousand()
{}

tU32 mascf_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& mascf_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_u16_IndexInReferenceList::mascf_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 mascf_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


mascf_fi_tcl_u16_IndexInReferenceList::~mascf_fi_tcl_u16_IndexInReferenceList()
{}

tU32 mascf_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& mascf_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_u16_ErrorCode::mascf_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 mascf_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_U16_ERRORCODE;
}


mascf_fi_tcl_u16_ErrorCode::~mascf_fi_tcl_u16_ErrorCode()
{}

tU32 mascf_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& mascf_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_u16_RPM::mascf_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 mascf_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_U16_RPM;
}


mascf_fi_tcl_u16_RPM::~mascf_fi_tcl_u16_RPM()
{}

tU32 mascf_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& mascf_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Kilogram::mascf_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_KILOGRAM;
}


mascf_fi_tcl_s32_Kilogram::~mascf_fi_tcl_s32_Kilogram()
{}

tU32 mascf_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Pound::mascf_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_POUND;
}


mascf_fi_tcl_s32_Pound::~mascf_fi_tcl_s32_Pound()
{}

tU32 mascf_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s16_Meter::mascf_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 mascf_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S16_METER;
}


mascf_fi_tcl_s16_Meter::~mascf_fi_tcl_s16_Meter()
{}

tU32 mascf_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& mascf_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Meter::mascf_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_METER;
}


mascf_fi_tcl_s32_Meter::~mascf_fi_tcl_s32_Meter()
{}

tU32 mascf_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Yards::mascf_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_YARDS;
}


mascf_fi_tcl_s32_Yards::~mascf_fi_tcl_s32_Yards()
{}

tU32 mascf_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Foot::mascf_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_FOOT;
}


mascf_fi_tcl_s32_Foot::~mascf_fi_tcl_s32_Foot()
{}

tU32 mascf_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Centimeter::mascf_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_CENTIMETER;
}


mascf_fi_tcl_s32_Centimeter::~mascf_fi_tcl_s32_Centimeter()
{}

tU32 mascf_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Inch::mascf_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_INCH;
}


mascf_fi_tcl_s32_Inch::~mascf_fi_tcl_s32_Inch()
{}

tU32 mascf_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Millimeter::mascf_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_MILLIMETER;
}


mascf_fi_tcl_s32_Millimeter::~mascf_fi_tcl_s32_Millimeter()
{}

tU32 mascf_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Microliter::mascf_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_MICROLITER;
}


mascf_fi_tcl_s32_Microliter::~mascf_fi_tcl_s32_Microliter()
{}

tU32 mascf_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Second::mascf_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_SECOND;
}


mascf_fi_tcl_s32_Second::~mascf_fi_tcl_s32_Second()
{}

tU32 mascf_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_u16_MilliSecond::mascf_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 mascf_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_U16_MILLISECOND;
}


mascf_fi_tcl_u16_MilliSecond::~mascf_fi_tcl_u16_MilliSecond()
{}

tU32 mascf_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& mascf_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_MilliSecond::mascf_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_MILLISECOND;
}


mascf_fi_tcl_s32_MilliSecond::~mascf_fi_tcl_s32_MilliSecond()
{}

tU32 mascf_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_POSIXTime::mascf_fi_tcl_POSIXTime(const mascf_fi_tcl_POSIXTime& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
mascf_fi_tcl_POSIXTime& mascf_fi_tcl_POSIXTime::operator=(const mascf_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_POSIXTime::mascf_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 mascf_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_POSIXTIME;
}


mascf_fi_tcl_POSIXTime::~mascf_fi_tcl_POSIXTime()
{}

tU32 mascf_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool mascf_fi_tcl_POSIXTime::operator==(const mascf_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_DST_State::mascf_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 mascf_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_DST_STATE;
}


mascf_fi_tcl_e8_DST_State::~mascf_fi_tcl_e8_DST_State()
{}

tU32 mascf_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_TimeZoneElement::mascf_fi_tcl_TimeZoneElement(const mascf_fi_tcl_TimeZoneElement& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
mascf_fi_tcl_TimeZoneElement& mascf_fi_tcl_TimeZoneElement::operator=(const mascf_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

mascf_fi_tcl_TimeZoneElement::mascf_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 mascf_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


mascf_fi_tcl_TimeZoneElement::~mascf_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+ static_cast<tU32>(DST_TimeDomain.size()*1);
}

fi_tclInContext& mascf_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool mascf_fi_tcl_TimeZoneElement::operator==(const mascf_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s16_KmPerHour::mascf_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 mascf_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S16_KMPERHOUR;
}


mascf_fi_tcl_s16_KmPerHour::~mascf_fi_tcl_s16_KmPerHour()
{}

tU32 mascf_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& mascf_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s16_MilesPerHour::mascf_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 mascf_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


mascf_fi_tcl_s16_MilesPerHour::~mascf_fi_tcl_s16_MilesPerHour()
{}

tU32 mascf_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& mascf_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s16_Knot::mascf_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 mascf_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S16_KNOT;
}


mascf_fi_tcl_s16_Knot::~mascf_fi_tcl_s16_Knot()
{}

tU32 mascf_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& mascf_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s16_CentimeterSecond::mascf_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 mascf_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


mascf_fi_tcl_s16_CentimeterSecond::~mascf_fi_tcl_s16_CentimeterSecond()
{}

tU32 mascf_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& mascf_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s16_Kelvin::mascf_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 mascf_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S16_KELVIN;
}


mascf_fi_tcl_s16_Kelvin::~mascf_fi_tcl_s16_Kelvin()
{}

tU32 mascf_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& mascf_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s16_Fahrenheit::mascf_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 mascf_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


mascf_fi_tcl_s16_Fahrenheit::~mascf_fi_tcl_s16_Fahrenheit()
{}

tU32 mascf_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& mascf_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Pascal::mascf_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_PASCAL;
}


mascf_fi_tcl_s32_Pascal::~mascf_fi_tcl_s32_Pascal()
{}

tU32 mascf_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Watt::mascf_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_WATT;
}


mascf_fi_tcl_s32_Watt::~mascf_fi_tcl_s32_Watt()
{}

tU32 mascf_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_FIVersion::mascf_fi_tcl_FIVersion(const mascf_fi_tcl_FIVersion& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
mascf_fi_tcl_FIVersion& mascf_fi_tcl_FIVersion::operator=(const mascf_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_FIVersion::mascf_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 mascf_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_FIVERSION;
}


mascf_fi_tcl_FIVersion::~mascf_fi_tcl_FIVersion()
{}

tU32 mascf_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool mascf_fi_tcl_FIVersion::operator==(const mascf_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Longitude::mascf_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_LONGITUDE;
}


mascf_fi_tcl_s32_Longitude::~mascf_fi_tcl_s32_Longitude()
{}

tU32 mascf_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s32_Latitude::mascf_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 mascf_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S32_LATITUDE;
}


mascf_fi_tcl_s32_Latitude::~mascf_fi_tcl_s32_Latitude()
{}

tU32 mascf_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& mascf_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_PositionWGS84::mascf_fi_tcl_PositionWGS84(const mascf_fi_tcl_PositionWGS84& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
mascf_fi_tcl_PositionWGS84& mascf_fi_tcl_PositionWGS84::operator=(const mascf_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_PositionWGS84::mascf_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 mascf_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_POSITIONWGS84;
}


mascf_fi_tcl_PositionWGS84::~mascf_fi_tcl_PositionWGS84()
{}

tU32 mascf_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mascf_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool mascf_fi_tcl_PositionWGS84::operator==(const mascf_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_RectangleWGS84::mascf_fi_tcl_RectangleWGS84(const mascf_fi_tcl_RectangleWGS84& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
mascf_fi_tcl_RectangleWGS84& mascf_fi_tcl_RectangleWGS84::operator=(const mascf_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_RectangleWGS84::mascf_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 mascf_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_RECTANGLEWGS84;
}


mascf_fi_tcl_RectangleWGS84::~mascf_fi_tcl_RectangleWGS84()
{}

tU32 mascf_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& mascf_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool mascf_fi_tcl_RectangleWGS84::operator==(const mascf_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e16_ISOCountryCode::mascf_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 mascf_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


mascf_fi_tcl_e16_ISOCountryCode::~mascf_fi_tcl_e16_ISOCountryCode()
{}

tU32 mascf_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e16_ISOLanguageCode::mascf_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 mascf_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


mascf_fi_tcl_e16_ISOLanguageCode::~mascf_fi_tcl_e16_ISOLanguageCode()
{}

tU32 mascf_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_LanguageID::mascf_fi_tcl_LanguageID(const mascf_fi_tcl_LanguageID& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
mascf_fi_tcl_LanguageID& mascf_fi_tcl_LanguageID::operator=(const mascf_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_LanguageID::mascf_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 mascf_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_LANGUAGEID;
}


mascf_fi_tcl_LanguageID::~mascf_fi_tcl_LanguageID()
{}

tU32 mascf_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool mascf_fi_tcl_LanguageID::operator==(const mascf_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_u8_DirectionAbsolute::mascf_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 mascf_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


mascf_fi_tcl_u8_DirectionAbsolute::~mascf_fi_tcl_u8_DirectionAbsolute()
{}

tU32 mascf_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& mascf_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_u8_DirectionRelative::mascf_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 mascf_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


mascf_fi_tcl_u8_DirectionRelative::~mascf_fi_tcl_u8_DirectionRelative()
{}

tU32 mascf_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& mascf_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s16_CentiDegree::mascf_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 mascf_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


mascf_fi_tcl_s16_CentiDegree::~mascf_fi_tcl_s16_CentiDegree()
{}

tU32 mascf_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& mascf_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s16_Degree::mascf_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 mascf_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S16_DEGREE;
}


mascf_fi_tcl_s16_Degree::~mascf_fi_tcl_s16_Degree()
{}

tU32 mascf_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& mascf_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree::mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree::~mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_s16_DirectionRelative_CentiDegree::mascf_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 mascf_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


mascf_fi_tcl_s16_DirectionRelative_CentiDegree::~mascf_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 mascf_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& mascf_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_FuelType::mascf_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 mascf_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_FUELTYPE;
}


mascf_fi_tcl_e8_FuelType::~mascf_fi_tcl_e8_FuelType()
{}

tU32 mascf_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_DistTimeFuel::mascf_fi_tcl_DistTimeFuel(const mascf_fi_tcl_DistTimeFuel& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
mascf_fi_tcl_DistTimeFuel& mascf_fi_tcl_DistTimeFuel::operator=(const mascf_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_DistTimeFuel::mascf_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 mascf_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_DISTTIMEFUEL;
}


mascf_fi_tcl_DistTimeFuel::~mascf_fi_tcl_DistTimeFuel()
{}

tU32 mascf_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& mascf_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool mascf_fi_tcl_DistTimeFuel::operator==(const mascf_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e16_Aud_TroubleCode::mascf_fi_tcl_e16_Aud_TroubleCode():enType(FI_EN_VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED) {}

tS32 mascf_fi_tcl_e16_Aud_TroubleCode::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E16_AUD_TROUBLECODE;
}


mascf_fi_tcl_e16_Aud_TroubleCode::~mascf_fi_tcl_e16_Aud_TroubleCode()
{}

tU32 mascf_fi_tcl_e16_Aud_TroubleCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_e16_Aud_TroubleCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e16_Aud_TroubleCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_MonitoringMode::mascf_fi_tcl_e8_Aud_MonitoringMode():enType(FI_EN_FC_AUDIO_MONITORING_OFF) {}

tS32 mascf_fi_tcl_e8_Aud_MonitoringMode::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_MONITORINGMODE;
}


mascf_fi_tcl_e8_Aud_MonitoringMode::~mascf_fi_tcl_e8_Aud_MonitoringMode()
{}

tU32 mascf_fi_tcl_e8_Aud_MonitoringMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_MonitoringMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_MonitoringMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_SupervisionControl::mascf_fi_tcl_e8_Aud_SupervisionControl():enType(FI_EN_FC_AUDIO_SUPERVISION_DEFAULT) {}

tS32 mascf_fi_tcl_e8_Aud_SupervisionControl::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_SUPERVISIONCONTROL;
}


mascf_fi_tcl_e8_Aud_SupervisionControl::~mascf_fi_tcl_e8_Aud_SupervisionControl()
{}

tU32 mascf_fi_tcl_e8_Aud_SupervisionControl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_SupervisionControl::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_SupervisionControl::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_ErrorStatus::mascf_fi_tcl_e8_Aud_ErrorStatus():enType(FI_EN_FC_AUDIO_TEST_PASSED) {}

tS32 mascf_fi_tcl_e8_Aud_ErrorStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_ERRORSTATUS;
}


mascf_fi_tcl_e8_Aud_ErrorStatus::~mascf_fi_tcl_e8_Aud_ErrorStatus()
{}

tU32 mascf_fi_tcl_e8_Aud_ErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_ErrorStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_ErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_RoutineStatus::mascf_fi_tcl_e8_Aud_RoutineStatus():enType(FI_EN_FC_AUDIO_ROUTINE_NOT_RUNNING) {}

tS32 mascf_fi_tcl_e8_Aud_RoutineStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_ROUTINESTATUS;
}


mascf_fi_tcl_e8_Aud_RoutineStatus::~mascf_fi_tcl_e8_Aud_RoutineStatus()
{}

tU32 mascf_fi_tcl_e8_Aud_RoutineStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_RoutineStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_RoutineStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_WriteTestErrorStatus::mascf_fi_tcl_e8_Aud_WriteTestErrorStatus():enType(FI_EN_FC_AUDIO_WRITE_STATIS_DIGNOSIS_LOG) {}

tS32 mascf_fi_tcl_e8_Aud_WriteTestErrorStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_WRITETESTERRORSTATUS;
}


mascf_fi_tcl_e8_Aud_WriteTestErrorStatus::~mascf_fi_tcl_e8_Aud_WriteTestErrorStatus()
{}

tU32 mascf_fi_tcl_e8_Aud_WriteTestErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_WriteTestErrorStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_WriteTestErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_SpeakerType::mascf_fi_tcl_e8_Aud_SpeakerType():enType(FI_EN_FC_AUDIO_SPEAKER_UNDEF) {}

tS32 mascf_fi_tcl_e8_Aud_SpeakerType::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_SPEAKERTYPE;
}


mascf_fi_tcl_e8_Aud_SpeakerType::~mascf_fi_tcl_e8_Aud_SpeakerType()
{}

tU32 mascf_fi_tcl_e8_Aud_SpeakerType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_SpeakerType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_SpeakerType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_TestToneControl::mascf_fi_tcl_e8_Aud_TestToneControl():enType(FI_EN_FC_AUDIO_TEST_TONE_UNDEF) {}

tS32 mascf_fi_tcl_e8_Aud_TestToneControl::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_TESTTONECONTROL;
}


mascf_fi_tcl_e8_Aud_TestToneControl::~mascf_fi_tcl_e8_Aud_TestToneControl()
{}

tU32 mascf_fi_tcl_e8_Aud_TestToneControl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_TestToneControl::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_TestToneControl::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_FreqTestTone::mascf_fi_tcl_e8_Aud_FreqTestTone():enType(FI_EN_FC_AUDIO_FREQ_TEST_TONE_DEFAULT) {}

tS32 mascf_fi_tcl_e8_Aud_FreqTestTone::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_FREQTESTTONE;
}


mascf_fi_tcl_e8_Aud_FreqTestTone::~mascf_fi_tcl_e8_Aud_FreqTestTone()
{}

tU32 mascf_fi_tcl_e8_Aud_FreqTestTone::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_FreqTestTone::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_FreqTestTone::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_Aud_TestRoutineParameter::mascf_fi_tcl_Aud_TestRoutineParameter(const mascf_fi_tcl_Aud_TestRoutineParameter& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   WriteToRM = coRef.WriteToRM;
   MonitoringMode = coRef.MonitoringMode;
   SupervisionControl = coRef.SupervisionControl;
}
mascf_fi_tcl_Aud_TestRoutineParameter& mascf_fi_tcl_Aud_TestRoutineParameter::operator=(const mascf_fi_tcl_Aud_TestRoutineParameter& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   WriteToRM = coRef.WriteToRM;
   MonitoringMode = coRef.MonitoringMode;
   SupervisionControl = coRef.SupervisionControl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_Aud_TestRoutineParameter::mascf_fi_tcl_Aud_TestRoutineParameter()
:TroubleCode()
,WriteToRM(0)
,MonitoringMode()
,SupervisionControl()
 {}

tS32 mascf_fi_tcl_Aud_TestRoutineParameter::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_AUD_TESTROUTINEPARAMETER;
}


mascf_fi_tcl_Aud_TestRoutineParameter::~mascf_fi_tcl_Aud_TestRoutineParameter()
{}

tU32 mascf_fi_tcl_Aud_TestRoutineParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mascf_fi_tcl_Aud_TestRoutineParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> WriteToRM);
   (tVoid) (oIn >> MonitoringMode);
   (tVoid) (oIn >> SupervisionControl);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_Aud_TestRoutineParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << WriteToRM);
   (tVoid) (oOut << MonitoringMode);
   (tVoid) (oOut << SupervisionControl);
   return oOut;
}

tBool mascf_fi_tcl_Aud_TestRoutineParameter::operator==(const mascf_fi_tcl_Aud_TestRoutineParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (WriteToRM == roRef.WriteToRM);
   bResult = bResult && (MonitoringMode == roRef.MonitoringMode);
   bResult = bResult && (SupervisionControl == roRef.SupervisionControl);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_Aud_TestRoutineParameterList::mascf_fi_tcl_Aud_TestRoutineParameterList(const mascf_fi_tcl_Aud_TestRoutineParameterList& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   TestRoutineParameterList = coRef.TestRoutineParameterList;
}
mascf_fi_tcl_Aud_TestRoutineParameterList& mascf_fi_tcl_Aud_TestRoutineParameterList::operator=(const mascf_fi_tcl_Aud_TestRoutineParameterList& coRef)
{
   if (this == &coRef) return *this;
   TestRoutineParameterList = coRef.TestRoutineParameterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_fi_tcl_Aud_TestRoutineParameterList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
         TestRoutineParameterList[u32Idx].vDestroy();
   TestRoutineParameterList.clear();
   }
}

mascf_fi_tcl_Aud_TestRoutineParameterList::mascf_fi_tcl_Aud_TestRoutineParameterList()

 {}

tS32 mascf_fi_tcl_Aud_TestRoutineParameterList::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_AUD_TESTROUTINEPARAMETERLIST;
}


mascf_fi_tcl_Aud_TestRoutineParameterList::~mascf_fi_tcl_Aud_TestRoutineParameterList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_fi_tcl_Aud_TestRoutineParameterList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TestRoutineParameterList.size()*5);
}

fi_tclInContext& mascf_fi_tcl_Aud_TestRoutineParameterList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
      {
         TestRoutineParameterList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TestRoutineParameterList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TestRoutineParameterList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_Aud_TestRoutineParameterList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TestRoutineParameterList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
         (tVoid) (oOut << TestRoutineParameterList[u32Idx]);
   }
   return oOut;
}

tBool mascf_fi_tcl_Aud_TestRoutineParameterList::operator==(const mascf_fi_tcl_Aud_TestRoutineParameterList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TestRoutineParameterList.size() == roRef.TestRoutineParameterList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TestRoutineParameterList.size()); ++u32Idx)
            bResult = bResult && (TestRoutineParameterList[u32Idx] == roRef.TestRoutineParameterList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_Aud_TestTroubleCodeStatus::mascf_fi_tcl_Aud_TestTroubleCodeStatus(const mascf_fi_tcl_Aud_TestTroubleCodeStatus& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   ErrorStatus = coRef.ErrorStatus;
   RoutineStatus = coRef.RoutineStatus;
   DiagnosisLogWrite = coRef.DiagnosisLogWrite;
}
mascf_fi_tcl_Aud_TestTroubleCodeStatus& mascf_fi_tcl_Aud_TestTroubleCodeStatus::operator=(const mascf_fi_tcl_Aud_TestTroubleCodeStatus& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   ErrorStatus = coRef.ErrorStatus;
   RoutineStatus = coRef.RoutineStatus;
   DiagnosisLogWrite = coRef.DiagnosisLogWrite;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_Aud_TestTroubleCodeStatus::mascf_fi_tcl_Aud_TestTroubleCodeStatus()
:TroubleCode()
,ErrorStatus()
,RoutineStatus()
,DiagnosisLogWrite()
 {}

tS32 mascf_fi_tcl_Aud_TestTroubleCodeStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_AUD_TESTTROUBLECODESTATUS;
}


mascf_fi_tcl_Aud_TestTroubleCodeStatus::~mascf_fi_tcl_Aud_TestTroubleCodeStatus()
{}

tU32 mascf_fi_tcl_Aud_TestTroubleCodeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mascf_fi_tcl_Aud_TestTroubleCodeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> ErrorStatus);
   (tVoid) (oIn >> RoutineStatus);
   (tVoid) (oIn >> DiagnosisLogWrite);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_Aud_TestTroubleCodeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << ErrorStatus);
   (tVoid) (oOut << RoutineStatus);
   (tVoid) (oOut << DiagnosisLogWrite);
   return oOut;
}

tBool mascf_fi_tcl_Aud_TestTroubleCodeStatus::operator==(const mascf_fi_tcl_Aud_TestTroubleCodeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (ErrorStatus == roRef.ErrorStatus);
   bResult = bResult && (RoutineStatus == roRef.RoutineStatus);
   bResult = bResult && (DiagnosisLogWrite == roRef.DiagnosisLogWrite);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_Aud_TestTroubleCodeStatusList::mascf_fi_tcl_Aud_TestTroubleCodeStatusList(const mascf_fi_tcl_Aud_TestTroubleCodeStatusList& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   TroubleCodeStatusList = coRef.TroubleCodeStatusList;
}
mascf_fi_tcl_Aud_TestTroubleCodeStatusList& mascf_fi_tcl_Aud_TestTroubleCodeStatusList::operator=(const mascf_fi_tcl_Aud_TestTroubleCodeStatusList& coRef)
{
   if (this == &coRef) return *this;
   TroubleCodeStatusList = coRef.TroubleCodeStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_fi_tcl_Aud_TestTroubleCodeStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TroubleCodeStatusList.size(); ++u32Idx)
         TroubleCodeStatusList[u32Idx].vDestroy();
   TroubleCodeStatusList.clear();
   }
}

mascf_fi_tcl_Aud_TestTroubleCodeStatusList::mascf_fi_tcl_Aud_TestTroubleCodeStatusList()

 {}

tS32 mascf_fi_tcl_Aud_TestTroubleCodeStatusList::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_AUD_TESTTROUBLECODESTATUSLIST;
}


mascf_fi_tcl_Aud_TestTroubleCodeStatusList::~mascf_fi_tcl_Aud_TestTroubleCodeStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_fi_tcl_Aud_TestTroubleCodeStatusList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TroubleCodeStatusList.size()*5);
}

fi_tclInContext& mascf_fi_tcl_Aud_TestTroubleCodeStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TroubleCodeStatusList.size(); ++u32Idx)
      {
         TroubleCodeStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TroubleCodeStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TroubleCodeStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_Aud_TestTroubleCodeStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TroubleCodeStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TroubleCodeStatusList.size(); ++u32Idx)
         (tVoid) (oOut << TroubleCodeStatusList[u32Idx]);
   }
   return oOut;
}

tBool mascf_fi_tcl_Aud_TestTroubleCodeStatusList::operator==(const mascf_fi_tcl_Aud_TestTroubleCodeStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TroubleCodeStatusList.size() == roRef.TroubleCodeStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TroubleCodeStatusList.size()); ++u32Idx)
            bResult = bResult && (TroubleCodeStatusList[u32Idx] == roRef.TroubleCodeStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_MicrophoneNumber::mascf_fi_tcl_e8_MicrophoneNumber():enType(FI_EN_MIC_1) {}

tS32 mascf_fi_tcl_e8_MicrophoneNumber::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_MICROPHONENUMBER;
}


mascf_fi_tcl_e8_MicrophoneNumber::~mascf_fi_tcl_e8_MicrophoneNumber()
{}

tU32 mascf_fi_tcl_e8_MicrophoneNumber::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_MicrophoneNumber::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_MicrophoneNumber::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_MicrophoneConnectionStatus::mascf_fi_tcl_e8_MicrophoneConnectionStatus():enType(FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_OPEN) {}

tS32 mascf_fi_tcl_e8_MicrophoneConnectionStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_MICROPHONECONNECTIONSTATUS;
}


mascf_fi_tcl_e8_MicrophoneConnectionStatus::~mascf_fi_tcl_e8_MicrophoneConnectionStatus()
{}

tU32 mascf_fi_tcl_e8_MicrophoneConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_MicrophoneConnectionStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_MicrophoneConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_MicrophoneDetection::mascf_fi_tcl_e8_MicrophoneDetection():enType(FI_EN_MIC_DET_ABSENT) {}

tS32 mascf_fi_tcl_e8_MicrophoneDetection::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_MICROPHONEDETECTION;
}


mascf_fi_tcl_e8_MicrophoneDetection::~mascf_fi_tcl_e8_MicrophoneDetection()
{}

tU32 mascf_fi_tcl_e8_MicrophoneDetection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_MicrophoneDetection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_MicrophoneDetection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_MicrophoneConnectionStatus::mascf_fi_tcl_MicrophoneConnectionStatus(const mascf_fi_tcl_MicrophoneConnectionStatus& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   e8MicrophoneNumber = coRef.e8MicrophoneNumber;
   u16MicrophoneCurrent = coRef.u16MicrophoneCurrent;
   e8MicrophoneConnectionStatus = coRef.e8MicrophoneConnectionStatus;
   e8MicrophoneDetection = coRef.e8MicrophoneDetection;
}
mascf_fi_tcl_MicrophoneConnectionStatus& mascf_fi_tcl_MicrophoneConnectionStatus::operator=(const mascf_fi_tcl_MicrophoneConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   e8MicrophoneNumber = coRef.e8MicrophoneNumber;
   u16MicrophoneCurrent = coRef.u16MicrophoneCurrent;
   e8MicrophoneConnectionStatus = coRef.e8MicrophoneConnectionStatus;
   e8MicrophoneDetection = coRef.e8MicrophoneDetection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_MicrophoneConnectionStatus::mascf_fi_tcl_MicrophoneConnectionStatus()
:e8MicrophoneNumber()
,u16MicrophoneCurrent(0)
,e8MicrophoneConnectionStatus()
,e8MicrophoneDetection()
 {}

tS32 mascf_fi_tcl_MicrophoneConnectionStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_MICROPHONECONNECTIONSTATUS;
}


mascf_fi_tcl_MicrophoneConnectionStatus::~mascf_fi_tcl_MicrophoneConnectionStatus()
{}

tU32 mascf_fi_tcl_MicrophoneConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mascf_fi_tcl_MicrophoneConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MicrophoneNumber);
   (tVoid) (oIn >> u16MicrophoneCurrent);
   (tVoid) (oIn >> e8MicrophoneConnectionStatus);
   (tVoid) (oIn >> e8MicrophoneDetection);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_MicrophoneConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MicrophoneNumber);
   (tVoid) (oOut << u16MicrophoneCurrent);
   (tVoid) (oOut << e8MicrophoneConnectionStatus);
   (tVoid) (oOut << e8MicrophoneDetection);
   return oOut;
}

tBool mascf_fi_tcl_MicrophoneConnectionStatus::operator==(const mascf_fi_tcl_MicrophoneConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MicrophoneNumber == roRef.e8MicrophoneNumber);
   bResult = bResult && (u16MicrophoneCurrent == roRef.u16MicrophoneCurrent);
   bResult = bResult && (e8MicrophoneConnectionStatus == roRef.e8MicrophoneConnectionStatus);
   bResult = bResult && (e8MicrophoneDetection == roRef.e8MicrophoneDetection);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_MicrophoneConnectionStatusList::mascf_fi_tcl_MicrophoneConnectionStatusList(const mascf_fi_tcl_MicrophoneConnectionStatusList& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   MicrophoneConnectionStatusList = coRef.MicrophoneConnectionStatusList;
}
mascf_fi_tcl_MicrophoneConnectionStatusList& mascf_fi_tcl_MicrophoneConnectionStatusList::operator=(const mascf_fi_tcl_MicrophoneConnectionStatusList& coRef)
{
   if (this == &coRef) return *this;
   MicrophoneConnectionStatusList = coRef.MicrophoneConnectionStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_fi_tcl_MicrophoneConnectionStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MicrophoneConnectionStatusList.size(); ++u32Idx)
         MicrophoneConnectionStatusList[u32Idx].vDestroy();
   MicrophoneConnectionStatusList.clear();
   }
}

mascf_fi_tcl_MicrophoneConnectionStatusList::mascf_fi_tcl_MicrophoneConnectionStatusList()

 {}

tS32 mascf_fi_tcl_MicrophoneConnectionStatusList::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_MICROPHONECONNECTIONSTATUSLIST;
}


mascf_fi_tcl_MicrophoneConnectionStatusList::~mascf_fi_tcl_MicrophoneConnectionStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_fi_tcl_MicrophoneConnectionStatusList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(MicrophoneConnectionStatusList.size()*5);
}

fi_tclInContext& mascf_fi_tcl_MicrophoneConnectionStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MicrophoneConnectionStatusList.size(); ++u32Idx)
      {
         MicrophoneConnectionStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      MicrophoneConnectionStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MicrophoneConnectionStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_MicrophoneConnectionStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)MicrophoneConnectionStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MicrophoneConnectionStatusList.size(); ++u32Idx)
         (tVoid) (oOut << MicrophoneConnectionStatusList[u32Idx]);
   }
   return oOut;
}

tBool mascf_fi_tcl_MicrophoneConnectionStatusList::operator==(const mascf_fi_tcl_MicrophoneConnectionStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (MicrophoneConnectionStatusList.size() == roRef.MicrophoneConnectionStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MicrophoneConnectionStatusList.size()); ++u32Idx)
            bResult = bResult && (MicrophoneConnectionStatusList[u32Idx] == roRef.MicrophoneConnectionStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_ResourceNo::mascf_fi_tcl_e8_ResourceNo():enType(FI_EN_AUDIO_RESOURCE_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_ResourceNo::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_RESOURCENO;
}


mascf_fi_tcl_e8_ResourceNo::~mascf_fi_tcl_e8_ResourceNo()
{}

tU32 mascf_fi_tcl_e8_ResourceNo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_ResourceNo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_ResourceNo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudioServiceStatus::mascf_fi_tcl_e8_AudioServiceStatus():enType(FI_EN_REJECTED) {}

tS32 mascf_fi_tcl_e8_AudioServiceStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDIOSERVICESTATUS;
}


mascf_fi_tcl_e8_AudioServiceStatus::~mascf_fi_tcl_e8_AudioServiceStatus()
{}

tU32 mascf_fi_tcl_e8_AudioServiceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudioServiceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudioServiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_GalaLevel::mascf_fi_tcl_e8_GalaLevel():enType(FI_EN_AUDIO_GALA_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_GalaLevel::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_GALALEVEL;
}


mascf_fi_tcl_e8_GalaLevel::~mascf_fi_tcl_e8_GalaLevel()
{}

tU32 mascf_fi_tcl_e8_GalaLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_GalaLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_GalaLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudioChannel::mascf_fi_tcl_e8_AudioChannel():enType(FI_EN_AUDIO_CHANNEL_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_AudioChannel::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDIOCHANNEL;
}


mascf_fi_tcl_e8_AudioChannel::~mascf_fi_tcl_e8_AudioChannel()
{}

tU32 mascf_fi_tcl_e8_AudioChannel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudioChannel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudioChannel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudioVolumeType::mascf_fi_tcl_e8_AudioVolumeType():enType(FI_EN_AUDIO_VAL_TYPE_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_AudioVolumeType::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDIOVOLUMETYPE;
}


mascf_fi_tcl_e8_AudioVolumeType::~mascf_fi_tcl_e8_AudioVolumeType()
{}

tU32 mascf_fi_tcl_e8_AudioVolumeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudioVolumeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudioVolumeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudioSoundType::mascf_fi_tcl_e8_AudioSoundType():enType(FI_EN_AUDIO_SND_TYPE_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_AudioSoundType::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDIOSOUNDTYPE;
}


mascf_fi_tcl_e8_AudioSoundType::~mascf_fi_tcl_e8_AudioSoundType()
{}

tU32 mascf_fi_tcl_e8_AudioSoundType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudioSoundType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudioSoundType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudioBeepType::mascf_fi_tcl_e8_AudioBeepType():enType(FI_EN_AUDIO_BEEP_WARN_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_AudioBeepType::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDIOBEEPTYPE;
}


mascf_fi_tcl_e8_AudioBeepType::~mascf_fi_tcl_e8_AudioBeepType()
{}

tU32 mascf_fi_tcl_e8_AudioBeepType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudioBeepType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudioBeepType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudioBeepStatus::mascf_fi_tcl_e8_AudioBeepStatus():enType(FI_EN_AUDIO_BEEP_STATUS_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_AudioBeepStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDIOBEEPSTATUS;
}


mascf_fi_tcl_e8_AudioBeepStatus::~mascf_fi_tcl_e8_AudioBeepStatus()
{}

tU32 mascf_fi_tcl_e8_AudioBeepStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudioBeepStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudioBeepStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_VolumeMode::mascf_fi_tcl_e8_VolumeMode():enType(FI_EN_AUDIO_VOLMODE_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_VolumeMode::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_VOLUMEMODE;
}


mascf_fi_tcl_e8_VolumeMode::~mascf_fi_tcl_e8_VolumeMode()
{}

tU32 mascf_fi_tcl_e8_VolumeMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_VolumeMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_VolumeMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_SourceNo::mascf_fi_tcl_e8_SourceNo():enType(FI_EN_AUDIO_SRC_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_SourceNo::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_SOURCENO;
}


mascf_fi_tcl_e8_SourceNo::~mascf_fi_tcl_e8_SourceNo()
{}

tU32 mascf_fi_tcl_e8_SourceNo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_SourceNo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_SourceNo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_RouteNo::mascf_fi_tcl_e8_RouteNo():enType(FI_EN_NOSOURCE) {}

tS32 mascf_fi_tcl_e8_RouteNo::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_ROUTENO;
}


mascf_fi_tcl_e8_RouteNo::~mascf_fi_tcl_e8_RouteNo()
{}

tU32 mascf_fi_tcl_e8_RouteNo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_RouteNo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_RouteNo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Sound::mascf_fi_tcl_e8_Sound():enType(FI_EN_AUDIO_SOUND_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_Sound::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_SOUND;
}


mascf_fi_tcl_e8_Sound::~mascf_fi_tcl_e8_Sound()
{}

tU32 mascf_fi_tcl_e8_Sound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Sound::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Sound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_MemStatus::mascf_fi_tcl_e8_MemStatus():enType(FI_EN_AUDIO_MEMSTATUS_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_MemStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_MEMSTATUS;
}


mascf_fi_tcl_e8_MemStatus::~mascf_fi_tcl_e8_MemStatus()
{}

tU32 mascf_fi_tcl_e8_MemStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_MemStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_MemStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_FaderStatus::mascf_fi_tcl_e8_FaderStatus():enType(FI_EN_AUDIO_FADERSTATUS_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_FaderStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_FADERSTATUS;
}


mascf_fi_tcl_e8_FaderStatus::~mascf_fi_tcl_e8_FaderStatus()
{}

tU32 mascf_fi_tcl_e8_FaderStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_FaderStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_FaderStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_DynCompression::mascf_fi_tcl_e8_DynCompression():enType(FI_EN_AUDIO_DYN_COMPRESSION_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_DynCompression::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_DYNCOMPRESSION;
}


mascf_fi_tcl_e8_DynCompression::~mascf_fi_tcl_e8_DynCompression()
{}

tU32 mascf_fi_tcl_e8_DynCompression::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_DynCompression::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_DynCompression::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Optimization::mascf_fi_tcl_e8_Optimization():enType(FI_EN_AUDIO_OPTIMIZATION_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_Optimization::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_OPTIMIZATION;
}


mascf_fi_tcl_e8_Optimization::~mascf_fi_tcl_e8_Optimization()
{}

tU32 mascf_fi_tcl_e8_Optimization::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Optimization::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Optimization::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_EquPresets::mascf_fi_tcl_e8_EquPresets():enType(FI_EN_AUDIO_EQU_PRESET_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_EquPresets::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_EQUPRESETS;
}


mascf_fi_tcl_e8_EquPresets::~mascf_fi_tcl_e8_EquPresets()
{}

tU32 mascf_fi_tcl_e8_EquPresets::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_EquPresets::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_EquPresets::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_DiagAudMode::mascf_fi_tcl_e8_DiagAudMode():enType(FI_EN_AUDIO_DIAG_AUD_MODE_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_DiagAudMode::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_DIAGAUDMODE;
}


mascf_fi_tcl_e8_DiagAudMode::~mascf_fi_tcl_e8_DiagAudMode()
{}

tU32 mascf_fi_tcl_e8_DiagAudMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_DiagAudMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_DiagAudMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_GenericDiagAudMode::mascf_fi_tcl_e8_GenericDiagAudMode():enType(FI_EN_NOT_DEFINED) {}

tS32 mascf_fi_tcl_e8_GenericDiagAudMode::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_GENERICDIAGAUDMODE;
}


mascf_fi_tcl_e8_GenericDiagAudMode::~mascf_fi_tcl_e8_GenericDiagAudMode()
{}

tU32 mascf_fi_tcl_e8_GenericDiagAudMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_GenericDiagAudMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_GenericDiagAudMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AuxInLevel::mascf_fi_tcl_e8_AuxInLevel():enType(FI_EN_AUDIO_AUX_IN_LEVEL_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_AuxInLevel::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUXINLEVEL;
}


mascf_fi_tcl_e8_AuxInLevel::~mascf_fi_tcl_e8_AuxInLevel()
{}

tU32 mascf_fi_tcl_e8_AuxInLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AuxInLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AuxInLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_BeepLevel::mascf_fi_tcl_e8_BeepLevel():enType(FI_EN_AUDIO_BEEP_LEVEL_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_BeepLevel::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_BEEPLEVEL;
}


mascf_fi_tcl_e8_BeepLevel::~mascf_fi_tcl_e8_BeepLevel()
{}

tU32 mascf_fi_tcl_e8_BeepLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_BeepLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_BeepLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Rear_Mute::mascf_fi_tcl_e8_Rear_Mute():enType(FI_EN_AUDIO_REAR_MUTE_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_Rear_Mute::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_REAR_MUTE;
}


mascf_fi_tcl_e8_Rear_Mute::~mascf_fi_tcl_e8_Rear_Mute()
{}

tU32 mascf_fi_tcl_e8_Rear_Mute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Rear_Mute::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Rear_Mute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Geometry_Mode::mascf_fi_tcl_e8_Geometry_Mode():enType(FI_EN_AUDIO_GEOMETRY_MODE_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_Geometry_Mode::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_GEOMETRY_MODE;
}


mascf_fi_tcl_e8_Geometry_Mode::~mascf_fi_tcl_e8_Geometry_Mode()
{}

tU32 mascf_fi_tcl_e8_Geometry_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Geometry_Mode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Geometry_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_PDCAttenuation::mascf_fi_tcl_e8_PDCAttenuation():enType(FI_EN_AUDIO_PDC_COMMAND_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_PDCAttenuation::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_PDCATTENUATION;
}


mascf_fi_tcl_e8_PDCAttenuation::~mascf_fi_tcl_e8_PDCAttenuation()
{}

tU32 mascf_fi_tcl_e8_PDCAttenuation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_PDCAttenuation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_PDCAttenuation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_VolumeType::mascf_fi_tcl_e8_VolumeType():enType(FI_EN_INCREMENT) {}

tS32 mascf_fi_tcl_e8_VolumeType::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_VOLUMETYPE;
}


mascf_fi_tcl_e8_VolumeType::~mascf_fi_tcl_e8_VolumeType()
{}

tU32 mascf_fi_tcl_e8_VolumeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_VolumeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_VolumeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_Volume::mascf_fi_tcl_Volume(const mascf_fi_tcl_Volume& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   e8VolType = coRef.e8VolType;
   s16Volume = coRef.s16Volume;
}
mascf_fi_tcl_Volume& mascf_fi_tcl_Volume::operator=(const mascf_fi_tcl_Volume& coRef)
{
   if (this == &coRef) return *this;
   e8VolType = coRef.e8VolType;
   s16Volume = coRef.s16Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_Volume::mascf_fi_tcl_Volume()
:e8VolType()
,s16Volume(0)
 {}

tS32 mascf_fi_tcl_Volume::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_VOLUME;
}


mascf_fi_tcl_Volume::~mascf_fi_tcl_Volume()
{}

tU32 mascf_fi_tcl_Volume::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_fi_tcl_Volume::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VolType);
   (tVoid) (oIn >> s16Volume);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_Volume::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VolType);
   (tVoid) (oOut << s16Volume);
   return oOut;
}

tBool mascf_fi_tcl_Volume::operator==(const mascf_fi_tcl_Volume& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VolType == roRef.e8VolType);
   bResult = bResult && (s16Volume == roRef.s16Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_b8_ChannelSelect::mascf_fi_tcl_b8_ChannelSelect():u8Value(0)
{}

tS32 mascf_fi_tcl_b8_ChannelSelect::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_B8_CHANNELSELECT;
}


mascf_fi_tcl_b8_ChannelSelect::~mascf_fi_tcl_b8_ChannelSelect()
{}

tU32 mascf_fi_tcl_b8_ChannelSelect::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_b8_ChannelSelect::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& mascf_fi_tcl_b8_ChannelSelect::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_Beep_Vol_Type::mascf_fi_tcl_e8_Aud_Beep_Vol_Type():enType(FI_EN_FC_AUDIO_BEEP_VOL_TYPE_SYSTEM_DEFAULT) {}

tS32 mascf_fi_tcl_e8_Aud_Beep_Vol_Type::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_BEEP_VOL_TYPE;
}


mascf_fi_tcl_e8_Aud_Beep_Vol_Type::~mascf_fi_tcl_e8_Aud_Beep_Vol_Type()
{}

tU32 mascf_fi_tcl_e8_Aud_Beep_Vol_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_Beep_Vol_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_Beep_Vol_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_BeepConfig::mascf_fi_tcl_BeepConfig(const mascf_fi_tcl_BeepConfig& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   e8VolType = coRef.e8VolType;
   s16VoldB = coRef.s16VoldB;
}
mascf_fi_tcl_BeepConfig& mascf_fi_tcl_BeepConfig::operator=(const mascf_fi_tcl_BeepConfig& coRef)
{
   if (this == &coRef) return *this;
   e8VolType = coRef.e8VolType;
   s16VoldB = coRef.s16VoldB;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_BeepConfig::mascf_fi_tcl_BeepConfig()
:e8VolType()
,s16VoldB(0)
 {}

tS32 mascf_fi_tcl_BeepConfig::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_BEEPCONFIG;
}


mascf_fi_tcl_BeepConfig::~mascf_fi_tcl_BeepConfig()
{}

tU32 mascf_fi_tcl_BeepConfig::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_fi_tcl_BeepConfig::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VolType);
   (tVoid) (oIn >> s16VoldB);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_BeepConfig::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VolType);
   (tVoid) (oOut << s16VoldB);
   return oOut;
}

tBool mascf_fi_tcl_BeepConfig::operator==(const mascf_fi_tcl_BeepConfig& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VolType == roRef.e8VolType);
   bResult = bResult && (s16VoldB == roRef.s16VoldB);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudioDevice_Availability::mascf_fi_tcl_e8_AudioDevice_Availability():enType(FI_EN_AUDIODEVICE_NOTAVAILABLE) {}

tS32 mascf_fi_tcl_e8_AudioDevice_Availability::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDIODEVICE_AVAILABILITY;
}


mascf_fi_tcl_e8_AudioDevice_Availability::~mascf_fi_tcl_e8_AudioDevice_Availability()
{}

tU32 mascf_fi_tcl_e8_AudioDevice_Availability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudioDevice_Availability::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudioDevice_Availability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_State::mascf_fi_tcl_e8_State():enType(FI_EN_CUESTATE_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_State::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_STATE;
}


mascf_fi_tcl_e8_State::~mascf_fi_tcl_e8_State()
{}

tU32 mascf_fi_tcl_e8_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_VolumeType::mascf_fi_tcl_e8_Aud_VolumeType():enType(FI_EN_VOLUME_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_Aud_VolumeType::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_VOLUMETYPE;
}


mascf_fi_tcl_e8_Aud_VolumeType::~mascf_fi_tcl_e8_Aud_VolumeType()
{}

tU32 mascf_fi_tcl_e8_Aud_VolumeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_VolumeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_VolumeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_Aud_VolumeStatus::mascf_fi_tcl_Aud_VolumeStatus(const mascf_fi_tcl_Aud_VolumeStatus& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   AudVolumeType = coRef.AudVolumeType;
   Volume = coRef.Volume;
}
mascf_fi_tcl_Aud_VolumeStatus& mascf_fi_tcl_Aud_VolumeStatus::operator=(const mascf_fi_tcl_Aud_VolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   AudVolumeType = coRef.AudVolumeType;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_Aud_VolumeStatus::mascf_fi_tcl_Aud_VolumeStatus()
:AudVolumeType()
,Volume(0)
 {}

tS32 mascf_fi_tcl_Aud_VolumeStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_AUD_VOLUMESTATUS;
}


mascf_fi_tcl_Aud_VolumeStatus::~mascf_fi_tcl_Aud_VolumeStatus()
{}

tU32 mascf_fi_tcl_Aud_VolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_Aud_VolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudVolumeType);
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_Aud_VolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudVolumeType);
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool mascf_fi_tcl_Aud_VolumeStatus::operator==(const mascf_fi_tcl_Aud_VolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudVolumeType == roRef.AudVolumeType);
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_Aud_VolumeStatusList::mascf_fi_tcl_Aud_VolumeStatusList(const mascf_fi_tcl_Aud_VolumeStatusList& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   VolumeStatusList = coRef.VolumeStatusList;
}
mascf_fi_tcl_Aud_VolumeStatusList& mascf_fi_tcl_Aud_VolumeStatusList::operator=(const mascf_fi_tcl_Aud_VolumeStatusList& coRef)
{
   if (this == &coRef) return *this;
   VolumeStatusList = coRef.VolumeStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_fi_tcl_Aud_VolumeStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < VolumeStatusList.size(); ++u32Idx)
         VolumeStatusList[u32Idx].vDestroy();
   VolumeStatusList.clear();
   }
}

mascf_fi_tcl_Aud_VolumeStatusList::mascf_fi_tcl_Aud_VolumeStatusList()

 {}

tS32 mascf_fi_tcl_Aud_VolumeStatusList::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_AUD_VOLUMESTATUSLIST;
}


mascf_fi_tcl_Aud_VolumeStatusList::~mascf_fi_tcl_Aud_VolumeStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_fi_tcl_Aud_VolumeStatusList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(VolumeStatusList.size()*2);
}

fi_tclInContext& mascf_fi_tcl_Aud_VolumeStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < VolumeStatusList.size(); ++u32Idx)
      {
         VolumeStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      VolumeStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> VolumeStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_Aud_VolumeStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)VolumeStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < VolumeStatusList.size(); ++u32Idx)
         (tVoid) (oOut << VolumeStatusList[u32Idx]);
   }
   return oOut;
}

tBool mascf_fi_tcl_Aud_VolumeStatusList::operator==(const mascf_fi_tcl_Aud_VolumeStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (VolumeStatusList.size() == roRef.VolumeStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < VolumeStatusList.size()); ++u32Idx)
            bResult = bResult && (VolumeStatusList[u32Idx] == roRef.VolumeStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_BTAudioInLevel::mascf_fi_tcl_e8_BTAudioInLevel():enType(FI_EN_AUDIO_BT_IN_LEVEL_1) {}

tS32 mascf_fi_tcl_e8_BTAudioInLevel::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_BTAUDIOINLEVEL;
}


mascf_fi_tcl_e8_BTAudioInLevel::~mascf_fi_tcl_e8_BTAudioInLevel()
{}

tU32 mascf_fi_tcl_e8_BTAudioInLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_BTAudioInLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_BTAudioInLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_EDType::mascf_fi_tcl_e8_Aud_EDType():enType(FI_EN_ED_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_Aud_EDType::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_EDTYPE;
}


mascf_fi_tcl_e8_Aud_EDType::~mascf_fi_tcl_e8_Aud_EDType()
{}

tU32 mascf_fi_tcl_e8_Aud_EDType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_EDType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_EDType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_Aud_EDStatus::mascf_fi_tcl_Aud_EDStatus(const mascf_fi_tcl_Aud_EDStatus& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   AudEDType = coRef.AudEDType;
   EDValue = coRef.EDValue;
}
mascf_fi_tcl_Aud_EDStatus& mascf_fi_tcl_Aud_EDStatus::operator=(const mascf_fi_tcl_Aud_EDStatus& coRef)
{
   if (this == &coRef) return *this;
   AudEDType = coRef.AudEDType;
   EDValue = coRef.EDValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_Aud_EDStatus::mascf_fi_tcl_Aud_EDStatus()
:AudEDType()
,EDValue(0)
 {}

tS32 mascf_fi_tcl_Aud_EDStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_AUD_EDSTATUS;
}


mascf_fi_tcl_Aud_EDStatus::~mascf_fi_tcl_Aud_EDStatus()
{}

tU32 mascf_fi_tcl_Aud_EDStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mascf_fi_tcl_Aud_EDStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudEDType);
   (tVoid) (oIn >> EDValue);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_Aud_EDStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudEDType);
   (tVoid) (oOut << EDValue);
   return oOut;
}

tBool mascf_fi_tcl_Aud_EDStatus::operator==(const mascf_fi_tcl_Aud_EDStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudEDType == roRef.AudEDType);
   bResult = bResult && (EDValue == roRef.EDValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_Aud_EDStatusList::mascf_fi_tcl_Aud_EDStatusList(const mascf_fi_tcl_Aud_EDStatusList& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   EDStatusList = coRef.EDStatusList;
}
mascf_fi_tcl_Aud_EDStatusList& mascf_fi_tcl_Aud_EDStatusList::operator=(const mascf_fi_tcl_Aud_EDStatusList& coRef)
{
   if (this == &coRef) return *this;
   EDStatusList = coRef.EDStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_fi_tcl_Aud_EDStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < EDStatusList.size(); ++u32Idx)
         EDStatusList[u32Idx].vDestroy();
   EDStatusList.clear();
   }
}

mascf_fi_tcl_Aud_EDStatusList::mascf_fi_tcl_Aud_EDStatusList()

 {}

tS32 mascf_fi_tcl_Aud_EDStatusList::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_AUD_EDSTATUSLIST;
}


mascf_fi_tcl_Aud_EDStatusList::~mascf_fi_tcl_Aud_EDStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_fi_tcl_Aud_EDStatusList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(EDStatusList.size()*5);
}

fi_tclInContext& mascf_fi_tcl_Aud_EDStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < EDStatusList.size(); ++u32Idx)
      {
         EDStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      EDStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> EDStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_Aud_EDStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)EDStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < EDStatusList.size(); ++u32Idx)
         (tVoid) (oOut << EDStatusList[u32Idx]);
   }
   return oOut;
}

tBool mascf_fi_tcl_Aud_EDStatusList::operator==(const mascf_fi_tcl_Aud_EDStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (EDStatusList.size() == roRef.EDStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < EDStatusList.size()); ++u32Idx)
            bResult = bResult && (EDStatusList[u32Idx] == roRef.EDStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_SurroundSetting::mascf_fi_tcl_e8_SurroundSetting():enType(FI_EN_AUDIO_SURROUND_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_SurroundSetting::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_SURROUNDSETTING;
}


mascf_fi_tcl_e8_SurroundSetting::~mascf_fi_tcl_e8_SurroundSetting()
{}

tU32 mascf_fi_tcl_e8_SurroundSetting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_SurroundSetting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_SurroundSetting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AmpTemperatureLevel::mascf_fi_tcl_e8_AmpTemperatureLevel():enType(FI_EN_THERMAL_WARNING_UNKNOWN) {}

tS32 mascf_fi_tcl_e8_AmpTemperatureLevel::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AMPTEMPERATURELEVEL;
}


mascf_fi_tcl_e8_AmpTemperatureLevel::~mascf_fi_tcl_e8_AmpTemperatureLevel()
{}

tU32 mascf_fi_tcl_e8_AmpTemperatureLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AmpTemperatureLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AmpTemperatureLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_DiagMode::mascf_fi_tcl_e8_DiagMode():enType(FI_EN_OFF) {}

tS32 mascf_fi_tcl_e8_DiagMode::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_DIAGMODE;
}


mascf_fi_tcl_e8_DiagMode::~mascf_fi_tcl_e8_DiagMode()
{}

tU32 mascf_fi_tcl_e8_DiagMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_DiagMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_DiagMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_DiagState::mascf_fi_tcl_e8_DiagState():enType(FI_EN_OFF) {}

tS32 mascf_fi_tcl_e8_DiagState::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_DIAGSTATE;
}


mascf_fi_tcl_e8_DiagState::~mascf_fi_tcl_e8_DiagState()
{}

tU32 mascf_fi_tcl_e8_DiagState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_DiagState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_DiagState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Aud_DataId::mascf_fi_tcl_e8_Aud_DataId():enType(FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LF) {}

tS32 mascf_fi_tcl_e8_Aud_DataId::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUD_DATAID;
}


mascf_fi_tcl_e8_Aud_DataId::~mascf_fi_tcl_e8_Aud_DataId()
{}

tU32 mascf_fi_tcl_e8_Aud_DataId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Aud_DataId::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Aud_DataId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_b32_MeasurementResult::mascf_fi_tcl_b32_MeasurementResult():u32Value(0)
{}

tS32 mascf_fi_tcl_b32_MeasurementResult::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_B32_MEASUREMENTRESULT;
}


mascf_fi_tcl_b32_MeasurementResult::~mascf_fi_tcl_b32_MeasurementResult()
{}

tU32 mascf_fi_tcl_b32_MeasurementResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_b32_MeasurementResult::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& mascf_fi_tcl_b32_MeasurementResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_Aud_MeasurementResultItem::mascf_fi_tcl_Aud_MeasurementResultItem(const mascf_fi_tcl_Aud_MeasurementResultItem& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   u8DataId = coRef.u8DataId;
   b32Result = coRef.b32Result;
}
mascf_fi_tcl_Aud_MeasurementResultItem& mascf_fi_tcl_Aud_MeasurementResultItem::operator=(const mascf_fi_tcl_Aud_MeasurementResultItem& coRef)
{
   if (this == &coRef) return *this;
   u8DataId = coRef.u8DataId;
   b32Result = coRef.b32Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_Aud_MeasurementResultItem::mascf_fi_tcl_Aud_MeasurementResultItem()
:u8DataId()
,b32Result()
 {}

tS32 mascf_fi_tcl_Aud_MeasurementResultItem::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_AUD_MEASUREMENTRESULTITEM;
}


mascf_fi_tcl_Aud_MeasurementResultItem::~mascf_fi_tcl_Aud_MeasurementResultItem()
{}

tU32 mascf_fi_tcl_Aud_MeasurementResultItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mascf_fi_tcl_Aud_MeasurementResultItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DataId);
   (tVoid) (oIn >> b32Result);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_Aud_MeasurementResultItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DataId);
   (tVoid) (oOut << b32Result);
   return oOut;
}

tBool mascf_fi_tcl_Aud_MeasurementResultItem::operator==(const mascf_fi_tcl_Aud_MeasurementResultItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DataId == roRef.u8DataId);
   bResult = bResult && (b32Result == roRef.b32Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_VolumeLock::mascf_fi_tcl_e8_VolumeLock():enType(FI_EN_AUDIO_VOLUME_LOCK_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_VolumeLock::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_VOLUMELOCK;
}


mascf_fi_tcl_e8_VolumeLock::~mascf_fi_tcl_e8_VolumeLock()
{}

tU32 mascf_fi_tcl_e8_VolumeLock::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_VolumeLock::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_VolumeLock::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_Requester::mascf_fi_tcl_e8_Requester():enType(FI_EN_UNKNOWN) {}

tS32 mascf_fi_tcl_e8_Requester::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_REQUESTER;
}


mascf_fi_tcl_e8_Requester::~mascf_fi_tcl_e8_Requester()
{}

tU32 mascf_fi_tcl_e8_Requester::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_Requester::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_Requester::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_RoomEffect::mascf_fi_tcl_e8_RoomEffect():enType(FI_EN_AUDIO_ROOM_EFFECT_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_RoomEffect::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_ROOMEFFECT;
}


mascf_fi_tcl_e8_RoomEffect::~mascf_fi_tcl_e8_RoomEffect()
{}

tU32 mascf_fi_tcl_e8_RoomEffect::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_RoomEffect::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_RoomEffect::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudDiagDefSetPhase::mascf_fi_tcl_e8_AudDiagDefSetPhase():enType(FI_EN_AUDIO_DIAGDEFSET_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_AudDiagDefSetPhase::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDDIAGDEFSETPHASE;
}


mascf_fi_tcl_e8_AudDiagDefSetPhase::~mascf_fi_tcl_e8_AudDiagDefSetPhase()
{}

tU32 mascf_fi_tcl_e8_AudDiagDefSetPhase::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudDiagDefSetPhase::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudDiagDefSetPhase::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudioMode::mascf_fi_tcl_e8_AudioMode():enType(FI_EN_AUDIO_MODE_NOT_DEF) {}

tS32 mascf_fi_tcl_e8_AudioMode::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDIOMODE;
}


mascf_fi_tcl_e8_AudioMode::~mascf_fi_tcl_e8_AudioMode()
{}

tU32 mascf_fi_tcl_e8_AudioMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudioMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudioMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_ADAS_UPA_SoundType::mascf_fi_tcl_e8_ADAS_UPA_SoundType():enType(FI_EN_ADAS_UPA_SOUND_UNDEF) {}

tS32 mascf_fi_tcl_e8_ADAS_UPA_SoundType::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_ADAS_UPA_SOUNDTYPE;
}


mascf_fi_tcl_e8_ADAS_UPA_SoundType::~mascf_fi_tcl_e8_ADAS_UPA_SoundType()
{}

tU32 mascf_fi_tcl_e8_ADAS_UPA_SoundType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_ADAS_UPA_SoundType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_ADAS_UPA_SoundType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_ADAS_ParkAssist_Volume::mascf_fi_tcl_e8_ADAS_ParkAssist_Volume():enType(FI_EN_ADAS_PA_VOL_NO_SOUND) {}

tS32 mascf_fi_tcl_e8_ADAS_ParkAssist_Volume::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_ADAS_PARKASSIST_VOLUME;
}


mascf_fi_tcl_e8_ADAS_ParkAssist_Volume::~mascf_fi_tcl_e8_ADAS_ParkAssist_Volume()
{}

tU32 mascf_fi_tcl_e8_ADAS_ParkAssist_Volume::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_ADAS_ParkAssist_Volume::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_ADAS_ParkAssist_Volume::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_ADAS_LDW_UserVolume::mascf_fi_tcl_e8_ADAS_LDW_UserVolume():enType(FI_EN_ADAS_LDW_USR_VOL_LEVEL_INVALID) {}

tS32 mascf_fi_tcl_e8_ADAS_LDW_UserVolume::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_ADAS_LDW_USERVOLUME;
}


mascf_fi_tcl_e8_ADAS_LDW_UserVolume::~mascf_fi_tcl_e8_ADAS_LDW_UserVolume()
{}

tU32 mascf_fi_tcl_e8_ADAS_LDW_UserVolume::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_ADAS_LDW_UserVolume::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_ADAS_LDW_UserVolume::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_ADAS_Setting_Sound::mascf_fi_tcl_e8_ADAS_Setting_Sound():enType(FI_EN_ADAS_SETTING_SOUND_NONE) {}

tS32 mascf_fi_tcl_e8_ADAS_Setting_Sound::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_ADAS_SETTING_SOUND;
}


mascf_fi_tcl_e8_ADAS_Setting_Sound::~mascf_fi_tcl_e8_ADAS_Setting_Sound()
{}

tU32 mascf_fi_tcl_e8_ADAS_Setting_Sound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_ADAS_Setting_Sound::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_ADAS_Setting_Sound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_OnGoingAction::mascf_fi_tcl_e8_OnGoingAction():enType(FI_EN_UNDEF) {}

tS32 mascf_fi_tcl_e8_OnGoingAction::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_ONGOINGACTION;
}


mascf_fi_tcl_e8_OnGoingAction::~mascf_fi_tcl_e8_OnGoingAction()
{}

tU32 mascf_fi_tcl_e8_OnGoingAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_OnGoingAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_OnGoingAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_BOSE_UnitType::mascf_fi_tcl_e8_BOSE_UnitType():enType(FI_EN_AUDIOAMPLIFIER) {}

tS32 mascf_fi_tcl_e8_BOSE_UnitType::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_BOSE_UNITTYPE;
}


mascf_fi_tcl_e8_BOSE_UnitType::~mascf_fi_tcl_e8_BOSE_UnitType()
{}

tU32 mascf_fi_tcl_e8_BOSE_UnitType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_BOSE_UnitType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_BOSE_UnitType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_BOSE_UnitConnectionStatus::mascf_fi_tcl_BOSE_UnitConnectionStatus(const mascf_fi_tcl_BOSE_UnitConnectionStatus& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   e8UnitType = coRef.e8UnitType;
   bConnected = coRef.bConnected;
   u8AbsenceState = coRef.u8AbsenceState;
   u8MuteState = coRef.u8MuteState;
}
mascf_fi_tcl_BOSE_UnitConnectionStatus& mascf_fi_tcl_BOSE_UnitConnectionStatus::operator=(const mascf_fi_tcl_BOSE_UnitConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   e8UnitType = coRef.e8UnitType;
   bConnected = coRef.bConnected;
   u8AbsenceState = coRef.u8AbsenceState;
   u8MuteState = coRef.u8MuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_BOSE_UnitConnectionStatus::mascf_fi_tcl_BOSE_UnitConnectionStatus()
:e8UnitType()
,bConnected(0)
,u8AbsenceState(0)
,u8MuteState(0)
 {}

tS32 mascf_fi_tcl_BOSE_UnitConnectionStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_BOSE_UNITCONNECTIONSTATUS;
}


mascf_fi_tcl_BOSE_UnitConnectionStatus::~mascf_fi_tcl_BOSE_UnitConnectionStatus()
{}

tU32 mascf_fi_tcl_BOSE_UnitConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_BOSE_UnitConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8UnitType);
   (tVoid) (oIn >> bConnected);
   (tVoid) (oIn >> u8AbsenceState);
   (tVoid) (oIn >> u8MuteState);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_BOSE_UnitConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8UnitType);
   (tVoid) (oOut << bConnected);
   (tVoid) (oOut << u8AbsenceState);
   (tVoid) (oOut << u8MuteState);
   return oOut;
}

tBool mascf_fi_tcl_BOSE_UnitConnectionStatus::operator==(const mascf_fi_tcl_BOSE_UnitConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8UnitType == roRef.e8UnitType);
   bResult = bResult && (bConnected == roRef.bConnected);
   bResult = bResult && (u8AbsenceState == roRef.u8AbsenceState);
   bResult = bResult && (u8MuteState == roRef.u8MuteState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_MicConnection::mascf_fi_tcl_e8_MicConnection():enType(FI_EN_UNAVAILABLE) {}

tS32 mascf_fi_tcl_e8_MicConnection::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_MICCONNECTION;
}


mascf_fi_tcl_e8_MicConnection::~mascf_fi_tcl_e8_MicConnection()
{}

tU32 mascf_fi_tcl_e8_MicConnection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_MicConnection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_MicConnection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_MicResult::mascf_fi_tcl_e8_MicResult():enType(FI_EN_NORMAL) {}

tS32 mascf_fi_tcl_e8_MicResult::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_MICRESULT;
}


mascf_fi_tcl_e8_MicResult::~mascf_fi_tcl_e8_MicResult()
{}

tU32 mascf_fi_tcl_e8_MicResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_MicResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_MicResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_MicrophoneStatus::mascf_fi_tcl_MicrophoneStatus(const mascf_fi_tcl_MicrophoneStatus& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   MicConnection = coRef.MicConnection;
   MicResult = coRef.MicResult;
}
mascf_fi_tcl_MicrophoneStatus& mascf_fi_tcl_MicrophoneStatus::operator=(const mascf_fi_tcl_MicrophoneStatus& coRef)
{
   if (this == &coRef) return *this;
   MicConnection = coRef.MicConnection;
   MicResult = coRef.MicResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_MicrophoneStatus::mascf_fi_tcl_MicrophoneStatus()
:MicConnection()
,MicResult()
 {}

tS32 mascf_fi_tcl_MicrophoneStatus::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_MICROPHONESTATUS;
}


mascf_fi_tcl_MicrophoneStatus::~mascf_fi_tcl_MicrophoneStatus()
{}

tU32 mascf_fi_tcl_MicrophoneStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_fi_tcl_MicrophoneStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MicConnection);
   (tVoid) (oIn >> MicResult);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_MicrophoneStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MicConnection);
   (tVoid) (oOut << MicResult);
   return oOut;
}

tBool mascf_fi_tcl_MicrophoneStatus::operator==(const mascf_fi_tcl_MicrophoneStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MicConnection == roRef.MicConnection);
   bResult = bResult && (MicResult == roRef.MicResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_MicrophoneResult::mascf_fi_tcl_MicrophoneResult(const mascf_fi_tcl_MicrophoneResult& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   Mic1Result = coRef.Mic1Result;
   Mic2Result = coRef.Mic2Result;
   Mic3Result = coRef.Mic3Result;
   Mic4Result = coRef.Mic4Result;
}
mascf_fi_tcl_MicrophoneResult& mascf_fi_tcl_MicrophoneResult::operator=(const mascf_fi_tcl_MicrophoneResult& coRef)
{
   if (this == &coRef) return *this;
   Mic1Result = coRef.Mic1Result;
   Mic2Result = coRef.Mic2Result;
   Mic3Result = coRef.Mic3Result;
   Mic4Result = coRef.Mic4Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_MicrophoneResult::mascf_fi_tcl_MicrophoneResult()
:Mic1Result()
,Mic2Result()
,Mic3Result()
,Mic4Result()
 {}

tS32 mascf_fi_tcl_MicrophoneResult::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_MICROPHONERESULT;
}


mascf_fi_tcl_MicrophoneResult::~mascf_fi_tcl_MicrophoneResult()
{}

tU32 mascf_fi_tcl_MicrophoneResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mascf_fi_tcl_MicrophoneResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mic1Result);
   (tVoid) (oIn >> Mic2Result);
   (tVoid) (oIn >> Mic3Result);
   (tVoid) (oIn >> Mic4Result);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_MicrophoneResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mic1Result);
   (tVoid) (oOut << Mic2Result);
   (tVoid) (oOut << Mic3Result);
   (tVoid) (oOut << Mic4Result);
   return oOut;
}

tBool mascf_fi_tcl_MicrophoneResult::operator==(const mascf_fi_tcl_MicrophoneResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mic1Result == roRef.Mic1Result);
   bResult = bResult && (Mic2Result == roRef.Mic2Result);
   bResult = bResult && (Mic3Result == roRef.Mic3Result);
   bResult = bResult && (Mic4Result == roRef.Mic4Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudioPilotIntensity::mascf_fi_tcl_e8_AudioPilotIntensity():enType(FI_EN_UNDEF) {}

tS32 mascf_fi_tcl_e8_AudioPilotIntensity::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDIOPILOTINTENSITY;
}


mascf_fi_tcl_e8_AudioPilotIntensity::~mascf_fi_tcl_e8_AudioPilotIntensity()
{}

tU32 mascf_fi_tcl_e8_AudioPilotIntensity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudioPilotIntensity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudioPilotIntensity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudSource::mascf_fi_tcl_e8_AudSource():enType(FI_EN_NONE) {}

tS32 mascf_fi_tcl_e8_AudSource::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDSOURCE;
}


mascf_fi_tcl_e8_AudSource::~mascf_fi_tcl_e8_AudSource()
{}

tU32 mascf_fi_tcl_e8_AudSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudSource::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudSource::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_SrcActivity::mascf_fi_tcl_e8_SrcActivity():enType(FI_EN_PAUSE) {}

tS32 mascf_fi_tcl_e8_SrcActivity::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_SRCACTIVITY;
}


mascf_fi_tcl_e8_SrcActivity::~mascf_fi_tcl_e8_SrcActivity()
{}

tU32 mascf_fi_tcl_e8_SrcActivity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_SrcActivity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_SrcActivity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_SrcAvailabilityReason::mascf_fi_tcl_e8_SrcAvailabilityReason():enType(FI_EN_NEWMEDIA) {}

tS32 mascf_fi_tcl_e8_SrcAvailabilityReason::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_SRCAVAILABILITYREASON;
}


mascf_fi_tcl_e8_SrcAvailabilityReason::~mascf_fi_tcl_e8_SrcAvailabilityReason()
{}

tU32 mascf_fi_tcl_e8_SrcAvailabilityReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_SrcAvailabilityReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_SrcAvailabilityReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_SrcAvailability::mascf_fi_tcl_e8_SrcAvailability():enType(FI_EN_NOT_AVAILABLE) {}

tS32 mascf_fi_tcl_e8_SrcAvailability::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_SRCAVAILABILITY;
}


mascf_fi_tcl_e8_SrcAvailability::~mascf_fi_tcl_e8_SrcAvailability()
{}

tU32 mascf_fi_tcl_e8_SrcAvailability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_SrcAvailability::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_SrcAvailability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_SourceAvailablityItem::mascf_fi_tcl_SourceAvailablityItem(const mascf_fi_tcl_SourceAvailablityItem& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   e8Reason = coRef.e8Reason;
   e8Availability = coRef.e8Availability;
}
mascf_fi_tcl_SourceAvailablityItem& mascf_fi_tcl_SourceAvailablityItem::operator=(const mascf_fi_tcl_SourceAvailablityItem& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   e8Reason = coRef.e8Reason;
   e8Availability = coRef.e8Availability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_SourceAvailablityItem::mascf_fi_tcl_SourceAvailablityItem()
:u8Source()
,u16SubSource(0)
,e8Reason()
,e8Availability()
 {}

tS32 mascf_fi_tcl_SourceAvailablityItem::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_SOURCEAVAILABLITYITEM;
}


mascf_fi_tcl_SourceAvailablityItem::~mascf_fi_tcl_SourceAvailablityItem()
{}

tU32 mascf_fi_tcl_SourceAvailablityItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mascf_fi_tcl_SourceAvailablityItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> e8Reason);
   (tVoid) (oIn >> e8Availability);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_SourceAvailablityItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << e8Reason);
   (tVoid) (oOut << e8Availability);
   return oOut;
}

tBool mascf_fi_tcl_SourceAvailablityItem::operator==(const mascf_fi_tcl_SourceAvailablityItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (e8Reason == roRef.e8Reason);
   bResult = bResult && (e8Availability == roRef.e8Availability);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8MuteAction::mascf_fi_tcl_e8MuteAction():enType(FI_EN_MUTE) {}

tS32 mascf_fi_tcl_e8MuteAction::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8MUTEACTION;
}


mascf_fi_tcl_e8MuteAction::~mascf_fi_tcl_e8MuteAction()
{}

tU32 mascf_fi_tcl_e8MuteAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8MuteAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8MuteAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_RequestAudioRouteItem::mascf_fi_tcl_RequestAudioRouteItem(const mascf_fi_tcl_RequestAudioRouteItem& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u8Reason = coRef.u8Reason;
   e8Activity = coRef.e8Activity;
}
mascf_fi_tcl_RequestAudioRouteItem& mascf_fi_tcl_RequestAudioRouteItem::operator=(const mascf_fi_tcl_RequestAudioRouteItem& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u8Reason = coRef.u8Reason;
   e8Activity = coRef.e8Activity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_RequestAudioRouteItem::mascf_fi_tcl_RequestAudioRouteItem()
:u8Source()
,u16SubSource(0)
,u8Reason(0)
,e8Activity()
 {}

tS32 mascf_fi_tcl_RequestAudioRouteItem::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_REQUESTAUDIOROUTEITEM;
}


mascf_fi_tcl_RequestAudioRouteItem::~mascf_fi_tcl_RequestAudioRouteItem()
{}

tU32 mascf_fi_tcl_RequestAudioRouteItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mascf_fi_tcl_RequestAudioRouteItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> u8Reason);
   (tVoid) (oIn >> e8Activity);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_RequestAudioRouteItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << u8Reason);
   (tVoid) (oOut << e8Activity);
   return oOut;
}

tBool mascf_fi_tcl_RequestAudioRouteItem::operator==(const mascf_fi_tcl_RequestAudioRouteItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (u8Reason == roRef.u8Reason);
   bResult = bResult && (e8Activity == roRef.e8Activity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_AudioProperty::mascf_fi_tcl_e8_AudioProperty():enType(FI_EN_AUDIO_PROP_VOLUME_LOCK) {}

tS32 mascf_fi_tcl_e8_AudioProperty::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_AUDIOPROPERTY;
}


mascf_fi_tcl_e8_AudioProperty::~mascf_fi_tcl_e8_AudioProperty()
{}

tU32 mascf_fi_tcl_e8_AudioProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_AudioProperty::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_AudioProperty::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_b32MuteReason::mascf_fi_tcl_b32MuteReason():u32Value(0)
{}

tS32 mascf_fi_tcl_b32MuteReason::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_B32MUTEREASON;
}


mascf_fi_tcl_b32MuteReason::~mascf_fi_tcl_b32MuteReason()
{}

tU32 mascf_fi_tcl_b32MuteReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_fi_tcl_b32MuteReason::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& mascf_fi_tcl_b32MuteReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_MuteState::mascf_fi_tcl_e8_MuteState():enType(FI_EN_MUTE) {}

tS32 mascf_fi_tcl_e8_MuteState::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_MUTESTATE;
}


mascf_fi_tcl_e8_MuteState::~mascf_fi_tcl_e8_MuteState()
{}

tU32 mascf_fi_tcl_e8_MuteState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_MuteState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_MuteState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_MuteRequestItem::mascf_fi_tcl_MuteRequestItem(const mascf_fi_tcl_MuteRequestItem& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   u8Source = coRef.u8Source;
   u8Action = coRef.u8Action;
   u32Reason = coRef.u32Reason;
}
mascf_fi_tcl_MuteRequestItem& mascf_fi_tcl_MuteRequestItem::operator=(const mascf_fi_tcl_MuteRequestItem& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u8Action = coRef.u8Action;
   u32Reason = coRef.u32Reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_MuteRequestItem::mascf_fi_tcl_MuteRequestItem()
:u8Source()
,u8Action()
,u32Reason()
 {}

tS32 mascf_fi_tcl_MuteRequestItem::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_MUTEREQUESTITEM;
}


mascf_fi_tcl_MuteRequestItem::~mascf_fi_tcl_MuteRequestItem()
{}

tU32 mascf_fi_tcl_MuteRequestItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mascf_fi_tcl_MuteRequestItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u8Action);
   (tVoid) (oIn >> u32Reason);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_MuteRequestItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u8Action);
   (tVoid) (oOut << u32Reason);
   return oOut;
}

tBool mascf_fi_tcl_MuteRequestItem::operator==(const mascf_fi_tcl_MuteRequestItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u8Action == roRef.u8Action);
   bResult = bResult && (u32Reason == roRef.u32Reason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8_MuteRequester::mascf_fi_tcl_e8_MuteRequester():enType(FI_EN_AUDIOROUTINGMANAGER) {}

tS32 mascf_fi_tcl_e8_MuteRequester::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8_MUTEREQUESTER;
}


mascf_fi_tcl_e8_MuteRequester::~mascf_fi_tcl_e8_MuteRequester()
{}

tU32 mascf_fi_tcl_e8_MuteRequester::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8_MuteRequester::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8_MuteRequester::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_e8MuteSpeed::mascf_fi_tcl_e8MuteSpeed():enType(FI_EN_VERY_FAST) {}

tS32 mascf_fi_tcl_e8MuteSpeed::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_E8MUTESPEED;
}


mascf_fi_tcl_e8MuteSpeed::~mascf_fi_tcl_e8MuteSpeed()
{}

tU32 mascf_fi_tcl_e8MuteSpeed::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_fi_tcl_e8MuteSpeed::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_e8MuteSpeed::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_SetAudioPropertyItem::mascf_fi_tcl_SetAudioPropertyItem(const mascf_fi_tcl_SetAudioPropertyItem& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
}
mascf_fi_tcl_SetAudioPropertyItem& mascf_fi_tcl_SetAudioPropertyItem::operator=(const mascf_fi_tcl_SetAudioPropertyItem& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_SetAudioPropertyItem::mascf_fi_tcl_SetAudioPropertyItem()
:u8Source()
,u16SubSource(0)
,u8Property()
,s32PropValue(0)
 {}

tS32 mascf_fi_tcl_SetAudioPropertyItem::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_SETAUDIOPROPERTYITEM;
}


mascf_fi_tcl_SetAudioPropertyItem::~mascf_fi_tcl_SetAudioPropertyItem()
{}

tU32 mascf_fi_tcl_SetAudioPropertyItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mascf_fi_tcl_SetAudioPropertyItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> u8Property);
   (tVoid) (oIn >> s32PropValue);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_SetAudioPropertyItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << u8Property);
   (tVoid) (oOut << s32PropValue);
   return oOut;
}

tBool mascf_fi_tcl_SetAudioPropertyItem::operator==(const mascf_fi_tcl_SetAudioPropertyItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (u8Property == roRef.u8Property);
   bResult = bResult && (s32PropValue == roRef.s32PropValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_fi_tcl_SourceRouteActivity::mascf_fi_tcl_SourceRouteActivity(const mascf_fi_tcl_SourceRouteActivity& coRef)
   : mascf_fi_tclVisitableTypeBase(coRef)
{
   Source = coRef.Source;
   SubSource = coRef.SubSource;
   PossibleNextSource = coRef.PossibleNextSource;
   Resource = coRef.Resource;
   Activity = coRef.Activity;
}
mascf_fi_tcl_SourceRouteActivity& mascf_fi_tcl_SourceRouteActivity::operator=(const mascf_fi_tcl_SourceRouteActivity& coRef)
{
   if (this == &coRef) return *this;
   Source = coRef.Source;
   SubSource = coRef.SubSource;
   PossibleNextSource = coRef.PossibleNextSource;
   Resource = coRef.Resource;
   Activity = coRef.Activity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_fi_tcl_SourceRouteActivity::mascf_fi_tcl_SourceRouteActivity()
:Source()
,SubSource(0)
,PossibleNextSource()
,Resource()
,Activity()
 {}

tS32 mascf_fi_tcl_SourceRouteActivity::s32GetTypeId() const
{
   return (tS32) mascf_typesfi_tclToken::EN_SOURCEROUTEACTIVITY;
}


mascf_fi_tcl_SourceRouteActivity::~mascf_fi_tcl_SourceRouteActivity()
{}

tU32 mascf_fi_tcl_SourceRouteActivity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mascf_fi_tcl_SourceRouteActivity::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> SubSource);
   (tVoid) (oIn >> PossibleNextSource);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Activity);
   return oIn;
}

fi_tclOutContext& mascf_fi_tcl_SourceRouteActivity::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Source);
   (tVoid) (oOut << SubSource);
   (tVoid) (oOut << PossibleNextSource);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Activity);
   return oOut;
}

tBool mascf_fi_tcl_SourceRouteActivity::operator==(const mascf_fi_tcl_SourceRouteActivity& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (SubSource == roRef.SubSource);
   bResult = bResult && (PossibleNextSource == roRef.PossibleNextSource);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Activity == roRef.Activity);
   return bResult;
}

