/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MASCF_MAINFITYPES_HEADER
#define MASCF_MAINFITYPES_HEADER


class mascf_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for mascf_main_fi message types

fi_tclMessageBase* mascf_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class mascf_mainfi_tclMsgBaseMessage : public mascf_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   mascf_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class mascf_mainfi_tclMsgVolumeModeMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgVolumeModeMethodStart& operator=(const mascf_mainfi_tclMsgVolumeModeMethodStart& coRef);
   mascf_mainfi_tclMsgVolumeModeMethodStart(const mascf_mainfi_tclMsgVolumeModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_VolumeMode VolumeMode;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgVolumeModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgVolumeModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeModeMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgVolumeModeMethodResult& operator=(const mascf_mainfi_tclMsgVolumeModeMethodResult& coRef);
   mascf_mainfi_tclMsgVolumeModeMethodResult(const mascf_mainfi_tclMsgVolumeModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~mascf_mainfi_tclMsgVolumeModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgVolumeModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBeepMethodStart& operator=(const mascf_mainfi_tclMsgBeepMethodStart& coRef);
   mascf_mainfi_tclMsgBeepMethodStart(const mascf_mainfi_tclMsgBeepMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioBeepType BeepType;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgBeepMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBeepMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBeepMethodResult& operator=(const mascf_mainfi_tclMsgBeepMethodResult& coRef);
   mascf_mainfi_tclMsgBeepMethodResult(const mascf_mainfi_tclMsgBeepMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~mascf_mainfi_tclMsgBeepMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBeepMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepFileMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepFileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBeepFileMethodStart& operator=(const mascf_mainfi_tclMsgBeepFileMethodStart& coRef);
   mascf_mainfi_tclMsgBeepFileMethodStart(const mascf_mainfi_tclMsgBeepFileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tclString sFilePath;
   mascf_fi_tcl_BeepConfig oConfig;
   virtual ~mascf_mainfi_tclMsgBeepFileMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBeepFileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepFileMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepFileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBeepFileMethodResult& operator=(const mascf_mainfi_tclMsgBeepFileMethodResult& coRef);
   mascf_mainfi_tclMsgBeepFileMethodResult(const mascf_mainfi_tclMsgBeepFileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   tU32 u32Token;
   virtual ~mascf_mainfi_tclMsgBeepFileMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBeepFileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMuteMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMuteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgMuteMethodStart& operator=(const mascf_mainfi_tclMsgMuteMethodStart& coRef);
   mascf_mainfi_tclMsgMuteMethodStart(const mascf_mainfi_tclMsgMuteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_MuteRequester Requester;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8MuteAction State;
   mascf_fi_tcl_b32MuteReason Reason;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgMuteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgMuteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMuteMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMuteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgMuteMethodResult& operator=(const mascf_mainfi_tclMsgMuteMethodResult& coRef);
   mascf_mainfi_tclMsgMuteMethodResult(const mascf_mainfi_tclMsgMuteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_MuteRequester Requester;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_MuteState State;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgMuteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgMuteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSet_Mute_RampMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSet_Mute_RampMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSet_Mute_RampMethodStart& operator=(const mascf_mainfi_tclMsgSet_Mute_RampMethodStart& coRef);
   mascf_mainfi_tclMsgSet_Mute_RampMethodStart(const mascf_mainfi_tclMsgSet_Mute_RampMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8MuteSpeed State;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgSet_Mute_RampMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSet_Mute_RampMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSet_Mute_RampMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSet_Mute_RampMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSet_Mute_RampMethodResult& operator=(const mascf_mainfi_tclMsgSet_Mute_RampMethodResult& coRef);
   mascf_mainfi_tclMsgSet_Mute_RampMethodResult(const mascf_mainfi_tclMsgSet_Mute_RampMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~mascf_mainfi_tclMsgSet_Mute_RampMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSet_Mute_RampMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioSourceMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioSourceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioSourceMethodStart& operator=(const mascf_mainfi_tclMsgAudioSourceMethodStart& coRef);
   mascf_mainfi_tclMsgAudioSourceMethodStart(const mascf_mainfi_tclMsgAudioSourceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudSource Source;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgAudioSourceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioSourceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioSourceMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioSourceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioSourceMethodResult& operator=(const mascf_mainfi_tclMsgAudioSourceMethodResult& coRef);
   mascf_mainfi_tclMsgAudioSourceMethodResult(const mascf_mainfi_tclMsgAudioSourceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~mascf_mainfi_tclMsgAudioSourceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioSourceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart& operator=(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart& coRef);
   mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   mascf_fi_tcl_e8_RouteNo Source;
   mascf_fi_tclString AudProcAdev;
   tU32 MsgHandle;
   mascf_fi_tcl_e8_OnGoingAction Action;
   virtual ~mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult& operator=(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult& coRef);
   mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   tU32 MsgHandle;
   virtual ~mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioTestToneMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioTestToneMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioTestToneMethodStart& operator=(const mascf_mainfi_tclMsgAudioTestToneMethodStart& coRef);
   mascf_mainfi_tclMsgAudioTestToneMethodStart(const mascf_mainfi_tclMsgAudioTestToneMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_b8_ChannelSelect ChannelSelect;
   tU32 Frequency;
   mascf_fi_tcl_Volume Volume;
   virtual ~mascf_mainfi_tclMsgAudioTestToneMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioTestToneMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioTestToneMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioTestToneMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioTestToneMethodResult& operator=(const mascf_mainfi_tclMsgAudioTestToneMethodResult& coRef);
   mascf_mainfi_tclMsgAudioTestToneMethodResult(const mascf_mainfi_tclMsgAudioTestToneMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_b8_ChannelSelect ChannelSelect;
   mascf_fi_tcl_e8_Aud_TestToneControl Status;
   virtual ~mascf_mainfi_tclMsgAudioTestToneMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioTestToneMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgCueStateMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgCueStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgCueStateMethodStart& operator=(const mascf_mainfi_tclMsgCueStateMethodStart& coRef);
   mascf_mainfi_tclMsgCueStateMethodStart(const mascf_mainfi_tclMsgCueStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_State State;
   mascf_fi_tcl_e8_AudSource Source;
   virtual ~mascf_mainfi_tclMsgCueStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgCueStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgCueStateMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgCueStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgCueStateMethodResult& operator=(const mascf_mainfi_tclMsgCueStateMethodResult& coRef);
   mascf_mainfi_tclMsgCueStateMethodResult(const mascf_mainfi_tclMsgCueStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~mascf_mainfi_tclMsgCueStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgCueStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgPerformOnVolumeLimitMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgPerformOnVolumeLimitMethodStart();

   virtual ~mascf_mainfi_tclMsgPerformOnVolumeLimitMethodStart();

   inline tBool operator==(const mascf_mainfi_tclMsgPerformOnVolumeLimitMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart& operator=(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart& coRef);
   mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_DiagMode DC_Mode;
   mascf_fi_tcl_e8_DiagMode AC_Mode;
   virtual ~mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult& operator=(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult& coRef);
   mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_DiagState Status;
   virtual ~mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSystemMuteMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSystemMuteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSystemMuteMethodStart& operator=(const mascf_mainfi_tclMsgSystemMuteMethodStart& coRef);
   mascf_mainfi_tclMsgSystemMuteMethodStart(const mascf_mainfi_tclMsgSystemMuteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_MuteRequester Requester;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8MuteAction State;
   mascf_fi_tcl_b32MuteReason Reason;
   virtual ~mascf_mainfi_tclMsgSystemMuteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSystemMuteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSystemMuteMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSystemMuteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSystemMuteMethodResult& operator=(const mascf_mainfi_tclMsgSystemMuteMethodResult& coRef);
   mascf_mainfi_tclMsgSystemMuteMethodResult(const mascf_mainfi_tclMsgSystemMuteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_MuteRequester Requester;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_MuteState State;
   virtual ~mascf_mainfi_tclMsgSystemMuteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSystemMuteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_SettingSoundMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_SettingSoundMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgADAS_SettingSoundMethodStart& operator=(const mascf_mainfi_tclMsgADAS_SettingSoundMethodStart& coRef);
   mascf_mainfi_tclMsgADAS_SettingSoundMethodStart(const mascf_mainfi_tclMsgADAS_SettingSoundMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_ADAS_Setting_Sound SettingSound;
   virtual ~mascf_mainfi_tclMsgADAS_SettingSoundMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgADAS_SettingSoundMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_SettingSoundMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_SettingSoundMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgADAS_SettingSoundMethodResult& operator=(const mascf_mainfi_tclMsgADAS_SettingSoundMethodResult& coRef);
   mascf_mainfi_tclMsgADAS_SettingSoundMethodResult(const mascf_mainfi_tclMsgADAS_SettingSoundMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~mascf_mainfi_tclMsgADAS_SettingSoundMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgADAS_SettingSoundMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEntertainmentMuteMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEntertainmentMuteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgEntertainmentMuteMethodStart& operator=(const mascf_mainfi_tclMsgEntertainmentMuteMethodStart& coRef);
   mascf_mainfi_tclMsgEntertainmentMuteMethodStart(const mascf_mainfi_tclMsgEntertainmentMuteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_MuteRequester Requester;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8MuteAction State;
   mascf_fi_tcl_b32MuteReason Reason;
   virtual ~mascf_mainfi_tclMsgEntertainmentMuteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgEntertainmentMuteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEntertainmentMuteMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEntertainmentMuteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgEntertainmentMuteMethodResult& operator=(const mascf_mainfi_tclMsgEntertainmentMuteMethodResult& coRef);
   mascf_mainfi_tclMsgEntertainmentMuteMethodResult(const mascf_mainfi_tclMsgEntertainmentMuteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_MuteRequester Requester;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_MuteState State;
   virtual ~mascf_mainfi_tclMsgEntertainmentMuteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgEntertainmentMuteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodStart : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodStart();

   virtual ~mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodStart();

   inline tBool operator==(const mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodResult : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodResult();

   virtual ~mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodResult();

   inline tBool operator==(const mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeModeStatusUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeModeStatusUpReg();

   virtual ~mascf_mainfi_tclMsgVolumeModeStatusUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeModeStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeModeStatusRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeModeStatusRelUpReg();

   virtual ~mascf_mainfi_tclMsgVolumeModeStatusRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeModeStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeModeStatusGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeModeStatusGet();

   virtual ~mascf_mainfi_tclMsgVolumeModeStatusGet();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeModeStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeModeStatusStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeModeStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgVolumeModeStatusStatus& operator=(const mascf_mainfi_tclMsgVolumeModeStatusStatus& coRef);
   mascf_mainfi_tclMsgVolumeModeStatusStatus(const mascf_mainfi_tclMsgVolumeModeStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_VolumeMode VolumeMode;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgVolumeModeStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgVolumeModeStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeUpReg();

   virtual ~mascf_mainfi_tclMsgVolumeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeRelUpReg();

   virtual ~mascf_mainfi_tclMsgVolumeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeGet();

   virtual ~mascf_mainfi_tclMsgVolumeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgVolumeSet& operator=(const mascf_mainfi_tclMsgVolumeSet& coRef);
   mascf_mainfi_tclMsgVolumeSet(const mascf_mainfi_tclMsgVolumeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioVolumeType VolumeType;
   mascf_fi_tcl_e8_ResourceNo Resource;
   tU8 Volume;
   virtual ~mascf_mainfi_tclMsgVolumeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgVolumeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgVolumeStatus& operator=(const mascf_mainfi_tclMsgVolumeStatus& coRef);
   mascf_mainfi_tclMsgVolumeStatus(const mascf_mainfi_tclMsgVolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_VolumeMode VolumeMode;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   tU8 Volume;
   mascf_fi_tcl_e8_AudSource Source;
   virtual ~mascf_mainfi_tclMsgVolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgVolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepStatusUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepStatusUpReg();

   virtual ~mascf_mainfi_tclMsgBeepStatusUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgBeepStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepStatusRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepStatusRelUpReg();

   virtual ~mascf_mainfi_tclMsgBeepStatusRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgBeepStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepStatusStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBeepStatusStatus& operator=(const mascf_mainfi_tclMsgBeepStatusStatus& coRef);
   mascf_mainfi_tclMsgBeepStatusStatus(const mascf_mainfi_tclMsgBeepStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioBeepStatus BeepStatus;
   tU32 u32Token;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgBeepStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBeepStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGalaUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGalaUpReg();

   virtual ~mascf_mainfi_tclMsgGalaUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgGalaUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGalaRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGalaRelUpReg();

   virtual ~mascf_mainfi_tclMsgGalaRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgGalaRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGalaGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGalaGet();

   virtual ~mascf_mainfi_tclMsgGalaGet();

   inline tBool operator==(const mascf_mainfi_tclMsgGalaGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGalaSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGalaSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgGalaSet& operator=(const mascf_mainfi_tclMsgGalaSet& coRef);
   mascf_mainfi_tclMsgGalaSet(const mascf_mainfi_tclMsgGalaSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_GalaLevel GalaLevel;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgGalaSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgGalaSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGalaStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGalaStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgGalaStatus& operator=(const mascf_mainfi_tclMsgGalaStatus& coRef);
   mascf_mainfi_tclMsgGalaStatus(const mascf_mainfi_tclMsgGalaStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_GalaLevel GalaLevel;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgGalaStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgGalaStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBalanceUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBalanceUpReg();

   virtual ~mascf_mainfi_tclMsgBalanceUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgBalanceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBalanceRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBalanceRelUpReg();

   virtual ~mascf_mainfi_tclMsgBalanceRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgBalanceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBalanceGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBalanceGet();

   virtual ~mascf_mainfi_tclMsgBalanceGet();

   inline tBool operator==(const mascf_mainfi_tclMsgBalanceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBalanceSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBalanceSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBalanceSet& operator=(const mascf_mainfi_tclMsgBalanceSet& coRef);
   mascf_mainfi_tclMsgBalanceSet(const mascf_mainfi_tclMsgBalanceSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioSoundType SoundType;
   mascf_fi_tcl_e8_ResourceNo Resource;
   tS8 Balance;
   virtual ~mascf_mainfi_tclMsgBalanceSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBalanceSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBalanceStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBalanceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBalanceStatus& operator=(const mascf_mainfi_tclMsgBalanceStatus& coRef);
   mascf_mainfi_tclMsgBalanceStatus(const mascf_mainfi_tclMsgBalanceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 Balance;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgBalanceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBalanceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgLoudnessUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgLoudnessUpReg();

   virtual ~mascf_mainfi_tclMsgLoudnessUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgLoudnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgLoudnessRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgLoudnessRelUpReg();

   virtual ~mascf_mainfi_tclMsgLoudnessRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgLoudnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgLoudnessGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgLoudnessGet();

   virtual ~mascf_mainfi_tclMsgLoudnessGet();

   inline tBool operator==(const mascf_mainfi_tclMsgLoudnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgLoudnessSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgLoudnessSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgLoudnessSet& operator=(const mascf_mainfi_tclMsgLoudnessSet& coRef);
   mascf_mainfi_tclMsgLoudnessSet(const mascf_mainfi_tclMsgLoudnessSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioSoundType SoundType;
   mascf_fi_tcl_e8_ResourceNo Resource;
   tU8 Loudness;
   virtual ~mascf_mainfi_tclMsgLoudnessSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgLoudnessSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgLoudnessStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgLoudnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgLoudnessStatus& operator=(const mascf_mainfi_tclMsgLoudnessStatus& coRef);
   mascf_mainfi_tclMsgLoudnessStatus(const mascf_mainfi_tclMsgLoudnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Loudness;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgLoudnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgLoudnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBassUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBassUpReg();

   virtual ~mascf_mainfi_tclMsgBassUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgBassUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBassRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBassRelUpReg();

   virtual ~mascf_mainfi_tclMsgBassRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgBassRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBassGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBassGet();

   virtual ~mascf_mainfi_tclMsgBassGet();

   inline tBool operator==(const mascf_mainfi_tclMsgBassGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBassSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBassSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBassSet& operator=(const mascf_mainfi_tclMsgBassSet& coRef);
   mascf_mainfi_tclMsgBassSet(const mascf_mainfi_tclMsgBassSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioSoundType SoundType;
   mascf_fi_tcl_e8_ResourceNo Resource;
   tS8 Bass;
   virtual ~mascf_mainfi_tclMsgBassSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBassSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBassStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBassStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBassStatus& operator=(const mascf_mainfi_tclMsgBassStatus& coRef);
   mascf_mainfi_tclMsgBassStatus(const mascf_mainfi_tclMsgBassStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 Bass;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgBassStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBassStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgTrebleUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgTrebleUpReg();

   virtual ~mascf_mainfi_tclMsgTrebleUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgTrebleUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgTrebleRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgTrebleRelUpReg();

   virtual ~mascf_mainfi_tclMsgTrebleRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgTrebleRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgTrebleGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgTrebleGet();

   virtual ~mascf_mainfi_tclMsgTrebleGet();

   inline tBool operator==(const mascf_mainfi_tclMsgTrebleGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgTrebleSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgTrebleSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgTrebleSet& operator=(const mascf_mainfi_tclMsgTrebleSet& coRef);
   mascf_mainfi_tclMsgTrebleSet(const mascf_mainfi_tclMsgTrebleSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioSoundType SoundType;
   mascf_fi_tcl_e8_ResourceNo Resource;
   tS8 Treble;
   virtual ~mascf_mainfi_tclMsgTrebleSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgTrebleSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgTrebleStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgTrebleStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgTrebleStatus& operator=(const mascf_mainfi_tclMsgTrebleStatus& coRef);
   mascf_mainfi_tclMsgTrebleStatus(const mascf_mainfi_tclMsgTrebleStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 Treble;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgTrebleStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgTrebleStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFaderUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFaderUpReg();

   virtual ~mascf_mainfi_tclMsgFaderUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgFaderUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFaderRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFaderRelUpReg();

   virtual ~mascf_mainfi_tclMsgFaderRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgFaderRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFaderGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFaderGet();

   virtual ~mascf_mainfi_tclMsgFaderGet();

   inline tBool operator==(const mascf_mainfi_tclMsgFaderGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFaderSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFaderSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgFaderSet& operator=(const mascf_mainfi_tclMsgFaderSet& coRef);
   mascf_mainfi_tclMsgFaderSet(const mascf_mainfi_tclMsgFaderSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioSoundType SoundType;
   mascf_fi_tcl_e8_ResourceNo Resource;
   tS8 Fader;
   virtual ~mascf_mainfi_tclMsgFaderSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgFaderSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFaderStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFaderStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgFaderStatus& operator=(const mascf_mainfi_tclMsgFaderStatus& coRef);
   mascf_mainfi_tclMsgFaderStatus(const mascf_mainfi_tclMsgFaderStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 Fader;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgFaderStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgFaderStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMidRangeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMidRangeUpReg();

   virtual ~mascf_mainfi_tclMsgMidRangeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgMidRangeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMidRangeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMidRangeRelUpReg();

   virtual ~mascf_mainfi_tclMsgMidRangeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgMidRangeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMidRangeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMidRangeGet();

   virtual ~mascf_mainfi_tclMsgMidRangeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgMidRangeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMidRangeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMidRangeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgMidRangeSet& operator=(const mascf_mainfi_tclMsgMidRangeSet& coRef);
   mascf_mainfi_tclMsgMidRangeSet(const mascf_mainfi_tclMsgMidRangeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioSoundType SoundType;
   mascf_fi_tcl_e8_ResourceNo Resource;
   tS8 MidRange;
   virtual ~mascf_mainfi_tclMsgMidRangeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgMidRangeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMidRangeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMidRangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgMidRangeStatus& operator=(const mascf_mainfi_tclMsgMidRangeStatus& coRef);
   mascf_mainfi_tclMsgMidRangeStatus(const mascf_mainfi_tclMsgMidRangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 MidRange;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgMidRangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgMidRangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMemSoundUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMemSoundUpReg();

   virtual ~mascf_mainfi_tclMsgMemSoundUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgMemSoundUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMemSoundRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMemSoundRelUpReg();

   virtual ~mascf_mainfi_tclMsgMemSoundRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgMemSoundRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMemSoundSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMemSoundSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgMemSoundSet& operator=(const mascf_mainfi_tclMsgMemSoundSet& coRef);
   mascf_mainfi_tclMsgMemSoundSet(const mascf_mainfi_tclMsgMemSoundSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Sound Sound;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgMemSoundSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgMemSoundSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMemSoundStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMemSoundStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgMemSoundStatus& operator=(const mascf_mainfi_tclMsgMemSoundStatus& coRef);
   mascf_mainfi_tclMsgMemSoundStatus(const mascf_mainfi_tclMsgMemSoundStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Sound Sound;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_MemStatus MemStatus;
   virtual ~mascf_mainfi_tclMsgMemSoundStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgMemSoundStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFaderActivationStatusUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFaderActivationStatusUpReg();

   virtual ~mascf_mainfi_tclMsgFaderActivationStatusUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgFaderActivationStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFaderActivationStatusRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFaderActivationStatusRelUpReg();

   virtual ~mascf_mainfi_tclMsgFaderActivationStatusRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgFaderActivationStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFaderActivationStatusGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFaderActivationStatusGet();

   virtual ~mascf_mainfi_tclMsgFaderActivationStatusGet();

   inline tBool operator==(const mascf_mainfi_tclMsgFaderActivationStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFaderActivationStatusStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFaderActivationStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgFaderActivationStatusStatus& operator=(const mascf_mainfi_tclMsgFaderActivationStatusStatus& coRef);
   mascf_mainfi_tclMsgFaderActivationStatusStatus(const mascf_mainfi_tclMsgFaderActivationStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_FaderStatus FaderStatus;
   virtual ~mascf_mainfi_tclMsgFaderActivationStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgFaderActivationStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDynamicCompressionUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDynamicCompressionUpReg();

   virtual ~mascf_mainfi_tclMsgDynamicCompressionUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgDynamicCompressionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDynamicCompressionRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDynamicCompressionRelUpReg();

   virtual ~mascf_mainfi_tclMsgDynamicCompressionRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgDynamicCompressionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDynamicCompressionGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDynamicCompressionGet();

   virtual ~mascf_mainfi_tclMsgDynamicCompressionGet();

   inline tBool operator==(const mascf_mainfi_tclMsgDynamicCompressionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDynamicCompressionSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDynamicCompressionSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgDynamicCompressionSet& operator=(const mascf_mainfi_tclMsgDynamicCompressionSet& coRef);
   mascf_mainfi_tclMsgDynamicCompressionSet(const mascf_mainfi_tclMsgDynamicCompressionSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_DynCompression DynComp;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgDynamicCompressionSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgDynamicCompressionSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDynamicCompressionStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDynamicCompressionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgDynamicCompressionStatus& operator=(const mascf_mainfi_tclMsgDynamicCompressionStatus& coRef);
   mascf_mainfi_tclMsgDynamicCompressionStatus(const mascf_mainfi_tclMsgDynamicCompressionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_DynCompression DynCompression;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgDynamicCompressionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgDynamicCompressionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOptimizationUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOptimizationUpReg();

   virtual ~mascf_mainfi_tclMsgOptimizationUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgOptimizationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOptimizationRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOptimizationRelUpReg();

   virtual ~mascf_mainfi_tclMsgOptimizationRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgOptimizationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOptimizationGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOptimizationGet();

   virtual ~mascf_mainfi_tclMsgOptimizationGet();

   inline tBool operator==(const mascf_mainfi_tclMsgOptimizationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOptimizationSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOptimizationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgOptimizationSet& operator=(const mascf_mainfi_tclMsgOptimizationSet& coRef);
   mascf_mainfi_tclMsgOptimizationSet(const mascf_mainfi_tclMsgOptimizationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Optimization Optimization;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgOptimizationSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgOptimizationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOptimizationStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOptimizationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgOptimizationStatus& operator=(const mascf_mainfi_tclMsgOptimizationStatus& coRef);
   mascf_mainfi_tclMsgOptimizationStatus(const mascf_mainfi_tclMsgOptimizationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Optimization Optimization;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgOptimizationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgOptimizationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEqualiserPresetUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEqualiserPresetUpReg();

   virtual ~mascf_mainfi_tclMsgEqualiserPresetUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgEqualiserPresetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEqualiserPresetRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEqualiserPresetRelUpReg();

   virtual ~mascf_mainfi_tclMsgEqualiserPresetRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgEqualiserPresetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEqualiserPresetGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEqualiserPresetGet();

   virtual ~mascf_mainfi_tclMsgEqualiserPresetGet();

   inline tBool operator==(const mascf_mainfi_tclMsgEqualiserPresetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEqualiserPresetSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEqualiserPresetSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgEqualiserPresetSet& operator=(const mascf_mainfi_tclMsgEqualiserPresetSet& coRef);
   mascf_mainfi_tclMsgEqualiserPresetSet(const mascf_mainfi_tclMsgEqualiserPresetSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_EquPresets EquPreset;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgEqualiserPresetSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgEqualiserPresetSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEqualiserPresetStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEqualiserPresetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgEqualiserPresetStatus& operator=(const mascf_mainfi_tclMsgEqualiserPresetStatus& coRef);
   mascf_mainfi_tclMsgEqualiserPresetStatus(const mascf_mainfi_tclMsgEqualiserPresetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_EquPresets EquPreset;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgEqualiserPresetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgEqualiserPresetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDiagAudModeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDiagAudModeUpReg();

   virtual ~mascf_mainfi_tclMsgDiagAudModeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgDiagAudModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDiagAudModeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDiagAudModeRelUpReg();

   virtual ~mascf_mainfi_tclMsgDiagAudModeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgDiagAudModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDiagAudModeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDiagAudModeGet();

   virtual ~mascf_mainfi_tclMsgDiagAudModeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgDiagAudModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDiagAudModeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDiagAudModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgDiagAudModeSet& operator=(const mascf_mainfi_tclMsgDiagAudModeSet& coRef);
   mascf_mainfi_tclMsgDiagAudModeSet(const mascf_mainfi_tclMsgDiagAudModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_DiagAudMode DiagAudMode;
   mascf_fi_tcl_e8_GenericDiagAudMode OnVolLimiterMode;
   mascf_fi_tcl_e8_GenericDiagAudMode MuteRampMode;
   mascf_fi_tcl_e8_GenericDiagAudMode VolumeRampMode;
   mascf_fi_tcl_e8_GenericDiagAudMode clippingMode;
   mascf_fi_tcl_e8_GenericDiagAudMode PresetMode;
   virtual ~mascf_mainfi_tclMsgDiagAudModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgDiagAudModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDiagAudModeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDiagAudModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgDiagAudModeStatus& operator=(const mascf_mainfi_tclMsgDiagAudModeStatus& coRef);
   mascf_mainfi_tclMsgDiagAudModeStatus(const mascf_mainfi_tclMsgDiagAudModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_DiagAudMode DiagAudMode;
   mascf_fi_tcl_e8_GenericDiagAudMode OnVolLimiterMode;
   mascf_fi_tcl_e8_GenericDiagAudMode MuteRampMode;
   mascf_fi_tcl_e8_GenericDiagAudMode VolumeRampMode;
   mascf_fi_tcl_e8_GenericDiagAudMode clippingMode;
   mascf_fi_tcl_e8_GenericDiagAudMode PresetMode;
   virtual ~mascf_mainfi_tclMsgDiagAudModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgDiagAudModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAuxInLevelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAuxInLevelUpReg();

   virtual ~mascf_mainfi_tclMsgAuxInLevelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAuxInLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAuxInLevelRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAuxInLevelRelUpReg();

   virtual ~mascf_mainfi_tclMsgAuxInLevelRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAuxInLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAuxInLevelGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAuxInLevelGet();

   virtual ~mascf_mainfi_tclMsgAuxInLevelGet();

   inline tBool operator==(const mascf_mainfi_tclMsgAuxInLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAuxInLevelSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAuxInLevelSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAuxInLevelSet& operator=(const mascf_mainfi_tclMsgAuxInLevelSet& coRef);
   mascf_mainfi_tclMsgAuxInLevelSet(const mascf_mainfi_tclMsgAuxInLevelSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AuxInLevel AuxInLevel;
   virtual ~mascf_mainfi_tclMsgAuxInLevelSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAuxInLevelSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAuxInLevelStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAuxInLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAuxInLevelStatus& operator=(const mascf_mainfi_tclMsgAuxInLevelStatus& coRef);
   mascf_mainfi_tclMsgAuxInLevelStatus(const mascf_mainfi_tclMsgAuxInLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AuxInLevel AuxInLevel;
   virtual ~mascf_mainfi_tclMsgAuxInLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAuxInLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepLevelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepLevelUpReg();

   virtual ~mascf_mainfi_tclMsgBeepLevelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgBeepLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepLevelRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepLevelRelUpReg();

   virtual ~mascf_mainfi_tclMsgBeepLevelRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgBeepLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepLevelGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepLevelGet();

   virtual ~mascf_mainfi_tclMsgBeepLevelGet();

   inline tBool operator==(const mascf_mainfi_tclMsgBeepLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepLevelSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepLevelSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBeepLevelSet& operator=(const mascf_mainfi_tclMsgBeepLevelSet& coRef);
   mascf_mainfi_tclMsgBeepLevelSet(const mascf_mainfi_tclMsgBeepLevelSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_BeepLevel BeepLevel;
   virtual ~mascf_mainfi_tclMsgBeepLevelSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBeepLevelSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBeepLevelStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBeepLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBeepLevelStatus& operator=(const mascf_mainfi_tclMsgBeepLevelStatus& coRef);
   mascf_mainfi_tclMsgBeepLevelStatus(const mascf_mainfi_tclMsgBeepLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_BeepLevel BeepLevel;
   virtual ~mascf_mainfi_tclMsgBeepLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBeepLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRear_MuteUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRear_MuteUpReg();

   virtual ~mascf_mainfi_tclMsgRear_MuteUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRear_MuteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRear_MuteRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRear_MuteRelUpReg();

   virtual ~mascf_mainfi_tclMsgRear_MuteRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRear_MuteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRear_MuteGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRear_MuteGet();

   virtual ~mascf_mainfi_tclMsgRear_MuteGet();

   inline tBool operator==(const mascf_mainfi_tclMsgRear_MuteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRear_MuteSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRear_MuteSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRear_MuteSet& operator=(const mascf_mainfi_tclMsgRear_MuteSet& coRef);
   mascf_mainfi_tclMsgRear_MuteSet(const mascf_mainfi_tclMsgRear_MuteSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Rear_Mute Rear_Mute;
   virtual ~mascf_mainfi_tclMsgRear_MuteSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRear_MuteSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRear_MuteStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRear_MuteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRear_MuteStatus& operator=(const mascf_mainfi_tclMsgRear_MuteStatus& coRef);
   mascf_mainfi_tclMsgRear_MuteStatus(const mascf_mainfi_tclMsgRear_MuteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Rear_Mute Rear_Mute;
   virtual ~mascf_mainfi_tclMsgRear_MuteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRear_MuteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGeometry_ModeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGeometry_ModeUpReg();

   virtual ~mascf_mainfi_tclMsgGeometry_ModeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgGeometry_ModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGeometry_ModeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGeometry_ModeRelUpReg();

   virtual ~mascf_mainfi_tclMsgGeometry_ModeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgGeometry_ModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGeometry_ModeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGeometry_ModeGet();

   virtual ~mascf_mainfi_tclMsgGeometry_ModeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgGeometry_ModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGeometry_ModeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGeometry_ModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgGeometry_ModeSet& operator=(const mascf_mainfi_tclMsgGeometry_ModeSet& coRef);
   mascf_mainfi_tclMsgGeometry_ModeSet(const mascf_mainfi_tclMsgGeometry_ModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Geometry_Mode Geometry_Mode;
   virtual ~mascf_mainfi_tclMsgGeometry_ModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgGeometry_ModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGeometry_ModeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGeometry_ModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgGeometry_ModeStatus& operator=(const mascf_mainfi_tclMsgGeometry_ModeStatus& coRef);
   mascf_mainfi_tclMsgGeometry_ModeStatus(const mascf_mainfi_tclMsgGeometry_ModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Geometry_Mode Geometry_Mode;
   virtual ~mascf_mainfi_tclMsgGeometry_ModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgGeometry_ModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgLSValueStatusUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgLSValueStatusUpReg();

   virtual ~mascf_mainfi_tclMsgLSValueStatusUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgLSValueStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgLSValueStatusRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgLSValueStatusRelUpReg();

   virtual ~mascf_mainfi_tclMsgLSValueStatusRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgLSValueStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgLSValueStatusGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgLSValueStatusGet();

   virtual ~mascf_mainfi_tclMsgLSValueStatusGet();

   inline tBool operator==(const mascf_mainfi_tclMsgLSValueStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgLSValueStatusStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgLSValueStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgLSValueStatusStatus& operator=(const mascf_mainfi_tclMsgLSValueStatusStatus& coRef);
   mascf_mainfi_tclMsgLSValueStatusStatus(const mascf_mainfi_tclMsgLSValueStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NaviSetupLs;
   virtual ~mascf_mainfi_tclMsgLSValueStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgLSValueStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgPDCAttenuationLevelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgPDCAttenuationLevelUpReg();

   virtual ~mascf_mainfi_tclMsgPDCAttenuationLevelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgPDCAttenuationLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgPDCAttenuationLevelRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgPDCAttenuationLevelRelUpReg();

   virtual ~mascf_mainfi_tclMsgPDCAttenuationLevelRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgPDCAttenuationLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgPDCAttenuationLevelGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgPDCAttenuationLevelGet();

   virtual ~mascf_mainfi_tclMsgPDCAttenuationLevelGet();

   inline tBool operator==(const mascf_mainfi_tclMsgPDCAttenuationLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgPDCAttenuationLevelSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgPDCAttenuationLevelSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgPDCAttenuationLevelSet& operator=(const mascf_mainfi_tclMsgPDCAttenuationLevelSet& coRef);
   mascf_mainfi_tclMsgPDCAttenuationLevelSet(const mascf_mainfi_tclMsgPDCAttenuationLevelSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PDCAttenutionLevel;
   virtual ~mascf_mainfi_tclMsgPDCAttenuationLevelSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgPDCAttenuationLevelSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgPDCAttenuationLevelStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgPDCAttenuationLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgPDCAttenuationLevelStatus& operator=(const mascf_mainfi_tclMsgPDCAttenuationLevelStatus& coRef);
   mascf_mainfi_tclMsgPDCAttenuationLevelStatus(const mascf_mainfi_tclMsgPDCAttenuationLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PDCAttenuationLevel;
   virtual ~mascf_mainfi_tclMsgPDCAttenuationLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgPDCAttenuationLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgPDCAttenuationUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgPDCAttenuationUpReg();

   virtual ~mascf_mainfi_tclMsgPDCAttenuationUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgPDCAttenuationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgPDCAttenuationRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgPDCAttenuationRelUpReg();

   virtual ~mascf_mainfi_tclMsgPDCAttenuationRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgPDCAttenuationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgPDCAttenuationGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgPDCAttenuationGet();

   virtual ~mascf_mainfi_tclMsgPDCAttenuationGet();

   inline tBool operator==(const mascf_mainfi_tclMsgPDCAttenuationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgPDCAttenuationSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgPDCAttenuationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgPDCAttenuationSet& operator=(const mascf_mainfi_tclMsgPDCAttenuationSet& coRef);
   mascf_mainfi_tclMsgPDCAttenuationSet(const mascf_mainfi_tclMsgPDCAttenuationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_PDCAttenuation PDCAttenuationCommand;
   virtual ~mascf_mainfi_tclMsgPDCAttenuationSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgPDCAttenuationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgPDCAttenuationStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgPDCAttenuationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgPDCAttenuationStatus& operator=(const mascf_mainfi_tclMsgPDCAttenuationStatus& coRef);
   mascf_mainfi_tclMsgPDCAttenuationStatus(const mascf_mainfi_tclMsgPDCAttenuationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_PDCAttenuation PDCAttenuation;
   virtual ~mascf_mainfi_tclMsgPDCAttenuationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgPDCAttenuationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioDeviceStatusUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioDeviceStatusUpReg();

   virtual ~mascf_mainfi_tclMsgAudioDeviceStatusUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioDeviceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioDeviceStatusRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioDeviceStatusRelUpReg();

   virtual ~mascf_mainfi_tclMsgAudioDeviceStatusRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioDeviceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioDeviceStatusGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioDeviceStatusGet();

   virtual ~mascf_mainfi_tclMsgAudioDeviceStatusGet();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioDeviceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioDeviceStatusStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioDeviceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioDeviceStatusStatus& operator=(const mascf_mainfi_tclMsgAudioDeviceStatusStatus& coRef);
   mascf_mainfi_tclMsgAudioDeviceStatusStatus(const mascf_mainfi_tclMsgAudioDeviceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioDevice_Availability AudioDeviceAvailability;
   virtual ~mascf_mainfi_tclMsgAudioDeviceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioDeviceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOverTempReductionUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOverTempReductionUpReg();

   virtual ~mascf_mainfi_tclMsgOverTempReductionUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgOverTempReductionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOverTempReductionRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOverTempReductionRelUpReg();

   virtual ~mascf_mainfi_tclMsgOverTempReductionRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgOverTempReductionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOverTempReductionGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOverTempReductionGet();

   virtual ~mascf_mainfi_tclMsgOverTempReductionGet();

   inline tBool operator==(const mascf_mainfi_tclMsgOverTempReductionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOverTempReductionSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOverTempReductionSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgOverTempReductionSet& operator=(const mascf_mainfi_tclMsgOverTempReductionSet& coRef);
   mascf_mainfi_tclMsgOverTempReductionSet(const mascf_mainfi_tclMsgOverTempReductionSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DownScaling_Active;
   tU8 ReductionInterval;
   virtual ~mascf_mainfi_tclMsgOverTempReductionSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgOverTempReductionSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOverTempReductionStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOverTempReductionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgOverTempReductionStatus& operator=(const mascf_mainfi_tclMsgOverTempReductionStatus& coRef);
   mascf_mainfi_tclMsgOverTempReductionStatus(const mascf_mainfi_tclMsgOverTempReductionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ActiveByCommand;
   tBool ActiveByAmplifier;
   tU8 CurrentFactor;
   tU8 ReductionInterval;
   virtual ~mascf_mainfi_tclMsgOverTempReductionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgOverTempReductionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOverTempAmplifierStatusUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOverTempAmplifierStatusUpReg();

   virtual ~mascf_mainfi_tclMsgOverTempAmplifierStatusUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgOverTempAmplifierStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOverTempAmplifierStatusRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOverTempAmplifierStatusRelUpReg();

   virtual ~mascf_mainfi_tclMsgOverTempAmplifierStatusRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgOverTempAmplifierStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOverTempAmplifierStatusGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOverTempAmplifierStatusGet();

   virtual ~mascf_mainfi_tclMsgOverTempAmplifierStatusGet();

   inline tBool operator==(const mascf_mainfi_tclMsgOverTempAmplifierStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgOverTempAmplifierStatusStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgOverTempAmplifierStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgOverTempAmplifierStatusStatus& operator=(const mascf_mainfi_tclMsgOverTempAmplifierStatusStatus& coRef);
   mascf_mainfi_tclMsgOverTempAmplifierStatusStatus(const mascf_mainfi_tclMsgOverTempAmplifierStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AmpTemperatureLevel AmpTemperatureLevel;
   virtual ~mascf_mainfi_tclMsgOverTempAmplifierStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgOverTempAmplifierStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgReadMeasurementResultUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgReadMeasurementResultUpReg();

   virtual ~mascf_mainfi_tclMsgReadMeasurementResultUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgReadMeasurementResultUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgReadMeasurementResultRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgReadMeasurementResultRelUpReg();

   virtual ~mascf_mainfi_tclMsgReadMeasurementResultRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgReadMeasurementResultRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgReadMeasurementResultGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgReadMeasurementResultGet();

   virtual ~mascf_mainfi_tclMsgReadMeasurementResultGet();

   inline tBool operator==(const mascf_mainfi_tclMsgReadMeasurementResultGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgReadMeasurementResultStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgReadMeasurementResultStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgReadMeasurementResultStatus& operator=(const mascf_mainfi_tclMsgReadMeasurementResultStatus& coRef);
   mascf_mainfi_tclMsgReadMeasurementResultStatus(const mascf_mainfi_tclMsgReadMeasurementResultStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mascf_fi_tcl_Aud_MeasurementResultItem, std::allocator<mascf_fi_tcl_Aud_MeasurementResultItem> > MeasurementResultList;
   virtual ~mascf_mainfi_tclMsgReadMeasurementResultStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgReadMeasurementResultStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgCenterUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgCenterUpReg();

   virtual ~mascf_mainfi_tclMsgCenterUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgCenterUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgCenterRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgCenterRelUpReg();

   virtual ~mascf_mainfi_tclMsgCenterRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgCenterRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgCenterGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgCenterGet();

   virtual ~mascf_mainfi_tclMsgCenterGet();

   inline tBool operator==(const mascf_mainfi_tclMsgCenterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgCenterSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgCenterSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgCenterSet& operator=(const mascf_mainfi_tclMsgCenterSet& coRef);
   mascf_mainfi_tclMsgCenterSet(const mascf_mainfi_tclMsgCenterSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioSoundType SoundType;
   mascf_fi_tcl_e8_ResourceNo Resource;
   tS16 Center;
   virtual ~mascf_mainfi_tclMsgCenterSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgCenterSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgCenterStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgCenterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgCenterStatus& operator=(const mascf_mainfi_tclMsgCenterStatus& coRef);
   mascf_mainfi_tclMsgCenterStatus(const mascf_mainfi_tclMsgCenterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 Center;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgCenterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgCenterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSubWooferUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSubWooferUpReg();

   virtual ~mascf_mainfi_tclMsgSubWooferUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSubWooferUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSubWooferRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSubWooferRelUpReg();

   virtual ~mascf_mainfi_tclMsgSubWooferRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSubWooferRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSubWooferGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSubWooferGet();

   virtual ~mascf_mainfi_tclMsgSubWooferGet();

   inline tBool operator==(const mascf_mainfi_tclMsgSubWooferGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSubWooferSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSubWooferSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSubWooferSet& operator=(const mascf_mainfi_tclMsgSubWooferSet& coRef);
   mascf_mainfi_tclMsgSubWooferSet(const mascf_mainfi_tclMsgSubWooferSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioSoundType SoundType;
   mascf_fi_tcl_e8_ResourceNo Resource;
   tS16 SubWoofer;
   virtual ~mascf_mainfi_tclMsgSubWooferSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSubWooferSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSubWooferStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSubWooferStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSubWooferStatus& operator=(const mascf_mainfi_tclMsgSubWooferStatus& coRef);
   mascf_mainfi_tclMsgSubWooferStatus(const mascf_mainfi_tclMsgSubWooferStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 SubWoofer;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgSubWooferStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSubWooferStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgExternalAmplifierConnectionStateUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgExternalAmplifierConnectionStateUpReg();

   virtual ~mascf_mainfi_tclMsgExternalAmplifierConnectionStateUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgExternalAmplifierConnectionStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgExternalAmplifierConnectionStateRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgExternalAmplifierConnectionStateRelUpReg();

   virtual ~mascf_mainfi_tclMsgExternalAmplifierConnectionStateRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgExternalAmplifierConnectionStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgExternalAmplifierConnectionStateGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgExternalAmplifierConnectionStateGet();

   virtual ~mascf_mainfi_tclMsgExternalAmplifierConnectionStateGet();

   inline tBool operator==(const mascf_mainfi_tclMsgExternalAmplifierConnectionStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus& operator=(const mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus& coRef);
   mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus(const mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ConnectionState;
   virtual ~mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGeneralSpeakerTestUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGeneralSpeakerTestUpReg();

   virtual ~mascf_mainfi_tclMsgGeneralSpeakerTestUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgGeneralSpeakerTestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGeneralSpeakerTestRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGeneralSpeakerTestRelUpReg();

   virtual ~mascf_mainfi_tclMsgGeneralSpeakerTestRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgGeneralSpeakerTestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGeneralSpeakerTestGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGeneralSpeakerTestGet();

   virtual ~mascf_mainfi_tclMsgGeneralSpeakerTestGet();

   inline tBool operator==(const mascf_mainfi_tclMsgGeneralSpeakerTestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGeneralSpeakerTestSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGeneralSpeakerTestSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgGeneralSpeakerTestSet& operator=(const mascf_mainfi_tclMsgGeneralSpeakerTestSet& coRef);
   mascf_mainfi_tclMsgGeneralSpeakerTestSet(const mascf_mainfi_tclMsgGeneralSpeakerTestSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Request;
   virtual ~mascf_mainfi_tclMsgGeneralSpeakerTestSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgGeneralSpeakerTestSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgGeneralSpeakerTestStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgGeneralSpeakerTestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgGeneralSpeakerTestStatus& operator=(const mascf_mainfi_tclMsgGeneralSpeakerTestStatus& coRef);
   mascf_mainfi_tclMsgGeneralSpeakerTestStatus(const mascf_mainfi_tclMsgGeneralSpeakerTestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SpeakerValue_1;
   tU8 SpeakerValue_2;
   tU8 SpeakerValue_3;
   tU8 SpeakerValue_4;
   tU8 SpeakerValue_5;
   virtual ~mascf_mainfi_tclMsgGeneralSpeakerTestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgGeneralSpeakerTestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCSWVersionUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCSWVersionUpReg();

   virtual ~mascf_mainfi_tclMsgANCSWVersionUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgANCSWVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCSWVersionRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCSWVersionRelUpReg();

   virtual ~mascf_mainfi_tclMsgANCSWVersionRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgANCSWVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCSWVersionGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCSWVersionGet();

   virtual ~mascf_mainfi_tclMsgANCSWVersionGet();

   inline tBool operator==(const mascf_mainfi_tclMsgANCSWVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCSWVersionStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCSWVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgANCSWVersionStatus& operator=(const mascf_mainfi_tclMsgANCSWVersionStatus& coRef);
   mascf_mainfi_tclMsgANCSWVersionStatus(const mascf_mainfi_tclMsgANCSWVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LargeVersion;
   tU8 MiddleVersion;
   tU8 SmallVersion;
   virtual ~mascf_mainfi_tclMsgANCSWVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgANCSWVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgASCSWVersionUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgASCSWVersionUpReg();

   virtual ~mascf_mainfi_tclMsgASCSWVersionUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgASCSWVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgASCSWVersionRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgASCSWVersionRelUpReg();

   virtual ~mascf_mainfi_tclMsgASCSWVersionRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgASCSWVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgASCSWVersionGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgASCSWVersionGet();

   virtual ~mascf_mainfi_tclMsgASCSWVersionGet();

   inline tBool operator==(const mascf_mainfi_tclMsgASCSWVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgASCSWVersionStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgASCSWVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgASCSWVersionStatus& operator=(const mascf_mainfi_tclMsgASCSWVersionStatus& coRef);
   mascf_mainfi_tclMsgASCSWVersionStatus(const mascf_mainfi_tclMsgASCSWVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LargeVersion;
   tU8 MiddleVersion;
   tU8 SmallVersion;
   virtual ~mascf_mainfi_tclMsgASCSWVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgASCSWVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCSettingUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCSettingUpReg();

   virtual ~mascf_mainfi_tclMsgANCASCSettingUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgANCASCSettingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCSettingRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCSettingRelUpReg();

   virtual ~mascf_mainfi_tclMsgANCASCSettingRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgANCASCSettingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCSettingGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCSettingGet();

   virtual ~mascf_mainfi_tclMsgANCASCSettingGet();

   inline tBool operator==(const mascf_mainfi_tclMsgANCASCSettingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCSettingSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCSettingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgANCASCSettingSet& operator=(const mascf_mainfi_tclMsgANCASCSettingSet& coRef);
   mascf_mainfi_tclMsgANCASCSettingSet(const mascf_mainfi_tclMsgANCASCSettingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ANCAvailability;
   tU8 ASCAvailability;
   virtual ~mascf_mainfi_tclMsgANCASCSettingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgANCASCSettingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCSettingStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCSettingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgANCASCSettingStatus& operator=(const mascf_mainfi_tclMsgANCASCSettingStatus& coRef);
   mascf_mainfi_tclMsgANCASCSettingStatus(const mascf_mainfi_tclMsgANCASCSettingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ANCAvailability;
   tU8 ASCAvailability;
   virtual ~mascf_mainfi_tclMsgANCASCSettingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgANCASCSettingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpSoftwareVersionUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpSoftwareVersionUpReg();

   virtual ~mascf_mainfi_tclMsgAmpSoftwareVersionUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpSoftwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpSoftwareVersionRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpSoftwareVersionRelUpReg();

   virtual ~mascf_mainfi_tclMsgAmpSoftwareVersionRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpSoftwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpSoftwareVersionGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpSoftwareVersionGet();

   virtual ~mascf_mainfi_tclMsgAmpSoftwareVersionGet();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpSoftwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpSoftwareVersionStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpSoftwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAmpSoftwareVersionStatus& operator=(const mascf_mainfi_tclMsgAmpSoftwareVersionStatus& coRef);
   mascf_mainfi_tclMsgAmpSoftwareVersionStatus(const mascf_mainfi_tclMsgAmpSoftwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LowerVersion;
   tU8 MiddleVersion;
   tU8 HigherVersion;
   virtual ~mascf_mainfi_tclMsgAmpSoftwareVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAmpSoftwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpParameterVersionUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpParameterVersionUpReg();

   virtual ~mascf_mainfi_tclMsgAmpParameterVersionUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpParameterVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpParameterVersionRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpParameterVersionRelUpReg();

   virtual ~mascf_mainfi_tclMsgAmpParameterVersionRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpParameterVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpParameterVersionGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpParameterVersionGet();

   virtual ~mascf_mainfi_tclMsgAmpParameterVersionGet();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpParameterVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpParameterVersionStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpParameterVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAmpParameterVersionStatus& operator=(const mascf_mainfi_tclMsgAmpParameterVersionStatus& coRef);
   mascf_mainfi_tclMsgAmpParameterVersionStatus(const mascf_mainfi_tclMsgAmpParameterVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LowerVersion;
   tU8 MiddleVersion;
   tU8 HigherVersion;
   virtual ~mascf_mainfi_tclMsgAmpParameterVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAmpParameterVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpHardwareVersionUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpHardwareVersionUpReg();

   virtual ~mascf_mainfi_tclMsgAmpHardwareVersionUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpHardwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpHardwareVersionRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpHardwareVersionRelUpReg();

   virtual ~mascf_mainfi_tclMsgAmpHardwareVersionRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpHardwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpHardwareVersionGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpHardwareVersionGet();

   virtual ~mascf_mainfi_tclMsgAmpHardwareVersionGet();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpHardwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpHardwareVersionStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpHardwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAmpHardwareVersionStatus& operator=(const mascf_mainfi_tclMsgAmpHardwareVersionStatus& coRef);
   mascf_mainfi_tclMsgAmpHardwareVersionStatus(const mascf_mainfi_tclMsgAmpHardwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LowerVersion;
   tU8 MiddleVersion;
   tU8 HigherVersion;
   virtual ~mascf_mainfi_tclMsgAmpHardwareVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAmpHardwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundVolUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundVolUpReg();

   virtual ~mascf_mainfi_tclMsgSurroundVolUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSurroundVolUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundVolRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundVolRelUpReg();

   virtual ~mascf_mainfi_tclMsgSurroundVolRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSurroundVolRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundVolGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundVolGet();

   virtual ~mascf_mainfi_tclMsgSurroundVolGet();

   inline tBool operator==(const mascf_mainfi_tclMsgSurroundVolGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundVolSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundVolSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSurroundVolSet& operator=(const mascf_mainfi_tclMsgSurroundVolSet& coRef);
   mascf_mainfi_tclMsgSurroundVolSet(const mascf_mainfi_tclMsgSurroundVolSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioSoundType SoundType;
   mascf_fi_tcl_e8_ResourceNo Resource;
   tS8 SurroundVol;
   virtual ~mascf_mainfi_tclMsgSurroundVolSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSurroundVolSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundVolStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundVolStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSurroundVolStatus& operator=(const mascf_mainfi_tclMsgSurroundVolStatus& coRef);
   mascf_mainfi_tclMsgSurroundVolStatus(const mascf_mainfi_tclMsgSurroundVolStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 SurroundVol;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_AudioChannel Channel;
   virtual ~mascf_mainfi_tclMsgSurroundVolStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSurroundVolStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioPilotModeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioPilotModeUpReg();

   virtual ~mascf_mainfi_tclMsgAudioPilotModeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioPilotModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioPilotModeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioPilotModeRelUpReg();

   virtual ~mascf_mainfi_tclMsgAudioPilotModeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioPilotModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioPilotModeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioPilotModeGet();

   virtual ~mascf_mainfi_tclMsgAudioPilotModeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioPilotModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioPilotModeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioPilotModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioPilotModeSet& operator=(const mascf_mainfi_tclMsgAudioPilotModeSet& coRef);
   mascf_mainfi_tclMsgAudioPilotModeSet(const mascf_mainfi_tclMsgAudioPilotModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AudPilotMode;
   virtual ~mascf_mainfi_tclMsgAudioPilotModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioPilotModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioPilotModeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioPilotModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioPilotModeStatus& operator=(const mascf_mainfi_tclMsgAudioPilotModeStatus& coRef);
   mascf_mainfi_tclMsgAudioPilotModeStatus(const mascf_mainfi_tclMsgAudioPilotModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AudPilotMode;
   virtual ~mascf_mainfi_tclMsgAudioPilotModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioPilotModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundModeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundModeUpReg();

   virtual ~mascf_mainfi_tclMsgSurroundModeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSurroundModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundModeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundModeRelUpReg();

   virtual ~mascf_mainfi_tclMsgSurroundModeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSurroundModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundModeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundModeGet();

   virtual ~mascf_mainfi_tclMsgSurroundModeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgSurroundModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundModeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSurroundModeSet& operator=(const mascf_mainfi_tclMsgSurroundModeSet& coRef);
   mascf_mainfi_tclMsgSurroundModeSet(const mascf_mainfi_tclMsgSurroundModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SurroundMode;
   virtual ~mascf_mainfi_tclMsgSurroundModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSurroundModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundModeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSurroundModeStatus& operator=(const mascf_mainfi_tclMsgSurroundModeStatus& coRef);
   mascf_mainfi_tclMsgSurroundModeStatus(const mascf_mainfi_tclMsgSurroundModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SurroundMode;
   virtual ~mascf_mainfi_tclMsgSurroundModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSurroundModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpDownMixModeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpDownMixModeUpReg();

   virtual ~mascf_mainfi_tclMsgAmpDownMixModeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpDownMixModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpDownMixModeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpDownMixModeRelUpReg();

   virtual ~mascf_mainfi_tclMsgAmpDownMixModeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpDownMixModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpDownMixModeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpDownMixModeGet();

   virtual ~mascf_mainfi_tclMsgAmpDownMixModeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpDownMixModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpDownMixModeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpDownMixModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAmpDownMixModeSet& operator=(const mascf_mainfi_tclMsgAmpDownMixModeSet& coRef);
   mascf_mainfi_tclMsgAmpDownMixModeSet(const mascf_mainfi_tclMsgAmpDownMixModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AmpDownMixMode;
   virtual ~mascf_mainfi_tclMsgAmpDownMixModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAmpDownMixModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpDownMixModeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpDownMixModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAmpDownMixModeStatus& operator=(const mascf_mainfi_tclMsgAmpDownMixModeStatus& coRef);
   mascf_mainfi_tclMsgAmpDownMixModeStatus(const mascf_mainfi_tclMsgAmpDownMixModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AmpDownMixMode;
   virtual ~mascf_mainfi_tclMsgAmpDownMixModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAmpDownMixModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDriverSoundModeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDriverSoundModeUpReg();

   virtual ~mascf_mainfi_tclMsgDriverSoundModeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgDriverSoundModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDriverSoundModeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDriverSoundModeRelUpReg();

   virtual ~mascf_mainfi_tclMsgDriverSoundModeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgDriverSoundModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDriverSoundModeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDriverSoundModeGet();

   virtual ~mascf_mainfi_tclMsgDriverSoundModeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgDriverSoundModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDriverSoundModeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDriverSoundModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgDriverSoundModeSet& operator=(const mascf_mainfi_tclMsgDriverSoundModeSet& coRef);
   mascf_mainfi_tclMsgDriverSoundModeSet(const mascf_mainfi_tclMsgDriverSoundModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DriverMode;
   virtual ~mascf_mainfi_tclMsgDriverSoundModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgDriverSoundModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDriverSoundModeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDriverSoundModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgDriverSoundModeStatus& operator=(const mascf_mainfi_tclMsgDriverSoundModeStatus& coRef);
   mascf_mainfi_tclMsgDriverSoundModeStatus(const mascf_mainfi_tclMsgDriverSoundModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DriverMode;
   virtual ~mascf_mainfi_tclMsgDriverSoundModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgDriverSoundModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRearSoundModeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRearSoundModeUpReg();

   virtual ~mascf_mainfi_tclMsgRearSoundModeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRearSoundModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRearSoundModeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRearSoundModeRelUpReg();

   virtual ~mascf_mainfi_tclMsgRearSoundModeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRearSoundModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRearSoundModeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRearSoundModeGet();

   virtual ~mascf_mainfi_tclMsgRearSoundModeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgRearSoundModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRearSoundModeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRearSoundModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRearSoundModeSet& operator=(const mascf_mainfi_tclMsgRearSoundModeSet& coRef);
   mascf_mainfi_tclMsgRearSoundModeSet(const mascf_mainfi_tclMsgRearSoundModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RearMode;
   virtual ~mascf_mainfi_tclMsgRearSoundModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRearSoundModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRearSoundModeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRearSoundModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRearSoundModeStatus& operator=(const mascf_mainfi_tclMsgRearSoundModeStatus& coRef);
   mascf_mainfi_tclMsgRearSoundModeStatus(const mascf_mainfi_tclMsgRearSoundModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RearMode;
   virtual ~mascf_mainfi_tclMsgRearSoundModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRearSoundModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioOFFMuteStateUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioOFFMuteStateUpReg();

   virtual ~mascf_mainfi_tclMsgAudioOFFMuteStateUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioOFFMuteStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioOFFMuteStateRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioOFFMuteStateRelUpReg();

   virtual ~mascf_mainfi_tclMsgAudioOFFMuteStateRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioOFFMuteStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioOFFMuteStateSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioOFFMuteStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioOFFMuteStateSet& operator=(const mascf_mainfi_tclMsgAudioOFFMuteStateSet& coRef);
   mascf_mainfi_tclMsgAudioOFFMuteStateSet(const mascf_mainfi_tclMsgAudioOFFMuteStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MuteState;
   virtual ~mascf_mainfi_tclMsgAudioOFFMuteStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioOFFMuteStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioOFFMuteStateStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioOFFMuteStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioOFFMuteStateStatus& operator=(const mascf_mainfi_tclMsgAudioOFFMuteStateStatus& coRef);
   mascf_mainfi_tclMsgAudioOFFMuteStateStatus(const mascf_mainfi_tclMsgAudioOFFMuteStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MuteState;
   virtual ~mascf_mainfi_tclMsgAudioOFFMuteStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioOFFMuteStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMicrophoneConnectionStatusUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMicrophoneConnectionStatusUpReg();

   virtual ~mascf_mainfi_tclMsgMicrophoneConnectionStatusUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgMicrophoneConnectionStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMicrophoneConnectionStatusRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMicrophoneConnectionStatusRelUpReg();

   virtual ~mascf_mainfi_tclMsgMicrophoneConnectionStatusRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgMicrophoneConnectionStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMicrophoneConnectionStatusGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMicrophoneConnectionStatusGet();

   virtual ~mascf_mainfi_tclMsgMicrophoneConnectionStatusGet();

   inline tBool operator==(const mascf_mainfi_tclMsgMicrophoneConnectionStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus& operator=(const mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus& coRef);
   mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus(const mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_MicrophoneConnectionStatusList MicrophoneConnectionStatusList;
   virtual ~mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgConnectionUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgConnectionUpReg();

   virtual ~mascf_mainfi_tclMsgConnectionUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgConnectionRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgConnectionRelUpReg();

   virtual ~mascf_mainfi_tclMsgConnectionRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgConnectionGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgConnectionGet();

   virtual ~mascf_mainfi_tclMsgConnectionGet();

   inline tBool operator==(const mascf_mainfi_tclMsgConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgConnectionStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgConnectionStatus& operator=(const mascf_mainfi_tclMsgConnectionStatus& coRef);
   mascf_mainfi_tclMsgConnectionStatus(const mascf_mainfi_tclMsgConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mascf_fi_tcl_BOSE_UnitConnectionStatus, std::allocator<mascf_fi_tcl_BOSE_UnitConnectionStatus> > arConnectionStatusList;
   virtual ~mascf_mainfi_tclMsgConnectionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeListUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeListUpReg();

   virtual ~mascf_mainfi_tclMsgVolumeListUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeListRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeListRelUpReg();

   virtual ~mascf_mainfi_tclMsgVolumeListRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeListGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeListGet();

   virtual ~mascf_mainfi_tclMsgVolumeListGet();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeListSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgVolumeListSet& operator=(const mascf_mainfi_tclMsgVolumeListSet& coRef);
   mascf_mainfi_tclMsgVolumeListSet(const mascf_mainfi_tclMsgVolumeListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_Aud_VolumeStatusList AudVolumeList;
   virtual ~mascf_mainfi_tclMsgVolumeListSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgVolumeListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeListStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgVolumeListStatus& operator=(const mascf_mainfi_tclMsgVolumeListStatus& coRef);
   mascf_mainfi_tclMsgVolumeListStatus(const mascf_mainfi_tclMsgVolumeListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_Aud_VolumeStatusList AudVolumeList;
   virtual ~mascf_mainfi_tclMsgVolumeListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgVolumeListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBTAudioInLevelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBTAudioInLevelUpReg();

   virtual ~mascf_mainfi_tclMsgBTAudioInLevelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgBTAudioInLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBTAudioInLevelRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBTAudioInLevelRelUpReg();

   virtual ~mascf_mainfi_tclMsgBTAudioInLevelRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgBTAudioInLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBTAudioInLevelGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBTAudioInLevelGet();

   virtual ~mascf_mainfi_tclMsgBTAudioInLevelGet();

   inline tBool operator==(const mascf_mainfi_tclMsgBTAudioInLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBTAudioInLevelSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBTAudioInLevelSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBTAudioInLevelSet& operator=(const mascf_mainfi_tclMsgBTAudioInLevelSet& coRef);
   mascf_mainfi_tclMsgBTAudioInLevelSet(const mascf_mainfi_tclMsgBTAudioInLevelSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_BTAudioInLevel BTAudioInLevel;
   virtual ~mascf_mainfi_tclMsgBTAudioInLevelSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBTAudioInLevelSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgBTAudioInLevelStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgBTAudioInLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgBTAudioInLevelStatus& operator=(const mascf_mainfi_tclMsgBTAudioInLevelStatus& coRef);
   mascf_mainfi_tclMsgBTAudioInLevelStatus(const mascf_mainfi_tclMsgBTAudioInLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_BTAudioInLevel BTAudioInLevel;
   virtual ~mascf_mainfi_tclMsgBTAudioInLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgBTAudioInLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEngineeringDataUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEngineeringDataUpReg();

   virtual ~mascf_mainfi_tclMsgEngineeringDataUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgEngineeringDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEngineeringDataRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEngineeringDataRelUpReg();

   virtual ~mascf_mainfi_tclMsgEngineeringDataRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgEngineeringDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEngineeringDataGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEngineeringDataGet();

   virtual ~mascf_mainfi_tclMsgEngineeringDataGet();

   inline tBool operator==(const mascf_mainfi_tclMsgEngineeringDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEngineeringDataSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEngineeringDataSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgEngineeringDataSet& operator=(const mascf_mainfi_tclMsgEngineeringDataSet& coRef);
   mascf_mainfi_tclMsgEngineeringDataSet(const mascf_mainfi_tclMsgEngineeringDataSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_Aud_EDStatusList EngineeringDataList;
   virtual ~mascf_mainfi_tclMsgEngineeringDataSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgEngineeringDataSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEngineeringDataStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEngineeringDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgEngineeringDataStatus& operator=(const mascf_mainfi_tclMsgEngineeringDataStatus& coRef);
   mascf_mainfi_tclMsgEngineeringDataStatus(const mascf_mainfi_tclMsgEngineeringDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_Aud_EDStatusList EngineeringDataList;
   virtual ~mascf_mainfi_tclMsgEngineeringDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgEngineeringDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundSettingUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundSettingUpReg();

   virtual ~mascf_mainfi_tclMsgSurroundSettingUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSurroundSettingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundSettingRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundSettingRelUpReg();

   virtual ~mascf_mainfi_tclMsgSurroundSettingRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSurroundSettingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundSettingGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundSettingGet();

   virtual ~mascf_mainfi_tclMsgSurroundSettingGet();

   inline tBool operator==(const mascf_mainfi_tclMsgSurroundSettingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundSettingSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundSettingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSurroundSettingSet& operator=(const mascf_mainfi_tclMsgSurroundSettingSet& coRef);
   mascf_mainfi_tclMsgSurroundSettingSet(const mascf_mainfi_tclMsgSurroundSettingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_SurroundSetting Surround;
   virtual ~mascf_mainfi_tclMsgSurroundSettingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSurroundSettingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSurroundSettingStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSurroundSettingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSurroundSettingStatus& operator=(const mascf_mainfi_tclMsgSurroundSettingStatus& coRef);
   mascf_mainfi_tclMsgSurroundSettingStatus(const mascf_mainfi_tclMsgSurroundSettingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_SurroundSetting Surround;
   virtual ~mascf_mainfi_tclMsgSurroundSettingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSurroundSettingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeLockUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeLockUpReg();

   virtual ~mascf_mainfi_tclMsgVolumeLockUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeLockUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeLockRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeLockRelUpReg();

   virtual ~mascf_mainfi_tclMsgVolumeLockRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeLockRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeLockGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeLockGet();

   virtual ~mascf_mainfi_tclMsgVolumeLockGet();

   inline tBool operator==(const mascf_mainfi_tclMsgVolumeLockGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeLockSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeLockSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgVolumeLockSet& operator=(const mascf_mainfi_tclMsgVolumeLockSet& coRef);
   mascf_mainfi_tclMsgVolumeLockSet(const mascf_mainfi_tclMsgVolumeLockSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_VolumeLock VolumeLockType;
   mascf_fi_tcl_e8_Requester Requester;
   virtual ~mascf_mainfi_tclMsgVolumeLockSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgVolumeLockSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgVolumeLockStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgVolumeLockStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgVolumeLockStatus& operator=(const mascf_mainfi_tclMsgVolumeLockStatus& coRef);
   mascf_mainfi_tclMsgVolumeLockStatus(const mascf_mainfi_tclMsgVolumeLockStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_VolumeLock VolumeLockType;
   mascf_fi_tcl_e8_Requester Requester;
   virtual ~mascf_mainfi_tclMsgVolumeLockStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgVolumeLockStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpAvailFunctionUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpAvailFunctionUpReg();

   virtual ~mascf_mainfi_tclMsgAmpAvailFunctionUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpAvailFunctionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpAvailFunctionRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpAvailFunctionRelUpReg();

   virtual ~mascf_mainfi_tclMsgAmpAvailFunctionRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpAvailFunctionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpAvailFunctionGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpAvailFunctionGet();

   virtual ~mascf_mainfi_tclMsgAmpAvailFunctionGet();

   inline tBool operator==(const mascf_mainfi_tclMsgAmpAvailFunctionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAmpAvailFunctionStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAmpAvailFunctionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAmpAvailFunctionStatus& operator=(const mascf_mainfi_tclMsgAmpAvailFunctionStatus& coRef);
   mascf_mainfi_tclMsgAmpAvailFunctionStatus(const mascf_mainfi_tclMsgAmpAvailFunctionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Bass;
   tBool Middle;
   tBool Treble;
   tBool Balance;
   tBool Fader;
   tBool AudioPilot;
   tBool Gala;
   tBool SurroundMode;
   tBool SubWoofer;
   tBool Staging;
   tBool RoomEffect;
   tBool Loudness;
   tBool AGC;
   tBool AmpDownMix;
   tBool SurroundVol;
   tBool RearSoundMode;
   tBool DriverSoundMode;
   tBool ANC;
   tBool ASC;
   tBool SoundAmbiance;
   tBool ESE;
   virtual ~mascf_mainfi_tclMsgAmpAvailFunctionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAmpAvailFunctionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSetAudioPropertyUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSetAudioPropertyUpReg();

   virtual ~mascf_mainfi_tclMsgSetAudioPropertyUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSetAudioPropertyUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSetAudioPropertyRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSetAudioPropertyRelUpReg();

   virtual ~mascf_mainfi_tclMsgSetAudioPropertyRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSetAudioPropertyRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSetAudioPropertyGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSetAudioPropertyGet();

   virtual ~mascf_mainfi_tclMsgSetAudioPropertyGet();

   inline tBool operator==(const mascf_mainfi_tclMsgSetAudioPropertyGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSetAudioPropertySet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSetAudioPropertySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSetAudioPropertySet& operator=(const mascf_mainfi_tclMsgSetAudioPropertySet& coRef);
   mascf_mainfi_tclMsgSetAudioPropertySet(const mascf_mainfi_tclMsgSetAudioPropertySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudSource u8Source;
   mascf_fi_tcl_e8_AudioProperty u8Property;
   tS32 s32PropValue;
   virtual ~mascf_mainfi_tclMsgSetAudioPropertySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSetAudioPropertySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSetAudioPropertyStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSetAudioPropertyStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSetAudioPropertyStatus& operator=(const mascf_mainfi_tclMsgSetAudioPropertyStatus& coRef);
   mascf_mainfi_tclMsgSetAudioPropertyStatus(const mascf_mainfi_tclMsgSetAudioPropertyStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudSource u8Source;
   mascf_fi_tcl_e8_AudioProperty u8Property;
   tS32 s32PropValue;
   virtual ~mascf_mainfi_tclMsgSetAudioPropertyStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSetAudioPropertyStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEntOnVolumeSetupUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEntOnVolumeSetupUpReg();

   virtual ~mascf_mainfi_tclMsgEntOnVolumeSetupUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgEntOnVolumeSetupUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEntOnVolumeSetupRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEntOnVolumeSetupRelUpReg();

   virtual ~mascf_mainfi_tclMsgEntOnVolumeSetupRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgEntOnVolumeSetupRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEntOnVolumeSetupSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEntOnVolumeSetupSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgEntOnVolumeSetupSet& operator=(const mascf_mainfi_tclMsgEntOnVolumeSetupSet& coRef);
   mascf_mainfi_tclMsgEntOnVolumeSetupSet(const mascf_mainfi_tclMsgEntOnVolumeSetupSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LimitValue;
   mascf_fi_tcl_e8_AudioSoundType SoundType;
   virtual ~mascf_mainfi_tclMsgEntOnVolumeSetupSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgEntOnVolumeSetupSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgEntOnVolumeSetupStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgEntOnVolumeSetupStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgEntOnVolumeSetupStatus& operator=(const mascf_mainfi_tclMsgEntOnVolumeSetupStatus& coRef);
   mascf_mainfi_tclMsgEntOnVolumeSetupStatus(const mascf_mainfi_tclMsgEntOnVolumeSetupStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LimitValue;
   virtual ~mascf_mainfi_tclMsgEntOnVolumeSetupStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgEntOnVolumeSetupStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRoomEffectUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRoomEffectUpReg();

   virtual ~mascf_mainfi_tclMsgRoomEffectUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRoomEffectUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRoomEffectRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRoomEffectRelUpReg();

   virtual ~mascf_mainfi_tclMsgRoomEffectRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRoomEffectRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRoomEffectGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRoomEffectGet();

   virtual ~mascf_mainfi_tclMsgRoomEffectGet();

   inline tBool operator==(const mascf_mainfi_tclMsgRoomEffectGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRoomEffectSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRoomEffectSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRoomEffectSet& operator=(const mascf_mainfi_tclMsgRoomEffectSet& coRef);
   mascf_mainfi_tclMsgRoomEffectSet(const mascf_mainfi_tclMsgRoomEffectSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_RoomEffect RoomEffect;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgRoomEffectSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRoomEffectSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRoomEffectStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRoomEffectStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRoomEffectStatus& operator=(const mascf_mainfi_tclMsgRoomEffectStatus& coRef);
   mascf_mainfi_tclMsgRoomEffectStatus(const mascf_mainfi_tclMsgRoomEffectStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_RoomEffect RoomEffect;
   mascf_fi_tcl_e8_ResourceNo Resource;
   virtual ~mascf_mainfi_tclMsgRoomEffectStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRoomEffectStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFMEnhancerModeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFMEnhancerModeUpReg();

   virtual ~mascf_mainfi_tclMsgFMEnhancerModeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgFMEnhancerModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFMEnhancerModeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFMEnhancerModeRelUpReg();

   virtual ~mascf_mainfi_tclMsgFMEnhancerModeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgFMEnhancerModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFMEnhancerModeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFMEnhancerModeGet();

   virtual ~mascf_mainfi_tclMsgFMEnhancerModeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgFMEnhancerModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFMEnhancerModeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFMEnhancerModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgFMEnhancerModeSet& operator=(const mascf_mainfi_tclMsgFMEnhancerModeSet& coRef);
   mascf_mainfi_tclMsgFMEnhancerModeSet(const mascf_mainfi_tclMsgFMEnhancerModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool FMEnhancer;
   virtual ~mascf_mainfi_tclMsgFMEnhancerModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgFMEnhancerModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgFMEnhancerModeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgFMEnhancerModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgFMEnhancerModeStatus& operator=(const mascf_mainfi_tclMsgFMEnhancerModeStatus& coRef);
   mascf_mainfi_tclMsgFMEnhancerModeStatus(const mascf_mainfi_tclMsgFMEnhancerModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool FMEnhancer;
   virtual ~mascf_mainfi_tclMsgFMEnhancerModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgFMEnhancerModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDiagDefSetPhaseUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDiagDefSetPhaseUpReg();

   virtual ~mascf_mainfi_tclMsgDiagDefSetPhaseUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgDiagDefSetPhaseUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDiagDefSetPhaseRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDiagDefSetPhaseRelUpReg();

   virtual ~mascf_mainfi_tclMsgDiagDefSetPhaseRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgDiagDefSetPhaseRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDiagDefSetPhaseGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDiagDefSetPhaseGet();

   virtual ~mascf_mainfi_tclMsgDiagDefSetPhaseGet();

   inline tBool operator==(const mascf_mainfi_tclMsgDiagDefSetPhaseGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgDiagDefSetPhaseStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgDiagDefSetPhaseStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgDiagDefSetPhaseStatus& operator=(const mascf_mainfi_tclMsgDiagDefSetPhaseStatus& coRef);
   mascf_mainfi_tclMsgDiagDefSetPhaseStatus(const mascf_mainfi_tclMsgDiagDefSetPhaseStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudDiagDefSetPhase DefSetPhase;
   virtual ~mascf_mainfi_tclMsgDiagDefSetPhaseStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgDiagDefSetPhaseStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESESoundTypeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESESoundTypeUpReg();

   virtual ~mascf_mainfi_tclMsgESESoundTypeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgESESoundTypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESESoundTypeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESESoundTypeRelUpReg();

   virtual ~mascf_mainfi_tclMsgESESoundTypeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgESESoundTypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESESoundTypeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESESoundTypeGet();

   virtual ~mascf_mainfi_tclMsgESESoundTypeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgESESoundTypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESESoundTypeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESESoundTypeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgESESoundTypeSet& operator=(const mascf_mainfi_tclMsgESESoundTypeSet& coRef);
   mascf_mainfi_tclMsgESESoundTypeSet(const mascf_mainfi_tclMsgESESoundTypeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SoundType;
   virtual ~mascf_mainfi_tclMsgESESoundTypeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgESESoundTypeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESESoundTypeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESESoundTypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgESESoundTypeStatus& operator=(const mascf_mainfi_tclMsgESESoundTypeStatus& coRef);
   mascf_mainfi_tclMsgESESoundTypeStatus(const mascf_mainfi_tclMsgESESoundTypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SoundType;
   virtual ~mascf_mainfi_tclMsgESESoundTypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgESESoundTypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESEVolumeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESEVolumeUpReg();

   virtual ~mascf_mainfi_tclMsgESEVolumeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgESEVolumeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESEVolumeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESEVolumeRelUpReg();

   virtual ~mascf_mainfi_tclMsgESEVolumeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgESEVolumeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESEVolumeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESEVolumeGet();

   virtual ~mascf_mainfi_tclMsgESEVolumeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgESEVolumeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESEVolumeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESEVolumeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgESEVolumeSet& operator=(const mascf_mainfi_tclMsgESEVolumeSet& coRef);
   mascf_mainfi_tclMsgESEVolumeSet(const mascf_mainfi_tclMsgESEVolumeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Volume;
   virtual ~mascf_mainfi_tclMsgESEVolumeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgESEVolumeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESEVolumeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESEVolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgESEVolumeStatus& operator=(const mascf_mainfi_tclMsgESEVolumeStatus& coRef);
   mascf_mainfi_tclMsgESEVolumeStatus(const mascf_mainfi_tclMsgESEVolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Volume;
   virtual ~mascf_mainfi_tclMsgESEVolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgESEVolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundOnOffUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundOnOffUpReg();

   virtual ~mascf_mainfi_tclMsgRSoundOnOffUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundOnOffUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundOnOffRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundOnOffRelUpReg();

   virtual ~mascf_mainfi_tclMsgRSoundOnOffRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundOnOffRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundOnOffGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundOnOffGet();

   virtual ~mascf_mainfi_tclMsgRSoundOnOffGet();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundOnOffGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundOnOffSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundOnOffSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRSoundOnOffSet& operator=(const mascf_mainfi_tclMsgRSoundOnOffSet& coRef);
   mascf_mainfi_tclMsgRSoundOnOffSet(const mascf_mainfi_tclMsgRSoundOnOffSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RSound;
   virtual ~mascf_mainfi_tclMsgRSoundOnOffSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRSoundOnOffSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundOnOffStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundOnOffStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRSoundOnOffStatus& operator=(const mascf_mainfi_tclMsgRSoundOnOffStatus& coRef);
   mascf_mainfi_tclMsgRSoundOnOffStatus(const mascf_mainfi_tclMsgRSoundOnOffStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RSound;
   virtual ~mascf_mainfi_tclMsgRSoundOnOffStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRSoundOnOffStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundSoundTypeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundSoundTypeUpReg();

   virtual ~mascf_mainfi_tclMsgRSoundSoundTypeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundSoundTypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundSoundTypeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundSoundTypeRelUpReg();

   virtual ~mascf_mainfi_tclMsgRSoundSoundTypeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundSoundTypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundSoundTypeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundSoundTypeGet();

   virtual ~mascf_mainfi_tclMsgRSoundSoundTypeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundSoundTypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundSoundTypeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundSoundTypeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRSoundSoundTypeSet& operator=(const mascf_mainfi_tclMsgRSoundSoundTypeSet& coRef);
   mascf_mainfi_tclMsgRSoundSoundTypeSet(const mascf_mainfi_tclMsgRSoundSoundTypeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RSoundType;
   virtual ~mascf_mainfi_tclMsgRSoundSoundTypeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRSoundSoundTypeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundSoundTypeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundSoundTypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRSoundSoundTypeStatus& operator=(const mascf_mainfi_tclMsgRSoundSoundTypeStatus& coRef);
   mascf_mainfi_tclMsgRSoundSoundTypeStatus(const mascf_mainfi_tclMsgRSoundSoundTypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RSoundType;
   virtual ~mascf_mainfi_tclMsgRSoundSoundTypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRSoundSoundTypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundVolumeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundVolumeUpReg();

   virtual ~mascf_mainfi_tclMsgRSoundVolumeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundVolumeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundVolumeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundVolumeRelUpReg();

   virtual ~mascf_mainfi_tclMsgRSoundVolumeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundVolumeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundVolumeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundVolumeGet();

   virtual ~mascf_mainfi_tclMsgRSoundVolumeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundVolumeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundVolumeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundVolumeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRSoundVolumeSet& operator=(const mascf_mainfi_tclMsgRSoundVolumeSet& coRef);
   mascf_mainfi_tclMsgRSoundVolumeSet(const mascf_mainfi_tclMsgRSoundVolumeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Volume;
   virtual ~mascf_mainfi_tclMsgRSoundVolumeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRSoundVolumeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundVolumeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundVolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRSoundVolumeStatus& operator=(const mascf_mainfi_tclMsgRSoundVolumeStatus& coRef);
   mascf_mainfi_tclMsgRSoundVolumeStatus(const mascf_mainfi_tclMsgRSoundVolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Volume;
   virtual ~mascf_mainfi_tclMsgRSoundVolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRSoundVolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESEDriveModeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESEDriveModeUpReg();

   virtual ~mascf_mainfi_tclMsgESEDriveModeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgESEDriveModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESEDriveModeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESEDriveModeRelUpReg();

   virtual ~mascf_mainfi_tclMsgESEDriveModeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgESEDriveModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESEDriveModeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESEDriveModeGet();

   virtual ~mascf_mainfi_tclMsgESEDriveModeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgESEDriveModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESEDriveModeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESEDriveModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgESEDriveModeSet& operator=(const mascf_mainfi_tclMsgESEDriveModeSet& coRef);
   mascf_mainfi_tclMsgESEDriveModeSet(const mascf_mainfi_tclMsgESEDriveModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DriveMode;
   virtual ~mascf_mainfi_tclMsgESEDriveModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgESEDriveModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgESEDriveModeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgESEDriveModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgESEDriveModeStatus& operator=(const mascf_mainfi_tclMsgESEDriveModeStatus& coRef);
   mascf_mainfi_tclMsgESEDriveModeStatus(const mascf_mainfi_tclMsgESEDriveModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DriveMode;
   virtual ~mascf_mainfi_tclMsgESEDriveModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgESEDriveModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioModeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioModeUpReg();

   virtual ~mascf_mainfi_tclMsgAudioModeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioModeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioModeRelUpReg();

   virtual ~mascf_mainfi_tclMsgAudioModeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioModeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioModeGet();

   virtual ~mascf_mainfi_tclMsgAudioModeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioModeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioModeStatus& operator=(const mascf_mainfi_tclMsgAudioModeStatus& coRef);
   mascf_mainfi_tclMsgAudioModeStatus(const mascf_mainfi_tclMsgAudioModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioMode AudioMode;
   virtual ~mascf_mainfi_tclMsgAudioModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_UPASoundTypeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_UPASoundTypeUpReg();

   virtual ~mascf_mainfi_tclMsgADAS_UPASoundTypeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_UPASoundTypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_UPASoundTypeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_UPASoundTypeRelUpReg();

   virtual ~mascf_mainfi_tclMsgADAS_UPASoundTypeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_UPASoundTypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_UPASoundTypeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_UPASoundTypeGet();

   virtual ~mascf_mainfi_tclMsgADAS_UPASoundTypeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_UPASoundTypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_UPASoundTypeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_UPASoundTypeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgADAS_UPASoundTypeSet& operator=(const mascf_mainfi_tclMsgADAS_UPASoundTypeSet& coRef);
   mascf_mainfi_tclMsgADAS_UPASoundTypeSet(const mascf_mainfi_tclMsgADAS_UPASoundTypeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_ADAS_UPA_SoundType SoundType;
   virtual ~mascf_mainfi_tclMsgADAS_UPASoundTypeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgADAS_UPASoundTypeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_UPASoundTypeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_UPASoundTypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgADAS_UPASoundTypeStatus& operator=(const mascf_mainfi_tclMsgADAS_UPASoundTypeStatus& coRef);
   mascf_mainfi_tclMsgADAS_UPASoundTypeStatus(const mascf_mainfi_tclMsgADAS_UPASoundTypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_ADAS_UPA_SoundType SoundType;
   virtual ~mascf_mainfi_tclMsgADAS_UPASoundTypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgADAS_UPASoundTypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_ParkAssistVolumeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_ParkAssistVolumeUpReg();

   virtual ~mascf_mainfi_tclMsgADAS_ParkAssistVolumeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_ParkAssistVolumeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_ParkAssistVolumeRelUpReg();

   virtual ~mascf_mainfi_tclMsgADAS_ParkAssistVolumeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_ParkAssistVolumeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_ParkAssistVolumeGet();

   virtual ~mascf_mainfi_tclMsgADAS_ParkAssistVolumeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet& operator=(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet& coRef);
   mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_ADAS_ParkAssist_Volume VolumeLevel;
   virtual ~mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus& operator=(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus& coRef);
   mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_ADAS_ParkAssist_Volume VolumeLevel;
   virtual ~mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_UPAMuteUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_UPAMuteUpReg();

   virtual ~mascf_mainfi_tclMsgADAS_UPAMuteUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_UPAMuteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_UPAMuteRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_UPAMuteRelUpReg();

   virtual ~mascf_mainfi_tclMsgADAS_UPAMuteRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_UPAMuteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_UPAMuteGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_UPAMuteGet();

   virtual ~mascf_mainfi_tclMsgADAS_UPAMuteGet();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_UPAMuteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_UPAMuteSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_UPAMuteSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgADAS_UPAMuteSet& operator=(const mascf_mainfi_tclMsgADAS_UPAMuteSet& coRef);
   mascf_mainfi_tclMsgADAS_UPAMuteSet(const mascf_mainfi_tclMsgADAS_UPAMuteSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMute;
   virtual ~mascf_mainfi_tclMsgADAS_UPAMuteSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgADAS_UPAMuteSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_UPAMuteStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_UPAMuteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgADAS_UPAMuteStatus& operator=(const mascf_mainfi_tclMsgADAS_UPAMuteStatus& coRef);
   mascf_mainfi_tclMsgADAS_UPAMuteStatus(const mascf_mainfi_tclMsgADAS_UPAMuteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMuted;
   virtual ~mascf_mainfi_tclMsgADAS_UPAMuteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgADAS_UPAMuteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAutomaticGainControlUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAutomaticGainControlUpReg();

   virtual ~mascf_mainfi_tclMsgAutomaticGainControlUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAutomaticGainControlUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAutomaticGainControlRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAutomaticGainControlRelUpReg();

   virtual ~mascf_mainfi_tclMsgAutomaticGainControlRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAutomaticGainControlRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAutomaticGainControlGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAutomaticGainControlGet();

   virtual ~mascf_mainfi_tclMsgAutomaticGainControlGet();

   inline tBool operator==(const mascf_mainfi_tclMsgAutomaticGainControlGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAutomaticGainControlSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAutomaticGainControlSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAutomaticGainControlSet& operator=(const mascf_mainfi_tclMsgAutomaticGainControlSet& coRef);
   mascf_mainfi_tclMsgAutomaticGainControlSet(const mascf_mainfi_tclMsgAutomaticGainControlSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AutomaticGainControl;
   virtual ~mascf_mainfi_tclMsgAutomaticGainControlSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAutomaticGainControlSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAutomaticGainControlStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAutomaticGainControlStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAutomaticGainControlStatus& operator=(const mascf_mainfi_tclMsgAutomaticGainControlStatus& coRef);
   mascf_mainfi_tclMsgAutomaticGainControlStatus(const mascf_mainfi_tclMsgAutomaticGainControlStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AutomaticGainControl;
   virtual ~mascf_mainfi_tclMsgAutomaticGainControlStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAutomaticGainControlStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_LDW_UserVolumeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_LDW_UserVolumeUpReg();

   virtual ~mascf_mainfi_tclMsgADAS_LDW_UserVolumeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_LDW_UserVolumeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_LDW_UserVolumeRelUpReg();

   virtual ~mascf_mainfi_tclMsgADAS_LDW_UserVolumeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_LDW_UserVolumeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_LDW_UserVolumeGet();

   virtual ~mascf_mainfi_tclMsgADAS_LDW_UserVolumeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet& operator=(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet& coRef);
   mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_ADAS_LDW_UserVolume VolumeLevel;
   virtual ~mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus& operator=(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus& coRef);
   mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_ADAS_LDW_UserVolume VolumeLevel;
   virtual ~mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundActivationUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundActivationUpReg();

   virtual ~mascf_mainfi_tclMsgRSoundActivationUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundActivationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundActivationRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundActivationRelUpReg();

   virtual ~mascf_mainfi_tclMsgRSoundActivationRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundActivationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundActivationGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundActivationGet();

   virtual ~mascf_mainfi_tclMsgRSoundActivationGet();

   inline tBool operator==(const mascf_mainfi_tclMsgRSoundActivationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundActivationSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundActivationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRSoundActivationSet& operator=(const mascf_mainfi_tclMsgRSoundActivationSet& coRef);
   mascf_mainfi_tclMsgRSoundActivationSet(const mascf_mainfi_tclMsgRSoundActivationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RSoundActive;
   virtual ~mascf_mainfi_tclMsgRSoundActivationSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRSoundActivationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgRSoundActivationStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgRSoundActivationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgRSoundActivationStatus& operator=(const mascf_mainfi_tclMsgRSoundActivationStatus& coRef);
   mascf_mainfi_tclMsgRSoundActivationStatus(const mascf_mainfi_tclMsgRSoundActivationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RSoundActive;
   virtual ~mascf_mainfi_tclMsgRSoundActivationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgRSoundActivationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCActiveTestUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCActiveTestUpReg();

   virtual ~mascf_mainfi_tclMsgANCASCActiveTestUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgANCASCActiveTestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCActiveTestRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCActiveTestRelUpReg();

   virtual ~mascf_mainfi_tclMsgANCASCActiveTestRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgANCASCActiveTestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCActiveTestGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCActiveTestGet();

   virtual ~mascf_mainfi_tclMsgANCASCActiveTestGet();

   inline tBool operator==(const mascf_mainfi_tclMsgANCASCActiveTestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCActiveTestSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCActiveTestSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgANCASCActiveTestSet& operator=(const mascf_mainfi_tclMsgANCASCActiveTestSet& coRef);
   mascf_mainfi_tclMsgANCASCActiveTestSet(const mascf_mainfi_tclMsgANCASCActiveTestSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Request;
   virtual ~mascf_mainfi_tclMsgANCASCActiveTestSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgANCASCActiveTestSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCActiveTestStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCActiveTestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgANCASCActiveTestStatus& operator=(const mascf_mainfi_tclMsgANCASCActiveTestStatus& coRef);
   mascf_mainfi_tclMsgANCASCActiveTestStatus(const mascf_mainfi_tclMsgANCASCActiveTestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TestStatus;
   virtual ~mascf_mainfi_tclMsgANCASCActiveTestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgANCASCActiveTestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusUpReg();

   virtual ~mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusRelUpReg();

   virtual ~mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusGet();

   virtual ~mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusGet();

   inline tBool operator==(const mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusSet();

   virtual ~mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusSet();

   inline tBool operator==(const mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus& operator=(const mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus& coRef);
   mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus(const mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DiagResultSummary;
   mascf_fi_tcl_MicrophoneResult MicrophoneResult;
   tU8 EnginePulse;
   tU8 DoorOpenClose;
   mascf_fi_tclString ConfigInformation;
   virtual ~mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgUserProfileChangeUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgUserProfileChangeUpReg();

   virtual ~mascf_mainfi_tclMsgUserProfileChangeUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgUserProfileChangeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgUserProfileChangeRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgUserProfileChangeRelUpReg();

   virtual ~mascf_mainfi_tclMsgUserProfileChangeRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgUserProfileChangeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgUserProfileChangeGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgUserProfileChangeGet();

   virtual ~mascf_mainfi_tclMsgUserProfileChangeGet();

   inline tBool operator==(const mascf_mainfi_tclMsgUserProfileChangeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgUserProfileChangeSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgUserProfileChangeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgUserProfileChangeSet& operator=(const mascf_mainfi_tclMsgUserProfileChangeSet& coRef);
   mascf_mainfi_tclMsgUserProfileChangeSet(const mascf_mainfi_tclMsgUserProfileChangeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool UserProfileChange;
   virtual ~mascf_mainfi_tclMsgUserProfileChangeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgUserProfileChangeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgUserProfileChangeStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgUserProfileChangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgUserProfileChangeStatus& operator=(const mascf_mainfi_tclMsgUserProfileChangeStatus& coRef);
   mascf_mainfi_tclMsgUserProfileChangeStatus(const mascf_mainfi_tclMsgUserProfileChangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool UserProfileChange;
   virtual ~mascf_mainfi_tclMsgUserProfileChangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgUserProfileChangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSRSoundNotificationStateUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSRSoundNotificationStateUpReg();

   virtual ~mascf_mainfi_tclMsgSRSoundNotificationStateUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSRSoundNotificationStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSRSoundNotificationStateRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSRSoundNotificationStateRelUpReg();

   virtual ~mascf_mainfi_tclMsgSRSoundNotificationStateRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgSRSoundNotificationStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSRSoundNotificationStateGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSRSoundNotificationStateGet();

   virtual ~mascf_mainfi_tclMsgSRSoundNotificationStateGet();

   inline tBool operator==(const mascf_mainfi_tclMsgSRSoundNotificationStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSRSoundNotificationStateSet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSRSoundNotificationStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSRSoundNotificationStateSet& operator=(const mascf_mainfi_tclMsgSRSoundNotificationStateSet& coRef);
   mascf_mainfi_tclMsgSRSoundNotificationStateSet(const mascf_mainfi_tclMsgSRSoundNotificationStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SR_SoundNotification_State;
   virtual ~mascf_mainfi_tclMsgSRSoundNotificationStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSRSoundNotificationStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgSRSoundNotificationStateStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgSRSoundNotificationStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgSRSoundNotificationStateStatus& operator=(const mascf_mainfi_tclMsgSRSoundNotificationStateStatus& coRef);
   mascf_mainfi_tclMsgSRSoundNotificationStateStatus(const mascf_mainfi_tclMsgSRSoundNotificationStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SR_SoundNotification_State;
   virtual ~mascf_mainfi_tclMsgSRSoundNotificationStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgSRSoundNotificationStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioPilotIntensityUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioPilotIntensityUpReg();

   virtual ~mascf_mainfi_tclMsgAudioPilotIntensityUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioPilotIntensityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioPilotIntensityRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioPilotIntensityRelUpReg();

   virtual ~mascf_mainfi_tclMsgAudioPilotIntensityRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioPilotIntensityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioPilotIntensityGet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioPilotIntensityGet();

   virtual ~mascf_mainfi_tclMsgAudioPilotIntensityGet();

   inline tBool operator==(const mascf_mainfi_tclMsgAudioPilotIntensityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioPilotIntensitySet : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioPilotIntensitySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioPilotIntensitySet& operator=(const mascf_mainfi_tclMsgAudioPilotIntensitySet& coRef);
   mascf_mainfi_tclMsgAudioPilotIntensitySet(const mascf_mainfi_tclMsgAudioPilotIntensitySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioPilotIntensity Audio_Pilot_Intensity;
   virtual ~mascf_mainfi_tclMsgAudioPilotIntensitySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioPilotIntensitySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgAudioPilotIntensityStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgAudioPilotIntensityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgAudioPilotIntensityStatus& operator=(const mascf_mainfi_tclMsgAudioPilotIntensityStatus& coRef);
   mascf_mainfi_tclMsgAudioPilotIntensityStatus(const mascf_mainfi_tclMsgAudioPilotIntensityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudioPilotIntensity Audio_Pilot_Intensity;
   virtual ~mascf_mainfi_tclMsgAudioPilotIntensityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgAudioPilotIntensityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMainAudioAttenuationUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMainAudioAttenuationUpReg();

   virtual ~mascf_mainfi_tclMsgMainAudioAttenuationUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgMainAudioAttenuationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMainAudioAttenuationRelUpReg : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMainAudioAttenuationRelUpReg();

   virtual ~mascf_mainfi_tclMsgMainAudioAttenuationRelUpReg();

   inline tBool operator==(const mascf_mainfi_tclMsgMainAudioAttenuationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mascf_mainfi_tclMsgMainAudioAttenuationStatus : public mascf_mainfi_tclMsgBaseMessage
{
public:

   mascf_mainfi_tclMsgMainAudioAttenuationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_mainfi_tclMsgMainAudioAttenuationStatus& operator=(const mascf_mainfi_tclMsgMainAudioAttenuationStatus& coRef);
   mascf_mainfi_tclMsgMainAudioAttenuationStatus(const mascf_mainfi_tclMsgMainAudioAttenuationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 Attenuation_Value;
   virtual ~mascf_mainfi_tclMsgMainAudioAttenuationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_mainfi_tclMsgMainAudioAttenuationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
