/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef LCMDBUSCLIENT_MAINFITYPES_HEADER
#define LCMDBUSCLIENT_MAINFITYPES_HEADER


class lcmdbusclient_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for lcmdbusclient_main_fi message types

fi_tclMessageBase* lcmdbusclient_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class lcmdbusclient_mainfi_tclMsgBaseMessage : public lcmdbusclient_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   lcmdbusclient_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class lcmdbusclient_mainfi_tclMsgCurrentSourceGet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgCurrentSourceGet();

   virtual ~lcmdbusclient_mainfi_tclMsgCurrentSourceGet();

   inline tBool operator==(const lcmdbusclient_mainfi_tclMsgCurrentSourceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgCurrentSourceStatus : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgCurrentSourceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgCurrentSourceStatus& operator=(const lcmdbusclient_mainfi_tclMsgCurrentSourceStatus& coRef);
   lcmdbusclient_mainfi_tclMsgCurrentSourceStatus(const lcmdbusclient_mainfi_tclMsgCurrentSourceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcmdbusclient_fi_tclString strSourceName;
   virtual ~lcmdbusclient_mainfi_tclMsgCurrentSourceStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgCurrentSourceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgNanomsgStatusGet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgNanomsgStatusGet();

   virtual ~lcmdbusclient_mainfi_tclMsgNanomsgStatusGet();

   inline tBool operator==(const lcmdbusclient_mainfi_tclMsgNanomsgStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgNanomsgStatusSet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgNanomsgStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgNanomsgStatusSet& operator=(const lcmdbusclient_mainfi_tclMsgNanomsgStatusSet& coRef);
   lcmdbusclient_mainfi_tclMsgNanomsgStatusSet(const lcmdbusclient_mainfi_tclMsgNanomsgStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Nanomsgconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgNanomsgStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgNanomsgStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus& operator=(const lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus& coRef);
   lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus(const lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Nanomsgconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusGet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusGet();

   virtual ~lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusGet();

   inline tBool operator==(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet& operator=(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet& coRef);
   lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus& operator=(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus& coRef);
   lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgVoltagelevelStatusGet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgVoltagelevelStatusGet();

   virtual ~lcmdbusclient_mainfi_tclMsgVoltagelevelStatusGet();

   inline tBool operator==(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet& operator=(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet& coRef);
   lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Voltagelevelconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus& operator=(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus& coRef);
   lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Voltagelevelconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgCockpitmodeStatusGet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgCockpitmodeStatusGet();

   virtual ~lcmdbusclient_mainfi_tclMsgCockpitmodeStatusGet();

   inline tBool operator==(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet& operator=(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet& coRef);
   lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Cockpitmodeconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus& operator=(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus& coRef);
   lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Cockpitmodeconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgThermallevelStatusGet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgThermallevelStatusGet();

   virtual ~lcmdbusclient_mainfi_tclMsgThermallevelStatusGet();

   inline tBool operator==(const lcmdbusclient_mainfi_tclMsgThermallevelStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgThermallevelStatusSet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgThermallevelStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgThermallevelStatusSet& operator=(const lcmdbusclient_mainfi_tclMsgThermallevelStatusSet& coRef);
   lcmdbusclient_mainfi_tclMsgThermallevelStatusSet(const lcmdbusclient_mainfi_tclMsgThermallevelStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Thermallevelconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgThermallevelStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgThermallevelStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus& operator=(const lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus& coRef);
   lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus(const lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Thermallevelconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgDoorUnlockStatusGet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgDoorUnlockStatusGet();

   virtual ~lcmdbusclient_mainfi_tclMsgDoorUnlockStatusGet();

   inline tBool operator==(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet& operator=(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet& coRef);
   lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DoorUnlockconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus& operator=(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus& coRef);
   lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DoorUnlockconstate;
   virtual ~lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusGet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusGet();

   virtual ~lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusGet();

   inline tBool operator==(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet& operator=(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet& coRef);
   lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PNMGRP10Signalstate;
   virtual ~lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus : public lcmdbusclient_mainfi_tclMsgBaseMessage
{
public:

   lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus& operator=(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus& coRef);
   lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PNMGRP10Signalstate;
   virtual ~lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
