/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define LCM_FI_S_IMPORT_INTERFACE_LCM_DBUSCTRLFI_TYPES
#define LCM_FI_S_IMPORT_INTERFACE_LCM_DBUSCTRLFI_FUNCTIONIDS
#define LCM_FI_S_IMPORT_INTERFACE_LCM_DBUSCTRLFI_SERVICEINFO
#include "lcm_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for lcm_dbusctrl_fi message types

fi_tclMessageBase* lcm_dbusctrlfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTPROCESSMETHODSTART:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgStartProcessMethodStart;

      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTPROCESSMETHODRESULT:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgStartProcessMethodResult;

      case lcm_dbusctrlfi_tclToken::EN_MSG_STOPPROCESSMETHODSTART:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgStopProcessMethodStart;

      case lcm_dbusctrlfi_tclToken::EN_MSG_STOPPROCESSMETHODRESULT:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgStopProcessMethodResult;

      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFINISHEDMETHODSTART:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart;

      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFINISHEDMETHODRESULT:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult;

      case lcm_dbusctrlfi_tclToken::EN_MSG_GETPROCESSIDMETHODSTART:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart;

      case lcm_dbusctrlfi_tclToken::EN_MSG_GETPROCESSIDMETHODRESULT:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgGetProcessIdMethodResult;

      case lcm_dbusctrlfi_tclToken::EN_MSG_TRIGGERGETUNITLISTMETHODSTART:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart;

      case lcm_dbusctrlfi_tclToken::EN_MSG_TRIGGERGETUNITLISTMETHODRESULT:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodResult;

      case lcm_dbusctrlfi_tclToken::EN_MSG_RESTARTPROCESSMETHODSTART:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgRestartProcessMethodStart;

      case lcm_dbusctrlfi_tclToken::EN_MSG_RESTARTPROCESSMETHODRESULT:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgRestartProcessMethodResult;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppStartRequestUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTRELUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppStartRequestRelUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTGET:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppStartRequestGet;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTSTATUS:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppStartRequestStatus;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppInitializedUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDRELUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppInitializedRelUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDGET:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppInitializedGet;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDSTATUS:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppInitializedStatus;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGEUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppStateChangeUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGERELUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppStateChangeRelUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGEGET:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppStateChangeGet;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGESET:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppStateChangeSet;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGESTATUS:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppStateChangeStatus;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppEndUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDRELUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppEndRelUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDGET:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppEndGet;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDSET:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppEndSet;

      case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDSTATUS:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgAppEndStatus;

      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgNewServiceLoadedUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDRELUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgNewServiceLoadedRelUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDGET:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgNewServiceLoadedGet;

      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDSTATUS:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus;

      case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgFailedServicesListUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTRELUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgFailedServicesListRelUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTGET:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgFailedServicesListGet;

      case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTSTATUS:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgFailedServicesListStatus;

      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgNewProcessIdUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDRELUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgNewProcessIdRelUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDGET:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgNewProcessIdGet;

      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDSTATUS:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgNewProcessIdStatus;

      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONGET:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgStartupFailureIndicationGet;

      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONRELUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgStartupFailureIndicationRelUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONSTATUS:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus;

      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONUPREG:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgStartupFailureIndicationUpReg;

      case lcm_dbusctrlfi_tclToken::EN_MSG_SUPERVISIONSTATECHANGESET:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet;

      case lcm_dbusctrlfi_tclToken::EN_MSG_SUPERVISIONSTATECHANGESTATUS:
         return OSAL_NEW lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all lcm_dbusctrlfifi messages

// common functions

tU16 lcm_dbusctrlfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return LCM_DBUSCTRLFI_C_U16_SERVICE_ID;
}

tU16 lcm_dbusctrlfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 lcm_dbusctrlfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& lcm_dbusctrlfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& lcm_dbusctrlfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 lcm_dbusctrlfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgStartProcessMethodStart::lcm_dbusctrlfi_tclMsgStartProcessMethodStart(const lcm_dbusctrlfi_tclMsgStartProcessMethodStart& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   strLocation = coRef.strLocation;
   u32Prio = coRef.u32Prio;
   u32Affinity = coRef.u32Affinity;
   u32AffinityEnd = coRef.u32AffinityEnd;
   u32NiceLevel = coRef.u32NiceLevel;
   u32NiceLevelEnd = coRef.u32NiceLevelEnd;
   u32Type = coRef.u32Type;
   u32Info = coRef.u32Info;
}
lcm_dbusctrlfi_tclMsgStartProcessMethodStart& lcm_dbusctrlfi_tclMsgStartProcessMethodStart::operator=(const lcm_dbusctrlfi_tclMsgStartProcessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strLocation = coRef.strLocation;
   u32Prio = coRef.u32Prio;
   u32Affinity = coRef.u32Affinity;
   u32AffinityEnd = coRef.u32AffinityEnd;
   u32NiceLevel = coRef.u32NiceLevel;
   u32NiceLevelEnd = coRef.u32NiceLevelEnd;
   u32Type = coRef.u32Type;
   u32Info = coRef.u32Info;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcm_dbusctrlfi_tclMsgStartProcessMethodStart::vDestroy()
{
   strLocation.vDestroy();
}

lcm_dbusctrlfi_tclMsgStartProcessMethodStart::lcm_dbusctrlfi_tclMsgStartProcessMethodStart()
:strLocation()
,u32Prio(0)
,u32Affinity(0)
,u32AffinityEnd(0)
,u32NiceLevel(0)
,u32NiceLevelEnd(0)
,u32Type()
,u32Info(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgStartProcessMethodStart::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_STARTPROCESSMETHODSTART;
}


lcm_dbusctrlfi_tclMsgStartProcessMethodStart::~lcm_dbusctrlfi_tclMsgStartProcessMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcm_dbusctrlfi_tclMsgStartProcessMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 28+strLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgStartProcessMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strLocation);
   (tVoid) (oIn >> u32Prio);
   (tVoid) (oIn >> u32Affinity);
   (tVoid) (oIn >> u32AffinityEnd);
   (tVoid) (oIn >> u32NiceLevel);
   (tVoid) (oIn >> u32NiceLevelEnd);
   (tVoid) (oIn >> u32Type);
   (tVoid) (oIn >> u32Info);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgStartProcessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strLocation);
   (tVoid) (oOut << u32Prio);
   (tVoid) (oOut << u32Affinity);
   (tVoid) (oOut << u32AffinityEnd);
   (tVoid) (oOut << u32NiceLevel);
   (tVoid) (oOut << u32NiceLevelEnd);
   (tVoid) (oOut << u32Type);
   (tVoid) (oOut << u32Info);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgStartProcessMethodStart::operator==(const lcm_dbusctrlfi_tclMsgStartProcessMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strLocation == roRef.strLocation);
   bResult = bResult && (u32Prio == roRef.u32Prio);
   bResult = bResult && (u32Affinity == roRef.u32Affinity);
   bResult = bResult && (u32AffinityEnd == roRef.u32AffinityEnd);
   bResult = bResult && (u32NiceLevel == roRef.u32NiceLevel);
   bResult = bResult && (u32NiceLevelEnd == roRef.u32NiceLevelEnd);
   bResult = bResult && (u32Type == roRef.u32Type);
   bResult = bResult && (u32Info == roRef.u32Info);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgStartProcessMethodResult::lcm_dbusctrlfi_tclMsgStartProcessMethodResult(const lcm_dbusctrlfi_tclMsgStartProcessMethodResult& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
   u32SpawnDuration = coRef.u32SpawnDuration;
}
lcm_dbusctrlfi_tclMsgStartProcessMethodResult& lcm_dbusctrlfi_tclMsgStartProcessMethodResult::operator=(const lcm_dbusctrlfi_tclMsgStartProcessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
   u32SpawnDuration = coRef.u32SpawnDuration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcm_dbusctrlfi_tclMsgStartProcessMethodResult::vDestroy()
{
   strLocation.vDestroy();
}

lcm_dbusctrlfi_tclMsgStartProcessMethodResult::lcm_dbusctrlfi_tclMsgStartProcessMethodResult()
:s32ReturnVal(0)
,strLocation()
,u32ProcId(0)
,u32SpawnDuration(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgStartProcessMethodResult::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_STARTPROCESSMETHODRESULT;
}


lcm_dbusctrlfi_tclMsgStartProcessMethodResult::~lcm_dbusctrlfi_tclMsgStartProcessMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcm_dbusctrlfi_tclMsgStartProcessMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+strLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgStartProcessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   (tVoid) (oIn >> strLocation);
   (tVoid) (oIn >> u32ProcId);
   (tVoid) (oIn >> u32SpawnDuration);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgStartProcessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   (tVoid) (oOut << strLocation);
   (tVoid) (oOut << u32ProcId);
   (tVoid) (oOut << u32SpawnDuration);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgStartProcessMethodResult::operator==(const lcm_dbusctrlfi_tclMsgStartProcessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   bResult = bResult && (strLocation == roRef.strLocation);
   bResult = bResult && (u32ProcId == roRef.u32ProcId);
   bResult = bResult && (u32SpawnDuration == roRef.u32SpawnDuration);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgStopProcessMethodStart::lcm_dbusctrlfi_tclMsgStopProcessMethodStart(const lcm_dbusctrlfi_tclMsgStopProcessMethodStart& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
}
lcm_dbusctrlfi_tclMsgStopProcessMethodStart& lcm_dbusctrlfi_tclMsgStopProcessMethodStart::operator=(const lcm_dbusctrlfi_tclMsgStopProcessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcm_dbusctrlfi_tclMsgStopProcessMethodStart::vDestroy()
{
   strLocation.vDestroy();
}

lcm_dbusctrlfi_tclMsgStopProcessMethodStart::lcm_dbusctrlfi_tclMsgStopProcessMethodStart()
:strLocation()
,u32ProcId(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgStopProcessMethodStart::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_STOPPROCESSMETHODSTART;
}


lcm_dbusctrlfi_tclMsgStopProcessMethodStart::~lcm_dbusctrlfi_tclMsgStopProcessMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcm_dbusctrlfi_tclMsgStopProcessMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+strLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgStopProcessMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strLocation);
   (tVoid) (oIn >> u32ProcId);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgStopProcessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strLocation);
   (tVoid) (oOut << u32ProcId);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgStopProcessMethodStart::operator==(const lcm_dbusctrlfi_tclMsgStopProcessMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strLocation == roRef.strLocation);
   bResult = bResult && (u32ProcId == roRef.u32ProcId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgStopProcessMethodResult::lcm_dbusctrlfi_tclMsgStopProcessMethodResult(const lcm_dbusctrlfi_tclMsgStopProcessMethodResult& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
lcm_dbusctrlfi_tclMsgStopProcessMethodResult& lcm_dbusctrlfi_tclMsgStopProcessMethodResult::operator=(const lcm_dbusctrlfi_tclMsgStopProcessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgStopProcessMethodResult::lcm_dbusctrlfi_tclMsgStopProcessMethodResult()
:s32ReturnVal(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgStopProcessMethodResult::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_STOPPROCESSMETHODRESULT;
}


lcm_dbusctrlfi_tclMsgStopProcessMethodResult::~lcm_dbusctrlfi_tclMsgStopProcessMethodResult()
{}

tU32 lcm_dbusctrlfi_tclMsgStopProcessMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgStopProcessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgStopProcessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgStopProcessMethodResult::operator==(const lcm_dbusctrlfi_tclMsgStopProcessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart::lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   eStartUpParam = coRef.eStartUpParam;
}
lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart& lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart::operator=(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eStartUpParam = coRef.eStartUpParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart::lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart()
:eStartUpParam()
 {}

tS32 lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFINISHEDMETHODSTART;
}


lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart::~lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart()
{}

tU32 lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eStartUpParam);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eStartUpParam);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart::operator==(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eStartUpParam == roRef.eStartUpParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult::lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult& lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult::operator=(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult::lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult()
:s32ReturnVal(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFINISHEDMETHODRESULT;
}


lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult::~lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult()
{}

tU32 lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult::operator==(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart::lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart(const lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   strServiceName = coRef.strServiceName;
}
lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart& lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart::operator=(const lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strServiceName = coRef.strServiceName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart::vDestroy()
{
   strServiceName.vDestroy();
}

lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart::lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart()
:strServiceName()
 {}

tS32 lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_GETPROCESSIDMETHODSTART;
}


lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart::~lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strServiceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strServiceName);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strServiceName);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart::operator==(const lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strServiceName == roRef.strServiceName);
   return bResult;
}

//=============================================================================

lcm_dbusctrlfi_tclMsgGetProcessIdMethodResult::lcm_dbusctrlfi_tclMsgGetProcessIdMethodResult()
 {}

tS32 lcm_dbusctrlfi_tclMsgGetProcessIdMethodResult::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_GETPROCESSIDMETHODRESULT;
}


lcm_dbusctrlfi_tclMsgGetProcessIdMethodResult::~lcm_dbusctrlfi_tclMsgGetProcessIdMethodResult()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart::lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart()
 {}

tS32 lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_TRIGGERGETUNITLISTMETHODSTART;
}


lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart::~lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodResult::lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodResult()
 {}

tS32 lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodResult::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_TRIGGERGETUNITLISTMETHODRESULT;
}


lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodResult::~lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgRestartProcessMethodStart::lcm_dbusctrlfi_tclMsgRestartProcessMethodStart(const lcm_dbusctrlfi_tclMsgRestartProcessMethodStart& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
}
lcm_dbusctrlfi_tclMsgRestartProcessMethodStart& lcm_dbusctrlfi_tclMsgRestartProcessMethodStart::operator=(const lcm_dbusctrlfi_tclMsgRestartProcessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcm_dbusctrlfi_tclMsgRestartProcessMethodStart::vDestroy()
{
   strLocation.vDestroy();
}

lcm_dbusctrlfi_tclMsgRestartProcessMethodStart::lcm_dbusctrlfi_tclMsgRestartProcessMethodStart()
:strLocation()
,u32ProcId(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgRestartProcessMethodStart::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_RESTARTPROCESSMETHODSTART;
}


lcm_dbusctrlfi_tclMsgRestartProcessMethodStart::~lcm_dbusctrlfi_tclMsgRestartProcessMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcm_dbusctrlfi_tclMsgRestartProcessMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+strLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgRestartProcessMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strLocation);
   (tVoid) (oIn >> u32ProcId);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgRestartProcessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strLocation);
   (tVoid) (oOut << u32ProcId);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgRestartProcessMethodStart::operator==(const lcm_dbusctrlfi_tclMsgRestartProcessMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strLocation == roRef.strLocation);
   bResult = bResult && (u32ProcId == roRef.u32ProcId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgRestartProcessMethodResult::lcm_dbusctrlfi_tclMsgRestartProcessMethodResult(const lcm_dbusctrlfi_tclMsgRestartProcessMethodResult& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
lcm_dbusctrlfi_tclMsgRestartProcessMethodResult& lcm_dbusctrlfi_tclMsgRestartProcessMethodResult::operator=(const lcm_dbusctrlfi_tclMsgRestartProcessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgRestartProcessMethodResult::lcm_dbusctrlfi_tclMsgRestartProcessMethodResult()
:s32ReturnVal(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgRestartProcessMethodResult::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_RESTARTPROCESSMETHODRESULT;
}


lcm_dbusctrlfi_tclMsgRestartProcessMethodResult::~lcm_dbusctrlfi_tclMsgRestartProcessMethodResult()
{}

tU32 lcm_dbusctrlfi_tclMsgRestartProcessMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgRestartProcessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgRestartProcessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgRestartProcessMethodResult::operator==(const lcm_dbusctrlfi_tclMsgRestartProcessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppStartRequestUpReg::lcm_dbusctrlfi_tclMsgAppStartRequestUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppStartRequestUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTUPREG;
}


lcm_dbusctrlfi_tclMsgAppStartRequestUpReg::~lcm_dbusctrlfi_tclMsgAppStartRequestUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppStartRequestRelUpReg::lcm_dbusctrlfi_tclMsgAppStartRequestRelUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppStartRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTRELUPREG;
}


lcm_dbusctrlfi_tclMsgAppStartRequestRelUpReg::~lcm_dbusctrlfi_tclMsgAppStartRequestRelUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppStartRequestGet::lcm_dbusctrlfi_tclMsgAppStartRequestGet()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppStartRequestGet::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTGET;
}


lcm_dbusctrlfi_tclMsgAppStartRequestGet::~lcm_dbusctrlfi_tclMsgAppStartRequestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgAppStartRequestStatus::lcm_dbusctrlfi_tclMsgAppStartRequestStatus(const lcm_dbusctrlfi_tclMsgAppStartRequestStatus& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   strSwBlockName = coRef.strSwBlockName;
   strServiceName = coRef.strServiceName;
   u32AppId = coRef.u32AppId;
}
lcm_dbusctrlfi_tclMsgAppStartRequestStatus& lcm_dbusctrlfi_tclMsgAppStartRequestStatus::operator=(const lcm_dbusctrlfi_tclMsgAppStartRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   strSwBlockName = coRef.strSwBlockName;
   strServiceName = coRef.strServiceName;
   u32AppId = coRef.u32AppId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcm_dbusctrlfi_tclMsgAppStartRequestStatus::vDestroy()
{
   strSwBlockName.vDestroy();
   strServiceName.vDestroy();
}

lcm_dbusctrlfi_tclMsgAppStartRequestStatus::lcm_dbusctrlfi_tclMsgAppStartRequestStatus()
:strSwBlockName()
,strServiceName()
,u32AppId(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgAppStartRequestStatus::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTSTATUS;
}


lcm_dbusctrlfi_tclMsgAppStartRequestStatus::~lcm_dbusctrlfi_tclMsgAppStartRequestStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcm_dbusctrlfi_tclMsgAppStartRequestStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+strSwBlockName.u32GetSize(u16MajorVersion)+strServiceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgAppStartRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strSwBlockName);
   (tVoid) (oIn >> strServiceName);
   (tVoid) (oIn >> u32AppId);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgAppStartRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strSwBlockName);
   (tVoid) (oOut << strServiceName);
   (tVoid) (oOut << u32AppId);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgAppStartRequestStatus::operator==(const lcm_dbusctrlfi_tclMsgAppStartRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strSwBlockName == roRef.strSwBlockName);
   bResult = bResult && (strServiceName == roRef.strServiceName);
   bResult = bResult && (u32AppId == roRef.u32AppId);
   return bResult;
}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppInitializedUpReg::lcm_dbusctrlfi_tclMsgAppInitializedUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppInitializedUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDUPREG;
}


lcm_dbusctrlfi_tclMsgAppInitializedUpReg::~lcm_dbusctrlfi_tclMsgAppInitializedUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppInitializedRelUpReg::lcm_dbusctrlfi_tclMsgAppInitializedRelUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppInitializedRelUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDRELUPREG;
}


lcm_dbusctrlfi_tclMsgAppInitializedRelUpReg::~lcm_dbusctrlfi_tclMsgAppInitializedRelUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppInitializedGet::lcm_dbusctrlfi_tclMsgAppInitializedGet()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppInitializedGet::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDGET;
}


lcm_dbusctrlfi_tclMsgAppInitializedGet::~lcm_dbusctrlfi_tclMsgAppInitializedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgAppInitializedStatus::lcm_dbusctrlfi_tclMsgAppInitializedStatus(const lcm_dbusctrlfi_tclMsgAppInitializedStatus& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   u32AppId = coRef.u32AppId;
}
lcm_dbusctrlfi_tclMsgAppInitializedStatus& lcm_dbusctrlfi_tclMsgAppInitializedStatus::operator=(const lcm_dbusctrlfi_tclMsgAppInitializedStatus& coRef)
{
   if (this == &coRef) return *this;
   u32AppId = coRef.u32AppId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgAppInitializedStatus::lcm_dbusctrlfi_tclMsgAppInitializedStatus()
:u32AppId(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgAppInitializedStatus::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDSTATUS;
}


lcm_dbusctrlfi_tclMsgAppInitializedStatus::~lcm_dbusctrlfi_tclMsgAppInitializedStatus()
{}

tU32 lcm_dbusctrlfi_tclMsgAppInitializedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgAppInitializedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32AppId);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgAppInitializedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32AppId);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgAppInitializedStatus::operator==(const lcm_dbusctrlfi_tclMsgAppInitializedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32AppId == roRef.u32AppId);
   return bResult;
}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppStateChangeUpReg::lcm_dbusctrlfi_tclMsgAppStateChangeUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppStateChangeUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGEUPREG;
}


lcm_dbusctrlfi_tclMsgAppStateChangeUpReg::~lcm_dbusctrlfi_tclMsgAppStateChangeUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppStateChangeRelUpReg::lcm_dbusctrlfi_tclMsgAppStateChangeRelUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppStateChangeRelUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGERELUPREG;
}


lcm_dbusctrlfi_tclMsgAppStateChangeRelUpReg::~lcm_dbusctrlfi_tclMsgAppStateChangeRelUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppStateChangeGet::lcm_dbusctrlfi_tclMsgAppStateChangeGet()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppStateChangeGet::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGEGET;
}


lcm_dbusctrlfi_tclMsgAppStateChangeGet::~lcm_dbusctrlfi_tclMsgAppStateChangeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgAppStateChangeSet::lcm_dbusctrlfi_tclMsgAppStateChangeSet(const lcm_dbusctrlfi_tclMsgAppStateChangeSet& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   u32AppId = coRef.u32AppId;
   u32State = coRef.u32State;
}
lcm_dbusctrlfi_tclMsgAppStateChangeSet& lcm_dbusctrlfi_tclMsgAppStateChangeSet::operator=(const lcm_dbusctrlfi_tclMsgAppStateChangeSet& coRef)
{
   if (this == &coRef) return *this;
   u32AppId = coRef.u32AppId;
   u32State = coRef.u32State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgAppStateChangeSet::lcm_dbusctrlfi_tclMsgAppStateChangeSet()
:u32AppId(0)
,u32State(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgAppStateChangeSet::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGESET;
}


lcm_dbusctrlfi_tclMsgAppStateChangeSet::~lcm_dbusctrlfi_tclMsgAppStateChangeSet()
{}

tU32 lcm_dbusctrlfi_tclMsgAppStateChangeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgAppStateChangeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32AppId);
   (tVoid) (oIn >> u32State);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgAppStateChangeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32AppId);
   (tVoid) (oOut << u32State);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgAppStateChangeSet::operator==(const lcm_dbusctrlfi_tclMsgAppStateChangeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32AppId == roRef.u32AppId);
   bResult = bResult && (u32State == roRef.u32State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgAppStateChangeStatus::lcm_dbusctrlfi_tclMsgAppStateChangeStatus(const lcm_dbusctrlfi_tclMsgAppStateChangeStatus& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   u32AppId = coRef.u32AppId;
   u32State = coRef.u32State;
}
lcm_dbusctrlfi_tclMsgAppStateChangeStatus& lcm_dbusctrlfi_tclMsgAppStateChangeStatus::operator=(const lcm_dbusctrlfi_tclMsgAppStateChangeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32AppId = coRef.u32AppId;
   u32State = coRef.u32State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgAppStateChangeStatus::lcm_dbusctrlfi_tclMsgAppStateChangeStatus()
:u32AppId(0)
,u32State(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgAppStateChangeStatus::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGESTATUS;
}


lcm_dbusctrlfi_tclMsgAppStateChangeStatus::~lcm_dbusctrlfi_tclMsgAppStateChangeStatus()
{}

tU32 lcm_dbusctrlfi_tclMsgAppStateChangeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgAppStateChangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32AppId);
   (tVoid) (oIn >> u32State);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgAppStateChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32AppId);
   (tVoid) (oOut << u32State);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgAppStateChangeStatus::operator==(const lcm_dbusctrlfi_tclMsgAppStateChangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32AppId == roRef.u32AppId);
   bResult = bResult && (u32State == roRef.u32State);
   return bResult;
}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppEndUpReg::lcm_dbusctrlfi_tclMsgAppEndUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppEndUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPENDUPREG;
}


lcm_dbusctrlfi_tclMsgAppEndUpReg::~lcm_dbusctrlfi_tclMsgAppEndUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppEndRelUpReg::lcm_dbusctrlfi_tclMsgAppEndRelUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppEndRelUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPENDRELUPREG;
}


lcm_dbusctrlfi_tclMsgAppEndRelUpReg::~lcm_dbusctrlfi_tclMsgAppEndRelUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgAppEndGet::lcm_dbusctrlfi_tclMsgAppEndGet()
 {}

tS32 lcm_dbusctrlfi_tclMsgAppEndGet::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPENDGET;
}


lcm_dbusctrlfi_tclMsgAppEndGet::~lcm_dbusctrlfi_tclMsgAppEndGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgAppEndSet::lcm_dbusctrlfi_tclMsgAppEndSet(const lcm_dbusctrlfi_tclMsgAppEndSet& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   u32AppId = coRef.u32AppId;
}
lcm_dbusctrlfi_tclMsgAppEndSet& lcm_dbusctrlfi_tclMsgAppEndSet::operator=(const lcm_dbusctrlfi_tclMsgAppEndSet& coRef)
{
   if (this == &coRef) return *this;
   u32AppId = coRef.u32AppId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgAppEndSet::lcm_dbusctrlfi_tclMsgAppEndSet()
:u32AppId(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgAppEndSet::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPENDSET;
}


lcm_dbusctrlfi_tclMsgAppEndSet::~lcm_dbusctrlfi_tclMsgAppEndSet()
{}

tU32 lcm_dbusctrlfi_tclMsgAppEndSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgAppEndSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32AppId);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgAppEndSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32AppId);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgAppEndSet::operator==(const lcm_dbusctrlfi_tclMsgAppEndSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32AppId == roRef.u32AppId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgAppEndStatus::lcm_dbusctrlfi_tclMsgAppEndStatus(const lcm_dbusctrlfi_tclMsgAppEndStatus& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   u32AppId = coRef.u32AppId;
}
lcm_dbusctrlfi_tclMsgAppEndStatus& lcm_dbusctrlfi_tclMsgAppEndStatus::operator=(const lcm_dbusctrlfi_tclMsgAppEndStatus& coRef)
{
   if (this == &coRef) return *this;
   u32AppId = coRef.u32AppId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgAppEndStatus::lcm_dbusctrlfi_tclMsgAppEndStatus()
:u32AppId(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgAppEndStatus::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_APPENDSTATUS;
}


lcm_dbusctrlfi_tclMsgAppEndStatus::~lcm_dbusctrlfi_tclMsgAppEndStatus()
{}

tU32 lcm_dbusctrlfi_tclMsgAppEndStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgAppEndStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32AppId);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgAppEndStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32AppId);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgAppEndStatus::operator==(const lcm_dbusctrlfi_tclMsgAppEndStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32AppId == roRef.u32AppId);
   return bResult;
}

//=============================================================================

lcm_dbusctrlfi_tclMsgNewServiceLoadedUpReg::lcm_dbusctrlfi_tclMsgNewServiceLoadedUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgNewServiceLoadedUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDUPREG;
}


lcm_dbusctrlfi_tclMsgNewServiceLoadedUpReg::~lcm_dbusctrlfi_tclMsgNewServiceLoadedUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgNewServiceLoadedRelUpReg::lcm_dbusctrlfi_tclMsgNewServiceLoadedRelUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgNewServiceLoadedRelUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDRELUPREG;
}


lcm_dbusctrlfi_tclMsgNewServiceLoadedRelUpReg::~lcm_dbusctrlfi_tclMsgNewServiceLoadedRelUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgNewServiceLoadedGet::lcm_dbusctrlfi_tclMsgNewServiceLoadedGet()
 {}

tS32 lcm_dbusctrlfi_tclMsgNewServiceLoadedGet::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDGET;
}


lcm_dbusctrlfi_tclMsgNewServiceLoadedGet::~lcm_dbusctrlfi_tclMsgNewServiceLoadedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus::lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus(const lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   strServiceName = coRef.strServiceName;
   strBlockName = coRef.strBlockName;
   u32AppId = coRef.u32AppId;
}
lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus& lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus::operator=(const lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus& coRef)
{
   if (this == &coRef) return *this;
   strServiceName = coRef.strServiceName;
   strBlockName = coRef.strBlockName;
   u32AppId = coRef.u32AppId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus::vDestroy()
{
   strServiceName.vDestroy();
   strBlockName.vDestroy();
}

lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus::lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus()
:strServiceName()
,strBlockName()
,u32AppId(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDSTATUS;
}


lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus::~lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+strServiceName.u32GetSize(u16MajorVersion)+strBlockName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strServiceName);
   (tVoid) (oIn >> strBlockName);
   (tVoid) (oIn >> u32AppId);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strServiceName);
   (tVoid) (oOut << strBlockName);
   (tVoid) (oOut << u32AppId);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus::operator==(const lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strServiceName == roRef.strServiceName);
   bResult = bResult && (strBlockName == roRef.strBlockName);
   bResult = bResult && (u32AppId == roRef.u32AppId);
   return bResult;
}

//=============================================================================

lcm_dbusctrlfi_tclMsgFailedServicesListUpReg::lcm_dbusctrlfi_tclMsgFailedServicesListUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgFailedServicesListUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTUPREG;
}


lcm_dbusctrlfi_tclMsgFailedServicesListUpReg::~lcm_dbusctrlfi_tclMsgFailedServicesListUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgFailedServicesListRelUpReg::lcm_dbusctrlfi_tclMsgFailedServicesListRelUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgFailedServicesListRelUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTRELUPREG;
}


lcm_dbusctrlfi_tclMsgFailedServicesListRelUpReg::~lcm_dbusctrlfi_tclMsgFailedServicesListRelUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgFailedServicesListGet::lcm_dbusctrlfi_tclMsgFailedServicesListGet()
 {}

tS32 lcm_dbusctrlfi_tclMsgFailedServicesListGet::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTGET;
}


lcm_dbusctrlfi_tclMsgFailedServicesListGet::~lcm_dbusctrlfi_tclMsgFailedServicesListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgFailedServicesListStatus::lcm_dbusctrlfi_tclMsgFailedServicesListStatus(const lcm_dbusctrlfi_tclMsgFailedServicesListStatus& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   tServices = coRef.tServices;
}
lcm_dbusctrlfi_tclMsgFailedServicesListStatus& lcm_dbusctrlfi_tclMsgFailedServicesListStatus::operator=(const lcm_dbusctrlfi_tclMsgFailedServicesListStatus& coRef)
{
   if (this == &coRef) return *this;
   tServices = coRef.tServices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcm_dbusctrlfi_tclMsgFailedServicesListStatus::vDestroy()
{
   tServices.vDestroy(); 
}

lcm_dbusctrlfi_tclMsgFailedServicesListStatus::lcm_dbusctrlfi_tclMsgFailedServicesListStatus()
:tServices()
 {}

tS32 lcm_dbusctrlfi_tclMsgFailedServicesListStatus::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTSTATUS;
}


lcm_dbusctrlfi_tclMsgFailedServicesListStatus::~lcm_dbusctrlfi_tclMsgFailedServicesListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcm_dbusctrlfi_tclMsgFailedServicesListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+tServices.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgFailedServicesListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tServices);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgFailedServicesListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tServices);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgFailedServicesListStatus::operator==(const lcm_dbusctrlfi_tclMsgFailedServicesListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tServices == roRef.tServices);
   return bResult;
}

//=============================================================================

lcm_dbusctrlfi_tclMsgNewProcessIdUpReg::lcm_dbusctrlfi_tclMsgNewProcessIdUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgNewProcessIdUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDUPREG;
}


lcm_dbusctrlfi_tclMsgNewProcessIdUpReg::~lcm_dbusctrlfi_tclMsgNewProcessIdUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgNewProcessIdRelUpReg::lcm_dbusctrlfi_tclMsgNewProcessIdRelUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgNewProcessIdRelUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDRELUPREG;
}


lcm_dbusctrlfi_tclMsgNewProcessIdRelUpReg::~lcm_dbusctrlfi_tclMsgNewProcessIdRelUpReg()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgNewProcessIdGet::lcm_dbusctrlfi_tclMsgNewProcessIdGet()
 {}

tS32 lcm_dbusctrlfi_tclMsgNewProcessIdGet::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDGET;
}


lcm_dbusctrlfi_tclMsgNewProcessIdGet::~lcm_dbusctrlfi_tclMsgNewProcessIdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgNewProcessIdStatus::lcm_dbusctrlfi_tclMsgNewProcessIdStatus(const lcm_dbusctrlfi_tclMsgNewProcessIdStatus& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   strBlockName = coRef.strBlockName;
   strServiceName = coRef.strServiceName;
   u32ProcessId = coRef.u32ProcessId;
}
lcm_dbusctrlfi_tclMsgNewProcessIdStatus& lcm_dbusctrlfi_tclMsgNewProcessIdStatus::operator=(const lcm_dbusctrlfi_tclMsgNewProcessIdStatus& coRef)
{
   if (this == &coRef) return *this;
   strBlockName = coRef.strBlockName;
   strServiceName = coRef.strServiceName;
   u32ProcessId = coRef.u32ProcessId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcm_dbusctrlfi_tclMsgNewProcessIdStatus::vDestroy()
{
   strBlockName.vDestroy();
   strServiceName.vDestroy();
}

lcm_dbusctrlfi_tclMsgNewProcessIdStatus::lcm_dbusctrlfi_tclMsgNewProcessIdStatus()
:strBlockName()
,strServiceName()
,u32ProcessId(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgNewProcessIdStatus::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDSTATUS;
}


lcm_dbusctrlfi_tclMsgNewProcessIdStatus::~lcm_dbusctrlfi_tclMsgNewProcessIdStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcm_dbusctrlfi_tclMsgNewProcessIdStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+strBlockName.u32GetSize(u16MajorVersion)+strServiceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgNewProcessIdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strBlockName);
   (tVoid) (oIn >> strServiceName);
   (tVoid) (oIn >> u32ProcessId);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgNewProcessIdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strBlockName);
   (tVoid) (oOut << strServiceName);
   (tVoid) (oOut << u32ProcessId);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgNewProcessIdStatus::operator==(const lcm_dbusctrlfi_tclMsgNewProcessIdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strBlockName == roRef.strBlockName);
   bResult = bResult && (strServiceName == roRef.strServiceName);
   bResult = bResult && (u32ProcessId == roRef.u32ProcessId);
   return bResult;
}

//=============================================================================

lcm_dbusctrlfi_tclMsgStartupFailureIndicationGet::lcm_dbusctrlfi_tclMsgStartupFailureIndicationGet()
 {}

tS32 lcm_dbusctrlfi_tclMsgStartupFailureIndicationGet::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONGET;
}


lcm_dbusctrlfi_tclMsgStartupFailureIndicationGet::~lcm_dbusctrlfi_tclMsgStartupFailureIndicationGet()
{}

//=============================================================================

lcm_dbusctrlfi_tclMsgStartupFailureIndicationRelUpReg::lcm_dbusctrlfi_tclMsgStartupFailureIndicationRelUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgStartupFailureIndicationRelUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONRELUPREG;
}


lcm_dbusctrlfi_tclMsgStartupFailureIndicationRelUpReg::~lcm_dbusctrlfi_tclMsgStartupFailureIndicationRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus::lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus(const lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   tStartupFailureInd = coRef.tStartupFailureInd;
}
lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus& lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus::operator=(const lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus& coRef)
{
   if (this == &coRef) return *this;
   tStartupFailureInd = coRef.tStartupFailureInd;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus::lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus()
:tStartupFailureInd()
 {}

tS32 lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONSTATUS;
}


lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus::~lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus()
{}

tU32 lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tStartupFailureInd);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tStartupFailureInd);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus::operator==(const lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tStartupFailureInd == roRef.tStartupFailureInd);
   return bResult;
}

//=============================================================================

lcm_dbusctrlfi_tclMsgStartupFailureIndicationUpReg::lcm_dbusctrlfi_tclMsgStartupFailureIndicationUpReg()
 {}

tS32 lcm_dbusctrlfi_tclMsgStartupFailureIndicationUpReg::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONUPREG;
}


lcm_dbusctrlfi_tclMsgStartupFailureIndicationUpReg::~lcm_dbusctrlfi_tclMsgStartupFailureIndicationUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet::lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   bSupervisionActive = coRef.bSupervisionActive;
}
lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet& lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet::operator=(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet& coRef)
{
   if (this == &coRef) return *this;
   bSupervisionActive = coRef.bSupervisionActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet::lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet()
:bSupervisionActive(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_SUPERVISIONSTATECHANGESET;
}


lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet::~lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet()
{}

tU32 lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSupervisionActive);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSupervisionActive);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet::operator==(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSupervisionActive == roRef.bSupervisionActive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus::lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus& coRef)
   : lcm_dbusctrlfi_tclMsgBaseMessage(coRef)
{
   bSupervisionActive = coRef.bSupervisionActive;
}
lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus& lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus::operator=(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus& coRef)
{
   if (this == &coRef) return *this;
   bSupervisionActive = coRef.bSupervisionActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus::lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus()
:bSupervisionActive(0)
 {}

tS32 lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus::s32GetTypeId() const
{
   return (tS32) lcm_dbusctrlfi_tclToken::EN_MSG_SUPERVISIONSTATECHANGESTATUS;
}


lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus::~lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus()
{}

tU32 lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSupervisionActive);
   return oIn;
}

fi_tclOutContext& lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSupervisionActive);
   return oOut;
}

tBool lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus::operator==(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSupervisionActive == roRef.bSupervisionActive);
   return bResult;
}

