#ifndef LCM_DBUSCTRLFILANGUAGE_HEADER
#define LCM_DBUSCTRLFILANGUAGE_HEADER

class lcm_dbusctrlfi_tclInContext;
class lcm_dbusctrlfi_tclOutContext;
class lcm_dbusctrlfi_tclVisitorBase;

class MY_DECL lcm_dbusctrlfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  lcm_dbusctrlfi_tclDescription(fi_tclInContext* poIn, lcm_dbusctrlfi_tclVisitorBase* poVisit);
  lcm_dbusctrlfi_tclDescription(fi_tclOutContext* poOut, lcm_dbusctrlfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(lcm_dbusctrlfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(lcm_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ lcm_dbusctrlfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  lcm_dbusctrlfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<lcm_dbusctrlfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<lcm_dbusctrlfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline lcm_dbusctrlfi_tclDescription::lcm_dbusctrlfi_tclDescription(fi_tclInContext* poIn, lcm_dbusctrlfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline lcm_dbusctrlfi_tclDescription::lcm_dbusctrlfi_tclDescription(fi_tclOutContext* poOut, lcm_dbusctrlfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

