/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef INPUT_MAINFITYPES_HEADER
#define INPUT_MAINFITYPES_HEADER


class input_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for input_main_fi message types

fi_tclMessageBase* input_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class input_mainfi_tclMsgBaseMessage : public input_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   input_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class input_mainfi_tclMsgEnableInputEventsMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgEnableInputEventsMethodStart();

   virtual ~input_mainfi_tclMsgEnableInputEventsMethodStart();

   inline tBool operator==(const input_mainfi_tclMsgEnableInputEventsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgEnableInputEventsMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgEnableInputEventsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgEnableInputEventsMethodResult& operator=(const input_mainfi_tclMsgEnableInputEventsMethodResult& coRef);
   input_mainfi_tclMsgEnableInputEventsMethodResult(const input_mainfi_tclMsgEnableInputEventsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SimulationStatus;
   virtual ~input_mainfi_tclMsgEnableInputEventsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgEnableInputEventsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgDisableInputEventsMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgDisableInputEventsMethodStart();

   virtual ~input_mainfi_tclMsgDisableInputEventsMethodStart();

   inline tBool operator==(const input_mainfi_tclMsgDisableInputEventsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgDisableInputEventsMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgDisableInputEventsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgDisableInputEventsMethodResult& operator=(const input_mainfi_tclMsgDisableInputEventsMethodResult& coRef);
   input_mainfi_tclMsgDisableInputEventsMethodResult(const input_mainfi_tclMsgDisableInputEventsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SimulationStatus;
   virtual ~input_mainfi_tclMsgDisableInputEventsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgDisableInputEventsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulateKeyInjectionMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulateKeyInjectionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgsimulateKeyInjectionMethodStart& operator=(const input_mainfi_tclMsgsimulateKeyInjectionMethodStart& coRef);
   input_mainfi_tclMsgsimulateKeyInjectionMethodStart(const input_mainfi_tclMsgsimulateKeyInjectionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_e16_KeyCode e16Keycode;
   tU8 u8KeyStatus;
   virtual ~input_mainfi_tclMsgsimulateKeyInjectionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgsimulateKeyInjectionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulateKeyInjectionMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulateKeyInjectionMethodResult();

   virtual ~input_mainfi_tclMsgsimulateKeyInjectionMethodResult();

   inline tBool operator==(const input_mainfi_tclMsgsimulateKeyInjectionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulateEncRotationMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulateEncRotationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgsimulateEncRotationMethodStart& operator=(const input_mainfi_tclMsgsimulateEncRotationMethodStart& coRef);
   input_mainfi_tclMsgsimulateEncRotationMethodStart(const input_mainfi_tclMsgsimulateEncRotationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_e8_EncoderType e8EncoderType;
   tS8 s8EncSteps;
   virtual ~input_mainfi_tclMsgsimulateEncRotationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgsimulateEncRotationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulateEncRotationMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulateEncRotationMethodResult();

   virtual ~input_mainfi_tclMsgsimulateEncRotationMethodResult();

   inline tBool operator==(const input_mainfi_tclMsgsimulateEncRotationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulateSingleTouchMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulateSingleTouchMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgsimulateSingleTouchMethodStart& operator=(const input_mainfi_tclMsgsimulateSingleTouchMethodStart& coRef);
   input_mainfi_tclMsgsimulateSingleTouchMethodStart(const input_mainfi_tclMsgsimulateSingleTouchMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32XCoord;
   tS32 s32YCoord;
   input_fi_tcl_e8_TouchStatus e8TouchStatus;
   virtual ~input_mainfi_tclMsgsimulateSingleTouchMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgsimulateSingleTouchMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulateSingleTouchMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulateSingleTouchMethodResult();

   virtual ~input_mainfi_tclMsgsimulateSingleTouchMethodResult();

   inline tBool operator==(const input_mainfi_tclMsgsimulateSingleTouchMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulateTouchSlideMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulateTouchSlideMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgsimulateTouchSlideMethodStart& operator=(const input_mainfi_tclMsgsimulateTouchSlideMethodStart& coRef);
   input_mainfi_tclMsgsimulateTouchSlideMethodStart(const input_mainfi_tclMsgsimulateTouchSlideMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32XStart;
   tS32 s32YStart;
   tS32 s32XEnd;
   tS32 s32YEnd;
   tU16 u16Duration;
   virtual ~input_mainfi_tclMsgsimulateTouchSlideMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgsimulateTouchSlideMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulateTouchSlideMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulateTouchSlideMethodResult();

   virtual ~input_mainfi_tclMsgsimulateTouchSlideMethodResult();

   inline tBool operator==(const input_mainfi_tclMsgsimulateTouchSlideMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulateMultiTouchMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulateMultiTouchMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgsimulateMultiTouchMethodStart& operator=(const input_mainfi_tclMsgsimulateMultiTouchMethodStart& coRef);
   input_mainfi_tclMsgsimulateMultiTouchMethodStart(const input_mainfi_tclMsgsimulateMultiTouchMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32SlotId;
   tS32 s32XCoord;
   tS32 s32YCoord;
   input_fi_tcl_e8_TouchStatus e8TouchStatus;
   virtual ~input_mainfi_tclMsgsimulateMultiTouchMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgsimulateMultiTouchMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulateMultiTouchMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulateMultiTouchMethodResult();

   virtual ~input_mainfi_tclMsgsimulateMultiTouchMethodResult();

   inline tBool operator==(const input_mainfi_tclMsgsimulateMultiTouchMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgGestureRecordMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgGestureRecordMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgGestureRecordMethodStart& operator=(const input_mainfi_tclMsgGestureRecordMethodStart& coRef);
   input_mainfi_tclMsgGestureRecordMethodStart(const input_mainfi_tclMsgGestureRecordMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8StartStop;
   input_fi_tclString FilePath;
   virtual ~input_mainfi_tclMsgGestureRecordMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgGestureRecordMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgGestureRecordMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgGestureRecordMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgGestureRecordMethodResult& operator=(const input_mainfi_tclMsgGestureRecordMethodResult& coRef);
   input_mainfi_tclMsgGestureRecordMethodResult(const input_mainfi_tclMsgGestureRecordMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSuccess;
   virtual ~input_mainfi_tclMsgGestureRecordMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgGestureRecordMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgGestureReplayMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgGestureReplayMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgGestureReplayMethodStart& operator=(const input_mainfi_tclMsgGestureReplayMethodStart& coRef);
   input_mainfi_tclMsgGestureReplayMethodStart(const input_mainfi_tclMsgGestureReplayMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8StartStop;
   input_fi_tclString FilePath;
   virtual ~input_mainfi_tclMsgGestureReplayMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgGestureReplayMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgGestureReplayMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgGestureReplayMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgGestureReplayMethodResult& operator=(const input_mainfi_tclMsgGestureReplayMethodResult& coRef);
   input_mainfi_tclMsgGestureReplayMethodResult(const input_mainfi_tclMsgGestureReplayMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSuccess;
   virtual ~input_mainfi_tclMsgGestureReplayMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgGestureReplayMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulatePIVITouchMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulatePIVITouchMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgsimulatePIVITouchMethodStart& operator=(const input_mainfi_tclMsgsimulatePIVITouchMethodStart& coRef);
   input_mainfi_tclMsgsimulatePIVITouchMethodStart(const input_mainfi_tclMsgsimulatePIVITouchMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32XCoord;
   tS32 s32YCoord;
   tS32 s32ScreenNumber;
   input_fi_tcl_e8_TouchStatus e8TouchStatus;
   virtual ~input_mainfi_tclMsgsimulatePIVITouchMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgsimulatePIVITouchMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulatePIVITouchMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulatePIVITouchMethodResult();

   virtual ~input_mainfi_tclMsgsimulatePIVITouchMethodResult();

   inline tBool operator==(const input_mainfi_tclMsgsimulatePIVITouchMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgDevInputNotifyConnectionMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgDevInputNotifyConnectionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgDevInputNotifyConnectionMethodStart& operator=(const input_mainfi_tclMsgDevInputNotifyConnectionMethodStart& coRef);
   input_mainfi_tclMsgDevInputNotifyConnectionMethodStart(const input_mainfi_tclMsgDevInputNotifyConnectionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_e8_Device DeviceType;
   input_fi_tcl_e8_DeviceConnectStatus DeviceConnectStatus;
   input_fi_tclString DeviceName;
   virtual ~input_mainfi_tclMsgDevInputNotifyConnectionMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgDevInputNotifyConnectionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgDevInputNotifyConnectionMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgDevInputNotifyConnectionMethodResult();

   virtual ~input_mainfi_tclMsgDevInputNotifyConnectionMethodResult();

   inline tBool operator==(const input_mainfi_tclMsgDevInputNotifyConnectionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart& operator=(const input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart& coRef);
   input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart(const input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32XStart;
   tS32 s32YStart;
   tS32 s32XEnd;
   tS32 s32YEnd;
   tU16 u16Duration;
   virtual ~input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgsimulatePIVITouchSlideMethodResult : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgsimulatePIVITouchSlideMethodResult();

   virtual ~input_mainfi_tclMsgsimulatePIVITouchSlideMethodResult();

   inline tBool operator==(const input_mainfi_tclMsgsimulatePIVITouchSlideMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgPressedKeysGet : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgPressedKeysGet();

   virtual ~input_mainfi_tclMsgPressedKeysGet();

   inline tBool operator==(const input_mainfi_tclMsgPressedKeysGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgPressedKeysStatus : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgPressedKeysStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgPressedKeysStatus& operator=(const input_mainfi_tclMsgPressedKeysStatus& coRef);
   input_mainfi_tclMsgPressedKeysStatus(const input_mainfi_tclMsgPressedKeysStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_DiagKeyList KeyInfoList;
   virtual ~input_mainfi_tclMsgPressedKeysStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgPressedKeysStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgEncoderDirStatusGet : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgEncoderDirStatusGet();

   virtual ~input_mainfi_tclMsgEncoderDirStatusGet();

   inline tBool operator==(const input_mainfi_tclMsgEncoderDirStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgEncoderDirStatusStatus : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgEncoderDirStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgEncoderDirStatusStatus& operator=(const input_mainfi_tclMsgEncoderDirStatusStatus& coRef);
   input_mainfi_tclMsgEncoderDirStatusStatus(const input_mainfi_tclMsgEncoderDirStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_EncoderDirectionList tEncoderDirectionList;
   virtual ~input_mainfi_tclMsgEncoderDirStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgEncoderDirStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgEncoderStatusGet : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgEncoderStatusGet();

   virtual ~input_mainfi_tclMsgEncoderStatusGet();

   inline tBool operator==(const input_mainfi_tclMsgEncoderStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgEncoderStatusStatus : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgEncoderStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgEncoderStatusStatus& operator=(const input_mainfi_tclMsgEncoderStatusStatus& coRef);
   input_mainfi_tclMsgEncoderStatusStatus(const input_mainfi_tclMsgEncoderStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_EncoderStatus tEncoderStatus;
   virtual ~input_mainfi_tclMsgEncoderStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgEncoderStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgTouchStatusGet : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgTouchStatusGet();

   virtual ~input_mainfi_tclMsgTouchStatusGet();

   inline tBool operator==(const input_mainfi_tclMsgTouchStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgTouchStatusStatus : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgTouchStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgTouchStatusStatus& operator=(const input_mainfi_tclMsgTouchStatusStatus& coRef);
   input_mainfi_tclMsgTouchStatusStatus(const input_mainfi_tclMsgTouchStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_TouchDataList tTouchDataList;
   virtual ~input_mainfi_tclMsgTouchStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgTouchStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgTouchStatusPIVISecondaryGet : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgTouchStatusPIVISecondaryGet();

   virtual ~input_mainfi_tclMsgTouchStatusPIVISecondaryGet();

   inline tBool operator==(const input_mainfi_tclMsgTouchStatusPIVISecondaryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class input_mainfi_tclMsgTouchStatusPIVISecondaryStatus : public input_mainfi_tclMsgBaseMessage
{
public:

   input_mainfi_tclMsgTouchStatusPIVISecondaryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_mainfi_tclMsgTouchStatusPIVISecondaryStatus& operator=(const input_mainfi_tclMsgTouchStatusPIVISecondaryStatus& coRef);
   input_mainfi_tclMsgTouchStatusPIVISecondaryStatus(const input_mainfi_tclMsgTouchStatusPIVISecondaryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_TouchDataList tSecondaryTouchDataList;
   virtual ~input_mainfi_tclMsgTouchStatusPIVISecondaryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_mainfi_tclMsgTouchStatusPIVISecondaryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
