/************************************************************************
*FILE: BaseWidgetMessages.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "BaseWidgetMessages.h"

namespace hmibase {
namespace widget {
// ========================================================================

const ::Courier::ComponentId SenderMessage::mSenderMessageSubscriberList[SenderMessage::SubscriberListSize] = {
    ::Courier::ComponentId(::Courier::ComponentType::View),
    ::Courier::ComponentId(::Courier::ComponentType::Controller)
};

// ------------------------------------------------------------------------
SenderMessage::SenderMessage() :
    Base(),
    mView(::Courier::ViewId()),
    mSender(::Courier::Identifier()),
    mUserData(::FeatStd::UInt32())
{
}

// ------------------------------------------------------------------------
SenderMessage::SenderMessage(::Courier::ViewId const & aView, ::Courier::Identifier const & aSender, ::FeatStd::UInt32 const & aUserData) :
    mView(aView), mSender(aSender), mUserData(aUserData)
{
}

// ------------------------------------------------------------------------
SenderMessage::~SenderMessage()
{
}

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata SenderMessage::mSenderMessageMetaData = {
    {false, false, false, ::FeatStd::UInt8(::Courier::Priority::Normal), ::FeatStd::UInt8(::Courier::MessageTag::None), SenderMessage::SubscriberListSize},
    COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6F5AAA11, SenderMessage),
    0xFFFFFFFF,
    SenderMessage::mSenderMessageSubscriberList
};

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata SenderMessage::mSenderMessageModifiableMetadata;

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata& SenderMessage::GetMetadata() const
{
    return mSenderMessageMetaData;
}

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata & SenderMessage::GetModifiableMetadata() 
{
    return mSenderMessageModifiableMetadata;
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
::FeatStd::UInt32 SenderMessage::AppendTo(::FeatStd::StringBuffer& stringBuffer) const
{
    ::FeatStd::UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("::hmibase::widget::SenderMessage { ");
    tcharCount += stringBuffer.Append("View = ");
    tcharCount += stringBuffer.AppendObject(GetView());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Sender = ");
    tcharCount += stringBuffer.AppendObject(GetSender());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("UserData = ");
    tcharCount += stringBuffer.AppendObject(GetUserData());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += ::Courier::Message::AppendTo(stringBuffer);
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}
#endif
// ========================================================================

::Courier::ComponentId TouchUpdMsg::mTouchUpdMsgSubscriberList[TouchUpdMsg::SubscriberListSize] = {
    ::Courier::ComponentId(::Courier::ComponentType::Controller),
    ::Courier::ComponentId(::Courier::ComponentType::Model),
    ::Courier::ComponentId(::Courier::ComponentType::Invalid)
};

// ------------------------------------------------------------------------
bool TouchUpdMsg::Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before)
{
    return ::Courier::Message::Subscribe(TouchUpdMsg::mTouchUpdMsgSubscriberList, TouchUpdMsg::SubscriberListSize, component, before);
}

// ------------------------------------------------------------------------
bool TouchUpdMsg::Unsubscribe(::Courier::ComponentId component)
{
    return ::Courier::Message::Unsubscribe(TouchUpdMsg::mTouchUpdMsgSubscriberList, TouchUpdMsg::SubscriberListSize, component);
}

// ------------------------------------------------------------------------
TouchUpdMsg::TouchUpdMsg() :
    Base(),
    mState(enTouchState::Enum())
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
TouchUpdMsg::TouchUpdMsg(::Courier::ViewId const & aView, ::Courier::Identifier const & aSender, ::FeatStd::UInt32 const & aUserData, enTouchState::Enum const & aState) :
    SenderMessage(aView, aSender, aUserData), mState(aState)
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
TouchUpdMsg::~TouchUpdMsg()
{
    ResetLocalSubscriberList();
}

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata TouchUpdMsg::mTouchUpdMsgMetaData = {
    {true, true, false, ::FeatStd::UInt8(::Courier::Priority::Normal), ::FeatStd::UInt8(::Courier::MessageTag::None), TouchUpdMsg::SubscriberListSize},
    COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5A533580, TouchUpdMsg),
    0xFFFFFFFF,
    TouchUpdMsg::mTouchUpdMsgSubscriberList
};

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata TouchUpdMsg::mTouchUpdMsgModifiableMetadata;

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata& TouchUpdMsg::GetMetadata() const
{
    return mTouchUpdMsgMetaData;
}

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata & TouchUpdMsg::GetModifiableMetadata() 
{
    return mTouchUpdMsgModifiableMetadata;
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
::FeatStd::UInt32 TouchUpdMsg::AppendTo(::FeatStd::StringBuffer& stringBuffer) const
{
    ::FeatStd::UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("::hmibase::widget::TouchUpdMsg { ");
    tcharCount += stringBuffer.Append("State = ");
    tcharCount += stringBuffer.AppendObject(GetState());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += ::hmibase::widget::SenderMessage::AppendTo(stringBuffer);
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}
#endif
} // namespace widget
} // namespace hmibase
