/************************************************************************
*FILE: MultiSliderHelperWidget3DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(MultiSliderHelperWidget3DBase_h)
#define MultiSliderHelperWidget3DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#include <Widgets/3D/BaseWidget3D.h>
// ------------------------------------------------------------------------
//! [MultiSliderHelperWidget3DBase_Declaration]
class MultiSliderHelperWidget3DBase : public BaseWidget3D
{
    public:
        typedef bool ScaleType;

        typedef FeatStd::Float RadiusOffsetType;

        typedef FeatStd::Float ValueMinType;

        typedef Candera::Color ColorTopLeftType;

        typedef Candera::Color ColorTopRightType;

        typedef Candera::Color ColorBottomType;

        typedef FeatStd::Float NonLinearFactorType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ScalePropertyId = 0x3CBA3FE6;
        static const FeatStd::UInt32 RadiusOffsetPropertyId = 0x7186FBB5;
        static const FeatStd::UInt32 ColorTopLeftPropertyId = 0x83C7F28F;
        static const FeatStd::UInt32 ColorTopRightPropertyId = 0xA4C83FC4;
        static const FeatStd::UInt32 ColorBottomPropertyId = 0x4E08825C;
        static const FeatStd::UInt32 NonLinearFactorPropertyId = 0x6334CFD4;
        //! [Property_IDs]

        MultiSliderHelperWidget3DBase();
        virtual ~MultiSliderHelperWidget3DBase();

        CGI_WIDGET_RTTI_DECLARATION(MultiSliderHelperWidget3DBase, BaseWidget3D);

        void SetScale(const ScaleType& scale);
        const ScaleType& GetScale() const { return m_Scale; }
        ScaleType& GetScale() { return m_Scale; }

        void SetRadiusOffset(const RadiusOffsetType& radiusoffset);
        const RadiusOffsetType& GetRadiusOffset() const { return m_RadiusOffset; }
        RadiusOffsetType& GetRadiusOffset() { return m_RadiusOffset; }

        void SetValueMin(const ValueMinType& valuemin);
        const ValueMinType& GetValueMin() const { return m_ValueMin; }
        ValueMinType& GetValueMin() { return m_ValueMin; }

        void SetColorTopLeft(const ColorTopLeftType& colortopleft);
        const ColorTopLeftType& GetColorTopLeft() const { return m_ColorTopLeft; }
        ColorTopLeftType& GetColorTopLeft() { return m_ColorTopLeft; }

        void SetColorTopRight(const ColorTopRightType& colortopright);
        const ColorTopRightType& GetColorTopRight() const { return m_ColorTopRight; }
        ColorTopRightType& GetColorTopRight() { return m_ColorTopRight; }

        void SetColorBottom(const ColorBottomType& colorbottom);
        const ColorBottomType& GetColorBottom() const { return m_ColorBottom; }
        ColorBottomType& GetColorBottom() { return m_ColorBottom; }

        void SetNonLinearFactor(const NonLinearFactorType& nonlinearfactor);
        const NonLinearFactorType& GetNonLinearFactor() const { return m_NonLinearFactor; }
        NonLinearFactorType& GetNonLinearFactor() { return m_NonLinearFactor; }

        // @WidgetBaseClass
        CdaWidgetDef(MultiSliderHelperWidget3DBase, BaseWidget3D)
            CdaDescription("Graphical 3D representation for Multi Slider controlled by MultiSliderController2D")
            CdaReadableName("MultiSliderHelperWidget3DBase")

            CdaProperties()
                CdaProperty(Scale, ScaleType, GetScale, SetScale)
                    CdaDescription("The texture will be cut off on top edge (false) or is scaled down (true).")
                CdaPropertyEnd()
                CdaProperty(RadiusOffset, RadiusOffsetType, GetRadiusOffset, SetRadiusOffset)
                    CdaDescription("Value > 0 creates a gap on the edges of the polygon.")
                CdaPropertyEnd()
                CdaProperty(ValueMin, ValueMinType, GetValueMin, SetValueMin)
                    CdaDescription("To show some content even if the controller value is 0, a minimum value for the view can be defined.")
                CdaPropertyEnd()
                CdaProperty(ColorTopLeft, ColorTopLeftType, GetColorTopLeft, SetColorTopLeft)
                    CdaDescription("Defines the color if center of polygon area moves to top left.")
                CdaPropertyEnd()
                CdaProperty(ColorTopRight, ColorTopRightType, GetColorTopRight, SetColorTopRight)
                    CdaDescription("Defines the color if center of polygon area moves to top right.")
                CdaPropertyEnd()
                CdaProperty(ColorBottom, ColorBottomType, GetColorBottom, SetColorBottom)
                    CdaDescription("Defines the color if center of polygon area moves to bottom.")
                CdaPropertyEnd()
                CdaProperty(NonLinearFactor, NonLinearFactorType, GetNonLinearFactor, SetNonLinearFactor)
                    CdaDescription("Factor for non-linear ratio between value and depth (0.001..10). 0.001 means linear, higher values define more exponential ratio.")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ScaleType m_Scale;
        RadiusOffsetType m_RadiusOffset;
        ValueMinType m_ValueMin;
        ColorTopLeftType m_ColorTopLeft;
        ColorTopRightType m_ColorTopRight;
        ColorBottomType m_ColorBottom;
        NonLinearFactorType m_NonLinearFactor;
};

#endif // MultiSliderHelperWidget3DBase_h
