/************************************************************************
*FILE: MultiSliderHelperWidget3DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "MultiSliderHelperWidget3DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(MultiSliderHelperWidget3DBase)

MultiSliderHelperWidget3DBase::MultiSliderHelperWidget3DBase() :
    m_Scale(false),
    m_RadiusOffset(0.0f),
    m_ValueMin(0.0f),
    m_ColorTopLeft(ColorTopLeftType()),
    m_ColorTopRight(ColorTopRightType()),
    m_ColorBottom(ColorBottomType()),
    m_NonLinearFactor(0.001f)
{
}

MultiSliderHelperWidget3DBase::~MultiSliderHelperWidget3DBase()
{
}

void MultiSliderHelperWidget3DBase::SetScale(const ScaleType& scale)
{
    m_Scale = scale;
    OnChanged(static_cast< ::FeatStd::UInt32>(ScalePropertyId));
}

void MultiSliderHelperWidget3DBase::SetRadiusOffset(const RadiusOffsetType& radiusoffset)
{
    m_RadiusOffset = radiusoffset;
    OnChanged(static_cast< ::FeatStd::UInt32>(RadiusOffsetPropertyId));
}

void MultiSliderHelperWidget3DBase::SetValueMin(const ValueMinType& valuemin)
{
    m_ValueMin = valuemin;
}

void MultiSliderHelperWidget3DBase::SetColorTopLeft(const ColorTopLeftType& colortopleft)
{
    m_ColorTopLeft = colortopleft;
    OnChanged(static_cast< ::FeatStd::UInt32>(ColorTopLeftPropertyId));
}

void MultiSliderHelperWidget3DBase::SetColorTopRight(const ColorTopRightType& colortopright)
{
    m_ColorTopRight = colortopright;
    OnChanged(static_cast< ::FeatStd::UInt32>(ColorTopRightPropertyId));
}

void MultiSliderHelperWidget3DBase::SetColorBottom(const ColorBottomType& colorbottom)
{
    m_ColorBottom = colorbottom;
    OnChanged(static_cast< ::FeatStd::UInt32>(ColorBottomPropertyId));
}

void MultiSliderHelperWidget3DBase::SetNonLinearFactor(const NonLinearFactorType& nonlinearfactor)
{
    m_NonLinearFactor = nonlinearfactor;
    OnChanged(static_cast< ::FeatStd::UInt32>(NonLinearFactorPropertyId));
}
